/*
 * Copyright (C) 2016 Freescale Semiconductor, Inc.
 *
 * SPDX-License-Identifier: GPL-2.0+
 */

#ifndef _MX7ULP_REGS_H_
#define _MX7ULP_REGS_H_

#include <linux/sizes.h>

#define CAAM_SEC_SRAM_BASE      (0x26000000)
#define CAAM_SEC_SRAM_SIZE      (SZ_32K)
#define CAAM_SEC_SRAM_END       (CAAM_SEC_SRAM_BASE + CAAM_SEC_SRAM_SIZE - 1)

#define OCRAM_0_BASE            (0x2F000000)
#define OCRAM_0_SIZE            (SZ_128K)
#define OCRAM_0_END             (OCRAM_0_BASE + OCRAM_0_SIZE - 1)

#define OCRAM_1_BASE            (0x2F020000)
#define OCRAM_1_SIZE            (SZ_128K)
#define OCRAM_1_END             (OCRAM_1_BASE + OCRAM_1_SIZE - 1)

#define TCML_BASE               (0x1FFD0000)
#define TCMU_BASE               (0x20000000)

#define AIPS3_BASE			(0x40800000UL)
#define AIPS3_SLOT_SIZE			(SZ_64K)
#define AIPS2_BASE			(0x40000000UL)
#define AIPS2_SLOT_SIZE			(SZ_64K)
#define AIPS1_BASE			(0x41080000UL)
#define AIPS1_SLOT_SIZE			(SZ_4K)
#define AIPS0_BASE			(0x41000000UL)
#define AIPS0_SLOT_SIZE			(SZ_4K)
#define IOMUXC0_AIPS0_SLOT		(61)
#define WDG0_AIPS0_SLOT			(37)
#define WDG1_AIPS2_SLOT			(61)
#define WDG2_AIPS2_SLOT			(67)
#define WDG0_PCC0_SLOT			(37)
#define IOMUXC1_AIPS3_SLOT		(44)
#define CMC0_AIPS1_SLOT			(36)
#define CMC1_AIPS2_SLOT			(65)
#define SCG0_AIPS0_SLOT			(39)
#define PCC0_AIPS0_SLOT			(38)
#define PCC1_AIPS1_SLOT			(50)
#define PCC2_AIPS2_SLOT			(63)
#define PCC3_AIPS3_SLOT			(51)
#define SCG1_AIPS2_SLOT			(62)
#define SIM0_AIPS1_SLOT			(35)
#define SIM1_AIPS1_SLOT			(48)
#define USBOTG0_AIPS2_SLOT		(51)
#define USBOTG1_AIPS2_SLOT		(52)
#define USBPHY_AIPS2_SLOT		(53)
#define USDHC0_AIPS2_SLOT		(55)
#define USDHC1_AIPS2_SLOT		(56)
#define RGPIO2P0_AIPS0_SLOT		(15)
#define RGPIO2P1_AIPS2_SLOT		(15)
#define IOMUXC0_AIPS0_SLOT		(61)
#define OCOTP_CTRL_AIPS1_SLOT		(38)
#define OCOTP_CTRL_PCC1_SLOT		(38)
#define SIM1_PCC1_SLOT			(48)
#define MMDC0_AIPS3_SLOT		(43)
#define IOMUXC_DDR_AIPS3_SLOT		(45)

#define LPI2C0_AIPS0_SLOT		(51)
#define LPI2C1_AIPS0_SLOT		(52)
#define LPI2C2_AIPS0_SLOT		(53)
#define LPI2C3_AIPS0_SLOT		(54)
#define LPI2C4_AIPS2_SLOT		(43)
#define LPI2C5_AIPS2_SLOT		(44)
#define LPI2C6_AIPS3_SLOT		(36)
#define LPI2C7_AIPS3_SLOT		(37)

#define LPUART0_PCC0_SLOT		(58)
#define LPUART1_PCC0_SLOT		(59)
#define LPUART2_PCC1_SLOT		(43)
#define LPUART3_PCC1_SLOT		(44)
#define LPUART0_AIPS0_SLOT		(58)
#define LPUART1_AIPS0_SLOT		(59)
#define LPUART2_AIPS1_SLOT		(43)
#define LPUART3_AIPS1_SLOT		(44)
#define LPUART4_AIPS2_SLOT		(45)
#define LPUART5_AIPS2_SLOT		(46)
#define LPUART6_AIPS3_SLOT		(38)
#define LPUART7_AIPS3_SLOT		(39)

#define CORE_B_ROM_SIZE			(SZ_32K + SZ_64K)
#define CORE_B_ROM_BASE			(0x00000000)

#define ROMCP_ARB_BASE_ADDR		CORE_B_ROM_BASE
#define ROMCP_ARB_END_ADDR		CORE_B_ROM_SIZE
#define IRAM_BASE_ADDR			OCRAM_0_BASE
#define IRAM_SIZE			(SZ_128K + SZ_128K)

#define IOMUXC_PCR_MUX_ALT0		(0<<8)
#define IOMUXC_PCR_MUX_ALT1		(1<<8)
#define IOMUXC_PCR_MUX_ALT2		(2<<8)
#define IOMUXC_PCR_MUX_ALT3		(3<<8)
#define IOMUXC_PCR_MUX_ALT4		(4<<8)
#define IOMUXC_PCR_MUX_ALT5		(5<<8)
#define IOMUXC_PCR_MUX_ALT6		(6<<8)
#define IOMUXC_PCR_MUX_ALT7		(7<<8)
#define IOMUXC_PCR_MUX_ALT8		(8<<8)
#define IOMUXC_PCR_MUX_ALT9		(9<<8)
#define IOMUXC_PCR_MUX_ALT10		(10<<8)
#define IOMUXC_PCR_MUX_ALT11		(11<<8)
#define IOMUXC_PCR_MUX_ALT12		(12<<8)
#define IOMUXC_PCR_MUX_ALT13		(13<<8)
#define IOMUXC_PCR_MUX_ALT14		(14<<8)
#define IOMUXC_PCR_MUX_ALT15		(15<<8)

#define IOMUXC_PSMI_IMUX_ALT0		(0x0)
#define IOMUXC_PSMI_IMUX_ALT1		(0x1)
#define IOMUXC_PSMI_IMUX_ALT2		(0x2)
#define IOMUXC_PSMI_IMUX_ALT3		(0x3)
#define IOMUXC_PSMI_IMUX_ALT4		(0x4)
#define IOMUXC_PSMI_IMUX_ALT5		(0x5)
#define IOMUXC_PSMI_IMUX_ALT6		(0x6)
#define IOMUXC_PSMI_IMUX_ALT7		(0x7)


#define SIM_SOPT1_EN_SNVS_HARD_RST	(1<<8)
#define SIM_SOPT1_PMIC_STBY_REQ		(1<<2)
#define SIM_SOPT1_A7_SW_RESET		(1<<0)

#define IOMUXC_PCR_MUX_ALT_SHIFT	(8)
#define IOMUXC_PCR_MUX_ALT_MASK		(0xF00)
#define IOMUXC_PSMI_IMUX_ALT_SHIFT	(0)

#define IOMUXC0_RBASE	((AIPS0_BASE + (AIPS0_SLOT_SIZE * IOMUXC0_AIPS0_SLOT)))
#define IOMUXC1_RBASE	((AIPS3_BASE + (AIPS3_SLOT_SIZE * IOMUXC1_AIPS3_SLOT)))
#define WDG0_RBASE	((AIPS0_BASE + (AIPS0_SLOT_SIZE * WDG0_AIPS0_SLOT)))
#define WDG1_RBASE	((AIPS2_BASE + (AIPS2_SLOT_SIZE * WDG1_AIPS2_SLOT)))
#define WDG2_RBASE	((AIPS2_BASE + (AIPS2_SLOT_SIZE * WDG2_AIPS2_SLOT)))
#define SCG0_RBASE	((AIPS0_BASE + (AIPS0_SLOT_SIZE * SCG0_AIPS0_SLOT)))
#define SCG1_RBASE	((AIPS2_BASE + (AIPS2_SLOT_SIZE * SCG1_AIPS2_SLOT)))
#define PCC0_RBASE	((AIPS0_BASE + (AIPS0_SLOT_SIZE * PCC0_AIPS0_SLOT)))
#define PCC1_RBASE	((AIPS1_BASE + (AIPS1_SLOT_SIZE * PCC1_AIPS1_SLOT)))
#define PCC2_RBASE	((AIPS2_BASE + (AIPS2_SLOT_SIZE * PCC2_AIPS2_SLOT)))
#define PCC3_RBASE	((AIPS3_BASE + (AIPS3_SLOT_SIZE * PCC3_AIPS3_SLOT)))
#define IOMUXC0_RBASE	((AIPS0_BASE + (AIPS0_SLOT_SIZE * IOMUXC0_AIPS0_SLOT)))
#define PSMI0_RBASE	((IOMUXC0_RBASE + 0x100)) /* in iomuxc0 after pta and ptb */
#define CMC0_RBASE	((AIPS1_BASE + (AIPS1_SLOT_SIZE * CMC0_AIPS1_SLOT)))
#define CMC1_RBASE	((AIPS2_BASE + (AIPS2_SLOT_SIZE * CMC1_AIPS2_SLOT)))
#define OCOTP_BASE_ADDR	((AIPS1_BASE + (AIPS1_SLOT_SIZE * OCOTP_CTRL_AIPS1_SLOT)))
#define SIM0_RBASE	((AIPS1_BASE + (AIPS1_SLOT_SIZE * SIM0_AIPS1_SLOT)))
#define SIM1_RBASE	((AIPS1_BASE + (AIPS1_SLOT_SIZE * SIM1_AIPS1_SLOT)))
#define MMDC0_RBASE	((AIPS3_BASE + (AIPS3_SLOT_SIZE * MMDC0_AIPS3_SLOT)))

#define USBOTG0_RBASE	((AIPS2_BASE + (AIPS2_SLOT_SIZE * USBOTG0_AIPS2_SLOT)))
#define USBOTG1_RBASE	((AIPS2_BASE + (AIPS2_SLOT_SIZE * USBOTG1_AIPS2_SLOT)))
#define USBPHY_RBASE	((AIPS2_BASE + (AIPS2_SLOT_SIZE * USBPHY_AIPS2_SLOT)))
#define USB_PHY0_BASE_ADDR	USBPHY_RBASE
#define USB_BASE_ADDR		USBOTG0_RBASE

#define LPI2C1_BASE_ADDR	((AIPS0_BASE + (AIPS0_SLOT_SIZE * LPI2C0_AIPS0_SLOT)))
#define LPI2C2_BASE_ADDR	((AIPS0_BASE + (AIPS0_SLOT_SIZE * LPI2C1_AIPS0_SLOT)))
#define LPI2C3_BASE_ADDR	((AIPS0_BASE + (AIPS0_SLOT_SIZE * LPI2C2_AIPS0_SLOT)))
#define LPI2C4_BASE_ADDR	((AIPS0_BASE + (AIPS0_SLOT_SIZE * LPI2C3_AIPS0_SLOT)))
#define LPI2C5_BASE_ADDR	((AIPS2_BASE + (AIPS2_SLOT_SIZE * LPI2C4_AIPS2_SLOT)))
#define LPI2C6_BASE_ADDR	((AIPS2_BASE + (AIPS2_SLOT_SIZE * LPI2C5_AIPS2_SLOT)))
#define LPI2C7_BASE_ADDR	((AIPS3_BASE + (AIPS3_SLOT_SIZE * LPI2C6_AIPS3_SLOT)))
#define LPI2C8_BASE_ADDR	((AIPS3_BASE + (AIPS3_SLOT_SIZE * LPI2C7_AIPS3_SLOT)))

#define LPUART0_RBASE	((AIPS0_BASE + (AIPS0_SLOT_SIZE * LPUART0_AIPS0_SLOT)))
#define LPUART1_RBASE	((AIPS0_BASE + (AIPS0_SLOT_SIZE * LPUART1_AIPS0_SLOT)))
#define LPUART2_RBASE	((AIPS1_BASE + (AIPS1_SLOT_SIZE * LPUART2_AIPS1_SLOT)))
#define LPUART3_RBASE	((AIPS1_BASE + (AIPS1_SLOT_SIZE * LPUART3_AIPS1_SLOT)))
#define LPUART4_RBASE	((AIPS2_BASE + (AIPS2_SLOT_SIZE * LPUART4_AIPS2_SLOT)))
#define LPUART5_RBASE	((AIPS2_BASE + (AIPS2_SLOT_SIZE * LPUART5_AIPS2_SLOT)))
#define LPUART6_RBASE	((AIPS3_BASE + (AIPS3_SLOT_SIZE * LPUART6_AIPS3_SLOT)))
#define LPUART7_RBASE	((AIPS3_BASE + (AIPS3_SLOT_SIZE * LPUART7_AIPS3_SLOT)))

#define USDHC0_RBASE	((AIPS2_BASE + (AIPS2_SLOT_SIZE * USDHC0_AIPS2_SLOT)))
#define USDHC1_RBASE	((AIPS2_BASE + (AIPS2_SLOT_SIZE * USDHC1_AIPS2_SLOT)))

#define RGPIO2P0_RBASE	((AIPS0_BASE + (AIPS0_SLOT_SIZE * RGPIO2P0_AIPS0_SLOT)))
#define RGPIO2P1_RBASE	((AIPS2_BASE + (AIPS2_SLOT_SIZE * RGPIO2P1_AIPS2_SLOT)))

#define WDG0_PCC_REG	(PCC0_RBASE + (4 * WDG0_PCC0_SLOT))
#define WDG1_PCC_REG	(PCC2_RBASE + (4 * WDG1_PCC2_SLOT))
#define CMC0_SRS	(CMC0_RBASE  + 0x20)
#define CMC0_SSRS	(CMC0_RBASE  + 0x28)
#define CMC1_SRS	(CMC1_RBASE  + 0x20)
#define CMC1_SSRS	(CMC1_RBASE  + 0x28)

#define IOMUXC0_PCR0	(IOMUXC0_RBASE + (4 * 0))
#define IOMUXC0_PCR1	(IOMUXC0_RBASE + (4 * 1))
#define IOMUXC0_PCR2	(IOMUXC0_RBASE + (4 * 2))
#define IOMUXC0_PCR3	(IOMUXC0_RBASE + (4 * 3))
#define IOMUXC0_PSMI62	(PSMI0_RBASE + (4 * 62))
#define IOMUXC0_PSMI63	(PSMI0_RBASE + (4 * 63))
#define IOMUXC0_PSMI64	(PSMI0_RBASE + (4 * 64))

#define SCG_CSR		(SCG0_RBASE + 0x010)
#define SCG_RCCR	(SCG0_RBASE + 0x014)
#define SCG_VCCR	(SCG0_RBASE + 0x018)
#define SCG_HCCR	(SCG0_RBASE + 0x01c)

#define LPUART0_PCC_REG	(PCC0_RBASE + (4 * LPUART0_PCC0_SLOT))
#define LPUART1_PCC_REG	(PCC0_RBASE + (4 * LPUART1_PCC0_SLOT))
#define LPUART2_PCC_REG	(PCC1_RBASE + (4 * LPUART2_PCC1_SLOT))
#define LPUART3_PCC_REG	(PCC1_RBASE + (4 * LPUART3_PCC1_SLOT))
#define LPUART4_PCC_REG	(PCC2_RBASE + (4 * LPUART4_PCC2_SLOT))
#define LPUART5_PCC_REG	(PCC2_RBASE + (4 * LPUART5_PCC2_SLOT))
#define LPUART6_PCC_REG	(PCC3_RBASE + (4 * LPUART6_PCC3_SLOT))
#define LPUART7_PCC_REG	(PCC3_RBASE + (4 * LPUART7_PCC3_SLOT))

#define USDHC0_PCC_REG	(PCC2_RBASE + (4 * USDHC0_PCC2_SLOT))
#define USDHC1_PCC_REG	(PCC2_RBASE + (4 * USDHC1_PCC2_SLOT))

#define SIM1_PCC_REG	(PCC1_RBASE + (4 * SIM1_PCC1_SLOT))
#define SCG1_PCC_REG	(PCC2_RBASE + (4 * SCG1_PCC2_SLOT))

#define OCOTP_CTRL_PCC_REG	(PCC1_RBASE + (4 * OCOTP_CTRL_PCC1_SLOT))

#define IOMUXC_DDR_RBASE	((AIPS3_BASE + (AIPS3_SLOT_SIZE * IOMUXC_DDR_AIPS3_SLOT)))
#define MMDC0_PCC_REG		(PCC3_RBASE + (4 * MMDC0_PCC3_SLOT))

#define IOMUXC_DPCR_DDR_DQS0	((IOMUXC_DDR_RBASE + (4 * 32)))
#define IOMUXC_DPCR_DDR_DQS1	((IOMUXC_DDR_RBASE + (4 * 33)))
#define IOMUXC_DPCR_DDR_DQS2	((IOMUXC_DDR_RBASE + (4 * 34)))
#define IOMUXC_DPCR_DDR_DQS3	((IOMUXC_DDR_RBASE + (4 * 35)))


#define IOMUXC_DPCR_DDR_DQ0	((IOMUXC_DDR_RBASE + (4 * 0)))
#define IOMUXC_DPCR_DDR_DQ1	((IOMUXC_DDR_RBASE + (4 * 1)))
#define IOMUXC_DPCR_DDR_DQ2	((IOMUXC_DDR_RBASE + (4 * 2)))
#define IOMUXC_DPCR_DDR_DQ3	((IOMUXC_DDR_RBASE + (4 * 3)))
#define IOMUXC_DPCR_DDR_DQ4	((IOMUXC_DDR_RBASE + (4 * 4)))
#define IOMUXC_DPCR_DDR_DQ5	((IOMUXC_DDR_RBASE + (4 * 5)))
#define IOMUXC_DPCR_DDR_DQ6	((IOMUXC_DDR_RBASE + (4 * 6)))
#define IOMUXC_DPCR_DDR_DQ7	((IOMUXC_DDR_RBASE + (4 * 7)))
#define IOMUXC_DPCR_DDR_DQ8	((IOMUXC_DDR_RBASE + (4 * 8)))
#define IOMUXC_DPCR_DDR_DQ9	((IOMUXC_DDR_RBASE + (4 * 9)))
#define IOMUXC_DPCR_DDR_DQ10	((IOMUXC_DDR_RBASE + (4 * 10)))
#define IOMUXC_DPCR_DDR_DQ11	((IOMUXC_DDR_RBASE + (4 * 11)))
#define IOMUXC_DPCR_DDR_DQ12	((IOMUXC_DDR_RBASE + (4 * 12)))
#define IOMUXC_DPCR_DDR_DQ13	((IOMUXC_DDR_RBASE + (4 * 13)))
#define IOMUXC_DPCR_DDR_DQ14	((IOMUXC_DDR_RBASE + (4 * 14)))
#define IOMUXC_DPCR_DDR_DQ15	((IOMUXC_DDR_RBASE + (4 * 15)))
#define IOMUXC_DPCR_DDR_DQ16	((IOMUXC_DDR_RBASE + (4 * 16)))
#define IOMUXC_DPCR_DDR_DQ17	((IOMUXC_DDR_RBASE + (4 * 17)))
#define IOMUXC_DPCR_DDR_DQ18	((IOMUXC_DDR_RBASE + (4 * 18)))
#define IOMUXC_DPCR_DDR_DQ19	((IOMUXC_DDR_RBASE + (4 * 19)))
#define IOMUXC_DPCR_DDR_DQ20	((IOMUXC_DDR_RBASE + (4 * 20)))
#define IOMUXC_DPCR_DDR_DQ21	((IOMUXC_DDR_RBASE + (4 * 21)))
#define IOMUXC_DPCR_DDR_DQ22	((IOMUXC_DDR_RBASE + (4 * 22)))
#define IOMUXC_DPCR_DDR_DQ23	((IOMUXC_DDR_RBASE + (4 * 23)))
#define IOMUXC_DPCR_DDR_DQ24	((IOMUXC_DDR_RBASE + (4 * 24)))
#define IOMUXC_DPCR_DDR_DQ25	((IOMUXC_DDR_RBASE + (4 * 25)))
#define IOMUXC_DPCR_DDR_DQ26	((IOMUXC_DDR_RBASE + (4 * 26)))
#define IOMUXC_DPCR_DDR_DQ27	((IOMUXC_DDR_RBASE + (4 * 27)))
#define IOMUXC_DPCR_DDR_DQ28	((IOMUXC_DDR_RBASE + (4 * 28)))
#define IOMUXC_DPCR_DDR_DQ29	((IOMUXC_DDR_RBASE + (4 * 29)))
#define IOMUXC_DPCR_DDR_DQ30	((IOMUXC_DDR_RBASE + (4 * 30)))
#define IOMUXC_DPCR_DDR_DQ31	((IOMUXC_DDR_RBASE + (4 * 31)))

/* Remap the rgpio2p registers addr to driver's addr */
#define RGPIO2P_GPIO1_BASE_ADDR	RGPIO2P0_RBASE
#define RGPIO2P_GPIO2_BASE_ADDR	(RGPIO2P0_RBASE + 0x40)
#define RGPIO2P_GPIO3_BASE_ADDR	(RGPIO2P1_RBASE)
#define RGPIO2P_GPIO4_BASE_ADDR	(RGPIO2P1_RBASE + 0x40)
#define RGPIO2P_GPIO5_BASE_ADDR	(RGPIO2P1_RBASE + 0x80)
#define RGPIO2P_GPIO6_BASE_ADDR	(RGPIO2P1_RBASE + 0xc0)

/* MMDC registers addresses */
#define MMDC_MDCTL_OFFSET	(0x000)
#define MMDC_MDPDC_OFFSET	(0x004)
#define MMDC_MDOTC_OFFSET	(0x008)
#define MMDC_MDCFG0_OFFSET	(0x00C)
#define MMDC_MDCFG1_OFFSET	(0x010)
#define MMDC_MDCFG2_OFFSET	(0x014)
#define MMDC_MDMISC_OFFSET	(0x018)
#define MMDC_MDSCR_OFFSET	(0x01C)
#define MMDC_MDREF_OFFSET	(0x020)
#define MMDC_MDRWD_OFFSET	(0x02C)
#define MMDC_MDOR_OFFSET	(0x030)
#define MMDC_MDMRR_OFFSET	(0x034)
#define MMDC_MDCFG3LP_OFFSET	(0x038)
#define MMDC_MDMR4_OFFSET	(0x03C)
#define MMDC_MDASP_OFFSET	(0x040)

#define MMDC_MAARCR_OFFSET	(0x400)
#define MMDC_MAPSR_OFFSET	(0x404)
#define MMDC_MAEXIDR0_OFFSET	(0x408)
#define MMDC_MAEXIDR1_OFFSET	(0x40C)
#define MMDC_MADPCR0_OFFSET	(0x410)
#define MMDC_MADPCR1_OFFSET	(0x414)
#define MMDC_MADPSR0_OFFSET	(0x418)
#define MMDC_MADPSR1_OFFSET	(0x41C)
#define MMDC_MADPSR2_OFFSET	(0x420)
#define MMDC_MADPSR3_OFFSET	(0x424)
#define MMDC_MADPSR4_OFFSET	(0x428)
#define MMDC_MADPSR5_OFFSET	(0x42C)
#define MMDC_MASBS0_OFFSET	(0x430)
#define MMDC_MASBS1_OFFSET	(0x434)
#define MMDC_MAGENP_OFFSET	(0x440)

#define MMDC_MPZQHWCTRL_OFFSET	(0x800)
#define MMDC_MPZQSWCTRL_OFFSET	(0x804)
#define MMDC_MPWLGCR_OFFSET	(0x808)
#define MMDC_MPWLDECTRL0_OFFSET	(0x80C)
#define MMDC_MPWLDECTRL1_OFFSET	(0x810)
#define MMDC_MPWLDLST_OFFSET	(0x814)
#define MMDC_MPODTCTRL_OFFSET	(0x818)
#define MMDC_MPREDQBY0DL_OFFSET	(0x81C)
#define MMDC_MPREDQBY1DL_OFFSET	(0x820)
#define MMDC_MPREDQBY2DL_OFFSET	(0x824)
#define MMDC_MPREDQBY3DL_OFFSET	(0x828)
#define MMDC_MPWRDQBY0DL_OFFSET	(0x82C)
#define MMDC_MPWRDQBY1DL_OFFSET	(0x830)
#define MMDC_MPWRDQBY2DL_OFFSET	(0x834)
#define MMDC_MPWRDQBY3DL_OFFSET	(0x838)
#define MMDC_MPDGCTRL0_OFFSET	(0x83C)
#define MMDC_MPDGCTRL1_OFFSET	(0x840)
#define MMDC_MPDGDLST_OFFSET	(0x844)
#define MMDC_MPRDDLCTL_OFFSET	(0x848)
#define MMDC_MPRDDLST_OFFSET	(0x84C)
#define MMDC_MPWRDLCTL_OFFSET	(0x850)
#define MMDC_MPWRDLST_OFFSET	(0x854)
#define MMDC_MPSDCTRL_OFFSET	(0x858)
#define MMDC_MPZQLP2CTL_OFFSET	(0x85C)
#define MMDC_MPRDDLHWCTL_OFFSET	(0x860)
#define MMDC_MPWRDLHWCTL_OFFSET	(0x864)
#define MMDC_MPRDDLHWST0_OFFSET	(0x868)
#define MMDC_MPRDDLHWST1_OFFSET	(0x86C)
#define MMDC_MPWRDLHWST0_OFFSET	(0x870)
#define MMDC_MPWRDLHWST1_OFFSET	(0x874)
#define MMDC_MPWLHWERR_OFFSET	(0x878)
#define MMDC_MPDGHWST0_OFFSET	(0x87C)
#define MMDC_MPDGHWST1_OFFSET	(0x880)
#define MMDC_MPDGHWST2_OFFSET	(0x884)
#define MMDC_MPDGHWST3_OFFSET	(0x888)
#define MMDC_MPPDCMPR1_OFFSET	(0x88C)
#define MMDC_MPPDCMPR2_OFFSET	(0x890)
#define MMDC_MPSWDAR_OFFSET	(0x894)
#define MMDC_MPSWDRDR0_OFFSET	(0x898)
#define MMDC_MPSWDRDR1_OFFSET	(0x89C)
#define MMDC_MPSWDRDR2_OFFSET	(0x8A0)
#define MMDC_MPSWDRDR3_OFFSET	(0x8A4)
#define MMDC_MPSWDRDR4_OFFSET	(0x8A8)
#define MMDC_MPSWDRDR5_OFFSET	(0x8AC)
#define MMDC_MPSWDRDR6_OFFSET	(0x8B0)
#define MMDC_MPSWDRDR7_OFFSET	(0x8B4)
#define MMDC_MPMUR_OFFSET	(0x8B8)
#define MMDC_MPWRCADL_OFFSET	(0x8BC)
#define MMDC_MPDCCR_OFFSET	(0x8C0)
#define MMDC_MPBC_OFFSET	(0x8C4)
#define MMDC_MPSWDRAR_OFFSET	(0x8C8)

/* First MMDC invalid IPS address */
#define MMDC_IPS_ILL_ADDR_START_OFFSET	(0x8CC)
#define MMDC_REGS_BASE			MMDC0_RBASE

#define MMDC_MDCTL	((MMDC_REGS_BASE + MMDC_MDCTL_OFFSET))
#define MMDC_MDPDC	((MMDC_REGS_BASE + MMDC_MDPDC_OFFSET))
#define MMDC_MDOTC	((MMDC_REGS_BASE + MMDC_MDOTC_OFFSET))
#define MMDC_MDCFG0	((MMDC_REGS_BASE + MMDC_MDCFG0_OFFSET))
#define MMDC_MDCFG1	((MMDC_REGS_BASE + MMDC_MDCFG1_OFFSET))
#define MMDC_MDCFG2	((MMDC_REGS_BASE + MMDC_MDCFG2_OFFSET))
#define MMDC_MDMISC	((MMDC_REGS_BASE + MMDC_MDMISC_OFFSET))
#define MMDC_MDSCR	((MMDC_REGS_BASE + MMDC_MDSCR_OFFSET))
#define MMDC_MDREF	((MMDC_REGS_BASE + MMDC_MDREF_OFFSET))
#define MMDC_MDRWD	((MMDC_REGS_BASE + MMDC_MDRWD_OFFSET))
#define MMDC_MDOR	((MMDC_REGS_BASE + MMDC_MDOR_OFFSET))
#define MMDC_MDMRR	((MMDC_REGS_BASE + MMDC_MDMRR_OFFSET))
#define MMDC_MDCFG3LP	((MMDC_REGS_BASE + MMDC_MDCFG3LP_OFFSET))
#define MMDC_MDMR4	((MMDC_REGS_BASE + MMDC_MDMR4_OFFSET))
#define MMDC_MDASP	((MMDC_REGS_BASE + MMDC_MDASP_OFFSET))

#define MMDC_MAARCR	((MMDC_REGS_BASE + MMDC_MAARCR_OFFSET))
#define MMDC_MAPSR	((MMDC_REGS_BASE + MMDC_MAPSR_OFFSET))
#define MMDC_MAEXIDR0	((MMDC_REGS_BASE + MMDC_MAEXIDR0_OFFSET))
#define MMDC_MAEXIDR1	((MMDC_REGS_BASE + MMDC_MAEXIDR1_OFFSET))
#define MMDC_MADPCR0	((MMDC_REGS_BASE + MMDC_MADPCR0_OFFSET))
#define MMDC_MADPCR1	((MMDC_REGS_BASE + MMDC_MADPCR1_OFFSET))
#define MMDC_MADPSR0	((MMDC_REGS_BASE + MMDC_MADPSR0_OFFSET))
#define MMDC_MADPSR1	((MMDC_REGS_BASE + MMDC_MADPSR1_OFFSET))
#define MMDC_MADPSR2	((MMDC_REGS_BASE + MMDC_MADPSR2_OFFSET))
#define MMDC_MADPSR3	((MMDC_REGS_BASE + MMDC_MADPSR3_OFFSET))
#define MMDC_MADPSR4	((MMDC_REGS_BASE + MMDC_MADPSR4_OFFSET))
#define MMDC_MADPSR5	((MMDC_REGS_BASE + MMDC_MADPSR5_OFFSET))
#define MMDC_MASBS0	((MMDC_REGS_BASE + MMDC_MASBS0_OFFSET))
#define MMDC_MASBS1	((MMDC_REGS_BASE + MMDC_MASBS1_OFFSET))
#define MMDC_MAGENP	((MMDC_REGS_BASE + MMDC_MAGENP_OFFSET))

#define MMDC_MPZQHWCTRL		((MMDC_REGS_BASE + MMDC_MPZQHWCTRL_OFFSET))
#define MMDC_MPZQSWCTRL		((MMDC_REGS_BASE + MMDC_MPZQSWCTRL_OFFSET))
#define MMDC_MPWLGCR		((MMDC_REGS_BASE + MMDC_MPWLGCR_OFFSET))
#define MMDC_MPWLDECTRL0	((MMDC_REGS_BASE + MMDC_MPWLDECTRL0_OFFSET))
#define MMDC_MPWLDECTRL1	((MMDC_REGS_BASE + MMDC_MPWLDECTRL1_OFFSET))
#define MMDC_MPWLDLST		((MMDC_REGS_BASE + MMDC_MPWLDLST_OFFSET))
#define MMDC_MPODTCTRL		((MMDC_REGS_BASE + MMDC_MPODTCTRL_OFFSET))
#define MMDC_MPREDQBY0DL	((MMDC_REGS_BASE + MMDC_MPREDQBY0DL_OFFSET))
#define MMDC_MPREDQBY1DL	((MMDC_REGS_BASE + MMDC_MPREDQBY1DL_OFFSET))
#define MMDC_MPREDQBY2DL	((MMDC_REGS_BASE + MMDC_MPREDQBY2DL_OFFSET))
#define MMDC_MPREDQBY3DL	((MMDC_REGS_BASE + MMDC_MPREDQBY3DL_OFFSET))
#define MMDC_MPWRDQBY0DL	((MMDC_REGS_BASE + MMDC_MPWRDQBY0DL_OFFSET))
#define MMDC_MPWRDQBY1DL	((MMDC_REGS_BASE + MMDC_MPWRDQBY1DL_OFFSET))
#define MMDC_MPWRDQBY2DL	((MMDC_REGS_BASE + MMDC_MPWRDQBY2DL_OFFSET))
#define MMDC_MPWRDQBY3DL	((MMDC_REGS_BASE + MMDC_MPWRDQBY3DL_OFFSET))
#define MMDC_MPDGCTRL0		((MMDC_REGS_BASE + MMDC_MPDGCTRL0_OFFSET))
#define MMDC_MPDGCTRL1		((MMDC_REGS_BASE + MMDC_MPDGCTRL1_OFFSET))
#define MMDC_MPDGDLST		((MMDC_REGS_BASE + MMDC_MPDGDLST_OFFSET))
#define MMDC_MPRDDLCTL		((MMDC_REGS_BASE + MMDC_MPRDDLCTL_OFFSET))
#define MMDC_MPRDDLST		((MMDC_REGS_BASE + MMDC_MPRDDLST_OFFSET))
#define MMDC_MPWRDLCTL		((MMDC_REGS_BASE + MMDC_MPWRDLCTL_OFFSET))
#define MMDC_MPWRDLST		((MMDC_REGS_BASE + MMDC_MPWRDLST_OFFSET))
#define MMDC_MPSDCTRL		((MMDC_REGS_BASE + MMDC_MPSDCTRL_OFFSET))
#define MMDC_MPZQLP2CTL		((MMDC_REGS_BASE + MMDC_MPZQLP2CTL_OFFSET))
#define MMDC_MPRDDLHWCTL	((MMDC_REGS_BASE + MMDC_MPRDDLHWCTL_OFFSET))
#define MMDC_MPWRDLHWCTL	((MMDC_REGS_BASE + MMDC_MPWRDLHWCTL_OFFSET))
#define MMDC_MPRDDLHWST0	((MMDC_REGS_BASE + MMDC_MPRDDLHWST0_OFFSET))
#define MMDC_MPRDDLHWST1	((MMDC_REGS_BASE + MMDC_MPRDDLHWST1_OFFSET))
#define MMDC_MPWRDLHWST0	((MMDC_REGS_BASE + MMDC_MPWRDLHWST0_OFFSET))
#define MMDC_MPWRDLHWST1	((MMDC_REGS_BASE + MMDC_MPWRDLHWST1_OFFSET))
#define MMDC_MPWLHWERR		((MMDC_REGS_BASE + MMDC_MPWLHWERR_OFFSET))
#define MMDC_MPDGHWST0		((MMDC_REGS_BASE + MMDC_MPDGHWST0_OFFSET))
#define MMDC_MPDGHWST1		((MMDC_REGS_BASE + MMDC_MPDGHWST1_OFFSET))
#define MMDC_MPDGHWST2		((MMDC_REGS_BASE + MMDC_MPDGHWST2_OFFSET))
#define MMDC_MPDGHWST3		((MMDC_REGS_BASE + MMDC_MPDGHWST3_OFFSET))
#define MMDC_MPPDCMPR1		((MMDC_REGS_BASE + MMDC_MPPDCMPR1_OFFSET))
#define MMDC_MPPDCMPR2		((MMDC_REGS_BASE + MMDC_MPPDCMPR2_OFFSET))
#define MMDC_MPSWDAR		((MMDC_REGS_BASE + MMDC_MPSWDAR_OFFSET))
#define MMDC_MPSWDRDR0		((MMDC_REGS_BASE + MMDC_MPSWDRDR0_OFFSET))
#define MMDC_MPSWDRDR1		((MMDC_REGS_BASE + MMDC_MPSWDRDR1_OFFSET))
#define MMDC_MPSWDRDR2		((MMDC_REGS_BASE + MMDC_MPSWDRDR2_OFFSET))
#define MMDC_MPSWDRDR3		((MMDC_REGS_BASE + MMDC_MPSWDRDR3_OFFSET))
#define MMDC_MPSWDRDR4		((MMDC_REGS_BASE + MMDC_MPSWDRDR4_OFFSET))
#define MMDC_MPSWDRDR5		((MMDC_REGS_BASE + MMDC_MPSWDRDR5_OFFSET))
#define MMDC_MPSWDRDR6		((MMDC_REGS_BASE + MMDC_MPSWDRDR6_OFFSET))
#define MMDC_MPSWDRDR7		((MMDC_REGS_BASE + MMDC_MPSWDRDR7_OFFSET))
#define MMDC_MPMUR		((MMDC_REGS_BASE + MMDC_MPMUR_OFFSET))
#define MMDC_MPWRCADL		((MMDC_REGS_BASE + MMDC_MPWRCADL_OFFSET))
#define MMDC_MPDCCR		((MMDC_REGS_BASE + MMDC_MPDCCR_OFFSET))
#define MMDC_MPBC		((MMDC_REGS_BASE + MMDC_MPBC_OFFSET))
#define MMDC_MPSWDRAR		((MMDC_REGS_BASE + MMDC_MPSWDRAR_OFFSET))

/* MMDC registers bit defines */
#define MMDC_MDCTL_SDE_0		(31)
#define MMDC_MDCTL_SDE_1		(30)
#define MMDC_MDCTL_ROW			(24)
#define MMDC_MDCTL_COL			(20)
#define MMDC_MDCTL_BL			(19)
#define MMDC_MDCTL_DSIZ			(16)

/* MDMISC */
#define MMDC_MDMISC_CS0_RDY		(31)
#define MMDC_MDMISC_CS1_RDY		(30)
#define MMDC_MDMISC_CK1_DEL		(22)
#define MMDC_MDMISC_CK1_GATING		(21)
#define MMDC_MDMISC_CALIB_PER_CS	(20)
#define MMDC_MDMISC_ADDR_MIRROR		(19)
#define MMDC_MDMISC_LHD			(18)
#define MMDC_MDMISC_WALAT		(16)
#define MMDC_MDMISC_BI			(12)
#define MMDC_MDMISC_LPDDR2_S		(11)
#define MMDC_MDMISC_MIF3_MODE		(9)
#define MMDC_MDMISC_RALAT		(6)
#define MMDC_MDMISC_DDR_4_BANK		(5)
#define MMDC_MDMISC_DDR_TYPE		(3)
#define MMDC_MDMISC_RST			(1)

/* MPWLGCR */
#define MMDC_MPWLGCR_WL_HW_ERR		(8)

/* MDSCR */
#define MMDC_MDSCR_CMD_ADDR_MSB		(24)
#define MMDC_MDSCR_MR_OP		(24)
#define MMDC_MDSCR_CMD_ADDR_LSB		(16)
#define MMDC_MDSCR_MR_ADDR		(16)
#define MMDC_MDSCR_CON_REQ		(15)
#define MMDC_MDSCR_CON_ACK		(14)
#define MMDC_MDSCR_MRR_READ_DATA_VALID	(10)
#define MMDC_MDSCR_WL_EN		(9)
#define MMDC_MDSCR_CMD			(4)
#define MMDC_MDSCR_CMD_CS		(3)
#define MMDC_MDSCR_CMD_BA		(0)

/* MPZQHWCTRL */
#define MMDC_MPZQHWCTRL_ZQ_HW_FOR	(16)
#define MMDC_MPZQHWCTRL_ZQ_MODE		(0)

/* MPZQSWCTRL */
#define MMDC_MPZQSWCTRL_ZQ_CMP_OUT_SMP	(16)
#define MMDC_MPZQSWCTRL_USE_ZQ_SW_VAL	(13)
#define MMDC_MPZQSWCTRL_ZQ_SW_PD	(12)
#define MMDC_MPZQSWCTRL_ZQ_SW_PD_VAL	(7)
#define MMDC_MPZQSWCTRL_ZQ_SW_PU_VAL	(2)
#define MMDC_MPZQSWCTRL_ZQ_SW_RES	(1)
#define MMDC_MPZQSWCTRL_ZQ_SW_FOR	(0)

/* MPDGCTRL0 */
#define MMDC_MPDGCTRL0_RST_RD_FIFO	(31)
#define MMDC_MPDGCTRL0_DG_CMP_CYC	(30)
#define MMDC_MPDGCTRL0_DG_DIS		(29)
#define MMDC_MPDGCTRL0_HW_DG_EN		(28)
#define MMDC_MPDGCTRL0_HW_DG_ERR	(12)

/* MPRDDLHWCTL */
#define MMDC_MPRDDLHWCTL_HW_RD_DL_CMP_CYC	(5)
#define MMDC_MPRDDLHWCTL_HW_RD_DL_EN		(4)
#define MMDC_MPRDDLHWCTL_HW_RD_DL_ERR		(0)

/* MPWRDLHWCTL */
#define MMDC_MPWRDLHWCTL_HW_WR_DL_CMP_CYC	(5)
#define MMDC_MPWRDLHWCTL_HW_WR_DL_EN		(4)
#define MMDC_MPWRDLHWCTL_HW_WR_DL_ERR		(0)

/* MPSWDAR */
#define MMDC_MPSWDAR_TEST_DUMMY_EN	(6)
#define MMDC_MPSWDAR_SW_DUM_CMP3	(5)
#define MMDC_MPSWDAR_SW_DUM_CMP2	(4)
#define MMDC_MPSWDAR_SW_DUM_CMP1	(3)
#define MMDC_MPSWDAR_SW_DUM_CMP0	(2)
#define MMDC_MPSWDAR_SW_DUMMY_RD	(1)
#define MMDC_MPSWDAR_SW_DUMMY_WR	(0)

/* MADPCR0 */
#define MMDC_MADPCR0_SBS		(9)
#define MMDC_MADPCR0_SBS_EN		(8)

/* MASBS1 */
#define MMDC_MASBS1_SBS_VLD		(0)
#define MMDC_MASBS1_SBS_TYPE		(1)

/* MDREF */
#define MMDC_MDREF_REF_CNT		(16)
#define MMDC_MDREF_REF_SEL		(14)
#define MMDC_MDREF_REFR			(11)
#define MMDC_MDREF_START_REF		(0)

/* MPWLGCR */
#define MMDC_MPWLGCR_HW_WL_EN		(0)

/* MPBC */
#define MMDC_MPBC_BIST_DM_LP_EN		(0)
#define MMDC_MPBC_BIST_CA0_LP_EN	(1)
#define MMDC_MPBC_BIST_DQ0_LP_EN	(3)
#define MMDC_MPBC_BIST_DQ1_LP_EN	(4)
#define MMDC_MPBC_BIST_DQ2_LP_EN	(5)
#define MMDC_MPBC_BIST_DQ3_LP_EN	(6)

/* MPMUR */
#define MMDC_MPMUR_FRC_MSR		(11)

/* MPODTCTRL */
#define MMDC_MPODTCTRL_ODT_RD_ACT_EN	(3)
#define MMDC_MPODTCTRL_ODT_RD_PAS_EN	(2)
#define MMDC_MPODTCTRL_ODT_WR_ACT_EN	(1)
#define MMDC_MPODTCTRL_ODT_WR_PAS_EN	(0)

/* MAPSR */
#define MMDC_MAPSR_DVACK		(25)
#define MMDC_MAPSR_LPACK		(24)
#define MMDC_MAPSR_DVFS			(21)
#define MMDC_MAPSR_LPMD			(20)

/* MAARCR */
#define MMDC_MAARCR_ARCR_EXC_ERR_EN	(28)

/* MPZQLP2CTL */
#define MMDC_MPZQLP2CTL_ZQ_LP2_HW_ZQCS	(24)
#define MMDC_MPZQLP2CTL_ZQ_LP2_HW_ZQCL	(16)
#define MMDC_MPZQLP2CTL_ZQ_LP2_HW_ZQINIT	(0)

/* MDCFG3LP */
#define MMDC_MDCFG3LP_tRC_LP		(16)
#define MMDC_MDCFG3LP_tRCD_LP		(8)
#define MMDC_MDCFG3LP_tRPpb_LP		(4)
#define MMDC_MDCFG3LP_tRPab_LP		(0)

/* MDOR */
#define MMDC_MDOR_tXPR			(16)
#define MMDC_MDOR_SDE_to_RST		(8)
#define MMDC_MDOR_RST_to_CKE		(0)

/* MDCFG0 */
#define MMDC_MDCFG0_tRFC		(24)
#define MMDC_MDCFG0_tXS			(16)
#define MMDC_MDCFG0_tXP			(13)
#define MMDC_MDCFG0_tXPDLL		(9)
#define MMDC_MDCFG0_tFAW		(4)
#define MMDC_MDCFG0_tCL			(0)

/* MDCFG1 */
#define MMDC_MDCFG1_tRCD		(29)
#define MMDC_MDCFG1_tRP			(26)
#define MMDC_MDCFG1_tRC			(21)
#define MMDC_MDCFG1_tRAS		(16)
#define MMDC_MDCFG1_tRPA		(15)
#define MMDC_MDCFG1_tWR			(9)
#define MMDC_MDCFG1_tMRD		(5)
#define MMDC_MDCFG1_tCWL		(0)

/* MDCFG2 */
#define MMDC_MDCFG2_tDLLK		(16)
#define MMDC_MDCFG2_tRTP		(6)
#define MMDC_MDCFG2_tWTR		(3)
#define MMDC_MDCFG2_tRRD		(0)

/* MDRWD */
#define MMDC_MDRWD_tDAI			(16)
#define MMDC_MDRWD_RTW_SAME		(12)
#define MMDC_MDRWD_WTR_DIFF		(9)
#define MMDC_MDRWD_WTW_DIFF		(6)
#define MMDC_MDRWD_RTW_DIFF		(3)
#define MMDC_MDRWD_RTR_DIFF		(0)

/* MDPDC */
#define MMDC_MDPDC_PRCT_1		(28)
#define MMDC_MDPDC_PRCT_0		(24)
#define MMDC_MDPDC_tCKE			(16)
#define MMDC_MDPDC_PWDT_1		(12)
#define MMDC_MDPDC_PWDT_0		(8)
#define MMDC_MDPDC_SLOW_PD		(7)
#define MMDC_MDPDC_BOTH_CS_PD		(6)
#define MMDC_MDPDC_tCKSRX		(3)
#define MMDC_MDPDC_tCKSRE		(0)

/* MDASP */
#define MMDC_MDASP_CS0_END		(0)

/* MAEXIDR0 */
#define MMDC_MAEXIDR0_EXC_ID_MONITOR1	(16)
#define MMDC_MAEXIDR0_EXC_ID_MONITOR0	(0)

/* MAEXIDR1 */
#define MMDC_MAEXIDR1_EXC_ID_MONITOR3	(16)
#define MMDC_MAEXIDR1_EXC_ID_MONITOR2	(0)

/* MPWRDLCTL */
#define MMDC_MPWRDLCTL_WR_DL_ABS_OFFSET3	(24)
#define MMDC_MPWRDLCTL_WR_DL_ABS_OFFSET2	(16)
#define MMDC_MPWRDLCTL_WR_DL_ABS_OFFSET1	(8)
#define MMDC_MPWRDLCTL_WR_DL_ABS_OFFSET0	(0)

/* MPRDDLCTL */
#define MMDC_MPRDDLCTL_RD_DL_ABS_OFFSET3	(24)
#define MMDC_MPRDDLCTL_RD_DL_ABS_OFFSET2	(16)
#define MMDC_MPRDDLCTL_RD_DL_ABS_OFFSET1	(8)
#define MMDC_MPRDDLCTL_RD_DL_ABS_OFFSET0	(0)

/* MPWRDQBY0DL */
#define MMDC_MPWRDQBY0DL_WR_DM0_DEL	(30)
#define MMDC_MPWRDQBY0DL_WR_DQ7_DEL	(28)
#define MMDC_MPWRDQBY0DL_WR_DQ6_DEL	(24)
#define MMDC_MPWRDQBY0DL_WR_DQ5_DEL	(20)
#define MMDC_MPWRDQBY0DL_WR_DQ4_DEL	(16)
#define MMDC_MPWRDQBY0DL_WR_DQ3_DEL	(12)
#define MMDC_MPWRDQBY0DL_WR_DQ2_DEL	(8)
#define MMDC_MPWRDQBY0DL_WR_DQ1_DEL	(4)
#define MMDC_MPWRDQBY0DL_WR_DQ0_DEL	(0)

/* MPWRDQBY1DL */
#define MMDC_MPWRDQBY1DL_WR_DM1_DEL	(30)
#define MMDC_MPWRDQBY1DL_WR_DQ15_DEL	(28)
#define MMDC_MPWRDQBY1DL_WR_DQ14_DEL	(24)
#define MMDC_MPWRDQBY1DL_WR_DQ13_DEL	(20)
#define MMDC_MPWRDQBY1DL_WR_DQ12_DEL	(16)
#define MMDC_MPWRDQBY1DL_WR_DQ11_DEL	(12)
#define MMDC_MPWRDQBY1DL_WR_DQ10_DEL	(8)
#define MMDC_MPWRDQBY1DL_WR_DQ9_DEL	(4)
#define MMDC_MPWRDQBY1DL_WR_DQ8_DEL	(0)

/* MPWRDQBY2DL */
#define MMDC_MPWRDQBY2DL_WR_DM2_DEL	(30)
#define MMDC_MPWRDQBY2DL_WR_DQ23_DEL	(28)
#define MMDC_MPWRDQBY2DL_WR_DQ22_DEL	(24)
#define MMDC_MPWRDQBY2DL_WR_DQ21_DEL	(20)
#define MMDC_MPWRDQBY2DL_WR_DQ20_DEL	(16)
#define MMDC_MPWRDQBY2DL_WR_DQ19_DEL	(12)
#define MMDC_MPWRDQBY2DL_WR_DQ18_DEL	(8)
#define MMDC_MPWRDQBY2DL_WR_DQ17_DEL	(4)
#define MMDC_MPWRDQBY2DL_WR_DQ16_DEL	(0)

/* MPWRDQBY3DL */
#define MMDC_MPWRDQBY3DL_WR_DM3_DEL	(30)
#define MMDC_MPWRDQBY3DL_WR_DQ31_DEL	(28)
#define MMDC_MPWRDQBY3DL_WR_DQ30_DEL	(24)
#define MMDC_MPWRDQBY3DL_WR_DQ29_DEL	(20)
#define MMDC_MPWRDQBY3DL_WR_DQ28_DEL	(16)
#define MMDC_MPWRDQBY3DL_WR_DQ27_DEL	(12)
#define MMDC_MPWRDQBY3DL_WR_DQ26_DEL	(8)
#define MMDC_MPWRDQBY3DL_WR_DQ25_DEL	(4)
#define MMDC_MPWRDQBY3DL_WR_DQ24_DEL	(0)

/* Fields masks */
#define MMDC_MDCTL_SDE_0_MASK	((0x1 << MMDC_MDCTL_SDE_0))
#define MMDC_MDCTL_SDE_1_MASK	((0x1 << MMDC_MDCTL_SDE_1))
#define MMDC_MDCTL_BL_MASK	((0x1 << MMDC_MDCTL_BL))
#define MMDC_MDCTL_ROW_MASK	((0x7 << MMDC_MDCTL_ROW))
#define MMDC_MDCTL_COL_MASK	((0x7 << MMDC_MDCTL_COL))
#define MMDC_MDCTL_DSIZ_MASK	((0x3 << MMDC_MDCTL_DSIZ))

/* MDMISC */
#define MMDC_MDMISC_CS0_RDY_MASK	((0x1 << MMDC_MDMISC_CS0_RDY))
#define MMDC_MDMISC_CS1_RDY_MASK	((0x1 << MMDC_MDMISC_CS1_RDY))
#define MMDC_MDMISC_CK1_DEL_MASK	((0x3 << MMDC_MDMISC_CK1_DEL))
#define MMDC_MDMISC_CK1_GATING_MASK	((0x1 << MMDC_MDMISC_CK1_GATING))
#define MMDC_MDMISC_CALIB_PER_CS_MASK	((0x1 << MMDC_MDMISC_CALIB_PER_CS))
#define MMDC_MDMISC_ADDR_MIRROR_MASK	((0x1 << MMDC_MDMISC_ADDR_MIRROR))
#define MMDC_MDMISC_LHD_MASK		((0x1 << MMDC_MDMISC_LHD))
#define MMDC_MDMISC_WALAT_MASK		((0x3 << MMDC_MDMISC_WALAT))
#define MMDC_MDMISC_BI_MASK		((0x1 << MMDC_MDMISC_BI))
#define MMDC_MDMISC_LPDDR2_S_MASK	((0x1 << MMDC_MDMISC_LPDDR2_S))
#define MMDC_MDMISC_MIF3_MODE_MASK	((0x3 << MMDC_MDMISC_MIF3_MODE))
#define MMDC_MDMISC_RALAT_MASK		((0x7 << MMDC_MDMISC_RALAT))
#define MMDC_MDMISC_DDR_4_BANK_MASK	((0x1 << MMDC_MDMISC_DDR_4_BANK))
#define MMDC_MDMISC_DDR_TYPE_MASK	((0x3 << MMDC_MDMISC_DDR_TYPE))
#define MMDC_MDMISC_RST_MASK		((0x1 << MMDC_MDMISC_RST))

/* MPWLGCR */
#define MMDC_MPWLGCR_WL_HW_ERR_MASK	((0xf << MMDC_MPWLGCR_WL_HW_ERR))

/* MDSCR */
#define MMDC_MDSCR_CMD_ADDR_MSB_MASK	((0xff << MMDC_MDSCR_CMD_ADDR_MSB))
#define MMDC_MDSCR_MR_OP_MASK		((0xff << MMDC_MDSCR_MR_OP))
#define MMDC_MDSCR_CMD_ADDR_LSB_MASK	((0xff << MMDC_MDSCR_CMD_ADDR_LSB))
#define MMDC_MDSCR_MR_ADDR_MASK		((0xff << MMDC_MDSCR_MR_ADDR))
#define MMDC_MDSCR_CON_REQ_MASK		((0x1  << MMDC_MDSCR_CON_REQ))
#define MMDC_MDSCR_CON_ACK_MASK		((0x1  << MMDC_MDSCR_CON_ACK))
#define MMDC_MDSCR_MRR_READ_DATA_VALID_MASK	((0x1  << MMDC_MDSCR_MRR_READ_DATA_VALID))
#define MMDC_MDSCR_WL_EN_MASK		((0x1  << MMDC_MDSCR_WL_EN))
#define MMDC_MDSCR_CMD_MASK		((0x7  << MMDC_MDSCR_CMD))
#define MMDC_MDSCR_CMD_CS_MASK		((0x1  << MMDC_MDSCR_CMD_CS))
#define MMDC_MDSCR_CMD_BA_MASK		((0x7  << MMDC_MDSCR_CMD_BA))

/* MPZQHWCTRL */
#define MMDC_MPZQHWCTRL_ZQ_HW_FOR_MASK	((0x1 << MMDC_MPZQHWCTRL_ZQ_HW_FOR))
#define MMDC_MPZQHWCTRL_ZQ_MODE_MASK	((0x3 << MMDC_MPZQHWCTRL_ZQ_MODE))

/* MPZQSWCTRL */
#define MMDC_MPZQSWCTRL_ZQ_CMP_OUT_SMP_MASK	((0x3  << MMDC_MPZQSWCTRL_ZQ_CMP_OUT_SMP))
#define MMDC_MPZQSWCTRL_USE_ZQ_SW_VAL_MASK	((0x1  << MMDC_MPZQSWCTRL_USE_ZQ_SW_VAL))
#define MMDC_MPZQSWCTRL_ZQ_SW_PD_MASK		((0x1  << MMDC_MPZQSWCTRL_ZQ_SW_PD))
#define MMDC_MPZQSWCTRL_ZQ_SW_PD_VAL_MASK	((0x1f << MMDC_MPZQSWCTRL_ZQ_SW_PD_VAL))
#define MMDC_MPZQSWCTRL_ZQ_SW_PU_VAL_MASK	((0x1f << MMDC_MPZQSWCTRL_ZQ_SW_PU_VAL))
#define MMDC_MPZQSWCTRL_ZQ_SW_RES_MASK		((0x1  << MMDC_MPZQSWCTRL_ZQ_SW_RES))
#define MMDC_MPZQSWCTRL_ZQ_SW_FOR_MASK		((0x1  << MMDC_MPZQSWCTRL_ZQ_SW_FOR))

/* MPDGCTRL0 */
#define MMDC_MPDGCTRL0_RST_RD_FIFO_MASK		((0x1 << MMDC_MPDGCTRL0_RST_RD_FIFO))
#define MMDC_MPDGCTRL0_DG_CMP_CYC_MASK		((0x1 << MMDC_MPDGCTRL0_DG_CMP_CYC))
#define MMDC_MPDGCTRL0_DG_DIS_MASK		((0x1 << MMDC_MPDGCTRL0_DG_DIS))
#define MMDC_MPDGCTRL0_HW_DG_EN_MASK		((0x1 << MMDC_MPDGCTRL0_HW_DG_EN))
#define MMDC_MPDGCTRL0_HW_DG_ERR_MASK		((0x1 << MMDC_MPDGCTRL0_HW_DG_ERR))

/* MPRDDLHWCTL */
#define MMDC_MPRDDLHWCTL_HW_RD_DL_CMP_CYC_MASK	((0x1 << MMDC_MPRDDLHWCTL_HW_RD_DL_CMP_CYC))
#define MMDC_MPRDDLHWCTL_HW_RD_DL_EN_MASK	((0x1 << MMDC_MPRDDLHWCTL_HW_RD_DL_EN))
#define MMDC_MPRDDLHWCTL_HW_RD_DL_ERR_MASK	((0xf << MMDC_MPRDDLHWCTL_HW_RD_DL_ERR))

/* MPWRDLHWCTL */
#define MMDC_MPWRDLHWCTL_HW_WR_DL_CMP_CYC_MASK	((0x1 << MMDC_MPWRDLHWCTL_HW_WR_DL_CMP_CYC))
#define MMDC_MPWRDLHWCTL_HW_WR_DL_EN_MASK	((0x1 << MMDC_MPWRDLHWCTL_HW_WR_DL_EN))
#define MMDC_MPWRDLHWCTL_HW_WR_DL_ERR_MASK	((0xf << MMDC_MPWRDLHWCTL_HW_WR_DL_ERR))

/* MPSWDAR */
#define MMDC_MPSWDAR_TEST_DUMMY_EN_MASK	((0x1 << MMDC_MPSWDAR_TEST_DUMMY_EN))
#define MMDC_MPSWDAR_SW_DUM_CMP3_MASK	((0x1 << MMDC_MPSWDAR_SW_DUM_CMP3))
#define MMDC_MPSWDAR_SW_DUM_CMP2_MASK	((0x1 << MMDC_MPSWDAR_SW_DUM_CMP2))
#define MMDC_MPSWDAR_SW_DUM_CMP1_MASK	((0x1 << MMDC_MPSWDAR_SW_DUM_CMP1))
#define MMDC_MPSWDAR_SW_DUM_CMP0_MASK	((0x1 << MMDC_MPSWDAR_SW_DUM_CMP0))
#define MMDC_MPSWDAR_SW_DUMMY_RD_MASK	((0x1 << MMDC_MPSWDAR_SW_DUMMY_RD))
#define MMDC_MPSWDAR_SW_DUMMY_WR_MASK	((0x1 << MMDC_MPSWDAR_SW_DUMMY_WR))

/* MADPCR0 */
#define MMDC_MADPCR0_SBS_MASK		((0x1 << MMDC_MADPCR0_SBS))
#define MMDC_MADPCR0_SBS_EN_MASK	((0x1 << MMDC_MADPCR0_SBS_EN))

/* MASBS1 */
#define MMDC_MASBS1_SBS_VLD_MASK	((0x1 << MMDC_MASBS1_SBS_VLD))
#define MMDC_MASBS1_SBS_TYPE_MASK	((0x1 << MMDC_MASBS1_SBS_TYPE))

/* MDREF */
#define MMDC_MDREF_REF_CNT_MASK		((0xffff << MMDC_MDREF_REF_CNT))
#define MMDC_MDREF_REF_SEL_MASK		((0x3    << MMDC_MDREF_REF_SEL))
#define MMDC_MDREF_REFR_MASK		((0x7    << MMDC_MDREF_REFR))
#define MMDC_MDREF_START_REF_MASK	((0x1    << MMDC_MDREF_START_REF))

/* MPWLGCR */
#define MMDC_MPWLGCR_HW_WL_EN_MASK	((0x1 << MMDC_MPWLGCR_HW_WL_EN))

/* MPBC */
#define MMDC_MPBC_BIST_DM_LP_EN_MASK	((0x1 << MMDC_MPBC_BIST_DM_LP_EN))
#define MMDC_MPBC_BIST_CA0_LP_EN_MASK	((0x1 << MMDC_MPBC_BIST_CA0_LP_EN))
#define MMDC_MPBC_BIST_DQ0_LP_EN_MASK	((0x1 << MMDC_MPBC_BIST_DQ0_LP_EN))
#define MMDC_MPBC_BIST_DQ1_LP_EN_MASK	((0x1 << MMDC_MPBC_BIST_DQ1_LP_EN))
#define MMDC_MPBC_BIST_DQ2_LP_EN_MASK	((0x1 << MMDC_MPBC_BIST_DQ2_LP_EN))
#define MMDC_MPBC_BIST_DQ3_LP_EN_MASK	((0x1 << MMDC_MPBC_BIST_DQ3_LP_EN))
#define MMDC_MPBC_BIST_DQ_LP_EN_MASK	((0xf << MMDC_MPBC_BIST_DQ0_LP_EN))

/* MPMUR */
#define MMDC_MPMUR_FRC_MSR_MASK		((0x1 << MMDC_MPMUR_FRC_MSR))

/* MPODTCTRL */
#define MMDC_MPODTCTRL_ODT_RD_ACT_EN_MASK	((0x1 << MMDC_MPODTCTRL_ODT_RD_ACT_EN))
#define MMDC_MPODTCTRL_ODT_RD_PAS_EN_MASK	((0x1 << MMDC_MPODTCTRL_ODT_RD_PAS_EN))
#define MMDC_MPODTCTRL_ODT_WR_ACT_EN_MASK	((0x1 << MMDC_MPODTCTRL_ODT_WR_ACT_EN))
#define MMDC_MPODTCTRL_ODT_WR_PAS_EN_MASK	((0x1 << MMDC_MPODTCTRL_ODT_WR_PAS_EN))

/* MAPSR */
#define MMDC_MAPSR_DVACK_MASK		((0x1 << MMDC_MAPSR_DVACK))
#define MMDC_MAPSR_LPACK_MASK		((0x1 << MMDC_MAPSR_LPACK))
#define MMDC_MAPSR_DVFS_MASK		((0x1 << MMDC_MAPSR_DVFS))
#define MMDC_MAPSR_LPMD_MASK		((0x1 << MMDC_MAPSR_LPMD))

/* MAARCR */
#define MMDC_MAARCR_ARCR_EXC_ERR_EN_MASK	((0x1 << MMDC_MAARCR_ARCR_EXC_ERR_EN))

/* MPZQLP2CTL */
#define MMDC_MPZQLP2CTL_ZQ_LP2_HW_ZQCS_MASK	((0x7f  << MMDC_MPZQLP2CTL_ZQ_LP2_HW_ZQCS))
#define MMDC_MPZQLP2CTL_ZQ_LP2_HW_ZQCL_MASK	((0xff  << MMDC_MPZQLP2CTL_ZQ_LP2_HW_ZQCL))
#define MMDC_MPZQLP2CTL_ZQ_LP2_HW_ZQINIT_MASK	((0x1ff << MMDC_MPZQLP2CTL_ZQ_LP2_HW_ZQINIT))

/* MDCFG3LP */
#define MMDC_MDCFG3LP_tRC_LP_MASK	((0x3f  << MMDC_MDCFG3LP_tRC_LP))
#define MMDC_MDCFG3LP_tRCD_LP_MASK	((0xf   << MMDC_MDCFG3LP_tRCD_LP))
#define MMDC_MDCFG3LP_tRPpb_LP_MASK	((0xf   << MMDC_MDCFG3LP_tRPpb_LP))
#define MMDC_MDCFG3LP_tRPab_LP_MASK	((0xf   << MMDC_MDCFG3LP_tRPab_LP))

/* MDOR */
#define MMDC_MDOR_tXPR_MASK		((0xff  << MMDC_MDOR_tXPR))
#define MMDC_MDOR_SDE_to_RST_MASK	((0x3f  << MMDC_MDOR_SDE_to_RST))
#define MMDC_MDOR_RST_to_CKE_MASK	((0x3f  << MMDC_MDOR_RST_to_CKE))

/* MDCFG0 */
#define MMDC_MDCFG0_tRFC_MASK		((0xff  << MMDC_MDCFG0_tRFC))
#define MMDC_MDCFG0_tXS_MASK		((0xff  << MMDC_MDCFG0_tXS))
#define MMDC_MDCFG0_tXP_MASK		((0x7   << MMDC_MDCFG0_tXP))
#define MMDC_MDCFG0_tXPDLL_MASK		((0xf   << MMDC_MDCFG0_tXPDLL))
#define MMDC_MDCFG0_tFAW_MASK		((0x1f  << MMDC_MDCFG0_tFAW))
#define MMDC_MDCFG0_tCL_MASK		((0xf   << MMDC_MDCFG0_tCL))

/* MDCFG1 */
#define MMDC_MDCFG1_tRCD_MASK		((0x7   << MMDC_MDCFG1_tRCD))
#define MMDC_MDCFG1_tRP_MASK		((0x7   << MMDC_MDCFG1_tRP))
#define MMDC_MDCFG1_tRC_MASK		((0x1f  << MMDC_MDCFG1_tRC))
#define MMDC_MDCFG1_tRAS_MASK		((0x1f  << MMDC_MDCFG1_tRAS))
#define MMDC_MDCFG1_tRPA_MASK		((0x1   << MMDC_MDCFG1_tRPA))
#define MMDC_MDCFG1_tWR_MASK		((0x7   << MMDC_MDCFG1_tWR))
#define MMDC_MDCFG1_tMRD_MASK		((0xf   << MMDC_MDCFG1_tMRD))
#define MMDC_MDCFG1_tCWL_MASK		((0x7   << MMDC_MDCFG1_tCWL))

/* MDCFG2 */
#define MMDC_MDCFG2_tDLLK_MASK		((0x1ff << MMDC_MDCFG2_tDLLK))
#define MMDC_MDCFG2_tRTP_MASK		((0x7   << MMDC_MDCFG2_tRTP))
#define MMDC_MDCFG2_tWTR_MASK		((0x7   << MMDC_MDCFG2_tWTR))
#define MMDC_MDCFG2_tRRD_MASK		((0x7   << MMDC_MDCFG2_tRRD))

/* MDRWD */
#define MMDC_MDRWD_tDAI_MASK		((0x1fff << MMDC_MDRWD_tDAI))
#define MMDC_MDRWD_RTW_SAME_MASK	((0x7    << MMDC_MDRWD_RTW_SAME))
#define MMDC_MDRWD_WTR_DIFF_MASK	((0x7    << MMDC_MDRWD_WTR_DIFF))
#define MMDC_MDRWD_WTW_DIFF_MASK	((0x7    << MMDC_MDRWD_WTW_DIFF))
#define MMDC_MDRWD_RTW_DIFF_MASK	((0x7    << MMDC_MDRWD_RTW_DIFF))
#define MMDC_MDRWD_RTR_DIFF_MASK	((0x7    << MMDC_MDRWD_RTR_DIFF))

/* MDPDC */
#define MMDC_MDPDC_PRCT_1_MASK		((0x7    << MMDC_MDPDC_PRCT_1))
#define MMDC_MDPDC_PRCT_0_MASK		((0x7    << MMDC_MDPDC_PRCT_0))
#define MMDC_MDPDC_tCKE_MASK		((0x7    << MMDC_MDPDC_tCKE))
#define MMDC_MDPDC_PWDT_1_MASK		((0xf    << MMDC_MDPDC_PWDT_1))
#define MMDC_MDPDC_PWDT_0_MASK		((0xf    << MMDC_MDPDC_PWDT_0))
#define MMDC_MDPDC_SLOW_PD_MASK		((0x1    << MMDC_MDPDC_SLOW_PD))
#define MMDC_MDPDC_BOTH_CS_PD_MASK	((0x1    << MMDC_MDPDC_BOTH_CS_PD))
#define MMDC_MDPDC_tCKSRX_MASK		((0x7    << MMDC_MDPDC_tCKSRX))
#define MMDC_MDPDC_tCKSRE_MASK		((0x7    << MMDC_MDPDC_tCKSRE))

/* MDASP */
#define MMDC_MDASP_CS0_END_MASK		((0x7f << MMDC_MDASP_CS0_END))

/* MAEXIDR0 */
#define MMDC_MAEXIDR0_EXC_ID_MONITOR1_MASK	((0xffff << MMDC_MAEXIDR0_EXC_ID_MONITOR1))
#define MMDC_MAEXIDR0_EXC_ID_MONITOR0_MASK	((0xffff << MMDC_MAEXIDR0_EXC_ID_MONITOR0))

/* MAEXIDR1 */
#define MMDC_MAEXIDR1_EXC_ID_MONITOR3_MASK	((0xffff << MMDC_MAEXIDR1_EXC_ID_MONITOR3))
#define MMDC_MAEXIDR1_EXC_ID_MONITOR2_MASK	((0xffff << MMDC_MAEXIDR1_EXC_ID_MONITOR2))

/* MPWRDLCTL */
#define MMDC_MPWRDLCTL_WR_DL_ABS_OFFSET3_MASK	((0x7f << MMDC_MPWRDLCTL_WR_DL_ABS_OFFSET3))
#define MMDC_MPWRDLCTL_WR_DL_ABS_OFFSET2_MASK	((0x7f << MMDC_MPWRDLCTL_WR_DL_ABS_OFFSET2))
#define MMDC_MPWRDLCTL_WR_DL_ABS_OFFSET1_MASK	((0x7f << MMDC_MPWRDLCTL_WR_DL_ABS_OFFSET1))
#define MMDC_MPWRDLCTL_WR_DL_ABS_OFFSET0_MASK	((0x7f << MMDC_MPWRDLCTL_WR_DL_ABS_OFFSET0))

/* MPRDDLCTL */
#define MMDC_MPRDDLCTL_RD_DL_ABS_OFFSET3_MASK	((0x7f << MMDC_MPRDDLCTL_RD_DL_ABS_OFFSET3))
#define MMDC_MPRDDLCTL_RD_DL_ABS_OFFSET2_MASK	((0x7f << MMDC_MPRDDLCTL_RD_DL_ABS_OFFSET2))
#define MMDC_MPRDDLCTL_RD_DL_ABS_OFFSET1_MASK	((0x7f << MMDC_MPRDDLCTL_RD_DL_ABS_OFFSET1))
#define MMDC_MPRDDLCTL_RD_DL_ABS_OFFSET0_MASK	((0x7f << MMDC_MPRDDLCTL_RD_DL_ABS_OFFSET0))

/* MPWRDQBY0DL */
#define MMDC_MPWRDQBY0DL_WR_DM0_DEL_MASK	((0x3f  << MMDC_MPWRDQBY0DL_WR_DM0_DEL))
#define MMDC_MPWRDQBY0DL_WR_DQ7_DEL_MASK	((0x3f  << MMDC_MPWRDQBY0DL_WR_DQ7_DEL))
#define MMDC_MPWRDQBY0DL_WR_DQ6_DEL_MASK	((0x3f  << MMDC_MPWRDQBY0DL_WR_DQ6_DEL))
#define MMDC_MPWRDQBY0DL_WR_DQ5_DEL_MASK	((0x3f  << MMDC_MPWRDQBY0DL_WR_DQ5_DEL))
#define MMDC_MPWRDQBY0DL_WR_DQ4_DEL_MASK	((0x3f  << MMDC_MPWRDQBY0DL_WR_DQ4_DEL))
#define MMDC_MPWRDQBY0DL_WR_DQ3_DEL_MASK	((0x3f  << MMDC_MPWRDQBY0DL_WR_DQ3_DEL))
#define MMDC_MPWRDQBY0DL_WR_DQ2_DEL_MASK	((0x3f  << MMDC_MPWRDQBY0DL_WR_DQ2_DEL))
#define MMDC_MPWRDQBY0DL_WR_DQ1_DEL_MASK	((0x3f  << MMDC_MPWRDQBY0DL_WR_DQ1_DEL))
#define MMDC_MPWRDQBY0DL_WR_DQ0_DEL_MASK	((0x3f  << MMDC_MPWRDQBY0DL_WR_DQ0_DEL))

/* MPWRDQBY1DL */
#define MMDC_MPWRDQBY1DL_WR_DM1_DEL_MASK	((0x3f  << MMDC_MPWRDQBY1DL_WR_DM1_DEL))
#define MMDC_MPWRDQBY1DL_WR_DQ15_DEL_MASK	((0x3f  << MMDC_MPWRDQBY1DL_WR_DQ15_DEL))
#define MMDC_MPWRDQBY1DL_WR_DQ14_DEL_MASK	((0x3f  << MMDC_MPWRDQBY1DL_WR_DQ14_DEL))
#define MMDC_MPWRDQBY1DL_WR_DQ13_DEL_MASK	((0x3f  << MMDC_MPWRDQBY1DL_WR_DQ13_DEL))
#define MMDC_MPWRDQBY1DL_WR_DQ12_DEL_MASK	((0x3f  << MMDC_MPWRDQBY1DL_WR_DQ12_DEL))
#define MMDC_MPWRDQBY1DL_WR_DQ11_DEL_MASK	((0x3f  << MMDC_MPWRDQBY1DL_WR_DQ11_DEL))
#define MMDC_MPWRDQBY1DL_WR_DQ10_DEL_MASK	((0x3f  << MMDC_MPWRDQBY1DL_WR_DQ10_DEL))
#define MMDC_MPWRDQBY1DL_WR_DQ9_DEL_MASK	((0x3f  << MMDC_MPWRDQBY1DL_WR_DQ9_DEL))
#define MMDC_MPWRDQBY1DL_WR_DQ8_DEL_MASK	((0x3f  << MMDC_MPWRDQBY1DL_WR_DQ8_DEL))

/* MPWRDQBY2DL */
#define MMDC_MPWRDQBY2DL_WR_DM2_DEL_MASK	((0x3f  << MMDC_MPWRDQBY2DL_WR_DM2_DEL))
#define MMDC_MPWRDQBY2DL_WR_DQ23_DEL_MASK	((0x3f  << MMDC_MPWRDQBY2DL_WR_DQ23_DEL))
#define MMDC_MPWRDQBY2DL_WR_DQ22_DEL_MASK	((0x3f  << MMDC_MPWRDQBY2DL_WR_DQ22_DEL))
#define MMDC_MPWRDQBY2DL_WR_DQ21_DEL_MASK	((0x3f  << MMDC_MPWRDQBY2DL_WR_DQ21_DEL))
#define MMDC_MPWRDQBY2DL_WR_DQ20_DEL_MASK	((0x3f  << MMDC_MPWRDQBY2DL_WR_DQ20_DEL))
#define MMDC_MPWRDQBY2DL_WR_DQ19_DEL_MASK	((0x3f  << MMDC_MPWRDQBY2DL_WR_DQ19_DEL))
#define MMDC_MPWRDQBY2DL_WR_DQ18_DEL_MASK	((0x3f  << MMDC_MPWRDQBY2DL_WR_DQ18_DEL))
#define MMDC_MPWRDQBY2DL_WR_DQ17_DEL_MASK	((0x3f  << MMDC_MPWRDQBY2DL_WR_DQ17_DEL))
#define MMDC_MPWRDQBY2DL_WR_DQ16_DEL_MASK	((0x3f  << MMDC_MPWRDQBY2DL_WR_DQ16_DEL))

/* MPWRDQBY3DL */
#define MMDC_MPWRDQBY3DL_WR_DM3_DEL_MASK	((0x3f  << MMDC_MPWRDQBY3DL_WR_DM3_DEL))
#define MMDC_MPWRDQBY3DL_WR_DQ31_DEL_MASK	((0x3f  << MMDC_MPWRDQBY3DL_WR_DQ31_DEL))
#define MMDC_MPWRDQBY3DL_WR_DQ30_DEL_MASK	((0x3f  << MMDC_MPWRDQBY3DL_WR_DQ30_DEL))
#define MMDC_MPWRDQBY3DL_WR_DQ29_DEL_MASK	((0x3f  << MMDC_MPWRDQBY3DL_WR_DQ29_DEL))
#define MMDC_MPWRDQBY3DL_WR_DQ28_DEL_MASK	((0x3f  << MMDC_MPWRDQBY3DL_WR_DQ28_DEL))
#define MMDC_MPWRDQBY3DL_WR_DQ27_DEL_MASK	((0x3f  << MMDC_MPWRDQBY3DL_WR_DQ27_DEL))
#define MMDC_MPWRDQBY3DL_WR_DQ26_DEL_MASK	((0x3f  << MMDC_MPWRDQBY3DL_WR_DQ26_DEL))
#define MMDC_MPWRDQBY3DL_WR_DQ25_DEL_MASK	((0x3f  << MMDC_MPWRDQBY3DL_WR_DQ25_DEL))
#define MMDC_MPWRDQBY3DL_WR_DQ24_DEL_MASK	((0x3f  << MMDC_MPWRDQBY3DL_WR_DQ24_DEL))

#if !(defined(__KERNEL_STRICT_NAMES) || defined(__ASSEMBLY__))

#include <asm/types.h>

struct fuse_word {
	u32	fuse;
	u32	rsvd[3];
};

struct ocotp_regs {
	u32	ctrl;
	u32	ctrl_set;
	u32	ctrl_clr;
	u32	ctrl_tog;
	u32	pdn;
	u32	rsvd0[3];
	u32	data;
	u32	rsvd1[3];
	u32	read_ctrl;
	u32	rsvd2[3];
	u32	read_fuse_data;
	u32	rsvd3[3];
	u32	sw_sticky;
	u32	rsvd4[3];
	u32	scs;
	u32	scs_set;
	u32	scs_clr;
	u32	scs_tog;
	u32	out_status;
	u32	out_status_set;
	u32	out_status_clr;
	u32	out_status_tog;
	u32	startword;
	u32	rsvd5[3];
	u32	version;
	u32	rsvd6[19];
	struct	fuse_word mem_repair[8];
	u32	rsvd7[0xa8];

	/* fuse banks */
	struct fuse_bank {
		u32	fuse_regs[0x20];
	} bank[0];
};

struct fuse_bank1_regs {
	u32	lock0;
	u32	rsvd0[3];
	u32	lock1;
	u32	rsvd1[3];
	u32	lock2;
	u32	rsvd2[3];
	u32	cfg0;
	u32	rsvd3[3];
	u32	cfg1;
	u32	rsvd4[3];
	u32	cfg2;
	u32	rsvd5[3];
	u32	cfg3;
	u32	rsvd6[3];
	u32	cfg4;
	u32	rsvd7[3];
};

struct fuse_bank2_regs {
	struct fuse_word boot[8];
};

struct fuse_bank3_regs {
	u32	mem0;
	u32	rsvd0[3];
	u32	mem1;
	u32	rsvd1[3];
	u32	mem2;
	u32	rsvd2[3];
	u32	mem3;
	u32	rsvd3[3];
	u32	ana0;
	u32	rsvd4[3];
	u32	ana1;
	u32	rsvd5[3];
	u32	ana2;
	u32	rsvd6[3];
	u32	ana3;
	u32	rsvd7[3];
};

struct fuse_bank7_regs {
	u32	sjc_resp0;
	u32	rsvd0[3];
	u32	sjc_resp1;
	u32	rsvd1[3];
	u32	gp0;
	u32	rsvd2[3];
	u32	gp1;
	u32	rsvd3[3];
	u32	gp2;
	u32	rsvd4[3];
	u32	gp3;
	u32	rsvd5[3];
	u32	gp4;
	u32	rsvd6[3];
	u32	gp5;
	u32	rsvd7[3];
};

struct usbphy_regs {
	u32	usbphy_pwd;			/* 0x000 */
	u32	usbphy_pwd_set;			/* 0x004 */
	u32	usbphy_pwd_clr;			/* 0x008 */
	u32	usbphy_pwd_tog;			/* 0x00c */
	u32	usbphy_tx;			/* 0x010 */
	u32	usbphy_tx_set;			/* 0x014 */
	u32	usbphy_tx_clr;			/* 0x018 */
	u32	usbphy_tx_tog;			/* 0x01c */
	u32	usbphy_rx;			/* 0x020 */
	u32	usbphy_rx_set;			/* 0x024 */
	u32	usbphy_rx_clr;			/* 0x028 */
	u32	usbphy_rx_tog;			/* 0x02c */
	u32	usbphy_ctrl;			/* 0x030 */
	u32	usbphy_ctrl_set;		/* 0x034 */
	u32	usbphy_ctrl_clr;		/* 0x038 */
	u32	usbphy_ctrl_tog;		/* 0x03c */
	u32	usbphy_status;			/* 0x040 */
	u32	reserved0[3];
	u32	usbphy_debug0;			/* 0x050 */
	u32	usbphy_debug0_set;		/* 0x054 */
	u32	usbphy_debug0_clr;		/* 0x058 */
	u32	usbphy_debug0_tog;		/* 0x05c */
	u32	reserved1[4];
	u32	usbphy_debug1;			/* 0x070 */
	u32	usbphy_debug1_set;		/* 0x074 */
	u32	usbphy_debug1_clr;		/* 0x078 */
	u32	usbphy_debug1_tog;		/* 0x07c */
	u32	usbphy_version;			/* 0x080 */
	u32	reserved2[7];
	u32	usb1_pll_480_ctrl;		/* 0x0a0 */
	u32	usb1_pll_480_ctrl_set;		/* 0x0a4 */
	u32	usb1_pll_480_ctrl_clr;		/* 0x0a8 */
	u32	usb1_pll_480_ctrl_tog;		/* 0x0ac */
	u32	reserved3[4];
	u32	usb1_vbus_detect;		/* 0xc0 */
	u32	usb1_vbus_detect_set;		/* 0xc4 */
	u32	usb1_vbus_detect_clr;		/* 0xc8 */
	u32	usb1_vbus_detect_tog;		/* 0xcc */
	u32	usb1_vbus_det_stat;		/* 0xd0 */
	u32	reserved4[3];
	u32	usb1_chrg_detect;		/* 0xe0 */
	u32	usb1_chrg_detect_set;		/* 0xe4 */
	u32	usb1_chrg_detect_clr;		/* 0xe8 */
	u32	usb1_chrg_detect_tog;		/* 0xec */
	u32	usb1_chrg_det_stat;		/* 0xf0 */
	u32	reserved5[3];
	u32	usbphy_anactrl;			/* 0x100 */
	u32	usbphy_anactrl_set;		/* 0x104 */
	u32	usbphy_anactrl_clr;		/* 0x108 */
	u32	usbphy_anactrl_tog;		/* 0x10c */
	u32	usb1_loopback;			/* 0x110 */
	u32	usb1_loopback_set;		/* 0x114 */
	u32	usb1_loopback_clr;		/* 0x118 */
	u32	usb1_loopback_tog;		/* 0x11c */
	u32	usb1_loopback_hsfscnt;		/* 0x120 */
	u32	usb1_loopback_hsfscnt_set;	/* 0x124 */
	u32	usb1_loopback_hsfscnt_clr;	/* 0x128 */
	u32	usb1_loopback_hsfscnt_tog;	/* 0x12c */
	u32	usphy_trim_override_en;		/* 0x130 */
	u32	usphy_trim_override_en_set;	/* 0x134 */
	u32	usphy_trim_override_en_clr;	/* 0x138 */
	u32	usphy_trim_override_en_tog;	/* 0x13c */
	u32	usb1_pfda_ctrl1;		/* 0x140 */
	u32	usb1_pfda_ctrl1_set;		/* 0x144 */
	u32	usb1_pfda_ctrl1_clr;		/* 0x148 */
	u32	usb1_pfda_ctrl1_tog;		/* 0x14c */
};


#define	is_boot_from_usb(void)		(!(readl(USB_PHY0_BASE_ADDR) & (1<<20)))
#define	disconnect_from_pc(void)	writel(0x0, USBOTG0_RBASE + 0x140)

#endif

#endif /* _MX7ULP_REGS_H_*/
