/* Intel Atom/32 gmp-mparam.h -- Compiler/machine parameter header file.

Copyright 1991, 1993, 1994, 2000-2011, 2014-2015 Free Software Foundation, Inc.

This file is part of the GNU MP Library.

The GNU MP Library is free software; you can redistribute it and/or modify
it under the terms of either:

  * the GNU Lesser General Public License as published by the Free
    Software Foundation; either version 3 of the License, or (at your
    option) any later version.

or

  * the GNU General Public License as published by the Free Software
    Foundation; either version 2 of the License, or (at your option) any
    later version.

or both in parallel, as here.

The GNU MP Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received copies of the GNU General Public License and the
GNU Lesser General Public License along with the GNU MP Library.  If not,
see https://www.gnu.org/licenses/.  */

#define GMP_LIMB_BITS 32
#define GMP_LIMB_BYTES 4

/* 1600 MHz Diamondville (Atom 330) */
/* FFT tuning limit = 50 M */
/* Generated by tuneup.c, 2015-10-09, gcc 4.7 */

#define MOD_1_NORM_THRESHOLD                 3
#define MOD_1_UNNORM_THRESHOLD               5
#define MOD_1N_TO_MOD_1_1_THRESHOLD         10
#define MOD_1U_TO_MOD_1_1_THRESHOLD          5
#define MOD_1_1_TO_MOD_1_2_THRESHOLD        10
#define MOD_1_2_TO_MOD_1_4_THRESHOLD         0  /* never mpn_mod_1s_2p */
#define PREINV_MOD_1_TO_MOD_1_THRESHOLD     17
#define USE_PREINV_DIVREM_1                  1  /* native */
#define DIV_QR_1N_PI1_METHOD                 1
#define DIV_QR_1_NORM_THRESHOLD              4
#define DIV_QR_1_UNNORM_THRESHOLD        MP_SIZE_T_MAX  /* never */
#define DIV_QR_2_PI2_THRESHOLD           MP_SIZE_T_MAX  /* never */
#define DIVEXACT_1_THRESHOLD                 0  /* always (native) */
#define BMOD_1_TO_MOD_1_THRESHOLD           31

#define MUL_TOOM22_THRESHOLD                20
#define MUL_TOOM33_THRESHOLD                81
#define MUL_TOOM44_THRESHOLD               178
#define MUL_TOOM6H_THRESHOLD               270
#define MUL_TOOM8H_THRESHOLD               381

#define MUL_TOOM32_TO_TOOM43_THRESHOLD     120
#define MUL_TOOM32_TO_TOOM53_THRESHOLD     126
#define MUL_TOOM42_TO_TOOM53_THRESHOLD     115
#define MUL_TOOM42_TO_TOOM63_THRESHOLD     127
#define MUL_TOOM43_TO_TOOM54_THRESHOLD     106

#define SQR_BASECASE_THRESHOLD               0  /* always (native) */
#define SQR_TOOM2_THRESHOLD                 32
#define SQR_TOOM3_THRESHOLD                121
#define SQR_TOOM4_THRESHOLD                184
#define SQR_TOOM6_THRESHOLD                303
#define SQR_TOOM8_THRESHOLD                527

#define MULMID_TOOM42_THRESHOLD             54

#define MULMOD_BNM1_THRESHOLD               16
#define SQRMOD_BNM1_THRESHOLD               17

#define MUL_FFT_MODF_THRESHOLD             380  /* k = 5 */
#define MUL_FFT_TABLE3                                      \
  { {    380, 5}, {     21, 6}, {     11, 5}, {     23, 6}, \
    {     12, 5}, {     25, 6}, {     21, 7}, {     11, 6}, \
    {     25, 7}, {     13, 6}, {     27, 7}, {     15, 6}, \
    {     31, 7}, {     21, 8}, {     11, 7}, {     27, 8}, \
    {     15, 7}, {     35, 8}, {     19, 7}, {     39, 8}, \
    {     23, 7}, {     47, 8}, {     27, 9}, {     15, 8}, \
    {     39, 9}, {     23, 8}, {     51,10}, {     15, 9}, \
    {     31, 8}, {     67, 9}, {     39, 8}, {     79, 9}, \
    {     47, 8}, {     99, 9}, {     55,10}, {     31, 9}, \
    {     79,10}, {     47, 9}, {     95,11}, {     31,10}, \
    {     63, 9}, {    135,10}, {     79, 9}, {    159,10}, \
    {     95, 9}, {    191,10}, {    111,11}, {     63,10}, \
    {    127, 9}, {    255, 8}, {    511, 9}, {    271,10}, \
    {    143, 9}, {    287, 8}, {    575, 9}, {    303,10}, \
    {    159, 9}, {    319,11}, {     95,10}, {    191, 9}, \
    {    383,12}, {     63,11}, {    127,10}, {    255, 9}, \
    {    511,10}, {    271, 9}, {    543,10}, {    287, 9}, \
    {    575,10}, {    303,11}, {    159,10}, {    319, 9}, \
    {    639,10}, {    351,11}, {    191,10}, {    383, 9}, \
    {    767,10}, {    415,11}, {    223,10}, {    447,12}, \
    {    127,11}, {    255,10}, {    543,11}, {    287,10}, \
    {    607,11}, {    319,10}, {    639,11}, {    351,10}, \
    {    703,12}, {    191,11}, {    383,10}, {    767,11}, \
    {    415,10}, {    831,11}, {    447,13}, {    127,12}, \
    {    255,11}, {    543,10}, {   1087,11}, {    607,12}, \
    {    319,11}, {    735,12}, {    383,11}, {    831,12}, \
    {    447,11}, {    959,13}, {    255,12}, {    511,11}, \
    {   1087,12}, {    575,11}, {   1215,12}, {    639,11}, \
    {   1279,12}, {    703,11}, {   1407,13}, {    383,12}, \
    {    959,14}, {    255,13}, {    511,12}, {   1215,13}, \
    {    639,12}, {   1471,13}, {    767,12}, {   1599,13}, \
    {    895,12}, {   1791,14}, {    511,13}, {   1023,12}, \
    {   2111,13}, {   1151,12}, {   2431,13}, {   1407,14}, \
    {    767,13}, {   1663,12}, {   3455,13}, {   1791,15}, \
    {    511,14}, {   1023,13}, {   2431,14}, {   1279,13}, \
    {   2943,12}, {   5887,14}, {   1535,13}, {   3455,14}, \
    {   1791,13}, {   3839,15}, {   1023,14}, {   2047,13}, \
    {   4223,14}, {   2303,13}, {   4991,12}, {   9983,14}, \
    {   2815,13}, {   5887,15}, {  32768,16} }
#define MUL_FFT_TABLE3_SIZE 155
#define MUL_FFT_THRESHOLD                 4544

#define SQR_FFT_MODF_THRESHOLD             340  /* k = 5 */
#define SQR_FFT_TABLE3                                      \
  { {    340, 5}, {     21, 6}, {     11, 5}, {     23, 6}, \
    {     12, 5}, {     25, 6}, {     21, 7}, {     11, 6}, \
    {     25, 7}, {     13, 6}, {     28, 7}, {     15, 6}, \
    {     31, 7}, {     21, 8}, {     11, 7}, {     27, 8}, \
    {     15, 7}, {     35, 8}, {     19, 7}, {     41, 8}, \
    {     23, 7}, {     47, 8}, {     27, 9}, {     15, 8}, \
    {     39, 9}, {     23, 8}, {     51,10}, {     15, 9}, \
    {     31, 8}, {     67, 9}, {     39, 8}, {     79, 9}, \
    {     47,10}, {     31, 9}, {     79,10}, {     47, 9}, \
    {     95,11}, {     31,10}, {     63, 9}, {    127, 8}, \
    {    255, 7}, {    511, 9}, {    135, 8}, {    271, 9}, \
    {    143,10}, {     79, 8}, {    319, 7}, {    639,10}, \
    {     95, 9}, {    191, 8}, {    383,10}, {    111,11}, \
    {     63,10}, {    127, 9}, {    255, 8}, {    511, 9}, \
    {    271, 8}, {    543,10}, {    143, 9}, {    287, 8}, \
    {    607, 9}, {    319,11}, {     95,10}, {    191,12}, \
    {     63,11}, {    127,10}, {    255, 9}, {    511,10}, \
    {    271, 9}, {    543,10}, {    287, 9}, {    575,10}, \
    {    303, 9}, {    607,10}, {    319, 9}, {    639,10}, \
    {    335, 9}, {    671,10}, {    351, 9}, {    703,11}, \
    {    191,10}, {    383, 9}, {    767,10}, {    415,11}, \
    {    223,10}, {    447,12}, {    127,11}, {    255,10}, \
    {    543,11}, {    287,10}, {    607,11}, {    319,10}, \
    {    671,11}, {    351,10}, {    703,12}, {    191,11}, \
    {    383,10}, {    767,11}, {    415,10}, {    831,11}, \
    {    479,13}, {    127,12}, {    255,11}, {    543,10}, \
    {   1087,11}, {    607,12}, {    319,11}, {    671,10}, \
    {   1343,11}, {    735,12}, {    383,11}, {    831,12}, \
    {    447,11}, {    959,13}, {    255,12}, {    511,11}, \
    {   1087,12}, {    575,11}, {   1215,12}, {    639,11}, \
    {   1343,12}, {    703,13}, {    383,12}, {    959,14}, \
    {    255,13}, {    511,12}, {   1215,13}, {    639,12}, \
    {   1471,13}, {    767,12}, {   1599,13}, {    895,14}, \
    {    511,13}, {   1023,12}, {   2111,13}, {   1151,12}, \
    {   2431,13}, {   1407,14}, {    767,13}, {   1663,12}, \
    {   3455,15}, {    511,14}, {   1023,13}, {   2431,14}, \
    {   1279,13}, {   2943,12}, {   5887,14}, {   1535,13}, \
    {   3455,14}, {   1791,13}, {   3839,15}, {   1023,14}, \
    {   2047,13}, {   4351,14}, {   2303,13}, {   4991,12}, \
    {   9983,14}, {   2815,13}, {   5887,15}, {  32768,16} }
#define SQR_FFT_TABLE3_SIZE 160
#define SQR_FFT_THRESHOLD                 3712

#define MULLO_BASECASE_THRESHOLD             0  /* always */
#define MULLO_DC_THRESHOLD                  56
#define MULLO_MUL_N_THRESHOLD             8907
#define SQRLO_BASECASE_THRESHOLD             0  /* always */
#define SQRLO_DC_THRESHOLD                 114
#define SQRLO_SQR_THRESHOLD               6654

#define DC_DIV_QR_THRESHOLD                 71
#define DC_DIVAPPR_Q_THRESHOLD             250
#define DC_BDIV_QR_THRESHOLD                68
#define DC_BDIV_Q_THRESHOLD                172

#define INV_MULMOD_BNM1_THRESHOLD           38
#define INV_NEWTON_THRESHOLD               250
#define INV_APPR_THRESHOLD                 250

#define BINV_NEWTON_THRESHOLD              264
#define REDC_1_TO_REDC_N_THRESHOLD          71

#define MU_DIV_QR_THRESHOLD               1442
#define MU_DIVAPPR_Q_THRESHOLD            1442
#define MUPI_DIV_QR_THRESHOLD              114
#define MU_BDIV_QR_THRESHOLD              1017
#define MU_BDIV_Q_THRESHOLD               1210

#define POWM_SEC_TABLE  3,16,96,416,1985

#define GET_STR_DC_THRESHOLD                13
#define GET_STR_PRECOMPUTE_THRESHOLD        25
#define SET_STR_DC_THRESHOLD               396
#define SET_STR_PRECOMPUTE_THRESHOLD      1105

#define FAC_DSC_THRESHOLD                  224
#define FAC_ODD_THRESHOLD                   29

#define MATRIX22_STRASSEN_THRESHOLD         17
#define HGCD_THRESHOLD                     126
#define HGCD_APPR_THRESHOLD                165
#define HGCD_REDUCE_THRESHOLD             2479
#define GCD_DC_THRESHOLD                   511
#define GCDEXT_DC_THRESHOLD                333
#define JACOBI_BASE_METHOD                   2
