// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// IPC Messages sent between compositor instances.

#ifndef CC_IPC_CC_PARAM_TRAITS_H_
#define CC_IPC_CC_PARAM_TRAITS_H_

#include "cc/ipc/cc_ipc_export.h"
#include "cc/ipc/cc_param_traits_macros.h"
#include "cc/paint/filter_operation.h"
#include "components/viz/common/quads/compositor_frame.h"
#include "components/viz/common/quads/draw_quad.h"
#include "components/viz/common/quads/frame_deadline.h"
#include "components/viz/common/quads/stream_video_draw_quad.h"
#include "components/viz/common/quads/texture_draw_quad.h"
#include "gpu/ipc/common/gpu_command_buffer_traits.h"
#include "ipc/ipc_message_macros.h"

namespace cc {
class FilterOperations;
class PaintFilter;
}

namespace IPC {

template <>
struct ParamTraits<cc::FilterOperation> {
  typedef cc::FilterOperation param_type;
  static void Write(base::Pickle* m, const param_type& p);
  static bool Read(const base::Pickle* m,
                   base::PickleIterator* iter,
                   param_type* r);
  static void Log(const param_type& p, std::string* l);
};

template <>
struct ParamTraits<cc::FilterOperations> {
  typedef cc::FilterOperations param_type;
  static void Write(base::Pickle* m, const param_type& p);
  static bool Read(const base::Pickle* m,
                   base::PickleIterator* iter,
                   param_type* r);
  static void Log(const param_type& p, std::string* l);
};

template <>
struct CC_IPC_EXPORT ParamTraits<sk_sp<cc::PaintFilter>> {
  typedef sk_sp<cc::PaintFilter> param_type;
  static void Write(base::Pickle* m, const param_type& p);
  static bool Read(const base::Pickle* m,
                   base::PickleIterator* iter,
                   param_type* r);
  static void Log(const param_type& p, std::string* l);
};

template <>
struct CC_IPC_EXPORT ParamTraits<viz::RenderPass> {
  typedef viz::RenderPass param_type;
  static void Write(base::Pickle* m, const param_type& p);
  static bool Read(const base::Pickle* m,
                   base::PickleIterator* iter,
                   param_type* r);
  static void Log(const param_type& p, std::string* l);
};

template <>
struct CC_IPC_EXPORT ParamTraits<viz::FrameDeadline> {
  typedef viz::FrameDeadline param_type;
  static void Write(base::Pickle* m, const param_type& p);
  static bool Read(const base::Pickle* m,
                   base::PickleIterator* iter,
                   param_type* r);
  static void Log(const param_type& p, std::string* l);
};

template <>
struct CC_IPC_EXPORT ParamTraits<viz::FrameSinkId> {
  typedef viz::FrameSinkId param_type;
  static void Write(base::Pickle* m, const param_type& p);
  static bool Read(const base::Pickle* m,
                   base::PickleIterator* iter,
                   param_type* r);
  static void Log(const param_type& p, std::string* l);
};

template <>
struct CC_IPC_EXPORT ParamTraits<viz::LocalSurfaceId> {
  typedef viz::LocalSurfaceId param_type;
  static void Write(base::Pickle* m, const param_type& p);
  static bool Read(const base::Pickle* m,
                   base::PickleIterator* iter,
                   param_type* r);
  static void Log(const param_type& p, std::string* l);
};

template <>
struct CC_IPC_EXPORT ParamTraits<viz::SurfaceId> {
  typedef viz::SurfaceId param_type;
  static void Write(base::Pickle* m, const param_type& p);
  static bool Read(const base::Pickle* m,
                   base::PickleIterator* iter,
                   param_type* r);
  static void Log(const param_type& p, std::string* l);
};

template <>
struct CC_IPC_EXPORT ParamTraits<viz::SurfaceInfo> {
  typedef viz::SurfaceInfo param_type;
  static void Write(base::Pickle* m, const param_type& p);
  static bool Read(const base::Pickle* m,
                   base::PickleIterator* iter,
                   param_type* r);
  static void Log(const param_type& p, std::string* l);
};

template <>
struct CC_IPC_EXPORT ParamTraits<viz::CompositorFrame> {
  typedef viz::CompositorFrame param_type;
  static void Write(base::Pickle* m, const param_type& p);
  static bool Read(const base::Pickle* m,
                   base::PickleIterator* iter,
                   param_type* p);
  static void Log(const param_type& p, std::string* l);
};

template <>
struct CC_IPC_EXPORT ParamTraits<viz::DrawQuad::Resources> {
  typedef viz::DrawQuad::Resources param_type;
  static void Write(base::Pickle* m, const param_type& p);
  static bool Read(const base::Pickle* m,
                   base::PickleIterator* iter,
                   param_type* p);
  static void Log(const param_type& p, std::string* l);
};

template <>
struct CC_IPC_EXPORT ParamTraits<viz::YUVVideoDrawQuad> {
  typedef viz::YUVVideoDrawQuad param_type;
  static void Write(base::Pickle* m, const param_type& p);
  static bool Read(const base::Pickle* m,
                   base::PickleIterator* iter,
                   param_type* p);
  static void Log(const param_type& p, std::string* l);
};

template <>
struct CC_IPC_EXPORT ParamTraits<viz::BeginFrameAck> {
  typedef viz::BeginFrameAck param_type;
  static void Write(base::Pickle* m, const param_type& p);
  static bool Read(const base::Pickle* m,
                   base::PickleIterator* iter,
                   param_type* p);
  static void Log(const param_type& p, std::string* l);
};

}  // namespace IPC

#endif  // CC_IPC_CC_PARAM_TRAITS_H_
