# Autobuild

Applications based on the AGL framework should have a
full build and packaging solution that is independent of the
[Yocto Project](https://www.yoctoproject.org) workflow.

You can create a script named **autobuild** to control applications
build operations.
AGL provides a BitBake class file (`aglwgt.bbclass`) that calls the
**autobuild** script for all operations.
The class file is located at the top level of the application repository.

You can write the **autobuild** script using any of the following languages:

* Makefile
* Bash
* Python

The script executes directly after applying a `chmod()` command.
The caller, which can be the `aglwgt.bbclass`, a Jenkins job, or an actual person,
must make the **autobuild** executable before calling it.
To facilitate direct execution, you need to start the script with a
[shebang](https://en.wikipedia.org/wiki/Shebang_(Unix)) sequence:

* '#!/usr/bin/make -f' for Makefile format
* '#!/usr/bin/bash' for Bash format

The calling convention is similar to the convention used in `make`.
To pass arguments, use environment variables.

**NOTE:** For Bash, an evaluation of the arguments
sets the environment variables correctly.

The following format shows the generic call:

```bash
autobuild/agl/autobuild <command> [ARG1="value1" [ARG2="value2" ... ]]
```

The **autobuild** script can be invoked from any directory
with all paths considered to be relative to the
script's location.
For makefile scripts, this is the usual behavior.
For Bash scripts, a `cd $(dirname $0)` command must be run at
the beginning of the script.

At build time, the following calls must be made in the following order:

1. Initialize the build environment (e.g if the application uses
   `cmake` the configure step runs CMake).

   ```bash
   autobuild/agl/autobuild configure CONFIGURE_ARGS="..."
   ```

2. Build the application (i.e. compile, link binaries, assembles javascript,
   and so forth).

   ```bash
   autobuild/agl/autobuild build BUILD_ARGS="...."
   ```

3. Create the widget package(s) in the specified destination path
   prepared by the caller.

   ```bash
   autobuild/agl/autobuild package PACKAGE_ARGS="..." DEST=<path-for-resulting-wgt-files>
   ```

4. Create the test widget package(s) in the specified destination path
   prepared by the caller.

   ```bash
   autobuild/agl/autobuild package-test PACKAGE_ARGS="..." DEST=<path-for-resulting-wgt-files>
   ```

5. Clean the built files by removing the result of the **autobuild** build.

   ```bash
   autobuild/agl/autobuild clean CLEAN_ARGS="..."
   ```

6. Clean everything by removing the result of the **autobuild** build
   and the **autobuild** configure.

   ```bash
   autobuild/agl/autobuild distclean DISTCLEAN_ARGS="..."
   ```

## Integrating **autobuild** into the Yocto Project Workflow

If you want to integrate the **autobuild** script into the Yocto Project
workflow, you need to generate the script.
To generate the script, use the `autobuild` target.

The following commands create the **autobuild** script in the
`autobuild/agl` directory:

```bash
mkdir -p build
cd build
cmake .. && make autobuild
```

## Available Targets

Following are the targets available from the **autobuild** script:

- **clean**: Removes object file and target results from the build directory.
- **distclean**: Deletes the build directory.
- **configure**: Generates the project Makefile from the `CMakeLists.txt` files.
- **build**: Compiles all project targets.
- **package**: Builds a widget (**wgt**) package.
- **package-test**: Builds the test **wgt** package and the normal **wgt** package.
- **install**: Installs the project into your filesystem.

Specifying the following variables lets you modify compilation behavior:

- **CLEAN_ARGS**: Variable used at **clean** time.
- **DISTCLEAN_ARGS**: Variable used at **distclean** time.
- **CONFIGURE_ARGS**: Variable used at **configure** time.
- **BUILD_ARGS**: Variable used at **build** time.
- **DEST**: Directory in which to place the created ***wgt*** file.
  The default directory is the build root directory.

When you provide a variable, use the CMake format (i.e.
BUILD_ARGS="-DC_FLAGS='-g -O2'").
Following is an example:

```bash
./autobuild/wgt/autobuild package DEST=/tmp
```
