/*
 * Copyright (C) 2015 Freescale Semiconductor, Inc.
 *
 * SPDX-License-Identifier:     GPL-2.0+
 */

#ifndef __ASM_ARCH_IMX7D_PINS_H__
#define __ASM_ARCH_IMX7D_PINS_H__

#include <asm/imx-common/iomux-v3.h>

enum {
	MX7D_PAD_GPIO1_IO00__GPIO1_IO0                           = IOMUX_PAD(0x0030, 0x0000, IOMUX_CONFIG_LPSR | 0, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO00__PWM4_OUT				 = IOMUX_PAD(0x0030, 0x0000, IOMUX_CONFIG_LPSR | 1, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO00__WDOG1_WDOG_B                        = IOMUX_PAD(0x0030, 0x0000, IOMUX_CONFIG_LPSR | 3, 0x0000, 0, 0),

	MX7D_PAD_GPIO1_IO01__GPIO1_IO1                           = IOMUX_PAD(0x0034, 0x0004, IOMUX_CONFIG_LPSR | 0, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO01__PWM1_OUT                            = IOMUX_PAD(0x0034, 0x0004, IOMUX_CONFIG_LPSR | 1, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO01__CCM_ENET_REF_CLK3                   = IOMUX_PAD(0x0034, 0x0004, IOMUX_CONFIG_LPSR | 2, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO01__SAI1_MCLK				 = IOMUX_PAD(0x0034, 0x0004, IOMUX_CONFIG_LPSR | 3, 0x0000, 0, 0),

	MX7D_PAD_GPIO1_IO02__GPIO1_IO2                           = IOMUX_PAD(0x0038, 0x0008, IOMUX_CONFIG_LPSR | 0, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO02__PWM2_OUT                            = IOMUX_PAD(0x0038, 0x0008, IOMUX_CONFIG_LPSR | 1, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO02__CCM_ENET_REF_CLK1                   = IOMUX_PAD(0x0038, 0x0008, IOMUX_CONFIG_LPSR | 2, 0x0564, 3, 0),
	MX7D_PAD_GPIO1_IO02__SAI2_MCLK                           = IOMUX_PAD(0x0038, 0x0008, IOMUX_CONFIG_LPSR | 3, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO02__CCM_CLKO1                           = IOMUX_PAD(0x0038, 0x0008, IOMUX_CONFIG_LPSR | 5, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO02__USB_OTG1_ID                         = IOMUX_PAD(0x0038, 0x0008, IOMUX_CONFIG_LPSR | 7, 0x0734, 3, 0),

	MX7D_PAD_GPIO1_IO03__GPIO1_IO3                           = IOMUX_PAD(0x003c, 0x000C, IOMUX_CONFIG_LPSR | 0, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO03__PWM3_OUT                            = IOMUX_PAD(0x003c, 0x000C, IOMUX_CONFIG_LPSR | 1, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO03__CCM_ENET_REF_CLK2                   = IOMUX_PAD(0x003c, 0x000C, IOMUX_CONFIG_LPSR | 2, 0x0570, 3, 0),
	MX7D_PAD_GPIO1_IO03__SAI3_MCLK                           = IOMUX_PAD(0x003c, 0x000C, IOMUX_CONFIG_LPSR | 3, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO03__CCM_CLKO2                           = IOMUX_PAD(0x003c, 0x000C, IOMUX_CONFIG_LPSR | 5, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO03__USB_OTG2_ID                         = IOMUX_PAD(0x003c, 0x000C, IOMUX_CONFIG_LPSR | 7, 0x0730, 3, 0),

	MX7D_PAD_GPIO1_IO04__GPIO1_IO4                           = IOMUX_PAD(0x0040, 0x0010, IOMUX_CONFIG_LPSR | 0, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO04__USB_OTG1_OC                         = IOMUX_PAD(0x0040, 0x0010, IOMUX_CONFIG_LPSR | 1, 0x072C, 1, 0),
	MX7D_PAD_GPIO1_IO04__FLEXTIMER_CH4                       = IOMUX_PAD(0x0040, 0x0010, IOMUX_CONFIG_LPSR | 2, 0x0594, 1, 0),
	MX7D_PAD_GPIO1_IO04__UART5_CTS_B                         = IOMUX_PAD(0x0040, 0x0010, IOMUX_CONFIG_LPSR | 3, 0x0710, 4, 0),
	MX7D_PAD_GPIO1_IO04__I2C1_SCL                            = IOMUX_PAD(0x0040, 0x0010, IOMUX_CONFIG_LPSR | IOMUX_CONFIG_SION | 4, 0x05D4, 2, 0),

	MX7D_PAD_GPIO1_IO05__GPIO1_IO5                           = IOMUX_PAD(0x0044, 0x0014, IOMUX_CONFIG_LPSR | 0, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO05__USB_OTG1_PWR                        = IOMUX_PAD(0x0044, 0x0014, IOMUX_CONFIG_LPSR | 1, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO05__FLEXTIMER1_CH5                      = IOMUX_PAD(0x0044, 0x0014, IOMUX_CONFIG_LPSR | 2, 0x0598, 1, 0),
	MX7D_PAD_GPIO1_IO05__UART5_RTS_B                         = IOMUX_PAD(0x0044, 0x0014, IOMUX_CONFIG_LPSR | 3, 0x0710, 5, 0),
	MX7D_PAD_GPIO1_IO05__I2C1_SDA                            = IOMUX_PAD(0x0044, 0x0014, IOMUX_CONFIG_LPSR | IOMUX_CONFIG_SION | 4, 0x05D8, 2, 0),

	MX7D_PAD_GPIO1_IO06__GPIO1_IO6                           = IOMUX_PAD(0x0048, 0x0018, IOMUX_CONFIG_LPSR | 0, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO06__USB_OTG2_OC                         = IOMUX_PAD(0x0048, 0x0018, IOMUX_CONFIG_LPSR | 1, 0x0728, 1, 0),
	MX7D_PAD_GPIO1_IO06__FLEXTIMER1_CH6                      = IOMUX_PAD(0x0048, 0x0018, IOMUX_CONFIG_LPSR | 2, 0x059C, 1, 0),
	MX7D_PAD_GPIO1_IO06__UART5_RX_DATA                       = IOMUX_PAD(0x0048, 0x0018, IOMUX_CONFIG_LPSR | 3, 0x0714, 4, 0),
	MX7D_PAD_GPIO1_IO06__I2C2_SCL                            = IOMUX_PAD(0x0048, 0x0018, IOMUX_CONFIG_LPSR | IOMUX_CONFIG_SION | 4, 0x05DC, 2, 0),
	MX7D_PAD_GPIO1_IO06__CCM_WAIT				 = IOMUX_PAD(0x0048, 0x0018, IOMUX_CONFIG_LPSR | 5, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO06__KPP_ROW4				 = IOMUX_PAD(0x0048, 0x0018, IOMUX_CONFIG_LPSR | 6, 0x0624, 1, 0),

	MX7D_PAD_GPIO1_IO07__GPIO1_IO7                           = IOMUX_PAD(0x004c, 0x001c, IOMUX_CONFIG_LPSR | 0, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO07__USB_OTG2_PWR                        = IOMUX_PAD(0x004c, 0x001c, IOMUX_CONFIG_LPSR | 1, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO07__FLEXTIMER1_CH7                      = IOMUX_PAD(0x004c, 0x001c, IOMUX_CONFIG_LPSR | 2, 0x05A0, 1, 0),
	MX7D_PAD_GPIO1_IO07__UART5_TX_DATA                       = IOMUX_PAD(0x004c, 0x001c, IOMUX_CONFIG_LPSR | 3, 0x0714, 5, 0),
	MX7D_PAD_GPIO1_IO07__I2C2_SDA                            = IOMUX_PAD(0x004c, 0x001c, IOMUX_CONFIG_LPSR | IOMUX_CONFIG_SION | 4, 0x05E0, 2, 0),
	MX7D_PAD_GPIO1_IO07__CCM_STOP				 = IOMUX_PAD(0x004c, 0x001c, IOMUX_CONFIG_LPSR | 5, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO07__KPP_COL4				 = IOMUX_PAD(0x004c, 0x001c, IOMUX_CONFIG_LPSR | 6, 0x0604, 1, 0),
};

enum {
	MX7D_PAD_GPIO1_IO08__GPIO1_IO8                           = IOMUX_PAD(0x026C, 0x0014, 0, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO08__SD1_VSELECT                         = IOMUX_PAD(0x026C, 0x0014, 1, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO08__WDOG1_WDOG_B                        = IOMUX_PAD(0x026C, 0x0014, 2, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO08__UART3_DCE_RX                        = IOMUX_PAD(0x026C, 0x0014, 3, 0x0704, 0, 0),
	MX7D_PAD_GPIO1_IO08__UART3_DTE_TX                        = IOMUX_PAD(0x026C, 0x0014, 3, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO08__I2C3_SCL                            = IOMUX_PAD(0x026C, 0x0014, IOMUX_CONFIG_SION | 4, 0x05E4, 0, 0),
	MX7D_PAD_GPIO1_IO08__KPP_COL5                            = IOMUX_PAD(0x026C, 0x0014, 6, 0x0608, 0, 0),
	MX7D_PAD_GPIO1_IO08__PWM1_OUT                            = IOMUX_PAD(0x026C, 0x0014, 7, 0x0000, 0, 0),

	MX7D_PAD_GPIO1_IO09__GPIO1_IO9                           = IOMUX_PAD(0x0270, 0x0018, 0, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO09__SD1_LCTL                            = IOMUX_PAD(0x0270, 0x0018, 1, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO09__CCM_ENET_REF_CLK3                   = IOMUX_PAD(0x0270, 0x0018, 2, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO09__UART3_DCE_TX                        = IOMUX_PAD(0x0270, 0x0018, 3, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO09__UART3_DTE_RX                        = IOMUX_PAD(0x0270, 0x0018, 3, 0x0704, 1, 0),
	MX7D_PAD_GPIO1_IO09__I2C3_SDA                            = IOMUX_PAD(0x0270, 0x0018, IOMUX_CONFIG_SION | 4, 0x05E8, 0, 0),
	MX7D_PAD_GPIO1_IO09__CCM_PMIC_READY                      = IOMUX_PAD(0x0270, 0x0018, 5, 0x04F4, 0, 0),
	MX7D_PAD_GPIO1_IO09__KPP_ROW5                            = IOMUX_PAD(0x0270, 0x0018, 6, 0x0628, 0, 0),
	MX7D_PAD_GPIO1_IO09__PWM2_OUT                            = IOMUX_PAD(0x0270, 0x0018, 7, 0x0000, 0, 0),

	MX7D_PAD_GPIO1_IO10__GPIO1_IO10                          = IOMUX_PAD(0x0274, 0x001C, 0, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO10__SD2_LCTL                            = IOMUX_PAD(0x0274, 0x001C, 1, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO10__ENET1_MDIO                          = IOMUX_PAD(0x0274, 0x001C, 2, 0x0568, 0, 0),
	MX7D_PAD_GPIO1_IO10__UART3_DCE_RTS                       = IOMUX_PAD(0x0274, 0x001C, 3, 0x0700, 0, 0),
	MX7D_PAD_GPIO1_IO10__UART3_DTE_CTS                       = IOMUX_PAD(0x0274, 0x001C, 3, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO10__I2C4_SCL                            = IOMUX_PAD(0x0274, 0x001C, IOMUX_CONFIG_SION | 4, 0x05EC, 0, 0),
	MX7D_PAD_GPIO1_IO10__FLEXTIMER1_PHA                      = IOMUX_PAD(0x0274, 0x001C, 5, 0x05A4, 0, 0),
	MX7D_PAD_GPIO1_IO10__KPP_COL6                            = IOMUX_PAD(0x0274, 0x001C, 6, 0x060C, 0, 0),
	MX7D_PAD_GPIO1_IO10__PWM3_OUT                            = IOMUX_PAD(0x0274, 0x001C, 7, 0x0000, 0, 0),

	MX7D_PAD_GPIO1_IO11__GPIO1_IO11                          = IOMUX_PAD(0x0278, 0x0020, 0, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO11__SD3_LCTL                            = IOMUX_PAD(0x0278, 0x0020, 1, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO11__ENET1_MDC                           = IOMUX_PAD(0x0278, 0x0020, 2, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO11__UART3_DCE_CTS                       = IOMUX_PAD(0x0278, 0x0020, 3, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO11__UART3_DTE_RTS                       = IOMUX_PAD(0x0278, 0x0020, 3, 0x0700, 1, 0),
	MX7D_PAD_GPIO1_IO11__I2C4_SDA                            = IOMUX_PAD(0x0278, 0x0020, IOMUX_CONFIG_SION | 4, 0x05F0, 0, 0),
	MX7D_PAD_GPIO1_IO11__FLEXTIMER1_PHB                      = IOMUX_PAD(0x0278, 0x0020, 5, 0x05A8, 0, 0),
	MX7D_PAD_GPIO1_IO11__KPP_ROW6                            = IOMUX_PAD(0x0278, 0x0020, 6, 0x062C, 0, 0),
	MX7D_PAD_GPIO1_IO11__PWM4_OUT                            = IOMUX_PAD(0x0278, 0x0020, 7, 0x0000, 0, 0),

	MX7D_PAD_GPIO1_IO12__GPIO1_IO12                          = IOMUX_PAD(0x027C, 0x0024, 0, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO12__SD2_VSELECT                         = IOMUX_PAD(0x027C, 0x0024, 1, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO12__CCM_ENET_REF_CLK1                   = IOMUX_PAD(0x027C, 0x0024, 2, 0x0564, 0, 0),
	MX7D_PAD_GPIO1_IO12__FLEXCAN1_RX                         = IOMUX_PAD(0x027C, 0x0024, 3, 0x04DC, 0, 0),
	MX7D_PAD_GPIO1_IO12__CM4_NMI                             = IOMUX_PAD(0x027C, 0x0024, 4, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO12__CCM_EXT_CLK1                        = IOMUX_PAD(0x027C, 0x0024, 5, 0x04E4, 0, 0),
	MX7D_PAD_GPIO1_IO12__SNVS_VIO_5                          = IOMUX_PAD(0x027C, 0x0024, 6, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO12__USB_OTG1_ID                         = IOMUX_PAD(0x027C, 0x0024, 7, 0x0734, 0, 0),

	MX7D_PAD_GPIO1_IO13__GPIO1_IO13                          = IOMUX_PAD(0x0280, 0x0028, 0, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO13__SD3_VSELECT                         = IOMUX_PAD(0x0280, 0x0028, 1, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO13__CCM_ENET_REF_CLK2                   = IOMUX_PAD(0x0280, 0x0028, 2, 0x0570, 0, 0),
	MX7D_PAD_GPIO1_IO13__FLEXCAN1_TX                         = IOMUX_PAD(0x0280, 0x0028, 3, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO13__CCM_PMIC_READY                      = IOMUX_PAD(0x0280, 0x0028, 4, 0x04F4, 1, 0),
	MX7D_PAD_GPIO1_IO13__CCM_EXT_CLK2                        = IOMUX_PAD(0x0280, 0x0028, 5, 0x04E8, 0, 0),
	MX7D_PAD_GPIO1_IO13__SNVS_VIO_5_CTL                      = IOMUX_PAD(0x0280, 0x0028, 6, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO13__USB_OTG2_ID                         = IOMUX_PAD(0x0280, 0x0028, 7, 0x0730, 0, 0),

	MX7D_PAD_GPIO1_IO14__GPIO1_IO14                          = IOMUX_PAD(0x0284, 0x002C, 0, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO14__SD3_CD_B                            = IOMUX_PAD(0x0284, 0x002C, 1, 0x0738, 0, 0),
	MX7D_PAD_GPIO1_IO14__ENET2_MDIO                          = IOMUX_PAD(0x0284, 0x002C, 2, 0x0574, 0, 0),
	MX7D_PAD_GPIO1_IO14__FLEXCAN2_RX                         = IOMUX_PAD(0x0284, 0x002C, 3, 0x04E0, 0, 0),
	MX7D_PAD_GPIO1_IO14__WDOG3_WDOG_B                        = IOMUX_PAD(0x0284, 0x002C, 4, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO14__CCM_EXT_CLK3                        = IOMUX_PAD(0x0284, 0x002C, 5, 0x04EC, 0, 0),
	MX7D_PAD_GPIO1_IO14__SDMA_EXT_EVENT0                     = IOMUX_PAD(0x0284, 0x002C, 6, 0x06D8, 0, 0),

	MX7D_PAD_GPIO1_IO15__GPIO1_IO15                          = IOMUX_PAD(0x0288, 0x0030, 0, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO15__SD3_WP                              = IOMUX_PAD(0x0288, 0x0030, 1, 0x073C, 0, 0),
	MX7D_PAD_GPIO1_IO15__ENET2_MDC                           = IOMUX_PAD(0x0288, 0x0030, 2, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO15__FLEXCAN2_TX                         = IOMUX_PAD(0x0288, 0x0030, 3, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO15__WDOG4_WDOG_B                        = IOMUX_PAD(0x0288, 0x0030, 4, 0x0000, 0, 0),
	MX7D_PAD_GPIO1_IO15__CCM_EXT_CLK4                        = IOMUX_PAD(0x0288, 0x0030, 5, 0x04F0, 0, 0),
	MX7D_PAD_GPIO1_IO15__SDMA_EXT_EVENT1                     = IOMUX_PAD(0x0288, 0x0030, 6, 0x06DC, 0, 0),

	MX7D_PAD_EPDC_DATA00__EPDC_DATA0                         = IOMUX_PAD(0x02A4, 0x0034, 0, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA00__SIM1_PORT2_TRXD                    = IOMUX_PAD(0x02A4, 0x0034, 1, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA00__QSPI_A_DATA0                       = IOMUX_PAD(0x02A4, 0x0034, 2, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA00__KPP_ROW3                           = IOMUX_PAD(0x02A4, 0x0034, 3, 0x0620, 0, 0),
	MX7D_PAD_EPDC_DATA00__EIM_AD0                            = IOMUX_PAD(0x02A4, 0x0034, 4, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA00__GPIO2_IO0                          = IOMUX_PAD(0x02A4, 0x0034, 5, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA00__LCD_DATA0                          = IOMUX_PAD(0x02A4, 0x0034, 6, 0x0638, 0, 0),
	MX7D_PAD_EPDC_DATA00__LCD_CLK                            = IOMUX_PAD(0x02A4, 0x0034, 7, 0x0000, 0, 0),

	MX7D_PAD_EPDC_DATA01__EPDC_DATA1                         = IOMUX_PAD(0x02A8, 0x0038, 0, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA01__SIM1_PORT2_CLK                     = IOMUX_PAD(0x02A8, 0x0038, 1, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA01__QSPI_A_DATA1                       = IOMUX_PAD(0x02A8, 0x0038, 2, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA01__KPP_COL3                           = IOMUX_PAD(0x02A8, 0x0038, 3, 0x0600, 0, 0),
	MX7D_PAD_EPDC_DATA01__EIM_AD1                            = IOMUX_PAD(0x02A8, 0x0038, 4, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA01__GPIO2_IO1                          = IOMUX_PAD(0x02A8, 0x0038, 5, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA01__LCD_DATA1                          = IOMUX_PAD(0x02A8, 0x0038, 6, 0x063C, 0, 0),
	MX7D_PAD_EPDC_DATA01__LCD_ENABLE                         = IOMUX_PAD(0x02A8, 0x0038, 7, 0x0000, 0, 0),

	MX7D_PAD_EPDC_DATA02__EPDC_DATA2                         = IOMUX_PAD(0x02AC, 0x003C, 0, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA02__SIM1_PORT2_RST_B                   = IOMUX_PAD(0x02AC, 0x003C, 1, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA02__QSPI_A_DATA2                       = IOMUX_PAD(0x02AC, 0x003C, 2, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA02__KPP_ROW2                           = IOMUX_PAD(0x02AC, 0x003C, 3, 0x061C, 0, 0),
	MX7D_PAD_EPDC_DATA02__EIM_AD2                            = IOMUX_PAD(0x02AC, 0x003C, 4, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA02__GPIO2_IO2                          = IOMUX_PAD(0x02AC, 0x003C, 5, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA02__LCD_DATA2                          = IOMUX_PAD(0x02AC, 0x003C, 6, 0x0640, 0, 0),
	MX7D_PAD_EPDC_DATA02__LCD_VSYNC                          = IOMUX_PAD(0x02AC, 0x003C, 7, 0x0698, 0, 0),

	MX7D_PAD_EPDC_DATA03__EPDC_DATA3                         = IOMUX_PAD(0x02B0, 0x0040, 0, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA03__SIM1_PORT2_SVEN                    = IOMUX_PAD(0x02B0, 0x0040, 1, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA03__QSPI_A_DATA3                       = IOMUX_PAD(0x02B0, 0x0040, 2, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA03__KPP_COL2                           = IOMUX_PAD(0x02B0, 0x0040, 3, 0x05FC, 0, 0),
	MX7D_PAD_EPDC_DATA03__EIM_AD3                            = IOMUX_PAD(0x02B0, 0x0040, 4, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA03__GPIO2_IO3                          = IOMUX_PAD(0x02B0, 0x0040, 5, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA03__LCD_DATA3                          = IOMUX_PAD(0x02B0, 0x0040, 6, 0x0644, 0, 0),
	MX7D_PAD_EPDC_DATA03__LCD_HSYNC                          = IOMUX_PAD(0x02B0, 0x0040, 7, 0x0000, 0, 0),

	MX7D_PAD_EPDC_DATA04__EPDC_DATA4                         = IOMUX_PAD(0x02B4, 0x0044, 0, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA04__SIM1_PORT2_PD                      = IOMUX_PAD(0x02B4, 0x0044, 1, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA04__QSPI_A_DQS                         = IOMUX_PAD(0x02B4, 0x0044, 2, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA04__KPP_ROW1                           = IOMUX_PAD(0x02B4, 0x0044, 3, 0x0618, 0, 0),
	MX7D_PAD_EPDC_DATA04__EIM_AD4                            = IOMUX_PAD(0x02B4, 0x0044, 4, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA04__GPIO2_IO4                          = IOMUX_PAD(0x02B4, 0x0044, 5, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA04__LCD_DATA4                          = IOMUX_PAD(0x02B4, 0x0044, 6, 0x0648, 0, 0),
	MX7D_PAD_EPDC_DATA04__JTAG_FAIL                          = IOMUX_PAD(0x02B4, 0x0044, 7, 0x0000, 0, 0),

	MX7D_PAD_EPDC_DATA05__EPDC_DATA5                         = IOMUX_PAD(0x02B8, 0x0048, 0, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA05__SIM2_PORT2_TRXD                    = IOMUX_PAD(0x02B8, 0x0048, 1, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA05__QSPI_A_SCLK                        = IOMUX_PAD(0x02B8, 0x0048, 2, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA05__KPP_COL1                           = IOMUX_PAD(0x02B8, 0x0048, 3, 0x05F8, 0, 0),
	MX7D_PAD_EPDC_DATA05__EIM_AD5                            = IOMUX_PAD(0x02B8, 0x0048, 4, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA05__GPIO2_IO5                          = IOMUX_PAD(0x02B8, 0x0048, 5, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA05__LCD_DATA5                          = IOMUX_PAD(0x02B8, 0x0048, 6, 0x064C, 0, 0),
	MX7D_PAD_EPDC_DATA05__JTAG_ACTIVE                        = IOMUX_PAD(0x02B8, 0x0048, 7, 0x0000, 0, 0),

	MX7D_PAD_EPDC_DATA06__EPDC_DATA6                         = IOMUX_PAD(0x02BC, 0x004C, 0, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA06__SIM2_PORT2_CLK                     = IOMUX_PAD(0x02BC, 0x004C, 1, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA06__QSPI_A_SS0_B                       = IOMUX_PAD(0x02BC, 0x004C, 2, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA06__KPP_ROW0                           = IOMUX_PAD(0x02BC, 0x004C, 3, 0x0614, 0, 0),
	MX7D_PAD_EPDC_DATA06__EIM_AD6                            = IOMUX_PAD(0x02BC, 0x004C, 4, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA06__GPIO2_IO6                          = IOMUX_PAD(0x02BC, 0x004C, 5, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA06__LCD_DATA6                          = IOMUX_PAD(0x02BC, 0x004C, 6, 0x0650, 0, 0),
	MX7D_PAD_EPDC_DATA06__JTAG_DE_B                          = IOMUX_PAD(0x02BC, 0x004C, 7, 0x0000, 0, 0),

	MX7D_PAD_EPDC_DATA07__EPDC_DATA7                         = IOMUX_PAD(0x02C0, 0x0050, 0, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA07__SIM2_PORT2_RST_B                   = IOMUX_PAD(0x02C0, 0x0050, 1, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA07__QSPI_A_SS1_B                       = IOMUX_PAD(0x02C0, 0x0050, 2, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA07__KPP_COL0                           = IOMUX_PAD(0x02C0, 0x0050, 3, 0x05F4, 0, 0),
	MX7D_PAD_EPDC_DATA07__EIM_AD7                            = IOMUX_PAD(0x02C0, 0x0050, 4, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA07__GPIO2_IO7                          = IOMUX_PAD(0x02C0, 0x0050, 5, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA07__LCD_DATA7                          = IOMUX_PAD(0x02C0, 0x0050, 6, 0x0654, 0, 0),
	MX7D_PAD_EPDC_DATA07__JTAG_DONE                          = IOMUX_PAD(0x02C0, 0x0050, 7, 0x0000, 0, 0),

	MX7D_PAD_EPDC_DATA08__EPDC_DATA8                         = IOMUX_PAD(0x02C4, 0x0054, 0, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA08__SIM1_PORT1_TRXD                    = IOMUX_PAD(0x02C4, 0x0054, 1, 0x06E4, 0, 0),
	MX7D_PAD_EPDC_DATA08__QSPI_B_DATA0                       = IOMUX_PAD(0x02C4, 0x0054, 2, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA08__UART6_DCE_RX                       = IOMUX_PAD(0x02C4, 0x0054, 3, 0x071C, 0, 0),
	MX7D_PAD_EPDC_DATA08__UART6_DTE_TX                       = IOMUX_PAD(0x02C4, 0x0054, 3, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA08__EIM_OE                             = IOMUX_PAD(0x02C4, 0x0054, 4, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA08__GPIO2_IO8                          = IOMUX_PAD(0x02C4, 0x0054, 5, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA08__LCD_DATA8                          = IOMUX_PAD(0x02C4, 0x0054, 6, 0x0658, 0, 0),
	MX7D_PAD_EPDC_DATA08__LCD_BUSY                           = IOMUX_PAD(0x02C4, 0x0054, 7, 0x0634, 0, 0),
	MX7D_PAD_EPDC_DATA08__EPDC_SDCLK                         = IOMUX_PAD(0x02C4, 0x0054, 8, 0x0000, 0, 0),

	MX7D_PAD_EPDC_DATA09__EPDC_DATA9                         = IOMUX_PAD(0x02C8, 0x0058, 0, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA09__SIM1_PORT1_CLK                     = IOMUX_PAD(0x02C8, 0x0058, 1, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA09__QSPI_B_DATA1                       = IOMUX_PAD(0x02C8, 0x0058, 2, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA09__UART6_DCE_TX                       = IOMUX_PAD(0x02C8, 0x0058, 3, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA09__UART6_DTE_RX                       = IOMUX_PAD(0x02C8, 0x0058, 3, 0x071C, 1, 0),
	MX7D_PAD_EPDC_DATA09__EIM_RW                             = IOMUX_PAD(0x02C8, 0x0058, 4, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA09__GPIO2_IO9                          = IOMUX_PAD(0x02C8, 0x0058, 5, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA09__LCD_DATA9                          = IOMUX_PAD(0x02C8, 0x0058, 6, 0x065C, 0, 0),
	MX7D_PAD_EPDC_DATA09__LCD_DATA0                          = IOMUX_PAD(0x02C8, 0x0058, 7, 0x0638, 1, 0),
	MX7D_PAD_EPDC_DATA09__EPDC_SDLE                          = IOMUX_PAD(0x02C8, 0x0058, 8, 0x0000, 0, 0),

	MX7D_PAD_EPDC_DATA10__EPDC_DATA10                        = IOMUX_PAD(0x02CC, 0x005C, 0, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA10__SIM1_PORT1_RST_B                   = IOMUX_PAD(0x02CC, 0x005C, 1, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA10__QSPI_B_DATA2                       = IOMUX_PAD(0x02CC, 0x005C, 2, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA10__UART6_DCE_RTS                      = IOMUX_PAD(0x02CC, 0x005C, 3, 0x0718, 0, 0),
	MX7D_PAD_EPDC_DATA10__UART6_DTE_CTS                      = IOMUX_PAD(0x02CC, 0x005C, 3, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA10__EIM_CS0_B                          = IOMUX_PAD(0x02CC, 0x005C, 4, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA10__GPIO2_IO10                         = IOMUX_PAD(0x02CC, 0x005C, 5, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA10__LCD_DATA10                         = IOMUX_PAD(0x02CC, 0x005C, 6, 0x0660, 0, 0),
	MX7D_PAD_EPDC_DATA10__LCD_DATA9                          = IOMUX_PAD(0x02CC, 0x005C, 7, 0x065C, 1, 0),
	MX7D_PAD_EPDC_DATA10__EPDC_SDOE                          = IOMUX_PAD(0x02CC, 0x005C, 8, 0x0000, 0, 0),

	MX7D_PAD_EPDC_DATA11__EPDC_DATA11                        = IOMUX_PAD(0x02D0, 0x0060, 0, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA11__SIM1_PORT1_SVEN                    = IOMUX_PAD(0x02D0, 0x0060, 1, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA11__QSPI_B_DATA3                       = IOMUX_PAD(0x02D0, 0x0060, 2, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA11__UART6_DCE_CTS                      = IOMUX_PAD(0x02D0, 0x0060, 3, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA11__UART6_DTE_RTS                      = IOMUX_PAD(0x02D0, 0x0060, 3, 0x0718, 1, 0),
	MX7D_PAD_EPDC_DATA11__EIM_BCLK                           = IOMUX_PAD(0x02D0, 0x0060, 4, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA11__GPIO2_IO11                         = IOMUX_PAD(0x02D0, 0x0060, 5, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA11__LCD_DATA11                         = IOMUX_PAD(0x02D0, 0x0060, 6, 0x0664, 0, 0),
	MX7D_PAD_EPDC_DATA11__LCD_DATA1                          = IOMUX_PAD(0x02D0, 0x0060, 7, 0x063C, 1, 0),
	MX7D_PAD_EPDC_DATA11__EPDC_SDCE0                         = IOMUX_PAD(0x02D0, 0x0060, 8, 0x0000, 0, 0),

	MX7D_PAD_EPDC_DATA12__EPDC_DATA12                        = IOMUX_PAD(0x02D4, 0x0064, 0, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA12__SIM1_PORT1_PD                      = IOMUX_PAD(0x02D4, 0x0064, 1, 0x06E0, 0, 0),
	MX7D_PAD_EPDC_DATA12__QSPI_B_DQS                         = IOMUX_PAD(0x02D4, 0x0064, 2, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA12__UART7_DCE_RX                       = IOMUX_PAD(0x02D4, 0x0064, 3, 0x0724, 0, 0),
	MX7D_PAD_EPDC_DATA12__UART7_DTE_TX                       = IOMUX_PAD(0x02D4, 0x0064, 3, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA12__EIM_LBA_B                          = IOMUX_PAD(0x02D4, 0x0064, 4, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA12__GPIO2_IO12                         = IOMUX_PAD(0x02D4, 0x0064, 5, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA12__LCD_DATA12                         = IOMUX_PAD(0x02D4, 0x0064, 6, 0x0668, 0, 0),
	MX7D_PAD_EPDC_DATA12__LCD_DATA21                         = IOMUX_PAD(0x02D4, 0x0064, 7, 0x068C, 0, 0),
	MX7D_PAD_EPDC_DATA12__EPDC_GDCLK                         = IOMUX_PAD(0x02D4, 0x0064, 8, 0x0000, 0, 0),

	MX7D_PAD_EPDC_DATA13__EPDC_DATA13                        = IOMUX_PAD(0x02D8, 0x0068, 0, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA13__SIM2_PORT1_TRXD                    = IOMUX_PAD(0x02D8, 0x0068, 1, 0x06EC, 0, 0),
	MX7D_PAD_EPDC_DATA13__QSPI_B_SCLK                        = IOMUX_PAD(0x02D8, 0x0068, 2, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA13__UART7_DCE_TX                       = IOMUX_PAD(0x02D8, 0x0068, 3, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA13__UART7_DTE_RX                       = IOMUX_PAD(0x02D8, 0x0068, 3, 0x0724, 1, 0),
	MX7D_PAD_EPDC_DATA13__EIM_WAIT                           = IOMUX_PAD(0x02D8, 0x0068, 4, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA13__GPIO2_IO13                         = IOMUX_PAD(0x02D8, 0x0068, 5, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA13__LCD_DATA13                         = IOMUX_PAD(0x02D8, 0x0068, 6, 0x066C, 0, 0),
	MX7D_PAD_EPDC_DATA13__LCD_CS                             = IOMUX_PAD(0x02D8, 0x0068, 7, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA13__EPDC_GDOE                          = IOMUX_PAD(0x02D8, 0x0068, 8, 0x0000, 0, 0),

	MX7D_PAD_EPDC_DATA14__EPDC_DATA14                        = IOMUX_PAD(0x02DC, 0x006C, 0, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA14__SIM2_PORT1_CLK                     = IOMUX_PAD(0x02DC, 0x006C, 1, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA14__QSPI_B_SS0_B                       = IOMUX_PAD(0x02DC, 0x006C, 2, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA14__UART7_DCE_RTS                      = IOMUX_PAD(0x02DC, 0x006C, 3, 0x0720, 0, 0),
	MX7D_PAD_EPDC_DATA14__UART7_DTE_CTS                      = IOMUX_PAD(0x02DC, 0x006C, 3, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA14__EIM_EB_B0                          = IOMUX_PAD(0x02DC, 0x006C, 4, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA14__GPIO2_IO14                         = IOMUX_PAD(0x02DC, 0x006C, 5, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA14__LCD_DATA14                         = IOMUX_PAD(0x02DC, 0x006C, 6, 0x0670, 0, 0),
	MX7D_PAD_EPDC_DATA14__LCD_DATA22                         = IOMUX_PAD(0x02DC, 0x006C, 7, 0x0690, 0, 0),
	MX7D_PAD_EPDC_DATA14__EPDC_GDSP                          = IOMUX_PAD(0x02DC, 0x006C, 8, 0x0000, 0, 0),

	MX7D_PAD_EPDC_DATA15__EPDC_DATA15                        = IOMUX_PAD(0x02E0, 0x0070, 0, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA15__SIM2_PORT1_RST_B                   = IOMUX_PAD(0x02E0, 0x0070, 1, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA15__QSPI_B_SS1_B                       = IOMUX_PAD(0x02E0, 0x0070, 2, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA15__UART7_DCE_CTS                      = IOMUX_PAD(0x02E0, 0x0070, 3, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA15__UART7_DTE_RTS                      = IOMUX_PAD(0x02E0, 0x0070, 3, 0x0720, 1, 0),
	MX7D_PAD_EPDC_DATA15__EIM_CS1_B                          = IOMUX_PAD(0x02E0, 0x0070, 4, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA15__GPIO2_IO15                         = IOMUX_PAD(0x02E0, 0x0070, 5, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA15__LCD_DATA15                         = IOMUX_PAD(0x02E0, 0x0070, 6, 0x0674, 0, 0),
	MX7D_PAD_EPDC_DATA15__LCD_WR_RWN                         = IOMUX_PAD(0x02E0, 0x0070, 7, 0x0000, 0, 0),
	MX7D_PAD_EPDC_DATA15__EPDC_PWR_COM                       = IOMUX_PAD(0x02E0, 0x0070, 8, 0x0000, 0, 0),

	MX7D_PAD_EPDC_SDCLK__EPDC_SDCLK                          = IOMUX_PAD(0x02E4, 0x0074, 0, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDCLK__SIM2_PORT2_SVEN                     = IOMUX_PAD(0x02E4, 0x0074, 1, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDCLK__ENET2_RGMII_RD0                     = IOMUX_PAD(0x02E4, 0x0074, 2, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDCLK__KPP_ROW4                            = IOMUX_PAD(0x02E4, 0x0074, 3, 0x0624, 0, 0),
	MX7D_PAD_EPDC_SDCLK__EIM_AD10                            = IOMUX_PAD(0x02E4, 0x0074, 4, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDCLK__GPIO2_IO16                          = IOMUX_PAD(0x02E4, 0x0074, 5, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDCLK__LCD_CLK                             = IOMUX_PAD(0x02E4, 0x0074, 6, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDCLK__LCD_DATA20                          = IOMUX_PAD(0x02E4, 0x0074, 7, 0x0688, 0, 0),

	MX7D_PAD_EPDC_SDLE__EPDC_SDLE                            = IOMUX_PAD(0x02E8, 0x0078, 0, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDLE__SIM2_PORT2_PD                        = IOMUX_PAD(0x02E8, 0x0078, 1, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDLE__ENET2_RGMII_RD1                      = IOMUX_PAD(0x02E8, 0x0078, 2, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDLE__KPP_COL4                             = IOMUX_PAD(0x02E8, 0x0078, 3, 0x0604, 0, 0),
	MX7D_PAD_EPDC_SDLE__EIM_AD11                             = IOMUX_PAD(0x02E8, 0x0078, 4, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDLE__GPIO2_IO17                           = IOMUX_PAD(0x02E8, 0x0078, 5, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDLE__LCD_DATA16                           = IOMUX_PAD(0x02E8, 0x0078, 6, 0x0678, 0, 0),
	MX7D_PAD_EPDC_SDLE__LCD_DATA8                            = IOMUX_PAD(0x02E8, 0x0078, 7, 0x0658, 1, 0),

	MX7D_PAD_EPDC_SDOE__EPDC_SDOE                            = IOMUX_PAD(0x02EC, 0x007C, 0, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDOE__FLEXTIMER1_CH0                       = IOMUX_PAD(0x02EC, 0x007C, 1, 0x0584, 0, 0),
	MX7D_PAD_EPDC_SDOE__ENET2_RGMII_RD2                      = IOMUX_PAD(0x02EC, 0x007C, 2, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDOE__KPP_COL5                             = IOMUX_PAD(0x02EC, 0x007C, 3, 0x0608, 1, 0),
	MX7D_PAD_EPDC_SDOE__EIM_AD12                             = IOMUX_PAD(0x02EC, 0x007C, 4, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDOE__GPIO2_IO18                           = IOMUX_PAD(0x02EC, 0x007C, 5, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDOE__LCD_DATA17                           = IOMUX_PAD(0x02EC, 0x007C, 6, 0x067C, 0, 0),
	MX7D_PAD_EPDC_SDOE__LCD_DATA23                           = IOMUX_PAD(0x02EC, 0x007C, 7, 0x0694, 0, 0),

	MX7D_PAD_EPDC_SDSHR__EPDC_SDSHR                          = IOMUX_PAD(0x02F0, 0x0080, 0, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDSHR__FLEXTIMER1_CH1                      = IOMUX_PAD(0x02F0, 0x0080, 1, 0x0588, 0, 0),
	MX7D_PAD_EPDC_SDSHR__ENET2_RGMII_RD3                     = IOMUX_PAD(0x02F0, 0x0080, 2, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDSHR__KPP_ROW5                            = IOMUX_PAD(0x02F0, 0x0080, 3, 0x0628, 1, 0),
	MX7D_PAD_EPDC_SDSHR__EIM_AD13                            = IOMUX_PAD(0x02F0, 0x0080, 4, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDSHR__GPIO2_IO19                          = IOMUX_PAD(0x02F0, 0x0080, 5, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDSHR__LCD_DATA18                          = IOMUX_PAD(0x02F0, 0x0080, 6, 0x0680, 0, 0),
	MX7D_PAD_EPDC_SDSHR__LCD_DATA10                          = IOMUX_PAD(0x02F0, 0x0080, 7, 0x0660, 1, 0),

	MX7D_PAD_EPDC_SDCE0__EPDC_SDCE0                          = IOMUX_PAD(0x02F4, 0x0084, 0, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDCE0__FLEXTIMER1_CH2                      = IOMUX_PAD(0x02F4, 0x0084, 1, 0x058C, 0, 0),
	MX7D_PAD_EPDC_SDCE0__ENET2_RGMII_RX_CTL                  = IOMUX_PAD(0x02F4, 0x0084, 2, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDCE0__EIM_AD14                            = IOMUX_PAD(0x02F4, 0x0084, 4, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDCE0__GPIO2_IO20                          = IOMUX_PAD(0x02F4, 0x0084, 5, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDCE0__LCD_DATA19                          = IOMUX_PAD(0x02F4, 0x0084, 6, 0x0684, 0, 0),
	MX7D_PAD_EPDC_SDCE0__LCD_DATA5                           = IOMUX_PAD(0x02F4, 0x0084, 7, 0x064C, 1, 0),

	MX7D_PAD_EPDC_SDCE1__EPDC_SDCE1                          = IOMUX_PAD(0x02F8, 0x0088, 0, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDCE1__FLEXTIMER1_CH3                      = IOMUX_PAD(0x02F8, 0x0088, 1, 0x0590, 0, 0),
	MX7D_PAD_EPDC_SDCE1__ENET2_RGMII_RXC                     = IOMUX_PAD(0x02F8, 0x0088, 2, 0x0578, 0, 0),
	MX7D_PAD_EPDC_SDCE1__ENET2_RX_ER                         = IOMUX_PAD(0x02F8, 0x0088, 3, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDCE1__EIM_AD15                            = IOMUX_PAD(0x02F8, 0x0088, 4, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDCE1__GPIO2_IO21                          = IOMUX_PAD(0x02F8, 0x0088, 5, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDCE1__LCD_DATA20                          = IOMUX_PAD(0x02F8, 0x0088, 6, 0x0688, 1, 0),
	MX7D_PAD_EPDC_SDCE1__LCD_DATA4                           = IOMUX_PAD(0x02F8, 0x0088, 7, 0x0648, 1, 0),

	MX7D_PAD_EPDC_SDCE2__EPDC_SDCE2                          = IOMUX_PAD(0x02FC, 0x008C, 0, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDCE2__SIM2_PORT1_SVEN                     = IOMUX_PAD(0x02FC, 0x008C, 1, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDCE2__ENET2_RGMII_TD0                     = IOMUX_PAD(0x02FC, 0x008C, 2, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDCE2__KPP_COL6                            = IOMUX_PAD(0x02FC, 0x008C, 3, 0x060C, 1, 0),
	MX7D_PAD_EPDC_SDCE2__EIM_ADDR16                          = IOMUX_PAD(0x02FC, 0x008C, 4, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDCE2__GPIO2_IO22                          = IOMUX_PAD(0x02FC, 0x008C, 5, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDCE2__LCD_DATA21                          = IOMUX_PAD(0x02FC, 0x008C, 6, 0x068C, 1, 0),
	MX7D_PAD_EPDC_SDCE2__LCD_DATA3                           = IOMUX_PAD(0x02FC, 0x008C, 7, 0x0644, 1, 0),

	MX7D_PAD_EPDC_SDCE3__EPDC_SDCE3                          = IOMUX_PAD(0x0300, 0x0090, 0, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDCE3__SIM2_PORT1_PD                       = IOMUX_PAD(0x0300, 0x0090, 1, 0x06E8, 0, 0),
	MX7D_PAD_EPDC_SDCE3__ENET2_RGMII_TD1                     = IOMUX_PAD(0x0300, 0x0090, 2, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDCE3__KPP_ROW6                            = IOMUX_PAD(0x0300, 0x0090, 3, 0x062C, 1, 0),
	MX7D_PAD_EPDC_SDCE3__EIM_ADDR17                          = IOMUX_PAD(0x0300, 0x0090, 4, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDCE3__GPIO2_IO23                          = IOMUX_PAD(0x0300, 0x0090, 5, 0x0000, 0, 0),
	MX7D_PAD_EPDC_SDCE3__LCD_DATA22                          = IOMUX_PAD(0x0300, 0x0090, 6, 0x0690, 1, 0),
	MX7D_PAD_EPDC_SDCE3__LCD_DATA2                           = IOMUX_PAD(0x0300, 0x0090, 7, 0x0640, 1, 0),

	MX7D_PAD_EPDC_GDCLK__EPDC_GDCLK                          = IOMUX_PAD(0x0304, 0x0094, 0, 0x0000, 0, 0),
	MX7D_PAD_EPDC_GDCLK__FLEXTIMER2_CH0                      = IOMUX_PAD(0x0304, 0x0094, 1, 0x05AC, 0, 0),
	MX7D_PAD_EPDC_GDCLK__ENET2_RGMII_TD2                     = IOMUX_PAD(0x0304, 0x0094, 2, 0x0000, 0, 0),
	MX7D_PAD_EPDC_GDCLK__KPP_COL7                            = IOMUX_PAD(0x0304, 0x0094, 3, 0x0610, 0, 0),
	MX7D_PAD_EPDC_GDCLK__EIM_ADDR18                          = IOMUX_PAD(0x0304, 0x0094, 4, 0x0000, 0, 0),
	MX7D_PAD_EPDC_GDCLK__GPIO2_IO24                          = IOMUX_PAD(0x0304, 0x0094, 5, 0x0000, 0, 0),
	MX7D_PAD_EPDC_GDCLK__LCD_DATA23                          = IOMUX_PAD(0x0304, 0x0094, 6, 0x0694, 1, 0),
	MX7D_PAD_EPDC_GDCLK__LCD_DATA16                          = IOMUX_PAD(0x0304, 0x0094, 7, 0x0678, 1, 0),

	MX7D_PAD_EPDC_GDOE__EPDC_GDOE                            = IOMUX_PAD(0x0308, 0x0098, 0, 0x0000, 0, 0),
	MX7D_PAD_EPDC_GDOE__FLEXTIMER2_CH1                       = IOMUX_PAD(0x0308, 0x0098, 1, 0x05B0, 0, 0),
	MX7D_PAD_EPDC_GDOE__ENET2_RGMII_TD3                      = IOMUX_PAD(0x0308, 0x0098, 2, 0x0000, 0, 0),
	MX7D_PAD_EPDC_GDOE__KPP_ROW7                             = IOMUX_PAD(0x0308, 0x0098, 3, 0x0630, 0, 0),
	MX7D_PAD_EPDC_GDOE__EIM_ADDR19                           = IOMUX_PAD(0x0308, 0x0098, 4, 0x0000, 0, 0),
	MX7D_PAD_EPDC_GDOE__GPIO2_IO25                           = IOMUX_PAD(0x0308, 0x0098, 5, 0x0000, 0, 0),
	MX7D_PAD_EPDC_GDOE__LCD_WR_RWN                           = IOMUX_PAD(0x0308, 0x0098, 6, 0x0000, 0, 0),
	MX7D_PAD_EPDC_GDOE__LCD_DATA18                           = IOMUX_PAD(0x0308, 0x0098, 7, 0x0680, 1, 0),

	MX7D_PAD_EPDC_GDRL__EPDC_GDRL                            = IOMUX_PAD(0x030C, 0x009C, 0, 0x0000, 0, 0),
	MX7D_PAD_EPDC_GDRL__FLEXTIMER2_CH2                       = IOMUX_PAD(0x030C, 0x009C, 1, 0x05B4, 0, 0),
	MX7D_PAD_EPDC_GDRL__ENET2_RGMII_TX_CTL                   = IOMUX_PAD(0x030C, 0x009C, 2, 0x0000, 0, 0),
	MX7D_PAD_EPDC_GDRL__EIM_ADDR20                           = IOMUX_PAD(0x030C, 0x009C, 4, 0x0000, 0, 0),
	MX7D_PAD_EPDC_GDRL__GPIO2_IO26                           = IOMUX_PAD(0x030C, 0x009C, 5, 0x0000, 0, 0),
	MX7D_PAD_EPDC_GDRL__LCD_RD_E                             = IOMUX_PAD(0x030C, 0x009C, 6, 0x0000, 0, 0),
	MX7D_PAD_EPDC_GDRL__LCD_DATA19                           = IOMUX_PAD(0x030C, 0x009C, 7, 0x0684, 1, 0),

	MX7D_PAD_EPDC_GDSP__EPDC_GDSP                            = IOMUX_PAD(0x0310, 0x00A0, 0, 0x0000, 0, 0),
	MX7D_PAD_EPDC_GDSP__FLEXTIMER2_CH3                       = IOMUX_PAD(0x0310, 0x00A0, 1, 0x05B8, 0, 0),
	MX7D_PAD_EPDC_GDSP__ENET2_RGMII_TXC                      = IOMUX_PAD(0x0310, 0x00A0, 2, 0x0000, 0, 0),
	MX7D_PAD_EPDC_GDSP__ENET2_TX_ER                          = IOMUX_PAD(0x0310, 0x00A0, 3, 0x0000, 0, 0),
	MX7D_PAD_EPDC_GDSP__EIM_ADDR21                           = IOMUX_PAD(0x0310, 0x00A0, 4, 0x0000, 0, 0),
	MX7D_PAD_EPDC_GDSP__GPIO2_IO27                           = IOMUX_PAD(0x0310, 0x00A0, 5, 0x0000, 0, 0),
	MX7D_PAD_EPDC_GDSP__LCD_BUSY                             = IOMUX_PAD(0x0310, 0x00A0, 6, 0x0634, 1, 0),
	MX7D_PAD_EPDC_GDSP__LCD_DATA17                           = IOMUX_PAD(0x0310, 0x00A0, 7, 0x067C, 1, 0),

	MX7D_PAD_EPDC_BDR0__EPDC_BDR0                            = IOMUX_PAD(0x0314, 0x00A4, 0, 0x0000, 0, 0),
	MX7D_PAD_EPDC_BDR0__ENET2_TX_CLK                         = IOMUX_PAD(0x0314, 0x00A4, 2, 0x0000, 0, 0),
	MX7D_PAD_EPDC_BDR0__CCM_ENET_REF_CLK2                    = IOMUX_PAD(0x0314, 0x00A4, 3, 0x0570, 1, 0),
	MX7D_PAD_EPDC_BDR0__EIM_ADDR22                           = IOMUX_PAD(0x0314, 0x00A4, 4, 0x0000, 0, 0),
	MX7D_PAD_EPDC_BDR0__GPIO2_IO28                           = IOMUX_PAD(0x0314, 0x00A4, 5, 0x0000, 0, 0),
	MX7D_PAD_EPDC_BDR0__LCD_CS                               = IOMUX_PAD(0x0314, 0x00A4, 6, 0x0000, 0, 0),
	MX7D_PAD_EPDC_BDR0__LCD_DATA7                            = IOMUX_PAD(0x0314, 0x00A4, 7, 0x0654, 1, 0),

	MX7D_PAD_EPDC_BDR1__EPDC_BDR1                            = IOMUX_PAD(0x0318, 0x00A8, 0, 0x0000, 0, 0),
	MX7D_PAD_EPDC_BDR1__EPDC_SDCLKN                          = IOMUX_PAD(0x0318, 0x00A8, 1, 0x0000, 0, 0),
	MX7D_PAD_EPDC_BDR1__ENET2_RX_CLK                         = IOMUX_PAD(0x0318, 0x00A8, 2, 0x0578, 1, 0),
	MX7D_PAD_EPDC_BDR1__EIM_AD8                              = IOMUX_PAD(0x0318, 0x00A8, 4, 0x0000, 0, 0),
	MX7D_PAD_EPDC_BDR1__GPIO2_IO29                           = IOMUX_PAD(0x0318, 0x00A8, 5, 0x0000, 0, 0),
	MX7D_PAD_EPDC_BDR1__LCD_ENABLE                           = IOMUX_PAD(0x0318, 0x00A8, 6, 0x0000, 0, 0),
	MX7D_PAD_EPDC_BDR1__LCD_DATA6                            = IOMUX_PAD(0x0318, 0x00A8, 7, 0x0650, 1, 0),

	MX7D_PAD_EPDC_PWR_COM__EPDC_PWR_COM                      = IOMUX_PAD(0x031C, 0x00AC, 0, 0x0000, 0, 0),
	MX7D_PAD_EPDC_PWR_COM__FLEXTIMER2_PHA                    = IOMUX_PAD(0x031C, 0x00AC, 1, 0x05CC, 0, 0),
	MX7D_PAD_EPDC_PWR_COM__ENET2_CRS                         = IOMUX_PAD(0x031C, 0x00AC, 2, 0x0000, 0, 0),
	MX7D_PAD_EPDC_PWR_COM__EIM_AD9                           = IOMUX_PAD(0x031C, 0x00AC, 4, 0x0000, 0, 0),
	MX7D_PAD_EPDC_PWR_COM__GPIO2_IO30                        = IOMUX_PAD(0x031C, 0x00AC, 5, 0x0000, 0, 0),
	MX7D_PAD_EPDC_PWR_COM__LCD_HSYNC                         = IOMUX_PAD(0x031C, 0x00AC, 6, 0x0000, 0, 0),
	MX7D_PAD_EPDC_PWR_COM__LCD_DATA11                        = IOMUX_PAD(0x031C, 0x00AC, 7, 0x0664, 1, 0),

	MX7D_PAD_EPDC_PWR_STAT__EPDC_PWR_STAT                    = IOMUX_PAD(0x0320, 0x00B0, 0, 0x0580, 0, 0),
	MX7D_PAD_EPDC_PWR_STAT__FLEXTIMER2_PHB                   = IOMUX_PAD(0x0320, 0x00B0, 1, 0x05D0, 0, 0),
	MX7D_PAD_EPDC_PWR_STAT__ENET2_COL                        = IOMUX_PAD(0x0320, 0x00B0, 2, 0x0000, 0, 0),
	MX7D_PAD_EPDC_PWR_STAT__EIM_EB_B1                        = IOMUX_PAD(0x0320, 0x00B0, 4, 0x0000, 0, 0),
	MX7D_PAD_EPDC_PWR_STAT__GPIO2_IO31                       = IOMUX_PAD(0x0320, 0x00B0, 5, 0x0000, 0, 0),
	MX7D_PAD_EPDC_PWR_STAT__LCD_VSYNC                        = IOMUX_PAD(0x0320, 0x00B0, 6, 0x0698, 1, 0),
	MX7D_PAD_EPDC_PWR_STAT__LCD_DATA12                       = IOMUX_PAD(0x0320, 0x00B0, 7, 0x0668, 1, 0),

	MX7D_PAD_LCD_CLK__LCD_CLK                                = IOMUX_PAD(0x0324, 0x00B4, 0, 0x0000, 0, 0),
	MX7D_PAD_LCD_CLK__ECSPI4_MISO                            = IOMUX_PAD(0x0324, 0x00B4, 1, 0x0558, 0, 0),
	MX7D_PAD_LCD_CLK__ENET1_1588_EVENT2_IN                   = IOMUX_PAD(0x0324, 0x00B4, 2, 0x0000, 0, 0),
	MX7D_PAD_LCD_CLK__CSI_DATA16                             = IOMUX_PAD(0x0324, 0x00B4, 3, 0x0000, 0, 0),
	MX7D_PAD_LCD_CLK__UART2_DCE_RX                           = IOMUX_PAD(0x0324, 0x00B4, 4, 0x06FC, 0, 0),
	MX7D_PAD_LCD_CLK__UART2_DTE_TX                           = IOMUX_PAD(0x0324, 0x00B4, 4, 0x0000, 0, 0),
	MX7D_PAD_LCD_CLK__GPIO3_IO0                              = IOMUX_PAD(0x0324, 0x00B4, 5, 0x0000, 0, 0),

	MX7D_PAD_LCD_ENABLE__LCD_ENABLE                          = IOMUX_PAD(0x0328, 0x00B8, 0, 0x0000, 0, 0),
	MX7D_PAD_LCD_ENABLE__ECSPI4_MOSI                         = IOMUX_PAD(0x0328, 0x00B8, 1, 0x055C, 0, 0),
	MX7D_PAD_LCD_ENABLE__ENET1_1588_EVENT3_IN                = IOMUX_PAD(0x0328, 0x00B8, 2, 0x0000, 0, 0),
	MX7D_PAD_LCD_ENABLE__CSI_DATA17                          = IOMUX_PAD(0x0328, 0x00B8, 3, 0x0000, 0, 0),
	MX7D_PAD_LCD_ENABLE__UART2_DCE_TX                        = IOMUX_PAD(0x0328, 0x00B8, 4, 0x0000, 0, 0),
	MX7D_PAD_LCD_ENABLE__UART2_DTE_RX                        = IOMUX_PAD(0x0328, 0x00B8, 4, 0x06FC, 1, 0),
	MX7D_PAD_LCD_ENABLE__GPIO3_IO1                           = IOMUX_PAD(0x0328, 0x00B8, 5, 0x0000, 0, 0),

	MX7D_PAD_LCD_HSYNC__LCD_HSYNC                            = IOMUX_PAD(0x032C, 0x00BC, 0, 0x0000, 0, 0),
	MX7D_PAD_LCD_HSYNC__ECSPI4_SCLK                          = IOMUX_PAD(0x032C, 0x00BC, 1, 0x0554, 0, 0),
	MX7D_PAD_LCD_HSYNC__ENET2_1588_EVENT2_IN                 = IOMUX_PAD(0x032C, 0x00BC, 2, 0x0000, 0, 0),
	MX7D_PAD_LCD_HSYNC__CSI_DATA18                           = IOMUX_PAD(0x032C, 0x00BC, 3, 0x0000, 0, 0),
	MX7D_PAD_LCD_HSYNC__UART2_DCE_RTS                        = IOMUX_PAD(0x032C, 0x00BC, 4, 0x06F8, 0, 0),
	MX7D_PAD_LCD_HSYNC__UART2_DTE_CTS                        = IOMUX_PAD(0x032C, 0x00BC, 4, 0x0000, 0, 0),
	MX7D_PAD_LCD_HSYNC__GPIO3_IO2                            = IOMUX_PAD(0x032C, 0x00BC, 5, 0x0000, 0, 0),

	MX7D_PAD_LCD_VSYNC__LCD_VSYNC                            = IOMUX_PAD(0x0330, 0x00C0, 0, 0x0698, 2, 0),
	MX7D_PAD_LCD_VSYNC__ECSPI4_SS0                           = IOMUX_PAD(0x0330, 0x00C0, 1, 0x0560, 0, 0),
	MX7D_PAD_LCD_VSYNC__ENET2_1588_EVENT3_IN                 = IOMUX_PAD(0x0330, 0x00C0, 2, 0x0000, 0, 0),
	MX7D_PAD_LCD_VSYNC__CSI_DATA19                           = IOMUX_PAD(0x0330, 0x00C0, 3, 0x0000, 0, 0),
	MX7D_PAD_LCD_VSYNC__UART2_DCE_CTS                        = IOMUX_PAD(0x0330, 0x00C0, 4, 0x0000, 0, 0),
	MX7D_PAD_LCD_VSYNC__UART2_DTE_RTS                        = IOMUX_PAD(0x0330, 0x00C0, 4, 0x06F8, 1, 0),
	MX7D_PAD_LCD_VSYNC__GPIO3_IO3                            = IOMUX_PAD(0x0330, 0x00C0, 5, 0x0000, 0, 0),

	MX7D_PAD_LCD_RESET__LCD_RESET                            = IOMUX_PAD(0x0334, 0x00C4, 0, 0x0000, 0, 0),
	MX7D_PAD_LCD_RESET__GPT1_COMPARE1                        = IOMUX_PAD(0x0334, 0x00C4, 1, 0x0000, 0, 0),
	MX7D_PAD_LCD_RESET__ARM_PLATFORM_EVENTI                  = IOMUX_PAD(0x0334, 0x00C4, 2, 0x0000, 0, 0),
	MX7D_PAD_LCD_RESET__CSI_FIELD                            = IOMUX_PAD(0x0334, 0x00C4, 3, 0x0000, 0, 0),
	MX7D_PAD_LCD_RESET__EIM_DTACK_B                          = IOMUX_PAD(0x0334, 0x00C4, 4, 0x0000, 0, 0),
	MX7D_PAD_LCD_RESET__GPIO3_IO4                            = IOMUX_PAD(0x0334, 0x00C4, 5, 0x0000, 0, 0),

	MX7D_PAD_LCD_DATA00__LCD_DATA0                           = IOMUX_PAD(0x0338, 0x00C8, 0, 0x0638, 2, 0),
	MX7D_PAD_LCD_DATA00__GPT1_COMPARE2                       = IOMUX_PAD(0x0338, 0x00C8, 1, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA00__CSI_DATA20                          = IOMUX_PAD(0x0338, 0x00C8, 3, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA00__EIM_DATA0                           = IOMUX_PAD(0x0338, 0x00C8, 4, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA00__GPIO3_IO5                           = IOMUX_PAD(0x0338, 0x00C8, 5, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA00__SRC_BOOT_CFG0                       = IOMUX_PAD(0x0338, 0x00C8, 6, 0x0000, 0, 0),

	MX7D_PAD_LCD_DATA01__LCD_DATA1                           = IOMUX_PAD(0x033C, 0x00CC, 0, 0x063C, 2, 0),
	MX7D_PAD_LCD_DATA01__GPT1_COMPARE3                       = IOMUX_PAD(0x033C, 0x00CC, 1, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA01__CSI_DATA21                          = IOMUX_PAD(0x033C, 0x00CC, 3, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA01__EIM_DATA1                           = IOMUX_PAD(0x033C, 0x00CC, 4, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA01__GPIO3_IO6                           = IOMUX_PAD(0x033C, 0x00CC, 5, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA01__SRC_BOOT_CFG1                       = IOMUX_PAD(0x033C, 0x00CC, 6, 0x0000, 0, 0),

	MX7D_PAD_LCD_DATA02__LCD_DATA2                           = IOMUX_PAD(0x0340, 0x00D0, 0, 0x0640, 2, 0),
	MX7D_PAD_LCD_DATA02__GPT1_CLK                            = IOMUX_PAD(0x0340, 0x00D0, 1, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA02__CSI_DATA22                          = IOMUX_PAD(0x0340, 0x00D0, 3, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA02__EIM_DATA2                           = IOMUX_PAD(0x0340, 0x00D0, 4, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA02__GPIO3_IO7                           = IOMUX_PAD(0x0340, 0x00D0, 5, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA02__SRC_BOOT_CFG2                       = IOMUX_PAD(0x0340, 0x00D0, 6, 0x0000, 0, 0),

	MX7D_PAD_LCD_DATA03__LCD_DATA3                           = IOMUX_PAD(0x0344, 0x00D4, 0, 0x0644, 2, 0),
	MX7D_PAD_LCD_DATA03__GPT1_CAPTURE1                       = IOMUX_PAD(0x0344, 0x00D4, 1, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA03__CSI_DATA23                          = IOMUX_PAD(0x0344, 0x00D4, 3, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA03__EIM_DATA3                           = IOMUX_PAD(0x0344, 0x00D4, 4, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA03__GPIO3_IO8                           = IOMUX_PAD(0x0344, 0x00D4, 5, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA03__SRC_BOOT_CFG3                       = IOMUX_PAD(0x0344, 0x00D4, 6, 0x0000, 0, 0),

	MX7D_PAD_LCD_DATA04__LCD_DATA4                           = IOMUX_PAD(0x0348, 0x00D8, 0, 0x0648, 2, 0),
	MX7D_PAD_LCD_DATA04__GPT1_CAPTURE2                       = IOMUX_PAD(0x0348, 0x00D8, 1, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA04__CSI_VSYNC                           = IOMUX_PAD(0x0348, 0x00D8, 3, 0x0520, 0, 0),
	MX7D_PAD_LCD_DATA04__EIM_DATA4                           = IOMUX_PAD(0x0348, 0x00D8, 4, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA04__GPIO3_IO9                           = IOMUX_PAD(0x0348, 0x00D8, 5, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA04__SRC_BOOT_CFG4                       = IOMUX_PAD(0x0348, 0x00D8, 6, 0x0000, 0, 0),

	MX7D_PAD_LCD_DATA05__LCD_DATA5                           = IOMUX_PAD(0x034C, 0x00DC, 0, 0x064C, 2, 0),
	MX7D_PAD_LCD_DATA05__CSI_HSYNC                           = IOMUX_PAD(0x034C, 0x00DC, 3, 0x0518, 0, 0),
	MX7D_PAD_LCD_DATA05__EIM_DATA5                           = IOMUX_PAD(0x034C, 0x00DC, 4, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA05__GPIO3_IO10                          = IOMUX_PAD(0x034C, 0x00DC, 5, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA05__SRC_BOOT_CFG5                       = IOMUX_PAD(0x034C, 0x00DC, 6, 0x0000, 0, 0),

	MX7D_PAD_LCD_DATA06__LCD_DATA6                           = IOMUX_PAD(0x0350, 0x00E0, 0, 0x0650, 2, 0),
	MX7D_PAD_LCD_DATA06__CSI_PIXCLK                          = IOMUX_PAD(0x0350, 0x00E0, 3, 0x051C, 0, 0),
	MX7D_PAD_LCD_DATA06__EIM_DATA6                           = IOMUX_PAD(0x0350, 0x00E0, 4, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA06__GPIO3_IO11                          = IOMUX_PAD(0x0350, 0x00E0, 5, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA06__SRC_BOOT_CFG6                       = IOMUX_PAD(0x0350, 0x00E0, 6, 0x0000, 0, 0),

	MX7D_PAD_LCD_DATA07__LCD_DATA7                           = IOMUX_PAD(0x0354, 0x00E4, 0, 0x0654, 2, 0),
	MX7D_PAD_LCD_DATA07__CSI_MCLK                            = IOMUX_PAD(0x0354, 0x00E4, 3, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA07__EIM_DATA7                           = IOMUX_PAD(0x0354, 0x00E4, 4, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA07__GPIO3_IO12                          = IOMUX_PAD(0x0354, 0x00E4, 5, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA07__SRC_BOOT_CFG7                       = IOMUX_PAD(0x0354, 0x00E4, 6, 0x0000, 0, 0),

	MX7D_PAD_LCD_DATA08__LCD_DATA8                           = IOMUX_PAD(0x0358, 0x00E8, 0, 0x0658, 2, 0),
	MX7D_PAD_LCD_DATA08__CSI_DATA9                           = IOMUX_PAD(0x0358, 0x00E8, 3, 0x0514, 0, 0),
	MX7D_PAD_LCD_DATA08__EIM_DATA8                           = IOMUX_PAD(0x0358, 0x00E8, 4, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA08__GPIO3_IO13                          = IOMUX_PAD(0x0358, 0x00E8, 5, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA08__SRC_BOOT_CFG8                       = IOMUX_PAD(0x0358, 0x00E8, 6, 0x0000, 0, 0),

	MX7D_PAD_LCD_DATA09__LCD_DATA9                           = IOMUX_PAD(0x035C, 0x00EC, 0, 0x065C, 2, 0),
	MX7D_PAD_LCD_DATA09__CSI_DATA8                           = IOMUX_PAD(0x035C, 0x00EC, 3, 0x0510, 0, 0),
	MX7D_PAD_LCD_DATA09__EIM_DATA9                           = IOMUX_PAD(0x035C, 0x00EC, 4, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA09__GPIO3_IO14                          = IOMUX_PAD(0x035C, 0x00EC, 5, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA09__SRC_BOOT_CFG9                       = IOMUX_PAD(0x035C, 0x00EC, 6, 0x0000, 0, 0),

	MX7D_PAD_LCD_DATA10__LCD_DATA10                          = IOMUX_PAD(0x0360, 0x00F0, 0, 0x0660, 2, 0),
	MX7D_PAD_LCD_DATA10__CSI_DATA7                           = IOMUX_PAD(0x0360, 0x00F0, 3, 0x050C, 0, 0),
	MX7D_PAD_LCD_DATA10__EIM_DATA10                          = IOMUX_PAD(0x0360, 0x00F0, 4, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA10__GPIO3_IO15                          = IOMUX_PAD(0x0360, 0x00F0, 5, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA10__SRC_BOOT_CFG10                      = IOMUX_PAD(0x0360, 0x00F0, 6, 0x0000, 0, 0),

	MX7D_PAD_LCD_DATA11__LCD_DATA11                          = IOMUX_PAD(0x0364, 0x00F4, 0, 0x0664, 2, 0),
	MX7D_PAD_LCD_DATA11__CSI_DATA6                           = IOMUX_PAD(0x0364, 0x00F4, 3, 0x0508, 0, 0),
	MX7D_PAD_LCD_DATA11__EIM_DATA11                          = IOMUX_PAD(0x0364, 0x00F4, 4, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA11__GPIO3_IO16                          = IOMUX_PAD(0x0364, 0x00F4, 5, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA11__SRC_BOOT_CFG11                      = IOMUX_PAD(0x0364, 0x00F4, 6, 0x0000, 0, 0),

	MX7D_PAD_LCD_DATA12__LCD_DATA12                          = IOMUX_PAD(0x0368, 0x00F8, 0, 0x0668, 2, 0),
	MX7D_PAD_LCD_DATA12__CSI_DATA5                           = IOMUX_PAD(0x0368, 0x00F8, 3, 0x0504, 0, 0),
	MX7D_PAD_LCD_DATA12__EIM_DATA12                          = IOMUX_PAD(0x0368, 0x00F8, 4, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA12__GPIO3_IO17                          = IOMUX_PAD(0x0368, 0x00F8, 5, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA12__SRC_BOOT_CFG12                      = IOMUX_PAD(0x0368, 0x00F8, 6, 0x0000, 0, 0),

	MX7D_PAD_LCD_DATA13__LCD_DATA13                          = IOMUX_PAD(0x036C, 0x00FC, 0, 0x066C, 1, 0),
	MX7D_PAD_LCD_DATA13__CSI_DATA4                           = IOMUX_PAD(0x036C, 0x00FC, 3, 0x0500, 0, 0),
	MX7D_PAD_LCD_DATA13__EIM_DATA13                          = IOMUX_PAD(0x036C, 0x00FC, 4, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA13__GPIO3_IO18                          = IOMUX_PAD(0x036C, 0x00FC, 5, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA13__SRC_BOOT_CFG13                      = IOMUX_PAD(0x036C, 0x00FC, 6, 0x0000, 0, 0),

	MX7D_PAD_LCD_DATA14__LCD_DATA14                          = IOMUX_PAD(0x0370, 0x0100, 0, 0x0670, 1, 0),
	MX7D_PAD_LCD_DATA14__CSI_DATA3                           = IOMUX_PAD(0x0370, 0x0100, 3, 0x04FC, 0, 0),
	MX7D_PAD_LCD_DATA14__EIM_DATA14                          = IOMUX_PAD(0x0370, 0x0100, 4, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA14__GPIO3_IO19                          = IOMUX_PAD(0x0370, 0x0100, 5, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA14__SRC_BOOT_CFG14                      = IOMUX_PAD(0x0370, 0x0100, 6, 0x0000, 0, 0),

	MX7D_PAD_LCD_DATA15__LCD_DATA15                          = IOMUX_PAD(0x0374, 0x0104, 0, 0x0674, 1, 0),
	MX7D_PAD_LCD_DATA15__CSI_DATA2                           = IOMUX_PAD(0x0374, 0x0104, 3, 0x04F8, 0, 0),
	MX7D_PAD_LCD_DATA15__EIM_DATA15                          = IOMUX_PAD(0x0374, 0x0104, 4, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA15__GPIO3_IO20                          = IOMUX_PAD(0x0374, 0x0104, 5, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA15__SRC_BOOT_CFG15                      = IOMUX_PAD(0x0374, 0x0104, 6, 0x0000, 0, 0),

	MX7D_PAD_LCD_DATA16__LCD_DATA16                          = IOMUX_PAD(0x0378, 0x0108, 0, 0x0678, 2, 0),
	MX7D_PAD_LCD_DATA16__FLEXTIMER1_CH4                      = IOMUX_PAD(0x0378, 0x0108, 1, 0x0594, 0, 0),
	MX7D_PAD_LCD_DATA16__CSI_DATA1                           = IOMUX_PAD(0x0378, 0x0108, 3, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA16__EIM_CRE                             = IOMUX_PAD(0x0378, 0x0108, 4, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA16__GPIO3_IO21                          = IOMUX_PAD(0x0378, 0x0108, 5, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA16__SRC_BOOT_CFG16                      = IOMUX_PAD(0x0378, 0x0108, 6, 0x0000, 0, 0),

	MX7D_PAD_LCD_DATA17__LCD_DATA17                          = IOMUX_PAD(0x037C, 0x010C, 0, 0x067C, 2, 0),
	MX7D_PAD_LCD_DATA17__FLEXTIMER1_CH5                      = IOMUX_PAD(0x037C, 0x010C, 1, 0x0598, 0, 0),
	MX7D_PAD_LCD_DATA17__CSI_DATA0                           = IOMUX_PAD(0x037C, 0x010C, 3, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA17__EIM_ACLK_FREERUN                    = IOMUX_PAD(0x037C, 0x010C, 4, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA17__GPIO3_IO22                          = IOMUX_PAD(0x037C, 0x010C, 5, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA17__SRC_BOOT_CFG17                      = IOMUX_PAD(0x037C, 0x010C, 6, 0x0000, 0, 0),

	MX7D_PAD_LCD_DATA18__LCD_DATA18                          = IOMUX_PAD(0x0380, 0x0110, 0, 0x0680, 2, 0),
	MX7D_PAD_LCD_DATA18__FLEXTIMER1_CH6                      = IOMUX_PAD(0x0380, 0x0110, 1, 0x059C, 0, 0),
	MX7D_PAD_LCD_DATA18__ARM_PLATFORM_EVENTO                 = IOMUX_PAD(0x0380, 0x0110, 2, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA18__CSI_DATA15                          = IOMUX_PAD(0x0380, 0x0110, 3, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA18__EIM_CS2_B                           = IOMUX_PAD(0x0380, 0x0110, 4, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA18__GPIO3_IO23                          = IOMUX_PAD(0x0380, 0x0110, 5, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA18__SRC_BOOT_CFG18                      = IOMUX_PAD(0x0380, 0x0110, 6, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA19__EIM_CS3_B                           = IOMUX_PAD(0x0384, 0x0114, 4, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA19__GPIO3_IO24                          = IOMUX_PAD(0x0384, 0x0114, 5, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA19__SRC_BOOT_CFG19                      = IOMUX_PAD(0x0384, 0x0114, 6, 0x0000, 0, 0),

	MX7D_PAD_LCD_DATA19__LCD_DATA19                          = IOMUX_PAD(0x0384, 0x0114, 0, 0x0684, 2, 0),
	MX7D_PAD_LCD_DATA19__FLEXTIMER1_CH7                      = IOMUX_PAD(0x0384, 0x0114, 1, 0x05A0, 0, 0),
	MX7D_PAD_LCD_DATA19__CSI_DATA14                          = IOMUX_PAD(0x0384, 0x0114, 3, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA20__EIM_ADDR23                          = IOMUX_PAD(0x0388, 0x0118, 4, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA20__GPIO3_IO25                          = IOMUX_PAD(0x0388, 0x0118, 5, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA20__I2C3_SCL                            = IOMUX_PAD(0x0388, 0x0118, IOMUX_CONFIG_SION | 6, 0x05E4, 1, 0),

	MX7D_PAD_LCD_DATA20__LCD_DATA20                          = IOMUX_PAD(0x0388, 0x0118, 0, 0x0688, 2, 0),
	MX7D_PAD_LCD_DATA20__FLEXTIMER2_CH4                      = IOMUX_PAD(0x0388, 0x0118, 1, 0x05BC, 0, 0),
	MX7D_PAD_LCD_DATA20__ENET1_1588_EVENT2_OUT               = IOMUX_PAD(0x0388, 0x0118, 2, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA20__CSI_DATA13                          = IOMUX_PAD(0x0388, 0x0118, 3, 0x0000, 0, 0),

	MX7D_PAD_LCD_DATA21__LCD_DATA21                          = IOMUX_PAD(0x038C, 0x011C, 0, 0x068C, 2, 0),
	MX7D_PAD_LCD_DATA21__FLEXTIMER2_CH5                      = IOMUX_PAD(0x038C, 0x011C, 1, 0x05C0, 0, 0),
	MX7D_PAD_LCD_DATA21__ENET1_1588_EVENT3_OUT               = IOMUX_PAD(0x038C, 0x011C, 2, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA21__CSI_DATA12                          = IOMUX_PAD(0x038C, 0x011C, 3, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA21__EIM_ADDR24                          = IOMUX_PAD(0x038C, 0x011C, 4, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA21__GPIO3_IO26                          = IOMUX_PAD(0x038C, 0x011C, 5, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA21__I2C3_SDA                            = IOMUX_PAD(0x038C, 0x011C, IOMUX_CONFIG_SION | 6, 0x05E8, 1, 0),

	MX7D_PAD_LCD_DATA22__LCD_DATA22                          = IOMUX_PAD(0x0390, 0x0120, 0, 0x0690, 2, 0),
	MX7D_PAD_LCD_DATA22__FLEXTIMER2_CH6                      = IOMUX_PAD(0x0390, 0x0120, 1, 0x05C4, 0, 0),
	MX7D_PAD_LCD_DATA22__ENET2_1588_EVENT2_OUT               = IOMUX_PAD(0x0390, 0x0120, 2, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA22__CSI_DATA11                          = IOMUX_PAD(0x0390, 0x0120, 3, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA22__EIM_ADDR25                          = IOMUX_PAD(0x0390, 0x0120, 4, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA22__GPIO3_IO27                          = IOMUX_PAD(0x0390, 0x0120, 5, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA22__I2C4_SCL                            = IOMUX_PAD(0x0390, 0x0120, IOMUX_CONFIG_SION | 6, 0x05EC, 1, 0),

	MX7D_PAD_LCD_DATA23__LCD_DATA23                          = IOMUX_PAD(0x0394, 0x0124, 0, 0x0694, 2, 0),
	MX7D_PAD_LCD_DATA23__FLEXTIMER2_CH7                      = IOMUX_PAD(0x0394, 0x0124, 1, 0x05C8, 0, 0),
	MX7D_PAD_LCD_DATA23__ENET2_1588_EVENT3_OUT               = IOMUX_PAD(0x0394, 0x0124, 2, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA23__CSI_DATA10                          = IOMUX_PAD(0x0394, 0x0124, 3, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA23__EIM_ADDR26                          = IOMUX_PAD(0x0394, 0x0124, 4, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA23__GPIO3_IO28                          = IOMUX_PAD(0x0394, 0x0124, 5, 0x0000, 0, 0),
	MX7D_PAD_LCD_DATA23__I2C4_SDA                            = IOMUX_PAD(0x0394, 0x0124, IOMUX_CONFIG_SION | 6, 0x05F0, 1, 0),

	MX7D_PAD_UART1_RX_DATA__UART1_DCE_RX                     = IOMUX_PAD(0x0398, 0x0128, 0, 0x06F4, 0, 0),

	MX7D_PAD_UART1_RX_DATA__UART1_DTE_TX                     = IOMUX_PAD(0x0398, 0x0128, 0, 0x0000, 0, 0),
	MX7D_PAD_UART1_RX_DATA__I2C1_SCL                         = IOMUX_PAD(0x0398, 0x0128, IOMUX_CONFIG_SION | 1, 0x0000, 0, 0),
	MX7D_PAD_UART1_RX_DATA__CCM_PMIC_READY                   = IOMUX_PAD(0x0398, 0x0128, 2, 0x0000, 0, 0),
	MX7D_PAD_UART1_RX_DATA__ECSPI1_SS1                       = IOMUX_PAD(0x0398, 0x0128, 3, 0x0000, 0, 0),
	MX7D_PAD_UART1_RX_DATA__ENET2_1588_EVENT0_IN             = IOMUX_PAD(0x0398, 0x0128, 4, 0x0000, 0, 0),
	MX7D_PAD_UART1_RX_DATA__GPIO4_IO0                        = IOMUX_PAD(0x0398, 0x0128, 5, 0x0000, 0, 0),
	MX7D_PAD_UART1_RX_DATA__ENET1_MDIO                       = IOMUX_PAD(0x0398, 0x0128, 6, 0x0000, 0, 0),

	MX7D_PAD_UART1_TX_DATA__UART1_DCE_TX                     = IOMUX_PAD(0x039C, 0x012C, 0, 0x0000, 0, 0),

	MX7D_PAD_UART1_TX_DATA__UART1_DTE_RX                     = IOMUX_PAD(0x039C, 0x012C, 0, 0x06F4, 1, 0),
	MX7D_PAD_UART1_TX_DATA__I2C1_SDA                         = IOMUX_PAD(0x039C, 0x012C, IOMUX_CONFIG_SION | 1, 0x05D8, 0, 0),
	MX7D_PAD_UART1_TX_DATA__SAI3_MCLK                        = IOMUX_PAD(0x039C, 0x012C, 2, 0x0000, 0, 0),
	MX7D_PAD_UART1_TX_DATA__ECSPI1_SS2                       = IOMUX_PAD(0x039C, 0x012C, 3, 0x0000, 0, 0),
	MX7D_PAD_UART1_TX_DATA__ENET2_1588_EVENT0_OUT            = IOMUX_PAD(0x039C, 0x012C, 4, 0x0000, 0, 0),
	MX7D_PAD_UART1_TX_DATA__GPIO4_IO1                        = IOMUX_PAD(0x039C, 0x012C, 5, 0x0000, 0, 0),
	MX7D_PAD_UART1_TX_DATA__ENET1_MDC                        = IOMUX_PAD(0x039C, 0x012C, 6, 0x0000, 0, 0),

	MX7D_PAD_UART2_RX_DATA__UART2_DCE_RX                     = IOMUX_PAD(0x03A0, 0x0130, 0, 0x06FC, 2, 0),

	MX7D_PAD_UART2_RX_DATA__UART2_DTE_TX                     = IOMUX_PAD(0x03A0, 0x0130, 0, 0x0000, 0, 0),
	MX7D_PAD_UART2_RX_DATA__I2C2_SCL                         = IOMUX_PAD(0x03A0, 0x0130, IOMUX_CONFIG_SION | 1, 0x0000, 0, 0),
	MX7D_PAD_UART2_RX_DATA__SAI3_RX_BCLK                     = IOMUX_PAD(0x03A0, 0x0130, 2, 0x0000, 0, 0),
	MX7D_PAD_UART2_RX_DATA__ECSPI1_SS3                       = IOMUX_PAD(0x03A0, 0x0130, 3, 0x0000, 0, 0),
	MX7D_PAD_UART2_RX_DATA__ENET2_1588_EVENT1_IN             = IOMUX_PAD(0x03A0, 0x0130, 4, 0x0000, 0, 0),
	MX7D_PAD_UART2_RX_DATA__GPIO4_IO2                        = IOMUX_PAD(0x03A0, 0x0130, 5, 0x0000, 0, 0),
	MX7D_PAD_UART2_RX_DATA__ENET2_MDIO                       = IOMUX_PAD(0x03A0, 0x0130, 6, 0x0000, 0, 0),

	MX7D_PAD_UART2_TX_DATA__UART2_DCE_TX                     = IOMUX_PAD(0x03A4, 0x0134, 0, 0x0000, 0, 0),

	MX7D_PAD_UART2_TX_DATA__UART2_DTE_RX                     = IOMUX_PAD(0x03A4, 0x0134, 0, 0x06FC, 3, 0),
	MX7D_PAD_UART2_TX_DATA__I2C2_SDA                         = IOMUX_PAD(0x03A4, 0x0134, IOMUX_CONFIG_SION | 1, 0x05E0, 0, 0),
	MX7D_PAD_UART2_TX_DATA__SAI3_RX_DATA0                    = IOMUX_PAD(0x03A4, 0x0134, 2, 0x06C8, 0, 0),
	MX7D_PAD_UART2_TX_DATA__ECSPI1_RDY                       = IOMUX_PAD(0x03A4, 0x0134, 3, 0x0000, 0, 0),
	MX7D_PAD_UART2_TX_DATA__ENET2_1588_EVENT1_OUT            = IOMUX_PAD(0x03A4, 0x0134, 4, 0x0000, 0, 0),
	MX7D_PAD_UART2_TX_DATA__GPIO4_IO3                        = IOMUX_PAD(0x03A4, 0x0134, 5, 0x0000, 0, 0),
	MX7D_PAD_UART2_TX_DATA__ENET2_MDC                        = IOMUX_PAD(0x03A4, 0x0134, 6, 0x0000, 0, 0),

	MX7D_PAD_UART3_RX_DATA__UART3_DCE_RX                     = IOMUX_PAD(0x03A8, 0x0138, 0, 0x0704, 2, 0),

	MX7D_PAD_UART3_RX_DATA__UART3_DTE_TX                     = IOMUX_PAD(0x03A8, 0x0138, 0, 0x0000, 0, 0),
	MX7D_PAD_UART3_RX_DATA__USB_OTG1_OC                      = IOMUX_PAD(0x03A8, 0x0138, 1, 0x072C, 0, 0),
	MX7D_PAD_UART3_RX_DATA__SAI3_RX_SYNC                     = IOMUX_PAD(0x03A8, 0x0138, 2, 0x06CC, 0, 0),
	MX7D_PAD_UART3_RX_DATA__ECSPI1_MISO                      = IOMUX_PAD(0x03A8, 0x0138, 3, 0x0528, 0, 0),
	MX7D_PAD_UART3_RX_DATA__ENET1_1588_EVENT0_IN             = IOMUX_PAD(0x03A8, 0x0138, 4, 0x0000, 0, 0),
	MX7D_PAD_UART3_RX_DATA__GPIO4_IO4                        = IOMUX_PAD(0x03A8, 0x0138, 5, 0x0000, 0, 0),
	MX7D_PAD_UART3_RX_DATA__SD1_LCTL                         = IOMUX_PAD(0x03A8, 0x0138, 6, 0x0000, 0, 0),

	MX7D_PAD_UART3_TX_DATA__UART3_DCE_TX                     = IOMUX_PAD(0x03AC, 0x013C, 0, 0x0000, 0, 0),

	MX7D_PAD_UART3_TX_DATA__UART3_DTE_RX                     = IOMUX_PAD(0x03AC, 0x013C, 0, 0x0704, 3, 0),
	MX7D_PAD_UART3_TX_DATA__USB_OTG1_PWR                     = IOMUX_PAD(0x03AC, 0x013C, 1, 0x0000, 0, 0),
	MX7D_PAD_UART3_TX_DATA__SAI3_TX_BCLK                     = IOMUX_PAD(0x03AC, 0x013C, 2, 0x06D0, 0, 0),
	MX7D_PAD_UART3_TX_DATA__ECSPI1_MOSI                      = IOMUX_PAD(0x03AC, 0x013C, 3, 0x052C, 0, 0),
	MX7D_PAD_UART3_TX_DATA__ENET1_1588_EVENT0_OUT            = IOMUX_PAD(0x03AC, 0x013C, 4, 0x0000, 0, 0),
	MX7D_PAD_UART3_TX_DATA__GPIO4_IO5                        = IOMUX_PAD(0x03AC, 0x013C, 5, 0x0000, 0, 0),
	MX7D_PAD_UART3_TX_DATA__SD2_LCTL                         = IOMUX_PAD(0x03AC, 0x013C, 6, 0x0000, 0, 0),

	MX7D_PAD_UART3_RTS_B__UART3_DCE_RTS                      = IOMUX_PAD(0x03B0, 0x0140, 0, 0x0700, 2, 0),

	MX7D_PAD_UART3_RTS_B__UART3_DTE_CTS                      = IOMUX_PAD(0x03B0, 0x0140, 0, 0x0000, 0, 0),
	MX7D_PAD_UART3_RTS_B__USB_OTG2_OC                        = IOMUX_PAD(0x03B0, 0x0140, 1, 0x0000, 0, 0),
	MX7D_PAD_UART3_RTS_B__SAI3_TX_DATA0                      = IOMUX_PAD(0x03B0, 0x0140, 2, 0x0000, 0, 0),
	MX7D_PAD_UART3_RTS_B__ECSPI1_SCLK                        = IOMUX_PAD(0x03B0, 0x0140, 3, 0x0000, 0, 0),
	MX7D_PAD_UART3_RTS_B__ENET1_1588_EVENT1_IN               = IOMUX_PAD(0x03B0, 0x0140, 4, 0x0000, 0, 0),
	MX7D_PAD_UART3_RTS_B__GPIO4_IO6                          = IOMUX_PAD(0x03B0, 0x0140, 5, 0x0000, 0, 0),
	MX7D_PAD_UART3_RTS_B__SD3_LCTL                           = IOMUX_PAD(0x03B0, 0x0140, 6, 0x0000, 0, 0),

	MX7D_PAD_UART3_CTS_B__UART3_DCE_CTS                      = IOMUX_PAD(0x03B4, 0x0144, 0, 0x0000, 0, 0),

	MX7D_PAD_UART3_CTS_B__UART3_DTE_RTS                      = IOMUX_PAD(0x03B4, 0x0144, 0, 0x0700, 3, 0),
	MX7D_PAD_UART3_CTS_B__USB_OTG2_PWR                       = IOMUX_PAD(0x03B4, 0x0144, 1, 0x0000, 0, 0),
	MX7D_PAD_UART3_CTS_B__SAI3_TX_SYNC                       = IOMUX_PAD(0x03B4, 0x0144, 2, 0x06D4, 0, 0),
	MX7D_PAD_UART3_CTS_B__ECSPI1_SS0                         = IOMUX_PAD(0x03B4, 0x0144, 3, 0x0530, 0, 0),
	MX7D_PAD_UART3_CTS_B__ENET1_1588_EVENT1_OUT              = IOMUX_PAD(0x03B4, 0x0144, 4, 0x0000, 0, 0),
	MX7D_PAD_UART3_CTS_B__GPIO4_IO7                          = IOMUX_PAD(0x03B4, 0x0144, 5, 0x0000, 0, 0),
	MX7D_PAD_UART3_CTS_B__SD1_VSELECT                        = IOMUX_PAD(0x03B4, 0x0144, 6, 0x0000, 0, 0),

	MX7D_PAD_I2C1_SCL__I2C1_SCL                              = IOMUX_PAD(0x03B8, 0x0148, IOMUX_CONFIG_SION | 0, 0x05D4, 1, 0),
	MX7D_PAD_I2C1_SCL__UART4_DCE_CTS                         = IOMUX_PAD(0x03B8, 0x0148, 1, 0x0000, 0, 0),
	MX7D_PAD_I2C1_SCL__UART4_DTE_RTS                         = IOMUX_PAD(0x03B8, 0x0148, 1, 0x0708, 0, 0),
	MX7D_PAD_I2C1_SCL__FLEXCAN1_RX                           = IOMUX_PAD(0x03B8, 0x0148, 2, 0x04DC, 1, 0),
	MX7D_PAD_I2C1_SCL__ECSPI3_MISO                           = IOMUX_PAD(0x03B8, 0x0148, 3, 0x0548, 0, 0),
	MX7D_PAD_I2C1_SCL__GPIO4_IO8                             = IOMUX_PAD(0x03B8, 0x0148, 5, 0x0000, 0, 0),
	MX7D_PAD_I2C1_SCL__SD2_VSELECT                           = IOMUX_PAD(0x03B8, 0x0148, 6, 0x0000, 0, 0),

	MX7D_PAD_I2C1_SDA__I2C1_SDA                              = IOMUX_PAD(0x03BC, 0x014C, IOMUX_CONFIG_SION | 0, 0x05D8, 1, 0),
	MX7D_PAD_I2C1_SDA__UART4_DCE_RTS                         = IOMUX_PAD(0x03BC, 0x014C, 1, 0x0708, 1, 0),
	MX7D_PAD_I2C1_SDA__UART4_DTE_CTS                         = IOMUX_PAD(0x03BC, 0x014C, 1, 0x0000, 0, 0),
	MX7D_PAD_I2C1_SDA__FLEXCAN1_TX                           = IOMUX_PAD(0x03BC, 0x014C, 2, 0x0000, 0, 0),
	MX7D_PAD_I2C1_SDA__ECSPI3_MOSI                           = IOMUX_PAD(0x03BC, 0x014C, 3, 0x054C, 0, 0),
	MX7D_PAD_I2C1_SDA__CCM_ENET_REF_CLK1                     = IOMUX_PAD(0x03BC, 0x014C, 4, 0x0564, 1, 0),
	MX7D_PAD_I2C1_SDA__GPIO4_IO9                             = IOMUX_PAD(0x03BC, 0x014C, 5, 0x0000, 0, 0),
	MX7D_PAD_I2C1_SDA__SD3_VSELECT                           = IOMUX_PAD(0x03BC, 0x014C, 6, 0x0000, 0, 0),

	MX7D_PAD_I2C2_SCL__I2C2_SCL                              = IOMUX_PAD(0x03C0, 0x0150, IOMUX_CONFIG_SION | 0, 0x05DC, 1, 0),
	MX7D_PAD_I2C2_SCL__UART4_DCE_RX                          = IOMUX_PAD(0x03C0, 0x0150, 1, 0x070C, 0, 0),
	MX7D_PAD_I2C2_SCL__UART4_DTE_TX                          = IOMUX_PAD(0x03C0, 0x0150, 1, 0x0000, 0, 0),
	MX7D_PAD_I2C2_SCL__WDOG3_WDOG_B                          = IOMUX_PAD(0x03C0, 0x0150, 2, 0x0000, 0, 0),
	MX7D_PAD_I2C2_SCL__ECSPI3_SCLK                           = IOMUX_PAD(0x03C0, 0x0150, 3, 0x0544, 0, 0),
	MX7D_PAD_I2C2_SCL__CCM_ENET_REF_CLK2                     = IOMUX_PAD(0x03C0, 0x0150, 4, 0x0570, 2, 0),
	MX7D_PAD_I2C2_SCL__GPIO4_IO10                            = IOMUX_PAD(0x03C0, 0x0150, 5, 0x0000, 0, 0),
	MX7D_PAD_I2C2_SCL__SD3_CD_B                              = IOMUX_PAD(0x03C0, 0x0150, 6, 0x0738, 1, 0),

	MX7D_PAD_I2C2_SDA__I2C2_SDA                              = IOMUX_PAD(0x03C4, 0x0154, IOMUX_CONFIG_SION | 0, 0x05E0, 1, 0),
	MX7D_PAD_I2C2_SDA__UART4_DCE_TX                          = IOMUX_PAD(0x03C4, 0x0154, 1, 0x0000, 0, 0),
	MX7D_PAD_I2C2_SDA__UART4_DTE_RX                          = IOMUX_PAD(0x03C4, 0x0154, 1, 0x070C, 1, 0),
	MX7D_PAD_I2C2_SDA__WDOG3_WDOG_RST_B_DEB                  = IOMUX_PAD(0x03C4, 0x0154, 2, 0x0000, 0, 0),
	MX7D_PAD_I2C2_SDA__ECSPI3_SS0                            = IOMUX_PAD(0x03C4, 0x0154, 3, 0x0550, 0, 0),
	MX7D_PAD_I2C2_SDA__CCM_ENET_REF_CLK3                     = IOMUX_PAD(0x03C4, 0x0154, 4, 0x0000, 0, 0),
	MX7D_PAD_I2C2_SDA__GPIO4_IO11                            = IOMUX_PAD(0x03C4, 0x0154, 5, 0x0000, 0, 0),
	MX7D_PAD_I2C2_SDA__SD3_WP                                = IOMUX_PAD(0x03C4, 0x0154, 6, 0x073C, 1, 0),

	MX7D_PAD_I2C3_SCL__I2C3_SCL                              = IOMUX_PAD(0x03C8, 0x0158, IOMUX_CONFIG_SION | 0, 0x05E4, 2, 0),
	MX7D_PAD_I2C3_SCL__UART5_DCE_CTS                         = IOMUX_PAD(0x03C8, 0x0158, 1, 0x0000, 0, 0),
	MX7D_PAD_I2C3_SCL__UART5_DTE_RTS                         = IOMUX_PAD(0x03C8, 0x0158, 1, 0x0710, 0, 0),
	MX7D_PAD_I2C3_SCL__FLEXCAN2_RX                           = IOMUX_PAD(0x03C8, 0x0158, 2, 0x04E0, 1, 0),
	MX7D_PAD_I2C3_SCL__CSI_VSYNC                             = IOMUX_PAD(0x03C8, 0x0158, 3, 0x0520, 1, 0),
	MX7D_PAD_I2C3_SCL__SDMA_EXT_EVENT0                       = IOMUX_PAD(0x03C8, 0x0158, 4, 0x06D8, 1, 0),
	MX7D_PAD_I2C3_SCL__GPIO4_IO12                            = IOMUX_PAD(0x03C8, 0x0158, 5, 0x0000, 0, 0),
	MX7D_PAD_I2C3_SCL__EPDC_BDR0                             = IOMUX_PAD(0x03C8, 0x0158, 6, 0x0000, 0, 0),

	MX7D_PAD_I2C3_SDA__I2C3_SDA                              = IOMUX_PAD(0x03CC, 0x015C, IOMUX_CONFIG_SION | 0, 0x05E8, 2, 0),
	MX7D_PAD_I2C3_SDA__UART5_DCE_RTS                         = IOMUX_PAD(0x03CC, 0x015C, 1, 0x0710, 1, 0),
	MX7D_PAD_I2C3_SDA__UART5_DTE_CTS                         = IOMUX_PAD(0x03CC, 0x015C, 1, 0x0000, 0, 0),
	MX7D_PAD_I2C3_SDA__FLEXCAN2_TX                           = IOMUX_PAD(0x03CC, 0x015C, 2, 0x0000, 0, 0),
	MX7D_PAD_I2C3_SDA__CSI_HSYNC                             = IOMUX_PAD(0x03CC, 0x015C, 3, 0x0518, 1, 0),
	MX7D_PAD_I2C3_SDA__SDMA_EXT_EVENT1                       = IOMUX_PAD(0x03CC, 0x015C, 4, 0x06DC, 1, 0),
	MX7D_PAD_I2C3_SDA__GPIO4_IO13                            = IOMUX_PAD(0x03CC, 0x015C, 5, 0x0000, 0, 0),
	MX7D_PAD_I2C3_SDA__EPDC_BDR1                             = IOMUX_PAD(0x03CC, 0x015C, 6, 0x0000, 0, 0),

	MX7D_PAD_I2C4_SCL__I2C4_SCL                              = IOMUX_PAD(0x03D0, 0x0160, IOMUX_CONFIG_SION | 0, 0x05EC, 2, 0),
	MX7D_PAD_I2C4_SCL__UART5_DCE_RX                          = IOMUX_PAD(0x03D0, 0x0160, 1, 0x0714, 0, 0),
	MX7D_PAD_I2C4_SCL__UART5_DTE_TX                          = IOMUX_PAD(0x03D0, 0x0160, 1, 0x0000, 0, 0),
	MX7D_PAD_I2C4_SCL__WDOG4_WDOG_B                          = IOMUX_PAD(0x03D0, 0x0160, 2, 0x0000, 0, 0),
	MX7D_PAD_I2C4_SCL__CSI_PIXCLK                            = IOMUX_PAD(0x03D0, 0x0160, 3, 0x051C, 1, 0),
	MX7D_PAD_I2C4_SCL__USB_OTG1_ID                           = IOMUX_PAD(0x03D0, 0x0160, 4, 0x0734, 1, 0),
	MX7D_PAD_I2C4_SCL__GPIO4_IO14                            = IOMUX_PAD(0x03D0, 0x0160, 5, 0x0000, 0, 0),
	MX7D_PAD_I2C4_SCL__EPDC_VCOM0                            = IOMUX_PAD(0x03D0, 0x0160, 6, 0x0000, 0, 0),

	MX7D_PAD_I2C4_SDA__I2C4_SDA                              = IOMUX_PAD(0x03D4, 0x0164, IOMUX_CONFIG_SION | 0, 0x05F0, 2, 0),
	MX7D_PAD_I2C4_SDA__UART5_DCE_TX                          = IOMUX_PAD(0x03D4, 0x0164, 1, 0x0000, 0, 0),
	MX7D_PAD_I2C4_SDA__UART5_DTE_RX                          = IOMUX_PAD(0x03D4, 0x0164, 1, 0x0714, 1, 0),
	MX7D_PAD_I2C4_SDA__WDOG4_WDOG_RST_B_DEB                  = IOMUX_PAD(0x03D4, 0x0164, 2, 0x0000, 0, 0),
	MX7D_PAD_I2C4_SDA__CSI_MCLK                              = IOMUX_PAD(0x03D4, 0x0164, 3, 0x0000, 0, 0),
	MX7D_PAD_I2C4_SDA__USB_OTG2_ID                           = IOMUX_PAD(0x03D4, 0x0164, 4, 0x0730, 1, 0),
	MX7D_PAD_I2C4_SDA__GPIO4_IO15                            = IOMUX_PAD(0x03D4, 0x0164, 5, 0x0000, 0, 0),
	MX7D_PAD_I2C4_SDA__EPDC_VCOM1                            = IOMUX_PAD(0x03D4, 0x0164, 6, 0x0000, 0, 0),

	MX7D_PAD_ECSPI1_SCLK__ECSPI1_SCLK                        = IOMUX_PAD(0x03D8, 0x0168, 0, 0x0524, 1, 0),
	MX7D_PAD_ECSPI1_SCLK__UART6_DCE_RX                       = IOMUX_PAD(0x03D8, 0x0168, 1, 0x071C, 2, 0),
	MX7D_PAD_ECSPI1_SCLK__UART6_DTE_TX                       = IOMUX_PAD(0x03D8, 0x0168, 1, 0x0000, 0, 0),
	MX7D_PAD_ECSPI1_SCLK__SD2_DATA4                          = IOMUX_PAD(0x03D8, 0x0168, 2, 0x0000, 0, 0),
	MX7D_PAD_ECSPI1_SCLK__CSI_DATA2                          = IOMUX_PAD(0x03D8, 0x0168, 3, 0x04F8, 1, 0),
	MX7D_PAD_ECSPI1_SCLK__GPIO4_IO16                         = IOMUX_PAD(0x03D8, 0x0168, 5, 0x0000, 0, 0),
	MX7D_PAD_ECSPI1_SCLK__EPDC_PWR_COM                       = IOMUX_PAD(0x03D8, 0x0168, 6, 0x0000, 0, 0),

	MX7D_PAD_ECSPI1_MOSI__ECSPI1_MOSI                        = IOMUX_PAD(0x03DC, 0x016C, 0, 0x052C, 1, 0),
	MX7D_PAD_ECSPI1_MOSI__UART6_DCE_TX                       = IOMUX_PAD(0x03DC, 0x016C, 1, 0x0000, 0, 0),
	MX7D_PAD_ECSPI1_MOSI__UART6_DTE_RX                       = IOMUX_PAD(0x03DC, 0x016C, 1, 0x071C, 3, 0),
	MX7D_PAD_ECSPI1_MOSI__SD2_DATA5                          = IOMUX_PAD(0x03DC, 0x016C, 2, 0x0000, 0, 0),
	MX7D_PAD_ECSPI1_MOSI__CSI_DATA3                          = IOMUX_PAD(0x03DC, 0x016C, 3, 0x04FC, 1, 0),
	MX7D_PAD_ECSPI1_MOSI__GPIO4_IO17                         = IOMUX_PAD(0x03DC, 0x016C, 5, 0x0000, 0, 0),
	MX7D_PAD_ECSPI1_MOSI__EPDC_PWR_STAT                      = IOMUX_PAD(0x03DC, 0x016C, 6, 0x0580, 1, 0),

	MX7D_PAD_ECSPI1_MISO__ECSPI1_MISO                        = IOMUX_PAD(0x03E0, 0x0170, 0, 0x0528, 1, 0),
	MX7D_PAD_ECSPI1_MISO__UART6_DCE_RTS                      = IOMUX_PAD(0x03E0, 0x0170, 1, 0x0718, 2, 0),
	MX7D_PAD_ECSPI1_MISO__UART6_DTE_CTS                      = IOMUX_PAD(0x03E0, 0x0170, 1, 0x0000, 0, 0),
	MX7D_PAD_ECSPI1_MISO__SD2_DATA6                          = IOMUX_PAD(0x03E0, 0x0170, 2, 0x0000, 0, 0),
	MX7D_PAD_ECSPI1_MISO__CSI_DATA4                          = IOMUX_PAD(0x03E0, 0x0170, 3, 0x0500, 1, 0),
	MX7D_PAD_ECSPI1_MISO__GPIO4_IO18                         = IOMUX_PAD(0x03E0, 0x0170, 5, 0x0000, 0, 0),
	MX7D_PAD_ECSPI1_MISO__EPDC_PWR_IRQ                       = IOMUX_PAD(0x03E0, 0x0170, 6, 0x057C, 0, 0),

	MX7D_PAD_ECSPI1_SS0__ECSPI1_SS0                          = IOMUX_PAD(0x03E4, 0x0174, 0, 0x0530, 1, 0),
	MX7D_PAD_ECSPI1_SS0__UART6_DCE_CTS                       = IOMUX_PAD(0x03E4, 0x0174, 1, 0x0000, 0, 0),
	MX7D_PAD_ECSPI1_SS0__UART6_DTE_RTS                       = IOMUX_PAD(0x03E4, 0x0174, 1, 0x0718, 3, 0),
	MX7D_PAD_ECSPI1_SS0__SD2_DATA7                           = IOMUX_PAD(0x03E4, 0x0174, 2, 0x0000, 0, 0),
	MX7D_PAD_ECSPI1_SS0__CSI_DATA5                           = IOMUX_PAD(0x03E4, 0x0174, 3, 0x0504, 1, 0),
	MX7D_PAD_ECSPI1_SS0__GPIO4_IO19                          = IOMUX_PAD(0x03E4, 0x0174, 5, 0x0000, 0, 0),
	MX7D_PAD_ECSPI1_SS0__EPDC_PWR_CTRL3                      = IOMUX_PAD(0x03E4, 0x0174, 6, 0x0000, 0, 0),

	MX7D_PAD_ECSPI2_SCLK__ECSPI2_SCLK                        = IOMUX_PAD(0x03E8, 0x0178, 0, 0x0534, 0, 0),
	MX7D_PAD_ECSPI2_SCLK__UART7_DCE_RX                       = IOMUX_PAD(0x03E8, 0x0178, 1, 0x0724, 2, 0),
	MX7D_PAD_ECSPI2_SCLK__UART7_DTE_TX                       = IOMUX_PAD(0x03E8, 0x0178, 1, 0x0000, 0, 0),
	MX7D_PAD_ECSPI2_SCLK__SD1_DATA4                          = IOMUX_PAD(0x03E8, 0x0178, 2, 0x0000, 0, 0),
	MX7D_PAD_ECSPI2_SCLK__CSI_DATA6                          = IOMUX_PAD(0x03E8, 0x0178, 3, 0x0508, 1, 0),
	MX7D_PAD_ECSPI2_SCLK__LCD_DATA13                         = IOMUX_PAD(0x03E8, 0x0178, 4, 0x066C, 2, 0),
	MX7D_PAD_ECSPI2_SCLK__GPIO4_IO20                         = IOMUX_PAD(0x03E8, 0x0178, 5, 0x0000, 0, 0),
	MX7D_PAD_ECSPI2_SCLK__EPDC_PWR_CTRL0                     = IOMUX_PAD(0x03E8, 0x0178, 6, 0x0000, 0, 0),

	MX7D_PAD_ECSPI2_MOSI__ECSPI2_MOSI                        = IOMUX_PAD(0x03EC, 0x017C, 0, 0x053C, 0, 0),
	MX7D_PAD_ECSPI2_MOSI__UART7_DCE_TX                       = IOMUX_PAD(0x03EC, 0x017C, 1, 0x0000, 0, 0),
	MX7D_PAD_ECSPI2_MOSI__UART7_DTE_RX                       = IOMUX_PAD(0x03EC, 0x017C, 1, 0x0724, 3, 0),
	MX7D_PAD_ECSPI2_MOSI__SD1_DATA5                          = IOMUX_PAD(0x03EC, 0x017C, 2, 0x0000, 0, 0),
	MX7D_PAD_ECSPI2_MOSI__CSI_DATA7                          = IOMUX_PAD(0x03EC, 0x017C, 3, 0x050C, 1, 0),
	MX7D_PAD_ECSPI2_MOSI__LCD_DATA14                         = IOMUX_PAD(0x03EC, 0x017C, 4, 0x0670, 2, 0),
	MX7D_PAD_ECSPI2_MOSI__GPIO4_IO21                         = IOMUX_PAD(0x03EC, 0x017C, 5, 0x0000, 0, 0),
	MX7D_PAD_ECSPI2_MOSI__EPDC_PWR_CTRL1                     = IOMUX_PAD(0x03EC, 0x017C, 6, 0x0000, 0, 0),
	MX7D_PAD_ECSPI2_MISO__GPIO4_IO22                         = IOMUX_PAD(0x03F0, 0x0180, 5, 0x0000, 0, 0),
	MX7D_PAD_ECSPI2_MISO__EPDC_PWR_CTRL2                     = IOMUX_PAD(0x03F0, 0x0180, 6, 0x0000, 0, 0),

	MX7D_PAD_ECSPI2_MISO__ECSPI2_MISO                        = IOMUX_PAD(0x03F0, 0x0180, 0, 0x0538, 0, 0),
	MX7D_PAD_ECSPI2_MISO__UART7_DCE_RTS                      = IOMUX_PAD(0x03F0, 0x0180, 1, 0x0720, 2, 0),
	MX7D_PAD_ECSPI2_MISO__UART7_DTE_CTS                      = IOMUX_PAD(0x03F0, 0x0180, 1, 0x0000, 0, 0),
	MX7D_PAD_ECSPI2_MISO__SD1_DATA6                          = IOMUX_PAD(0x03F0, 0x0180, 2, 0x0000, 0, 0),
	MX7D_PAD_ECSPI2_MISO__CSI_DATA8                          = IOMUX_PAD(0x03F0, 0x0180, 3, 0x0510, 1, 0),
	MX7D_PAD_ECSPI2_MISO__LCD_DATA15                         = IOMUX_PAD(0x03F0, 0x0180, 4, 0x0674, 2, 0),

	MX7D_PAD_ECSPI2_SS0__ECSPI2_SS0                          = IOMUX_PAD(0x03F4, 0x0184, 0, 0x0540, 0, 0),
	MX7D_PAD_ECSPI2_SS0__UART7_DCE_CTS                       = IOMUX_PAD(0x03F4, 0x0184, 1, 0x0000, 0, 0),
	MX7D_PAD_ECSPI2_SS0__UART7_DTE_RTS                       = IOMUX_PAD(0x03F4, 0x0184, 1, 0x0720, 3, 0),
	MX7D_PAD_ECSPI2_SS0__SD1_DATA7                           = IOMUX_PAD(0x03F4, 0x0184, 2, 0x0000, 0, 0),
	MX7D_PAD_ECSPI2_SS0__CSI_DATA9                           = IOMUX_PAD(0x03F4, 0x0184, 3, 0x0514, 1, 0),
	MX7D_PAD_ECSPI2_SS0__LCD_RESET                           = IOMUX_PAD(0x03F4, 0x0184, 4, 0x0000, 0, 0),
	MX7D_PAD_ECSPI2_SS0__GPIO4_IO23                          = IOMUX_PAD(0x03F4, 0x0184, 5, 0x0000, 0, 0),
	MX7D_PAD_ECSPI2_SS0__EPDC_PWR_WAKE                       = IOMUX_PAD(0x03F4, 0x0184, 6, 0x0000, 0, 0),

	MX7D_PAD_SD1_CD_B__SD1_CD_B                              = IOMUX_PAD(0x03F8, 0x0188, 0, 0x0000, 0, 0),
	MX7D_PAD_SD1_CD_B__UART6_DCE_RX                          = IOMUX_PAD(0x03F8, 0x0188, 2, 0x071C, 4, 0),
	MX7D_PAD_SD1_CD_B__UART6_DTE_TX                          = IOMUX_PAD(0x03F8, 0x0188, 2, 0x0000, 0, 0),
	MX7D_PAD_SD1_CD_B__ECSPI4_MISO                           = IOMUX_PAD(0x03F8, 0x0188, 3, 0x0558, 1, 0),
	MX7D_PAD_SD1_CD_B__FLEXTIMER1_CH0                        = IOMUX_PAD(0x03F8, 0x0188, 4, 0x0584, 1, 0),
	MX7D_PAD_SD1_CD_B__GPIO5_IO0                             = IOMUX_PAD(0x03F8, 0x0188, 5, 0x0000, 0, 0),
	MX7D_PAD_SD1_CD_B__CCM_CLKO1                             = IOMUX_PAD(0x03F8, 0x0188, 6, 0x0000, 0, 0),

	MX7D_PAD_SD1_WP__SD1_WP                                  = IOMUX_PAD(0x03FC, 0x018C, 0, 0x0000, 0, 0),
	MX7D_PAD_SD1_WP__UART6_DCE_TX                            = IOMUX_PAD(0x03FC, 0x018C, 2, 0x0000, 0, 0),
	MX7D_PAD_SD1_WP__UART6_DTE_RX                            = IOMUX_PAD(0x03FC, 0x018C, 2, 0x071C, 5, 0),
	MX7D_PAD_SD1_WP__ECSPI4_MOSI                             = IOMUX_PAD(0x03FC, 0x018C, 3, 0x055C, 1, 0),
	MX7D_PAD_SD1_WP__FLEXTIMER1_CH1                          = IOMUX_PAD(0x03FC, 0x018C, 4, 0x0588, 1, 0),
	MX7D_PAD_SD1_WP__GPIO5_IO1                               = IOMUX_PAD(0x03FC, 0x018C, 5, 0x0000, 0, 0),
	MX7D_PAD_SD1_WP__CCM_CLKO2                               = IOMUX_PAD(0x03FC, 0x018C, 6, 0x0000, 0, 0),

	MX7D_PAD_SD1_RESET_B__SD1_RESET_B                        = IOMUX_PAD(0x0400, 0x0190, 0, 0x0000, 0, 0),
	MX7D_PAD_SD1_RESET_B__SAI3_MCLK                          = IOMUX_PAD(0x0400, 0x0190, 1, 0x0000, 0, 0),
	MX7D_PAD_SD1_RESET_B__UART6_DCE_RTS                      = IOMUX_PAD(0x0400, 0x0190, 2, 0x0718, 4, 0),
	MX7D_PAD_SD1_RESET_B__UART6_DTE_CTS                      = IOMUX_PAD(0x0400, 0x0190, 2, 0x0000, 0, 0),
	MX7D_PAD_SD1_RESET_B__ECSPI4_SCLK                        = IOMUX_PAD(0x0400, 0x0190, 3, 0x0554, 1, 0),
	MX7D_PAD_SD1_RESET_B__FLEXTIMER1_CH2                     = IOMUX_PAD(0x0400, 0x0190, 4, 0x058C, 1, 0),
	MX7D_PAD_SD1_RESET_B__GPIO5_IO2                          = IOMUX_PAD(0x0400, 0x0190, 5, 0x0000, 0, 0),

	MX7D_PAD_SD1_CLK__SD1_CLK                                = IOMUX_PAD(0x0404, 0x0194, 0, 0x0000, 0, 0),
	MX7D_PAD_SD1_CLK__SAI3_RX_SYNC                           = IOMUX_PAD(0x0404, 0x0194, 1, 0x06CC, 1, 0),
	MX7D_PAD_SD1_CLK__UART6_DCE_CTS                          = IOMUX_PAD(0x0404, 0x0194, 2, 0x0000, 0, 0),
	MX7D_PAD_SD1_CLK__UART6_DTE_RTS                          = IOMUX_PAD(0x0404, 0x0194, 2, 0x0718, 5, 0),
	MX7D_PAD_SD1_CLK__ECSPI4_SS0                             = IOMUX_PAD(0x0404, 0x0194, 3, 0x0560, 1, 0),
	MX7D_PAD_SD1_CLK__FLEXTIMER1_CH3                         = IOMUX_PAD(0x0404, 0x0194, 4, 0x0590, 1, 0),
	MX7D_PAD_SD1_CLK__GPIO5_IO3                              = IOMUX_PAD(0x0404, 0x0194, 5, 0x0000, 0, 0),

	MX7D_PAD_SD1_CMD__SD1_CMD                                = IOMUX_PAD(0x0408, 0x0198, 0, 0x0000, 0, 0),
	MX7D_PAD_SD1_CMD__SAI3_RX_BCLK                           = IOMUX_PAD(0x0408, 0x0198, 1, 0x06C4, 1, 0),
	MX7D_PAD_SD1_CMD__ECSPI4_SS1                             = IOMUX_PAD(0x0408, 0x0198, 3, 0x0000, 0, 0),
	MX7D_PAD_SD1_CMD__FLEXTIMER2_CH0                         = IOMUX_PAD(0x0408, 0x0198, 4, 0x05AC, 1, 0),
	MX7D_PAD_SD1_CMD__GPIO5_IO4                              = IOMUX_PAD(0x0408, 0x0198, 5, 0x0000, 0, 0),

	MX7D_PAD_SD1_DATA0__SD1_DATA0                            = IOMUX_PAD(0x040C, 0x019C, 0, 0x0000, 0, 0),
	MX7D_PAD_SD1_DATA0__SAI3_RX_DATA0                        = IOMUX_PAD(0x040C, 0x019C, 1, 0x06C8, 1, 0),
	MX7D_PAD_SD1_DATA0__UART7_DCE_RX                         = IOMUX_PAD(0x040C, 0x019C, 2, 0x0724, 4, 0),
	MX7D_PAD_SD1_DATA0__UART7_DTE_TX                         = IOMUX_PAD(0x040C, 0x019C, 2, 0x0000, 0, 0),
	MX7D_PAD_SD1_DATA0__ECSPI4_SS2                           = IOMUX_PAD(0x040C, 0x019C, 3, 0x0000, 0, 0),
	MX7D_PAD_SD1_DATA0__FLEXTIMER2_CH1                       = IOMUX_PAD(0x040C, 0x019C, 4, 0x05B0, 1, 0),
	MX7D_PAD_SD1_DATA0__GPIO5_IO5                            = IOMUX_PAD(0x040C, 0x019C, 5, 0x0000, 0, 0),
	MX7D_PAD_SD1_DATA0__CCM_EXT_CLK1                         = IOMUX_PAD(0x040C, 0x019C, 6, 0x04E4, 1, 0),

	MX7D_PAD_SD1_DATA1__SD1_DATA1                            = IOMUX_PAD(0x0410, 0x01A0, 0, 0x0000, 0, 0),
	MX7D_PAD_SD1_DATA1__SAI3_TX_BCLK                         = IOMUX_PAD(0x0410, 0x01A0, 1, 0x06D0, 1, 0),
	MX7D_PAD_SD1_DATA1__UART7_DCE_TX                         = IOMUX_PAD(0x0410, 0x01A0, 2, 0x0000, 0, 0),
	MX7D_PAD_SD1_DATA1__UART7_DTE_RX                         = IOMUX_PAD(0x0410, 0x01A0, 2, 0x0724, 5, 0),
	MX7D_PAD_SD1_DATA1__ECSPI4_SS3                           = IOMUX_PAD(0x0410, 0x01A0, 3, 0x0000, 0, 0),
	MX7D_PAD_SD1_DATA1__FLEXTIMER2_CH2                       = IOMUX_PAD(0x0410, 0x01A0, 4, 0x05B4, 1, 0),
	MX7D_PAD_SD1_DATA1__GPIO5_IO6                            = IOMUX_PAD(0x0410, 0x01A0, 5, 0x0000, 0, 0),
	MX7D_PAD_SD1_DATA1__CCM_EXT_CLK2                         = IOMUX_PAD(0x0410, 0x01A0, 6, 0x04E8, 1, 0),

	MX7D_PAD_SD1_DATA2__SD1_DATA2                            = IOMUX_PAD(0x0414, 0x01A4, 0, 0x0000, 0, 0),
	MX7D_PAD_SD1_DATA2__SAI3_TX_SYNC                         = IOMUX_PAD(0x0414, 0x01A4, 1, 0x06D4, 1, 0),
	MX7D_PAD_SD1_DATA2__UART7_DCE_CTS                        = IOMUX_PAD(0x0414, 0x01A4, 2, 0x0000, 0, 0),
	MX7D_PAD_SD1_DATA2__UART7_DTE_RTS                        = IOMUX_PAD(0x0414, 0x01A4, 2, 0x0720, 4, 0),
	MX7D_PAD_SD1_DATA2__ECSPI4_RDY                           = IOMUX_PAD(0x0414, 0x01A4, 3, 0x0000, 0, 0),
	MX7D_PAD_SD1_DATA2__FLEXTIMER2_CH3                       = IOMUX_PAD(0x0414, 0x01A4, 4, 0x05B8, 1, 0),
	MX7D_PAD_SD1_DATA2__GPIO5_IO7                            = IOMUX_PAD(0x0414, 0x01A4, 5, 0x0000, 0, 0),
	MX7D_PAD_SD1_DATA2__CCM_EXT_CLK3                         = IOMUX_PAD(0x0414, 0x01A4, 6, 0x04EC, 1, 0),

	MX7D_PAD_SD1_DATA3__SD1_DATA3                            = IOMUX_PAD(0x0418, 0x01A8, 0, 0x0000, 0, 0),
	MX7D_PAD_SD1_DATA3__SAI3_TX_DATA0                        = IOMUX_PAD(0x0418, 0x01A8, 1, 0x0000, 0, 0),
	MX7D_PAD_SD1_DATA3__UART7_DCE_RTS                        = IOMUX_PAD(0x0418, 0x01A8, 2, 0x0720, 5, 0),
	MX7D_PAD_SD1_DATA3__UART7_DTE_CTS                        = IOMUX_PAD(0x0418, 0x01A8, 2, 0x0000, 0, 0),
	MX7D_PAD_SD1_DATA3__ECSPI3_SS1                           = IOMUX_PAD(0x0418, 0x01A8, 3, 0x0000, 0, 0),
	MX7D_PAD_SD1_DATA3__FLEXTIMER1_PHA                       = IOMUX_PAD(0x0418, 0x01A8, 4, 0x05A4, 1, 0),
	MX7D_PAD_SD1_DATA3__GPIO5_IO8                            = IOMUX_PAD(0x0418, 0x01A8, 5, 0x0000, 0, 0),
	MX7D_PAD_SD1_DATA3__CCM_EXT_CLK4                         = IOMUX_PAD(0x0418, 0x01A8, 6, 0x04F0, 1, 0),

	MX7D_PAD_SD2_CD_B__SD2_CD_B                              = IOMUX_PAD(0x041C, 0x01AC, 0, 0x0000, 0, 0),
	MX7D_PAD_SD2_CD_B__ENET1_MDIO                            = IOMUX_PAD(0x041C, 0x01AC, 1, 0x0568, 2, 0),
	MX7D_PAD_SD2_CD_B__ENET2_MDIO                            = IOMUX_PAD(0x041C, 0x01AC, 2, 0x0574, 2, 0),
	MX7D_PAD_SD2_CD_B__ECSPI3_SS2                            = IOMUX_PAD(0x041C, 0x01AC, 3, 0x0000, 0, 0),
	MX7D_PAD_SD2_CD_B__FLEXTIMER1_PHB                        = IOMUX_PAD(0x041C, 0x01AC, 4, 0x05A8, 1, 0),
	MX7D_PAD_SD2_CD_B__GPIO5_IO9                             = IOMUX_PAD(0x041C, 0x01AC, 5, 0x0000, 0, 0),
	MX7D_PAD_SD2_CD_B__SDMA_EXT_EVENT0                       = IOMUX_PAD(0x041C, 0x01AC, 6, 0x06D8, 2, 0),

	MX7D_PAD_SD2_WP__SD2_WP                                  = IOMUX_PAD(0x0420, 0x01B0, 0, 0x0000, 0, 0),
	MX7D_PAD_SD2_WP__ENET1_MDC                               = IOMUX_PAD(0x0420, 0x01B0, 1, 0x0000, 0, 0),
	MX7D_PAD_SD2_WP__ENET2_MDC                               = IOMUX_PAD(0x0420, 0x01B0, 2, 0x0000, 0, 0),
	MX7D_PAD_SD2_WP__ECSPI3_SS3                              = IOMUX_PAD(0x0420, 0x01B0, 3, 0x0000, 0, 0),
	MX7D_PAD_SD2_WP__USB_OTG1_ID                             = IOMUX_PAD(0x0420, 0x01B0, 4, 0x0734, 2, 0),
	MX7D_PAD_SD2_WP__GPIO5_IO10                              = IOMUX_PAD(0x0420, 0x01B0, 5, 0x0000, 0, 0),
	MX7D_PAD_SD2_WP__SDMA_EXT_EVENT1                         = IOMUX_PAD(0x0420, 0x01B0, 6, 0x06DC, 2, 0),

	MX7D_PAD_SD2_RESET_B__SD2_RESET_B                        = IOMUX_PAD(0x0424, 0x01B4, 0, 0x0000, 0, 0),
	MX7D_PAD_SD2_RESET_B__SAI2_MCLK                          = IOMUX_PAD(0x0424, 0x01B4, 1, 0x0000, 0, 0),
	MX7D_PAD_SD2_RESET_B__SD2_RESET                          = IOMUX_PAD(0x0424, 0x01B4, 2, 0x0000, 0, 0),
	MX7D_PAD_SD2_RESET_B__ECSPI3_RDY                         = IOMUX_PAD(0x0424, 0x01B4, 3, 0x0000, 0, 0),
	MX7D_PAD_SD2_RESET_B__USB_OTG2_ID                        = IOMUX_PAD(0x0424, 0x01B4, 4, 0x0730, 2, 0),
	MX7D_PAD_SD2_RESET_B__GPIO5_IO11                         = IOMUX_PAD(0x0424, 0x01B4, 5, 0x0000, 0, 0),

	MX7D_PAD_SD2_CLK__SD2_CLK                                = IOMUX_PAD(0x0428, 0x01B8, 0, 0x0000, 0, 0),
	MX7D_PAD_SD2_CLK__SAI2_RX_SYNC                           = IOMUX_PAD(0x0428, 0x01B8, 1, 0x06B8, 0, 0),
	MX7D_PAD_SD2_CLK__MQS_RIGHT                              = IOMUX_PAD(0x0428, 0x01B8, 2, 0x0000, 0, 0),
	MX7D_PAD_SD2_CLK__GPT4_CLK                               = IOMUX_PAD(0x0428, 0x01B8, 3, 0x0000, 0, 0),
	MX7D_PAD_SD2_CLK__GPIO5_IO12                             = IOMUX_PAD(0x0428, 0x01B8, 5, 0x0000, 0, 0),

	MX7D_PAD_SD2_CMD__SD2_CMD                                = IOMUX_PAD(0x042C, 0x01BC, 0, 0x0000, 0, 0),
	MX7D_PAD_SD2_CMD__SAI2_RX_BCLK                           = IOMUX_PAD(0x042C, 0x01BC, 1, 0x06B0, 0, 0),
	MX7D_PAD_SD2_CMD__MQS_LEFT                               = IOMUX_PAD(0x042C, 0x01BC, 2, 0x0000, 0, 0),
	MX7D_PAD_SD2_CMD__GPT4_CAPTURE1                          = IOMUX_PAD(0x042C, 0x01BC, 3, 0x0000, 0, 0),
	MX7D_PAD_SD2_CMD__SIM2_PORT1_TRXD                        = IOMUX_PAD(0x042C, 0x01BC, 4, 0x06EC, 1, 0),
	MX7D_PAD_SD2_CMD__GPIO5_IO13                             = IOMUX_PAD(0x042C, 0x01BC, 5, 0x0000, 0, 0),

	MX7D_PAD_SD2_DATA0__SD2_DATA0                            = IOMUX_PAD(0x0430, 0x01C0, 0, 0x0000, 0, 0),
	MX7D_PAD_SD2_DATA0__SAI2_RX_DATA0                        = IOMUX_PAD(0x0430, 0x01C0, 1, 0x06B4, 0, 0),
	MX7D_PAD_SD2_DATA0__UART4_DCE_RX                         = IOMUX_PAD(0x0430, 0x01C0, 2, 0x070C, 2, 0),
	MX7D_PAD_SD2_DATA0__UART4_DTE_TX                         = IOMUX_PAD(0x0430, 0x01C0, 2, 0x0000, 0, 0),
	MX7D_PAD_SD2_DATA0__GPT4_CAPTURE2                        = IOMUX_PAD(0x0430, 0x01C0, 3, 0x0000, 0, 0),
	MX7D_PAD_SD2_DATA0__SIM2_PORT1_CLK                       = IOMUX_PAD(0x0430, 0x01C0, 4, 0x0000, 0, 0),
	MX7D_PAD_SD2_DATA0__GPIO5_IO14                           = IOMUX_PAD(0x0430, 0x01C0, 5, 0x0000, 0, 0),

	MX7D_PAD_SD2_DATA1__SD2_DATA1                            = IOMUX_PAD(0x0434, 0x01C4, 0, 0x0000, 0, 0),
	MX7D_PAD_SD2_DATA1__SAI2_TX_BCLK                         = IOMUX_PAD(0x0434, 0x01C4, 1, 0x06BC, 0, 0),
	MX7D_PAD_SD2_DATA1__UART4_DCE_TX                         = IOMUX_PAD(0x0434, 0x01C4, 2, 0x0000, 0, 0),
	MX7D_PAD_SD2_DATA1__UART4_DTE_RX                         = IOMUX_PAD(0x0434, 0x01C4, 2, 0x070C, 3, 0),
	MX7D_PAD_SD2_DATA1__GPT4_COMPARE1                        = IOMUX_PAD(0x0434, 0x01C4, 3, 0x0000, 0, 0),
	MX7D_PAD_SD2_DATA1__SIM2_PORT1_RST_B                     = IOMUX_PAD(0x0434, 0x01C4, 4, 0x0000, 0, 0),
	MX7D_PAD_SD2_DATA1__GPIO5_IO15                           = IOMUX_PAD(0x0434, 0x01C4, 5, 0x0000, 0, 0),

	MX7D_PAD_SD2_DATA2__SD2_DATA2                            = IOMUX_PAD(0x0438, 0x01C8, 0, 0x0000, 0, 0),
	MX7D_PAD_SD2_DATA2__SAI2_TX_SYNC                         = IOMUX_PAD(0x0438, 0x01C8, 1, 0x06C0, 0, 0),
	MX7D_PAD_SD2_DATA2__UART4_DCE_CTS                        = IOMUX_PAD(0x0438, 0x01C8, 2, 0x0000, 0, 0),
	MX7D_PAD_SD2_DATA2__UART4_DTE_RTS                        = IOMUX_PAD(0x0438, 0x01C8, 2, 0x0708, 2, 0),
	MX7D_PAD_SD2_DATA2__GPT4_COMPARE2                        = IOMUX_PAD(0x0438, 0x01C8, 3, 0x0000, 0, 0),
	MX7D_PAD_SD2_DATA2__SIM2_PORT1_SVEN                      = IOMUX_PAD(0x0438, 0x01C8, 4, 0x0000, 0, 0),
	MX7D_PAD_SD2_DATA2__GPIO5_IO16                           = IOMUX_PAD(0x0438, 0x01C8, 5, 0x0000, 0, 0),

	MX7D_PAD_SD2_DATA3__SD2_DATA3                            = IOMUX_PAD(0x043C, 0x01CC, 0, 0x0000, 0, 0),
	MX7D_PAD_SD2_DATA3__SAI2_TX_DATA0                        = IOMUX_PAD(0x043C, 0x01CC, 1, 0x0000, 0, 0),
	MX7D_PAD_SD2_DATA3__UART4_DCE_RTS                        = IOMUX_PAD(0x043C, 0x01CC, 2, 0x0708, 3, 0),
	MX7D_PAD_SD2_DATA3__UART4_DTE_CTS                        = IOMUX_PAD(0x043C, 0x01CC, 2, 0x0000, 0, 0),
	MX7D_PAD_SD2_DATA3__GPT4_COMPARE3                        = IOMUX_PAD(0x043C, 0x01CC, 3, 0x0000, 0, 0),
	MX7D_PAD_SD2_DATA3__SIM2_PORT1_PD                        = IOMUX_PAD(0x043C, 0x01CC, 4, 0x06E8, 1, 0),
	MX7D_PAD_SD2_DATA3__GPIO5_IO17                           = IOMUX_PAD(0x043C, 0x01CC, 5, 0x0000, 0, 0),

	MX7D_PAD_SD3_CLK__SD3_CLK                                = IOMUX_PAD(0x0440, 0x01D0, 0, 0x0000, 0, 0),
	MX7D_PAD_SD3_CLK__NAND_CLE                               = IOMUX_PAD(0x0440, 0x01D0, 1, 0x0000, 0, 0),
	MX7D_PAD_SD3_CLK__ECSPI4_MISO                            = IOMUX_PAD(0x0440, 0x01D0, 2, 0x0558, 2, 0),
	MX7D_PAD_SD3_CLK__SAI3_RX_SYNC                           = IOMUX_PAD(0x0440, 0x01D0, 3, 0x06CC, 2, 0),
	MX7D_PAD_SD3_CLK__GPT3_CLK                               = IOMUX_PAD(0x0440, 0x01D0, 4, 0x0000, 0, 0),
	MX7D_PAD_SD3_CLK__GPIO6_IO0                              = IOMUX_PAD(0x0440, 0x01D0, 5, 0x0000, 0, 0),

	MX7D_PAD_SD3_CMD__SD3_CMD                                = IOMUX_PAD(0x0444, 0x01D4, 0, 0x0000, 0, 0),
	MX7D_PAD_SD3_CMD__NAND_ALE                               = IOMUX_PAD(0x0444, 0x01D4, 1, 0x0000, 0, 0),
	MX7D_PAD_SD3_CMD__ECSPI4_MOSI                            = IOMUX_PAD(0x0444, 0x01D4, 2, 0x055C, 2, 0),
	MX7D_PAD_SD3_CMD__SAI3_RX_BCLK                           = IOMUX_PAD(0x0444, 0x01D4, 3, 0x06C4, 2, 0),
	MX7D_PAD_SD3_CMD__GPT3_CAPTURE1                          = IOMUX_PAD(0x0444, 0x01D4, 4, 0x0000, 0, 0),
	MX7D_PAD_SD3_CMD__GPIO6_IO1                              = IOMUX_PAD(0x0444, 0x01D4, 5, 0x0000, 0, 0),

	MX7D_PAD_SD3_DATA0__SD3_DATA0                            = IOMUX_PAD(0x0448, 0x01D8, 0, 0x0000, 0, 0),
	MX7D_PAD_SD3_DATA0__NAND_DATA00                          = IOMUX_PAD(0x0448, 0x01D8, 1, 0x0000, 0, 0),
	MX7D_PAD_SD3_DATA0__ECSPI4_SS0                           = IOMUX_PAD(0x0448, 0x01D8, 2, 0x0560, 2, 0),
	MX7D_PAD_SD3_DATA0__SAI3_RX_DATA0                        = IOMUX_PAD(0x0448, 0x01D8, 3, 0x06C8, 2, 0),
	MX7D_PAD_SD3_DATA0__GPT3_CAPTURE2                        = IOMUX_PAD(0x0448, 0x01D8, 4, 0x0000, 0, 0),
	MX7D_PAD_SD3_DATA0__GPIO6_IO2                            = IOMUX_PAD(0x0448, 0x01D8, 5, 0x0000, 0, 0),

	MX7D_PAD_SD3_DATA1__SD3_DATA1                            = IOMUX_PAD(0x044C, 0x01DC, 0, 0x0000, 0, 0),
	MX7D_PAD_SD3_DATA1__NAND_DATA01                          = IOMUX_PAD(0x044C, 0x01DC, 1, 0x0000, 0, 0),
	MX7D_PAD_SD3_DATA1__ECSPI4_SCLK                          = IOMUX_PAD(0x044C, 0x01DC, 2, 0x0554, 2, 0),
	MX7D_PAD_SD3_DATA1__SAI3_TX_BCLK                         = IOMUX_PAD(0x044C, 0x01DC, 3, 0x06D0, 2, 0),
	MX7D_PAD_SD3_DATA1__GPT3_COMPARE1                        = IOMUX_PAD(0x044C, 0x01DC, 4, 0x0000, 0, 0),
	MX7D_PAD_SD3_DATA1__GPIO6_IO3                            = IOMUX_PAD(0x044C, 0x01DC, 5, 0x0000, 0, 0),

	MX7D_PAD_SD3_DATA2__SD3_DATA2                            = IOMUX_PAD(0x0450, 0x01E0, 0, 0x0000, 0, 0),
	MX7D_PAD_SD3_DATA2__NAND_DATA02                          = IOMUX_PAD(0x0450, 0x01E0, 1, 0x0000, 0, 0),
	MX7D_PAD_SD3_DATA2__I2C3_SDA                             = IOMUX_PAD(0x0450, 0x01E0, IOMUX_CONFIG_SION | 2, 0x05E8, 3, 0),
	MX7D_PAD_SD3_DATA2__SAI3_TX_SYNC                         = IOMUX_PAD(0x0450, 0x01E0, 3, 0x06D4, 2, 0),
	MX7D_PAD_SD3_DATA2__GPT3_COMPARE2                        = IOMUX_PAD(0x0450, 0x01E0, 4, 0x0000, 0, 0),
	MX7D_PAD_SD3_DATA2__GPIO6_IO4                            = IOMUX_PAD(0x0450, 0x01E0, 5, 0x0000, 0, 0),

	MX7D_PAD_SD3_DATA3__SD3_DATA3                            = IOMUX_PAD(0x0454, 0x01E4, 0, 0x0000, 0, 0),
	MX7D_PAD_SD3_DATA3__NAND_DATA03                          = IOMUX_PAD(0x0454, 0x01E4, 1, 0x0000, 0, 0),
	MX7D_PAD_SD3_DATA3__I2C3_SCL                             = IOMUX_PAD(0x0454, 0x01E4, IOMUX_CONFIG_SION | 2, 0x05E4, 3, 0),
	MX7D_PAD_SD3_DATA3__SAI3_TX_DATA0                        = IOMUX_PAD(0x0454, 0x01E4, 3, 0x0000, 0, 0),
	MX7D_PAD_SD3_DATA3__GPT3_COMPARE3                        = IOMUX_PAD(0x0454, 0x01E4, 4, 0x0000, 0, 0),
	MX7D_PAD_SD3_DATA3__GPIO6_IO5                            = IOMUX_PAD(0x0454, 0x01E4, 5, 0x0000, 0, 0),

	MX7D_PAD_SD3_DATA4__SD3_DATA4                            = IOMUX_PAD(0x0458, 0x01E8, 0, 0x0000, 0, 0),
	MX7D_PAD_SD3_DATA4__NAND_DATA04                          = IOMUX_PAD(0x0458, 0x01E8, 1, 0x0000, 0, 0),
	MX7D_PAD_SD3_DATA4__UART3_DCE_RX                         = IOMUX_PAD(0x0458, 0x01E8, 3, 0x0704, 4, 0),
	MX7D_PAD_SD3_DATA4__UART3_DTE_TX                         = IOMUX_PAD(0x0458, 0x01E8, 3, 0x0000, 0, 0),
	MX7D_PAD_SD3_DATA4__FLEXCAN2_RX                          = IOMUX_PAD(0x0458, 0x01E8, 4, 0x04E0, 2, 0),
	MX7D_PAD_SD3_DATA4__GPIO6_IO6                            = IOMUX_PAD(0x0458, 0x01E8, 5, 0x0000, 0, 0),

	MX7D_PAD_SD3_DATA5__SD3_DATA5                            = IOMUX_PAD(0x045C, 0x01EC, 0, 0x0000, 0, 0),
	MX7D_PAD_SD3_DATA5__NAND_DATA05                          = IOMUX_PAD(0x045C, 0x01EC, 1, 0x0000, 0, 0),
	MX7D_PAD_SD3_DATA5__UART3_DCE_TX                         = IOMUX_PAD(0x045C, 0x01EC, 3, 0x0000, 0, 0),
	MX7D_PAD_SD3_DATA5__UART3_DTE_RX                         = IOMUX_PAD(0x045C, 0x01EC, 3, 0x0704, 5, 0),
	MX7D_PAD_SD3_DATA5__FLEXCAN1_TX                          = IOMUX_PAD(0x045C, 0x01EC, 4, 0x0000, 0, 0),
	MX7D_PAD_SD3_DATA5__GPIO6_IO7                            = IOMUX_PAD(0x045C, 0x01EC, 5, 0x0000, 0, 0),

	MX7D_PAD_SD3_DATA6__SD3_DATA6                            = IOMUX_PAD(0x0460, 0x01F0, 0, 0x0000, 0, 0),
	MX7D_PAD_SD3_DATA6__NAND_DATA06                          = IOMUX_PAD(0x0460, 0x01F0, 1, 0x0000, 0, 0),
	MX7D_PAD_SD3_DATA6__SD3_WP                               = IOMUX_PAD(0x0460, 0x01F0, 2, 0x073C, 2, 0),
	MX7D_PAD_SD3_DATA6__UART3_DCE_RTS                        = IOMUX_PAD(0x0460, 0x01F0, 3, 0x0700, 4, 0),
	MX7D_PAD_SD3_DATA6__UART3_DTE_CTS                        = IOMUX_PAD(0x0460, 0x01F0, 3, 0x0000, 0, 0),
	MX7D_PAD_SD3_DATA6__FLEXCAN2_TX                          = IOMUX_PAD(0x0460, 0x01F0, 4, 0x0000, 0, 0),
	MX7D_PAD_SD3_DATA6__GPIO6_IO8                            = IOMUX_PAD(0x0460, 0x01F0, 5, 0x0000, 0, 0),

	MX7D_PAD_SD3_DATA7__SD3_DATA7                            = IOMUX_PAD(0x0464, 0x01F4, 0, 0x0000, 0, 0),
	MX7D_PAD_SD3_DATA7__NAND_DATA07                          = IOMUX_PAD(0x0464, 0x01F4, 1, 0x0000, 0, 0),
	MX7D_PAD_SD3_DATA7__SD3_CD_B                             = IOMUX_PAD(0x0464, 0x01F4, 2, 0x0738, 2, 0),
	MX7D_PAD_SD3_DATA7__UART3_DCE_CTS                        = IOMUX_PAD(0x0464, 0x01F4, 3, 0x0000, 0, 0),
	MX7D_PAD_SD3_DATA7__UART3_DTE_RTS                        = IOMUX_PAD(0x0464, 0x01F4, 3, 0x0700, 5, 0),
	MX7D_PAD_SD3_DATA7__FLEXCAN1_RX                          = IOMUX_PAD(0x0464, 0x01F4, 4, 0x04DC, 2, 0),
	MX7D_PAD_SD3_DATA7__GPIO6_IO9                            = IOMUX_PAD(0x0464, 0x01F4, 5, 0x0000, 0, 0),

	MX7D_PAD_SD3_STROBE__SD3_STROBE                          = IOMUX_PAD(0x0468, 0x01F8, 0, 0x0000, 0, 0),
	MX7D_PAD_SD3_STROBE__NAND_RE_B                           = IOMUX_PAD(0x0468, 0x01F8, 1, 0x0000, 0, 0),
	MX7D_PAD_SD3_STROBE__GPIO6_IO10                          = IOMUX_PAD(0x0468, 0x01F8, 5, 0x0000, 0, 0),

	MX7D_PAD_SD3_RESET_B__SD3_RESET_B                        = IOMUX_PAD(0x046C, 0x01FC, 0, 0x0000, 0, 0),
	MX7D_PAD_SD3_RESET_B__NAND_WE_B                          = IOMUX_PAD(0x046C, 0x01FC, 1, 0x0000, 0, 0),
	MX7D_PAD_SD3_RESET_B__SD3_RESET                          = IOMUX_PAD(0x046C, 0x01FC, 2, 0x0000, 0, 0),
	MX7D_PAD_SD3_RESET_B__SAI3_MCLK                          = IOMUX_PAD(0x046C, 0x01FC, 3, 0x0000, 0, 0),
	MX7D_PAD_SD3_RESET_B__GPIO6_IO11                         = IOMUX_PAD(0x046C, 0x01FC, 5, 0x0000, 0, 0),

	MX7D_PAD_SAI1_RX_DATA__SAI1_RX_DATA0                     = IOMUX_PAD(0x0470, 0x0200, 0, 0x06A0, 0, 0),
	MX7D_PAD_SAI1_RX_DATA__NAND_CE1_B                        = IOMUX_PAD(0x0470, 0x0200, 1, 0x0000, 0, 0),
	MX7D_PAD_SAI1_RX_DATA__UART5_DCE_RX                      = IOMUX_PAD(0x0470, 0x0200, 2, 0x0714, 2, 0),
	MX7D_PAD_SAI1_RX_DATA__UART5_DTE_TX                      = IOMUX_PAD(0x0470, 0x0200, 2, 0x0000, 0, 0),
	MX7D_PAD_SAI1_RX_DATA__FLEXCAN1_RX                       = IOMUX_PAD(0x0470, 0x0200, 3, 0x04DC, 3, 0),
	MX7D_PAD_SAI1_RX_DATA__SIM1_PORT1_TRXD                   = IOMUX_PAD(0x0470, 0x0200, 4, 0x06E4, 1, 0),
	MX7D_PAD_SAI1_RX_DATA__GPIO6_IO12                        = IOMUX_PAD(0x0470, 0x0200, 5, 0x0000, 0, 0),
	MX7D_PAD_SAI1_RX_DATA__SRC_ANY_PU_RESET                  = IOMUX_PAD(0x0470, 0x0200, 7, 0x0000, 0, 0),

	MX7D_PAD_SAI1_TX_BCLK__SAI1_TX_BCLK                      = IOMUX_PAD(0x0474, 0x0204, 0, 0x06A8, 0, 0),
	MX7D_PAD_SAI1_TX_BCLK__NAND_CE0_B                        = IOMUX_PAD(0x0474, 0x0204, 1, 0x0000, 0, 0),
	MX7D_PAD_SAI1_TX_BCLK__UART5_DCE_TX                      = IOMUX_PAD(0x0474, 0x0204, 2, 0x0000, 0, 0),
	MX7D_PAD_SAI1_TX_BCLK__UART5_DTE_RX                      = IOMUX_PAD(0x0474, 0x0204, 2, 0x0714, 3, 0),
	MX7D_PAD_SAI1_TX_BCLK__FLEXCAN1_TX                       = IOMUX_PAD(0x0474, 0x0204, 3, 0x0000, 0, 0),
	MX7D_PAD_SAI1_TX_BCLK__SIM1_PORT1_CLK                    = IOMUX_PAD(0x0474, 0x0204, 4, 0x0000, 0, 0),
	MX7D_PAD_SAI1_TX_BCLK__GPIO6_IO13                        = IOMUX_PAD(0x0474, 0x0204, 5, 0x0000, 0, 0),
	MX7D_PAD_SAI1_TX_BCLK__SRC_EARLY_RESET                   = IOMUX_PAD(0x0474, 0x0204, 7, 0x0000, 0, 0),

	MX7D_PAD_SAI1_TX_SYNC__SAI1_TX_SYNC                      = IOMUX_PAD(0x0478, 0x0208, 0, 0x06AC, 0, 0),
	MX7D_PAD_SAI1_TX_SYNC__NAND_DQS                          = IOMUX_PAD(0x0478, 0x0208, 1, 0x0000, 0, 0),
	MX7D_PAD_SAI1_TX_SYNC__UART5_DCE_CTS                     = IOMUX_PAD(0x0478, 0x0208, 2, 0x0000, 0, 0),
	MX7D_PAD_SAI1_TX_SYNC__UART5_DTE_RTS                     = IOMUX_PAD(0x0478, 0x0208, 2, 0x0710, 2, 0),
	MX7D_PAD_SAI1_TX_SYNC__FLEXCAN2_RX                       = IOMUX_PAD(0x0478, 0x0208, 3, 0x04E0, 3, 0),
	MX7D_PAD_SAI1_TX_SYNC__SIM1_PORT1_RST_B                  = IOMUX_PAD(0x0478, 0x0208, 4, 0x0000, 0, 0),
	MX7D_PAD_SAI1_TX_SYNC__GPIO6_IO14                        = IOMUX_PAD(0x0478, 0x0208, 5, 0x0000, 0, 0),
	MX7D_PAD_SAI1_TX_SYNC__SRC_INT_BOOT                      = IOMUX_PAD(0x0478, 0x0208, 7, 0x0000, 0, 0),

	MX7D_PAD_SAI1_TX_DATA__SAI1_TX_DATA0                     = IOMUX_PAD(0x047C, 0x020C, 0, 0x0000, 0, 0),
	MX7D_PAD_SAI1_TX_DATA__NAND_READY_B                      = IOMUX_PAD(0x047C, 0x020C, 1, 0x0000, 0, 0),
	MX7D_PAD_SAI1_TX_DATA__UART5_DCE_RTS                     = IOMUX_PAD(0x047C, 0x020C, 2, 0x0710, 3, 0),
	MX7D_PAD_SAI1_TX_DATA__UART5_DTE_CTS                     = IOMUX_PAD(0x047C, 0x020C, 2, 0x0000, 0, 0),
	MX7D_PAD_SAI1_TX_DATA__FLEXCAN2_TX                       = IOMUX_PAD(0x047C, 0x020C, 3, 0x0000, 0, 0),
	MX7D_PAD_SAI1_TX_DATA__SIM1_PORT1_SVEN                   = IOMUX_PAD(0x047C, 0x020C, 4, 0x0000, 0, 0),
	MX7D_PAD_SAI1_TX_DATA__GPIO6_IO15                        = IOMUX_PAD(0x047C, 0x020C, 5, 0x0000, 0, 0),
	MX7D_PAD_SAI1_TX_DATA__SRC_SYSTEM_RESET                  = IOMUX_PAD(0x047C, 0x020C, 7, 0x0000, 0, 0),

	MX7D_PAD_SAI1_RX_SYNC__SAI1_RX_SYNC                      = IOMUX_PAD(0x0480, 0x0210, 0, 0x06A4, 0, 0),
	MX7D_PAD_SAI1_RX_SYNC__NAND_CE2_B                        = IOMUX_PAD(0x0480, 0x0210, 1, 0x0000, 0, 0),
	MX7D_PAD_SAI1_RX_SYNC__SAI2_RX_SYNC                      = IOMUX_PAD(0x0480, 0x0210, 2, 0x06B8, 1, 0),
	MX7D_PAD_SAI1_RX_SYNC__I2C4_SCL                          = IOMUX_PAD(0x0480, 0x0210, IOMUX_CONFIG_SION | 3, 0x05EC, 3, 0),
	MX7D_PAD_SAI1_RX_SYNC__SIM1_PORT1_PD                     = IOMUX_PAD(0x0480, 0x0210, 4, 0x06E0, 1, 0),
	MX7D_PAD_SAI1_RX_SYNC__GPIO6_IO16                        = IOMUX_PAD(0x0480, 0x0210, 5, 0x0000, 0, 0),
	MX7D_PAD_SAI1_RX_SYNC__MQS_RIGHT                         = IOMUX_PAD(0x0480, 0x0210, 6, 0x0000, 0, 0),
	MX7D_PAD_SAI1_RX_SYNC__SRC_CA7_RESET_B0                  = IOMUX_PAD(0x0480, 0x0210, 7, 0x0000, 0, 0),

	MX7D_PAD_SAI1_RX_BCLK__SAI1_RX_BCLK                      = IOMUX_PAD(0x0484, 0x0214, 0, 0x069C, 0, 0),
	MX7D_PAD_SAI1_RX_BCLK__NAND_CE3_B                        = IOMUX_PAD(0x0484, 0x0214, 1, 0x0000, 0, 0),
	MX7D_PAD_SAI1_RX_BCLK__SAI2_RX_BCLK                      = IOMUX_PAD(0x0484, 0x0214, 2, 0x06B0, 1, 0),
	MX7D_PAD_SAI1_RX_BCLK__I2C4_SDA                          = IOMUX_PAD(0x0484, 0x0214, IOMUX_CONFIG_SION | 3, 0x05F0, 3, 0),
	MX7D_PAD_SAI1_RX_BCLK__FLEXTIMER2_PHA                    = IOMUX_PAD(0x0484, 0x0214, 4, 0x05CC, 1, 0),
	MX7D_PAD_SAI1_RX_BCLK__GPIO6_IO17                        = IOMUX_PAD(0x0484, 0x0214, 5, 0x0000, 0, 0),
	MX7D_PAD_SAI1_RX_BCLK__MQS_LEFT                          = IOMUX_PAD(0x0484, 0x0214, 6, 0x0000, 0, 0),
	MX7D_PAD_SAI1_RX_BCLK__SRC_CA7_RESET_B1                  = IOMUX_PAD(0x0484, 0x0214, 7, 0x0000, 0, 0),

	MX7D_PAD_SAI1_MCLK__SAI1_MCLK                            = IOMUX_PAD(0x0488, 0x0218, 0, 0x0000, 0, 0),
	MX7D_PAD_SAI1_MCLK__NAND_WP_B                            = IOMUX_PAD(0x0488, 0x0218, 1, 0x0000, 0, 0),
	MX7D_PAD_SAI1_MCLK__SAI2_MCLK                            = IOMUX_PAD(0x0488, 0x0218, 2, 0x0000, 0, 0),
	MX7D_PAD_SAI1_MCLK__CCM_PMIC_READY                       = IOMUX_PAD(0x0488, 0x0218, 3, 0x04F4, 3, 0),
	MX7D_PAD_SAI1_MCLK__FLEXTIMER2_PHB                       = IOMUX_PAD(0x0488, 0x0218, 4, 0x05D0, 1, 0),
	MX7D_PAD_SAI1_MCLK__GPIO6_IO18                           = IOMUX_PAD(0x0488, 0x0218, 5, 0x0000, 0, 0),
	MX7D_PAD_SAI1_MCLK__SRC_TESTER_ACK                       = IOMUX_PAD(0x0488, 0x0218, 7, 0x0000, 0, 0),

	MX7D_PAD_SAI2_TX_SYNC__SAI2_TX_SYNC                      = IOMUX_PAD(0x048C, 0x021C, 0, 0x06C0, 1, 0),
	MX7D_PAD_SAI2_TX_SYNC__ECSPI3_MISO                       = IOMUX_PAD(0x048C, 0x021C, 1, 0x0548, 1, 0),
	MX7D_PAD_SAI2_TX_SYNC__UART4_DCE_RX                      = IOMUX_PAD(0x048C, 0x021C, 2, 0x070C, 4, 0),
	MX7D_PAD_SAI2_TX_SYNC__UART4_DTE_TX                      = IOMUX_PAD(0x048C, 0x021C, 2, 0x0000, 0, 0),
	MX7D_PAD_SAI2_TX_SYNC__UART1_DCE_CTS                     = IOMUX_PAD(0x048C, 0x021C, 3, 0x0000, 0, 0),
	MX7D_PAD_SAI2_TX_SYNC__UART1_DTE_RTS                     = IOMUX_PAD(0x048C, 0x021C, 3, 0x06F0, 0, 0),
	MX7D_PAD_SAI2_TX_SYNC__FLEXTIMER2_CH4                    = IOMUX_PAD(0x048C, 0x021C, 4, 0x05BC, 1, 0),
	MX7D_PAD_SAI2_TX_SYNC__GPIO6_IO19                        = IOMUX_PAD(0x048C, 0x021C, 5, 0x0000, 0, 0),

	MX7D_PAD_SAI2_TX_BCLK__SAI2_TX_BCLK                      = IOMUX_PAD(0x0490, 0x0220, 0, 0x06BC, 1, 0),
	MX7D_PAD_SAI2_TX_BCLK__ECSPI3_MOSI                       = IOMUX_PAD(0x0490, 0x0220, 1, 0x054C, 1, 0),
	MX7D_PAD_SAI2_TX_BCLK__UART4_DCE_TX                      = IOMUX_PAD(0x0490, 0x0220, 2, 0x0000, 0, 0),
	MX7D_PAD_SAI2_TX_BCLK__UART4_DTE_RX                      = IOMUX_PAD(0x0490, 0x0220, 2, 0x070C, 5, 0),
	MX7D_PAD_SAI2_TX_BCLK__UART1_DCE_RTS                     = IOMUX_PAD(0x0490, 0x0220, 3, 0x06F0, 1, 0),
	MX7D_PAD_SAI2_TX_BCLK__UART1_DTE_CTS                     = IOMUX_PAD(0x0490, 0x0220, 3, 0x0000, 0, 0),
	MX7D_PAD_SAI2_TX_BCLK__FLEXTIMER2_CH5                    = IOMUX_PAD(0x0490, 0x0220, 4, 0x05C0, 1, 0),
	MX7D_PAD_SAI2_TX_BCLK__GPIO6_IO20                        = IOMUX_PAD(0x0490, 0x0220, 5, 0x0000, 0, 0),

	MX7D_PAD_SAI2_RX_DATA__SAI2_RX_DATA0                     = IOMUX_PAD(0x0494, 0x0224, 0, 0x06B4, 1, 0),
	MX7D_PAD_SAI2_RX_DATA__ECSPI3_SCLK                       = IOMUX_PAD(0x0494, 0x0224, 1, 0x0544, 1, 0),
	MX7D_PAD_SAI2_RX_DATA__UART4_DCE_CTS                     = IOMUX_PAD(0x0494, 0x0224, 2, 0x0000, 0, 0),
	MX7D_PAD_SAI2_RX_DATA__UART4_DTE_RTS                     = IOMUX_PAD(0x0494, 0x0224, 2, 0x0708, 4, 0),
	MX7D_PAD_SAI2_RX_DATA__UART2_DCE_CTS                     = IOMUX_PAD(0x0494, 0x0224, 3, 0x0000, 0, 0),
	MX7D_PAD_SAI2_RX_DATA__UART2_DTE_RTS                     = IOMUX_PAD(0x0494, 0x0224, 3, 0x06F8, 2, 0),
	MX7D_PAD_SAI2_RX_DATA__FLEXTIMER2_CH6                    = IOMUX_PAD(0x0494, 0x0224, 4, 0x05C4, 1, 0),
	MX7D_PAD_SAI2_RX_DATA__GPIO6_IO21                        = IOMUX_PAD(0x0494, 0x0224, 5, 0x0000, 0, 0),
	MX7D_PAD_SAI2_RX_DATA__KPP_COL7                          = IOMUX_PAD(0x0494, 0x0224, 6, 0x0610, 1, 0),

	MX7D_PAD_SAI2_TX_DATA__SAI2_TX_DATA0                     = IOMUX_PAD(0x0498, 0x0228, 0, 0x0000, 0, 0),
	MX7D_PAD_SAI2_TX_DATA__ECSPI3_SS0                        = IOMUX_PAD(0x0498, 0x0228, 1, 0x0550, 1, 0),
	MX7D_PAD_SAI2_TX_DATA__UART4_DCE_RTS                     = IOMUX_PAD(0x0498, 0x0228, 2, 0x0708, 5, 0),
	MX7D_PAD_SAI2_TX_DATA__UART4_DTE_CTS                     = IOMUX_PAD(0x0498, 0x0228, 2, 0x0000, 0, 0),
	MX7D_PAD_SAI2_TX_DATA__UART2_DCE_RTS                     = IOMUX_PAD(0x0498, 0x0228, 3, 0x06F8, 3, 0),
	MX7D_PAD_SAI2_TX_DATA__UART2_DTE_CTS                     = IOMUX_PAD(0x0498, 0x0228, 3, 0x0000, 0, 0),
	MX7D_PAD_SAI2_TX_DATA__FLEXTIMER2_CH7                    = IOMUX_PAD(0x0498, 0x0228, 4, 0x05C8, 1, 0),
	MX7D_PAD_SAI2_TX_DATA__GPIO6_IO22                        = IOMUX_PAD(0x0498, 0x0228, 5, 0x0000, 0, 0),
	MX7D_PAD_SAI2_TX_DATA__KPP_ROW7                          = IOMUX_PAD(0x0498, 0x0228, 6, 0x0630, 1, 0),

	MX7D_PAD_ENET1_RGMII_RD0__ENET1_RGMII_RD0                = IOMUX_PAD(0x049C, 0x022C, 0, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_RD0__PWM1_OUT                       = IOMUX_PAD(0x049C, 0x022C, 1, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_RD0__I2C3_SCL                       = IOMUX_PAD(0x049C, 0x022C, IOMUX_CONFIG_SION | 2, 0x05E4, 4, 0),
	MX7D_PAD_ENET1_RGMII_RD0__UART1_DCE_CTS                  = IOMUX_PAD(0x049C, 0x022C, 3, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_RD0__UART1_DTE_RTS                  = IOMUX_PAD(0x049C, 0x022C, 3, 0x06F0, 2, 0),
	MX7D_PAD_ENET1_RGMII_RD0__EPDC_VCOM0                     = IOMUX_PAD(0x049C, 0x022C, 4, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_RD0__GPIO7_IO0                      = IOMUX_PAD(0x049C, 0x022C, 5, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_RD0__KPP_ROW3                       = IOMUX_PAD(0x049C, 0x022C, 6, 0x0620, 1, 0),

	MX7D_PAD_ENET1_RGMII_RD1__ENET1_RGMII_RD1                = IOMUX_PAD(0x04A0, 0x0230, 0, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_RD1__PWM2_OUT                       = IOMUX_PAD(0x04A0, 0x0230, 1, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_RD1__I2C3_SDA                       = IOMUX_PAD(0x04A0, 0x0230, IOMUX_CONFIG_SION | 2, 0x05E8, 4, 0),
	MX7D_PAD_ENET1_RGMII_RD1__UART1_DCE_RTS                  = IOMUX_PAD(0x04A0, 0x0230, 3, 0x06F0, 3, 0),
	MX7D_PAD_ENET1_RGMII_RD1__UART1_DTE_CTS                  = IOMUX_PAD(0x04A0, 0x0230, 3, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_RD1__EPDC_VCOM1                     = IOMUX_PAD(0x04A0, 0x0230, 4, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_RD1__GPIO7_IO1                      = IOMUX_PAD(0x04A0, 0x0230, 5, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_RD1__KPP_COL3                       = IOMUX_PAD(0x04A0, 0x0230, 6, 0x0600, 1, 0),

	MX7D_PAD_ENET1_RGMII_RD2__ENET1_RGMII_RD2                = IOMUX_PAD(0x04A4, 0x0234, 0, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_RD2__FLEXCAN1_RX                    = IOMUX_PAD(0x04A4, 0x0234, 1, 0x04DC, 4, 0),
	MX7D_PAD_ENET1_RGMII_RD2__ECSPI2_SCLK                    = IOMUX_PAD(0x04A4, 0x0234, 2, 0x0534, 1, 0),
	MX7D_PAD_ENET1_RGMII_RD2__UART1_DCE_RX                   = IOMUX_PAD(0x04A4, 0x0234, 3, 0x06F4, 2, 0),
	MX7D_PAD_ENET1_RGMII_RD2__UART1_DTE_TX                   = IOMUX_PAD(0x04A4, 0x0234, 3, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_RD2__EPDC_SDCE4                     = IOMUX_PAD(0x04A4, 0x0234, 4, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_RD2__GPIO7_IO2                      = IOMUX_PAD(0x04A4, 0x0234, 5, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_RD2__KPP_ROW2                       = IOMUX_PAD(0x04A4, 0x0234, 6, 0x061C, 1, 0),

	MX7D_PAD_ENET1_RGMII_RD3__ENET1_RGMII_RD3                = IOMUX_PAD(0x04A8, 0x0238, 0, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_RD3__FLEXCAN1_TX                    = IOMUX_PAD(0x04A8, 0x0238, 1, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_RD3__ECSPI2_MOSI                    = IOMUX_PAD(0x04A8, 0x0238, 2, 0x053C, 1, 0),
	MX7D_PAD_ENET1_RGMII_RD3__UART1_DCE_TX                   = IOMUX_PAD(0x04A8, 0x0238, 3, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_RD3__UART1_DTE_RX                   = IOMUX_PAD(0x04A8, 0x0238, 3, 0x06F4, 3, 0),
	MX7D_PAD_ENET1_RGMII_RD3__EPDC_SDCE5                     = IOMUX_PAD(0x04A8, 0x0238, 4, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_RD3__GPIO7_IO3                      = IOMUX_PAD(0x04A8, 0x0238, 5, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_RD3__KPP_COL2                       = IOMUX_PAD(0x04A8, 0x0238, 6, 0x05FC, 1, 0),

	MX7D_PAD_ENET1_RGMII_RX_CTL__ENET1_RGMII_RX_CTL          = IOMUX_PAD(0x04AC, 0x023C, 0, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_RX_CTL__ECSPI2_SS1                  = IOMUX_PAD(0x04AC, 0x023C, 2, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_RX_CTL__EPDC_SDCE6                  = IOMUX_PAD(0x04AC, 0x023C, 4, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_RX_CTL__GPIO7_IO4                   = IOMUX_PAD(0x04AC, 0x023C, 5, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_RX_CTL__KPP_ROW1                    = IOMUX_PAD(0x04AC, 0x023C, 6, 0x0618, 1, 0),

	MX7D_PAD_ENET1_RGMII_RXC__ENET1_RGMII_RXC                = IOMUX_PAD(0x04B0, 0x0240, 0, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_RXC__ENET1_RX_ER                    = IOMUX_PAD(0x04B0, 0x0240, 1, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_RXC__ECSPI2_SS2                     = IOMUX_PAD(0x04B0, 0x0240, 2, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_RXC__EPDC_SDCE7                     = IOMUX_PAD(0x04B0, 0x0240, 4, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_RXC__GPIO7_IO5                      = IOMUX_PAD(0x04B0, 0x0240, 5, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_RXC__KPP_COL1                       = IOMUX_PAD(0x04B0, 0x0240, 6, 0x0000, 0, 0),

	MX7D_PAD_ENET1_RGMII_TD0__ENET1_RGMII_TD0                = IOMUX_PAD(0x04B4, 0x0244, 0, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_TD0__PWM3_OUT                       = IOMUX_PAD(0x04B4, 0x0244, 1, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_TD0__ECSPI2_SS3                     = IOMUX_PAD(0x04B4, 0x0244, 2, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_TD0__EPDC_SDCE8                     = IOMUX_PAD(0x04B4, 0x0244, 4, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_TD0__GPIO7_IO6                      = IOMUX_PAD(0x04B4, 0x0244, 5, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_TD0__KPP_ROW0                       = IOMUX_PAD(0x04B4, 0x0244, 6, 0x0614, 1, 0),

	MX7D_PAD_ENET1_RGMII_TD1__ENET1_RGMII_TD1                = IOMUX_PAD(0x04B8, 0x0248, 0, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_TD1__PWM4_OUT                       = IOMUX_PAD(0x04B8, 0x0248, 1, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_TD1__ECSPI2_RDY                     = IOMUX_PAD(0x04B8, 0x0248, 2, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_TD1__EPDC_SDCE9                     = IOMUX_PAD(0x04B8, 0x0248, 4, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_TD1__GPIO7_IO7                      = IOMUX_PAD(0x04B8, 0x0248, 5, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_TD1__KPP_COL0                       = IOMUX_PAD(0x04B8, 0x0248, 6, 0x05F4, 1, 0),

	MX7D_PAD_ENET1_RGMII_TD2__ENET1_RGMII_TD2                = IOMUX_PAD(0x04BC, 0x024C, 0, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_TD2__FLEXCAN2_RX                    = IOMUX_PAD(0x04BC, 0x024C, 1, 0x04E0, 4, 0),
	MX7D_PAD_ENET1_RGMII_TD2__ECSPI2_MISO                    = IOMUX_PAD(0x04BC, 0x024C, 2, 0x0538, 1, 0),
	MX7D_PAD_ENET1_RGMII_TD2__I2C4_SCL                       = IOMUX_PAD(0x04BC, 0x024C, IOMUX_CONFIG_SION | 3, 0x05EC, 4, 0),
	MX7D_PAD_ENET1_RGMII_TD2__EPDC_SDOED                     = IOMUX_PAD(0x04BC, 0x024C, 4, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_TD2__GPIO7_IO8                      = IOMUX_PAD(0x04BC, 0x024C, 5, 0x0000, 0, 0),

	MX7D_PAD_ENET1_RGMII_TD3__ENET1_RGMII_TD3                = IOMUX_PAD(0x04C0, 0x0250, 0, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_TD3__FLEXCAN2_TX                    = IOMUX_PAD(0x04C0, 0x0250, 1, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_TD3__ECSPI2_SS0                     = IOMUX_PAD(0x04C0, 0x0250, 2, 0x0540, 1, 0),
	MX7D_PAD_ENET1_RGMII_TD3__I2C4_SDA                       = IOMUX_PAD(0x04C0, 0x0250, IOMUX_CONFIG_SION | 3, 0x05F0, 4, 0),
	MX7D_PAD_ENET1_RGMII_TD3__EPDC_SDOEZ                     = IOMUX_PAD(0x04C0, 0x0250, 4, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_TD3__GPIO7_IO9                      = IOMUX_PAD(0x04C0, 0x0250, 5, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_TD3__CAAM_RNG_OSC_OBS               = IOMUX_PAD(0x04C0, 0x0250, 7, 0x0000, 0, 0),

	MX7D_PAD_ENET1_RGMII_TX_CTL__ENET1_RGMII_TX_CTL          = IOMUX_PAD(0x04C4, 0x0254, 0, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_TX_CTL__SAI1_RX_SYNC                = IOMUX_PAD(0x04C4, 0x0254, 2, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_TX_CTL__GPT2_COMPARE1               = IOMUX_PAD(0x04C4, 0x0254, 3, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_TX_CTL__EPDC_PWR_CTRL2              = IOMUX_PAD(0x04C4, 0x0254, 4, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_TX_CTL__GPIO7_IO10                  = IOMUX_PAD(0x04C4, 0x0254, 5, 0x0000, 0, 0),

	MX7D_PAD_ENET1_RGMII_TXC__ENET1_RGMII_TXC                = IOMUX_PAD(0x04C8, 0x0258, 0, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_TXC__ENET1_TX_ER                    = IOMUX_PAD(0x04C8, 0x0258, 1, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_TXC__SAI1_RX_BCLK                   = IOMUX_PAD(0x04C8, 0x0258, 2, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_TXC__GPT2_COMPARE2                  = IOMUX_PAD(0x04C8, 0x0258, 3, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_TXC__EPDC_PWR_CTRL3                 = IOMUX_PAD(0x04C8, 0x0258, 4, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RGMII_TXC__GPIO7_IO11                     = IOMUX_PAD(0x04C8, 0x0258, 5, 0x0000, 0, 0),

	MX7D_PAD_ENET1_TX_CLK__ENET1_TX_CLK                      = IOMUX_PAD(0x04CC, 0x025C, 0, 0x0000, 0, 0),
	MX7D_PAD_ENET1_TX_CLK__CCM_ENET_REF_CLK1                 = IOMUX_PAD(0x04CC, 0x025C, 1, 0x0564, 2, 0),
	MX7D_PAD_ENET1_TX_CLK__SAI1_RX_DATA0                     = IOMUX_PAD(0x04CC, 0x025C, 2, 0x06A0, 1, 0),
	MX7D_PAD_ENET1_TX_CLK__GPT2_COMPARE3                     = IOMUX_PAD(0x04CC, 0x025C, 3, 0x0000, 0, 0),
	MX7D_PAD_ENET1_TX_CLK__EPDC_PWR_IRQ                      = IOMUX_PAD(0x04CC, 0x025C, 4, 0x057C, 1, 0),
	MX7D_PAD_ENET1_TX_CLK__GPIO7_IO12                        = IOMUX_PAD(0x04CC, 0x025C, 5, 0x0000, 0, 0),
	MX7D_PAD_ENET1_TX_CLK__CCM_EXT_CLK1                      = IOMUX_PAD(0x04CC, 0x025C, 6, 0x04E4, 2, 0),
	MX7D_PAD_ENET1_TX_CLK__CSU_ALARM_AUT0                    = IOMUX_PAD(0x04CC, 0x025C, 7, 0x0000, 0, 0),

	MX7D_PAD_ENET1_RX_CLK__ENET1_RX_CLK                      = IOMUX_PAD(0x04D0, 0x0260, 0, 0x056C, 0, 0),
	MX7D_PAD_ENET1_RX_CLK__WDOG2_WDOG_B                      = IOMUX_PAD(0x04D0, 0x0260, 1, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RX_CLK__SAI1_TX_BCLK                      = IOMUX_PAD(0x04D0, 0x0260, 2, 0x06A8, 1, 0),
	MX7D_PAD_ENET1_RX_CLK__GPT2_CLK                          = IOMUX_PAD(0x04D0, 0x0260, 3, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RX_CLK__EPDC_PWR_WAKE                     = IOMUX_PAD(0x04D0, 0x0260, 4, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RX_CLK__GPIO7_IO13                        = IOMUX_PAD(0x04D0, 0x0260, 5, 0x0000, 0, 0),
	MX7D_PAD_ENET1_RX_CLK__CCM_EXT_CLK2                      = IOMUX_PAD(0x04D0, 0x0260, 6, 0x04E8, 2, 0),
	MX7D_PAD_ENET1_RX_CLK__CSU_ALARM_AUT1                    = IOMUX_PAD(0x04D0, 0x0260, 7, 0x0000, 0, 0),

	MX7D_PAD_ENET1_CRS__ENET1_CRS                            = IOMUX_PAD(0x04D4, 0x0264, 0, 0x0000, 0, 0),
	MX7D_PAD_ENET1_CRS__WDOG2_WDOG_RST_B_DEB                 = IOMUX_PAD(0x04D4, 0x0264, 1, 0x0000, 0, 0),
	MX7D_PAD_ENET1_CRS__SAI1_TX_SYNC                         = IOMUX_PAD(0x04D4, 0x0264, 2, 0x06AC, 1, 0),
	MX7D_PAD_ENET1_CRS__GPT2_CAPTURE1                        = IOMUX_PAD(0x04D4, 0x0264, 3, 0x0000, 0, 0),
	MX7D_PAD_ENET1_CRS__EPDC_PWR_CTRL0                       = IOMUX_PAD(0x04D4, 0x0264, 4, 0x0000, 0, 0),
	MX7D_PAD_ENET1_CRS__GPIO7_IO14                           = IOMUX_PAD(0x04D4, 0x0264, 5, 0x0000, 0, 0),
	MX7D_PAD_ENET1_CRS__CCM_EXT_CLK3                         = IOMUX_PAD(0x04D4, 0x0264, 6, 0x04EC, 2, 0),
	MX7D_PAD_ENET1_CRS__CSU_ALARM_AUT2                       = IOMUX_PAD(0x04D4, 0x0264, 7, 0x0000, 0, 0),

	MX7D_PAD_ENET1_COL__ENET1_COL                            = IOMUX_PAD(0x04D8, 0x0268, 0, 0x0000, 0, 0),
	MX7D_PAD_ENET1_COL__WDOG1_WDOG_ANY                       = IOMUX_PAD(0x04D8, 0x0268, 1, 0x0000, 0, 0),
	MX7D_PAD_ENET1_COL__SAI1_TX_DATA0                        = IOMUX_PAD(0x04D8, 0x0268, 2, 0x0000, 0, 0),
	MX7D_PAD_ENET1_COL__GPT2_CAPTURE2                        = IOMUX_PAD(0x04D8, 0x0268, 3, 0x0000, 0, 0),
	MX7D_PAD_ENET1_COL__EPDC_PWR_CTRL1                       = IOMUX_PAD(0x04D8, 0x0268, 4, 0x0000, 0, 0),
	MX7D_PAD_ENET1_COL__GPIO7_IO15                           = IOMUX_PAD(0x04D8, 0x0268, 5, 0x0000, 0, 0),
	MX7D_PAD_ENET1_COL__CCM_EXT_CLK4                         = IOMUX_PAD(0x04D8, 0x0268, 6, 0x04F0, 2, 0),
	MX7D_PAD_ENET1_COL__CSU_INT_DEB                          = IOMUX_PAD(0x04D8, 0x0268, 7, 0x0000, 0, 0),
};
#endif  /* __ASM_ARCH_IMX7D_PINS_H__ */
