.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft CW
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de IN		\" send an index entry to the stderr
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.ny0
.TH XAnyEvent __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XAnyEvent, XEvent \- generic X event structures
.SH STRUCTURES
All the event structures declared in 
.Pn < X11/Xlib.h >
have the following common members:
.Ds 0
typedef struct {
        int type;
        unsigned long serial;   /\&* # of last request processed by server */
        Bool send_event;        /\&* true if this came from a SendEvent request */
        Display *display;       /\&* Display the event was read from */
        Window window;
} XAnyEvent;
.De
.LP
The type member is set to the event type constant name that uniquely identifies
it.
For example, when the X server reports a
.ZN GraphicsExpose
event to a client application, it sends an
.ZN XGraphicsExposeEvent
structure with the type member set to
.ZN GraphicsExpose .
The display member is set to a pointer to the display the event was read on.
The send_event member is set to
.ZN True
if the event came from a
.ZN SendEvent
protocol request.
The serial member is set from the serial number reported in the protocol
but expanded from the 16-bit least-significant bits to a full 32-bit value.
The window member is set to the window that is most useful to toolkit
dispatchers.
.LP
The
.ZN XEvent
structure is a union of the individual structures declared for each event type:
.Ds 0
typedef union _XEvent {
        int type;       /\&* must not be changed */
        XAnyEvent xany;
        XKeyEvent xkey;
        XButtonEvent xbutton;
        XMotionEvent xmotion;
        XCrossingEvent xcrossing;
        XFocusChangeEvent xfocus;
        XExposeEvent xexpose;
        XGraphicsExposeEvent xgraphicsexpose;
        XNoExposeEvent xnoexpose;
        XVisibilityEvent xvisibility;
        XCreateWindowEvent xcreatewindow;
        XDestroyWindowEvent xdestroywindow;
        XUnmapEvent xunmap;
        XMapEvent xmap;
        XMapRequestEvent xmaprequest;
        XReparentEvent xreparent;
        XConfigureEvent xconfigure;
        XGravityEvent xgravity;
        XResizeRequestEvent xresizerequest;
        XConfigureRequestEvent xconfigurerequest;
        XCirculateEvent xcirculate;
        XCirculateRequestEvent xcirculaterequest;
        XPropertyEvent xproperty;
        XSelectionClearEvent xselectionclear;
        XSelectionRequestEvent xselectionrequest;
        XSelectionEvent xselection;
        XColormapEvent xcolormap;
        XClientMessageEvent xclient;
        XMappingEvent xmapping;
        XErrorEvent xerror;
        XKeymapEvent xkeymap;
        long pad[24];
} XEvent;
.De
.LP
An
.ZN XEvent
structure's first entry always is the type member,
which is set to the event type.
The second member always is the serial number of the protocol request
that generated the event.
The third member always is send_event,
which is a
.ZN Bool
that indicates if the event was sent by a different client.
The fourth member always is a display,
which is the display that the event was read from.
Except for keymap events,
the fifth member always is a window,
which has been carefully selected to be useful to toolkit dispatchers.
To avoid breaking toolkits,
the order of these first five entries is not to change.
Most events also contain a time member,
which is the time at which an event occurred.
In addition, a pointer to the generic event must be cast before it
is used to access any other information in the structure.
.SH "SEE ALSO"
XButtonEvent(__libmansuffix__),
XCreateWindowEvent(__libmansuffix__),
XCirculateEvent(__libmansuffix__),
XCirculateRequestEvent(__libmansuffix__),
XColormapEvent(__libmansuffix__),
XConfigureEvent(__libmansuffix__),
XConfigureRequestEvent(__libmansuffix__),
XCrossingEvent(__libmansuffix__),
XDestroyWindowEvent(__libmansuffix__),
XErrorEvent(__libmansuffix__),
XExposeEvent(__libmansuffix__),
XFocusChangeEvent(__libmansuffix__),
XGraphicsExposeEvent(__libmansuffix__),
XGravityEvent(__libmansuffix__),
XKeymapEvent(__libmansuffix__),
XMapEvent(__libmansuffix__),
XMapRequestEvent(__libmansuffix__),
XPropertyEvent(__libmansuffix__),
XReparentEvent(__libmansuffix__),
XResizeRequestEvent(__libmansuffix__),
XSelectionClearEvent(__libmansuffix__),
XSelectionEvent(__libmansuffix__),
XSelectionRequestEvent(__libmansuffix__),
XUnmapEvent(__libmansuffix__),
XVisibilityEvent(__libmansuffix__)
.br
\fI\*(xL\fP
