# Value assertions

* **_AFT.assertEvalToTrue(value)**

    Assert that a given value evals to true. Lua coercion rules are applied so
    that values like 0,"",1.17 succeed in this assertion. If provided, extra_msg
    is a string which will be printed along with the failure message.

* **_AFT.assertEvalToFalse(Value)**

    Assert that a given value eval to *false*. Lua coercion rules are applied so
    that *nil* and *false* succeed in this assertion. If provided, extra_msg is a
    string which will be printed along with the failure message.

* **_AFT.assertIsTrue(value)**

    Assert that a given value compares to true. Lua coercion rules are applied so
    that values like 0, "", 1.17 all compare to true.

* **_AFT.assertIsFalse(value)**

    Assert that a given value compares to false. Lua coercion rules are applied so
    that only nil and false all compare to false.

* **_AFT.assertIsNil(value)**

    Assert that a given value is nil .

* **_AFT.assertNotIsNil(value)**

    Assert that a given value is not *nil* . Lua coercion rules are applied
    so that values like ``0``, ``""``, ``false`` all validate the assertion.
    If provided, *extra_msg* is a string which will be printed along with the
    failure message.

* **_AFT.assertIs(actual, expected)**

    Assert that two variables are identical. For string, numbers, boolean and
    for nil, this gives the same result as assertEquals() . For the other types,
    identity means that the two variables refer to the same object.

    Example :

    ```lua
    `s1='toto'
    s2='to'..'to'
    t1={1,2}
    t2={1,2}
    luaunit.assertIs(s1,s1) -- ok
    luaunit.assertIs(s1,s2) -- ok
    luaunit.assertIs(t1,t1) -- ok
    luaunit.assertIs(t1,t2) -- fail`
    ```

* **_AFT.assertNotIs(actual, expected)**

    Assert that two variables are not identical, in the sense that they do not
    refer to the same value. See assertIs() for more details.