'\" t
.\" Copyright 1999 Oracle and/or its affiliates. All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbSetCompatMap __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbSetCompatMap \- Modify the server's compatibility map
.SH SYNOPSIS
.HP
.B Bool XkbSetCompatMap
.BI "(\^Display *" "display" "\^,"
.BI "unsigned int " "which" "\^,"
.BI "XkbDescPtr " "xkb" "\^,"
.BI "Bool " "update_actions" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- display
connection to server
.TP
.I \- which
mask of compat map components to set
.TP
.I \- xkb
source for compat map components
.TP
.I \- update_actions
True => apply to server's keyboard map 
.SH DESCRIPTION
.LP
To modify the server's compatibility map, first modify a local copy of the Xkb 
compatibility map, then call 
.I XkbSetCompatMap. 
You may allocate a new compatibility map for this purpose using
.I XkbAllocCompatMap. 
You may also use a compatibility map from another server, although you need to 
adjust the 
.I device_spec 
field in the XkbDescRec accordingly. Note that symbol interpretations in a 
compatibility map (
.I sym_interpret, 
the vector of XkbSymInterpretRec structures) are also allocated using this same 
function.

.I XkbSetCompatMap 
copies compatibility map information from the keyboard description in 
.I xkb 
to the server specified in 
.I display
's compatibility map for the device specified by the 
.I device_spec 
field of 
.I xkb. 
Unless you have specifically modified this field, it is the default keyboard 
device. 
.I which 
specifies the compatibility map components to be set, and is an inclusive OR of 
the bits shown in Table 1.

.TS
c s s
l l l
l l lw(3i).
Table 1 Compatibility Map Component Masks
_
Mask	Value	Affecting
_
XkbSymInterpMask	(1<<0)	Symbol interpretations
XkbGroupCompatMask	(1<<1)	Group maps
XkbAllCompatMask	(0x3)	All compatibility map components
.TE

After updating its compatibility map for the specified device, if 
.I update_actions 
is True, the server applies the new compatibility map to its entire keyboard for 
the device to generate a new set of key semantics, compatibility state, and a 
new core keyboard map. If 
.I update_actions 
is False, the new compatibility map is not used to generate any modifications to 
the current device semantics, state, or core keyboard map. One reason for not 
applying the compatibility map immediately would be if one server was being 
configured to match another on a piecemeal basis; the map should not be applied 
until everything is updated. To force an update at a later time, use
.I XkbSetCompatMap 
specifying 
.I which 
as zero and 
.I update_actions 
as True. 

.I XkbSetCompatMap 
returns True if successful and False if unsuccessful. The server may report 
problems it encounters when processing the request subsequently via protocol 
errors.
.SH "RETURN VALUES"
.TP 15
True
The 
.I XkbSetCompatMap 
function returns True if successful.
.TP 15
False
The 
.I XkbSetCompatMap 
function returns False if unsuccessful.
.SH STRUCTURES
.LP
The complete description of an Xkb keyboard is given by an XkbDescRec. The 
component 
structures in the XkbDescRec represent the major Xkb components.

.nf
typedef struct {
   struct _XDisplay * display;      /\(** connection to X server */
   unsigned short     flags;        /\(** private to Xkb, do not modify */
   unsigned short     device_spec;  /\(** device of interest */
   KeyCode            min_key_code; /\(** minimum keycode for device */
   KeyCode            max_key_code; /\(** maximum keycode for device */
   XkbControlsPtr     ctrls;        /\(** controls */
   XkbServerMapPtr    server;       /\(** server keymap */
   XkbClientMapPtr    map;          /\(** client keymap */
   XkbIndicatorPtr    indicators;   /\(** indicator map */
   XkbNamesPtr        names;        /\(** names for all components */
   XkbCompatMapPtr    compat;       /\(** compatibility map */
   XkbGeometryPtr     geom;         /\(** physical geometry of keyboard */
} XkbDescRec, *XkbDescPtr;

.fi
The 
.I display 
field points to an X display structure. The 
.I flags field is private to the library: modifying 
.I flags 
may yield unpredictable results. The 
.I device_spec 
field specifies the device identifier of the keyboard input device, or 
XkbUseCoreKeyboard, which specifies the core keyboard device. The 
.I min_key_code
and 
.I max_key_code 
fields specify the least and greatest keycode that can be returned by the 
keyboard. 

Each structure component has a corresponding mask bit that is used in function 
calls to 
indicate that the structure should be manipulated in some manner, such as 
allocating it 
or freeing it. These masks and their relationships to the fields in the 
XkbDescRec are 
shown in Table 2.

.TS
c s s
l l l
l l l.
Table 2 Mask Bits for XkbDescRec
_
Mask Bit	XkbDescRec Field	Value
_
XkbControlsMask	ctrls	(1L<<0)
XkbServerMapMask	server	(1L<<1)
XkbIClientMapMask	map	(1L<<2)
XkbIndicatorMapMask	indicators	(1L<<3)
XkbNamesMask	names	(1L<<4)
XkbCompatMapMask	compat	(1L<<5)
XkbGeometryMask	geom	(1L<<6)
XkbAllComponentsMask	All Fields	(0x7f)
.TE

The XkbSymInterpretRec structure specifies a symbol interpretation:
.nf
 
    typedef struct {
        KeySym        sym;         /\(** keysym of interest or NULL */
        unsigned char flags;       /\(** XkbSI_AutoRepeat, XkbSI_LockingKey */
        unsigned char match;       /\(** specifies how mods is interpreted */
        unsigned char mods;        /\(** modifier bits, correspond to eight real modifiers */
        unsigned char virtual_mod; /\(** 1 modifier to add to key virtual mod map */
        XkbAnyAction  act;         /\(** action to bind to symbol position on key */
    } XkbSymInterpretRec,*XkbSymInterpretPtr;
    
.fi    
.SH "SEE ALSO"
.BR XkbAllocCompatMap (__libmansuffix__)
