.TH "ZIP_SOURCE_ROLLBACK_WRITE" "3" "November 18, 2014" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_source_rollback_write\fR
\- undo changes to zip source
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIint\fR
.PD 0
.HP 4n
\fBzip_source_rollback_write\fR(\fIzip_source_t\ *source\fR);
.PD
.SH "DESCRIPTION"
The function
\fBzip_source_rollback_write\fR()
reverts changes written to
\fIsource\fR,
restoring the data before
zip_source_begin_write(3)
was called.
Usually this removes temporary files or frees buffers.
.SH "RETURN VALUES"
Upon successful completion 0 is returned.
Otherwise, \-1 is returned and the error information in
\fIsource\fR
is set to indicate the error.
.SH "SEE ALSO"
libzip(3),
zip_source(3),
zip_source_begin_write(3),
zip_source_commit_write(3),
zip_source_seek_write(3),
zip_source_tell_write(3),
zip_source_write(3)
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
