.TH "ZIP_SOURCE_FILEP" "3" "November 10, 2015" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_source_filep\fR
\- create data source from FILE *
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fIzip_source_t *\fR
.PD 0
.HP 4n
\fBzip_source_filep\fR(\fIzip_t\ *archive\fR, \fIFILE\ *file\fR, \fIzip_uint64_t\ start\fR, \fIzip_int64_t\ len\fR);
.PD
.PP
\fIzip_source_t *\fR
.PD 0
.HP 4n
\fBzip_source_filep\fR(\fIFILE\ *file\fR, \fIzip_uint64_t\ start\fR, \fIzip_int64_t\ len\fR, \fIzip_error_t\ *error\fR);
.PD
.SH "DESCRIPTION"
The functions
\fBzip_source_filep\fR()
and
\fBzip_source_filep_create\fR()
create a zip source from a file stream.
They read
\fIlen\fR
bytes from offset
\fIstart\fR
from the open file stream
\fIfile\fR.
If
\fIlen\fR
is 0 or \-1, the whole file (starting from
\fIstart\fR)
is used.
.PP
If the file stream supports seeking, the source can be used to open
a read-only zip archive from.
.PP
The file stream is closed when the source is being freed, usually
by
zip_close(3).
.SH "RETURN VALUES"
Upon successful completion, the created source is returned.
Otherwise,
\fRNULL\fR
is returned and the error code in
\fIarchive\fR
or
\fIerror\fR
is set to indicate the error.
.SH "ERRORS"
\fBzip_source_filep\fR()
fails if:
.TP 19n
[\fRZIP_ER_INVAL\fR]
\fIfile\fR,
\fIstart\fR,
or
\fIlen\fR
are invalid.
.TP 19n
[\fRZIP_ER_MEMORY\fR]
Required memory could not be allocated.
.SH "SEE ALSO"
libzip(3),
zip_add(3),
zip_replace(3),
zip_source(3)
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
