]q (cpygments.token
_TokenType
qX   CommentqX   Singleqqqq}q(X   subtypesqcbuiltins
set
q	]q
qRqX   parentq
hhqqq}q(hh	]q(hhX	   Directiveqqqq}q(hh	]qqRqh
hubhhX	   Multilineqqqq}q(hh	]q q!Rq"h
hubhhX   Docq#q$q%q&}q'(hh	]q(q)Rq*h
hubhhX   Multiq+q,q-q.}q/(hh	]q0q1Rq2h
hubhhX
   Singlelineq3q4q5q6}q7(hh	]q8q9Rq:h
hubhhX   Preprocq;q<q=q>}q?(hh	]q@qARqBh
hubhhX   HashbangqCqDqEqF}qG(hh	]qHqIRqJh
hubhhhX   PreprocFileqKqLqMqN}qO(hh	]qPqQRqRh
hubhhX
   SingleLineqSqTqUqV}qW(hh	]qXqYRqZh
hubhhX   Specialq[q\q]q^}q_(hh	]q`qaRqbh
hubeqcRqdh
h)qeqf}qg(hh	]qh(hX   Punctuationqiqjqkql}qm(hh	]qnhhiX	   Indicatorqoqpqqqr}qs(hh	]qtquRqvh
hlubaqwRqxh
hfhohrubhX   Otherqyqzq{q|}q}(hh	]q~qRqh
hfubhX   Errorqqqq}q(hh	]qqRqh
hfubhX   Keywordqqqq}q(hh	]q(hhX   Wordqqqq}q(hh	]qqRqh
hubhhhqqq}q(hh	]qqRqh
hubhhX   Constantqqqq}q(hh	]qqRqh
hubhhX   Reservedqqqq}q(hh	]qqRqh
hubhhX	   Namespaceqqqq}q(hh	]qqRqh
hubhhX   Typeqqqq}q(hh	]qqRqh
hubhhX   PreProcqqqq}q(hh	]qÅqRqh
hubhhX   ControlqƆqǅqȁq}q(hh	]q˅qRqh
hubhhX   PseudoqΆqυqЁq}q(hh	]qӅqRqh
hubhhX   Declarationqֆqׅq؁q}q(hh	]qۅqRqh
hubeqRqh
hfhhhhhhhhhhhhhhhhhhhhubhhX   Literalqqqq}q(hh	]q(hhX   Charqqqq}q(hh	]qqRqh
hubhhX   Scalarqqqq}q(hh	]qhhhX   Plainqqqq}q(hh	]qqRqh
hubaqRqh
hhhubhhX   Stringqqr   r  }r  (hh	]r  (hhhX   Momentr  r  r  r  }r  (hh	]r	  r
  Rr  h
j  ubhhhhr  r
  r  }r  (hh	]r  r  Rr  h
j  ubhhhX	   Delimeterr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhhhhr  r  r  }r  (hh	]r  r   Rr!  h
j  ubhhhX   Interpolr"  r#  r$  r%  }r&  (hh	]r'  r(  Rr)  h
j  ubhhhX   Escaper*  r+  r,  r-  }r.  (hh	]r/  r0  Rr1  h
j  ubhhhh#r2  r3  r4  }r5  (hh	]r6  r7  Rr8  h
j  ubhhhX   Heredocr9  r:  r;  r<  }r=  (hh	]r>  r?  Rr@  h
j  ubhhhX   BacktickrA  rB  rC  rD  }rE  (hh	]rF  rG  RrH  h
j  ubhhhX   BooleanrI  rJ  rK  rL  }rM  (hh	]rN  rO  RrP  h
j  ubhhhX	   CharacterrQ  rR  rS  rT  }rU  (hh	]rV  rW  RrX  h
j  ubhhhX   AtomrY  rZ  r[  r\  }r]  (hh	]r^  r_  Rr`  h
j  ubhhhX   Affixra  rb  rc  rd  }re  (hh	]rf  rg  Rrh  h
j  ubhhhX   Doubleri  rj  rk  rl  }rm  (hh	]rn  ro  Rrp  h
j  ubhhhX   Symbolrq  rr  rs  rt  }ru  (hh	]rv  rw  Rrx  h
j  ubhhhX   Interpry  rz  r{  r|  }r}  (hh	]r~  r  Rr  h
j  ubhhhX   Regexr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhhhX   Namer  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhhhX	   Delimiterr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhhhhyr  r  r  }r  (hh	]r  r  Rr  h
j  uber  Rr  h
hja  jd  jA  jD  hj  j  j  h#j4  ji  jl  j*  j-  j9  j<  j"  j%  hyj  j  j  hj  jq  jt  jQ  jT  j  j  jy  j|  jI  jL  j  j  jY  j\  j  j  ubhhhyr  r  r  }r  (hh	]r  r  Rr  h
hubhhX   Numberr  r  r  r  }r  (hh	]r  (hhj  X   Integerr  r  r  r  }r  (hh	]r  h(hj  j  X   Longr  tr  r  r  }r  (hh	]r  r  Rr  h
j  ubar  Rr  h
j  j  j  ubhhj  X   Floatr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhhj  X   Binr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhhj  X   Decr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhhj  X   Radixr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhhj  X   Decimalr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhhj  X   Octr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhhj  X   Hexr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhhj  X	   Attributer  r  r  r  }r  (hh	]r  r  Rr  h
j  uber  Rr   h
hj  j  j  j  j  j  j  j  j  j  j  j  j  j  j  j  j  j  ubhhX   Dater  r  r  r  }r  (hh	]r  r  Rr  h
huber	  Rr
  h
hfhj  j  j  j  j  hhhyj  hhubhj  r  r  r
  }r  (hh	]r  (hj  X   Blubbr  r  r  r  }r  (hh	]r  r  Rr  h
j
  ubhj  X   Builtinr  r  r  r  }r  (hh	]r  (hj  j  h·r  r  r   }r!  (hh	]r"  r#  Rr$  h
j  ubhj  j  hr%  r&  r'  }r(  (hh	]r)  r*  Rr+  h
j  uber,  Rr-  h
j
  hj   hj'  ubhj  X   Entityr.  r/  r0  r1  }r2  (hh	]r3  hj  j.  X   DBSr4  r5  r6  r7  }r8  (hh	]r9  r:  Rr;  h
j1  ubar<  Rr=  h
j
  j4  j7  ubhj  hr>  r?  r@  }rA  (hh	]rB  rC  RrD  h
j
  ubhj  X   ClassrE  rF  rG  rH  }rI  (hh	]rJ  (hj  jE  X   StartrK  rL  rM  rN  }rO  (hh	]rP  rQ  RrR  h
jH  ubhj  jE  j4  rS  rT  rU  }rV  (hh	]rW  rX  RrY  h
jH  uberZ  Rr[  h
j
  jK  jN  j4  jU  ubhj  X	   Decoratorr\  r]  r^  r_  }r`  (hh	]ra  rb  Rrc  h
j
  ubhj  X   Functionrd  re  rf  rg  }rh  (hh	]ri  hj  jd  X   Magicrj  rk  rl  rm  }rn  (hh	]ro  rp  Rrq  h
jg  ubarr  Rrs  h
j
  jj  jm  ubhj  X   Operatorrt  ru  rv  rw  }rx  (hh	]ry  rz  Rr{  h
j
  ubhj  X   Propertyr|  r}  r~  r  }r  (hh	]r  r  Rr  h
j
  ubhj  X   Classesr  r  r  r  }r  (hh	]r  r  Rr  h
j
  ubhj  jq  r  r  r  }r  (hh	]r  r  Rr  h
j
  ubhj  hr  r  r  }r  (hh	]r  r  Rr  h
j
  ubhj  hr  r  r  }r  (hh	]r  r  Rr  h
j
  ubhj  j  r  r  r  }r  (hh	]r  hj  j  X   Variabler  r  r  r  }r  (hh	]r  r  Rr  h
j  ubar  Rr  h
j
  j  j  ubhj  X   Fieldr  r  r  r  }r  (hh	]r  r  Rr  h
j
  ubhj  X	   Exceptionr  r  r  r  }r  (hh	]r  r  Rr  h
j
  ubhj  j  r  r  r  }r  (hh	]r  (hj  j  X	   Anonymousr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  j  X   Instancer  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  j  X   Globalr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  j  jj  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  j  jE  r  r  r  }r  (hh	]r  r  Rr  h
j  uber  Rr  h
j
  jE  j  j  j  j  j  jj  j  j  j  ubhj  X   Tagr  r  r  r  }r  (hh	]r  r  Rr  h
j
  ubhj  hyr  r  r  }r  (hh	]r  hj  hyX   Memberr  r  r  r  }r  (hh	]r  r   Rr  h
j  ubar  Rr  h
j
  j  j  ubhj  X   Labelr  r  r  r  }r  (hh	]r	  r
  Rr  h
j
  ubhj  hΆr  r
  r  }r  (hh	]r  r  Rr  h
j
  uber  Rr  h
hfj  j  j  j  jE  jH  hj@  j\  j_  j.  j1  j  j  jd  jg  j|  j  j  j  hj  hyj  j  j  j  j  j  j  jq  j  hj  jt  jw  j  j  hj  j  j  ubhX   Genericr  r  r  r  }r  (hh	]r  (hj  X
   Subheadingr  r  r  r  }r  (hh	]r   r!  Rr"  h
j  ubhj  X   Promptr#  r$  r%  r&  }r'  (hh	]r(  r)  Rr*  h
j  ubhj  X   Outputr+  r,  r-  r.  }r/  (hh	]r0  r1  Rr2  h
j  ubhj  X   Strongr3  r4  r5  r6  }r7  (hh	]r8  r9  Rr:  h
j  ubhj  hr;  r<  r=  }r>  (hh	]r?  r@  RrA  h
j  ubhj  X	   TracebackrB  rC  rD  rE  }rF  (hh	]rG  rH  RrI  h
j  ubhj  X   EmphrJ  rK  rL  rM  }rN  (hh	]rO  rP  RrQ  h
j  ubhj  X   DeletedrR  rS  rT  rU  }rV  (hh	]rW  rX  RrY  h
j  ubhj  X   InsertedrZ  r[  r\  r]  }r^  (hh	]r_  r`  Rra  h
j  ubhj  X   Headingrb  rc  rd  re  }rf  (hh	]rg  rh  Rri  h
j  uberj  Rrk  h
hfjR  jU  jJ  jM  hj=  jb  je  jZ  j]  j+  j.  j#  j&  j3  j6  j  j  jB  jE  ubhjt  rl  rm  rn  }ro  (hh	]rp  (hjt  j4  rq  rr  rs  }rt  (hh	]ru  rv  Rrw  h
jn  ubhjt  hrx  ry  rz  }r{  (hh	]r|  r}  Rr~  h
jn  uber  Rr  h
hfhjz  j4  js  ubhj*  r  r  r  }r  (hh	]r  r  Rr  h
hfubhX   Textr  r  r  r  }r  (hh	]r  (hj  jq  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  hir  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  X   Ragr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  X
   Whitespacer  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  X   Beerr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  X   Rootr  r  r  r  }r  (hh	]r  r  Rr  h
j  uber  Rr  h
hfj  j  hij  jq  j  j  j  j  j  j  j  uber  Rr  j  j  j*  j  hhhyh|hhj  j
  hhhihljt  jn  hhj  j  X   Tokenr  hfhj  j  j  ubhChFhhh;h>hKhNhhh[h^hhhShVh#h&h+h.h3h6ububX5   ;;;; This contains some of the core Hy functions usedr  r  j  X   
r  r  hX4   ;;;; to make functional programming slightly easier.r  r  j  j  r  hX   ;;;;r  r  j  X   


r  r  j  X   (defnr  r  j  X    r  r  j  X   _numeric-checkr  r  j  j  r  hlX   [r  r  j  X   xr  r  hlX   ]r  r  j  X   
  r  r  j  X   (ifr  r  j  j  r  j  X   (notr  r  j  j  r  j  X	   (numeric?r  r  j  j  r  j  X   x))r  r  j  X   
    r  r  j  X   (raiser  r  j  j  r  j  X
   (TypeErrorr  r  j  j  r  j  X   (.formatr  r  j  j  r  j  X   "{0!r} is not a number"r  r  j  j  r  j  X   x)))))r  r  j  X   

r  r  j  X   (defnr  r  j  j  r  j  X   cycle r  r  hlj  r  j  X   collr  r  hlj  r   j  X   
  r  r  j  X3   "Yield an infinite repetition of the items in coll"r  r  j  X   
  r  r  j  X   (setvr  r  j  j  r	  j  X   seenr
  r  j  j  r  hlj  r
  hlj  r  j  X   )r  r  j  X   
  r  r  j  X   (forr  r  j  j  r  hlj  r  j  j  r  j  j  r  j  X   collr  r  hlj  r  j  X   
    r  r  j  X   (yieldr  r  j  j  r   j  X   x)r!  r"  j  X   
    r#  r$  j  X   (.appendr%  r&  j  j  r'  j  X   seenr(  r)  j  j  r*  j  X   x))r+  r,  j  X   
  r-  r.  j  X   (whiler/  r0  j  j  r1  j  X   seenr2  r3  j  X   
    r4  r5  j  X   (forr6  r7  j  j  r8  hlj  r9  j  j  r:  j  j  r;  j  X   seenr<  r=  hlj  r>  j  X   
      r?  r@  j  X   (yieldrA  rB  j  j  rC  j  X   x))))rD  rE  j  X   

rF  rG  j  X   (defnrH  rI  j  j  rJ  j  X   dec rK  rL  hlj  rM  j  X   nrN  rO  hlj  rP  j  X   
  rQ  rR  j  X   "Decrement n by 1"rS  rT  j  X   
  rU  rV  j  X   (_numeric-checkrW  rX  j  j  rY  j  X   n)rZ  r[  j  X   
  r\  r]  j  X   (-r^  r_  j  j  r`  j  jN  ra  j  j  rb  j  X   1rc  rd  j  X   ))re  rf  j  X   

rg  rh  j  X   (defnri  rj  j  j  rk  j  X	   distinct rl  rm  hlj  rn  j  X   collro  rp  hlj  rq  j  X   
  rr  rs  j  XL   "Return a generator from the original collection with duplicates
   removed"rt  ru  j  X   
  rv  rw  j  X   (letrx  ry  j  j  rz  hlj  r{  hlj  r|  j  X   seenr}  r~  j  j  r  hlj  r  hlj  r  hlj  r  j  j  r  hlj  r  j  X   citerr  r  j  j  r  j  X   (iterr  r  j  j  r  j  X   coll)r  r  hlj  r  hlj  r  j  X   
    r  r  j  X   (forr  r  j  j  r  hlj  r  j  X   valr  r  j  j  r  j  X   citerr  r  hlj  r  j  X   
      r  r  j  X   (ifr  r  j  j  r  j  X   (not_inr  r  j  j  r  j  X   valr  r  j  j  r  j  X   seen)r  r  j  X	   
        r  r  j  X   (dor  r  j  X
   
         r  r  j  X   (yieldr  r  j  j  r  j  X   val)r  r  j  X
   
         r  r  j  X   (.appendr  r  j  j  r  j  X   seenr  r  j  j  r  j  X	   val))))))r  r  j  X   

r  r  j  X   (defnr  r  j  j  r  j  X   drop r  r  hlj  r  j  X   countr  r  j  j  r  j  X   collr  r  hlj  r  j  X   
  r  r  j  X;   "Drop `count` elements from `coll` and yield back the rest"r  r  j  X   
  r  r  j  X   (letr  r  j  j  r  hlj  r  hlj  r  j  X   citerr  r  j  j  r  j  X   (iterr  r  j  j  r  j  X   coll)r  r  hlj  r  hlj  r  j  X   
    r  r  j  X   (tryr  r  j  j  r  j  X   (forr  r  j  j  r  hlj  r  j  X   ir  r  j  j  r  j  X   (ranger  r  j  j  r  j  X   count)r  r  hlj  r  j  X   
           r  r  j  X   (nextr  r  j  j  r  j  X   citer))r  r  j  X
   
         r  r  j  X   (catchr  r  j  j  r  hlj  r  j  X
   StopIterationr  r   hlj  r  j  X   ))r  r  j  X   
    r  r  j  X   citer))r  r  j  X   

r  r	  j  X   (defnr
  r  j  j  r  j  X   even? r
  r  hlj  r  j  jN  r  hlj  r  j  X   
  r  r  j  X$   "Return true if n is an even number"r  r  j  X   
  r  r  j  X   (_numeric-checkr  r  j  j  r  j  X   n)r  r  j  X   
  r  r  j  X   (=r  r   j  j  r!  j  X   (%r"  r#  j  j  r$  j  jN  r%  j  j  r&  j  X   2r'  r(  j  j  r)  j  j  r*  j  X   0r+  r,  j  X   ))r-  r.  j  X   

r/  r0  j  X   (defnr1  r2  j  j  r3  j  X   filterr4  r5  j  j  r6  hlj  r7  j  X   predr8  r9  j  j  r:  j  X   collr;  r<  hlj  r=  j  X   
  r>  r?  j  X2   "Return all elements from `coll` that pass `pred`"r@  rA  j  X   
  rB  rC  j  X   (letrD  rE  j  j  rF  hlj  rG  hlj  rH  j  X   citerrI  rJ  j  j  rK  j  X   (iterrL  rM  j  j  rN  j  X   coll)rO  rP  hlj  rQ  hlj  rR  j  X   
    rS  rT  j  X   (forrU  rV  j  j  rW  hlj  rX  j  X   valrY  rZ  j  j  r[  j  X   citerr\  r]  hlj  r^  j  X   
      r_  r`  j  X   (ifra  rb  j  j  rc  j  X   (predrd  re  j  j  rf  j  X   val)rg  rh  j  X	   
        ri  rj  j  X   (yieldrk  rl  j  j  rm  j  X   val)))))rn  ro  j  X   

rp  rq  j  X   (defnrr  rs  j  j  rt  j  X   inc ru  rv  hlj  rw  j  jN  rx  hlj  ry  j  X   
  rz  r{  j  X   "Increment n by 1"r|  r}  j  X   
  r~  r  j  X   (_numeric-checkr  r  j  j  r  j  X   n)r  r  j  X   
  r  r  j  X   (+r  r  j  j  r  j  jN  r  j  j  r  j  jc  r  j  X   ))r  r  j  X   

r  r  j  X   (defnr  r  j  j  r  j  X
   instance? r  r  hlj  r  j  X   klassr  r  j  j  r  j  j  r  hlj  r  j  X   
  r  r  j  X   (isinstancer  r  j  j  r  j  j  r  j  j  r  j  X   klass))r  r  j  X   

r  r  j  X   (defnr  r  j  j  r  j  X
   iterable? r  r  hlj  r  j  j  r  hlj  r  j  X   
  r  r  j  X   "Return true if x is iterable"r  r  j  X   
  r  r  j  X   (tryr  r  j  j  r  j  X   (dor  r  j  j  r  j  X   (iterr  r  j  j  r  j  X   x)r  r  j  j  r  j  X   true)r  r  j  X   
       r  r  j  X   (catchr  r  j  j  r  hlj  r  j  X	   Exceptionr  r  hlj  r  j  j  r  j  X   false)))r  r  j  X   

r  r  j  X   (defnr  r  j  j  r  j  X   iterate r  r  hlj  r  j  X   fr  r  j  j  r  j  j  r  hlj  r  j  X   
  r  r  j  X   (setvr  r  j  j  r  j  X   valr  r  j  j  r  j  X   x)r  r  j  X   
  r  r  j  X   (whiler  r  j  j  r  j  X   truer  r  j  X   
    r  r  j  X   (yieldr  r  j  j  r  j  X   val)r  r  j  X   
    r  r  j  X   (setvr  r  j  j  r  j  X   valr  r  j  j  r  j  X   (fr  r  j  j  r  j  X   val))))r  r   j  X   

r  r  j  X   (defnr  r  j  j  r  j  X
   iterator? r  r  hlj  r  j  j  r	  hlj  r
  j  X   
  r  r  j  X!   "Return true if x is an iterator"r
  r  j  X   
  r  r  j  X   (tryr  r  j  j  r  j  X   (=r  r  j  j  r  j  j  r  j  j  r  j  X   (iterr  r  j  j  r  j  X   x))r  r  j  X   
       r  r  j  X   (catchr   r!  j  j  r"  hlj  r#  j  X	   TypeErrorr$  r%  hlj  r&  j  j  r'  j  X   false)))r(  r)  j  X   

r*  r+  j  X   (defnr,  r-  j  j  r.  j  X   neg? r/  r0  hlj  r1  j  jN  r2  hlj  r3  j  X   
  r4  r5  j  X   "Return true if n is < 0"r6  r7  j  X   
  r8  r9  j  X   (_numeric-checkr:  r;  j  j  r<  j  X   n)r=  r>  j  X   
  r?  r@  j  X   (<rA  rB  j  j  rC  j  jN  rD  j  j  rE  j  j+  rF  j  X   ))rG  rH  j  X   

rI  rJ  j  X   (defnrK  rL  j  j  rM  j  X   none? rN  rO  hlj  rP  j  j  rQ  hlj  rR  j  X   
  rS  rT  j  X   "Return true if x is None"rU  rV  j  X   
  rW  rX  j  X   (isrY  rZ  j  j  r[  j  j  r\  j  j  r]  j   X   Noner^  r_  j  X   ))r`  ra  j  X   

rb  rc  j  X   (defnrd  re  j  j  rf  j  X	   numeric? rg  rh  hlj  ri  j  j  rj  hlj  rk  j  X   
  rl  rm  j  X   (importrn  ro  j  j  rp  j  X   numbers)rq  rr  j  X   
  rs  rt  j  X
   (instance?ru  rv  j  j  rw  j  X   numbers.Numberrx  ry  j  j  rz  j  X   x))r{  r|  j  X   

r}  r~  j  X   (defnr  r  j  j  r  j  X   nth r  r  hlj  r  j  X   collr  r  j  j  r  j  X   indexr  r  hlj  r  j  X   
  r  r  j  X<   "Return nth item in collection or sequence, counting from 0"r  r  j  X   
  r  r  j  X   (ifr  r  j  j  r  j  X   (notr  r  j  j  r  j  X   (neg?r  r  j  j  r  j  X   index))r  r  j  X   
    r  r  j  X   (ifr  r  j  j  r  j  X
   (iterable?r  r  j  j  r  j  X   coll)r  r  j  X   
      r  r  j  X   (tryr  r  j  j  r  j  X   (firstr  r  j  j  r  j  X   (listr  r  j  j  r  j  X   (taker  r  j  j  r  j  jc  r  j  j  r  j  X   (dropr  r  j  j  r  j  X   indexr  r  j  j  r  j  X   coll))))r  r  j  X   
           r  r  j  X   (catchr  r  j  j  r  hlj  r  j  X
   IndexErrorr  r  hlj  r  j  j  r  j   X   Noner  r  j  X   ))r  r  j  X   
      r  r  j  X   (tryr  r  j  j  r  j  X   (getr  r  j  j  r  j  X   collr  r  j  j  r  j  X   index)r  r  j  X   
           r  r  j  X   (catchr  r  j  j  r  hlj  r  j  X
   IndexErrorr  r  hlj  r  j  j  r  j   X   Noner  r  j  X   )))r  r  j  X   
    r  r  j   X   Noner  r  j  X   ))r  r  j  X   

r  r  j  X   (defnr  r  j  j  r  j  X   odd? r  r  hlj  r  j  jN  r  hlj  r  j  X   
  r  r  j  X#   "Return true if n is an odd number"r  r  j  X   
  r  r  j  X   (_numeric-checkr  r  j  j  r  j  X   n)r   r  j  X   
  r  r  j  X   (=r  r  j  j  r  j  X   (%r  r  j  j  r	  j  jN  r
  j  j  r  j  j'  r  j  j  r
  j  j  r  j  jc  r  j  X   ))r  r  j  X   

r  r  j  X   (defnr  r  j  j  r  j  X   pos? r  r  hlj  r  j  jN  r  hlj  r  j  X   
  r  r  j  X   "Return true if n is > 0"r  r  j  X   
  r   r!  j  X   (_numeric_checkr"  r#  j  j  r$  j  X   n)r%  r&  j  X   
  r'  r(  j  X   (>r)  r*  j  j  r+  j  jN  r,  j  j  r-  j  j+  r.  j  X   ))r/  r0  j  X   

r1  r2  j  X   (defnr3  r4  j  j  r5  j  X   remove r6  r7  hlj  r8  j  X   predr9  r:  j  j  r;  j  X   collr<  r=  hlj  r>  j  X   
  r?  r@  j  X4   "Return coll with elements removed that pass `pred`"rA  rB  j  X   
  rC  rD  j  X   (letrE  rF  j  j  rG  hlj  rH  hlj  rI  j  X   citerrJ  rK  j  j  rL  j  X   (iterrM  rN  j  j  rO  j  X   coll)rP  rQ  hlj  rR  hlj  rS  j  X   
    rT  rU  j  X   (forrV  rW  j  j  rX  hlj  rY  j  X   valrZ  r[  j  j  r\  j  X   citerr]  r^  hlj  r_  j  X   
      r`  ra  j  X   (ifrb  rc  j  j  rd  j  X   (notre  rf  j  j  rg  j  X   (predrh  ri  j  j  rj  j  X   val))rk  rl  j  X	   
        rm  rn  j  X   (yieldro  rp  j  j  rq  j  X   val)))))rr  rs  j  X   

rt  ru  j  X   (defnrv  rw  j  j  rx  j  X   repeat ry  rz  hlj  r{  j  j  r|  j  j  r}  jn  X   &r~  r  j  X   optionalr  r  j  j  r  j  jN  r  hlj  r  j  X   
  r  r  j  X'   "Yield x forever or optionally n times"r  r  j  X   
  r  r  j  X   (ifr  r  j  j  r  j  X   (none?r  r  j  j  r  j  X   n)r  r  j  X   
    r  r  j  X   (setvr  r  j  j  r  j  X   dispatchr  r  j  j  r  j  X   (fnr  r  j  j  r  hlj  r  hlj  r  j  j  r  j  X   (whiler  r  j  j  r  j  X   truer  r  j  j  r  j  X   (yieldr  r  j  j  r  j  X   x))))r  r  j  X   
    r  r  j  X   (setvr  r  j  j  r  j  X   dispatchr  r  j  j  r  j  X   (fnr  r  j  j  r  hlj  r  hlj  r  j  j  r  j  X   (forr  r  j  j  r  hlj  r  j  X   _r  r  j  j  r  j  X   (ranger  r  j  j  r  j  X   n)r  r  hlj  r  j  j  r  j  X   (yieldr  r  j  j  r  j  X   x)))))r  r  j  X   
  r  r  j  X   (dispatch))r  r  j  X   

r  r  j  X   (defnr  r  j  j  r  j  X   repeatedly r  r  hlj  r  j  X   funcr  r  hlj  r  j  X   
  r  r  j  X)   "Yield result of running func repeatedly"r  r  j  X   
  r  r  j  X   (whiler  r  j  j  r  j  X   truer  r  j  X   
    r  r  j  X   (yieldr  r  j  j  r  j  X	   (func))))r  r  j  X   

r  r  j  X   (defnr  r  j  j  r  j  X   take r  r  hlj  r  j  X   countr  r  j  j  r  j  X   collr  r  hlj  r  j  X   
  r  r  j  Xx   "Take `count` elements from `coll`, or the whole set if the total
    number of entries in `coll` is less than `count`."r  r  j  X   
  r   r  j  X   (letr  r  j  j  r  hlj  r  hlj  r  j  X   citerr  r  j  j  r	  j  X   (iterr
  r  j  j  r  j  X   coll)r
  r  hlj  r  hlj  r  j  X   
    r  r  j  X   (forr  r  j  j  r  hlj  r  j  j  r  j  j  r  j  X   (ranger  r  j  j  r  j  X   count)r  r  hlj  r  j  X   
      r  r   j  X   (yieldr!  r"  j  j  r#  j  X   (nextr$  r%  j  j  r&  j  X
   citer)))))r'  r(  j  X   

r)  r*  j  X   (defnr+  r,  j  j  r-  j  X   take-nthr.  r/  j  j  r0  hlj  r1  j  jN  r2  j  j  r3  j  X   collr4  r5  hlj  r6  j  X   
  r7  r8  j  XK   "Return every nth member of coll
     raises ValueError for (not (pos? n))"r9  r:  j  X   
  r;  r<  j  X   (ifr=  r>  j  j  r?  j  X   (pos?r@  rA  j  j  rB  j  X   n)rC  rD  j  X   
    rE  rF  j  X   (letrG  rH  j  j  rI  hlj  rJ  hlj  rK  j  X   citerrL  rM  j  j  rN  j  X   (iterrO  rP  j  j  rQ  j  X   coll)rR  rS  hlj  rT  j  j  rU  hlj  rV  j  X   skiprW  rX  j  j  rY  j  X   (decrZ  r[  j  j  r\  j  X   n)r]  r^  hlj  r_  hlj  r`  j  X   
      ra  rb  j  X   (forrc  rd  j  j  re  hlj  rf  j  X   valrg  rh  j  j  ri  j  X   citerrj  rk  hlj  rl  j  X	   
        rm  rn  j  X   (yieldro  rp  j  j  rq  j  X   val)rr  rs  j  X	   
        rt  ru  j  X   (forrv  rw  j  j  rx  hlj  ry  j  j  rz  j  j  r{  j  X   (ranger|  r}  j  j  r~  j  X   skip)r  r  hlj  r  j  X   
          r  r  j  X   (nextr  r  j  j  r  j  X	   citer))))r  r  j  X   
    r  r  j  X   (raiser  r  j  j  r  j  X   (ValueErrorr  r  j  j  r  j  X   "n must be positive"r  r  j  X   ))))r  r  j  X   

r  r  j  X   (defnr  r  j  j  r  j  X
   take-whiler  r  j  j  r  hlj  r  j  X   predr  r  j  j  r  j  X   collr  r  hlj  r  j  X   
  r  r  j  X(   "Take all elements while `pred` is true"r  r  j  X   
  r  r  j  X   (letr  r  j  j  r  hlj  r  hlj  r  j  X   citerr  r  j  j  r  j  X   (iterr  r  j  j  r  j  X   coll)r  r  hlj  r  hlj  r  j  X   
    r  r  j  X   (forr  r  j  j  r  hlj  r  j  X   valr  r  j  j  r  j  X   citerr  r  hlj  r  j  X   
      r  r  j  X   (ifr  r  j  j  r  j  X   (predr  r  j  j  r  j  X   val)r  r  j  X	   
        r  r  j  X   (yieldr  r  j  j  r  j  X   val)r  r  j  X	   
        r  r  j  X   (break)))))r  r  j  X   

r  r  j  X   (defnr  r  j  j  r  j  X   zero? r  r  hlj  r  j  jN  r  hlj  r  j  X   
  r  r  j  X   "Return true if n is 0"r  r  j  X   
  r  r  j  X   (_numeric_checkr  r  j  j  r  j  X   n)r  r  j  X   
  r  r  j  X   (=r  r  j  j  r  j  jN  r  j  j  r  j  j+  r  j  X   ))r  r  j  X   

r  r  j  X   (defr  r  j  j  r  j  X	   *exports*r  r  j  j  r 	  hlj  r	  j  X   "cycle"r	  r	  j  j  r	  j  X   "dec"r	  r	  j  j  r	  j  X
   "distinct"r	  r		  j  j  r
	  j  X   "drop"r	  r	  j  j  r
	  j  X   "even?"r	  r	  j  j  r	  j  X   "filter"r	  r	  j  j  r	  j  X   "inc"r	  r	  j  X   
                r	  r	  j  X   "instance?"r	  r	  j  j  r	  j  X   "iterable?"r	  r	  j  j  r	  j  X	   "iterate"r	  r	  j  j  r 	  j  X   "iterator?"r!	  r"	  j  j  r#	  j  X   "neg?"r$	  r%	  j  X   
                r&	  r'	  j  X   "none?"r(	  r)	  j  j  r*	  j  X   "nth"r+	  r,	  j  j  r-	  j  X
   "numeric?"r.	  r/	  j  j  r0	  j  X   "odd?"r1	  r2	  j  j  r3	  j  X   "pos?"r4	  r5	  j  j  r6	  j  X   "remove"r7	  r8	  j  j  r9	  j  X   "repeat"r:	  r;	  j  X   
                r<	  r=	  j  X   "repeatedly"r>	  r?	  j  j  r@	  j  X   "take"rA	  rB	  j  j  rC	  j  X
   "take_nth"rD	  rE	  j  j  rF	  j  X   "take_while"rG	  rH	  j  j  rI	  j  X   "zero?"rJ	  rK	  hlj  rL	  j  j  rM	  j  j  rN	  e.