.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XrmPutResource __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XrmPutResource, XrmQPutResource, XrmPutStringResource, XrmQPutStringResource, XrmPutLineResource \- store database resources
.SH SYNTAX
.HP
#include <X11/Xresource.h>
.HP
void XrmPutResource\^(\^XrmDatabase *\fIdatabase\fP\^, char
*\fIspecifier\fP\^, char *\fItype\fP\^, XrmValue *\fIvalue\fP\^);
.HP
void XrmQPutResource\^(\^XrmDatabase *\fIdatabase\fP\^, XrmBindingList
\fIbindings\fP\^, XrmQuarkList \fIquarks\fP\^, XrmRepresentation \fItype\fP\^,
XrmValue *\fIvalue\fP\^);
.HP
void XrmPutStringResource\^(\^XrmDatabase *\fIdatabase\fP\^, char
*\fIspecifier\fP\^, char *\fIvalue\fP\^);
.HP
void XrmQPutStringResource\^(\^XrmDatabase *\fIdatabase\fP\^, XrmBindingList
\fIbindings\fP\^, XrmQuarkList \fIquarks\fP\^, char *\fIvalue\fP\^);
.HP
void XrmPutLineResource\^(\^XrmDatabase *\fIdatabase\fP\^, char
*\fIline\fP\^);
.SH ARGUMENTS
.IP \fIbindings\fP 1i
Specifies a list of bindings.
.IP \fIdatabase\fP 1i
Specifies the resource database.
.IP \fIline\fP 1i
Specifies the resource name and value pair as a single string.
.IP \fIquarks\fP 1i
Specifies the complete or partial name or the class list of the resource.
.IP \fIspecifier\fP 1i
Specifies a complete or partial specification of the resource.
.IP \fItype\fP 1i
Specifies the type of the resource.
.IP \fIvalue\fP 1i
Specifies the value of the resource, which is specified as a string.
.SH DESCRIPTION
If database contains NULL,
.B XrmPutResource
creates a new database and returns a pointer to it.
.B XrmPutResource
is a convenience function that calls
.B XrmStringToBindingQuarkList
followed by:
.LP
.EX
XrmQPutResource(database, bindings, quarks, XrmStringToQuark(type), value)
.EE
.LP
If the specifier and type are not in the Host Portable Character Encoding,
the result is implementation-dependent.
The value is stored in the database without modification.
.LP
If database contains NULL,
.B XrmQPutResource
creates a new database and returns a pointer to it.
If a resource entry with the identical bindings and quarks already
exists in the database, the previous type and value are replaced by the new
specified type and value.
The value is stored in the database without modification.
.LP
If database contains NULL,
.B XrmPutStringResource
creates a new database and returns a pointer to it.
.B XrmPutStringResource
adds a resource with the specified value to the specified database.
.B XrmPutStringResource
is a convenience function that first calls
.B XrmStringToBindingQuarkList
on the specifier and then calls
.BR XrmQPutResource ,
using a \*(lqString\*(rq representation type.
If the specifier is not in the Host Portable Character Encoding,
the result is implementation-dependent.
The value is stored in the database without modification.
.LP
If database contains NULL,
.B XrmQPutStringResource
creates a new database and returns a pointer to it.
.B XrmQPutStringResource
is a convenience routine that constructs an
.B XrmValue
for the value string (by calling
.B strlen
to compute the size) and
then calls
.BR XrmQPutResource ,
using a \*(lqString\*(rq representation type.
The value is stored in the database without modification.
.LP
If database contains NULL,
.B XrmPutLineResource
creates a new database and returns a pointer to it.
.B XrmPutLineResource
adds a single resource entry to the specified database.
The line should be in valid ResourceLine format (see section 15.1)
terminated by a newline or null character;
the database that results from using a string
with incorrect syntax is implementation-dependent.
The string is parsed in the locale of the database.
If the
.B ResourceName
is not in the Host Portable Character Encoding,
the result is implementation-dependent.
Note that comment lines are not stored.
.SH "SEE ALSO"
XrmGetResource(__libmansuffix__),
XrmInitialize(__libmansuffix__),
XrmMergeDatabases(__libmansuffix__),
XrmUniqueQuark(__libmansuffix__)
.br
\fI\*(xL\fP
