.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XSetCloseDownMode __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XSetCloseDownMode, XKillClient \- control clients
.SH SYNTAX
.HP
int XSetCloseDownMode\^(\^Display *\fIdisplay\fP\^, int \fIclose_mode\fP\^);
.HP
int XKillClient\^(\^Display *\fIdisplay\fP\^, XID \fIresource\fP\^);
.SH ARGUMENTS
.IP \fIclose_mode\fP 1i
Specifies the client close-down mode.
You can pass
.BR DestroyAll ,
.BR RetainPermanent ,
or
.BR RetainTemporary .
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIresource\fP 1i
Specifies any resource associated with the client that you want to destroy or
.BR AllTemporary .
.SH DESCRIPTION
The
.B XSetCloseDownMode
defines what will happen to the client's resources at connection close.
A connection starts in
.B DestroyAll
mode.
For information on what happens to the client's resources when the
close_mode argument is
.B RetainPermanent
or
.BR RetainTemporary ,
see section 2.6.
.LP
.B XSetCloseDownMode
can generate a
.B BadValue
error.
.LP
The
.B XKillClient
function
forces a close down of the client
that created the resource
if a valid resource is specified.
If the client has already terminated in
either
.B RetainPermanent
or
.B RetainTemporary
mode, all of the client's
resources are destroyed.
If
.B AllTemporary
is specified, the resources of all clients that have terminated in
.B RetainTemporary
are destroyed (see section 2.5).
This permits implementation of window manager facilities that aid debugging.
A client can set its close-down mode to
.BR RetainTemporary .
If the client then crashes,
its windows would not be destroyed.
The programmer can then inspect the application's window tree
and use the window manager to destroy the zombie windows.
.LP
.B XKillClient
can generate a
.B BadValue
error.
.SH DIAGNOSTICS
.TP 1i
.B BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.
Any argument defined as a set of
alternatives can generate this error.
.SH "SEE ALSO"
\fI\*(xL\fP
