/*
 * OmniVision ov490-ov10640 sensor camera setup 1280x1080@30/UYVY/BT601/8bit
 *
 * Copyright (C) 2016-2020 Cogent Embedded, Inc.
 *
 * This program is free software; you can redistribute  it and/or modify it
 * under  the terms of  the GNU General  Public License as published by the
 * Free Software Foundation;  either version 2 of the  License, or (at your
 * option) any later version.
 */

//#define OV490_DISPLAY_PATTERN

struct ov490_reg {
	u16	reg;
	u8	val;
};

static const struct ov490_reg ov490_regs[] = {
/* The following registers should match firmware */
{0xfffd, 0x80},
{0xfffe, 0x82},
{0x0071, 0x11},
{0x0075, 0x11},
{0xfffe, 0x29},
{0x6010, 0x01},
/* ov490 EMB line disable in YUV and RAW data, NOTE: EMB line is still used in ISP and sensor */
{0xe000, 0x14},
#if 0 /* do not disable EMB line in ISP! */
{0x4017, 0x00},
#endif
{0xfffe, 0x28},
{0x6000, 0x04},
{0x6004, 0x00},
{0x6008, 0x00}, // PCLK polarity - useless due to silicon bug -> use 0x808000bb register
{0xfffe, 0x80},
{0x0091, 0x00},
{0x00bb, 0x1d}, // bit[3]=0 - PCLK polarity workaround
/* ov10640 EMB line disable */
#if 0 /* do not disable EMB line in sensor! */
{0xfffe, 0x19},
{0x5000, 0x00},
{0x5001, 0x30},
{0x5002, 0x91},
{0x5003, 0x08},
{0xfffe, 0x80},
{0x00c0, 0xc1},
#endif
/* Ov490 FSIN: app_fsin_from_fsync */
{0xfffe, 0x85},
{0x0008, 0x00},
{0x0009, 0x01},
{0x000A, 0x05}, // fsin0 src
{0x000B, 0x00},
{0x0030, 0x02}, // fsin0_delay
{0x0031, 0x00},
{0x0032, 0x00},
{0x0033, 0x00},
{0x0038, 0x02}, // fsin1_delay
{0x0039, 0x00},
{0x003A, 0x00},
{0x003B, 0x00},
{0x0070, 0x2C}, // fsin0_length
{0x0071, 0x01},
{0x0072, 0x00},
{0x0073, 0x00},
{0x0074, 0x64}, // fsin1_length
{0x0075, 0x00},
{0x0076, 0x00},
{0x0077, 0x00},
{0x0000, 0x14},
{0x0001, 0x00},
{0x0002, 0x00},
{0x0003, 0x00},
{0x0004, 0x32}, // load fsin0,load fsin1,load other, it will be cleared automatically.
{0x0005, 0x00},
{0x0006, 0x00},
{0x0007, 0x00},
{0xfffe, 0x80},
{0x0081, 0x00}, // 03;SENSOR FSIN
/* ov10640 FSIN */
{0xfffe, 0x19},
{0x5000, 0x00},
{0x5001, 0x30},
{0x5002, 0x8c},
{0x5003, 0xb2},
{0xfffe, 0x80},
{0x00c0, 0xc1},
/* ov10640 HFLIP=1 by default */
{0xfffe, 0x19},
{0x5000, 0x01},
{0x5001, 0x00},
{0xfffe, 0x80},
{0x00c0, 0xdc},
#ifdef OV490_DISPLAY_PATTERN
{0xfffe, 0x19},
{0x5000, 0x02},
{0xfffe, 0x80},
{0x00c0, 0xd6},
#endif
};
