/*
 * Copyright © 2017 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

/* THIS FILE HAS BEEN GENERATED, DO NOT HAND EDIT.
 *
 * Sizes of bitfields in genxml instructions, structures, and registers.
 */

#ifndef GENX_BITS_H
#define GENX_BITS_H

#include <stdint.h>

#include "common/gen_device_info.h"
#include "util/macros.h"



#ifdef __cplusplus
extern "C" {
#endif

/* 3DPRIMITIVE */


#define GEN10_3DPRIMITIVE_length  7
#define GEN9_3DPRIMITIVE_length  7
#define GEN8_3DPRIMITIVE_length  7
#define GEN75_3DPRIMITIVE_length  7
#define GEN7_3DPRIMITIVE_length  7
#define GEN6_3DPRIMITIVE_length  6
#define GEN5_3DPRIMITIVE_length  6
#define GEN45_3DPRIMITIVE_length  6
#define GEN4_3DPRIMITIVE_length  6

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 7;
   case 9: return 7;
   case 8: return 7;
   case 7:
      if (devinfo->is_haswell) {
         return 7;
      } else {
         return 7;
      }
   case 6: return 6;
   case 5: return 6;
   case 4:
      if (devinfo->is_g4x) {
         return 6;
      } else {
         return 6;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::3D Command Opcode */


#define GEN10_3DPRIMITIVE_3DCommandOpcode_bits  3
#define GEN9_3DPRIMITIVE_3DCommandOpcode_bits  3
#define GEN8_3DPRIMITIVE_3DCommandOpcode_bits  3
#define GEN75_3DPRIMITIVE_3DCommandOpcode_bits  3
#define GEN7_3DPRIMITIVE_3DCommandOpcode_bits  3
#define GEN6_3DPRIMITIVE_3DCommandOpcode_bits  3
#define GEN5_3DPRIMITIVE_3DCommandOpcode_bits  3
#define GEN45_3DPRIMITIVE_3DCommandOpcode_bits  3
#define GEN4_3DPRIMITIVE_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 3;
   case 4:
      if (devinfo->is_g4x) {
         return 3;
      } else {
         return 3;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DPRIMITIVE_3DCommandOpcode_start  24
#define GEN9_3DPRIMITIVE_3DCommandOpcode_start  24
#define GEN8_3DPRIMITIVE_3DCommandOpcode_start  24
#define GEN75_3DPRIMITIVE_3DCommandOpcode_start  24
#define GEN7_3DPRIMITIVE_3DCommandOpcode_start  24
#define GEN6_3DPRIMITIVE_3DCommandOpcode_start  24
#define GEN5_3DPRIMITIVE_3DCommandOpcode_start  24
#define GEN45_3DPRIMITIVE_3DCommandOpcode_start  24
#define GEN4_3DPRIMITIVE_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 24;
      }
   case 6: return 24;
   case 5: return 24;
   case 4:
      if (devinfo->is_g4x) {
         return 24;
      } else {
         return 24;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::3D Command Sub Opcode */


#define GEN10_3DPRIMITIVE_3DCommandSubOpcode_bits  8
#define GEN9_3DPRIMITIVE_3DCommandSubOpcode_bits  8
#define GEN8_3DPRIMITIVE_3DCommandSubOpcode_bits  8
#define GEN75_3DPRIMITIVE_3DCommandSubOpcode_bits  8
#define GEN7_3DPRIMITIVE_3DCommandSubOpcode_bits  8
#define GEN6_3DPRIMITIVE_3DCommandSubOpcode_bits  8
#define GEN5_3DPRIMITIVE_3DCommandSubOpcode_bits  8
#define GEN45_3DPRIMITIVE_3DCommandSubOpcode_bits  8
#define GEN4_3DPRIMITIVE_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 8;
   case 4:
      if (devinfo->is_g4x) {
         return 8;
      } else {
         return 8;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DPRIMITIVE_3DCommandSubOpcode_start  16
#define GEN9_3DPRIMITIVE_3DCommandSubOpcode_start  16
#define GEN8_3DPRIMITIVE_3DCommandSubOpcode_start  16
#define GEN75_3DPRIMITIVE_3DCommandSubOpcode_start  16
#define GEN7_3DPRIMITIVE_3DCommandSubOpcode_start  16
#define GEN6_3DPRIMITIVE_3DCommandSubOpcode_start  16
#define GEN5_3DPRIMITIVE_3DCommandSubOpcode_start  16
#define GEN45_3DPRIMITIVE_3DCommandSubOpcode_start  16
#define GEN4_3DPRIMITIVE_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 16;
   case 5: return 16;
   case 4:
      if (devinfo->is_g4x) {
         return 16;
      } else {
         return 16;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::Base Vertex Location */


#define GEN10_3DPRIMITIVE_BaseVertexLocation_bits  32
#define GEN9_3DPRIMITIVE_BaseVertexLocation_bits  32
#define GEN8_3DPRIMITIVE_BaseVertexLocation_bits  32
#define GEN75_3DPRIMITIVE_BaseVertexLocation_bits  32
#define GEN7_3DPRIMITIVE_BaseVertexLocation_bits  32
#define GEN6_3DPRIMITIVE_BaseVertexLocation_bits  32
#define GEN5_3DPRIMITIVE_BaseVertexLocation_bits  32
#define GEN45_3DPRIMITIVE_BaseVertexLocation_bits  32
#define GEN4_3DPRIMITIVE_BaseVertexLocation_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_BaseVertexLocation_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 32;
      }
   case 6: return 32;
   case 5: return 32;
   case 4:
      if (devinfo->is_g4x) {
         return 32;
      } else {
         return 32;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DPRIMITIVE_BaseVertexLocation_start  192
#define GEN9_3DPRIMITIVE_BaseVertexLocation_start  192
#define GEN8_3DPRIMITIVE_BaseVertexLocation_start  192
#define GEN75_3DPRIMITIVE_BaseVertexLocation_start  192
#define GEN7_3DPRIMITIVE_BaseVertexLocation_start  192
#define GEN6_3DPRIMITIVE_BaseVertexLocation_start  160
#define GEN5_3DPRIMITIVE_BaseVertexLocation_start  160
#define GEN45_3DPRIMITIVE_BaseVertexLocation_start  160
#define GEN4_3DPRIMITIVE_BaseVertexLocation_start  160

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_BaseVertexLocation_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 192;
   case 9: return 192;
   case 8: return 192;
   case 7:
      if (devinfo->is_haswell) {
         return 192;
      } else {
         return 192;
      }
   case 6: return 160;
   case 5: return 160;
   case 4:
      if (devinfo->is_g4x) {
         return 160;
      } else {
         return 160;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::Command SubType */


#define GEN10_3DPRIMITIVE_CommandSubType_bits  2
#define GEN9_3DPRIMITIVE_CommandSubType_bits  2
#define GEN8_3DPRIMITIVE_CommandSubType_bits  2
#define GEN75_3DPRIMITIVE_CommandSubType_bits  2
#define GEN7_3DPRIMITIVE_CommandSubType_bits  2
#define GEN6_3DPRIMITIVE_CommandSubType_bits  2
#define GEN5_3DPRIMITIVE_CommandSubType_bits  2
#define GEN45_3DPRIMITIVE_CommandSubType_bits  2
#define GEN4_3DPRIMITIVE_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 2;
   case 5: return 2;
   case 4:
      if (devinfo->is_g4x) {
         return 2;
      } else {
         return 2;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DPRIMITIVE_CommandSubType_start  27
#define GEN9_3DPRIMITIVE_CommandSubType_start  27
#define GEN8_3DPRIMITIVE_CommandSubType_start  27
#define GEN75_3DPRIMITIVE_CommandSubType_start  27
#define GEN7_3DPRIMITIVE_CommandSubType_start  27
#define GEN6_3DPRIMITIVE_CommandSubType_start  27
#define GEN5_3DPRIMITIVE_CommandSubType_start  27
#define GEN45_3DPRIMITIVE_CommandSubType_start  27
#define GEN4_3DPRIMITIVE_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 27;
      }
   case 6: return 27;
   case 5: return 27;
   case 4:
      if (devinfo->is_g4x) {
         return 27;
      } else {
         return 27;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::Command Type */


#define GEN10_3DPRIMITIVE_CommandType_bits  3
#define GEN9_3DPRIMITIVE_CommandType_bits  3
#define GEN8_3DPRIMITIVE_CommandType_bits  3
#define GEN75_3DPRIMITIVE_CommandType_bits  3
#define GEN7_3DPRIMITIVE_CommandType_bits  3
#define GEN6_3DPRIMITIVE_CommandType_bits  3
#define GEN5_3DPRIMITIVE_CommandType_bits  3
#define GEN45_3DPRIMITIVE_CommandType_bits  3
#define GEN4_3DPRIMITIVE_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 3;
   case 4:
      if (devinfo->is_g4x) {
         return 3;
      } else {
         return 3;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DPRIMITIVE_CommandType_start  29
#define GEN9_3DPRIMITIVE_CommandType_start  29
#define GEN8_3DPRIMITIVE_CommandType_start  29
#define GEN75_3DPRIMITIVE_CommandType_start  29
#define GEN7_3DPRIMITIVE_CommandType_start  29
#define GEN6_3DPRIMITIVE_CommandType_start  29
#define GEN5_3DPRIMITIVE_CommandType_start  29
#define GEN45_3DPRIMITIVE_CommandType_start  29
#define GEN4_3DPRIMITIVE_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 29;
      }
   case 6: return 29;
   case 5: return 29;
   case 4:
      if (devinfo->is_g4x) {
         return 29;
      } else {
         return 29;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::DWord Length */


#define GEN10_3DPRIMITIVE_DWordLength_bits  8
#define GEN9_3DPRIMITIVE_DWordLength_bits  8
#define GEN8_3DPRIMITIVE_DWordLength_bits  8
#define GEN75_3DPRIMITIVE_DWordLength_bits  8
#define GEN7_3DPRIMITIVE_DWordLength_bits  8
#define GEN6_3DPRIMITIVE_DWordLength_bits  8
#define GEN5_3DPRIMITIVE_DWordLength_bits  8
#define GEN45_3DPRIMITIVE_DWordLength_bits  8
#define GEN4_3DPRIMITIVE_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 8;
   case 4:
      if (devinfo->is_g4x) {
         return 8;
      } else {
         return 8;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DPRIMITIVE_DWordLength_start  0
#define GEN9_3DPRIMITIVE_DWordLength_start  0
#define GEN8_3DPRIMITIVE_DWordLength_start  0
#define GEN75_3DPRIMITIVE_DWordLength_start  0
#define GEN7_3DPRIMITIVE_DWordLength_start  0
#define GEN6_3DPRIMITIVE_DWordLength_start  0
#define GEN5_3DPRIMITIVE_DWordLength_start  0
#define GEN45_3DPRIMITIVE_DWordLength_start  0
#define GEN4_3DPRIMITIVE_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::End Offset Enable */


#define GEN10_3DPRIMITIVE_EndOffsetEnable_bits  1
#define GEN9_3DPRIMITIVE_EndOffsetEnable_bits  1
#define GEN8_3DPRIMITIVE_EndOffsetEnable_bits  1
#define GEN75_3DPRIMITIVE_EndOffsetEnable_bits  1
#define GEN7_3DPRIMITIVE_EndOffsetEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_EndOffsetEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DPRIMITIVE_EndOffsetEnable_start  41
#define GEN9_3DPRIMITIVE_EndOffsetEnable_start  41
#define GEN8_3DPRIMITIVE_EndOffsetEnable_start  41
#define GEN75_3DPRIMITIVE_EndOffsetEnable_start  41
#define GEN7_3DPRIMITIVE_EndOffsetEnable_start  41

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_EndOffsetEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 41;
   case 9: return 41;
   case 8: return 41;
   case 7:
      if (devinfo->is_haswell) {
         return 41;
      } else {
         return 41;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::Extended Parameter 0 */


#define GEN10_3DPRIMITIVE_ExtendedParameter0_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_ExtendedParameter0_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DPRIMITIVE_ExtendedParameter0_start  224

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_ExtendedParameter0_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 224;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::Extended Parameter 1 */


#define GEN10_3DPRIMITIVE_ExtendedParameter1_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_ExtendedParameter1_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DPRIMITIVE_ExtendedParameter1_start  256

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_ExtendedParameter1_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 256;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::Extended Parameter 2 */


#define GEN10_3DPRIMITIVE_ExtendedParameter2_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_ExtendedParameter2_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DPRIMITIVE_ExtendedParameter2_start  288

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_ExtendedParameter2_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 288;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::Extended Parameters Present */


#define GEN10_3DPRIMITIVE_ExtendedParametersPresent_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_ExtendedParametersPresent_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DPRIMITIVE_ExtendedParametersPresent_start  11

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_ExtendedParametersPresent_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 11;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::Indirect Parameter Enable */


#define GEN10_3DPRIMITIVE_IndirectParameterEnable_bits  1
#define GEN9_3DPRIMITIVE_IndirectParameterEnable_bits  1
#define GEN8_3DPRIMITIVE_IndirectParameterEnable_bits  1
#define GEN75_3DPRIMITIVE_IndirectParameterEnable_bits  1
#define GEN7_3DPRIMITIVE_IndirectParameterEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_IndirectParameterEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DPRIMITIVE_IndirectParameterEnable_start  10
#define GEN9_3DPRIMITIVE_IndirectParameterEnable_start  10
#define GEN8_3DPRIMITIVE_IndirectParameterEnable_start  10
#define GEN75_3DPRIMITIVE_IndirectParameterEnable_start  10
#define GEN7_3DPRIMITIVE_IndirectParameterEnable_start  10

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_IndirectParameterEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 10;
   case 9: return 10;
   case 8: return 10;
   case 7:
      if (devinfo->is_haswell) {
         return 10;
      } else {
         return 10;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::Indirect Vertex Count */


#define GEN5_3DPRIMITIVE_IndirectVertexCount_bits  1
#define GEN45_3DPRIMITIVE_IndirectVertexCount_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_IndirectVertexCount_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 1;
   case 4:
      if (devinfo->is_g4x) {
         return 1;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN5_3DPRIMITIVE_IndirectVertexCount_start  9
#define GEN45_3DPRIMITIVE_IndirectVertexCount_start  9

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_IndirectVertexCount_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 9;
   case 4:
      if (devinfo->is_g4x) {
         return 9;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::Instance Count */


#define GEN10_3DPRIMITIVE_InstanceCount_bits  32
#define GEN9_3DPRIMITIVE_InstanceCount_bits  32
#define GEN8_3DPRIMITIVE_InstanceCount_bits  32
#define GEN75_3DPRIMITIVE_InstanceCount_bits  32
#define GEN7_3DPRIMITIVE_InstanceCount_bits  32
#define GEN6_3DPRIMITIVE_InstanceCount_bits  32
#define GEN5_3DPRIMITIVE_InstanceCount_bits  32
#define GEN45_3DPRIMITIVE_InstanceCount_bits  32
#define GEN4_3DPRIMITIVE_InstanceCount_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_InstanceCount_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 32;
      }
   case 6: return 32;
   case 5: return 32;
   case 4:
      if (devinfo->is_g4x) {
         return 32;
      } else {
         return 32;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DPRIMITIVE_InstanceCount_start  128
#define GEN9_3DPRIMITIVE_InstanceCount_start  128
#define GEN8_3DPRIMITIVE_InstanceCount_start  128
#define GEN75_3DPRIMITIVE_InstanceCount_start  128
#define GEN7_3DPRIMITIVE_InstanceCount_start  128
#define GEN6_3DPRIMITIVE_InstanceCount_start  96
#define GEN5_3DPRIMITIVE_InstanceCount_start  96
#define GEN45_3DPRIMITIVE_InstanceCount_start  96
#define GEN4_3DPRIMITIVE_InstanceCount_start  96

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_InstanceCount_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 128;
   case 9: return 128;
   case 8: return 128;
   case 7:
      if (devinfo->is_haswell) {
         return 128;
      } else {
         return 128;
      }
   case 6: return 96;
   case 5: return 96;
   case 4:
      if (devinfo->is_g4x) {
         return 96;
      } else {
         return 96;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::Internal Vertex Count */


#define GEN6_3DPRIMITIVE_InternalVertexCount_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_InternalVertexCount_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DPRIMITIVE_InternalVertexCount_start  9

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_InternalVertexCount_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 9;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::Predicate Enable */


#define GEN10_3DPRIMITIVE_PredicateEnable_bits  1
#define GEN9_3DPRIMITIVE_PredicateEnable_bits  1
#define GEN8_3DPRIMITIVE_PredicateEnable_bits  1
#define GEN75_3DPRIMITIVE_PredicateEnable_bits  1
#define GEN7_3DPRIMITIVE_PredicateEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_PredicateEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DPRIMITIVE_PredicateEnable_start  8
#define GEN9_3DPRIMITIVE_PredicateEnable_start  8
#define GEN8_3DPRIMITIVE_PredicateEnable_start  8
#define GEN75_3DPRIMITIVE_PredicateEnable_start  8
#define GEN7_3DPRIMITIVE_PredicateEnable_start  8

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_PredicateEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::Primitive Topology Type */


#define GEN10_3DPRIMITIVE_PrimitiveTopologyType_bits  6
#define GEN9_3DPRIMITIVE_PrimitiveTopologyType_bits  6
#define GEN8_3DPRIMITIVE_PrimitiveTopologyType_bits  6
#define GEN75_3DPRIMITIVE_PrimitiveTopologyType_bits  6
#define GEN7_3DPRIMITIVE_PrimitiveTopologyType_bits  6
#define GEN6_3DPRIMITIVE_PrimitiveTopologyType_bits  5
#define GEN5_3DPRIMITIVE_PrimitiveTopologyType_bits  5
#define GEN45_3DPRIMITIVE_PrimitiveTopologyType_bits  5
#define GEN4_3DPRIMITIVE_PrimitiveTopologyType_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_PrimitiveTopologyType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 6;
   case 9: return 6;
   case 8: return 6;
   case 7:
      if (devinfo->is_haswell) {
         return 6;
      } else {
         return 6;
      }
   case 6: return 5;
   case 5: return 5;
   case 4:
      if (devinfo->is_g4x) {
         return 5;
      } else {
         return 5;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DPRIMITIVE_PrimitiveTopologyType_start  32
#define GEN9_3DPRIMITIVE_PrimitiveTopologyType_start  32
#define GEN8_3DPRIMITIVE_PrimitiveTopologyType_start  32
#define GEN75_3DPRIMITIVE_PrimitiveTopologyType_start  32
#define GEN7_3DPRIMITIVE_PrimitiveTopologyType_start  32
#define GEN6_3DPRIMITIVE_PrimitiveTopologyType_start  10
#define GEN5_3DPRIMITIVE_PrimitiveTopologyType_start  10
#define GEN45_3DPRIMITIVE_PrimitiveTopologyType_start  10
#define GEN4_3DPRIMITIVE_PrimitiveTopologyType_start  10

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_PrimitiveTopologyType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 32;
      }
   case 6: return 10;
   case 5: return 10;
   case 4:
      if (devinfo->is_g4x) {
         return 10;
      } else {
         return 10;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::Start Instance Location */


#define GEN10_3DPRIMITIVE_StartInstanceLocation_bits  32
#define GEN9_3DPRIMITIVE_StartInstanceLocation_bits  32
#define GEN8_3DPRIMITIVE_StartInstanceLocation_bits  32
#define GEN75_3DPRIMITIVE_StartInstanceLocation_bits  32
#define GEN7_3DPRIMITIVE_StartInstanceLocation_bits  32
#define GEN6_3DPRIMITIVE_StartInstanceLocation_bits  32
#define GEN5_3DPRIMITIVE_StartInstanceLocation_bits  32
#define GEN45_3DPRIMITIVE_StartInstanceLocation_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_StartInstanceLocation_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 32;
      }
   case 6: return 32;
   case 5: return 32;
   case 4:
      if (devinfo->is_g4x) {
         return 32;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DPRIMITIVE_StartInstanceLocation_start  160
#define GEN9_3DPRIMITIVE_StartInstanceLocation_start  160
#define GEN8_3DPRIMITIVE_StartInstanceLocation_start  160
#define GEN75_3DPRIMITIVE_StartInstanceLocation_start  160
#define GEN7_3DPRIMITIVE_StartInstanceLocation_start  160
#define GEN6_3DPRIMITIVE_StartInstanceLocation_start  128
#define GEN5_3DPRIMITIVE_StartInstanceLocation_start  128
#define GEN45_3DPRIMITIVE_StartInstanceLocation_start  128

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_StartInstanceLocation_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 160;
   case 9: return 160;
   case 8: return 160;
   case 7:
      if (devinfo->is_haswell) {
         return 160;
      } else {
         return 160;
      }
   case 6: return 128;
   case 5: return 128;
   case 4:
      if (devinfo->is_g4x) {
         return 128;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::Start Vertex Location */


#define GEN10_3DPRIMITIVE_StartVertexLocation_bits  32
#define GEN9_3DPRIMITIVE_StartVertexLocation_bits  32
#define GEN8_3DPRIMITIVE_StartVertexLocation_bits  32
#define GEN75_3DPRIMITIVE_StartVertexLocation_bits  32
#define GEN7_3DPRIMITIVE_StartVertexLocation_bits  32
#define GEN6_3DPRIMITIVE_StartVertexLocation_bits  32
#define GEN5_3DPRIMITIVE_StartVertexLocation_bits  32
#define GEN45_3DPRIMITIVE_StartVertexLocation_bits  32
#define GEN4_3DPRIMITIVE_StartVertexLocation_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_StartVertexLocation_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 32;
      }
   case 6: return 32;
   case 5: return 32;
   case 4:
      if (devinfo->is_g4x) {
         return 32;
      } else {
         return 32;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DPRIMITIVE_StartVertexLocation_start  96
#define GEN9_3DPRIMITIVE_StartVertexLocation_start  96
#define GEN8_3DPRIMITIVE_StartVertexLocation_start  96
#define GEN75_3DPRIMITIVE_StartVertexLocation_start  96
#define GEN7_3DPRIMITIVE_StartVertexLocation_start  96
#define GEN6_3DPRIMITIVE_StartVertexLocation_start  64
#define GEN5_3DPRIMITIVE_StartVertexLocation_start  64
#define GEN45_3DPRIMITIVE_StartVertexLocation_start  64
#define GEN4_3DPRIMITIVE_StartVertexLocation_start  64

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_StartVertexLocation_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 96;
   case 9: return 96;
   case 8: return 96;
   case 7:
      if (devinfo->is_haswell) {
         return 96;
      } else {
         return 96;
      }
   case 6: return 64;
   case 5: return 64;
   case 4:
      if (devinfo->is_g4x) {
         return 64;
      } else {
         return 64;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::UAV Coherency Required */


#define GEN10_3DPRIMITIVE_UAVCoherencyRequired_bits  1
#define GEN9_3DPRIMITIVE_UAVCoherencyRequired_bits  1
#define GEN8_3DPRIMITIVE_UAVCoherencyRequired_bits  1
#define GEN75_3DPRIMITIVE_UAVCoherencyRequired_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_UAVCoherencyRequired_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DPRIMITIVE_UAVCoherencyRequired_start  9
#define GEN9_3DPRIMITIVE_UAVCoherencyRequired_start  9
#define GEN8_3DPRIMITIVE_UAVCoherencyRequired_start  9
#define GEN75_3DPRIMITIVE_UAVCoherencyRequired_start  9

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_UAVCoherencyRequired_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 9;
   case 9: return 9;
   case 8: return 9;
   case 7:
      if (devinfo->is_haswell) {
         return 9;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::Vertex Access Type */


#define GEN10_3DPRIMITIVE_VertexAccessType_bits  1
#define GEN9_3DPRIMITIVE_VertexAccessType_bits  1
#define GEN8_3DPRIMITIVE_VertexAccessType_bits  1
#define GEN75_3DPRIMITIVE_VertexAccessType_bits  1
#define GEN7_3DPRIMITIVE_VertexAccessType_bits  1
#define GEN6_3DPRIMITIVE_VertexAccessType_bits  1
#define GEN5_3DPRIMITIVE_VertexAccessType_bits  1
#define GEN45_3DPRIMITIVE_VertexAccessType_bits  1
#define GEN4_3DPRIMITIVE_VertexAccessType_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_VertexAccessType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 1;
   case 5: return 1;
   case 4:
      if (devinfo->is_g4x) {
         return 1;
      } else {
         return 1;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DPRIMITIVE_VertexAccessType_start  40
#define GEN9_3DPRIMITIVE_VertexAccessType_start  40
#define GEN8_3DPRIMITIVE_VertexAccessType_start  40
#define GEN75_3DPRIMITIVE_VertexAccessType_start  40
#define GEN7_3DPRIMITIVE_VertexAccessType_start  40
#define GEN6_3DPRIMITIVE_VertexAccessType_start  15
#define GEN5_3DPRIMITIVE_VertexAccessType_start  15
#define GEN45_3DPRIMITIVE_VertexAccessType_start  15
#define GEN4_3DPRIMITIVE_VertexAccessType_start  15

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_VertexAccessType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 40;
   case 9: return 40;
   case 8: return 40;
   case 7:
      if (devinfo->is_haswell) {
         return 40;
      } else {
         return 40;
      }
   case 6: return 15;
   case 5: return 15;
   case 4:
      if (devinfo->is_g4x) {
         return 15;
      } else {
         return 15;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::Vertex Count Per Instance */


#define GEN10_3DPRIMITIVE_VertexCountPerInstance_bits  32
#define GEN9_3DPRIMITIVE_VertexCountPerInstance_bits  32
#define GEN8_3DPRIMITIVE_VertexCountPerInstance_bits  32
#define GEN75_3DPRIMITIVE_VertexCountPerInstance_bits  32
#define GEN7_3DPRIMITIVE_VertexCountPerInstance_bits  32
#define GEN6_3DPRIMITIVE_VertexCountPerInstance_bits  32
#define GEN5_3DPRIMITIVE_VertexCountPerInstance_bits  32
#define GEN45_3DPRIMITIVE_VertexCountPerInstance_bits  32
#define GEN4_3DPRIMITIVE_VertexCountPerInstance_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_VertexCountPerInstance_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 32;
      }
   case 6: return 32;
   case 5: return 32;
   case 4:
      if (devinfo->is_g4x) {
         return 32;
      } else {
         return 32;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DPRIMITIVE_VertexCountPerInstance_start  64
#define GEN9_3DPRIMITIVE_VertexCountPerInstance_start  64
#define GEN8_3DPRIMITIVE_VertexCountPerInstance_start  64
#define GEN75_3DPRIMITIVE_VertexCountPerInstance_start  64
#define GEN7_3DPRIMITIVE_VertexCountPerInstance_start  64
#define GEN6_3DPRIMITIVE_VertexCountPerInstance_start  32
#define GEN5_3DPRIMITIVE_VertexCountPerInstance_start  32
#define GEN45_3DPRIMITIVE_VertexCountPerInstance_start  32
#define GEN4_3DPRIMITIVE_VertexCountPerInstance_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_VertexCountPerInstance_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 64;
   case 9: return 64;
   case 8: return 64;
   case 7:
      if (devinfo->is_haswell) {
         return 64;
      } else {
         return 64;
      }
   case 6: return 32;
   case 5: return 32;
   case 4:
      if (devinfo->is_g4x) {
         return 32;
      } else {
         return 32;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_AA_LINE_PARAMETERS */


#define GEN10_3DSTATE_AA_LINE_PARAMETERS_length  3
#define GEN9_3DSTATE_AA_LINE_PARAMETERS_length  3
#define GEN8_3DSTATE_AA_LINE_PARAMETERS_length  3
#define GEN75_3DSTATE_AA_LINE_PARAMETERS_length  3
#define GEN7_3DSTATE_AA_LINE_PARAMETERS_length  3
#define GEN6_3DSTATE_AA_LINE_PARAMETERS_length  3
#define GEN5_3DSTATE_AA_LINE_PARAMETERS_length  3
#define GEN45_3DSTATE_AA_LINE_PARAMETERS_length  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 3;
   case 4:
      if (devinfo->is_g4x) {
         return 3;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_AA_LINE_PARAMETERS::3D Command Opcode */


#define GEN10_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_bits  3
#define GEN7_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_bits  3
#define GEN6_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_bits  3
#define GEN5_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_bits  3
#define GEN45_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 3;
   case 4:
      if (devinfo->is_g4x) {
         return 3;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_start  24
#define GEN9_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_start  24
#define GEN8_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_start  24
#define GEN75_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_start  24
#define GEN7_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_start  24
#define GEN6_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_start  24
#define GEN5_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_start  24
#define GEN45_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 24;
      }
   case 6: return 24;
   case 5: return 24;
   case 4:
      if (devinfo->is_g4x) {
         return 24;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_AA_LINE_PARAMETERS::3D Command Sub Opcode */


#define GEN10_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_bits  8
#define GEN7_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_bits  8
#define GEN6_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_bits  8
#define GEN5_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_bits  8
#define GEN45_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 8;
   case 4:
      if (devinfo->is_g4x) {
         return 8;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_start  16
#define GEN7_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_start  16
#define GEN6_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_start  16
#define GEN5_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_start  16
#define GEN45_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 16;
   case 5: return 16;
   case 4:
      if (devinfo->is_g4x) {
         return 16;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_AA_LINE_PARAMETERS::AA Coverage Bias */


#define GEN10_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_bits  8
#define GEN9_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_bits  8
#define GEN8_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_bits  8
#define GEN75_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_bits  8
#define GEN7_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_bits  8
#define GEN6_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_bits  8
#define GEN5_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_bits  8
#define GEN45_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 8;
   case 4:
      if (devinfo->is_g4x) {
         return 8;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_start  48
#define GEN9_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_start  48
#define GEN8_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_start  48
#define GEN75_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_start  48
#define GEN7_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_start  48
#define GEN6_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_start  48
#define GEN5_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_start  48
#define GEN45_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_start  48

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 48;
   case 9: return 48;
   case 8: return 48;
   case 7:
      if (devinfo->is_haswell) {
         return 48;
      } else {
         return 48;
      }
   case 6: return 48;
   case 5: return 48;
   case 4:
      if (devinfo->is_g4x) {
         return 48;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_AA_LINE_PARAMETERS::AA Coverage EndCap Bias */


#define GEN10_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_bits  8
#define GEN9_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_bits  8
#define GEN8_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_bits  8
#define GEN75_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_bits  8
#define GEN7_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_bits  8
#define GEN6_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_bits  8
#define GEN5_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_bits  8
#define GEN45_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 8;
   case 4:
      if (devinfo->is_g4x) {
         return 8;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_start  80
#define GEN9_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_start  80
#define GEN8_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_start  80
#define GEN75_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_start  80
#define GEN7_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_start  80
#define GEN6_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_start  80
#define GEN5_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_start  80
#define GEN45_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_start  80

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 80;
   case 9: return 80;
   case 8: return 80;
   case 7:
      if (devinfo->is_haswell) {
         return 80;
      } else {
         return 80;
      }
   case 6: return 80;
   case 5: return 80;
   case 4:
      if (devinfo->is_g4x) {
         return 80;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_AA_LINE_PARAMETERS::AA Coverage EndCap Slope */


#define GEN10_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_bits  8
#define GEN9_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_bits  8
#define GEN8_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_bits  8
#define GEN75_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_bits  8
#define GEN7_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_bits  8
#define GEN6_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_bits  8
#define GEN5_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_bits  8
#define GEN45_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 8;
   case 4:
      if (devinfo->is_g4x) {
         return 8;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_start  64
#define GEN9_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_start  64
#define GEN8_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_start  64
#define GEN75_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_start  64
#define GEN7_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_start  64
#define GEN6_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_start  64
#define GEN5_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_start  64
#define GEN45_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_start  64

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 64;
   case 9: return 64;
   case 8: return 64;
   case 7:
      if (devinfo->is_haswell) {
         return 64;
      } else {
         return 64;
      }
   case 6: return 64;
   case 5: return 64;
   case 4:
      if (devinfo->is_g4x) {
         return 64;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_AA_LINE_PARAMETERS::AA Coverage Slope */


#define GEN10_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_bits  8
#define GEN9_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_bits  8
#define GEN8_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_bits  8
#define GEN75_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_bits  8
#define GEN7_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_bits  8
#define GEN6_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_bits  8
#define GEN5_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_bits  8
#define GEN45_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 8;
   case 4:
      if (devinfo->is_g4x) {
         return 8;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_start  32
#define GEN9_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_start  32
#define GEN8_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_start  32
#define GEN75_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_start  32
#define GEN7_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_start  32
#define GEN6_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_start  32
#define GEN5_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_start  32
#define GEN45_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 32;
      }
   case 6: return 32;
   case 5: return 32;
   case 4:
      if (devinfo->is_g4x) {
         return 32;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_AA_LINE_PARAMETERS::AA Point Coverage Bias */


#define GEN10_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageBias_bits  8
#define GEN9_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageBias_bits  8
#define GEN8_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageBias_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageBias_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageBias_start  56
#define GEN9_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageBias_start  56
#define GEN8_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageBias_start  56

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageBias_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 56;
   case 9: return 56;
   case 8: return 56;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_AA_LINE_PARAMETERS::AA Point Coverage EndCap Bias */


#define GEN10_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapBias_bits  8
#define GEN9_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapBias_bits  8
#define GEN8_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapBias_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapBias_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapBias_start  88
#define GEN9_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapBias_start  88
#define GEN8_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapBias_start  88

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapBias_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 88;
   case 9: return 88;
   case 8: return 88;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_AA_LINE_PARAMETERS::AA Point Coverage EndCap Slope */


#define GEN10_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapSlope_bits  8
#define GEN9_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapSlope_bits  8
#define GEN8_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapSlope_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapSlope_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapSlope_start  72
#define GEN9_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapSlope_start  72
#define GEN8_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapSlope_start  72

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapSlope_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 72;
   case 9: return 72;
   case 8: return 72;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_AA_LINE_PARAMETERS::AA Point Coverage Slope */


#define GEN10_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageSlope_bits  8
#define GEN9_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageSlope_bits  8
#define GEN8_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageSlope_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageSlope_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageSlope_start  40
#define GEN9_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageSlope_start  40
#define GEN8_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageSlope_start  40

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageSlope_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 40;
   case 9: return 40;
   case 8: return 40;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_AA_LINE_PARAMETERS::Command SubType */


#define GEN10_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_bits  2
#define GEN9_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_bits  2
#define GEN8_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_bits  2
#define GEN75_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_bits  2
#define GEN7_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_bits  2
#define GEN6_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_bits  2
#define GEN5_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_bits  2
#define GEN45_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 2;
   case 5: return 2;
   case 4:
      if (devinfo->is_g4x) {
         return 2;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_start  27
#define GEN9_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_start  27
#define GEN8_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_start  27
#define GEN75_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_start  27
#define GEN7_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_start  27
#define GEN6_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_start  27
#define GEN5_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_start  27
#define GEN45_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 27;
      }
   case 6: return 27;
   case 5: return 27;
   case 4:
      if (devinfo->is_g4x) {
         return 27;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_AA_LINE_PARAMETERS::Command Type */


#define GEN10_3DSTATE_AA_LINE_PARAMETERS_CommandType_bits  3
#define GEN9_3DSTATE_AA_LINE_PARAMETERS_CommandType_bits  3
#define GEN8_3DSTATE_AA_LINE_PARAMETERS_CommandType_bits  3
#define GEN75_3DSTATE_AA_LINE_PARAMETERS_CommandType_bits  3
#define GEN7_3DSTATE_AA_LINE_PARAMETERS_CommandType_bits  3
#define GEN6_3DSTATE_AA_LINE_PARAMETERS_CommandType_bits  3
#define GEN5_3DSTATE_AA_LINE_PARAMETERS_CommandType_bits  3
#define GEN45_3DSTATE_AA_LINE_PARAMETERS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 3;
   case 4:
      if (devinfo->is_g4x) {
         return 3;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_AA_LINE_PARAMETERS_CommandType_start  29
#define GEN9_3DSTATE_AA_LINE_PARAMETERS_CommandType_start  29
#define GEN8_3DSTATE_AA_LINE_PARAMETERS_CommandType_start  29
#define GEN75_3DSTATE_AA_LINE_PARAMETERS_CommandType_start  29
#define GEN7_3DSTATE_AA_LINE_PARAMETERS_CommandType_start  29
#define GEN6_3DSTATE_AA_LINE_PARAMETERS_CommandType_start  29
#define GEN5_3DSTATE_AA_LINE_PARAMETERS_CommandType_start  29
#define GEN45_3DSTATE_AA_LINE_PARAMETERS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 29;
      }
   case 6: return 29;
   case 5: return 29;
   case 4:
      if (devinfo->is_g4x) {
         return 29;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_AA_LINE_PARAMETERS::DWord Length */


#define GEN10_3DSTATE_AA_LINE_PARAMETERS_DWordLength_bits  8
#define GEN9_3DSTATE_AA_LINE_PARAMETERS_DWordLength_bits  8
#define GEN8_3DSTATE_AA_LINE_PARAMETERS_DWordLength_bits  8
#define GEN75_3DSTATE_AA_LINE_PARAMETERS_DWordLength_bits  8
#define GEN7_3DSTATE_AA_LINE_PARAMETERS_DWordLength_bits  8
#define GEN6_3DSTATE_AA_LINE_PARAMETERS_DWordLength_bits  8
#define GEN5_3DSTATE_AA_LINE_PARAMETERS_DWordLength_bits  8
#define GEN45_3DSTATE_AA_LINE_PARAMETERS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 8;
   case 4:
      if (devinfo->is_g4x) {
         return 8;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_AA_LINE_PARAMETERS_DWordLength_start  0
#define GEN9_3DSTATE_AA_LINE_PARAMETERS_DWordLength_start  0
#define GEN8_3DSTATE_AA_LINE_PARAMETERS_DWordLength_start  0
#define GEN75_3DSTATE_AA_LINE_PARAMETERS_DWordLength_start  0
#define GEN7_3DSTATE_AA_LINE_PARAMETERS_DWordLength_start  0
#define GEN6_3DSTATE_AA_LINE_PARAMETERS_DWordLength_start  0
#define GEN5_3DSTATE_AA_LINE_PARAMETERS_DWordLength_start  0
#define GEN45_3DSTATE_AA_LINE_PARAMETERS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_DS */





/* 3DSTATE_BINDING_TABLE_EDIT_DS::3D Command Opcode */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandOpcode_start  24
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandOpcode_start  24
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandOpcode_start  24
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_DS::3D Command Sub Opcode */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_DS::Binding Table Block Clear */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableBlockClear_bits  16
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableBlockClear_bits  16
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableBlockClear_bits  16
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableBlockClear_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableBlockClear_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableBlockClear_start  48
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableBlockClear_start  48
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableBlockClear_start  48
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableBlockClear_start  48

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableBlockClear_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 48;
   case 9: return 48;
   case 8: return 48;
   case 7:
      if (devinfo->is_haswell) {
         return 48;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_DS::Binding Table Edit Target */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableEditTarget_bits  2
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableEditTarget_bits  2
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableEditTarget_bits  2
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableEditTarget_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableEditTarget_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableEditTarget_start  32
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableEditTarget_start  32
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableEditTarget_start  32
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableEditTarget_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableEditTarget_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_DS::Command SubType */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_DS_CommandSubType_bits  2
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_DS_CommandSubType_bits  2
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_DS_CommandSubType_bits  2
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_DS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_DS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_DS_CommandSubType_start  27
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_DS_CommandSubType_start  27
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_DS_CommandSubType_start  27
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_DS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_DS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_DS::Command Type */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_DS_CommandType_bits  3
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_DS_CommandType_bits  3
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_DS_CommandType_bits  3
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_DS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_DS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_DS_CommandType_start  29
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_DS_CommandType_start  29
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_DS_CommandType_start  29
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_DS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_DS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_DS::DWord Length */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_DS_DWordLength_bits  9
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_DS_DWordLength_bits  9
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_DS_DWordLength_bits  9
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_DS_DWordLength_bits  9

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_DS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 9;
   case 9: return 9;
   case 8: return 9;
   case 7:
      if (devinfo->is_haswell) {
         return 9;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_DS_DWordLength_start  0
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_DS_DWordLength_start  0
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_DS_DWordLength_start  0
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_DS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_DS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_DS::Entry [n] */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_DS_Entryn_bits  32
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_DS_Entryn_bits  32
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_DS_Entryn_bits  32
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_DS_Entryn_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_DS_Entryn_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_DS_Entryn_start  0
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_DS_Entryn_start  0
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_DS_Entryn_start  0
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_DS_Entryn_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_DS_Entryn_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_GS */





/* 3DSTATE_BINDING_TABLE_EDIT_GS::3D Command Opcode */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandOpcode_start  24
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandOpcode_start  24
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandOpcode_start  24
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_GS::3D Command Sub Opcode */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_GS::Binding Table Block Clear */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableBlockClear_bits  16
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableBlockClear_bits  16
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableBlockClear_bits  16
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableBlockClear_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableBlockClear_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableBlockClear_start  48
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableBlockClear_start  48
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableBlockClear_start  48
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableBlockClear_start  48

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableBlockClear_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 48;
   case 9: return 48;
   case 8: return 48;
   case 7:
      if (devinfo->is_haswell) {
         return 48;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_GS::Binding Table Edit Target */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableEditTarget_bits  2
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableEditTarget_bits  2
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableEditTarget_bits  2
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableEditTarget_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableEditTarget_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableEditTarget_start  32
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableEditTarget_start  32
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableEditTarget_start  32
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableEditTarget_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableEditTarget_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_GS::Command SubType */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_GS_CommandSubType_bits  2
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_GS_CommandSubType_bits  2
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_GS_CommandSubType_bits  2
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_GS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_GS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_GS_CommandSubType_start  27
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_GS_CommandSubType_start  27
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_GS_CommandSubType_start  27
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_GS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_GS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_GS::Command Type */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_GS_CommandType_bits  3
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_GS_CommandType_bits  3
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_GS_CommandType_bits  3
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_GS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_GS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_GS_CommandType_start  29
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_GS_CommandType_start  29
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_GS_CommandType_start  29
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_GS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_GS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_GS::DWord Length */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_GS_DWordLength_bits  9
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_GS_DWordLength_bits  9
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_GS_DWordLength_bits  9
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_GS_DWordLength_bits  9

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_GS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 9;
   case 9: return 9;
   case 8: return 9;
   case 7:
      if (devinfo->is_haswell) {
         return 9;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_GS_DWordLength_start  0
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_GS_DWordLength_start  0
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_GS_DWordLength_start  0
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_GS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_GS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_GS::Entry [n] */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_GS_Entryn_bits  32
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_GS_Entryn_bits  32
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_GS_Entryn_bits  32
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_GS_Entryn_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_GS_Entryn_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_GS_Entryn_start  0
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_GS_Entryn_start  0
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_GS_Entryn_start  0
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_GS_Entryn_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_GS_Entryn_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_HS */





/* 3DSTATE_BINDING_TABLE_EDIT_HS::3D Command Opcode */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandOpcode_start  24
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandOpcode_start  24
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandOpcode_start  24
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_HS::3D Command Sub Opcode */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_HS::Binding Table Block Clear */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableBlockClear_bits  16
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableBlockClear_bits  16
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableBlockClear_bits  16
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableBlockClear_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableBlockClear_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableBlockClear_start  48
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableBlockClear_start  48
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableBlockClear_start  48
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableBlockClear_start  48

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableBlockClear_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 48;
   case 9: return 48;
   case 8: return 48;
   case 7:
      if (devinfo->is_haswell) {
         return 48;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_HS::Binding Table Edit Target */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableEditTarget_bits  2
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableEditTarget_bits  2
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableEditTarget_bits  2
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableEditTarget_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableEditTarget_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableEditTarget_start  32
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableEditTarget_start  32
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableEditTarget_start  32
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableEditTarget_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableEditTarget_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_HS::Command SubType */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_HS_CommandSubType_bits  2
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_HS_CommandSubType_bits  2
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_HS_CommandSubType_bits  2
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_HS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_HS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_HS_CommandSubType_start  27
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_HS_CommandSubType_start  27
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_HS_CommandSubType_start  27
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_HS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_HS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_HS::Command Type */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_HS_CommandType_bits  3
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_HS_CommandType_bits  3
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_HS_CommandType_bits  3
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_HS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_HS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_HS_CommandType_start  29
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_HS_CommandType_start  29
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_HS_CommandType_start  29
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_HS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_HS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_HS::DWord Length */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_HS_DWordLength_bits  9
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_HS_DWordLength_bits  9
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_HS_DWordLength_bits  9
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_HS_DWordLength_bits  9

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_HS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 9;
   case 9: return 9;
   case 8: return 9;
   case 7:
      if (devinfo->is_haswell) {
         return 9;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_HS_DWordLength_start  0
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_HS_DWordLength_start  0
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_HS_DWordLength_start  0
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_HS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_HS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_HS::Entry [n] */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_HS_Entryn_bits  32
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_HS_Entryn_bits  32
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_HS_Entryn_bits  32
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_HS_Entryn_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_HS_Entryn_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_HS_Entryn_start  0
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_HS_Entryn_start  0
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_HS_Entryn_start  0
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_HS_Entryn_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_HS_Entryn_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_PS */





/* 3DSTATE_BINDING_TABLE_EDIT_PS::3D Command Opcode */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandOpcode_start  24
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandOpcode_start  24
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandOpcode_start  24
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_PS::3D Command Sub Opcode */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_PS::Binding Table Block Clear */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableBlockClear_bits  16
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableBlockClear_bits  16
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableBlockClear_bits  16
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableBlockClear_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableBlockClear_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableBlockClear_start  48
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableBlockClear_start  48
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableBlockClear_start  48
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableBlockClear_start  48

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableBlockClear_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 48;
   case 9: return 48;
   case 8: return 48;
   case 7:
      if (devinfo->is_haswell) {
         return 48;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_PS::Binding Table Edit Target */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableEditTarget_bits  2
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableEditTarget_bits  2
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableEditTarget_bits  2
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableEditTarget_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableEditTarget_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableEditTarget_start  32
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableEditTarget_start  32
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableEditTarget_start  32
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableEditTarget_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableEditTarget_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_PS::Command SubType */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_PS_CommandSubType_bits  2
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_PS_CommandSubType_bits  2
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_PS_CommandSubType_bits  2
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_PS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_PS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_PS_CommandSubType_start  27
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_PS_CommandSubType_start  27
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_PS_CommandSubType_start  27
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_PS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_PS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_PS::Command Type */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_PS_CommandType_bits  3
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_PS_CommandType_bits  3
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_PS_CommandType_bits  3
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_PS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_PS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_PS_CommandType_start  29
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_PS_CommandType_start  29
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_PS_CommandType_start  29
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_PS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_PS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_PS::DWord Length */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_PS_DWordLength_bits  9
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_PS_DWordLength_bits  9
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_PS_DWordLength_bits  9
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_PS_DWordLength_bits  9

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_PS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 9;
   case 9: return 9;
   case 8: return 9;
   case 7:
      if (devinfo->is_haswell) {
         return 9;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_PS_DWordLength_start  0
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_PS_DWordLength_start  0
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_PS_DWordLength_start  0
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_PS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_PS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_PS::Entry [n] */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_PS_Entryn_bits  32
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_PS_Entryn_bits  32
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_PS_Entryn_bits  32
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_PS_Entryn_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_PS_Entryn_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_PS_Entryn_start  0
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_PS_Entryn_start  0
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_PS_Entryn_start  0
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_PS_Entryn_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_PS_Entryn_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_VS */





/* 3DSTATE_BINDING_TABLE_EDIT_VS::3D Command Opcode */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandOpcode_start  24
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandOpcode_start  24
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandOpcode_start  24
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_VS::3D Command Sub Opcode */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_VS::Binding Table Block Clear */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableBlockClear_bits  16
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableBlockClear_bits  16
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableBlockClear_bits  16
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableBlockClear_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableBlockClear_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableBlockClear_start  48
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableBlockClear_start  48
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableBlockClear_start  48
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableBlockClear_start  48

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableBlockClear_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 48;
   case 9: return 48;
   case 8: return 48;
   case 7:
      if (devinfo->is_haswell) {
         return 48;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_VS::Binding Table Edit Target */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableEditTarget_bits  2
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableEditTarget_bits  2
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableEditTarget_bits  2
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableEditTarget_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableEditTarget_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableEditTarget_start  32
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableEditTarget_start  32
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableEditTarget_start  32
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableEditTarget_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableEditTarget_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_VS::Command SubType */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_VS_CommandSubType_bits  2
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_VS_CommandSubType_bits  2
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_VS_CommandSubType_bits  2
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_VS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_VS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_VS_CommandSubType_start  27
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_VS_CommandSubType_start  27
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_VS_CommandSubType_start  27
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_VS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_VS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_VS::Command Type */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_VS_CommandType_bits  3
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_VS_CommandType_bits  3
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_VS_CommandType_bits  3
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_VS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_VS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_VS_CommandType_start  29
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_VS_CommandType_start  29
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_VS_CommandType_start  29
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_VS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_VS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_VS::DWord Length */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_VS_DWordLength_bits  9
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_VS_DWordLength_bits  9
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_VS_DWordLength_bits  9
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_VS_DWordLength_bits  9

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_VS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 9;
   case 9: return 9;
   case 8: return 9;
   case 7:
      if (devinfo->is_haswell) {
         return 9;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_VS_DWordLength_start  0
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_VS_DWordLength_start  0
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_VS_DWordLength_start  0
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_VS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_VS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_VS::Entry [n] */


#define GEN10_3DSTATE_BINDING_TABLE_EDIT_VS_Entryn_bits  32
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_VS_Entryn_bits  32
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_VS_Entryn_bits  32
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_VS_Entryn_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_VS_Entryn_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_EDIT_VS_Entryn_start  0
#define GEN9_3DSTATE_BINDING_TABLE_EDIT_VS_Entryn_start  0
#define GEN8_3DSTATE_BINDING_TABLE_EDIT_VS_Entryn_start  0
#define GEN75_3DSTATE_BINDING_TABLE_EDIT_VS_Entryn_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_VS_Entryn_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS */


#define GEN6_3DSTATE_BINDING_TABLE_POINTERS_length  4
#define GEN5_3DSTATE_BINDING_TABLE_POINTERS_length  6
#define GEN45_3DSTATE_BINDING_TABLE_POINTERS_length  6
#define GEN4_3DSTATE_BINDING_TABLE_POINTERS_length  6

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 4;
   case 5: return 6;
   case 4:
      if (devinfo->is_g4x) {
         return 6;
      } else {
         return 6;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS::3D Command Opcode */


#define GEN6_3DSTATE_BINDING_TABLE_POINTERS_3DCommandOpcode_bits  3
#define GEN5_3DSTATE_BINDING_TABLE_POINTERS_3DCommandOpcode_bits  3
#define GEN45_3DSTATE_BINDING_TABLE_POINTERS_3DCommandOpcode_bits  3
#define GEN4_3DSTATE_BINDING_TABLE_POINTERS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 3;
   case 5: return 3;
   case 4:
      if (devinfo->is_g4x) {
         return 3;
      } else {
         return 3;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_BINDING_TABLE_POINTERS_3DCommandOpcode_start  24
#define GEN5_3DSTATE_BINDING_TABLE_POINTERS_3DCommandOpcode_start  24
#define GEN45_3DSTATE_BINDING_TABLE_POINTERS_3DCommandOpcode_start  24
#define GEN4_3DSTATE_BINDING_TABLE_POINTERS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 24;
   case 5: return 24;
   case 4:
      if (devinfo->is_g4x) {
         return 24;
      } else {
         return 24;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS::3D Command Sub Opcode */


#define GEN6_3DSTATE_BINDING_TABLE_POINTERS_3DCommandSubOpcode_bits  8
#define GEN5_3DSTATE_BINDING_TABLE_POINTERS_3DCommandSubOpcode_bits  8
#define GEN45_3DSTATE_BINDING_TABLE_POINTERS_3DCommandSubOpcode_bits  8
#define GEN4_3DSTATE_BINDING_TABLE_POINTERS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 8;
   case 5: return 8;
   case 4:
      if (devinfo->is_g4x) {
         return 8;
      } else {
         return 8;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_BINDING_TABLE_POINTERS_3DCommandSubOpcode_start  16
#define GEN5_3DSTATE_BINDING_TABLE_POINTERS_3DCommandSubOpcode_start  16
#define GEN45_3DSTATE_BINDING_TABLE_POINTERS_3DCommandSubOpcode_start  16
#define GEN4_3DSTATE_BINDING_TABLE_POINTERS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 16;
   case 5: return 16;
   case 4:
      if (devinfo->is_g4x) {
         return 16;
      } else {
         return 16;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS::Command SubType */


#define GEN6_3DSTATE_BINDING_TABLE_POINTERS_CommandSubType_bits  2
#define GEN5_3DSTATE_BINDING_TABLE_POINTERS_CommandSubType_bits  2
#define GEN45_3DSTATE_BINDING_TABLE_POINTERS_CommandSubType_bits  2
#define GEN4_3DSTATE_BINDING_TABLE_POINTERS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 2;
   case 5: return 2;
   case 4:
      if (devinfo->is_g4x) {
         return 2;
      } else {
         return 2;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_BINDING_TABLE_POINTERS_CommandSubType_start  27
#define GEN5_3DSTATE_BINDING_TABLE_POINTERS_CommandSubType_start  27
#define GEN45_3DSTATE_BINDING_TABLE_POINTERS_CommandSubType_start  27
#define GEN4_3DSTATE_BINDING_TABLE_POINTERS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 27;
   case 5: return 27;
   case 4:
      if (devinfo->is_g4x) {
         return 27;
      } else {
         return 27;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS::Command Type */


#define GEN6_3DSTATE_BINDING_TABLE_POINTERS_CommandType_bits  3
#define GEN5_3DSTATE_BINDING_TABLE_POINTERS_CommandType_bits  3
#define GEN45_3DSTATE_BINDING_TABLE_POINTERS_CommandType_bits  3
#define GEN4_3DSTATE_BINDING_TABLE_POINTERS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 3;
   case 5: return 3;
   case 4:
      if (devinfo->is_g4x) {
         return 3;
      } else {
         return 3;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_BINDING_TABLE_POINTERS_CommandType_start  29
#define GEN5_3DSTATE_BINDING_TABLE_POINTERS_CommandType_start  29
#define GEN45_3DSTATE_BINDING_TABLE_POINTERS_CommandType_start  29
#define GEN4_3DSTATE_BINDING_TABLE_POINTERS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 29;
   case 5: return 29;
   case 4:
      if (devinfo->is_g4x) {
         return 29;
      } else {
         return 29;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS::DWord Length */


#define GEN6_3DSTATE_BINDING_TABLE_POINTERS_DWordLength_bits  8
#define GEN5_3DSTATE_BINDING_TABLE_POINTERS_DWordLength_bits  8
#define GEN45_3DSTATE_BINDING_TABLE_POINTERS_DWordLength_bits  8
#define GEN4_3DSTATE_BINDING_TABLE_POINTERS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 8;
   case 5: return 8;
   case 4:
      if (devinfo->is_g4x) {
         return 8;
      } else {
         return 8;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_BINDING_TABLE_POINTERS_DWordLength_start  0
#define GEN5_3DSTATE_BINDING_TABLE_POINTERS_DWordLength_start  0
#define GEN45_3DSTATE_BINDING_TABLE_POINTERS_DWordLength_start  0
#define GEN4_3DSTATE_BINDING_TABLE_POINTERS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS::GS Binding Table Change */


#define GEN6_3DSTATE_BINDING_TABLE_POINTERS_GSBindingTableChange_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_GSBindingTableChange_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_BINDING_TABLE_POINTERS_GSBindingTableChange_start  9

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_GSBindingTableChange_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 9;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS::PS Binding Table Change */


#define GEN6_3DSTATE_BINDING_TABLE_POINTERS_PSBindingTableChange_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PSBindingTableChange_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_BINDING_TABLE_POINTERS_PSBindingTableChange_start  12

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PSBindingTableChange_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 12;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS::Pointer to CLIP Binding Table */


#define GEN5_3DSTATE_BINDING_TABLE_POINTERS_PointertoCLIPBindingTable_bits  27
#define GEN45_3DSTATE_BINDING_TABLE_POINTERS_PointertoCLIPBindingTable_bits  27
#define GEN4_3DSTATE_BINDING_TABLE_POINTERS_PointertoCLIPBindingTable_bits  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PointertoCLIPBindingTable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 27;
   case 4:
      if (devinfo->is_g4x) {
         return 27;
      } else {
         return 27;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN5_3DSTATE_BINDING_TABLE_POINTERS_PointertoCLIPBindingTable_start  101
#define GEN45_3DSTATE_BINDING_TABLE_POINTERS_PointertoCLIPBindingTable_start  101
#define GEN4_3DSTATE_BINDING_TABLE_POINTERS_PointertoCLIPBindingTable_start  101

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PointertoCLIPBindingTable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 101;
   case 4:
      if (devinfo->is_g4x) {
         return 101;
      } else {
         return 101;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS::Pointer to GS Binding Table */


#define GEN6_3DSTATE_BINDING_TABLE_POINTERS_PointertoGSBindingTable_bits  27
#define GEN5_3DSTATE_BINDING_TABLE_POINTERS_PointertoGSBindingTable_bits  27
#define GEN45_3DSTATE_BINDING_TABLE_POINTERS_PointertoGSBindingTable_bits  27
#define GEN4_3DSTATE_BINDING_TABLE_POINTERS_PointertoGSBindingTable_bits  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PointertoGSBindingTable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 27;
   case 5: return 27;
   case 4:
      if (devinfo->is_g4x) {
         return 27;
      } else {
         return 27;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_BINDING_TABLE_POINTERS_PointertoGSBindingTable_start  69
#define GEN5_3DSTATE_BINDING_TABLE_POINTERS_PointertoGSBindingTable_start  69
#define GEN45_3DSTATE_BINDING_TABLE_POINTERS_PointertoGSBindingTable_start  69
#define GEN4_3DSTATE_BINDING_TABLE_POINTERS_PointertoGSBindingTable_start  69

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PointertoGSBindingTable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 69;
   case 5: return 69;
   case 4:
      if (devinfo->is_g4x) {
         return 69;
      } else {
         return 69;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS::Pointer to PS Binding Table */


#define GEN6_3DSTATE_BINDING_TABLE_POINTERS_PointertoPSBindingTable_bits  27
#define GEN5_3DSTATE_BINDING_TABLE_POINTERS_PointertoPSBindingTable_bits  27
#define GEN45_3DSTATE_BINDING_TABLE_POINTERS_PointertoPSBindingTable_bits  27
#define GEN4_3DSTATE_BINDING_TABLE_POINTERS_PointertoPSBindingTable_bits  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PointertoPSBindingTable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 27;
   case 5: return 27;
   case 4:
      if (devinfo->is_g4x) {
         return 27;
      } else {
         return 27;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_BINDING_TABLE_POINTERS_PointertoPSBindingTable_start  101
#define GEN5_3DSTATE_BINDING_TABLE_POINTERS_PointertoPSBindingTable_start  165
#define GEN45_3DSTATE_BINDING_TABLE_POINTERS_PointertoPSBindingTable_start  165
#define GEN4_3DSTATE_BINDING_TABLE_POINTERS_PointertoPSBindingTable_start  165

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PointertoPSBindingTable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 101;
   case 5: return 165;
   case 4:
      if (devinfo->is_g4x) {
         return 165;
      } else {
         return 165;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS::Pointer to SF Binding Table */


#define GEN5_3DSTATE_BINDING_TABLE_POINTERS_PointertoSFBindingTable_bits  27
#define GEN45_3DSTATE_BINDING_TABLE_POINTERS_PointertoSFBindingTable_bits  27
#define GEN4_3DSTATE_BINDING_TABLE_POINTERS_PointertoSFBindingTable_bits  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PointertoSFBindingTable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 27;
   case 4:
      if (devinfo->is_g4x) {
         return 27;
      } else {
         return 27;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN5_3DSTATE_BINDING_TABLE_POINTERS_PointertoSFBindingTable_start  133
#define GEN45_3DSTATE_BINDING_TABLE_POINTERS_PointertoSFBindingTable_start  133
#define GEN4_3DSTATE_BINDING_TABLE_POINTERS_PointertoSFBindingTable_start  133

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PointertoSFBindingTable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 133;
   case 4:
      if (devinfo->is_g4x) {
         return 133;
      } else {
         return 133;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS::Pointer to VS Binding Table */


#define GEN6_3DSTATE_BINDING_TABLE_POINTERS_PointertoVSBindingTable_bits  27
#define GEN5_3DSTATE_BINDING_TABLE_POINTERS_PointertoVSBindingTable_bits  27
#define GEN45_3DSTATE_BINDING_TABLE_POINTERS_PointertoVSBindingTable_bits  27
#define GEN4_3DSTATE_BINDING_TABLE_POINTERS_PointertoVSBindingTable_bits  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PointertoVSBindingTable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 27;
   case 5: return 27;
   case 4:
      if (devinfo->is_g4x) {
         return 27;
      } else {
         return 27;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_BINDING_TABLE_POINTERS_PointertoVSBindingTable_start  37
#define GEN5_3DSTATE_BINDING_TABLE_POINTERS_PointertoVSBindingTable_start  37
#define GEN45_3DSTATE_BINDING_TABLE_POINTERS_PointertoVSBindingTable_start  37
#define GEN4_3DSTATE_BINDING_TABLE_POINTERS_PointertoVSBindingTable_start  37

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PointertoVSBindingTable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 37;
   case 5: return 37;
   case 4:
      if (devinfo->is_g4x) {
         return 37;
      } else {
         return 37;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS::VS Binding Table Change */


#define GEN6_3DSTATE_BINDING_TABLE_POINTERS_VSBindingTableChange_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_VSBindingTableChange_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_BINDING_TABLE_POINTERS_VSBindingTableChange_start  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_VSBindingTableChange_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 8;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_DS */


#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_DS_length  2
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_DS_length  2
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_DS_length  2
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_DS_length  2
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_DS_length  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_DS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_DS::3D Command Opcode */


#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandOpcode_bits  3
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandOpcode_start  24
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandOpcode_start  24
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandOpcode_start  24
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandOpcode_start  24
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 24;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_DS::3D Command Sub Opcode */


#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandSubOpcode_bits  8
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandSubOpcode_start  16
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_DS::Command SubType */


#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandSubType_bits  2
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandSubType_bits  2
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandSubType_bits  2
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandSubType_bits  2
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandSubType_start  27
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandSubType_start  27
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandSubType_start  27
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandSubType_start  27
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 27;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_DS::Command Type */


#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandType_bits  3
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandType_bits  3
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandType_bits  3
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandType_bits  3
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandType_start  29
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandType_start  29
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandType_start  29
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandType_start  29
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 29;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_DS::DWord Length */


#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_DS_DWordLength_bits  8
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_DS_DWordLength_bits  8
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_DS_DWordLength_bits  8
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_DS_DWordLength_bits  8
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_DS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_DS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_DS_DWordLength_start  0
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_DS_DWordLength_start  0
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_DS_DWordLength_start  0
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_DS_DWordLength_start  0
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_DS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_DS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_DS::Pointer to DS Binding Table */


#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_DS_PointertoDSBindingTable_bits  11
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_DS_PointertoDSBindingTable_bits  11
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_DS_PointertoDSBindingTable_bits  11
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_DS_PointertoDSBindingTable_bits  11
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_DS_PointertoDSBindingTable_bits  11

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_DS_PointertoDSBindingTable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 11;
   case 9: return 11;
   case 8: return 11;
   case 7:
      if (devinfo->is_haswell) {
         return 11;
      } else {
         return 11;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_DS_PointertoDSBindingTable_start  37
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_DS_PointertoDSBindingTable_start  37
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_DS_PointertoDSBindingTable_start  37
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_DS_PointertoDSBindingTable_start  37
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_DS_PointertoDSBindingTable_start  37

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_DS_PointertoDSBindingTable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 37;
   case 9: return 37;
   case 8: return 37;
   case 7:
      if (devinfo->is_haswell) {
         return 37;
      } else {
         return 37;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_GS */


#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_GS_length  2
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_GS_length  2
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_GS_length  2
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_GS_length  2
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_GS_length  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_GS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_GS::3D Command Opcode */


#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandOpcode_bits  3
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandOpcode_start  24
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandOpcode_start  24
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandOpcode_start  24
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandOpcode_start  24
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 24;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_GS::3D Command Sub Opcode */


#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandSubOpcode_bits  8
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandSubOpcode_start  16
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_GS::Command SubType */


#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandSubType_bits  2
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandSubType_bits  2
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandSubType_bits  2
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandSubType_bits  2
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandSubType_start  27
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandSubType_start  27
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandSubType_start  27
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandSubType_start  27
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 27;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_GS::Command Type */


#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandType_bits  3
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandType_bits  3
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandType_bits  3
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandType_bits  3
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandType_start  29
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandType_start  29
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandType_start  29
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandType_start  29
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 29;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_GS::DWord Length */


#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_GS_DWordLength_bits  8
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_GS_DWordLength_bits  8
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_GS_DWordLength_bits  8
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_GS_DWordLength_bits  8
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_GS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_GS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_GS_DWordLength_start  0
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_GS_DWordLength_start  0
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_GS_DWordLength_start  0
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_GS_DWordLength_start  0
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_GS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_GS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_GS::Pointer to GS Binding Table */


#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_GS_PointertoGSBindingTable_bits  11
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_GS_PointertoGSBindingTable_bits  11
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_GS_PointertoGSBindingTable_bits  11
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_GS_PointertoGSBindingTable_bits  11
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_GS_PointertoGSBindingTable_bits  11

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_GS_PointertoGSBindingTable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 11;
   case 9: return 11;
   case 8: return 11;
   case 7:
      if (devinfo->is_haswell) {
         return 11;
      } else {
         return 11;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_GS_PointertoGSBindingTable_start  37
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_GS_PointertoGSBindingTable_start  37
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_GS_PointertoGSBindingTable_start  37
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_GS_PointertoGSBindingTable_start  37
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_GS_PointertoGSBindingTable_start  37

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_GS_PointertoGSBindingTable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 37;
   case 9: return 37;
   case 8: return 37;
   case 7:
      if (devinfo->is_haswell) {
         return 37;
      } else {
         return 37;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_HS */


#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_HS_length  2
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_HS_length  2
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_HS_length  2
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_HS_length  2
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_HS_length  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_HS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_HS::3D Command Opcode */


#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandOpcode_bits  3
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandOpcode_start  24
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandOpcode_start  24
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandOpcode_start  24
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandOpcode_start  24
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 24;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_HS::3D Command Sub Opcode */


#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandSubOpcode_bits  8
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandSubOpcode_start  16
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_HS::Command SubType */


#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandSubType_bits  2
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandSubType_bits  2
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandSubType_bits  2
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandSubType_bits  2
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandSubType_start  27
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandSubType_start  27
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandSubType_start  27
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandSubType_start  27
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 27;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_HS::Command Type */


#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandType_bits  3
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandType_bits  3
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandType_bits  3
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandType_bits  3
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandType_start  29
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandType_start  29
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandType_start  29
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandType_start  29
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 29;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_HS::DWord Length */


#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_HS_DWordLength_bits  8
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_HS_DWordLength_bits  8
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_HS_DWordLength_bits  8
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_HS_DWordLength_bits  8
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_HS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_HS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_HS_DWordLength_start  0
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_HS_DWordLength_start  0
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_HS_DWordLength_start  0
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_HS_DWordLength_start  0
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_HS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_HS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_HS::Pointer to HS Binding Table */


#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_HS_PointertoHSBindingTable_bits  11
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_HS_PointertoHSBindingTable_bits  11
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_HS_PointertoHSBindingTable_bits  11
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_HS_PointertoHSBindingTable_bits  11
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_HS_PointertoHSBindingTable_bits  11

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_HS_PointertoHSBindingTable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 11;
   case 9: return 11;
   case 8: return 11;
   case 7:
      if (devinfo->is_haswell) {
         return 11;
      } else {
         return 11;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_HS_PointertoHSBindingTable_start  37
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_HS_PointertoHSBindingTable_start  37
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_HS_PointertoHSBindingTable_start  37
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_HS_PointertoHSBindingTable_start  37
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_HS_PointertoHSBindingTable_start  37

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_HS_PointertoHSBindingTable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 37;
   case 9: return 37;
   case 8: return 37;
   case 7:
      if (devinfo->is_haswell) {
         return 37;
      } else {
         return 37;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_PS */


#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_PS_length  2
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_PS_length  2
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_PS_length  2
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_PS_length  2
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_PS_length  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_PS::3D Command Opcode */


#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandOpcode_bits  3
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandOpcode_start  24
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandOpcode_start  24
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandOpcode_start  24
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandOpcode_start  24
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 24;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_PS::3D Command Sub Opcode */


#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandSubOpcode_bits  8
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandSubOpcode_start  16
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_PS::Command SubType */


#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandSubType_bits  2
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandSubType_bits  2
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandSubType_bits  2
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandSubType_bits  2
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandSubType_start  27
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandSubType_start  27
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandSubType_start  27
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandSubType_start  27
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 27;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_PS::Command Type */


#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandType_bits  3
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandType_bits  3
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandType_bits  3
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandType_bits  3
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandType_start  29
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandType_start  29
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandType_start  29
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandType_start  29
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 29;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_PS::DWord Length */


#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_PS_DWordLength_bits  8
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_PS_DWordLength_bits  8
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_PS_DWordLength_bits  8
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_PS_DWordLength_bits  8
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_PS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_PS_DWordLength_start  0
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_PS_DWordLength_start  0
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_PS_DWordLength_start  0
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_PS_DWordLength_start  0
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_PS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_PS::Pointer to PS Binding Table */


#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_PS_PointertoPSBindingTable_bits  11
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_PS_PointertoPSBindingTable_bits  11
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_PS_PointertoPSBindingTable_bits  11
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_PS_PointertoPSBindingTable_bits  11
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_PS_PointertoPSBindingTable_bits  11

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PS_PointertoPSBindingTable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 11;
   case 9: return 11;
   case 8: return 11;
   case 7:
      if (devinfo->is_haswell) {
         return 11;
      } else {
         return 11;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_PS_PointertoPSBindingTable_start  37
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_PS_PointertoPSBindingTable_start  37
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_PS_PointertoPSBindingTable_start  37
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_PS_PointertoPSBindingTable_start  37
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_PS_PointertoPSBindingTable_start  37

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PS_PointertoPSBindingTable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 37;
   case 9: return 37;
   case 8: return 37;
   case 7:
      if (devinfo->is_haswell) {
         return 37;
      } else {
         return 37;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_VS */


#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_VS_length  2
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_VS_length  2
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_VS_length  2
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_VS_length  2
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_VS_length  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_VS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_VS::3D Command Opcode */


#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandOpcode_bits  3
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandOpcode_start  24
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandOpcode_start  24
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandOpcode_start  24
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandOpcode_start  24
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 24;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_VS::3D Command Sub Opcode */


#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandSubOpcode_bits  8
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandSubOpcode_start  16
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_VS::Command SubType */


#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandSubType_bits  2
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandSubType_bits  2
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandSubType_bits  2
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandSubType_bits  2
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandSubType_start  27
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandSubType_start  27
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandSubType_start  27
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandSubType_start  27
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 27;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_VS::Command Type */


#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandType_bits  3
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandType_bits  3
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandType_bits  3
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandType_bits  3
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandType_start  29
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandType_start  29
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandType_start  29
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandType_start  29
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 29;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_VS::DWord Length */


#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_VS_DWordLength_bits  8
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_VS_DWordLength_bits  8
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_VS_DWordLength_bits  8
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_VS_DWordLength_bits  8
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_VS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_VS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_VS_DWordLength_start  0
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_VS_DWordLength_start  0
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_VS_DWordLength_start  0
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_VS_DWordLength_start  0
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_VS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_VS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_VS::Pointer to VS Binding Table */


#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_VS_PointertoVSBindingTable_bits  11
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_VS_PointertoVSBindingTable_bits  11
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_VS_PointertoVSBindingTable_bits  11
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_VS_PointertoVSBindingTable_bits  11
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_VS_PointertoVSBindingTable_bits  11

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_VS_PointertoVSBindingTable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 11;
   case 9: return 11;
   case 8: return 11;
   case 7:
      if (devinfo->is_haswell) {
         return 11;
      } else {
         return 11;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POINTERS_VS_PointertoVSBindingTable_start  37
#define GEN9_3DSTATE_BINDING_TABLE_POINTERS_VS_PointertoVSBindingTable_start  37
#define GEN8_3DSTATE_BINDING_TABLE_POINTERS_VS_PointertoVSBindingTable_start  37
#define GEN75_3DSTATE_BINDING_TABLE_POINTERS_VS_PointertoVSBindingTable_start  37
#define GEN7_3DSTATE_BINDING_TABLE_POINTERS_VS_PointertoVSBindingTable_start  37

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_VS_PointertoVSBindingTable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 37;
   case 9: return 37;
   case 8: return 37;
   case 7:
      if (devinfo->is_haswell) {
         return 37;
      } else {
         return 37;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POOL_ALLOC */


#define GEN10_3DSTATE_BINDING_TABLE_POOL_ALLOC_length  4
#define GEN9_3DSTATE_BINDING_TABLE_POOL_ALLOC_length  4
#define GEN8_3DSTATE_BINDING_TABLE_POOL_ALLOC_length  4
#define GEN75_3DSTATE_BINDING_TABLE_POOL_ALLOC_length  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 4;
   case 9: return 4;
   case 8: return 4;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POOL_ALLOC::3D Command Opcode */


#define GEN10_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandOpcode_start  24
#define GEN9_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandOpcode_start  24
#define GEN8_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandOpcode_start  24
#define GEN75_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POOL_ALLOC::3D Command Sub Opcode */


#define GEN10_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POOL_ALLOC::Binding Table Pool Base Address */


#define GEN10_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBaseAddress_bits  52
#define GEN9_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBaseAddress_bits  52
#define GEN8_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBaseAddress_bits  52
#define GEN75_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBaseAddress_bits  20

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBaseAddress_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 52;
   case 9: return 52;
   case 8: return 52;
   case 7:
      if (devinfo->is_haswell) {
         return 20;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBaseAddress_start  44
#define GEN9_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBaseAddress_start  44
#define GEN8_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBaseAddress_start  44
#define GEN75_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBaseAddress_start  44

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBaseAddress_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 44;
   case 9: return 44;
   case 8: return 44;
   case 7:
      if (devinfo->is_haswell) {
         return 44;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POOL_ALLOC::Binding Table Pool Buffer Size */


#define GEN10_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBufferSize_bits  20
#define GEN9_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBufferSize_bits  20
#define GEN8_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBufferSize_bits  20

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBufferSize_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 20;
   case 9: return 20;
   case 8: return 20;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBufferSize_start  108
#define GEN9_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBufferSize_start  108
#define GEN8_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBufferSize_start  108

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBufferSize_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 108;
   case 9: return 108;
   case 8: return 108;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POOL_ALLOC::Binding Table Pool Enable */


#define GEN10_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolEnable_bits  1
#define GEN9_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolEnable_bits  1
#define GEN8_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolEnable_bits  1
#define GEN75_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolEnable_start  43
#define GEN9_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolEnable_start  43
#define GEN8_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolEnable_start  43
#define GEN75_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolEnable_start  43

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 43;
   case 9: return 43;
   case 8: return 43;
   case 7:
      if (devinfo->is_haswell) {
         return 43;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POOL_ALLOC::Binding Table Pool Upper Bound */


#define GEN75_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolUpperBound_bits  20

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolUpperBound_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 20;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN75_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolUpperBound_start  76

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolUpperBound_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 76;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POOL_ALLOC::Command SubType */


#define GEN10_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandSubType_bits  2
#define GEN9_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandSubType_bits  2
#define GEN8_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandSubType_bits  2
#define GEN75_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandSubType_start  27
#define GEN9_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandSubType_start  27
#define GEN8_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandSubType_start  27
#define GEN75_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POOL_ALLOC::Command Type */


#define GEN10_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandType_bits  3
#define GEN9_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandType_bits  3
#define GEN8_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandType_bits  3
#define GEN75_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandType_start  29
#define GEN9_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandType_start  29
#define GEN8_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandType_start  29
#define GEN75_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POOL_ALLOC::DWord Length */


#define GEN10_3DSTATE_BINDING_TABLE_POOL_ALLOC_DWordLength_bits  8
#define GEN9_3DSTATE_BINDING_TABLE_POOL_ALLOC_DWordLength_bits  8
#define GEN8_3DSTATE_BINDING_TABLE_POOL_ALLOC_DWordLength_bits  8
#define GEN75_3DSTATE_BINDING_TABLE_POOL_ALLOC_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POOL_ALLOC_DWordLength_start  0
#define GEN9_3DSTATE_BINDING_TABLE_POOL_ALLOC_DWordLength_start  0
#define GEN8_3DSTATE_BINDING_TABLE_POOL_ALLOC_DWordLength_start  0
#define GEN75_3DSTATE_BINDING_TABLE_POOL_ALLOC_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POOL_ALLOC::Surface Object Control State */


#define GEN10_3DSTATE_BINDING_TABLE_POOL_ALLOC_SurfaceObjectControlState_bits  7
#define GEN9_3DSTATE_BINDING_TABLE_POOL_ALLOC_SurfaceObjectControlState_bits  7
#define GEN8_3DSTATE_BINDING_TABLE_POOL_ALLOC_SurfaceObjectControlState_bits  7
#define GEN75_3DSTATE_BINDING_TABLE_POOL_ALLOC_SurfaceObjectControlState_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_SurfaceObjectControlState_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 7;
   case 9: return 7;
   case 8: return 7;
   case 7:
      if (devinfo->is_haswell) {
         return 4;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BINDING_TABLE_POOL_ALLOC_SurfaceObjectControlState_start  32
#define GEN9_3DSTATE_BINDING_TABLE_POOL_ALLOC_SurfaceObjectControlState_start  32
#define GEN8_3DSTATE_BINDING_TABLE_POOL_ALLOC_SurfaceObjectControlState_start  32
#define GEN75_3DSTATE_BINDING_TABLE_POOL_ALLOC_SurfaceObjectControlState_start  39

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_SurfaceObjectControlState_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 39;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BLEND_STATE_POINTERS */


#define GEN10_3DSTATE_BLEND_STATE_POINTERS_length  2
#define GEN9_3DSTATE_BLEND_STATE_POINTERS_length  2
#define GEN8_3DSTATE_BLEND_STATE_POINTERS_length  2
#define GEN75_3DSTATE_BLEND_STATE_POINTERS_length  2
#define GEN7_3DSTATE_BLEND_STATE_POINTERS_length  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BLEND_STATE_POINTERS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BLEND_STATE_POINTERS::3D Command Opcode */


#define GEN10_3DSTATE_BLEND_STATE_POINTERS_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_BLEND_STATE_POINTERS_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_BLEND_STATE_POINTERS_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_BLEND_STATE_POINTERS_3DCommandOpcode_bits  3
#define GEN7_3DSTATE_BLEND_STATE_POINTERS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BLEND_STATE_POINTERS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BLEND_STATE_POINTERS_3DCommandOpcode_start  24
#define GEN9_3DSTATE_BLEND_STATE_POINTERS_3DCommandOpcode_start  24
#define GEN8_3DSTATE_BLEND_STATE_POINTERS_3DCommandOpcode_start  24
#define GEN75_3DSTATE_BLEND_STATE_POINTERS_3DCommandOpcode_start  24
#define GEN7_3DSTATE_BLEND_STATE_POINTERS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BLEND_STATE_POINTERS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 24;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BLEND_STATE_POINTERS::3D Command Sub Opcode */


#define GEN10_3DSTATE_BLEND_STATE_POINTERS_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_BLEND_STATE_POINTERS_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_BLEND_STATE_POINTERS_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_BLEND_STATE_POINTERS_3DCommandSubOpcode_bits  8
#define GEN7_3DSTATE_BLEND_STATE_POINTERS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BLEND_STATE_POINTERS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BLEND_STATE_POINTERS_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_BLEND_STATE_POINTERS_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_BLEND_STATE_POINTERS_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_BLEND_STATE_POINTERS_3DCommandSubOpcode_start  16
#define GEN7_3DSTATE_BLEND_STATE_POINTERS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BLEND_STATE_POINTERS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BLEND_STATE_POINTERS::Blend State Pointer */


#define GEN10_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointer_bits  26
#define GEN9_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointer_bits  26
#define GEN8_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointer_bits  26
#define GEN75_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointer_bits  26
#define GEN7_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointer_bits  26

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointer_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 26;
   case 9: return 26;
   case 8: return 26;
   case 7:
      if (devinfo->is_haswell) {
         return 26;
      } else {
         return 26;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointer_start  38
#define GEN9_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointer_start  38
#define GEN8_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointer_start  38
#define GEN75_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointer_start  38
#define GEN7_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointer_start  38

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointer_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 38;
   case 9: return 38;
   case 8: return 38;
   case 7:
      if (devinfo->is_haswell) {
         return 38;
      } else {
         return 38;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BLEND_STATE_POINTERS::Blend State Pointer Valid */


#define GEN10_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointerValid_bits  1
#define GEN9_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointerValid_bits  1
#define GEN8_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointerValid_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointerValid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointerValid_start  32
#define GEN9_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointerValid_start  32
#define GEN8_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointerValid_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointerValid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BLEND_STATE_POINTERS::Command SubType */


#define GEN10_3DSTATE_BLEND_STATE_POINTERS_CommandSubType_bits  2
#define GEN9_3DSTATE_BLEND_STATE_POINTERS_CommandSubType_bits  2
#define GEN8_3DSTATE_BLEND_STATE_POINTERS_CommandSubType_bits  2
#define GEN75_3DSTATE_BLEND_STATE_POINTERS_CommandSubType_bits  2
#define GEN7_3DSTATE_BLEND_STATE_POINTERS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BLEND_STATE_POINTERS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BLEND_STATE_POINTERS_CommandSubType_start  27
#define GEN9_3DSTATE_BLEND_STATE_POINTERS_CommandSubType_start  27
#define GEN8_3DSTATE_BLEND_STATE_POINTERS_CommandSubType_start  27
#define GEN75_3DSTATE_BLEND_STATE_POINTERS_CommandSubType_start  27
#define GEN7_3DSTATE_BLEND_STATE_POINTERS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BLEND_STATE_POINTERS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 27;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BLEND_STATE_POINTERS::Command Type */


#define GEN10_3DSTATE_BLEND_STATE_POINTERS_CommandType_bits  3
#define GEN9_3DSTATE_BLEND_STATE_POINTERS_CommandType_bits  3
#define GEN8_3DSTATE_BLEND_STATE_POINTERS_CommandType_bits  3
#define GEN75_3DSTATE_BLEND_STATE_POINTERS_CommandType_bits  3
#define GEN7_3DSTATE_BLEND_STATE_POINTERS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BLEND_STATE_POINTERS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BLEND_STATE_POINTERS_CommandType_start  29
#define GEN9_3DSTATE_BLEND_STATE_POINTERS_CommandType_start  29
#define GEN8_3DSTATE_BLEND_STATE_POINTERS_CommandType_start  29
#define GEN75_3DSTATE_BLEND_STATE_POINTERS_CommandType_start  29
#define GEN7_3DSTATE_BLEND_STATE_POINTERS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BLEND_STATE_POINTERS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 29;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BLEND_STATE_POINTERS::DWord Length */


#define GEN10_3DSTATE_BLEND_STATE_POINTERS_DWordLength_bits  8
#define GEN9_3DSTATE_BLEND_STATE_POINTERS_DWordLength_bits  8
#define GEN8_3DSTATE_BLEND_STATE_POINTERS_DWordLength_bits  8
#define GEN75_3DSTATE_BLEND_STATE_POINTERS_DWordLength_bits  8
#define GEN7_3DSTATE_BLEND_STATE_POINTERS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BLEND_STATE_POINTERS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_BLEND_STATE_POINTERS_DWordLength_start  0
#define GEN9_3DSTATE_BLEND_STATE_POINTERS_DWordLength_start  0
#define GEN8_3DSTATE_BLEND_STATE_POINTERS_DWordLength_start  0
#define GEN75_3DSTATE_BLEND_STATE_POINTERS_DWordLength_start  0
#define GEN7_3DSTATE_BLEND_STATE_POINTERS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BLEND_STATE_POINTERS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CC_STATE_POINTERS */


#define GEN10_3DSTATE_CC_STATE_POINTERS_length  2
#define GEN9_3DSTATE_CC_STATE_POINTERS_length  2
#define GEN8_3DSTATE_CC_STATE_POINTERS_length  2
#define GEN75_3DSTATE_CC_STATE_POINTERS_length  2
#define GEN7_3DSTATE_CC_STATE_POINTERS_length  2
#define GEN6_3DSTATE_CC_STATE_POINTERS_length  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 4;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CC_STATE_POINTERS::3D Command Opcode */


#define GEN10_3DSTATE_CC_STATE_POINTERS_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_CC_STATE_POINTERS_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_CC_STATE_POINTERS_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_CC_STATE_POINTERS_3DCommandOpcode_bits  3
#define GEN7_3DSTATE_CC_STATE_POINTERS_3DCommandOpcode_bits  3
#define GEN6_3DSTATE_CC_STATE_POINTERS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CC_STATE_POINTERS_3DCommandOpcode_start  24
#define GEN9_3DSTATE_CC_STATE_POINTERS_3DCommandOpcode_start  24
#define GEN8_3DSTATE_CC_STATE_POINTERS_3DCommandOpcode_start  24
#define GEN75_3DSTATE_CC_STATE_POINTERS_3DCommandOpcode_start  24
#define GEN7_3DSTATE_CC_STATE_POINTERS_3DCommandOpcode_start  24
#define GEN6_3DSTATE_CC_STATE_POINTERS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 24;
      }
   case 6: return 24;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CC_STATE_POINTERS::3D Command Sub Opcode */


#define GEN10_3DSTATE_CC_STATE_POINTERS_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_CC_STATE_POINTERS_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_CC_STATE_POINTERS_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_CC_STATE_POINTERS_3DCommandSubOpcode_bits  8
#define GEN7_3DSTATE_CC_STATE_POINTERS_3DCommandSubOpcode_bits  8
#define GEN6_3DSTATE_CC_STATE_POINTERS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CC_STATE_POINTERS_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_CC_STATE_POINTERS_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_CC_STATE_POINTERS_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_CC_STATE_POINTERS_3DCommandSubOpcode_start  16
#define GEN7_3DSTATE_CC_STATE_POINTERS_3DCommandSubOpcode_start  16
#define GEN6_3DSTATE_CC_STATE_POINTERS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 16;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CC_STATE_POINTERS::BLEND_STATE Change */


#define GEN6_3DSTATE_CC_STATE_POINTERS_BLEND_STATEChange_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_BLEND_STATEChange_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CC_STATE_POINTERS_BLEND_STATEChange_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_BLEND_STATEChange_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 32;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CC_STATE_POINTERS::Color Calc State Pointer */


#define GEN10_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointer_bits  26
#define GEN9_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointer_bits  26
#define GEN8_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointer_bits  26
#define GEN75_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointer_bits  26
#define GEN7_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointer_bits  26
#define GEN6_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointer_bits  26

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointer_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 26;
   case 9: return 26;
   case 8: return 26;
   case 7:
      if (devinfo->is_haswell) {
         return 26;
      } else {
         return 26;
      }
   case 6: return 26;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointer_start  38
#define GEN9_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointer_start  38
#define GEN8_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointer_start  38
#define GEN75_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointer_start  38
#define GEN7_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointer_start  38
#define GEN6_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointer_start  102

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointer_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 38;
   case 9: return 38;
   case 8: return 38;
   case 7:
      if (devinfo->is_haswell) {
         return 38;
      } else {
         return 38;
      }
   case 6: return 102;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CC_STATE_POINTERS::Color Calc State Pointer Valid */


#define GEN10_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointerValid_bits  1
#define GEN9_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointerValid_bits  1
#define GEN8_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointerValid_bits  1
#define GEN6_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointerValid_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointerValid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointerValid_start  32
#define GEN9_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointerValid_start  32
#define GEN8_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointerValid_start  32
#define GEN6_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointerValid_start  96

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointerValid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 96;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CC_STATE_POINTERS::Command SubType */


#define GEN10_3DSTATE_CC_STATE_POINTERS_CommandSubType_bits  2
#define GEN9_3DSTATE_CC_STATE_POINTERS_CommandSubType_bits  2
#define GEN8_3DSTATE_CC_STATE_POINTERS_CommandSubType_bits  2
#define GEN75_3DSTATE_CC_STATE_POINTERS_CommandSubType_bits  2
#define GEN7_3DSTATE_CC_STATE_POINTERS_CommandSubType_bits  2
#define GEN6_3DSTATE_CC_STATE_POINTERS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 2;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CC_STATE_POINTERS_CommandSubType_start  27
#define GEN9_3DSTATE_CC_STATE_POINTERS_CommandSubType_start  27
#define GEN8_3DSTATE_CC_STATE_POINTERS_CommandSubType_start  27
#define GEN75_3DSTATE_CC_STATE_POINTERS_CommandSubType_start  27
#define GEN7_3DSTATE_CC_STATE_POINTERS_CommandSubType_start  27
#define GEN6_3DSTATE_CC_STATE_POINTERS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 27;
      }
   case 6: return 27;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CC_STATE_POINTERS::Command Type */


#define GEN10_3DSTATE_CC_STATE_POINTERS_CommandType_bits  3
#define GEN9_3DSTATE_CC_STATE_POINTERS_CommandType_bits  3
#define GEN8_3DSTATE_CC_STATE_POINTERS_CommandType_bits  3
#define GEN75_3DSTATE_CC_STATE_POINTERS_CommandType_bits  3
#define GEN7_3DSTATE_CC_STATE_POINTERS_CommandType_bits  3
#define GEN6_3DSTATE_CC_STATE_POINTERS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CC_STATE_POINTERS_CommandType_start  29
#define GEN9_3DSTATE_CC_STATE_POINTERS_CommandType_start  29
#define GEN8_3DSTATE_CC_STATE_POINTERS_CommandType_start  29
#define GEN75_3DSTATE_CC_STATE_POINTERS_CommandType_start  29
#define GEN7_3DSTATE_CC_STATE_POINTERS_CommandType_start  29
#define GEN6_3DSTATE_CC_STATE_POINTERS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 29;
      }
   case 6: return 29;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CC_STATE_POINTERS::DEPTH_STENCIL_STATE Change */


#define GEN6_3DSTATE_CC_STATE_POINTERS_DEPTH_STENCIL_STATEChange_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_DEPTH_STENCIL_STATEChange_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CC_STATE_POINTERS_DEPTH_STENCIL_STATEChange_start  64

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_DEPTH_STENCIL_STATEChange_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 64;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CC_STATE_POINTERS::DWord Length */


#define GEN10_3DSTATE_CC_STATE_POINTERS_DWordLength_bits  8
#define GEN9_3DSTATE_CC_STATE_POINTERS_DWordLength_bits  8
#define GEN8_3DSTATE_CC_STATE_POINTERS_DWordLength_bits  8
#define GEN75_3DSTATE_CC_STATE_POINTERS_DWordLength_bits  8
#define GEN7_3DSTATE_CC_STATE_POINTERS_DWordLength_bits  8
#define GEN6_3DSTATE_CC_STATE_POINTERS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CC_STATE_POINTERS_DWordLength_start  0
#define GEN9_3DSTATE_CC_STATE_POINTERS_DWordLength_start  0
#define GEN8_3DSTATE_CC_STATE_POINTERS_DWordLength_start  0
#define GEN75_3DSTATE_CC_STATE_POINTERS_DWordLength_start  0
#define GEN7_3DSTATE_CC_STATE_POINTERS_DWordLength_start  0
#define GEN6_3DSTATE_CC_STATE_POINTERS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CC_STATE_POINTERS::Pointer to BLEND_STATE */


#define GEN6_3DSTATE_CC_STATE_POINTERS_PointertoBLEND_STATE_bits  26

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_PointertoBLEND_STATE_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 26;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CC_STATE_POINTERS_PointertoBLEND_STATE_start  38

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_PointertoBLEND_STATE_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 38;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CC_STATE_POINTERS::Pointer to DEPTH_STENCIL_STATE */


#define GEN6_3DSTATE_CC_STATE_POINTERS_PointertoDEPTH_STENCIL_STATE_bits  26

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_PointertoDEPTH_STENCIL_STATE_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 26;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CC_STATE_POINTERS_PointertoDEPTH_STENCIL_STATE_start  70

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_PointertoDEPTH_STENCIL_STATE_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 70;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CHROMA_KEY */


#define GEN10_3DSTATE_CHROMA_KEY_length  4
#define GEN9_3DSTATE_CHROMA_KEY_length  4
#define GEN8_3DSTATE_CHROMA_KEY_length  4
#define GEN75_3DSTATE_CHROMA_KEY_length  4
#define GEN7_3DSTATE_CHROMA_KEY_length  4
#define GEN6_3DSTATE_CHROMA_KEY_length  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CHROMA_KEY_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 4;
   case 9: return 4;
   case 8: return 4;
   case 7:
      if (devinfo->is_haswell) {
         return 4;
      } else {
         return 4;
      }
   case 6: return 4;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CHROMA_KEY::3D Command Opcode */


#define GEN10_3DSTATE_CHROMA_KEY_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_CHROMA_KEY_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_CHROMA_KEY_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_CHROMA_KEY_3DCommandOpcode_bits  3
#define GEN7_3DSTATE_CHROMA_KEY_3DCommandOpcode_bits  3
#define GEN6_3DSTATE_CHROMA_KEY_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CHROMA_KEY_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CHROMA_KEY_3DCommandOpcode_start  24
#define GEN9_3DSTATE_CHROMA_KEY_3DCommandOpcode_start  24
#define GEN8_3DSTATE_CHROMA_KEY_3DCommandOpcode_start  24
#define GEN75_3DSTATE_CHROMA_KEY_3DCommandOpcode_start  24
#define GEN7_3DSTATE_CHROMA_KEY_3DCommandOpcode_start  24
#define GEN6_3DSTATE_CHROMA_KEY_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CHROMA_KEY_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 24;
      }
   case 6: return 24;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CHROMA_KEY::3D Command Sub Opcode */


#define GEN10_3DSTATE_CHROMA_KEY_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_CHROMA_KEY_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_CHROMA_KEY_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_CHROMA_KEY_3DCommandSubOpcode_bits  8
#define GEN7_3DSTATE_CHROMA_KEY_3DCommandSubOpcode_bits  8
#define GEN6_3DSTATE_CHROMA_KEY_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CHROMA_KEY_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CHROMA_KEY_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_CHROMA_KEY_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_CHROMA_KEY_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_CHROMA_KEY_3DCommandSubOpcode_start  16
#define GEN7_3DSTATE_CHROMA_KEY_3DCommandSubOpcode_start  16
#define GEN6_3DSTATE_CHROMA_KEY_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CHROMA_KEY_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 16;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CHROMA_KEY::ChromaKey High Value */


#define GEN10_3DSTATE_CHROMA_KEY_ChromaKeyHighValue_bits  32
#define GEN9_3DSTATE_CHROMA_KEY_ChromaKeyHighValue_bits  32
#define GEN8_3DSTATE_CHROMA_KEY_ChromaKeyHighValue_bits  32
#define GEN75_3DSTATE_CHROMA_KEY_ChromaKeyHighValue_bits  32
#define GEN7_3DSTATE_CHROMA_KEY_ChromaKeyHighValue_bits  32
#define GEN6_3DSTATE_CHROMA_KEY_ChromaKeyHighValue_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CHROMA_KEY_ChromaKeyHighValue_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 32;
      }
   case 6: return 32;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CHROMA_KEY_ChromaKeyHighValue_start  96
#define GEN9_3DSTATE_CHROMA_KEY_ChromaKeyHighValue_start  96
#define GEN8_3DSTATE_CHROMA_KEY_ChromaKeyHighValue_start  96
#define GEN75_3DSTATE_CHROMA_KEY_ChromaKeyHighValue_start  96
#define GEN7_3DSTATE_CHROMA_KEY_ChromaKeyHighValue_start  96
#define GEN6_3DSTATE_CHROMA_KEY_ChromaKeyHighValue_start  96

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CHROMA_KEY_ChromaKeyHighValue_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 96;
   case 9: return 96;
   case 8: return 96;
   case 7:
      if (devinfo->is_haswell) {
         return 96;
      } else {
         return 96;
      }
   case 6: return 96;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CHROMA_KEY::ChromaKey Low Value */


#define GEN10_3DSTATE_CHROMA_KEY_ChromaKeyLowValue_bits  32
#define GEN9_3DSTATE_CHROMA_KEY_ChromaKeyLowValue_bits  32
#define GEN8_3DSTATE_CHROMA_KEY_ChromaKeyLowValue_bits  32
#define GEN75_3DSTATE_CHROMA_KEY_ChromaKeyLowValue_bits  32
#define GEN7_3DSTATE_CHROMA_KEY_ChromaKeyLowValue_bits  32
#define GEN6_3DSTATE_CHROMA_KEY_ChromaKeyLowValue_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CHROMA_KEY_ChromaKeyLowValue_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 32;
      }
   case 6: return 32;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CHROMA_KEY_ChromaKeyLowValue_start  64
#define GEN9_3DSTATE_CHROMA_KEY_ChromaKeyLowValue_start  64
#define GEN8_3DSTATE_CHROMA_KEY_ChromaKeyLowValue_start  64
#define GEN75_3DSTATE_CHROMA_KEY_ChromaKeyLowValue_start  64
#define GEN7_3DSTATE_CHROMA_KEY_ChromaKeyLowValue_start  64
#define GEN6_3DSTATE_CHROMA_KEY_ChromaKeyLowValue_start  64

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CHROMA_KEY_ChromaKeyLowValue_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 64;
   case 9: return 64;
   case 8: return 64;
   case 7:
      if (devinfo->is_haswell) {
         return 64;
      } else {
         return 64;
      }
   case 6: return 64;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CHROMA_KEY::ChromaKey Table Index */


#define GEN10_3DSTATE_CHROMA_KEY_ChromaKeyTableIndex_bits  2
#define GEN9_3DSTATE_CHROMA_KEY_ChromaKeyTableIndex_bits  2
#define GEN8_3DSTATE_CHROMA_KEY_ChromaKeyTableIndex_bits  2
#define GEN75_3DSTATE_CHROMA_KEY_ChromaKeyTableIndex_bits  2
#define GEN7_3DSTATE_CHROMA_KEY_ChromaKeyTableIndex_bits  2
#define GEN6_3DSTATE_CHROMA_KEY_ChromaKeyTableIndex_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CHROMA_KEY_ChromaKeyTableIndex_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 2;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CHROMA_KEY_ChromaKeyTableIndex_start  62
#define GEN9_3DSTATE_CHROMA_KEY_ChromaKeyTableIndex_start  62
#define GEN8_3DSTATE_CHROMA_KEY_ChromaKeyTableIndex_start  62
#define GEN75_3DSTATE_CHROMA_KEY_ChromaKeyTableIndex_start  62
#define GEN7_3DSTATE_CHROMA_KEY_ChromaKeyTableIndex_start  62
#define GEN6_3DSTATE_CHROMA_KEY_ChromaKeyTableIndex_start  62

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CHROMA_KEY_ChromaKeyTableIndex_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 62;
   case 9: return 62;
   case 8: return 62;
   case 7:
      if (devinfo->is_haswell) {
         return 62;
      } else {
         return 62;
      }
   case 6: return 62;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CHROMA_KEY::Command SubType */


#define GEN10_3DSTATE_CHROMA_KEY_CommandSubType_bits  2
#define GEN9_3DSTATE_CHROMA_KEY_CommandSubType_bits  2
#define GEN8_3DSTATE_CHROMA_KEY_CommandSubType_bits  2
#define GEN75_3DSTATE_CHROMA_KEY_CommandSubType_bits  2
#define GEN7_3DSTATE_CHROMA_KEY_CommandSubType_bits  2
#define GEN6_3DSTATE_CHROMA_KEY_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CHROMA_KEY_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 2;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CHROMA_KEY_CommandSubType_start  27
#define GEN9_3DSTATE_CHROMA_KEY_CommandSubType_start  27
#define GEN8_3DSTATE_CHROMA_KEY_CommandSubType_start  27
#define GEN75_3DSTATE_CHROMA_KEY_CommandSubType_start  27
#define GEN7_3DSTATE_CHROMA_KEY_CommandSubType_start  27
#define GEN6_3DSTATE_CHROMA_KEY_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CHROMA_KEY_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 27;
      }
   case 6: return 27;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CHROMA_KEY::Command Type */


#define GEN10_3DSTATE_CHROMA_KEY_CommandType_bits  3
#define GEN9_3DSTATE_CHROMA_KEY_CommandType_bits  3
#define GEN8_3DSTATE_CHROMA_KEY_CommandType_bits  3
#define GEN75_3DSTATE_CHROMA_KEY_CommandType_bits  3
#define GEN7_3DSTATE_CHROMA_KEY_CommandType_bits  3
#define GEN6_3DSTATE_CHROMA_KEY_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CHROMA_KEY_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CHROMA_KEY_CommandType_start  29
#define GEN9_3DSTATE_CHROMA_KEY_CommandType_start  29
#define GEN8_3DSTATE_CHROMA_KEY_CommandType_start  29
#define GEN75_3DSTATE_CHROMA_KEY_CommandType_start  29
#define GEN7_3DSTATE_CHROMA_KEY_CommandType_start  29
#define GEN6_3DSTATE_CHROMA_KEY_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CHROMA_KEY_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 29;
      }
   case 6: return 29;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CHROMA_KEY::DWord Length */


#define GEN10_3DSTATE_CHROMA_KEY_DWordLength_bits  8
#define GEN9_3DSTATE_CHROMA_KEY_DWordLength_bits  8
#define GEN8_3DSTATE_CHROMA_KEY_DWordLength_bits  8
#define GEN75_3DSTATE_CHROMA_KEY_DWordLength_bits  8
#define GEN7_3DSTATE_CHROMA_KEY_DWordLength_bits  8
#define GEN6_3DSTATE_CHROMA_KEY_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CHROMA_KEY_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CHROMA_KEY_DWordLength_start  0
#define GEN9_3DSTATE_CHROMA_KEY_DWordLength_start  0
#define GEN8_3DSTATE_CHROMA_KEY_DWordLength_start  0
#define GEN75_3DSTATE_CHROMA_KEY_DWordLength_start  0
#define GEN7_3DSTATE_CHROMA_KEY_DWordLength_start  0
#define GEN6_3DSTATE_CHROMA_KEY_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CHROMA_KEY_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLEAR_PARAMS */


#define GEN10_3DSTATE_CLEAR_PARAMS_length  3
#define GEN9_3DSTATE_CLEAR_PARAMS_length  3
#define GEN8_3DSTATE_CLEAR_PARAMS_length  3
#define GEN75_3DSTATE_CLEAR_PARAMS_length  3
#define GEN7_3DSTATE_CLEAR_PARAMS_length  3
#define GEN6_3DSTATE_CLEAR_PARAMS_length  2
#define GEN5_3DSTATE_CLEAR_PARAMS_length  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLEAR_PARAMS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 2;
   case 5: return 2;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLEAR_PARAMS::3D Command Opcode */


#define GEN10_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_bits  3
#define GEN7_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_bits  3
#define GEN6_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_bits  3
#define GEN5_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 3;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_start  24
#define GEN9_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_start  24
#define GEN8_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_start  24
#define GEN75_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_start  24
#define GEN7_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_start  24
#define GEN6_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_start  24
#define GEN5_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 24;
      }
   case 6: return 24;
   case 5: return 24;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLEAR_PARAMS::3D Command Sub Opcode */


#define GEN10_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_bits  8
#define GEN7_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_bits  8
#define GEN6_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_bits  8
#define GEN5_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 8;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_start  16
#define GEN7_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_start  16
#define GEN6_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_start  16
#define GEN5_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 16;
   case 5: return 16;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLEAR_PARAMS::Command SubType */


#define GEN10_3DSTATE_CLEAR_PARAMS_CommandSubType_bits  2
#define GEN9_3DSTATE_CLEAR_PARAMS_CommandSubType_bits  2
#define GEN8_3DSTATE_CLEAR_PARAMS_CommandSubType_bits  2
#define GEN75_3DSTATE_CLEAR_PARAMS_CommandSubType_bits  2
#define GEN7_3DSTATE_CLEAR_PARAMS_CommandSubType_bits  2
#define GEN6_3DSTATE_CLEAR_PARAMS_CommandSubType_bits  2
#define GEN5_3DSTATE_CLEAR_PARAMS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLEAR_PARAMS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 2;
   case 5: return 2;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CLEAR_PARAMS_CommandSubType_start  27
#define GEN9_3DSTATE_CLEAR_PARAMS_CommandSubType_start  27
#define GEN8_3DSTATE_CLEAR_PARAMS_CommandSubType_start  27
#define GEN75_3DSTATE_CLEAR_PARAMS_CommandSubType_start  27
#define GEN7_3DSTATE_CLEAR_PARAMS_CommandSubType_start  27
#define GEN6_3DSTATE_CLEAR_PARAMS_CommandSubType_start  27
#define GEN5_3DSTATE_CLEAR_PARAMS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLEAR_PARAMS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 27;
      }
   case 6: return 27;
   case 5: return 27;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLEAR_PARAMS::Command Type */


#define GEN10_3DSTATE_CLEAR_PARAMS_CommandType_bits  3
#define GEN9_3DSTATE_CLEAR_PARAMS_CommandType_bits  3
#define GEN8_3DSTATE_CLEAR_PARAMS_CommandType_bits  3
#define GEN75_3DSTATE_CLEAR_PARAMS_CommandType_bits  3
#define GEN7_3DSTATE_CLEAR_PARAMS_CommandType_bits  3
#define GEN6_3DSTATE_CLEAR_PARAMS_CommandType_bits  3
#define GEN5_3DSTATE_CLEAR_PARAMS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLEAR_PARAMS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 3;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CLEAR_PARAMS_CommandType_start  29
#define GEN9_3DSTATE_CLEAR_PARAMS_CommandType_start  29
#define GEN8_3DSTATE_CLEAR_PARAMS_CommandType_start  29
#define GEN75_3DSTATE_CLEAR_PARAMS_CommandType_start  29
#define GEN7_3DSTATE_CLEAR_PARAMS_CommandType_start  29
#define GEN6_3DSTATE_CLEAR_PARAMS_CommandType_start  29
#define GEN5_3DSTATE_CLEAR_PARAMS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLEAR_PARAMS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 29;
      }
   case 6: return 29;
   case 5: return 29;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLEAR_PARAMS::DWord Length */


#define GEN10_3DSTATE_CLEAR_PARAMS_DWordLength_bits  8
#define GEN9_3DSTATE_CLEAR_PARAMS_DWordLength_bits  8
#define GEN8_3DSTATE_CLEAR_PARAMS_DWordLength_bits  8
#define GEN75_3DSTATE_CLEAR_PARAMS_DWordLength_bits  8
#define GEN7_3DSTATE_CLEAR_PARAMS_DWordLength_bits  8
#define GEN6_3DSTATE_CLEAR_PARAMS_DWordLength_bits  8
#define GEN5_3DSTATE_CLEAR_PARAMS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLEAR_PARAMS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 8;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CLEAR_PARAMS_DWordLength_start  0
#define GEN9_3DSTATE_CLEAR_PARAMS_DWordLength_start  0
#define GEN8_3DSTATE_CLEAR_PARAMS_DWordLength_start  0
#define GEN75_3DSTATE_CLEAR_PARAMS_DWordLength_start  0
#define GEN7_3DSTATE_CLEAR_PARAMS_DWordLength_start  0
#define GEN6_3DSTATE_CLEAR_PARAMS_DWordLength_start  0
#define GEN5_3DSTATE_CLEAR_PARAMS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLEAR_PARAMS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLEAR_PARAMS::Depth Clear Value */


#define GEN10_3DSTATE_CLEAR_PARAMS_DepthClearValue_bits  32
#define GEN9_3DSTATE_CLEAR_PARAMS_DepthClearValue_bits  32
#define GEN8_3DSTATE_CLEAR_PARAMS_DepthClearValue_bits  32
#define GEN75_3DSTATE_CLEAR_PARAMS_DepthClearValue_bits  32
#define GEN7_3DSTATE_CLEAR_PARAMS_DepthClearValue_bits  32
#define GEN6_3DSTATE_CLEAR_PARAMS_DepthClearValue_bits  32
#define GEN5_3DSTATE_CLEAR_PARAMS_DepthClearValue_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLEAR_PARAMS_DepthClearValue_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 32;
      }
   case 6: return 32;
   case 5: return 32;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CLEAR_PARAMS_DepthClearValue_start  32
#define GEN9_3DSTATE_CLEAR_PARAMS_DepthClearValue_start  32
#define GEN8_3DSTATE_CLEAR_PARAMS_DepthClearValue_start  32
#define GEN75_3DSTATE_CLEAR_PARAMS_DepthClearValue_start  32
#define GEN7_3DSTATE_CLEAR_PARAMS_DepthClearValue_start  32
#define GEN6_3DSTATE_CLEAR_PARAMS_DepthClearValue_start  32
#define GEN5_3DSTATE_CLEAR_PARAMS_DepthClearValue_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLEAR_PARAMS_DepthClearValue_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 32;
      }
   case 6: return 32;
   case 5: return 32;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLEAR_PARAMS::Depth Clear Value Valid */


#define GEN10_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_bits  1
#define GEN9_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_bits  1
#define GEN8_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_bits  1
#define GEN75_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_bits  1
#define GEN7_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_bits  1
#define GEN6_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_bits  1
#define GEN5_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 1;
   case 5: return 1;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_start  64
#define GEN9_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_start  64
#define GEN8_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_start  64
#define GEN75_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_start  64
#define GEN7_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_start  64
#define GEN6_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_start  15
#define GEN5_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_start  15

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 64;
   case 9: return 64;
   case 8: return 64;
   case 7:
      if (devinfo->is_haswell) {
         return 64;
      } else {
         return 64;
      }
   case 6: return 15;
   case 5: return 15;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP */


#define GEN10_3DSTATE_CLIP_length  4
#define GEN9_3DSTATE_CLIP_length  4
#define GEN8_3DSTATE_CLIP_length  4
#define GEN75_3DSTATE_CLIP_length  4
#define GEN7_3DSTATE_CLIP_length  4
#define GEN6_3DSTATE_CLIP_length  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 4;
   case 9: return 4;
   case 8: return 4;
   case 7:
      if (devinfo->is_haswell) {
         return 4;
      } else {
         return 4;
      }
   case 6: return 4;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::3D Command Opcode */


#define GEN10_3DSTATE_CLIP_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_CLIP_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_CLIP_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_CLIP_3DCommandOpcode_bits  3
#define GEN7_3DSTATE_CLIP_3DCommandOpcode_bits  3
#define GEN6_3DSTATE_CLIP_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CLIP_3DCommandOpcode_start  24
#define GEN9_3DSTATE_CLIP_3DCommandOpcode_start  24
#define GEN8_3DSTATE_CLIP_3DCommandOpcode_start  24
#define GEN75_3DSTATE_CLIP_3DCommandOpcode_start  24
#define GEN7_3DSTATE_CLIP_3DCommandOpcode_start  24
#define GEN6_3DSTATE_CLIP_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 24;
      }
   case 6: return 24;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::3D Command Sub Opcode */


#define GEN10_3DSTATE_CLIP_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_CLIP_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_CLIP_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_CLIP_3DCommandSubOpcode_bits  8
#define GEN7_3DSTATE_CLIP_3DCommandSubOpcode_bits  8
#define GEN6_3DSTATE_CLIP_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CLIP_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_CLIP_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_CLIP_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_CLIP_3DCommandSubOpcode_start  16
#define GEN7_3DSTATE_CLIP_3DCommandSubOpcode_start  16
#define GEN6_3DSTATE_CLIP_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 16;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::API Mode */


#define GEN10_3DSTATE_CLIP_APIMode_bits  1
#define GEN9_3DSTATE_CLIP_APIMode_bits  1
#define GEN8_3DSTATE_CLIP_APIMode_bits  1
#define GEN75_3DSTATE_CLIP_APIMode_bits  1
#define GEN7_3DSTATE_CLIP_APIMode_bits  1
#define GEN6_3DSTATE_CLIP_APIMode_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_APIMode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CLIP_APIMode_start  94
#define GEN9_3DSTATE_CLIP_APIMode_start  94
#define GEN8_3DSTATE_CLIP_APIMode_start  94
#define GEN75_3DSTATE_CLIP_APIMode_start  94
#define GEN7_3DSTATE_CLIP_APIMode_start  94
#define GEN6_3DSTATE_CLIP_APIMode_start  94

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_APIMode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 94;
   case 9: return 94;
   case 8: return 94;
   case 7:
      if (devinfo->is_haswell) {
         return 94;
      } else {
         return 94;
      }
   case 6: return 94;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Clip Enable */


#define GEN10_3DSTATE_CLIP_ClipEnable_bits  1
#define GEN9_3DSTATE_CLIP_ClipEnable_bits  1
#define GEN8_3DSTATE_CLIP_ClipEnable_bits  1
#define GEN75_3DSTATE_CLIP_ClipEnable_bits  1
#define GEN7_3DSTATE_CLIP_ClipEnable_bits  1
#define GEN6_3DSTATE_CLIP_ClipEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_ClipEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CLIP_ClipEnable_start  95
#define GEN9_3DSTATE_CLIP_ClipEnable_start  95
#define GEN8_3DSTATE_CLIP_ClipEnable_start  95
#define GEN75_3DSTATE_CLIP_ClipEnable_start  95
#define GEN7_3DSTATE_CLIP_ClipEnable_start  95
#define GEN6_3DSTATE_CLIP_ClipEnable_start  95

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_ClipEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 95;
   case 9: return 95;
   case 8: return 95;
   case 7:
      if (devinfo->is_haswell) {
         return 95;
      } else {
         return 95;
      }
   case 6: return 95;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Clip Mode */


#define GEN10_3DSTATE_CLIP_ClipMode_bits  3
#define GEN9_3DSTATE_CLIP_ClipMode_bits  3
#define GEN8_3DSTATE_CLIP_ClipMode_bits  3
#define GEN75_3DSTATE_CLIP_ClipMode_bits  3
#define GEN7_3DSTATE_CLIP_ClipMode_bits  3
#define GEN6_3DSTATE_CLIP_ClipMode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_ClipMode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CLIP_ClipMode_start  77
#define GEN9_3DSTATE_CLIP_ClipMode_start  77
#define GEN8_3DSTATE_CLIP_ClipMode_start  77
#define GEN75_3DSTATE_CLIP_ClipMode_start  77
#define GEN7_3DSTATE_CLIP_ClipMode_start  77
#define GEN6_3DSTATE_CLIP_ClipMode_start  77

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_ClipMode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 77;
   case 9: return 77;
   case 8: return 77;
   case 7:
      if (devinfo->is_haswell) {
         return 77;
      } else {
         return 77;
      }
   case 6: return 77;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Command SubType */


#define GEN10_3DSTATE_CLIP_CommandSubType_bits  2
#define GEN9_3DSTATE_CLIP_CommandSubType_bits  2
#define GEN8_3DSTATE_CLIP_CommandSubType_bits  2
#define GEN75_3DSTATE_CLIP_CommandSubType_bits  2
#define GEN7_3DSTATE_CLIP_CommandSubType_bits  2
#define GEN6_3DSTATE_CLIP_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 2;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CLIP_CommandSubType_start  27
#define GEN9_3DSTATE_CLIP_CommandSubType_start  27
#define GEN8_3DSTATE_CLIP_CommandSubType_start  27
#define GEN75_3DSTATE_CLIP_CommandSubType_start  27
#define GEN7_3DSTATE_CLIP_CommandSubType_start  27
#define GEN6_3DSTATE_CLIP_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 27;
      }
   case 6: return 27;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Command Type */


#define GEN10_3DSTATE_CLIP_CommandType_bits  3
#define GEN9_3DSTATE_CLIP_CommandType_bits  3
#define GEN8_3DSTATE_CLIP_CommandType_bits  3
#define GEN75_3DSTATE_CLIP_CommandType_bits  3
#define GEN7_3DSTATE_CLIP_CommandType_bits  3
#define GEN6_3DSTATE_CLIP_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CLIP_CommandType_start  29
#define GEN9_3DSTATE_CLIP_CommandType_start  29
#define GEN8_3DSTATE_CLIP_CommandType_start  29
#define GEN75_3DSTATE_CLIP_CommandType_start  29
#define GEN7_3DSTATE_CLIP_CommandType_start  29
#define GEN6_3DSTATE_CLIP_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 29;
      }
   case 6: return 29;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Cull Mode */


#define GEN75_3DSTATE_CLIP_CullMode_bits  2
#define GEN7_3DSTATE_CLIP_CullMode_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_CullMode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN75_3DSTATE_CLIP_CullMode_start  48
#define GEN7_3DSTATE_CLIP_CullMode_start  48

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_CullMode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 48;
      } else {
         return 48;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::DWord Length */


#define GEN10_3DSTATE_CLIP_DWordLength_bits  8
#define GEN9_3DSTATE_CLIP_DWordLength_bits  8
#define GEN8_3DSTATE_CLIP_DWordLength_bits  8
#define GEN75_3DSTATE_CLIP_DWordLength_bits  8
#define GEN7_3DSTATE_CLIP_DWordLength_bits  8
#define GEN6_3DSTATE_CLIP_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CLIP_DWordLength_start  0
#define GEN9_3DSTATE_CLIP_DWordLength_start  0
#define GEN8_3DSTATE_CLIP_DWordLength_start  0
#define GEN75_3DSTATE_CLIP_DWordLength_start  0
#define GEN7_3DSTATE_CLIP_DWordLength_start  0
#define GEN6_3DSTATE_CLIP_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Early Cull Enable */


#define GEN10_3DSTATE_CLIP_EarlyCullEnable_bits  1
#define GEN9_3DSTATE_CLIP_EarlyCullEnable_bits  1
#define GEN8_3DSTATE_CLIP_EarlyCullEnable_bits  1
#define GEN75_3DSTATE_CLIP_EarlyCullEnable_bits  1
#define GEN7_3DSTATE_CLIP_EarlyCullEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_EarlyCullEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CLIP_EarlyCullEnable_start  50
#define GEN9_3DSTATE_CLIP_EarlyCullEnable_start  50
#define GEN8_3DSTATE_CLIP_EarlyCullEnable_start  50
#define GEN75_3DSTATE_CLIP_EarlyCullEnable_start  50
#define GEN7_3DSTATE_CLIP_EarlyCullEnable_start  50

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_EarlyCullEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 50;
   case 9: return 50;
   case 8: return 50;
   case 7:
      if (devinfo->is_haswell) {
         return 50;
      } else {
         return 50;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Force Clip Mode */


#define GEN10_3DSTATE_CLIP_ForceClipMode_bits  1
#define GEN9_3DSTATE_CLIP_ForceClipMode_bits  1
#define GEN8_3DSTATE_CLIP_ForceClipMode_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_ForceClipMode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CLIP_ForceClipMode_start  48
#define GEN9_3DSTATE_CLIP_ForceClipMode_start  48
#define GEN8_3DSTATE_CLIP_ForceClipMode_start  48

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_ForceClipMode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 48;
   case 9: return 48;
   case 8: return 48;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Force User Clip Distance Clip Test Enable Bitmask */


#define GEN10_3DSTATE_CLIP_ForceUserClipDistanceClipTestEnableBitmask_bits  1
#define GEN9_3DSTATE_CLIP_ForceUserClipDistanceClipTestEnableBitmask_bits  1
#define GEN8_3DSTATE_CLIP_ForceUserClipDistanceClipTestEnableBitmask_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_ForceUserClipDistanceClipTestEnableBitmask_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CLIP_ForceUserClipDistanceClipTestEnableBitmask_start  49
#define GEN9_3DSTATE_CLIP_ForceUserClipDistanceClipTestEnableBitmask_start  49
#define GEN8_3DSTATE_CLIP_ForceUserClipDistanceClipTestEnableBitmask_start  49

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_ForceUserClipDistanceClipTestEnableBitmask_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 49;
   case 9: return 49;
   case 8: return 49;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Force User Clip Distance Cull Test Enable Bitmask */


#define GEN10_3DSTATE_CLIP_ForceUserClipDistanceCullTestEnableBitmask_bits  1
#define GEN9_3DSTATE_CLIP_ForceUserClipDistanceCullTestEnableBitmask_bits  1
#define GEN8_3DSTATE_CLIP_ForceUserClipDistanceCullTestEnableBitmask_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_ForceUserClipDistanceCullTestEnableBitmask_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CLIP_ForceUserClipDistanceCullTestEnableBitmask_start  52
#define GEN9_3DSTATE_CLIP_ForceUserClipDistanceCullTestEnableBitmask_start  52
#define GEN8_3DSTATE_CLIP_ForceUserClipDistanceCullTestEnableBitmask_start  52

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_ForceUserClipDistanceCullTestEnableBitmask_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 52;
   case 9: return 52;
   case 8: return 52;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Force Zero RTA Index Enable */


#define GEN10_3DSTATE_CLIP_ForceZeroRTAIndexEnable_bits  1
#define GEN9_3DSTATE_CLIP_ForceZeroRTAIndexEnable_bits  1
#define GEN8_3DSTATE_CLIP_ForceZeroRTAIndexEnable_bits  1
#define GEN75_3DSTATE_CLIP_ForceZeroRTAIndexEnable_bits  1
#define GEN7_3DSTATE_CLIP_ForceZeroRTAIndexEnable_bits  1
#define GEN6_3DSTATE_CLIP_ForceZeroRTAIndexEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_ForceZeroRTAIndexEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CLIP_ForceZeroRTAIndexEnable_start  101
#define GEN9_3DSTATE_CLIP_ForceZeroRTAIndexEnable_start  101
#define GEN8_3DSTATE_CLIP_ForceZeroRTAIndexEnable_start  101
#define GEN75_3DSTATE_CLIP_ForceZeroRTAIndexEnable_start  101
#define GEN7_3DSTATE_CLIP_ForceZeroRTAIndexEnable_start  101
#define GEN6_3DSTATE_CLIP_ForceZeroRTAIndexEnable_start  101

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_ForceZeroRTAIndexEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 101;
   case 9: return 101;
   case 8: return 101;
   case 7:
      if (devinfo->is_haswell) {
         return 101;
      } else {
         return 101;
      }
   case 6: return 101;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Front Winding */


#define GEN75_3DSTATE_CLIP_FrontWinding_bits  1
#define GEN7_3DSTATE_CLIP_FrontWinding_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_FrontWinding_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN75_3DSTATE_CLIP_FrontWinding_start  52
#define GEN7_3DSTATE_CLIP_FrontWinding_start  52

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_FrontWinding_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 52;
      } else {
         return 52;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Guardband Clip Test Enable */


#define GEN10_3DSTATE_CLIP_GuardbandClipTestEnable_bits  1
#define GEN9_3DSTATE_CLIP_GuardbandClipTestEnable_bits  1
#define GEN8_3DSTATE_CLIP_GuardbandClipTestEnable_bits  1
#define GEN75_3DSTATE_CLIP_GuardbandClipTestEnable_bits  1
#define GEN7_3DSTATE_CLIP_GuardbandClipTestEnable_bits  1
#define GEN6_3DSTATE_CLIP_GuardbandClipTestEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_GuardbandClipTestEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CLIP_GuardbandClipTestEnable_start  90
#define GEN9_3DSTATE_CLIP_GuardbandClipTestEnable_start  90
#define GEN8_3DSTATE_CLIP_GuardbandClipTestEnable_start  90
#define GEN75_3DSTATE_CLIP_GuardbandClipTestEnable_start  90
#define GEN7_3DSTATE_CLIP_GuardbandClipTestEnable_start  90
#define GEN6_3DSTATE_CLIP_GuardbandClipTestEnable_start  90

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_GuardbandClipTestEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 90;
   case 9: return 90;
   case 8: return 90;
   case 7:
      if (devinfo->is_haswell) {
         return 90;
      } else {
         return 90;
      }
   case 6: return 90;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Line Strip/List Provoking Vertex Select */


#define GEN10_3DSTATE_CLIP_LineStripListProvokingVertexSelect_bits  2
#define GEN9_3DSTATE_CLIP_LineStripListProvokingVertexSelect_bits  2
#define GEN8_3DSTATE_CLIP_LineStripListProvokingVertexSelect_bits  2
#define GEN75_3DSTATE_CLIP_LineStripListProvokingVertexSelect_bits  2
#define GEN7_3DSTATE_CLIP_LineStripListProvokingVertexSelect_bits  2
#define GEN6_3DSTATE_CLIP_LineStripListProvokingVertexSelect_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_LineStripListProvokingVertexSelect_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 2;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CLIP_LineStripListProvokingVertexSelect_start  66
#define GEN9_3DSTATE_CLIP_LineStripListProvokingVertexSelect_start  66
#define GEN8_3DSTATE_CLIP_LineStripListProvokingVertexSelect_start  66
#define GEN75_3DSTATE_CLIP_LineStripListProvokingVertexSelect_start  66
#define GEN7_3DSTATE_CLIP_LineStripListProvokingVertexSelect_start  66
#define GEN6_3DSTATE_CLIP_LineStripListProvokingVertexSelect_start  66

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_LineStripListProvokingVertexSelect_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 66;
   case 9: return 66;
   case 8: return 66;
   case 7:
      if (devinfo->is_haswell) {
         return 66;
      } else {
         return 66;
      }
   case 6: return 66;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Maximum Point Width */


#define GEN10_3DSTATE_CLIP_MaximumPointWidth_bits  11
#define GEN9_3DSTATE_CLIP_MaximumPointWidth_bits  11
#define GEN8_3DSTATE_CLIP_MaximumPointWidth_bits  11
#define GEN75_3DSTATE_CLIP_MaximumPointWidth_bits  11
#define GEN7_3DSTATE_CLIP_MaximumPointWidth_bits  11
#define GEN6_3DSTATE_CLIP_MaximumPointWidth_bits  11

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_MaximumPointWidth_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 11;
   case 9: return 11;
   case 8: return 11;
   case 7:
      if (devinfo->is_haswell) {
         return 11;
      } else {
         return 11;
      }
   case 6: return 11;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CLIP_MaximumPointWidth_start  102
#define GEN9_3DSTATE_CLIP_MaximumPointWidth_start  102
#define GEN8_3DSTATE_CLIP_MaximumPointWidth_start  102
#define GEN75_3DSTATE_CLIP_MaximumPointWidth_start  102
#define GEN7_3DSTATE_CLIP_MaximumPointWidth_start  102
#define GEN6_3DSTATE_CLIP_MaximumPointWidth_start  102

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_MaximumPointWidth_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 102;
   case 9: return 102;
   case 8: return 102;
   case 7:
      if (devinfo->is_haswell) {
         return 102;
      } else {
         return 102;
      }
   case 6: return 102;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Maximum VP Index */


#define GEN10_3DSTATE_CLIP_MaximumVPIndex_bits  4
#define GEN9_3DSTATE_CLIP_MaximumVPIndex_bits  4
#define GEN8_3DSTATE_CLIP_MaximumVPIndex_bits  4
#define GEN75_3DSTATE_CLIP_MaximumVPIndex_bits  4
#define GEN7_3DSTATE_CLIP_MaximumVPIndex_bits  4
#define GEN6_3DSTATE_CLIP_MaximumVPIndex_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_MaximumVPIndex_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 4;
   case 9: return 4;
   case 8: return 4;
   case 7:
      if (devinfo->is_haswell) {
         return 4;
      } else {
         return 4;
      }
   case 6: return 4;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CLIP_MaximumVPIndex_start  96
#define GEN9_3DSTATE_CLIP_MaximumVPIndex_start  96
#define GEN8_3DSTATE_CLIP_MaximumVPIndex_start  96
#define GEN75_3DSTATE_CLIP_MaximumVPIndex_start  96
#define GEN7_3DSTATE_CLIP_MaximumVPIndex_start  96
#define GEN6_3DSTATE_CLIP_MaximumVPIndex_start  96

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_MaximumVPIndex_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 96;
   case 9: return 96;
   case 8: return 96;
   case 7:
      if (devinfo->is_haswell) {
         return 96;
      } else {
         return 96;
      }
   case 6: return 96;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Minimum Point Width */


#define GEN10_3DSTATE_CLIP_MinimumPointWidth_bits  11
#define GEN9_3DSTATE_CLIP_MinimumPointWidth_bits  11
#define GEN8_3DSTATE_CLIP_MinimumPointWidth_bits  11
#define GEN75_3DSTATE_CLIP_MinimumPointWidth_bits  11
#define GEN7_3DSTATE_CLIP_MinimumPointWidth_bits  11
#define GEN6_3DSTATE_CLIP_MinimumPointWidth_bits  11

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_MinimumPointWidth_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 11;
   case 9: return 11;
   case 8: return 11;
   case 7:
      if (devinfo->is_haswell) {
         return 11;
      } else {
         return 11;
      }
   case 6: return 11;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CLIP_MinimumPointWidth_start  113
#define GEN9_3DSTATE_CLIP_MinimumPointWidth_start  113
#define GEN8_3DSTATE_CLIP_MinimumPointWidth_start  113
#define GEN75_3DSTATE_CLIP_MinimumPointWidth_start  113
#define GEN7_3DSTATE_CLIP_MinimumPointWidth_start  113
#define GEN6_3DSTATE_CLIP_MinimumPointWidth_start  113

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_MinimumPointWidth_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 113;
   case 9: return 113;
   case 8: return 113;
   case 7:
      if (devinfo->is_haswell) {
         return 113;
      } else {
         return 113;
      }
   case 6: return 113;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Non-Perspective Barycentric Enable */


#define GEN10_3DSTATE_CLIP_NonPerspectiveBarycentricEnable_bits  1
#define GEN9_3DSTATE_CLIP_NonPerspectiveBarycentricEnable_bits  1
#define GEN8_3DSTATE_CLIP_NonPerspectiveBarycentricEnable_bits  1
#define GEN75_3DSTATE_CLIP_NonPerspectiveBarycentricEnable_bits  1
#define GEN7_3DSTATE_CLIP_NonPerspectiveBarycentricEnable_bits  1
#define GEN6_3DSTATE_CLIP_NonPerspectiveBarycentricEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_NonPerspectiveBarycentricEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CLIP_NonPerspectiveBarycentricEnable_start  72
#define GEN9_3DSTATE_CLIP_NonPerspectiveBarycentricEnable_start  72
#define GEN8_3DSTATE_CLIP_NonPerspectiveBarycentricEnable_start  72
#define GEN75_3DSTATE_CLIP_NonPerspectiveBarycentricEnable_start  72
#define GEN7_3DSTATE_CLIP_NonPerspectiveBarycentricEnable_start  72
#define GEN6_3DSTATE_CLIP_NonPerspectiveBarycentricEnable_start  72

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_NonPerspectiveBarycentricEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 72;
   case 9: return 72;
   case 8: return 72;
   case 7:
      if (devinfo->is_haswell) {
         return 72;
      } else {
         return 72;
      }
   case 6: return 72;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Perspective Divide Disable */


#define GEN10_3DSTATE_CLIP_PerspectiveDivideDisable_bits  1
#define GEN9_3DSTATE_CLIP_PerspectiveDivideDisable_bits  1
#define GEN8_3DSTATE_CLIP_PerspectiveDivideDisable_bits  1
#define GEN75_3DSTATE_CLIP_PerspectiveDivideDisable_bits  1
#define GEN7_3DSTATE_CLIP_PerspectiveDivideDisable_bits  1
#define GEN6_3DSTATE_CLIP_PerspectiveDivideDisable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_PerspectiveDivideDisable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CLIP_PerspectiveDivideDisable_start  73
#define GEN9_3DSTATE_CLIP_PerspectiveDivideDisable_start  73
#define GEN8_3DSTATE_CLIP_PerspectiveDivideDisable_start  73
#define GEN75_3DSTATE_CLIP_PerspectiveDivideDisable_start  73
#define GEN7_3DSTATE_CLIP_PerspectiveDivideDisable_start  73
#define GEN6_3DSTATE_CLIP_PerspectiveDivideDisable_start  73

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_PerspectiveDivideDisable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 73;
   case 9: return 73;
   case 8: return 73;
   case 7:
      if (devinfo->is_haswell) {
         return 73;
      } else {
         return 73;
      }
   case 6: return 73;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Statistics Enable */


#define GEN10_3DSTATE_CLIP_StatisticsEnable_bits  1
#define GEN9_3DSTATE_CLIP_StatisticsEnable_bits  1
#define GEN8_3DSTATE_CLIP_StatisticsEnable_bits  1
#define GEN75_3DSTATE_CLIP_StatisticsEnable_bits  1
#define GEN7_3DSTATE_CLIP_StatisticsEnable_bits  1
#define GEN6_3DSTATE_CLIP_StatisticsEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_StatisticsEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CLIP_StatisticsEnable_start  42
#define GEN9_3DSTATE_CLIP_StatisticsEnable_start  42
#define GEN8_3DSTATE_CLIP_StatisticsEnable_start  42
#define GEN75_3DSTATE_CLIP_StatisticsEnable_start  42
#define GEN7_3DSTATE_CLIP_StatisticsEnable_start  42
#define GEN6_3DSTATE_CLIP_StatisticsEnable_start  42

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_StatisticsEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 42;
   case 9: return 42;
   case 8: return 42;
   case 7:
      if (devinfo->is_haswell) {
         return 42;
      } else {
         return 42;
      }
   case 6: return 42;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Triangle Fan Provoking Vertex Select */


#define GEN10_3DSTATE_CLIP_TriangleFanProvokingVertexSelect_bits  2
#define GEN9_3DSTATE_CLIP_TriangleFanProvokingVertexSelect_bits  2
#define GEN8_3DSTATE_CLIP_TriangleFanProvokingVertexSelect_bits  2
#define GEN75_3DSTATE_CLIP_TriangleFanProvokingVertexSelect_bits  2
#define GEN7_3DSTATE_CLIP_TriangleFanProvokingVertexSelect_bits  2
#define GEN6_3DSTATE_CLIP_TriangleFanProvokingVertexSelect_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_TriangleFanProvokingVertexSelect_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 2;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CLIP_TriangleFanProvokingVertexSelect_start  64
#define GEN9_3DSTATE_CLIP_TriangleFanProvokingVertexSelect_start  64
#define GEN8_3DSTATE_CLIP_TriangleFanProvokingVertexSelect_start  64
#define GEN75_3DSTATE_CLIP_TriangleFanProvokingVertexSelect_start  64
#define GEN7_3DSTATE_CLIP_TriangleFanProvokingVertexSelect_start  64
#define GEN6_3DSTATE_CLIP_TriangleFanProvokingVertexSelect_start  64

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_TriangleFanProvokingVertexSelect_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 64;
   case 9: return 64;
   case 8: return 64;
   case 7:
      if (devinfo->is_haswell) {
         return 64;
      } else {
         return 64;
      }
   case 6: return 64;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Triangle Strip/List Provoking Vertex Select */


#define GEN10_3DSTATE_CLIP_TriangleStripListProvokingVertexSelect_bits  2
#define GEN9_3DSTATE_CLIP_TriangleStripListProvokingVertexSelect_bits  2
#define GEN8_3DSTATE_CLIP_TriangleStripListProvokingVertexSelect_bits  2
#define GEN75_3DSTATE_CLIP_TriangleStripListProvokingVertexSelect_bits  2
#define GEN7_3DSTATE_CLIP_TriangleStripListProvokingVertexSelect_bits  2
#define GEN6_3DSTATE_CLIP_TriangleStripListProvokingVertexSelect_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_TriangleStripListProvokingVertexSelect_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 2;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CLIP_TriangleStripListProvokingVertexSelect_start  68
#define GEN9_3DSTATE_CLIP_TriangleStripListProvokingVertexSelect_start  68
#define GEN8_3DSTATE_CLIP_TriangleStripListProvokingVertexSelect_start  68
#define GEN75_3DSTATE_CLIP_TriangleStripListProvokingVertexSelect_start  68
#define GEN7_3DSTATE_CLIP_TriangleStripListProvokingVertexSelect_start  68
#define GEN6_3DSTATE_CLIP_TriangleStripListProvokingVertexSelect_start  68

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_TriangleStripListProvokingVertexSelect_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 68;
   case 9: return 68;
   case 8: return 68;
   case 7:
      if (devinfo->is_haswell) {
         return 68;
      } else {
         return 68;
      }
   case 6: return 68;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::User Clip Distance Clip Test Enable Bitmask */


#define GEN10_3DSTATE_CLIP_UserClipDistanceClipTestEnableBitmask_bits  8
#define GEN9_3DSTATE_CLIP_UserClipDistanceClipTestEnableBitmask_bits  8
#define GEN8_3DSTATE_CLIP_UserClipDistanceClipTestEnableBitmask_bits  8
#define GEN75_3DSTATE_CLIP_UserClipDistanceClipTestEnableBitmask_bits  8
#define GEN7_3DSTATE_CLIP_UserClipDistanceClipTestEnableBitmask_bits  8
#define GEN6_3DSTATE_CLIP_UserClipDistanceClipTestEnableBitmask_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_UserClipDistanceClipTestEnableBitmask_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CLIP_UserClipDistanceClipTestEnableBitmask_start  80
#define GEN9_3DSTATE_CLIP_UserClipDistanceClipTestEnableBitmask_start  80
#define GEN8_3DSTATE_CLIP_UserClipDistanceClipTestEnableBitmask_start  80
#define GEN75_3DSTATE_CLIP_UserClipDistanceClipTestEnableBitmask_start  80
#define GEN7_3DSTATE_CLIP_UserClipDistanceClipTestEnableBitmask_start  80
#define GEN6_3DSTATE_CLIP_UserClipDistanceClipTestEnableBitmask_start  80

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_UserClipDistanceClipTestEnableBitmask_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 80;
   case 9: return 80;
   case 8: return 80;
   case 7:
      if (devinfo->is_haswell) {
         return 80;
      } else {
         return 80;
      }
   case 6: return 80;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::User Clip Distance Cull Test Enable Bitmask */


#define GEN10_3DSTATE_CLIP_UserClipDistanceCullTestEnableBitmask_bits  8
#define GEN9_3DSTATE_CLIP_UserClipDistanceCullTestEnableBitmask_bits  8
#define GEN8_3DSTATE_CLIP_UserClipDistanceCullTestEnableBitmask_bits  8
#define GEN75_3DSTATE_CLIP_UserClipDistanceCullTestEnableBitmask_bits  8
#define GEN7_3DSTATE_CLIP_UserClipDistanceCullTestEnableBitmask_bits  8
#define GEN6_3DSTATE_CLIP_UserClipDistanceCullTestEnableBitmask_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_UserClipDistanceCullTestEnableBitmask_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CLIP_UserClipDistanceCullTestEnableBitmask_start  32
#define GEN9_3DSTATE_CLIP_UserClipDistanceCullTestEnableBitmask_start  32
#define GEN8_3DSTATE_CLIP_UserClipDistanceCullTestEnableBitmask_start  32
#define GEN75_3DSTATE_CLIP_UserClipDistanceCullTestEnableBitmask_start  32
#define GEN7_3DSTATE_CLIP_UserClipDistanceCullTestEnableBitmask_start  32
#define GEN6_3DSTATE_CLIP_UserClipDistanceCullTestEnableBitmask_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_UserClipDistanceCullTestEnableBitmask_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 32;
      }
   case 6: return 32;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Vertex Sub Pixel Precision Select */


#define GEN10_3DSTATE_CLIP_VertexSubPixelPrecisionSelect_bits  1
#define GEN9_3DSTATE_CLIP_VertexSubPixelPrecisionSelect_bits  1
#define GEN8_3DSTATE_CLIP_VertexSubPixelPrecisionSelect_bits  1
#define GEN75_3DSTATE_CLIP_VertexSubPixelPrecisionSelect_bits  1
#define GEN7_3DSTATE_CLIP_VertexSubPixelPrecisionSelect_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_VertexSubPixelPrecisionSelect_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CLIP_VertexSubPixelPrecisionSelect_start  51
#define GEN9_3DSTATE_CLIP_VertexSubPixelPrecisionSelect_start  51
#define GEN8_3DSTATE_CLIP_VertexSubPixelPrecisionSelect_start  51
#define GEN75_3DSTATE_CLIP_VertexSubPixelPrecisionSelect_start  51
#define GEN7_3DSTATE_CLIP_VertexSubPixelPrecisionSelect_start  51

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_VertexSubPixelPrecisionSelect_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 51;
   case 9: return 51;
   case 8: return 51;
   case 7:
      if (devinfo->is_haswell) {
         return 51;
      } else {
         return 51;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Viewport XY Clip Test Enable */


#define GEN10_3DSTATE_CLIP_ViewportXYClipTestEnable_bits  1
#define GEN9_3DSTATE_CLIP_ViewportXYClipTestEnable_bits  1
#define GEN8_3DSTATE_CLIP_ViewportXYClipTestEnable_bits  1
#define GEN75_3DSTATE_CLIP_ViewportXYClipTestEnable_bits  1
#define GEN7_3DSTATE_CLIP_ViewportXYClipTestEnable_bits  1
#define GEN6_3DSTATE_CLIP_ViewportXYClipTestEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_ViewportXYClipTestEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CLIP_ViewportXYClipTestEnable_start  92
#define GEN9_3DSTATE_CLIP_ViewportXYClipTestEnable_start  92
#define GEN8_3DSTATE_CLIP_ViewportXYClipTestEnable_start  92
#define GEN75_3DSTATE_CLIP_ViewportXYClipTestEnable_start  92
#define GEN7_3DSTATE_CLIP_ViewportXYClipTestEnable_start  92
#define GEN6_3DSTATE_CLIP_ViewportXYClipTestEnable_start  92

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_ViewportXYClipTestEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 92;
   case 9: return 92;
   case 8: return 92;
   case 7:
      if (devinfo->is_haswell) {
         return 92;
      } else {
         return 92;
      }
   case 6: return 92;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Viewport Z Clip Test Enable */


#define GEN75_3DSTATE_CLIP_ViewportZClipTestEnable_bits  1
#define GEN7_3DSTATE_CLIP_ViewportZClipTestEnable_bits  1
#define GEN6_3DSTATE_CLIP_ViewportZClipTestEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_ViewportZClipTestEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN75_3DSTATE_CLIP_ViewportZClipTestEnable_start  91
#define GEN7_3DSTATE_CLIP_ViewportZClipTestEnable_start  91
#define GEN6_3DSTATE_CLIP_ViewportZClipTestEnable_start  91

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_ViewportZClipTestEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 91;
      } else {
         return 91;
      }
   case 6: return 91;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_BODY */


#define GEN10_3DSTATE_CONSTANT_BODY_length  10
#define GEN9_3DSTATE_CONSTANT_BODY_length  10
#define GEN8_3DSTATE_CONSTANT_BODY_length  10
#define GEN75_3DSTATE_CONSTANT_BODY_length  6
#define GEN7_3DSTATE_CONSTANT_BODY_length  6

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_BODY_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 10;
   case 9: return 10;
   case 8: return 10;
   case 7:
      if (devinfo->is_haswell) {
         return 6;
      } else {
         return 6;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_BODY::Buffer */


#define GEN10_3DSTATE_CONSTANT_BODY_Buffer_bits  59
#define GEN9_3DSTATE_CONSTANT_BODY_Buffer_bits  59
#define GEN8_3DSTATE_CONSTANT_BODY_Buffer_bits  59
#define GEN75_3DSTATE_CONSTANT_BODY_Buffer_bits  27
#define GEN7_3DSTATE_CONSTANT_BODY_Buffer_bits  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_BODY_Buffer_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 59;
   case 9: return 59;
   case 8: return 59;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 27;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_BODY_Buffer_start  5
#define GEN9_3DSTATE_CONSTANT_BODY_Buffer_start  5
#define GEN8_3DSTATE_CONSTANT_BODY_Buffer_start  5
#define GEN75_3DSTATE_CONSTANT_BODY_Buffer_start  5
#define GEN7_3DSTATE_CONSTANT_BODY_Buffer_start  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_BODY_Buffer_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 5;
   case 9: return 5;
   case 8: return 5;
   case 7:
      if (devinfo->is_haswell) {
         return 5;
      } else {
         return 5;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_BODY::Constant Buffer Object Control State */


#define GEN75_3DSTATE_CONSTANT_BODY_ConstantBufferObjectControlState_bits  5
#define GEN7_3DSTATE_CONSTANT_BODY_ConstantBufferObjectControlState_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_BODY_ConstantBufferObjectControlState_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 5;
      } else {
         return 5;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN75_3DSTATE_CONSTANT_BODY_ConstantBufferObjectControlState_start  64
#define GEN7_3DSTATE_CONSTANT_BODY_ConstantBufferObjectControlState_start  64

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_BODY_ConstantBufferObjectControlState_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 64;
      } else {
         return 64;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_BODY::Read Length */


#define GEN10_3DSTATE_CONSTANT_BODY_ReadLength_bits  16
#define GEN9_3DSTATE_CONSTANT_BODY_ReadLength_bits  16
#define GEN8_3DSTATE_CONSTANT_BODY_ReadLength_bits  16
#define GEN75_3DSTATE_CONSTANT_BODY_ReadLength_bits  16
#define GEN7_3DSTATE_CONSTANT_BODY_ReadLength_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_BODY_ReadLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_BODY_ReadLength_start  0
#define GEN9_3DSTATE_CONSTANT_BODY_ReadLength_start  0
#define GEN8_3DSTATE_CONSTANT_BODY_ReadLength_start  0
#define GEN75_3DSTATE_CONSTANT_BODY_ReadLength_start  0
#define GEN7_3DSTATE_CONSTANT_BODY_ReadLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_BODY_ReadLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_COLOR */


#define GEN5_3DSTATE_CONSTANT_COLOR_length  5
#define GEN45_3DSTATE_CONSTANT_COLOR_length  5
#define GEN4_3DSTATE_CONSTANT_COLOR_length  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 5;
   case 4:
      if (devinfo->is_g4x) {
         return 5;
      } else {
         return 5;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_COLOR::3D Command Opcode */


#define GEN5_3DSTATE_CONSTANT_COLOR_3DCommandOpcode_bits  3
#define GEN45_3DSTATE_CONSTANT_COLOR_3DCommandOpcode_bits  3
#define GEN4_3DSTATE_CONSTANT_COLOR_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 3;
   case 4:
      if (devinfo->is_g4x) {
         return 3;
      } else {
         return 3;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN5_3DSTATE_CONSTANT_COLOR_3DCommandOpcode_start  24
#define GEN45_3DSTATE_CONSTANT_COLOR_3DCommandOpcode_start  24
#define GEN4_3DSTATE_CONSTANT_COLOR_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 24;
   case 4:
      if (devinfo->is_g4x) {
         return 24;
      } else {
         return 24;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_COLOR::3D Command Sub Opcode */


#define GEN5_3DSTATE_CONSTANT_COLOR_3DCommandSubOpcode_bits  8
#define GEN45_3DSTATE_CONSTANT_COLOR_3DCommandSubOpcode_bits  8
#define GEN4_3DSTATE_CONSTANT_COLOR_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 8;
   case 4:
      if (devinfo->is_g4x) {
         return 8;
      } else {
         return 8;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN5_3DSTATE_CONSTANT_COLOR_3DCommandSubOpcode_start  16
#define GEN45_3DSTATE_CONSTANT_COLOR_3DCommandSubOpcode_start  16
#define GEN4_3DSTATE_CONSTANT_COLOR_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 16;
   case 4:
      if (devinfo->is_g4x) {
         return 16;
      } else {
         return 16;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_COLOR::Blend Constant Color Alpha */


#define GEN5_3DSTATE_CONSTANT_COLOR_BlendConstantColorAlpha_bits  32
#define GEN45_3DSTATE_CONSTANT_COLOR_BlendConstantColorAlpha_bits  32
#define GEN4_3DSTATE_CONSTANT_COLOR_BlendConstantColorAlpha_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_BlendConstantColorAlpha_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 32;
   case 4:
      if (devinfo->is_g4x) {
         return 32;
      } else {
         return 32;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN5_3DSTATE_CONSTANT_COLOR_BlendConstantColorAlpha_start  128
#define GEN45_3DSTATE_CONSTANT_COLOR_BlendConstantColorAlpha_start  128
#define GEN4_3DSTATE_CONSTANT_COLOR_BlendConstantColorAlpha_start  128

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_BlendConstantColorAlpha_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 128;
   case 4:
      if (devinfo->is_g4x) {
         return 128;
      } else {
         return 128;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_COLOR::Blend Constant Color Blue */


#define GEN5_3DSTATE_CONSTANT_COLOR_BlendConstantColorBlue_bits  32
#define GEN45_3DSTATE_CONSTANT_COLOR_BlendConstantColorBlue_bits  32
#define GEN4_3DSTATE_CONSTANT_COLOR_BlendConstantColorBlue_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_BlendConstantColorBlue_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 32;
   case 4:
      if (devinfo->is_g4x) {
         return 32;
      } else {
         return 32;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN5_3DSTATE_CONSTANT_COLOR_BlendConstantColorBlue_start  96
#define GEN45_3DSTATE_CONSTANT_COLOR_BlendConstantColorBlue_start  96
#define GEN4_3DSTATE_CONSTANT_COLOR_BlendConstantColorBlue_start  96

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_BlendConstantColorBlue_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 96;
   case 4:
      if (devinfo->is_g4x) {
         return 96;
      } else {
         return 96;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_COLOR::Blend Constant Color Green */


#define GEN5_3DSTATE_CONSTANT_COLOR_BlendConstantColorGreen_bits  32
#define GEN45_3DSTATE_CONSTANT_COLOR_BlendConstantColorGreen_bits  32
#define GEN4_3DSTATE_CONSTANT_COLOR_BlendConstantColorGreen_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_BlendConstantColorGreen_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 32;
   case 4:
      if (devinfo->is_g4x) {
         return 32;
      } else {
         return 32;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN5_3DSTATE_CONSTANT_COLOR_BlendConstantColorGreen_start  64
#define GEN45_3DSTATE_CONSTANT_COLOR_BlendConstantColorGreen_start  64
#define GEN4_3DSTATE_CONSTANT_COLOR_BlendConstantColorGreen_start  64

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_BlendConstantColorGreen_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 64;
   case 4:
      if (devinfo->is_g4x) {
         return 64;
      } else {
         return 64;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_COLOR::Blend Constant Color Red */


#define GEN5_3DSTATE_CONSTANT_COLOR_BlendConstantColorRed_bits  32
#define GEN45_3DSTATE_CONSTANT_COLOR_BlendConstantColorRed_bits  32
#define GEN4_3DSTATE_CONSTANT_COLOR_BlendConstantColorRed_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_BlendConstantColorRed_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 32;
   case 4:
      if (devinfo->is_g4x) {
         return 32;
      } else {
         return 32;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN5_3DSTATE_CONSTANT_COLOR_BlendConstantColorRed_start  32
#define GEN45_3DSTATE_CONSTANT_COLOR_BlendConstantColorRed_start  32
#define GEN4_3DSTATE_CONSTANT_COLOR_BlendConstantColorRed_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_BlendConstantColorRed_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 32;
   case 4:
      if (devinfo->is_g4x) {
         return 32;
      } else {
         return 32;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_COLOR::Command SubType */


#define GEN5_3DSTATE_CONSTANT_COLOR_CommandSubType_bits  2
#define GEN45_3DSTATE_CONSTANT_COLOR_CommandSubType_bits  2
#define GEN4_3DSTATE_CONSTANT_COLOR_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 2;
   case 4:
      if (devinfo->is_g4x) {
         return 2;
      } else {
         return 2;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN5_3DSTATE_CONSTANT_COLOR_CommandSubType_start  27
#define GEN45_3DSTATE_CONSTANT_COLOR_CommandSubType_start  27
#define GEN4_3DSTATE_CONSTANT_COLOR_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 27;
   case 4:
      if (devinfo->is_g4x) {
         return 27;
      } else {
         return 27;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_COLOR::Command Type */


#define GEN5_3DSTATE_CONSTANT_COLOR_CommandType_bits  3
#define GEN45_3DSTATE_CONSTANT_COLOR_CommandType_bits  3
#define GEN4_3DSTATE_CONSTANT_COLOR_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 3;
   case 4:
      if (devinfo->is_g4x) {
         return 3;
      } else {
         return 3;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN5_3DSTATE_CONSTANT_COLOR_CommandType_start  29
#define GEN45_3DSTATE_CONSTANT_COLOR_CommandType_start  29
#define GEN4_3DSTATE_CONSTANT_COLOR_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 29;
   case 4:
      if (devinfo->is_g4x) {
         return 29;
      } else {
         return 29;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_COLOR::DWord Length */


#define GEN5_3DSTATE_CONSTANT_COLOR_DWordLength_bits  8
#define GEN45_3DSTATE_CONSTANT_COLOR_DWordLength_bits  8
#define GEN4_3DSTATE_CONSTANT_COLOR_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 8;
   case 4:
      if (devinfo->is_g4x) {
         return 8;
      } else {
         return 8;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN5_3DSTATE_CONSTANT_COLOR_DWordLength_start  0
#define GEN45_3DSTATE_CONSTANT_COLOR_DWordLength_start  0
#define GEN4_3DSTATE_CONSTANT_COLOR_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_DS */


#define GEN10_3DSTATE_CONSTANT_DS_length  11
#define GEN9_3DSTATE_CONSTANT_DS_length  11
#define GEN8_3DSTATE_CONSTANT_DS_length  11
#define GEN75_3DSTATE_CONSTANT_DS_length  7
#define GEN7_3DSTATE_CONSTANT_DS_length  7

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_DS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 11;
   case 9: return 11;
   case 8: return 11;
   case 7:
      if (devinfo->is_haswell) {
         return 7;
      } else {
         return 7;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_DS::3D Command Opcode */


#define GEN10_3DSTATE_CONSTANT_DS_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_CONSTANT_DS_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_CONSTANT_DS_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_CONSTANT_DS_3DCommandOpcode_bits  3
#define GEN7_3DSTATE_CONSTANT_DS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_DS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_DS_3DCommandOpcode_start  24
#define GEN9_3DSTATE_CONSTANT_DS_3DCommandOpcode_start  24
#define GEN8_3DSTATE_CONSTANT_DS_3DCommandOpcode_start  24
#define GEN75_3DSTATE_CONSTANT_DS_3DCommandOpcode_start  24
#define GEN7_3DSTATE_CONSTANT_DS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_DS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 24;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_DS::3D Command Sub Opcode */


#define GEN10_3DSTATE_CONSTANT_DS_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_CONSTANT_DS_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_CONSTANT_DS_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_CONSTANT_DS_3DCommandSubOpcode_bits  8
#define GEN7_3DSTATE_CONSTANT_DS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_DS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_DS_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_CONSTANT_DS_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_CONSTANT_DS_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_CONSTANT_DS_3DCommandSubOpcode_start  16
#define GEN7_3DSTATE_CONSTANT_DS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_DS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_DS::Command SubType */


#define GEN10_3DSTATE_CONSTANT_DS_CommandSubType_bits  2
#define GEN9_3DSTATE_CONSTANT_DS_CommandSubType_bits  2
#define GEN8_3DSTATE_CONSTANT_DS_CommandSubType_bits  2
#define GEN75_3DSTATE_CONSTANT_DS_CommandSubType_bits  2
#define GEN7_3DSTATE_CONSTANT_DS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_DS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_DS_CommandSubType_start  27
#define GEN9_3DSTATE_CONSTANT_DS_CommandSubType_start  27
#define GEN8_3DSTATE_CONSTANT_DS_CommandSubType_start  27
#define GEN75_3DSTATE_CONSTANT_DS_CommandSubType_start  27
#define GEN7_3DSTATE_CONSTANT_DS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_DS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 27;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_DS::Command Type */


#define GEN10_3DSTATE_CONSTANT_DS_CommandType_bits  3
#define GEN9_3DSTATE_CONSTANT_DS_CommandType_bits  3
#define GEN8_3DSTATE_CONSTANT_DS_CommandType_bits  3
#define GEN75_3DSTATE_CONSTANT_DS_CommandType_bits  3
#define GEN7_3DSTATE_CONSTANT_DS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_DS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_DS_CommandType_start  29
#define GEN9_3DSTATE_CONSTANT_DS_CommandType_start  29
#define GEN8_3DSTATE_CONSTANT_DS_CommandType_start  29
#define GEN75_3DSTATE_CONSTANT_DS_CommandType_start  29
#define GEN7_3DSTATE_CONSTANT_DS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_DS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 29;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_DS::Constant Body */


#define GEN10_3DSTATE_CONSTANT_DS_ConstantBody_bits  320
#define GEN9_3DSTATE_CONSTANT_DS_ConstantBody_bits  320
#define GEN8_3DSTATE_CONSTANT_DS_ConstantBody_bits  320
#define GEN75_3DSTATE_CONSTANT_DS_ConstantBody_bits  192
#define GEN7_3DSTATE_CONSTANT_DS_ConstantBody_bits  192

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_DS_ConstantBody_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 320;
   case 9: return 320;
   case 8: return 320;
   case 7:
      if (devinfo->is_haswell) {
         return 192;
      } else {
         return 192;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_DS_ConstantBody_start  32
#define GEN9_3DSTATE_CONSTANT_DS_ConstantBody_start  32
#define GEN8_3DSTATE_CONSTANT_DS_ConstantBody_start  32
#define GEN75_3DSTATE_CONSTANT_DS_ConstantBody_start  32
#define GEN7_3DSTATE_CONSTANT_DS_ConstantBody_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_DS_ConstantBody_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 32;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_DS::Constant Buffer Object Control State */


#define GEN10_3DSTATE_CONSTANT_DS_ConstantBufferObjectControlState_bits  7
#define GEN9_3DSTATE_CONSTANT_DS_ConstantBufferObjectControlState_bits  7
#define GEN8_3DSTATE_CONSTANT_DS_ConstantBufferObjectControlState_bits  7

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_DS_ConstantBufferObjectControlState_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 7;
   case 9: return 7;
   case 8: return 7;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_DS_ConstantBufferObjectControlState_start  8
#define GEN9_3DSTATE_CONSTANT_DS_ConstantBufferObjectControlState_start  8
#define GEN8_3DSTATE_CONSTANT_DS_ConstantBufferObjectControlState_start  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_DS_ConstantBufferObjectControlState_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_DS::DWord Length */


#define GEN10_3DSTATE_CONSTANT_DS_DWordLength_bits  8
#define GEN9_3DSTATE_CONSTANT_DS_DWordLength_bits  8
#define GEN8_3DSTATE_CONSTANT_DS_DWordLength_bits  8
#define GEN75_3DSTATE_CONSTANT_DS_DWordLength_bits  8
#define GEN7_3DSTATE_CONSTANT_DS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_DS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_DS_DWordLength_start  0
#define GEN9_3DSTATE_CONSTANT_DS_DWordLength_start  0
#define GEN8_3DSTATE_CONSTANT_DS_DWordLength_start  0
#define GEN75_3DSTATE_CONSTANT_DS_DWordLength_start  0
#define GEN7_3DSTATE_CONSTANT_DS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_DS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_GS */


#define GEN10_3DSTATE_CONSTANT_GS_length  11
#define GEN9_3DSTATE_CONSTANT_GS_length  11
#define GEN8_3DSTATE_CONSTANT_GS_length  11
#define GEN75_3DSTATE_CONSTANT_GS_length  7
#define GEN7_3DSTATE_CONSTANT_GS_length  7
#define GEN6_3DSTATE_CONSTANT_GS_length  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 11;
   case 9: return 11;
   case 8: return 11;
   case 7:
      if (devinfo->is_haswell) {
         return 7;
      } else {
         return 7;
      }
   case 6: return 5;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_GS::3D Command Opcode */


#define GEN10_3DSTATE_CONSTANT_GS_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_CONSTANT_GS_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_CONSTANT_GS_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_CONSTANT_GS_3DCommandOpcode_bits  3
#define GEN7_3DSTATE_CONSTANT_GS_3DCommandOpcode_bits  3
#define GEN6_3DSTATE_CONSTANT_GS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_GS_3DCommandOpcode_start  24
#define GEN9_3DSTATE_CONSTANT_GS_3DCommandOpcode_start  24
#define GEN8_3DSTATE_CONSTANT_GS_3DCommandOpcode_start  24
#define GEN75_3DSTATE_CONSTANT_GS_3DCommandOpcode_start  24
#define GEN7_3DSTATE_CONSTANT_GS_3DCommandOpcode_start  24
#define GEN6_3DSTATE_CONSTANT_GS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 24;
      }
   case 6: return 24;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_GS::3D Command Sub Opcode */


#define GEN10_3DSTATE_CONSTANT_GS_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_CONSTANT_GS_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_CONSTANT_GS_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_CONSTANT_GS_3DCommandSubOpcode_bits  8
#define GEN7_3DSTATE_CONSTANT_GS_3DCommandSubOpcode_bits  8
#define GEN6_3DSTATE_CONSTANT_GS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_GS_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_CONSTANT_GS_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_CONSTANT_GS_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_CONSTANT_GS_3DCommandSubOpcode_start  16
#define GEN7_3DSTATE_CONSTANT_GS_3DCommandSubOpcode_start  16
#define GEN6_3DSTATE_CONSTANT_GS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 16;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_GS::Buffer 0 Valid */


#define GEN6_3DSTATE_CONSTANT_GS_Buffer0Valid_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_Buffer0Valid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_GS_Buffer0Valid_start  12

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_Buffer0Valid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 12;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_GS::Buffer 1 Valid */


#define GEN6_3DSTATE_CONSTANT_GS_Buffer1Valid_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_Buffer1Valid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_GS_Buffer1Valid_start  13

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_Buffer1Valid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 13;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_GS::Buffer 2 Valid */


#define GEN6_3DSTATE_CONSTANT_GS_Buffer2Valid_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_Buffer2Valid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_GS_Buffer2Valid_start  14

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_Buffer2Valid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 14;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_GS::Buffer 3 Valid */


#define GEN6_3DSTATE_CONSTANT_GS_Buffer3Valid_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_Buffer3Valid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_GS_Buffer3Valid_start  15

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_Buffer3Valid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 15;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_GS::Command SubType */


#define GEN10_3DSTATE_CONSTANT_GS_CommandSubType_bits  2
#define GEN9_3DSTATE_CONSTANT_GS_CommandSubType_bits  2
#define GEN8_3DSTATE_CONSTANT_GS_CommandSubType_bits  2
#define GEN75_3DSTATE_CONSTANT_GS_CommandSubType_bits  2
#define GEN7_3DSTATE_CONSTANT_GS_CommandSubType_bits  2
#define GEN6_3DSTATE_CONSTANT_GS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 2;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_GS_CommandSubType_start  27
#define GEN9_3DSTATE_CONSTANT_GS_CommandSubType_start  27
#define GEN8_3DSTATE_CONSTANT_GS_CommandSubType_start  27
#define GEN75_3DSTATE_CONSTANT_GS_CommandSubType_start  27
#define GEN7_3DSTATE_CONSTANT_GS_CommandSubType_start  27
#define GEN6_3DSTATE_CONSTANT_GS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 27;
      }
   case 6: return 27;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_GS::Command Type */


#define GEN10_3DSTATE_CONSTANT_GS_CommandType_bits  3
#define GEN9_3DSTATE_CONSTANT_GS_CommandType_bits  3
#define GEN8_3DSTATE_CONSTANT_GS_CommandType_bits  3
#define GEN75_3DSTATE_CONSTANT_GS_CommandType_bits  3
#define GEN7_3DSTATE_CONSTANT_GS_CommandType_bits  3
#define GEN6_3DSTATE_CONSTANT_GS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_GS_CommandType_start  29
#define GEN9_3DSTATE_CONSTANT_GS_CommandType_start  29
#define GEN8_3DSTATE_CONSTANT_GS_CommandType_start  29
#define GEN75_3DSTATE_CONSTANT_GS_CommandType_start  29
#define GEN7_3DSTATE_CONSTANT_GS_CommandType_start  29
#define GEN6_3DSTATE_CONSTANT_GS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 29;
      }
   case 6: return 29;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_GS::Constant Body */


#define GEN10_3DSTATE_CONSTANT_GS_ConstantBody_bits  320
#define GEN9_3DSTATE_CONSTANT_GS_ConstantBody_bits  320
#define GEN8_3DSTATE_CONSTANT_GS_ConstantBody_bits  320
#define GEN75_3DSTATE_CONSTANT_GS_ConstantBody_bits  192
#define GEN7_3DSTATE_CONSTANT_GS_ConstantBody_bits  192

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_ConstantBody_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 320;
   case 9: return 320;
   case 8: return 320;
   case 7:
      if (devinfo->is_haswell) {
         return 192;
      } else {
         return 192;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_GS_ConstantBody_start  32
#define GEN9_3DSTATE_CONSTANT_GS_ConstantBody_start  32
#define GEN8_3DSTATE_CONSTANT_GS_ConstantBody_start  32
#define GEN75_3DSTATE_CONSTANT_GS_ConstantBody_start  32
#define GEN7_3DSTATE_CONSTANT_GS_ConstantBody_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_ConstantBody_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 32;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_GS::Constant Buffer Object Control State */


#define GEN10_3DSTATE_CONSTANT_GS_ConstantBufferObjectControlState_bits  7
#define GEN9_3DSTATE_CONSTANT_GS_ConstantBufferObjectControlState_bits  7
#define GEN8_3DSTATE_CONSTANT_GS_ConstantBufferObjectControlState_bits  7
#define GEN6_3DSTATE_CONSTANT_GS_ConstantBufferObjectControlState_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_ConstantBufferObjectControlState_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 7;
   case 9: return 7;
   case 8: return 7;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 4;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_GS_ConstantBufferObjectControlState_start  8
#define GEN9_3DSTATE_CONSTANT_GS_ConstantBufferObjectControlState_start  8
#define GEN8_3DSTATE_CONSTANT_GS_ConstantBufferObjectControlState_start  8
#define GEN6_3DSTATE_CONSTANT_GS_ConstantBufferObjectControlState_start  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_ConstantBufferObjectControlState_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 8;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_GS::DWord Length */


#define GEN10_3DSTATE_CONSTANT_GS_DWordLength_bits  8
#define GEN9_3DSTATE_CONSTANT_GS_DWordLength_bits  8
#define GEN8_3DSTATE_CONSTANT_GS_DWordLength_bits  8
#define GEN75_3DSTATE_CONSTANT_GS_DWordLength_bits  8
#define GEN7_3DSTATE_CONSTANT_GS_DWordLength_bits  8
#define GEN6_3DSTATE_CONSTANT_GS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_GS_DWordLength_start  0
#define GEN9_3DSTATE_CONSTANT_GS_DWordLength_start  0
#define GEN8_3DSTATE_CONSTANT_GS_DWordLength_start  0
#define GEN75_3DSTATE_CONSTANT_GS_DWordLength_start  0
#define GEN7_3DSTATE_CONSTANT_GS_DWordLength_start  0
#define GEN6_3DSTATE_CONSTANT_GS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_GS::GS Constant Buffer 0 Read Length */


#define GEN6_3DSTATE_CONSTANT_GS_GSConstantBuffer0ReadLength_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_GSConstantBuffer0ReadLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 5;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_GS_GSConstantBuffer0ReadLength_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_GSConstantBuffer0ReadLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 32;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_GS::GS Constant Buffer 1 Read Length */


#define GEN6_3DSTATE_CONSTANT_GS_GSConstantBuffer1ReadLength_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_GSConstantBuffer1ReadLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 5;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_GS_GSConstantBuffer1ReadLength_start  64

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_GSConstantBuffer1ReadLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 64;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_GS::GS Constant Buffer 2 Read Length */


#define GEN6_3DSTATE_CONSTANT_GS_GSConstantBuffer2ReadLength_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_GSConstantBuffer2ReadLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 5;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_GS_GSConstantBuffer2ReadLength_start  96

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_GSConstantBuffer2ReadLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 96;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_GS::GS Constant Buffer 3 Read Length */


#define GEN6_3DSTATE_CONSTANT_GS_GSConstantBuffer3ReadLength_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_GSConstantBuffer3ReadLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 5;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_GS_GSConstantBuffer3ReadLength_start  128

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_GSConstantBuffer3ReadLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 128;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_GS::Pointer to GS Constant Buffer 0 */


#define GEN6_3DSTATE_CONSTANT_GS_PointertoGSConstantBuffer0_bits  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_PointertoGSConstantBuffer0_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 27;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_GS_PointertoGSConstantBuffer0_start  37

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_PointertoGSConstantBuffer0_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 37;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_GS::Pointer to GS Constant Buffer 1 */


#define GEN6_3DSTATE_CONSTANT_GS_PointertoGSConstantBuffer1_bits  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_PointertoGSConstantBuffer1_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 27;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_GS_PointertoGSConstantBuffer1_start  69

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_PointertoGSConstantBuffer1_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 69;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_GS::Pointer to GS Constant Buffer 2 */


#define GEN6_3DSTATE_CONSTANT_GS_PointertoGSConstantBuffer2_bits  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_PointertoGSConstantBuffer2_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 27;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_GS_PointertoGSConstantBuffer2_start  101

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_PointertoGSConstantBuffer2_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 101;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_GS::Pointer to GS Constant Buffer 3 */


#define GEN6_3DSTATE_CONSTANT_GS_PointertoGSConstantBuffer3_bits  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_PointertoGSConstantBuffer3_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 27;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_GS_PointertoGSConstantBuffer3_start  133

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_PointertoGSConstantBuffer3_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 133;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_HS */


#define GEN10_3DSTATE_CONSTANT_HS_length  11
#define GEN9_3DSTATE_CONSTANT_HS_length  11
#define GEN8_3DSTATE_CONSTANT_HS_length  11
#define GEN75_3DSTATE_CONSTANT_HS_length  7
#define GEN7_3DSTATE_CONSTANT_HS_length  7

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_HS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 11;
   case 9: return 11;
   case 8: return 11;
   case 7:
      if (devinfo->is_haswell) {
         return 7;
      } else {
         return 7;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_HS::3D Command Opcode */


#define GEN10_3DSTATE_CONSTANT_HS_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_CONSTANT_HS_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_CONSTANT_HS_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_CONSTANT_HS_3DCommandOpcode_bits  3
#define GEN7_3DSTATE_CONSTANT_HS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_HS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_HS_3DCommandOpcode_start  24
#define GEN9_3DSTATE_CONSTANT_HS_3DCommandOpcode_start  24
#define GEN8_3DSTATE_CONSTANT_HS_3DCommandOpcode_start  24
#define GEN75_3DSTATE_CONSTANT_HS_3DCommandOpcode_start  24
#define GEN7_3DSTATE_CONSTANT_HS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_HS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 24;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_HS::3D Command Sub Opcode */


#define GEN10_3DSTATE_CONSTANT_HS_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_CONSTANT_HS_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_CONSTANT_HS_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_CONSTANT_HS_3DCommandSubOpcode_bits  8
#define GEN7_3DSTATE_CONSTANT_HS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_HS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_HS_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_CONSTANT_HS_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_CONSTANT_HS_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_CONSTANT_HS_3DCommandSubOpcode_start  16
#define GEN7_3DSTATE_CONSTANT_HS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_HS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_HS::Command SubType */


#define GEN10_3DSTATE_CONSTANT_HS_CommandSubType_bits  2
#define GEN9_3DSTATE_CONSTANT_HS_CommandSubType_bits  2
#define GEN8_3DSTATE_CONSTANT_HS_CommandSubType_bits  2
#define GEN75_3DSTATE_CONSTANT_HS_CommandSubType_bits  2
#define GEN7_3DSTATE_CONSTANT_HS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_HS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_HS_CommandSubType_start  27
#define GEN9_3DSTATE_CONSTANT_HS_CommandSubType_start  27
#define GEN8_3DSTATE_CONSTANT_HS_CommandSubType_start  27
#define GEN75_3DSTATE_CONSTANT_HS_CommandSubType_start  27
#define GEN7_3DSTATE_CONSTANT_HS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_HS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 27;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_HS::Command Type */


#define GEN10_3DSTATE_CONSTANT_HS_CommandType_bits  3
#define GEN9_3DSTATE_CONSTANT_HS_CommandType_bits  3
#define GEN8_3DSTATE_CONSTANT_HS_CommandType_bits  3
#define GEN75_3DSTATE_CONSTANT_HS_CommandType_bits  3
#define GEN7_3DSTATE_CONSTANT_HS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_HS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_HS_CommandType_start  29
#define GEN9_3DSTATE_CONSTANT_HS_CommandType_start  29
#define GEN8_3DSTATE_CONSTANT_HS_CommandType_start  29
#define GEN75_3DSTATE_CONSTANT_HS_CommandType_start  29
#define GEN7_3DSTATE_CONSTANT_HS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_HS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 29;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_HS::Constant Body */


#define GEN10_3DSTATE_CONSTANT_HS_ConstantBody_bits  320
#define GEN9_3DSTATE_CONSTANT_HS_ConstantBody_bits  320
#define GEN8_3DSTATE_CONSTANT_HS_ConstantBody_bits  320
#define GEN75_3DSTATE_CONSTANT_HS_ConstantBody_bits  192
#define GEN7_3DSTATE_CONSTANT_HS_ConstantBody_bits  192

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_HS_ConstantBody_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 320;
   case 9: return 320;
   case 8: return 320;
   case 7:
      if (devinfo->is_haswell) {
         return 192;
      } else {
         return 192;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_HS_ConstantBody_start  32
#define GEN9_3DSTATE_CONSTANT_HS_ConstantBody_start  32
#define GEN8_3DSTATE_CONSTANT_HS_ConstantBody_start  32
#define GEN75_3DSTATE_CONSTANT_HS_ConstantBody_start  32
#define GEN7_3DSTATE_CONSTANT_HS_ConstantBody_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_HS_ConstantBody_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 32;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_HS::Constant Buffer Object Control State */


#define GEN10_3DSTATE_CONSTANT_HS_ConstantBufferObjectControlState_bits  7
#define GEN9_3DSTATE_CONSTANT_HS_ConstantBufferObjectControlState_bits  7
#define GEN8_3DSTATE_CONSTANT_HS_ConstantBufferObjectControlState_bits  7

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_HS_ConstantBufferObjectControlState_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 7;
   case 9: return 7;
   case 8: return 7;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_HS_ConstantBufferObjectControlState_start  8
#define GEN9_3DSTATE_CONSTANT_HS_ConstantBufferObjectControlState_start  8
#define GEN8_3DSTATE_CONSTANT_HS_ConstantBufferObjectControlState_start  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_HS_ConstantBufferObjectControlState_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_HS::DWord Length */


#define GEN10_3DSTATE_CONSTANT_HS_DWordLength_bits  8
#define GEN9_3DSTATE_CONSTANT_HS_DWordLength_bits  8
#define GEN8_3DSTATE_CONSTANT_HS_DWordLength_bits  8
#define GEN75_3DSTATE_CONSTANT_HS_DWordLength_bits  8
#define GEN7_3DSTATE_CONSTANT_HS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_HS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_HS_DWordLength_start  0
#define GEN9_3DSTATE_CONSTANT_HS_DWordLength_start  0
#define GEN8_3DSTATE_CONSTANT_HS_DWordLength_start  0
#define GEN75_3DSTATE_CONSTANT_HS_DWordLength_start  0
#define GEN7_3DSTATE_CONSTANT_HS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_HS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_PS */


#define GEN10_3DSTATE_CONSTANT_PS_length  11
#define GEN9_3DSTATE_CONSTANT_PS_length  11
#define GEN8_3DSTATE_CONSTANT_PS_length  11
#define GEN75_3DSTATE_CONSTANT_PS_length  7
#define GEN7_3DSTATE_CONSTANT_PS_length  7
#define GEN6_3DSTATE_CONSTANT_PS_length  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 11;
   case 9: return 11;
   case 8: return 11;
   case 7:
      if (devinfo->is_haswell) {
         return 7;
      } else {
         return 7;
      }
   case 6: return 5;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_PS::3D Command Opcode */


#define GEN10_3DSTATE_CONSTANT_PS_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_CONSTANT_PS_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_CONSTANT_PS_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_CONSTANT_PS_3DCommandOpcode_bits  3
#define GEN7_3DSTATE_CONSTANT_PS_3DCommandOpcode_bits  3
#define GEN6_3DSTATE_CONSTANT_PS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_PS_3DCommandOpcode_start  24
#define GEN9_3DSTATE_CONSTANT_PS_3DCommandOpcode_start  24
#define GEN8_3DSTATE_CONSTANT_PS_3DCommandOpcode_start  24
#define GEN75_3DSTATE_CONSTANT_PS_3DCommandOpcode_start  24
#define GEN7_3DSTATE_CONSTANT_PS_3DCommandOpcode_start  24
#define GEN6_3DSTATE_CONSTANT_PS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 24;
      }
   case 6: return 24;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_PS::3D Command Sub Opcode */


#define GEN10_3DSTATE_CONSTANT_PS_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_CONSTANT_PS_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_CONSTANT_PS_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_CONSTANT_PS_3DCommandSubOpcode_bits  8
#define GEN7_3DSTATE_CONSTANT_PS_3DCommandSubOpcode_bits  8
#define GEN6_3DSTATE_CONSTANT_PS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_PS_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_CONSTANT_PS_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_CONSTANT_PS_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_CONSTANT_PS_3DCommandSubOpcode_start  16
#define GEN7_3DSTATE_CONSTANT_PS_3DCommandSubOpcode_start  16
#define GEN6_3DSTATE_CONSTANT_PS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 16;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_PS::Buffer 0 Valid */


#define GEN6_3DSTATE_CONSTANT_PS_Buffer0Valid_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_Buffer0Valid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_PS_Buffer0Valid_start  12

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_Buffer0Valid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 12;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_PS::Buffer 1 Valid */


#define GEN6_3DSTATE_CONSTANT_PS_Buffer1Valid_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_Buffer1Valid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_PS_Buffer1Valid_start  13

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_Buffer1Valid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 13;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_PS::Buffer 2 Valid */


#define GEN6_3DSTATE_CONSTANT_PS_Buffer2Valid_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_Buffer2Valid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_PS_Buffer2Valid_start  14

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_Buffer2Valid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 14;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_PS::Buffer 3 Valid */


#define GEN6_3DSTATE_CONSTANT_PS_Buffer3Valid_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_Buffer3Valid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_PS_Buffer3Valid_start  15

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_Buffer3Valid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 15;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_PS::Command SubType */


#define GEN10_3DSTATE_CONSTANT_PS_CommandSubType_bits  2
#define GEN9_3DSTATE_CONSTANT_PS_CommandSubType_bits  2
#define GEN8_3DSTATE_CONSTANT_PS_CommandSubType_bits  2
#define GEN75_3DSTATE_CONSTANT_PS_CommandSubType_bits  2
#define GEN7_3DSTATE_CONSTANT_PS_CommandSubType_bits  2
#define GEN6_3DSTATE_CONSTANT_PS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 2;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_PS_CommandSubType_start  27
#define GEN9_3DSTATE_CONSTANT_PS_CommandSubType_start  27
#define GEN8_3DSTATE_CONSTANT_PS_CommandSubType_start  27
#define GEN75_3DSTATE_CONSTANT_PS_CommandSubType_start  27
#define GEN7_3DSTATE_CONSTANT_PS_CommandSubType_start  27
#define GEN6_3DSTATE_CONSTANT_PS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 27;
      }
   case 6: return 27;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_PS::Command Type */


#define GEN10_3DSTATE_CONSTANT_PS_CommandType_bits  3
#define GEN9_3DSTATE_CONSTANT_PS_CommandType_bits  3
#define GEN8_3DSTATE_CONSTANT_PS_CommandType_bits  3
#define GEN75_3DSTATE_CONSTANT_PS_CommandType_bits  3
#define GEN7_3DSTATE_CONSTANT_PS_CommandType_bits  3
#define GEN6_3DSTATE_CONSTANT_PS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_PS_CommandType_start  29
#define GEN9_3DSTATE_CONSTANT_PS_CommandType_start  29
#define GEN8_3DSTATE_CONSTANT_PS_CommandType_start  29
#define GEN75_3DSTATE_CONSTANT_PS_CommandType_start  29
#define GEN7_3DSTATE_CONSTANT_PS_CommandType_start  29
#define GEN6_3DSTATE_CONSTANT_PS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 29;
      }
   case 6: return 29;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_PS::Constant Body */


#define GEN10_3DSTATE_CONSTANT_PS_ConstantBody_bits  320
#define GEN9_3DSTATE_CONSTANT_PS_ConstantBody_bits  320
#define GEN8_3DSTATE_CONSTANT_PS_ConstantBody_bits  320
#define GEN75_3DSTATE_CONSTANT_PS_ConstantBody_bits  192
#define GEN7_3DSTATE_CONSTANT_PS_ConstantBody_bits  192

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_ConstantBody_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 320;
   case 9: return 320;
   case 8: return 320;
   case 7:
      if (devinfo->is_haswell) {
         return 192;
      } else {
         return 192;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_PS_ConstantBody_start  32
#define GEN9_3DSTATE_CONSTANT_PS_ConstantBody_start  32
#define GEN8_3DSTATE_CONSTANT_PS_ConstantBody_start  32
#define GEN75_3DSTATE_CONSTANT_PS_ConstantBody_start  32
#define GEN7_3DSTATE_CONSTANT_PS_ConstantBody_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_ConstantBody_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 32;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_PS::Constant Buffer Object Control State */


#define GEN10_3DSTATE_CONSTANT_PS_ConstantBufferObjectControlState_bits  7
#define GEN9_3DSTATE_CONSTANT_PS_ConstantBufferObjectControlState_bits  7
#define GEN8_3DSTATE_CONSTANT_PS_ConstantBufferObjectControlState_bits  7
#define GEN6_3DSTATE_CONSTANT_PS_ConstantBufferObjectControlState_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_ConstantBufferObjectControlState_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 7;
   case 9: return 7;
   case 8: return 7;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 4;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_PS_ConstantBufferObjectControlState_start  8
#define GEN9_3DSTATE_CONSTANT_PS_ConstantBufferObjectControlState_start  8
#define GEN8_3DSTATE_CONSTANT_PS_ConstantBufferObjectControlState_start  8
#define GEN6_3DSTATE_CONSTANT_PS_ConstantBufferObjectControlState_start  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_ConstantBufferObjectControlState_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 8;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_PS::DWord Length */


#define GEN10_3DSTATE_CONSTANT_PS_DWordLength_bits  8
#define GEN9_3DSTATE_CONSTANT_PS_DWordLength_bits  8
#define GEN8_3DSTATE_CONSTANT_PS_DWordLength_bits  8
#define GEN75_3DSTATE_CONSTANT_PS_DWordLength_bits  8
#define GEN7_3DSTATE_CONSTANT_PS_DWordLength_bits  8
#define GEN6_3DSTATE_CONSTANT_PS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_PS_DWordLength_start  0
#define GEN9_3DSTATE_CONSTANT_PS_DWordLength_start  0
#define GEN8_3DSTATE_CONSTANT_PS_DWordLength_start  0
#define GEN75_3DSTATE_CONSTANT_PS_DWordLength_start  0
#define GEN7_3DSTATE_CONSTANT_PS_DWordLength_start  0
#define GEN6_3DSTATE_CONSTANT_PS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_PS::Disable Gather at Set Shader Hint */


#define GEN10_3DSTATE_CONSTANT_PS_DisableGatheratSetShaderHint_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_DisableGatheratSetShaderHint_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_PS_DisableGatheratSetShaderHint_start  15

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_DisableGatheratSetShaderHint_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 15;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_PS::PS Constant Buffer 0 Read Length */


#define GEN6_3DSTATE_CONSTANT_PS_PSConstantBuffer0ReadLength_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_PSConstantBuffer0ReadLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 5;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_PS_PSConstantBuffer0ReadLength_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_PSConstantBuffer0ReadLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 32;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_PS::PS Constant Buffer 1 Read Length */


#define GEN6_3DSTATE_CONSTANT_PS_PSConstantBuffer1ReadLength_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_PSConstantBuffer1ReadLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 5;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_PS_PSConstantBuffer1ReadLength_start  64

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_PSConstantBuffer1ReadLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 64;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_PS::PS Constant Buffer 2 Read Length */


#define GEN6_3DSTATE_CONSTANT_PS_PSConstantBuffer2ReadLength_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_PSConstantBuffer2ReadLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 5;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_PS_PSConstantBuffer2ReadLength_start  96

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_PSConstantBuffer2ReadLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 96;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_PS::PS Constant Buffer 3 Read Length */


#define GEN6_3DSTATE_CONSTANT_PS_PSConstantBuffer3ReadLength_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_PSConstantBuffer3ReadLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 5;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_PS_PSConstantBuffer3ReadLength_start  128

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_PSConstantBuffer3ReadLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 128;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_PS::Pointer to PS Constant Buffer 0 */


#define GEN6_3DSTATE_CONSTANT_PS_PointertoPSConstantBuffer0_bits  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_PointertoPSConstantBuffer0_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 27;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_PS_PointertoPSConstantBuffer0_start  37

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_PointertoPSConstantBuffer0_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 37;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_PS::Pointer to PS Constant Buffer 1 */


#define GEN6_3DSTATE_CONSTANT_PS_PointertoPSConstantBuffer1_bits  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_PointertoPSConstantBuffer1_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 27;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_PS_PointertoPSConstantBuffer1_start  69

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_PointertoPSConstantBuffer1_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 69;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_PS::Pointer to PS Constant Buffer 2 */


#define GEN6_3DSTATE_CONSTANT_PS_PointertoPSConstantBuffer2_bits  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_PointertoPSConstantBuffer2_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 27;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_PS_PointertoPSConstantBuffer2_start  101

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_PointertoPSConstantBuffer2_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 101;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_PS::Pointer to PS Constant Buffer 3 */


#define GEN6_3DSTATE_CONSTANT_PS_PointertoPSConstantBuffer3_bits  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_PointertoPSConstantBuffer3_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 27;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_PS_PointertoPSConstantBuffer3_start  133

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_PointertoPSConstantBuffer3_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 133;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_VS */


#define GEN10_3DSTATE_CONSTANT_VS_length  11
#define GEN9_3DSTATE_CONSTANT_VS_length  11
#define GEN8_3DSTATE_CONSTANT_VS_length  11
#define GEN75_3DSTATE_CONSTANT_VS_length  7
#define GEN7_3DSTATE_CONSTANT_VS_length  7
#define GEN6_3DSTATE_CONSTANT_VS_length  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 11;
   case 9: return 11;
   case 8: return 11;
   case 7:
      if (devinfo->is_haswell) {
         return 7;
      } else {
         return 7;
      }
   case 6: return 5;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_VS::3D Command Opcode */


#define GEN10_3DSTATE_CONSTANT_VS_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_CONSTANT_VS_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_CONSTANT_VS_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_CONSTANT_VS_3DCommandOpcode_bits  3
#define GEN7_3DSTATE_CONSTANT_VS_3DCommandOpcode_bits  3
#define GEN6_3DSTATE_CONSTANT_VS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_VS_3DCommandOpcode_start  24
#define GEN9_3DSTATE_CONSTANT_VS_3DCommandOpcode_start  24
#define GEN8_3DSTATE_CONSTANT_VS_3DCommandOpcode_start  24
#define GEN75_3DSTATE_CONSTANT_VS_3DCommandOpcode_start  24
#define GEN7_3DSTATE_CONSTANT_VS_3DCommandOpcode_start  24
#define GEN6_3DSTATE_CONSTANT_VS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 24;
      }
   case 6: return 24;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_VS::3D Command Sub Opcode */


#define GEN10_3DSTATE_CONSTANT_VS_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_CONSTANT_VS_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_CONSTANT_VS_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_CONSTANT_VS_3DCommandSubOpcode_bits  8
#define GEN7_3DSTATE_CONSTANT_VS_3DCommandSubOpcode_bits  8
#define GEN6_3DSTATE_CONSTANT_VS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_VS_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_CONSTANT_VS_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_CONSTANT_VS_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_CONSTANT_VS_3DCommandSubOpcode_start  16
#define GEN7_3DSTATE_CONSTANT_VS_3DCommandSubOpcode_start  16
#define GEN6_3DSTATE_CONSTANT_VS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 16;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_VS::Buffer 0 Valid */


#define GEN6_3DSTATE_CONSTANT_VS_Buffer0Valid_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_Buffer0Valid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_VS_Buffer0Valid_start  12

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_Buffer0Valid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 12;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_VS::Buffer 1 Valid */


#define GEN6_3DSTATE_CONSTANT_VS_Buffer1Valid_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_Buffer1Valid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_VS_Buffer1Valid_start  13

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_Buffer1Valid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 13;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_VS::Buffer 2 Valid */


#define GEN6_3DSTATE_CONSTANT_VS_Buffer2Valid_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_Buffer2Valid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_VS_Buffer2Valid_start  14

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_Buffer2Valid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 14;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_VS::Buffer 3 Valid */


#define GEN6_3DSTATE_CONSTANT_VS_Buffer3Valid_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_Buffer3Valid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_VS_Buffer3Valid_start  15

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_Buffer3Valid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 15;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_VS::Command SubType */


#define GEN10_3DSTATE_CONSTANT_VS_CommandSubType_bits  2
#define GEN9_3DSTATE_CONSTANT_VS_CommandSubType_bits  2
#define GEN8_3DSTATE_CONSTANT_VS_CommandSubType_bits  2
#define GEN75_3DSTATE_CONSTANT_VS_CommandSubType_bits  2
#define GEN7_3DSTATE_CONSTANT_VS_CommandSubType_bits  2
#define GEN6_3DSTATE_CONSTANT_VS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 2;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_VS_CommandSubType_start  27
#define GEN9_3DSTATE_CONSTANT_VS_CommandSubType_start  27
#define GEN8_3DSTATE_CONSTANT_VS_CommandSubType_start  27
#define GEN75_3DSTATE_CONSTANT_VS_CommandSubType_start  27
#define GEN7_3DSTATE_CONSTANT_VS_CommandSubType_start  27
#define GEN6_3DSTATE_CONSTANT_VS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 27;
      }
   case 6: return 27;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_VS::Command Type */


#define GEN10_3DSTATE_CONSTANT_VS_CommandType_bits  3
#define GEN9_3DSTATE_CONSTANT_VS_CommandType_bits  3
#define GEN8_3DSTATE_CONSTANT_VS_CommandType_bits  3
#define GEN75_3DSTATE_CONSTANT_VS_CommandType_bits  3
#define GEN7_3DSTATE_CONSTANT_VS_CommandType_bits  3
#define GEN6_3DSTATE_CONSTANT_VS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_VS_CommandType_start  29
#define GEN9_3DSTATE_CONSTANT_VS_CommandType_start  29
#define GEN8_3DSTATE_CONSTANT_VS_CommandType_start  29
#define GEN75_3DSTATE_CONSTANT_VS_CommandType_start  29
#define GEN7_3DSTATE_CONSTANT_VS_CommandType_start  29
#define GEN6_3DSTATE_CONSTANT_VS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 29;
      }
   case 6: return 29;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_VS::Constant Body */


#define GEN10_3DSTATE_CONSTANT_VS_ConstantBody_bits  320
#define GEN9_3DSTATE_CONSTANT_VS_ConstantBody_bits  320
#define GEN8_3DSTATE_CONSTANT_VS_ConstantBody_bits  320
#define GEN75_3DSTATE_CONSTANT_VS_ConstantBody_bits  192
#define GEN7_3DSTATE_CONSTANT_VS_ConstantBody_bits  192

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_ConstantBody_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 320;
   case 9: return 320;
   case 8: return 320;
   case 7:
      if (devinfo->is_haswell) {
         return 192;
      } else {
         return 192;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_VS_ConstantBody_start  32
#define GEN9_3DSTATE_CONSTANT_VS_ConstantBody_start  32
#define GEN8_3DSTATE_CONSTANT_VS_ConstantBody_start  32
#define GEN75_3DSTATE_CONSTANT_VS_ConstantBody_start  32
#define GEN7_3DSTATE_CONSTANT_VS_ConstantBody_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_ConstantBody_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 32;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_VS::Constant Buffer Object Control State */


#define GEN10_3DSTATE_CONSTANT_VS_ConstantBufferObjectControlState_bits  7
#define GEN9_3DSTATE_CONSTANT_VS_ConstantBufferObjectControlState_bits  7
#define GEN8_3DSTATE_CONSTANT_VS_ConstantBufferObjectControlState_bits  7
#define GEN6_3DSTATE_CONSTANT_VS_ConstantBufferObjectControlState_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_ConstantBufferObjectControlState_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 7;
   case 9: return 7;
   case 8: return 7;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 4;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_VS_ConstantBufferObjectControlState_start  8
#define GEN9_3DSTATE_CONSTANT_VS_ConstantBufferObjectControlState_start  8
#define GEN8_3DSTATE_CONSTANT_VS_ConstantBufferObjectControlState_start  8
#define GEN6_3DSTATE_CONSTANT_VS_ConstantBufferObjectControlState_start  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_ConstantBufferObjectControlState_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 8;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_VS::DWord Length */


#define GEN10_3DSTATE_CONSTANT_VS_DWordLength_bits  8
#define GEN9_3DSTATE_CONSTANT_VS_DWordLength_bits  8
#define GEN8_3DSTATE_CONSTANT_VS_DWordLength_bits  8
#define GEN75_3DSTATE_CONSTANT_VS_DWordLength_bits  8
#define GEN7_3DSTATE_CONSTANT_VS_DWordLength_bits  8
#define GEN6_3DSTATE_CONSTANT_VS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_CONSTANT_VS_DWordLength_start  0
#define GEN9_3DSTATE_CONSTANT_VS_DWordLength_start  0
#define GEN8_3DSTATE_CONSTANT_VS_DWordLength_start  0
#define GEN75_3DSTATE_CONSTANT_VS_DWordLength_start  0
#define GEN7_3DSTATE_CONSTANT_VS_DWordLength_start  0
#define GEN6_3DSTATE_CONSTANT_VS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_VS::Pointer to VS Constant Buffer 0 */


#define GEN6_3DSTATE_CONSTANT_VS_PointertoVSConstantBuffer0_bits  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_PointertoVSConstantBuffer0_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 27;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_VS_PointertoVSConstantBuffer0_start  37

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_PointertoVSConstantBuffer0_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 37;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_VS::Pointer to VS Constant Buffer 1 */


#define GEN6_3DSTATE_CONSTANT_VS_PointertoVSConstantBuffer1_bits  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_PointertoVSConstantBuffer1_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 27;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_VS_PointertoVSConstantBuffer1_start  69

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_PointertoVSConstantBuffer1_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 69;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_VS::Pointer to VS Constant Buffer 2 */


#define GEN6_3DSTATE_CONSTANT_VS_PointertoVSConstantBuffer2_bits  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_PointertoVSConstantBuffer2_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 27;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_VS_PointertoVSConstantBuffer2_start  101

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_PointertoVSConstantBuffer2_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 101;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_VS::Pointer to VS Constant Buffer 3 */


#define GEN6_3DSTATE_CONSTANT_VS_PointertoVSConstantBuffer3_bits  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_PointertoVSConstantBuffer3_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 27;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_VS_PointertoVSConstantBuffer3_start  133

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_PointertoVSConstantBuffer3_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 133;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_VS::VS Constant Buffer 0 Read Length */


#define GEN6_3DSTATE_CONSTANT_VS_VSConstantBuffer0ReadLength_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_VSConstantBuffer0ReadLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 5;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_VS_VSConstantBuffer0ReadLength_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_VSConstantBuffer0ReadLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 32;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_VS::VS Constant Buffer 1 Read Length */


#define GEN6_3DSTATE_CONSTANT_VS_VSConstantBuffer1ReadLength_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_VSConstantBuffer1ReadLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 5;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_VS_VSConstantBuffer1ReadLength_start  64

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_VSConstantBuffer1ReadLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 64;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_VS::VS Constant Buffer 2 Read Length */


#define GEN6_3DSTATE_CONSTANT_VS_VSConstantBuffer2ReadLength_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_VSConstantBuffer2ReadLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 5;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_VS_VSConstantBuffer2ReadLength_start  96

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_VSConstantBuffer2ReadLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 96;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_VS::VS Constant Buffer 3 Read Length */


#define GEN6_3DSTATE_CONSTANT_VS_VSConstantBuffer3ReadLength_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_VSConstantBuffer3ReadLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 5;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_CONSTANT_VS_VSConstantBuffer3ReadLength_start  128

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_VSConstantBuffer3ReadLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 128;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER */


#define GEN10_3DSTATE_DEPTH_BUFFER_length  8
#define GEN9_3DSTATE_DEPTH_BUFFER_length  8
#define GEN8_3DSTATE_DEPTH_BUFFER_length  8
#define GEN75_3DSTATE_DEPTH_BUFFER_length  7
#define GEN7_3DSTATE_DEPTH_BUFFER_length  7
#define GEN6_3DSTATE_DEPTH_BUFFER_length  7
#define GEN5_3DSTATE_DEPTH_BUFFER_length  6
#define GEN45_3DSTATE_DEPTH_BUFFER_length  6
#define GEN4_3DSTATE_DEPTH_BUFFER_length  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 7;
      } else {
         return 7;
      }
   case 6: return 7;
   case 5: return 6;
   case 4:
      if (devinfo->is_g4x) {
         return 6;
      } else {
         return 5;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::3D Command Opcode */


#define GEN10_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_bits  3
#define GEN7_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_bits  3
#define GEN6_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_bits  3
#define GEN5_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_bits  3
#define GEN45_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_bits  3
#define GEN4_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 3;
   case 4:
      if (devinfo->is_g4x) {
         return 3;
      } else {
         return 3;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_start  24
#define GEN9_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_start  24
#define GEN8_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_start  24
#define GEN75_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_start  24
#define GEN7_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_start  24
#define GEN6_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_start  24
#define GEN5_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_start  24
#define GEN45_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_start  24
#define GEN4_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 24;
      }
   case 6: return 24;
   case 5: return 24;
   case 4:
      if (devinfo->is_g4x) {
         return 24;
      } else {
         return 24;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::3D Command Sub Opcode */


#define GEN10_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_bits  8
#define GEN7_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_bits  8
#define GEN6_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_bits  8
#define GEN5_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_bits  8
#define GEN45_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_bits  8
#define GEN4_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 8;
   case 4:
      if (devinfo->is_g4x) {
         return 8;
      } else {
         return 8;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_start  16
#define GEN7_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_start  16
#define GEN6_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_start  16
#define GEN5_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_start  16
#define GEN45_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_start  16
#define GEN4_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 16;
   case 5: return 16;
   case 4:
      if (devinfo->is_g4x) {
         return 16;
      } else {
         return 16;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Command SubType */


#define GEN10_3DSTATE_DEPTH_BUFFER_CommandSubType_bits  2
#define GEN9_3DSTATE_DEPTH_BUFFER_CommandSubType_bits  2
#define GEN8_3DSTATE_DEPTH_BUFFER_CommandSubType_bits  2
#define GEN75_3DSTATE_DEPTH_BUFFER_CommandSubType_bits  2
#define GEN7_3DSTATE_DEPTH_BUFFER_CommandSubType_bits  2
#define GEN6_3DSTATE_DEPTH_BUFFER_CommandSubType_bits  2
#define GEN5_3DSTATE_DEPTH_BUFFER_CommandSubType_bits  2
#define GEN45_3DSTATE_DEPTH_BUFFER_CommandSubType_bits  2
#define GEN4_3DSTATE_DEPTH_BUFFER_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 2;
   case 5: return 2;
   case 4:
      if (devinfo->is_g4x) {
         return 2;
      } else {
         return 2;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DEPTH_BUFFER_CommandSubType_start  27
#define GEN9_3DSTATE_DEPTH_BUFFER_CommandSubType_start  27
#define GEN8_3DSTATE_DEPTH_BUFFER_CommandSubType_start  27
#define GEN75_3DSTATE_DEPTH_BUFFER_CommandSubType_start  27
#define GEN7_3DSTATE_DEPTH_BUFFER_CommandSubType_start  27
#define GEN6_3DSTATE_DEPTH_BUFFER_CommandSubType_start  27
#define GEN5_3DSTATE_DEPTH_BUFFER_CommandSubType_start  27
#define GEN45_3DSTATE_DEPTH_BUFFER_CommandSubType_start  27
#define GEN4_3DSTATE_DEPTH_BUFFER_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 27;
      }
   case 6: return 27;
   case 5: return 27;
   case 4:
      if (devinfo->is_g4x) {
         return 27;
      } else {
         return 27;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Command Type */


#define GEN10_3DSTATE_DEPTH_BUFFER_CommandType_bits  3
#define GEN9_3DSTATE_DEPTH_BUFFER_CommandType_bits  3
#define GEN8_3DSTATE_DEPTH_BUFFER_CommandType_bits  3
#define GEN75_3DSTATE_DEPTH_BUFFER_CommandType_bits  3
#define GEN7_3DSTATE_DEPTH_BUFFER_CommandType_bits  3
#define GEN6_3DSTATE_DEPTH_BUFFER_CommandType_bits  3
#define GEN5_3DSTATE_DEPTH_BUFFER_CommandType_bits  3
#define GEN45_3DSTATE_DEPTH_BUFFER_CommandType_bits  3
#define GEN4_3DSTATE_DEPTH_BUFFER_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 3;
   case 4:
      if (devinfo->is_g4x) {
         return 3;
      } else {
         return 3;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DEPTH_BUFFER_CommandType_start  29
#define GEN9_3DSTATE_DEPTH_BUFFER_CommandType_start  29
#define GEN8_3DSTATE_DEPTH_BUFFER_CommandType_start  29
#define GEN75_3DSTATE_DEPTH_BUFFER_CommandType_start  29
#define GEN7_3DSTATE_DEPTH_BUFFER_CommandType_start  29
#define GEN6_3DSTATE_DEPTH_BUFFER_CommandType_start  29
#define GEN5_3DSTATE_DEPTH_BUFFER_CommandType_start  29
#define GEN45_3DSTATE_DEPTH_BUFFER_CommandType_start  29
#define GEN4_3DSTATE_DEPTH_BUFFER_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 29;
      }
   case 6: return 29;
   case 5: return 29;
   case 4:
      if (devinfo->is_g4x) {
         return 29;
      } else {
         return 29;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::DWord Length */


#define GEN10_3DSTATE_DEPTH_BUFFER_DWordLength_bits  8
#define GEN9_3DSTATE_DEPTH_BUFFER_DWordLength_bits  8
#define GEN8_3DSTATE_DEPTH_BUFFER_DWordLength_bits  8
#define GEN75_3DSTATE_DEPTH_BUFFER_DWordLength_bits  8
#define GEN7_3DSTATE_DEPTH_BUFFER_DWordLength_bits  8
#define GEN6_3DSTATE_DEPTH_BUFFER_DWordLength_bits  8
#define GEN5_3DSTATE_DEPTH_BUFFER_DWordLength_bits  8
#define GEN45_3DSTATE_DEPTH_BUFFER_DWordLength_bits  8
#define GEN4_3DSTATE_DEPTH_BUFFER_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 8;
   case 4:
      if (devinfo->is_g4x) {
         return 8;
      } else {
         return 8;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DEPTH_BUFFER_DWordLength_start  0
#define GEN9_3DSTATE_DEPTH_BUFFER_DWordLength_start  0
#define GEN8_3DSTATE_DEPTH_BUFFER_DWordLength_start  0
#define GEN75_3DSTATE_DEPTH_BUFFER_DWordLength_start  0
#define GEN7_3DSTATE_DEPTH_BUFFER_DWordLength_start  0
#define GEN6_3DSTATE_DEPTH_BUFFER_DWordLength_start  0
#define GEN5_3DSTATE_DEPTH_BUFFER_DWordLength_start  0
#define GEN45_3DSTATE_DEPTH_BUFFER_DWordLength_start  0
#define GEN4_3DSTATE_DEPTH_BUFFER_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Depth */


#define GEN10_3DSTATE_DEPTH_BUFFER_Depth_bits  11
#define GEN9_3DSTATE_DEPTH_BUFFER_Depth_bits  11
#define GEN8_3DSTATE_DEPTH_BUFFER_Depth_bits  11
#define GEN75_3DSTATE_DEPTH_BUFFER_Depth_bits  11
#define GEN7_3DSTATE_DEPTH_BUFFER_Depth_bits  11
#define GEN6_3DSTATE_DEPTH_BUFFER_Depth_bits  11
#define GEN5_3DSTATE_DEPTH_BUFFER_Depth_bits  11
#define GEN45_3DSTATE_DEPTH_BUFFER_Depth_bits  11
#define GEN4_3DSTATE_DEPTH_BUFFER_Depth_bits  11

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_Depth_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 11;
   case 9: return 11;
   case 8: return 11;
   case 7:
      if (devinfo->is_haswell) {
         return 11;
      } else {
         return 11;
      }
   case 6: return 11;
   case 5: return 11;
   case 4:
      if (devinfo->is_g4x) {
         return 11;
      } else {
         return 11;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DEPTH_BUFFER_Depth_start  181
#define GEN9_3DSTATE_DEPTH_BUFFER_Depth_start  181
#define GEN8_3DSTATE_DEPTH_BUFFER_Depth_start  181
#define GEN75_3DSTATE_DEPTH_BUFFER_Depth_start  149
#define GEN7_3DSTATE_DEPTH_BUFFER_Depth_start  149
#define GEN6_3DSTATE_DEPTH_BUFFER_Depth_start  149
#define GEN5_3DSTATE_DEPTH_BUFFER_Depth_start  149
#define GEN45_3DSTATE_DEPTH_BUFFER_Depth_start  149
#define GEN4_3DSTATE_DEPTH_BUFFER_Depth_start  149

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_Depth_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 181;
   case 9: return 181;
   case 8: return 181;
   case 7:
      if (devinfo->is_haswell) {
         return 149;
      } else {
         return 149;
      }
   case 6: return 149;
   case 5: return 149;
   case 4:
      if (devinfo->is_g4x) {
         return 149;
      } else {
         return 149;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Depth Buffer Coordinate Offset Disable */


#define GEN45_3DSTATE_DEPTH_BUFFER_DepthBufferCoordinateOffsetDisable_bits  1
#define GEN4_3DSTATE_DEPTH_BUFFER_DepthBufferCoordinateOffsetDisable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_DepthBufferCoordinateOffsetDisable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 1;
      } else {
         return 1;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN45_3DSTATE_DEPTH_BUFFER_DepthBufferCoordinateOffsetDisable_start  57
#define GEN4_3DSTATE_DEPTH_BUFFER_DepthBufferCoordinateOffsetDisable_start  57

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_DepthBufferCoordinateOffsetDisable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 57;
      } else {
         return 57;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Depth Buffer MOCS */


#define GEN10_3DSTATE_DEPTH_BUFFER_DepthBufferMOCS_bits  7
#define GEN9_3DSTATE_DEPTH_BUFFER_DepthBufferMOCS_bits  7
#define GEN8_3DSTATE_DEPTH_BUFFER_DepthBufferMOCS_bits  7
#define GEN75_3DSTATE_DEPTH_BUFFER_DepthBufferMOCS_bits  4
#define GEN7_3DSTATE_DEPTH_BUFFER_DepthBufferMOCS_bits  4
#define GEN6_3DSTATE_DEPTH_BUFFER_DepthBufferMOCS_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_DepthBufferMOCS_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 7;
   case 9: return 7;
   case 8: return 7;
   case 7:
      if (devinfo->is_haswell) {
         return 4;
      } else {
         return 4;
      }
   case 6: return 5;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DEPTH_BUFFER_DepthBufferMOCS_start  160
#define GEN9_3DSTATE_DEPTH_BUFFER_DepthBufferMOCS_start  160
#define GEN8_3DSTATE_DEPTH_BUFFER_DepthBufferMOCS_start  160
#define GEN75_3DSTATE_DEPTH_BUFFER_DepthBufferMOCS_start  128
#define GEN7_3DSTATE_DEPTH_BUFFER_DepthBufferMOCS_start  128
#define GEN6_3DSTATE_DEPTH_BUFFER_DepthBufferMOCS_start  219

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_DepthBufferMOCS_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 160;
   case 9: return 160;
   case 8: return 160;
   case 7:
      if (devinfo->is_haswell) {
         return 128;
      } else {
         return 128;
      }
   case 6: return 219;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Depth Buffer Object Control State */


#define GEN10_3DSTATE_DEPTH_BUFFER_DepthBufferObjectControlState_bits  7
#define GEN9_3DSTATE_DEPTH_BUFFER_DepthBufferObjectControlState_bits  7
#define GEN8_3DSTATE_DEPTH_BUFFER_DepthBufferObjectControlState_bits  7
#define GEN75_3DSTATE_DEPTH_BUFFER_DepthBufferObjectControlState_bits  4
#define GEN7_3DSTATE_DEPTH_BUFFER_DepthBufferObjectControlState_bits  4
#define GEN6_3DSTATE_DEPTH_BUFFER_DepthBufferObjectControlState_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_DepthBufferObjectControlState_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 7;
   case 9: return 7;
   case 8: return 7;
   case 7:
      if (devinfo->is_haswell) {
         return 4;
      } else {
         return 4;
      }
   case 6: return 5;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DEPTH_BUFFER_DepthBufferObjectControlState_start  160
#define GEN9_3DSTATE_DEPTH_BUFFER_DepthBufferObjectControlState_start  160
#define GEN8_3DSTATE_DEPTH_BUFFER_DepthBufferObjectControlState_start  160
#define GEN75_3DSTATE_DEPTH_BUFFER_DepthBufferObjectControlState_start  128
#define GEN7_3DSTATE_DEPTH_BUFFER_DepthBufferObjectControlState_start  128
#define GEN6_3DSTATE_DEPTH_BUFFER_DepthBufferObjectControlState_start  219

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_DepthBufferObjectControlState_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 160;
   case 9: return 160;
   case 8: return 160;
   case 7:
      if (devinfo->is_haswell) {
         return 128;
      } else {
         return 128;
      }
   case 6: return 219;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Depth Coordinate Offset X */


#define GEN75_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetX_bits  16
#define GEN7_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetX_bits  16
#define GEN6_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetX_bits  16
#define GEN5_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetX_bits  16
#define GEN45_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetX_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetX_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 16;
   case 5: return 16;
   case 4:
      if (devinfo->is_g4x) {
         return 16;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN75_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetX_start  160
#define GEN7_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetX_start  160
#define GEN6_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetX_start  160
#define GEN5_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetX_start  160
#define GEN45_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetX_start  160

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetX_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 160;
      } else {
         return 160;
      }
   case 6: return 160;
   case 5: return 160;
   case 4:
      if (devinfo->is_g4x) {
         return 160;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Depth Coordinate Offset Y */


#define GEN75_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetY_bits  16
#define GEN7_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetY_bits  16
#define GEN6_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetY_bits  16
#define GEN5_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetY_bits  16
#define GEN45_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetY_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetY_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 16;
   case 5: return 16;
   case 4:
      if (devinfo->is_g4x) {
         return 16;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN75_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetY_start  176
#define GEN7_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetY_start  176
#define GEN6_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetY_start  176
#define GEN5_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetY_start  176
#define GEN45_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetY_start  176

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetY_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 176;
      } else {
         return 176;
      }
   case 6: return 176;
   case 5: return 176;
   case 4:
      if (devinfo->is_g4x) {
         return 176;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Depth Write Enable */


#define GEN10_3DSTATE_DEPTH_BUFFER_DepthWriteEnable_bits  1
#define GEN9_3DSTATE_DEPTH_BUFFER_DepthWriteEnable_bits  1
#define GEN8_3DSTATE_DEPTH_BUFFER_DepthWriteEnable_bits  1
#define GEN75_3DSTATE_DEPTH_BUFFER_DepthWriteEnable_bits  1
#define GEN7_3DSTATE_DEPTH_BUFFER_DepthWriteEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_DepthWriteEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DEPTH_BUFFER_DepthWriteEnable_start  60
#define GEN9_3DSTATE_DEPTH_BUFFER_DepthWriteEnable_start  60
#define GEN8_3DSTATE_DEPTH_BUFFER_DepthWriteEnable_start  60
#define GEN75_3DSTATE_DEPTH_BUFFER_DepthWriteEnable_start  60
#define GEN7_3DSTATE_DEPTH_BUFFER_DepthWriteEnable_start  60

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_DepthWriteEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 60;
   case 9: return 60;
   case 8: return 60;
   case 7:
      if (devinfo->is_haswell) {
         return 60;
      } else {
         return 60;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Height */


#define GEN10_3DSTATE_DEPTH_BUFFER_Height_bits  14
#define GEN9_3DSTATE_DEPTH_BUFFER_Height_bits  14
#define GEN8_3DSTATE_DEPTH_BUFFER_Height_bits  14
#define GEN75_3DSTATE_DEPTH_BUFFER_Height_bits  14
#define GEN7_3DSTATE_DEPTH_BUFFER_Height_bits  14
#define GEN6_3DSTATE_DEPTH_BUFFER_Height_bits  13
#define GEN5_3DSTATE_DEPTH_BUFFER_Height_bits  13
#define GEN45_3DSTATE_DEPTH_BUFFER_Height_bits  13
#define GEN4_3DSTATE_DEPTH_BUFFER_Height_bits  13

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_Height_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 14;
   case 9: return 14;
   case 8: return 14;
   case 7:
      if (devinfo->is_haswell) {
         return 14;
      } else {
         return 14;
      }
   case 6: return 13;
   case 5: return 13;
   case 4:
      if (devinfo->is_g4x) {
         return 13;
      } else {
         return 13;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DEPTH_BUFFER_Height_start  146
#define GEN9_3DSTATE_DEPTH_BUFFER_Height_start  146
#define GEN8_3DSTATE_DEPTH_BUFFER_Height_start  146
#define GEN75_3DSTATE_DEPTH_BUFFER_Height_start  114
#define GEN7_3DSTATE_DEPTH_BUFFER_Height_start  114
#define GEN6_3DSTATE_DEPTH_BUFFER_Height_start  115
#define GEN5_3DSTATE_DEPTH_BUFFER_Height_start  115
#define GEN45_3DSTATE_DEPTH_BUFFER_Height_start  115
#define GEN4_3DSTATE_DEPTH_BUFFER_Height_start  115

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_Height_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 146;
   case 9: return 146;
   case 8: return 146;
   case 7:
      if (devinfo->is_haswell) {
         return 114;
      } else {
         return 114;
      }
   case 6: return 115;
   case 5: return 115;
   case 4:
      if (devinfo->is_g4x) {
         return 115;
      } else {
         return 115;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Hierarchical Depth Buffer Enable */


#define GEN10_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_bits  1
#define GEN9_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_bits  1
#define GEN8_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_bits  1
#define GEN75_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_bits  1
#define GEN7_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_bits  1
#define GEN6_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_bits  1
#define GEN5_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 1;
   case 5: return 1;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_start  54
#define GEN9_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_start  54
#define GEN8_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_start  54
#define GEN75_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_start  54
#define GEN7_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_start  54
#define GEN6_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_start  54
#define GEN5_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_start  54

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 54;
   case 9: return 54;
   case 8: return 54;
   case 7:
      if (devinfo->is_haswell) {
         return 54;
      } else {
         return 54;
      }
   case 6: return 54;
   case 5: return 54;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::LOD */


#define GEN10_3DSTATE_DEPTH_BUFFER_LOD_bits  4
#define GEN9_3DSTATE_DEPTH_BUFFER_LOD_bits  4
#define GEN8_3DSTATE_DEPTH_BUFFER_LOD_bits  4
#define GEN75_3DSTATE_DEPTH_BUFFER_LOD_bits  4
#define GEN7_3DSTATE_DEPTH_BUFFER_LOD_bits  4
#define GEN6_3DSTATE_DEPTH_BUFFER_LOD_bits  4
#define GEN5_3DSTATE_DEPTH_BUFFER_LOD_bits  4
#define GEN45_3DSTATE_DEPTH_BUFFER_LOD_bits  4
#define GEN4_3DSTATE_DEPTH_BUFFER_LOD_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_LOD_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 4;
   case 9: return 4;
   case 8: return 4;
   case 7:
      if (devinfo->is_haswell) {
         return 4;
      } else {
         return 4;
      }
   case 6: return 4;
   case 5: return 4;
   case 4:
      if (devinfo->is_g4x) {
         return 4;
      } else {
         return 4;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DEPTH_BUFFER_LOD_start  128
#define GEN9_3DSTATE_DEPTH_BUFFER_LOD_start  128
#define GEN8_3DSTATE_DEPTH_BUFFER_LOD_start  128
#define GEN75_3DSTATE_DEPTH_BUFFER_LOD_start  96
#define GEN7_3DSTATE_DEPTH_BUFFER_LOD_start  96
#define GEN6_3DSTATE_DEPTH_BUFFER_LOD_start  98
#define GEN5_3DSTATE_DEPTH_BUFFER_LOD_start  98
#define GEN45_3DSTATE_DEPTH_BUFFER_LOD_start  98
#define GEN4_3DSTATE_DEPTH_BUFFER_LOD_start  98

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_LOD_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 128;
   case 9: return 128;
   case 8: return 128;
   case 7:
      if (devinfo->is_haswell) {
         return 96;
      } else {
         return 96;
      }
   case 6: return 98;
   case 5: return 98;
   case 4:
      if (devinfo->is_g4x) {
         return 98;
      } else {
         return 98;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::MIP Map Layout Mode */


#define GEN6_3DSTATE_DEPTH_BUFFER_MIPMapLayoutMode_bits  1
#define GEN5_3DSTATE_DEPTH_BUFFER_MIPMapLayoutMode_bits  1
#define GEN45_3DSTATE_DEPTH_BUFFER_MIPMapLayoutMode_bits  1
#define GEN4_3DSTATE_DEPTH_BUFFER_MIPMapLayoutMode_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_MIPMapLayoutMode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 1;
   case 5: return 1;
   case 4:
      if (devinfo->is_g4x) {
         return 1;
      } else {
         return 1;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_DEPTH_BUFFER_MIPMapLayoutMode_start  97
#define GEN5_3DSTATE_DEPTH_BUFFER_MIPMapLayoutMode_start  97
#define GEN45_3DSTATE_DEPTH_BUFFER_MIPMapLayoutMode_start  97
#define GEN4_3DSTATE_DEPTH_BUFFER_MIPMapLayoutMode_start  97

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_MIPMapLayoutMode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 97;
   case 5: return 97;
   case 4:
      if (devinfo->is_g4x) {
         return 97;
      } else {
         return 97;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Minimum Array Element */


#define GEN10_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_bits  11
#define GEN9_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_bits  11
#define GEN8_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_bits  11
#define GEN75_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_bits  11
#define GEN7_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_bits  11
#define GEN6_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_bits  11
#define GEN5_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_bits  11
#define GEN45_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_bits  11
#define GEN4_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_bits  11

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 11;
   case 9: return 11;
   case 8: return 11;
   case 7:
      if (devinfo->is_haswell) {
         return 11;
      } else {
         return 11;
      }
   case 6: return 11;
   case 5: return 11;
   case 4:
      if (devinfo->is_g4x) {
         return 11;
      } else {
         return 11;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_start  170
#define GEN9_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_start  170
#define GEN8_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_start  170
#define GEN75_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_start  138
#define GEN7_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_start  138
#define GEN6_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_start  138
#define GEN5_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_start  138
#define GEN45_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_start  138
#define GEN4_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_start  138

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 170;
   case 9: return 170;
   case 8: return 170;
   case 7:
      if (devinfo->is_haswell) {
         return 138;
      } else {
         return 138;
      }
   case 6: return 138;
   case 5: return 138;
   case 4:
      if (devinfo->is_g4x) {
         return 138;
      } else {
         return 138;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Mip Tail Start LOD */


#define GEN10_3DSTATE_DEPTH_BUFFER_MipTailStartLOD_bits  4
#define GEN9_3DSTATE_DEPTH_BUFFER_MipTailStartLOD_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_MipTailStartLOD_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 4;
   case 9: return 4;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DEPTH_BUFFER_MipTailStartLOD_start  218
#define GEN9_3DSTATE_DEPTH_BUFFER_MipTailStartLOD_start  218

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_MipTailStartLOD_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 218;
   case 9: return 218;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Render Target View Extent */


#define GEN10_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_bits  11
#define GEN9_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_bits  11
#define GEN8_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_bits  11
#define GEN75_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_bits  11
#define GEN7_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_bits  11
#define GEN6_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_bits  9
#define GEN5_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_bits  9
#define GEN45_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_bits  9
#define GEN4_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_bits  9

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 11;
   case 9: return 11;
   case 8: return 11;
   case 7:
      if (devinfo->is_haswell) {
         return 11;
      } else {
         return 11;
      }
   case 6: return 9;
   case 5: return 9;
   case 4:
      if (devinfo->is_g4x) {
         return 9;
      } else {
         return 9;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_start  245
#define GEN9_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_start  245
#define GEN8_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_start  245
#define GEN75_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_start  213
#define GEN7_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_start  213
#define GEN6_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_start  129
#define GEN5_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_start  129
#define GEN45_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_start  129
#define GEN4_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_start  129

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 245;
   case 9: return 245;
   case 8: return 245;
   case 7:
      if (devinfo->is_haswell) {
         return 213;
      } else {
         return 213;
      }
   case 6: return 129;
   case 5: return 129;
   case 4:
      if (devinfo->is_g4x) {
         return 129;
      } else {
         return 129;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Separate Stencil Buffer Enable */


#define GEN6_3DSTATE_DEPTH_BUFFER_SeparateStencilBufferEnable_bits  1
#define GEN5_3DSTATE_DEPTH_BUFFER_SeparateStencilBufferEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_SeparateStencilBufferEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 1;
   case 5: return 1;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_DEPTH_BUFFER_SeparateStencilBufferEnable_start  53
#define GEN5_3DSTATE_DEPTH_BUFFER_SeparateStencilBufferEnable_start  53

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_SeparateStencilBufferEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 53;
   case 5: return 53;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Software Tiled Rendering Mode */


#define GEN6_3DSTATE_DEPTH_BUFFER_SoftwareTiledRenderingMode_bits  2
#define GEN5_3DSTATE_DEPTH_BUFFER_SoftwareTiledRenderingMode_bits  2
#define GEN45_3DSTATE_DEPTH_BUFFER_SoftwareTiledRenderingMode_bits  2
#define GEN4_3DSTATE_DEPTH_BUFFER_SoftwareTiledRenderingMode_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_SoftwareTiledRenderingMode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 2;
   case 5: return 2;
   case 4:
      if (devinfo->is_g4x) {
         return 2;
      } else {
         return 2;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_DEPTH_BUFFER_SoftwareTiledRenderingMode_start  55
#define GEN5_3DSTATE_DEPTH_BUFFER_SoftwareTiledRenderingMode_start  55
#define GEN45_3DSTATE_DEPTH_BUFFER_SoftwareTiledRenderingMode_start  55
#define GEN4_3DSTATE_DEPTH_BUFFER_SoftwareTiledRenderingMode_start  55

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_SoftwareTiledRenderingMode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 55;
   case 5: return 55;
   case 4:
      if (devinfo->is_g4x) {
         return 55;
      } else {
         return 55;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Stencil Write Enable */


#define GEN10_3DSTATE_DEPTH_BUFFER_StencilWriteEnable_bits  1
#define GEN9_3DSTATE_DEPTH_BUFFER_StencilWriteEnable_bits  1
#define GEN8_3DSTATE_DEPTH_BUFFER_StencilWriteEnable_bits  1
#define GEN75_3DSTATE_DEPTH_BUFFER_StencilWriteEnable_bits  1
#define GEN7_3DSTATE_DEPTH_BUFFER_StencilWriteEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_StencilWriteEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DEPTH_BUFFER_StencilWriteEnable_start  59
#define GEN9_3DSTATE_DEPTH_BUFFER_StencilWriteEnable_start  59
#define GEN8_3DSTATE_DEPTH_BUFFER_StencilWriteEnable_start  59
#define GEN75_3DSTATE_DEPTH_BUFFER_StencilWriteEnable_start  59
#define GEN7_3DSTATE_DEPTH_BUFFER_StencilWriteEnable_start  59

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_StencilWriteEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 59;
   case 9: return 59;
   case 8: return 59;
   case 7:
      if (devinfo->is_haswell) {
         return 59;
      } else {
         return 59;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Surface Base Address */


#define GEN10_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_bits  64
#define GEN9_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_bits  64
#define GEN8_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_bits  64
#define GEN75_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_bits  32
#define GEN7_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_bits  32
#define GEN6_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_bits  32
#define GEN5_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_bits  32
#define GEN45_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_bits  32
#define GEN4_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 64;
   case 9: return 64;
   case 8: return 64;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 32;
      }
   case 6: return 32;
   case 5: return 32;
   case 4:
      if (devinfo->is_g4x) {
         return 32;
      } else {
         return 32;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_start  64
#define GEN9_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_start  64
#define GEN8_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_start  64
#define GEN75_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_start  64
#define GEN7_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_start  64
#define GEN6_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_start  64
#define GEN5_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_start  64
#define GEN45_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_start  64
#define GEN4_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_start  64

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 64;
   case 9: return 64;
   case 8: return 64;
   case 7:
      if (devinfo->is_haswell) {
         return 64;
      } else {
         return 64;
      }
   case 6: return 64;
   case 5: return 64;
   case 4:
      if (devinfo->is_g4x) {
         return 64;
      } else {
         return 64;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Surface Format */


#define GEN10_3DSTATE_DEPTH_BUFFER_SurfaceFormat_bits  3
#define GEN9_3DSTATE_DEPTH_BUFFER_SurfaceFormat_bits  3
#define GEN8_3DSTATE_DEPTH_BUFFER_SurfaceFormat_bits  3
#define GEN75_3DSTATE_DEPTH_BUFFER_SurfaceFormat_bits  3
#define GEN7_3DSTATE_DEPTH_BUFFER_SurfaceFormat_bits  3
#define GEN6_3DSTATE_DEPTH_BUFFER_SurfaceFormat_bits  3
#define GEN5_3DSTATE_DEPTH_BUFFER_SurfaceFormat_bits  3
#define GEN45_3DSTATE_DEPTH_BUFFER_SurfaceFormat_bits  3
#define GEN4_3DSTATE_DEPTH_BUFFER_SurfaceFormat_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_SurfaceFormat_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 3;
   case 4:
      if (devinfo->is_g4x) {
         return 3;
      } else {
         return 3;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DEPTH_BUFFER_SurfaceFormat_start  50
#define GEN9_3DSTATE_DEPTH_BUFFER_SurfaceFormat_start  50
#define GEN8_3DSTATE_DEPTH_BUFFER_SurfaceFormat_start  50
#define GEN75_3DSTATE_DEPTH_BUFFER_SurfaceFormat_start  50
#define GEN7_3DSTATE_DEPTH_BUFFER_SurfaceFormat_start  50
#define GEN6_3DSTATE_DEPTH_BUFFER_SurfaceFormat_start  50
#define GEN5_3DSTATE_DEPTH_BUFFER_SurfaceFormat_start  50
#define GEN45_3DSTATE_DEPTH_BUFFER_SurfaceFormat_start  50
#define GEN4_3DSTATE_DEPTH_BUFFER_SurfaceFormat_start  50

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_SurfaceFormat_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 50;
   case 9: return 50;
   case 8: return 50;
   case 7:
      if (devinfo->is_haswell) {
         return 50;
      } else {
         return 50;
      }
   case 6: return 50;
   case 5: return 50;
   case 4:
      if (devinfo->is_g4x) {
         return 50;
      } else {
         return 50;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Surface Pitch */


#define GEN10_3DSTATE_DEPTH_BUFFER_SurfacePitch_bits  18
#define GEN9_3DSTATE_DEPTH_BUFFER_SurfacePitch_bits  18
#define GEN8_3DSTATE_DEPTH_BUFFER_SurfacePitch_bits  18
#define GEN75_3DSTATE_DEPTH_BUFFER_SurfacePitch_bits  18
#define GEN7_3DSTATE_DEPTH_BUFFER_SurfacePitch_bits  18
#define GEN6_3DSTATE_DEPTH_BUFFER_SurfacePitch_bits  17
#define GEN5_3DSTATE_DEPTH_BUFFER_SurfacePitch_bits  17
#define GEN45_3DSTATE_DEPTH_BUFFER_SurfacePitch_bits  17
#define GEN4_3DSTATE_DEPTH_BUFFER_SurfacePitch_bits  17

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_SurfacePitch_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 18;
   case 9: return 18;
   case 8: return 18;
   case 7:
      if (devinfo->is_haswell) {
         return 18;
      } else {
         return 18;
      }
   case 6: return 17;
   case 5: return 17;
   case 4:
      if (devinfo->is_g4x) {
         return 17;
      } else {
         return 17;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DEPTH_BUFFER_SurfacePitch_start  32
#define GEN9_3DSTATE_DEPTH_BUFFER_SurfacePitch_start  32
#define GEN8_3DSTATE_DEPTH_BUFFER_SurfacePitch_start  32
#define GEN75_3DSTATE_DEPTH_BUFFER_SurfacePitch_start  32
#define GEN7_3DSTATE_DEPTH_BUFFER_SurfacePitch_start  32
#define GEN6_3DSTATE_DEPTH_BUFFER_SurfacePitch_start  32
#define GEN5_3DSTATE_DEPTH_BUFFER_SurfacePitch_start  32
#define GEN45_3DSTATE_DEPTH_BUFFER_SurfacePitch_start  32
#define GEN4_3DSTATE_DEPTH_BUFFER_SurfacePitch_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_SurfacePitch_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 32;
      }
   case 6: return 32;
   case 5: return 32;
   case 4:
      if (devinfo->is_g4x) {
         return 32;
      } else {
         return 32;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Surface QPitch */


#define GEN10_3DSTATE_DEPTH_BUFFER_SurfaceQPitch_bits  15
#define GEN9_3DSTATE_DEPTH_BUFFER_SurfaceQPitch_bits  15
#define GEN8_3DSTATE_DEPTH_BUFFER_SurfaceQPitch_bits  15

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_SurfaceQPitch_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 15;
   case 9: return 15;
   case 8: return 15;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DEPTH_BUFFER_SurfaceQPitch_start  224
#define GEN9_3DSTATE_DEPTH_BUFFER_SurfaceQPitch_start  224
#define GEN8_3DSTATE_DEPTH_BUFFER_SurfaceQPitch_start  224

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_SurfaceQPitch_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 224;
   case 9: return 224;
   case 8: return 224;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Surface Type */


#define GEN10_3DSTATE_DEPTH_BUFFER_SurfaceType_bits  3
#define GEN9_3DSTATE_DEPTH_BUFFER_SurfaceType_bits  3
#define GEN8_3DSTATE_DEPTH_BUFFER_SurfaceType_bits  3
#define GEN75_3DSTATE_DEPTH_BUFFER_SurfaceType_bits  3
#define GEN7_3DSTATE_DEPTH_BUFFER_SurfaceType_bits  3
#define GEN6_3DSTATE_DEPTH_BUFFER_SurfaceType_bits  3
#define GEN5_3DSTATE_DEPTH_BUFFER_SurfaceType_bits  3
#define GEN45_3DSTATE_DEPTH_BUFFER_SurfaceType_bits  3
#define GEN4_3DSTATE_DEPTH_BUFFER_SurfaceType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_SurfaceType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 3;
   case 4:
      if (devinfo->is_g4x) {
         return 3;
      } else {
         return 3;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DEPTH_BUFFER_SurfaceType_start  61
#define GEN9_3DSTATE_DEPTH_BUFFER_SurfaceType_start  61
#define GEN8_3DSTATE_DEPTH_BUFFER_SurfaceType_start  61
#define GEN75_3DSTATE_DEPTH_BUFFER_SurfaceType_start  61
#define GEN7_3DSTATE_DEPTH_BUFFER_SurfaceType_start  61
#define GEN6_3DSTATE_DEPTH_BUFFER_SurfaceType_start  61
#define GEN5_3DSTATE_DEPTH_BUFFER_SurfaceType_start  61
#define GEN45_3DSTATE_DEPTH_BUFFER_SurfaceType_start  61
#define GEN4_3DSTATE_DEPTH_BUFFER_SurfaceType_start  61

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_SurfaceType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 61;
   case 9: return 61;
   case 8: return 61;
   case 7:
      if (devinfo->is_haswell) {
         return 61;
      } else {
         return 61;
      }
   case 6: return 61;
   case 5: return 61;
   case 4:
      if (devinfo->is_g4x) {
         return 61;
      } else {
         return 61;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Tile Walk */


#define GEN6_3DSTATE_DEPTH_BUFFER_TileWalk_bits  1
#define GEN5_3DSTATE_DEPTH_BUFFER_TileWalk_bits  1
#define GEN45_3DSTATE_DEPTH_BUFFER_TileWalk_bits  1
#define GEN4_3DSTATE_DEPTH_BUFFER_TileWalk_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_TileWalk_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 1;
   case 5: return 1;
   case 4:
      if (devinfo->is_g4x) {
         return 1;
      } else {
         return 1;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_DEPTH_BUFFER_TileWalk_start  58
#define GEN5_3DSTATE_DEPTH_BUFFER_TileWalk_start  58
#define GEN45_3DSTATE_DEPTH_BUFFER_TileWalk_start  58
#define GEN4_3DSTATE_DEPTH_BUFFER_TileWalk_start  58

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_TileWalk_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 58;
   case 5: return 58;
   case 4:
      if (devinfo->is_g4x) {
         return 58;
      } else {
         return 58;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Tiled Resource Mode */


#define GEN10_3DSTATE_DEPTH_BUFFER_TiledResourceMode_bits  2
#define GEN9_3DSTATE_DEPTH_BUFFER_TiledResourceMode_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_TiledResourceMode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DEPTH_BUFFER_TiledResourceMode_start  222
#define GEN9_3DSTATE_DEPTH_BUFFER_TiledResourceMode_start  222

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_TiledResourceMode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 222;
   case 9: return 222;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Tiled Surface */


#define GEN6_3DSTATE_DEPTH_BUFFER_TiledSurface_bits  1
#define GEN5_3DSTATE_DEPTH_BUFFER_TiledSurface_bits  1
#define GEN45_3DSTATE_DEPTH_BUFFER_TiledSurface_bits  1
#define GEN4_3DSTATE_DEPTH_BUFFER_TiledSurface_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_TiledSurface_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 1;
   case 5: return 1;
   case 4:
      if (devinfo->is_g4x) {
         return 1;
      } else {
         return 1;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_DEPTH_BUFFER_TiledSurface_start  59
#define GEN5_3DSTATE_DEPTH_BUFFER_TiledSurface_start  59
#define GEN45_3DSTATE_DEPTH_BUFFER_TiledSurface_start  59
#define GEN4_3DSTATE_DEPTH_BUFFER_TiledSurface_start  59

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_TiledSurface_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 59;
   case 5: return 59;
   case 4:
      if (devinfo->is_g4x) {
         return 59;
      } else {
         return 59;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Width */


#define GEN10_3DSTATE_DEPTH_BUFFER_Width_bits  14
#define GEN9_3DSTATE_DEPTH_BUFFER_Width_bits  14
#define GEN8_3DSTATE_DEPTH_BUFFER_Width_bits  14
#define GEN75_3DSTATE_DEPTH_BUFFER_Width_bits  14
#define GEN7_3DSTATE_DEPTH_BUFFER_Width_bits  14
#define GEN6_3DSTATE_DEPTH_BUFFER_Width_bits  13
#define GEN5_3DSTATE_DEPTH_BUFFER_Width_bits  13
#define GEN45_3DSTATE_DEPTH_BUFFER_Width_bits  13
#define GEN4_3DSTATE_DEPTH_BUFFER_Width_bits  13

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_Width_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 14;
   case 9: return 14;
   case 8: return 14;
   case 7:
      if (devinfo->is_haswell) {
         return 14;
      } else {
         return 14;
      }
   case 6: return 13;
   case 5: return 13;
   case 4:
      if (devinfo->is_g4x) {
         return 13;
      } else {
         return 13;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DEPTH_BUFFER_Width_start  132
#define GEN9_3DSTATE_DEPTH_BUFFER_Width_start  132
#define GEN8_3DSTATE_DEPTH_BUFFER_Width_start  132
#define GEN75_3DSTATE_DEPTH_BUFFER_Width_start  100
#define GEN7_3DSTATE_DEPTH_BUFFER_Width_start  100
#define GEN6_3DSTATE_DEPTH_BUFFER_Width_start  102
#define GEN5_3DSTATE_DEPTH_BUFFER_Width_start  102
#define GEN45_3DSTATE_DEPTH_BUFFER_Width_start  102
#define GEN4_3DSTATE_DEPTH_BUFFER_Width_start  102

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_Width_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 132;
   case 9: return 132;
   case 8: return 132;
   case 7:
      if (devinfo->is_haswell) {
         return 100;
      } else {
         return 100;
      }
   case 6: return 102;
   case 5: return 102;
   case 4:
      if (devinfo->is_g4x) {
         return 102;
      } else {
         return 102;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_STENCIL_STATE_POINTERS */


#define GEN75_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_length  2
#define GEN7_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_length  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_STENCIL_STATE_POINTERS::3D Command Opcode */


#define GEN75_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_3DCommandOpcode_bits  3
#define GEN7_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN75_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_3DCommandOpcode_start  24
#define GEN7_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 24;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_STENCIL_STATE_POINTERS::3D Command Sub Opcode */


#define GEN75_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_3DCommandSubOpcode_bits  8
#define GEN7_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN75_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_3DCommandSubOpcode_start  16
#define GEN7_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_STENCIL_STATE_POINTERS::Command SubType */


#define GEN75_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_CommandSubType_bits  2
#define GEN7_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN75_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_CommandSubType_start  27
#define GEN7_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 27;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_STENCIL_STATE_POINTERS::Command Type */


#define GEN75_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_CommandType_bits  3
#define GEN7_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN75_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_CommandType_start  29
#define GEN7_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 29;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_STENCIL_STATE_POINTERS::DWord Length */


#define GEN75_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_DWordLength_bits  8
#define GEN7_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN75_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_DWordLength_start  0
#define GEN7_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_STENCIL_STATE_POINTERS::Pointer to DEPTH_STENCIL_STATE */


#define GEN75_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_PointertoDEPTH_STENCIL_STATE_bits  26
#define GEN7_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_PointertoDEPTH_STENCIL_STATE_bits  26

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_PointertoDEPTH_STENCIL_STATE_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 26;
      } else {
         return 26;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN75_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_PointertoDEPTH_STENCIL_STATE_start  38
#define GEN7_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_PointertoDEPTH_STENCIL_STATE_start  38

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_PointertoDEPTH_STENCIL_STATE_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 38;
      } else {
         return 38;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DRAWING_RECTANGLE */


#define GEN10_3DSTATE_DRAWING_RECTANGLE_length  4
#define GEN9_3DSTATE_DRAWING_RECTANGLE_length  4
#define GEN8_3DSTATE_DRAWING_RECTANGLE_length  4
#define GEN75_3DSTATE_DRAWING_RECTANGLE_length  4
#define GEN7_3DSTATE_DRAWING_RECTANGLE_length  4
#define GEN6_3DSTATE_DRAWING_RECTANGLE_length  4
#define GEN5_3DSTATE_DRAWING_RECTANGLE_length  4
#define GEN45_3DSTATE_DRAWING_RECTANGLE_length  4
#define GEN4_3DSTATE_DRAWING_RECTANGLE_length  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 4;
   case 9: return 4;
   case 8: return 4;
   case 7:
      if (devinfo->is_haswell) {
         return 4;
      } else {
         return 4;
      }
   case 6: return 4;
   case 5: return 4;
   case 4:
      if (devinfo->is_g4x) {
         return 4;
      } else {
         return 4;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DRAWING_RECTANGLE::3D Command Opcode */


#define GEN10_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_bits  3
#define GEN7_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_bits  3
#define GEN6_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_bits  3
#define GEN5_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_bits  3
#define GEN45_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_bits  3
#define GEN4_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 3;
   case 4:
      if (devinfo->is_g4x) {
         return 3;
      } else {
         return 3;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_start  24
#define GEN9_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_start  24
#define GEN8_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_start  24
#define GEN75_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_start  24
#define GEN7_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_start  24
#define GEN6_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_start  24
#define GEN5_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_start  24
#define GEN45_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_start  24
#define GEN4_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 24;
      }
   case 6: return 24;
   case 5: return 24;
   case 4:
      if (devinfo->is_g4x) {
         return 24;
      } else {
         return 24;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DRAWING_RECTANGLE::3D Command Sub Opcode */


#define GEN10_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_bits  8
#define GEN7_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_bits  8
#define GEN6_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_bits  8
#define GEN5_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_bits  8
#define GEN45_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_bits  8
#define GEN4_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 8;
   case 4:
      if (devinfo->is_g4x) {
         return 8;
      } else {
         return 8;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_start  16
#define GEN7_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_start  16
#define GEN6_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_start  16
#define GEN5_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_start  16
#define GEN45_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_start  16
#define GEN4_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 16;
   case 5: return 16;
   case 4:
      if (devinfo->is_g4x) {
         return 16;
      } else {
         return 16;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DRAWING_RECTANGLE::Clipped Drawing Rectangle X Max */


#define GEN10_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_bits  16
#define GEN9_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_bits  16
#define GEN8_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_bits  16
#define GEN75_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_bits  16
#define GEN7_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_bits  16
#define GEN6_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_bits  16
#define GEN5_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_bits  16
#define GEN45_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_bits  16
#define GEN4_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 16;
   case 5: return 16;
   case 4:
      if (devinfo->is_g4x) {
         return 16;
      } else {
         return 16;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_start  64
#define GEN9_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_start  64
#define GEN8_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_start  64
#define GEN75_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_start  64
#define GEN7_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_start  64
#define GEN6_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_start  64
#define GEN5_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_start  64
#define GEN45_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_start  64
#define GEN4_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_start  64

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 64;
   case 9: return 64;
   case 8: return 64;
   case 7:
      if (devinfo->is_haswell) {
         return 64;
      } else {
         return 64;
      }
   case 6: return 64;
   case 5: return 64;
   case 4:
      if (devinfo->is_g4x) {
         return 64;
      } else {
         return 64;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DRAWING_RECTANGLE::Clipped Drawing Rectangle X Min */


#define GEN10_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_bits  16
#define GEN9_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_bits  16
#define GEN8_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_bits  16
#define GEN75_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_bits  16
#define GEN7_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_bits  16
#define GEN6_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_bits  16
#define GEN5_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_bits  16
#define GEN45_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_bits  16
#define GEN4_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 16;
   case 5: return 16;
   case 4:
      if (devinfo->is_g4x) {
         return 16;
      } else {
         return 16;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_start  32
#define GEN9_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_start  32
#define GEN8_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_start  32
#define GEN75_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_start  32
#define GEN7_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_start  32
#define GEN6_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_start  32
#define GEN5_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_start  32
#define GEN45_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_start  32
#define GEN4_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 32;
      }
   case 6: return 32;
   case 5: return 32;
   case 4:
      if (devinfo->is_g4x) {
         return 32;
      } else {
         return 32;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DRAWING_RECTANGLE::Clipped Drawing Rectangle Y Max */


#define GEN10_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_bits  16
#define GEN9_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_bits  16
#define GEN8_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_bits  16
#define GEN75_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_bits  16
#define GEN7_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_bits  16
#define GEN6_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_bits  16
#define GEN5_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_bits  16
#define GEN45_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_bits  16
#define GEN4_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 16;
   case 5: return 16;
   case 4:
      if (devinfo->is_g4x) {
         return 16;
      } else {
         return 16;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_start  80
#define GEN9_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_start  80
#define GEN8_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_start  80
#define GEN75_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_start  80
#define GEN7_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_start  80
#define GEN6_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_start  80
#define GEN5_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_start  80
#define GEN45_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_start  80
#define GEN4_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_start  80

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 80;
   case 9: return 80;
   case 8: return 80;
   case 7:
      if (devinfo->is_haswell) {
         return 80;
      } else {
         return 80;
      }
   case 6: return 80;
   case 5: return 80;
   case 4:
      if (devinfo->is_g4x) {
         return 80;
      } else {
         return 80;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DRAWING_RECTANGLE::Clipped Drawing Rectangle Y Min */


#define GEN10_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_bits  16
#define GEN9_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_bits  16
#define GEN8_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_bits  16
#define GEN75_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_bits  16
#define GEN7_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_bits  16
#define GEN6_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_bits  16
#define GEN5_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_bits  16
#define GEN45_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_bits  16
#define GEN4_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 16;
   case 5: return 16;
   case 4:
      if (devinfo->is_g4x) {
         return 16;
      } else {
         return 16;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_start  48
#define GEN9_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_start  48
#define GEN8_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_start  48
#define GEN75_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_start  48
#define GEN7_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_start  48
#define GEN6_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_start  48
#define GEN5_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_start  48
#define GEN45_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_start  48
#define GEN4_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_start  48

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 48;
   case 9: return 48;
   case 8: return 48;
   case 7:
      if (devinfo->is_haswell) {
         return 48;
      } else {
         return 48;
      }
   case 6: return 48;
   case 5: return 48;
   case 4:
      if (devinfo->is_g4x) {
         return 48;
      } else {
         return 48;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DRAWING_RECTANGLE::Command SubType */


#define GEN10_3DSTATE_DRAWING_RECTANGLE_CommandSubType_bits  2
#define GEN9_3DSTATE_DRAWING_RECTANGLE_CommandSubType_bits  2
#define GEN8_3DSTATE_DRAWING_RECTANGLE_CommandSubType_bits  2
#define GEN75_3DSTATE_DRAWING_RECTANGLE_CommandSubType_bits  2
#define GEN7_3DSTATE_DRAWING_RECTANGLE_CommandSubType_bits  2
#define GEN6_3DSTATE_DRAWING_RECTANGLE_CommandSubType_bits  2
#define GEN5_3DSTATE_DRAWING_RECTANGLE_CommandSubType_bits  2
#define GEN45_3DSTATE_DRAWING_RECTANGLE_CommandSubType_bits  2
#define GEN4_3DSTATE_DRAWING_RECTANGLE_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 2;
   case 5: return 2;
   case 4:
      if (devinfo->is_g4x) {
         return 2;
      } else {
         return 2;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DRAWING_RECTANGLE_CommandSubType_start  27
#define GEN9_3DSTATE_DRAWING_RECTANGLE_CommandSubType_start  27
#define GEN8_3DSTATE_DRAWING_RECTANGLE_CommandSubType_start  27
#define GEN75_3DSTATE_DRAWING_RECTANGLE_CommandSubType_start  27
#define GEN7_3DSTATE_DRAWING_RECTANGLE_CommandSubType_start  27
#define GEN6_3DSTATE_DRAWING_RECTANGLE_CommandSubType_start  27
#define GEN5_3DSTATE_DRAWING_RECTANGLE_CommandSubType_start  27
#define GEN45_3DSTATE_DRAWING_RECTANGLE_CommandSubType_start  27
#define GEN4_3DSTATE_DRAWING_RECTANGLE_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 27;
      }
   case 6: return 27;
   case 5: return 27;
   case 4:
      if (devinfo->is_g4x) {
         return 27;
      } else {
         return 27;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DRAWING_RECTANGLE::Command Type */


#define GEN10_3DSTATE_DRAWING_RECTANGLE_CommandType_bits  3
#define GEN9_3DSTATE_DRAWING_RECTANGLE_CommandType_bits  3
#define GEN8_3DSTATE_DRAWING_RECTANGLE_CommandType_bits  3
#define GEN75_3DSTATE_DRAWING_RECTANGLE_CommandType_bits  3
#define GEN7_3DSTATE_DRAWING_RECTANGLE_CommandType_bits  3
#define GEN6_3DSTATE_DRAWING_RECTANGLE_CommandType_bits  3
#define GEN5_3DSTATE_DRAWING_RECTANGLE_CommandType_bits  3
#define GEN45_3DSTATE_DRAWING_RECTANGLE_CommandType_bits  3
#define GEN4_3DSTATE_DRAWING_RECTANGLE_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 3;
   case 4:
      if (devinfo->is_g4x) {
         return 3;
      } else {
         return 3;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DRAWING_RECTANGLE_CommandType_start  29
#define GEN9_3DSTATE_DRAWING_RECTANGLE_CommandType_start  29
#define GEN8_3DSTATE_DRAWING_RECTANGLE_CommandType_start  29
#define GEN75_3DSTATE_DRAWING_RECTANGLE_CommandType_start  29
#define GEN7_3DSTATE_DRAWING_RECTANGLE_CommandType_start  29
#define GEN6_3DSTATE_DRAWING_RECTANGLE_CommandType_start  29
#define GEN5_3DSTATE_DRAWING_RECTANGLE_CommandType_start  29
#define GEN45_3DSTATE_DRAWING_RECTANGLE_CommandType_start  29
#define GEN4_3DSTATE_DRAWING_RECTANGLE_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 29;
      }
   case 6: return 29;
   case 5: return 29;
   case 4:
      if (devinfo->is_g4x) {
         return 29;
      } else {
         return 29;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DRAWING_RECTANGLE::Core Mode Select */


#define GEN10_3DSTATE_DRAWING_RECTANGLE_CoreModeSelect_bits  2
#define GEN9_3DSTATE_DRAWING_RECTANGLE_CoreModeSelect_bits  2
#define GEN8_3DSTATE_DRAWING_RECTANGLE_CoreModeSelect_bits  2
#define GEN75_3DSTATE_DRAWING_RECTANGLE_CoreModeSelect_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_CoreModeSelect_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DRAWING_RECTANGLE_CoreModeSelect_start  14
#define GEN9_3DSTATE_DRAWING_RECTANGLE_CoreModeSelect_start  14
#define GEN8_3DSTATE_DRAWING_RECTANGLE_CoreModeSelect_start  14
#define GEN75_3DSTATE_DRAWING_RECTANGLE_CoreModeSelect_start  14

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_CoreModeSelect_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 14;
   case 9: return 14;
   case 8: return 14;
   case 7:
      if (devinfo->is_haswell) {
         return 14;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DRAWING_RECTANGLE::DWord Length */


#define GEN10_3DSTATE_DRAWING_RECTANGLE_DWordLength_bits  8
#define GEN9_3DSTATE_DRAWING_RECTANGLE_DWordLength_bits  8
#define GEN8_3DSTATE_DRAWING_RECTANGLE_DWordLength_bits  8
#define GEN75_3DSTATE_DRAWING_RECTANGLE_DWordLength_bits  8
#define GEN7_3DSTATE_DRAWING_RECTANGLE_DWordLength_bits  8
#define GEN6_3DSTATE_DRAWING_RECTANGLE_DWordLength_bits  8
#define GEN5_3DSTATE_DRAWING_RECTANGLE_DWordLength_bits  8
#define GEN45_3DSTATE_DRAWING_RECTANGLE_DWordLength_bits  8
#define GEN4_3DSTATE_DRAWING_RECTANGLE_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 8;
   case 4:
      if (devinfo->is_g4x) {
         return 8;
      } else {
         return 8;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DRAWING_RECTANGLE_DWordLength_start  0
#define GEN9_3DSTATE_DRAWING_RECTANGLE_DWordLength_start  0
#define GEN8_3DSTATE_DRAWING_RECTANGLE_DWordLength_start  0
#define GEN75_3DSTATE_DRAWING_RECTANGLE_DWordLength_start  0
#define GEN7_3DSTATE_DRAWING_RECTANGLE_DWordLength_start  0
#define GEN6_3DSTATE_DRAWING_RECTANGLE_DWordLength_start  0
#define GEN5_3DSTATE_DRAWING_RECTANGLE_DWordLength_start  0
#define GEN45_3DSTATE_DRAWING_RECTANGLE_DWordLength_start  0
#define GEN4_3DSTATE_DRAWING_RECTANGLE_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DRAWING_RECTANGLE::Drawing Rectangle Origin X */


#define GEN10_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_bits  16
#define GEN9_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_bits  16
#define GEN8_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_bits  16
#define GEN75_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_bits  16
#define GEN7_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_bits  16
#define GEN6_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_bits  16
#define GEN5_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_bits  16
#define GEN45_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_bits  16
#define GEN4_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 16;
   case 5: return 16;
   case 4:
      if (devinfo->is_g4x) {
         return 16;
      } else {
         return 16;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_start  96
#define GEN9_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_start  96
#define GEN8_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_start  96
#define GEN75_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_start  96
#define GEN7_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_start  96
#define GEN6_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_start  96
#define GEN5_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_start  96
#define GEN45_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_start  96
#define GEN4_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_start  96

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 96;
   case 9: return 96;
   case 8: return 96;
   case 7:
      if (devinfo->is_haswell) {
         return 96;
      } else {
         return 96;
      }
   case 6: return 96;
   case 5: return 96;
   case 4:
      if (devinfo->is_g4x) {
         return 96;
      } else {
         return 96;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DRAWING_RECTANGLE::Drawing Rectangle Origin Y */


#define GEN10_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_bits  16
#define GEN9_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_bits  16
#define GEN8_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_bits  16
#define GEN75_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_bits  16
#define GEN7_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_bits  16
#define GEN6_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_bits  16
#define GEN5_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_bits  16
#define GEN45_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_bits  16
#define GEN4_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 16;
   case 5: return 16;
   case 4:
      if (devinfo->is_g4x) {
         return 16;
      } else {
         return 16;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_start  112
#define GEN9_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_start  112
#define GEN8_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_start  112
#define GEN75_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_start  112
#define GEN7_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_start  112
#define GEN6_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_start  112
#define GEN5_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_start  112
#define GEN45_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_start  112
#define GEN4_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_start  112

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 112;
   case 9: return 112;
   case 8: return 112;
   case 7:
      if (devinfo->is_haswell) {
         return 112;
      } else {
         return 112;
      }
   case 6: return 112;
   case 5: return 112;
   case 4:
      if (devinfo->is_g4x) {
         return 112;
      } else {
         return 112;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS */


#define GEN10_3DSTATE_DS_length  11
#define GEN9_3DSTATE_DS_length  11
#define GEN8_3DSTATE_DS_length  9
#define GEN75_3DSTATE_DS_length  6
#define GEN7_3DSTATE_DS_length  6

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 11;
   case 9: return 11;
   case 8: return 9;
   case 7:
      if (devinfo->is_haswell) {
         return 6;
      } else {
         return 6;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::3D Command Opcode */


#define GEN10_3DSTATE_DS_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_DS_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_DS_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_DS_3DCommandOpcode_bits  3
#define GEN7_3DSTATE_DS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DS_3DCommandOpcode_start  24
#define GEN9_3DSTATE_DS_3DCommandOpcode_start  24
#define GEN8_3DSTATE_DS_3DCommandOpcode_start  24
#define GEN75_3DSTATE_DS_3DCommandOpcode_start  24
#define GEN7_3DSTATE_DS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 24;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::3D Command Sub Opcode */


#define GEN10_3DSTATE_DS_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_DS_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_DS_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_DS_3DCommandSubOpcode_bits  8
#define GEN7_3DSTATE_DS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DS_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_DS_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_DS_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_DS_3DCommandSubOpcode_start  16
#define GEN7_3DSTATE_DS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Accesses UAV */


#define GEN10_3DSTATE_DS_AccessesUAV_bits  1
#define GEN9_3DSTATE_DS_AccessesUAV_bits  1
#define GEN8_3DSTATE_DS_AccessesUAV_bits  1
#define GEN75_3DSTATE_DS_AccessesUAV_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_AccessesUAV_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DS_AccessesUAV_start  110
#define GEN9_3DSTATE_DS_AccessesUAV_start  110
#define GEN8_3DSTATE_DS_AccessesUAV_start  110
#define GEN75_3DSTATE_DS_AccessesUAV_start  78

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_AccessesUAV_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 110;
   case 9: return 110;
   case 8: return 110;
   case 7:
      if (devinfo->is_haswell) {
         return 78;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Binding Table Entry Count */


#define GEN10_3DSTATE_DS_BindingTableEntryCount_bits  8
#define GEN9_3DSTATE_DS_BindingTableEntryCount_bits  8
#define GEN8_3DSTATE_DS_BindingTableEntryCount_bits  8
#define GEN75_3DSTATE_DS_BindingTableEntryCount_bits  8
#define GEN7_3DSTATE_DS_BindingTableEntryCount_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_BindingTableEntryCount_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DS_BindingTableEntryCount_start  114
#define GEN9_3DSTATE_DS_BindingTableEntryCount_start  114
#define GEN8_3DSTATE_DS_BindingTableEntryCount_start  114
#define GEN75_3DSTATE_DS_BindingTableEntryCount_start  82
#define GEN7_3DSTATE_DS_BindingTableEntryCount_start  82

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_BindingTableEntryCount_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 114;
   case 9: return 114;
   case 8: return 114;
   case 7:
      if (devinfo->is_haswell) {
         return 82;
      } else {
         return 82;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Cache Disable */


#define GEN10_3DSTATE_DS_CacheDisable_bits  1
#define GEN9_3DSTATE_DS_CacheDisable_bits  1
#define GEN8_3DSTATE_DS_CacheDisable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_CacheDisable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DS_CacheDisable_start  225
#define GEN9_3DSTATE_DS_CacheDisable_start  225
#define GEN8_3DSTATE_DS_CacheDisable_start  225

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_CacheDisable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 225;
   case 9: return 225;
   case 8: return 225;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Command SubType */


#define GEN10_3DSTATE_DS_CommandSubType_bits  2
#define GEN9_3DSTATE_DS_CommandSubType_bits  2
#define GEN8_3DSTATE_DS_CommandSubType_bits  2
#define GEN75_3DSTATE_DS_CommandSubType_bits  2
#define GEN7_3DSTATE_DS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DS_CommandSubType_start  27
#define GEN9_3DSTATE_DS_CommandSubType_start  27
#define GEN8_3DSTATE_DS_CommandSubType_start  27
#define GEN75_3DSTATE_DS_CommandSubType_start  27
#define GEN7_3DSTATE_DS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 27;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Command Type */


#define GEN10_3DSTATE_DS_CommandType_bits  3
#define GEN9_3DSTATE_DS_CommandType_bits  3
#define GEN8_3DSTATE_DS_CommandType_bits  3
#define GEN75_3DSTATE_DS_CommandType_bits  3
#define GEN7_3DSTATE_DS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DS_CommandType_start  29
#define GEN9_3DSTATE_DS_CommandType_start  29
#define GEN8_3DSTATE_DS_CommandType_start  29
#define GEN75_3DSTATE_DS_CommandType_start  29
#define GEN7_3DSTATE_DS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 29;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Compute W Coordinate Enable */


#define GEN10_3DSTATE_DS_ComputeWCoordinateEnable_bits  1
#define GEN9_3DSTATE_DS_ComputeWCoordinateEnable_bits  1
#define GEN8_3DSTATE_DS_ComputeWCoordinateEnable_bits  1
#define GEN75_3DSTATE_DS_ComputeWCoordinateEnable_bits  1
#define GEN7_3DSTATE_DS_ComputeWCoordinateEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_ComputeWCoordinateEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DS_ComputeWCoordinateEnable_start  226
#define GEN9_3DSTATE_DS_ComputeWCoordinateEnable_start  226
#define GEN8_3DSTATE_DS_ComputeWCoordinateEnable_start  226
#define GEN75_3DSTATE_DS_ComputeWCoordinateEnable_start  162
#define GEN7_3DSTATE_DS_ComputeWCoordinateEnable_start  162

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_ComputeWCoordinateEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 226;
   case 9: return 226;
   case 8: return 226;
   case 7:
      if (devinfo->is_haswell) {
         return 162;
      } else {
         return 162;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::DS Cache Disable */


#define GEN75_3DSTATE_DS_DSCacheDisable_bits  1
#define GEN7_3DSTATE_DS_DSCacheDisable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_DSCacheDisable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN75_3DSTATE_DS_DSCacheDisable_start  161
#define GEN7_3DSTATE_DS_DSCacheDisable_start  161

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_DSCacheDisable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 161;
      } else {
         return 161;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::DUAL_PATCH Kernel Start Pointer */


#define GEN10_3DSTATE_DS_DUAL_PATCHKernelStartPointer_bits  58
#define GEN9_3DSTATE_DS_DUAL_PATCHKernelStartPointer_bits  58

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_DUAL_PATCHKernelStartPointer_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 58;
   case 9: return 58;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DS_DUAL_PATCHKernelStartPointer_start  294
#define GEN9_3DSTATE_DS_DUAL_PATCHKernelStartPointer_start  294

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_DUAL_PATCHKernelStartPointer_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 294;
   case 9: return 294;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::DWord Length */


#define GEN10_3DSTATE_DS_DWordLength_bits  8
#define GEN9_3DSTATE_DS_DWordLength_bits  8
#define GEN8_3DSTATE_DS_DWordLength_bits  8
#define GEN75_3DSTATE_DS_DWordLength_bits  8
#define GEN7_3DSTATE_DS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DS_DWordLength_start  0
#define GEN9_3DSTATE_DS_DWordLength_start  0
#define GEN8_3DSTATE_DS_DWordLength_start  0
#define GEN75_3DSTATE_DS_DWordLength_start  0
#define GEN7_3DSTATE_DS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Dispatch GRF Start Register For URB Data */


#define GEN10_3DSTATE_DS_DispatchGRFStartRegisterForURBData_bits  5
#define GEN9_3DSTATE_DS_DispatchGRFStartRegisterForURBData_bits  5
#define GEN8_3DSTATE_DS_DispatchGRFStartRegisterForURBData_bits  5
#define GEN75_3DSTATE_DS_DispatchGRFStartRegisterForURBData_bits  5
#define GEN7_3DSTATE_DS_DispatchGRFStartRegisterForURBData_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_DispatchGRFStartRegisterForURBData_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 5;
   case 9: return 5;
   case 8: return 5;
   case 7:
      if (devinfo->is_haswell) {
         return 5;
      } else {
         return 5;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DS_DispatchGRFStartRegisterForURBData_start  212
#define GEN9_3DSTATE_DS_DispatchGRFStartRegisterForURBData_start  212
#define GEN8_3DSTATE_DS_DispatchGRFStartRegisterForURBData_start  212
#define GEN75_3DSTATE_DS_DispatchGRFStartRegisterForURBData_start  148
#define GEN7_3DSTATE_DS_DispatchGRFStartRegisterForURBData_start  148

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_DispatchGRFStartRegisterForURBData_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 212;
   case 9: return 212;
   case 8: return 212;
   case 7:
      if (devinfo->is_haswell) {
         return 148;
      } else {
         return 148;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Dispatch Mode */


#define GEN10_3DSTATE_DS_DispatchMode_bits  2
#define GEN9_3DSTATE_DS_DispatchMode_bits  2
#define GEN8_3DSTATE_DS_DispatchMode_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_DispatchMode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DS_DispatchMode_start  227
#define GEN9_3DSTATE_DS_DispatchMode_start  227
#define GEN8_3DSTATE_DS_DispatchMode_start  227

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_DispatchMode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 227;
   case 9: return 227;
   case 8: return 227;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Enable */


#define GEN10_3DSTATE_DS_Enable_bits  1
#define GEN9_3DSTATE_DS_Enable_bits  1
#define GEN8_3DSTATE_DS_Enable_bits  1
#define GEN75_3DSTATE_DS_Enable_bits  1
#define GEN7_3DSTATE_DS_Enable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_Enable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DS_Enable_start  224
#define GEN9_3DSTATE_DS_Enable_start  224
#define GEN8_3DSTATE_DS_Enable_start  224
#define GEN75_3DSTATE_DS_Enable_start  160
#define GEN7_3DSTATE_DS_Enable_start  160

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_Enable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 224;
   case 9: return 224;
   case 8: return 224;
   case 7:
      if (devinfo->is_haswell) {
         return 160;
      } else {
         return 160;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Floating Point Mode */


#define GEN10_3DSTATE_DS_FloatingPointMode_bits  1
#define GEN9_3DSTATE_DS_FloatingPointMode_bits  1
#define GEN8_3DSTATE_DS_FloatingPointMode_bits  1
#define GEN75_3DSTATE_DS_FloatingPointMode_bits  1
#define GEN7_3DSTATE_DS_FloatingPointMode_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_FloatingPointMode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DS_FloatingPointMode_start  112
#define GEN9_3DSTATE_DS_FloatingPointMode_start  112
#define GEN8_3DSTATE_DS_FloatingPointMode_start  112
#define GEN75_3DSTATE_DS_FloatingPointMode_start  80
#define GEN7_3DSTATE_DS_FloatingPointMode_start  80

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_FloatingPointMode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 112;
   case 9: return 112;
   case 8: return 112;
   case 7:
      if (devinfo->is_haswell) {
         return 80;
      } else {
         return 80;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Illegal Opcode Exception Enable */


#define GEN10_3DSTATE_DS_IllegalOpcodeExceptionEnable_bits  1
#define GEN9_3DSTATE_DS_IllegalOpcodeExceptionEnable_bits  1
#define GEN8_3DSTATE_DS_IllegalOpcodeExceptionEnable_bits  1
#define GEN75_3DSTATE_DS_IllegalOpcodeExceptionEnable_bits  1
#define GEN7_3DSTATE_DS_IllegalOpcodeExceptionEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_IllegalOpcodeExceptionEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DS_IllegalOpcodeExceptionEnable_start  109
#define GEN9_3DSTATE_DS_IllegalOpcodeExceptionEnable_start  109
#define GEN8_3DSTATE_DS_IllegalOpcodeExceptionEnable_start  109
#define GEN75_3DSTATE_DS_IllegalOpcodeExceptionEnable_start  77
#define GEN7_3DSTATE_DS_IllegalOpcodeExceptionEnable_start  77

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_IllegalOpcodeExceptionEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 109;
   case 9: return 109;
   case 8: return 109;
   case 7:
      if (devinfo->is_haswell) {
         return 77;
      } else {
         return 77;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Kernel Start Pointer */


#define GEN10_3DSTATE_DS_KernelStartPointer_bits  58
#define GEN9_3DSTATE_DS_KernelStartPointer_bits  58
#define GEN8_3DSTATE_DS_KernelStartPointer_bits  58
#define GEN75_3DSTATE_DS_KernelStartPointer_bits  26
#define GEN7_3DSTATE_DS_KernelStartPointer_bits  26

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_KernelStartPointer_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 58;
   case 9: return 58;
   case 8: return 58;
   case 7:
      if (devinfo->is_haswell) {
         return 26;
      } else {
         return 26;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DS_KernelStartPointer_start  38
#define GEN9_3DSTATE_DS_KernelStartPointer_start  38
#define GEN8_3DSTATE_DS_KernelStartPointer_start  38
#define GEN75_3DSTATE_DS_KernelStartPointer_start  38
#define GEN7_3DSTATE_DS_KernelStartPointer_start  38

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_KernelStartPointer_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 38;
   case 9: return 38;
   case 8: return 38;
   case 7:
      if (devinfo->is_haswell) {
         return 38;
      } else {
         return 38;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Maximum Number of Threads */


#define GEN10_3DSTATE_DS_MaximumNumberofThreads_bits  10
#define GEN9_3DSTATE_DS_MaximumNumberofThreads_bits  9
#define GEN8_3DSTATE_DS_MaximumNumberofThreads_bits  9
#define GEN75_3DSTATE_DS_MaximumNumberofThreads_bits  9
#define GEN7_3DSTATE_DS_MaximumNumberofThreads_bits  7

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_MaximumNumberofThreads_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 10;
   case 9: return 9;
   case 8: return 9;
   case 7:
      if (devinfo->is_haswell) {
         return 9;
      } else {
         return 7;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DS_MaximumNumberofThreads_start  245
#define GEN9_3DSTATE_DS_MaximumNumberofThreads_start  245
#define GEN8_3DSTATE_DS_MaximumNumberofThreads_start  245
#define GEN75_3DSTATE_DS_MaximumNumberofThreads_start  181
#define GEN7_3DSTATE_DS_MaximumNumberofThreads_start  185

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_MaximumNumberofThreads_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 245;
   case 9: return 245;
   case 8: return 245;
   case 7:
      if (devinfo->is_haswell) {
         return 181;
      } else {
         return 185;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Patch URB Entry Read Length */


#define GEN10_3DSTATE_DS_PatchURBEntryReadLength_bits  7
#define GEN9_3DSTATE_DS_PatchURBEntryReadLength_bits  7
#define GEN8_3DSTATE_DS_PatchURBEntryReadLength_bits  7
#define GEN75_3DSTATE_DS_PatchURBEntryReadLength_bits  7
#define GEN7_3DSTATE_DS_PatchURBEntryReadLength_bits  7

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_PatchURBEntryReadLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 7;
   case 9: return 7;
   case 8: return 7;
   case 7:
      if (devinfo->is_haswell) {
         return 7;
      } else {
         return 7;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DS_PatchURBEntryReadLength_start  203
#define GEN9_3DSTATE_DS_PatchURBEntryReadLength_start  203
#define GEN8_3DSTATE_DS_PatchURBEntryReadLength_start  203
#define GEN75_3DSTATE_DS_PatchURBEntryReadLength_start  139
#define GEN7_3DSTATE_DS_PatchURBEntryReadLength_start  139

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_PatchURBEntryReadLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 203;
   case 9: return 203;
   case 8: return 203;
   case 7:
      if (devinfo->is_haswell) {
         return 139;
      } else {
         return 139;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Patch URB Entry Read Offset */


#define GEN10_3DSTATE_DS_PatchURBEntryReadOffset_bits  6
#define GEN9_3DSTATE_DS_PatchURBEntryReadOffset_bits  6
#define GEN8_3DSTATE_DS_PatchURBEntryReadOffset_bits  6
#define GEN75_3DSTATE_DS_PatchURBEntryReadOffset_bits  6
#define GEN7_3DSTATE_DS_PatchURBEntryReadOffset_bits  6

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_PatchURBEntryReadOffset_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 6;
   case 9: return 6;
   case 8: return 6;
   case 7:
      if (devinfo->is_haswell) {
         return 6;
      } else {
         return 6;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DS_PatchURBEntryReadOffset_start  196
#define GEN9_3DSTATE_DS_PatchURBEntryReadOffset_start  196
#define GEN8_3DSTATE_DS_PatchURBEntryReadOffset_start  196
#define GEN75_3DSTATE_DS_PatchURBEntryReadOffset_start  132
#define GEN7_3DSTATE_DS_PatchURBEntryReadOffset_start  132

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_PatchURBEntryReadOffset_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 196;
   case 9: return 196;
   case 8: return 196;
   case 7:
      if (devinfo->is_haswell) {
         return 132;
      } else {
         return 132;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Per-Thread Scratch Space */


#define GEN10_3DSTATE_DS_PerThreadScratchSpace_bits  4
#define GEN9_3DSTATE_DS_PerThreadScratchSpace_bits  4
#define GEN8_3DSTATE_DS_PerThreadScratchSpace_bits  4
#define GEN75_3DSTATE_DS_PerThreadScratchSpace_bits  4
#define GEN7_3DSTATE_DS_PerThreadScratchSpace_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_PerThreadScratchSpace_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 4;
   case 9: return 4;
   case 8: return 4;
   case 7:
      if (devinfo->is_haswell) {
         return 4;
      } else {
         return 4;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DS_PerThreadScratchSpace_start  128
#define GEN9_3DSTATE_DS_PerThreadScratchSpace_start  128
#define GEN8_3DSTATE_DS_PerThreadScratchSpace_start  128
#define GEN75_3DSTATE_DS_PerThreadScratchSpace_start  96
#define GEN7_3DSTATE_DS_PerThreadScratchSpace_start  96

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_PerThreadScratchSpace_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 128;
   case 9: return 128;
   case 8: return 128;
   case 7:
      if (devinfo->is_haswell) {
         return 96;
      } else {
         return 96;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Sampler Count */


#define GEN10_3DSTATE_DS_SamplerCount_bits  3
#define GEN9_3DSTATE_DS_SamplerCount_bits  3
#define GEN8_3DSTATE_DS_SamplerCount_bits  3
#define GEN75_3DSTATE_DS_SamplerCount_bits  3
#define GEN7_3DSTATE_DS_SamplerCount_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_SamplerCount_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DS_SamplerCount_start  123
#define GEN9_3DSTATE_DS_SamplerCount_start  123
#define GEN8_3DSTATE_DS_SamplerCount_start  123
#define GEN75_3DSTATE_DS_SamplerCount_start  91
#define GEN7_3DSTATE_DS_SamplerCount_start  91

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_SamplerCount_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 123;
   case 9: return 123;
   case 8: return 123;
   case 7:
      if (devinfo->is_haswell) {
         return 91;
      } else {
         return 91;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Scratch Space Base Pointer */


#define GEN10_3DSTATE_DS_ScratchSpaceBasePointer_bits  54
#define GEN9_3DSTATE_DS_ScratchSpaceBasePointer_bits  54
#define GEN8_3DSTATE_DS_ScratchSpaceBasePointer_bits  54
#define GEN75_3DSTATE_DS_ScratchSpaceBasePointer_bits  22
#define GEN7_3DSTATE_DS_ScratchSpaceBasePointer_bits  22

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_ScratchSpaceBasePointer_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 54;
   case 9: return 54;
   case 8: return 54;
   case 7:
      if (devinfo->is_haswell) {
         return 22;
      } else {
         return 22;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DS_ScratchSpaceBasePointer_start  138
#define GEN9_3DSTATE_DS_ScratchSpaceBasePointer_start  138
#define GEN8_3DSTATE_DS_ScratchSpaceBasePointer_start  138
#define GEN75_3DSTATE_DS_ScratchSpaceBasePointer_start  106
#define GEN7_3DSTATE_DS_ScratchSpaceBasePointer_start  106

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_ScratchSpaceBasePointer_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 138;
   case 9: return 138;
   case 8: return 138;
   case 7:
      if (devinfo->is_haswell) {
         return 106;
      } else {
         return 106;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Single Domain Point Dispatch */


#define GEN8_3DSTATE_DS_SingleDomainPointDispatch_bits  1
#define GEN75_3DSTATE_DS_SingleDomainPointDispatch_bits  1
#define GEN7_3DSTATE_DS_SingleDomainPointDispatch_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_SingleDomainPointDispatch_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN8_3DSTATE_DS_SingleDomainPointDispatch_start  127
#define GEN75_3DSTATE_DS_SingleDomainPointDispatch_start  95
#define GEN7_3DSTATE_DS_SingleDomainPointDispatch_start  95

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_SingleDomainPointDispatch_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 127;
   case 7:
      if (devinfo->is_haswell) {
         return 95;
      } else {
         return 95;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Software Exception Enable */


#define GEN10_3DSTATE_DS_SoftwareExceptionEnable_bits  1
#define GEN9_3DSTATE_DS_SoftwareExceptionEnable_bits  1
#define GEN8_3DSTATE_DS_SoftwareExceptionEnable_bits  1
#define GEN75_3DSTATE_DS_SoftwareExceptionEnable_bits  1
#define GEN7_3DSTATE_DS_SoftwareExceptionEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_SoftwareExceptionEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DS_SoftwareExceptionEnable_start  103
#define GEN9_3DSTATE_DS_SoftwareExceptionEnable_start  103
#define GEN8_3DSTATE_DS_SoftwareExceptionEnable_start  103
#define GEN75_3DSTATE_DS_SoftwareExceptionEnable_start  71
#define GEN7_3DSTATE_DS_SoftwareExceptionEnable_start  71

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_SoftwareExceptionEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 103;
   case 9: return 103;
   case 8: return 103;
   case 7:
      if (devinfo->is_haswell) {
         return 71;
      } else {
         return 71;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Statistics Enable */


#define GEN10_3DSTATE_DS_StatisticsEnable_bits  1
#define GEN9_3DSTATE_DS_StatisticsEnable_bits  1
#define GEN8_3DSTATE_DS_StatisticsEnable_bits  1
#define GEN75_3DSTATE_DS_StatisticsEnable_bits  1
#define GEN7_3DSTATE_DS_StatisticsEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_StatisticsEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DS_StatisticsEnable_start  234
#define GEN9_3DSTATE_DS_StatisticsEnable_start  234
#define GEN8_3DSTATE_DS_StatisticsEnable_start  234
#define GEN75_3DSTATE_DS_StatisticsEnable_start  170
#define GEN7_3DSTATE_DS_StatisticsEnable_start  170

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_StatisticsEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 234;
   case 9: return 234;
   case 8: return 234;
   case 7:
      if (devinfo->is_haswell) {
         return 170;
      } else {
         return 170;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Thread Dispatch Priority */


#define GEN10_3DSTATE_DS_ThreadDispatchPriority_bits  1
#define GEN9_3DSTATE_DS_ThreadDispatchPriority_bits  1
#define GEN8_3DSTATE_DS_ThreadDispatchPriority_bits  1
#define GEN75_3DSTATE_DS_ThreadDispatchPriority_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_ThreadDispatchPriority_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DS_ThreadDispatchPriority_start  113
#define GEN9_3DSTATE_DS_ThreadDispatchPriority_start  113
#define GEN8_3DSTATE_DS_ThreadDispatchPriority_start  113
#define GEN75_3DSTATE_DS_ThreadDispatchPriority_start  81

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_ThreadDispatchPriority_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 113;
   case 9: return 113;
   case 8: return 113;
   case 7:
      if (devinfo->is_haswell) {
         return 81;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::User Clip Distance Clip Test Enable Bitmask */


#define GEN10_3DSTATE_DS_UserClipDistanceClipTestEnableBitmask_bits  8
#define GEN9_3DSTATE_DS_UserClipDistanceClipTestEnableBitmask_bits  8
#define GEN8_3DSTATE_DS_UserClipDistanceClipTestEnableBitmask_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_UserClipDistanceClipTestEnableBitmask_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DS_UserClipDistanceClipTestEnableBitmask_start  264
#define GEN9_3DSTATE_DS_UserClipDistanceClipTestEnableBitmask_start  264
#define GEN8_3DSTATE_DS_UserClipDistanceClipTestEnableBitmask_start  264

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_UserClipDistanceClipTestEnableBitmask_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 264;
   case 9: return 264;
   case 8: return 264;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::User Clip Distance Cull Test Enable Bitmask */


#define GEN10_3DSTATE_DS_UserClipDistanceCullTestEnableBitmask_bits  8
#define GEN9_3DSTATE_DS_UserClipDistanceCullTestEnableBitmask_bits  8
#define GEN8_3DSTATE_DS_UserClipDistanceCullTestEnableBitmask_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_UserClipDistanceCullTestEnableBitmask_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DS_UserClipDistanceCullTestEnableBitmask_start  256
#define GEN9_3DSTATE_DS_UserClipDistanceCullTestEnableBitmask_start  256
#define GEN8_3DSTATE_DS_UserClipDistanceCullTestEnableBitmask_start  256

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_UserClipDistanceCullTestEnableBitmask_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 256;
   case 9: return 256;
   case 8: return 256;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Vector Mask Enable */


#define GEN10_3DSTATE_DS_VectorMaskEnable_bits  1
#define GEN9_3DSTATE_DS_VectorMaskEnable_bits  1
#define GEN8_3DSTATE_DS_VectorMaskEnable_bits  1
#define GEN75_3DSTATE_DS_VectorMaskEnable_bits  1
#define GEN7_3DSTATE_DS_VectorMaskEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_VectorMaskEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DS_VectorMaskEnable_start  126
#define GEN9_3DSTATE_DS_VectorMaskEnable_start  126
#define GEN8_3DSTATE_DS_VectorMaskEnable_start  126
#define GEN75_3DSTATE_DS_VectorMaskEnable_start  94
#define GEN7_3DSTATE_DS_VectorMaskEnable_start  94

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_VectorMaskEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 126;
   case 9: return 126;
   case 8: return 126;
   case 7:
      if (devinfo->is_haswell) {
         return 94;
      } else {
         return 94;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Vertex URB Entry Output Length */


#define GEN10_3DSTATE_DS_VertexURBEntryOutputLength_bits  5
#define GEN9_3DSTATE_DS_VertexURBEntryOutputLength_bits  5
#define GEN8_3DSTATE_DS_VertexURBEntryOutputLength_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_VertexURBEntryOutputLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 5;
   case 9: return 5;
   case 8: return 5;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DS_VertexURBEntryOutputLength_start  272
#define GEN9_3DSTATE_DS_VertexURBEntryOutputLength_start  272
#define GEN8_3DSTATE_DS_VertexURBEntryOutputLength_start  272

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_VertexURBEntryOutputLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 272;
   case 9: return 272;
   case 8: return 272;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Vertex URB Entry Output Read Offset */


#define GEN10_3DSTATE_DS_VertexURBEntryOutputReadOffset_bits  6
#define GEN9_3DSTATE_DS_VertexURBEntryOutputReadOffset_bits  6
#define GEN8_3DSTATE_DS_VertexURBEntryOutputReadOffset_bits  6

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_VertexURBEntryOutputReadOffset_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 6;
   case 9: return 6;
   case 8: return 6;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_DS_VertexURBEntryOutputReadOffset_start  277
#define GEN9_3DSTATE_DS_VertexURBEntryOutputReadOffset_start  277
#define GEN8_3DSTATE_DS_VertexURBEntryOutputReadOffset_start  277

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_VertexURBEntryOutputReadOffset_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 277;
   case 9: return 277;
   case 8: return 277;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_DS */





/* 3DSTATE_GATHER_CONSTANT_DS::3D Command Opcode */


#define GEN10_3DSTATE_GATHER_CONSTANT_DS_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_GATHER_CONSTANT_DS_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_GATHER_CONSTANT_DS_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_GATHER_CONSTANT_DS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_DS_3DCommandOpcode_start  24
#define GEN9_3DSTATE_GATHER_CONSTANT_DS_3DCommandOpcode_start  24
#define GEN8_3DSTATE_GATHER_CONSTANT_DS_3DCommandOpcode_start  24
#define GEN75_3DSTATE_GATHER_CONSTANT_DS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_DS::3D Command Sub Opcode */


#define GEN10_3DSTATE_GATHER_CONSTANT_DS_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_GATHER_CONSTANT_DS_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_GATHER_CONSTANT_DS_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_GATHER_CONSTANT_DS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_DS_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_GATHER_CONSTANT_DS_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_GATHER_CONSTANT_DS_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_GATHER_CONSTANT_DS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_DS::Command SubType */


#define GEN10_3DSTATE_GATHER_CONSTANT_DS_CommandSubType_bits  2
#define GEN9_3DSTATE_GATHER_CONSTANT_DS_CommandSubType_bits  2
#define GEN8_3DSTATE_GATHER_CONSTANT_DS_CommandSubType_bits  2
#define GEN75_3DSTATE_GATHER_CONSTANT_DS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_DS_CommandSubType_start  27
#define GEN9_3DSTATE_GATHER_CONSTANT_DS_CommandSubType_start  27
#define GEN8_3DSTATE_GATHER_CONSTANT_DS_CommandSubType_start  27
#define GEN75_3DSTATE_GATHER_CONSTANT_DS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_DS::Command Type */


#define GEN10_3DSTATE_GATHER_CONSTANT_DS_CommandType_bits  3
#define GEN9_3DSTATE_GATHER_CONSTANT_DS_CommandType_bits  3
#define GEN8_3DSTATE_GATHER_CONSTANT_DS_CommandType_bits  3
#define GEN75_3DSTATE_GATHER_CONSTANT_DS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_DS_CommandType_start  29
#define GEN9_3DSTATE_GATHER_CONSTANT_DS_CommandType_start  29
#define GEN8_3DSTATE_GATHER_CONSTANT_DS_CommandType_start  29
#define GEN75_3DSTATE_GATHER_CONSTANT_DS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_DS::Constant Buffer Binding Table Block */


#define GEN10_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferBindingTableBlock_bits  4
#define GEN9_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferBindingTableBlock_bits  4
#define GEN8_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferBindingTableBlock_bits  4
#define GEN75_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferBindingTableBlock_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferBindingTableBlock_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 4;
   case 9: return 4;
   case 8: return 4;
   case 7:
      if (devinfo->is_haswell) {
         return 4;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferBindingTableBlock_start  44
#define GEN9_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferBindingTableBlock_start  44
#define GEN8_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferBindingTableBlock_start  44
#define GEN75_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferBindingTableBlock_start  44

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferBindingTableBlock_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 44;
   case 9: return 44;
   case 8: return 44;
   case 7:
      if (devinfo->is_haswell) {
         return 44;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_DS::Constant Buffer Dx9 Generate Stall */


#define GEN10_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferDx9GenerateStall_bits  1
#define GEN9_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferDx9GenerateStall_bits  1
#define GEN8_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferDx9GenerateStall_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferDx9GenerateStall_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferDx9GenerateStall_start  69
#define GEN9_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferDx9GenerateStall_start  69
#define GEN8_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferDx9GenerateStall_start  69

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferDx9GenerateStall_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 69;
   case 9: return 69;
   case 8: return 69;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_DS::Constant Buffer Valid */


#define GEN10_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferValid_bits  16
#define GEN9_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferValid_bits  16
#define GEN8_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferValid_bits  16
#define GEN75_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferValid_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferValid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferValid_start  48
#define GEN9_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferValid_start  48
#define GEN8_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferValid_start  48
#define GEN75_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferValid_start  48

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferValid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 48;
   case 9: return 48;
   case 8: return 48;
   case 7:
      if (devinfo->is_haswell) {
         return 48;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_DS::DWord Length */


#define GEN10_3DSTATE_GATHER_CONSTANT_DS_DWordLength_bits  8
#define GEN9_3DSTATE_GATHER_CONSTANT_DS_DWordLength_bits  8
#define GEN8_3DSTATE_GATHER_CONSTANT_DS_DWordLength_bits  8
#define GEN75_3DSTATE_GATHER_CONSTANT_DS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_DS_DWordLength_start  0
#define GEN9_3DSTATE_GATHER_CONSTANT_DS_DWordLength_start  0
#define GEN8_3DSTATE_GATHER_CONSTANT_DS_DWordLength_start  0
#define GEN75_3DSTATE_GATHER_CONSTANT_DS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_DS::Entry_0 */


#define GEN10_3DSTATE_GATHER_CONSTANT_DS_Entry_0_bits  16
#define GEN9_3DSTATE_GATHER_CONSTANT_DS_Entry_0_bits  16
#define GEN8_3DSTATE_GATHER_CONSTANT_DS_Entry_0_bits  16
#define GEN75_3DSTATE_GATHER_CONSTANT_DS_Entry_0_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_Entry_0_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_DS_Entry_0_start  0
#define GEN9_3DSTATE_GATHER_CONSTANT_DS_Entry_0_start  0
#define GEN8_3DSTATE_GATHER_CONSTANT_DS_Entry_0_start  0
#define GEN75_3DSTATE_GATHER_CONSTANT_DS_Entry_0_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_Entry_0_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_DS::Entry_1 */


#define GEN10_3DSTATE_GATHER_CONSTANT_DS_Entry_1_bits  16
#define GEN9_3DSTATE_GATHER_CONSTANT_DS_Entry_1_bits  16
#define GEN8_3DSTATE_GATHER_CONSTANT_DS_Entry_1_bits  16
#define GEN75_3DSTATE_GATHER_CONSTANT_DS_Entry_1_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_Entry_1_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_DS_Entry_1_start  16
#define GEN9_3DSTATE_GATHER_CONSTANT_DS_Entry_1_start  16
#define GEN8_3DSTATE_GATHER_CONSTANT_DS_Entry_1_start  16
#define GEN75_3DSTATE_GATHER_CONSTANT_DS_Entry_1_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_Entry_1_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_DS::Gather Buffer Offset */


#define GEN10_3DSTATE_GATHER_CONSTANT_DS_GatherBufferOffset_bits  17
#define GEN9_3DSTATE_GATHER_CONSTANT_DS_GatherBufferOffset_bits  17
#define GEN8_3DSTATE_GATHER_CONSTANT_DS_GatherBufferOffset_bits  17
#define GEN75_3DSTATE_GATHER_CONSTANT_DS_GatherBufferOffset_bits  17

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_GatherBufferOffset_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 17;
   case 9: return 17;
   case 8: return 17;
   case 7:
      if (devinfo->is_haswell) {
         return 17;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_DS_GatherBufferOffset_start  70
#define GEN9_3DSTATE_GATHER_CONSTANT_DS_GatherBufferOffset_start  70
#define GEN8_3DSTATE_GATHER_CONSTANT_DS_GatherBufferOffset_start  70
#define GEN75_3DSTATE_GATHER_CONSTANT_DS_GatherBufferOffset_start  70

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_GatherBufferOffset_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 70;
   case 9: return 70;
   case 8: return 70;
   case 7:
      if (devinfo->is_haswell) {
         return 70;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_DS::On-Die Table */


#define GEN10_3DSTATE_GATHER_CONSTANT_DS_OnDieTable_bits  1
#define GEN9_3DSTATE_GATHER_CONSTANT_DS_OnDieTable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_OnDieTable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_DS_OnDieTable_start  67
#define GEN9_3DSTATE_GATHER_CONSTANT_DS_OnDieTable_start  67

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_OnDieTable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 67;
   case 9: return 67;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_DS::Update Gather Table Only */


#define GEN10_3DSTATE_GATHER_CONSTANT_DS_UpdateGatherTableOnly_bits  1
#define GEN9_3DSTATE_GATHER_CONSTANT_DS_UpdateGatherTableOnly_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_UpdateGatherTableOnly_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_DS_UpdateGatherTableOnly_start  33
#define GEN9_3DSTATE_GATHER_CONSTANT_DS_UpdateGatherTableOnly_start  33

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_UpdateGatherTableOnly_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 33;
   case 9: return 33;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_GS */





/* 3DSTATE_GATHER_CONSTANT_GS::3D Command Opcode */


#define GEN10_3DSTATE_GATHER_CONSTANT_GS_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_GATHER_CONSTANT_GS_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_GATHER_CONSTANT_GS_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_GATHER_CONSTANT_GS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_GS_3DCommandOpcode_start  24
#define GEN9_3DSTATE_GATHER_CONSTANT_GS_3DCommandOpcode_start  24
#define GEN8_3DSTATE_GATHER_CONSTANT_GS_3DCommandOpcode_start  24
#define GEN75_3DSTATE_GATHER_CONSTANT_GS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_GS::3D Command Sub Opcode */


#define GEN10_3DSTATE_GATHER_CONSTANT_GS_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_GATHER_CONSTANT_GS_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_GATHER_CONSTANT_GS_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_GATHER_CONSTANT_GS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_GS_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_GATHER_CONSTANT_GS_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_GATHER_CONSTANT_GS_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_GATHER_CONSTANT_GS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_GS::Command SubType */


#define GEN10_3DSTATE_GATHER_CONSTANT_GS_CommandSubType_bits  2
#define GEN9_3DSTATE_GATHER_CONSTANT_GS_CommandSubType_bits  2
#define GEN8_3DSTATE_GATHER_CONSTANT_GS_CommandSubType_bits  2
#define GEN75_3DSTATE_GATHER_CONSTANT_GS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_GS_CommandSubType_start  27
#define GEN9_3DSTATE_GATHER_CONSTANT_GS_CommandSubType_start  27
#define GEN8_3DSTATE_GATHER_CONSTANT_GS_CommandSubType_start  27
#define GEN75_3DSTATE_GATHER_CONSTANT_GS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_GS::Command Type */


#define GEN10_3DSTATE_GATHER_CONSTANT_GS_CommandType_bits  3
#define GEN9_3DSTATE_GATHER_CONSTANT_GS_CommandType_bits  3
#define GEN8_3DSTATE_GATHER_CONSTANT_GS_CommandType_bits  3
#define GEN75_3DSTATE_GATHER_CONSTANT_GS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_GS_CommandType_start  29
#define GEN9_3DSTATE_GATHER_CONSTANT_GS_CommandType_start  29
#define GEN8_3DSTATE_GATHER_CONSTANT_GS_CommandType_start  29
#define GEN75_3DSTATE_GATHER_CONSTANT_GS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_GS::Constant Buffer Binding Table Block */


#define GEN10_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferBindingTableBlock_bits  4
#define GEN9_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferBindingTableBlock_bits  4
#define GEN8_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferBindingTableBlock_bits  4
#define GEN75_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferBindingTableBlock_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferBindingTableBlock_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 4;
   case 9: return 4;
   case 8: return 4;
   case 7:
      if (devinfo->is_haswell) {
         return 4;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferBindingTableBlock_start  44
#define GEN9_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferBindingTableBlock_start  44
#define GEN8_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferBindingTableBlock_start  44
#define GEN75_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferBindingTableBlock_start  44

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferBindingTableBlock_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 44;
   case 9: return 44;
   case 8: return 44;
   case 7:
      if (devinfo->is_haswell) {
         return 44;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_GS::Constant Buffer Dx9 Generate Stall */


#define GEN10_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferDx9GenerateStall_bits  1
#define GEN9_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferDx9GenerateStall_bits  1
#define GEN8_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferDx9GenerateStall_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferDx9GenerateStall_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferDx9GenerateStall_start  69
#define GEN9_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferDx9GenerateStall_start  69
#define GEN8_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferDx9GenerateStall_start  69

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferDx9GenerateStall_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 69;
   case 9: return 69;
   case 8: return 69;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_GS::Constant Buffer Valid */


#define GEN10_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferValid_bits  16
#define GEN9_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferValid_bits  16
#define GEN8_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferValid_bits  16
#define GEN75_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferValid_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferValid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferValid_start  48
#define GEN9_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferValid_start  48
#define GEN8_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferValid_start  48
#define GEN75_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferValid_start  48

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferValid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 48;
   case 9: return 48;
   case 8: return 48;
   case 7:
      if (devinfo->is_haswell) {
         return 48;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_GS::DWord Length */


#define GEN10_3DSTATE_GATHER_CONSTANT_GS_DWordLength_bits  8
#define GEN9_3DSTATE_GATHER_CONSTANT_GS_DWordLength_bits  8
#define GEN8_3DSTATE_GATHER_CONSTANT_GS_DWordLength_bits  8
#define GEN75_3DSTATE_GATHER_CONSTANT_GS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_GS_DWordLength_start  0
#define GEN9_3DSTATE_GATHER_CONSTANT_GS_DWordLength_start  0
#define GEN8_3DSTATE_GATHER_CONSTANT_GS_DWordLength_start  0
#define GEN75_3DSTATE_GATHER_CONSTANT_GS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_GS::Entry_0 */


#define GEN10_3DSTATE_GATHER_CONSTANT_GS_Entry_0_bits  16
#define GEN9_3DSTATE_GATHER_CONSTANT_GS_Entry_0_bits  16
#define GEN8_3DSTATE_GATHER_CONSTANT_GS_Entry_0_bits  16
#define GEN75_3DSTATE_GATHER_CONSTANT_GS_Entry_0_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_Entry_0_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_GS_Entry_0_start  0
#define GEN9_3DSTATE_GATHER_CONSTANT_GS_Entry_0_start  0
#define GEN8_3DSTATE_GATHER_CONSTANT_GS_Entry_0_start  0
#define GEN75_3DSTATE_GATHER_CONSTANT_GS_Entry_0_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_Entry_0_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_GS::Entry_1 */


#define GEN10_3DSTATE_GATHER_CONSTANT_GS_Entry_1_bits  16
#define GEN9_3DSTATE_GATHER_CONSTANT_GS_Entry_1_bits  16
#define GEN8_3DSTATE_GATHER_CONSTANT_GS_Entry_1_bits  16
#define GEN75_3DSTATE_GATHER_CONSTANT_GS_Entry_1_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_Entry_1_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_GS_Entry_1_start  16
#define GEN9_3DSTATE_GATHER_CONSTANT_GS_Entry_1_start  16
#define GEN8_3DSTATE_GATHER_CONSTANT_GS_Entry_1_start  16
#define GEN75_3DSTATE_GATHER_CONSTANT_GS_Entry_1_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_Entry_1_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_GS::Gather Buffer Offset */


#define GEN10_3DSTATE_GATHER_CONSTANT_GS_GatherBufferOffset_bits  17
#define GEN9_3DSTATE_GATHER_CONSTANT_GS_GatherBufferOffset_bits  17
#define GEN8_3DSTATE_GATHER_CONSTANT_GS_GatherBufferOffset_bits  17
#define GEN75_3DSTATE_GATHER_CONSTANT_GS_GatherBufferOffset_bits  17

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_GatherBufferOffset_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 17;
   case 9: return 17;
   case 8: return 17;
   case 7:
      if (devinfo->is_haswell) {
         return 17;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_GS_GatherBufferOffset_start  70
#define GEN9_3DSTATE_GATHER_CONSTANT_GS_GatherBufferOffset_start  70
#define GEN8_3DSTATE_GATHER_CONSTANT_GS_GatherBufferOffset_start  70
#define GEN75_3DSTATE_GATHER_CONSTANT_GS_GatherBufferOffset_start  70

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_GatherBufferOffset_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 70;
   case 9: return 70;
   case 8: return 70;
   case 7:
      if (devinfo->is_haswell) {
         return 70;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_GS::On-Die Table */


#define GEN10_3DSTATE_GATHER_CONSTANT_GS_OnDieTable_bits  1
#define GEN9_3DSTATE_GATHER_CONSTANT_GS_OnDieTable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_OnDieTable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_GS_OnDieTable_start  67
#define GEN9_3DSTATE_GATHER_CONSTANT_GS_OnDieTable_start  67

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_OnDieTable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 67;
   case 9: return 67;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_GS::Update Gather Table Only */


#define GEN10_3DSTATE_GATHER_CONSTANT_GS_UpdateGatherTableOnly_bits  1
#define GEN9_3DSTATE_GATHER_CONSTANT_GS_UpdateGatherTableOnly_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_UpdateGatherTableOnly_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_GS_UpdateGatherTableOnly_start  33
#define GEN9_3DSTATE_GATHER_CONSTANT_GS_UpdateGatherTableOnly_start  33

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_UpdateGatherTableOnly_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 33;
   case 9: return 33;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_HS */





/* 3DSTATE_GATHER_CONSTANT_HS::3D Command Opcode */


#define GEN10_3DSTATE_GATHER_CONSTANT_HS_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_GATHER_CONSTANT_HS_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_GATHER_CONSTANT_HS_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_GATHER_CONSTANT_HS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_HS_3DCommandOpcode_start  24
#define GEN9_3DSTATE_GATHER_CONSTANT_HS_3DCommandOpcode_start  24
#define GEN8_3DSTATE_GATHER_CONSTANT_HS_3DCommandOpcode_start  24
#define GEN75_3DSTATE_GATHER_CONSTANT_HS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_HS::3D Command Sub Opcode */


#define GEN10_3DSTATE_GATHER_CONSTANT_HS_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_GATHER_CONSTANT_HS_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_GATHER_CONSTANT_HS_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_GATHER_CONSTANT_HS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_HS_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_GATHER_CONSTANT_HS_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_GATHER_CONSTANT_HS_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_GATHER_CONSTANT_HS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_HS::Command SubType */


#define GEN10_3DSTATE_GATHER_CONSTANT_HS_CommandSubType_bits  2
#define GEN9_3DSTATE_GATHER_CONSTANT_HS_CommandSubType_bits  2
#define GEN8_3DSTATE_GATHER_CONSTANT_HS_CommandSubType_bits  2
#define GEN75_3DSTATE_GATHER_CONSTANT_HS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_HS_CommandSubType_start  27
#define GEN9_3DSTATE_GATHER_CONSTANT_HS_CommandSubType_start  27
#define GEN8_3DSTATE_GATHER_CONSTANT_HS_CommandSubType_start  27
#define GEN75_3DSTATE_GATHER_CONSTANT_HS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_HS::Command Type */


#define GEN10_3DSTATE_GATHER_CONSTANT_HS_CommandType_bits  3
#define GEN9_3DSTATE_GATHER_CONSTANT_HS_CommandType_bits  3
#define GEN8_3DSTATE_GATHER_CONSTANT_HS_CommandType_bits  3
#define GEN75_3DSTATE_GATHER_CONSTANT_HS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_HS_CommandType_start  29
#define GEN9_3DSTATE_GATHER_CONSTANT_HS_CommandType_start  29
#define GEN8_3DSTATE_GATHER_CONSTANT_HS_CommandType_start  29
#define GEN75_3DSTATE_GATHER_CONSTANT_HS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_HS::Constant Buffer Binding Table Block */


#define GEN10_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferBindingTableBlock_bits  4
#define GEN9_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferBindingTableBlock_bits  4
#define GEN8_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferBindingTableBlock_bits  4
#define GEN75_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferBindingTableBlock_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferBindingTableBlock_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 4;
   case 9: return 4;
   case 8: return 4;
   case 7:
      if (devinfo->is_haswell) {
         return 4;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferBindingTableBlock_start  44
#define GEN9_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferBindingTableBlock_start  44
#define GEN8_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferBindingTableBlock_start  44
#define GEN75_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferBindingTableBlock_start  44

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferBindingTableBlock_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 44;
   case 9: return 44;
   case 8: return 44;
   case 7:
      if (devinfo->is_haswell) {
         return 44;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_HS::Constant Buffer Dx9 Generate Stall */


#define GEN10_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferDx9GenerateStall_bits  1
#define GEN9_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferDx9GenerateStall_bits  1
#define GEN8_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferDx9GenerateStall_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferDx9GenerateStall_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferDx9GenerateStall_start  69
#define GEN9_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferDx9GenerateStall_start  69
#define GEN8_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferDx9GenerateStall_start  69

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferDx9GenerateStall_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 69;
   case 9: return 69;
   case 8: return 69;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_HS::Constant Buffer Valid */


#define GEN10_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferValid_bits  16
#define GEN9_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferValid_bits  16
#define GEN8_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferValid_bits  16
#define GEN75_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferValid_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferValid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferValid_start  48
#define GEN9_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferValid_start  48
#define GEN8_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferValid_start  48
#define GEN75_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferValid_start  48

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferValid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 48;
   case 9: return 48;
   case 8: return 48;
   case 7:
      if (devinfo->is_haswell) {
         return 48;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_HS::DWord Length */


#define GEN10_3DSTATE_GATHER_CONSTANT_HS_DWordLength_bits  8
#define GEN9_3DSTATE_GATHER_CONSTANT_HS_DWordLength_bits  8
#define GEN8_3DSTATE_GATHER_CONSTANT_HS_DWordLength_bits  8
#define GEN75_3DSTATE_GATHER_CONSTANT_HS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_HS_DWordLength_start  0
#define GEN9_3DSTATE_GATHER_CONSTANT_HS_DWordLength_start  0
#define GEN8_3DSTATE_GATHER_CONSTANT_HS_DWordLength_start  0
#define GEN75_3DSTATE_GATHER_CONSTANT_HS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_HS::Entry_0 */


#define GEN10_3DSTATE_GATHER_CONSTANT_HS_Entry_0_bits  16
#define GEN9_3DSTATE_GATHER_CONSTANT_HS_Entry_0_bits  16
#define GEN8_3DSTATE_GATHER_CONSTANT_HS_Entry_0_bits  16
#define GEN75_3DSTATE_GATHER_CONSTANT_HS_Entry_0_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_Entry_0_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_HS_Entry_0_start  0
#define GEN9_3DSTATE_GATHER_CONSTANT_HS_Entry_0_start  0
#define GEN8_3DSTATE_GATHER_CONSTANT_HS_Entry_0_start  0
#define GEN75_3DSTATE_GATHER_CONSTANT_HS_Entry_0_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_Entry_0_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_HS::Entry_1 */


#define GEN10_3DSTATE_GATHER_CONSTANT_HS_Entry_1_bits  16
#define GEN9_3DSTATE_GATHER_CONSTANT_HS_Entry_1_bits  16
#define GEN8_3DSTATE_GATHER_CONSTANT_HS_Entry_1_bits  16
#define GEN75_3DSTATE_GATHER_CONSTANT_HS_Entry_1_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_Entry_1_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_HS_Entry_1_start  16
#define GEN9_3DSTATE_GATHER_CONSTANT_HS_Entry_1_start  16
#define GEN8_3DSTATE_GATHER_CONSTANT_HS_Entry_1_start  16
#define GEN75_3DSTATE_GATHER_CONSTANT_HS_Entry_1_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_Entry_1_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_HS::Gather Buffer Offset */


#define GEN10_3DSTATE_GATHER_CONSTANT_HS_GatherBufferOffset_bits  17
#define GEN9_3DSTATE_GATHER_CONSTANT_HS_GatherBufferOffset_bits  17
#define GEN8_3DSTATE_GATHER_CONSTANT_HS_GatherBufferOffset_bits  17
#define GEN75_3DSTATE_GATHER_CONSTANT_HS_GatherBufferOffset_bits  17

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_GatherBufferOffset_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 17;
   case 9: return 17;
   case 8: return 17;
   case 7:
      if (devinfo->is_haswell) {
         return 17;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_HS_GatherBufferOffset_start  70
#define GEN9_3DSTATE_GATHER_CONSTANT_HS_GatherBufferOffset_start  70
#define GEN8_3DSTATE_GATHER_CONSTANT_HS_GatherBufferOffset_start  70
#define GEN75_3DSTATE_GATHER_CONSTANT_HS_GatherBufferOffset_start  70

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_GatherBufferOffset_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 70;
   case 9: return 70;
   case 8: return 70;
   case 7:
      if (devinfo->is_haswell) {
         return 70;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_HS::On-Die Table */


#define GEN10_3DSTATE_GATHER_CONSTANT_HS_OnDieTable_bits  1
#define GEN9_3DSTATE_GATHER_CONSTANT_HS_OnDieTable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_OnDieTable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_HS_OnDieTable_start  67
#define GEN9_3DSTATE_GATHER_CONSTANT_HS_OnDieTable_start  67

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_OnDieTable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 67;
   case 9: return 67;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_HS::Update Gather Table Only */


#define GEN10_3DSTATE_GATHER_CONSTANT_HS_UpdateGatherTableOnly_bits  1
#define GEN9_3DSTATE_GATHER_CONSTANT_HS_UpdateGatherTableOnly_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_UpdateGatherTableOnly_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_HS_UpdateGatherTableOnly_start  33
#define GEN9_3DSTATE_GATHER_CONSTANT_HS_UpdateGatherTableOnly_start  33

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_UpdateGatherTableOnly_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 33;
   case 9: return 33;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_PS */





/* 3DSTATE_GATHER_CONSTANT_PS::3D Command Opcode */


#define GEN10_3DSTATE_GATHER_CONSTANT_PS_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_GATHER_CONSTANT_PS_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_GATHER_CONSTANT_PS_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_GATHER_CONSTANT_PS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_PS_3DCommandOpcode_start  24
#define GEN9_3DSTATE_GATHER_CONSTANT_PS_3DCommandOpcode_start  24
#define GEN8_3DSTATE_GATHER_CONSTANT_PS_3DCommandOpcode_start  24
#define GEN75_3DSTATE_GATHER_CONSTANT_PS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_PS::3D Command Sub Opcode */


#define GEN10_3DSTATE_GATHER_CONSTANT_PS_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_GATHER_CONSTANT_PS_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_GATHER_CONSTANT_PS_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_GATHER_CONSTANT_PS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_PS_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_GATHER_CONSTANT_PS_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_GATHER_CONSTANT_PS_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_GATHER_CONSTANT_PS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_PS::Command SubType */


#define GEN10_3DSTATE_GATHER_CONSTANT_PS_CommandSubType_bits  2
#define GEN9_3DSTATE_GATHER_CONSTANT_PS_CommandSubType_bits  2
#define GEN8_3DSTATE_GATHER_CONSTANT_PS_CommandSubType_bits  2
#define GEN75_3DSTATE_GATHER_CONSTANT_PS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_PS_CommandSubType_start  27
#define GEN9_3DSTATE_GATHER_CONSTANT_PS_CommandSubType_start  27
#define GEN8_3DSTATE_GATHER_CONSTANT_PS_CommandSubType_start  27
#define GEN75_3DSTATE_GATHER_CONSTANT_PS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_PS::Command Type */


#define GEN10_3DSTATE_GATHER_CONSTANT_PS_CommandType_bits  3
#define GEN9_3DSTATE_GATHER_CONSTANT_PS_CommandType_bits  3
#define GEN8_3DSTATE_GATHER_CONSTANT_PS_CommandType_bits  3
#define GEN75_3DSTATE_GATHER_CONSTANT_PS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_PS_CommandType_start  29
#define GEN9_3DSTATE_GATHER_CONSTANT_PS_CommandType_start  29
#define GEN8_3DSTATE_GATHER_CONSTANT_PS_CommandType_start  29
#define GEN75_3DSTATE_GATHER_CONSTANT_PS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_PS::Constant Buffer Binding Table Block */


#define GEN10_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferBindingTableBlock_bits  4
#define GEN9_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferBindingTableBlock_bits  4
#define GEN8_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferBindingTableBlock_bits  4
#define GEN75_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferBindingTableBlock_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferBindingTableBlock_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 4;
   case 9: return 4;
   case 8: return 4;
   case 7:
      if (devinfo->is_haswell) {
         return 4;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferBindingTableBlock_start  44
#define GEN9_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferBindingTableBlock_start  44
#define GEN8_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferBindingTableBlock_start  44
#define GEN75_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferBindingTableBlock_start  44

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferBindingTableBlock_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 44;
   case 9: return 44;
   case 8: return 44;
   case 7:
      if (devinfo->is_haswell) {
         return 44;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_PS::Constant Buffer Dx9 Enable */


#define GEN10_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9Enable_bits  1
#define GEN9_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9Enable_bits  1
#define GEN8_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9Enable_bits  1
#define GEN75_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9Enable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9Enable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9Enable_start  68
#define GEN9_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9Enable_start  68
#define GEN8_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9Enable_start  68
#define GEN75_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9Enable_start  68

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9Enable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 68;
   case 9: return 68;
   case 8: return 68;
   case 7:
      if (devinfo->is_haswell) {
         return 68;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_PS::Constant Buffer Dx9 Generate Stall */


#define GEN10_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9GenerateStall_bits  1
#define GEN9_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9GenerateStall_bits  1
#define GEN8_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9GenerateStall_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9GenerateStall_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9GenerateStall_start  69
#define GEN9_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9GenerateStall_start  69
#define GEN8_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9GenerateStall_start  69

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9GenerateStall_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 69;
   case 9: return 69;
   case 8: return 69;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_PS::Constant Buffer Valid */


#define GEN10_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferValid_bits  16
#define GEN9_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferValid_bits  16
#define GEN8_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferValid_bits  16
#define GEN75_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferValid_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferValid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferValid_start  48
#define GEN9_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferValid_start  48
#define GEN8_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferValid_start  48
#define GEN75_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferValid_start  48

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferValid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 48;
   case 9: return 48;
   case 8: return 48;
   case 7:
      if (devinfo->is_haswell) {
         return 48;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_PS::DWord Length */


#define GEN10_3DSTATE_GATHER_CONSTANT_PS_DWordLength_bits  8
#define GEN9_3DSTATE_GATHER_CONSTANT_PS_DWordLength_bits  8
#define GEN8_3DSTATE_GATHER_CONSTANT_PS_DWordLength_bits  8
#define GEN75_3DSTATE_GATHER_CONSTANT_PS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_PS_DWordLength_start  0
#define GEN9_3DSTATE_GATHER_CONSTANT_PS_DWordLength_start  0
#define GEN8_3DSTATE_GATHER_CONSTANT_PS_DWordLength_start  0
#define GEN75_3DSTATE_GATHER_CONSTANT_PS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_PS::DX9 On-Die Register Read Enable */


#define GEN10_3DSTATE_GATHER_CONSTANT_PS_DX9OnDieRegisterReadEnable_bits  1
#define GEN9_3DSTATE_GATHER_CONSTANT_PS_DX9OnDieRegisterReadEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_DX9OnDieRegisterReadEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_PS_DX9OnDieRegisterReadEnable_start  32
#define GEN9_3DSTATE_GATHER_CONSTANT_PS_DX9OnDieRegisterReadEnable_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_DX9OnDieRegisterReadEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_PS::Entry_0 */


#define GEN10_3DSTATE_GATHER_CONSTANT_PS_Entry_0_bits  16
#define GEN9_3DSTATE_GATHER_CONSTANT_PS_Entry_0_bits  16
#define GEN8_3DSTATE_GATHER_CONSTANT_PS_Entry_0_bits  16
#define GEN75_3DSTATE_GATHER_CONSTANT_PS_Entry_0_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_Entry_0_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_PS_Entry_0_start  0
#define GEN9_3DSTATE_GATHER_CONSTANT_PS_Entry_0_start  0
#define GEN8_3DSTATE_GATHER_CONSTANT_PS_Entry_0_start  0
#define GEN75_3DSTATE_GATHER_CONSTANT_PS_Entry_0_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_Entry_0_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_PS::Entry_1 */


#define GEN10_3DSTATE_GATHER_CONSTANT_PS_Entry_1_bits  16
#define GEN9_3DSTATE_GATHER_CONSTANT_PS_Entry_1_bits  16
#define GEN8_3DSTATE_GATHER_CONSTANT_PS_Entry_1_bits  16
#define GEN75_3DSTATE_GATHER_CONSTANT_PS_Entry_1_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_Entry_1_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_PS_Entry_1_start  16
#define GEN9_3DSTATE_GATHER_CONSTANT_PS_Entry_1_start  16
#define GEN8_3DSTATE_GATHER_CONSTANT_PS_Entry_1_start  16
#define GEN75_3DSTATE_GATHER_CONSTANT_PS_Entry_1_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_Entry_1_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_PS::Gather Buffer Offset */


#define GEN10_3DSTATE_GATHER_CONSTANT_PS_GatherBufferOffset_bits  17
#define GEN9_3DSTATE_GATHER_CONSTANT_PS_GatherBufferOffset_bits  17
#define GEN8_3DSTATE_GATHER_CONSTANT_PS_GatherBufferOffset_bits  17
#define GEN75_3DSTATE_GATHER_CONSTANT_PS_GatherBufferOffset_bits  17

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_GatherBufferOffset_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 17;
   case 9: return 17;
   case 8: return 17;
   case 7:
      if (devinfo->is_haswell) {
         return 17;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_PS_GatherBufferOffset_start  70
#define GEN9_3DSTATE_GATHER_CONSTANT_PS_GatherBufferOffset_start  70
#define GEN8_3DSTATE_GATHER_CONSTANT_PS_GatherBufferOffset_start  70
#define GEN75_3DSTATE_GATHER_CONSTANT_PS_GatherBufferOffset_start  70

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_GatherBufferOffset_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 70;
   case 9: return 70;
   case 8: return 70;
   case 7:
      if (devinfo->is_haswell) {
         return 70;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_PS::On-Die Table */


#define GEN10_3DSTATE_GATHER_CONSTANT_PS_OnDieTable_bits  1
#define GEN9_3DSTATE_GATHER_CONSTANT_PS_OnDieTable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_OnDieTable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_PS_OnDieTable_start  67
#define GEN9_3DSTATE_GATHER_CONSTANT_PS_OnDieTable_start  67

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_OnDieTable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 67;
   case 9: return 67;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_PS::Update Gather Table Only */


#define GEN10_3DSTATE_GATHER_CONSTANT_PS_UpdateGatherTableOnly_bits  1
#define GEN9_3DSTATE_GATHER_CONSTANT_PS_UpdateGatherTableOnly_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_UpdateGatherTableOnly_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_PS_UpdateGatherTableOnly_start  33
#define GEN9_3DSTATE_GATHER_CONSTANT_PS_UpdateGatherTableOnly_start  33

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_UpdateGatherTableOnly_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 33;
   case 9: return 33;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_VS */





/* 3DSTATE_GATHER_CONSTANT_VS::3D Command Opcode */


#define GEN10_3DSTATE_GATHER_CONSTANT_VS_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_GATHER_CONSTANT_VS_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_GATHER_CONSTANT_VS_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_GATHER_CONSTANT_VS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_VS_3DCommandOpcode_start  24
#define GEN9_3DSTATE_GATHER_CONSTANT_VS_3DCommandOpcode_start  24
#define GEN8_3DSTATE_GATHER_CONSTANT_VS_3DCommandOpcode_start  24
#define GEN75_3DSTATE_GATHER_CONSTANT_VS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_VS::3D Command Sub Opcode */


#define GEN10_3DSTATE_GATHER_CONSTANT_VS_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_GATHER_CONSTANT_VS_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_GATHER_CONSTANT_VS_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_GATHER_CONSTANT_VS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_VS_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_GATHER_CONSTANT_VS_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_GATHER_CONSTANT_VS_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_GATHER_CONSTANT_VS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_VS::Command SubType */


#define GEN10_3DSTATE_GATHER_CONSTANT_VS_CommandSubType_bits  2
#define GEN9_3DSTATE_GATHER_CONSTANT_VS_CommandSubType_bits  2
#define GEN8_3DSTATE_GATHER_CONSTANT_VS_CommandSubType_bits  2
#define GEN75_3DSTATE_GATHER_CONSTANT_VS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_VS_CommandSubType_start  27
#define GEN9_3DSTATE_GATHER_CONSTANT_VS_CommandSubType_start  27
#define GEN8_3DSTATE_GATHER_CONSTANT_VS_CommandSubType_start  27
#define GEN75_3DSTATE_GATHER_CONSTANT_VS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_VS::Command Type */


#define GEN10_3DSTATE_GATHER_CONSTANT_VS_CommandType_bits  3
#define GEN9_3DSTATE_GATHER_CONSTANT_VS_CommandType_bits  3
#define GEN8_3DSTATE_GATHER_CONSTANT_VS_CommandType_bits  3
#define GEN75_3DSTATE_GATHER_CONSTANT_VS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_VS_CommandType_start  29
#define GEN9_3DSTATE_GATHER_CONSTANT_VS_CommandType_start  29
#define GEN8_3DSTATE_GATHER_CONSTANT_VS_CommandType_start  29
#define GEN75_3DSTATE_GATHER_CONSTANT_VS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_VS::Constant Buffer Binding Table Block */


#define GEN10_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferBindingTableBlock_bits  4
#define GEN9_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferBindingTableBlock_bits  4
#define GEN8_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferBindingTableBlock_bits  4
#define GEN75_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferBindingTableBlock_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferBindingTableBlock_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 4;
   case 9: return 4;
   case 8: return 4;
   case 7:
      if (devinfo->is_haswell) {
         return 4;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferBindingTableBlock_start  44
#define GEN9_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferBindingTableBlock_start  44
#define GEN8_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferBindingTableBlock_start  44
#define GEN75_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferBindingTableBlock_start  44

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferBindingTableBlock_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 44;
   case 9: return 44;
   case 8: return 44;
   case 7:
      if (devinfo->is_haswell) {
         return 44;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_VS::Constant Buffer Dx9 Enable */


#define GEN10_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9Enable_bits  1
#define GEN9_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9Enable_bits  1
#define GEN8_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9Enable_bits  1
#define GEN75_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9Enable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9Enable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9Enable_start  68
#define GEN9_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9Enable_start  68
#define GEN8_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9Enable_start  68
#define GEN75_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9Enable_start  68

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9Enable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 68;
   case 9: return 68;
   case 8: return 68;
   case 7:
      if (devinfo->is_haswell) {
         return 68;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_VS::Constant Buffer Dx9 Generate Stall */


#define GEN10_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9GenerateStall_bits  1
#define GEN9_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9GenerateStall_bits  1
#define GEN8_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9GenerateStall_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9GenerateStall_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9GenerateStall_start  69
#define GEN9_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9GenerateStall_start  69
#define GEN8_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9GenerateStall_start  69

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9GenerateStall_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 69;
   case 9: return 69;
   case 8: return 69;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_VS::Constant Buffer Valid */


#define GEN10_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferValid_bits  16
#define GEN9_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferValid_bits  16
#define GEN8_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferValid_bits  16
#define GEN75_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferValid_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferValid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferValid_start  48
#define GEN9_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferValid_start  48
#define GEN8_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferValid_start  48
#define GEN75_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferValid_start  48

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferValid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 48;
   case 9: return 48;
   case 8: return 48;
   case 7:
      if (devinfo->is_haswell) {
         return 48;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_VS::DWord Length */


#define GEN10_3DSTATE_GATHER_CONSTANT_VS_DWordLength_bits  8
#define GEN9_3DSTATE_GATHER_CONSTANT_VS_DWordLength_bits  8
#define GEN8_3DSTATE_GATHER_CONSTANT_VS_DWordLength_bits  8
#define GEN75_3DSTATE_GATHER_CONSTANT_VS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_VS_DWordLength_start  0
#define GEN9_3DSTATE_GATHER_CONSTANT_VS_DWordLength_start  0
#define GEN8_3DSTATE_GATHER_CONSTANT_VS_DWordLength_start  0
#define GEN75_3DSTATE_GATHER_CONSTANT_VS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_VS::DX9 On-Die Register Read Enable */


#define GEN10_3DSTATE_GATHER_CONSTANT_VS_DX9OnDieRegisterReadEnable_bits  1
#define GEN9_3DSTATE_GATHER_CONSTANT_VS_DX9OnDieRegisterReadEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_DX9OnDieRegisterReadEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_VS_DX9OnDieRegisterReadEnable_start  32
#define GEN9_3DSTATE_GATHER_CONSTANT_VS_DX9OnDieRegisterReadEnable_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_DX9OnDieRegisterReadEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_VS::Entry_0 */


#define GEN10_3DSTATE_GATHER_CONSTANT_VS_Entry_0_bits  16
#define GEN9_3DSTATE_GATHER_CONSTANT_VS_Entry_0_bits  16
#define GEN8_3DSTATE_GATHER_CONSTANT_VS_Entry_0_bits  16
#define GEN75_3DSTATE_GATHER_CONSTANT_VS_Entry_0_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_Entry_0_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_VS_Entry_0_start  0
#define GEN9_3DSTATE_GATHER_CONSTANT_VS_Entry_0_start  0
#define GEN8_3DSTATE_GATHER_CONSTANT_VS_Entry_0_start  0
#define GEN75_3DSTATE_GATHER_CONSTANT_VS_Entry_0_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_Entry_0_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_VS::Entry_1 */


#define GEN10_3DSTATE_GATHER_CONSTANT_VS_Entry_1_bits  16
#define GEN9_3DSTATE_GATHER_CONSTANT_VS_Entry_1_bits  16
#define GEN8_3DSTATE_GATHER_CONSTANT_VS_Entry_1_bits  16
#define GEN75_3DSTATE_GATHER_CONSTANT_VS_Entry_1_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_Entry_1_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_VS_Entry_1_start  16
#define GEN9_3DSTATE_GATHER_CONSTANT_VS_Entry_1_start  16
#define GEN8_3DSTATE_GATHER_CONSTANT_VS_Entry_1_start  16
#define GEN75_3DSTATE_GATHER_CONSTANT_VS_Entry_1_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_Entry_1_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_VS::Gather Buffer Offset */


#define GEN10_3DSTATE_GATHER_CONSTANT_VS_GatherBufferOffset_bits  17
#define GEN9_3DSTATE_GATHER_CONSTANT_VS_GatherBufferOffset_bits  17
#define GEN8_3DSTATE_GATHER_CONSTANT_VS_GatherBufferOffset_bits  17
#define GEN75_3DSTATE_GATHER_CONSTANT_VS_GatherBufferOffset_bits  17

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_GatherBufferOffset_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 17;
   case 9: return 17;
   case 8: return 17;
   case 7:
      if (devinfo->is_haswell) {
         return 17;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_VS_GatherBufferOffset_start  70
#define GEN9_3DSTATE_GATHER_CONSTANT_VS_GatherBufferOffset_start  70
#define GEN8_3DSTATE_GATHER_CONSTANT_VS_GatherBufferOffset_start  70
#define GEN75_3DSTATE_GATHER_CONSTANT_VS_GatherBufferOffset_start  70

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_GatherBufferOffset_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 70;
   case 9: return 70;
   case 8: return 70;
   case 7:
      if (devinfo->is_haswell) {
         return 70;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_VS::On-Die Table */


#define GEN10_3DSTATE_GATHER_CONSTANT_VS_OnDieTable_bits  1
#define GEN9_3DSTATE_GATHER_CONSTANT_VS_OnDieTable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_OnDieTable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_VS_OnDieTable_start  67
#define GEN9_3DSTATE_GATHER_CONSTANT_VS_OnDieTable_start  67

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_OnDieTable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 67;
   case 9: return 67;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_VS::Update Gather Table Only */


#define GEN10_3DSTATE_GATHER_CONSTANT_VS_UpdateGatherTableOnly_bits  1
#define GEN9_3DSTATE_GATHER_CONSTANT_VS_UpdateGatherTableOnly_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_UpdateGatherTableOnly_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_CONSTANT_VS_UpdateGatherTableOnly_start  33
#define GEN9_3DSTATE_GATHER_CONSTANT_VS_UpdateGatherTableOnly_start  33

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_UpdateGatherTableOnly_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 33;
   case 9: return 33;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_POOL_ALLOC */


#define GEN10_3DSTATE_GATHER_POOL_ALLOC_length  4
#define GEN9_3DSTATE_GATHER_POOL_ALLOC_length  4
#define GEN8_3DSTATE_GATHER_POOL_ALLOC_length  4
#define GEN75_3DSTATE_GATHER_POOL_ALLOC_length  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 4;
   case 9: return 4;
   case 8: return 4;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_POOL_ALLOC::3D Command Opcode */


#define GEN10_3DSTATE_GATHER_POOL_ALLOC_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_GATHER_POOL_ALLOC_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_GATHER_POOL_ALLOC_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_GATHER_POOL_ALLOC_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_POOL_ALLOC_3DCommandOpcode_start  24
#define GEN9_3DSTATE_GATHER_POOL_ALLOC_3DCommandOpcode_start  24
#define GEN8_3DSTATE_GATHER_POOL_ALLOC_3DCommandOpcode_start  24
#define GEN75_3DSTATE_GATHER_POOL_ALLOC_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_POOL_ALLOC::3D Command Sub Opcode */


#define GEN10_3DSTATE_GATHER_POOL_ALLOC_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_GATHER_POOL_ALLOC_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_GATHER_POOL_ALLOC_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_GATHER_POOL_ALLOC_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_POOL_ALLOC_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_GATHER_POOL_ALLOC_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_GATHER_POOL_ALLOC_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_GATHER_POOL_ALLOC_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_POOL_ALLOC::Command SubType */


#define GEN10_3DSTATE_GATHER_POOL_ALLOC_CommandSubType_bits  2
#define GEN9_3DSTATE_GATHER_POOL_ALLOC_CommandSubType_bits  2
#define GEN8_3DSTATE_GATHER_POOL_ALLOC_CommandSubType_bits  2
#define GEN75_3DSTATE_GATHER_POOL_ALLOC_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_POOL_ALLOC_CommandSubType_start  27
#define GEN9_3DSTATE_GATHER_POOL_ALLOC_CommandSubType_start  27
#define GEN8_3DSTATE_GATHER_POOL_ALLOC_CommandSubType_start  27
#define GEN75_3DSTATE_GATHER_POOL_ALLOC_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_POOL_ALLOC::Command Type */


#define GEN10_3DSTATE_GATHER_POOL_ALLOC_CommandType_bits  3
#define GEN9_3DSTATE_GATHER_POOL_ALLOC_CommandType_bits  3
#define GEN8_3DSTATE_GATHER_POOL_ALLOC_CommandType_bits  3
#define GEN75_3DSTATE_GATHER_POOL_ALLOC_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_POOL_ALLOC_CommandType_start  29
#define GEN9_3DSTATE_GATHER_POOL_ALLOC_CommandType_start  29
#define GEN8_3DSTATE_GATHER_POOL_ALLOC_CommandType_start  29
#define GEN75_3DSTATE_GATHER_POOL_ALLOC_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_POOL_ALLOC::DWord Length */


#define GEN10_3DSTATE_GATHER_POOL_ALLOC_DWordLength_bits  8
#define GEN9_3DSTATE_GATHER_POOL_ALLOC_DWordLength_bits  8
#define GEN8_3DSTATE_GATHER_POOL_ALLOC_DWordLength_bits  8
#define GEN75_3DSTATE_GATHER_POOL_ALLOC_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_POOL_ALLOC_DWordLength_start  0
#define GEN9_3DSTATE_GATHER_POOL_ALLOC_DWordLength_start  0
#define GEN8_3DSTATE_GATHER_POOL_ALLOC_DWordLength_start  0
#define GEN75_3DSTATE_GATHER_POOL_ALLOC_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_POOL_ALLOC::Gather Pool Base Address */


#define GEN10_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBaseAddress_bits  52
#define GEN9_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBaseAddress_bits  52
#define GEN8_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBaseAddress_bits  52
#define GEN75_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBaseAddress_bits  20

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBaseAddress_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 52;
   case 9: return 52;
   case 8: return 52;
   case 7:
      if (devinfo->is_haswell) {
         return 20;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBaseAddress_start  44
#define GEN9_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBaseAddress_start  44
#define GEN8_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBaseAddress_start  44
#define GEN75_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBaseAddress_start  44

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBaseAddress_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 44;
   case 9: return 44;
   case 8: return 44;
   case 7:
      if (devinfo->is_haswell) {
         return 44;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_POOL_ALLOC::Gather Pool Buffer Size */


#define GEN10_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBufferSize_bits  20
#define GEN9_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBufferSize_bits  20
#define GEN8_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBufferSize_bits  20

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBufferSize_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 20;
   case 9: return 20;
   case 8: return 20;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBufferSize_start  108
#define GEN9_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBufferSize_start  108
#define GEN8_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBufferSize_start  108

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBufferSize_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 108;
   case 9: return 108;
   case 8: return 108;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_POOL_ALLOC::Gather Pool Enable */


#define GEN10_3DSTATE_GATHER_POOL_ALLOC_GatherPoolEnable_bits  1
#define GEN9_3DSTATE_GATHER_POOL_ALLOC_GatherPoolEnable_bits  1
#define GEN8_3DSTATE_GATHER_POOL_ALLOC_GatherPoolEnable_bits  1
#define GEN75_3DSTATE_GATHER_POOL_ALLOC_GatherPoolEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_GatherPoolEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_POOL_ALLOC_GatherPoolEnable_start  43
#define GEN9_3DSTATE_GATHER_POOL_ALLOC_GatherPoolEnable_start  43
#define GEN8_3DSTATE_GATHER_POOL_ALLOC_GatherPoolEnable_start  43
#define GEN75_3DSTATE_GATHER_POOL_ALLOC_GatherPoolEnable_start  43

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_GatherPoolEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 43;
   case 9: return 43;
   case 8: return 43;
   case 7:
      if (devinfo->is_haswell) {
         return 43;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_POOL_ALLOC::Gather Pool Upper Bound */


#define GEN75_3DSTATE_GATHER_POOL_ALLOC_GatherPoolUpperBound_bits  20

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_GatherPoolUpperBound_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 20;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN75_3DSTATE_GATHER_POOL_ALLOC_GatherPoolUpperBound_start  76

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_GatherPoolUpperBound_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 76;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_POOL_ALLOC::Memory Object Control State */


#define GEN10_3DSTATE_GATHER_POOL_ALLOC_MemoryObjectControlState_bits  7
#define GEN9_3DSTATE_GATHER_POOL_ALLOC_MemoryObjectControlState_bits  7
#define GEN8_3DSTATE_GATHER_POOL_ALLOC_MemoryObjectControlState_bits  7
#define GEN75_3DSTATE_GATHER_POOL_ALLOC_MemoryObjectControlState_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_MemoryObjectControlState_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 7;
   case 9: return 7;
   case 8: return 7;
   case 7:
      if (devinfo->is_haswell) {
         return 4;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GATHER_POOL_ALLOC_MemoryObjectControlState_start  32
#define GEN9_3DSTATE_GATHER_POOL_ALLOC_MemoryObjectControlState_start  32
#define GEN8_3DSTATE_GATHER_POOL_ALLOC_MemoryObjectControlState_start  32
#define GEN75_3DSTATE_GATHER_POOL_ALLOC_MemoryObjectControlState_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_MemoryObjectControlState_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP */


#define GEN5_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_length  2
#define GEN45_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_length  2
#define GEN4_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_length  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 2;
   case 4:
      if (devinfo->is_g4x) {
         return 2;
      } else {
         return 2;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP::3D Command Opcode */


#define GEN5_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_3DCommandOpcode_bits  3
#define GEN45_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_3DCommandOpcode_bits  3
#define GEN4_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 3;
   case 4:
      if (devinfo->is_g4x) {
         return 3;
      } else {
         return 3;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN5_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_3DCommandOpcode_start  24
#define GEN45_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_3DCommandOpcode_start  24
#define GEN4_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 24;
   case 4:
      if (devinfo->is_g4x) {
         return 24;
      } else {
         return 24;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP::3D Command Sub Opcode */


#define GEN5_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_3DCommandSubOpcode_bits  8
#define GEN45_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_3DCommandSubOpcode_bits  8
#define GEN4_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 8;
   case 4:
      if (devinfo->is_g4x) {
         return 8;
      } else {
         return 8;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN5_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_3DCommandSubOpcode_start  16
#define GEN45_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_3DCommandSubOpcode_start  16
#define GEN4_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 16;
   case 4:
      if (devinfo->is_g4x) {
         return 16;
      } else {
         return 16;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP::Command SubType */


#define GEN5_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_CommandSubType_bits  2
#define GEN45_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_CommandSubType_bits  2
#define GEN4_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 2;
   case 4:
      if (devinfo->is_g4x) {
         return 2;
      } else {
         return 2;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN5_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_CommandSubType_start  27
#define GEN45_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_CommandSubType_start  27
#define GEN4_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 27;
   case 4:
      if (devinfo->is_g4x) {
         return 27;
      } else {
         return 27;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP::Command Type */


#define GEN5_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_CommandType_bits  3
#define GEN45_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_CommandType_bits  3
#define GEN4_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 3;
   case 4:
      if (devinfo->is_g4x) {
         return 3;
      } else {
         return 3;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN5_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_CommandType_start  29
#define GEN45_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_CommandType_start  29
#define GEN4_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 29;
   case 4:
      if (devinfo->is_g4x) {
         return 29;
      } else {
         return 29;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP::DWord Length */


#define GEN5_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_DWordLength_bits  8
#define GEN45_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_DWordLength_bits  8
#define GEN4_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 8;
   case 4:
      if (devinfo->is_g4x) {
         return 8;
      } else {
         return 8;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN5_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_DWordLength_start  0
#define GEN45_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_DWordLength_start  0
#define GEN4_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP::Global Depth Offset Clamp */


#define GEN5_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_GlobalDepthOffsetClamp_bits  32
#define GEN45_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_GlobalDepthOffsetClamp_bits  32
#define GEN4_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_GlobalDepthOffsetClamp_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_GlobalDepthOffsetClamp_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 32;
   case 4:
      if (devinfo->is_g4x) {
         return 32;
      } else {
         return 32;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN5_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_GlobalDepthOffsetClamp_start  32
#define GEN45_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_GlobalDepthOffsetClamp_start  32
#define GEN4_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_GlobalDepthOffsetClamp_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_GlobalDepthOffsetClamp_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 32;
   case 4:
      if (devinfo->is_g4x) {
         return 32;
      } else {
         return 32;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS */


#define GEN10_3DSTATE_GS_length  10
#define GEN9_3DSTATE_GS_length  10
#define GEN8_3DSTATE_GS_length  10
#define GEN75_3DSTATE_GS_length  7
#define GEN7_3DSTATE_GS_length  7
#define GEN6_3DSTATE_GS_length  7

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 10;
   case 9: return 10;
   case 8: return 10;
   case 7:
      if (devinfo->is_haswell) {
         return 7;
      } else {
         return 7;
      }
   case 6: return 7;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::3D Command Opcode */


#define GEN10_3DSTATE_GS_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_GS_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_GS_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_GS_3DCommandOpcode_bits  3
#define GEN7_3DSTATE_GS_3DCommandOpcode_bits  3
#define GEN6_3DSTATE_GS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_3DCommandOpcode_start  24
#define GEN9_3DSTATE_GS_3DCommandOpcode_start  24
#define GEN8_3DSTATE_GS_3DCommandOpcode_start  24
#define GEN75_3DSTATE_GS_3DCommandOpcode_start  24
#define GEN7_3DSTATE_GS_3DCommandOpcode_start  24
#define GEN6_3DSTATE_GS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 24;
      }
   case 6: return 24;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::3D Command Sub Opcode */


#define GEN10_3DSTATE_GS_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_GS_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_GS_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_GS_3DCommandSubOpcode_bits  8
#define GEN7_3DSTATE_GS_3DCommandSubOpcode_bits  8
#define GEN6_3DSTATE_GS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_GS_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_GS_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_GS_3DCommandSubOpcode_start  16
#define GEN7_3DSTATE_GS_3DCommandSubOpcode_start  16
#define GEN6_3DSTATE_GS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 16;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Accesses UAV */


#define GEN10_3DSTATE_GS_AccessesUAV_bits  1
#define GEN9_3DSTATE_GS_AccessesUAV_bits  1
#define GEN8_3DSTATE_GS_AccessesUAV_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_AccessesUAV_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_AccessesUAV_start  108
#define GEN9_3DSTATE_GS_AccessesUAV_start  108
#define GEN8_3DSTATE_GS_AccessesUAV_start  108

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_AccessesUAV_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 108;
   case 9: return 108;
   case 8: return 108;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Binding Table Entry Count */


#define GEN10_3DSTATE_GS_BindingTableEntryCount_bits  8
#define GEN9_3DSTATE_GS_BindingTableEntryCount_bits  8
#define GEN8_3DSTATE_GS_BindingTableEntryCount_bits  8
#define GEN75_3DSTATE_GS_BindingTableEntryCount_bits  8
#define GEN7_3DSTATE_GS_BindingTableEntryCount_bits  8
#define GEN6_3DSTATE_GS_BindingTableEntryCount_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_BindingTableEntryCount_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_BindingTableEntryCount_start  114
#define GEN9_3DSTATE_GS_BindingTableEntryCount_start  114
#define GEN8_3DSTATE_GS_BindingTableEntryCount_start  114
#define GEN75_3DSTATE_GS_BindingTableEntryCount_start  82
#define GEN7_3DSTATE_GS_BindingTableEntryCount_start  82
#define GEN6_3DSTATE_GS_BindingTableEntryCount_start  82

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_BindingTableEntryCount_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 114;
   case 9: return 114;
   case 8: return 114;
   case 7:
      if (devinfo->is_haswell) {
         return 82;
      } else {
         return 82;
      }
   case 6: return 82;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Command SubType */


#define GEN10_3DSTATE_GS_CommandSubType_bits  2
#define GEN9_3DSTATE_GS_CommandSubType_bits  2
#define GEN8_3DSTATE_GS_CommandSubType_bits  2
#define GEN75_3DSTATE_GS_CommandSubType_bits  2
#define GEN7_3DSTATE_GS_CommandSubType_bits  2
#define GEN6_3DSTATE_GS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 2;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_CommandSubType_start  27
#define GEN9_3DSTATE_GS_CommandSubType_start  27
#define GEN8_3DSTATE_GS_CommandSubType_start  27
#define GEN75_3DSTATE_GS_CommandSubType_start  27
#define GEN7_3DSTATE_GS_CommandSubType_start  27
#define GEN6_3DSTATE_GS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 27;
      }
   case 6: return 27;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Command Type */


#define GEN10_3DSTATE_GS_CommandType_bits  3
#define GEN9_3DSTATE_GS_CommandType_bits  3
#define GEN8_3DSTATE_GS_CommandType_bits  3
#define GEN75_3DSTATE_GS_CommandType_bits  3
#define GEN7_3DSTATE_GS_CommandType_bits  3
#define GEN6_3DSTATE_GS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_CommandType_start  29
#define GEN9_3DSTATE_GS_CommandType_start  29
#define GEN8_3DSTATE_GS_CommandType_start  29
#define GEN75_3DSTATE_GS_CommandType_start  29
#define GEN7_3DSTATE_GS_CommandType_start  29
#define GEN6_3DSTATE_GS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 29;
      }
   case 6: return 29;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Control Data Format */


#define GEN10_3DSTATE_GS_ControlDataFormat_bits  1
#define GEN9_3DSTATE_GS_ControlDataFormat_bits  1
#define GEN8_3DSTATE_GS_ControlDataFormat_bits  1
#define GEN75_3DSTATE_GS_ControlDataFormat_bits  1
#define GEN7_3DSTATE_GS_ControlDataFormat_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_ControlDataFormat_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_ControlDataFormat_start  287
#define GEN9_3DSTATE_GS_ControlDataFormat_start  287
#define GEN8_3DSTATE_GS_ControlDataFormat_start  287
#define GEN75_3DSTATE_GS_ControlDataFormat_start  223
#define GEN7_3DSTATE_GS_ControlDataFormat_start  184

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_ControlDataFormat_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 287;
   case 9: return 287;
   case 8: return 287;
   case 7:
      if (devinfo->is_haswell) {
         return 223;
      } else {
         return 184;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Control Data Header Size */


#define GEN10_3DSTATE_GS_ControlDataHeaderSize_bits  4
#define GEN9_3DSTATE_GS_ControlDataHeaderSize_bits  4
#define GEN8_3DSTATE_GS_ControlDataHeaderSize_bits  4
#define GEN75_3DSTATE_GS_ControlDataHeaderSize_bits  4
#define GEN7_3DSTATE_GS_ControlDataHeaderSize_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_ControlDataHeaderSize_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 4;
   case 9: return 4;
   case 8: return 4;
   case 7:
      if (devinfo->is_haswell) {
         return 4;
      } else {
         return 4;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_ControlDataHeaderSize_start  244
#define GEN9_3DSTATE_GS_ControlDataHeaderSize_start  244
#define GEN8_3DSTATE_GS_ControlDataHeaderSize_start  244
#define GEN75_3DSTATE_GS_ControlDataHeaderSize_start  180
#define GEN7_3DSTATE_GS_ControlDataHeaderSize_start  180

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_ControlDataHeaderSize_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 244;
   case 9: return 244;
   case 8: return 244;
   case 7:
      if (devinfo->is_haswell) {
         return 180;
      } else {
         return 180;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::DWord Length */


#define GEN10_3DSTATE_GS_DWordLength_bits  8
#define GEN9_3DSTATE_GS_DWordLength_bits  8
#define GEN8_3DSTATE_GS_DWordLength_bits  8
#define GEN75_3DSTATE_GS_DWordLength_bits  8
#define GEN7_3DSTATE_GS_DWordLength_bits  8
#define GEN6_3DSTATE_GS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_DWordLength_start  0
#define GEN9_3DSTATE_GS_DWordLength_start  0
#define GEN8_3DSTATE_GS_DWordLength_start  0
#define GEN75_3DSTATE_GS_DWordLength_start  0
#define GEN7_3DSTATE_GS_DWordLength_start  0
#define GEN6_3DSTATE_GS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Default Stream Id */


#define GEN10_3DSTATE_GS_DefaultStreamId_bits  2
#define GEN9_3DSTATE_GS_DefaultStreamId_bits  2
#define GEN8_3DSTATE_GS_DefaultStreamId_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_DefaultStreamId_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_DefaultStreamId_start  237
#define GEN9_3DSTATE_GS_DefaultStreamId_start  237
#define GEN8_3DSTATE_GS_DefaultStreamId_start  237

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_DefaultStreamId_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 237;
   case 9: return 237;
   case 8: return 237;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Default StreamID */


#define GEN75_3DSTATE_GS_DefaultStreamID_bits  2
#define GEN7_3DSTATE_GS_DefaultStreamID_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_DefaultStreamID_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN75_3DSTATE_GS_DefaultStreamID_start  173
#define GEN7_3DSTATE_GS_DefaultStreamID_start  173

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_DefaultStreamID_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 173;
      } else {
         return 173;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Discard Adjacency */


#define GEN10_3DSTATE_GS_DiscardAdjacency_bits  1
#define GEN9_3DSTATE_GS_DiscardAdjacency_bits  1
#define GEN8_3DSTATE_GS_DiscardAdjacency_bits  1
#define GEN75_3DSTATE_GS_DiscardAdjacency_bits  1
#define GEN7_3DSTATE_GS_DiscardAdjacency_bits  1
#define GEN6_3DSTATE_GS_DiscardAdjacency_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_DiscardAdjacency_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_DiscardAdjacency_start  225
#define GEN9_3DSTATE_GS_DiscardAdjacency_start  225
#define GEN8_3DSTATE_GS_DiscardAdjacency_start  225
#define GEN75_3DSTATE_GS_DiscardAdjacency_start  161
#define GEN7_3DSTATE_GS_DiscardAdjacency_start  161
#define GEN6_3DSTATE_GS_DiscardAdjacency_start  221

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_DiscardAdjacency_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 225;
   case 9: return 225;
   case 8: return 225;
   case 7:
      if (devinfo->is_haswell) {
         return 161;
      } else {
         return 161;
      }
   case 6: return 221;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Dispatch GRF Start Register For URB Data */


#define GEN10_3DSTATE_GS_DispatchGRFStartRegisterForURBData_bits  4
#define GEN9_3DSTATE_GS_DispatchGRFStartRegisterForURBData_bits  4
#define GEN8_3DSTATE_GS_DispatchGRFStartRegisterForURBData_bits  4
#define GEN75_3DSTATE_GS_DispatchGRFStartRegisterForURBData_bits  4
#define GEN7_3DSTATE_GS_DispatchGRFStartRegisterForURBData_bits  4
#define GEN6_3DSTATE_GS_DispatchGRFStartRegisterForURBData_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_DispatchGRFStartRegisterForURBData_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 4;
   case 9: return 4;
   case 8: return 4;
   case 7:
      if (devinfo->is_haswell) {
         return 4;
      } else {
         return 4;
      }
   case 6: return 4;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_DispatchGRFStartRegisterForURBData_start  192
#define GEN9_3DSTATE_GS_DispatchGRFStartRegisterForURBData_start  192
#define GEN8_3DSTATE_GS_DispatchGRFStartRegisterForURBData_start  192
#define GEN75_3DSTATE_GS_DispatchGRFStartRegisterForURBData_start  128
#define GEN7_3DSTATE_GS_DispatchGRFStartRegisterForURBData_start  128
#define GEN6_3DSTATE_GS_DispatchGRFStartRegisterForURBData_start  128

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_DispatchGRFStartRegisterForURBData_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 192;
   case 9: return 192;
   case 8: return 192;
   case 7:
      if (devinfo->is_haswell) {
         return 128;
      } else {
         return 128;
      }
   case 6: return 128;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Dispatch GRF Start Register For URB Data [5:4] */


#define GEN10_3DSTATE_GS_DispatchGRFStartRegisterForURBData54_bits  2
#define GEN9_3DSTATE_GS_DispatchGRFStartRegisterForURBData54_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_DispatchGRFStartRegisterForURBData54_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_DispatchGRFStartRegisterForURBData54_start  221
#define GEN9_3DSTATE_GS_DispatchGRFStartRegisterForURBData54_start  221

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_DispatchGRFStartRegisterForURBData54_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 221;
   case 9: return 221;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Dispatch Mode */


#define GEN10_3DSTATE_GS_DispatchMode_bits  2
#define GEN9_3DSTATE_GS_DispatchMode_bits  2
#define GEN8_3DSTATE_GS_DispatchMode_bits  2
#define GEN75_3DSTATE_GS_DispatchMode_bits  2
#define GEN7_3DSTATE_GS_DispatchMode_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_DispatchMode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_DispatchMode_start  235
#define GEN9_3DSTATE_GS_DispatchMode_start  235
#define GEN8_3DSTATE_GS_DispatchMode_start  235
#define GEN75_3DSTATE_GS_DispatchMode_start  171
#define GEN7_3DSTATE_GS_DispatchMode_start  171

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_DispatchMode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 235;
   case 9: return 235;
   case 8: return 235;
   case 7:
      if (devinfo->is_haswell) {
         return 171;
      } else {
         return 171;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Enable */


#define GEN10_3DSTATE_GS_Enable_bits  1
#define GEN9_3DSTATE_GS_Enable_bits  1
#define GEN8_3DSTATE_GS_Enable_bits  1
#define GEN75_3DSTATE_GS_Enable_bits  1
#define GEN7_3DSTATE_GS_Enable_bits  1
#define GEN6_3DSTATE_GS_Enable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_Enable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_Enable_start  224
#define GEN9_3DSTATE_GS_Enable_start  224
#define GEN8_3DSTATE_GS_Enable_start  224
#define GEN75_3DSTATE_GS_Enable_start  160
#define GEN7_3DSTATE_GS_Enable_start  160
#define GEN6_3DSTATE_GS_Enable_start  207

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_Enable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 224;
   case 9: return 224;
   case 8: return 224;
   case 7:
      if (devinfo->is_haswell) {
         return 160;
      } else {
         return 160;
      }
   case 6: return 207;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Expected Vertex Count */


#define GEN10_3DSTATE_GS_ExpectedVertexCount_bits  6
#define GEN9_3DSTATE_GS_ExpectedVertexCount_bits  6
#define GEN8_3DSTATE_GS_ExpectedVertexCount_bits  6

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_ExpectedVertexCount_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 6;
   case 9: return 6;
   case 8: return 6;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_ExpectedVertexCount_start  96
#define GEN9_3DSTATE_GS_ExpectedVertexCount_start  96
#define GEN8_3DSTATE_GS_ExpectedVertexCount_start  96

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_ExpectedVertexCount_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 96;
   case 9: return 96;
   case 8: return 96;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Floating Point Mode */


#define GEN10_3DSTATE_GS_FloatingPointMode_bits  1
#define GEN9_3DSTATE_GS_FloatingPointMode_bits  1
#define GEN8_3DSTATE_GS_FloatingPointMode_bits  1
#define GEN75_3DSTATE_GS_FloatingPointMode_bits  1
#define GEN7_3DSTATE_GS_FloatingPointMode_bits  1
#define GEN6_3DSTATE_GS_FloatingPointMode_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_FloatingPointMode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_FloatingPointMode_start  112
#define GEN9_3DSTATE_GS_FloatingPointMode_start  112
#define GEN8_3DSTATE_GS_FloatingPointMode_start  112
#define GEN75_3DSTATE_GS_FloatingPointMode_start  80
#define GEN7_3DSTATE_GS_FloatingPointMode_start  80
#define GEN6_3DSTATE_GS_FloatingPointMode_start  80

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_FloatingPointMode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 112;
   case 9: return 112;
   case 8: return 112;
   case 7:
      if (devinfo->is_haswell) {
         return 80;
      } else {
         return 80;
      }
   case 6: return 80;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::GS Invocations Increment Value */


#define GEN75_3DSTATE_GS_GSInvocationsIncrementValue_bits  5
#define GEN7_3DSTATE_GS_GSInvocationsIncrementValue_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_GSInvocationsIncrementValue_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 5;
      } else {
         return 5;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN75_3DSTATE_GS_GSInvocationsIncrementValue_start  165
#define GEN7_3DSTATE_GS_GSInvocationsIncrementValue_start  165

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_GSInvocationsIncrementValue_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 165;
      } else {
         return 165;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::GS accesses UAV */


#define GEN75_3DSTATE_GS_GSaccessesUAV_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_GSaccessesUAV_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN75_3DSTATE_GS_GSaccessesUAV_start  76

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_GSaccessesUAV_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 76;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Hint */


#define GEN10_3DSTATE_GS_Hint_bits  1
#define GEN9_3DSTATE_GS_Hint_bits  1
#define GEN8_3DSTATE_GS_Hint_bits  1
#define GEN75_3DSTATE_GS_Hint_bits  1
#define GEN7_3DSTATE_GS_Hint_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_Hint_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_Hint_start  227
#define GEN9_3DSTATE_GS_Hint_start  227
#define GEN8_3DSTATE_GS_Hint_start  227
#define GEN75_3DSTATE_GS_Hint_start  163
#define GEN7_3DSTATE_GS_Hint_start  163

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_Hint_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 227;
   case 9: return 227;
   case 8: return 227;
   case 7:
      if (devinfo->is_haswell) {
         return 163;
      } else {
         return 163;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Illegal Opcode Exception Enable */


#define GEN10_3DSTATE_GS_IllegalOpcodeExceptionEnable_bits  1
#define GEN9_3DSTATE_GS_IllegalOpcodeExceptionEnable_bits  1
#define GEN8_3DSTATE_GS_IllegalOpcodeExceptionEnable_bits  1
#define GEN75_3DSTATE_GS_IllegalOpcodeExceptionEnable_bits  1
#define GEN7_3DSTATE_GS_IllegalOpcodeExceptionEnable_bits  1
#define GEN6_3DSTATE_GS_IllegalOpcodeExceptionEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_IllegalOpcodeExceptionEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_IllegalOpcodeExceptionEnable_start  109
#define GEN9_3DSTATE_GS_IllegalOpcodeExceptionEnable_start  109
#define GEN8_3DSTATE_GS_IllegalOpcodeExceptionEnable_start  109
#define GEN75_3DSTATE_GS_IllegalOpcodeExceptionEnable_start  77
#define GEN7_3DSTATE_GS_IllegalOpcodeExceptionEnable_start  77
#define GEN6_3DSTATE_GS_IllegalOpcodeExceptionEnable_start  77

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_IllegalOpcodeExceptionEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 109;
   case 9: return 109;
   case 8: return 109;
   case 7:
      if (devinfo->is_haswell) {
         return 77;
      } else {
         return 77;
      }
   case 6: return 77;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Include Primitive ID */


#define GEN10_3DSTATE_GS_IncludePrimitiveID_bits  1
#define GEN9_3DSTATE_GS_IncludePrimitiveID_bits  1
#define GEN8_3DSTATE_GS_IncludePrimitiveID_bits  1
#define GEN75_3DSTATE_GS_IncludePrimitiveID_bits  1
#define GEN7_3DSTATE_GS_IncludePrimitiveID_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_IncludePrimitiveID_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_IncludePrimitiveID_start  228
#define GEN9_3DSTATE_GS_IncludePrimitiveID_start  228
#define GEN8_3DSTATE_GS_IncludePrimitiveID_start  228
#define GEN75_3DSTATE_GS_IncludePrimitiveID_start  164
#define GEN7_3DSTATE_GS_IncludePrimitiveID_start  164

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_IncludePrimitiveID_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 228;
   case 9: return 228;
   case 8: return 228;
   case 7:
      if (devinfo->is_haswell) {
         return 164;
      } else {
         return 164;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Include Vertex Handles */


#define GEN10_3DSTATE_GS_IncludeVertexHandles_bits  1
#define GEN9_3DSTATE_GS_IncludeVertexHandles_bits  1
#define GEN8_3DSTATE_GS_IncludeVertexHandles_bits  1
#define GEN75_3DSTATE_GS_IncludeVertexHandles_bits  1
#define GEN7_3DSTATE_GS_IncludeVertexHandles_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_IncludeVertexHandles_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_IncludeVertexHandles_start  202
#define GEN9_3DSTATE_GS_IncludeVertexHandles_start  202
#define GEN8_3DSTATE_GS_IncludeVertexHandles_start  202
#define GEN75_3DSTATE_GS_IncludeVertexHandles_start  138
#define GEN7_3DSTATE_GS_IncludeVertexHandles_start  138

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_IncludeVertexHandles_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 202;
   case 9: return 202;
   case 8: return 202;
   case 7:
      if (devinfo->is_haswell) {
         return 138;
      } else {
         return 138;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Instance Control */


#define GEN10_3DSTATE_GS_InstanceControl_bits  5
#define GEN9_3DSTATE_GS_InstanceControl_bits  5
#define GEN8_3DSTATE_GS_InstanceControl_bits  5
#define GEN75_3DSTATE_GS_InstanceControl_bits  5
#define GEN7_3DSTATE_GS_InstanceControl_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_InstanceControl_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 5;
   case 9: return 5;
   case 8: return 5;
   case 7:
      if (devinfo->is_haswell) {
         return 5;
      } else {
         return 5;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_InstanceControl_start  239
#define GEN9_3DSTATE_GS_InstanceControl_start  239
#define GEN8_3DSTATE_GS_InstanceControl_start  239
#define GEN75_3DSTATE_GS_InstanceControl_start  175
#define GEN7_3DSTATE_GS_InstanceControl_start  175

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_InstanceControl_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 239;
   case 9: return 239;
   case 8: return 239;
   case 7:
      if (devinfo->is_haswell) {
         return 175;
      } else {
         return 175;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Invocations Increment Value */


#define GEN10_3DSTATE_GS_InvocationsIncrementValue_bits  5
#define GEN9_3DSTATE_GS_InvocationsIncrementValue_bits  5
#define GEN8_3DSTATE_GS_InvocationsIncrementValue_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_InvocationsIncrementValue_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 5;
   case 9: return 5;
   case 8: return 5;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_InvocationsIncrementValue_start  229
#define GEN9_3DSTATE_GS_InvocationsIncrementValue_start  229
#define GEN8_3DSTATE_GS_InvocationsIncrementValue_start  229

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_InvocationsIncrementValue_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 229;
   case 9: return 229;
   case 8: return 229;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Kernel Start Pointer */


#define GEN10_3DSTATE_GS_KernelStartPointer_bits  58
#define GEN9_3DSTATE_GS_KernelStartPointer_bits  58
#define GEN8_3DSTATE_GS_KernelStartPointer_bits  58
#define GEN75_3DSTATE_GS_KernelStartPointer_bits  26
#define GEN7_3DSTATE_GS_KernelStartPointer_bits  26
#define GEN6_3DSTATE_GS_KernelStartPointer_bits  26

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_KernelStartPointer_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 58;
   case 9: return 58;
   case 8: return 58;
   case 7:
      if (devinfo->is_haswell) {
         return 26;
      } else {
         return 26;
      }
   case 6: return 26;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_KernelStartPointer_start  38
#define GEN9_3DSTATE_GS_KernelStartPointer_start  38
#define GEN8_3DSTATE_GS_KernelStartPointer_start  38
#define GEN75_3DSTATE_GS_KernelStartPointer_start  38
#define GEN7_3DSTATE_GS_KernelStartPointer_start  38
#define GEN6_3DSTATE_GS_KernelStartPointer_start  38

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_KernelStartPointer_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 38;
   case 9: return 38;
   case 8: return 38;
   case 7:
      if (devinfo->is_haswell) {
         return 38;
      } else {
         return 38;
      }
   case 6: return 38;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Mask Stack Exception Enable */


#define GEN10_3DSTATE_GS_MaskStackExceptionEnable_bits  1
#define GEN9_3DSTATE_GS_MaskStackExceptionEnable_bits  1
#define GEN8_3DSTATE_GS_MaskStackExceptionEnable_bits  1
#define GEN75_3DSTATE_GS_MaskStackExceptionEnable_bits  1
#define GEN7_3DSTATE_GS_MaskStackExceptionEnable_bits  1
#define GEN6_3DSTATE_GS_MaskStackExceptionEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_MaskStackExceptionEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_MaskStackExceptionEnable_start  107
#define GEN9_3DSTATE_GS_MaskStackExceptionEnable_start  107
#define GEN8_3DSTATE_GS_MaskStackExceptionEnable_start  107
#define GEN75_3DSTATE_GS_MaskStackExceptionEnable_start  75
#define GEN7_3DSTATE_GS_MaskStackExceptionEnable_start  75
#define GEN6_3DSTATE_GS_MaskStackExceptionEnable_start  75

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_MaskStackExceptionEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 107;
   case 9: return 107;
   case 8: return 107;
   case 7:
      if (devinfo->is_haswell) {
         return 75;
      } else {
         return 75;
      }
   case 6: return 75;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Maximum Number of Threads */


#define GEN10_3DSTATE_GS_MaximumNumberofThreads_bits  9
#define GEN9_3DSTATE_GS_MaximumNumberofThreads_bits  9
#define GEN8_3DSTATE_GS_MaximumNumberofThreads_bits  8
#define GEN75_3DSTATE_GS_MaximumNumberofThreads_bits  8
#define GEN7_3DSTATE_GS_MaximumNumberofThreads_bits  7
#define GEN6_3DSTATE_GS_MaximumNumberofThreads_bits  7

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_MaximumNumberofThreads_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 9;
   case 9: return 9;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 7;
      }
   case 6: return 7;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_MaximumNumberofThreads_start  256
#define GEN9_3DSTATE_GS_MaximumNumberofThreads_start  256
#define GEN8_3DSTATE_GS_MaximumNumberofThreads_start  248
#define GEN75_3DSTATE_GS_MaximumNumberofThreads_start  184
#define GEN7_3DSTATE_GS_MaximumNumberofThreads_start  185
#define GEN6_3DSTATE_GS_MaximumNumberofThreads_start  185

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_MaximumNumberofThreads_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 256;
   case 9: return 256;
   case 8: return 248;
   case 7:
      if (devinfo->is_haswell) {
         return 184;
      } else {
         return 185;
      }
   case 6: return 185;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Output Topology */


#define GEN10_3DSTATE_GS_OutputTopology_bits  6
#define GEN9_3DSTATE_GS_OutputTopology_bits  6
#define GEN8_3DSTATE_GS_OutputTopology_bits  6
#define GEN75_3DSTATE_GS_OutputTopology_bits  6
#define GEN7_3DSTATE_GS_OutputTopology_bits  6

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_OutputTopology_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 6;
   case 9: return 6;
   case 8: return 6;
   case 7:
      if (devinfo->is_haswell) {
         return 6;
      } else {
         return 6;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_OutputTopology_start  209
#define GEN9_3DSTATE_GS_OutputTopology_start  209
#define GEN8_3DSTATE_GS_OutputTopology_start  209
#define GEN75_3DSTATE_GS_OutputTopology_start  145
#define GEN7_3DSTATE_GS_OutputTopology_start  145

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_OutputTopology_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 209;
   case 9: return 209;
   case 8: return 209;
   case 7:
      if (devinfo->is_haswell) {
         return 145;
      } else {
         return 145;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Output Vertex Size */


#define GEN10_3DSTATE_GS_OutputVertexSize_bits  6
#define GEN9_3DSTATE_GS_OutputVertexSize_bits  6
#define GEN8_3DSTATE_GS_OutputVertexSize_bits  6
#define GEN75_3DSTATE_GS_OutputVertexSize_bits  6
#define GEN7_3DSTATE_GS_OutputVertexSize_bits  6

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_OutputVertexSize_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 6;
   case 9: return 6;
   case 8: return 6;
   case 7:
      if (devinfo->is_haswell) {
         return 6;
      } else {
         return 6;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_OutputVertexSize_start  215
#define GEN9_3DSTATE_GS_OutputVertexSize_start  215
#define GEN8_3DSTATE_GS_OutputVertexSize_start  215
#define GEN75_3DSTATE_GS_OutputVertexSize_start  151
#define GEN7_3DSTATE_GS_OutputVertexSize_start  151

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_OutputVertexSize_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 215;
   case 9: return 215;
   case 8: return 215;
   case 7:
      if (devinfo->is_haswell) {
         return 151;
      } else {
         return 151;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Per-Thread Scratch Space */


#define GEN10_3DSTATE_GS_PerThreadScratchSpace_bits  4
#define GEN9_3DSTATE_GS_PerThreadScratchSpace_bits  4
#define GEN8_3DSTATE_GS_PerThreadScratchSpace_bits  4
#define GEN75_3DSTATE_GS_PerThreadScratchSpace_bits  4
#define GEN7_3DSTATE_GS_PerThreadScratchSpace_bits  4
#define GEN6_3DSTATE_GS_PerThreadScratchSpace_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_PerThreadScratchSpace_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 4;
   case 9: return 4;
   case 8: return 4;
   case 7:
      if (devinfo->is_haswell) {
         return 4;
      } else {
         return 4;
      }
   case 6: return 4;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_PerThreadScratchSpace_start  128
#define GEN9_3DSTATE_GS_PerThreadScratchSpace_start  128
#define GEN8_3DSTATE_GS_PerThreadScratchSpace_start  128
#define GEN75_3DSTATE_GS_PerThreadScratchSpace_start  96
#define GEN7_3DSTATE_GS_PerThreadScratchSpace_start  96
#define GEN6_3DSTATE_GS_PerThreadScratchSpace_start  96

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_PerThreadScratchSpace_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 128;
   case 9: return 128;
   case 8: return 128;
   case 7:
      if (devinfo->is_haswell) {
         return 96;
      } else {
         return 96;
      }
   case 6: return 96;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Rendering Enabled */


#define GEN6_3DSTATE_GS_RenderingEnabled_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_RenderingEnabled_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_GS_RenderingEnabled_start  168

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_RenderingEnabled_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 168;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Reorder Mode */


#define GEN10_3DSTATE_GS_ReorderMode_bits  1
#define GEN9_3DSTATE_GS_ReorderMode_bits  1
#define GEN8_3DSTATE_GS_ReorderMode_bits  1
#define GEN75_3DSTATE_GS_ReorderMode_bits  1
#define GEN7_3DSTATE_GS_ReorderMode_bits  1
#define GEN6_3DSTATE_GS_ReorderMode_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_ReorderMode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_ReorderMode_start  226
#define GEN9_3DSTATE_GS_ReorderMode_start  226
#define GEN8_3DSTATE_GS_ReorderMode_start  226
#define GEN75_3DSTATE_GS_ReorderMode_start  162
#define GEN7_3DSTATE_GS_ReorderMode_start  162
#define GEN6_3DSTATE_GS_ReorderMode_start  222

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_ReorderMode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 226;
   case 9: return 226;
   case 8: return 226;
   case 7:
      if (devinfo->is_haswell) {
         return 162;
      } else {
         return 162;
      }
   case 6: return 222;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::SO Statistics Enable */


#define GEN6_3DSTATE_GS_SOStatisticsEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SOStatisticsEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_GS_SOStatisticsEnable_start  169

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SOStatisticsEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 169;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::SVBI Payload Enable */


#define GEN6_3DSTATE_GS_SVBIPayloadEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVBIPayloadEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_GS_SVBIPayloadEnable_start  220

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVBIPayloadEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 220;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::SVBI Post-Increment Enable */


#define GEN6_3DSTATE_GS_SVBIPostIncrementEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVBIPostIncrementEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_GS_SVBIPostIncrementEnable_start  219

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVBIPostIncrementEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 219;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::SVBI Post-Increment Value */


#define GEN6_3DSTATE_GS_SVBIPostIncrementValue_bits  10

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVBIPostIncrementValue_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 10;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_GS_SVBIPostIncrementValue_start  208

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVBIPostIncrementValue_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 208;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Sampler Count */


#define GEN10_3DSTATE_GS_SamplerCount_bits  3
#define GEN9_3DSTATE_GS_SamplerCount_bits  3
#define GEN8_3DSTATE_GS_SamplerCount_bits  3
#define GEN75_3DSTATE_GS_SamplerCount_bits  3
#define GEN7_3DSTATE_GS_SamplerCount_bits  3
#define GEN6_3DSTATE_GS_SamplerCount_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SamplerCount_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_SamplerCount_start  123
#define GEN9_3DSTATE_GS_SamplerCount_start  123
#define GEN8_3DSTATE_GS_SamplerCount_start  123
#define GEN75_3DSTATE_GS_SamplerCount_start  91
#define GEN7_3DSTATE_GS_SamplerCount_start  91
#define GEN6_3DSTATE_GS_SamplerCount_start  91

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SamplerCount_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 123;
   case 9: return 123;
   case 8: return 123;
   case 7:
      if (devinfo->is_haswell) {
         return 91;
      } else {
         return 91;
      }
   case 6: return 91;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Scratch Space Base Pointer */


#define GEN10_3DSTATE_GS_ScratchSpaceBasePointer_bits  54
#define GEN9_3DSTATE_GS_ScratchSpaceBasePointer_bits  54
#define GEN8_3DSTATE_GS_ScratchSpaceBasePointer_bits  54
#define GEN75_3DSTATE_GS_ScratchSpaceBasePointer_bits  22
#define GEN7_3DSTATE_GS_ScratchSpaceBasePointer_bits  22
#define GEN6_3DSTATE_GS_ScratchSpaceBasePointer_bits  22

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_ScratchSpaceBasePointer_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 54;
   case 9: return 54;
   case 8: return 54;
   case 7:
      if (devinfo->is_haswell) {
         return 22;
      } else {
         return 22;
      }
   case 6: return 22;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_ScratchSpaceBasePointer_start  138
#define GEN9_3DSTATE_GS_ScratchSpaceBasePointer_start  138
#define GEN8_3DSTATE_GS_ScratchSpaceBasePointer_start  138
#define GEN75_3DSTATE_GS_ScratchSpaceBasePointer_start  106
#define GEN7_3DSTATE_GS_ScratchSpaceBasePointer_start  106
#define GEN6_3DSTATE_GS_ScratchSpaceBasePointer_start  106

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_ScratchSpaceBasePointer_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 138;
   case 9: return 138;
   case 8: return 138;
   case 7:
      if (devinfo->is_haswell) {
         return 106;
      } else {
         return 106;
      }
   case 6: return 106;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Semaphore Handle */


#define GEN75_3DSTATE_GS_SemaphoreHandle_bits  13
#define GEN7_3DSTATE_GS_SemaphoreHandle_bits  12

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SemaphoreHandle_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 13;
      } else {
         return 12;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN75_3DSTATE_GS_SemaphoreHandle_start  192
#define GEN7_3DSTATE_GS_SemaphoreHandle_start  192

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SemaphoreHandle_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 192;
      } else {
         return 192;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Single Program Flow */


#define GEN10_3DSTATE_GS_SingleProgramFlow_bits  1
#define GEN9_3DSTATE_GS_SingleProgramFlow_bits  1
#define GEN8_3DSTATE_GS_SingleProgramFlow_bits  1
#define GEN75_3DSTATE_GS_SingleProgramFlow_bits  1
#define GEN7_3DSTATE_GS_SingleProgramFlow_bits  1
#define GEN6_3DSTATE_GS_SingleProgramFlow_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SingleProgramFlow_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_SingleProgramFlow_start  127
#define GEN9_3DSTATE_GS_SingleProgramFlow_start  127
#define GEN8_3DSTATE_GS_SingleProgramFlow_start  127
#define GEN75_3DSTATE_GS_SingleProgramFlow_start  95
#define GEN7_3DSTATE_GS_SingleProgramFlow_start  95
#define GEN6_3DSTATE_GS_SingleProgramFlow_start  95

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SingleProgramFlow_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 127;
   case 9: return 127;
   case 8: return 127;
   case 7:
      if (devinfo->is_haswell) {
         return 95;
      } else {
         return 95;
      }
   case 6: return 95;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Software Exception Enable */


#define GEN10_3DSTATE_GS_SoftwareExceptionEnable_bits  1
#define GEN9_3DSTATE_GS_SoftwareExceptionEnable_bits  1
#define GEN8_3DSTATE_GS_SoftwareExceptionEnable_bits  1
#define GEN75_3DSTATE_GS_SoftwareExceptionEnable_bits  1
#define GEN7_3DSTATE_GS_SoftwareExceptionEnable_bits  1
#define GEN6_3DSTATE_GS_SoftwareExceptionEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SoftwareExceptionEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_SoftwareExceptionEnable_start  103
#define GEN9_3DSTATE_GS_SoftwareExceptionEnable_start  103
#define GEN8_3DSTATE_GS_SoftwareExceptionEnable_start  103
#define GEN75_3DSTATE_GS_SoftwareExceptionEnable_start  71
#define GEN7_3DSTATE_GS_SoftwareExceptionEnable_start  71
#define GEN6_3DSTATE_GS_SoftwareExceptionEnable_start  71

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SoftwareExceptionEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 103;
   case 9: return 103;
   case 8: return 103;
   case 7:
      if (devinfo->is_haswell) {
         return 71;
      } else {
         return 71;
      }
   case 6: return 71;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Static Output */


#define GEN10_3DSTATE_GS_StaticOutput_bits  1
#define GEN9_3DSTATE_GS_StaticOutput_bits  1
#define GEN8_3DSTATE_GS_StaticOutput_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_StaticOutput_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_StaticOutput_start  286
#define GEN9_3DSTATE_GS_StaticOutput_start  286
#define GEN8_3DSTATE_GS_StaticOutput_start  286

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_StaticOutput_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 286;
   case 9: return 286;
   case 8: return 286;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Static Output Vertex Count */


#define GEN10_3DSTATE_GS_StaticOutputVertexCount_bits  11
#define GEN9_3DSTATE_GS_StaticOutputVertexCount_bits  11
#define GEN8_3DSTATE_GS_StaticOutputVertexCount_bits  11

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_StaticOutputVertexCount_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 11;
   case 9: return 11;
   case 8: return 11;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_StaticOutputVertexCount_start  272
#define GEN9_3DSTATE_GS_StaticOutputVertexCount_start  272
#define GEN8_3DSTATE_GS_StaticOutputVertexCount_start  272

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_StaticOutputVertexCount_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 272;
   case 9: return 272;
   case 8: return 272;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Statistics Enable */


#define GEN10_3DSTATE_GS_StatisticsEnable_bits  1
#define GEN9_3DSTATE_GS_StatisticsEnable_bits  1
#define GEN8_3DSTATE_GS_StatisticsEnable_bits  1
#define GEN75_3DSTATE_GS_StatisticsEnable_bits  1
#define GEN7_3DSTATE_GS_StatisticsEnable_bits  1
#define GEN6_3DSTATE_GS_StatisticsEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_StatisticsEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_StatisticsEnable_start  234
#define GEN9_3DSTATE_GS_StatisticsEnable_start  234
#define GEN8_3DSTATE_GS_StatisticsEnable_start  234
#define GEN75_3DSTATE_GS_StatisticsEnable_start  170
#define GEN7_3DSTATE_GS_StatisticsEnable_start  170
#define GEN6_3DSTATE_GS_StatisticsEnable_start  170

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_StatisticsEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 234;
   case 9: return 234;
   case 8: return 234;
   case 7:
      if (devinfo->is_haswell) {
         return 170;
      } else {
         return 170;
      }
   case 6: return 170;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Thread Dispatch Priority */


#define GEN10_3DSTATE_GS_ThreadDispatchPriority_bits  1
#define GEN9_3DSTATE_GS_ThreadDispatchPriority_bits  1
#define GEN8_3DSTATE_GS_ThreadDispatchPriority_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_ThreadDispatchPriority_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_ThreadDispatchPriority_start  113
#define GEN9_3DSTATE_GS_ThreadDispatchPriority_start  113
#define GEN8_3DSTATE_GS_ThreadDispatchPriority_start  113

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_ThreadDispatchPriority_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 113;
   case 9: return 113;
   case 8: return 113;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Thread Priority */


#define GEN75_3DSTATE_GS_ThreadPriority_bits  1
#define GEN7_3DSTATE_GS_ThreadPriority_bits  1
#define GEN6_3DSTATE_GS_ThreadPriority_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_ThreadPriority_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN75_3DSTATE_GS_ThreadPriority_start  81
#define GEN7_3DSTATE_GS_ThreadPriority_start  81
#define GEN6_3DSTATE_GS_ThreadPriority_start  81

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_ThreadPriority_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 81;
      } else {
         return 81;
      }
   case 6: return 81;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::User Clip Distance Clip Test Enable Bitmask */


#define GEN10_3DSTATE_GS_UserClipDistanceClipTestEnableBitmask_bits  8
#define GEN9_3DSTATE_GS_UserClipDistanceClipTestEnableBitmask_bits  8
#define GEN8_3DSTATE_GS_UserClipDistanceClipTestEnableBitmask_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_UserClipDistanceClipTestEnableBitmask_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_UserClipDistanceClipTestEnableBitmask_start  296
#define GEN9_3DSTATE_GS_UserClipDistanceClipTestEnableBitmask_start  296
#define GEN8_3DSTATE_GS_UserClipDistanceClipTestEnableBitmask_start  296

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_UserClipDistanceClipTestEnableBitmask_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 296;
   case 9: return 296;
   case 8: return 296;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::User Clip Distance Cull Test Enable Bitmask */


#define GEN10_3DSTATE_GS_UserClipDistanceCullTestEnableBitmask_bits  8
#define GEN9_3DSTATE_GS_UserClipDistanceCullTestEnableBitmask_bits  8
#define GEN8_3DSTATE_GS_UserClipDistanceCullTestEnableBitmask_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_UserClipDistanceCullTestEnableBitmask_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_UserClipDistanceCullTestEnableBitmask_start  288
#define GEN9_3DSTATE_GS_UserClipDistanceCullTestEnableBitmask_start  288
#define GEN8_3DSTATE_GS_UserClipDistanceCullTestEnableBitmask_start  288

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_UserClipDistanceCullTestEnableBitmask_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 288;
   case 9: return 288;
   case 8: return 288;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Vector Mask Enable */


#define GEN10_3DSTATE_GS_VectorMaskEnable_bits  1
#define GEN9_3DSTATE_GS_VectorMaskEnable_bits  1
#define GEN8_3DSTATE_GS_VectorMaskEnable_bits  1
#define GEN75_3DSTATE_GS_VectorMaskEnable_bits  1
#define GEN7_3DSTATE_GS_VectorMaskEnable_bits  1
#define GEN6_3DSTATE_GS_VectorMaskEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_VectorMaskEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_VectorMaskEnable_start  126
#define GEN9_3DSTATE_GS_VectorMaskEnable_start  126
#define GEN8_3DSTATE_GS_VectorMaskEnable_start  126
#define GEN75_3DSTATE_GS_VectorMaskEnable_start  94
#define GEN7_3DSTATE_GS_VectorMaskEnable_start  94
#define GEN6_3DSTATE_GS_VectorMaskEnable_start  94

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_VectorMaskEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 126;
   case 9: return 126;
   case 8: return 126;
   case 7:
      if (devinfo->is_haswell) {
         return 94;
      } else {
         return 94;
      }
   case 6: return 94;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Vertex URB Entry Output Length */


#define GEN10_3DSTATE_GS_VertexURBEntryOutputLength_bits  5
#define GEN9_3DSTATE_GS_VertexURBEntryOutputLength_bits  5
#define GEN8_3DSTATE_GS_VertexURBEntryOutputLength_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_VertexURBEntryOutputLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 5;
   case 9: return 5;
   case 8: return 5;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_VertexURBEntryOutputLength_start  304
#define GEN9_3DSTATE_GS_VertexURBEntryOutputLength_start  304
#define GEN8_3DSTATE_GS_VertexURBEntryOutputLength_start  304

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_VertexURBEntryOutputLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 304;
   case 9: return 304;
   case 8: return 304;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Vertex URB Entry Output Read Offset */


#define GEN10_3DSTATE_GS_VertexURBEntryOutputReadOffset_bits  6
#define GEN9_3DSTATE_GS_VertexURBEntryOutputReadOffset_bits  6
#define GEN8_3DSTATE_GS_VertexURBEntryOutputReadOffset_bits  6

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_VertexURBEntryOutputReadOffset_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 6;
   case 9: return 6;
   case 8: return 6;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_VertexURBEntryOutputReadOffset_start  309
#define GEN9_3DSTATE_GS_VertexURBEntryOutputReadOffset_start  309
#define GEN8_3DSTATE_GS_VertexURBEntryOutputReadOffset_start  309

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_VertexURBEntryOutputReadOffset_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 309;
   case 9: return 309;
   case 8: return 309;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Vertex URB Entry Read Length */


#define GEN10_3DSTATE_GS_VertexURBEntryReadLength_bits  6
#define GEN9_3DSTATE_GS_VertexURBEntryReadLength_bits  6
#define GEN8_3DSTATE_GS_VertexURBEntryReadLength_bits  6
#define GEN75_3DSTATE_GS_VertexURBEntryReadLength_bits  6
#define GEN7_3DSTATE_GS_VertexURBEntryReadLength_bits  6
#define GEN6_3DSTATE_GS_VertexURBEntryReadLength_bits  6

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_VertexURBEntryReadLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 6;
   case 9: return 6;
   case 8: return 6;
   case 7:
      if (devinfo->is_haswell) {
         return 6;
      } else {
         return 6;
      }
   case 6: return 6;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_VertexURBEntryReadLength_start  203
#define GEN9_3DSTATE_GS_VertexURBEntryReadLength_start  203
#define GEN8_3DSTATE_GS_VertexURBEntryReadLength_start  203
#define GEN75_3DSTATE_GS_VertexURBEntryReadLength_start  139
#define GEN7_3DSTATE_GS_VertexURBEntryReadLength_start  139
#define GEN6_3DSTATE_GS_VertexURBEntryReadLength_start  139

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_VertexURBEntryReadLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 203;
   case 9: return 203;
   case 8: return 203;
   case 7:
      if (devinfo->is_haswell) {
         return 139;
      } else {
         return 139;
      }
   case 6: return 139;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Vertex URB Entry Read Offset */


#define GEN10_3DSTATE_GS_VertexURBEntryReadOffset_bits  6
#define GEN9_3DSTATE_GS_VertexURBEntryReadOffset_bits  6
#define GEN8_3DSTATE_GS_VertexURBEntryReadOffset_bits  6
#define GEN75_3DSTATE_GS_VertexURBEntryReadOffset_bits  6
#define GEN7_3DSTATE_GS_VertexURBEntryReadOffset_bits  6
#define GEN6_3DSTATE_GS_VertexURBEntryReadOffset_bits  6

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_VertexURBEntryReadOffset_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 6;
   case 9: return 6;
   case 8: return 6;
   case 7:
      if (devinfo->is_haswell) {
         return 6;
      } else {
         return 6;
      }
   case 6: return 6;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_GS_VertexURBEntryReadOffset_start  196
#define GEN9_3DSTATE_GS_VertexURBEntryReadOffset_start  196
#define GEN8_3DSTATE_GS_VertexURBEntryReadOffset_start  196
#define GEN75_3DSTATE_GS_VertexURBEntryReadOffset_start  132
#define GEN7_3DSTATE_GS_VertexURBEntryReadOffset_start  132
#define GEN6_3DSTATE_GS_VertexURBEntryReadOffset_start  132

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_VertexURBEntryReadOffset_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 196;
   case 9: return 196;
   case 8: return 196;
   case 7:
      if (devinfo->is_haswell) {
         return 132;
      } else {
         return 132;
      }
   case 6: return 132;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS_SVB_INDEX */


#define GEN6_3DSTATE_GS_SVB_INDEX_length  7

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 7;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS_SVB_INDEX::3D Command Opcode */


#define GEN6_3DSTATE_GS_SVB_INDEX_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 3;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_GS_SVB_INDEX_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 24;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS_SVB_INDEX::3D Command Sub Opcode */


#define GEN6_3DSTATE_GS_SVB_INDEX_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 8;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_GS_SVB_INDEX_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 16;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS_SVB_INDEX::Command SubType */


#define GEN6_3DSTATE_GS_SVB_INDEX_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 2;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_GS_SVB_INDEX_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 27;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS_SVB_INDEX::Command Type */


#define GEN6_3DSTATE_GS_SVB_INDEX_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 3;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_GS_SVB_INDEX_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 29;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS_SVB_INDEX::DWord Length */


#define GEN6_3DSTATE_GS_SVB_INDEX_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 8;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_GS_SVB_INDEX_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS_SVB_INDEX::Index Number */


#define GEN6_3DSTATE_GS_SVB_INDEX_IndexNumber_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_IndexNumber_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 2;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_GS_SVB_INDEX_IndexNumber_start  61

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_IndexNumber_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 61;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS_SVB_INDEX::Load Internal Vertex Count */


#define GEN6_3DSTATE_GS_SVB_INDEX_LoadInternalVertexCount_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_LoadInternalVertexCount_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_GS_SVB_INDEX_LoadInternalVertexCount_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_LoadInternalVertexCount_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 32;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS_SVB_INDEX::Maximum Index */


#define GEN6_3DSTATE_GS_SVB_INDEX_MaximumIndex_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_MaximumIndex_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 32;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_GS_SVB_INDEX_MaximumIndex_start  96

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_MaximumIndex_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 96;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS_SVB_INDEX::Streamed Vertex Buffer Index */


#define GEN6_3DSTATE_GS_SVB_INDEX_StreamedVertexBufferIndex_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_StreamedVertexBufferIndex_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 32;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN6_3DSTATE_GS_SVB_INDEX_StreamedVertexBufferIndex_start  64

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_StreamedVertexBufferIndex_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 64;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HIER_DEPTH_BUFFER */


#define GEN10_3DSTATE_HIER_DEPTH_BUFFER_length  5
#define GEN9_3DSTATE_HIER_DEPTH_BUFFER_length  5
#define GEN8_3DSTATE_HIER_DEPTH_BUFFER_length  5
#define GEN75_3DSTATE_HIER_DEPTH_BUFFER_length  3
#define GEN7_3DSTATE_HIER_DEPTH_BUFFER_length  3
#define GEN6_3DSTATE_HIER_DEPTH_BUFFER_length  3
#define GEN5_3DSTATE_HIER_DEPTH_BUFFER_length  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 5;
   case 9: return 5;
   case 8: return 5;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 3;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HIER_DEPTH_BUFFER::3D Command Opcode */


#define GEN10_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_bits  3
#define GEN7_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_bits  3
#define GEN6_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_bits  3
#define GEN5_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 3;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_start  24
#define GEN9_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_start  24
#define GEN8_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_start  24
#define GEN75_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_start  24
#define GEN7_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_start  24
#define GEN6_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_start  24
#define GEN5_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 24;
      }
   case 6: return 24;
   case 5: return 24;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HIER_DEPTH_BUFFER::3D Command Sub Opcode */


#define GEN10_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_bits  8
#define GEN7_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_bits  8
#define GEN6_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_bits  8
#define GEN5_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 8;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_start  16
#define GEN7_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_start  16
#define GEN6_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_start  16
#define GEN5_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 16;
   case 5: return 16;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HIER_DEPTH_BUFFER::Command SubType */


#define GEN10_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_bits  2
#define GEN9_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_bits  2
#define GEN8_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_bits  2
#define GEN75_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_bits  2
#define GEN7_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_bits  2
#define GEN6_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_bits  2
#define GEN5_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 2;
   case 5: return 2;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_start  27
#define GEN9_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_start  27
#define GEN8_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_start  27
#define GEN75_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_start  27
#define GEN7_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_start  27
#define GEN6_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_start  27
#define GEN5_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 27;
      }
   case 6: return 27;
   case 5: return 27;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HIER_DEPTH_BUFFER::Command Type */


#define GEN10_3DSTATE_HIER_DEPTH_BUFFER_CommandType_bits  3
#define GEN9_3DSTATE_HIER_DEPTH_BUFFER_CommandType_bits  3
#define GEN8_3DSTATE_HIER_DEPTH_BUFFER_CommandType_bits  3
#define GEN75_3DSTATE_HIER_DEPTH_BUFFER_CommandType_bits  3
#define GEN7_3DSTATE_HIER_DEPTH_BUFFER_CommandType_bits  3
#define GEN6_3DSTATE_HIER_DEPTH_BUFFER_CommandType_bits  3
#define GEN5_3DSTATE_HIER_DEPTH_BUFFER_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 3;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HIER_DEPTH_BUFFER_CommandType_start  29
#define GEN9_3DSTATE_HIER_DEPTH_BUFFER_CommandType_start  29
#define GEN8_3DSTATE_HIER_DEPTH_BUFFER_CommandType_start  29
#define GEN75_3DSTATE_HIER_DEPTH_BUFFER_CommandType_start  29
#define GEN7_3DSTATE_HIER_DEPTH_BUFFER_CommandType_start  29
#define GEN6_3DSTATE_HIER_DEPTH_BUFFER_CommandType_start  29
#define GEN5_3DSTATE_HIER_DEPTH_BUFFER_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 29;
      }
   case 6: return 29;
   case 5: return 29;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HIER_DEPTH_BUFFER::DWord Length */


#define GEN10_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_bits  8
#define GEN9_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_bits  8
#define GEN8_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_bits  8
#define GEN75_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_bits  8
#define GEN7_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_bits  8
#define GEN6_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_bits  8
#define GEN5_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 8;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_start  0
#define GEN9_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_start  0
#define GEN8_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_start  0
#define GEN75_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_start  0
#define GEN7_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_start  0
#define GEN6_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_start  0
#define GEN5_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HIER_DEPTH_BUFFER::Hierarchical Depth Buffer MOCS */


#define GEN10_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferMOCS_bits  7
#define GEN9_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferMOCS_bits  7
#define GEN8_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferMOCS_bits  7
#define GEN75_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferMOCS_bits  4
#define GEN7_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferMOCS_bits  4
#define GEN6_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferMOCS_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferMOCS_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 7;
   case 9: return 7;
   case 8: return 7;
   case 7:
      if (devinfo->is_haswell) {
         return 4;
      } else {
         return 4;
      }
   case 6: return 4;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferMOCS_start  57
#define GEN9_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferMOCS_start  57
#define GEN8_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferMOCS_start  57
#define GEN75_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferMOCS_start  57
#define GEN7_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferMOCS_start  57
#define GEN6_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferMOCS_start  57

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferMOCS_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 57;
   case 9: return 57;
   case 8: return 57;
   case 7:
      if (devinfo->is_haswell) {
         return 57;
      } else {
         return 57;
      }
   case 6: return 57;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HIER_DEPTH_BUFFER::Hierarchical Depth Buffer Object Control State */


#define GEN10_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferObjectControlState_bits  7
#define GEN9_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferObjectControlState_bits  7
#define GEN8_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferObjectControlState_bits  7
#define GEN75_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferObjectControlState_bits  4
#define GEN7_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferObjectControlState_bits  4
#define GEN6_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferObjectControlState_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferObjectControlState_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 7;
   case 9: return 7;
   case 8: return 7;
   case 7:
      if (devinfo->is_haswell) {
         return 4;
      } else {
         return 4;
      }
   case 6: return 4;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferObjectControlState_start  57
#define GEN9_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferObjectControlState_start  57
#define GEN8_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferObjectControlState_start  57
#define GEN75_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferObjectControlState_start  57
#define GEN7_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferObjectControlState_start  57
#define GEN6_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferObjectControlState_start  57

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferObjectControlState_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 57;
   case 9: return 57;
   case 8: return 57;
   case 7:
      if (devinfo->is_haswell) {
         return 57;
      } else {
         return 57;
      }
   case 6: return 57;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HIER_DEPTH_BUFFER::Surface Base Address */


#define GEN10_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_bits  64
#define GEN9_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_bits  64
#define GEN8_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_bits  64
#define GEN75_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_bits  32
#define GEN7_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_bits  32
#define GEN6_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_bits  32
#define GEN5_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 64;
   case 9: return 64;
   case 8: return 64;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 32;
      }
   case 6: return 32;
   case 5: return 32;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_start  64
#define GEN9_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_start  64
#define GEN8_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_start  64
#define GEN75_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_start  64
#define GEN7_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_start  64
#define GEN6_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_start  64
#define GEN5_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_start  64

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 64;
   case 9: return 64;
   case 8: return 64;
   case 7:
      if (devinfo->is_haswell) {
         return 64;
      } else {
         return 64;
      }
   case 6: return 64;
   case 5: return 64;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HIER_DEPTH_BUFFER::Surface Pitch */


#define GEN10_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_bits  17
#define GEN9_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_bits  17
#define GEN8_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_bits  17
#define GEN75_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_bits  17
#define GEN7_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_bits  17
#define GEN6_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_bits  17
#define GEN5_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_bits  17

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 17;
   case 9: return 17;
   case 8: return 17;
   case 7:
      if (devinfo->is_haswell) {
         return 17;
      } else {
         return 17;
      }
   case 6: return 17;
   case 5: return 17;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_start  32
#define GEN9_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_start  32
#define GEN8_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_start  32
#define GEN75_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_start  32
#define GEN7_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_start  32
#define GEN6_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_start  32
#define GEN5_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 32;
      }
   case 6: return 32;
   case 5: return 32;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HIER_DEPTH_BUFFER::Surface QPitch */


#define GEN10_3DSTATE_HIER_DEPTH_BUFFER_SurfaceQPitch_bits  15
#define GEN9_3DSTATE_HIER_DEPTH_BUFFER_SurfaceQPitch_bits  15
#define GEN8_3DSTATE_HIER_DEPTH_BUFFER_SurfaceQPitch_bits  15

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_SurfaceQPitch_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 15;
   case 9: return 15;
   case 8: return 15;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HIER_DEPTH_BUFFER_SurfaceQPitch_start  128
#define GEN9_3DSTATE_HIER_DEPTH_BUFFER_SurfaceQPitch_start  128
#define GEN8_3DSTATE_HIER_DEPTH_BUFFER_SurfaceQPitch_start  128

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_SurfaceQPitch_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 128;
   case 9: return 128;
   case 8: return 128;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS */


#define GEN10_3DSTATE_HS_length  9
#define GEN9_3DSTATE_HS_length  9
#define GEN8_3DSTATE_HS_length  9
#define GEN75_3DSTATE_HS_length  7
#define GEN7_3DSTATE_HS_length  7

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 9;
   case 9: return 9;
   case 8: return 9;
   case 7:
      if (devinfo->is_haswell) {
         return 7;
      } else {
         return 7;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::3D Command Opcode */


#define GEN10_3DSTATE_HS_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_HS_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_HS_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_HS_3DCommandOpcode_bits  3
#define GEN7_3DSTATE_HS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HS_3DCommandOpcode_start  24
#define GEN9_3DSTATE_HS_3DCommandOpcode_start  24
#define GEN8_3DSTATE_HS_3DCommandOpcode_start  24
#define GEN75_3DSTATE_HS_3DCommandOpcode_start  24
#define GEN7_3DSTATE_HS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 24;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::3D Command Sub Opcode */


#define GEN10_3DSTATE_HS_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_HS_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_HS_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_HS_3DCommandSubOpcode_bits  8
#define GEN7_3DSTATE_HS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HS_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_HS_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_HS_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_HS_3DCommandSubOpcode_start  16
#define GEN7_3DSTATE_HS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Accesses UAV */


#define GEN10_3DSTATE_HS_AccessesUAV_bits  1
#define GEN9_3DSTATE_HS_AccessesUAV_bits  1
#define GEN8_3DSTATE_HS_AccessesUAV_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_AccessesUAV_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HS_AccessesUAV_start  249
#define GEN9_3DSTATE_HS_AccessesUAV_start  249
#define GEN8_3DSTATE_HS_AccessesUAV_start  249

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_AccessesUAV_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 249;
   case 9: return 249;
   case 8: return 249;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Binding Table Entry Count */


#define GEN10_3DSTATE_HS_BindingTableEntryCount_bits  8
#define GEN9_3DSTATE_HS_BindingTableEntryCount_bits  8
#define GEN8_3DSTATE_HS_BindingTableEntryCount_bits  8
#define GEN75_3DSTATE_HS_BindingTableEntryCount_bits  8
#define GEN7_3DSTATE_HS_BindingTableEntryCount_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_BindingTableEntryCount_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HS_BindingTableEntryCount_start  50
#define GEN9_3DSTATE_HS_BindingTableEntryCount_start  50
#define GEN8_3DSTATE_HS_BindingTableEntryCount_start  50
#define GEN75_3DSTATE_HS_BindingTableEntryCount_start  50
#define GEN7_3DSTATE_HS_BindingTableEntryCount_start  50

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_BindingTableEntryCount_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 50;
   case 9: return 50;
   case 8: return 50;
   case 7:
      if (devinfo->is_haswell) {
         return 50;
      } else {
         return 50;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Command SubType */


#define GEN10_3DSTATE_HS_CommandSubType_bits  2
#define GEN9_3DSTATE_HS_CommandSubType_bits  2
#define GEN8_3DSTATE_HS_CommandSubType_bits  2
#define GEN75_3DSTATE_HS_CommandSubType_bits  2
#define GEN7_3DSTATE_HS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HS_CommandSubType_start  27
#define GEN9_3DSTATE_HS_CommandSubType_start  27
#define GEN8_3DSTATE_HS_CommandSubType_start  27
#define GEN75_3DSTATE_HS_CommandSubType_start  27
#define GEN7_3DSTATE_HS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 27;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Command Type */


#define GEN10_3DSTATE_HS_CommandType_bits  3
#define GEN9_3DSTATE_HS_CommandType_bits  3
#define GEN8_3DSTATE_HS_CommandType_bits  3
#define GEN75_3DSTATE_HS_CommandType_bits  3
#define GEN7_3DSTATE_HS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HS_CommandType_start  29
#define GEN9_3DSTATE_HS_CommandType_start  29
#define GEN8_3DSTATE_HS_CommandType_start  29
#define GEN75_3DSTATE_HS_CommandType_start  29
#define GEN7_3DSTATE_HS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 29;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::DWord Length */


#define GEN10_3DSTATE_HS_DWordLength_bits  8
#define GEN9_3DSTATE_HS_DWordLength_bits  8
#define GEN8_3DSTATE_HS_DWordLength_bits  8
#define GEN75_3DSTATE_HS_DWordLength_bits  8
#define GEN7_3DSTATE_HS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HS_DWordLength_start  0
#define GEN9_3DSTATE_HS_DWordLength_start  0
#define GEN8_3DSTATE_HS_DWordLength_start  0
#define GEN75_3DSTATE_HS_DWordLength_start  0
#define GEN7_3DSTATE_HS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Dispatch GRF Start Register For URB Data */


#define GEN10_3DSTATE_HS_DispatchGRFStartRegisterForURBData_bits  5
#define GEN9_3DSTATE_HS_DispatchGRFStartRegisterForURBData_bits  5
#define GEN8_3DSTATE_HS_DispatchGRFStartRegisterForURBData_bits  5
#define GEN75_3DSTATE_HS_DispatchGRFStartRegisterForURBData_bits  5
#define GEN7_3DSTATE_HS_DispatchGRFStartRegisterForURBData_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_DispatchGRFStartRegisterForURBData_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 5;
   case 9: return 5;
   case 8: return 5;
   case 7:
      if (devinfo->is_haswell) {
         return 5;
      } else {
         return 5;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HS_DispatchGRFStartRegisterForURBData_start  243
#define GEN9_3DSTATE_HS_DispatchGRFStartRegisterForURBData_start  243
#define GEN8_3DSTATE_HS_DispatchGRFStartRegisterForURBData_start  243
#define GEN75_3DSTATE_HS_DispatchGRFStartRegisterForURBData_start  179
#define GEN7_3DSTATE_HS_DispatchGRFStartRegisterForURBData_start  179

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_DispatchGRFStartRegisterForURBData_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 243;
   case 9: return 243;
   case 8: return 243;
   case 7:
      if (devinfo->is_haswell) {
         return 179;
      } else {
         return 179;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Dispatch GRF Start Register For URB Data [5] */


#define GEN10_3DSTATE_HS_DispatchGRFStartRegisterForURBData5_bits  1
#define GEN9_3DSTATE_HS_DispatchGRFStartRegisterForURBData5_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_DispatchGRFStartRegisterForURBData5_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HS_DispatchGRFStartRegisterForURBData5_start  252
#define GEN9_3DSTATE_HS_DispatchGRFStartRegisterForURBData5_start  252

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_DispatchGRFStartRegisterForURBData5_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 252;
   case 9: return 252;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Dispatch Mode */


#define GEN10_3DSTATE_HS_DispatchMode_bits  2
#define GEN9_3DSTATE_HS_DispatchMode_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_DispatchMode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HS_DispatchMode_start  241
#define GEN9_3DSTATE_HS_DispatchMode_start  241

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_DispatchMode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 241;
   case 9: return 241;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Enable */


#define GEN10_3DSTATE_HS_Enable_bits  1
#define GEN9_3DSTATE_HS_Enable_bits  1
#define GEN8_3DSTATE_HS_Enable_bits  1
#define GEN75_3DSTATE_HS_Enable_bits  1
#define GEN7_3DSTATE_HS_Enable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_Enable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HS_Enable_start  95
#define GEN9_3DSTATE_HS_Enable_start  95
#define GEN8_3DSTATE_HS_Enable_start  95
#define GEN75_3DSTATE_HS_Enable_start  95
#define GEN7_3DSTATE_HS_Enable_start  95

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_Enable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 95;
   case 9: return 95;
   case 8: return 95;
   case 7:
      if (devinfo->is_haswell) {
         return 95;
      } else {
         return 95;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Floating Point Mode */


#define GEN10_3DSTATE_HS_FloatingPointMode_bits  1
#define GEN9_3DSTATE_HS_FloatingPointMode_bits  1
#define GEN8_3DSTATE_HS_FloatingPointMode_bits  1
#define GEN75_3DSTATE_HS_FloatingPointMode_bits  1
#define GEN7_3DSTATE_HS_FloatingPointMode_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_FloatingPointMode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HS_FloatingPointMode_start  48
#define GEN9_3DSTATE_HS_FloatingPointMode_start  48
#define GEN8_3DSTATE_HS_FloatingPointMode_start  48
#define GEN75_3DSTATE_HS_FloatingPointMode_start  48
#define GEN7_3DSTATE_HS_FloatingPointMode_start  48

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_FloatingPointMode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 48;
   case 9: return 48;
   case 8: return 48;
   case 7:
      if (devinfo->is_haswell) {
         return 48;
      } else {
         return 48;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::HS accesses UAV */


#define GEN75_3DSTATE_HS_HSaccessesUAV_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_HSaccessesUAV_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN75_3DSTATE_HS_HSaccessesUAV_start  185

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_HSaccessesUAV_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 185;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Illegal Opcode Exception Enable */


#define GEN10_3DSTATE_HS_IllegalOpcodeExceptionEnable_bits  1
#define GEN9_3DSTATE_HS_IllegalOpcodeExceptionEnable_bits  1
#define GEN8_3DSTATE_HS_IllegalOpcodeExceptionEnable_bits  1
#define GEN75_3DSTATE_HS_IllegalOpcodeExceptionEnable_bits  1
#define GEN7_3DSTATE_HS_IllegalOpcodeExceptionEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_IllegalOpcodeExceptionEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HS_IllegalOpcodeExceptionEnable_start  45
#define GEN9_3DSTATE_HS_IllegalOpcodeExceptionEnable_start  45
#define GEN8_3DSTATE_HS_IllegalOpcodeExceptionEnable_start  45
#define GEN75_3DSTATE_HS_IllegalOpcodeExceptionEnable_start  45
#define GEN7_3DSTATE_HS_IllegalOpcodeExceptionEnable_start  45

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_IllegalOpcodeExceptionEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 45;
   case 9: return 45;
   case 8: return 45;
   case 7:
      if (devinfo->is_haswell) {
         return 45;
      } else {
         return 45;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Include Primitive ID */


#define GEN10_3DSTATE_HS_IncludePrimitiveID_bits  1
#define GEN9_3DSTATE_HS_IncludePrimitiveID_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_IncludePrimitiveID_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HS_IncludePrimitiveID_start  224
#define GEN9_3DSTATE_HS_IncludePrimitiveID_start  224

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_IncludePrimitiveID_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 224;
   case 9: return 224;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Include Vertex Handles */


#define GEN10_3DSTATE_HS_IncludeVertexHandles_bits  1
#define GEN9_3DSTATE_HS_IncludeVertexHandles_bits  1
#define GEN8_3DSTATE_HS_IncludeVertexHandles_bits  1
#define GEN75_3DSTATE_HS_IncludeVertexHandles_bits  1
#define GEN7_3DSTATE_HS_IncludeVertexHandles_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_IncludeVertexHandles_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HS_IncludeVertexHandles_start  248
#define GEN9_3DSTATE_HS_IncludeVertexHandles_start  248
#define GEN8_3DSTATE_HS_IncludeVertexHandles_start  248
#define GEN75_3DSTATE_HS_IncludeVertexHandles_start  184
#define GEN7_3DSTATE_HS_IncludeVertexHandles_start  184

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_IncludeVertexHandles_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 248;
   case 9: return 248;
   case 8: return 248;
   case 7:
      if (devinfo->is_haswell) {
         return 184;
      } else {
         return 184;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Instance Count */


#define GEN10_3DSTATE_HS_InstanceCount_bits  4
#define GEN9_3DSTATE_HS_InstanceCount_bits  4
#define GEN8_3DSTATE_HS_InstanceCount_bits  4
#define GEN75_3DSTATE_HS_InstanceCount_bits  4
#define GEN7_3DSTATE_HS_InstanceCount_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_InstanceCount_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 4;
   case 9: return 4;
   case 8: return 4;
   case 7:
      if (devinfo->is_haswell) {
         return 4;
      } else {
         return 4;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HS_InstanceCount_start  64
#define GEN9_3DSTATE_HS_InstanceCount_start  64
#define GEN8_3DSTATE_HS_InstanceCount_start  64
#define GEN75_3DSTATE_HS_InstanceCount_start  64
#define GEN7_3DSTATE_HS_InstanceCount_start  64

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_InstanceCount_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 64;
   case 9: return 64;
   case 8: return 64;
   case 7:
      if (devinfo->is_haswell) {
         return 64;
      } else {
         return 64;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Kernel Start Pointer */


#define GEN10_3DSTATE_HS_KernelStartPointer_bits  58
#define GEN9_3DSTATE_HS_KernelStartPointer_bits  58
#define GEN8_3DSTATE_HS_KernelStartPointer_bits  58
#define GEN75_3DSTATE_HS_KernelStartPointer_bits  26
#define GEN7_3DSTATE_HS_KernelStartPointer_bits  26

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_KernelStartPointer_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 58;
   case 9: return 58;
   case 8: return 58;
   case 7:
      if (devinfo->is_haswell) {
         return 26;
      } else {
         return 26;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HS_KernelStartPointer_start  102
#define GEN9_3DSTATE_HS_KernelStartPointer_start  102
#define GEN8_3DSTATE_HS_KernelStartPointer_start  102
#define GEN75_3DSTATE_HS_KernelStartPointer_start  102
#define GEN7_3DSTATE_HS_KernelStartPointer_start  102

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_KernelStartPointer_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 102;
   case 9: return 102;
   case 8: return 102;
   case 7:
      if (devinfo->is_haswell) {
         return 102;
      } else {
         return 102;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Maximum Number of Threads */


#define GEN10_3DSTATE_HS_MaximumNumberofThreads_bits  9
#define GEN9_3DSTATE_HS_MaximumNumberofThreads_bits  9
#define GEN8_3DSTATE_HS_MaximumNumberofThreads_bits  9
#define GEN75_3DSTATE_HS_MaximumNumberofThreads_bits  8
#define GEN7_3DSTATE_HS_MaximumNumberofThreads_bits  7

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_MaximumNumberofThreads_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 9;
   case 9: return 9;
   case 8: return 9;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 7;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HS_MaximumNumberofThreads_start  72
#define GEN9_3DSTATE_HS_MaximumNumberofThreads_start  72
#define GEN8_3DSTATE_HS_MaximumNumberofThreads_start  72
#define GEN75_3DSTATE_HS_MaximumNumberofThreads_start  32
#define GEN7_3DSTATE_HS_MaximumNumberofThreads_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_MaximumNumberofThreads_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 72;
   case 9: return 72;
   case 8: return 72;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 32;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Per-Thread Scratch Space */


#define GEN10_3DSTATE_HS_PerThreadScratchSpace_bits  4
#define GEN9_3DSTATE_HS_PerThreadScratchSpace_bits  4
#define GEN8_3DSTATE_HS_PerThreadScratchSpace_bits  4
#define GEN75_3DSTATE_HS_PerThreadScratchSpace_bits  4
#define GEN7_3DSTATE_HS_PerThreadScratchSpace_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_PerThreadScratchSpace_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 4;
   case 9: return 4;
   case 8: return 4;
   case 7:
      if (devinfo->is_haswell) {
         return 4;
      } else {
         return 4;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HS_PerThreadScratchSpace_start  160
#define GEN9_3DSTATE_HS_PerThreadScratchSpace_start  160
#define GEN8_3DSTATE_HS_PerThreadScratchSpace_start  160
#define GEN75_3DSTATE_HS_PerThreadScratchSpace_start  128
#define GEN7_3DSTATE_HS_PerThreadScratchSpace_start  128

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_PerThreadScratchSpace_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 160;
   case 9: return 160;
   case 8: return 160;
   case 7:
      if (devinfo->is_haswell) {
         return 128;
      } else {
         return 128;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Sampler Count */


#define GEN10_3DSTATE_HS_SamplerCount_bits  3
#define GEN9_3DSTATE_HS_SamplerCount_bits  3
#define GEN8_3DSTATE_HS_SamplerCount_bits  3
#define GEN75_3DSTATE_HS_SamplerCount_bits  3
#define GEN7_3DSTATE_HS_SamplerCount_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_SamplerCount_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HS_SamplerCount_start  59
#define GEN9_3DSTATE_HS_SamplerCount_start  59
#define GEN8_3DSTATE_HS_SamplerCount_start  59
#define GEN75_3DSTATE_HS_SamplerCount_start  59
#define GEN7_3DSTATE_HS_SamplerCount_start  59

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_SamplerCount_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 59;
   case 9: return 59;
   case 8: return 59;
   case 7:
      if (devinfo->is_haswell) {
         return 59;
      } else {
         return 59;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Scratch Space Base Pointer */


#define GEN10_3DSTATE_HS_ScratchSpaceBasePointer_bits  54
#define GEN9_3DSTATE_HS_ScratchSpaceBasePointer_bits  54
#define GEN8_3DSTATE_HS_ScratchSpaceBasePointer_bits  54
#define GEN75_3DSTATE_HS_ScratchSpaceBasePointer_bits  22
#define GEN7_3DSTATE_HS_ScratchSpaceBasePointer_bits  22

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_ScratchSpaceBasePointer_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 54;
   case 9: return 54;
   case 8: return 54;
   case 7:
      if (devinfo->is_haswell) {
         return 22;
      } else {
         return 22;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HS_ScratchSpaceBasePointer_start  170
#define GEN9_3DSTATE_HS_ScratchSpaceBasePointer_start  170
#define GEN8_3DSTATE_HS_ScratchSpaceBasePointer_start  170
#define GEN75_3DSTATE_HS_ScratchSpaceBasePointer_start  138
#define GEN7_3DSTATE_HS_ScratchSpaceBasePointer_start  138

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_ScratchSpaceBasePointer_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 170;
   case 9: return 170;
   case 8: return 170;
   case 7:
      if (devinfo->is_haswell) {
         return 138;
      } else {
         return 138;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Semaphore Handle */


#define GEN75_3DSTATE_HS_SemaphoreHandle_bits  13
#define GEN7_3DSTATE_HS_SemaphoreHandle_bits  12

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_SemaphoreHandle_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 13;
      } else {
         return 12;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN75_3DSTATE_HS_SemaphoreHandle_start  192
#define GEN7_3DSTATE_HS_SemaphoreHandle_start  192

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_SemaphoreHandle_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 192;
      } else {
         return 192;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Single Program Flow */


#define GEN10_3DSTATE_HS_SingleProgramFlow_bits  1
#define GEN9_3DSTATE_HS_SingleProgramFlow_bits  1
#define GEN8_3DSTATE_HS_SingleProgramFlow_bits  1
#define GEN75_3DSTATE_HS_SingleProgramFlow_bits  1
#define GEN7_3DSTATE_HS_SingleProgramFlow_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_SingleProgramFlow_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HS_SingleProgramFlow_start  251
#define GEN9_3DSTATE_HS_SingleProgramFlow_start  251
#define GEN8_3DSTATE_HS_SingleProgramFlow_start  251
#define GEN75_3DSTATE_HS_SingleProgramFlow_start  187
#define GEN7_3DSTATE_HS_SingleProgramFlow_start  187

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_SingleProgramFlow_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 251;
   case 9: return 251;
   case 8: return 251;
   case 7:
      if (devinfo->is_haswell) {
         return 187;
      } else {
         return 187;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Software Exception Enable */


#define GEN10_3DSTATE_HS_SoftwareExceptionEnable_bits  1
#define GEN9_3DSTATE_HS_SoftwareExceptionEnable_bits  1
#define GEN8_3DSTATE_HS_SoftwareExceptionEnable_bits  1
#define GEN75_3DSTATE_HS_SoftwareExceptionEnable_bits  1
#define GEN7_3DSTATE_HS_SoftwareExceptionEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_SoftwareExceptionEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HS_SoftwareExceptionEnable_start  44
#define GEN9_3DSTATE_HS_SoftwareExceptionEnable_start  44
#define GEN8_3DSTATE_HS_SoftwareExceptionEnable_start  44
#define GEN75_3DSTATE_HS_SoftwareExceptionEnable_start  44
#define GEN7_3DSTATE_HS_SoftwareExceptionEnable_start  39

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_SoftwareExceptionEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 44;
   case 9: return 44;
   case 8: return 44;
   case 7:
      if (devinfo->is_haswell) {
         return 44;
      } else {
         return 39;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Statistics Enable */


#define GEN10_3DSTATE_HS_StatisticsEnable_bits  1
#define GEN9_3DSTATE_HS_StatisticsEnable_bits  1
#define GEN8_3DSTATE_HS_StatisticsEnable_bits  1
#define GEN75_3DSTATE_HS_StatisticsEnable_bits  1
#define GEN7_3DSTATE_HS_StatisticsEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_StatisticsEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HS_StatisticsEnable_start  93
#define GEN9_3DSTATE_HS_StatisticsEnable_start  93
#define GEN8_3DSTATE_HS_StatisticsEnable_start  93
#define GEN75_3DSTATE_HS_StatisticsEnable_start  93
#define GEN7_3DSTATE_HS_StatisticsEnable_start  93

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_StatisticsEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 93;
   case 9: return 93;
   case 8: return 93;
   case 7:
      if (devinfo->is_haswell) {
         return 93;
      } else {
         return 93;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Thread Dispatch Priority */


#define GEN10_3DSTATE_HS_ThreadDispatchPriority_bits  1
#define GEN9_3DSTATE_HS_ThreadDispatchPriority_bits  1
#define GEN8_3DSTATE_HS_ThreadDispatchPriority_bits  1
#define GEN75_3DSTATE_HS_ThreadDispatchPriority_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_ThreadDispatchPriority_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HS_ThreadDispatchPriority_start  49
#define GEN9_3DSTATE_HS_ThreadDispatchPriority_start  49
#define GEN8_3DSTATE_HS_ThreadDispatchPriority_start  49
#define GEN75_3DSTATE_HS_ThreadDispatchPriority_start  49

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_ThreadDispatchPriority_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 49;
   case 9: return 49;
   case 8: return 49;
   case 7:
      if (devinfo->is_haswell) {
         return 49;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Vector Mask Enable */


#define GEN10_3DSTATE_HS_VectorMaskEnable_bits  1
#define GEN9_3DSTATE_HS_VectorMaskEnable_bits  1
#define GEN8_3DSTATE_HS_VectorMaskEnable_bits  1
#define GEN75_3DSTATE_HS_VectorMaskEnable_bits  1
#define GEN7_3DSTATE_HS_VectorMaskEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_VectorMaskEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HS_VectorMaskEnable_start  250
#define GEN9_3DSTATE_HS_VectorMaskEnable_start  250
#define GEN8_3DSTATE_HS_VectorMaskEnable_start  250
#define GEN75_3DSTATE_HS_VectorMaskEnable_start  186
#define GEN7_3DSTATE_HS_VectorMaskEnable_start  186

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_VectorMaskEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 250;
   case 9: return 250;
   case 8: return 250;
   case 7:
      if (devinfo->is_haswell) {
         return 186;
      } else {
         return 186;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Vertex URB Entry Read Length */


#define GEN10_3DSTATE_HS_VertexURBEntryReadLength_bits  6
#define GEN9_3DSTATE_HS_VertexURBEntryReadLength_bits  6
#define GEN8_3DSTATE_HS_VertexURBEntryReadLength_bits  6
#define GEN75_3DSTATE_HS_VertexURBEntryReadLength_bits  6
#define GEN7_3DSTATE_HS_VertexURBEntryReadLength_bits  6

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_VertexURBEntryReadLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 6;
   case 9: return 6;
   case 8: return 6;
   case 7:
      if (devinfo->is_haswell) {
         return 6;
      } else {
         return 6;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HS_VertexURBEntryReadLength_start  235
#define GEN9_3DSTATE_HS_VertexURBEntryReadLength_start  235
#define GEN8_3DSTATE_HS_VertexURBEntryReadLength_start  235
#define GEN75_3DSTATE_HS_VertexURBEntryReadLength_start  171
#define GEN7_3DSTATE_HS_VertexURBEntryReadLength_start  171

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_VertexURBEntryReadLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 235;
   case 9: return 235;
   case 8: return 235;
   case 7:
      if (devinfo->is_haswell) {
         return 171;
      } else {
         return 171;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Vertex URB Entry Read Offset */


#define GEN10_3DSTATE_HS_VertexURBEntryReadOffset_bits  6
#define GEN9_3DSTATE_HS_VertexURBEntryReadOffset_bits  6
#define GEN8_3DSTATE_HS_VertexURBEntryReadOffset_bits  6
#define GEN75_3DSTATE_HS_VertexURBEntryReadOffset_bits  6
#define GEN7_3DSTATE_HS_VertexURBEntryReadOffset_bits  6

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_VertexURBEntryReadOffset_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 6;
   case 9: return 6;
   case 8: return 6;
   case 7:
      if (devinfo->is_haswell) {
         return 6;
      } else {
         return 6;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_HS_VertexURBEntryReadOffset_start  228
#define GEN9_3DSTATE_HS_VertexURBEntryReadOffset_start  228
#define GEN8_3DSTATE_HS_VertexURBEntryReadOffset_start  228
#define GEN75_3DSTATE_HS_VertexURBEntryReadOffset_start  164
#define GEN7_3DSTATE_HS_VertexURBEntryReadOffset_start  164

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_VertexURBEntryReadOffset_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 228;
   case 9: return 228;
   case 8: return 228;
   case 7:
      if (devinfo->is_haswell) {
         return 164;
      } else {
         return 164;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_INDEX_BUFFER */


#define GEN10_3DSTATE_INDEX_BUFFER_length  5
#define GEN9_3DSTATE_INDEX_BUFFER_length  5
#define GEN8_3DSTATE_INDEX_BUFFER_length  5
#define GEN75_3DSTATE_INDEX_BUFFER_length  3
#define GEN7_3DSTATE_INDEX_BUFFER_length  3
#define GEN6_3DSTATE_INDEX_BUFFER_length  3
#define GEN5_3DSTATE_INDEX_BUFFER_length  3
#define GEN45_3DSTATE_INDEX_BUFFER_length  3
#define GEN4_3DSTATE_INDEX_BUFFER_length  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_INDEX_BUFFER_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 5;
   case 9: return 5;
   case 8: return 5;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 3;
   case 4:
      if (devinfo->is_g4x) {
         return 3;
      } else {
         return 3;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_INDEX_BUFFER::3D Command Opcode */


#define GEN10_3DSTATE_INDEX_BUFFER_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_INDEX_BUFFER_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_INDEX_BUFFER_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_INDEX_BUFFER_3DCommandOpcode_bits  3
#define GEN7_3DSTATE_INDEX_BUFFER_3DCommandOpcode_bits  3
#define GEN6_3DSTATE_INDEX_BUFFER_3DCommandOpcode_bits  3
#define GEN5_3DSTATE_INDEX_BUFFER_3DCommandOpcode_bits  3
#define GEN45_3DSTATE_INDEX_BUFFER_3DCommandOpcode_bits  3
#define GEN4_3DSTATE_INDEX_BUFFER_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_INDEX_BUFFER_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 3;
   case 4:
      if (devinfo->is_g4x) {
         return 3;
      } else {
         return 3;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_INDEX_BUFFER_3DCommandOpcode_start  24
#define GEN9_3DSTATE_INDEX_BUFFER_3DCommandOpcode_start  24
#define GEN8_3DSTATE_INDEX_BUFFER_3DCommandOpcode_start  24
#define GEN75_3DSTATE_INDEX_BUFFER_3DCommandOpcode_start  24
#define GEN7_3DSTATE_INDEX_BUFFER_3DCommandOpcode_start  24
#define GEN6_3DSTATE_INDEX_BUFFER_3DCommandOpcode_start  24
#define GEN5_3DSTATE_INDEX_BUFFER_3DCommandOpcode_start  24
#define GEN45_3DSTATE_INDEX_BUFFER_3DCommandOpcode_start  24
#define GEN4_3DSTATE_INDEX_BUFFER_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_INDEX_BUFFER_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 24;
      }
   case 6: return 24;
   case 5: return 24;
   case 4:
      if (devinfo->is_g4x) {
         return 24;
      } else {
         return 24;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_INDEX_BUFFER::3D Command Sub Opcode */


#define GEN10_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_bits  8
#define GEN7_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_bits  8
#define GEN6_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_bits  8
#define GEN5_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_bits  8
#define GEN45_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_bits  8
#define GEN4_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 8;
   case 4:
      if (devinfo->is_g4x) {
         return 8;
      } else {
         return 8;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_start  16
#define GEN7_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_start  16
#define GEN6_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_start  16
#define GEN5_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_start  16
#define GEN45_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_start  16
#define GEN4_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 16;
   case 5: return 16;
   case 4:
      if (devinfo->is_g4x) {
         return 16;
      } else {
         return 16;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_INDEX_BUFFER::Buffer Ending Address */


#define GEN75_3DSTATE_INDEX_BUFFER_BufferEndingAddress_bits  32
#define GEN7_3DSTATE_INDEX_BUFFER_BufferEndingAddress_bits  32
#define GEN6_3DSTATE_INDEX_BUFFER_BufferEndingAddress_bits  32
#define GEN5_3DSTATE_INDEX_BUFFER_BufferEndingAddress_bits  32
#define GEN45_3DSTATE_INDEX_BUFFER_BufferEndingAddress_bits  32
#define GEN4_3DSTATE_INDEX_BUFFER_BufferEndingAddress_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_INDEX_BUFFER_BufferEndingAddress_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 32;
      }
   case 6: return 32;
   case 5: return 32;
   case 4:
      if (devinfo->is_g4x) {
         return 32;
      } else {
         return 32;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN75_3DSTATE_INDEX_BUFFER_BufferEndingAddress_start  64
#define GEN7_3DSTATE_INDEX_BUFFER_BufferEndingAddress_start  64
#define GEN6_3DSTATE_INDEX_BUFFER_BufferEndingAddress_start  64
#define GEN5_3DSTATE_INDEX_BUFFER_BufferEndingAddress_start  64
#define GEN45_3DSTATE_INDEX_BUFFER_BufferEndingAddress_start  64
#define GEN4_3DSTATE_INDEX_BUFFER_BufferEndingAddress_start  64

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_INDEX_BUFFER_BufferEndingAddress_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 64;
      } else {
         return 64;
      }
   case 6: return 64;
   case 5: return 64;
   case 4:
      if (devinfo->is_g4x) {
         return 64;
      } else {
         return 64;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_INDEX_BUFFER::Buffer Size */


#define GEN10_3DSTATE_INDEX_BUFFER_BufferSize_bits  32
#define GEN9_3DSTATE_INDEX_BUFFER_BufferSize_bits  32
#define GEN8_3DSTATE_INDEX_BUFFER_BufferSize_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_INDEX_BUFFER_BufferSize_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_INDEX_BUFFER_BufferSize_start  128
#define GEN9_3DSTATE_INDEX_BUFFER_BufferSize_start  128
#define GEN8_3DSTATE_INDEX_BUFFER_BufferSize_start  128

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_INDEX_BUFFER_BufferSize_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 128;
   case 9: return 128;
   case 8: return 128;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_INDEX_BUFFER::Buffer Starting Address */


#define GEN10_3DSTATE_INDEX_BUFFER_BufferStartingAddress_bits  64
#define GEN9_3DSTATE_INDEX_BUFFER_BufferStartingAddress_bits  64
#define GEN8_3DSTATE_INDEX_BUFFER_BufferStartingAddress_bits  64
#define GEN75_3DSTATE_INDEX_BUFFER_BufferStartingAddress_bits  32
#define GEN7_3DSTATE_INDEX_BUFFER_BufferStartingAddress_bits  32
#define GEN6_3DSTATE_INDEX_BUFFER_BufferStartingAddress_bits  32
#define GEN5_3DSTATE_INDEX_BUFFER_BufferStartingAddress_bits  32
#define GEN45_3DSTATE_INDEX_BUFFER_BufferStartingAddress_bits  32
#define GEN4_3DSTATE_INDEX_BUFFER_BufferStartingAddress_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_INDEX_BUFFER_BufferStartingAddress_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 64;
   case 9: return 64;
   case 8: return 64;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 32;
      }
   case 6: return 32;
   case 5: return 32;
   case 4:
      if (devinfo->is_g4x) {
         return 32;
      } else {
         return 32;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_INDEX_BUFFER_BufferStartingAddress_start  64
#define GEN9_3DSTATE_INDEX_BUFFER_BufferStartingAddress_start  64
#define GEN8_3DSTATE_INDEX_BUFFER_BufferStartingAddress_start  64
#define GEN75_3DSTATE_INDEX_BUFFER_BufferStartingAddress_start  32
#define GEN7_3DSTATE_INDEX_BUFFER_BufferStartingAddress_start  32
#define GEN6_3DSTATE_INDEX_BUFFER_BufferStartingAddress_start  32
#define GEN5_3DSTATE_INDEX_BUFFER_BufferStartingAddress_start  32
#define GEN45_3DSTATE_INDEX_BUFFER_BufferStartingAddress_start  32
#define GEN4_3DSTATE_INDEX_BUFFER_BufferStartingAddress_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_INDEX_BUFFER_BufferStartingAddress_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 64;
   case 9: return 64;
   case 8: return 64;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 32;
      }
   case 6: return 32;
   case 5: return 32;
   case 4:
      if (devinfo->is_g4x) {
         return 32;
      } else {
         return 32;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_INDEX_BUFFER::Command SubType */


#define GEN10_3DSTATE_INDEX_BUFFER_CommandSubType_bits  2
#define GEN9_3DSTATE_INDEX_BUFFER_CommandSubType_bits  2
#define GEN8_3DSTATE_INDEX_BUFFER_CommandSubType_bits  2
#define GEN75_3DSTATE_INDEX_BUFFER_CommandSubType_bits  2
#define GEN7_3DSTATE_INDEX_BUFFER_CommandSubType_bits  2
#define GEN6_3DSTATE_INDEX_BUFFER_CommandSubType_bits  2
#define GEN5_3DSTATE_INDEX_BUFFER_CommandSubType_bits  2
#define GEN45_3DSTATE_INDEX_BUFFER_CommandSubType_bits  2
#define GEN4_3DSTATE_INDEX_BUFFER_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_INDEX_BUFFER_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 2;
   case 5: return 2;
   case 4:
      if (devinfo->is_g4x) {
         return 2;
      } else {
         return 2;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_INDEX_BUFFER_CommandSubType_start  27
#define GEN9_3DSTATE_INDEX_BUFFER_CommandSubType_start  27
#define GEN8_3DSTATE_INDEX_BUFFER_CommandSubType_start  27
#define GEN75_3DSTATE_INDEX_BUFFER_CommandSubType_start  27
#define GEN7_3DSTATE_INDEX_BUFFER_CommandSubType_start  27
#define GEN6_3DSTATE_INDEX_BUFFER_CommandSubType_start  27
#define GEN5_3DSTATE_INDEX_BUFFER_CommandSubType_start  27
#define GEN45_3DSTATE_INDEX_BUFFER_CommandSubType_start  27
#define GEN4_3DSTATE_INDEX_BUFFER_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_INDEX_BUFFER_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 27;
      }
   case 6: return 27;
   case 5: return 27;
   case 4:
      if (devinfo->is_g4x) {
         return 27;
      } else {
         return 27;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_INDEX_BUFFER::Command Type */


#define GEN10_3DSTATE_INDEX_BUFFER_CommandType_bits  3
#define GEN9_3DSTATE_INDEX_BUFFER_CommandType_bits  3
#define GEN8_3DSTATE_INDEX_BUFFER_CommandType_bits  3
#define GEN75_3DSTATE_INDEX_BUFFER_CommandType_bits  3
#define GEN7_3DSTATE_INDEX_BUFFER_CommandType_bits  3
#define GEN6_3DSTATE_INDEX_BUFFER_CommandType_bits  3
#define GEN5_3DSTATE_INDEX_BUFFER_CommandType_bits  3
#define GEN45_3DSTATE_INDEX_BUFFER_CommandType_bits  3
#define GEN4_3DSTATE_INDEX_BUFFER_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_INDEX_BUFFER_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 3;
   case 4:
      if (devinfo->is_g4x) {
         return 3;
      } else {
         return 3;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_INDEX_BUFFER_CommandType_start  29
#define GEN9_3DSTATE_INDEX_BUFFER_CommandType_start  29
#define GEN8_3DSTATE_INDEX_BUFFER_CommandType_start  29
#define GEN75_3DSTATE_INDEX_BUFFER_CommandType_start  29
#define GEN7_3DSTATE_INDEX_BUFFER_CommandType_start  29
#define GEN6_3DSTATE_INDEX_BUFFER_CommandType_start  29
#define GEN5_3DSTATE_INDEX_BUFFER_CommandType_start  29
#define GEN45_3DSTATE_INDEX_BUFFER_CommandType_start  29
#define GEN4_3DSTATE_INDEX_BUFFER_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_INDEX_BUFFER_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 29;
      }
   case 6: return 29;
   case 5: return 29;
   case 4:
      if (devinfo->is_g4x) {
         return 29;
      } else {
         return 29;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_INDEX_BUFFER::Cut Index Enable */


#define GEN7_3DSTATE_INDEX_BUFFER_CutIndexEnable_bits  1
#define GEN6_3DSTATE_INDEX_BUFFER_CutIndexEnable_bits  1
#define GEN5_3DSTATE_INDEX_BUFFER_CutIndexEnable_bits  1
#define GEN45_3DSTATE_INDEX_BUFFER_CutIndexEnable_bits  1
#define GEN4_3DSTATE_INDEX_BUFFER_CutIndexEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_INDEX_BUFFER_CutIndexEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 1;
      }
   case 6: return 1;
   case 5: return 1;
   case 4:
      if (devinfo->is_g4x) {
         return 1;
      } else {
         return 1;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN7_3DSTATE_INDEX_BUFFER_CutIndexEnable_start  10
#define GEN6_3DSTATE_INDEX_BUFFER_CutIndexEnable_start  10
#define GEN5_3DSTATE_INDEX_BUFFER_CutIndexEnable_start  10
#define GEN45_3DSTATE_INDEX_BUFFER_CutIndexEnable_start  10
#define GEN4_3DSTATE_INDEX_BUFFER_CutIndexEnable_start  10

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_INDEX_BUFFER_CutIndexEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 10;
      }
   case 6: return 10;
   case 5: return 10;
   case 4:
      if (devinfo->is_g4x) {
         return 10;
      } else {
         return 10;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_INDEX_BUFFER::DWord Length */


#define GEN10_3DSTATE_INDEX_BUFFER_DWordLength_bits  8
#define GEN9_3DSTATE_INDEX_BUFFER_DWordLength_bits  8
#define GEN8_3DSTATE_INDEX_BUFFER_DWordLength_bits  8
#define GEN75_3DSTATE_INDEX_BUFFER_DWordLength_bits  8
#define GEN7_3DSTATE_INDEX_BUFFER_DWordLength_bits  8
#define GEN6_3DSTATE_INDEX_BUFFER_DWordLength_bits  8
#define GEN5_3DSTATE_INDEX_BUFFER_DWordLength_bits  8
#define GEN45_3DSTATE_INDEX_BUFFER_DWordLength_bits  8
#define GEN4_3DSTATE_INDEX_BUFFER_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_INDEX_BUFFER_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 8;
   case 4:
      if (devinfo->is_g4x) {
         return 8;
      } else {
         return 8;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_INDEX_BUFFER_DWordLength_start  0
#define GEN9_3DSTATE_INDEX_BUFFER_DWordLength_start  0
#define GEN8_3DSTATE_INDEX_BUFFER_DWordLength_start  0
#define GEN75_3DSTATE_INDEX_BUFFER_DWordLength_start  0
#define GEN7_3DSTATE_INDEX_BUFFER_DWordLength_start  0
#define GEN6_3DSTATE_INDEX_BUFFER_DWordLength_start  0
#define GEN5_3DSTATE_INDEX_BUFFER_DWordLength_start  0
#define GEN45_3DSTATE_INDEX_BUFFER_DWordLength_start  0
#define GEN4_3DSTATE_INDEX_BUFFER_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_INDEX_BUFFER_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_INDEX_BUFFER::Index Format */


#define GEN10_3DSTATE_INDEX_BUFFER_IndexFormat_bits  2
#define GEN9_3DSTATE_INDEX_BUFFER_IndexFormat_bits  2
#define GEN8_3DSTATE_INDEX_BUFFER_IndexFormat_bits  2
#define GEN75_3DSTATE_INDEX_BUFFER_IndexFormat_bits  2
#define GEN7_3DSTATE_INDEX_BUFFER_IndexFormat_bits  2
#define GEN6_3DSTATE_INDEX_BUFFER_IndexFormat_bits  2
#define GEN5_3DSTATE_INDEX_BUFFER_IndexFormat_bits  2
#define GEN45_3DSTATE_INDEX_BUFFER_IndexFormat_bits  2
#define GEN4_3DSTATE_INDEX_BUFFER_IndexFormat_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_INDEX_BUFFER_IndexFormat_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 2;
   case 5: return 2;
   case 4:
      if (devinfo->is_g4x) {
         return 2;
      } else {
         return 2;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_INDEX_BUFFER_IndexFormat_start  40
#define GEN9_3DSTATE_INDEX_BUFFER_IndexFormat_start  40
#define GEN8_3DSTATE_INDEX_BUFFER_IndexFormat_start  40
#define GEN75_3DSTATE_INDEX_BUFFER_IndexFormat_start  8
#define GEN7_3DSTATE_INDEX_BUFFER_IndexFormat_start  8
#define GEN6_3DSTATE_INDEX_BUFFER_IndexFormat_start  8
#define GEN5_3DSTATE_INDEX_BUFFER_IndexFormat_start  8
#define GEN45_3DSTATE_INDEX_BUFFER_IndexFormat_start  8
#define GEN4_3DSTATE_INDEX_BUFFER_IndexFormat_start  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_INDEX_BUFFER_IndexFormat_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 40;
   case 9: return 40;
   case 8: return 40;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 8;
   case 4:
      if (devinfo->is_g4x) {
         return 8;
      } else {
         return 8;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_INDEX_BUFFER::IndexBufferMOCS */


#define GEN10_3DSTATE_INDEX_BUFFER_IndexBufferMOCS_bits  7
#define GEN9_3DSTATE_INDEX_BUFFER_IndexBufferMOCS_bits  7
#define GEN8_3DSTATE_INDEX_BUFFER_IndexBufferMOCS_bits  7
#define GEN75_3DSTATE_INDEX_BUFFER_IndexBufferMOCS_bits  4
#define GEN7_3DSTATE_INDEX_BUFFER_IndexBufferMOCS_bits  4
#define GEN6_3DSTATE_INDEX_BUFFER_IndexBufferMOCS_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_INDEX_BUFFER_IndexBufferMOCS_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 7;
   case 9: return 7;
   case 8: return 7;
   case 7:
      if (devinfo->is_haswell) {
         return 4;
      } else {
         return 4;
      }
   case 6: return 4;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_INDEX_BUFFER_IndexBufferMOCS_start  32
#define GEN9_3DSTATE_INDEX_BUFFER_IndexBufferMOCS_start  32
#define GEN8_3DSTATE_INDEX_BUFFER_IndexBufferMOCS_start  32
#define GEN75_3DSTATE_INDEX_BUFFER_IndexBufferMOCS_start  12
#define GEN7_3DSTATE_INDEX_BUFFER_IndexBufferMOCS_start  12
#define GEN6_3DSTATE_INDEX_BUFFER_IndexBufferMOCS_start  12

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_INDEX_BUFFER_IndexBufferMOCS_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 12;
      } else {
         return 12;
      }
   case 6: return 12;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_INDEX_BUFFER::Memory Object Control State */


#define GEN10_3DSTATE_INDEX_BUFFER_MemoryObjectControlState_bits  7
#define GEN9_3DSTATE_INDEX_BUFFER_MemoryObjectControlState_bits  7
#define GEN8_3DSTATE_INDEX_BUFFER_MemoryObjectControlState_bits  7
#define GEN75_3DSTATE_INDEX_BUFFER_MemoryObjectControlState_bits  4
#define GEN7_3DSTATE_INDEX_BUFFER_MemoryObjectControlState_bits  4
#define GEN6_3DSTATE_INDEX_BUFFER_MemoryObjectControlState_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_INDEX_BUFFER_MemoryObjectControlState_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 7;
   case 9: return 7;
   case 8: return 7;
   case 7:
      if (devinfo->is_haswell) {
         return 4;
      } else {
         return 4;
      }
   case 6: return 4;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_INDEX_BUFFER_MemoryObjectControlState_start  32
#define GEN9_3DSTATE_INDEX_BUFFER_MemoryObjectControlState_start  32
#define GEN8_3DSTATE_INDEX_BUFFER_MemoryObjectControlState_start  32
#define GEN75_3DSTATE_INDEX_BUFFER_MemoryObjectControlState_start  12
#define GEN7_3DSTATE_INDEX_BUFFER_MemoryObjectControlState_start  12
#define GEN6_3DSTATE_INDEX_BUFFER_MemoryObjectControlState_start  12

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_INDEX_BUFFER_MemoryObjectControlState_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 12;
      } else {
         return 12;
      }
   case 6: return 12;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_LINE_STIPPLE */


#define GEN10_3DSTATE_LINE_STIPPLE_length  3
#define GEN9_3DSTATE_LINE_STIPPLE_length  3
#define GEN8_3DSTATE_LINE_STIPPLE_length  3
#define GEN75_3DSTATE_LINE_STIPPLE_length  3
#define GEN7_3DSTATE_LINE_STIPPLE_length  3
#define GEN6_3DSTATE_LINE_STIPPLE_length  3
#define GEN5_3DSTATE_LINE_STIPPLE_length  3
#define GEN45_3DSTATE_LINE_STIPPLE_length  3
#define GEN4_3DSTATE_LINE_STIPPLE_length  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_LINE_STIPPLE_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 3;
   case 4:
      if (devinfo->is_g4x) {
         return 3;
      } else {
         return 3;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_LINE_STIPPLE::3D Command Opcode */


#define GEN10_3DSTATE_LINE_STIPPLE_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_LINE_STIPPLE_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_LINE_STIPPLE_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_LINE_STIPPLE_3DCommandOpcode_bits  3
#define GEN7_3DSTATE_LINE_STIPPLE_3DCommandOpcode_bits  3
#define GEN6_3DSTATE_LINE_STIPPLE_3DCommandOpcode_bits  3
#define GEN5_3DSTATE_LINE_STIPPLE_3DCommandOpcode_bits  3
#define GEN45_3DSTATE_LINE_STIPPLE_3DCommandOpcode_bits  3
#define GEN4_3DSTATE_LINE_STIPPLE_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_LINE_STIPPLE_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 3;
   case 4:
      if (devinfo->is_g4x) {
         return 3;
      } else {
         return 3;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_LINE_STIPPLE_3DCommandOpcode_start  24
#define GEN9_3DSTATE_LINE_STIPPLE_3DCommandOpcode_start  24
#define GEN8_3DSTATE_LINE_STIPPLE_3DCommandOpcode_start  24
#define GEN75_3DSTATE_LINE_STIPPLE_3DCommandOpcode_start  24
#define GEN7_3DSTATE_LINE_STIPPLE_3DCommandOpcode_start  24
#define GEN6_3DSTATE_LINE_STIPPLE_3DCommandOpcode_start  24
#define GEN5_3DSTATE_LINE_STIPPLE_3DCommandOpcode_start  24
#define GEN45_3DSTATE_LINE_STIPPLE_3DCommandOpcode_start  24
#define GEN4_3DSTATE_LINE_STIPPLE_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_LINE_STIPPLE_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 24;
      }
   case 6: return 24;
   case 5: return 24;
   case 4:
      if (devinfo->is_g4x) {
         return 24;
      } else {
         return 24;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_LINE_STIPPLE::3D Command Sub Opcode */


#define GEN10_3DSTATE_LINE_STIPPLE_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_LINE_STIPPLE_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_LINE_STIPPLE_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_LINE_STIPPLE_3DCommandSubOpcode_bits  8
#define GEN7_3DSTATE_LINE_STIPPLE_3DCommandSubOpcode_bits  8
#define GEN6_3DSTATE_LINE_STIPPLE_3DCommandSubOpcode_bits  8
#define GEN5_3DSTATE_LINE_STIPPLE_3DCommandSubOpcode_bits  8
#define GEN45_3DSTATE_LINE_STIPPLE_3DCommandSubOpcode_bits  8
#define GEN4_3DSTATE_LINE_STIPPLE_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_LINE_STIPPLE_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 8;
   case 4:
      if (devinfo->is_g4x) {
         return 8;
      } else {
         return 8;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_LINE_STIPPLE_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_LINE_STIPPLE_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_LINE_STIPPLE_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_LINE_STIPPLE_3DCommandSubOpcode_start  16
#define GEN7_3DSTATE_LINE_STIPPLE_3DCommandSubOpcode_start  16
#define GEN6_3DSTATE_LINE_STIPPLE_3DCommandSubOpcode_start  16
#define GEN5_3DSTATE_LINE_STIPPLE_3DCommandSubOpcode_start  16
#define GEN45_3DSTATE_LINE_STIPPLE_3DCommandSubOpcode_start  16
#define GEN4_3DSTATE_LINE_STIPPLE_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_LINE_STIPPLE_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 16;
   case 5: return 16;
   case 4:
      if (devinfo->is_g4x) {
         return 16;
      } else {
         return 16;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_LINE_STIPPLE::Command SubType */


#define GEN10_3DSTATE_LINE_STIPPLE_CommandSubType_bits  2
#define GEN9_3DSTATE_LINE_STIPPLE_CommandSubType_bits  2
#define GEN8_3DSTATE_LINE_STIPPLE_CommandSubType_bits  2
#define GEN75_3DSTATE_LINE_STIPPLE_CommandSubType_bits  2
#define GEN7_3DSTATE_LINE_STIPPLE_CommandSubType_bits  2
#define GEN6_3DSTATE_LINE_STIPPLE_CommandSubType_bits  2
#define GEN5_3DSTATE_LINE_STIPPLE_CommandSubType_bits  2
#define GEN45_3DSTATE_LINE_STIPPLE_CommandSubType_bits  2
#define GEN4_3DSTATE_LINE_STIPPLE_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_LINE_STIPPLE_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 2;
   case 5: return 2;
   case 4:
      if (devinfo->is_g4x) {
         return 2;
      } else {
         return 2;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_LINE_STIPPLE_CommandSubType_start  27
#define GEN9_3DSTATE_LINE_STIPPLE_CommandSubType_start  27
#define GEN8_3DSTATE_LINE_STIPPLE_CommandSubType_start  27
#define GEN75_3DSTATE_LINE_STIPPLE_CommandSubType_start  27
#define GEN7_3DSTATE_LINE_STIPPLE_CommandSubType_start  27
#define GEN6_3DSTATE_LINE_STIPPLE_CommandSubType_start  27
#define GEN5_3DSTATE_LINE_STIPPLE_CommandSubType_start  27
#define GEN45_3DSTATE_LINE_STIPPLE_CommandSubType_start  27
#define GEN4_3DSTATE_LINE_STIPPLE_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_LINE_STIPPLE_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 27;
      }
   case 6: return 27;
   case 5: return 27;
   case 4:
      if (devinfo->is_g4x) {
         return 27;
      } else {
         return 27;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_LINE_STIPPLE::Command Type */


#define GEN10_3DSTATE_LINE_STIPPLE_CommandType_bits  3
#define GEN9_3DSTATE_LINE_STIPPLE_CommandType_bits  3
#define GEN8_3DSTATE_LINE_STIPPLE_CommandType_bits  3
#define GEN75_3DSTATE_LINE_STIPPLE_CommandType_bits  3
#define GEN7_3DSTATE_LINE_STIPPLE_CommandType_bits  3
#define GEN6_3DSTATE_LINE_STIPPLE_CommandType_bits  3
#define GEN5_3DSTATE_LINE_STIPPLE_CommandType_bits  3
#define GEN45_3DSTATE_LINE_STIPPLE_CommandType_bits  3
#define GEN4_3DSTATE_LINE_STIPPLE_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_LINE_STIPPLE_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 3;
   case 4:
      if (devinfo->is_g4x) {
         return 3;
      } else {
         return 3;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_LINE_STIPPLE_CommandType_start  29
#define GEN9_3DSTATE_LINE_STIPPLE_CommandType_start  29
#define GEN8_3DSTATE_LINE_STIPPLE_CommandType_start  29
#define GEN75_3DSTATE_LINE_STIPPLE_CommandType_start  29
#define GEN7_3DSTATE_LINE_STIPPLE_CommandType_start  29
#define GEN6_3DSTATE_LINE_STIPPLE_CommandType_start  29
#define GEN5_3DSTATE_LINE_STIPPLE_CommandType_start  29
#define GEN45_3DSTATE_LINE_STIPPLE_CommandType_start  29
#define GEN4_3DSTATE_LINE_STIPPLE_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_LINE_STIPPLE_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 29;
   case 9: return 29;
   case 8: return 29;
   case 7:
      if (devinfo->is_haswell) {
         return 29;
      } else {
         return 29;
      }
   case 6: return 29;
   case 5: return 29;
   case 4:
      if (devinfo->is_g4x) {
         return 29;
      } else {
         return 29;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_LINE_STIPPLE::Current Repeat Counter */


#define GEN10_3DSTATE_LINE_STIPPLE_CurrentRepeatCounter_bits  9
#define GEN9_3DSTATE_LINE_STIPPLE_CurrentRepeatCounter_bits  9
#define GEN8_3DSTATE_LINE_STIPPLE_CurrentRepeatCounter_bits  9
#define GEN75_3DSTATE_LINE_STIPPLE_CurrentRepeatCounter_bits  9
#define GEN7_3DSTATE_LINE_STIPPLE_CurrentRepeatCounter_bits  9
#define GEN6_3DSTATE_LINE_STIPPLE_CurrentRepeatCounter_bits  9
#define GEN5_3DSTATE_LINE_STIPPLE_CurrentRepeatCounter_bits  9
#define GEN45_3DSTATE_LINE_STIPPLE_CurrentRepeatCounter_bits  9
#define GEN4_3DSTATE_LINE_STIPPLE_CurrentRepeatCounter_bits  9

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_LINE_STIPPLE_CurrentRepeatCounter_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 9;
   case 9: return 9;
   case 8: return 9;
   case 7:
      if (devinfo->is_haswell) {
         return 9;
      } else {
         return 9;
      }
   case 6: return 9;
   case 5: return 9;
   case 4:
      if (devinfo->is_g4x) {
         return 9;
      } else {
         return 9;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_LINE_STIPPLE_CurrentRepeatCounter_start  53
#define GEN9_3DSTATE_LINE_STIPPLE_CurrentRepeatCounter_start  53
#define GEN8_3DSTATE_LINE_STIPPLE_CurrentRepeatCounter_start  53
#define GEN75_3DSTATE_LINE_STIPPLE_CurrentRepeatCounter_start  53
#define GEN7_3DSTATE_LINE_STIPPLE_CurrentRepeatCounter_start  53
#define GEN6_3DSTATE_LINE_STIPPLE_CurrentRepeatCounter_start  53
#define GEN5_3DSTATE_LINE_STIPPLE_CurrentRepeatCounter_start  53
#define GEN45_3DSTATE_LINE_STIPPLE_CurrentRepeatCounter_start  53
#define GEN4_3DSTATE_LINE_STIPPLE_CurrentRepeatCounter_start  53

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_LINE_STIPPLE_CurrentRepeatCounter_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 53;
   case 9: return 53;
   case 8: return 53;
   case 7:
      if (devinfo->is_haswell) {
         return 53;
      } else {
         return 53;
      }
   case 6: return 53;
   case 5: return 53;
   case 4:
      if (devinfo->is_g4x) {
         return 53;
      } else {
         return 53;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_LINE_STIPPLE::Current Stipple Index */


#define GEN10_3DSTATE_LINE_STIPPLE_CurrentStippleIndex_bits  4
#define GEN9_3DSTATE_LINE_STIPPLE_CurrentStippleIndex_bits  4
#define GEN8_3DSTATE_LINE_STIPPLE_CurrentStippleIndex_bits  4
#define GEN75_3DSTATE_LINE_STIPPLE_CurrentStippleIndex_bits  4
#define GEN7_3DSTATE_LINE_STIPPLE_CurrentStippleIndex_bits  4
#define GEN6_3DSTATE_LINE_STIPPLE_CurrentStippleIndex_bits  4
#define GEN5_3DSTATE_LINE_STIPPLE_CurrentStippleIndex_bits  4
#define GEN45_3DSTATE_LINE_STIPPLE_CurrentStippleIndex_bits  4
#define GEN4_3DSTATE_LINE_STIPPLE_CurrentStippleIndex_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_LINE_STIPPLE_CurrentStippleIndex_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 4;
   case 9: return 4;
   case 8: return 4;
   case 7:
      if (devinfo->is_haswell) {
         return 4;
      } else {
         return 4;
      }
   case 6: return 4;
   case 5: return 4;
   case 4:
      if (devinfo->is_g4x) {
         return 4;
      } else {
         return 4;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_LINE_STIPPLE_CurrentStippleIndex_start  48
#define GEN9_3DSTATE_LINE_STIPPLE_CurrentStippleIndex_start  48
#define GEN8_3DSTATE_LINE_STIPPLE_CurrentStippleIndex_start  48
#define GEN75_3DSTATE_LINE_STIPPLE_CurrentStippleIndex_start  48
#define GEN7_3DSTATE_LINE_STIPPLE_CurrentStippleIndex_start  48
#define GEN6_3DSTATE_LINE_STIPPLE_CurrentStippleIndex_start  48
#define GEN5_3DSTATE_LINE_STIPPLE_CurrentStippleIndex_start  48
#define GEN45_3DSTATE_LINE_STIPPLE_CurrentStippleIndex_start  48
#define GEN4_3DSTATE_LINE_STIPPLE_CurrentStippleIndex_start  48

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_LINE_STIPPLE_CurrentStippleIndex_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 48;
   case 9: return 48;
   case 8: return 48;
   case 7:
      if (devinfo->is_haswell) {
         return 48;
      } else {
         return 48;
      }
   case 6: return 48;
   case 5: return 48;
   case 4:
      if (devinfo->is_g4x) {
         return 48;
      } else {
         return 48;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_LINE_STIPPLE::DWord Length */


#define GEN10_3DSTATE_LINE_STIPPLE_DWordLength_bits  8
#define GEN9_3DSTATE_LINE_STIPPLE_DWordLength_bits  8
#define GEN8_3DSTATE_LINE_STIPPLE_DWordLength_bits  8
#define GEN75_3DSTATE_LINE_STIPPLE_DWordLength_bits  8
#define GEN7_3DSTATE_LINE_STIPPLE_DWordLength_bits  8
#define GEN6_3DSTATE_LINE_STIPPLE_DWordLength_bits  8
#define GEN5_3DSTATE_LINE_STIPPLE_DWordLength_bits  8
#define GEN45_3DSTATE_LINE_STIPPLE_DWordLength_bits  8
#define GEN4_3DSTATE_LINE_STIPPLE_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_LINE_STIPPLE_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 8;
   case 4:
      if (devinfo->is_g4x) {
         return 8;
      } else {
         return 8;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_LINE_STIPPLE_DWordLength_start  0
#define GEN9_3DSTATE_LINE_STIPPLE_DWordLength_start  0
#define GEN8_3DSTATE_LINE_STIPPLE_DWordLength_start  0
#define GEN75_3DSTATE_LINE_STIPPLE_DWordLength_start  0
#define GEN7_3DSTATE_LINE_STIPPLE_DWordLength_start  0
#define GEN6_3DSTATE_LINE_STIPPLE_DWordLength_start  0
#define GEN5_3DSTATE_LINE_STIPPLE_DWordLength_start  0
#define GEN45_3DSTATE_LINE_STIPPLE_DWordLength_start  0
#define GEN4_3DSTATE_LINE_STIPPLE_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_LINE_STIPPLE_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_LINE_STIPPLE::Line Stipple Inverse Repeat Count */


#define GEN10_3DSTATE_LINE_STIPPLE_LineStippleInverseRepeatCount_bits  17
#define GEN9_3DSTATE_LINE_STIPPLE_LineStippleInverseRepeatCount_bits  17
#define GEN8_3DSTATE_LINE_STIPPLE_LineStippleInverseRepeatCount_bits  17
#define GEN75_3DSTATE_LINE_STIPPLE_LineStippleInverseRepeatCount_bits  17
#define GEN7_3DSTATE_LINE_STIPPLE_LineStippleInverseRepeatCount_bits  17
#define GEN6_3DSTATE_LINE_STIPPLE_LineStippleInverseRepeatCount_bits  16
#define GEN5_3DSTATE_LINE_STIPPLE_LineStippleInverseRepeatCount_bits  16
#define GEN45_3DSTATE_LINE_STIPPLE_LineStippleInverseRepeatCount_bits  16
#define GEN4_3DSTATE_LINE_STIPPLE_LineStippleInverseRepeatCount_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_LINE_STIPPLE_LineStippleInverseRepeatCount_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 17;
   case 9: return 17;
   case 8: return 17;
   case 7:
      if (devinfo->is_haswell) {
         return 17;
      } else {
         return 17;
      }
   case 6: return 16;
   case 5: return 16;
   case 4:
      if (devinfo->is_g4x) {
         return 16;
      } else {
         return 16;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_LINE_STIPPLE_LineStippleInverseRepeatCount_start  79
#define GEN9_3DSTATE_LINE_STIPPLE_LineStippleInverseRepeatCount_start  79
#define GEN8_3DSTATE_LINE_STIPPLE_LineStippleInverseRepeatCount_start  79
#define GEN75_3DSTATE_LINE_STIPPLE_LineStippleInverseRepeatCount_start  79
#define GEN7_3DSTATE_LINE_STIPPLE_LineStippleInverseRepeatCount_start  79
#define GEN6_3DSTATE_LINE_STIPPLE_LineStippleInverseRepeatCount_start  80
#define GEN5_3DSTATE_LINE_STIPPLE_LineStippleInverseRepeatCount_start  80
#define GEN45_3DSTATE_LINE_STIPPLE_LineStippleInverseRepeatCount_start  80
#define GEN4_3DSTATE_LINE_STIPPLE_LineStippleInverseRepeatCount_start  80

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_LINE_STIPPLE_LineStippleInverseRepeatCount_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 79;
   case 9: return 79;
   case 8: return 79;
   case 7:
      if (devinfo->is_haswell) {
         return 79;
      } else {
         return 79;
      }
   case 6: return 80;
   case 5: return 80;
   case 4:
      if (devinfo->is_g4x) {
         return 80;
      } else {
         return 80;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_LINE_STIPPLE::Line Stipple Pattern */


#define GEN10_3DSTATE_LINE_STIPPLE_LineStipplePattern_bits  16
#define GEN9_3DSTATE_LINE_STIPPLE_LineStipplePattern_bits  16
#define GEN8_3DSTATE_LINE_STIPPLE_LineStipplePattern_bits  16
#define GEN75_3DSTATE_LINE_STIPPLE_LineStipplePattern_bits  16
#define GEN7_3DSTATE_LINE_STIPPLE_LineStipplePattern_bits  16
#define GEN6_3DSTATE_LINE_STIPPLE_LineStipplePattern_bits  16
#define GEN5_3DSTATE_LINE_STIPPLE_LineStipplePattern_bits  16
#define GEN45_3DSTATE_LINE_STIPPLE_LineStipplePattern_bits  16
#define GEN4_3DSTATE_LINE_STIPPLE_LineStipplePattern_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_LINE_STIPPLE_LineStipplePattern_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 16;
   case 5: return 16;
   case 4:
      if (devinfo->is_g4x) {
         return 16;
      } else {
         return 16;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_LINE_STIPPLE_LineStipplePattern_start  32
#define GEN9_3DSTATE_LINE_STIPPLE_LineStipplePattern_start  32
#define GEN8_3DSTATE_LINE_STIPPLE_LineStipplePattern_start  32
#define GEN75_3DSTATE_LINE_STIPPLE_LineStipplePattern_start  32
#define GEN7_3DSTATE_LINE_STIPPLE_LineStipplePattern_start  32
#define GEN6_3DSTATE_LINE_STIPPLE_LineStipplePattern_start  32
#define GEN5_3DSTATE_LINE_STIPPLE_LineStipplePattern_start  32
#define GEN45_3DSTATE_LINE_STIPPLE_LineStipplePattern_start  32
#define GEN4_3DSTATE_LINE_STIPPLE_LineStipplePattern_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_LINE_STIPPLE_LineStipplePattern_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 32;
   case 9: return 32;
   case 8: return 32;
   case 7:
      if (devinfo->is_haswell) {
         return 32;
      } else {
         return 32;
      }
   case 6: return 32;
   case 5: return 32;
   case 4:
      if (devinfo->is_g4x) {
         return 32;
      } else {
         return 32;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_LINE_STIPPLE::Line Stipple Repeat Count */


#define GEN10_3DSTATE_LINE_STIPPLE_LineStippleRepeatCount_bits  9
#define GEN9_3DSTATE_LINE_STIPPLE_LineStippleRepeatCount_bits  9
#define GEN8_3DSTATE_LINE_STIPPLE_LineStippleRepeatCount_bits  9
#define GEN75_3DSTATE_LINE_STIPPLE_LineStippleRepeatCount_bits  9
#define GEN7_3DSTATE_LINE_STIPPLE_LineStippleRepeatCount_bits  9
#define GEN6_3DSTATE_LINE_STIPPLE_LineStippleRepeatCount_bits  9
#define GEN5_3DSTATE_LINE_STIPPLE_LineStippleRepeatCount_bits  9
#define GEN45_3DSTATE_LINE_STIPPLE_LineStippleRepeatCount_bits  9
#define GEN4_3DSTATE_LINE_STIPPLE_LineStippleRepeatCount_bits  9

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_LINE_STIPPLE_LineStippleRepeatCount_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 9;
   case 9: return 9;
   case 8: return 9;
   case 7:
      if (devinfo->is_haswell) {
         return 9;
      } else {
         return 9;
      }
   case 6: return 9;
   case 5: return 9;
   case 4:
      if (devinfo->is_g4x) {
         return 9;
      } else {
         return 9;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_LINE_STIPPLE_LineStippleRepeatCount_start  64
#define GEN9_3DSTATE_LINE_STIPPLE_LineStippleRepeatCount_start  64
#define GEN8_3DSTATE_LINE_STIPPLE_LineStippleRepeatCount_start  64
#define GEN75_3DSTATE_LINE_STIPPLE_LineStippleRepeatCount_start  64
#define GEN7_3DSTATE_LINE_STIPPLE_LineStippleRepeatCount_start  64
#define GEN6_3DSTATE_LINE_STIPPLE_LineStippleRepeatCount_start  64
#define GEN5_3DSTATE_LINE_STIPPLE_LineStippleRepeatCount_start  64
#define GEN45_3DSTATE_LINE_STIPPLE_LineStippleRepeatCount_start  64
#define GEN4_3DSTATE_LINE_STIPPLE_LineStippleRepeatCount_start  64

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_LINE_STIPPLE_LineStippleRepeatCount_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 64;
   case 9: return 64;
   case 8: return 64;
   case 7:
      if (devinfo->is_haswell) {
         return 64;
      } else {
         return 64;
      }
   case 6: return 64;
   case 5: return 64;
   case 4:
      if (devinfo->is_g4x) {
         return 64;
      } else {
         return 64;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_LINE_STIPPLE::Modify Enable */


#define GEN5_3DSTATE_LINE_STIPPLE_ModifyEnable_bits  1
#define GEN4_3DSTATE_LINE_STIPPLE_ModifyEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_LINE_STIPPLE_ModifyEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 1;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 1;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN5_3DSTATE_LINE_STIPPLE_ModifyEnable_start  63
#define GEN4_3DSTATE_LINE_STIPPLE_ModifyEnable_start  63

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_LINE_STIPPLE_ModifyEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 0;
   case 9: return 0;
   case 8: return 0;
   case 7:
      if (devinfo->is_haswell) {
         return 0;
      } else {
         return 0;
      }
   case 6: return 0;
   case 5: return 63;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 63;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_LINE_STIPPLE::Modify Enable (Current Repeat Counter, Current Stipple Index) */


#define GEN10_3DSTATE_LINE_STIPPLE_ModifyEnableCurrentRepeatCounterCurrentStippleIndex_bits  1
#define GEN9_3DSTATE_LINE_STIPPLE_ModifyEnableCurrentRepeatCounterCurrentStippleIndex_bits  1
#define GEN8_3DSTATE_LINE_STIPPLE_ModifyEnableCurrentRepeatCounterCurrentStippleIndex_bits  1
#define GEN75_3DSTATE_LINE_STIPPLE_ModifyEnableCurrentRepeatCounterCurrentStippleIndex_bits  1
#define GEN7_3DSTATE_LINE_STIPPLE_ModifyEnableCurrentRepeatCounterCurrentStippleIndex_bits  1
#define GEN6_3DSTATE_LINE_STIPPLE_ModifyEnableCurrentRepeatCounterCurrentStippleIndex_bits  1
#define GEN45_3DSTATE_LINE_STIPPLE_ModifyEnableCurrentRepeatCounterCurrentStippleIndex_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_LINE_STIPPLE_ModifyEnableCurrentRepeatCounterCurrentStippleIndex_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 1;
   case 9: return 1;
   case 8: return 1;
   case 7:
      if (devinfo->is_haswell) {
         return 1;
      } else {
         return 1;
      }
   case 6: return 1;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 1;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_LINE_STIPPLE_ModifyEnableCurrentRepeatCounterCurrentStippleIndex_start  63
#define GEN9_3DSTATE_LINE_STIPPLE_ModifyEnableCurrentRepeatCounterCurrentStippleIndex_start  63
#define GEN8_3DSTATE_LINE_STIPPLE_ModifyEnableCurrentRepeatCounterCurrentStippleIndex_start  63
#define GEN75_3DSTATE_LINE_STIPPLE_ModifyEnableCurrentRepeatCounterCurrentStippleIndex_start  63
#define GEN7_3DSTATE_LINE_STIPPLE_ModifyEnableCurrentRepeatCounterCurrentStippleIndex_start  63
#define GEN6_3DSTATE_LINE_STIPPLE_ModifyEnableCurrentRepeatCounterCurrentStippleIndex_start  63
#define GEN45_3DSTATE_LINE_STIPPLE_ModifyEnableCurrentRepeatCounterCurrentStippleIndex_start  63

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_LINE_STIPPLE_ModifyEnableCurrentRepeatCounterCurrentStippleIndex_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 63;
   case 9: return 63;
   case 8: return 63;
   case 7:
      if (devinfo->is_haswell) {
         return 63;
      } else {
         return 63;
      }
   case 6: return 63;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 63;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_MONOFILTER_SIZE */


#define GEN10_3DSTATE_MONOFILTER_SIZE_length  2
#define GEN9_3DSTATE_MONOFILTER_SIZE_length  2
#define GEN8_3DSTATE_MONOFILTER_SIZE_length  2
#define GEN75_3DSTATE_MONOFILTER_SIZE_length  2
#define GEN7_3DSTATE_MONOFILTER_SIZE_length  2
#define GEN6_3DSTATE_MONOFILTER_SIZE_length  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_MONOFILTER_SIZE_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 2;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_MONOFILTER_SIZE::3D Command Opcode */


#define GEN10_3DSTATE_MONOFILTER_SIZE_3DCommandOpcode_bits  3
#define GEN9_3DSTATE_MONOFILTER_SIZE_3DCommandOpcode_bits  3
#define GEN8_3DSTATE_MONOFILTER_SIZE_3DCommandOpcode_bits  3
#define GEN75_3DSTATE_MONOFILTER_SIZE_3DCommandOpcode_bits  3
#define GEN7_3DSTATE_MONOFILTER_SIZE_3DCommandOpcode_bits  3
#define GEN6_3DSTATE_MONOFILTER_SIZE_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_MONOFILTER_SIZE_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
   case 7:
      if (devinfo->is_haswell) {
         return 3;
      } else {
         return 3;
      }
   case 6: return 3;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_MONOFILTER_SIZE_3DCommandOpcode_start  24
#define GEN9_3DSTATE_MONOFILTER_SIZE_3DCommandOpcode_start  24
#define GEN8_3DSTATE_MONOFILTER_SIZE_3DCommandOpcode_start  24
#define GEN75_3DSTATE_MONOFILTER_SIZE_3DCommandOpcode_start  24
#define GEN7_3DSTATE_MONOFILTER_SIZE_3DCommandOpcode_start  24
#define GEN6_3DSTATE_MONOFILTER_SIZE_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_MONOFILTER_SIZE_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 24;
   case 9: return 24;
   case 8: return 24;
   case 7:
      if (devinfo->is_haswell) {
         return 24;
      } else {
         return 24;
      }
   case 6: return 24;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_MONOFILTER_SIZE::3D Command Sub Opcode */


#define GEN10_3DSTATE_MONOFILTER_SIZE_3DCommandSubOpcode_bits  8
#define GEN9_3DSTATE_MONOFILTER_SIZE_3DCommandSubOpcode_bits  8
#define GEN8_3DSTATE_MONOFILTER_SIZE_3DCommandSubOpcode_bits  8
#define GEN75_3DSTATE_MONOFILTER_SIZE_3DCommandSubOpcode_bits  8
#define GEN7_3DSTATE_MONOFILTER_SIZE_3DCommandSubOpcode_bits  8
#define GEN6_3DSTATE_MONOFILTER_SIZE_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_MONOFILTER_SIZE_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 8;
   case 9: return 8;
   case 8: return 8;
   case 7:
      if (devinfo->is_haswell) {
         return 8;
      } else {
         return 8;
      }
   case 6: return 8;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_MONOFILTER_SIZE_3DCommandSubOpcode_start  16
#define GEN9_3DSTATE_MONOFILTER_SIZE_3DCommandSubOpcode_start  16
#define GEN8_3DSTATE_MONOFILTER_SIZE_3DCommandSubOpcode_start  16
#define GEN75_3DSTATE_MONOFILTER_SIZE_3DCommandSubOpcode_start  16
#define GEN7_3DSTATE_MONOFILTER_SIZE_3DCommandSubOpcode_start  16
#define GEN6_3DSTATE_MONOFILTER_SIZE_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_MONOFILTER_SIZE_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 16;
   case 9: return 16;
   case 8: return 16;
   case 7:
      if (devinfo->is_haswell) {
         return 16;
      } else {
         return 16;
      }
   case 6: return 16;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_MONOFILTER_SIZE::Command SubType */


#define GEN10_3DSTATE_MONOFILTER_SIZE_CommandSubType_bits  2
#define GEN9_3DSTATE_MONOFILTER_SIZE_CommandSubType_bits  2
#define GEN8_3DSTATE_MONOFILTER_SIZE_CommandSubType_bits  2
#define GEN75_3DSTATE_MONOFILTER_SIZE_CommandSubType_bits  2
#define GEN7_3DSTATE_MONOFILTER_SIZE_CommandSubType_bits  2
#define GEN6_3DSTATE_MONOFILTER_SIZE_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_MONOFILTER_SIZE_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 2;
   case 9: return 2;
   case 8: return 2;
   case 7:
      if (devinfo->is_haswell) {
         return 2;
      } else {
         return 2;
      }
   case 6: return 2;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GEN10_3DSTATE_MONOFILTER_SIZE_CommandSubType_start  27
#define GEN9_3DSTATE_MONOFILTER_SIZE_CommandSubType_start  27
#define GEN8_3DSTATE_MONOFILTER_SIZE_CommandSubType_start  27
#define GEN75_3DSTATE_MONOFILTER_SIZE_CommandSubType_start  27
#define GEN7_3DSTATE_MONOFILTER_SIZE_CommandSubType_start  27
#define GEN6_3DSTATE_MONOFILTER_SIZE_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_MONOFILTER_SIZE_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 27;
   case 9: return 27;
   case 8: return 27;
   case 7:
      if (devinfo->is_haswell) {
         return 27;
      } else {
         return 27;
      }
   case 6: return 27;
   case 5: return 0;
   case 4:
      if (devinfo->is_g4x) {
         return 0;
      } else {
         return 0;
      }
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_MONOFILTER_SIZE::Command Type */


#define GEN10_3DSTATE_MONOFILTER_SIZE_CommandType_bits  3
#define GEN9_3DSTATE_MONOFILTER_SIZE_CommandType_bits  3
#define GEN8_3DSTATE_MONOFILTER_SIZE_CommandType_bits  3
#define GEN75_3DSTATE_MONOFILTER_SIZE_CommandType_bits  3
#define GEN7_3DSTATE_MONOFILTER_SIZE_CommandType_bits  3
#define GEN6_3DSTATE_MONOFILTER_SIZE_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_MONOFILTER_SIZE_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->gen) {
   case 10: return 3;
   case 9: return 3;
   case 8: return 3;
