/* Autogenerated file, DO NOT EDIT manually! generated by brw_oa.py
 *
 * Copyright (c) 2015 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#include <stdint.h>
#include <stdbool.h>

#include "util/hash_table.h"

#include "brw_oa_chv.h"
#include "brw_context.h"
#include "brw_performance_query.h"


#define MIN(a, b) ((a < b) ? (a) : (b))
#define MAX(a, b) ((a > b) ? (a) : (b))


/* Render Metrics Basic Gen8LP :: GPU Core Clocks */
static uint64_t
chv__render_basic__gpu_core_clocks__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Render Metrics Basic Gen8LP :: EU Active */
static float
chv__render_basic__eu_active__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic Gen8LP :: L3 Misses */
static uint64_t
chv__render_basic__l3_misses__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: C 4 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 4];

   return tmp0;
}

/* Render Metrics Basic Gen8LP :: GTI L3 Throughput */
static uint64_t
chv__render_basic__gti_l3_throughput__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: $L3Misses 64 UMUL */
   uint64_t tmp0 = chv__render_basic__l3_misses__read(brw, query, accumulator) * 64;

   return tmp0;
}

/* Render Metrics Basic Gen8LP :: EU Both FPU Pipes Active */
static float
chv__render_basic__eu_fpu_both_active__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic Gen8LP :: VS Send Pipe Active */
static float
chv__render_basic__vs_send_active__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic Gen8LP :: Sampler 1 Bottleneck */
static float
chv__render_basic__sampler1_bottleneck__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: B 3 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 3];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics Basic Gen8LP :: VS FPU1 Pipe Active */
static float
chv__render_basic__vs_fpu1_active__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 11];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic Gen8LP :: GS Threads Dispatched */
static uint64_t
chv__render_basic__gs_threads__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Render Metrics Basic Gen8LP :: L3 Sampler Throughput */
static uint64_t
chv__render_basic__l3_sampler_throughput__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Render Metrics Basic Gen8LP :: Early Hi-Depth Test Fails */
static uint64_t
chv__render_basic__hi_depth_test_fails__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic Gen8LP :: FS Both FPU Active */
static float
chv__render_basic__ps_eu_both_fpu_active__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 18];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic Gen8LP :: VS Threads Dispatched */
static uint64_t
chv__render_basic__vs_threads__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Render Metrics Basic Gen8LP :: FS Threads Dispatched */
static uint64_t
chv__render_basic__ps_threads__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Render Metrics Basic Gen8LP :: Sampler 0 Busy */
static float
chv__render_basic__sampler0_busy__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: B 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics Basic Gen8LP :: Sampler 1 Busy */
static float
chv__render_basic__sampler1_busy__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: B 1 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 1];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics Basic Gen8LP :: Samplers Busy */
static float
chv__render_basic__samplers_busy__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: B 0 READ  B 1 READ UADD $GpuCoreClocks FDIV 2 FDIV 100 FMUL */
   uint64_t tmp0 = accumulator[query->b_offset + 0];
   uint64_t tmp1 = accumulator[query->b_offset + 1];
   uint64_t tmp2 = tmp0 + tmp1;
   double tmp3 = tmp2;
   double tmp4 = chv__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
   double tmp6 = tmp5;
   double tmp7 = 2;
   double tmp8 = tmp7 ? tmp6 / tmp7 : 0;
   double tmp9 = tmp8 * 100;

   return tmp9;
}

/* Render Metrics Basic Gen8LP :: GTI Fixed Pipe Throughput */
static uint64_t
chv__render_basic__gti_vf_throughput__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: B 6 READ B 7 READ UADD 64 UMUL */
   uint64_t tmp0 = accumulator[query->b_offset + 6];
   uint64_t tmp1 = accumulator[query->b_offset + 7];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = tmp2 * 64;

   return tmp3;
}

/* Render Metrics Basic Gen8LP :: Shader Barrier Messages */
static uint64_t
chv__render_basic__shader_barriers__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Render Metrics Basic Gen8LP :: Sampler 0 Bottleneck */
static float
chv__render_basic__sampler0_bottleneck__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: B 2 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 2];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics Basic Gen8LP :: Sampler Texels */
static uint64_t
chv__render_basic__sampler_texels__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic Gen8LP :: Pixels Failing Tests */
static uint64_t
chv__render_basic__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                                      const struct brw_perf_query_info *query,
                                                      uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic Gen8LP :: GPU Time Elapsed */
static uint64_t
chv__render_basic__gpu_time__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics Basic Gen8LP :: AVG GPU Core Frequency */
static uint64_t
chv__render_basic__avg_gpu_core_frequency__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = chv__render_basic__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = chv__render_basic__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Render Metrics Basic Gen8LP :: AVG GPU Core Frequency */
static uint64_t
chv__render_basic__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Render Metrics Basic Gen8LP :: Sampler Texels Misses */
static uint64_t
chv__render_basic__sampler_texel_misses__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic Gen8LP :: CS Threads Dispatched */
static uint64_t
chv__render_basic__cs_threads__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Render Metrics Basic Gen8LP :: Shader Memory Accesses */
static uint64_t
chv__render_basic__shader_memory_accesses__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Render Metrics Basic Gen8LP :: SLM Bytes Read */
static uint64_t
chv__render_basic__slm_bytes_read__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Render Metrics Basic Gen8LP :: GTI Read Throughput */
static uint64_t
chv__render_basic__gti_read_throughput__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: C 6 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 6];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Render Metrics Basic Gen8LP :: PS FPU1 Pipe Active */
static float
chv__render_basic__ps_fpu1_active__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 16 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 16];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic Gen8LP :: PS Send Pipeline Active */
static float
chv__render_basic__ps_send_active__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 17];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic Gen8LP :: Rasterized Pixels */
static uint64_t
chv__render_basic__rasterized_pixels__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic Gen8LP :: GPU Busy */
static float
chv__render_basic__gpu_busy__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics Basic Gen8LP :: GTI Depth Throughput */
static uint64_t
chv__render_basic__gti_depth_throughput__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 0 READ C 1 READ UADD 64 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 0];
   uint64_t tmp1 = accumulator[query->c_offset + 1];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = tmp2 * 64;

   return tmp3;
}

/* Render Metrics Basic Gen8LP :: VS FPU0 Pipe Active */
static float
chv__render_basic__vs_fpu0_active__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 10];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic Gen8LP :: PS FPU0 Pipe Active */
static float
chv__render_basic__ps_fpu0_active__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 15 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 15];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic Gen8LP :: DS Threads Dispatched */
static uint64_t
chv__render_basic__ds_threads__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Render Metrics Basic Gen8LP :: Samples Written */
static uint64_t
chv__render_basic__samples_written__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic Gen8LP :: EU Stall */
static float
chv__render_basic__eu_stall__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic Gen8LP :: Samples Blended */
static uint64_t
chv__render_basic__samples_blended__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic Gen8LP :: Early Depth Test Fails */
static uint64_t
chv__render_basic__early_depth_test_fails__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic Gen8LP :: Samplers Bottleneck */
static float
chv__render_basic__sampler_bottleneck__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: $Sampler0Bottleneck $Sampler1Bottleneck FMAX */
   double tmp0 = chv__render_basic__sampler0_bottleneck__read(brw, query, accumulator);
   double tmp1 = chv__render_basic__sampler1_bottleneck__read(brw, query, accumulator);
   double tmp2 = MAX(tmp0, tmp1);

   return tmp2;
}

/* Render Metrics Basic Gen8LP :: GTI HDC TLB Lookup Throughput */
static uint64_t
chv__render_basic__gti_hdc_lookups_throughput__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: C 5 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 5];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Render Metrics Basic Gen8LP :: GTI RCC Throughput */
static uint64_t
chv__render_basic__gti_rcc_throughput__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: C 2 READ C 3 READ UADD 64 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 2];
   uint64_t tmp1 = accumulator[query->c_offset + 3];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = tmp2 * 64;

   return tmp3;
}

/* Render Metrics Basic Gen8LP :: HS Threads Dispatched */
static uint64_t
chv__render_basic__hs_threads__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Render Metrics Basic Gen8LP :: GTI Write Throughput */
static uint64_t
chv__render_basic__gti_write_throughput__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 7 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 7];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Render Metrics Basic Gen8LP :: SLM Bytes Written */
static uint64_t
chv__render_basic__slm_bytes_written__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Render Metrics Basic Gen8LP :: L3 Shader Throughput */
static uint64_t
chv__render_basic__l3_shader_throughput__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses UADD UADD 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = tmp1 + chv__render_basic__shader_memory_accesses__read(brw, query, accumulator);
   uint64_t tmp3 = tmp0 + tmp2;
   uint64_t tmp4 = tmp3 * 64;

   return tmp4;
}

/* Render Metrics Basic Gen8LP :: Samples Killed in FS */
static uint64_t
chv__render_basic__samples_killed_in_ps__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic Gen8LP :: Shader Atomic Memory Accesses */
static uint64_t
chv__render_basic__shader_atomics__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

static struct brw_perf_query_counter chv_render_basic_query_counters[50];
static struct brw_perf_query_info chv_render_basic_query = {
   .kind = OA_COUNTERS,
   .name = "Render Metrics Basic Gen8LP",
   .guid = "9d8a3af5-c02c-4a4a-b947-f1672469e0fb",
   .counters = chv_render_basic_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
};

static void
register_render_basic_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &chv_render_basic_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_basic__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_basic__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_basic__l3_misses__read;
      counter->name = "L3 Misses";
      counter->desc = "The total number of L3 misses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 16;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_basic__gti_l3_throughput__read;
      counter->name = "GTI L3 Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between L3 caches and GTI.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 24;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_basic__eu_fpu_both_active__read;
      counter->name = "EU Both FPU Pipes Active";
      counter->desc = "The percentage of time in which both EU FPU pipelines were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 32;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_basic__vs_send_active__read;
      counter->name = "VS Send Pipe Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 36;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_basic__sampler1_bottleneck__read;
      counter->name = "Sampler 1 Bottleneck";
      counter->desc = "The percentage of time in which Sampler 1 has been slowing down the pipe when processing EU requests.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 40;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_basic__vs_fpu1_active__read;
      counter->name = "VS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 44;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_basic__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 48;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_basic__l3_sampler_throughput__read;
      counter->name = "L3 Sampler Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between samplers and L3 caches.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 56;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_basic__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 64;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_basic__ps_eu_both_fpu_active__read;
      counter->name = "FS Both FPU Active";
      counter->desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 72;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_basic__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_basic__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_basic__sampler0_busy__read;
      counter->name = "Sampler 0 Busy";
      counter->desc = "The percentage of time in which Sampler 0 has been processing EU requests.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 96;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_basic__sampler1_busy__read;
      counter->name = "Sampler 1 Busy";
      counter->desc = "The percentage of time in which Sampler 1 has been processing EU requests.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 100;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_basic__samplers_busy__read;
      counter->name = "Samplers Busy";
      counter->desc = "The percentage of time in which samplers have been processing EU requests.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 104;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_basic__gti_vf_throughput__read;
      counter->name = "GTI Fixed Pipe Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between 3D Pipeline (Command Dispatch, Input Assembly and Stream Output) and GTI.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_basic__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 120;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_basic__sampler0_bottleneck__read;
      counter->name = "Sampler 0 Bottleneck";
      counter->desc = "The percentage of time in which Sampler 0 has been slowing down the pipe when processing EU requests.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 128;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_basic__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 136;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_basic__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 144;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_basic__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 152;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_basic__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = chv__render_basic__avg_gpu_core_frequency__max(brw);
      counter->offset = 160;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_basic__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 168;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_basic__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 176;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_basic__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_basic__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 192;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_basic__gti_read_throughput__read;
      counter->name = "GTI Read Throughput";
      counter->desc = "The total number of GPU memory bytes read from GTI.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 200;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_basic__ps_fpu1_active__read;
      counter->name = "PS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 208;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_basic__ps_send_active__read;
      counter->name = "PS Send Pipeline Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 212;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_basic__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_basic__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 224;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_basic__gti_depth_throughput__read;
      counter->name = "GTI Depth Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between depth caches and GTI.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 232;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_basic__vs_fpu0_active__read;
      counter->name = "VS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 240;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_basic__ps_fpu0_active__read;
      counter->name = "PS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 244;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_basic__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 248;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_basic__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 256;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_basic__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 264;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_basic__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 272;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_basic__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 280;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_basic__sampler_bottleneck__read;
      counter->name = "Samplers Bottleneck";
      counter->desc = "The percentage of time in which samplers have been slowing down the pipe when processing EU requests.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 288;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_basic__gti_hdc_lookups_throughput__read;
      counter->name = "GTI HDC TLB Lookup Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between GTI and HDC, when HDC is doing TLB lookups.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 296;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_basic__gti_rcc_throughput__read;
      counter->name = "GTI RCC Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between render color caches and GTI.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 304;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_basic__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 312;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_basic__gti_write_throughput__read;
      counter->name = "GTI Write Throughput";
      counter->desc = "The total number of GPU memory bytes written to GTI.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 320;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_basic__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 328;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_basic__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 336;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_basic__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 344;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_basic__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 352;
      counter->size = sizeof(uint64_t);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Compute Metrics Basic Gen8LP :: GPU Core Clocks */
static uint64_t
chv__compute_basic__gpu_core_clocks__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Compute Metrics Basic Gen8LP :: EU Active */
static float
chv__compute_basic__eu_active__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__compute_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics Basic Gen8LP :: Untyped Bytes Read */
static uint64_t
chv__compute_basic__untyped_bytes_read__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: B 4 READ B 5 READ UADD 64 UMUL */
   uint64_t tmp0 = accumulator[query->b_offset + 4];
   uint64_t tmp1 = accumulator[query->b_offset + 5];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = tmp2 * 64;

   return tmp3;
}

/* Compute Metrics Basic Gen8LP :: EU Both FPU Pipes Active */
static float
chv__compute_basic__eu_fpu_both_active__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__compute_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics Basic Gen8LP :: Typed Bytes Written */
static uint64_t
chv__compute_basic__typed_bytes_written__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: B 2 READ B 3 READ UADD 64 UMUL */
   uint64_t tmp0 = accumulator[query->b_offset + 2];
   uint64_t tmp1 = accumulator[query->b_offset + 3];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = tmp2 * 64;

   return tmp3;
}

/* Compute Metrics Basic Gen8LP :: EU FPU0 Pipe Active */
static float
chv__compute_basic__fpu0_active__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 10];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__compute_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics Basic Gen8LP :: EU FPU1 Pipe Active */
static float
chv__compute_basic__fpu1_active__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 11];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__compute_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics Basic Gen8LP :: EU AVG IPC Rate */
static float
chv__compute_basic__eu_avg_ipc_rate__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: A 9 READ  A 10 READ  A 11 READ UADD  A 9 READ USUB FDIV 1 FADD */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = accumulator[query->a_offset + 10];
   uint64_t tmp2 = accumulator[query->a_offset + 11];
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = accumulator[query->a_offset + 9];
   uint64_t tmp5 = tmp3 - tmp4;
   double tmp6 = tmp0;
   double tmp7 = tmp5;
   double tmp8 = tmp7 ? tmp6 / tmp7 : 0;
   double tmp9 = tmp8 + 1;

   return tmp9;
}

/* Compute Metrics Basic Gen8LP :: GS Threads Dispatched */
static uint64_t
chv__compute_basic__gs_threads__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Compute Metrics Basic Gen8LP :: Early Hi-Depth Test Fails */
static uint64_t
chv__compute_basic__hi_depth_test_fails__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics Basic Gen8LP :: VS Threads Dispatched */
static uint64_t
chv__compute_basic__vs_threads__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Compute Metrics Basic Gen8LP :: FS Threads Dispatched */
static uint64_t
chv__compute_basic__ps_threads__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Compute Metrics Basic Gen8LP :: Shader Barrier Messages */
static uint64_t
chv__compute_basic__shader_barriers__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Compute Metrics Basic Gen8LP :: Sampler Texels */
static uint64_t
chv__compute_basic__sampler_texels__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics Basic Gen8LP :: Pixels Failing Tests */
static uint64_t
chv__compute_basic__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                                       const struct brw_perf_query_info *query,
                                                       uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics Basic Gen8LP :: GPU Time Elapsed */
static uint64_t
chv__compute_basic__gpu_time__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Compute Metrics Basic Gen8LP :: AVG GPU Core Frequency */
static uint64_t
chv__compute_basic__avg_gpu_core_frequency__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = chv__compute_basic__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = chv__compute_basic__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Compute Metrics Basic Gen8LP :: AVG GPU Core Frequency */
static uint64_t
chv__compute_basic__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Compute Metrics Basic Gen8LP :: Sampler Texels Misses */
static uint64_t
chv__compute_basic__sampler_texel_misses__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics Basic Gen8LP :: CS Threads Dispatched */
static uint64_t
chv__compute_basic__cs_threads__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Compute Metrics Basic Gen8LP :: Shader Memory Accesses */
static uint64_t
chv__compute_basic__shader_memory_accesses__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Compute Metrics Basic Gen8LP :: SLM Bytes Read */
static uint64_t
chv__compute_basic__slm_bytes_read__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Compute Metrics Basic Gen8LP :: GTI Read Throughput */
static uint64_t
chv__compute_basic__gti_read_throughput__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 0 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 0];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Compute Metrics Basic Gen8LP :: GTI Ring Throughput */
static uint64_t
chv__compute_basic__gti_ring_throughput__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 2 READ 128 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 2];
   uint64_t tmp1 = tmp0 * 128;

   return tmp1;
}

/* Compute Metrics Basic Gen8LP :: Untyped Writes */
static uint64_t
chv__compute_basic__untyped_bytes_written__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: B 6 READ B 7 READ UADD $EuSlicesTotalCount 64 UMUL UMUL */
   uint64_t tmp0 = accumulator[query->b_offset + 6];
   uint64_t tmp1 = accumulator[query->b_offset + 7];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.n_eu_slices * 64;
   uint64_t tmp4 = tmp2 * tmp3;

   return tmp4;
}

/* Compute Metrics Basic Gen8LP :: GPU Busy */
static float
chv__compute_basic__gpu_busy__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__compute_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Compute Metrics Basic Gen8LP :: Rasterized Pixels */
static uint64_t
chv__compute_basic__rasterized_pixels__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics Basic Gen8LP :: Typed Bytes Read */
static uint64_t
chv__compute_basic__typed_bytes_read__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: B 0 READ B 1 READ UADD 64 UMUL */
   uint64_t tmp0 = accumulator[query->b_offset + 0];
   uint64_t tmp1 = accumulator[query->b_offset + 1];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = tmp2 * 64;

   return tmp3;
}

/* Compute Metrics Basic Gen8LP :: GTI Read-Only Stall */
static float
chv__compute_basic__gti_ro_stall__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: C 3 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 3];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__compute_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Compute Metrics Basic Gen8LP :: DS Threads Dispatched */
static uint64_t
chv__compute_basic__ds_threads__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Compute Metrics Basic Gen8LP :: EU Thread Occupancy */
static float
chv__compute_basic__eu_thread_occupancy__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 13 READ 8 UMUL $EuCoresTotalCount UDIV $EuThreadsCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 13];
   uint64_t tmp1 = tmp0 * 8;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;
   uint64_t tmp5 = tmp4;
   uint64_t tmp6 = brw->perfquery.sys_vars.eu_threads_count;
   uint64_t tmp7 = tmp6 ? tmp5 / tmp6 : 0;
   uint64_t tmp8 = tmp7 * 100;
   double tmp9 = tmp8;
   double tmp10 = chv__compute_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp11 = tmp10 ? tmp9 / tmp10 : 0;

   return tmp11;
}

/* Compute Metrics Basic Gen8LP :: GTI Read-Write Stall */
static float
chv__compute_basic__gti_rw_stall__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: C 4 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 4];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__compute_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Compute Metrics Basic Gen8LP :: EU Stall */
static float
chv__compute_basic__eu_stall__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__compute_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics Basic Gen8LP :: Samples Blended */
static uint64_t
chv__compute_basic__samples_blended__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics Basic Gen8LP :: Early Depth Test Fails */
static uint64_t
chv__compute_basic__early_depth_test_fails__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics Basic Gen8LP :: HS Threads Dispatched */
static uint64_t
chv__compute_basic__hs_threads__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Compute Metrics Basic Gen8LP :: GTI Write Throughput */
static uint64_t
chv__compute_basic__gti_write_throughput__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: C 1 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 1];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Compute Metrics Basic Gen8LP :: SLM Bytes Written */
static uint64_t
chv__compute_basic__slm_bytes_written__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Compute Metrics Basic Gen8LP :: L3 Shader Throughput */
static uint64_t
chv__compute_basic__l3_shader_throughput__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses UADD UADD 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = tmp1 + chv__compute_basic__shader_memory_accesses__read(brw, query, accumulator);
   uint64_t tmp3 = tmp0 + tmp2;
   uint64_t tmp4 = tmp3 * 64;

   return tmp4;
}

/* Compute Metrics Basic Gen8LP :: Samples Killed in FS */
static uint64_t
chv__compute_basic__samples_killed_in_ps__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics Basic Gen8LP :: Samples Written */
static uint64_t
chv__compute_basic__samples_written__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics Basic Gen8LP :: Shader Atomic Memory Accesses */
static uint64_t
chv__compute_basic__shader_atomics__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

/* Compute Metrics Basic Gen8LP :: EU Send Pipe Active */
static float
chv__compute_basic__eu_send_active__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__compute_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

static struct brw_perf_query_counter chv_compute_basic_query_counters[42];
static struct brw_perf_query_info chv_compute_basic_query = {
   .kind = OA_COUNTERS,
   .name = "Compute Metrics Basic Gen8LP",
   .guid = "f522a89c-ecd1-4522-8331-3383c54af5f5",
   .counters = chv_compute_basic_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
};

static void
register_compute_basic_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &chv_compute_basic_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__compute_basic__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__compute_basic__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__compute_basic__untyped_bytes_read__read;
      counter->name = "Untyped Bytes Read";
      counter->desc = "The total number of typed memory bytes read via Data Port.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 16;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__compute_basic__eu_fpu_both_active__read;
      counter->name = "EU Both FPU Pipes Active";
      counter->desc = "The percentage of time in which both EU FPU pipelines were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 24;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__compute_basic__typed_bytes_written__read;
      counter->name = "Typed Bytes Written";
      counter->desc = "The total number of untyped memory bytes written via Data Port.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__compute_basic__fpu0_active__read;
      counter->name = "EU FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 40;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__compute_basic__fpu1_active__read;
      counter->name = "EU FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 44;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__compute_basic__eu_avg_ipc_rate__read;
      counter->name = "EU AVG IPC Rate";
      counter->desc = "The average rate of IPC calculated for 2 FPU pipelines.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 2;
      counter->offset = 48;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__compute_basic__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 56;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__compute_basic__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 64;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__compute_basic__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__compute_basic__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__compute_basic__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__compute_basic__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__compute_basic__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 104;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__compute_basic__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__compute_basic__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = chv__compute_basic__avg_gpu_core_frequency__max(brw);
      counter->offset = 120;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__compute_basic__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 128;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__compute_basic__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 136;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__compute_basic__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 144;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__compute_basic__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 152;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__compute_basic__gti_read_throughput__read;
      counter->name = "GTI Read Throughput";
      counter->desc = "The total number of GPU memory bytes read from GTI.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 160;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__compute_basic__gti_ring_throughput__read;
      counter->name = "GTI Ring Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between GTI and Uncore ring.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 168;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__compute_basic__untyped_bytes_written__read;
      counter->name = "Untyped Writes";
      counter->desc = "The total number of untyped memory bytes written via Data Port.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 176;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__compute_basic__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 184;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__compute_basic__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 192;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__compute_basic__typed_bytes_read__read;
      counter->name = "Typed Bytes Read";
      counter->desc = "The total number of typed memory bytes read via Data Port.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 200;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__compute_basic__gti_ro_stall__read;
      counter->name = "GTI Read-Only Stall";
      counter->desc = "The percentage of time in which GTI Read-Only port has been stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 208;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__compute_basic__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__compute_basic__eu_thread_occupancy__read;
      counter->name = "EU Thread Occupancy";
      counter->desc = "The percentage of time in which hardware threads occupied EUs.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 224;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__compute_basic__gti_rw_stall__read;
      counter->name = "GTI Read-Write Stall";
      counter->desc = "The percentage of time in which GTI Read-Write port has been stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 228;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__compute_basic__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 232;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__compute_basic__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 240;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__compute_basic__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 248;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__compute_basic__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 256;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__compute_basic__gti_write_throughput__read;
      counter->name = "GTI Write Throughput";
      counter->desc = "The total number of GPU memory bytes written to GTI.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 264;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__compute_basic__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 272;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__compute_basic__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 280;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__compute_basic__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 288;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__compute_basic__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 296;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__compute_basic__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 304;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__compute_basic__eu_send_active__read;
      counter->name = "EU Send Pipe Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 312;
      counter->size = sizeof(float);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Render Metrics for 3D Pipeline Profile :: GPU Core Clocks */
static uint64_t
chv__render_pipe_profile__gpu_core_clocks__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Render Metrics for 3D Pipeline Profile :: EU Active */
static float
chv__render_pipe_profile__eu_active__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics for 3D Pipeline Profile :: VS Bottleneck */
static float
chv__render_pipe_profile__vs_bottleneck__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: B 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: Hi-Depth Bottleneck */
static float
chv__render_pipe_profile__hi_depth_bottleneck__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: C 6 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 6];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: GS Bottleneck */
static float
chv__render_pipe_profile__gs_bottleneck__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: B 3 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 3];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: GS Threads Dispatched */
static uint64_t
chv__render_pipe_profile__gs_threads__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Render Metrics for 3D Pipeline Profile :: Early Hi-Depth Test Fails */
static uint64_t
chv__render_pipe_profile__hi_depth_test_fails__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics for 3D Pipeline Profile :: VS Threads Dispatched */
static uint64_t
chv__render_pipe_profile__vs_threads__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Render Metrics for 3D Pipeline Profile :: FS Threads Dispatched */
static uint64_t
chv__render_pipe_profile__ps_threads__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Render Metrics for 3D Pipeline Profile :: BC Bottleneck */
static float
chv__render_pipe_profile__bc_bottleneck__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 7 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 7];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: HS Stall */
static float
chv__render_pipe_profile__hs_stall__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: C 1 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 1];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: Shader Barrier Messages */
static uint64_t
chv__render_pipe_profile__shader_barriers__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Render Metrics for 3D Pipeline Profile :: Sampler Texels */
static uint64_t
chv__render_pipe_profile__sampler_texels__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics for 3D Pipeline Profile :: Pixels Failing Tests */
static uint64_t
chv__render_pipe_profile__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                                             const struct brw_perf_query_info *query,
                                                             uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics for 3D Pipeline Profile :: GPU Time Elapsed */
static uint64_t
chv__render_pipe_profile__gpu_time__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: AVG GPU Core Frequency */
static uint64_t
chv__render_pipe_profile__avg_gpu_core_frequency__read(struct brw_context *brw,
                                                       const struct brw_perf_query_info *query,
                                                       uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = chv__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = chv__render_pipe_profile__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Render Metrics for 3D Pipeline Profile :: AVG GPU Core Frequency */
static uint64_t
chv__render_pipe_profile__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Render Metrics for 3D Pipeline Profile :: Sampler Texels Misses */
static uint64_t
chv__render_pipe_profile__sampler_texel_misses__read(struct brw_context *brw,
                                                     const struct brw_perf_query_info *query,
                                                     uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics for 3D Pipeline Profile :: CS Threads Dispatched */
static uint64_t
chv__render_pipe_profile__cs_threads__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Render Metrics for 3D Pipeline Profile :: VF Bottleneck */
static float
chv__render_pipe_profile__vf_bottleneck__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: SLM Bytes Read */
static uint64_t
chv__render_pipe_profile__slm_bytes_read__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Render Metrics for 3D Pipeline Profile :: Strip-Fans Bottleneck */
static float
chv__render_pipe_profile__sf_bottleneck__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: B 6 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 6];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: Sampler Accesses */
static uint64_t
chv__render_pipe_profile__sampler_accesses__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: A 28 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 28];

   return tmp0;
}

/* Render Metrics for 3D Pipeline Profile :: SF Stall */
static float
chv__render_pipe_profile__sf_stall__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: C 5 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 5];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: GPU Busy */
static float
chv__render_pipe_profile__gpu_busy__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: HS Bottleneck */
static float
chv__render_pipe_profile__hs_bottleneck__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: B 1 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 1];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: CL Stall */
static float
chv__render_pipe_profile__cl_stall__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: C 4 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 4];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: SO Bottleneck */
static float
chv__render_pipe_profile__so_bottleneck__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: B 4 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 4];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: Rasterized Pixels */
static uint64_t
chv__render_pipe_profile__rasterized_pixels__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics for 3D Pipeline Profile :: DS Threads Dispatched */
static uint64_t
chv__render_pipe_profile__ds_threads__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Render Metrics for 3D Pipeline Profile :: Samples Written */
static uint64_t
chv__render_pipe_profile__samples_written__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics for 3D Pipeline Profile :: DS Bottleneck */
static float
chv__render_pipe_profile__ds_bottleneck__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: B 2 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 2];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: EU Stall */
static float
chv__render_pipe_profile__eu_stall__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics for 3D Pipeline Profile :: Clipper Bottleneck */
static float
chv__render_pipe_profile__cl_bottleneck__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: B 5 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 5];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: DS Stall */
static float
chv__render_pipe_profile__ds_stall__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: C 2 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 2];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: Early Depth Bottleneck */
static float
chv__render_pipe_profile__early_depth_bottleneck__read(struct brw_context *brw,
                                                       const struct brw_perf_query_info *query,
                                                       uint64_t *accumulator)
{
   /* RPN equation: B 7 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 7];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: Samples Blended */
static uint64_t
chv__render_pipe_profile__samples_blended__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics for 3D Pipeline Profile :: Early Depth Test Fails */
static uint64_t
chv__render_pipe_profile__early_depth_test_fails__read(struct brw_context *brw,
                                                       const struct brw_perf_query_info *query,
                                                       uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics for 3D Pipeline Profile :: Shader Memory Accesses */
static uint64_t
chv__render_pipe_profile__shader_memory_accesses__read(struct brw_context *brw,
                                                       const struct brw_perf_query_info *query,
                                                       uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Render Metrics for 3D Pipeline Profile :: HS Threads Dispatched */
static uint64_t
chv__render_pipe_profile__hs_threads__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Render Metrics for 3D Pipeline Profile :: SLM Bytes Written */
static uint64_t
chv__render_pipe_profile__slm_bytes_written__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Render Metrics for 3D Pipeline Profile :: L3 Shader Throughput */
static uint64_t
chv__render_pipe_profile__l3_shader_throughput__read(struct brw_context *brw,
                                                     const struct brw_perf_query_info *query,
                                                     uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses UADD UADD 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = tmp1 + chv__render_pipe_profile__shader_memory_accesses__read(brw, query, accumulator);
   uint64_t tmp3 = tmp0 + tmp2;
   uint64_t tmp4 = tmp3 * 64;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: Samples Killed in FS */
static uint64_t
chv__render_pipe_profile__samples_killed_in_ps__read(struct brw_context *brw,
                                                     const struct brw_perf_query_info *query,
                                                     uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics for 3D Pipeline Profile :: SO Stall */
static float
chv__render_pipe_profile__so_stall__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: C 3 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 3];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: Shader Atomic Memory Accesses */
static uint64_t
chv__render_pipe_profile__shader_atomics__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

static struct brw_perf_query_counter chv_render_pipe_profile_query_counters[44];
static struct brw_perf_query_info chv_render_pipe_profile_query = {
   .kind = OA_COUNTERS,
   .name = "Render Metrics for 3D Pipeline Profile",
   .guid = "a9ccc03d-a943-4e6b-9cd6-13e063075927",
   .counters = chv_render_pipe_profile_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
};

static void
register_render_pipe_profile_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &chv_render_pipe_profile_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_pipe_profile__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_pipe_profile__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_pipe_profile__vs_bottleneck__read;
      counter->name = "VS Bottleneck";
      counter->desc = "The percentage of time in which vertex shader pipeline stage was slowing down the 3D pipeline.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 12;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_pipe_profile__hi_depth_bottleneck__read;
      counter->name = "Hi-Depth Bottleneck";
      counter->desc = "The percentage of time in which early hierarchical depth test pipeline stage was slowing down the 3D pipeline.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 16;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_pipe_profile__gs_bottleneck__read;
      counter->name = "GS Bottleneck";
      counter->desc = "The percentage of time in which geometry shader pipeline stage was slowing down the 3D pipeline.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 20;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_pipe_profile__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 24;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_pipe_profile__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_pipe_profile__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 40;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_pipe_profile__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 48;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_pipe_profile__bc_bottleneck__read;
      counter->name = "BC Bottleneck";
      counter->desc = "The percentage of time in which barycentric coordinates calculation pipeline stage was slowing down the 3D pipeline.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 56;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_pipe_profile__hs_stall__read;
      counter->name = "HS Stall";
      counter->desc = "The percentage of time in which hull stall pipeline stage was stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 60;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_pipe_profile__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 64;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_pipe_profile__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_pipe_profile__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_pipe_profile__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_pipe_profile__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = chv__render_pipe_profile__avg_gpu_core_frequency__max(brw);
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_pipe_profile__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 104;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_pipe_profile__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_pipe_profile__vf_bottleneck__read;
      counter->name = "VF Bottleneck";
      counter->desc = "The percentage of time in which vertex fetch pipeline stage was slowing down the 3D pipeline.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 120;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_pipe_profile__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 128;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_pipe_profile__sf_bottleneck__read;
      counter->name = "Strip-Fans Bottleneck";
      counter->desc = "The percentage of time in which strip-fans pipeline stage was slowing down the 3D pipeline.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 136;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_pipe_profile__sampler_accesses__read;
      counter->name = "Sampler Accesses";
      counter->desc = "The total number of messages send to samplers.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 144;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_pipe_profile__sf_stall__read;
      counter->name = "SF Stall";
      counter->desc = "The percentage of time in which strip-fans pipeline stage was stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 152;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_pipe_profile__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 156;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_pipe_profile__hs_bottleneck__read;
      counter->name = "HS Bottleneck";
      counter->desc = "The percentage of time in which hull shader pipeline stage was slowing down the 3D pipeline.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 160;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_pipe_profile__cl_stall__read;
      counter->name = "CL Stall";
      counter->desc = "The percentage of time in which clipper pipeline stage was stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 164;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_pipe_profile__so_bottleneck__read;
      counter->name = "SO Bottleneck";
      counter->desc = "The percentage of time in which stream output pipeline stage was slowing down the 3D pipeline.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 168;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_pipe_profile__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 176;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_pipe_profile__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_pipe_profile__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 192;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_pipe_profile__ds_bottleneck__read;
      counter->name = "DS Bottleneck";
      counter->desc = "The percentage of time in which domain shader pipeline stage was slowing down the 3D pipeline.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 200;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_pipe_profile__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 204;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_pipe_profile__cl_bottleneck__read;
      counter->name = "Clipper Bottleneck";
      counter->desc = "The percentage of time in which clipper pipeline stage was slowing down the 3D pipeline.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 208;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_pipe_profile__ds_stall__read;
      counter->name = "DS Stall";
      counter->desc = "The percentage of time in which domain shader pipeline stage was stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 212;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_pipe_profile__early_depth_bottleneck__read;
      counter->name = "Early Depth Bottleneck";
      counter->desc = "The percentage of time in which early depth test pipeline stage was slowing down the 3D pipeline.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 216;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_pipe_profile__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 224;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_pipe_profile__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 232;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_pipe_profile__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 240;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_pipe_profile__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 248;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_pipe_profile__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 256;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_pipe_profile__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 264;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_pipe_profile__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 272;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__render_pipe_profile__so_stall__read;
      counter->name = "SO Stall";
      counter->desc = "The percentage of time in which stream-output pipeline stage was stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 280;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__render_pipe_profile__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 288;
      counter->size = sizeof(uint64_t);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Metric set HDCAndSF :: GPU Core Clocks */
static uint64_t
chv__hdc_and_sf__gpu_core_clocks__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Metric set HDCAndSF :: EU Active */
static float
chv__hdc_and_sf__eu_active__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set HDCAndSF :: EU Both FPU Pipes Active */
static float
chv__hdc_and_sf__eu_fpu_both_active__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set HDCAndSF :: VS Send Pipe Active */
static float
chv__hdc_and_sf__vs_send_active__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set HDCAndSF :: VS FPU1 Pipe Active */
static float
chv__hdc_and_sf__vs_fpu1_active__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 11];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set HDCAndSF :: GS Threads Dispatched */
static uint64_t
chv__hdc_and_sf__gs_threads__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Metric set HDCAndSF :: Early Hi-Depth Test Fails */
static uint64_t
chv__hdc_and_sf__hi_depth_test_fails__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set HDCAndSF :: FS Both FPU Active */
static float
chv__hdc_and_sf__ps_eu_both_fpu_active__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 18];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set HDCAndSF :: VS Threads Dispatched */
static uint64_t
chv__hdc_and_sf__vs_threads__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Metric set HDCAndSF :: Polygon Data Ready */
static float
chv__hdc_and_sf__poly_data_ready__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: B 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set HDCAndSF :: FS Threads Dispatched */
static uint64_t
chv__hdc_and_sf__ps_threads__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss2) */
static float
chv__hdc_and_sf__non_sampler_shader12_access_stalled_on_l3__read(struct brw_context *brw,
                                                                 const struct brw_perf_query_info *query,
                                                                 uint64_t *accumulator)
{
   /* RPN equation: C 1 READ C 0 READ USUB 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 1];
   uint64_t tmp1 = accumulator[query->c_offset + 0];
   uint64_t tmp2 = tmp0 - tmp1;
   uint64_t tmp3 = tmp2 * 100;
   double tmp4 = tmp3;
   double tmp5 = chv__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

   return tmp6;
}

/* Metric set HDCAndSF :: Shader Barrier Messages */
static uint64_t
chv__hdc_and_sf__shader_barriers__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Metric set HDCAndSF :: Sampler Texels */
static uint64_t
chv__hdc_and_sf__sampler_texels__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set HDCAndSF :: Pixels Failing Tests */
static uint64_t
chv__hdc_and_sf__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set HDCAndSF :: GPU Time Elapsed */
static uint64_t
chv__hdc_and_sf__gpu_time__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set HDCAndSF :: AVG GPU Core Frequency */
static uint64_t
chv__hdc_and_sf__avg_gpu_core_frequency__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = chv__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = chv__hdc_and_sf__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Metric set HDCAndSF :: AVG GPU Core Frequency */
static uint64_t
chv__hdc_and_sf__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Metric set HDCAndSF :: Sampler Texels Misses */
static uint64_t
chv__hdc_and_sf__sampler_texel_misses__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss1) */
static float
chv__hdc_and_sf__non_sampler_shader01_access_stalled_on_l3__read(struct brw_context *brw,
                                                                 const struct brw_perf_query_info *query,
                                                                 uint64_t *accumulator)
{
   /* RPN equation: C 5 READ C 4 READ USUB 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 5];
   uint64_t tmp1 = accumulator[query->c_offset + 4];
   uint64_t tmp2 = tmp0 - tmp1;
   uint64_t tmp3 = tmp2 * 100;
   double tmp4 = tmp3;
   double tmp5 = chv__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

   return tmp6;
}

/* Metric set HDCAndSF :: CS Threads Dispatched */
static uint64_t
chv__hdc_and_sf__cs_threads__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss2) */
static float
chv__hdc_and_sf__non_sampler_shader02_access_stalled_on_l3__read(struct brw_context *brw,
                                                                 const struct brw_perf_query_info *query,
                                                                 uint64_t *accumulator)
{
   /* RPN equation: C 7 READ C 6 READ USUB 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 7];
   uint64_t tmp1 = accumulator[query->c_offset + 6];
   uint64_t tmp2 = tmp0 - tmp1;
   uint64_t tmp3 = tmp2 * 100;
   double tmp4 = tmp3;
   double tmp5 = chv__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

   return tmp6;
}

/* Metric set HDCAndSF :: SLM Bytes Read */
static uint64_t
chv__hdc_and_sf__slm_bytes_read__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set HDCAndSF :: PS FPU1 Pipe Active */
static float
chv__hdc_and_sf__ps_fpu1_active__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 16 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 16];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set HDCAndSF :: PS Send Pipeline Active */
static float
chv__hdc_and_sf__ps_send_active__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 17];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set HDCAndSF :: VS FPU0 Pipe Active */
static float
chv__hdc_and_sf__vs_fpu0_active__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 10];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set HDCAndSF :: GPU Busy */
static float
chv__hdc_and_sf__gpu_busy__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss0) */
static float
chv__hdc_and_sf__non_sampler_shader10_access_stalled_on_l3__read(struct brw_context *brw,
                                                                 const struct brw_perf_query_info *query,
                                                                 uint64_t *accumulator)
{
   /* RPN equation: B 5 READ B 4 READ USUB 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 5];
   uint64_t tmp1 = accumulator[query->b_offset + 4];
   uint64_t tmp2 = tmp0 - tmp1;
   uint64_t tmp3 = tmp2 * 100;
   double tmp4 = tmp3;
   double tmp5 = chv__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

   return tmp6;
}

/* Metric set HDCAndSF :: Rasterized Pixels */
static uint64_t
chv__hdc_and_sf__rasterized_pixels__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set HDCAndSF :: PS FPU0 Pipe Active */
static float
chv__hdc_and_sf__ps_fpu0_active__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 15 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 15];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set HDCAndSF :: DS Threads Dispatched */
static uint64_t
chv__hdc_and_sf__ds_threads__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Metric set HDCAndSF :: Samples Written */
static uint64_t
chv__hdc_and_sf__samples_written__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set HDCAndSF :: EU Stall */
static float
chv__hdc_and_sf__eu_stall__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set HDCAndSF :: Samples Blended */
static uint64_t
chv__hdc_and_sf__samples_blended__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set HDCAndSF :: Early Depth Test Fails */
static uint64_t
chv__hdc_and_sf__early_depth_test_fails__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set HDCAndSF :: Shader Memory Accesses */
static uint64_t
chv__hdc_and_sf__shader_memory_accesses__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Metric set HDCAndSF :: HS Threads Dispatched */
static uint64_t
chv__hdc_and_sf__hs_threads__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss1) */
static float
chv__hdc_and_sf__non_sampler_shader11_access_stalled_on_l3__read(struct brw_context *brw,
                                                                 const struct brw_perf_query_info *query,
                                                                 uint64_t *accumulator)
{
   /* RPN equation: B 7 READ B 6 READ USUB 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 7];
   uint64_t tmp1 = accumulator[query->b_offset + 6];
   uint64_t tmp2 = tmp0 - tmp1;
   uint64_t tmp3 = tmp2 * 100;
   double tmp4 = tmp3;
   double tmp5 = chv__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

   return tmp6;
}

/* Metric set HDCAndSF :: SLM Bytes Written */
static uint64_t
chv__hdc_and_sf__slm_bytes_written__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set HDCAndSF :: L3 Shader Throughput */
static uint64_t
chv__hdc_and_sf__l3_shader_throughput__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = chv__hdc_and_sf__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Metric set HDCAndSF :: Samples Killed in FS */
static uint64_t
chv__hdc_and_sf__samples_killed_in_ps__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss0) */
static float
chv__hdc_and_sf__non_sampler_shader00_access_stalled_on_l3__read(struct brw_context *brw,
                                                                 const struct brw_perf_query_info *query,
                                                                 uint64_t *accumulator)
{
   /* RPN equation: C 3 READ C 2 READ USUB 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 3];
   uint64_t tmp1 = accumulator[query->c_offset + 2];
   uint64_t tmp2 = tmp0 - tmp1;
   uint64_t tmp3 = tmp2 * 100;
   double tmp4 = tmp3;
   double tmp5 = chv__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

   return tmp6;
}

/* Metric set HDCAndSF :: Shader Atomic Memory Accesses */
static uint64_t
chv__hdc_and_sf__shader_atomics__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

static struct brw_perf_query_counter chv_hdc_and_sf_query_counters[42];
static struct brw_perf_query_info chv_hdc_and_sf_query = {
   .kind = OA_COUNTERS,
   .name = "Metric set HDCAndSF",
   .guid = "2cf0c064-68df-4fac-9b3f-57f51ca8a069",
   .counters = chv_hdc_and_sf_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
};

static void
register_hdc_and_sf_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &chv_hdc_and_sf_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__hdc_and_sf__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__hdc_and_sf__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__hdc_and_sf__eu_fpu_both_active__read;
      counter->name = "EU Both FPU Pipes Active";
      counter->desc = "The percentage of time in which both EU FPU pipelines were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 12;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__hdc_and_sf__vs_send_active__read;
      counter->name = "VS Send Pipe Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 16;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__hdc_and_sf__vs_fpu1_active__read;
      counter->name = "VS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 20;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__hdc_and_sf__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 24;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__hdc_and_sf__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__hdc_and_sf__ps_eu_both_fpu_active__read;
      counter->name = "FS Both FPU Active";
      counter->desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 40;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__hdc_and_sf__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 48;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__hdc_and_sf__poly_data_ready__read;
      counter->name = "Polygon Data Ready";
      counter->desc = "The percentage of time in which geometry pipeline output is ready";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 56;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__hdc_and_sf__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 64;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x20) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__hdc_and_sf__non_sampler_shader12_access_stalled_on_l3__read;
         counter->name = "HDC stalled by L3 (s0.ss2)";
         counter->desc = "Percentage of time when HDC has messges to L3, but it's stalled due to lack of credits (s0.ss2)";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 72;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__hdc_and_sf__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__hdc_and_sf__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__hdc_and_sf__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__hdc_and_sf__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 104;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__hdc_and_sf__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = chv__hdc_and_sf__avg_gpu_core_frequency__max(brw);
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__hdc_and_sf__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 120;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x2) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__hdc_and_sf__non_sampler_shader01_access_stalled_on_l3__read;
         counter->name = "HDC stalled by L3 (s0.ss1)";
         counter->desc = "Percentage of time when HDC has messges to L3, but it's stalled due to lack of credits (s0.ss1)";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 128;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__hdc_and_sf__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 136;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x4) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__hdc_and_sf__non_sampler_shader02_access_stalled_on_l3__read;
         counter->name = "HDC stalled by L3 (s0.ss2)";
         counter->desc = "Percentage of time when HDC has messges to L3, but it's stalled due to lack of credits (s0.ss2)";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 144;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__hdc_and_sf__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 152;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__hdc_and_sf__ps_fpu1_active__read;
      counter->name = "PS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 160;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__hdc_and_sf__ps_send_active__read;
      counter->name = "PS Send Pipeline Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 164;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__hdc_and_sf__vs_fpu0_active__read;
      counter->name = "VS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 168;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__hdc_and_sf__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 172;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.subslice_mask & 0x8) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__hdc_and_sf__non_sampler_shader10_access_stalled_on_l3__read;
         counter->name = "HDC stalled by L3 (s0.ss0)";
         counter->desc = "Percentage of time when HDC has messges to L3, but it's stalled due to lack of credits (s0.ss0)";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 176;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__hdc_and_sf__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__hdc_and_sf__ps_fpu0_active__read;
      counter->name = "PS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 192;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__hdc_and_sf__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 200;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__hdc_and_sf__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 208;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__hdc_and_sf__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 216;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__hdc_and_sf__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 224;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__hdc_and_sf__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 232;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__hdc_and_sf__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 240;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__hdc_and_sf__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 248;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x10) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__hdc_and_sf__non_sampler_shader11_access_stalled_on_l3__read;
         counter->name = "HDC stalled by L3 (s0.ss1)";
         counter->desc = "Percentage of time when HDC has messges to L3, but it's stalled due to lack of credits (s0.ss1)";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 256;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__hdc_and_sf__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 264;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__hdc_and_sf__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 272;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__hdc_and_sf__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 280;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__hdc_and_sf__non_sampler_shader00_access_stalled_on_l3__read;
         counter->name = "HDC stalled by L3 (s0.ss0)";
         counter->desc = "Percentage of time when HDC has messges to L3, but it's stalled due to lack of credits (s0.ss0)";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 288;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__hdc_and_sf__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 296;
      counter->size = sizeof(uint64_t);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Metric set L3_1 :: GPU Core Clocks */
static uint64_t
chv__l3_1__gpu_core_clocks__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Metric set L3_1 :: EU Active */
static float
chv__l3_1__eu_active__read(struct brw_context *brw,
                           const struct brw_perf_query_info *query,
                           uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_1 :: Slice1 L3 Bank1 Stalled */
static float
chv__l3_1__l31_bank1_stalled__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: B 4 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 4];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_1 :: EU Both FPU Pipes Active */
static float
chv__l3_1__eu_fpu_both_active__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_1 :: VS Send Pipe Active */
static float
chv__l3_1__vs_send_active__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_1 :: VS FPU1 Pipe Active */
static float
chv__l3_1__vs_fpu1_active__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 11];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_1 :: GS Threads Dispatched */
static uint64_t
chv__l3_1__gs_threads__read(struct brw_context *brw,
                            const struct brw_perf_query_info *query,
                            uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Metric set L3_1 :: Early Hi-Depth Test Fails */
static uint64_t
chv__l3_1__hi_depth_test_fails__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_1 :: FS Both FPU Active */
static float
chv__l3_1__ps_eu_both_fpu_active__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 18];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_1 :: VS Threads Dispatched */
static uint64_t
chv__l3_1__vs_threads__read(struct brw_context *brw,
                            const struct brw_perf_query_info *query,
                            uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Metric set L3_1 :: FS Threads Dispatched */
static uint64_t
chv__l3_1__ps_threads__read(struct brw_context *brw,
                            const struct brw_perf_query_info *query,
                            uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Metric set L3_1 :: Shader Barrier Messages */
static uint64_t
chv__l3_1__shader_barriers__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Metric set L3_1 :: Slice1 L3 Bank0 Stalled */
static float
chv__l3_1__l31_bank0_stalled__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: B 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_1 :: Sampler Texels */
static uint64_t
chv__l3_1__sampler_texels__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_1 :: Pixels Failing Tests */
static uint64_t
chv__l3_1__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_1 :: GPU Time Elapsed */
static uint64_t
chv__l3_1__gpu_time__read(struct brw_context *brw,
                          const struct brw_perf_query_info *query,
                          uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_1 :: AVG GPU Core Frequency */
static uint64_t
chv__l3_1__avg_gpu_core_frequency__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = chv__l3_1__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = chv__l3_1__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Metric set L3_1 :: AVG GPU Core Frequency */
static uint64_t
chv__l3_1__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Metric set L3_1 :: Sampler Texels Misses */
static uint64_t
chv__l3_1__sampler_texel_misses__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_1 :: CS Threads Dispatched */
static uint64_t
chv__l3_1__cs_threads__read(struct brw_context *brw,
                            const struct brw_perf_query_info *query,
                            uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Metric set L3_1 :: SLM Bytes Read */
static uint64_t
chv__l3_1__slm_bytes_read__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set L3_1 :: PS FPU1 Pipe Active */
static float
chv__l3_1__ps_fpu1_active__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 16 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 16];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_1 :: PS Send Pipeline Active */
static float
chv__l3_1__ps_send_active__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 17];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_1 :: VS FPU0 Pipe Active */
static float
chv__l3_1__vs_fpu0_active__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 10];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_1 :: GPU Busy */
static float
chv__l3_1__gpu_busy__read(struct brw_context *brw,
                          const struct brw_perf_query_info *query,
                          uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_1 :: Rasterized Pixels */
static uint64_t
chv__l3_1__rasterized_pixels__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_1 :: Slice1 L3 Bank1 Active */
static float
chv__l3_1__l31_bank1_active__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: C 7 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 7];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_1 :: PS FPU0 Pipe Active */
static float
chv__l3_1__ps_fpu0_active__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 15 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 15];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_1 :: DS Threads Dispatched */
static uint64_t
chv__l3_1__ds_threads__read(struct brw_context *brw,
                            const struct brw_perf_query_info *query,
                            uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Metric set L3_1 :: Samples Written */
static uint64_t
chv__l3_1__samples_written__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_1 :: EU Stall */
static float
chv__l3_1__eu_stall__read(struct brw_context *brw,
                          const struct brw_perf_query_info *query,
                          uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_1 :: Slice1 L3 Bank0 Active */
static float
chv__l3_1__l31_bank0_active__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: C 6 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 6];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_1 :: Samples Blended */
static uint64_t
chv__l3_1__samples_blended__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_1 :: Early Depth Test Fails */
static uint64_t
chv__l3_1__early_depth_test_fails__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_1 :: Shader Memory Accesses */
static uint64_t
chv__l3_1__shader_memory_accesses__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Metric set L3_1 :: HS Threads Dispatched */
static uint64_t
chv__l3_1__hs_threads__read(struct brw_context *brw,
                            const struct brw_perf_query_info *query,
                            uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Metric set L3_1 :: SLM Bytes Written */
static uint64_t
chv__l3_1__slm_bytes_written__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set L3_1 :: L3 Shader Throughput */
static uint64_t
chv__l3_1__l3_shader_throughput__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = chv__l3_1__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Metric set L3_1 :: Samples Killed in FS */
static uint64_t
chv__l3_1__samples_killed_in_ps__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_1 :: Shader Atomic Memory Accesses */
static uint64_t
chv__l3_1__shader_atomics__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

static struct brw_perf_query_counter chv_l3_1_query_counters[39];
static struct brw_perf_query_info chv_l3_1_query = {
   .kind = OA_COUNTERS,
   .name = "Metric set L3_1",
   .guid = "78a87ff9-543a-49ce-95ea-26d86071ea93",
   .counters = chv_l3_1_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
};

static void
register_l3_1_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &chv_l3_1_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_1__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_1__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.slice_mask & 0x2) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__l3_1__l31_bank1_stalled__read;
         counter->name = "Slice1 L3 Bank1 Stalled";
         counter->desc = "The percentage of time in which slice1 L3 bank1 is stalled";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 12;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_1__eu_fpu_both_active__read;
      counter->name = "EU Both FPU Pipes Active";
      counter->desc = "The percentage of time in which both EU FPU pipelines were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 16;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_1__vs_send_active__read;
      counter->name = "VS Send Pipe Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 20;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_1__vs_fpu1_active__read;
      counter->name = "VS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 24;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_1__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_1__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 40;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_1__ps_eu_both_fpu_active__read;
      counter->name = "FS Both FPU Active";
      counter->desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 48;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_1__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 56;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_1__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 64;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_1__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.slice_mask & 0x2) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__l3_1__l31_bank0_stalled__read;
         counter->name = "Slice1 L3 Bank0 Stalled";
         counter->desc = "The percentage of time in which slice1 L3 bank0 is stalled";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 80;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_1__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_1__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_1__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 104;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_1__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = chv__l3_1__avg_gpu_core_frequency__max(brw);
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_1__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 120;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_1__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 128;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_1__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 136;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_1__ps_fpu1_active__read;
      counter->name = "PS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 144;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_1__ps_send_active__read;
      counter->name = "PS Send Pipeline Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 148;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_1__vs_fpu0_active__read;
      counter->name = "VS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 152;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_1__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 156;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_1__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 160;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.slice_mask & 0x2) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__l3_1__l31_bank1_active__read;
         counter->name = "Slice1 L3 Bank1 Active";
         counter->desc = "The percentage of time in which slice1 L3 bank1 is active";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 168;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_1__ps_fpu0_active__read;
      counter->name = "PS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 172;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_1__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 176;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_1__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_1__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 192;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.slice_mask & 0x2) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__l3_1__l31_bank0_active__read;
         counter->name = "Slice1 L3 Bank0 Active";
         counter->desc = "The percentage of time in which slice1 L3 bank0 is active";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 196;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_1__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 200;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_1__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 208;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_1__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_1__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 224;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_1__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 232;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_1__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 240;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_1__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 248;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_1__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 256;
      counter->size = sizeof(uint64_t);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Metric set L3_2 :: GPU Core Clocks */
static uint64_t
chv__l3_2__gpu_core_clocks__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Metric set L3_2 :: EU Active */
static float
chv__l3_2__eu_active__read(struct brw_context *brw,
                           const struct brw_perf_query_info *query,
                           uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_2 :: Slice0 L3 Bank1 Active */
static float
chv__l3_2__l30_bank1_active__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: C 7 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 7];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__l3_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_2 :: EU Both FPU Pipes Active */
static float
chv__l3_2__eu_fpu_both_active__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_2 :: VS Send Pipe Active */
static float
chv__l3_2__vs_send_active__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_2 :: VS FPU1 Pipe Active */
static float
chv__l3_2__vs_fpu1_active__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 11];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_2 :: GS Threads Dispatched */
static uint64_t
chv__l3_2__gs_threads__read(struct brw_context *brw,
                            const struct brw_perf_query_info *query,
                            uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Metric set L3_2 :: Early Hi-Depth Test Fails */
static uint64_t
chv__l3_2__hi_depth_test_fails__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_2 :: FS Both FPU Active */
static float
chv__l3_2__ps_eu_both_fpu_active__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 18];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_2 :: VS Threads Dispatched */
static uint64_t
chv__l3_2__vs_threads__read(struct brw_context *brw,
                            const struct brw_perf_query_info *query,
                            uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Metric set L3_2 :: Slice0 L3 Bank1 Stalled */
static float
chv__l3_2__l30_bank1_stalled__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: B 4 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 4];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__l3_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_2 :: FS Threads Dispatched */
static uint64_t
chv__l3_2__ps_threads__read(struct brw_context *brw,
                            const struct brw_perf_query_info *query,
                            uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Metric set L3_2 :: Shader Barrier Messages */
static uint64_t
chv__l3_2__shader_barriers__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Metric set L3_2 :: Sampler Texels */
static uint64_t
chv__l3_2__sampler_texels__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_2 :: Pixels Failing Tests */
static uint64_t
chv__l3_2__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_2 :: GPU Time Elapsed */
static uint64_t
chv__l3_2__gpu_time__read(struct brw_context *brw,
                          const struct brw_perf_query_info *query,
                          uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_2 :: AVG GPU Core Frequency */
static uint64_t
chv__l3_2__avg_gpu_core_frequency__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = chv__l3_2__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = chv__l3_2__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Metric set L3_2 :: AVG GPU Core Frequency */
static uint64_t
chv__l3_2__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Metric set L3_2 :: Sampler Texels Misses */
static uint64_t
chv__l3_2__sampler_texel_misses__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_2 :: CS Threads Dispatched */
static uint64_t
chv__l3_2__cs_threads__read(struct brw_context *brw,
                            const struct brw_perf_query_info *query,
                            uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Metric set L3_2 :: SLM Bytes Read */
static uint64_t
chv__l3_2__slm_bytes_read__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set L3_2 :: PS FPU1 Pipe Active */
static float
chv__l3_2__ps_fpu1_active__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 16 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 16];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_2 :: PS Send Pipeline Active */
static float
chv__l3_2__ps_send_active__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 17];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_2 :: VS FPU0 Pipe Active */
static float
chv__l3_2__vs_fpu0_active__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 10];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_2 :: GPU Busy */
static float
chv__l3_2__gpu_busy__read(struct brw_context *brw,
                          const struct brw_perf_query_info *query,
                          uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__l3_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_2 :: Slice0 L3 Bank0 Active */
static float
chv__l3_2__l30_bank0_active__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: C 6 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 6];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__l3_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_2 :: Rasterized Pixels */
static uint64_t
chv__l3_2__rasterized_pixels__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_2 :: PS FPU0 Pipe Active */
static float
chv__l3_2__ps_fpu0_active__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 15 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 15];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_2 :: Slice0 L3 Bank0 Stalled */
static float
chv__l3_2__l30_bank0_stalled__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: B 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__l3_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_2 :: DS Threads Dispatched */
static uint64_t
chv__l3_2__ds_threads__read(struct brw_context *brw,
                            const struct brw_perf_query_info *query,
                            uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Metric set L3_2 :: Samples Written */
static uint64_t
chv__l3_2__samples_written__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_2 :: EU Stall */
static float
chv__l3_2__eu_stall__read(struct brw_context *brw,
                          const struct brw_perf_query_info *query,
                          uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_2 :: Samples Blended */
static uint64_t
chv__l3_2__samples_blended__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_2 :: Early Depth Test Fails */
static uint64_t
chv__l3_2__early_depth_test_fails__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_2 :: Shader Memory Accesses */
static uint64_t
chv__l3_2__shader_memory_accesses__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Metric set L3_2 :: HS Threads Dispatched */
static uint64_t
chv__l3_2__hs_threads__read(struct brw_context *brw,
                            const struct brw_perf_query_info *query,
                            uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Metric set L3_2 :: SLM Bytes Written */
static uint64_t
chv__l3_2__slm_bytes_written__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set L3_2 :: L3 Shader Throughput */
static uint64_t
chv__l3_2__l3_shader_throughput__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = chv__l3_2__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Metric set L3_2 :: Samples Killed in FS */
static uint64_t
chv__l3_2__samples_killed_in_ps__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_2 :: Shader Atomic Memory Accesses */
static uint64_t
chv__l3_2__shader_atomics__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

static struct brw_perf_query_counter chv_l3_2_query_counters[39];
static struct brw_perf_query_info chv_l3_2_query = {
   .kind = OA_COUNTERS,
   .name = "Metric set L3_2",
   .guid = "9f2cece5-7bfe-4320-ad66-8c7cc526bec5",
   .counters = chv_l3_2_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
};

static void
register_l3_2_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &chv_l3_2_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_2__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_2__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.slice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__l3_2__l30_bank1_active__read;
         counter->name = "Slice0 L3 Bank1 Active";
         counter->desc = "The percentage of time in which slice0 L3 bank1 is active";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 12;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_2__eu_fpu_both_active__read;
      counter->name = "EU Both FPU Pipes Active";
      counter->desc = "The percentage of time in which both EU FPU pipelines were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 16;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_2__vs_send_active__read;
      counter->name = "VS Send Pipe Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 20;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_2__vs_fpu1_active__read;
      counter->name = "VS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 24;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_2__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_2__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 40;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_2__ps_eu_both_fpu_active__read;
      counter->name = "FS Both FPU Active";
      counter->desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 48;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_2__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 56;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.slice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__l3_2__l30_bank1_stalled__read;
         counter->name = "Slice0 L3 Bank1 Stalled";
         counter->desc = "The percentage of time in which slice0 L3 bank1 is stalled";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 64;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_2__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_2__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_2__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_2__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_2__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 104;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_2__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = chv__l3_2__avg_gpu_core_frequency__max(brw);
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_2__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 120;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_2__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 128;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_2__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 136;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_2__ps_fpu1_active__read;
      counter->name = "PS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 144;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_2__ps_send_active__read;
      counter->name = "PS Send Pipeline Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 148;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_2__vs_fpu0_active__read;
      counter->name = "VS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 152;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_2__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 156;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.slice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__l3_2__l30_bank0_active__read;
         counter->name = "Slice0 L3 Bank0 Active";
         counter->desc = "The percentage of time in which slice0 L3 bank0 is active";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 160;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_2__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 168;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_2__ps_fpu0_active__read;
      counter->name = "PS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 176;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.slice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__l3_2__l30_bank0_stalled__read;
         counter->name = "Slice0 L3 Bank0 Stalled";
         counter->desc = "The percentage of time in which slice0 L3 bank0 is stalled";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 180;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_2__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_2__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 192;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_2__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 200;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_2__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 208;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_2__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_2__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 224;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_2__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 232;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_2__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 240;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_2__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 248;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_2__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 256;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_2__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 264;
      counter->size = sizeof(uint64_t);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Metric set L3_3 :: GPU Core Clocks */
static uint64_t
chv__l3_3__gpu_core_clocks__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Metric set L3_3 :: EU Active */
static float
chv__l3_3__eu_active__read(struct brw_context *brw,
                           const struct brw_perf_query_info *query,
                           uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_3__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_3 :: EU Both FPU Pipes Active */
static float
chv__l3_3__eu_fpu_both_active__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_3__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_3 :: VS Send Pipe Active */
static float
chv__l3_3__vs_send_active__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_3__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_3 :: VS FPU1 Pipe Active */
static float
chv__l3_3__vs_fpu1_active__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 11];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_3__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_3 :: GS Threads Dispatched */
static uint64_t
chv__l3_3__gs_threads__read(struct brw_context *brw,
                            const struct brw_perf_query_info *query,
                            uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Metric set L3_3 :: Early Hi-Depth Test Fails */
static uint64_t
chv__l3_3__hi_depth_test_fails__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_3 :: FS Both FPU Active */
static float
chv__l3_3__ps_eu_both_fpu_active__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 18];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_3__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_3 :: VS Threads Dispatched */
static uint64_t
chv__l3_3__vs_threads__read(struct brw_context *brw,
                            const struct brw_perf_query_info *query,
                            uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Metric set L3_3 :: FS Threads Dispatched */
static uint64_t
chv__l3_3__ps_threads__read(struct brw_context *brw,
                            const struct brw_perf_query_info *query,
                            uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Metric set L3_3 :: Slice0 L3 Bank3 Stalled */
static float
chv__l3_3__l30_bank3_stalled__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: B 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__l3_3__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_3 :: Shader Barrier Messages */
static uint64_t
chv__l3_3__shader_barriers__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Metric set L3_3 :: Sampler Texels */
static uint64_t
chv__l3_3__sampler_texels__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_3 :: Pixels Failing Tests */
static uint64_t
chv__l3_3__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_3 :: GPU Time Elapsed */
static uint64_t
chv__l3_3__gpu_time__read(struct brw_context *brw,
                          const struct brw_perf_query_info *query,
                          uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_3 :: AVG GPU Core Frequency */
static uint64_t
chv__l3_3__avg_gpu_core_frequency__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = chv__l3_3__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = chv__l3_3__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Metric set L3_3 :: AVG GPU Core Frequency */
static uint64_t
chv__l3_3__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Metric set L3_3 :: Sampler Texels Misses */
static uint64_t
chv__l3_3__sampler_texel_misses__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_3 :: CS Threads Dispatched */
static uint64_t
chv__l3_3__cs_threads__read(struct brw_context *brw,
                            const struct brw_perf_query_info *query,
                            uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Metric set L3_3 :: SLM Bytes Read */
static uint64_t
chv__l3_3__slm_bytes_read__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set L3_3 :: PS FPU1 Pipe Active */
static float
chv__l3_3__ps_fpu1_active__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 16 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 16];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_3__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_3 :: Slice0 L3 Bank3 Active */
static float
chv__l3_3__l30_bank3_active__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: C 6 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 6];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__l3_3__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_3 :: PS Send Pipeline Active */
static float
chv__l3_3__ps_send_active__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 17];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_3__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_3 :: VS FPU0 Pipe Active */
static float
chv__l3_3__vs_fpu0_active__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 10];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_3__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_3 :: GPU Busy */
static float
chv__l3_3__gpu_busy__read(struct brw_context *brw,
                          const struct brw_perf_query_info *query,
                          uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__l3_3__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_3 :: Slice1 L3 Bank3 Active */
static float
chv__l3_3__l31_bank3_active__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: C 7 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 7];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__l3_3__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_3 :: Slice1 L3 Bank3 Stalled */
static float
chv__l3_3__l31_bank3_stalled__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: B 4 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 4];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__l3_3__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_3 :: Rasterized Pixels */
static uint64_t
chv__l3_3__rasterized_pixels__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_3 :: PS FPU0 Pipe Active */
static float
chv__l3_3__ps_fpu0_active__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 15 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 15];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_3__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_3 :: DS Threads Dispatched */
static uint64_t
chv__l3_3__ds_threads__read(struct brw_context *brw,
                            const struct brw_perf_query_info *query,
                            uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Metric set L3_3 :: Samples Written */
static uint64_t
chv__l3_3__samples_written__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_3 :: EU Stall */
static float
chv__l3_3__eu_stall__read(struct brw_context *brw,
                          const struct brw_perf_query_info *query,
                          uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_3__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_3 :: Samples Blended */
static uint64_t
chv__l3_3__samples_blended__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_3 :: Early Depth Test Fails */
static uint64_t
chv__l3_3__early_depth_test_fails__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_3 :: Shader Memory Accesses */
static uint64_t
chv__l3_3__shader_memory_accesses__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Metric set L3_3 :: HS Threads Dispatched */
static uint64_t
chv__l3_3__hs_threads__read(struct brw_context *brw,
                            const struct brw_perf_query_info *query,
                            uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Metric set L3_3 :: SLM Bytes Written */
static uint64_t
chv__l3_3__slm_bytes_written__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set L3_3 :: L3 Shader Throughput */
static uint64_t
chv__l3_3__l3_shader_throughput__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = chv__l3_3__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Metric set L3_3 :: Samples Killed in FS */
static uint64_t
chv__l3_3__samples_killed_in_ps__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_3 :: Shader Atomic Memory Accesses */
static uint64_t
chv__l3_3__shader_atomics__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

static struct brw_perf_query_counter chv_l3_3_query_counters[39];
static struct brw_perf_query_info chv_l3_3_query = {
   .kind = OA_COUNTERS,
   .name = "Metric set L3_3",
   .guid = "d890ef38-d309-47e4-b8b5-aa779bb19ab0",
   .counters = chv_l3_3_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
};

static void
register_l3_3_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &chv_l3_3_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_3__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_3__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_3__eu_fpu_both_active__read;
      counter->name = "EU Both FPU Pipes Active";
      counter->desc = "The percentage of time in which both EU FPU pipelines were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 12;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_3__vs_send_active__read;
      counter->name = "VS Send Pipe Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 16;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_3__vs_fpu1_active__read;
      counter->name = "VS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 20;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_3__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 24;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_3__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_3__ps_eu_both_fpu_active__read;
      counter->name = "FS Both FPU Active";
      counter->desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 40;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_3__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 48;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_3__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 56;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.slice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__l3_3__l30_bank3_stalled__read;
         counter->name = "Slice0 L3 Bank3 Stalled";
         counter->desc = "The percentage of time in which slice0 L3 bank3 is stalled";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 64;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_3__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_3__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_3__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_3__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_3__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = chv__l3_3__avg_gpu_core_frequency__max(brw);
      counter->offset = 104;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_3__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_3__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 120;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_3__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 128;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_3__ps_fpu1_active__read;
      counter->name = "PS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 136;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.slice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__l3_3__l30_bank3_active__read;
         counter->name = "Slice0 L3 Bank3 Active";
         counter->desc = "The percentage of time in which slice0 L3 bank3 is active";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 140;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_3__ps_send_active__read;
      counter->name = "PS Send Pipeline Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 144;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_3__vs_fpu0_active__read;
      counter->name = "VS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 148;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_3__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 152;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.slice_mask & 0x2) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__l3_3__l31_bank3_active__read;
         counter->name = "Slice1 L3 Bank3 Active";
         counter->desc = "The percentage of time in which slice1 L3 bank3 is active";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 156;
         counter->size = sizeof(float);
      }

      if (brw->perfquery.sys_vars.slice_mask & 0x2) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__l3_3__l31_bank3_stalled__read;
         counter->name = "Slice1 L3 Bank3 Stalled";
         counter->desc = "The percentage of time in which slice1 L3 bank3 is stalled";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 160;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_3__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 168;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_3__ps_fpu0_active__read;
      counter->name = "PS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 176;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_3__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_3__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 192;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_3__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 200;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_3__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 208;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_3__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_3__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 224;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_3__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 232;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_3__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 240;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_3__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 248;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_3__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 256;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_3__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 264;
      counter->size = sizeof(uint64_t);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Metric set L3_4 :: GPU Core Clocks */
static uint64_t
chv__l3_4__gpu_core_clocks__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Metric set L3_4 :: EU Active */
static float
chv__l3_4__eu_active__read(struct brw_context *brw,
                           const struct brw_perf_query_info *query,
                           uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_4__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_4 :: EU Both FPU Pipes Active */
static float
chv__l3_4__eu_fpu_both_active__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_4__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_4 :: VS Send Pipe Active */
static float
chv__l3_4__vs_send_active__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_4__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_4 :: VS FPU1 Pipe Active */
static float
chv__l3_4__vs_fpu1_active__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 11];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_4__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_4 :: GS Threads Dispatched */
static uint64_t
chv__l3_4__gs_threads__read(struct brw_context *brw,
                            const struct brw_perf_query_info *query,
                            uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Metric set L3_4 :: Early Hi-Depth Test Fails */
static uint64_t
chv__l3_4__hi_depth_test_fails__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_4 :: FS Both FPU Active */
static float
chv__l3_4__ps_eu_both_fpu_active__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 18];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_4__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_4 :: VS Threads Dispatched */
static uint64_t
chv__l3_4__vs_threads__read(struct brw_context *brw,
                            const struct brw_perf_query_info *query,
                            uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Metric set L3_4 :: FS Threads Dispatched */
static uint64_t
chv__l3_4__ps_threads__read(struct brw_context *brw,
                            const struct brw_perf_query_info *query,
                            uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Metric set L3_4 :: Shader Barrier Messages */
static uint64_t
chv__l3_4__shader_barriers__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Metric set L3_4 :: Sampler Texels */
static uint64_t
chv__l3_4__sampler_texels__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_4 :: Pixels Failing Tests */
static uint64_t
chv__l3_4__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_4 :: GPU Time Elapsed */
static uint64_t
chv__l3_4__gpu_time__read(struct brw_context *brw,
                          const struct brw_perf_query_info *query,
                          uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_4 :: AVG GPU Core Frequency */
static uint64_t
chv__l3_4__avg_gpu_core_frequency__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = chv__l3_4__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = chv__l3_4__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Metric set L3_4 :: AVG GPU Core Frequency */
static uint64_t
chv__l3_4__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Metric set L3_4 :: Sampler Texels Misses */
static uint64_t
chv__l3_4__sampler_texel_misses__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_4 :: CS Threads Dispatched */
static uint64_t
chv__l3_4__cs_threads__read(struct brw_context *brw,
                            const struct brw_perf_query_info *query,
                            uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Metric set L3_4 :: SLM Bytes Read */
static uint64_t
chv__l3_4__slm_bytes_read__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set L3_4 :: PS FPU1 Pipe Active */
static float
chv__l3_4__ps_fpu1_active__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 16 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 16];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_4__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_4 :: Slice0 L3 Bank2 Stalled */
static float
chv__l3_4__l30_bank2_stalled__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: B 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__l3_4__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_4 :: PS Send Pipeline Active */
static float
chv__l3_4__ps_send_active__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 17];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_4__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_4 :: VS FPU0 Pipe Active */
static float
chv__l3_4__vs_fpu0_active__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 10];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_4__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_4 :: GPU Busy */
static float
chv__l3_4__gpu_busy__read(struct brw_context *brw,
                          const struct brw_perf_query_info *query,
                          uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__l3_4__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_4 :: Slice1 L3 Bank2 Active */
static float
chv__l3_4__l31_bank2_active__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: C 7 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 7];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__l3_4__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_4 :: Slice0 L3 Bank2 Active */
static float
chv__l3_4__l30_bank2_active__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: C 6 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 6];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__l3_4__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_4 :: Rasterized Pixels */
static uint64_t
chv__l3_4__rasterized_pixels__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_4 :: Slice1 L3 Bank2 Stalled */
static float
chv__l3_4__l31_bank2_stalled__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: B 4 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 4];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__l3_4__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_4 :: PS FPU0 Pipe Active */
static float
chv__l3_4__ps_fpu0_active__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 15 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 15];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_4__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_4 :: DS Threads Dispatched */
static uint64_t
chv__l3_4__ds_threads__read(struct brw_context *brw,
                            const struct brw_perf_query_info *query,
                            uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Metric set L3_4 :: Samples Written */
static uint64_t
chv__l3_4__samples_written__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_4 :: EU Stall */
static float
chv__l3_4__eu_stall__read(struct brw_context *brw,
                          const struct brw_perf_query_info *query,
                          uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__l3_4__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_4 :: Samples Blended */
static uint64_t
chv__l3_4__samples_blended__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_4 :: Early Depth Test Fails */
static uint64_t
chv__l3_4__early_depth_test_fails__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_4 :: Shader Memory Accesses */
static uint64_t
chv__l3_4__shader_memory_accesses__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Metric set L3_4 :: HS Threads Dispatched */
static uint64_t
chv__l3_4__hs_threads__read(struct brw_context *brw,
                            const struct brw_perf_query_info *query,
                            uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Metric set L3_4 :: SLM Bytes Written */
static uint64_t
chv__l3_4__slm_bytes_written__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set L3_4 :: L3 Shader Throughput */
static uint64_t
chv__l3_4__l3_shader_throughput__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = chv__l3_4__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Metric set L3_4 :: Samples Killed in FS */
static uint64_t
chv__l3_4__samples_killed_in_ps__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_4 :: Shader Atomic Memory Accesses */
static uint64_t
chv__l3_4__shader_atomics__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

static struct brw_perf_query_counter chv_l3_4_query_counters[39];
static struct brw_perf_query_info chv_l3_4_query = {
   .kind = OA_COUNTERS,
   .name = "Metric set L3_4",
   .guid = "5fdff4a6-9dc8-45e1-bfda-ef54869fbdd4",
   .counters = chv_l3_4_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
};

static void
register_l3_4_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &chv_l3_4_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_4__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_4__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_4__eu_fpu_both_active__read;
      counter->name = "EU Both FPU Pipes Active";
      counter->desc = "The percentage of time in which both EU FPU pipelines were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 12;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_4__vs_send_active__read;
      counter->name = "VS Send Pipe Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 16;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_4__vs_fpu1_active__read;
      counter->name = "VS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 20;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_4__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 24;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_4__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_4__ps_eu_both_fpu_active__read;
      counter->name = "FS Both FPU Active";
      counter->desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 40;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_4__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 48;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_4__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 56;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_4__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 64;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_4__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_4__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_4__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_4__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = chv__l3_4__avg_gpu_core_frequency__max(brw);
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_4__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 104;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_4__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_4__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 120;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_4__ps_fpu1_active__read;
      counter->name = "PS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 128;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.slice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__l3_4__l30_bank2_stalled__read;
         counter->name = "Slice0 L3 Bank2 Stalled";
         counter->desc = "The percentage of time in which slice0 L3 bank2 is stalled";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 132;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_4__ps_send_active__read;
      counter->name = "PS Send Pipeline Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 136;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_4__vs_fpu0_active__read;
      counter->name = "VS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 140;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_4__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 144;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.slice_mask & 0x2) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__l3_4__l31_bank2_active__read;
         counter->name = "Slice1 L3 Bank2 Active";
         counter->desc = "The percentage of time in which slice1 L3 bank2 is active";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 148;
         counter->size = sizeof(float);
      }

      if (brw->perfquery.sys_vars.slice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__l3_4__l30_bank2_active__read;
         counter->name = "Slice0 L3 Bank2 Active";
         counter->desc = "The percentage of time in which slice0 L3 bank2 is active";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 152;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_4__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 160;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.slice_mask & 0x2) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__l3_4__l31_bank2_stalled__read;
         counter->name = "Slice1 L3 Bank2 Stalled";
         counter->desc = "The percentage of time in which slice1 L3 bank2 is stalled";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 168;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_4__ps_fpu0_active__read;
      counter->name = "PS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 172;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_4__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 176;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_4__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__l3_4__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 192;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_4__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 200;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_4__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 208;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_4__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_4__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 224;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_4__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 232;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_4__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 240;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_4__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 248;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__l3_4__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 256;
      counter->size = sizeof(uint64_t);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Metric set RasterizerAndPixelBackend :: GPU Core Clocks */
static uint64_t
chv__rasterizer_and_pixel_backend__gpu_core_clocks__read(struct brw_context *brw,
                                                         const struct brw_perf_query_info *query,
                                                         uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Metric set RasterizerAndPixelBackend :: EU Active */
static float
chv__rasterizer_and_pixel_backend__eu_active__read(struct brw_context *brw,
                                                   const struct brw_perf_query_info *query,
                                                   uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set RasterizerAndPixelBackend :: EU Both FPU Pipes Active */
static float
chv__rasterizer_and_pixel_backend__eu_fpu_both_active__read(struct brw_context *brw,
                                                            const struct brw_perf_query_info *query,
                                                            uint64_t *accumulator)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set RasterizerAndPixelBackend :: Slice1 Rasterizer Input Available */
static float
chv__rasterizer_and_pixel_backend__rasterizer1_input_available__read(struct brw_context *brw,
                                                                     const struct brw_perf_query_info *query,
                                                                     uint64_t *accumulator)
{
   /* RPN equation: B 3 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 3];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set RasterizerAndPixelBackend :: VS Send Pipe Active */
static float
chv__rasterizer_and_pixel_backend__vs_send_active__read(struct brw_context *brw,
                                                        const struct brw_perf_query_info *query,
                                                        uint64_t *accumulator)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set RasterizerAndPixelBackend :: VS FPU1 Pipe Active */
static float
chv__rasterizer_and_pixel_backend__vs_fpu1_active__read(struct brw_context *brw,
                                                        const struct brw_perf_query_info *query,
                                                        uint64_t *accumulator)
{
   /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 11];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set RasterizerAndPixelBackend :: GS Threads Dispatched */
static uint64_t
chv__rasterizer_and_pixel_backend__gs_threads__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Metric set RasterizerAndPixelBackend :: Early Hi-Depth Test Fails */
static uint64_t
chv__rasterizer_and_pixel_backend__hi_depth_test_fails__read(struct brw_context *brw,
                                                             const struct brw_perf_query_info *query,
                                                             uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set RasterizerAndPixelBackend :: FS Both FPU Active */
static float
chv__rasterizer_and_pixel_backend__ps_eu_both_fpu_active__read(struct brw_context *brw,
                                                               const struct brw_perf_query_info *query,
                                                               uint64_t *accumulator)
{
   /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 18];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set RasterizerAndPixelBackend :: VS Threads Dispatched */
static uint64_t
chv__rasterizer_and_pixel_backend__vs_threads__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Metric set RasterizerAndPixelBackend :: FS Threads Dispatched */
static uint64_t
chv__rasterizer_and_pixel_backend__ps_threads__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Metric set RasterizerAndPixelBackend :: Slice0 Pixel Values Ready */
static float
chv__rasterizer_and_pixel_backend__pixel_values0_ready__read(struct brw_context *brw,
                                                             const struct brw_perf_query_info *query,
                                                             uint64_t *accumulator)
{
   /* RPN equation: C 7 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 7];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set RasterizerAndPixelBackend :: Shader Barrier Messages */
static uint64_t
chv__rasterizer_and_pixel_backend__shader_barriers__read(struct brw_context *brw,
                                                         const struct brw_perf_query_info *query,
                                                         uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Metric set RasterizerAndPixelBackend :: Sampler Texels */
static uint64_t
chv__rasterizer_and_pixel_backend__sampler_texels__read(struct brw_context *brw,
                                                        const struct brw_perf_query_info *query,
                                                        uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set RasterizerAndPixelBackend :: Pixels Failing Tests */
static uint64_t
chv__rasterizer_and_pixel_backend__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                                                      const struct brw_perf_query_info *query,
                                                                      uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set RasterizerAndPixelBackend :: GPU Time Elapsed */
static uint64_t
chv__rasterizer_and_pixel_backend__gpu_time__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set RasterizerAndPixelBackend :: AVG GPU Core Frequency */
static uint64_t
chv__rasterizer_and_pixel_backend__avg_gpu_core_frequency__read(struct brw_context *brw,
                                                                const struct brw_perf_query_info *query,
                                                                uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = chv__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = chv__rasterizer_and_pixel_backend__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Metric set RasterizerAndPixelBackend :: AVG GPU Core Frequency */
static uint64_t
chv__rasterizer_and_pixel_backend__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Metric set RasterizerAndPixelBackend :: Sampler Texels Misses */
static uint64_t
chv__rasterizer_and_pixel_backend__sampler_texel_misses__read(struct brw_context *brw,
                                                              const struct brw_perf_query_info *query,
                                                              uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set RasterizerAndPixelBackend :: CS Threads Dispatched */
static uint64_t
chv__rasterizer_and_pixel_backend__cs_threads__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Metric set RasterizerAndPixelBackend :: Slice0 Rasterizer Input Available */
static float
chv__rasterizer_and_pixel_backend__rasterizer0_input_available__read(struct brw_context *brw,
                                                                     const struct brw_perf_query_info *query,
                                                                     uint64_t *accumulator)
{
   /* RPN equation: B 5 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 5];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set RasterizerAndPixelBackend :: Slice0 Post-EarlyZ Pixel Data Ready */
static float
chv__rasterizer_and_pixel_backend__pixel_data0_ready__read(struct brw_context *brw,
                                                           const struct brw_perf_query_info *query,
                                                           uint64_t *accumulator)
{
   /* RPN equation: B 2 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 2];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set RasterizerAndPixelBackend :: SLM Bytes Read */
static uint64_t
chv__rasterizer_and_pixel_backend__slm_bytes_read__read(struct brw_context *brw,
                                                        const struct brw_perf_query_info *query,
                                                        uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set RasterizerAndPixelBackend :: PS FPU1 Pipe Active */
static float
chv__rasterizer_and_pixel_backend__ps_fpu1_active__read(struct brw_context *brw,
                                                        const struct brw_perf_query_info *query,
                                                        uint64_t *accumulator)
{
   /* RPN equation: A 16 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 16];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set RasterizerAndPixelBackend :: PS Send Pipeline Active */
static float
chv__rasterizer_and_pixel_backend__ps_send_active__read(struct brw_context *brw,
                                                        const struct brw_perf_query_info *query,
                                                        uint64_t *accumulator)
{
   /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 17];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set RasterizerAndPixelBackend :: VS FPU0 Pipe Active */
static float
chv__rasterizer_and_pixel_backend__vs_fpu0_active__read(struct brw_context *brw,
                                                        const struct brw_perf_query_info *query,
                                                        uint64_t *accumulator)
{
   /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 10];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set RasterizerAndPixelBackend :: GPU Busy */
static float
chv__rasterizer_and_pixel_backend__gpu_busy__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set RasterizerAndPixelBackend :: Slice1 Pixel Values Ready */
static float
chv__rasterizer_and_pixel_backend__pixel_values1_ready__read(struct brw_context *brw,
                                                             const struct brw_perf_query_info *query,
                                                             uint64_t *accumulator)
{
   /* RPN equation: C 5 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 5];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set RasterizerAndPixelBackend :: Slice1 PS Output Available */
static float
chv__rasterizer_and_pixel_backend__ps_output1_available__read(struct brw_context *brw,
                                                              const struct brw_perf_query_info *query,
                                                              uint64_t *accumulator)
{
   /* RPN equation: C 4 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 4];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set RasterizerAndPixelBackend :: Rasterized Pixels */
static uint64_t
chv__rasterizer_and_pixel_backend__rasterized_pixels__read(struct brw_context *brw,
                                                           const struct brw_perf_query_info *query,
                                                           uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set RasterizerAndPixelBackend :: PS FPU0 Pipe Active */
static float
chv__rasterizer_and_pixel_backend__ps_fpu0_active__read(struct brw_context *brw,
                                                        const struct brw_perf_query_info *query,
                                                        uint64_t *accumulator)
{
   /* RPN equation: A 15 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 15];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set RasterizerAndPixelBackend :: DS Threads Dispatched */
static uint64_t
chv__rasterizer_and_pixel_backend__ds_threads__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Metric set RasterizerAndPixelBackend :: Samples Written */
static uint64_t
chv__rasterizer_and_pixel_backend__samples_written__read(struct brw_context *brw,
                                                         const struct brw_perf_query_info *query,
                                                         uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set RasterizerAndPixelBackend :: EU Stall */
static float
chv__rasterizer_and_pixel_backend__eu_stall__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set RasterizerAndPixelBackend :: Slice0 Rasterizer Output Ready */
static float
chv__rasterizer_and_pixel_backend__rasterizer0_output_ready__read(struct brw_context *brw,
                                                                  const struct brw_perf_query_info *query,
                                                                  uint64_t *accumulator)
{
   /* RPN equation: B 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set RasterizerAndPixelBackend :: Samples Blended */
static uint64_t
chv__rasterizer_and_pixel_backend__samples_blended__read(struct brw_context *brw,
                                                         const struct brw_perf_query_info *query,
                                                         uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set RasterizerAndPixelBackend :: Early Depth Test Fails */
static uint64_t
chv__rasterizer_and_pixel_backend__early_depth_test_fails__read(struct brw_context *brw,
                                                                const struct brw_perf_query_info *query,
                                                                uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set RasterizerAndPixelBackend :: Slice1 Rasterizer Output Ready */
static float
chv__rasterizer_and_pixel_backend__rasterizer1_output_ready__read(struct brw_context *brw,
                                                                  const struct brw_perf_query_info *query,
                                                                  uint64_t *accumulator)
{
   /* RPN equation: B 4 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 4];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set RasterizerAndPixelBackend :: Slice1 Post-EarlyZ Pixel Data Ready */
static float
chv__rasterizer_and_pixel_backend__pixel_data1_ready__read(struct brw_context *brw,
                                                           const struct brw_perf_query_info *query,
                                                           uint64_t *accumulator)
{
   /* RPN equation: B 1 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 1];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set RasterizerAndPixelBackend :: Shader Memory Accesses */
static uint64_t
chv__rasterizer_and_pixel_backend__shader_memory_accesses__read(struct brw_context *brw,
                                                                const struct brw_perf_query_info *query,
                                                                uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Metric set RasterizerAndPixelBackend :: HS Threads Dispatched */
static uint64_t
chv__rasterizer_and_pixel_backend__hs_threads__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Metric set RasterizerAndPixelBackend :: SLM Bytes Written */
static uint64_t
chv__rasterizer_and_pixel_backend__slm_bytes_written__read(struct brw_context *brw,
                                                           const struct brw_perf_query_info *query,
                                                           uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set RasterizerAndPixelBackend :: L3 Shader Throughput */
static uint64_t
chv__rasterizer_and_pixel_backend__l3_shader_throughput__read(struct brw_context *brw,
                                                              const struct brw_perf_query_info *query,
                                                              uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = chv__rasterizer_and_pixel_backend__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Metric set RasterizerAndPixelBackend :: Samples Killed in FS */
static uint64_t
chv__rasterizer_and_pixel_backend__samples_killed_in_ps__read(struct brw_context *brw,
                                                              const struct brw_perf_query_info *query,
                                                              uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set RasterizerAndPixelBackend :: Slice0 PS Output Available */
static float
chv__rasterizer_and_pixel_backend__ps_output0_available__read(struct brw_context *brw,
                                                              const struct brw_perf_query_info *query,
                                                              uint64_t *accumulator)
{
   /* RPN equation: C 6 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 6];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set RasterizerAndPixelBackend :: Shader Atomic Memory Accesses */
static uint64_t
chv__rasterizer_and_pixel_backend__shader_atomics__read(struct brw_context *brw,
                                                        const struct brw_perf_query_info *query,
                                                        uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

static struct brw_perf_query_counter chv_rasterizer_and_pixel_backend_query_counters[45];
static struct brw_perf_query_info chv_rasterizer_and_pixel_backend_query = {
   .kind = OA_COUNTERS,
   .name = "Metric set RasterizerAndPixelBackend",
   .guid = "2c0e45e1-7e2c-4a14-ae00-0b7ec868b8aa",
   .counters = chv_rasterizer_and_pixel_backend_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
};

static void
register_rasterizer_and_pixel_backend_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &chv_rasterizer_and_pixel_backend_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__rasterizer_and_pixel_backend__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__rasterizer_and_pixel_backend__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__rasterizer_and_pixel_backend__eu_fpu_both_active__read;
      counter->name = "EU Both FPU Pipes Active";
      counter->desc = "The percentage of time in which both EU FPU pipelines were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 12;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.slice_mask & 0x2) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__rasterizer_and_pixel_backend__rasterizer1_input_available__read;
         counter->name = "Slice1 Rasterizer Input Available";
         counter->desc = "The percentage of time in which slice1 rasterizer input is available";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 16;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__rasterizer_and_pixel_backend__vs_send_active__read;
      counter->name = "VS Send Pipe Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 20;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__rasterizer_and_pixel_backend__vs_fpu1_active__read;
      counter->name = "VS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 24;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__rasterizer_and_pixel_backend__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__rasterizer_and_pixel_backend__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 40;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__rasterizer_and_pixel_backend__ps_eu_both_fpu_active__read;
      counter->name = "FS Both FPU Active";
      counter->desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 48;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__rasterizer_and_pixel_backend__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 56;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__rasterizer_and_pixel_backend__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 64;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.slice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__rasterizer_and_pixel_backend__pixel_values0_ready__read;
         counter->name = "Slice0 Pixel Values Ready";
         counter->desc = "The percentage of time in which slice0 pixel values are ready";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 72;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__rasterizer_and_pixel_backend__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__rasterizer_and_pixel_backend__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__rasterizer_and_pixel_backend__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__rasterizer_and_pixel_backend__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 104;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__rasterizer_and_pixel_backend__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = chv__rasterizer_and_pixel_backend__avg_gpu_core_frequency__max(brw);
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__rasterizer_and_pixel_backend__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 120;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__rasterizer_and_pixel_backend__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 128;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.slice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__rasterizer_and_pixel_backend__rasterizer0_input_available__read;
         counter->name = "Slice0 Rasterizer Input Available";
         counter->desc = "The percentage of time in which slice0 rasterizer input is available";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 136;
         counter->size = sizeof(float);
      }

      if (brw->perfquery.sys_vars.slice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__rasterizer_and_pixel_backend__pixel_data0_ready__read;
         counter->name = "Slice0 Post-EarlyZ Pixel Data Ready";
         counter->desc = "The percentage of time in which slice0 post-EarlyZ pixel data is ready (after early Z tests have been applied))";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 140;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__rasterizer_and_pixel_backend__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 144;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__rasterizer_and_pixel_backend__ps_fpu1_active__read;
      counter->name = "PS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 152;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__rasterizer_and_pixel_backend__ps_send_active__read;
      counter->name = "PS Send Pipeline Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 156;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__rasterizer_and_pixel_backend__vs_fpu0_active__read;
      counter->name = "VS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 160;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__rasterizer_and_pixel_backend__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 164;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.slice_mask & 0x2) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__rasterizer_and_pixel_backend__pixel_values1_ready__read;
         counter->name = "Slice1 Pixel Values Ready";
         counter->desc = "The percentage of time in which slice1 pixel values are ready";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 168;
         counter->size = sizeof(float);
      }

      if (brw->perfquery.sys_vars.slice_mask & 0x2) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__rasterizer_and_pixel_backend__ps_output1_available__read;
         counter->name = "Slice1 PS Output Available";
         counter->desc = "The percentage of time in which slice1 PS output is available";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 172;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__rasterizer_and_pixel_backend__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 176;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__rasterizer_and_pixel_backend__ps_fpu0_active__read;
      counter->name = "PS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 184;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__rasterizer_and_pixel_backend__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 192;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__rasterizer_and_pixel_backend__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 200;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__rasterizer_and_pixel_backend__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 208;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.slice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__rasterizer_and_pixel_backend__rasterizer0_output_ready__read;
         counter->name = "Slice0 Rasterizer Output Ready";
         counter->desc = "The percentage of time in which slice0 rasterizer output is ready";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 212;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__rasterizer_and_pixel_backend__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__rasterizer_and_pixel_backend__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 224;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.slice_mask & 0x2) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__rasterizer_and_pixel_backend__rasterizer1_output_ready__read;
         counter->name = "Slice1 Rasterizer Output Ready";
         counter->desc = "The percentage of time in which slice1 rasterizer output is ready";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 232;
         counter->size = sizeof(float);
      }

      if (brw->perfquery.sys_vars.slice_mask & 0x2) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__rasterizer_and_pixel_backend__pixel_data1_ready__read;
         counter->name = "Slice1 Post-EarlyZ Pixel Data Ready";
         counter->desc = "The percentage of time in which slice1 post-EarlyZ pixel data is ready (after early Z tests have been applied)";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 236;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__rasterizer_and_pixel_backend__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 240;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__rasterizer_and_pixel_backend__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 248;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__rasterizer_and_pixel_backend__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 256;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__rasterizer_and_pixel_backend__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 264;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__rasterizer_and_pixel_backend__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 272;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.slice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__rasterizer_and_pixel_backend__ps_output0_available__read;
         counter->name = "Slice0 PS Output Available";
         counter->desc = "The percentage of time in which slice0 PS output is available";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 280;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__rasterizer_and_pixel_backend__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 288;
      counter->size = sizeof(uint64_t);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Metric set Sampler_1 :: GPU Core Clocks */
static uint64_t
chv__sampler_1__gpu_core_clocks__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Metric set Sampler_1 :: EU Active */
static float
chv__sampler_1__eu_active__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__sampler_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler_1 :: EU Both FPU Pipes Active */
static float
chv__sampler_1__eu_fpu_both_active__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__sampler_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler_1 :: VS Send Pipe Active */
static float
chv__sampler_1__vs_send_active__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__sampler_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler_1 :: VS FPU1 Pipe Active */
static float
chv__sampler_1__vs_fpu1_active__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 11];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__sampler_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler_1 :: GS Threads Dispatched */
static uint64_t
chv__sampler_1__gs_threads__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Metric set Sampler_1 :: Slice1 Subslice0 Input Available */
static float
chv__sampler_1__sampler10_input_available__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: B 2 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 2];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__sampler_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set Sampler_1 :: Early Hi-Depth Test Fails */
static uint64_t
chv__sampler_1__hi_depth_test_fails__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler_1 :: FS Both FPU Active */
static float
chv__sampler_1__ps_eu_both_fpu_active__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 18];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__sampler_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler_1 :: VS Threads Dispatched */
static uint64_t
chv__sampler_1__vs_threads__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Metric set Sampler_1 :: FS Threads Dispatched */
static uint64_t
chv__sampler_1__ps_threads__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Metric set Sampler_1 :: Shader Barrier Messages */
static uint64_t
chv__sampler_1__shader_barriers__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Metric set Sampler_1 :: Sampler Texels */
static uint64_t
chv__sampler_1__sampler_texels__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler_1 :: Pixels Failing Tests */
static uint64_t
chv__sampler_1__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                                   const struct brw_perf_query_info *query,
                                                   uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler_1 :: Slice1 Subslice2 Sampler Output Ready */
static float
chv__sampler_1__sampler12_output_ready__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: C 7 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 7];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__sampler_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set Sampler_1 :: GPU Time Elapsed */
static uint64_t
chv__sampler_1__gpu_time__read(struct brw_context *brw,
                               const struct brw_perf_query_info *query,
                               uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set Sampler_1 :: AVG GPU Core Frequency */
static uint64_t
chv__sampler_1__avg_gpu_core_frequency__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = chv__sampler_1__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = chv__sampler_1__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Metric set Sampler_1 :: AVG GPU Core Frequency */
static uint64_t
chv__sampler_1__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Metric set Sampler_1 :: Sampler Texels Misses */
static uint64_t
chv__sampler_1__sampler_texel_misses__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler_1 :: CS Threads Dispatched */
static uint64_t
chv__sampler_1__cs_threads__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Metric set Sampler_1 :: SLM Bytes Read */
static uint64_t
chv__sampler_1__slm_bytes_read__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set Sampler_1 :: PS FPU1 Pipe Active */
static float
chv__sampler_1__ps_fpu1_active__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 16 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 16];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__sampler_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler_1 :: PS Send Pipeline Active */
static float
chv__sampler_1__ps_send_active__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 17];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__sampler_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler_1 :: VS FPU0 Pipe Active */
static float
chv__sampler_1__vs_fpu0_active__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 10];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__sampler_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler_1 :: GPU Busy */
static float
chv__sampler_1__gpu_busy__read(struct brw_context *brw,
                               const struct brw_perf_query_info *query,
                               uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__sampler_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set Sampler_1 :: Slice1 Subslice1 Input Available */
static float
chv__sampler_1__sampler11_input_available__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: B 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__sampler_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set Sampler_1 :: Rasterized Pixels */
static uint64_t
chv__sampler_1__rasterized_pixels__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler_1 :: PS FPU0 Pipe Active */
static float
chv__sampler_1__ps_fpu0_active__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 15 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 15];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__sampler_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler_1 :: DS Threads Dispatched */
static uint64_t
chv__sampler_1__ds_threads__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Metric set Sampler_1 :: Samples Written */
static uint64_t
chv__sampler_1__samples_written__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler_1 :: EU Stall */
static float
chv__sampler_1__eu_stall__read(struct brw_context *brw,
                               const struct brw_perf_query_info *query,
                               uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__sampler_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler_1 :: Samples Blended */
static uint64_t
chv__sampler_1__samples_blended__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler_1 :: Early Depth Test Fails */
static uint64_t
chv__sampler_1__early_depth_test_fails__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler_1 :: Slice1 Subslice2 Input Available */
static float
chv__sampler_1__sampler12_input_available__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: B 1 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 1];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__sampler_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set Sampler_1 :: Slice1 Subslice0 Sampler Output Ready */
static float
chv__sampler_1__sampler10_output_ready__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: C 6 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 6];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__sampler_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set Sampler_1 :: Shader Memory Accesses */
static uint64_t
chv__sampler_1__shader_memory_accesses__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Metric set Sampler_1 :: Slice1 Subslice1 Sampler Output Ready */
static float
chv__sampler_1__sampler11_output_ready__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: C 5 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 5];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__sampler_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set Sampler_1 :: HS Threads Dispatched */
static uint64_t
chv__sampler_1__hs_threads__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Metric set Sampler_1 :: SLM Bytes Written */
static uint64_t
chv__sampler_1__slm_bytes_written__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set Sampler_1 :: L3 Shader Throughput */
static uint64_t
chv__sampler_1__l3_shader_throughput__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = chv__sampler_1__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Metric set Sampler_1 :: Samples Killed in FS */
static uint64_t
chv__sampler_1__samples_killed_in_ps__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler_1 :: Shader Atomic Memory Accesses */
static uint64_t
chv__sampler_1__shader_atomics__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

static struct brw_perf_query_counter chv_sampler_1_query_counters[41];
static struct brw_perf_query_info chv_sampler_1_query = {
   .kind = OA_COUNTERS,
   .name = "Metric set Sampler_1",
   .guid = "71148d78-baf5-474f-878a-e23158d0265d",
   .counters = chv_sampler_1_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
};

static void
register_sampler_1_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &chv_sampler_1_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_1__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__sampler_1__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__sampler_1__eu_fpu_both_active__read;
      counter->name = "EU Both FPU Pipes Active";
      counter->desc = "The percentage of time in which both EU FPU pipelines were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 12;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__sampler_1__vs_send_active__read;
      counter->name = "VS Send Pipe Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 16;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__sampler_1__vs_fpu1_active__read;
      counter->name = "VS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 20;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_1__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 24;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x8) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__sampler_1__sampler10_input_available__read;
         counter->name = "Slice1 Subslice0 Input Available";
         counter->desc = "The percentage of time in which slice1 subslice0 sampler input is available";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 32;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_1__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 40;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__sampler_1__ps_eu_both_fpu_active__read;
      counter->name = "FS Both FPU Active";
      counter->desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 48;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_1__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 56;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_1__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 64;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_1__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_1__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_1__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x20) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__sampler_1__sampler12_output_ready__read;
         counter->name = "Slice1 Subslice2 Sampler Output Ready";
         counter->desc = "The percentage of time in which slice1 subslice2 sampler output is ready";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 96;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_1__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 104;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_1__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = chv__sampler_1__avg_gpu_core_frequency__max(brw);
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_1__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 120;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_1__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 128;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_1__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 136;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__sampler_1__ps_fpu1_active__read;
      counter->name = "PS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 144;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__sampler_1__ps_send_active__read;
      counter->name = "PS Send Pipeline Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 148;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__sampler_1__vs_fpu0_active__read;
      counter->name = "VS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 152;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__sampler_1__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 156;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.subslice_mask & 0x10) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__sampler_1__sampler11_input_available__read;
         counter->name = "Slice1 Subslice1 Input Available";
         counter->desc = "The percentage of time in which slice1 subslice1 sampler input is available";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 160;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_1__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 168;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__sampler_1__ps_fpu0_active__read;
      counter->name = "PS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 176;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_1__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_1__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 192;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__sampler_1__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 200;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_1__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 208;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_1__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x20) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__sampler_1__sampler12_input_available__read;
         counter->name = "Slice1 Subslice2 Input Available";
         counter->desc = "The percentage of time in which slice1 subslice2 sampler input is available";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 224;
         counter->size = sizeof(float);
      }

      if (brw->perfquery.sys_vars.subslice_mask & 0x8) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__sampler_1__sampler10_output_ready__read;
         counter->name = "Slice1 Subslice0 Sampler Output Ready";
         counter->desc = "The percentage of time in which slice1 subslice0 sampler output is ready";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 228;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_1__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 232;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x10) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__sampler_1__sampler11_output_ready__read;
         counter->name = "Slice1 Subslice1 Sampler Output Ready";
         counter->desc = "The percentage of time in which slice1 subslice1 sampler output is ready";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 240;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_1__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 248;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_1__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 256;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_1__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 264;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_1__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 272;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_1__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 280;
      counter->size = sizeof(uint64_t);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Metric set Sampler_2 :: GPU Core Clocks */
static uint64_t
chv__sampler_2__gpu_core_clocks__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Metric set Sampler_2 :: EU Active */
static float
chv__sampler_2__eu_active__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__sampler_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler_2 :: Slice0 Subslice2 Input Available */
static float
chv__sampler_2__sampler02_input_available__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: B 1 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 1];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__sampler_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set Sampler_2 :: EU Both FPU Pipes Active */
static float
chv__sampler_2__eu_fpu_both_active__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__sampler_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler_2 :: VS Send Pipe Active */
static float
chv__sampler_2__vs_send_active__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__sampler_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler_2 :: Slice0 Subslice0 Input Available */
static float
chv__sampler_2__sampler00_input_available__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: B 2 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 2];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__sampler_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set Sampler_2 :: VS FPU1 Pipe Active */
static float
chv__sampler_2__vs_fpu1_active__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 11];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__sampler_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler_2 :: GS Threads Dispatched */
static uint64_t
chv__sampler_2__gs_threads__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Metric set Sampler_2 :: Early Hi-Depth Test Fails */
static uint64_t
chv__sampler_2__hi_depth_test_fails__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler_2 :: FS Both FPU Active */
static float
chv__sampler_2__ps_eu_both_fpu_active__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 18];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__sampler_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler_2 :: VS Threads Dispatched */
static uint64_t
chv__sampler_2__vs_threads__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Metric set Sampler_2 :: Slice0 Subslice2 Sampler Output Ready */
static float
chv__sampler_2__sampler02_output_ready__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: C 7 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 7];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__sampler_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set Sampler_2 :: FS Threads Dispatched */
static uint64_t
chv__sampler_2__ps_threads__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Metric set Sampler_2 :: Shader Barrier Messages */
static uint64_t
chv__sampler_2__shader_barriers__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Metric set Sampler_2 :: Slice0 Subslice1 Input Available */
static float
chv__sampler_2__sampler01_input_available__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: B 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__sampler_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set Sampler_2 :: Sampler Texels */
static uint64_t
chv__sampler_2__sampler_texels__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler_2 :: Pixels Failing Tests */
static uint64_t
chv__sampler_2__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                                   const struct brw_perf_query_info *query,
                                                   uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler_2 :: GPU Time Elapsed */
static uint64_t
chv__sampler_2__gpu_time__read(struct brw_context *brw,
                               const struct brw_perf_query_info *query,
                               uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set Sampler_2 :: AVG GPU Core Frequency */
static uint64_t
chv__sampler_2__avg_gpu_core_frequency__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = chv__sampler_2__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = chv__sampler_2__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Metric set Sampler_2 :: AVG GPU Core Frequency */
static uint64_t
chv__sampler_2__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Metric set Sampler_2 :: Sampler Texels Misses */
static uint64_t
chv__sampler_2__sampler_texel_misses__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler_2 :: CS Threads Dispatched */
static uint64_t
chv__sampler_2__cs_threads__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Metric set Sampler_2 :: SLM Bytes Read */
static uint64_t
chv__sampler_2__slm_bytes_read__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set Sampler_2 :: PS FPU1 Pipe Active */
static float
chv__sampler_2__ps_fpu1_active__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 16 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 16];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__sampler_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler_2 :: PS Send Pipeline Active */
static float
chv__sampler_2__ps_send_active__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 17];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__sampler_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler_2 :: VS FPU0 Pipe Active */
static float
chv__sampler_2__vs_fpu0_active__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 10];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__sampler_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler_2 :: GPU Busy */
static float
chv__sampler_2__gpu_busy__read(struct brw_context *brw,
                               const struct brw_perf_query_info *query,
                               uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__sampler_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set Sampler_2 :: Rasterized Pixels */
static uint64_t
chv__sampler_2__rasterized_pixels__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler_2 :: PS FPU0 Pipe Active */
static float
chv__sampler_2__ps_fpu0_active__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 15 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 15];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__sampler_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler_2 :: DS Threads Dispatched */
static uint64_t
chv__sampler_2__ds_threads__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Metric set Sampler_2 :: Samples Written */
static uint64_t
chv__sampler_2__samples_written__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler_2 :: EU Stall */
static float
chv__sampler_2__eu_stall__read(struct brw_context *brw,
                               const struct brw_perf_query_info *query,
                               uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__sampler_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler_2 :: Samples Blended */
static uint64_t
chv__sampler_2__samples_blended__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler_2 :: Early Depth Test Fails */
static uint64_t
chv__sampler_2__early_depth_test_fails__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler_2 :: Slice0 Subslice0 Sampler Output Ready */
static float
chv__sampler_2__sampler00_output_ready__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: C 6 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 6];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__sampler_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set Sampler_2 :: Slice0 Subslice1 Sampler Output Ready */
static float
chv__sampler_2__sampler01_output_ready__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: C 5 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 5];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__sampler_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set Sampler_2 :: Shader Memory Accesses */
static uint64_t
chv__sampler_2__shader_memory_accesses__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Metric set Sampler_2 :: HS Threads Dispatched */
static uint64_t
chv__sampler_2__hs_threads__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Metric set Sampler_2 :: SLM Bytes Written */
static uint64_t
chv__sampler_2__slm_bytes_written__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set Sampler_2 :: L3 Shader Throughput */
static uint64_t
chv__sampler_2__l3_shader_throughput__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = chv__sampler_2__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Metric set Sampler_2 :: Samples Killed in FS */
static uint64_t
chv__sampler_2__samples_killed_in_ps__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler_2 :: Shader Atomic Memory Accesses */
static uint64_t
chv__sampler_2__shader_atomics__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

static struct brw_perf_query_counter chv_sampler_2_query_counters[41];
static struct brw_perf_query_info chv_sampler_2_query = {
   .kind = OA_COUNTERS,
   .name = "Metric set Sampler_2",
   .guid = "b996a2b7-c59c-492d-877a-8cd54fd6df84",
   .counters = chv_sampler_2_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
};

static void
register_sampler_2_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &chv_sampler_2_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_2__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__sampler_2__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.subslice_mask & 0x4) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__sampler_2__sampler02_input_available__read;
         counter->name = "Slice0 Subslice2 Input Available";
         counter->desc = "The percentage of time in which slice0 subslice2 sampler input is available";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 12;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__sampler_2__eu_fpu_both_active__read;
      counter->name = "EU Both FPU Pipes Active";
      counter->desc = "The percentage of time in which both EU FPU pipelines were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 16;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__sampler_2__vs_send_active__read;
      counter->name = "VS Send Pipe Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 20;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.subslice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__sampler_2__sampler00_input_available__read;
         counter->name = "Slice0 Subslice0 Input Available";
         counter->desc = "The percentage of time in which slice0 subslice0 sampler input is available";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 24;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__sampler_2__vs_fpu1_active__read;
      counter->name = "VS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 28;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_2__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_2__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 40;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__sampler_2__ps_eu_both_fpu_active__read;
      counter->name = "FS Both FPU Active";
      counter->desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 48;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_2__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 56;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x4) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__sampler_2__sampler02_output_ready__read;
         counter->name = "Slice0 Subslice2 Sampler Output Ready";
         counter->desc = "The percentage of time in which slice0 subslice2 sampler output is ready";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 64;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_2__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_2__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x2) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__sampler_2__sampler01_input_available__read;
         counter->name = "Slice0 Subslice1 Input Available";
         counter->desc = "The percentage of time in which slice0 subslice1 sampler input is available";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 88;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_2__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_2__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 104;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_2__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_2__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = chv__sampler_2__avg_gpu_core_frequency__max(brw);
      counter->offset = 120;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_2__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 128;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_2__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 136;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_2__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 144;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__sampler_2__ps_fpu1_active__read;
      counter->name = "PS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 152;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__sampler_2__ps_send_active__read;
      counter->name = "PS Send Pipeline Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 156;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__sampler_2__vs_fpu0_active__read;
      counter->name = "VS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 160;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__sampler_2__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 164;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_2__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 168;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__sampler_2__ps_fpu0_active__read;
      counter->name = "PS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 176;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_2__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_2__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 192;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__sampler_2__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 200;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_2__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 208;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_2__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__sampler_2__sampler00_output_ready__read;
         counter->name = "Slice0 Subslice0 Sampler Output Ready";
         counter->desc = "The percentage of time in which slice0 subslice0 sampler output is ready";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 224;
         counter->size = sizeof(float);
      }

      if (brw->perfquery.sys_vars.subslice_mask & 0x2) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__sampler_2__sampler01_output_ready__read;
         counter->name = "Slice0 Subslice1 Sampler Output Ready";
         counter->desc = "The percentage of time in which slice0 subslice1 sampler output is ready";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 228;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_2__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 232;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_2__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 240;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_2__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 248;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_2__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 256;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_2__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 264;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__sampler_2__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 272;
      counter->size = sizeof(uint64_t);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Metric set TDL_1 :: GPU Core Clocks */
static uint64_t
chv__tdl_1__gpu_core_clocks__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Metric set TDL_1 :: EU Active */
static float
chv__tdl_1__eu_active__read(struct brw_context *brw,
                            const struct brw_perf_query_info *query,
                            uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_1 :: EU Both FPU Pipes Active */
static float
chv__tdl_1__eu_fpu_both_active__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_1 :: VS Send Pipe Active */
static float
chv__tdl_1__vs_send_active__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_1 :: VS FPU1 Pipe Active */
static float
chv__tdl_1__vs_fpu1_active__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 11];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_1 :: GS Threads Dispatched */
static uint64_t
chv__tdl_1__gs_threads__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Metric set TDL_1 :: Early Hi-Depth Test Fails */
static uint64_t
chv__tdl_1__hi_depth_test_fails__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_1 :: FS Both FPU Active */
static float
chv__tdl_1__ps_eu_both_fpu_active__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 18];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_1 :: VS Threads Dispatched */
static uint64_t
chv__tdl_1__vs_threads__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Metric set TDL_1 :: PS Thread Ready For Dispatch on Slice1 Subslice1 Thread Dispatcher */
static float
chv__tdl_1__ps_thread11_ready_for_dispatch__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: B 5 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 5];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_1 :: FS Threads Dispatched */
static uint64_t
chv__tdl_1__ps_threads__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Metric set TDL_1 :: Non-PS Thread Ready For Dispatch on Slice1 Subslice2 Thread Dispatcher */
static float
chv__tdl_1__non_ps_thread12_ready_for_dispatch__read(struct brw_context *brw,
                                                     const struct brw_perf_query_info *query,
                                                     uint64_t *accumulator)
{
   /* RPN equation: B 4 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 4];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_1 :: Shader Barrier Messages */
static uint64_t
chv__tdl_1__shader_barriers__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Metric set TDL_1 :: Sampler Texels */
static uint64_t
chv__tdl_1__sampler_texels__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_1 :: Pixels Failing Tests */
static uint64_t
chv__tdl_1__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_1 :: Non-PS Thread Ready For Dispatch on Slice1 Subslice0 Thread Dispatcher */
static float
chv__tdl_1__non_ps_thread10_ready_for_dispatch__read(struct brw_context *brw,
                                                     const struct brw_perf_query_info *query,
                                                     uint64_t *accumulator)
{
   /* RPN equation: B 2 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 2];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_1 :: Thread Header Ready on Slice0 Subslice1 Thread Dispatcher Port 0 */
static float
chv__tdl_1__thread_header01_ready_port0__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 7 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 7];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_1 :: Thread Header Ready on Slice0 Subslice1 Thread Dispatcher Port 1 */
static float
chv__tdl_1__thread_header01_ready_port1__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 2 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 2];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_1 :: GPU Time Elapsed */
static uint64_t
chv__tdl_1__gpu_time__read(struct brw_context *brw,
                           const struct brw_perf_query_info *query,
                           uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_1 :: AVG GPU Core Frequency */
static uint64_t
chv__tdl_1__avg_gpu_core_frequency__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = chv__tdl_1__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = chv__tdl_1__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Metric set TDL_1 :: AVG GPU Core Frequency */
static uint64_t
chv__tdl_1__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Metric set TDL_1 :: Sampler Texels Misses */
static uint64_t
chv__tdl_1__sampler_texel_misses__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_1 :: CS Threads Dispatched */
static uint64_t
chv__tdl_1__cs_threads__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Metric set TDL_1 :: SLM Bytes Read */
static uint64_t
chv__tdl_1__slm_bytes_read__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set TDL_1 :: PS FPU1 Pipe Active */
static float
chv__tdl_1__ps_fpu1_active__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 16 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 16];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_1 :: PS Send Pipeline Active */
static float
chv__tdl_1__ps_send_active__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 17];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_1 :: VS FPU0 Pipe Active */
static float
chv__tdl_1__vs_fpu0_active__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 10];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_1 :: GPU Busy */
static float
chv__tdl_1__gpu_busy__read(struct brw_context *brw,
                           const struct brw_perf_query_info *query,
                           uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_1 :: Thread Header Ready on Slice0 Subslice2 Thread Dispatcher Port 1 */
static float
chv__tdl_1__thread_header02_ready_port1__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 4 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 4];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_1 :: Thread Header Ready on Slice0 Subslice2 Thread Dispatcher Port 0 */
static float
chv__tdl_1__thread_header02_ready_port0__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 3 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 3];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_1 :: Rasterized Pixels */
static uint64_t
chv__tdl_1__rasterized_pixels__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_1 :: PS FPU0 Pipe Active */
static float
chv__tdl_1__ps_fpu0_active__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 15 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 15];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_1 :: DS Threads Dispatched */
static uint64_t
chv__tdl_1__ds_threads__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Metric set TDL_1 :: Samples Written */
static uint64_t
chv__tdl_1__samples_written__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_1 :: EU Stall */
static float
chv__tdl_1__eu_stall__read(struct brw_context *brw,
                           const struct brw_perf_query_info *query,
                           uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_1 :: Samples Blended */
static uint64_t
chv__tdl_1__samples_blended__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_1 :: Early Depth Test Fails */
static uint64_t
chv__tdl_1__early_depth_test_fails__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_1 :: PS Thread Ready For Dispatch on Slice1 Subslice2 Thread Dispatcher */
static float
chv__tdl_1__ps_thread12_ready_for_dispatch__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: B 3 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 3];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_1 :: PS Thread Ready For Dispatch on Slice1 Subslice0 Thread Dispatcher */
static float
chv__tdl_1__ps_thread10_ready_for_dispatch__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: B 1 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 1];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_1 :: Non-PS Thread Ready For Dispatch on Slice1 Subslice1 Thread Dispatcher */
static float
chv__tdl_1__non_ps_thread11_ready_for_dispatch__read(struct brw_context *brw,
                                                     const struct brw_perf_query_info *query,
                                                     uint64_t *accumulator)
{
   /* RPN equation: B 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_1 :: Shader Memory Accesses */
static uint64_t
chv__tdl_1__shader_memory_accesses__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Metric set TDL_1 :: HS Threads Dispatched */
static uint64_t
chv__tdl_1__hs_threads__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Metric set TDL_1 :: SLM Bytes Written */
static uint64_t
chv__tdl_1__slm_bytes_written__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set TDL_1 :: L3 Shader Throughput */
static uint64_t
chv__tdl_1__l3_shader_throughput__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = chv__tdl_1__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Metric set TDL_1 :: Samples Killed in FS */
static uint64_t
chv__tdl_1__samples_killed_in_ps__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_1 :: Thread Header Ready on Slice0 Subslice0 Thread Dispatcher Port 0 */
static float
chv__tdl_1__thread_header00_ready_port0__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 5 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 5];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_1 :: Shader Atomic Memory Accesses */
static uint64_t
chv__tdl_1__shader_atomics__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

/* Metric set TDL_1 :: Thread Header Ready on Slice0 Subslice0 Thread Dispatcher Port 1 */
static float
chv__tdl_1__thread_header00_ready_port1__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 6 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 6];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

static struct brw_perf_query_counter chv_tdl_1_query_counters[47];
static struct brw_perf_query_info chv_tdl_1_query = {
   .kind = OA_COUNTERS,
   .name = "Metric set TDL_1",
   .guid = "eb2fecba-b431-42e7-8261-fe9429a6e67a",
   .counters = chv_tdl_1_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
};

static void
register_tdl_1_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &chv_tdl_1_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_1__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__tdl_1__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__tdl_1__eu_fpu_both_active__read;
      counter->name = "EU Both FPU Pipes Active";
      counter->desc = "The percentage of time in which both EU FPU pipelines were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 12;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__tdl_1__vs_send_active__read;
      counter->name = "VS Send Pipe Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 16;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__tdl_1__vs_fpu1_active__read;
      counter->name = "VS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 20;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_1__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 24;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_1__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__tdl_1__ps_eu_both_fpu_active__read;
      counter->name = "FS Both FPU Active";
      counter->desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 40;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_1__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 48;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x10) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__tdl_1__ps_thread11_ready_for_dispatch__read;
         counter->name = "PS Thread Ready For Dispatch on Slice1 Subslice1 Thread Dispatcher";
         counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice1 subslice1 thread dispatcher";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 56;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_1__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 64;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x20) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__tdl_1__non_ps_thread12_ready_for_dispatch__read;
         counter->name = "Non-PS Thread Ready For Dispatch on Slice1 Subslice2 Thread Dispatcher";
         counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice1 subslice2 thread dispatcher";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 72;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_1__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_1__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_1__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x8) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__tdl_1__non_ps_thread10_ready_for_dispatch__read;
         counter->name = "Non-PS Thread Ready For Dispatch on Slice1 Subslice0 Thread Dispatcher";
         counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice1 subslice0 thread dispatcher";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 104;
         counter->size = sizeof(float);
      }

      if (brw->perfquery.sys_vars.subslice_mask & 0x2) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__tdl_1__thread_header01_ready_port0__read;
         counter->name = "Thread Header Ready on Slice0 Subslice1 Thread Dispatcher Port 0";
         counter->desc = "The percentage of time in which thread header is ready on slice0 subslice1 thread dispatcher port 0";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 108;
         counter->size = sizeof(float);
      }

      if (brw->perfquery.sys_vars.subslice_mask & 0x2) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__tdl_1__thread_header01_ready_port1__read;
         counter->name = "Thread Header Ready on Slice0 Subslice1 Thread Dispatcher Port 1";
         counter->desc = "The percentage of time in which thread header is ready on slice0 subslice1 thread dispatcher port 1";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 112;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_1__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 120;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_1__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = chv__tdl_1__avg_gpu_core_frequency__max(brw);
      counter->offset = 128;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_1__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 136;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_1__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 144;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_1__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 152;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__tdl_1__ps_fpu1_active__read;
      counter->name = "PS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 160;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__tdl_1__ps_send_active__read;
      counter->name = "PS Send Pipeline Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 164;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__tdl_1__vs_fpu0_active__read;
      counter->name = "VS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 168;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__tdl_1__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 172;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.subslice_mask & 0x4) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__tdl_1__thread_header02_ready_port1__read;
         counter->name = "Thread Header Ready on Slice0 Subslice2 Thread Dispatcher Port 1";
         counter->desc = "The percentage of time in which thread header is ready on slice0 subslice2 thread dispatcher port 1";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 176;
         counter->size = sizeof(float);
      }

      if (brw->perfquery.sys_vars.subslice_mask & 0x4) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__tdl_1__thread_header02_ready_port0__read;
         counter->name = "Thread Header Ready on Slice0 Subslice2 Thread Dispatcher Port 0";
         counter->desc = "The percentage of time in which thread header is ready on slice0 subslice2 thread dispatcher port 0";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 180;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_1__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__tdl_1__ps_fpu0_active__read;
      counter->name = "PS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 192;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_1__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 200;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_1__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 208;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__tdl_1__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 216;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_1__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 224;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_1__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 232;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x20) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__tdl_1__ps_thread12_ready_for_dispatch__read;
         counter->name = "PS Thread Ready For Dispatch on Slice1 Subslice2 Thread Dispatcher";
         counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice1 subslice2 thread dispatcher";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 240;
         counter->size = sizeof(float);
      }

      if (brw->perfquery.sys_vars.subslice_mask & 0x8) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__tdl_1__ps_thread10_ready_for_dispatch__read;
         counter->name = "PS Thread Ready For Dispatch on Slice1 Subslice0 Thread Dispatcher";
         counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice1 subslice0 thread dispatcher";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 244;
         counter->size = sizeof(float);
      }

      if (brw->perfquery.sys_vars.subslice_mask & 0x10) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__tdl_1__non_ps_thread11_ready_for_dispatch__read;
         counter->name = "Non-PS Thread Ready For Dispatch on Slice1 Subslice1 Thread Dispatcher";
         counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice1 subslice1 thread dispatcher";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 248;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_1__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 256;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_1__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 264;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_1__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 272;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_1__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 280;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_1__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 288;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__tdl_1__thread_header00_ready_port0__read;
         counter->name = "Thread Header Ready on Slice0 Subslice0 Thread Dispatcher Port 0";
         counter->desc = "The percentage of time in which thread header is ready on slice0 subslice0 thread dispatcher port 0";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 296;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_1__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 304;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__tdl_1__thread_header00_ready_port1__read;
         counter->name = "Thread Header Ready on Slice0 Subslice0 Thread Dispatcher Port 1";
         counter->desc = "The percentage of time in which thread header is ready on slice0 subslice0 thread dispatcher port 1";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 312;
         counter->size = sizeof(float);
      }

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Metric set TDL_2 :: GPU Core Clocks */
static uint64_t
chv__tdl_2__gpu_core_clocks__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Metric set TDL_2 :: EU Active */
static float
chv__tdl_2__eu_active__read(struct brw_context *brw,
                            const struct brw_perf_query_info *query,
                            uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_2 :: EU Both FPU Pipes Active */
static float
chv__tdl_2__eu_fpu_both_active__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_2 :: Thread Header Ready on Slice1 Subslice1 Thread Dispatcher Port 1 */
static float
chv__tdl_2__thread_header11_ready_port1__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 5 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 5];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_2 :: VS Send Pipe Active */
static float
chv__tdl_2__vs_send_active__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_2 :: VS FPU1 Pipe Active */
static float
chv__tdl_2__vs_fpu1_active__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 11];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_2 :: GS Threads Dispatched */
static uint64_t
chv__tdl_2__gs_threads__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Metric set TDL_2 :: Early Hi-Depth Test Fails */
static uint64_t
chv__tdl_2__hi_depth_test_fails__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_2 :: FS Both FPU Active */
static float
chv__tdl_2__ps_eu_both_fpu_active__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 18];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_2 :: VS Threads Dispatched */
static uint64_t
chv__tdl_2__vs_threads__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Metric set TDL_2 :: FS Threads Dispatched */
static uint64_t
chv__tdl_2__ps_threads__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Metric set TDL_2 :: Non-PS Thread Ready For Dispatch on Slice0 Subslice2 Thread Dispatcher */
static float
chv__tdl_2__non_ps_thread02_ready_for_dispatch__read(struct brw_context *brw,
                                                     const struct brw_perf_query_info *query,
                                                     uint64_t *accumulator)
{
   /* RPN equation: B 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_2 :: Shader Barrier Messages */
static uint64_t
chv__tdl_2__shader_barriers__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Metric set TDL_2 :: Sampler Texels */
static uint64_t
chv__tdl_2__sampler_texels__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_2 :: Pixels Failing Tests */
static uint64_t
chv__tdl_2__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_2 :: GPU Time Elapsed */
static uint64_t
chv__tdl_2__gpu_time__read(struct brw_context *brw,
                           const struct brw_perf_query_info *query,
                           uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_2 :: AVG GPU Core Frequency */
static uint64_t
chv__tdl_2__avg_gpu_core_frequency__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = chv__tdl_2__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = chv__tdl_2__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Metric set TDL_2 :: AVG GPU Core Frequency */
static uint64_t
chv__tdl_2__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Metric set TDL_2 :: Sampler Texels Misses */
static uint64_t
chv__tdl_2__sampler_texel_misses__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_2 :: Non-PS Thread Ready For Dispatch on Slice0 Subslice0 Thread Dispatcher */
static float
chv__tdl_2__non_ps_thread00_ready_for_dispatch__read(struct brw_context *brw,
                                                     const struct brw_perf_query_info *query,
                                                     uint64_t *accumulator)
{
   /* RPN equation: B 5 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 5];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_2 :: CS Threads Dispatched */
static uint64_t
chv__tdl_2__cs_threads__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Metric set TDL_2 :: SLM Bytes Read */
static uint64_t
chv__tdl_2__slm_bytes_read__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set TDL_2 :: Thread Header Ready on Slice1 Subslice1 Thread Dispatcher Port 0 */
static float
chv__tdl_2__thread_header11_ready_port0__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 2 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 2];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_2 :: PS FPU1 Pipe Active */
static float
chv__tdl_2__ps_fpu1_active__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 16 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 16];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_2 :: PS Send Pipeline Active */
static float
chv__tdl_2__ps_send_active__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 17];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_2 :: VS FPU0 Pipe Active */
static float
chv__tdl_2__vs_fpu0_active__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 10];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_2 :: GPU Busy */
static float
chv__tdl_2__gpu_busy__read(struct brw_context *brw,
                           const struct brw_perf_query_info *query,
                           uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_2 :: Thread Header Ready on Slice1 Subslice2 Thread Dispatcher Port 0 */
static float
chv__tdl_2__thread_header12_ready_port0__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 7 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 7];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_2 :: PS Thread Ready For Dispatch on Slice0 Subslice0 Thread Dispatcher */
static float
chv__tdl_2__ps_thread00_ready_for_dispatch__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: B 3 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 3];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_2 :: Rasterized Pixels */
static uint64_t
chv__tdl_2__rasterized_pixels__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_2 :: PS FPU0 Pipe Active */
static float
chv__tdl_2__ps_fpu0_active__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 15 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 15];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_2 :: DS Threads Dispatched */
static uint64_t
chv__tdl_2__ds_threads__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Metric set TDL_2 :: Samples Written */
static uint64_t
chv__tdl_2__samples_written__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_2 :: Thread Header Ready on Slice1 Subslice0 Thread Dispatcher Port 1 */
static float
chv__tdl_2__thread_header10_ready_port1__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 3 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 3];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_2 :: EU Stall */
static float
chv__tdl_2__eu_stall__read(struct brw_context *brw,
                           const struct brw_perf_query_info *query,
                           uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = chv__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_2 :: Samples Blended */
static uint64_t
chv__tdl_2__samples_blended__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_2 :: Early Depth Test Fails */
static uint64_t
chv__tdl_2__early_depth_test_fails__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_2 :: PS Thread Ready For Dispatch on Slice0 Subslice1 Thread Dispatcher */
static float
chv__tdl_2__ps_thread01_ready_for_dispatch__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: B 2 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 2];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_2 :: Thread Header Ready on Slice1 Subslice2 Thread Dispatcher Port 1 */
static float
chv__tdl_2__thread_header12_ready_port1__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 6 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 6];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_2 :: Shader Memory Accesses */
static uint64_t
chv__tdl_2__shader_memory_accesses__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Metric set TDL_2 :: HS Threads Dispatched */
static uint64_t
chv__tdl_2__hs_threads__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Metric set TDL_2 :: PS Thread Ready For Dispatch on Slice0 Subslice2 Thread Dispatcher */
static float
chv__tdl_2__ps_thread02_ready_for_dispatch__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: B 1 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 1];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_2 :: SLM Bytes Written */
static uint64_t
chv__tdl_2__slm_bytes_written__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set TDL_2 :: L3 Shader Throughput */
static uint64_t
chv__tdl_2__l3_shader_throughput__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = chv__tdl_2__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Metric set TDL_2 :: Samples Killed in FS */
static uint64_t
chv__tdl_2__samples_killed_in_ps__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_2 :: Thread Header Ready on Slice1 Subslice0 Thread Dispatcher Port 0 */
static float
chv__tdl_2__thread_header10_ready_port0__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 4 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 4];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_2 :: Shader Atomic Memory Accesses */
static uint64_t
chv__tdl_2__shader_atomics__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

/* Metric set TDL_2 :: Non-PS Thread Ready For Dispatch on Slice0 Subslice1 Thread Dispatcher */
static float
chv__tdl_2__non_ps_thread01_ready_for_dispatch__read(struct brw_context *brw,
                                                     const struct brw_perf_query_info *query,
                                                     uint64_t *accumulator)
{
   /* RPN equation: B 4 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 4];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = chv__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

static struct brw_perf_query_counter chv_tdl_2_query_counters[47];
static struct brw_perf_query_info chv_tdl_2_query = {
   .kind = OA_COUNTERS,
   .name = "Metric set TDL_2",
   .guid = "60749470-a648-4a4b-9f10-dbfe1e36e44d",
   .counters = chv_tdl_2_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
};

static void
register_tdl_2_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &chv_tdl_2_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_2__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__tdl_2__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__tdl_2__eu_fpu_both_active__read;
      counter->name = "EU Both FPU Pipes Active";
      counter->desc = "The percentage of time in which both EU FPU pipelines were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 12;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.subslice_mask & 0x10) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__tdl_2__thread_header11_ready_port1__read;
         counter->name = "Thread Header Ready on Slice1 Subslice1 Thread Dispatcher Port 1";
         counter->desc = "The percentage of time in which thread header is ready on slice1 subslice1 thread dispatcher port 1";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 16;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__tdl_2__vs_send_active__read;
      counter->name = "VS Send Pipe Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 20;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__tdl_2__vs_fpu1_active__read;
      counter->name = "VS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 24;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_2__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_2__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 40;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__tdl_2__ps_eu_both_fpu_active__read;
      counter->name = "FS Both FPU Active";
      counter->desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 48;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_2__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 56;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_2__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 64;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x4) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__tdl_2__non_ps_thread02_ready_for_dispatch__read;
         counter->name = "Non-PS Thread Ready For Dispatch on Slice0 Subslice2 Thread Dispatcher";
         counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 subslice2 thread dispatcher";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 72;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_2__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_2__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_2__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_2__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 104;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_2__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = chv__tdl_2__avg_gpu_core_frequency__max(brw);
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_2__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 120;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__tdl_2__non_ps_thread00_ready_for_dispatch__read;
         counter->name = "Non-PS Thread Ready For Dispatch on Slice0 Subslice0 Thread Dispatcher";
         counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 subslice0 thread dispatcher";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 128;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_2__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 136;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_2__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 144;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x10) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__tdl_2__thread_header11_ready_port0__read;
         counter->name = "Thread Header Ready on Slice1 Subslice1 Thread Dispatcher Port 0";
         counter->desc = "The percentage of time in which thread header is ready on slice1 subslice1 thread dispatcher port 0";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 152;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__tdl_2__ps_fpu1_active__read;
      counter->name = "PS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 156;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__tdl_2__ps_send_active__read;
      counter->name = "PS Send Pipeline Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 160;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__tdl_2__vs_fpu0_active__read;
      counter->name = "VS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 164;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__tdl_2__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 168;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.subslice_mask & 0x20) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__tdl_2__thread_header12_ready_port0__read;
         counter->name = "Thread Header Ready on Slice1 Subslice2 Thread Dispatcher Port 0";
         counter->desc = "The percentage of time in which thread header is ready on slice1 subslice2 thread dispatcher port 0";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 172;
         counter->size = sizeof(float);
      }

      if (brw->perfquery.sys_vars.subslice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__tdl_2__ps_thread00_ready_for_dispatch__read;
         counter->name = "PS Thread Ready For Dispatch on Slice0 Subslice0 Thread Dispatcher";
         counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice0 subslice0 thread dispatcher";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 176;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_2__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__tdl_2__ps_fpu0_active__read;
      counter->name = "PS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 192;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_2__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 200;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_2__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 208;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x8) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__tdl_2__thread_header10_ready_port1__read;
         counter->name = "Thread Header Ready on Slice1 Subslice0 Thread Dispatcher Port 1";
         counter->desc = "The percentage of time in which thread header is ready on slice1 subslice0 thread dispatcher port 1";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 216;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = chv__tdl_2__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 220;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_2__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 224;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_2__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 232;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x2) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__tdl_2__ps_thread01_ready_for_dispatch__read;
         counter->name = "PS Thread Ready For Dispatch on Slice0 Subslice1 Thread Dispatcher";
         counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice0 subslice1 thread dispatcher";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 240;
         counter->size = sizeof(float);
      }

      if (brw->perfquery.sys_vars.subslice_mask & 0x20) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__tdl_2__thread_header12_ready_port1__read;
         counter->name = "Thread Header Ready on Slice1 Subslice2 Thread Dispatcher Port 1";
         counter->desc = "The percentage of time in which thread header is ready on slice1 subslice2 thread dispatcher port 1";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 244;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_2__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 248;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_2__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 256;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x4) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__tdl_2__ps_thread02_ready_for_dispatch__read;
         counter->name = "PS Thread Ready For Dispatch on Slice0 Subslice2 Thread Dispatcher";
         counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice0 subslice2 thread dispatcher";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 264;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_2__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 272;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_2__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 280;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_2__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 288;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x8) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__tdl_2__thread_header10_ready_port0__read;
         counter->name = "Thread Header Ready on Slice1 Subslice0 Thread Dispatcher Port 0";
         counter->desc = "The percentage of time in which thread header is ready on slice1 subslice0 thread dispatcher port 0";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 296;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__tdl_2__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 304;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x2) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = chv__tdl_2__non_ps_thread01_ready_for_dispatch__read;
         counter->name = "Non-PS Thread Ready For Dispatch on Slice0 Subslice1 Thread Dispatcher";
         counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 subslice1 thread dispatcher";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 312;
         counter->size = sizeof(float);
      }

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* MDAPI testing set Gen8LP :: TestCounter7 */
static uint64_t
chv__test_oa__counter7__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: B 7 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 7];

   return tmp0;
}

/* MDAPI testing set Gen8LP :: GPU Time Elapsed */
static uint64_t
chv__test_oa__gpu_time__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* MDAPI testing set Gen8LP :: GPU Core Clocks */
static uint64_t
chv__test_oa__gpu_core_clocks__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* MDAPI testing set Gen8LP :: AVG GPU Core Frequency */
static uint64_t
chv__test_oa__avg_gpu_core_frequency__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = chv__test_oa__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = chv__test_oa__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* MDAPI testing set Gen8LP :: AVG GPU Core Frequency */
static uint64_t
chv__test_oa__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* MDAPI testing set Gen8LP :: TestCounter8 */
static uint64_t
chv__test_oa__counter8__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: C 7 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 7];

   return tmp0;
}

/* MDAPI testing set Gen8LP :: TestCounter4 */
static uint64_t
chv__test_oa__counter4__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: B 4 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 4];

   return tmp0;
}

/* MDAPI testing set Gen8LP :: TestCounter5 */
static uint64_t
chv__test_oa__counter5__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: B 5 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 5];

   return tmp0;
}

/* MDAPI testing set Gen8LP :: TestCounter6 */
static uint64_t
chv__test_oa__counter6__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: B 6 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 6];

   return tmp0;
}

/* MDAPI testing set Gen8LP :: TestCounter3 */
static uint64_t
chv__test_oa__counter3__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: B 3 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 3];

   return tmp0;
}

/* MDAPI testing set Gen8LP :: TestCounter0 */
static uint64_t
chv__test_oa__counter0__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: B 0 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 0];

   return tmp0;
}

/* MDAPI testing set Gen8LP :: TestCounter1 */
static uint64_t
chv__test_oa__counter1__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: B 1 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 1];

   return tmp0;
}

/* MDAPI testing set Gen8LP :: TestCounter2 */
static uint64_t
chv__test_oa__counter2__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: B 2 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 2];

   return tmp0;
}

static struct brw_perf_query_counter chv_test_oa_query_counters[12];
static struct brw_perf_query_info chv_test_oa_query = {
   .kind = OA_COUNTERS,
   .name = "MDAPI testing set Gen8LP",
   .guid = "4a534b07-cba3-414d-8d60-874830e883aa",
   .counters = chv_test_oa_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
};

static void
register_test_oa_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &chv_test_oa_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__test_oa__counter7__read;
      counter->name = "TestCounter7";
      counter->desc = "HW test counter 7. Factor: 0.666";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__test_oa__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 8;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__test_oa__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 16;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__test_oa__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = chv__test_oa__avg_gpu_core_frequency__max(brw);
      counter->offset = 24;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__test_oa__counter8__read;
      counter->name = "TestCounter8";
      counter->desc = "HW test counter 8. Should be equal to 1.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__test_oa__counter4__read;
      counter->name = "TestCounter4";
      counter->desc = "HW test counter 4. Factor: 0.333";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 40;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__test_oa__counter5__read;
      counter->name = "TestCounter5";
      counter->desc = "HW test counter 5. Factor: 0.333";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 48;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__test_oa__counter6__read;
      counter->name = "TestCounter6";
      counter->desc = "HW test counter 6. Factor: 0.166";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 56;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__test_oa__counter3__read;
      counter->name = "TestCounter3";
      counter->desc = "HW test counter 3. Factor: 0.5";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 64;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__test_oa__counter0__read;
      counter->name = "TestCounter0";
      counter->desc = "HW test counter 0. Factor: 0.0";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__test_oa__counter1__read;
      counter->name = "TestCounter1";
      counter->desc = "HW test counter 1. Factor: 1.0";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = chv__test_oa__counter2__read;
      counter->name = "TestCounter2";
      counter->desc = "HW test counter 2. Factor: 1.0";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

void
brw_oa_register_queries_chv(struct brw_context *brw)
{
   register_render_basic_counter_query(brw);
   register_compute_basic_counter_query(brw);
   register_render_pipe_profile_counter_query(brw);
   register_hdc_and_sf_counter_query(brw);
   register_l3_1_counter_query(brw);
   register_l3_2_counter_query(brw);
   register_l3_3_counter_query(brw);
   register_l3_4_counter_query(brw);
   register_rasterizer_and_pixel_backend_counter_query(brw);
   register_sampler_1_counter_query(brw);
   register_sampler_2_counter_query(brw);
   register_tdl_1_counter_query(brw);
   register_tdl_2_counter_query(brw);
   register_test_oa_counter_query(brw);
}
