/* Generated by re2c */

#include <stddef.h> /* size_t */
#include <stdio.h>
#include <stdlib.h> /* malloc, free */
#include <string.h> /* memcpy */

static void *read_file
    ( const char *fname
    , size_t unit
    , size_t padding
    , size_t *pfsize
    )
{
    void *buffer = NULL;
    size_t fsize = 0;

    /* open file */
    FILE *f = fopen(fname, "rb");
    if(f == NULL) {
        goto error;
    }

    /* get file size */
    fseek(f, 0, SEEK_END);
    fsize = (size_t) ftell(f) / unit;
    fseek(f, 0, SEEK_SET);

    /* allocate memory for file and padding */
    buffer = malloc(unit * (fsize + padding));
    if (buffer == NULL) {
        goto error;
    }

    /* read the whole file in memory */
    if (fread(buffer, unit, fsize, f) != fsize) {
        goto error;
    }

    fclose(f);
    *pfsize = fsize;
    return buffer;

error:
    fprintf(stderr, "error: cannot read file '%s'\n", fname);
    free(buffer);
    if (f != NULL) {
        fclose(f);
    }
    return NULL;
}

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line344
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line344: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line344: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line344(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line344: not enough keys\n");
    return 1;
}

int lex_line344()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line344.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line344.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych >= 0x00000080) goto yy4;
        YYSKIP ();
        status = check_key_count_line344(keys_count, i, 3)
             || action_line344(&i, keys, input, token, &cursor, 0);
        continue;
yy4:
        YYSKIP ();
        status = check_key_count_line344(keys_count, i, 3)
             || action_line344(&i, keys, input, token, &cursor, 254);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line344: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line344: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line351
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line351: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line351: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line351(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line351: not enough keys\n");
    return 1;
}

int lex_line351()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line351.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line351.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000007F) goto yy8;
        if (yych <= 0x000000FF) goto yy10;
yy8:
        YYSKIP ();
        status = check_key_count_line351(keys_count, i, 3)
             || action_line351(&i, keys, input, token, &cursor, 254);
        continue;
yy10:
        YYSKIP ();
        status = check_key_count_line351(keys_count, i, 3)
             || action_line351(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line351: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line351: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line358
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line358: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line358: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line358(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line358: not enough keys\n");
    return 1;
}

int lex_line358()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line358.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line358.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x000000FF) goto yy14;
        if (yych <= 0x0000017F) goto yy16;
yy14:
        YYSKIP ();
        status = check_key_count_line358(keys_count, i, 3)
             || action_line358(&i, keys, input, token, &cursor, 254);
        continue;
yy16:
        YYSKIP ();
        status = check_key_count_line358(keys_count, i, 3)
             || action_line358(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line358: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line358: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line365
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line365: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line365: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line365(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line365: not enough keys\n");
    return 1;
}

int lex_line365()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line365.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line365.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000017F) goto yy20;
        if (yych <= 0x0000024F) goto yy22;
yy20:
        YYSKIP ();
        status = check_key_count_line365(keys_count, i, 3)
             || action_line365(&i, keys, input, token, &cursor, 254);
        continue;
yy22:
        YYSKIP ();
        status = check_key_count_line365(keys_count, i, 3)
             || action_line365(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line365: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line365: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line372
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line372: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line372: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line372(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line372: not enough keys\n");
    return 1;
}

int lex_line372()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line372.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line372.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000024F) goto yy26;
        if (yych <= 0x000002AF) goto yy28;
yy26:
        YYSKIP ();
        status = check_key_count_line372(keys_count, i, 3)
             || action_line372(&i, keys, input, token, &cursor, 254);
        continue;
yy28:
        YYSKIP ();
        status = check_key_count_line372(keys_count, i, 3)
             || action_line372(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line372: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line372: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line379
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line379: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line379: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line379(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line379: not enough keys\n");
    return 1;
}

int lex_line379()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line379.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line379.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x000002AF) goto yy32;
        if (yych <= 0x000002FF) goto yy34;
yy32:
        YYSKIP ();
        status = check_key_count_line379(keys_count, i, 3)
             || action_line379(&i, keys, input, token, &cursor, 254);
        continue;
yy34:
        YYSKIP ();
        status = check_key_count_line379(keys_count, i, 3)
             || action_line379(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line379: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line379: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line386
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line386: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line386: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line386(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line386: not enough keys\n");
    return 1;
}

int lex_line386()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line386.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line386.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x000002FF) goto yy38;
        if (yych <= 0x0000036F) goto yy40;
yy38:
        YYSKIP ();
        status = check_key_count_line386(keys_count, i, 3)
             || action_line386(&i, keys, input, token, &cursor, 254);
        continue;
yy40:
        YYSKIP ();
        status = check_key_count_line386(keys_count, i, 3)
             || action_line386(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line386: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line386: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line393
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line393: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line393: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line393(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line393: not enough keys\n");
    return 1;
}

int lex_line393()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line393.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line393.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000036F) goto yy44;
        if (yych <= 0x000003FF) goto yy46;
yy44:
        YYSKIP ();
        status = check_key_count_line393(keys_count, i, 3)
             || action_line393(&i, keys, input, token, &cursor, 254);
        continue;
yy46:
        YYSKIP ();
        status = check_key_count_line393(keys_count, i, 3)
             || action_line393(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line393: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line393: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line400
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line400: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line400: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line400(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line400: not enough keys\n");
    return 1;
}

int lex_line400()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line400.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line400.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x000003FF) goto yy50;
        if (yych <= 0x000004FF) goto yy52;
yy50:
        YYSKIP ();
        status = check_key_count_line400(keys_count, i, 3)
             || action_line400(&i, keys, input, token, &cursor, 254);
        continue;
yy52:
        YYSKIP ();
        status = check_key_count_line400(keys_count, i, 3)
             || action_line400(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line400: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line400: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line407
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line407: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line407: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line407(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line407: not enough keys\n");
    return 1;
}

int lex_line407()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line407.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line407.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x000004FF) goto yy56;
        if (yych <= 0x0000052F) goto yy58;
yy56:
        YYSKIP ();
        status = check_key_count_line407(keys_count, i, 3)
             || action_line407(&i, keys, input, token, &cursor, 254);
        continue;
yy58:
        YYSKIP ();
        status = check_key_count_line407(keys_count, i, 3)
             || action_line407(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line407: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line407: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line414
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line414: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line414: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line414(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line414: not enough keys\n");
    return 1;
}

int lex_line414()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line414.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line414.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000052F) goto yy62;
        if (yych <= 0x0000058F) goto yy64;
yy62:
        YYSKIP ();
        status = check_key_count_line414(keys_count, i, 3)
             || action_line414(&i, keys, input, token, &cursor, 254);
        continue;
yy64:
        YYSKIP ();
        status = check_key_count_line414(keys_count, i, 3)
             || action_line414(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line414: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line414: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line421
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line421: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line421: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line421(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line421: not enough keys\n");
    return 1;
}

int lex_line421()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line421.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line421.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000058F) goto yy68;
        if (yych <= 0x000005FF) goto yy70;
yy68:
        YYSKIP ();
        status = check_key_count_line421(keys_count, i, 3)
             || action_line421(&i, keys, input, token, &cursor, 254);
        continue;
yy70:
        YYSKIP ();
        status = check_key_count_line421(keys_count, i, 3)
             || action_line421(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line421: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line421: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line428
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line428: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line428: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line428(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line428: not enough keys\n");
    return 1;
}

int lex_line428()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line428.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line428.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x000005FF) goto yy74;
        if (yych <= 0x000006FF) goto yy76;
yy74:
        YYSKIP ();
        status = check_key_count_line428(keys_count, i, 3)
             || action_line428(&i, keys, input, token, &cursor, 254);
        continue;
yy76:
        YYSKIP ();
        status = check_key_count_line428(keys_count, i, 3)
             || action_line428(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line428: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line428: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line435
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line435: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line435: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line435(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line435: not enough keys\n");
    return 1;
}

int lex_line435()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line435.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line435.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x000006FF) goto yy80;
        if (yych <= 0x0000074F) goto yy82;
yy80:
        YYSKIP ();
        status = check_key_count_line435(keys_count, i, 3)
             || action_line435(&i, keys, input, token, &cursor, 254);
        continue;
yy82:
        YYSKIP ();
        status = check_key_count_line435(keys_count, i, 3)
             || action_line435(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line435: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line435: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line442
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line442: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line442: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line442(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line442: not enough keys\n");
    return 1;
}

int lex_line442()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line442.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line442.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000077F) goto yy86;
        if (yych <= 0x000007BF) goto yy88;
yy86:
        YYSKIP ();
        status = check_key_count_line442(keys_count, i, 3)
             || action_line442(&i, keys, input, token, &cursor, 254);
        continue;
yy88:
        YYSKIP ();
        status = check_key_count_line442(keys_count, i, 3)
             || action_line442(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line442: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line442: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line449
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line449: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line449: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line449(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line449: not enough keys\n");
    return 1;
}

int lex_line449()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line449.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line449.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x000008FF) goto yy92;
        if (yych <= 0x0000097F) goto yy94;
yy92:
        YYSKIP ();
        status = check_key_count_line449(keys_count, i, 3)
             || action_line449(&i, keys, input, token, &cursor, 254);
        continue;
yy94:
        YYSKIP ();
        status = check_key_count_line449(keys_count, i, 3)
             || action_line449(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line449: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line449: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line456
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line456: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line456: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line456(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line456: not enough keys\n");
    return 1;
}

int lex_line456()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line456.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line456.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000097F) goto yy98;
        if (yych <= 0x000009FF) goto yy100;
yy98:
        YYSKIP ();
        status = check_key_count_line456(keys_count, i, 3)
             || action_line456(&i, keys, input, token, &cursor, 254);
        continue;
yy100:
        YYSKIP ();
        status = check_key_count_line456(keys_count, i, 3)
             || action_line456(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line456: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line456: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line463
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line463: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line463: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line463(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line463: not enough keys\n");
    return 1;
}

int lex_line463()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line463.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line463.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x000009FF) goto yy104;
        if (yych <= 0x00000A7F) goto yy106;
yy104:
        YYSKIP ();
        status = check_key_count_line463(keys_count, i, 3)
             || action_line463(&i, keys, input, token, &cursor, 254);
        continue;
yy106:
        YYSKIP ();
        status = check_key_count_line463(keys_count, i, 3)
             || action_line463(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line463: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line463: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line470
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line470: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line470: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line470(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line470: not enough keys\n");
    return 1;
}

int lex_line470()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line470.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line470.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x00000A7F) goto yy110;
        if (yych <= 0x00000AFF) goto yy112;
yy110:
        YYSKIP ();
        status = check_key_count_line470(keys_count, i, 3)
             || action_line470(&i, keys, input, token, &cursor, 254);
        continue;
yy112:
        YYSKIP ();
        status = check_key_count_line470(keys_count, i, 3)
             || action_line470(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line470: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line470: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line477
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line477: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line477: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line477(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line477: not enough keys\n");
    return 1;
}

int lex_line477()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line477.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line477.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x00000AFF) goto yy116;
        if (yych <= 0x00000B7F) goto yy118;
yy116:
        YYSKIP ();
        status = check_key_count_line477(keys_count, i, 3)
             || action_line477(&i, keys, input, token, &cursor, 254);
        continue;
yy118:
        YYSKIP ();
        status = check_key_count_line477(keys_count, i, 3)
             || action_line477(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line477: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line477: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line484
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line484: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line484: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line484(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line484: not enough keys\n");
    return 1;
}

int lex_line484()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line484.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line484.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x00000B7F) goto yy122;
        if (yych <= 0x00000BFF) goto yy124;
yy122:
        YYSKIP ();
        status = check_key_count_line484(keys_count, i, 3)
             || action_line484(&i, keys, input, token, &cursor, 254);
        continue;
yy124:
        YYSKIP ();
        status = check_key_count_line484(keys_count, i, 3)
             || action_line484(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line484: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line484: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line491
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line491: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line491: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line491(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line491: not enough keys\n");
    return 1;
}

int lex_line491()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line491.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line491.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x00000BFF) goto yy128;
        if (yych <= 0x00000C7F) goto yy130;
yy128:
        YYSKIP ();
        status = check_key_count_line491(keys_count, i, 3)
             || action_line491(&i, keys, input, token, &cursor, 254);
        continue;
yy130:
        YYSKIP ();
        status = check_key_count_line491(keys_count, i, 3)
             || action_line491(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line491: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line491: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line498
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line498: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line498: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line498(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line498: not enough keys\n");
    return 1;
}

int lex_line498()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line498.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line498.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x00000C7F) goto yy134;
        if (yych <= 0x00000CFF) goto yy136;
yy134:
        YYSKIP ();
        status = check_key_count_line498(keys_count, i, 3)
             || action_line498(&i, keys, input, token, &cursor, 254);
        continue;
yy136:
        YYSKIP ();
        status = check_key_count_line498(keys_count, i, 3)
             || action_line498(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line498: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line498: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line505
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line505: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line505: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line505(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line505: not enough keys\n");
    return 1;
}

int lex_line505()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line505.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line505.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x00000CFF) goto yy140;
        if (yych <= 0x00000D7F) goto yy142;
yy140:
        YYSKIP ();
        status = check_key_count_line505(keys_count, i, 3)
             || action_line505(&i, keys, input, token, &cursor, 254);
        continue;
yy142:
        YYSKIP ();
        status = check_key_count_line505(keys_count, i, 3)
             || action_line505(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line505: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line505: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line512
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line512: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line512: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line512(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line512: not enough keys\n");
    return 1;
}

int lex_line512()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line512.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line512.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x00000D7F) goto yy146;
        if (yych <= 0x00000DFF) goto yy148;
yy146:
        YYSKIP ();
        status = check_key_count_line512(keys_count, i, 3)
             || action_line512(&i, keys, input, token, &cursor, 254);
        continue;
yy148:
        YYSKIP ();
        status = check_key_count_line512(keys_count, i, 3)
             || action_line512(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line512: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line512: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line519
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line519: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line519: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line519(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line519: not enough keys\n");
    return 1;
}

int lex_line519()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line519.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line519.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x00000DFF) goto yy152;
        if (yych <= 0x00000E7F) goto yy154;
yy152:
        YYSKIP ();
        status = check_key_count_line519(keys_count, i, 3)
             || action_line519(&i, keys, input, token, &cursor, 254);
        continue;
yy154:
        YYSKIP ();
        status = check_key_count_line519(keys_count, i, 3)
             || action_line519(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line519: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line519: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line526
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line526: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line526: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line526(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line526: not enough keys\n");
    return 1;
}

int lex_line526()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line526.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line526.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x00000E7F) goto yy158;
        if (yych <= 0x00000EFF) goto yy160;
yy158:
        YYSKIP ();
        status = check_key_count_line526(keys_count, i, 3)
             || action_line526(&i, keys, input, token, &cursor, 254);
        continue;
yy160:
        YYSKIP ();
        status = check_key_count_line526(keys_count, i, 3)
             || action_line526(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line526: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line526: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line533
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line533: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line533: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line533(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line533: not enough keys\n");
    return 1;
}

int lex_line533()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line533.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line533.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x00000EFF) goto yy164;
        if (yych <= 0x00000FFF) goto yy166;
yy164:
        YYSKIP ();
        status = check_key_count_line533(keys_count, i, 3)
             || action_line533(&i, keys, input, token, &cursor, 254);
        continue;
yy166:
        YYSKIP ();
        status = check_key_count_line533(keys_count, i, 3)
             || action_line533(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line533: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line533: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line540
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line540: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line540: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line540(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line540: not enough keys\n");
    return 1;
}

int lex_line540()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line540.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line540.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x00000FFF) goto yy170;
        if (yych <= 0x0000109F) goto yy172;
yy170:
        YYSKIP ();
        status = check_key_count_line540(keys_count, i, 3)
             || action_line540(&i, keys, input, token, &cursor, 254);
        continue;
yy172:
        YYSKIP ();
        status = check_key_count_line540(keys_count, i, 3)
             || action_line540(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line540: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line540: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line547
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line547: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line547: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line547(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line547: not enough keys\n");
    return 1;
}

int lex_line547()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line547.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line547.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000109F) goto yy176;
        if (yych <= 0x000010FF) goto yy178;
yy176:
        YYSKIP ();
        status = check_key_count_line547(keys_count, i, 3)
             || action_line547(&i, keys, input, token, &cursor, 254);
        continue;
yy178:
        YYSKIP ();
        status = check_key_count_line547(keys_count, i, 3)
             || action_line547(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line547: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line547: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line554
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line554: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line554: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line554(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line554: not enough keys\n");
    return 1;
}

int lex_line554()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line554.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line554.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x000010FF) goto yy182;
        if (yych <= 0x000011FF) goto yy184;
yy182:
        YYSKIP ();
        status = check_key_count_line554(keys_count, i, 3)
             || action_line554(&i, keys, input, token, &cursor, 254);
        continue;
yy184:
        YYSKIP ();
        status = check_key_count_line554(keys_count, i, 3)
             || action_line554(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line554: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line554: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line561
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line561: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line561: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line561(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line561: not enough keys\n");
    return 1;
}

int lex_line561()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line561.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line561.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x000011FF) goto yy188;
        if (yych <= 0x0000137F) goto yy190;
yy188:
        YYSKIP ();
        status = check_key_count_line561(keys_count, i, 3)
             || action_line561(&i, keys, input, token, &cursor, 254);
        continue;
yy190:
        YYSKIP ();
        status = check_key_count_line561(keys_count, i, 3)
             || action_line561(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line561: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line561: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line568
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line568: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line568: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line568(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line568: not enough keys\n");
    return 1;
}

int lex_line568()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line568.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line568.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000139F) goto yy194;
        if (yych <= 0x000013FF) goto yy196;
yy194:
        YYSKIP ();
        status = check_key_count_line568(keys_count, i, 3)
             || action_line568(&i, keys, input, token, &cursor, 254);
        continue;
yy196:
        YYSKIP ();
        status = check_key_count_line568(keys_count, i, 3)
             || action_line568(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line568: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line568: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line575
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line575: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line575: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line575(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line575: not enough keys\n");
    return 1;
}

int lex_line575()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line575.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line575.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x000013FF) goto yy200;
        if (yych <= 0x0000167F) goto yy202;
yy200:
        YYSKIP ();
        status = check_key_count_line575(keys_count, i, 3)
             || action_line575(&i, keys, input, token, &cursor, 254);
        continue;
yy202:
        YYSKIP ();
        status = check_key_count_line575(keys_count, i, 3)
             || action_line575(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line575: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line575: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line582
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line582: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line582: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line582(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line582: not enough keys\n");
    return 1;
}

int lex_line582()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line582.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line582.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000167F) goto yy206;
        if (yych <= 0x0000169F) goto yy208;
yy206:
        YYSKIP ();
        status = check_key_count_line582(keys_count, i, 3)
             || action_line582(&i, keys, input, token, &cursor, 254);
        continue;
yy208:
        YYSKIP ();
        status = check_key_count_line582(keys_count, i, 3)
             || action_line582(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line582: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line582: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line589
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line589: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line589: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line589(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line589: not enough keys\n");
    return 1;
}

int lex_line589()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line589.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line589.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000169F) goto yy212;
        if (yych <= 0x000016FF) goto yy214;
yy212:
        YYSKIP ();
        status = check_key_count_line589(keys_count, i, 3)
             || action_line589(&i, keys, input, token, &cursor, 254);
        continue;
yy214:
        YYSKIP ();
        status = check_key_count_line589(keys_count, i, 3)
             || action_line589(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line589: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line589: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line596
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line596: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line596: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line596(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line596: not enough keys\n");
    return 1;
}

int lex_line596()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line596.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line596.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x000016FF) goto yy218;
        if (yych <= 0x0000171F) goto yy220;
yy218:
        YYSKIP ();
        status = check_key_count_line596(keys_count, i, 3)
             || action_line596(&i, keys, input, token, &cursor, 254);
        continue;
yy220:
        YYSKIP ();
        status = check_key_count_line596(keys_count, i, 3)
             || action_line596(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line596: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line596: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line603
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line603: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line603: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line603(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line603: not enough keys\n");
    return 1;
}

int lex_line603()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line603.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line603.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000171F) goto yy224;
        if (yych <= 0x0000173F) goto yy226;
yy224:
        YYSKIP ();
        status = check_key_count_line603(keys_count, i, 3)
             || action_line603(&i, keys, input, token, &cursor, 254);
        continue;
yy226:
        YYSKIP ();
        status = check_key_count_line603(keys_count, i, 3)
             || action_line603(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line603: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line603: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line610
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line610: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line610: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line610(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line610: not enough keys\n");
    return 1;
}

int lex_line610()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line610.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line610.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000173F) goto yy230;
        if (yych <= 0x0000175F) goto yy232;
yy230:
        YYSKIP ();
        status = check_key_count_line610(keys_count, i, 3)
             || action_line610(&i, keys, input, token, &cursor, 254);
        continue;
yy232:
        YYSKIP ();
        status = check_key_count_line610(keys_count, i, 3)
             || action_line610(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line610: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line610: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line617
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line617: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line617: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line617(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line617: not enough keys\n");
    return 1;
}

int lex_line617()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line617.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line617.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000175F) goto yy236;
        if (yych <= 0x0000177F) goto yy238;
yy236:
        YYSKIP ();
        status = check_key_count_line617(keys_count, i, 3)
             || action_line617(&i, keys, input, token, &cursor, 254);
        continue;
yy238:
        YYSKIP ();
        status = check_key_count_line617(keys_count, i, 3)
             || action_line617(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line617: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line617: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line624
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line624: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line624: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line624(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line624: not enough keys\n");
    return 1;
}

int lex_line624()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line624.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line624.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000177F) goto yy242;
        if (yych <= 0x000017FF) goto yy244;
yy242:
        YYSKIP ();
        status = check_key_count_line624(keys_count, i, 3)
             || action_line624(&i, keys, input, token, &cursor, 254);
        continue;
yy244:
        YYSKIP ();
        status = check_key_count_line624(keys_count, i, 3)
             || action_line624(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line624: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line624: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line631
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line631: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line631: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line631(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line631: not enough keys\n");
    return 1;
}

int lex_line631()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line631.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line631.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x000017FF) goto yy248;
        if (yych <= 0x000018AF) goto yy250;
yy248:
        YYSKIP ();
        status = check_key_count_line631(keys_count, i, 3)
             || action_line631(&i, keys, input, token, &cursor, 254);
        continue;
yy250:
        YYSKIP ();
        status = check_key_count_line631(keys_count, i, 3)
             || action_line631(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line631: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line631: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line638
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line638: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line638: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line638(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line638: not enough keys\n");
    return 1;
}

int lex_line638()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line638.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line638.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x000018FF) goto yy254;
        if (yych <= 0x0000194F) goto yy256;
yy254:
        YYSKIP ();
        status = check_key_count_line638(keys_count, i, 3)
             || action_line638(&i, keys, input, token, &cursor, 254);
        continue;
yy256:
        YYSKIP ();
        status = check_key_count_line638(keys_count, i, 3)
             || action_line638(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line638: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line638: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line645
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line645: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line645: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line645(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line645: not enough keys\n");
    return 1;
}

int lex_line645()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line645.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line645.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000194F) goto yy260;
        if (yych <= 0x0000197F) goto yy262;
yy260:
        YYSKIP ();
        status = check_key_count_line645(keys_count, i, 3)
             || action_line645(&i, keys, input, token, &cursor, 254);
        continue;
yy262:
        YYSKIP ();
        status = check_key_count_line645(keys_count, i, 3)
             || action_line645(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line645: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line645: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line652
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line652: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line652: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line652(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line652: not enough keys\n");
    return 1;
}

int lex_line652()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line652.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line652.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x000019DF) goto yy266;
        if (yych <= 0x000019FF) goto yy268;
yy266:
        YYSKIP ();
        status = check_key_count_line652(keys_count, i, 3)
             || action_line652(&i, keys, input, token, &cursor, 254);
        continue;
yy268:
        YYSKIP ();
        status = check_key_count_line652(keys_count, i, 3)
             || action_line652(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line652: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line652: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line659
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line659: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line659: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line659(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line659: not enough keys\n");
    return 1;
}

int lex_line659()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line659.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line659.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x00001CFF) goto yy272;
        if (yych <= 0x00001D7F) goto yy274;
yy272:
        YYSKIP ();
        status = check_key_count_line659(keys_count, i, 3)
             || action_line659(&i, keys, input, token, &cursor, 254);
        continue;
yy274:
        YYSKIP ();
        status = check_key_count_line659(keys_count, i, 3)
             || action_line659(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line659: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line659: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line666
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line666: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line666: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line666(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line666: not enough keys\n");
    return 1;
}

int lex_line666()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line666.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line666.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x00001DFF) goto yy278;
        if (yych <= 0x00001EFF) goto yy280;
yy278:
        YYSKIP ();
        status = check_key_count_line666(keys_count, i, 3)
             || action_line666(&i, keys, input, token, &cursor, 254);
        continue;
yy280:
        YYSKIP ();
        status = check_key_count_line666(keys_count, i, 3)
             || action_line666(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line666: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line666: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line673
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line673: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line673: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line673(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line673: not enough keys\n");
    return 1;
}

int lex_line673()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line673.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line673.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x00001EFF) goto yy284;
        if (yych <= 0x00001FFF) goto yy286;
yy284:
        YYSKIP ();
        status = check_key_count_line673(keys_count, i, 3)
             || action_line673(&i, keys, input, token, &cursor, 254);
        continue;
yy286:
        YYSKIP ();
        status = check_key_count_line673(keys_count, i, 3)
             || action_line673(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line673: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line673: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line680
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line680: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line680: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line680(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line680: not enough keys\n");
    return 1;
}

int lex_line680()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line680.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line680.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x00001FFF) goto yy290;
        if (yych <= 0x0000206F) goto yy292;
yy290:
        YYSKIP ();
        status = check_key_count_line680(keys_count, i, 3)
             || action_line680(&i, keys, input, token, &cursor, 254);
        continue;
yy292:
        YYSKIP ();
        status = check_key_count_line680(keys_count, i, 3)
             || action_line680(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line680: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line680: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line687
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line687: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line687: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line687(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line687: not enough keys\n");
    return 1;
}

int lex_line687()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line687.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line687.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000206F) goto yy296;
        if (yych <= 0x0000209F) goto yy298;
yy296:
        YYSKIP ();
        status = check_key_count_line687(keys_count, i, 3)
             || action_line687(&i, keys, input, token, &cursor, 254);
        continue;
yy298:
        YYSKIP ();
        status = check_key_count_line687(keys_count, i, 3)
             || action_line687(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line687: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line687: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line694
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line694: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line694: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line694(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line694: not enough keys\n");
    return 1;
}

int lex_line694()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line694.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line694.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000209F) goto yy302;
        if (yych <= 0x000020CF) goto yy304;
yy302:
        YYSKIP ();
        status = check_key_count_line694(keys_count, i, 3)
             || action_line694(&i, keys, input, token, &cursor, 254);
        continue;
yy304:
        YYSKIP ();
        status = check_key_count_line694(keys_count, i, 3)
             || action_line694(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line694: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line694: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line701
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line701: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line701: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line701(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line701: not enough keys\n");
    return 1;
}

int lex_line701()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line701.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line701.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x000020CF) goto yy308;
        if (yych <= 0x000020FF) goto yy310;
yy308:
        YYSKIP ();
        status = check_key_count_line701(keys_count, i, 3)
             || action_line701(&i, keys, input, token, &cursor, 254);
        continue;
yy310:
        YYSKIP ();
        status = check_key_count_line701(keys_count, i, 3)
             || action_line701(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line701: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line701: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line708
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line708: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line708: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line708(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line708: not enough keys\n");
    return 1;
}

int lex_line708()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line708.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line708.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x000020FF) goto yy314;
        if (yych <= 0x0000214F) goto yy316;
yy314:
        YYSKIP ();
        status = check_key_count_line708(keys_count, i, 3)
             || action_line708(&i, keys, input, token, &cursor, 254);
        continue;
yy316:
        YYSKIP ();
        status = check_key_count_line708(keys_count, i, 3)
             || action_line708(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line708: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line708: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line715
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line715: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line715: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line715(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line715: not enough keys\n");
    return 1;
}

int lex_line715()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line715.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line715.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000214F) goto yy320;
        if (yych <= 0x0000218F) goto yy322;
yy320:
        YYSKIP ();
        status = check_key_count_line715(keys_count, i, 3)
             || action_line715(&i, keys, input, token, &cursor, 254);
        continue;
yy322:
        YYSKIP ();
        status = check_key_count_line715(keys_count, i, 3)
             || action_line715(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line715: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line715: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line722
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line722: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line722: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line722(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line722: not enough keys\n");
    return 1;
}

int lex_line722()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line722.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line722.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000218F) goto yy326;
        if (yych <= 0x000021FF) goto yy328;
yy326:
        YYSKIP ();
        status = check_key_count_line722(keys_count, i, 3)
             || action_line722(&i, keys, input, token, &cursor, 254);
        continue;
yy328:
        YYSKIP ();
        status = check_key_count_line722(keys_count, i, 3)
             || action_line722(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line722: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line722: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line729
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line729: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line729: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line729(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line729: not enough keys\n");
    return 1;
}

int lex_line729()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line729.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line729.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x000021FF) goto yy332;
        if (yych <= 0x000022FF) goto yy334;
yy332:
        YYSKIP ();
        status = check_key_count_line729(keys_count, i, 3)
             || action_line729(&i, keys, input, token, &cursor, 254);
        continue;
yy334:
        YYSKIP ();
        status = check_key_count_line729(keys_count, i, 3)
             || action_line729(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line729: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line729: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line736
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line736: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line736: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line736(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line736: not enough keys\n");
    return 1;
}

int lex_line736()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line736.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line736.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x000022FF) goto yy338;
        if (yych <= 0x000023FF) goto yy340;
yy338:
        YYSKIP ();
        status = check_key_count_line736(keys_count, i, 3)
             || action_line736(&i, keys, input, token, &cursor, 254);
        continue;
yy340:
        YYSKIP ();
        status = check_key_count_line736(keys_count, i, 3)
             || action_line736(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line736: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line736: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line743
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line743: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line743: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line743(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line743: not enough keys\n");
    return 1;
}

int lex_line743()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line743.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line743.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x000023FF) goto yy344;
        if (yych <= 0x0000243F) goto yy346;
yy344:
        YYSKIP ();
        status = check_key_count_line743(keys_count, i, 3)
             || action_line743(&i, keys, input, token, &cursor, 254);
        continue;
yy346:
        YYSKIP ();
        status = check_key_count_line743(keys_count, i, 3)
             || action_line743(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line743: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line743: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line750
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line750: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line750: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line750(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line750: not enough keys\n");
    return 1;
}

int lex_line750()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line750.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line750.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000243F) goto yy350;
        if (yych <= 0x0000245F) goto yy352;
yy350:
        YYSKIP ();
        status = check_key_count_line750(keys_count, i, 3)
             || action_line750(&i, keys, input, token, &cursor, 254);
        continue;
yy352:
        YYSKIP ();
        status = check_key_count_line750(keys_count, i, 3)
             || action_line750(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line750: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line750: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line757
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line757: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line757: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line757(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line757: not enough keys\n");
    return 1;
}

int lex_line757()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line757.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line757.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000245F) goto yy356;
        if (yych <= 0x000024FF) goto yy358;
yy356:
        YYSKIP ();
        status = check_key_count_line757(keys_count, i, 3)
             || action_line757(&i, keys, input, token, &cursor, 254);
        continue;
yy358:
        YYSKIP ();
        status = check_key_count_line757(keys_count, i, 3)
             || action_line757(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line757: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line757: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line764
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line764: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line764: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line764(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line764: not enough keys\n");
    return 1;
}

int lex_line764()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line764.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line764.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x000024FF) goto yy362;
        if (yych <= 0x0000257F) goto yy364;
yy362:
        YYSKIP ();
        status = check_key_count_line764(keys_count, i, 3)
             || action_line764(&i, keys, input, token, &cursor, 254);
        continue;
yy364:
        YYSKIP ();
        status = check_key_count_line764(keys_count, i, 3)
             || action_line764(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line764: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line764: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line771
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line771: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line771: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line771(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line771: not enough keys\n");
    return 1;
}

int lex_line771()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line771.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line771.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000257F) goto yy368;
        if (yych <= 0x0000259F) goto yy370;
yy368:
        YYSKIP ();
        status = check_key_count_line771(keys_count, i, 3)
             || action_line771(&i, keys, input, token, &cursor, 254);
        continue;
yy370:
        YYSKIP ();
        status = check_key_count_line771(keys_count, i, 3)
             || action_line771(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line771: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line771: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line778
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line778: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line778: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line778(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line778: not enough keys\n");
    return 1;
}

int lex_line778()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line778.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line778.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000259F) goto yy374;
        if (yych <= 0x000025FF) goto yy376;
yy374:
        YYSKIP ();
        status = check_key_count_line778(keys_count, i, 3)
             || action_line778(&i, keys, input, token, &cursor, 254);
        continue;
yy376:
        YYSKIP ();
        status = check_key_count_line778(keys_count, i, 3)
             || action_line778(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line778: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line778: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line785
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line785: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line785: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line785(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line785: not enough keys\n");
    return 1;
}

int lex_line785()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line785.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line785.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x000025FF) goto yy380;
        if (yych <= 0x000026FF) goto yy382;
yy380:
        YYSKIP ();
        status = check_key_count_line785(keys_count, i, 3)
             || action_line785(&i, keys, input, token, &cursor, 254);
        continue;
yy382:
        YYSKIP ();
        status = check_key_count_line785(keys_count, i, 3)
             || action_line785(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line785: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line785: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line792
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line792: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line792: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line792(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line792: not enough keys\n");
    return 1;
}

int lex_line792()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line792.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line792.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x000026FF) goto yy386;
        if (yych <= 0x000027BF) goto yy388;
yy386:
        YYSKIP ();
        status = check_key_count_line792(keys_count, i, 3)
             || action_line792(&i, keys, input, token, &cursor, 254);
        continue;
yy388:
        YYSKIP ();
        status = check_key_count_line792(keys_count, i, 3)
             || action_line792(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line792: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line792: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line799
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line799: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line799: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line799(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line799: not enough keys\n");
    return 1;
}

int lex_line799()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line799.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line799.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x000027BF) goto yy392;
        if (yych <= 0x000027EF) goto yy394;
yy392:
        YYSKIP ();
        status = check_key_count_line799(keys_count, i, 3)
             || action_line799(&i, keys, input, token, &cursor, 254);
        continue;
yy394:
        YYSKIP ();
        status = check_key_count_line799(keys_count, i, 3)
             || action_line799(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line799: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line799: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line806
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line806: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line806: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line806(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line806: not enough keys\n");
    return 1;
}

int lex_line806()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line806.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line806.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x000027EF) goto yy398;
        if (yych <= 0x000027FF) goto yy400;
yy398:
        YYSKIP ();
        status = check_key_count_line806(keys_count, i, 3)
             || action_line806(&i, keys, input, token, &cursor, 254);
        continue;
yy400:
        YYSKIP ();
        status = check_key_count_line806(keys_count, i, 3)
             || action_line806(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line806: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line806: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line813
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line813: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line813: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line813(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line813: not enough keys\n");
    return 1;
}

int lex_line813()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line813.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line813.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x000027FF) goto yy404;
        if (yych <= 0x000028FF) goto yy406;
yy404:
        YYSKIP ();
        status = check_key_count_line813(keys_count, i, 3)
             || action_line813(&i, keys, input, token, &cursor, 254);
        continue;
yy406:
        YYSKIP ();
        status = check_key_count_line813(keys_count, i, 3)
             || action_line813(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line813: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line813: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line820
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line820: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line820: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line820(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line820: not enough keys\n");
    return 1;
}

int lex_line820()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line820.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line820.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x000028FF) goto yy410;
        if (yych <= 0x0000297F) goto yy412;
yy410:
        YYSKIP ();
        status = check_key_count_line820(keys_count, i, 3)
             || action_line820(&i, keys, input, token, &cursor, 254);
        continue;
yy412:
        YYSKIP ();
        status = check_key_count_line820(keys_count, i, 3)
             || action_line820(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line820: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line820: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line827
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line827: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line827: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line827(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line827: not enough keys\n");
    return 1;
}

int lex_line827()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line827.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line827.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000297F) goto yy416;
        if (yych <= 0x000029FF) goto yy418;
yy416:
        YYSKIP ();
        status = check_key_count_line827(keys_count, i, 3)
             || action_line827(&i, keys, input, token, &cursor, 254);
        continue;
yy418:
        YYSKIP ();
        status = check_key_count_line827(keys_count, i, 3)
             || action_line827(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line827: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line827: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line834
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line834: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line834: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line834(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line834: not enough keys\n");
    return 1;
}

int lex_line834()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line834.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line834.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x000029FF) goto yy422;
        if (yych <= 0x00002AFF) goto yy424;
yy422:
        YYSKIP ();
        status = check_key_count_line834(keys_count, i, 3)
             || action_line834(&i, keys, input, token, &cursor, 254);
        continue;
yy424:
        YYSKIP ();
        status = check_key_count_line834(keys_count, i, 3)
             || action_line834(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line834: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line834: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line841
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line841: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line841: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line841(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line841: not enough keys\n");
    return 1;
}

int lex_line841()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line841.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line841.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x00002AFF) goto yy428;
        if (yych <= 0x00002BFF) goto yy430;
yy428:
        YYSKIP ();
        status = check_key_count_line841(keys_count, i, 3)
             || action_line841(&i, keys, input, token, &cursor, 254);
        continue;
yy430:
        YYSKIP ();
        status = check_key_count_line841(keys_count, i, 3)
             || action_line841(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line841: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line841: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line848
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line848: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line848: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line848(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line848: not enough keys\n");
    return 1;
}

int lex_line848()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line848.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line848.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x00002E7F) goto yy434;
        if (yych <= 0x00002EFF) goto yy436;
yy434:
        YYSKIP ();
        status = check_key_count_line848(keys_count, i, 3)
             || action_line848(&i, keys, input, token, &cursor, 254);
        continue;
yy436:
        YYSKIP ();
        status = check_key_count_line848(keys_count, i, 3)
             || action_line848(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line848: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line848: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line855
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line855: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line855: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line855(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line855: not enough keys\n");
    return 1;
}

int lex_line855()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line855.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line855.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x00002EFF) goto yy440;
        if (yych <= 0x00002FDF) goto yy442;
yy440:
        YYSKIP ();
        status = check_key_count_line855(keys_count, i, 3)
             || action_line855(&i, keys, input, token, &cursor, 254);
        continue;
yy442:
        YYSKIP ();
        status = check_key_count_line855(keys_count, i, 3)
             || action_line855(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line855: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line855: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line862
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line862: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line862: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line862(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line862: not enough keys\n");
    return 1;
}

int lex_line862()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line862.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line862.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x00002FEF) goto yy446;
        if (yych <= 0x00002FFF) goto yy448;
yy446:
        YYSKIP ();
        status = check_key_count_line862(keys_count, i, 3)
             || action_line862(&i, keys, input, token, &cursor, 254);
        continue;
yy448:
        YYSKIP ();
        status = check_key_count_line862(keys_count, i, 3)
             || action_line862(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line862: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line862: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line869
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line869: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line869: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line869(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line869: not enough keys\n");
    return 1;
}

int lex_line869()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line869.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line869.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x00002FFF) goto yy452;
        if (yych <= 0x0000303F) goto yy454;
yy452:
        YYSKIP ();
        status = check_key_count_line869(keys_count, i, 3)
             || action_line869(&i, keys, input, token, &cursor, 254);
        continue;
yy454:
        YYSKIP ();
        status = check_key_count_line869(keys_count, i, 3)
             || action_line869(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line869: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line869: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line876
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line876: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line876: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line876(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line876: not enough keys\n");
    return 1;
}

int lex_line876()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line876.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line876.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000303F) goto yy458;
        if (yych <= 0x0000309F) goto yy460;
yy458:
        YYSKIP ();
        status = check_key_count_line876(keys_count, i, 3)
             || action_line876(&i, keys, input, token, &cursor, 254);
        continue;
yy460:
        YYSKIP ();
        status = check_key_count_line876(keys_count, i, 3)
             || action_line876(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line876: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line876: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line883
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line883: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line883: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line883(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line883: not enough keys\n");
    return 1;
}

int lex_line883()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line883.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line883.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000309F) goto yy464;
        if (yych <= 0x000030FF) goto yy466;
yy464:
        YYSKIP ();
        status = check_key_count_line883(keys_count, i, 3)
             || action_line883(&i, keys, input, token, &cursor, 254);
        continue;
yy466:
        YYSKIP ();
        status = check_key_count_line883(keys_count, i, 3)
             || action_line883(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line883: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line883: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line890
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line890: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line890: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line890(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line890: not enough keys\n");
    return 1;
}

int lex_line890()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line890.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line890.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x000030FF) goto yy470;
        if (yych <= 0x0000312F) goto yy472;
yy470:
        YYSKIP ();
        status = check_key_count_line890(keys_count, i, 3)
             || action_line890(&i, keys, input, token, &cursor, 254);
        continue;
yy472:
        YYSKIP ();
        status = check_key_count_line890(keys_count, i, 3)
             || action_line890(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line890: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line890: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line897
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line897: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line897: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line897(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line897: not enough keys\n");
    return 1;
}

int lex_line897()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line897.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line897.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000312F) goto yy476;
        if (yych <= 0x0000318F) goto yy478;
yy476:
        YYSKIP ();
        status = check_key_count_line897(keys_count, i, 3)
             || action_line897(&i, keys, input, token, &cursor, 254);
        continue;
yy478:
        YYSKIP ();
        status = check_key_count_line897(keys_count, i, 3)
             || action_line897(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line897: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line897: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line904
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line904: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line904: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line904(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line904: not enough keys\n");
    return 1;
}

int lex_line904()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line904.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line904.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000318F) goto yy482;
        if (yych <= 0x0000319F) goto yy484;
yy482:
        YYSKIP ();
        status = check_key_count_line904(keys_count, i, 3)
             || action_line904(&i, keys, input, token, &cursor, 254);
        continue;
yy484:
        YYSKIP ();
        status = check_key_count_line904(keys_count, i, 3)
             || action_line904(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line904: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line904: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line911
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line911: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line911: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line911(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line911: not enough keys\n");
    return 1;
}

int lex_line911()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line911.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line911.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000319F) goto yy488;
        if (yych <= 0x000031BF) goto yy490;
yy488:
        YYSKIP ();
        status = check_key_count_line911(keys_count, i, 3)
             || action_line911(&i, keys, input, token, &cursor, 254);
        continue;
yy490:
        YYSKIP ();
        status = check_key_count_line911(keys_count, i, 3)
             || action_line911(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line911: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line911: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line918
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line918: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line918: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line918(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line918: not enough keys\n");
    return 1;
}

int lex_line918()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line918.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line918.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x000031EF) goto yy494;
        if (yych <= 0x000031FF) goto yy496;
yy494:
        YYSKIP ();
        status = check_key_count_line918(keys_count, i, 3)
             || action_line918(&i, keys, input, token, &cursor, 254);
        continue;
yy496:
        YYSKIP ();
        status = check_key_count_line918(keys_count, i, 3)
             || action_line918(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line918: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line918: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line925
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line925: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line925: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line925(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line925: not enough keys\n");
    return 1;
}

int lex_line925()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line925.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line925.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x000031FF) goto yy500;
        if (yych <= 0x000032FF) goto yy502;
yy500:
        YYSKIP ();
        status = check_key_count_line925(keys_count, i, 3)
             || action_line925(&i, keys, input, token, &cursor, 254);
        continue;
yy502:
        YYSKIP ();
        status = check_key_count_line925(keys_count, i, 3)
             || action_line925(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line925: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line925: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line932
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line932: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line932: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line932(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line932: not enough keys\n");
    return 1;
}

int lex_line932()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line932.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line932.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x000032FF) goto yy506;
        if (yych <= 0x000033FF) goto yy508;
yy506:
        YYSKIP ();
        status = check_key_count_line932(keys_count, i, 3)
             || action_line932(&i, keys, input, token, &cursor, 254);
        continue;
yy508:
        YYSKIP ();
        status = check_key_count_line932(keys_count, i, 3)
             || action_line932(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line932: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line932: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line939
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line939: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line939: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line939(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line939: not enough keys\n");
    return 1;
}

int lex_line939()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line939.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line939.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x000033FF) goto yy512;
        if (yych <= 0x00004DBF) goto yy514;
yy512:
        YYSKIP ();
        status = check_key_count_line939(keys_count, i, 3)
             || action_line939(&i, keys, input, token, &cursor, 254);
        continue;
yy514:
        YYSKIP ();
        status = check_key_count_line939(keys_count, i, 3)
             || action_line939(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line939: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line939: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line946
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line946: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line946: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line946(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line946: not enough keys\n");
    return 1;
}

int lex_line946()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line946.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line946.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x00004DBF) goto yy518;
        if (yych <= 0x00004DFF) goto yy520;
yy518:
        YYSKIP ();
        status = check_key_count_line946(keys_count, i, 3)
             || action_line946(&i, keys, input, token, &cursor, 254);
        continue;
yy520:
        YYSKIP ();
        status = check_key_count_line946(keys_count, i, 3)
             || action_line946(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line946: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line946: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line953
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line953: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line953: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line953(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line953: not enough keys\n");
    return 1;
}

int lex_line953()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line953.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line953.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x00004DFF) goto yy524;
        if (yych <= 0x00009FFF) goto yy526;
yy524:
        YYSKIP ();
        status = check_key_count_line953(keys_count, i, 3)
             || action_line953(&i, keys, input, token, &cursor, 254);
        continue;
yy526:
        YYSKIP ();
        status = check_key_count_line953(keys_count, i, 3)
             || action_line953(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line953: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line953: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line960
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line960: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line960: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line960(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line960: not enough keys\n");
    return 1;
}

int lex_line960()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line960.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line960.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x00009FFF) goto yy530;
        if (yych <= 0x0000A48F) goto yy532;
yy530:
        YYSKIP ();
        status = check_key_count_line960(keys_count, i, 3)
             || action_line960(&i, keys, input, token, &cursor, 254);
        continue;
yy532:
        YYSKIP ();
        status = check_key_count_line960(keys_count, i, 3)
             || action_line960(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line960: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line960: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line967
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line967: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line967: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line967(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line967: not enough keys\n");
    return 1;
}

int lex_line967()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line967.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line967.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000A48F) goto yy536;
        if (yych <= 0x0000A4CF) goto yy538;
yy536:
        YYSKIP ();
        status = check_key_count_line967(keys_count, i, 3)
             || action_line967(&i, keys, input, token, &cursor, 254);
        continue;
yy538:
        YYSKIP ();
        status = check_key_count_line967(keys_count, i, 3)
             || action_line967(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line967: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line967: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line974
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line974: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line974: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line974(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line974: not enough keys\n");
    return 1;
}

int lex_line974()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line974.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line974.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000ABFF) goto yy542;
        if (yych <= 0x0000D7AF) goto yy544;
yy542:
        YYSKIP ();
        status = check_key_count_line974(keys_count, i, 3)
             || action_line974(&i, keys, input, token, &cursor, 254);
        continue;
yy544:
        YYSKIP ();
        status = check_key_count_line974(keys_count, i, 3)
             || action_line974(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line974: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line974: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line981
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line981: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line981: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line981(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line981: not enough keys\n");
    return 1;
}

int lex_line981()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line981.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line981.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000D7FF) goto yy548;
        if (yych <= 0x0000DB7F) goto yy550;
yy548:
        YYSKIP ();
        status = check_key_count_line981(keys_count, i, 3)
             || action_line981(&i, keys, input, token, &cursor, 254);
        continue;
yy550:
        YYSKIP ();
        status = check_key_count_line981(keys_count, i, 3)
             || action_line981(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line981: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line981: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line988
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line988: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line988: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line988(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line988: not enough keys\n");
    return 1;
}

int lex_line988()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line988.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line988.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000DB7F) goto yy554;
        if (yych <= 0x0000DBFF) goto yy556;
yy554:
        YYSKIP ();
        status = check_key_count_line988(keys_count, i, 3)
             || action_line988(&i, keys, input, token, &cursor, 254);
        continue;
yy556:
        YYSKIP ();
        status = check_key_count_line988(keys_count, i, 3)
             || action_line988(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line988: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line988: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line995
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line995: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line995: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line995(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line995: not enough keys\n");
    return 1;
}

int lex_line995()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line995.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line995.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000DBFF) goto yy560;
        if (yych <= 0x0000DFFF) goto yy562;
yy560:
        YYSKIP ();
        status = check_key_count_line995(keys_count, i, 3)
             || action_line995(&i, keys, input, token, &cursor, 254);
        continue;
yy562:
        YYSKIP ();
        status = check_key_count_line995(keys_count, i, 3)
             || action_line995(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line995: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line995: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line1002
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line1002: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line1002: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line1002(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line1002: not enough keys\n");
    return 1;
}

int lex_line1002()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line1002.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line1002.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000DFFF) goto yy566;
        if (yych <= 0x0000F8FF) goto yy568;
yy566:
        YYSKIP ();
        status = check_key_count_line1002(keys_count, i, 3)
             || action_line1002(&i, keys, input, token, &cursor, 254);
        continue;
yy568:
        YYSKIP ();
        status = check_key_count_line1002(keys_count, i, 3)
             || action_line1002(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line1002: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line1002: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line1009
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line1009: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line1009: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line1009(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line1009: not enough keys\n");
    return 1;
}

int lex_line1009()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line1009.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line1009.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000F8FF) goto yy572;
        if (yych <= 0x0000FAFF) goto yy574;
yy572:
        YYSKIP ();
        status = check_key_count_line1009(keys_count, i, 3)
             || action_line1009(&i, keys, input, token, &cursor, 254);
        continue;
yy574:
        YYSKIP ();
        status = check_key_count_line1009(keys_count, i, 3)
             || action_line1009(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line1009: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line1009: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line1016
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line1016: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line1016: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line1016(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line1016: not enough keys\n");
    return 1;
}

int lex_line1016()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line1016.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line1016.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000FAFF) goto yy578;
        if (yych <= 0x0000FB4F) goto yy580;
yy578:
        YYSKIP ();
        status = check_key_count_line1016(keys_count, i, 3)
             || action_line1016(&i, keys, input, token, &cursor, 254);
        continue;
yy580:
        YYSKIP ();
        status = check_key_count_line1016(keys_count, i, 3)
             || action_line1016(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line1016: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line1016: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line1023
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line1023: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line1023: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line1023(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line1023: not enough keys\n");
    return 1;
}

int lex_line1023()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line1023.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line1023.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000FB4F) goto yy584;
        if (yych <= 0x0000FDFF) goto yy586;
yy584:
        YYSKIP ();
        status = check_key_count_line1023(keys_count, i, 3)
             || action_line1023(&i, keys, input, token, &cursor, 254);
        continue;
yy586:
        YYSKIP ();
        status = check_key_count_line1023(keys_count, i, 3)
             || action_line1023(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line1023: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line1023: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line1030
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line1030: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line1030: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line1030(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line1030: not enough keys\n");
    return 1;
}

int lex_line1030()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line1030.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line1030.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000FDFF) goto yy590;
        if (yych <= 0x0000FE0F) goto yy592;
yy590:
        YYSKIP ();
        status = check_key_count_line1030(keys_count, i, 3)
             || action_line1030(&i, keys, input, token, &cursor, 254);
        continue;
yy592:
        YYSKIP ();
        status = check_key_count_line1030(keys_count, i, 3)
             || action_line1030(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line1030: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line1030: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line1037
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line1037: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line1037: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line1037(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line1037: not enough keys\n");
    return 1;
}

int lex_line1037()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line1037.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line1037.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000FE1F) goto yy596;
        if (yych <= 0x0000FE2F) goto yy598;
yy596:
        YYSKIP ();
        status = check_key_count_line1037(keys_count, i, 3)
             || action_line1037(&i, keys, input, token, &cursor, 254);
        continue;
yy598:
        YYSKIP ();
        status = check_key_count_line1037(keys_count, i, 3)
             || action_line1037(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line1037: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line1037: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line1044
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line1044: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line1044: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line1044(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line1044: not enough keys\n");
    return 1;
}

int lex_line1044()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line1044.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line1044.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000FE2F) goto yy602;
        if (yych <= 0x0000FE4F) goto yy604;
yy602:
        YYSKIP ();
        status = check_key_count_line1044(keys_count, i, 3)
             || action_line1044(&i, keys, input, token, &cursor, 254);
        continue;
yy604:
        YYSKIP ();
        status = check_key_count_line1044(keys_count, i, 3)
             || action_line1044(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line1044: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line1044: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line1051
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line1051: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line1051: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line1051(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line1051: not enough keys\n");
    return 1;
}

int lex_line1051()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line1051.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line1051.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000FE4F) goto yy608;
        if (yych <= 0x0000FE6F) goto yy610;
yy608:
        YYSKIP ();
        status = check_key_count_line1051(keys_count, i, 3)
             || action_line1051(&i, keys, input, token, &cursor, 254);
        continue;
yy610:
        YYSKIP ();
        status = check_key_count_line1051(keys_count, i, 3)
             || action_line1051(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line1051: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line1051: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line1058
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line1058: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line1058: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line1058(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line1058: not enough keys\n");
    return 1;
}

int lex_line1058()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line1058.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line1058.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000FE6F) goto yy614;
        if (yych <= 0x0000FEFF) goto yy616;
yy614:
        YYSKIP ();
        status = check_key_count_line1058(keys_count, i, 3)
             || action_line1058(&i, keys, input, token, &cursor, 254);
        continue;
yy616:
        YYSKIP ();
        status = check_key_count_line1058(keys_count, i, 3)
             || action_line1058(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line1058: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line1058: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line1065
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line1065: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line1065: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line1065(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line1065: not enough keys\n");
    return 1;
}

int lex_line1065()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line1065.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line1065.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000FEFF) goto yy620;
        if (yych <= 0x0000FFEF) goto yy622;
yy620:
        YYSKIP ();
        status = check_key_count_line1065(keys_count, i, 3)
             || action_line1065(&i, keys, input, token, &cursor, 254);
        continue;
yy622:
        YYSKIP ();
        status = check_key_count_line1065(keys_count, i, 3)
             || action_line1065(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line1065: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line1065: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line1072
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line1072: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line1072: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line1072(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line1072: not enough keys\n");
    return 1;
}

int lex_line1072()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line1072.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line1072.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0000FFEF) goto yy626;
        if (yych <= 0x0000FFFF) goto yy628;
yy626:
        YYSKIP ();
        status = check_key_count_line1072(keys_count, i, 3)
             || action_line1072(&i, keys, input, token, &cursor, 254);
        continue;
yy628:
        YYSKIP ();
        status = check_key_count_line1072(keys_count, i, 3)
             || action_line1072(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line1072: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line1072: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line1079
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line1079: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line1079: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line1079(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line1079: not enough keys\n");
    return 1;
}

int lex_line1079()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line1079.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.u--skeleton--encoding-policy(ignore).c.line1079.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x00001DFF) {
            if (yych <= 0x000018AF) {
                if (yych <= 0x000007BF) {
                    if (yych <= 0x0000074F) goto yy632;
                    if (yych <= 0x0000077F) goto yy634;
                } else {
                    if (yych <= 0x000008FF) goto yy634;
                    if (yych <= 0x0000137F) goto yy632;
                    if (yych <= 0x0000139F) goto yy634;
                }
            } else {
                if (yych <= 0x000019DF) {
                    if (yych <= 0x000018FF) goto yy634;
                    if (yych >= 0x00001980) goto yy634;
                } else {
                    if (yych <= 0x000019FF) goto yy632;
                    if (yych <= 0x00001CFF) goto yy634;
                    if (yych >= 0x00001D80) goto yy634;
                }
            }
        } else {
            if (yych <= 0x0000A4CF) {
                if (yych <= 0x00002FDF) {
                    if (yych <= 0x00002BFF) goto yy632;
                    if (yych <= 0x00002E7F) goto yy634;
                } else {
                    if (yych <= 0x00002FEF) goto yy634;
                    if (yych <= 0x000031BF) goto yy632;
                    if (yych <= 0x000031EF) goto yy634;
                }
            } else {
                if (yych <= 0x0000D7FF) {
                    if (yych <= 0x0000ABFF) goto yy634;
                    if (yych >= 0x0000D7B0) goto yy634;
                } else {
                    if (yych <= 0x0000FE0F) goto yy632;
                    if (yych <= 0x0000FE1F) goto yy634;
                    if (yych >= 0x00010000) goto yy634;
                }
            }
        }
yy632:
        YYSKIP ();
        status = check_key_count_line1079(keys_count, i, 3)
             || action_line1079(&i, keys, input, token, &cursor, 0);
        continue;
yy634:
        YYSKIP ();
        status = check_key_count_line1079(keys_count, i, 3)
             || action_line1079(&i, keys, input, token, &cursor, 254);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line1079: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line1079: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

int main()
{
    if(lex_line1002() != 0) {
        return 1;
    }
    if(lex_line1009() != 0) {
        return 1;
    }
    if(lex_line1016() != 0) {
        return 1;
    }
    if(lex_line1023() != 0) {
        return 1;
    }
    if(lex_line1030() != 0) {
        return 1;
    }
    if(lex_line1037() != 0) {
        return 1;
    }
    if(lex_line1044() != 0) {
        return 1;
    }
    if(lex_line1051() != 0) {
        return 1;
    }
    if(lex_line1058() != 0) {
        return 1;
    }
    if(lex_line1065() != 0) {
        return 1;
    }
    if(lex_line1072() != 0) {
        return 1;
    }
    if(lex_line1079() != 0) {
        return 1;
    }
    if(lex_line344() != 0) {
        return 1;
    }
    if(lex_line351() != 0) {
        return 1;
    }
    if(lex_line358() != 0) {
        return 1;
    }
    if(lex_line365() != 0) {
        return 1;
    }
    if(lex_line372() != 0) {
        return 1;
    }
    if(lex_line379() != 0) {
        return 1;
    }
    if(lex_line386() != 0) {
        return 1;
    }
    if(lex_line393() != 0) {
        return 1;
    }
    if(lex_line400() != 0) {
        return 1;
    }
    if(lex_line407() != 0) {
        return 1;
    }
    if(lex_line414() != 0) {
        return 1;
    }
    if(lex_line421() != 0) {
        return 1;
    }
    if(lex_line428() != 0) {
        return 1;
    }
    if(lex_line435() != 0) {
        return 1;
    }
    if(lex_line442() != 0) {
        return 1;
    }
    if(lex_line449() != 0) {
        return 1;
    }
    if(lex_line456() != 0) {
        return 1;
    }
    if(lex_line463() != 0) {
        return 1;
    }
    if(lex_line470() != 0) {
        return 1;
    }
    if(lex_line477() != 0) {
        return 1;
    }
    if(lex_line484() != 0) {
        return 1;
    }
    if(lex_line491() != 0) {
        return 1;
    }
    if(lex_line498() != 0) {
        return 1;
    }
    if(lex_line505() != 0) {
        return 1;
    }
    if(lex_line512() != 0) {
        return 1;
    }
    if(lex_line519() != 0) {
        return 1;
    }
    if(lex_line526() != 0) {
        return 1;
    }
    if(lex_line533() != 0) {
        return 1;
    }
    if(lex_line540() != 0) {
        return 1;
    }
    if(lex_line547() != 0) {
        return 1;
    }
    if(lex_line554() != 0) {
        return 1;
    }
    if(lex_line561() != 0) {
        return 1;
    }
    if(lex_line568() != 0) {
        return 1;
    }
    if(lex_line575() != 0) {
        return 1;
    }
    if(lex_line582() != 0) {
        return 1;
    }
    if(lex_line589() != 0) {
        return 1;
    }
    if(lex_line596() != 0) {
        return 1;
    }
    if(lex_line603() != 0) {
        return 1;
    }
    if(lex_line610() != 0) {
        return 1;
    }
    if(lex_line617() != 0) {
        return 1;
    }
    if(lex_line624() != 0) {
        return 1;
    }
    if(lex_line631() != 0) {
        return 1;
    }
    if(lex_line638() != 0) {
        return 1;
    }
    if(lex_line645() != 0) {
        return 1;
    }
    if(lex_line652() != 0) {
        return 1;
    }
    if(lex_line659() != 0) {
        return 1;
    }
    if(lex_line666() != 0) {
        return 1;
    }
    if(lex_line673() != 0) {
        return 1;
    }
    if(lex_line680() != 0) {
        return 1;
    }
    if(lex_line687() != 0) {
        return 1;
    }
    if(lex_line694() != 0) {
        return 1;
    }
    if(lex_line701() != 0) {
        return 1;
    }
    if(lex_line708() != 0) {
        return 1;
    }
    if(lex_line715() != 0) {
        return 1;
    }
    if(lex_line722() != 0) {
        return 1;
    }
    if(lex_line729() != 0) {
        return 1;
    }
    if(lex_line736() != 0) {
        return 1;
    }
    if(lex_line743() != 0) {
        return 1;
    }
    if(lex_line750() != 0) {
        return 1;
    }
    if(lex_line757() != 0) {
        return 1;
    }
    if(lex_line764() != 0) {
        return 1;
    }
    if(lex_line771() != 0) {
        return 1;
    }
    if(lex_line778() != 0) {
        return 1;
    }
    if(lex_line785() != 0) {
        return 1;
    }
    if(lex_line792() != 0) {
        return 1;
    }
    if(lex_line799() != 0) {
        return 1;
    }
    if(lex_line806() != 0) {
        return 1;
    }
    if(lex_line813() != 0) {
        return 1;
    }
    if(lex_line820() != 0) {
        return 1;
    }
    if(lex_line827() != 0) {
        return 1;
    }
    if(lex_line834() != 0) {
        return 1;
    }
    if(lex_line841() != 0) {
        return 1;
    }
    if(lex_line848() != 0) {
        return 1;
    }
    if(lex_line855() != 0) {
        return 1;
    }
    if(lex_line862() != 0) {
        return 1;
    }
    if(lex_line869() != 0) {
        return 1;
    }
    if(lex_line876() != 0) {
        return 1;
    }
    if(lex_line883() != 0) {
        return 1;
    }
    if(lex_line890() != 0) {
        return 1;
    }
    if(lex_line897() != 0) {
        return 1;
    }
    if(lex_line904() != 0) {
        return 1;
    }
    if(lex_line911() != 0) {
        return 1;
    }
    if(lex_line918() != 0) {
        return 1;
    }
    if(lex_line925() != 0) {
        return 1;
    }
    if(lex_line932() != 0) {
        return 1;
    }
    if(lex_line939() != 0) {
        return 1;
    }
    if(lex_line946() != 0) {
        return 1;
    }
    if(lex_line953() != 0) {
        return 1;
    }
    if(lex_line960() != 0) {
        return 1;
    }
    if(lex_line967() != 0) {
        return 1;
    }
    if(lex_line974() != 0) {
        return 1;
    }
    if(lex_line981() != 0) {
        return 1;
    }
    if(lex_line988() != 0) {
        return 1;
    }
    if(lex_line995() != 0) {
        return 1;
    }
    return 0;
}
             `  @            	  
  `  @   
             `  @                `  @                `   @!   "   #  #  $  %  &  `'  @(   )   *  *  +  ,  -  `.  @/   0   1  1  2  3  4  `5  @6   7   8  8  9  :  ;  `<  @=   >   ?  ?  @  A  B  `C  @D   E   F  F  G  H  I  `J  @K   L   M  M  N  O  P  `Q  @R   S   T  T  U  V  W  `X  @Y   Z   [  [  \  ]  ^  `_  @`   a   b  b  c  d  e  `f  @g   h   i  i  j  k  l  `m  @n   o   p  p  q  r  s  `t  @u   v   w  w  x  y  z  `{  @|   }   ~  ~        `  @                `  @                `  @                `  @                `  @                `  @                `  @                `  @                `  @                `  @                `  @                `  @                `  @                `  @          	  ) 9 #I *Y 1i 8y ? F M T [ b i p w	 ~ ) 9 I Y i y    Ĺ     	  ) 9 J 
Z j z  & - 4 ; B I P W
 ^ e* l: sJ zZ j z         
  * : J Z j z   
   " ) 0 7 > E+ L; SK Z[ ak h{ o v }        + ; K [ k { ߋ      	    %, ,< 3L :\ Al H| O V ] d k r y  	 	 ,	 <	 L	 \	 l	 |	 	 Ɯ	 ͬ	 Լ	 	 	 	 	 
 
 -
 =
 M
 ]
 !m
 (}
 /
 6
 =
 D
 K
 R
 Y
 `
 g
 n u- |= M ] m }         
  - = M ] n ~    $ + 2 9 @ G
 N
 U.
 \>
 cN
 j^
 qn
 x~
 
 
 
 
 
 
 
 
   . > N ^ n ~          ' . 5/ <? CO J_ Qo X _ f m t {      / ? O _ o  Ϗ ֟ ݯ           2  K  d  }              ,  E  ^  w            
  &  ?  X  q                 9  R  k                3  L  e  ~              -  F  _  x              '  @  Y  r              !  :  S  l                4  M  f                .  G  `  y              (  A  Z  s            	  "  ;  T  m                5  N  g                /  H  a  z              )  B  [  t            
  #  <  U  n                6  O  h                0  I  b  {              *  C  \  u              $  =  V  o                7  P  i                1  J  c  |              +  D  ]  v              %  >  W  p                8  Q  j                                                                                                                                                                                                                                                                                                      	  
      
          {  t  m  f  _  X  Q  J  C  <  5  .  '        !  "  #  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  x6  q7  j8  c9  \:  U;  N<  G=  @>  9?  2@  +A  $B  C  D  E  F  G  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  |Y  uZ  n[  g\  `]  Y^  R_  K`  Da  =b  6c  /d  (e  !f  g  h  i  j  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  y}  r~  k  d  ]  V  O  H  A  :  3  ,  %        	            ߒ  ؓ  є  ʕ  Ö                    }  v  o  h  a  Z  S  L  E  >  7  0  )  "      
              ܶ  շ  θ  ǹ                      z  s  l  e  ^  W  P  I  B  ;  4  -  &        
                                        ~  w  p  i  b  [  T  M  F  ?  8  1  *  #                
 + ; K [ #k ({ - 2 7 < A F K P U Z _+ d; iK n[ sk x{ }          + ; K [ k { ͋ қ ׫ ܻ       + < 	L \ l |  " ' , 1 6 ; @ E J O, T< YL ^\ cl h| m r w |       , < L \ l |   Ǭ ̼       , < L \ m } 
    ! & + 0 5
 : ?- D= IM N] Sm X} ] b g l q v {  
	 	 -	 =	 M	 ]	 m	 }	 	 	 	 	 	 	 	 	 
 
 -
 =
 M
 ]
 m
 }
 
 
 
 
 
 
 
  
 % * /. 4> 9N >^ Cn H~ M R W \ a f k p u z . > N ^ n ~         
 
 .
 >
 N
 ^
 n
 ~
 
 
 
 
 
 
 
 
   / $? )O ._ 3o 8 = B G L Q V [ ` e j o/ t? yO ~_ o            / ? O _ o  ݏ                   
                         "  $  &  (  *  ,  .  0  2  4  6  8  :  <  >  @  B  D  F  H  J  L  N  P  R  T  V  X  Z  \  ^  `  b  d  f  h  j  l  n  p  r  t  v  x  z  |  ~                                                                                                                                             
                         "  $  &  (  *  ,  .  0  2  4  6  8  :  <  >  @  B  D  F  H  J  L  N  P  R  T  V  X  Z  \  ^  `  b  d  f  h  j  l  n  p  r  t  v  x  z  |  ~                                                                                                                                                                                                                                                                                                                                                                                                                            	  
      
                        ~  y  t  o  j  e  `  [   V!  Q"  L#  G$  B%  =&  8'  3(  .)  )*  $+  ,  -  .  /  0  1  2  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  zL  uM  pN  kO  fP  aQ  \R  WS  RT  MU  HV  CW  >X  9Y  4Z  /[  *\  %]   ^  _  `  a  b  c  d  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  {~  v  q  l  g  b  ]  X  S  N  I  D  ?  :  5  0  +  &  !        
                    ۝  ֞  џ  ̠  ǡ  ¢                            |  w  r  m  h  c  ^  Y  T  O  J  E  @  ;  6  1  ,  '  "          	                                                        }  x  s  n  i  d  _  Z  U  P  K  F  A  <  7  2  -  (  #          
      P  U Z _+ d; iK n[ sk x{ }          + ; K [ k { ͋ қ ׫ ܻ       + < 	L \ l |  " ' , 1 6 ; @ E J O, T< YL ^\ cl h| m r w |       , < L \ l |   Ǭ ̼       , < L \ m } 
    ! & + 0 5
 : ?- D= IM N] Sm X} ] b g l q v {  
  - = M ] m }         
	 	 -	 =	 M	 ]	 m	 }	 	 	 	 	 	 	 	  	 %
 *
 /.
 4>
 9N
 >^
 Cn
 H~
 M
 R
 W
 \
 a
 f
 k
 p
 u z . > N ^ n ~           . > N ^ n ~         
 
 /
 $?
 )O
 ._
 3o
 8
 =
 B
 G
 L
 Q
 V
 [
 `
 e j o/ t? yO ~_ o            / ? O _ o  ݏ           
  0 @ P ` #p ( - 2 7 < A F K                     	  
      
                                         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O                                                                                                         	  
      
                                      |   x!  t"  p#  l$  h%  d&  `'  \(  X)  T*  P+  L,  H-  D.  @/  <0  81  42  03  ,4  (5  $6   7  8  9  :  ;  <  =  >   ?  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  |_  x`  ta  pb  lc  hd  de  `f  \g  Xh  Ti  Pj  Lk  Hl  Dm  @n  <o  8p  4q  0r  ,s  (t  $u   v  w  x  y  z  {  |  }   ~  ~                ܆  ؇  Ԉ  Љ  ̊  ȋ  Č                                    |  x  t  p  l  h  d  `  \  X  T  P  L  H  D  @  <  8  4  0  ,  (  $                                                                                      |  x  t  p  l  h  d  `  \  X  T  P  L  H  D  @  <  8  4  0  ,  (  $                   O       . > 
N ^ n ~          " $ &. (> *N ,^ .n 0~ 2 4 6 8 : < > @ B D F. H> JN L^ Nn P~ R T V X Z \ ^ ` b d f. h> jN l^ nn p~ r t v x z | ~    . > N ^ n ~           . > N ^ n ~           . > N ^ n ~ Ҏ Ԟ ֮ ؾ       . > N ^ n ~          	 	 /	 ?	 
O	 _	 o	 	 	 	 	 	 	 	 	  	 "
 $
 &/
 (?
 *O
 ,_
 .o
 0
 2
 4
 6
 8
 :
 <
 >
 @
 B D F/ H? JO L_ No P R T V X Z \ ^ ` b d f/ h? jO l_ no p r t v x z | ~  
 
 /
 ?
 O
 _
 o
 
 
 
 
 
 
 
 
 
   / ? O _ o            / ? O _ o  ҏ ԟ ֯ ؿ       / ? O _ o          P  S  V  Y  \  _  b  e  h  k  n  q  t  w  z  }                                                                                              
  
              "  %  (  +  .  1  4  7  :  =  @  C  F  I  L  O  R  U  X  [  ^  a  d  g  j  m  p  s  v  y  |                                                                                               	                !  $  '  *  -  0  3  6  9  <  ?  B  E  H  K  N  Q  T  W  Z  ]  `  c  f  i  l  o  r  u  x  {  ~                                                                                                                                                                                                                                                                                                                                                     	  
      
                                         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  ~@  |A  zB  xC  vD  tE  rF  pG  nH  lI  jJ  hK  fL  dM  bN  `O  ^P  \Q  ZR  XS  VT  TU  RV  PW  NX  LY  JZ  H[  F\  D]  B^  @_  >`  <a  :b  8c  6d  4e  2f  0g  .h  ,i  *j  (k  &l  $m  "n   o  p  q  r  s  t  u  v  w  x  y  
z  {  |  }  ~                                     ޏ  ܐ  ڑ  ؒ  ֓  Ԕ  ҕ  Ж  Η  ̘  ʙ  Ț  ƛ  Ĝ                                                                      ~  |  z  x  v  t  r  p  n  l  j  h  f  d  b  `  ^  \  Z  X  V  T  R  P  N  L  J  H  F  D  B  @  >  <  :  8  6  4  2  0  .  ,  *  (  &  $  "                         
                . > N ^ n  ~ " $ & ( * , . 0 2 4 6. 8> :N <^ >n @~ B D F H J L N P R T V. X> ZN \^ ^n `~ b d f h j l n p r t v. x> zN |^ ~n ~           . > N ^ n ~           . > N ^ n ~  Ğ Ʈ Ⱦ       . > N ^ n ~           . > N ^ n       
    	 	 /	 ?	 O	 _	 o	  	 "	 $	 &	 (	 *	 ,	 .	 0	 2
 4
 6/
 8?
 :O
 <_
 >o
 @
 B
 D
 F
 H
 J
 L
 N
 P
 R T V/ X? ZO \_ ^o ` b d f h j l n p r t v/ x? zO |_ ~o          
 
 /
 ?
 O
 _
 o
 
 
 
 
 
 
 
 
 
   / ? O _ o   ğ Ư ȿ       / ? O _ o            / ? O _ o       
                       	  
      
                                             	  
      
                                         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~      ~  }  |  {  z  y  x  w  v  u  t  s  r  q  p  o  n  m  l  k  j  i  h  g  f  e  d  c  b  a  `  _  ^  ]  \  [  Z  Y  X  W  V  U  T  S  R  Q  P  O  N  M  L  K  J  I  H  G  F  E  D  C  B  A  @  ?  >  =  <  ;  :  9  8  7  6  5  4  3  2  1  0  /  .  -  ,  +  *  )  (  '  &  %  $  #  "  !                                         
      
  	                    0  2 4 6. 8> :N <^ >n @~ B D F H J L N P R T V. X> ZN \^ ^n `~ b d f h j l n p r t v. x> zN |^ ~n ~           . > N ^ n ~           . > N ^ n ~  Ğ Ʈ Ⱦ       . > N ^ n ~           . > N ^ n       
      / ? O _ o   " $ & ( * , . 0 2	 4	 6/	 8?	 :O	 <_	 >o	 @	 B	 D	 F	 H	 J	 L	 N	 P	 R
 T
 V/
 X?
 ZO
 \_
 ^o
 `
 b
 d
 f
 h
 j
 l
 n
 p
 r t v/ x? zO |_ ~o            / ? O _ o          
 
 /
 ?
 O
 _
 o
 
 
 ğ
 Ư
 ȿ
 
 
 
 
   / ? O _ o            / ? O _ o       
        0 @ P ` p   " $ & ( * , .     !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /                                         	  
      
                                         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~      ~  }  |  {  z  y  x  w  v  u  t  s  r  q  p  o  n  m  l  k  j  i  h  g  f  e  d  c  b  a  `  _  ^  ]  \  [  Z  Y  X  W  V  U  T  S  R  Q  P  O  N  M  L  K  J  I  H  G  F  E  D  C  B  A  @  ?  >  =  <  ;  :  9  8  7  6  5  4  3  2  1  0  /  .  -  ,  +  *  )  (  '  &  %  $  #  "  !                                         
      
  	                  /  P  R T V. X> ZN \^ ^n `~ b d f h j l n p r t v. x> zN |^ ~n ~           . > N ^ n ~           . > N ^ n ~  Ğ Ʈ Ⱦ       . > N ^ n ~           . > N ^ n       
      / ? O _ o   " $ & ( * , . 0 2 4 6/ 8? :O <_ >o @ B D F H J L N P R	 T	 V/	 X?	 ZO	 \_	 ^o	 `	 b	 d	 f	 h	 j	 l	 n	 p	 r
 t
 v/
 x?
 zO
 |_
 ~o
 
 
 
 
 
 
 
 
 
   / ? O _ o            / ? O _ o   ğ Ư ȿ     
 
 /
 ?
 O
 _
 o
 
 
 
 
 
 
 
 
 
   / ? O _ o       
        0 @ P ` p   " $ & ( * , . 0  2 4  60 8@ :P <` >p @ B D F H J L N  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O                                                         	  
      
                                         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~      ~  }  |  {  z  y  x  w  v  u  t  s  r  q  p  o  n  m  l  k  j  i  h  g  f  e  d  c  b  a  `  _  ^  ]  \  [  Z  Y  X  W  V  U  T  S  R  Q  P  O  N  M  L  K  J  I  H  G  F  E  D  C  B  A  @  ?  >  =  <  ;  :  9  8  7  6  5  4  3  2  1  0  /  .  -  ,  +  *  )  (  '  &  %  $  #  "  !                                         
      
  	                  O  p  r t v. x> zN |^ ~n ~           . > N ^ n ~           . > N ^ n ~  Ğ Ʈ Ⱦ       . > N ^ n ~           . > N ^ n       
      / ? O _ o   " $ & ( * , . 0 2 4 6/ 8? :O <_ >o @ B D F H J L N P R T V/ X? ZO \_ ^o ` b d f h j l n p r	 t	 v/	 x?	 zO	 |_	 ~o	 	 	 	 	 	 	 	 	 	 
 
 /
 ?
 O
 _
 o
 
 
 
 
 
 
 
 
 
   / ? O _ o   ğ Ư ȿ       / ? O _ o          
 
 /
 ?
 O
 _
 o
  
 
 
 
 
 

 
 
      0 @ P ` p   " $ & ( * , . 0  2 4  60 8@ :P <` >p @ B D F H J L N P  R T  V0 X@ ZP \` ^p ` b d f h j l n  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o                                                         	  
      
                                         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~      ~  }  |  {  z  y  x  w  v  u  t  s  r  q  p  o  n  m  l  k  j  i  h  g  f  e  d  c  b  a  `  _  ^  ]  \  [  Z  Y  X  W  V  U  T  S  R  Q  P  O  N  M  L  K  J  I  H  G  F  E  D  C  B  A  @  ?  >  =  <  ;  :  9  8  7  6  5  4  3  2  1  0  /  .  -  ,  +  *  )  (  '  &  %  $  #  "  !                                         
      
  	                  o       / ? O _ o  	 
   
      / ? O _ o           ! " #/ $? %O &_ 'o ( ) * + , - . / 0 1 2 3/ 4? 5O 6_ 7o 8 9 : ; < = > ? @ A B C/ D? EO F_ Go H I J K L M N O P Q R S/ T? UO V_ Wo X Y Z [ \ ] ^ _ ` a b c/ d? eO f_ go h i j k l m n o p q r s/ t? uO v_ wo x y z { | } ~   	 	 /	 ?	 O	 _	 o	 	 	 	 	 	 	 	 	 	 
 
 /
 ?
 O
 _
 o
 
 
 
 
 
 
 
 
 
   / ? O _ o            / ? O _ o          
 
 /
 ?
 O
 _
 o
 
 ɏ
 ʟ
 ˯
 ̿
 
 
 
 
   / ? O _ o  ُ ڟ ۯ ܿ       / ? O _ o            / ? O _ o          p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                                                                                                                                                                                                                                                                                                                                                                                                                                           	  
      
                                         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~      ~  }  |  {  z  y  x  w  v  u  t  s  r  q  p  o  n  m  l  k  j  i  h  g  f  e  d  c  b  a  `  _  ^  ]  \  [  Z  Y  X  W  V  U  T  S  R  Q  P  O  N  M  L  K  J  I  H  G  F  E  D  C  B  A  @  ?  >  =  <  ;  :  9  8  7  6  5  4  3  2  1  0  /  .  -  ,  +  *  )  (  '  &  %  $  #  "  !                                         
      
  	                        / ? O _ o               0 @ P ` p  	 
   
        0 @ P ` p            ! "  #0 $@ %P &` 'p ( ) * + , - . / 0  1 2  30 4@ 5P 6` 7p 8 9 : ; < = > ? @  A B  C0 D@ EP F` Gp H I J K L M N O P  Q R  S0 T@ UP V` Wp X Y Z [ \ ] ^ _ `  a b  c0 d@ eP f` gp h i j k l m n o p 	 q	 r 	 s0	 t@	 uP	 v`	 wp	 x	 y	 z	 {	 |	 }	 ~	 	  
 
  
 0
 @
 P
 `
 p
 
 
 
 
 
 
 
 
      0 @ P ` p              0 @ P ` p          
 
  
 0
 @
 P
 `
 p
 
 
 
 
 
 
 
 
      0 @ P ` p Ȁ ɐ ʠ ˰          0 @ P ` p ؀ ِ ڠ ۰          0 @ P ` p                             	  
      
                                         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 	   
         
                                                             !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /   0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?   @   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O   P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _   `   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o   p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~                                                                                                                                                                                                                                                                                                                                                                                                                0  @  P  `  p                          0  @  P  `  p                          0  @  P  `  p                          0  @  P  `  p                          0  @  P  `  p                          0  @  P  `  p                          0  @  P  `  p                          0  @  P  `  p                   	  	   	  0	  @	  P	  `	  p	  	  	  	  	  	  	  	  	   
  
   
  0
  @
  P
  `
  p
  
  
  
  
  
  
  
  
          0  @  P  `  p                          0  @  P  `  p                   
  
   
  0
  @
  P
  `
  p
  
  
  
  
  
  
  
  
          0  @  P  `  p                          0  @  P  `  p                          0  @  P  `  p                                                                                   (   0   8   @   H   P   X   `   h   p   x                                                               (  0  8  @  H  P  X  `  h  p  x                                              (  0  8  @  H  P  X  `  h  p  x                                              (  0  8  @  H  P  X  `  h  p  x                                              (  0  8  @  H  P  X  `  h  p  x                                              (  0  8  @  H  P  X  `  h  p  x                                              (  0  8  @  H  P  X  `  h  p  x                                              (  0  8  @  H  O                                                                                                                                   	  	  	  !	  ,	  7	  B	  M	  X	  c	  n	  y	  	  	  	  	  	  	  	  	  	  	  	  	  
  
  
  )
  4
  ?
  J
  U
  `
  k
  v
  
  
  
  
  
  
  
  
  
  
  
  
        &  1  <  G  R  ]  h  s  ~                          
    #  .  9  D  O  Z  e  p  {                          

  
   
  +
  6
  A
  L
  W
  b
  m
  x
  
  
  
  
  
  
  
  
  
  
  
  
        (  3  >  I  T  _  j  u                                %  0  ;  F  Q  \  g  r  }                              "  -  8  C  N  Y  d  o  z                          	      *  5  @  K  V  a  l  w                                '  2  =  H  S  ^  i  t                                $  /  :  E  P  [  f  q  |                                                 $  *  0  6  <  B  H  N  T  Z  `  f  l  r  x  ~                                                         &  ,  2  8  >  D  J  P  V  \  b  h  n  t  z                                                
        "  (  .  4  :  @  F  L  R  X  ^  d  j  p  v  |                                                         $  *  0  6  <  B  H  N  T  Z  `  f  l  r  x  ~                                                         &  ,  2  8  >  D  J  P  V  \  b  h  n  t  z                                       	  
      
                                         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                                                                                       	  
      
                                         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~           *  8  F  T  b  p  ~                    
    &  4  B  P  ^  l  z                          "   0   >   L   Z   h   v                              !  !  !  ,!  :!  H!  V!  d!  r!  !  !  !  !  !  !  !  !  !  !  "  "  ("  6"  D"  R"  `"  n"  |"  "  "  "  "  "  "  "  "  "  #  #  $#  2#  @#  N#  \#  j#  x#  #  #  #  #  #  #  #  #  #  $  $   $  .$  <$  J$  X$  f$  t$  $  $  $  $  $  $  $  $  $   %  %  %  *%  8%  F%  T%  b%  p%  ~%  %  %  %  %  %  %  %  %  %  
&  &  &&  4&  B&  P&  ^&  l&  z&  &  &  &  &  &  &  &  &  &  '  '  "'  0'  >'  L'  Z'  h'  v'  '  '  '  '  '  '  '  '  '  (  (  (  ,(  :(  H(  V(  d(  r(  (  (  (  (  (  (  (  (  (  (  )  )  ()  6)  D)  R)  `)  n)  |)  )  )  )  )  )  )  )  )  )  *  *  $*  2*  @*  N*  \*  j*  x*  *  *  *  *  *  *  *  *  *  +  +   +  .+  <+  J+  X+  f+  t+  +  +  +  +  +  +  +  +  +  +  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .   /  /  /  /  /  
/  /  /  /  /  /  /  /  /  /  /   /  "/  $/  &/  (/  */  ,/  ./  0/  2/  4/  6/  8/  :/  </  >/  @/  B/  D/  F/  H/  J/  L/  N/  P/  R/  T/  V/  X/  Z/  \/  ^/  `/  b/  d/  f/  h/  j/  l/  n/  p/  r/  t/  v/  x/  z/  |/  ~/  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /   0  0  0  0  0  
0  0  0  0  0  0  0  0  0  0  0   0  "0  $0  &0  (0  *0  ,0  .0  00  20  40  60  80  :0  <0  >0  @0  B0  D0  F0  H0  J0  L0  N0  P0  R0  T0  V0  X0  Z0  \0  ^0  `0  b0  d0  f0  h0  j0  l0  n0  p0  r0  t0  v0  x0  z0  |0  ~0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0   1  1  1  1  1  
1  1  1  1  1  1  1  1  1  1  1   1  "1  $1  &1  (1  *1  ,1  .1  01  21  41  61  81  :1  <1  >1  @1  B1  D1  F1  H1  J1  L1  N1  P1  R1  T1  V1  X1  Z1  \1  ^1  `1  b1  d1  f1  h1  j1  l1  n1  p1  r1  t1  v1  x1  z1  |1  ~1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  c2  2  I3  3  /4  4  5  5  5  n6  6  T7  7  :8  8   9  9  :  y:  :  _;  ;  E<  <  +=  =  >  >  >  j?  ?  P@  @  6A  A  B  B  C  uC  C  [D  D  AE  E  'F  F  
G  G  G  fH  H  LI  I  2J  J  K  K  K  qL  L  WM  M  =N  N  #O  O  	P  |P  P  bQ  Q  HR  R  .S  S  T  T  T  mU  U  SV  V  9W  W  X  X  Y  xY  Y  ^Z  Z  D[  [  *\  \  ]  ]  ]  i^  ^  O_  _  5`  `  a  a  b  tb  b  Zc  c  @d  d  &e  e  f  f  f  eg  g  Kh  h  1i  i  j  j  j  pk  k  Vl  l  <m  m  "n  n  o  {o  o  ap  p  Gq  q  -r  r  s  s  s  lt  t  Ru  u  8v  v  w  w  x  wx  x  ]y  y  Cz  z  ){  {  |  |  |  h}  }  N~  ~  4           s    Y  ̂  ?    %      ~    d  ׆  J    0          o    U  ȋ  ;    !      z    `  ӏ  F    ,          k  ޓ  Q  Ĕ  7          v    \  Ϙ  B    (          g  ڜ  M    3          r    X  ˡ  >    $    
  }  Ϥ     ,  X      ܬ    4  `          <  h          D  p    ȯ       L  x    а    (  T      ر    0  \          8  d          @  l    Ĵ      H  t    ̵    $  P  |    Զ     ,  X      ܷ    4  `          <  h          D  p    Ⱥ       L  x    л    (  T      ؼ    0  \          8  d          @  l    Ŀ      H  t        $  P  |         ,  X          4  `          <  h          D  p           L  x        (  T          0  \          8  d          @  l          H  t        $  P  |         ,  X          4  `          <  h          D  p           L  x        (  T          0  \          8  d          @  l          H  t        $  P  |         '  N  u          8  _          "  I  p          3  Z            D  k          .  U  |          ?  f          )  P  w          :  a          $  K  r          5  \            F  m        	  0  W  ~          A  h          +  R  y          <  c          &  M  t          7  ^          !  H  o          2  Y            C  j          -  T  {          >  e          (  O  v          9  `          #  J  q        
  4  [            E  l          /  V  }          @  g          *  Q  x          ;  b          %  L  s          6  ]             G  n        
  1  X            B  i          ,  S  z             "  $  &  (  *  ,  .  0  2  4  6  8  :  <  >  @  B  D  F  H  J  L  N  P  R  T  V  X  Z  \  ^  `  b  d  f  h  j  l  n  p  r  t  v  x  z  |  ~                                                                                                                                             
                         "  $  &  (  *  ,  .  0  2  4  6  8  :  <  >  @  B  D  F  H  J  L  N  P  R  T  V  X  Z  \  ^  `  b  d  f  h  j  l  n  p  r  t  v  x  z  |  ~                                                                                                                                    P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                                                                               
                         "  $  &  (  *  ,  .  0  2  4  6  8  :  <  >  @  B  D  F  H  J  L  N  P  R  T  V  X  Z  \  ^  `  b  d  f  h  j  l  n  p  r  t  v  x  z  |  ~                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           	                !  $  '  *  -  0  3  6  9  <  ?  B  E  H  K  N  Q  T  W  Z  ]  `  c  f  i  l  o  r  u  x  {  ~                                                                                                               #  &  )  ,  /  2  5  8  ;  >  A  D  G  J  M  P  S  V  Y  \  _  b  e  h  k  n  q  t  w  z  }                                                                                              
  
              "  %  (  +  .  1  4  7  :  =  @  C  F  I  L  O  R  U  X  [  ^  a  d  g  j  m  p  s  v  y  |                                                                                                                                                                                                                                                                                                                                                           ,  ,  ,  	,  ,  ,  ,  ,  ,  ,  ,  !,  $,  ',  *,  -,  0,  3,  6,  9,  <,  ?,  B,  E,  H,  K,  N,  Q,  T,  W,  Z,  ],  `,  c,  f,  i,  l,  o,  r,  u,  x,  {,  ~,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  -  -  -  -  -  -  -  -  -  -   -  #-  &-  )-  ,-  /-  2-  5-  8-  ;-  >-  A-  D-  G-  J-  M-  P-  S-  V-  Y-  \-  _-  b-  e-  h-  k-  n-  q-  t-  w-  z-  }-  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  .  .  .  
.  
.  .  .  .  .  .  .  ".  %.  (.  +.  ..  1.  4.  7.  :.  =.  @.  C.  F.  I.  L.  O.  R.  U.  X.  [.  ^.  a.  d.  g.  j.  m.  p.  s.  v.  y.  |.  .  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  Ф  ؤ                      (  0  8  @  H  P  X  `  h  p  x                    ȥ  Х  إ                      (  0  8  @  H  P  X  `  h  p  x                    Ȧ  Ц  ئ                      (  0  8  @  H  P  X  `  h  p  x                    ȧ  Ч  ا                      (  0  8  @  H  P  X  `  h  p  x                    Ȩ  Ш  ب                      (  0  8  @  H  P  X  `  h  p  x                    ȩ  Щ  ة                      (  0  8  @  H  P  X  `  h  p  x                    Ȫ  Ъ  ت                      (  0  8  @  H  P  X  `  h  p  x                    ȫ  Ы  ث                                                                                                                                                                                                                     0  @  P  `  p                          0  @  P  `  p                          0  @  P  `  p                          0  @  P  `  p                          0  @  P  `  p                          0  @  P  `  p                          0  @  P  `  p                          0  @  P  `  p                   	  	   	  0	  @	  P	  `	  p	  	  	  	  	  	  	  	  	   
  
   
  0
  @
  P
  `
  p
  
  
  
  
  
  
  
  
          0  @  P  `  p                          0  @  P  `  p                   
  
   
  0
  @
  P
  `
  p
  
  
  
  
  
  
  
  
          0  @  P  `  p                          0  @  P  `  p                          0  @  P  `  p                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                	   
         
                                                             !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /   0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?   @   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O   P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _   `   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o   p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~           "  3  D  U  f  w                   ! 2 C T e v            1 B S d u           0 A R c t         
  / @ Q b s           . ? P a r           - > O ` q         
  , = N _ p         	  + < M ^ o         	 	 *	 ;	 L	 ]	 n	 	 	 	 	 	 	 	 	 
 
 )
 :
 K
 \
 m
 ~
 
 
 
 
 
 
 
   ( 9 J [ l }          ' 8 I Z k |        
 
 &
 7
 H
 Y
 j
 {
 
 
 
 
 
 
 
   % 6 G X i z          $ 5 F W h y          # 4 E V g x                                                                                                                                                                     	   
         
                                                             !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /   0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?   @   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O   P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _   `   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o   p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~           "  3  D  U  f  w                   ! 2 C T e v            1 B S d u چ ٗ ب ׹       0 A R c t ˅ ʖ ɧ ȸ     
  / @ Q b s           . ? P a r           - > O ` q         
  , = N _ p         	  + < M ^ o   ~ } | { z y x	 w	 v*	 u;	 tL	 s]	 rn	 q	 p	 o	 n	 m	 l	 k	 j	 i
 h
 g)
 f:
 eK
 d\
 cm
 b~
 a
 `
 _
 ^
 ]
 \
 [
 Z Y X( W9 VJ U[ Tl S} R Q P O N M L K J I' H8 GI FZ Ek D| C B A @ ? > = <
 ;
 :&
 97
 8H
 7Y
 6j
 5{
 4
 3
 2
 1
 0
 /
 .
 - , +% *6 )G (X 'i &z % $ # " !      $ 5 F W h y          
# 4 E 
V 	g x                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     	   
         
                                                             !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /   0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?   @   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O   P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _   `   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o   p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~                                                                                                                                                                                                                                                                                                                                                                                                          ~#  }4  |E  {V  zg  yx  x  w  v  u  t  s  r  q  p o" n3 mD lU kf jw i h g f e d c b a `! _2 ^C ]T \e [v Z Y X W V U T S R Q  P1 OB NS Md Lu K J I H G F E D C B A0 @A ?R >c =t < ; : 9 8 7 6 5 4
 3 2/ 1@ 0Q /b .s - , + * ) ( ' & % $ #. "? !P  a r           - > O ` q   
   
 	  
  , = N _ p          	 	 *	 ;	 L	 ]	 n	 	 	 	 	 	 	 	 	 
 
 )
 :
 K
 \
 m
 ~
 
 
 ߱
 
 
 
 
   ( 9 J [ l } Ҏ џ а       ' 8 I Z k | Í       
 
 &
 7
 H
 Y
 j
 {
 
 
 
 
 
 
 
   % 6 G X i z          $ 5 F W h y          # 4 E V g x                            	  
      
                                         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                                                                                                                                                    
                                     "   $   &   (   *   ,   .   0   2   4   6   8   :   <   >   @   B   D   F   H   J   L   N   P   R   T   V   X   Z   \   ^   `   b   d   f   h   j   l   n   p   r   t   v   x   z   |   ~                                                                                                                                                                                                              
                         "  $  &  (  *  ,  .  0  2  4  6  8  :  <  >  @  B  D  F  H  J  L  N  P  R  T  V  X  Z  \  ^  `  b  d  f  h  j  l  n  p  r  t  v  x  z  |  ~    P  N  L$  J5  HF  FW  Dh  By  @  >  <  :  8  6  4  2 0 .# ,4 *E (V &g $x "           " 3 D 
U f w             1 B S d u           0 A R c t ȅ Ɩ ħ ¸     
  / @ Q b s           . ? P a r        ~ | z x- v> tO r` pq n l j h f d b ` ^
 \ Z, X= VN T_ Rp P N L J H F D B @		 >	 <+	 :<	 8M	 6^	 4o	 2	 0	 .	 ,	 *	 (	 &	 $	 "
  
 *
 ;
 L
 ]
 n
 
 
 
 
 
 

 
 
    ) 9 J [ l }          ' 8 I Z k | ֍ Ԟ ү     
 
 &
 7
 H
 Y
 j
 {
 
 
 
 
 
 
 
   % 6 G X i z          $ 5 F W h ~y | z x v t r p n l j# h4 fE dV bg `x ^ \ Z X V T R                                                                                                                                                                                                                                                                                     	  
      
                                         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O                                                                                                                                                                                                                            	                        !   $   '   *   -   0   3   6   9   <   ?   B   E   H   K   N   Q   T   W   Z   ]   `   c   f   i   l   o   r   u   x   {   ~                                                                                                                                                           #  &  )  ,  /  2  5  8  ;  >  A  D  G  J  M  P  S  V  Y  \  _  b  e  h  k  n  q  t  w  z  }                                                                                              
  
              "  %  (  +  .  1  4  7  :  =  @  C  F  I  L  O      $  5  F  W  h  y                  # 4 E V g x   ~ | z x v t  r p" n3 lD jU hf fw d b ` ^ \ Z X V T R! P2 NC LT Je Hv F D B @ > < : 8 6 4  21 0B .S ,d *u ( & $ "        0 A R c t 
           . ? P a r           - > O ` q ΂ ̓ ʤ ȵ     
  , = N _ p         		 	 +	 <	 M	 ^	 o	 	 	 	 	 	 	 	 	 
 
 ~*
 |;
 zL
 x]
 vn
 t
 r
 p
 n
 l
 j
 h
 f
 d b `) ^: \K Z\ Xm V~ T R P N L J H F D B( @9 >J <[ :l 8} 6 4 2 0 . , * (
 &
 $'
 "8
  I
 Z
 k
 |
 
 
 
 
 
 
 
 
  & 7 H  Y i z          $ 5 F W h y ܊ ڛ ج ֽ      # 4 E V g x         P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                                                                                                                                                                                                              	                        !   $   '   *   -   0   3   6   9   <   ?   B   E   H   K   N   Q   T   W   Z   ]   `   c   f   i   l   o   r   u   x   {   ~                                                                                                                                                           #  &  )  ,  /  2  5  8  ;  >  A  D  G  J  M  P  S  V  Y  \  _  b  e  h  k  n  q  t  w  z  }                                                                                              
  
              "  %  (  +  .  1  4  7  :  =  @  C  F  I  L  O  R  U  X  [  ^  a  d  g  j  m  p  s  v  y  |                                         $  5  F  W  h  y        ߽          # 4 E V g x           " 3 D U f w       | y v s! p2 mC jT ge dv a ^ [ X U R O L I F  C1 @B =S :d 7u 4 1 . + ( % "    0 A R 
c 
t           . ? P a r ڃ ה ԥ Ѷ       - > O ` q         
  , = N _ p  } z w t q n k h		 e	 b+	 _<	 \M	 Y^	 Vo	 S	 P	 M	 J	 G	 D	 A	 >	 ;
 8
 5*
 2;
 /L
 ,]
 )n
 &
 #
  
 
 
 
 
 
   ) : K [ l }          ' 8 I Z k | ɍ ƞ ï     
 
 &
 7
 H
 Y
 j
 {
 
 
 
 
 
 
 
   % ~6 {G xX ui rz o l i f c ` ] Z W T$ Q5 NF KW Hh Ey B ? < 9 6 3 0 - * '# $4 !E V g x     	                                                                                                                                                                                                                                                              	                        !   $   '   *   -   0   3   6   9   <   ?   B   E   H   K   N   Q   T   W   Z   ]   `   c   f   i   l   o   r   u   x   {   ~                                                                                                                                                           #  &  )  ,  /  2  5  8  ;  >  A  D  G  J  M  P  S  V  Y  \  _  b  e  h  k  n  q  t  w  z  }                                                                                              
  
              "  %  (  +  .  1  4  7  :  =  @  C  F  I  L  O  R  U  X  [  ^  a  d  g  j  m  p  s  v  y  |                                                                                          p  m  j%  g6  dG  aX  ^i  [z  X  U  R  O  L  I  F  C @ =$ :5 7F 4W 1h .y + ( % "      # 
4 
E V g x          ! 2 C T e v ч Θ ˩ Ⱥ        1 B S d u           0 A R }c zt w t q n k h e b _
 \ Y/ V@ SQ Pb Ms J G D A > ; 8 5 2 / ,. )? &P #a  r           , = N _ p         		 	 +	 <	 M	 ^	 o	 À	 	 	 	 	 	 	 	 
 
 *
 ;
 L
 ]
 n
 
 
 
 
 
 
 
 
 ~ { x) u: rK o\ lm i~ f c ` ] Z W T Q N K( H9 EJ B[ ?l <} 9 6 3 0 - * ' $
 !
 '
 8
 I
 Z
 k
 |
 
 	
 
 
  
 
 
   % 6 G X i z ߋ ܜ ٭ ־      $ 5 F W h y          # 4 E V g x    | y v s                     	  
      
                                         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o                                                                                                                                               $   (   ,   0   4   8   <   @   D   H   L   P   T   X   \   `   d   h   l   p   t   x   |                                                                                                                       $  (  ,  0  4  8  <  @  D  H  L  P  T  X  \  `  d  h  l  p  t  x  |                                                                                      $  (  ,  0  4  8  <  @  D  H  L  P  T  X  \  `  d  h  l  p  t  x  |                                                                                      $  (  ,  0  4  8  <  @  D  H  L  P  T  X  \  `  d  h  l  o       %  6  G  X  i  z    ܜ  ح  Ծ          $ 5 F W h y          # |4 xE tV pg lx h d ` \ X T P L  H D" @3 <D 8U 4f 0w , ( $        ! 2  C S d u           0 A R c t         
  / @ Q b |s x t p l h d ` \ X T P. L? HP Da @r < 8 4 0 , ( $     - > O ` q          		 	 +	 <	 M	 ^	 o	 Ā	 	 	 	 	 	 	 	 
 
 *
 ;
 L
 ]
 n
 
 
 
 |
 x
 t
 p
 l
 h d `) \: XK T\ Pm L~ H D @ < 8 4 0 , ( $(  9 J [ l }         
 
 &
 7
 H
 Y
 j
 {
 Ќ
 ̝
 Ȯ
 Ŀ
 
 
 
   % 6 G X i z       | x t p$ l5 hF dW `h \y X T P L H D @ < 8 4# 04 ,E (V $g  x         p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                                                                                                                                                                                                                                                                                                                                                                                                                                                 $   (   ,   0   4   8   <   @   D   H   L   P   T   X   \   `   d   h   l   p   t   x   |                                                                                                                       $  (  ,  0  4  8  <  @  D  H  L  P  T  X  \  `  d  h  l  p  t  x  |                                                                                      $  (  ,  0  4  8  <  @  D  H  L  P  T  X  \  `  d  h  l  p  t  x  |                                                                                      $  (  ,  0  4  8  <  @  D  H  L  P  T  X  \  `  d  h  l  p  t  x  |                                                                         &  7  H  Y  j  {  ،  ӝ  ή  ɿ          % 6 G X i z    ~ y t o j e `$ [5 VF QW Lh Gy B = 8 3 . ) $   # 4 E V g w          ! 2 C T e v            z1 uB pS kd fu a \ W R M H C > 9 4 /0 *A %R  c t           . ? P a r ˃ Ɣ         - > O ` q  { v q l g b ] X
	 S	 N,	 I=	 DN	 ?_	 :p	 5	 0	 +	 &	 !	 	 	 	 
	
 
 +
 ;
 L
 ]
 n
 
 
 
 ۲
 
 
 
 
   ) : K \ m ~       | w r m( h9 cJ ^[ Yl T} O J E @ ; 6 1 ,
 '
 "'
 8
 I
 Z
 k
 	|
 
 
 
 
 
 
 
   % 6 G X i z          $ 5 F }W xh sy n i d _ Z U P K F A# <4 7E 2V -g (x #     
                      	  
      
                                         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           
               #   (   -   2   7   <   A   F   K   P   U   Z   _   d   i   n   s   x   }                                                                                   	          "  '  ,  1  6  ;  @  E  J  O  T  Y  ^  c  h  m  r  w  |                                                          
        !  &  +  0  5  :  ?  D  I  N  S  X  ]  b  g  l  q  v  {                                                                     %  *  /  4  9  >  C  H  M  R  W  \  a  f  k  p  u  z                                                                    $  )  .  3  8  =  B  G  L  Q  V  [  `  e  j  o  t  y  ~                                                      0  +  &'  !8  I  Z  k  
|                  % 6 G X i z          $ 5 F W |h wy r m h c ^ Y T O J E# @4 ;E 6V 1g ,x ' "     	    ! 2 C T e v ܇ ט ҩ ͺ        1 B S d u     } x s n i d _0 ZA UR Pc Kt F A < 7 2 - ( # 
  / @ 
Q b  s           - > O ` q         
	 	 ~,	 y=	 tN	 o_	 jp	 e	 `	 [	 V	 Q	 L	 G	 B	 =	
 8
 3+
 .<
 )M
 $^
 o
 
 
 
 
 
 
 
 
   ) : K \ m ~ ʏ Š        ( 9 J [ l }  z u p k f a \
 W
 R'
 M8
 HI
 CZ
 >k
 9|
 4
 /
 *
 %
  
 
 
   & 7 G X i z   ߭ ھ      $ 5 F W h y        { v q# l4 gE bV ]g Xx S N I D ? : 5                     	  
      
                                         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /                                                                     $   *   0   6   <   B   H   N   T   Z   `   f   l   r   x   ~                                                                               &  ,  2  8  >  D  J  P  V  \  b  h  n  t  z                                                
        "  (  .  4  :  @  F  L  R  X  ^  d  j  p  v  |                                                         $  *  0  6  <  B  H  N  T  Z  `  f  l  r  x  ~                                                         &  ,  2  8  >  D  J  P  V  \  b  h  n  t  z                                                
        "  (  .  /      '  8  |I  wZ  rk  m|  h  c  ^  Y  T  O  J  E @ ;& 67 1H ,Y 'j "{     	     $ 5 F W h y Ҋ ͛ Ȭ ý      # 4 E V g x   } x s n i d  _ Z" U3 PD KU Ff Aw < 7 2 - ( #    ! 
2 C  T d u           0 A R c t         ~
 y t/ o@ jQ eb `s [ V Q L G B = 8 3 . ). $? P a r         
	 	 ,	 =	 N	 _	 p	 Ł	 	 	 	 	 	 	 	 	
 
 +
 <
 M
 ^
 o
 z
 u
 p
 k
 f
 a
 \
 W
 R M H* C; >L 9] 4n / * %         ( 9 J [ l } ߎ ڟ հ     
 
 '
 8
 I
 Z
 k
 |
 
 
 
 
 
 {
 v
 q l g& b7 ]H XY Sj N{ I D ? : 5 0 + & ! % 6 G 
X i z          # 4 E V g x         0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                                                                                                                                                       $   *   0   6   <   B   H   N   T   Z   `   f   l   r   x   ~                                                                               &  ,  2  8  >  D  J  P  V  \  b  h  n  t  z                                                
        "  (  .  4  :  @  F  L  R  X  ^  d  j  p  v  |                                                         $  *  0  6  <  B  H  N  T  Z  `  f  l  r  x  ~                                                         &  ,  2  8  >  D  J  P  V  \  b  h  n  t  z                                                
        "  (  .  4  :  @  F  L  R  X  ^  d  j  p  v  |               '  8  I  Z  k  |  Ѝ  ʞ  į            & 7 H Y j |{ v p j d ^ X R L F @% :6 4G .X (i "z    
      # 4 E V g x           " 3 D zU tf nw h b \ V P J D > 8 2! ,2 &C  T e v           0 A R c t         
 ~ x/ r@ lQ fb `s Z T N H B < 6 0 * $ . ? P a r          
	 	 ,	 =	 N	 _	 p	 	 	 	 	 	 	 	 |	 v	
 p
 j+
 d<
 ^M
 X^
 Ro
 L
 F
 @
 :
 4
 .
 (
 "
   * 
; L \ m ~          ( 9 J [ l }     z t n h
 b
 \'
 V8
 PI
 JZ
 Dk
 >|
 8
 2
 ,
 &
  
 
 
   & 6 G X i z ދ ؜ ҭ ̾      $ 5 F W h y  ~ x r l f ` Z T N# H4 BE <V 6g 0x * $                                                                                                                                                                                                                                                                                                                                                                          $   *   0   6   <   B   H   N   T   Z   `   f   l   r   x   ~                                                                               &  ,  2  8  >  D  J  P  V  \  b  h  n  t  z                                                
        "  (  .  4  :  @  F  L  R  X  ^  d  j  p  v  |                                                         $  *  0  6  <  B  H  N  T  Z  `  f  l  r  x  ~                                                         &  ,  2  8  >  D  J  P  V  \  b  h  n  t  z                                                
        "  (  .  4  :  @  F  L  R  X  ^  d  j  p  v  |                                                   (  9  J  [  l  }  Ȏ                ' 8 {I tZ mk f| _ X Q J C < 5 . '  & 7 H Y j z          $ 5 F W h y    x q j c \ U N# G4 @E 9V 2g +x $         ! 2 C T e v          |  u1 nB gS `d Yu R K D = 6 / ( !   0 A Q b s   ۦ Է       . ? P a r  y r k d ] V O H	 A	 :-	 3>	 ,O	 %`	 q	 	 	 		 	 	 	 	 	 	
 
 +
 <
 M
 ^
 o
 
 
 
 
 
 
 
 }
 v o h* a; ZL S] Ln E > 7 0 ) "   
  ( 9 J [ l } Վ Ο ǰ     
 
 '
 8
 I
 Z
 zk
 s|
 l
 e
 ^
 W
 P
 I
 B
 ; 4 -& &7 H Y j 
{          $ 5 F W h y     ~ w p i b [# T4 ME FV ?g 8x 1 * #                         	  
      
                                         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    #   *   1   8   ?   F   M   T   [   b   i   p   w   ~                                                           
        &  -  4  ;  B  I  P  W  ^  e  l  s  z                                          
      "  )  0  7  >  E  L  S  Z  a  h  o  v  }                                        	        %  ,  3  :  A  H  O  V  ]  d  k  r  y                                                !  (  /  6  =  D  K  R  Y  `  g  n  u  |                                                $  +  2  9  @  G  N  U  \  c  j  q  x                                                   '  .  5  <  C  J  Q  X  _  f  m  t  {                                        P  I  B)  ;:  4K  -\  &m  ~      
            ' 8 I Z k |        ~ w p& i7 bH [Y Tj M{ F ? 8 1 * #    %  6 F W h y ݊ ֛ Ϭ Ƚ      # 4 E V g {x t m f _ X Q J C  < 5" .3 'D  U f w            1 B S d u       x q j c \0 UA NR Gc @t 9 2 + $     
  . ? P a r Ѓ ɔ ¥      	 	 -	 >	 |O	 u`	 nq	 g	 `	 Y	 R	 K	 D	 =	 6	 /

 (
 !,
 =
 N
 _
 p
 
 
 
 
 
 
 
 
   * ; L ] n     y r k d ] V O) H: AK :\ 3m ,~ %    	   
 
 '
 8
 I
 Z
 k
 |
 
 
 
 
 
 
 
   }& v7 oH hY aj Z{ S L E > 7 0 ) "  % 
6 G W h y   ܬ ս      # 4 E V g x  z s l e ^ W                     	  
      
                                         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O                                                                                                   (   0   8   @   H   P   X   `   h   p   x                                                               (  0  8  @  H  P  X  `  h  p  x                                              (  0  8  @  H  P  X  `  h  p  x                                              (  0  8  @  H  P  X  `  h  p  x                                              (  0  8  @  H  P  X  `  h  p  x                                              (  0  8  @  H  P  X  `  h  p  x                                              (  0  8  @  H  P  X  `  h  p  x                                              (  0  8  @  H  P  X  `  h  p  x        )  :  K  \  m  ~      z  s  l  e  ^  W P I( B9 ;J 4[ -l &}    
      & 7 H Y j {         ~ w% p6 iG bX [i Tz M F ? 8 1 * #   $ 5  F V g x  ݚ ֫ ϼ       " 3 D U f w { t m f _ X Q J C <! 52 .C 'T  e v           0 A R c t        x q
 j c/ \@ UQ Nb Gs @ 9 2 + $    	 	 -	 >	 O	 `	 q	 ׂ	 Г	 ɤ	 µ	 	 	 	 	 

 
 ,
 =
 N
 |_
 up
 n
 g
 `
 Y
 R
 K
 D
 =
 6	 / (+ !< M ^ o           ) : K \ m ~     y r k d
 ]
 V(
 O9
 HJ
 A[
 :l
 3}
 ,
 %
 
 
 
 	
 
   & 7 H Y j { Ì         % }6 vG oX hi az Z S L E > 7 0 ) " $ 5 
F W g x    ܼ                                                                                                                                                                                                         	         $   -   6   ?   H   Q   Z   c   l   u   ~                                                      )  2  ;  D  M  V  _  h  q  z                                
      %  .  7  @  I  R  [  d  m  v                                      !  *  3  <  E  N  W  `  i  r  {                                      &  /  8  A  J  S  \  e  n  w                                      "  +  4  =  F  O  X  a  j  s  |                                      '  0  9  B  K  T  ]  f  o  x                                      #  ,  5  >  G  P  Y  b  k  t  }                                
      (  1  :  C  L  U  ^  g  p  y                                	  w  n+  e<  \M  S^  Jo  A  8  /  &            ) : K \ m ~       { r i `( W9 NJ E[ <l 3} * !        & 7 H Y j {      v m d [ R% I6 @G 7X .i %z   
       # 4 E V g x    z q h _ V  M D" ;3 2D )U  f w            1 B S d u  ~ u l c Z Q H ? 6 -0 $A R c 	t          	 	 .	 ?	 P	 a	 r	 y	 p	 g	 ^	 U	 L	 C	 :	 1
 (
 -
 >
 
O
 `
 p
 
 
 
 ״
 
 
 
 
 	  + < M }^ to k b Y P G > 5 , #  * ; K \ m ~ ۏ Ҡ ɱ     
 
 (
 9
 xJ
 o[
 fl
 ]}
 T
 K
 B
 9
 0
 '
 
   ' 7 H Y j { ͌ ĝ        |% s6 jG aX Xi Oz F = 4 + "     # 4 E V g x          	  	  	  	  	  	  	  	  	  		  
	  	  	  
	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	   	  !	  "	  #	  $	  %	  &	  '	  (	  )	  *	  +	  ,	  -	  .	  /	  0	  1	  2	  3	  4	  5	  6	  7	  8	  9	  :	  ;	  <	  =	  >	  ?	  @	  A	  B	  C	  D	  E	  F	  G	  H	  I	  J	  K	  L	  M	  N	  O	  P	  Q	  R	  S	  T	  U	  V	  W	  X	  Y	  Z	  [	  \	  ]	  ^	  _	  `	  a	  b	  c	  d	  e	  f	  g	  h	  i	  j	  k	  l	  m	  n	  o	  p	  q	  r	  s	  t	  u	  v	  w	  x	  y	  z	  {	  |	  }	  ~	  	                                                                                                                                      
         (   2   <   F   P   Z   d   n   x                                                "  ,  6  @  J  T  ^  h  r  |                                  &  0  :  D  N  X  b  l  v                                     *  4  >  H  R  \  f  p  z                                  $  .  8  B  L  V  `  j  t  ~                             
      (  2  <  F  P  Z  d  n  x                                  "  ,  6  @  J  T  ^  h  r  |                                  &  0  :  D  N  X  b  l  v                                     *  4  >  H  R  \  f  p  z                            	  	  	  $	  .	  8	  B	  L	  V	  `	  j	  t	  ~	  	   
    +  <  M  ^  o              ~  t  j ` V* L; BL 8] .n $          ( 9 J [ l }  z p f \ R H > 4 *'  8 I Z k {   ڮ п      % 6 G vX li bz X N D : 0 &    # 4 E V g x        |  r h" ^3 TD JU @f 6w , "          1 B S d u    x n d Z P F < 20 (A R c 
t          	 	 .	 ?	 P	 ~a	 tr	 j	 `	 V	 L	 B	 8	 .	 $	 
 
 -
 =
 N
 _
 p
 ԁ
 ʒ
 
 
 
 
 
 
 	 z p+ f< \M R^ Ho > 4 *         ) : K \ m ~     v l b X
 N
 D(
 :9
 0J
 &[
 l
 }
 
 
 
 
 
 
 
   & 7 H Y j |{ r h ^ T J @ 6 , " % 6 G W h y ܊ қ Ȭ       # x4 nE dV Zg Px F < 2 (   
  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	                                                                                                                                      
         (   2   <   F   P   Z   d   n   x                                                "  ,  6  @  J  T  ^  h  r  |                                  &  0  :  D  N  X  b  l  v                                     *  4  >  H  R  \  f  p  z                                  $  .  8  B  L  V  `  j  t  ~                             
      (  2  <  F  P  Z  d  n  x                                  "  ,  6  @  J  T  ^  h  r  |                                  &  0  :  D  N  X  b  l  v                                     *  4  >  H  R  \  f  p  z                            	  	  	  $	  .	  8	  B	  L	  V	  `	  j	  t	  ~	  	  	  	  	  	  	  	  	  	  	  	  	  	  
  v  l,  b=  XN  N_  Dp  :  0  &              * ; L ] n     | r h ^ T J @) 6: ,K "\ m ~          ' 8 I Z k x| n d Z P F < 2 (  & 
7  H X i z ؋ Μ ĭ       ~$ t5 jF `W Vh Ly B 8 . $       " 3 D U f w      z p f \ R! H2 >C 4T *e  v           0 A R c t  v l b X N D : 0
	 &	 /	 @	 Q	 a	 r	 	 	 ֥	 ̶	 	 	 	 	 
 
 -
 |>
 rO
 h`
 ^q
 T
 J
 @
 6
 ,
 "
 
 
 
  + < M ^ o        x n d Z* P; FL <] 2n (   
      
 
 (
 9
 J
 [
 l
 }
 
 ~
 t
 j
 `
 V
 L
 B 8 .' $8 I Z k {   ޮ Կ      % 6 G zX pi fz \ R H > 4 *     $ 4 E V g x Ɖ         
  
  
  
  
  
  
  
  
  	
  

  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
   
  !
  "
  #
  $
  %
  &
  '
  (
  )
  *
  +
  ,
  -
  .
  /
  0
  1
  2
  3
  4
  5
  6
  7
  8
  9
  :
  ;
  <
  =
  >
  ?
  @
  A
  B
  C
  D
  E
  F
  G
  H
  I
  J
  K
  L
  M
  N
  O
  P
  Q
  R
  S
  T
  U
  V
  W
  X
  Y
  Z
  [
  \
  ]
  ^
  _
  `
  a
  b
  c
  d
  e
  f
  g
  h
  i
  j
  k
  l
  m
  n
  o
  p
  q
  r
  s
  t
  u
  v
  w
  x
  y
  z
  {
  |
  }
  ~
  
                                                                                                                                            !   ,   7   B   M   X   c   n   y                                             )  4  ?  J  U  `  k  v                                &  1  <  G  R  ]  h  s  ~                          
    #  .  9  D  O  Z  e  p  {                          
       +  6  A  L  W  b  m  x                                (  3  >  I  T  _  j  u                                %  0  ;  F  Q  \  g  r  }                              "  -  8  C  N  Y  d  o  z                          	      *  5  @  K  V  a  l  w                          	  	  	  '	  2	  =	  H	  S	  ^	  i	  t	  	  	  	  	  	  	  	  	  	  	  	  	  
  
  
  $
  /
  :
  E
  P
  [
  f
  q
  |
  
       ,  =  N  _  p            |  q  f  [	 P E+ :< /M $^ o           ) : K \ tm i~ ^ S H = 2 '    ' 8 I Z k |       w l a V& K7 @H 5Y *j {  	        $ 5 F W h zy o d Y N C 8 - "  # 4 D U f w ʈ       } r g! \2 QC FT ;e 0v %          0 A R c t  u j _ T I > 3 (
	 	 /	 @	 P	 a	 r	 ۃ	 Д	 ť	 	 	 	 	 	 
 x
 m-
 b>
 WO
 L`
 Aq
 6
 +
  
 
 

 
 
 
 	  + < M ^ o   { p e Z O D 9 . #* ; 
L ] m ~  ֠ ˱     
 
 ~(
 s9
 hJ
 ][
 Rl
 G}
 <
 1
 &
 
 
 
 
   & 7 H Y j {    v k ` U J ? 4% )6 G X i y   ܬ ѽ      # 4 yE nV cg Xx M B 7 , !    
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
                                                                                                                                            !   ,   7   B   M   X   c   n   y                                             )  4  ?  J  U  `  k  v                                &  1  <  G  R  ]  h  s  ~                          
    #  .  9  D  O  Z  e  p  {                          
       +  6  A  L  W  b  m  x                                (  3  >  I  T  _  j  u                                %  0  ;  F  Q  \  g  r  }                              "  -  8  C  N  Y  d  o  z                          	      *  5  @  K  V  a  l  w                          	  	  	  '	  2	  =	  H	  S	  ^	  i	  t	  	  	  	  	  	  	  	  	  	  	  	  	  
  
  
  $
  /
  :
  E
  P
  [
  f
  q
  |
  
  
  
  
  
  
  
  
  
  
  
  
    u  j-  _>  TO  I`  >q  3  (              	  + < M ^ o   x m b W L A 6 +  * ; 
L \ m ~ ޏ Ӡ ȱ       {( p9 eJ Z[ Ol D} 9 . #  
     & 7 H Y j {   ~ s h ] R G < 1% &6 G X i y   ٬ ν      # 4 vE kV `g Ux J ? 4 )      ! 2 C T e v     y n c X M B  71 ,B !S d u     ߸     
	 	 /	 @	 |Q	 qb	 fs	 [	 P	 E	 :	 /	 $	 	 	 
 
 -
 >
 O
 `
 q
 
 
 
 
 
 
 t
 i
 ^
 S H, == 2N '_ p           * ; L ] wn l a V K @ 5 *  
 	
 (
 9
 J
 [
 l
 }
 
 
 
 
 
 
 z
 o d Y' N8 CI 8Z -k "|          % 6 G X i }z r g \ Q F ; 0 %  $ 5 E V g x ͉                           	  
      
                                         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                                                                                                                                              $   0   <   H   T   `   l   x                                           ,  8  D  P  \  h  t                              (  4  @  L  X  d  p  |                             $  0  <  H  T  `  l  x                               ,  8  D  P  \  h  t                              (  4  @  L  X  d  p  |                             $  0  <  H  T  `  l  x                               ,  8  D  P  \  h  t                              (  4  @  L  X  d  p  |                       	  	  	  $	  0	  <	  H	  T	  `	  l	  x	  	  	  	  	  	  	  	  	  	  	  	  
  
   
  ,
  8
  D
  P
  \
  h
  t
  
  
  
  
  
  
  
  
  
  
  
        (  4  @  L  X  d  p  |         -  >  O  `  q          |  p  d  X  L
 @ 4, (= N _ p    Գ       * t; hL \] Pn D 8 ,         ( 9 J [ l }  x l ` T H < 0 $ ' 8  I Y j { Ќ ĝ      | p d% X6 LG @X 4i (z          # 4 E V g tx h \ P D 8 ,      ! 2 C T e v      x l ` T H  <1 0B $S d u     ܸ     
	 	 /	 |@	 pQ	 db	 Xs	 L	 @	 4	 (	 	 	 	 	 
 
 -
 >
 O
 `
 q
 
 
 
 t
 h
 \
 P
 D
 8
 ,  , = N ^ o  ؑ ̢       x l* `; TL H] <n 0 $        
 
 (
 9
 J
 [
 l
 |}
 p
 d
 X
 L
 @
 4
 (
   ' 7 H Y j {       t h \ P% D6 8G ,X  i z          # 4 E xV lg `x T H < 0 $                                                                                                                                                                                                                                                                                                                                                                                                              $   0   <   H   T   `   l   x                                           ,  8  D  P  \  h  t                              (  4  @  L  X  d  p  |                             $  0  <  H  T  `  l  x                               ,  8  D  P  \  h  t                              (  4  @  L  X  d  p  |                             $  0  <  H  T  `  l  x                               ,  8  D  P  \  h  t                              (  4  @  L  X  d  p  |                       	  	  	  $	  0	  <	  H	  T	  `	  l	  x	  	  	  	  	  	  	  	  	  	  	  	  
  
   
  ,
  8
  D
  P
  \
  h
  t
  
  
  
  
  
  
  
  
  
  
  
        (  4  @  L  X  d  p  |                          t  h.  \?  PP  Da  8r  ,                 
  , = N _ p x l ` T H < 0 $ 	   + ; L ] n       | p d X L) @: 4K (\ m ~          ' 8 I tZ hk \| P D 8 ,       % 6 G X i z    x l ` T H < 0$ $5 F W  h x  ܚ Ы ļ       |" p3 dD XU Lf @w 4 (          1 B S d u  t h \ P D 8 ,  	 	 0	 @	 Q	 b	 s	 ̄	 	 	 	 	 	 	 x	 l
 `
 T.
 H?
 <P
 0a
 $r
 
 
  
 
 
 
 
 
 
  , = N |_ pp d X L @ 4 (   	  * ; L ] n      t h \ P
 D
 8)
 ,:
  K
 \
 m
 }
 
 
 ذ
 
 
 
 
   ' x8 lI `Z Tk H| < 0 $        % 6 G X i z  | p d X L @ 4 ( $ 5 F V g x ԉ Ț                          	  
      
                                         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                                                                                                                                        
      '   4   A   N   [   h   u                                       +  8  E  R  _  l  y                          "  /  <  I  V  c  p  }                          &  3  @  M  Z  g  t                            *  7  D  Q  ^  k  x                          !  .  ;  H  U  b  o  |                          %  2  ?  L  Y  f  s                            )  6  C  P  ]  j  w                             -  :  G  T  a  n  {                      
	  	  $	  1	  >	  K	  X	  e	  r	  	  	  	  	  	  	  	  	  	  	  
  
  
  (
  5
  B
  O
  \
  i
  v
  
  
  
  
  
  
  
  
  
  
        ,  9  F  S  `  m  z                      	    #  0  =  J  W  d  q  ~     
    .  ?  P  a  r        ~  q  d  W  J  = 0 #- > 	O _ p  Ւ ȣ      z	 m `+ S< FM 9^ ,o           ) : K v\ im \~ O B 5 (      ' 8 I Z k |   r e X K > 1 $ & 
7 G X i z ɋ      { n a T$ G5 :F -W  h y    ߼       " 3 wD jU ]f Pw C 6 )         1 B S d u  s f Y L ? 2 % 	 	 /	 @	 Q	 b	 s	 	 	 	 	 	 |	 o	 b	 U
 H
 ;.
 .?
 !P
 a
 r
 
 
 
 ӵ
 
 
 
 
 
  x, k= ^N Q_ Dp 7 *         * ; L ] n t g Z M @ 3 &  
 
 (
 9
 J
 [
 l
 }
 
 
 
 }
 p
 c
 V
 I < /' "8 I Z j {  ԝ Ǯ      y l% _6 RG EX 8i +z          # 4 E V ug hx [ N A 4 '  
                                                                                                                                                                                                                                                                                                                                                                                                      
      '   4   A   N   [   h   u                                       +  8  E  R  _  l  y                          "  /  <  I  V  c  p  }                          &  3  @  M  Z  g  t                            *  7  D  Q  ^  k  x                          !  .  ;  H  U  b  o  |                          %  2  ?  L  Y  f  s                            )  6  C  P  ]  j  w                             -  :  G  T  a  n  {                      
	  	  $	  1	  >	  K	  X	  e	  r	  	  	  	  	  	  	  	  	  	  	  
  
  
  (
  5
  B
  O
  \
  i
  v
  
  
  
  
  
  
  
  
  
  
        ,  9  F  S  `  m  z                      	    #  0  =  J  W  d  q  ~                      
  s  f/  Y@  LQ  ?b  2s  %                  - > O |` oq b U H ; . !   	  + < M ^ o    x k ^ Q D 7 * * ; L \ m ~ Ϗ        t g Z( M9 @J 3[ &l }          & 7 }H pY cj V{ I < / "      $ 5 F W h y  y l _ R E 8 +  # 4 D U f w È      u h [ N! A2 4C 'T e 
v     ٹ     	 	 ~0	 qA	 dR	 Wc	 Jt	 =	 0	 #	 	 		 	 	 	 
 
 .
 ?
 P
 a
 r
 z
 m
 `
 S
 F
 9
 ,
 
   , = N _ p      v i \ O	 B 5+ (< M ^ o   ڡ Ͳ     
 
 r)
 e:
 XK
 K\
 >m
 1~
 $
 
 

 
 
 
 
   ' 8 I Z {k n| a T G : -      % 6 G X i z    w j ] P C 6 )$ 5 F W g x ۉ Κ        
  
  
  
  
  
  
  
  
  	
  

  
  
  

  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
   
  !
  "
  #
  $
  %
  &
  '
  (
  )
  *
  +
  ,
  -
  .
  /
  0
  1
  2
  3
  4
  5
  6
  7
  8
  9
  :
  ;
  <
  =
  >
  ?
  @
  A
  B
  C
  D
  E
  F
  G
  H
  I
  J
  K
  L
  M
  N
  O
  P
  Q
  R
  S
  T
  U
  V
  W
  X
  Y
  Z
  [
  \
  ]
  ^
  _
  `
  a
  b
  c
  d
  e
  f
  g
  h
  i
  j
  k
  l
  m
  n
  o
  p
  q
  r
  s
  t
  u
  v
  w
  x
  y
  z
  {
  |
  }
  ~
  
                                                                                                                                            *   8   F   T   b   p   ~                              
    &  4  B  P  ^  l  z                        "  0  >  L  Z  h  v                          ,  :  H  V  d  r                          (  6  D  R  `  n  |                        $  2  @  N  \  j  x                           .  <  J  X  f  t                           *  8  F  T  b  p  ~                    
    &  4  B  P  ^  l  z                    	  	  "	  0	  >	  L	  Z	  h	  v	  	  	  	  	  	  	  	  	  	  
  
  
  ,
  :
  H
  V
  d
  r
  
  
  
  
  
  
  
  
  
  
      (  6  D  R  `  n  |                        $  2  @  N  \  j  x                    
  
   
  .
  <
  J
  X
  f
  t
  
       /  @  Q  b  s        t  f  X  J  <  .   . ? O ` q ̂      x j \
 N @, 2= $N _ p   ޢ г      | n* `; RL D] 6n (          ( 9 J r[ dl V} H : ,       & 7 H Y j { v h Z L > 0 "   $ 5 F W h y    z l ^ P B 4 &# 4 
E U f w ҈ ę     ~ p b T! F2 8C *T e v     ֹ     	 	 t0	 fA	 XR	 Jc	 <t	 .	  	 	 	 	 	 	 	 
 
 .
 ?
 P
 xa
 jr
 \
 N
 @
 2
 $
 
 
 
 
  , = N _ p  | n ` R D 6 ( 	  * ; L ] n      r d V H
 :
 ,)
 :
 K
 \
 l
 }
 ؎
 ʟ
 
 
 
 
 
 v h Z' L8 >I 0Z "k |    ܿ      % z6 lG ^X Pi Bz 4 &  
      # 4 E V ~g px b T F 8 *    
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
                                                                                                                                            *   8   F   T   b   p   ~                              
    &  4  B  P  ^  l  z                        "  0  >  L  Z  h  v                          ,  :  H  V  d  r                          (  6  D  R  `  n  |                        $  2  @  N  \  j  x                           .  <  J  X  f  t                           *  8  F  T  b  p  ~                    
    &  4  B  P  ^  l  z                    	  	  "	  0	  >	  L	  Z	  h	  v	  	  	  	  	  	  	  	  	  	  
  
  
  ,
  :
  H
  V
  d
  r
  
  
  
  
  
  
  
  
  
  
      (  6  D  R  `  n  |                        $  2  @  N  \  j  x                    
  
   
  .
  <
  J
  X
  f
  t
  
  
  
  
  
  
  
  
  
  
    r  d0  VA  HR  :c  ,t                    . ? vP ha Zr L > 0 "     
  , = N _ p z l ^ P B 4 &  
	  * ; L ] n    ~ p b T F 8 * ) :  K [ l } Ȏ      t f X J' <8 .I  Z k |   ڮ ̿      x% j6 \G NX @i 2z $         # 4 E |V ng `x R D 6 (      ! 2 C T e v  r d V H : ,  	  	 0	 A	 R	 c	 t	 	 	 	 	 v	 h	 Z	 L	 >
 0
 "/
 @
 Q
 a
 r
 ܃
 Δ
 
 
 
 
 
 z
 l ^ P- B> 4O &` q 
        	  ~+ p< bM T^ Fo 8 *        
 
 )
 :
 K
 \
 tm
 f~
 X
 J
 <
 .
  
 
 
   ' 8 I Z k |  x j \ N @ 2 $  & 6 G X i z     | n ` R D 6$ (5 F W g x  Ԛ ƫ                         	  
      
                                         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                                                                                                                                              -   <   K   Z   i   x                                  ,  ;  J  Y  h  w                    
    +  :  I  X  g  v                        *  9  H  W  f  u                        )  8  G  V  e  t                    
    (  7  F  U  d  s                    	    '  6  E  T  c  r                        &  5  D  S  b  q                        %  4  C  R  a  p                    	  	  $	  3	  B	  Q	  `	  o	  ~	  	  	  	  	  	  	  	  	  
  
  #
  2
  A
  P
  _
  n
  }
  
  
  
  
  
  
  
  
      "  1  @  O  ^  m  |                      !  0  ?  N  ]  l  {                  
  
   
  /
  >
  M
  \
  k
  z
  
  
  
  
  
  
  
  
        .  =  L  [  j  y         0  A  R  c  t      y  j  [  L  =  .  
  / ? P a r     z k \ M > /  - > O _ p Ձ ƒ     { l ]	 N ?+ 0< !M ^ o   ֡ ǲ     | m ^) O: @K 1\ "m ~          }' n8 _I PZ Ak 2| #         % 6 ~G oX `i Qz B 3 $       # 4 E V g px a R C 4 %     ! 2 C T e v  q b S D 5 &  	 	 0	 A	 R	 c	 t	 	 	 	 r	 c	 T	 E	 6	 '
 
 	/
 ?
 P
 a
 r
 
 
 
 
 
 s
 d
 U
 F 7 (- > 
O _ p ݁ Β      t e	 V G+ 8< )M ^ o   ޡ ϲ     
 u
 f)
 W:
 HK
 9\
 *m
 ~
 
 
 
 
 
 
 
   ' v8 gI XZ Ik :| +  
       % 6 G wX hi Yz J ; ,       # 4 E V g xx i Z K < -                                                                                                                                                                                                                                                                                                                                                                                                              -   <   K   Z   i   x                                  ,  ;  J  Y  h  w                    
    +  :  I  X  g  v                        *  9  H  W  f  u                        )  8  G  V  e  t                    
    (  7  F  U  d  s                    	    '  6  E  T  c  r                        &  5  D  S  b  q                        %  4  C  R  a  p                    	  	  $	  3	  B	  Q	  `	  o	  ~	  	  	  	  	  	  	  	  	  
  
  #
  2
  A
  P
  _
  n
  }
  
  
  
  
  
  
  
  
      "  1  @  O  ^  m  |                      !  0  ?  N  ]  l  {                  
  
   
  /
  >
  M
  \
  k
  z
  
  
  
  
  
  
  
  
        .  =  L  [  j  y                          1  B  S  d  u      p  `  P  @  0        / @ Q b s    p ` P @ 0     . > O ` q     p ` P @ 0
   ,  = M ^ o      p ` P @ 0  * ;  L \ m ~      p ` P @ 0(  9 J  [ k | Ѝ      p ` P @& 07  H Y  j z  М      p ` P$ @5 0F  W h  y   Ы       p `" P3 @D 0U  f w     к     	 p 	 `1	 PB	 @S	 0d	  u	 	  	 	 	 	 	 	 	 
 
 p/
 `@
 PQ
 @b
 0s
  
 
  
 
 
 
 
 
   - p> `O P` @q 0          	  + < pM `^ Po @ 0         
 
 )
 :
 K
 p\
 `m
 P~
 @
 0
  
 
  
 
 
   ' 8 I Z pk `| P @ 0         % 6 G X i pz ` P @ 0        # 4 E V g x p ` P @ 0                        	  
      
                                         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               0   @   P   `   p                                   0  @  P  `  p                          0  @  P  `  p                          0  @  P  `  p                          0  @  P  `  p                          0  @  P  `  p                          0  @  P  `  p                          0  @  P  `  p                          0  @  P  `  p                   	  	   	  0	  @	  P	  `	  p	  	  	  	  	  	  	  	  	   
  
   
  0
  @
  P
  `
  p
  
  
  
  
  
  
  
  
          0  @  P  `  p                          0  @  P  `  p                   
  
   
  0
  @
  P
  `
  p
  
  
  
  
  
  
  
  
          0  @  P  `  p                          0  @  P  `  p                      !  2  pC  `T  Pe  @v  0                    0 A pR `c Pt @ 0           . ? P pa `r P @ 0        
  , = N _ pp ` P @ 0         * ; L ] n p ` P @ 0        ( 9 J [ l } p ` P @ 0       & 7 H Y j {  p ` P @ 0      $ 5 F W h y   p ` P @ 0     # 3 D U f w    p ` P @ 0  	 !	  2	 B	 S	 d	 u	 	 	 	 	 p	 `	 P	 @	 0
  
 0
  A
 Q
 b
 s
 
 
 
 
 
 p
 `
 P
 @ 0  . ?  P ` q Ђ      p ` P
 @ 0,  = N  _ o  Б      p `
 P
 @*
 0;
  L
 ]
  n
 ~
 
 Р
 
 
 
 
 
 p ` P( @9 0J  [ l  }   Я      p `& P7 @H 0Y  j {     о      p$ `5 PF @W 0h  y                             	  
      
                                         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                                                                                                                                                                                                                                           "   3   D   U   f   w                             !  2  C  T  e  v                       1  B  S  d  u                      0  A  R  c  t                  
    /  @  Q  b  s                      .  ?  P  a  r                      -  >  O  `  q                  
    ,  =  N  _  p                  	    +  <  M  ^  o                  	  	  *	  ;	  L	  ]	  n	  	  	  	  	  	  	  	  	  
  
  )
  :
  K
  \
  m
  ~
  
  
  
  
  
  
  
      (  9  J  [  l  }                    '  8  I  Z  k  |                
  
  &
  7
  H
  Y
  j
  {
  
  
  
  
  
  
  
      %  6  G  X  i  z                    $  5  F  W  h  y                    #  4  E  V  g  x           !  2  C  T  e  v    x  g  V  E  4  #      0 A R c t  y h W F 5 $  
  . ? P a r  z i X G 6 %    , = N _ p  { j Y H 7 &  	  * ; L ] n  | k Z I 8 '    ( 9 J [ l } } l [ J 9 (    & 7 H Y j { ~ m \ K : )    $ 5 F W h y  n ] L ; *    " 3 D U f w  o ^ M < +  	 	  	 1	 B	 S	 d	 u	 	 p	 _	 N	 =	 ,	 	 
	 
 
 /
 @
 Q
 b
 s
 
 q
 `
 O
 >
 -
 
 
   - > O ` q  r a P ? .   	  + < M ^ o  s b Q @ /  
 
 
 )
 :
 K
 \
 m
 ~
 t
 c
 R
 A
 0
 
 
   ' 8 I Z k | u d S B 1      % 6 G X i z v e T C 2 !    # 4 E V g x w f U D 3 "                                                                                                                                                                                                                                                                                                          "   3   D   U   f   w                             !  2  C  T  e  v                       1  B  S  d  u                      0  A  R  c  t                  
    /  @  Q  b  s                      .  ?  P  a  r                      -  >  O  `  q                  
    ,  =  N  _  p                  	    +  <  M  ^  o                  	  	  *	  ;	  L	  ]	  n	  	  	  	  	  	  	  	  	  
  
  )
  :
  K
  \
  m
  ~
  
  
  
  
  
  
  
      (  9  J  [  l  }                    '  8  I  Z  k  |                
  
  &
  7
  H
  Y
  j
  {
  
  
  
  
  
  
  
      %  6  G  X  i  z                    $  5  F  W  h  y                    #  4  E  V  g  x                     "  3  D  U  f  w    p  ^  L  :  (         1 B S d u t b P > ,    
  / @ Q b xs f T B 0       - > O |` jq X F 4 "     	  + < M n^ \o J 8 &        ) : rK `\ Nm <~ *         ' v8 dI RZ @k .|  
        z% h6 VG DX 2i  z    ؽ     ~ l# Z4 HE 6V $g x    ܪ ʻ     p	 ^!	 L2	 :C	 (T	 e	 v	 	 	 Ψ	 	 	 	 	 t	 b
 P
 >0
 ,A
 R
 c
 s
 
 ҕ
 
 
 
 
 x
 f
 T B 0. ? P ` q ւ ē    | j X F
 4 ", = M ^ o Ȁ     n \ J 8
 &
 *
 ;
 K
 \
 m
 ~
 
 
 
 r
 `
 N
 <
 *  ( 8 I Z k |   v d R @ .  
 % 6 G X i z  z h V D 2     # 4 E V g x ~ l Z H 6 $                      	  
      
                                         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           $   6   H   Z   l   ~                             2  D  V  h  z                
    .  @  R  d  v                    *  <  N  `  r                    &  8  J  \  n                    "  4  F  X  j  |                    0  B  T  f  x                    ,  >  P  b  t                    (  :  L  ^  p                 	  	  $	  6	  H	  Z	  l	  ~	  	  	  	  	  	  	  	  
   
  2
  D
  V
  h
  z
  
  
  
  
  
  
  
  
    .  @  R  d  v                    *  <  N  `  r                
  
  &
  8
  J
  \
  n
  
  
  
  
  
  
  
  
    "  4  F  X  j  |                    0  B  T  f  x                    ,  >  P  b  t                    (  :  L  ^  p                    m$  Z5  GF  4W  !h  y      ի  ¼        v  c P" =3 *D U f v އ ˘     l Y F 3   1 
B R c t     u b O < )
  / ? P a r   ~ k X E 2    , = N _ p  t a N ; (     * ; L ] }n j W D 1       ( 9 J s[ `l M} : '        & |7 iH VY Cj 0{  
        r$ _5 LF 9W &h y    ګ Ǽ    { 	 h	 U"	 B3	 /D	 U	 	f	 v	 	 И	 	 	 	 	 q	 ^	 K
 8 
 %1
 B
 R
 c
 t
 ƅ
 
 
 
 z
 g
 T
 A
 .
  / ? P a r    p ] J 7 $   , = N _ p  y f S @ -   
 
 *
 ;
 L
 ]
 n
 o
 \
 I
 6
 #
 
 
 
   ( 9 J x[ el R} ? ,        & 7 nH [Y Hj 5{ "         w$ d5 QF >W +h y   ߫ ̼                
                         "  $  &  (  *  ,  .  0  2  4  6  8  :  <  >  @  B  D  F  H  J  L  N  P  R  T  V  X  Z  \  ^  `  b  d  f  h  j  l  n  p  r  t  v  x  z  |  ~                                                                                                                                             
                         "  $  &  (  *  ,  .  0  2  4  6  8  :  <  >  @  B  D  F  H  J  L  N  P  R  T  V  X  Z  \  ^  `  b  d  f  h  j  l  n  p  r  t  v  x  z  |  ~                                                                                                                                                                                                            (   <   P   d   x                         ,  @  T  h  |                  0  D  X  l                     4  H  \  p                  $  8  L  `  t                   (  <  P  d  x                  ,  @  T  h  |                  0  D  X  l                     4  H  \  p                	  $	  8	  L	  `	  t	  	  	  	  	  	  	   
  
  (
  <
  P
  d
  x
  
  
  
  
  
  
      ,  @  T  h  |                  0  D  X  l                
   
  4
  H
  \
  p
  
  
  
  
  
  
  
    $  8  L  `  t                   (  <  P  d  x                  ,  @  T  h  |                  0  D  X  l                     4  H  \  p                  $  8  L  `  t           $  5  F  W  h  y  t  `  L  8  $         " 3 D U pf \w H 4           1 lB XS Dd 0u         |
 h T/ @@ ,Q b s  ܔ ȥ    x d P < (- >  O _ p ā    t ` L 8 $	  * ; L ] n   p \ H 4      ( 9 J [ l l} X D 0       & 7 |H hY Tj @{ ,         x$ d5 PF <W (h y    ث ļ    t 	 `	 L"	 83	 $D	 U	 e	 v	 ԇ	 	 	 	 	 p	 \	 H	 4
   
 1
 A
 R
 c
 t
 
 
 
 l
 X
 D
 0
 
 
  . ? P a r | h T @ ,    
  , = N x_ dp P < (       
 
 *
 t;
 `L
 L]
 8n
 $
 
 
 
 
 
 
 
  p \( H9 4J  [ l |  О     l X D 0& 7 H X i z    | h T @ ,  $ 4 E V g x  x d P < (                                                                                                                                                                                                                                                                                                          (   <   P   d   x                         ,  @  T  h  |                  0  D  X  l                     4  H  \  p                  $  8  L  `  t                   (  <  P  d  x                  ,  @  T  h  |                  0  D  X  l                     4  H  \  p                	  $	  8	  L	  `	  t	  	  	  	  	  	  	   
  
  (
  <
  P
  d
  x
  
  
  
  
  
  
      ,  @  T  h  |                  0  D  X  l                
   
  4
  H
  \
  p
  
  
  
  
  
  
  
    $  8  L  `  t                   (  <  P  d  x                  ,  @  T  h  |                  0  D  X  l                     4  H  \  p                  $  8  L  `  t                  j'  T8  >I  (Z  k  {    Н        x  b  L 6  % 
6 F W h y   p Z D .    " 3 D U ~f hw R < &         v1 `B JS 4d u   ܧ Ƹ    n X
 B ,/ @  Q a r    | f P : $   , = N _ p t ^ H 2       * ; lL V] @n *        z d N( 89 "J [ k | ʍ    r \ F 0  & 6 G X i z  j T > (   	 	 #	 4	 E	 xV	 bg	 Lx	 6	  	 
	 	 	 	 	 	 
 p!
 Z2
 DC
 .T
 e
 v
 
 ֗
 
 
 
 ~
 h
 R
 < & 0 @ Q b s   v ` J 4     - > O ` nq X B ,       	
 
 |+
 f<
 PM
 :^
 $o
 
 
 
 ̲
 
 
 
 t
 ^ H 2) : K [ l }    l V @ *   & 7 H Y j z{ d N 8 "      $ 5 rF \W Fh 0y    ؼ            	                !  $  '  *  -  0  3  6  9  <  ?  B  E  H  K  N  Q  T  W  Z  ]  `  c  f  i  l  o  r  u  x  {  ~                                                                                                               #  &  )  ,  /  2  5  8  ;  >  A  D  G  J  M  P  S  V  Y  \  _  b  e  h  k  n  q  t  w  z  }                                                                                              
  
              "  %  (  +  .  1  4  7  :  =  @  C  F  I  L  O  R  U  X  [  ^  a  d  g  j  m  p  s  v  y  |                                                                                                                                                                                                                                 .   E   \   s                       +  B  Y  p                (  ?  V  m                %  <  S  j                "  9  P  g  ~                6  M  d  {                3  J  a  x                0  G  ^  u                -  D  [  r              	  *	  A	  X	  o	  	  	  	  	  	  	  
  '
  >
  U
  l
  
  
  
  
  
  
  
  $  ;  R  i              
  !  8  O  f  }            
  
  5
  L
  c
  z
  
  
  
  
  
      2  I  `  w                /  F  ]  t                ,  C  Z  q                )  @  W  n                &  =  T  k                #  :  Q  h              	     7  N  e  |                4  K  b  y                1  H  _  v      '  t8  ^I  HZ  2k  |      ڮ  Ŀ        l V @% *6 G W h y    z d N 8 "  " 3 D U f w r \ F 0        1 B jS Td >u (        x
 b L/ 6@  Q 
b r ރ Ȕ    p Z D .  - = N _ p  ~ h R < &     * ; L v] `n J 4         n( X9 BJ ,[ l  }  Ԟ    | f P : $& 7 G X i z   t ^ H 2  	 	 #	 4	 E	 V	 g	 lx	 V	 @	 *	 	 	 	 	 	 
 !
 z2
 dC
 NT
 8e
 "v
 
 
 
 ʹ
 
 
 
 r
 \ F 00 A R b s     j T > (   - > O ` q x b L 6   
   	
 
 +
 <
 pM
 Z^
 Do
 .
 
 
 
 
 
 
 
 ~ h R) <: &K \ l } Ύ    v ` J 4  ' 7 H Y j {  n X B ,      $ 5 F |W fh Py : $                                                                                                              .   E   \   s                       +  B  Y  p                (  ?  V  m                %  <  S  j                "  9  P  g  ~                6  M  d  {                3  J  a  x                0  G  ^  u                -  D  [  r              	  *	  A	  X	  o	  	  	  	  	  	  	  
  '
  >
  U
  l
  
  
  
  
  
  
  
  $  ;  R  i              
  !  8  O  f  }            
  
  5
  L
  c
  z
  
  
  
  
  
      2  I  `  w                /  F  ]  t                ,  C  Z  q                )  @  W  n                &  =  T  k                #  :  Q  h              	     7  N  e  |                4  K  b  y                1  H  _  v         '  8  I  Z  k  v|  _  H  1            % y6 bG KX 4i z   ج    | e N 7#  4 	E U f w    h Q : #     1 B S d ku T = &      
  n/ W@ @Q )b s   ͥ    q Z C , - = N _ p   t ] F /     * ; L w] `n I 2        z c( L9 5J [ l | ٍ    } f O 8 ! 
& 6 G X i z  i R ; $ 
  	 	 #	 4	 E	 lV	 Ug	 >x	 '	 	 	 	 	 	 	 	 o
 X!
 A2
 *C
 T
 d
 u
 Ά
 
 
 
 r
 [
 D
 -
   / @ Q b s u ^ G 0       - x> aO J` 3q    ״    { d	
 M
 6+
 <
 M
 ]
 n
 
 
 
 ~
 g
 P
 9
 "
   ( 9 J [ l j} S < %       & m7 VH ?Y (j {   ̭    p Y B +$ 5 E V g x   s \ E .                                                                                                                                                                                                                                                                                                          .   E   \   s                       +  B  Y  p                (  ?  V  m                %  <  S  j                "  9  P  g  ~                6  M  d  {                3  J  a  x                0  G  ^  u                -  D  [  r              	  *	  A	  X	  o	  	  	  	  	  	  	  
  '
  >
  U
  l
  
  
  
  
  
  
  
  $  ;  R  i              
  !  8  O  f  }            
  
  5
  L
  c
  z
  
  
  
  
  
      2  I  `  w                /  F  ]  t                ,  C  Z  q                )  @  W  n                &  =  T  k                #  :  Q  h              	     7  N  e  |                4  K  b  y                1  H  _  v                 	(  8  I  Z  k  |    h  Q  :  #        % 6 G kX Ti =z &        n W# @4 )E V f w ͈    q Z C ,    1 B S d u t ] F /     
  / w@ `Q Ib 2s    ֶ    z c L 5- > O _ p    } f O 8 ! 
	  * ; L ] n i R ; $ 
      ( l9 UJ >[ 'l }   ˯    o X A *& 7 G X i z   r [ D -  	 	 #	 4	 E	 V	 ug	 ^x	 G	 0	 	 	 	 	 	 	 
 x!
 a2
 JC
 3T
 e
 v
 
 ח
 
 
 
 {
 d
 M
 6  0 @ Q b s  ~ g P 9 "     - > O j` Sq < %       	
 m
 V+
 ?<
 (M
 ^
 n
 
 ̐
 
 
 
 p
 Y
 B
 +  ( 9 J [ l } s \ E .       & 7 vH _Y Hj 1{    վ    y b K$ 45 F W g x    | e N 7                     	  
      
                                                                             0   H   `   x                       8  P  h                (  @  X  p                 0  H  `  x                 8  P  h                (  @  X  p                 0  H  `  x                 8  P  h                (  @  X  p             	  	  0	  H	  `	  x	  	  	  	  	  	  
   
  8
  P
  h
  
  
  
  
  
  
    (  @  X  p                 0  H  `  x            
   
  8
  P
  h
  
  
  
  
  
  
    (  @  X  p                 0  H  `  x                 8  P  h                (  @  X  p                 0  H  `  x                 8  P  h                (  @  X  p                 0  H  `  x                 8  P  h                  @  )(  9  I  Z  k  |      q  Z  C  ,      % 6 G X ti ]z F /        w# `4 IE 2V g x  ֙    z c L 5 ! 2 B S d u  } f O 8 ! 
  
  / @ Q ib Rs ; $ 
       l U- >> 'O ` p  ˒    o X A *	  * ; L ] n  r [ D -      ( 9 uJ ^[ Gl 0}        x a J& 37 H Y i z    { d M 6 	 	 #	 4	 E	 V	 g	 ~x	 g	 P	 9	 "	 	 	 	 	 
 !
 2
 jC
 ST
 <e
 %v
 
 
 
 ɹ
 
 
 
 m
 V ? (0 A Q b s    p Y B +    - > O ` sq \ E .       	
 
 v+
 _<
 HM
 1^
 o
 
 
 ա
 
 
 
 y
 b
 K 4 ) : J [ l }  | e N 7   	   & 7 H Y hj Q{ : #        k$ T5 =F &W h x  ʚ    n W     !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?                                         0   H   `   x                       8  P  h                (  @  X  p                 0  H  `  x                 8  P  h                (  @  X  p                 0  H  `  x                 8  P  h                (  @  X  p             	  	  0	  H	  `	  x	  	  	  	  	  	  
   
  8
  P
  h
  
  
  
  
  
  
    (  @  X  p                 0  H  `  x            
   
  8
  P
  h
  
  
  
  
  
  
    (  @  X  p                 0  H  `  x                 8  P  h                (  @  X  p                 0  H  `  x                 8  P  h                (  @  X  p                 0  H  `  x                 8  P  h                (  ?  `  I(  29  J  [  k  |        z  c  L  5    % 6 G X i }z f O 8 ! 
     # 4 iE RV ;g $x 
  ߪ Ȼ    l U >! '2 C S d u    o X A *  
  / @ Q b rs [ D -        u- ^> GO 0` q   ԣ    x a J	 3 + < L ] n   { d M 6     ( 9 J ~[ gl P} 9 "        j& S7 <H %Y j z  ɜ    m V ?	 (	 $	 4	 E	 V	 g	 x	 	 p	 Y	 B	 +	 	 	 	 
 !
 2
 C
 sT
 \e
 Ev
 .
 
  
 
 
 
 
 
 v _ H0 1A R c s Մ    y b K 4   - > O ` q | e N 7   	   	
 
 +
 <
 hM
 Q^
 :o
 #
 
 
 ޲
 
 
 
 
 k T =) &: K [ l }    n W @ )   & 7 H Y j q{ Z C ,       $ t5 ]F FW /h y   ӫ    w  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _                                         0   H   `   x                       8  P  h                (  @  X  p                 0  H  `  x                 8  P  h                (  @  X  p                 0  H  `  x                 8  P  h                (  @  X  p             	  	  0	  H	  `	  x	  	  	  	  	  	  
   
  8
  P
  h
  
  
  
  
  
  
    (  @  X  p                 0  H  `  x            
   
  8
  P
  h
  
  
  
  
  
  
    (  @  X  p                 0  H  `  x                 8  P  h                (  @  X  p                 0  H  `  x                 8  P  h                (  @  X  p                 0  H  `  x                 8  P  h                (  @  X  _    i(  R9  ;J  $[  
l  |  ߍ  Ȟ        l  U  > ' & 6 G X i z  o X A *     # 4 E rV [g Dx -        u ^! G2 0C T e u Ԇ    x a J 3   / @ Q b s { d M 6       - ~> gO P` 9q "   ݴ     j	 S <+ %< M ] n     m V ? (   ( 9 J [ l p} Y B +       & s7 \H EY .j {    ҭ    v _	 H	 1$	 5	 F	 V	 g	 x	 	 	 y	 b	 K	 4	 	  
 
 !
 2
 C
 T
 |e
 ev
 N
 7
  
 	
 
 
 
 
   h0 QA :R #c t  ޕ Ǧ    k T = & . > O ` q   n W @ )   	
 
 +
 <
 M
 q^
 Zo
 C
 ,
 
 
 
 
 
 
  t ]) F: /K \ m } ӎ    w ` I 2  ' 7 H Y j { z c L 5      $ 5 }F fW Oh 8y ! 
  ܼ     `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                                           0   H   `   x                       8  P  h                (  @  X  p                 0  H  `  x                 8  P  h                (  @  X  p                 0  H  `  x                 8  P  h                (  @  X  p             	  	  0	  H	  `	  x	  	  	  	  	  	  
   
  8
  P
  h
  
  
  
  
  
  
    (  @  X  p                 0  H  `  x            
   
  8
  P
  h
  
  
  
  
  
  
    (  @  X  p                 0  H  `  x                 8  P  h                (  @  X  p                 0  H  `  x                 8  P  h                (  @  X  p                 0  H  `  x                 8  P  h                (  @  X  p       (  9  J  [  l  p}  X  @  (            & h7 PH 8Y  j {  ؜    x ` H 0 $  5 E V g x  p X @ (     ! 2 C hT Pe 8v     ع    x ` H 00 A  R b s    p X @ (    - > O ` hq P 8        	 x `+ H< 0M ^  o  А    p X @ (  ( 9 J [ l } h P 8        & x7 `H HY 0j {    Э    p X	 @	 ($	 5	 E	 V	 g	 x	 	 	 h	 P	 8	  	 	 	 
 !
 2
 C
 xT
 `e
 Hv
 0
 
  
 
 
 
 
 
 p X @0 (A R b s Ȅ    h P 8     - > O ` xq ` H 0       	
 
 p+
 X<
 @M
 (^
 o
 
 
 ȡ
 
 
 
 h
 P
 8   ) 9 J [ l } x ` H 0       & 7 pH XY @j ({    Ⱦ    h P 8$  5 F V g x   x ` H 0                                                                                                                                                                                                                                                                                                                                                                                                          0   H   `   x                       8  P  h                (  @  X  p                 0  H  `  x                 8  P  h                (  @  X  p                 0  H  `  x                 8  P  h                (  @  X  p             	  	  0	  H	  `	  x	  	  	  	  	  	  
   
  8
  P
  h
  
  
  
  
  
  
    (  @  X  p                 0  H  `  x            
   
  8
  P
  h
  
  
  
  
  
  
    (  @  X  p                 0  H  `  x                 8  P  h                (  @  X  p                 0  H  `  x                 8  P  h                (  @  X  p                 0  H  `  x                 8  P  h                (  @  X  p                )  :  hK  P\  8m   ~      ذ        x  ` H 0' 8  I Y j {   p X @ (    $ 5 F W hh Py 8          x `" H3 0D U  f v Ї    p X @ (   0 A R c t h P 8         x. `? HP 0a r    Ф    p X @
 ( , < M ^ o   h P 8       ) : xK `\ Hm 0~         p X @' (8 I Y j {    h P 8   	 	 $	 5	 F	 W	 xh	 `y	 H	 0	 	  	 	 	 	  
 
 p"
 X3
 @D
 (U
 f
 v
 
 Ș
 
 
 
 h
 P
 8
     0 A R c t x ` H 0        . p? XP @a (r    ȵ    h P

 8
  ,
 =
 M
 ^
 o
 
 
 x
 `
 H
 0
 
  
   ) : K p\ Xm @~ (        h P' 88  I Z j {    x ` H 0    $ 5 F W h py X @ (                         	  
      
                                         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                                                                                                                                                                                                                                                                                           2   K   d   }                    ,  E  ^  w            
  &  ?  X  q                 9  R  k                3  L  e  ~              -  F  _  x              '  @  Y  r              !  :  S  l                4  M  f              	  .	  G	  `	  y	  	  	  	  	  	  
  (
  A
  Z
  s
  
  
  
  
  
  	  "  ;  T  m                5  N  g              
  /
  H
  a
  z
  
  
  
  
  
    )  B  [  t            
  #  <  U  n                6  O  h                0  I  b  {              *  C  \  u              $  =  V  o                7  P  i                1  J  c  |              +  D  ]  v              %  >  W  p                8  Q  j              P  7*  ;  L  \  m  ~      o  V  =  $      ' 8 I uZ \k C| *   ߿    { b I% 06 G W h y    h O 6    " 3 D U nf Uw < # 
      t [  B1 )B S c t Ņ   z a H /    . ? P a gr N 5       
 m T, ;= "N 	_ o ׀    s Z A (   ) : K \ ym `~ G .        f' M8 4I Z k { Ќ    l S : !	 	 $	 5	 F	 W	 h	 ry	 Y	 @	 '	 	 	 	 	  
 
 x"
 _3
 FD
 -U
 f
 v
 
 ɘ
 
 
 ~
 e
 L
 3
    0 A R c t k R 9         q. X? ?P &a 
r  ۓ ¤   w ^ E ,

 
 +
 <
 M
 ^
 o
 }
 d
 K
 2
 
  
 
 
   ) j: QK 8\ m ~  ԟ    p W > % ' 7 H Y j { v ] D +      $ |5 cF JW 1h y   ͫ    i                     	  
      
                                         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O                                                                                         4   N   h                      8  R  l              "  <  V  p              &  @  Z  t              *  D  ^  x              .  H  b  |              2  L  f                6  P  j                 :  T  n            
	  $	  >	  X	  r	  	  	  	  	  	  
  (
  B
  \
  v
  
  
  
  
  
    ,  F  `  z              0  J  d  ~           
  
  4
  N
  h
  
  
  
  
  
      8  R  l              "  <  V  p              &  @  Z  t              *  D  ^  x              .  H  b  |              2  L  f                6  P  j                 :  T  n            
  $  >  X  r              (  B  \  v              ,  F  `  z              0  J  O    g*  N;  5L  ]  n  ~  я        m  T  ;  " 	 ' 8 I Z k s| Z A (       y% `6 GG .X i y  ʛ    f M 4  # 3 D U f w l S : !        r1 YB @S 'd u  ܖ ç   x _ F -
  . ? P a r ~ e L 3     
  , k= RN 9_  p   բ    q X ? & 
* : K \ m ~ w ^ E ,      ' }8 dI KZ 2k |    ή    j Q	 8	 %	 6	 F	 W	 h	 y	 	 p	 W	 >	 %	 	 	  
 
 "
 3
 vD
 ]U
 Df
 +w
 
 
 
 Ǻ
 
 
 |
 c
 J 1  1 A R c t   i P 7      . ? oP Va =r $   ٵ    u \

 C
 *,
 =
 M
 ^
 o
 
 
 {
 b
 I
 0
 
 
   ) : K h\ Om 6~        n U <' #8 
I Y j {   t [ B )    $ 5 F zW ah Hy /        P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                                                           4   N   h                      8  R  l              "  <  V  p              &  @  Z  t              *  D  ^  x              .  H  b  |              2  L  f                6  P  j                 :  T  n            
	  $	  >	  X	  r	  	  	  	  	  	  
  (
  B
  \
  v
  
  
  
  
  
    ,  F  `  z              0  J  d  ~           
  
  4
  N
  h
  
  
  
  
  
      8  R  l              "  <  V  p              &  @  Z  t              *  D  ^  x              .  H  b  |              2  L  f                6  P  j                 :  T  n            
  $  >  X  r              (  B  \  v              ,  F  `  z              0  J  d  ~             *  ;  L  ]  ~n  d  J  0             z `( F9 ,J [ k | č   v \ B (   % 6 G X ri Xz > $ 
      n T# :4  E V f w    j P 6      1 B S fd Lu 2       | b
 H ./ @ P a r   x ^ D *   
  , = tN Z_ @p &   س    p V < "* ; K \ m ~  l R 8      ' 8 hI NZ 4k |    ̮   ~ d J	 0	 %	 5	 F	 W	 h	 y	 z	 `	 F	 ,	 	 	 	  
 
 "
 v3
 \D
 BU
 (f
 w
 
 ژ
 
 
 
 r
 X
 >
 $ 
  0 A R c t n T :         j. P? 6P a r  Γ    f L 2 

 
 +
 <
 M
 ^
 |o
 b
 H
 .
 
 
 
 
 
  x ^) D: *K \ l }    t Z @ &   & 7 H Y pj V{ < "       l R$ 85 F W g x    h N 4                                                                                                          :   W   t                 "  ?  \  y          
  '  D  a  ~            ,  I  f              1  N  k              6  S  p              ;  X  u            #  @  ]  z            (  E  b            	  -	  J	  g	  	  	  	  	  	  
  2
  O
  l
  
  
  
  
  
    7  T  q              <  Y  v          
  $
  A
  ^
  {
  
  
  
  
    )  F  c              .  K  h              3  P  m              8  U  r               =  Z  w            %  B  _  |          
  *  G  d              /  L  i              4  Q  n              9  V  s            !  >  [  x          	  &  C  `  }            +  H  e              0  M  j              5  R  o              c.  F?  )P  a  q  ҂      {  ^  A  $    	  + < vM Y^ <o    Ȳ   q T 7  ( 9 J [ l l} O 2       g J& -7 H X i z   b E (     # z4 ]E @V #g x  ̙   u X ;     1 B S pd Su 6   ߸    k N
 1 / ? P a r  f I ,     
 ~ a, D= 'N 
_ o Ѐ   y \ ? "    ) : tK W\ :m ~    ư   o R 5	 	 &	 7	 H	 Y	 j	 j{	 M	 0	 	 	 	 	 	 
 e
 H$
 +5
 F
 V
 g
 x
 
 }
 `
 C
 &
 	
 
 
  ! x2 [C >T !e v  ʗ   s V 9  
  / @ Q nb Qs 4   ݶ    i L
 /
 -
 =
 N
 _
 p
 
 d
 G
 *
 

 
 
 
  | _* B; %L ] m ~   w Z =      ' 8 rI UZ 8k |   Į   m P 3  $ 5 F W h hy K .                          	  
      
                                         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                                                                                                                                           <   Z   x                 ,  J  h              :  X  v            *  H  f              8  V  t          
  (  F  d              6  T  r            &  D  b              4  R  p          	  $	  B	  `	  ~	  	  	  	  	  
  2
  P
  n
  
  
  
  
    "  @  ^  |            0  N  l          
   
  >
  \
  z
  
  
  
  
    .  L  j               <  Z  x            ,  J  h              :  X  v            *  H  f              8  V  t          
  (  F  d              6  T  r            &  D  b              4  R  p            $  B  `  ~            2  P  n            "  @  ^  |            0  N  l               >  \  z            .  L  j               /  @  Q  b  es  F  '            m  N / - = N _ p u V 7      } ^ ?*  ; L \ m ~  f G ( 	     n' O8 0I Z j {   v W 8     $ ~5 _F @W !h y  Ě   g H ) 
   ! 2 C oT Pe 1v   Ԩ   w X 9   / @ Q b `s A "      h I * - = N _ p p Q 2      x Y :* ; K \ m ~  a B #    	 	 i'	 J8	 +I	 Z	 j	 {	 	 	 q	 R	 3	 	 	 
 
 $
 y5
 ZF
 ;W
 h
 x
 މ
 
 
 
 b
 C
 $
    ! 2 C jT Ke ,v 
  Ϩ   r S 4   / @ Q zb [s <   ߶    c D
 %
 -
 =
 N
 _
 p
 k
 L
 -
 
 
 
 
 
 s T 5* ; K \ m ~ { \ =       d' E8 &I Z j {   l M .     $ t5 UF 6W h x ى   | ] >                      	  
      
                                         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           >   ]   |                 6  U  t            .  M  l            &  E  d              =  \  {            5  T  s            -  L  k            %  D  c              <  [  z          	  4	  S	  r	  	  	  	  	  
  ,
  K
  j
  
  
  
  
    $  C  b              ;  Z  y          
  3
  R
  q
  
  
  
  
    +  J  i            #  B  a              :  Y  x            2  Q  p            *  I  h            "  A  `              9  X  w            1  P  o          
  )  H  g            !  @  _  ~            8  W  v            0  O  n          	  (  G  f               ?  ^  }            7  V  u            /  N  m            '  F  e                0  A  R  c  `t  @                `  @    . > O ` q ` @         `	 @  +  < L ] n  ` @         ` @(  9  J Z k |  ` @         `% @6  G  X h y   ` @         " `3 @D  U  f v    ` @        0 `A @R  c  t     ` @       - > `O @`  q       ` @    	  * ; L `] @n         ` @  	  	 '	 8	 I	 Z	 `k	 @|	  	  	 	 	 	 	 `	 @
  
  %
 5
 F
 W
 h
 `y
 @
  
  
 
 
 
 
 `  @  "  3 C T e v ` @         ` @  0  A Q b s  ` @        
 `
 @-
  >
  O
 _
 p
 
 
 `
 @
  
  
 
 
   `* @;  L  ] m ~   ` @        ' `8 @I  Z  k {    ` @       $ 5 `F @W  h  y     ` @                       	  
      
                                         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            @   `                     @  `                @  `                @  `                @  `                @  `                @  `                @  `                @  `           	   	  @	  `	  	  	  	  	   
   
  @
  `
  
  
  
  
        @  `                @  `           
   
  @
  `
  
  
  
  
        @  `                @  `                @  `                @  `                @  `                @  `                @  `                @  `                @  `                @  `                @  `                @  `                @  `                @  `                @  `                @  `                @  `                @  `            p   P1  0B  S  c  t      p  P  0          p. P? 0P a q Ђ   p P 0   	  + p< PM 0^ o  А   p P 0    ( 9 pJ P[ 0l }  О   p P 0   % 6 G pX Pi 0z   Ь   p P 0  " 3 D U pf Pw 0   к   p P 0   0 A R c pt P 0      p P 0 . > O ` q p P 0      p	 P 0+ < L ] n  p P 0     	 p	 P(	 09	 J	 Z	 k	 |	 	 p	 P	 0	 	 	 	 
 
 p%
 P6
 0G
 X
 h
 y
 
 
 p
 P
 0
 
 
    " p3 PD 0U f v Ї   p P 0     0 pA PR 0c t  Е   p P 0  
 
 -
 >
 pO
 P`
 0q
 
 
 У
 
 
 p
 P
 0
 	  * ; L p] Pn 0   б   p P 0  ' 8 I Z pk P| 0   п   p P 0 % 5 F W h py P 0                                   	   
         
                                                             !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /   0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?   @   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O   P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _   `   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o                                                                                                                       !   B   c                 )  J  k            1  R  s            9  Z  {             A  b            (  I  j            0  Q  r            8  Y  z            @  a          	  '	  H	  i	  	  	  	  	  
  /
  P
  q
  
  
  
  
    7  X  y            ?  `          
  &
  G
  h
  
  
  
  
  
  .  O  p            6  W  x            >  _            %  F  g            -  N  o            5  V  w            =  ^            $  E  f            ,  M  n            4  U  v            <  ]  ~          #  D  e          
  +  L  m            3  T  u            ;  \  }          "  C  d          	  *  K  l            2  S  t             :   [   o      1  `B  @S   d   u          `  @          . ? `P @a  r       ` @    
  + < M `^ @o         ` @     ( 9 J [ `l @}         ` @    & 6 G X i `z @         ` @  #  4 D U f w ` @         ` @   1  B R c t  ` @         ` @.  ?  P ` q   ` @       	  `+ @<  M  ^ n    ` @      	 	 (	 `9	 @J	  [	  l	 |	 	 	 	 `	 @	  	  	 
 
 %
 6
 `G
 @X
  i
  z
 
 
 
 
 `
 @
  
    " 3 D `U @f  w       ` @      0 A R `c @t         ` @  
  
 -
 >
 O
 `
 `q
 @
  
  
 
 
 
 
 `
 @	    + ; L ] n ` @         ` @  (  9 I Z k | ` @         ` @%  6  G W h y  ` @        p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~                                                                                                                                                          !   B   c                 )  J  k            1  R  s            9  Z  {             A  b            (  I  j            0  Q  r            8  Y  z            @  a          	  '	  H	  i	  	  	  	  	  
  /
  P
  q
  
  
  
  
    7  X  y            ?  `          
  &
  G
  h
  
  
  
  
  
  .  O  p            6  W  x            >  _            %  F  g            -  N  o            5  V  w            =  ^            $  E  f            ,  M  n            4  U  v            <  ]  ~          #  D  e          
  +  L  m            3  T  u            ;  \  }          "  C  d          	  *  K  l            2  S  t             :   [   |            1  B  pS  Pd  0u      Ч      p  P  0  
  . ? P pa Pr 0   е   p P 0
  + < M ^ po P 0      p P 0 ) 9 J [ l p} P 0      p P 0& 7 G X i z p P 0      p P# 04 E U f w  p P 0      p  P1 0B S c t   p P 0      p. P? 0P a q Ђ   p P 0   	  + p< PM 0^ o  А   p P 0  	 	 (	 9	 pJ	 P[	 0l	 }	 	 О	 	 	 p	 P	 0	 
 
 %
 6
 G
 pX
 Pi
 0z
 
 
 Ь
 
 
 p
 P
 0  " 3 D U pf Pw 0   к   p P 0   0 A R c pt P 0      p P
 0
 .
 >
 O
 `
 q
 p
 P
 0
 
 
 
 
 
 p	 P 0+ < L ] n  p P 0      p P( 09 J Z k |  p P 0      p% P6 0G X h y   p P 0                                                                                                                                                                                                        !   B   c                 )  J  k            1  R  s            9  Z  {             A  b            (  I  j            0  Q  r            8  Y  z            @  a          	  '	  H	  i	  	  	  	  	  
  /
  P
  q
  
  
  
  
    7  X  y            ?  `          
  &
  G
  h
  
  
  
  
  
  .  O  p            6  W  x            >  _            %  F  g            -  N  o            5  V  w            =  ^            $  E  f            ,  M  n            4  U  v            <  ]  ~          #  D  e          
  +  L  m            3  T  u            ;  \  }          "  C  d          	  *  K  l            2  S  t             :   [   |             !  1  B  S  |d  [u  :      ׸      t  S  2
  . ? P a lr K * 	     d C
 " , < M ^ }o \ ;      u T 3 ) 9 J [ l m} L + 
     e D #& 7 G X i ~z ] <      v U 4# 4 D U f w n M ,      f E  $1 B R c t  ^ =      w V 5. ? O ` q  o N -     	 g F+ %< M ] n   _ >     	 x	 W(	 69	 J	 Z	 k	 |	 	 p	 O	 .	 
	 	 	 
 
 h%
 G6
 &G
 X
 h
 y
 
 
 `
 ?
 
 
 
    y" X3 7D U e v   q P /      i0 HA 'R c s Ą   a @    
 
 z-
 Y>
 8O
 `
 p
 Ձ
 
 
 r
 Q
 0
 
 
   * j; IL (] n ~ ŏ   b A      ' {8 ZI 9Z k { ֌   s R 1    $ 5 kF JW )h y  ƚ   c B !                                                                                                                                                                                                      !   B   c                 )  J  k            1  R  s            9  Z  {             A  b            (  I  j            0  Q  r            8  Y  z            @  a          	  '	  H	  i	  	  	  	  	  
  /
  P
  q
  
  
  
  
    7  X  y            ?  `          
  &
  G
  h
  
  
  
  
  
  .  O  p            6  W  x            >  _            %  F  g            -  N  o            5  V  w            =  ^            $  E  f            ,  M  n            4  U  v            <  ]  ~          #  D  e          
  +  L  m            3  T  u            ;  \  }          "  C  d          	  *  K  l            2  S  t             :   [   |               P!  /2  C  S  d  u    i  H  '          
 a @/ @ P a r  z Y 8     
 r Q, 0= N ^ o   j I (      b) A:  K [ l }  { Z 9      s& R7 1H Y i z   k J )     # c4 BE !V  g w   | [ :       t1 SB 2S d t υ   l K * 	    . d? CP "a r    } \ ;   	  + u< TM 3^ o  А   m L + 
 	 	 (	 9	 eJ	 D[	 #l	 }	 	 	 	 ~	 ]	 <	 	 
 
 %
 6
 vG
 UX
 4i
 z
 
 ћ
 
 
 n
 M
 ,
   " 3 D fU Ef $w      ^ =    0 A wR Vc 5t   Ҧ   o N - 
 
 -
 >
 O
 g`
 Fq
 %
 
 
 ´
 
 
 _
 >
 	  * ; L x] Wn 6   ӱ   p O . 
 ' 8 I Z hk G| &   ÿ   ` ?  $ 5 F W yh Xy 7   Լ   q   !  !  !  !  !  !  !  !  !  	!  
!  !  !  
!  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !   !  !!  "!  #!  $!  %!  &!  '!  (!  )!  *!  +!  ,!  -!  .!  /!  0!  1!  2!  3!  4!  5!  6!  7!  8!  9!  :!  ;!  <!  =!  >!  ?!  @!  A!  B!  C!  D!  E!  F!  G!  H!  I!  J!  K!  L!  M!  N!  O!                                                                                      "   D   f                 2  T  v             B  d            0  R  t            @  b            .  P  r            >  `          
  ,  N  p            <  ^          	  *	  L	  n	  	  	  	  	  
  :
  \
  ~
  
  
  
    (  J  l            8  Z  |        
  &
  H
  j
  
  
  
  
    6  X  z          $  F  h            4  V  x           "  D  f            2  T  v             B  d            0  R  t            @  b            .  P  r            >  `          
  ,  N  p            <  ^            *  L  n            :  \  ~          (  J  l            8  Z  |          &  H  j            6  X  z           $   F   h               !  4!  O!  !  o2  NC  -T  e  u  ʆ      g  F  %      
  / _@ >Q b r ۃ   x W 6   
  , p= ON ._ 
p  ˑ   h G &    ) : `K ?\ m } ܎   y X 7    & 7 qH PY /j {  ̜   i H '   # 4 E aV @g x  ݙ   z Y 8     1 B rS Qd 0u   ͧ   j I ( 
  . ? P ba Ar    ޤ   { Z 9 
  + < M s^ Ro 1   β   k J )	 	 (	 9	 J	 [	 cl	 B}	 !	  	 ߯	 	 	 |	 [	 :
 
 %
 6
 G
 X
 ti
 Sz
 2
 
 
 Ͻ
 
 
 l
 K * 	# 3 D U f dw C "     } \ ;   0 A R c ut T 3      m L
 +
 
.
 >
 O
 `
 q
 e
 D
 #
 
 
 
 
 ~
 ]	 < + ; L ] n v U 4      n M ,( 9 I Z k | f E $      ^ =% 6 F W h y w V 5      P!  Q!  R!  S!  T!  U!  V!  W!  X!  Y!  Z!  [!  \!  ]!  ^!  _!  `!  a!  b!  c!  d!  e!  f!  g!  h!  i!  j!  k!  l!  m!  n!  o!  p!  q!  r!  s!  t!  u!  v!  w!  x!  y!  z!  {!  |!  }!  ~!  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !                                                                      "   D   f                 2  T  v             B  d            0  R  t            @  b            .  P  r            >  `          
  ,  N  p            <  ^          	  *	  L	  n	  	  	  	  	  
  :
  \
  ~
  
  
  
    (  J  l            8  Z  |        
  &
  H
  j
  
  
  
  
    6  X  z          $  F  h            4  V  x           "  D  f            2  T  v             B  d            0  R  t            @  b            .  P  r            >  `          
  ,  N  p            <  ^            *  L  n            :  \  ~          (  J  l            8  Z  |          &  H  j            6  X  z           $   F   h               !  4!  V!  x!  !   "  2  C  T  xe  Vv  4      ι      h  F  $  / @ Q zb Xs 6   ж   j H &  , = N |_ Zp 8   ҳ   l J (  ) : K ~\ \m :~   ԰   n L *  & 7 H Y ^j <{   ֭   p N , 
 # 4 E V `g >x   ت   r P .    1 B S bd @u   ڧ   t R 0 
  . ? P da Br    ܤ   v T 2 
  + < M f^ Do "   ޡ   x V 4 	 	 (	 9	 J	 h[	 Fl	 $}	 	 	 	 	 z	 X	 6	 
 
 %
 6
 G
 jX
 Hi
 &z
 
 
 
 
 |
 Z
 8
   " 3 D lU Jf (w   ©  ~ \ :    0 A nR Lc *t   Ħ   ^ <  
 
 -
 >
 pO
 N`
 ,q
 

 
 ƣ
 
 
 `
 >
 
   * ; rL P] .n   Ƞ   b @    ' 8 tI RZ 0k |  ʝ   d B     $ 5 vF TW 2h y  ̚   f D "  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !                                                                                                                      "   D   f                 2  T  v             B  d            0  R  t            @  b            .  P  r            >  `          
  ,  N  p            <  ^          	  *	  L	  n	  	  	  	  	  
  :
  \
  ~
  
  
  
    (  J  l            8  Z  |        
  &
  H
  j
  
  
  
  
    6  X  z          $  F  h            4  V  x           "  D  f            2  T  v             B  d            0  R  t            @  b            .  P  r            >  `          
  ,  N  p            <  ^            *  L  n            :  \  ~          (  J  l            8  Z  |          &  H  j            6  X  z           $   F   h               !  4!  V!  x!  !  !  !  !   #  3  D  U  tf  Qw  .      ź      \  9    0 A R gc Dt !  ۦ   r O , 	  - > }O Z` 7q   Σ   e B    * ; pL M] *n     { X 5    ' 8 cI @Z k { ׌   n K (    $ y5 VF 3W h x ʉ   a >     ! l2 IC &T e u   w T 1    
  _/ <@ Q a r   j G $    
 u R, /= N ^ o   ] :     	 h	 E)	 ":	 J	 [	 l	 }	 s	 P	 -	 
	 	 	 	 ~
 [
 8&
 7
 G
 X
 i
 z
 f
 C
  
 
 
 
 
 q N +# 4 D U f |w Y 6      d A   0 A R c ot L )     z W 4
 
 -
 >
 O
 `
 bq
 ?
 
 
 ִ
 
 
 m
 J
 '	  * ; L x] Un 2   ɱ   ` =   ' 8 I kZ Hk %|  ߝ   v S 0 
  $ 5 F ^W ;h y  Қ   i F #   "  "  "  "  "  "  "  "  "  	"  
"  "  "  
"  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "   "  !"  ""  #"  $"  %"  &"  '"  ("  )"  *"  +"  ,"  -"  ."  /"  0"  1"  2"  3"  4"  5"  6"  7"  8"  9"  :"  ;"  <"  ="  >"  ?"  @"  A"  B"  C"  D"  E"  F"  G"  H"  I"  J"  K"  L"  M"  N"  O"  P"  Q"  R"  S"  T"  U"  V"  W"  X"  Y"  Z"  ["  \"  ]"  ^"  _"  `"  a"  b"  c"  d"  e"  f"  g"  h"  i"  j"  k"  l"  m"  n"  o"  p"  q"  r"  s"  t"  u"  v"  w"  x"  y"  z"  {"  |"  }"  ~"  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "                                                                                                                                                                                                                                                                      #   F   i                 ;  ^          
  0  S  v          %  H  k            =  `            2  U  x          '  J  m            ?  b            4  W  z        	  )	  L	  o	  	  	  	  	  
  A
  d
  
  
  
  
    6  Y  |          +  N  q           
  C
  f
  
  
  
  
    8  [  ~        
  -  P  s          "  E  h            :  ]            /  R  u          $  G  j            <  _            1  T  w          &  I  l            >  a            3  V  y          (  K  n            @  c            5  X  {          *  M  p            B  e            7  Z  }        	  ,  O  r          !   D   g               !  9!  \!  !  !  !  !  "  ."  Q"  t"  "  "  "  "   $  4  E  V  pg  Lx  (          t  P  ,     1 B xS Td 0u   ħ  | X 4    . ? \P 8a r  ̓   ` <   	  + d< @M ^ n    h D       l( H9 $J  [ k |  p L (     t P% ,6 G W h y x T 0     |  X 4" 3 C T e v \ 8      ` <  / @ Q b ds @   Զ   h D    , = N l_ Hp $   ܢ   p L ( 	 	 )	 :	 tK	 P\	 ,m	 ~	 	 	 	 x	 T	 0	 	 
 
 &
 |7
 XH
 4Y
 j
 z
 ȋ
 
 
 \
 8
 
 
   # `4 <E V f w   d @      h  D1  B R c t  l H $      p
 L
 (.
 ?
 O
 `
 q
 t
 P
 ,
 
 
 
 
 x
 T	 0 + ; L ] |n X 4      \ 8  ' 8 I Z `k <|   Ю   d @   $ 5 F hW Dh  y  ؚ   l H $   #  #  #  #  #  #  #  #  #  	#  
#  #  #  
#  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #   #  !#  "#  ##  $#  %#  &#  '#  (#  )#  *#  +#  ,#  -#  .#  /#  0#  1#  2#  3#  4#  5#  6#  7#  8#  9#  :#  ;#  <#  =#  >#  ?#  @#  A#  B#  C#  D#  E#  F#  G#  H#  I#  J#  K#  L#  M#  N#  O#  P#  Q#  R#  S#  T#  U#  V#  W#  X#  Y#  Z#  [#  \#  ]#  ^#  _#  `#  a#  b#  c#  d#  e#  f#  g#  h#  i#  j#  k#  l#  m#  n#  o#  p#  q#  r#  s#  t#  u#  v#  w#  x#  y#  z#  {#  |#  }#  ~#  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #                                                                                                                                                                                                                                                                      $   H   l                  D  h            @  d            <  `            8  \            4  X  |          0  T  x          ,  P  t          (  L  p         	  $	  H	  l	  	  	  	  	   
  D
  h
  
  
  
  
    @  d            <  `          
  8
  \
  
  
  
  
    4  X  |          0  T  x          ,  P  t          (  L  p           $  H  l             D  h            @  d            <  `            8  \            4  X  |          0  T  x          ,  P  t          (  L  p           $  H  l             D  h            @  d            <  `            8  \             4   X   |            !  0!  T!  x!  !  !  !  "  ,"  P"  t"  "  "  "  #  (#  L#  p#  #  #  #  #  @$  5  E  V  g  x  h  D             l  H $!  2 B S d pu L (     t P ,
  . ? P xa Tr 0   ĵ  | X 4 
  + < M \^ 8o   ̡   ` <    ( 9 dJ @[ l | ԍ   h D      % l6 HG $X  i y   p L (      t" P3 ,D U e v  x T 0     | X 40 A Q b s  \ 8      ` < - = N _ p d @      h D	  	 )	 :	 K	 \	 lm	 H~	 $	  	 ܰ	 	 	 p	 L	 (
 
 &
 7
 H
 tY
 Pj
 ,{
 
 
 
 
 x
 T
 0
   # 4 |E XV 4g x  ș   \ 8      1 `B <S d t Ѕ   d @    
 
 h.
 D?
  P
 `
 q
 
 
 l
 H
 $
  
 
 
 	 p L+ (< M ] n  t P ,     x T 0( 9 I Z k || X 4      \ 8 % 5 F W h `y <   м   d   $  $  $  $  $  $  $  $  $  	$  
$  $  $  
$  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $   $  !$  "$  #$  $$  %$  &$  '$  ($  )$  *$  +$  ,$  -$  .$  /$  0$  1$  2$  3$  4$  5$  6$  7$  8$  9$  :$  ;$  <$  =$  >$  ?$                                                                      %   J   o              (  M  r          +  P  u        	  .  S  x          1  V  {          4  Y  ~          7  \            :  _            =  b          	  @	  e	  	  	  	  	  
  C
  h
  
  
  
  
  !  F  k          $  I  n        
  '
  L
  q
  
  
  
    *  O  t          -  R  w          0  U  z          3  X  }          6  [            9  ^            <  a            ?  d            B  g             E  j          #  H  m          &  K  p          )  N  s          ,  Q  v        
  /  T  y        
  2  W  |          5  Z            8  ]             ;   `               !  >!  c!  !  !  !  !  "  A"  f"  "  "  "  "  #  D#  i#  #  #  #  #  "$  ?$  `$  <5  F  V  g  x    d  @            h D!  2 B S d u l H $      p L
 ( / ? P a tr P ,     x T 0
  + < M |^ Xo 4   Ȳ   \ 8   ( 9 J `[ <l }  О   d @    % 6 hG DX  i y ؊   l H $      " p3 LD (U f v   t P ,     x T0 0A R b s  | X 4      \ 8- > N _ p  ` <      d	 @	 *	 :	 K	 \	 m	 h~	 D	  	 	 	 	 	 l	 H
 $
  '
 7
 H
 Y
 pj
 L{
 (
 
 
 
 
 t
 P
 ,  # 4 E xV Tg 0x   Ī  | X 4     1 B \S 8d u  ̖   ` <   
 
 .
 d?
 @P
 a
 q
 Ԃ
 
 
 h
 D
  
 
 
 	  l+ H< $M  ^ n   p L (     t P( ,9 J Z k | x T 0     | X 4% 6 F W h y \ 8       @$  A$  B$  C$  D$  E$  F$  G$  H$  I$  J$  K$  L$  M$  N$  O$  P$  Q$  R$  S$  T$  U$  V$  W$  X$  Y$  Z$  [$  \$  ]$  ^$  _$                                      %   J   o              (  M  r          +  P  u        	  .  S  x          1  V  {          4  Y  ~          7  \            :  _            =  b          	  @	  e	  	  	  	  	  
  C
  h
  
  
  
  
  !  F  k          $  I  n        
  '
  L
  q
  
  
  
    *  O  t          -  R  w          0  U  z          3  X  }          6  [            9  ^            <  a            ?  d            B  g             E  j          #  H  m          &  K  p          )  N  s          ,  Q  v        
  /  T  y        
  2  W  |          5  Z            8  ]             ;   `               !  >!  c!  !  !  !  !  "  A"  f"  "  "  "  "  #  D#  i#  #  #  #  #  "$  G$  _$   %  5  F  W  lh  Gy  "    ث      i  D     ! 2 C fT Ae v  җ   c >   
  / `@ ;Q b r ̃   ] 8    
  Z, 5= N ^ o  | W 2 
    y T /) 
: J [ l v} Q ,     s N ) & 6 G X pi Kz &  ܬ   m H #  " 3 D jU Ef  w  ֘   g B     0 dA ?R c s Є   a <      ^- 9> O _ p   [ 6     }	 X	 3*	 ;	 K	 \	 m	 z~	 U	 0	 	 	 	 	 w	 R
 -
 '
 7
 H
 Y
 tj
 O{
 *
 
 
 
 
 q
 L
 '  # 4 E nV Ig $x  ڙ   k F !     1 hB CS d t ԅ   e @    
 
 b.
 =?
 P
 `
 q
 
 
 _
 :
 
 
 
 
 	 \ 7+ < L ] n ~ Y 4     { V 1 ( 8 I Z xk S| . 	    u P +  $ 5 F rW Mh (y  ޚ   o J %  `$  a$  b$  c$  d$  e$  f$  g$  h$  i$  j$  k$  l$  m$  n$  o$  p$  q$  r$  s$  t$  u$  v$  w$  x$  y$  z$  {$  |$  }$  ~$  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $                                                                                                                                                                      %   J   o              (  M  r          +  P  u        	  .  S  x          1  V  {          4  Y  ~          7  \            :  _            =  b          	  @	  e	  	  	  	  	  
  C
  h
  
  
  
  
  !  F  k          $  I  n        
  '
  L
  q
  
  
  
    *  O  t          -  R  w          0  U  z          3  X  }          6  [            9  ^            <  a            ?  d            B  g             E  j          #  H  m          &  K  p          )  N  s          ,  Q  v        
  /  T  y        
  2  W  |          5  Z            8  ]             ;   `               !  >!  c!  !  !  !  !  "  A"  f"  "  "  "  "  #  D#  i#  #  #  #  #  "$  G$  l$  $  $  $  $  %  [6  6G  X  h  y    }  X  3          z U" 03 D T e v w R -     t O * 0 @ Q b qs L '  ݶ   n I $  , = N k_ Fp !  ע   h C    ) : eK @\ m } ю   b =     & _7 :H Y i z   \ 7     ~ Y# 44 E U f w { V 1     x S .  	1 A R c ut P +     r M (  - > O o` Jq %   ۣ   l G " 	 	 *	 ;	 iL	 D]	 n	 ~	 Տ	 	 	 f	 A	 	 	 
 
 '
 c8
 >I
 Z
 j
 {
 
 
 `
 ;
 
 
 
   ]$ 85 F V g x  Z 5     | W 2! 
2 B S d yu T / 
    v Q ,

 
 .
 ?
 P
 sa
 Nr
 )
 
 ߤ
 
 
 p
 K
 &
 
  + < mM H^ #o  ِ   j E      ( g9 BJ [ k |   d ?      a% <6 G W h y  ^ 9       %  %  %  %  %  %  %  %  %  	%  
%  %  %  
%  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %   %  !%  "%  #%  $%  %%  &%  '%  (%  )%  *%  +%  ,%  -%  .%  /%  0%  1%  2%  3%  4%  5%  6%  7%  8%  9%  :%  ;%  <%  =%  >%  ?%  @%  A%  B%  C%  D%  E%  F%  G%  H%  I%  J%  K%  L%  M%  N%  O%  P%  Q%  R%  S%  T%  U%  V%  W%  X%  Y%  Z%  [%  \%  ]%  ^%  _%  `%  a%  b%  c%  d%  e%  f%  g%  h%  i%  j%  k%  l%  m%  n%  o%  p%  q%  r%  s%  t%  u%  v%  w%  x%  y%  z%  {%  |%  }%  ~%  %                                                                                                                                      &   L   r            
  0  V  |          :  `            D  j          (  N  t          2  X  ~          <  b             F  l          *  P  v        	  4	  Z	  	  	  	  	  
  >
  d
  
  
  
  
  "  H  n          ,  R  x        
  6
  \
  
  
  
  
    @  f          $  J  p          .  T  z          8  ^            B  h           &  L  r        
  0  V  |          :  `            D  j          (  N  t          2  X  ~          <  b             F  l          *  P  v          4  Z            >  d          "  H  n          ,  R  x           6   \               !  @!  f!  !  !  !  !  $"  J"  p"  "  "  "  #  .#  T#  z#  #  #  #  $  8$  ^$  $  $  $  $  %  B%  h%  %  %  {6  VG  1X  i  y      x  S  .  	       u" P3 +D U e v  r M (     o J %0  A Q b s l G "     i D  , = N _ fp A   ҳ   c >   ) : K `\ ;m ~  ̟   ] 8    & 7 ZH 5Y j z Ƌ  | W 2 
    y# T4 /E 
V f w  v Q ,     s N  )1 B R c t p K &     m H # - > O ` jq E    ִ   g B 		 	 *	 ;	 L	 d]	 ?n	 	 	 Р	 	 	 a	 <	 	 
 
 '
 8
 ^I
 9Z
 k
 {
 ʌ
 
 
 [
 6
 
 
   }$ X5 3F W g x  z U 0     w R! -2 C S d u t O *     q L

 '
 /
 ?
 P
 a
 nr
 I
 $
 
 ڵ
 
 
 k
 F
 !
  + < M h^ Co   ԡ   e @    ( 9 bJ =[ l | ΍   _ :     % \6 7G X h y  ~ Y 4     %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %                                      &   L   r            
  0  V  |          :  `            D  j          (  N  t          2  X  ~          <  b             F  l          *  P  v        	  4	  Z	  	  	  	  	  
  >
  d
  
  
  
  
  "  H  n          ,  R  x        
  6
  \
  
  
  
  
    @  f          $  J  p          .  T  z          8  ^            B  h           &  L  r        
  0  V  |          :  `            D  j          (  N  t          2  X  ~          <  b             F  l          *  P  v          4  Z            >  d          "  H  n          ,  R  x           6   \               !  @!  f!  !  !  !  !  $"  J"  p"  "  "  "  #  .#  T#  z#  #  #  #  $  8$  ^$  $  $  $  $  %  B%  h%  %  %   &  6  G  X  hi  Bz      Ь      ^  8    " 3 zD TU .f w    p J $     f0 @A R b s   \ 6     x R ,- > N _ p n H "     d >  ) : K \ Zm 4~   °  v P *   & 7 lH FY  j z ԋ   b <     ~# X4 2E V f w  t N (     j D  1 A R c t ` :     | V 0 
 - > O r` Lq &   ڣ   h B  	 	 *	 ;	 ^L	 8]	 n	 ~	 Ə	 	 z	 T	 .	 	 	 
 
 p'
 J8
 $I
 Y
 j
 {
 
 f
 @
 
 
 
 
  \ 6$ 5 E V g xx R ,     n H "   1 B S dd >u   ̧   Z 4  
 
 .
 v?
 PP
 *a
 r
 ނ
 
 
 l
 F
  
 
 
 	  b+ << M ] n  ~ X 2     t N (( 9 I Z k j| D   ҿ   ` :  $ 5 F |W Vh 0y 
    r L &  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %                                                                                                      &   L   r            
  0  V  |          :  `            D  j          (  N  t          2  X  ~          <  b             F  l          *  P  v        	  4	  Z	  	  	  	  	  
  >
  d
  
  
  
  
  "  H  n          ,  R  x        
  6
  \
  
  
  
  
    @  f          $  J  p          .  T  z          8  ^            B  h           &  L  r        
  0  V  |          :  `            D  j          (  N  t          2  X  ~          <  b             F  l          *  P  v          4  Z            >  d          "  H  n          ,  R  x           6   \               !  @!  f!  !  !  !  !  $"  J"  p"  "  "  "  #  .#  T#  z#  #  #  #  $  8$  ^$  $  $  $  $  %  B%  h%  %  %  %  %   '  7  H  Y  dj  ={      ȭ    z  S  ,    # 4 iE BV g w ͈   X 1 
    n  G1  B R c t  ] 6     s L % - > O ` bq ;   ƴ  x Q * 	  * ; gL @] n ~ ˏ  } V /     l' E8 I Y j {  [ 4 
    q J #$ 4 E V g `x 9   Ļ  v O (    1 B eS >d u  ɖ  { T -     j. C? P ` q   Y 2     o		 H	 !+	 ;	 L	 ]	 n	 ^	 7	 	 	 	 	 t	 M	 &
 
 '
 8
 I
 cZ
 <k
 |
 
 ǝ
 
 y
 R
 +
 
   $ h5 AF W g x  ~ W 0 	    m F! 2 B S d u \ 5     r K $

 
 .
 ?
 P
 aa
 :r
 
 
 Ť
 
 w
 P
 )
 
 	  + f< ?M ^ n   | U .     k D( 9 I Z k | Z 3     p I " $ 5 F W _h 8y   ë  u N '   &  &  &  &  &  &  &  &  &  	&  
&  &  &  
&  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &   &  !&  "&  #&  $&  %&  &&  '&  (&  )&  *&  +&  ,&  -&  .&  /&  0&  1&  2&  3&  4&  5&  6&  7&  8&  9&  :&  ;&  <&  =&  >&  ?&  @&  A&  B&  C&  D&  E&  F&  G&  H&  I&  J&  K&  L&  M&  N&  O&  P&  Q&  R&  S&  T&  U&  V&  W&  X&  Y&  Z&  [&  \&  ]&  ^&  _&  `&  a&  b&  c&  d&  e&  f&  g&  h&  i&  j&  k&  l&  m&  n&  o&  p&  q&  r&  s&  t&  u&  v&  w&  x&  y&  z&  {&  |&  }&  ~&  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &                                                                                                                                                                                                                                                                      '   N   u              8  _          "  I  p          3  Z            D  k          .  U  |          ?  f          )  P  w          :  a          $	  K	  r	  	  	  	  
  5
  \
  
  
  
  
    F  m        	  0  W  ~        
  A
  h
  
  
  
    +  R  y          <  c          &  M  t          7  ^          !  H  o          2  Y            C  j          -  T  {          >  e          (  O  v          9  `          #  J  q        
  4  [            E  l          /  V  }          @  g          *  Q  x          ;  b          %   L   s            !  6!  ]!  !  !  !  !   "  G"  n"  "  "  "  
#  1#  X#  #  #  #  #  $  B$  i$  $  $  $  %  ,%  S%  z%  %  %  %  &  =&  d&  &  &  &  &  '  8  rI  KZ  $k  {  ֌      a  :        w$ P5 )F W g x  f ?     | U .! 2 B S d ku D   ϸ   Z 3 
  . ? pP Ia "r  ԓ   _ 8   	  u+ N< 'M  ^ n   d =     z S ,( 9 I Z k i| B   Ϳ   X 1 
 $ 5 F nW Gh  y  Қ   ] 6    ! s2 LC %T d u   b ;     x
 Q */ @ P a r g @     } V /
	 	 +	 <	 M	 l^	 Eo	 	 	 С	 	 	 [	 4	 
	 
 
 (
 q9
 JJ
 #[
 k
 |
 
 
 `
 9
 
 
 
  v O% (6 G W h y e >     { T  - " 2 C T je Cv   Ψ   Y 2  

 
 /
 o@
 HQ
 !b
 r
 Ӄ
 
 
 ^
 7
 
 
 
 
 t M, &= M ^ o  c <     y R + ) 9 J [ hl A}   ̯  ~ W 0 	  % 6 mG FX i y ъ   \ 5     '  '  '  '  '  '  '  '  '  	'  
'  '  '  
'  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '   '  !'  "'  #'  $'  %'  &'  ''  ('  )'  *'  +'  ,'  -'  .'  /'  0'  1'  2'  3'  4'  5'  6'  7'  8'  9'  :'  ;'  <'  ='  >'  ?'  @'  A'  B'  C'  D'  E'  F'  G'  H'  I'  J'  K'  L'  M'  N'  O'  P'  Q'  R'  S'  T'  U'  V'  W'  X'  Y'  Z'  ['  \'  ]'  ^'  _'  `'  a'  b'  c'  d'  e'  f'  g'  h'  i'  j'  k'  l'  m'  n'  o'  p'  q'  r'  s'  t'  u'  v'  w'  x'  y'  z'  {'  |'  }'  ~'  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '                                                                                                                                                                                                      (   P   x              @  h          0  X             H  p          8  `           (  P  x          @  h          0  X             H  p        	  8	  `	  	  	  	   
  (
  P
  x
  
  
  
    @  h          0  X           
  H
  p
  
  
  
    8  `           (  P  x          @  h          0  X             H  p          8  `           (  P  x          @  h          0  X             H  p          8  `           (  P  x          @  h          0  X             H  p          8  `           (  P  x          @  h           0   X                !  H!  p!  !  !  !  "  8"  `"  "  "  "   #  (#  P#  x#  #  #  #  $  @$  h$  $  $  $  %  0%  X%  %  %  %  %   &  H&  p&  &  &  &  '  8'  `'  '  '  '  '  8  I  {Z  Tk  -|    ߝ      j  C      $ 5 YF 2W h x   o H !     ^! 72 C S d u t M &     c <
  . ? P ya Rr +  ݤ   h A  	  + ~< WM 0^ 	o    m F      \( 59 J Z k | r K $     a : % 5 F W wh Py )  ۫   f ?    ! 2 |C UT .e v    k D    
  Z/ 3@ Q a r  p I "     _
	 8	 ,	 <	 M	 ^	 uo	 N	 '	  	 ٲ	 	 	 d	 =	 
 
 (
 9
 zJ
 S[
 ,l
 }
 ލ
 
 
 i
 B
 
 
   % X6 1G 
X h y  n G        ] 6" 3 C T e sv L %  ׹   b ; 
 
 /
 @
 xQ
 Qb
 *s
 
 ܔ
 
 
 g
 @
 
 
 
  }, V= /N _ o   l E      [ 4) 
: J [ l q} J #     ` 9  % 6 G vX Oi (z  ڛ   e >   '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '                                                      (   P   x              @  h          0  X             H  p          8  `           (  P  x          @  h          0  X             H  p        	  8	  `	  	  	  	   
  (
  P
  x
  
  
  
    @  h          0  X           
  H
  p
  
  
  
    8  `           (  P  x          @  h          0  X             H  p          8  `           (  P  x          @  h          0  X             H  p          8  `           (  P  x          @  h          0  X             H  p          8  `           (  P  x          @  h           0   X                !  H!  p!  !  !  !  "  8"  `"  "  "  "   #  (#  P#  x#  #  #  #  $  @$  h$  $  $  $  %  0%  X%  %  %  %  %   &  H&  p&  &  &  &  '  8'  `'  '  '  '  '   (  8  I  Z  `k  8|          p  H       $ 5 XF 0W h x   h @     x P! (2  C S d u ` 8     p H  
  . ? P Xa 0r     h @   	  x+ P< (M  ^ n   ` 8     p H  ( 8 I Z k X| 0     h @   $ 5 xF PW (h  y ؉   ` 8     p! H2  C S d u  X 0     h @
  . ? P xa Pr (   ؤ   ` 8  		 	 +	 p<	 HM	  ^	 n	 	 	 	 X	 0	 	 	 	 
 h
 @(
 9
 I
 Z
 k
 x|
 P
 (
  
 ؿ
 
 
 `
 8  $ 5 F pW Hh  y  К   X 0    ! h2 @C T d u  x P (      `

 8
 /
 ?
 P
 a
 pr
 H
  
 
 е
 
 
 X
 0
 
  + < hM @^ o  Ȑ  x P (      `( 89 J Z k | p H       X 0 % 5 F W hh @y   ȫ  x P (  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '                      (   P   x              @  h          0  X             H  p          8  `           (  P  x          @  h          0  X             H  p        	  8	  `	  	  	  	   
  (
  P
  x
  
  
  
    @  h          0  X           
  H
  p
  
  
  
    8  `           (  P  x          @  h          0  X             H  p          8  `           (  P  x          @  h          0  X             H  p          8  `           (  P  x          @  h          0  X             H  p          8  `           (  P  x          @  h           0   X                !  H!  p!  !  !  !  "  8"  `"  "  "  "   #  (#  P#  x#  #  #  #  $  @$  h$  $  $  $  %  0%  X%  %  %  %  %   &  H&  p&  &  &  &  '  8'  `'  '  '  '  '   )  9  J  [  \l  3}  
        f  =      % p6 GG X h y  z Q (      [ 2" 	3 C T e ev <     o F  
  / y@ PQ 'b r Ճ   Z 1    
 d ;, = M ^ o n E     x O &  ( 9 J Y[ 0l } ލ   c :     m% D6 G W h y w N %     X  / " 2 C T be 9v     l C   
  v/ M@ $Q a r   W .     a
	 8	 ,	 <	 M	 ^	 ko	 B	 	 	 ǲ	 	 u	 L	 #	 
 
 (
 9
 VJ
 -[
 l
 |
 
 
 `
 7
 
 
 
  j A% 6 F W h ty K "  м  ~ U ,   ! 2 C _T 6e 
v    i @    

 s
 J/
 !@
 P
 a
 r
 }
 T
 +
 
 
 
 
 ^
 5
  + < M h^ ?o   ġ  r I      |( S9 *J [ k |  ] 4     g > % 5 F W qh Hy   ͫ  { R )   (  (  (  (  (  (  (  (  (  	(  
(  (  (  
(  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (   (  !(  "(  #(  $(  %(  &(  '(  ((  )(  *(  +(  ,(  -(  .(  /(  0(  1(  2(  3(  4(  5(  6(  7(  8(  9(  :(  ;(  <(  =(  >(  ?(  @(  A(  B(  C(  D(  E(  F(  G(  H(  I(  J(  K(  L(  M(  N(  O(  P(  Q(  R(  S(  T(  U(  V(  W(  X(  Y(  Z(  [(  \(  ](  ^(  _(  `(  a(  b(  c(  d(  e(  f(  g(  h(  i(  j(  k(  l(  m(  n(  o(  p(  q(  r(  s(  t(  u(  v(  w(  x(  y(  z(  {(  |(  }(  ~(  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (  (                                                                                                                                                                                                                                                                      )   R   {              H  q          >  g          4  ]          *  S  |           I  r          ?  h          5  ^          +  T  }        !	  J	  s	  	  	  	  
  @
  i
  
  
  
  
  6  _          ,  U  ~        "
  K
  t
  
  
  
    A  j          7  `          -  V          #  L  u          B  k          8  a          .  W          $  M  v          C  l          9  b          /  X          %  N  w          D  m          :  c          0  Y          &  O  x          E  n          ;  d           1   Z               '!  P!  y!  !  !  !  "  F"  o"  "  "  "  #  <#  e#  #  #  #  	$  2$  [$  $  $  $  $  (%  Q%  z%  %  %  %  &  G&  p&  &  &  &  '  ='  f'  '  '  '  
(  3(  \(  (  (  (  (  )  W:  .K  \  l  }    a  8          k B & 6 G X ui Lz #  Ѭ   V -   " 3 `D 7U f v   j A     t K "0 @ Q b ~s U ,  ڶ   _ 6 
  , = iN @_ p  ő  s J !    } T) +: K [ l } ^ 5     h ?  % 6 G rX Ii  z  Λ  | S *     " ]3 4D U e v  g >     q H  / @ Q {b Rs )   ץ   \ 3 
 
	 	 ,	 f=	 =N	 _	 o	 	 	 p	 G	 	 	 	 	 z
 Q
 ()
 9
 J
 [
 l
 [}
 2
 	
 
 
 
 e
 <
   % 6 oG FX i y ˊ  y P '      Z" 13 D T e v d ;     n E 
 
 /
 @
 xQ
 Ob
 &s
 
 Ԕ
 
 
 Y
 0
 
 
 
  c, := N ^ o  m D     w N % ( 9 J [ Xl /}  ݞ   b 9    % l6 CG X h y  v M $      )  )  )  )  )  )  )  )  )  	)  
)  )  )  
)  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )   )  !)  ")  #)  $)  %)  &)  ')  ()  ))  *)  +)  ,)  -)  .)  /)  0)  1)  2)  3)  4)  5)  6)  7)  8)  9)  :)  ;)  <)  =)  >)  ?)  @)  A)  B)  C)  D)  E)  F)  G)  H)  I)  J)  K)  L)  M)  N)  O)  P)  Q)  R)  S)  T)  U)  V)  W)  X)  Y)  Z)  [)  \)  ])  ^)  _)  `)  a)  b)  c)  d)  e)  f)  g)  h)  i)  j)  k)  l)  m)  n)  o)  p)  q)  r)  s)  t)  u)  v)  w)  x)  y)  z)  {)  |)  })  ~)  )                                                                                                                                      *   T   ~            &  P  z        "  L  v          H  r          D  n          @  j          <  f          8  b        
  4  ^        	  0	  Z	  	  	  	  
  ,
  V
  
  
  
  
  (  R  |        $  N  x         
  J
  t
  
  
  
    F  p          B  l          >  h          :  d          6  `          2  \          .  X           *  T  ~        &  P  z        "  L  v          H  r          D  n          @  j          <  f          8  b        
  4  ^          0  Z          ,  V          (   R   |            $!  N!  x!  !  !  !   "  J"  t"  "  "  "  #  F#  p#  #  #  #  $  B$  l$  $  $  $  %  >%  h%  %  %  %  &  :&  d&  &  &  &  '  6'  `'  '  '  '  (  2(  \(  (  (  (  )  .)  X)  )   *  :  K  \  Xm  .~    ڟ      \  2      & `7 6H Y i z  d :     h > # 3 D U lf Bw   ĩ  p F     t0 JA  R b s  x N $    | R ( , = N _ Vp ,  آ   Z 0    ) ^: 4K 
\ l }  b 8     f < & 6 G X ji @z   ¬  n D     " r3 HD U e v  v L "    z P & / @ Q ~b Ts *   ֥   X .  
	 	 ,	 \=	 2N	 _	 o	 	 	 `	 6	 	 	 	 	 d
 :
 )
 9
 J
 [
 hl
 >}
 
 
 
 
 l
 B
 
   % p6 FG X h y  t J      x  N $" 2 C T |e Rv (  Ԩ   V ,  

 
 /
 Z@
 0Q
 b
 r
 
 
 ^
 4
 

 
 
 
 b
 8 , < M ^ fo <     j @    ( n9 DJ [ k |  r H     v L "% 5 F W zh Py &  ҫ  ~ T *  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )                                                                                                                                      *   T   ~            &  P  z        "  L  v          H  r          D  n          @  j          <  f          8  b        
  4  ^        	  0	  Z	  	  	  	  
  ,
  V
  
  
  
  
  (  R  |        $  N  x         
  J
  t
  
  
  
    F  p          B  l          >  h          :  d          6  `          2  \          .  X           *  T  ~        &  P  z        "  L  v          H  r          D  n          @  j          <  f          8  b        
  4  ^          0  Z          ,  V          (   R   |            $!  N!  x!  !  !  !   "  J"  t"  "  "  "  #  F#  p#  #  #  #  $  B$  l$  $  $  $  %  >%  h%  %  %  %  &  :&  d&  &  &  &  '  6'  `'  '  '  '  (  2(  \(  (  (  (  )  .)  X)  )  )  )  )   +  ;  L  ]  Tn  )    Ӡ    }  R  '      {' P8 %I Y j { y N #    w L ! # 4 E uV Jg x  ə  s H     q  F1 B R c t o D     m B   - > kO @` q    i >     g <* ; K \ m e~ :     c 8 
  & 7 aH 6Y j z   _ 4 	    ] 2# 4 D U f [w 0  ک   Y .    0 WA ,R c s   U *    ~ S	 (	 ,	 =	 N	 |_	 Qp	 &	 	 Т	 	 z	 O	 $	 	 
 
 x)
 M:
 "K
 [
 l
 }
 v
 K
  
 
 
 
 t
 I  % 6 G rX Gi z  ƛ  p E      n" C3 D T e v l A     j ? 
 
 /
 @
 hQ
 =b
 s
 
 
 
 f
 ;
 
 
 
 
 d 9, = M ^ o b 7     ` 5 
  ( 9 ^J 3[ l |   \ 1     Z /% 6 F W h Xy -  ׫   V +   *  *  *  *  *  *  *  *  *  	*  
*  *  *  
*  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *   *  !*  "*  #*  $*  %*  &*  '*  (*  )*  **  +*  ,*  -*  .*  /*  0*  1*  2*  3*  4*  5*  6*  7*  8*  9*  :*  ;*  <*  =*  >*  ?*  @*  A*  B*  C*  D*  E*  F*  G*  H*  I*  J*  K*  L*  M*  N*  O*  P*  Q*  R*  S*  T*  U*  V*  W*  X*  Y*  Z*  [*  \*  ]*  ^*  _*  `*  a*  b*  c*  d*  e*  f*  g*  h*  i*  j*  k*  l*  m*  n*  o*  p*  q*  r*  s*  t*  u*  v*  w*  x*  y*  z*  {*  |*  }*  ~*  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *                                                                                                                                                                                                                                                                      +   V              -  X          /  Z          1  \          3  ^        
  5  `          7  b          9  d          ;  f        	  =	  h	  	  	  	  
  ?
  j
  
  
  
    A  l          C  n        
  E
  p
  
  
  
    G  r          I  t           K  v        "  M  x        $  O  z        &  Q  |        (  S  ~        *  U          ,  W          .  Y          0  [          2  ]        	  4  _          6  a        
  8  c          :  e          <  g          >  i           @   k            !  B!  m!  !  !  !  "  D"  o"  "  "  "  #  F#  q#  #  #  #  $  H$  s$  $  $  $  %  J%  u%  %  %  %  !&  L&  w&  &  &  &  #'  N'  y'  '  '  '  %(  P(  {(  (  (  (  ')  R)  })  )  )  )  )*  T*  *  *  *  *   ,  <  M  |^  Po  $    ̡    t  H        l( @9 J Z k | d 8     \ 0  $ 5 F TW (h x Љ  x L      p D! 2 B S d hu <     ` 4    . X? ,P  a q  | P $    t H	  * ; L l] @n     d 8     \' 08 I Y j { T (  о  x L    # 4 pE DV g w   h <     ` 4  1 A R c Xt ,   Ԧ  | P $  	 	 t-	 H>	 O	 _	 p	 	 l	 @	 	 	 	 	 d	 8
 
 )
 :
 K
 \\
 0m
 ~
 ؎
 
 
 T
 (
 
 
  x L&  7 G X i pz D     h <   " 3 `D 4U f v   X ,     | P
 $
 /
 @
 Q
 tb
 Hs
 
 
 ĥ
 
 l
 @
 
 
 
  d, 8= N ^ o  \ 0     T (  ( 9 xJ L[  l | ȍ  p D     h <% 6 F W h `y 4  ܫ   X ,   +  +  +  +  +  +  +  +  +  	+  
+  +  +  
+  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +   +  !+  "+  #+  $+  %+  &+  '+  (+  )+  *+  ++  ,+  -+  .+  /+  0+  1+  2+  3+  4+  5+  6+  7+  8+  9+  :+  ;+  <+  =+  >+  ?+  @+  A+  B+  C+  D+  E+  F+  G+  H+  I+  J+  K+  L+  M+  N+  O+  P+  Q+  R+  S+  T+  U+  V+  W+  X+  Y+  Z+  [+  \+  ]+  ^+  _+  `+  a+  b+  c+  d+  e+  f+  g+  h+  i+  j+  k+  l+  m+  n+  o+  p+  q+  r+  s+  t+  u+  v+  w+  x+  y+  z+  {+  |+  }+  ~+  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +                                                                                                                                                                                                                                                                      /   ^              I  x        4  c          N  }      
  9  h        $  S          >  m        )  X          C  r        .	  ]	  	  	  	  
  H
  w
  
  
    3  b          M  |      	
  8
  g
  
  
  
  #  R          =  l        (  W          B  q        -  \          G  v        2  a          L  {        7  f        "  Q        
  <  k        '  V          A  p        ,  [          F  u        1  `          K  z        6  e        !   P            !  ;!  j!  !  !  !  &"  U"  "  "  "  #  @#  o#  #  #  #  +$  Z$  $  $  $  %  E%  t%  %  %  &  0&  _&  &  &  &  '  J'  y'  '  '  (  5(  d(  (  (  (   )  O)  ~)  )  )  *  :*  i*  *  *  *  %+  T+  +  +  +  ,  ?,  n,  ,  ,  ,  *-  Y-  -  -  -  .  D.  s.  .   /  ?  P  sa  Dr          Y  *      	 n ?+ < L ] n T %  Ǳ  i :    ~' O8  I Y j { d 5  ׾  y J   # 4 _E 0V g w  t E     Z +  0 A oR @c t    U &    j ; - = N _ Pp !  â  e 6    z K) : J [ l `} 1  ӯ  u F    % [6 ,G W h y p A     V '   ! 2 kC <T 
e u   Q "    f 7
	 	 .	 ?	 {P	 La	 r	 	 	 	 a	 2	 	 	 	 v	
 G
 +
 ;
 L
 ]
 \n
 -
 
 Ϡ
 
 q
 B
 
 
   W' (8 H Y j l{ =  ߭   R #   # g4 8E 	V f w | M     b 3 
 
 0
 wA
 HR
 c
 s
 
 
 ]
 .
 
 
 
 r
 C  , = N X_ )p  ˑ  m >     S $) 9 J [ hl 9} 
 ۞  } N     c% 46 G W h xy I     ^ /  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .                                                                                                                                      /   ^              I  x        4  c          N  }      
  9  h        $  S          >  m        )  X          C  r        .	  ]	  	  	  	  
  H
  w
  
  
    3  b          M  |      	
  8
  g
  
  
  
  #  R          =  l        (  W          B  q        -  \          G  v        2  a          L  {        7  f        "  Q        
  <  k        '  V          A  p        ,  [          F  u        1  `          K  z        6  e        !   P            !  ;!  j!  !  !  !  &"  U"  "  "  "  #  @#  o#  #  #  #  +$  Z$  $  $  $  %  E%  t%  %  %  &  0&  _&  &  &  &  '  J'  y'  '  '  (  5(  d(  (  (  (   )  O)  ~)  )  )  *  :*  i*  *  *  *  %+  T+  +  +  +  ,  ?,  n,  ,  ,  ,  *-  Y-  -  -  -  .  D.  s.  .  .  .  /  @  Q  Sb  $s    Ɣ    h  9  
      }
 N , < M ^ co 4  ֡  x I     ^( /9  J Z k s| D     Y *   $ n5 ?F W g x  T %    i :    1 ~B OS  d t   d 5    y J  - > O _` 0q  Ғ  t E     Z +* : K \ om @~     U &    j& ;7 H X i z P !  ý  e 6   " z3 KD U e v  ` 1    u F 	 	 /	 @	 [Q	 ,b	 r	 ΃	 	 p	 A	 	 	 	 	 V

 '
 +
 <
 M
 k^
 <o
 
 ސ
 
 
 Q
 "
 
 
  f 7( 9 I Z {k L|     a 2    v$ G5 F V g x \ -  ϻ  q B  
  
 1
 WB
 (S
 c
 t
 
 l
 =
 
 
 
 
 R
 #  - > gO 8` 	q ځ  | M     b 3 * : K w\ Hm ~    ] .    r C& 7 G X i Xz )  ˬ  m >    /  /  /  /  /  /  /  /  /  	/  
/  /  /  
/  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /   /  !/  "/  #/  $/  %/  &/  '/  (/  )/  */  +/  ,/  -/  ./  //  0/  1/  2/  3/  4/  5/  6/  7/  8/  9/  :/  ;/  </  =/  >/  ?/  @/  A/  B/  C/  D/  E/  F/  G/  H/  I/  J/  K/  L/  M/  N/  O/  P/  Q/  R/  S/  T/  U/  V/  W/  X/  Y/  Z/  [/  \/  ]/  ^/  _/  `/  a/  b/  c/  d/  e/  f/  g/  h/  i/  j/  k/  l/  m/  n/  o/  p/  q/  r/  s/  t/  u/  v/  w/  x/  y/  z/  {/  |/  }/  ~/  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /                                                                                                                                                                                                                                      0   `               P          @  p         0  `           P          @  p         0  `           P          @  p       	  0	  `	  	  	  	   
  P
  
  
  
    @  p         0  `         
  P
  
  
  
    @  p         0  `           P          @  p         0  `           P          @  p         0  `           P          @  p         0  `           P          @  p         0  `           P          @  p         0  `           P           @   p          !  0!  `!  !  !  !   "  P"  "  "  "  #  @#  p#  #  #   $  0$  `$  $  $  $   %  P%  %  %  %  &  @&  p&  &  &   '  0'  `'  '  '  '   (  P(  (  (  (  )  @)  p)  )  )   *  0*  `*  *  *  *   +  P+  +  +  +  ,  @,  p,  ,  ,   -  0-  `-  -  -  -   .  P.  .  .  .  /  @/  p/  /  /  /   0  @  Q  pb  @s          P         
 ` 0,  = M ^ po @     P      `( 09  J Z k p| @     P     $ `5 0F  W g x p @     P      1 `B 0S  d t  p @     P    - > `O 0`  q Ё  p @     P   ) : K `\ 0m  ~ Ў  p @     P  & 6 G X `i 0z   Л  p @      P"  3 C T e `v 0   Ш  p @   
	 	 P/	  @	 P	 a	 r	 `	 0	  	 е	 	 p	 @	 	 	
 
 +
 P<
  M
 ]
 n
 
 `
 0
  
 
 
 p
 @
   ' 8 PI  Z j {  ` 0     p @  # 4 E PV  g w   ` 0     p @
  
 0
 A
 R
 Pc
  t
 
 
 
 `
 0
  
 
 
 p @ - = N _ Pp      ` 0     p @) : J [ l P}      ` 0     p% @6 G W h y P      ` 0  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /                      0   `               P          @  p         0  `           P          @  p         0  `           P          @  p       	  0	  `	  	  	  	   
  P
  
  
  
    @  p         0  `         
  P
  
  
  
    @  p         0  `           P          @  p         0  `           P          @  p         0  `           P          @  p         0  `           P          @  p         0  `           P          @  p         0  `           P           @   p          !  0!  `!  !  !  !   "  P"  "  "  "  #  @#  p#  #  #   $  0$  `$  $  $  $   %  P%  %  %  %  &  @&  p&  &  &   '  0'  `'  '  '  '   (  P(  (  (  (  )  @)  p)  )  )   *  0*  `*  *  *  *   +  P+  +  +  +  ,  @,  p,  ,  ,   -  0-  `-  -  -  -   .  P.  .  .  .  /  @/  p/  /  /  /  @0  A  Q  b  s  P           `  0     
  p, @= N ^ o  P      ` 0    ( p9 @J [ k |  P      ` 0   $ 5 pF @W h x   P      ` 0  ! 1 B pS @d u    P      ` 0  . > O p` @q     P      ` 0*  ; K \ pm @~     P      `& 07  H X i pz @     P      " `3 0D  U e v p @     P   
	 	 /	 `@	 0Q	  b	 r	 	 p	 @	 	 	 	 	 P	  

 
 +
 <
 `M
 0^
  o
 
 
 p
 @
 
 
 
 
 P   ' 8 I `Z 0k  | Ќ  p @     P  $ 4 E V `g 0x   Й  p @    
 P 
  1
 A
 R
 c
 `t
 0
  
 Ц
 
 p
 @
 
 
   P-  > N _ p ` 0   г  p @    ) P:  K [ l } ` 0     p @   % 6 PG  X h y  ` 0     p   0  0  0  0  0  0  0  0  0  	0  
0  0  0  
0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0   0  !0  "0  #0  $0  %0  &0  '0  (0  )0  *0  +0  ,0  -0  .0  /0  00  10  20  30  40  50  60  70  80  90  :0  ;0  <0  =0  >0  ?0                                                                      1   b            &  W          L  }        A  r        6  g        +  \           Q          F  w      
  ;  l        0	  a	  	  	  	  %
  V
  
  
  
    K  |        @  q      
  5
  f
  
  
  
  *  [          P          E  v      	  :  k        /  `        $  U          J  {        ?  p        4  e        )  Z          O          D  u        9  j        .  _        #  T          I  z      
  >  o        3  d        (   Y            !  N!  !  !  !  "  C"  t"  "  "  #  8#  i#  #  #  #  -$  ^$  $  $  $  "%  S%  %  %  %  &  H&  y&  &  &  '  ='  n'  '  '  (  2(  c(  (  (  (  ')  X)  )  )  )  *  M*  ~*  *  *  +  B+  s+  +  +  ,  7,  h,  ,  ,  ,  ,-  ]-  -  -  -  !.  R.  .  .  .  /  G/  x/  /  /  0  <0  ?0  0  pA  @R  c  s      P           `  0   , = pN @_ p    P      ` 0  ) 9 J p[ @l }    P      ` 0%  6 F W ph @y     P      `! 02  C S d pu @     P      `. 0?  P ` q p @     P     * `; 0L  ] m ~ p @     P    & 7 `H 0Y  j z  p @     P   " 3 D `U 0f  w Ї  p @     P	  	 /	 @	 Q	 `b	 0s	  	 Д	 	 p	 @	 	 	 	 

 P
  ,
 <
 M
 ^
 `o
 0
  
 С
 
 p
 @
 
 
   P(  9 I Z k `| 0   Ю  p @    $ P5  F V g x ` 0   л  p @  
  
 1
 PB
  S
 c
 t
 
 `
 0
  
 
 
 p
 @
   - > PO  ` p   ` 0     p @  ) : K P\  m }   ` 0     p @ & 6 G X Pi  z    ` 0     @0  A0  B0  C0  D0  E0  F0  G0  H0  I0  J0  K0  L0  M0  N0  O0  P0  Q0  R0  S0  T0  U0  V0  W0  X0  Y0  Z0  [0  \0  ]0  ^0  _0  `0  a0  b0  c0  d0  e0  f0  g0  h0  i0  j0  k0  l0  m0  n0  o0  p0  q0  r0  s0  t0  u0  v0  w0  x0  y0  z0  {0  |0  }0  ~0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0                                                                                                      1   b            &  W          L  }        A  r        6  g        +  \           Q          F  w      
  ;  l        0	  a	  	  	  	  %
  V
  
  
  
    K  |        @  q      
  5
  f
  
  
  
  *  [          P          E  v      	  :  k        /  `        $  U          J  {        ?  p        4  e        )  Z          O          D  u        9  j        .  _        #  T          I  z      
  >  o        3  d        (   Y            !  N!  !  !  !  "  C"  t"  "  "  #  8#  i#  #  #  #  -$  ^$  $  $  $  "%  S%  %  %  %  &  H&  y&  &  &  '  ='  n'  '  '  (  2(  c(  (  (  (  ')  X)  )  )  )  *  M*  ~*  *  *  +  B+  s+  +  +  ,  7,  h,  ,  ,  ,  ,-  ]-  -  -  -  !.  R.  .  .  .  /  G/  x/  /  /  0  <0  m0  0  0   1  A  R  mc  <t    ڕ    x  G         R !- = N _ ]p ,  ʢ  h 7    s B) : J [ ~l M}     X '    c% 26 G W h ny =  ۫  y H    ! S2 "C S d u ^ -  ˸  i 8    t. C? P ` q  N     Y (   * d; 3L ] m ~ o > 
   z I   & 7 TH #Y i z  _ .    j 9  " 3 uD DU f v   O     Z )	 	 /	 @	 eQ	 4b	 s	 ҃	 	 p	 ?	 	 	 	 {	 J

 
 +
 <
 M
 U^
 $o
 
 
 
 `
 /
 
 
 
 k : 	( 8 I vZ Ek |    P     [ *$ 4 E V fg 5x  ә  q @    |
 K 
 1
 A
 R
 c
 Vt
 %
 
 æ
 
 a
 0
 
 
  l ;- 
> N _ wp F     Q      \) +: J [ l g} 6  ԯ  r A    }% L6 G W h y W &  ļ  b 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0                                                                                                      1   b            &  W          L  }        A  r        6  g        +  \           Q          F  w      
  ;  l        0	  a	  	  	  	  %
  V
  
  
  
    K  |        @  q      
  5
  f
  
  
  
  *  [          P          E  v      	  :  k        /  `        $  U          J  {        ?  p        4  e        )  Z          O          D  u        9  j        .  _        #  T          I  z      
  >  o        3  d        (   Y            !  N!  !  !  !  "  C"  t"  "  "  #  8#  i#  #  #  #  -$  ^$  $  $  $  "%  S%  %  %  %  &  H&  y&  &  &  '  ='  n'  '  '  (  2(  c(  (  (  (  ')  X)  )  )  )  *  M*  ~*  *  *  +  B+  s+  +  +  ,  7,  h,  ,  ,  ,  ,-  ]-  -  -  -  !.  R.  .  .  .  /  G/  x/  /  /  0  <0  m0  0  0  0  01  A  R  c  lt  ;  
  ٦    w  F        Q-  > N _ p \ +  ɳ  g 6    r) A: K [ l }} L     W &   % b6 1G  X h y m <  ڼ  x G    ! 2 RC !T d u  ] ,    h 7 
  . s? BP a q  ~ M     X '	  * ; cL 2] n ~  n =    y H  & 7 H SY "j z   ^ -    i 8 # 3 D tU Cf w    N     Y	 (	 /	 @	 Q	 db	 3s	 	 є	 	 o	 >	 
	 	 	 z

 I
 ,
 <
 M
 ^
 To
 #
 
 
 
 _
 .
 
 
  j 9( 9 I Z uk D|     O     Z$ )5 E V g ex 4  Ҫ  p ?   
 { 
 J1
 B
 R
 c
 t
 U
 $
 
 ·
 
 `
 /
 
   k- :> 	O _ p v E     P    ) [: *K [ l } f 5    q @   % |6 KG X h y  V %    a   1  1  1  1  1  1  1  1  1  	1  
1  1  1  
1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1   1  !1  "1  #1  $1  %1  &1  '1  (1  )1  *1  +1  ,1  -1  .1  /1                                                      2   d            ,  ^        &  X           R          L  ~        F  x        @  r        :  l        4  f        .	  `	  	  	  	  (
  Z
  
  
  
  "  T          N        
  H
  z
  
  
    B  t      
  <  n        6  h        0  b        *  \        $  V          P          J  |        D  v        >  p        8  j         2  d        ,  ^        &  X           R          L  ~        F  x        @  r         :   l         !  4!  f!  !  !  !  ."  `"  "  "  "  (#  Z#  #  #  #  "$  T$  $  $  $  %  N%  %  %  %  &  H&  z&  &  &  '  B'  t'  '  '  
(  <(  n(  (  (  )  6)  h)  )  )  )  0*  b*  *  *  *  *+  \+  +  +  +  $,  V,  ,  ,  ,  -  P-  -  -  -  .  J.  |.  .  .  /  D/  v/  /  /  0  >0  p0  0  0  1  /1  1  _B  .S  c  t    j  9        u  D    - > OO ` p   Z )    e 4  ) : pK ?\ m }  { J     U $ % 6 G `X /i y ͊  k : 	   v  E " 2 C T Pe v    [ *    f
 5 / ? P qa @r  ޓ  | K    	 V %+ ; L ] an 0  Π  l ; 
   w F' 8 H Y j Q{      \ +    g# 64 E U f rw A  ߩ  } L   	 	 W0	 &A	 Q	 b	 s	 b	 1	  	 ϶	 	 m	 <	 	 

 
 x,
 G=
 N
 ^
 o
 
 R
 !
 
 
 
 ]
 ,
   ( h9 7J [ k | s B    ~ M   $ 5 XF 'W g x  c 2    n = 
  
 1
 yB
 HS
 d
 t
 
 
 S
 "
 
 
 
 ^
 -  - > iO 8` q ց  t C     N  ) : K Y\ (m } Ǝ  d 3    o > 
& 6 G zX Ii z    T #    01  11  21  31  41  51  61  71  81  91  :1  ;1  <1  =1  >1  ?1  @1  A1  B1  C1  D1  E1  F1  G1  H1  I1  J1  K1  L1  M1  N1  O1  P1  Q1  R1  S1  T1  U1  V1  W1  X1  Y1  Z1  [1  \1  ]1  ^1  _1  `1  a1  b1  c1  d1  e1  f1  g1  h1  i1  j1  k1  l1  m1  n1  o1  p1  q1  r1  s1  t1  u1  v1  w1  x1  y1  z1  {1  |1  }1  ~1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1                                                                                                      2   d            ,  ^        &  X           R          L  ~        F  x        @  r        :  l        4  f        .	  `	  	  	  	  (
  Z
  
  
  
  "  T          N        
  H
  z
  
  
    B  t      
  <  n        6  h        0  b        *  \        $  V          P          J  |        D  v        >  p        8  j         2  d        ,  ^        &  X           R          L  ~        F  x        @  r         :   l         !  4!  f!  !  !  !  ."  `"  "  "  "  (#  Z#  #  #  #  "$  T$  $  $  $  %  N%  %  %  %  &  H&  z&  &  &  '  B'  t'  '  '  
(  <(  n(  (  (  )  6)  h)  )  )  )  0*  b*  *  *  *  *+  \+  +  +  +  $,  V,  ,  ,  ,  -  P-  -  -  -  .  J.  |.  .  .  /  D/  v/  /  /  0  >0  p0  0  0  1  81  j1  1  1  oB  >S  
d  t    z  I          T  #  - > _O .` p ́  j 9    u D  ) : K O\ m }   Z )    e 4 & 6 G pX ?i z ݊  { J      U $" 2 C T `e /v  ͗  k : 	   v
 E / ? P a Pr     [ *   	 f 5+ < L ] qn @  ޠ  | K     V' %8 H Y j a{ 0  έ  l ; 
   w# F4 E U f w Q      \ +  	 	 g0	 6A	 R	 b	 s	 r	 A	 	 ߶	 	 }	 L	 	 

 
 ,
 W=
 &N
 ^
 o
 
 b
 1
  
 
 
 m
 <
   ( x9 GJ [ k |  R !    ] ,  $ 5 hF 7W h x  s B    ~ M 
  
 1
 B
 XS
 'd
 t
 Ņ
 
 c
 2
 
 
 
 n
 =  - > yO H` q    S "    ^ - ) : K i\ 8m ~ ֎  t C     N & 6 G X Yi (z  ƛ  d 3    1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1                      2   d            ,  ^        &  X           R          L  ~        F  x        @  r        :  l        4  f        .	  `	  	  	  	  (
  Z
  
  
  
  "  T          N        
  H
  z
  
  
    B  t      
  <  n        6  h        0  b        *  \        $  V          P          J  |        D  v        >  p        8  j         2  d        ,  ^        &  X           R          L  ~        F  x        @  r         :   l         !  4!  f!  !  !  !  ."  `"  "  "  "  (#  Z#  #  #  #  "$  T$  $  $  $  %  N%  %  %  %  &  H&  z&  &  &  '  B'  t'  '  '  
(  <(  n(  (  (  )  6)  h)  )  )  )  0*  b*  *  *  *  *+  \+  +  +  +  $,  V,  ,  ,  ,  -  P-  -  -  -  .  J.  |.  .  .  /  D/  v/  /  /  0  >0  p0  0  0  1  81  j1  1  1  1  B  ^S  -d  t  ˅    i  8        t  C  - > O N` q    Y (    d 3 * : K o\ >m 
~ ܎  z I     T #& 6 G X _i .z  ̛  j 9     u D" 3 C T e Ov     Z )   
 e 4/ @ P a pr ?  ݤ  { J   	  U+ $< L ] n ` /  ͱ  k : 	   v' E8 I Y j { P     [ *   # f4 5E V f w q @  ޺  | K  	 	 0	 VA	 %R	 b	 s	 	 a	 0	 	 	 	 l	 ;	 

 
 ,
 w=
 FN
 _
 o
 
 
 Q
  
 
 
 
 \
 +  ( 9 gJ 6[ l |  r A    } L  $ 5 F WW &h x ĉ  b 1     m <
 !
 1
 B
 xS
 Gd
 u
 
 
 
 R
 !
 
 
 
 ] , - > O h` 7q  Ւ  s B    ~ M * : K \ Xm '~  ş  c 2    n =& 7 G X yi Hz     S "   1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1                                      2   d            ,  ^        &  X           R          L  ~        F  x        @  r        :  l        4  f        .	  `	  	  	  	  (
  Z
  
  
  
  "  T          N        
  H
  z
  
  
    B  t      
  <  n        6  h        0  b        *  \        $  V          P          J  |        D  v        >  p        8  j         2  d        ,  ^        &  X           R          L  ~        F  x        @  r         :   l         !  4!  f!  !  !  !  ."  `"  "  "  "  (#  Z#  #  #  #  "$  T$  $  $  $  %  N%  %  %  %  &  H&  z&  &  &  '  B'  t'  '  '  
(  <(  n(  (  (  )  6)  h)  )  )  )  0*  b*  *  *  *  *+  \+  +  +  +  $,  V,  ,  ,  ,  -  P-  -  -  -  .  J.  |.  .  .  /  D/  v/  /  /  0  >0  p0  0  0  1  81  j1  1  1  1   2  B  S  jd  8u    Ԗ    p  >        v D . > O |` Jq     P     V $* : K \ \m *~  Ɵ  b 0    h 6& 7 G X ni <z 
 ؛  t B     z H" 3 C T e Nv     T "   
 Z (/ ? P a `r .  ʤ  f 4   	 l :+ < L ] rn @  ܠ  x F    ~ L' 8 H Y j R{      X &    ^# ,4 D U f dw 2   Ω  j 8   	 p	 >0	 A	 Q	 b	 vs	 D	 	 	 	 |	 J	 	 	 

 
 P,
 =
 M
 ^
 o
 V
 $
 
 
 
 \
 *
 
   b( 09 I Z k h| 6  Ү  n < 
   t$ B5 F V g zx H     N   
  
 T1
 "B
 R
 c
 t
 Z
 (
 
 ķ
 
 `
 .
 
   f- 4> O _ p l :  ֳ  r @    x) F: K [ l ~} L     R     % X6 &G W h y ^ ,  ȼ  d 2  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1                      2   d            ,  ^        &  X           R          L  ~        F  x        @  r        :  l        4  f        .	  `	  	  	  	  (
  Z
  
  
  
  "  T          N        
  H
  z
  
  
    B  t      
  <  n        6  h        0  b        *  \        $  V          P          J  |        D  v        >  p        8  j         2  d        ,  ^        &  X           R          L  ~        F  x        @  r         :   l         !  4!  f!  !  !  !  ."  `"  "  "  "  (#  Z#  #  #  #  "$  T$  $  $  $  %  N%  %  %  %  &  H&  z&  &  &  '  B'  t'  '  '  
(  <(  n(  (  (  )  6)  h)  )  )  )  0*  b*  *  *  *  *+  \+  +  +  +  $,  V,  ,  ,  ,  -  P-  -  -  -  .  J.  |.  .  .  /  D/  v/  /  /  0  >0  p0  0  0  1  81  j1  1  1  1   3  C  T  ge  4v    Η    h  5        i
 6 / ? P ja 7r  ѓ  k 8    l	 9 + ; L m] :n  ԏ  n ;    o < 	' 7 H pY =j 
{ ׋  q >    r ? # 3 D sU @f 
w ڇ  t A    u B  / @ vQ Cb s ݃  w D    x E
  + < yM F^ o   z G    { H  ' 8 |I IZ k {  } J    ~ K  # 4 E LV g w   M     N 	 	 0	 A	 OR	 c	 s	 	 	 P	 	 	 	 	 Q	 
 
 ,
 =
 RN
 _
 o
 
 
 S
  
 
 
 
 T
 !  ( 9 UJ "[ k |  V #    W $  $ 5 XF %W g x  Y &    Z ' 
  
 1
 [B
 (S
 c
 t
 
 \
 )
 
 
 
 ]
 *
   - ^> +O _ p  _ ,    ` -   ) a: .K [ l } b /    c 0   % d6 1G W h y e 2  ̼  f 3   2  2  2  2  2  2  2  2  2  	2  
2  2  2  
2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2   2  !2  "2  #2  $2  %2  &2  '2  (2  )2  *2  +2  ,2  -2  .2  /2  02  12  22  32  42  52  62  72  82  92  :2  ;2  <2  =2  >2  ?2  @2  A2  B2  C2  D2  E2  F2  G2  H2  I2  J2  K2  L2  M2  N2  O2  P2  Q2  R2  S2  T2  U2  V2  W2  X2  Y2  Z2  [2  \2  ]2  ^2  _2  `2  a2  b2  c2  d2  e2  f2  g2  h2  i2  j2  k2  l2  m2  n2  o2  p2  q2  r2  s2  t2  u2  v2  w2  x2  y2  z2  {2  |2  }2  ~2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2                                                                                                                                                                                                                                                                      3   f            2  e        1  d        0  c        /  b        .  a        -  `        ,  _        +  ^        *	  ]	  	  	  	  )
  \
  
  
  
  (  [        '  Z        &
  Y
  
  
  
  %  X        $  W        #  V        "  U        !  T           S          R          Q          P          O          N          M          L          K  ~        J  }        I  |        H  {        G  z         F   y         !  E!  x!  !  !  "  D"  w"  "  "  #  C#  v#  #  #  $  B$  u$  $  $  %  A%  t%  %  %  
&  @&  s&  &  &  '  ?'  r'  '  '  (  >(  q(  (  (  
)  =)  p)  )  )  	*  <*  o*  *  *  +  ;+  n+  +  +  ,  :,  m,  ,  ,  -  9-  l-  -  -  .  8.  k.  .  .  /  7/  j/  /  /  0  60  i0  0  0  1  51  h1  1  1  2  42  g2  2  2  2   4  D  U  df  0w    Ș    `  ,        \ ( / @ Q Xb $s    T      P
  + < M L^ o   | H    x D  ' 8 tI @Z k {  p <    l 8  # 4 hE 4V  g w  d 0    ` ,   0 \A (R b s  X $    T   
  , P= N ^ o  L    | H    x( D9 J Z k t| @  خ  p <    l$ 85 F V g hx 4   ̪  d 0   	 ` 	 ,1	 A	 R	 c	 \t	 (	 	 	 	 X	 $	 	 	 
 T
  -
 =
 N
 _
 Pp
 
 
 
 
 L
 
 
 
 | H ) 9 J x[ Dl } ܍  t @    p < % 5 F lW 8h y Љ  h 4     d 0
  
 1
 B
 `S
 ,d
 t
 ą
 
 \
 (
 
 
 
 X
 $  - > TO  ` p   P     L   ) |: HK \ l } x D    t @   % p6 <G X h y l 8  м  h 4   3  3  3  3  3  3  3  3  3  	3  
3  3  3  
3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3   3  !3  "3  #3  $3  %3  &3  '3  (3  )3  *3  +3  ,3  -3  .3  /3  03  13  23  33  43  53  63  73  83  93  :3  ;3  <3  =3  >3  ?3  @3  A3  B3  C3  D3  E3  F3  G3  H3  I3  J3  K3  L3  M3  N3  O3  P3  Q3  R3  S3  T3  U3  V3  W3  X3  Y3  Z3  [3  \3  ]3  ^3  _3  `3  a3  b3  c3  d3  e3  f3  g3  h3  i3  j3  k3  l3  m3  n3  o3  p3  q3  r3  s3  t3  u3  v3  w3  x3  y3  z3  {3  |3  }3  ~3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3                                                                                                                                                                                                                                                                      4   h           8  l        <  p        @  t        D  x        H  |        L          P           T        $	  X	  	  	  	  (
  \
  
  
  
  ,  `        0  d       
  4
  h
  
  
    8  l        <  p        @  t        D  x        H  |        L          P           T        $  X        (  \        ,  `        0  d         4  h        8  l        <  p        @  t        D  x        H  |         L            !  P!  !  !  !   "  T"  "  "  "  $#  X#  #  #  #  ($  \$  $  $  $  ,%  `%  %  %  %  0&  d&  &  &   '  4'  h'  '  '  (  8(  l(  (  (  )  <)  p)  )  )  *  @*  t*  *  *  +  D+  x+  +  +  ,  H,  |,  ,  ,  -  L-  -  -  -  .  P.  .  .  .   /  T/  /  /  /  $0  X0  0  0  0  (1  \1  1  1  1  ,2  `2  2  2  2  03  d3  3  3  3  M  s^  &o      ?      X      q $ & 7 =H X i Vz 	  o "   ;   T! 2 B mS  d t  9   R   k   , 7= M ^ Po   i    5   N ' 7 gH Y i z 3   L   e    ~! 12 B S Jd t  c  ɷ | /   H  , a= N ^ zo -   F   _   x +' 7 H DY i z ]  ì v )   B   ! [2 C S td 'u څ  @   Y   r	 %	 ,	 =	 >N	 ^	 o	 W	 
	 	 p	 #	 	 	 <	 
 
 U'
 8
 H
 nY
 !j
 z
 
 :
 
 
 S
 
 
 l   ! 2 8C S d Qu   j    6   O - = hN _ o  4   M    f 
 
 '
 28
 H
 Y
 Kj
 z
 
 d
 
 ʽ
 }
 0
 
   I ! 2 bC T d {u .   G   `   y ,- = N E_ o  ^  Ĳ w *   C  ' \8 I Y uj ({ ۋ  A   Z 
   4  4  44  N4  h4  4  4  4  4  4  5  5  85  R5  l5  5  5  5  5  5  6  "6  <6  V6  p6  6  6  6  6  6  7  &7  @7  Z7  t7  7  7  7  7  7  8  *8  D8  ^8  x8  8  8  8  8  8  9  .9  H9  b9  |9  9  9  9  9  9  :  2:  L:  f:  :  :  :  :  :  ;  ;  6;  P;  j;  ;  ;  ;  ;  ;  <   <  :<  T<  n<  <  <  <  <  <  
=  $=  >=  X=  r=  =  =  =  =  =  >  (>  B>  \>  v>  >  >  >  >  >  ?  ,?  F?  `?  z?  ?  ?  ?  ?  ?  @  0@  J@  d@  ~@  @  @  @  @   A  A  4A  NA  hA  A  A  A  A  A  B  B  8B  RB  lB  B  B  B  B  B  C  "C  <C  VC  pC  C  C  C  C  C  D  &D  @D  ZD  tD  D  D  D  D  D  E  *E  DE  ^E  xE  E  E  E  E  E  F  .F  HF  bF  |F  F  F  F  F  F  G  2G  LG  fG  G  G  G  G  G  H  H  6H  PH  jH  H  H  H  H  H  I   I  :I  TI  nI  I  I  I  I  I  
J  $J  >J  XJ  rJ  J  J  J  J  J  K  (K  BK  \K  vK  K  K  K  K  K  L  ,L  FL  `L  zL  L  L  L  L  L  M  0M  JM  dM  ~M  M  M  M                                                                                                                                                                                                                                                                     N         8      "  p      Z      D      .  |      f      P      :      $	  r	  	  
  \
  
  
  F      0  ~    
  h
  
    R      <      &  t      ^      H      2        j      T      >      (  v      `      J      4        l      V      @      *  x      b      L         6!  !  !   "  n"  "  
#  X#  #  #  B$  $  $  ,%  z%  %  &  d&  &   '  N'  '  '  8(  (  (  ")  p)  )  *  Z*  *  *  D+  +  +  .,  |,  ,  -  f-  -  .  P.  .  .  :/  /  /  $0  r0  0  1  \1  1  1  F2  2  2  03  ~3  3  4  h4  4  5  R5  5  5  <6  6  6  &7  t7  7  8  ^8  8  8  H9  9  9  2:  :  :  ;  j;  ;  <  T<  <  <  >=  =  =  (>  v>  >  ?  `?  ?  ?  J@  @  @  4A  A  A  B  lB  B  C  VC  C  C  @D  D  D  *E  xE  E  F  bF  F  F  LG  G  G  6H  H  H   I  nI  I  
J  XJ  J  J  BK  K  K  ,L  zL  L  M  dM  M  M   N  ^  do    Ȑ  z  ,      B     X 
' 7 nH  Y i z 6   L   b    x! *2 B S @d t  V   l    4  , J= M ^ `o  Đ v (   >   T ' 7 jH Y i z 2   H   ^    t! &2 B S <d t  R   h   ~ 0  , F= M ^ \o   r $   :   P ' 7 fH Y i |z .   D   Z    p! "2 B S 8d t  N    d   z ,	 	 ,	 B=	 M	 ^	 Xo	 
	 	 n	  	 	 	 6	 	 
 L
 &
 7
 bH
 Y
 i
 xz
 *
 ܛ
 
 @
 
 
 V
    l! 2 B S 4d t  J   `   v (  , >= M ^ To   j    2  
 H
 &
 7
 ^H
 Y
 i
 tz
 &
 ؛
 
 <
 
 
 R
    h! 2 B ~S 0d t  F   \   r $  , := M ^ Po   f   | .   D & 7 ZH Y i pz " ԛ  8   N  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M  M                                                                      N         8      "  p      Z      D      .  |      f      P      :      $	  r	  	  
  \
  
  
  F      0  ~    
  h
  
    R      <      &  t      ^      H      2        j      T      >      (  v      `      J      4        l      V      @      *  x      b      L         6!  !  !   "  n"  "  
#  X#  #  #  B$  $  $  ,%  z%  %  &  d&  &   '  N'  '  '  8(  (  (  ")  p)  )  *  Z*  *  *  D+  +  +  .,  |,  ,  -  f-  -  .  P.  .  .  :/  /  /  $0  r0  0  1  \1  1  1  F2  2  2  03  ~3  3  4  h4  4  5  R5  5  5  <6  6  6  &7  t7  7  8  ^8  8  8  H9  9  9  2:  :  :  ;  j;  ;  <  T<  <  <  >=  =  =  (>  v>  >  ?  `?  ?  ?  J@  @  @  4A  A  A  B  lB  B  C  VC  C  C  @D  D  D  *E  xE  E  F  bF  F  F  LG  G  G  6H  H  H   I  nI  I  
J  XJ  J  J  BK  K  K  ,L  zL  L  M  dM  M  M     `           @   # `3 C  T d t @    `      @   ) `9 I  Z j z @    `      @   / `? O  ` p  @    `      @ $  5 `E U  f v  @    `     	 @ *  ; `K [  l |  @    `      @  0  A `Q a  r   @    `      @& 6  G `W g  x   @    `      @, <  M `] m  ~   @    `   	 	 !	 @2	 B	  S	 `c	 s	  	 	 	 @	 	  	 `	 	  
 
 '
 @8
 H
  Y
 `i
 y
  
 
 
 @
 
  
 `
 
  
  - @> N  _ `o      @    `    # 3 @D T  e `u      @    ` 
  
 )
 9
 @J
 Z
  k
 `{
 
  
 
 
 @
 
  
 `
    / ? @P `  q `      @    `   % 5 E @V f  w `      @    `
   + ; K @\ l  } `      @    N  RN  N  N  HO  O  O  >P  P  P  4Q  Q  Q  *R  |R  R   S  rS  S  T  hT  T  U  ^U  U  V  TV  V  V  JW  W  W  @X  X  X  6Y  Y  Y  ,Z  ~Z  Z  "[  t[  [  \  j\  \  ]  `]  ]  ^  V^  ^  ^  L_  _  _  B`  `  `  8a  a  a  .b  b  b  $c  vc  c  d  ld  d  e  be  e  f  Xf  f  f  Ng  g  g  Dh  h  h  :i  i  i  0j  j  j  &k  xk  k  l  nl  l  m  dm  m  n  Zn  n  n  Po  o  o  Fp  p  p  <q  q  q  2r  r  r  (s  zs  s  t  pt  t  u  fu  u  
v  \v  v   w  Rw  w  w  Hx  x  x  >y  y  y  4z  z  z  *{  |{  {   |  r|  |  }  h}  }  ~  ^~  ~    T      J      @      6    ڂ  ,  ~  Ѓ  "  t  Ƅ    j      `      V      L      B      8    ܊  .    ҋ  $  v  Ȍ    l      b      X      N      D      :    ޒ  0    ԓ  &  x  ʔ    n      d      Z      P      F      <      2    ֛  (  z  ̜    p      f    
  \                                                                                                                                                                                                                                                                              @           `       @           `	   
  
  @       
  
  `       @           `       @           `       @           `       @        !  !  `"   #  #  @$  $  %   &  &  `'   (  (  @)  )  *   +  +  `,   -  -  @.  .  /   0  0  `1   2  2  @3  3  4   5  5  `6   7  7  @8  8  9   :  :  `;   <  <  @=  =  >   ?  ?  `@   A  A  @B  B  C   D  D  `E   F  F  @G  G  H   I  I  `J   K  K  @L  L  M   N  N  `O   P  P  @Q  Q  R   S  S  `T   U  U  @V  V  W   X  X  `Y   Z  Z  @[  [  \   ]  ]  `^   _  _  @`  `  a   b  b  `c   d  d  @e  e  f   g  g  `h   i  i  @j  j  k   l  l  `m   n  n  @o  o  p   q  q  `r   s  s  @t  t  u   v  v  `w   x  x  @y  y  z   {  {  `|   }  }  @~  ~         `       @           `       @           `       @           `       @           `       @           `       @           `        H       \    p' 7 (H X h <y   P   d   x  0- = M D^ n ~ X   l  $   8 " 2 LC S d `t   t е ,   @   T( 8 I hY i  z | ؚ 4   H    \
  . p> N (_ o  <   P   d   x# 3 0D T d Du   X   l  $   8) 9 I LZ j { `   t  ,   @  . T? O ` hp Ā   | ر 4   H 	  	 \$	 4	 E	 pU	 e	 (v	 	 	 <	 	 	 P	 	 	 d	
 
 *
 x:
 J
 0[
 k
 {
 D
 
 
 X
 
 
 l
 
 $  / 8@ P ` Lq   `   t  ,   @% 5 E TV f w h ė   |  4   H

 
  +
 \;
 K
 \
 pl
 |
 (
 
 
 <
 
 
 P
 
  d  0 A xQ a 0r   D   X   l  $& 6 F 8W g w L   `   t  ,  + @< L \ Tm }  h Į   |  4       
          #  (  -  2  7  <  A  F  K  P  U  Z  _  d  i  n  s  x  }                            à  Ƞ  ͠  Ҡ  נ  ܠ                  	          "  '  ,  1  6  ;  @  E  J  O  T  Y  ^  c  h  m  r  w  |                            ¡  ǡ  ̡  ѡ  ֡  ۡ                    
        !  &  +  0  5  :  ?  D  I  N  S  X  ]  b  g  l  q  v  {                              Ƣ  ˢ  Т  բ  ڢ  ߢ                             %  *  /  4  9  >  C  H  M  R  W  \  a  f  k  p  u  z                              ţ  ʣ  ϣ  ԣ  ٣  ޣ                            $  )  .  3  8  =  B  G  L  Q  V  [  `  e  j  o  t  y  ~                                                                                                                                                                                                                                                            J      9      (    r      a  	  	  P
  
    ?    
  .    x      g      V      E      4    ~  #    m      \      K      :      !  )"  "  s#  $  $  b%  &  &  Q'  '  (  @)  )  *  /+  +  y,  -  -  h.  
/  /  W0  0  1  F2  2  3  54  4  5  $6  6  n7  8  8  ]9  :  :  L;  ;  <  ;=  =  >  *?  ?  t@  A  A  cB  C  C  RD  D  E  AF  F  G  0H  H  zI  J  J  iK  L  L  XM  M  N  GO  O  P  6Q  Q  R  %S  S  oT  U  U  ^V  W  W  MX  X  Y  <Z  Z  [  +\  \  u]  ^  ^  d_  	`  `  Sa  a  b  Bc  c  d  1e  e  {f   g  g  jh  i  i  Yj  j  k  Hl  l  m  7n  n  o  &p  p  pq  r  r  _s  t  t  Nu  u  v  =w  w  x  ,y  y  vz  {  {  e|  
}  }  T~  ~    C      2  ׂ  |  !  Ƅ  k      Z      I      8  ݋    '  ̍  q      `      O      >      -  Җ  w      f      U      D      3  ؟  }  "  ǡ  l      [    Ф  ,      @     T ' 8 hH X  i |y ؉ 4   H    \   p- = (N ^ n <   P   d   x " 03 C S Dd t  X   l  $   8 ( 8 LI Y j `z   t л ,   @ 
  T. > O h_ o   | ؠ 4   H    \ # 4 pD T (e u  <   P   d   x) 9 0J Z j D{   X   l  $   8/ ? O L` p  `   t  ,  	 @	 $	 4	 TE	 U	 f	 hv	 Ć	  	 |	 ط	 4	 	 	 H	 	
  
 \*
 :
 K
 p[
 k
 (|
 
 
 <
 
 
 P
 
 
 d  0 x@ P 0a q  D   X   l  $ % 5 8F V f Lw   `   t  , 

 
 @+
 ;
 K
 T\
 l
 }
 h
 ĝ
  
 |
 
 4
 
 
 H    1 \A Q b pr ̂ (   <   P   d& 6 G xW g 0x   D   X   l  $, < L 8] m } L   `   t                                                                                                      ¤  ä  Ĥ  Ť  Ƥ  Ǥ  Ȥ  ɤ  ʤ  ˤ  ̤  ͤ  Τ  Ϥ                                                                         X      \      `      d      h	  
  
  l      p
      t       x  $    |  (      ,      0      4      8      <      @      !  D"  "  #  H$  $  %  L&  &  '  P(  (  )  T*   +  +  X,  -  -  \.  /  /  `0  1  1  d2  3  3  h4  5  5  l6  7  7  p8  9  9  t:   ;  ;  x<  $=  =  |>  (?  ?  @  ,A  A  B  0C  C  D  4E  E  F  8G  G  H  <I  I  J  @K  K  L  DM  M  N  HO  O  P  LQ  Q  R  PS  S  T  TU   V  V  XW  X  X  \Y  Z  Z  `[  \  \  d]  ^  ^  h_  `  `  la  b  b  pc  d  d  te   f  f  xg  $h  h  |i  (j  j  k  ,l  l  m  0n  n  o  4p  p  q  8r  r  s  <t  t  u  @v  v  w  Dx  x  y  Hz  z  {  L|  |  }  P~  ~    T       X      \      `      d      h      l    č  p    ȏ  t     ̑  x  $  Г  |  (  ԕ    ,  ؗ    0  ܙ    4      8      <      @      D      H      L      P      T          + T }( 8 H X !i Jy s  ũ   @ i  
  
+ 6; _K [ k {  , U ~    " K
 t - = M ^ An j~     7 `      -0 V@ P ` p  # L u     B k " 2 B S 8c as   ܣ  . W     $% M5 vE U e u  C l     9 b  ' 7 H /X Xh x  Ә  % N w   	  D* m: J Z j { : c     0 Y 	 	 ,	 <	 &M	 O]	 xm	 }	 ʍ	 	 	 E	 n	 	 	 	 
 ;
 d/
 ?
 O
 _
 p
 1
 Z
 
 
 
 
 '
 P
 y  ! 1 B FR ob r    < e    	 2 [$ 4 D T d (u Q z  ̵   G p 
 
 &
 7
 =G
 fW
 g
 w
 
 

 3
 \
 
 
 
  
 )	 R {) 9 I Y j Hz q  ê   > g    , 4< ]L \ l |  * S |      I r . > N _ ?o h     5 ^      ,  X      ܬ    4  `          <  h          D  p    ȯ       L  x    а    (  T      ر    0  \          8  d          @  l    Ĵ      H  t    ̵    $  P  |    Զ     ,  X      ܷ    4  `          <  h          D  p    Ⱥ       L  x    л    (  T      ؼ    0  \          8  d          @  l    Ŀ      H  t        $  P  |         ,  X          4  `          <  h          D  p           L  x        (  T          0  \          8  d          @  l          H  t        $  P  |         ,  X          4  `          <  h          D  p           L  x        (  T          0  \          8  d          @  l          H  t        $  P  |                                                                                                                                                                                                                                                                                 `  8          p  H	   
  
      
  X  0          h  @          x  P  (           `  8        !  "  p#  H$   %  %  &  '  (  X)  0*  +  +  ,  -  h.  @/  0  0  1  2  x3  P4  (5   6  6  7  8  `9  8:  ;  ;  <  =  p>  H?   @  @  A  B  C  XD  0E  F  F  G  H  hI  @J  K  K  L  M  xN  PO  (P   Q  Q  R  S  `T  8U  V  V  W  X  pY  HZ   [  [  \  ]  ^  X_  0`  a  a  b  c  hd  @e  f  f  g  h  xi  Pj  (k   l  l  m  n  `o  8p  q  q  r  s  pt  Hu   v  v  w  x  y  Xz  0{  |  |  }  ~  h  @      Ȃ    x  P  (     ؇      `  8          p  H       В      X  0          h  @      ȝ    x  P  (     آ      `  8          p  H       Э      X  0          h  @      ȸ    x  P  (     ؽ      `  8          p  H             X  0          h  @          x  P  (            9, ^< L \ l |  < a      ? d . > N ^ o B g   ֿ    E j     0 @ #Q Ha mq   ܡ  & K p    # )3 NC sS c s   , Q v    
 / T% y5 E U e 
v 2 W |     5 Z  ' 7 G X 8h ]x   ̨   ; `  	  ) : >J cZ j z Ҋ   A f      D, i< L \ l | " G l      % J	 o	 .	 >	 N	 _	 (o	 M	 r	 	 	 	 	 +	 P	 u 
 
  
 0
 	A
 .Q
 Sa
 xq
 
 
 
 
 1
 V
 {
 
   # 43 YC ~S c s   7 \      : _% 5 E U e v = b      @ e
 
 '
 7
 G
 X
 Ch
 hx
 
 
 ר
 
 !
 F
 k
 
 	  ) $: IJ nZ j z ݊  ' L q     * O, t< L \ l } - R w     0 U z . > N _ 3o X }  ǯ   6 [                      $  (  ,  0  4  8  <  @  D  H  L  P  T  X  \  `  d  h  l  p  t  x  |                                                                                      $  (  ,  0  4  8  <  @  D  H  L  P  T  X  \  `  d  h  l  p  t  x  |                                                                                      $  (  ,  0  4  8  <  @  D  H  L  P  T  X  \  `  d  h  l  p  t  x  |                                                                                      $  (  ,  0  4  8  <  @  D  H  L  P  T  X  \  `  d  h  l  p  t  x  |                                                                                                                                                                                                                                                p  L  (          t	  P
  ,      
    x  T  0          |  X  4            \  8           !  `"  <#  $  $  %  &  '  d(  @)  *  *  +  ,  -  h.  D/   0  0  1  2  3  l4  H5  $6   7  7  8  9  p:  L;  (<  =  =  >  ?  t@  PA  ,B  C  C  D  E  xF  TG  0H  I  I  J  K  |L  XM  4N  O  O  P  Q  R  \S  8T  U  U  V  W  X  `Y  <Z  [  [  \  ]  ^  d_  @`  a  a  b  c  d  he  Df   g  g  h  i  j  lk  Hl  $m   n  n  o  p  pq  Lr  (s  t  t  u  v  tw  Px  ,y  z  z  {  |  x}  T~  0      ā    |  X  4      ȇ      \  8      ̍      `  <      Г      d  @      ԙ      h  D       ؟      l  H  $     ܥ      p  L  (          t  P  ,          x  T  0      ĸ    |  X  4      Ⱦ      \  8            `  <            d  @            h  D             l  H  $       $  H  l  , < L  ] Dm h}   ԭ   @ d    . ? <O `_ o  ̏   8 \      ! 41 XA |Q a q   0 T x     , P# t3 C S c t ( L p      $ H l % 5 E U  f Dv h   Զ   @ d   ' 7 H <X `h x  ̘   8 \   	  * 4: XJ |Z j z   0 T x     , P, t< L \ l } ( L p      $ H	 l	 .	 >	 N	 ^	  o	 D	 h	 	 	 Կ	 	 	 @	 d 
 
  
 0
 @
 Q
 <a
 `q
 
 
 ̡
 
 
 8
 \
 
   " 3 4C XS |c s ă   0 T x     ,% P5 tE U e u  ( L p      $
 H
 l'
 7
 G
 W
 g
  x
 D
 h
 
 
 
 
 
 @
 d	  ) 9 I Z <j `z   ̪   8 \    + < 4L X\ |l | Č   0 T x   
  ,. P> tN ^ n ~  ( L p                                                                                                                                                                                                                                                                                                                                                                                                                p  L  (          t	  P
  ,      
    x  T  0          |  X  4            \  8           !  `"  <#  $  $  %  &  '  d(  @)  *  *  +  ,  -  h.  D/   0  0  1  2  3  l4  H5  $6   7  7  8  9  p:  L;  (<  =  =  >  ?  t@  PA  ,B  C  C  D  E  xF  TG  0H  I  I  J  K  |L  XM  4N  O  O  P  Q  R  \S  8T  U  U  V  W  X  `Y  <Z  [  [  \  ]  ^  d_  @`  a  a  b  c  d  he  Df   g  g  h  i  j  lk  Hl  $m   n  n  o  p  pq  Lr  (s  t  t  u  v  tw  Px  ,y  z  z  {  |  x}  T~  0      ā    |  X  4      ȇ      \  8      ̍      `  <      Г      d  @      ԙ      h  D       ؟      l  H  $     ܥ      p  L  (          t  P  ,          x  T  0      ĸ    |  X  4      Ⱦ      \  8            `  <            d  @            h  D             l  H  $          @  `   0 @ P  a  q @ `         @ ` " 2 B R  c  s @ `         @ ` $ 4 D T  e  u @ `         @ ` & 6 F V  g  w @ `         @ ` ( 8 H X  i  y @ `         @
 ` * : J Z  k  { @ `         @ ` , < L \  m  } @ `         @ ` . > N ^  o   @ `         	 @	 ` 	 0	 @	 P	 `	  q	  	 @	 `	 	 	 	 	  	  
 @
 `"
 2
 B
 R
 b
  s
  
 @
 `
 
 
 
 
  
   @ `$ 4 D T d  u   @ `         @ `& 6 F V f  w   @ `        
 @
 `(
 8
 H
 X
 h
  y
  
 @
 `
 
 
 
 
  
  
 @ `* : J Z j  {   @ `         @ `, < L \ l  }   @ `         @ `. > N ^ n     @ `                          $  (  ,  0  4  8  <  @  D  H  L  P  T  X  \  `  d  h  l  p  t  x  |                                                                                      $  (  ,  0  4  8  <  @  D  H  L  P  T  X  \  `  d  h  l  p  t  x  |                                                                                      $  (  ,  0  4  8  <  @  D  H  L  P  T  X  \  `  d  h  l  p  t  x  |                                                                                      $  (  ,  0  4  8  <  @  D  H  L  P  T  X  \  `  d  h  l  p  t  x  |                                                                                                                                                                                                                                                                                                                                     