#! /bin/sh

# depcomp - compile a program generating dependencies as side-effects
# Copyright 1999, 2000, 2003 Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

# As a special exception to the GNU General Public License, if you
# distribute this file as part of a program that contains a
# configuration script generated by Autoconf, you may include it under
# the same distribution terms that you use for the rest of that program.

# Originally written by Alexandre Oliva <oliva@dcc.unicamp.br>.
# Completely stripped for own purposes by Carlo Wood.

if test -z "$depmode" || test -z "$source" || test -z "$object"; then
  echo "depcomp: Variables source, object and depmode must be set" 1>&2
  exit 1
fi
# `libtool' can also be set to `yes' or `no'.

if test -z "$depfile"; then
   base=`echo "$object" | sed -e 's,^.*/,,' -e 's,\.\([^.]*\)$,.P\1,'`
   dir=`echo "$object" | sed 's,/.*$,/,'`
   if test "$dir" = "$object"; then
      dir=
   fi
   # FIXME: should be _deps on DOS.
   depfile="$dir.deps/$base"
fi

tmpdepfile=${tmpdepfile-`echo "$depfile" | sed 's/\.\([^.]*\)$/.T\1/'`}

rm -f "$tmpdepfile"

case "$depmode" in
pch)
  # First compile file without dependency tracking.
  "$@" || exit $?

  # Remove the call to libtool its parameters.
  if test "$libtool" = yes; then
    while test $1 != '--mode=compile'; do
      shift
    done
    shift
    if expr "$1" : "--" >/dev/null; then
      shift
    fi
  fi

  # Remove `-o $object' and `-include pch.h'.
  eatpch=
  IFS=" "
  for arg
  do
    case $arg in
    -o)
      shift
      ;;
    $object)
      shift
      ;;
    -include)
      shift
      eatpch=yes
      ;;
    *)
      if test x$eatpch = xyes; then
        if test "$arg" = "pch.h"; then
	  shift
	else
	  set fnord "$@" -include "$arg"
	  shift # fnord
	  shift # $arg
	fi
	eatpch=
      else
	set fnord "$@" "$arg"
	shift # fnord
	shift # $arg
      fi
      ;;
    esac
  done
  
  # Generate dependency file.
  "$@" -MT "$object" -M -MF "$tmpdepfile"
  stat=$?
  if test $stat -eq 0; then :
  else
    rm -f "$tmpdepfile"
    exit $stat
  fi
  mv "$tmpdepfile" "$depfile"
  ;;

*)
  echo "Unknown depmode $depmode" 1>&2
  exit 1
  ;;
esac

exit 0
