/* PipeWire
 *
 * Copyright © 2020 Wim Taymans
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef PULSE_SERVER_SAMPLE_H
#define PULSE_SERVER_SAMPLE_H

#include <stdint.h>

#include "format.h"

struct impl;
struct pw_properties;

struct sample {
	int ref;
	uint32_t index;
	struct impl *impl;
	const char *name;
	struct sample_spec ss;
	struct channel_map map;
	struct pw_properties *props;
	uint32_t length;
	uint8_t *buffer;
};

void sample_free(struct sample *sample);

static inline struct sample *sample_ref(struct sample *sample)
{
	sample->ref++;
	return sample;
}

static inline void sample_unref(struct sample *sample)
{
	if (--sample->ref == 0)
		sample_free(sample);
}

#endif /* PULSE_SERVER_SAMPLE_H */
