dnl Copyright (C) 2015 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

# Define HAVE_BITFIELD_TYPE_MATTERS if the type of bitfields effects their
# alignment.

AC_DEFUN([gt_BITFIELD_TYPE_MATTERS],
[
  AC_CACHE_CHECK([if the type of bitfields matters], gt_cv_bitfield_type_matters,
  [
    AC_TRY_COMPILE(
      [struct foo1 { char x; char y:1; char z; };
struct foo2 { char x; long long int y:1; char z; };
int foo1test[ sizeof (struct foo1) < sizeof (struct foo2) ? 1 : -1 ]; ],
      [], gt_cv_bitfield_type_matters=yes, gt_cv_bitfield_type_matters=no)
  ])
  if test $gt_cv_bitfield_type_matters = yes; then
    AC_DEFINE(HAVE_BITFIELD_TYPE_MATTERS, 1,
      [Define if the type of bitfields effects alignment.])
  fi
])
