/* valagtkmodule.c generated by valac, the Vala compiler
 * generated from valagtkmodule.vala, do not modify */

/* valagtkmodule.vala
 *
 * Copyright (C) 2013  Jürg Billeter
 * Copyright (C) 2013-2014  Luca Bruno
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Luca Bruno <lucabru@src.gnome.org>
 */

#include "valacodegen.h"
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <vala.h>
#include <glib/gstdio.h>
#include <valaccode.h>

#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_markup_reader_unref0(var) ((var == NULL) ? NULL : (var = (vala_markup_reader_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))

struct _ValaGtkModulePrivate {
	ValaHashMap* type_id_to_vala_map;
	ValaHashMap* cclass_to_vala_map;
	ValaHashMap* gresource_to_file_map;
	ValaHashMap* current_handler_to_signal_map;
	ValaHashMap* current_child_to_class_map;
	ValaList* current_required_app_classes;
};

static gint ValaGtkModule_private_offset;
static gpointer vala_gtk_module_parent_class = NULL;

static void vala_gtk_module_ensure_type_id_to_vala_map (ValaGtkModule* self);
static void vala_gtk_module_recurse_type_id_to_vala_map (ValaGtkModule* self,
                                                  ValaNamespace* ns);
static void vala_gtk_module_ensure_cclass_to_vala_map (ValaGtkModule* self);
static void vala_gtk_module_recurse_cclass_to_vala_map (ValaGtkModule* self,
                                                 ValaNamespace* ns);
static void vala_gtk_module_ensure_gresource_to_file_map (ValaGtkModule* self);
static void vala_gtk_module_process_current_ui_resource (ValaGtkModule* self,
                                                  const gchar* ui_resource,
                                                  ValaCodeNode* node);
static gboolean vala_gtk_module_is_gtk_template (ValaGtkModule* self,
                                          ValaClass* cl);
static void vala_gtk_module_real_generate_class_init (ValaGTypeModule* base,
                                               ValaClass* cl);
static void vala_gtk_module_real_visit_property (ValaCodeVisitor* base,
                                          ValaProperty* prop);
static void vala_gtk_module_real_visit_field (ValaCodeVisitor* base,
                                       ValaField* f);
static void vala_gtk_module_real_visit_method (ValaCodeVisitor* base,
                                        ValaMethod* m);
static void vala_gtk_module_real_end_instance_init (ValaGTypeModule* base,
                                             ValaClass* cl);
static void vala_gtk_module_finalize (ValaCodeVisitor * obj);

static inline gpointer
vala_gtk_module_get_instance_private (ValaGtkModule* self)
{
	return G_STRUCT_MEMBER_P (self, ValaGtkModule_private_offset);
}

static void
vala_gtk_module_ensure_type_id_to_vala_map (ValaGtkModule* self)
{
	ValaHashMap* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GEqualFunc _tmp3_;
	ValaHashMap* _tmp4_;
	ValaCodeContext* _tmp5_;
	ValaCodeContext* _tmp6_;
	ValaNamespace* _tmp7_;
	ValaNamespace* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->type_id_to_vala_map;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALA_TYPE_CLASS, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_, _tmp2_, _tmp3_);
	_vala_map_unref0 (self->priv->type_id_to_vala_map);
	self->priv->type_id_to_vala_map = _tmp4_;
	_tmp5_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_code_context_get_root (_tmp6_);
	_tmp8_ = _tmp7_;
	vala_gtk_module_recurse_type_id_to_vala_map (self, _tmp8_);
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
vala_gtk_module_recurse_type_id_to_vala_map (ValaGtkModule* self,
                                             ValaNamespace* ns)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp0_;
		gint _cl_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _cl_index = 0;
		_tmp0_ = vala_namespace_get_classes (ns);
		_cl_list = _tmp0_;
		_tmp1_ = _cl_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_cl_size = _tmp3_;
		_cl_index = -1;
		while (TRUE) {
			ValaClass* cl = NULL;
			ValaList* _tmp4_;
			gpointer _tmp5_;
			ValaClass* _tmp6_;
			gboolean _tmp7_;
			gboolean _tmp8_;
			_cl_index = _cl_index + 1;
			if (!(_cl_index < _cl_size)) {
				break;
			}
			_tmp4_ = _cl_list;
			_tmp5_ = vala_list_get (_tmp4_, _cl_index);
			cl = (ValaClass*) _tmp5_;
			_tmp6_ = cl;
			_tmp7_ = vala_class_get_is_compact (_tmp6_);
			_tmp8_ = _tmp7_;
			if (!_tmp8_) {
				gchar* type_id = NULL;
				ValaClass* _tmp9_;
				gchar* _tmp10_;
				const gchar* _tmp11_;
				gint i = 0;
				const gchar* _tmp12_;
				ValaHashMap* _tmp19_;
				const gchar* _tmp20_;
				ValaClass* _tmp21_;
				_tmp9_ = cl;
				_tmp10_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp9_);
				type_id = _tmp10_;
				_tmp11_ = type_id;
				if (_tmp11_ == NULL) {
					_g_free0 (type_id);
					_vala_code_node_unref0 (cl);
					continue;
				}
				_tmp12_ = type_id;
				i = string_index_of_char (_tmp12_, (gunichar) '(', 0);
				if (i > 0) {
					const gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp13_ = type_id;
					_tmp14_ = string_substring (_tmp13_, (glong) 0, (glong) (i - 1));
					_tmp15_ = _tmp14_;
					_tmp16_ = string_strip (_tmp15_);
					_g_free0 (type_id);
					type_id = _tmp16_;
					_g_free0 (_tmp15_);
				} else {
					const gchar* _tmp17_;
					gchar* _tmp18_;
					_tmp17_ = type_id;
					_tmp18_ = string_strip (_tmp17_);
					_g_free0 (type_id);
					type_id = _tmp18_;
				}
				_tmp19_ = self->priv->type_id_to_vala_map;
				_tmp20_ = type_id;
				_tmp21_ = cl;
				vala_map_set ((ValaMap*) _tmp19_, _tmp20_, _tmp21_);
				_g_free0 (type_id);
			}
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _inner_list = NULL;
		ValaList* _tmp22_;
		gint _inner_size = 0;
		ValaList* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _inner_index = 0;
		_tmp22_ = vala_namespace_get_namespaces (ns);
		_inner_list = _tmp22_;
		_tmp23_ = _inner_list;
		_tmp24_ = vala_collection_get_size ((ValaCollection*) _tmp23_);
		_tmp25_ = _tmp24_;
		_inner_size = _tmp25_;
		_inner_index = -1;
		while (TRUE) {
			ValaNamespace* inner = NULL;
			ValaList* _tmp26_;
			gpointer _tmp27_;
			ValaNamespace* _tmp28_;
			_inner_index = _inner_index + 1;
			if (!(_inner_index < _inner_size)) {
				break;
			}
			_tmp26_ = _inner_list;
			_tmp27_ = vala_list_get (_tmp26_, _inner_index);
			inner = (ValaNamespace*) _tmp27_;
			_tmp28_ = inner;
			vala_gtk_module_recurse_type_id_to_vala_map (self, _tmp28_);
			_vala_code_node_unref0 (inner);
		}
		_vala_iterable_unref0 (_inner_list);
	}
}

static void
vala_gtk_module_ensure_cclass_to_vala_map (ValaGtkModule* self)
{
	ValaHashMap* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GEqualFunc _tmp3_;
	ValaHashMap* _tmp4_;
	ValaCodeContext* _tmp5_;
	ValaCodeContext* _tmp6_;
	ValaNamespace* _tmp7_;
	ValaNamespace* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cclass_to_vala_map;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALA_TYPE_CLASS, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_, _tmp2_, _tmp3_);
	_vala_map_unref0 (self->priv->cclass_to_vala_map);
	self->priv->cclass_to_vala_map = _tmp4_;
	_tmp5_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_code_context_get_root (_tmp6_);
	_tmp8_ = _tmp7_;
	vala_gtk_module_recurse_cclass_to_vala_map (self, _tmp8_);
}

static void
vala_gtk_module_recurse_cclass_to_vala_map (ValaGtkModule* self,
                                            ValaNamespace* ns)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp0_;
		gint _cl_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _cl_index = 0;
		_tmp0_ = vala_namespace_get_classes (ns);
		_cl_list = _tmp0_;
		_tmp1_ = _cl_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_cl_size = _tmp3_;
		_cl_index = -1;
		while (TRUE) {
			ValaClass* cl = NULL;
			ValaList* _tmp4_;
			gpointer _tmp5_;
			ValaClass* _tmp6_;
			gboolean _tmp7_;
			gboolean _tmp8_;
			_cl_index = _cl_index + 1;
			if (!(_cl_index < _cl_size)) {
				break;
			}
			_tmp4_ = _cl_list;
			_tmp5_ = vala_list_get (_tmp4_, _cl_index);
			cl = (ValaClass*) _tmp5_;
			_tmp6_ = cl;
			_tmp7_ = vala_class_get_is_compact (_tmp6_);
			_tmp8_ = _tmp7_;
			if (!_tmp8_) {
				ValaHashMap* _tmp9_;
				ValaClass* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				ValaClass* _tmp13_;
				_tmp9_ = self->priv->cclass_to_vala_map;
				_tmp10_ = cl;
				_tmp11_ = vala_get_ccode_name ((ValaCodeNode*) _tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = cl;
				vala_map_set ((ValaMap*) _tmp9_, _tmp12_, _tmp13_);
				_g_free0 (_tmp12_);
			}
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _inner_list = NULL;
		ValaList* _tmp14_;
		gint _inner_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _inner_index = 0;
		_tmp14_ = vala_namespace_get_namespaces (ns);
		_inner_list = _tmp14_;
		_tmp15_ = _inner_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_inner_size = _tmp17_;
		_inner_index = -1;
		while (TRUE) {
			ValaNamespace* inner = NULL;
			ValaList* _tmp18_;
			gpointer _tmp19_;
			ValaNamespace* _tmp20_;
			_inner_index = _inner_index + 1;
			if (!(_inner_index < _inner_size)) {
				break;
			}
			_tmp18_ = _inner_list;
			_tmp19_ = vala_list_get (_tmp18_, _inner_index);
			inner = (ValaNamespace*) _tmp19_;
			_tmp20_ = inner;
			vala_gtk_module_recurse_cclass_to_vala_map (self, _tmp20_);
			_vala_code_node_unref0 (inner);
		}
		_vala_iterable_unref0 (_inner_list);
	}
}

static void
vala_gtk_module_ensure_gresource_to_file_map (ValaGtkModule* self)
{
	ValaHashMap* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GEqualFunc _tmp3_;
	ValaHashMap* _tmp4_;
	ValaCodeContext* _tmp5_;
	ValaCodeContext* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar** _tmp8_;
	gint _tmp8__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->gresource_to_file_map;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp1_, _tmp2_, _tmp3_);
	_vala_map_unref0 (self->priv->gresource_to_file_map);
	self->priv->gresource_to_file_map = _tmp4_;
	_tmp5_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_code_context_get_gresources (_tmp6_, &_tmp7__length1);
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _tmp7__length1;
	{
		gchar** gresource_collection = NULL;
		gint gresource_collection_length1 = 0;
		gint _gresource_collection_size_ = 0;
		gint gresource_it = 0;
		gresource_collection = _tmp8_;
		gresource_collection_length1 = _tmp8__length1;
		for (gresource_it = 0; gresource_it < gresource_collection_length1; gresource_it = gresource_it + 1) {
			gchar* _tmp9_;
			gchar* gresource = NULL;
			_tmp9_ = g_strdup (gresource_collection[gresource_it]);
			gresource = _tmp9_;
			{
				const gchar* _tmp10_;
				ValaMarkupReader* reader = NULL;
				const gchar* _tmp14_;
				ValaMarkupReader* _tmp15_;
				gint state = 0;
				gchar* prefix = NULL;
				gchar* alias = NULL;
				ValaMarkupTokenType current_token = 0;
				ValaMarkupReader* _tmp16_;
				_tmp10_ = gresource;
				if (!g_file_test (_tmp10_, G_FILE_TEST_EXISTS)) {
					const gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					_tmp11_ = gresource;
					_tmp12_ = g_strdup_printf ("GResources file `%s' does not exist", _tmp11_);
					_tmp13_ = _tmp12_;
					vala_report_error (NULL, _tmp13_);
					_g_free0 (_tmp13_);
					_g_free0 (gresource);
					continue;
				}
				_tmp14_ = gresource;
				_tmp15_ = vala_markup_reader_new (_tmp14_);
				reader = _tmp15_;
				state = 0;
				prefix = NULL;
				alias = NULL;
				_tmp16_ = reader;
				current_token = vala_markup_reader_read_token (_tmp16_, NULL, NULL);
				while (TRUE) {
					ValaMarkupTokenType _tmp17_;
					gboolean _tmp18_ = FALSE;
					ValaMarkupTokenType _tmp19_;
					ValaMarkupReader* _tmp56_;
					_tmp17_ = current_token;
					if (!(_tmp17_ != VALA_MARKUP_TOKEN_TYPE_EOF)) {
						break;
					}
					_tmp19_ = current_token;
					if (_tmp19_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
						ValaMarkupReader* _tmp20_;
						const gchar* _tmp21_;
						const gchar* _tmp22_;
						_tmp20_ = reader;
						_tmp21_ = vala_markup_reader_get_name (_tmp20_);
						_tmp22_ = _tmp21_;
						_tmp18_ = g_strcmp0 (_tmp22_, "gresource") == 0;
					} else {
						_tmp18_ = FALSE;
					}
					if (_tmp18_) {
						ValaMarkupReader* _tmp23_;
						gchar* _tmp24_;
						_tmp23_ = reader;
						_tmp24_ = vala_markup_reader_get_attribute (_tmp23_, "prefix");
						_g_free0 (prefix);
						prefix = _tmp24_;
					} else {
						gboolean _tmp25_ = FALSE;
						ValaMarkupTokenType _tmp26_;
						_tmp26_ = current_token;
						if (_tmp26_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
							ValaMarkupReader* _tmp27_;
							const gchar* _tmp28_;
							const gchar* _tmp29_;
							_tmp27_ = reader;
							_tmp28_ = vala_markup_reader_get_name (_tmp27_);
							_tmp29_ = _tmp28_;
							_tmp25_ = g_strcmp0 (_tmp29_, "file") == 0;
						} else {
							_tmp25_ = FALSE;
						}
						if (_tmp25_) {
							ValaMarkupReader* _tmp30_;
							gchar* _tmp31_;
							_tmp30_ = reader;
							_tmp31_ = vala_markup_reader_get_attribute (_tmp30_, "alias");
							_g_free0 (alias);
							alias = _tmp31_;
							state = 1;
						} else {
							gboolean _tmp32_ = FALSE;
							if (state == 1) {
								ValaMarkupTokenType _tmp33_;
								_tmp33_ = current_token;
								_tmp32_ = _tmp33_ == VALA_MARKUP_TOKEN_TYPE_TEXT;
							} else {
								_tmp32_ = FALSE;
							}
							if (_tmp32_) {
								gchar* name = NULL;
								ValaMarkupReader* _tmp34_;
								const gchar* _tmp35_;
								const gchar* _tmp36_;
								gchar* _tmp37_;
								gchar* filename = NULL;
								ValaCodeContext* _tmp38_;
								ValaCodeContext* _tmp39_;
								const gchar* _tmp40_;
								const gchar* _tmp41_;
								gchar* _tmp42_;
								const gchar* _tmp43_;
								ValaHashMap* _tmp50_;
								const gchar* _tmp51_;
								const gchar* _tmp52_;
								gchar* _tmp53_;
								gchar* _tmp54_;
								const gchar* _tmp55_;
								_tmp34_ = reader;
								_tmp35_ = vala_markup_reader_get_content (_tmp34_);
								_tmp36_ = _tmp35_;
								_tmp37_ = g_strdup (_tmp36_);
								name = _tmp37_;
								_tmp38_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
								_tmp39_ = _tmp38_;
								_tmp40_ = gresource;
								_tmp41_ = name;
								_tmp42_ = vala_code_context_get_gresource_path (_tmp39_, _tmp40_, _tmp41_);
								filename = _tmp42_;
								_tmp43_ = alias;
								if (_tmp43_ != NULL) {
									ValaHashMap* _tmp44_;
									const gchar* _tmp45_;
									const gchar* _tmp46_;
									gchar* _tmp47_;
									gchar* _tmp48_;
									const gchar* _tmp49_;
									_tmp44_ = self->priv->gresource_to_file_map;
									_tmp45_ = prefix;
									_tmp46_ = alias;
									_tmp47_ = g_build_filename (_tmp45_, _tmp46_, NULL);
									_tmp48_ = _tmp47_;
									_tmp49_ = filename;
									vala_map_set ((ValaMap*) _tmp44_, _tmp48_, _tmp49_);
									_g_free0 (_tmp48_);
								}
								_tmp50_ = self->priv->gresource_to_file_map;
								_tmp51_ = prefix;
								_tmp52_ = name;
								_tmp53_ = g_build_filename (_tmp51_, _tmp52_, NULL);
								_tmp54_ = _tmp53_;
								_tmp55_ = filename;
								vala_map_set ((ValaMap*) _tmp50_, _tmp54_, _tmp55_);
								_g_free0 (_tmp54_);
								state = 0;
								_g_free0 (filename);
								_g_free0 (name);
							}
						}
					}
					_tmp56_ = reader;
					current_token = vala_markup_reader_read_token (_tmp56_, NULL, NULL);
				}
				_g_free0 (alias);
				_g_free0 (prefix);
				_vala_markup_reader_unref0 (reader);
				_g_free0 (gresource);
			}
		}
	}
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch8_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch8_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally8;
	__catch8_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally8:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
vala_gtk_module_process_current_ui_resource (ValaGtkModule* self,
                                             const gchar* ui_resource,
                                             ValaCodeNode* node)
{
	gchar* ui_file = NULL;
	ValaHashMap* _tmp0_;
	gpointer _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	GHashFunc _tmp9_;
	GEqualFunc _tmp10_;
	GEqualFunc _tmp11_;
	ValaHashMap* _tmp12_;
	GHashFunc _tmp13_;
	GEqualFunc _tmp14_;
	GEqualFunc _tmp15_;
	ValaHashMap* _tmp16_;
	ValaMarkupReader* reader = NULL;
	const gchar* _tmp17_;
	ValaMarkupReader* _tmp18_;
	ValaClass* current_class = NULL;
	gboolean template_tag_found = FALSE;
	ValaMarkupTokenType current_token = 0;
	ValaMarkupReader* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ui_resource != NULL);
	g_return_if_fail (node != NULL);
	vala_gtk_module_ensure_type_id_to_vala_map (self);
	vala_gtk_module_ensure_cclass_to_vala_map (self);
	vala_gtk_module_ensure_gresource_to_file_map (self);
	_vala_map_unref0 (self->priv->current_handler_to_signal_map);
	self->priv->current_handler_to_signal_map = NULL;
	_vala_map_unref0 (self->priv->current_child_to_class_map);
	self->priv->current_child_to_class_map = NULL;
	_tmp0_ = self->priv->gresource_to_file_map;
	_tmp1_ = vala_map_get ((ValaMap*) _tmp0_, ui_resource);
	ui_file = (gchar*) _tmp1_;
	_tmp3_ = ui_file;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = ui_file;
		_tmp2_ = !g_file_test (_tmp4_, G_FILE_TEST_EXISTS);
	}
	if (_tmp2_) {
		ValaSourceReference* _tmp5_;
		ValaSourceReference* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		vala_code_node_set_error (node, TRUE);
		_tmp5_ = vala_code_node_get_source_reference (node);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup_printf ("UI resource not found: `%s'. Please make sure to specify the proper GR" \
"esources xml files with --gresources and alternative search locations " \
"with --gresourcesdir.", ui_resource);
		_tmp8_ = _tmp7_;
		vala_report_error (_tmp6_, _tmp8_);
		_g_free0 (_tmp8_);
		_g_free0 (ui_file);
		return;
	}
	_tmp9_ = g_str_hash;
	_tmp10_ = g_str_equal;
	_tmp11_ = g_direct_equal;
	_tmp12_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALA_TYPE_SIGNAL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp9_, _tmp10_, _tmp11_);
	_vala_map_unref0 (self->priv->current_handler_to_signal_map);
	self->priv->current_handler_to_signal_map = _tmp12_;
	_tmp13_ = g_str_hash;
	_tmp14_ = g_str_equal;
	_tmp15_ = g_direct_equal;
	_tmp16_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALA_TYPE_CLASS, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp13_, _tmp14_, _tmp15_);
	_vala_map_unref0 (self->priv->current_child_to_class_map);
	self->priv->current_child_to_class_map = _tmp16_;
	_tmp17_ = ui_file;
	_tmp18_ = vala_markup_reader_new (_tmp17_);
	reader = _tmp18_;
	current_class = NULL;
	template_tag_found = FALSE;
	_tmp19_ = reader;
	current_token = vala_markup_reader_read_token (_tmp19_, NULL, NULL);
	while (TRUE) {
		ValaMarkupTokenType _tmp20_;
		const gchar* current_name = NULL;
		ValaMarkupReader* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		gboolean _tmp24_ = FALSE;
		ValaMarkupTokenType _tmp25_;
		ValaMarkupReader* _tmp91_;
		_tmp20_ = current_token;
		if (!(_tmp20_ != VALA_MARKUP_TOKEN_TYPE_EOF)) {
			break;
		}
		_tmp21_ = reader;
		_tmp22_ = vala_markup_reader_get_name (_tmp21_);
		_tmp23_ = _tmp22_;
		current_name = _tmp23_;
		_tmp25_ = current_token;
		if (_tmp25_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
			gboolean _tmp26_ = FALSE;
			const gchar* _tmp27_;
			_tmp27_ = current_name;
			if (g_strcmp0 (_tmp27_, "object") == 0) {
				_tmp26_ = TRUE;
			} else {
				const gchar* _tmp28_;
				_tmp28_ = current_name;
				_tmp26_ = g_strcmp0 (_tmp28_, "template") == 0;
			}
			_tmp24_ = _tmp26_;
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			const gchar* _tmp29_;
			ValaClass* _tmp37_;
			ValaClass* _tmp51_;
			_vala_code_node_unref0 (current_class);
			current_class = NULL;
			_tmp29_ = current_name;
			if (g_strcmp0 (_tmp29_, "object") == 0) {
				gchar* type_id = NULL;
				ValaMarkupReader* _tmp30_;
				gchar* _tmp31_;
				const gchar* _tmp32_;
				_tmp30_ = reader;
				_tmp31_ = vala_markup_reader_get_attribute (_tmp30_, "type-func");
				type_id = _tmp31_;
				_tmp32_ = type_id;
				if (_tmp32_ != NULL) {
					ValaHashMap* _tmp33_;
					const gchar* _tmp34_;
					gpointer _tmp35_;
					_tmp33_ = self->priv->type_id_to_vala_map;
					_tmp34_ = type_id;
					_tmp35_ = vala_map_get ((ValaMap*) _tmp33_, _tmp34_);
					_vala_code_node_unref0 (current_class);
					current_class = (ValaClass*) _tmp35_;
				}
				_g_free0 (type_id);
			} else {
				const gchar* _tmp36_;
				_tmp36_ = current_name;
				if (g_strcmp0 (_tmp36_, "template") == 0) {
					template_tag_found = TRUE;
				}
			}
			_tmp37_ = current_class;
			if (_tmp37_ == NULL) {
				gchar* class_name = NULL;
				ValaMarkupReader* _tmp38_;
				gchar* _tmp39_;
				const gchar* _tmp40_;
				ValaHashMap* _tmp48_;
				const gchar* _tmp49_;
				gpointer _tmp50_;
				_tmp38_ = reader;
				_tmp39_ = vala_markup_reader_get_attribute (_tmp38_, "class");
				class_name = _tmp39_;
				_tmp40_ = class_name;
				if (_tmp40_ == NULL) {
					ValaSourceReference* _tmp41_;
					ValaSourceReference* _tmp42_;
					const gchar* _tmp43_;
					const gchar* _tmp44_;
					gchar* _tmp45_;
					gchar* _tmp46_;
					ValaMarkupReader* _tmp47_;
					_tmp41_ = vala_code_node_get_source_reference (node);
					_tmp42_ = _tmp41_;
					_tmp43_ = current_name;
					_tmp44_ = ui_file;
					_tmp45_ = g_strdup_printf ("Invalid %s in ui file `%s'", _tmp43_, _tmp44_);
					_tmp46_ = _tmp45_;
					vala_report_error (_tmp42_, _tmp46_);
					_g_free0 (_tmp46_);
					_tmp47_ = reader;
					current_token = vala_markup_reader_read_token (_tmp47_, NULL, NULL);
					_g_free0 (class_name);
					continue;
				}
				_tmp48_ = self->priv->cclass_to_vala_map;
				_tmp49_ = class_name;
				_tmp50_ = vala_map_get ((ValaMap*) _tmp48_, _tmp49_);
				_vala_code_node_unref0 (current_class);
				current_class = (ValaClass*) _tmp50_;
				_g_free0 (class_name);
			}
			_tmp51_ = current_class;
			if (_tmp51_ != NULL) {
				gchar* child_name = NULL;
				ValaMarkupReader* _tmp52_;
				gchar* _tmp53_;
				const gchar* _tmp54_;
				_tmp52_ = reader;
				_tmp53_ = vala_markup_reader_get_attribute (_tmp52_, "id");
				child_name = _tmp53_;
				_tmp54_ = child_name;
				if (_tmp54_ != NULL) {
					ValaHashMap* _tmp55_;
					const gchar* _tmp56_;
					ValaClass* _tmp57_;
					_tmp55_ = self->priv->current_child_to_class_map;
					_tmp56_ = child_name;
					_tmp57_ = current_class;
					vala_map_set ((ValaMap*) _tmp55_, _tmp56_, _tmp57_);
				}
				_g_free0 (child_name);
			}
		} else {
			gboolean _tmp58_ = FALSE;
			gboolean _tmp59_ = FALSE;
			ValaClass* _tmp60_;
			_tmp60_ = current_class;
			if (_tmp60_ != NULL) {
				ValaMarkupTokenType _tmp61_;
				_tmp61_ = current_token;
				_tmp59_ = _tmp61_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT;
			} else {
				_tmp59_ = FALSE;
			}
			if (_tmp59_) {
				const gchar* _tmp62_;
				_tmp62_ = current_name;
				_tmp58_ = g_strcmp0 (_tmp62_, "signal") == 0;
			} else {
				_tmp58_ = FALSE;
			}
			if (_tmp58_) {
				gchar* signal_name = NULL;
				ValaMarkupReader* _tmp63_;
				gchar* _tmp64_;
				gchar* handler_name = NULL;
				ValaMarkupReader* _tmp65_;
				gchar* _tmp66_;
				ValaClass* _tmp67_;
				_tmp63_ = reader;
				_tmp64_ = vala_markup_reader_get_attribute (_tmp63_, "name");
				signal_name = _tmp64_;
				_tmp65_ = reader;
				_tmp66_ = vala_markup_reader_get_attribute (_tmp65_, "handler");
				handler_name = _tmp66_;
				_tmp67_ = current_class;
				if (_tmp67_ != NULL) {
					gboolean _tmp68_ = FALSE;
					const gchar* _tmp69_;
					gint sep_idx = 0;
					const gchar* _tmp77_;
					ValaSignal* sig = NULL;
					ValaClass* _tmp80_;
					const gchar* _tmp81_;
					gchar* _tmp82_;
					gchar* _tmp83_;
					ValaSymbol* _tmp84_;
					ValaSignal* _tmp85_;
					ValaSignal* _tmp86_;
					ValaSignal* _tmp87_;
					_tmp69_ = signal_name;
					if (_tmp69_ == NULL) {
						_tmp68_ = TRUE;
					} else {
						const gchar* _tmp70_;
						_tmp70_ = handler_name;
						_tmp68_ = _tmp70_ == NULL;
					}
					if (_tmp68_) {
						ValaSourceReference* _tmp71_;
						ValaSourceReference* _tmp72_;
						const gchar* _tmp73_;
						gchar* _tmp74_;
						gchar* _tmp75_;
						ValaMarkupReader* _tmp76_;
						_tmp71_ = vala_code_node_get_source_reference (node);
						_tmp72_ = _tmp71_;
						_tmp73_ = ui_file;
						_tmp74_ = g_strdup_printf ("Invalid signal in ui file `%s'", _tmp73_);
						_tmp75_ = _tmp74_;
						vala_report_error (_tmp72_, _tmp75_);
						_g_free0 (_tmp75_);
						_tmp76_ = reader;
						current_token = vala_markup_reader_read_token (_tmp76_, NULL, NULL);
						_g_free0 (handler_name);
						_g_free0 (signal_name);
						continue;
					}
					_tmp77_ = signal_name;
					sep_idx = string_index_of (_tmp77_, "::", 0);
					if (sep_idx >= 0) {
						const gchar* _tmp78_;
						gchar* _tmp79_;
						_tmp78_ = signal_name;
						_tmp79_ = string_substring (_tmp78_, (glong) 0, (glong) sep_idx);
						_g_free0 (signal_name);
						signal_name = _tmp79_;
					}
					_tmp80_ = current_class;
					_tmp81_ = signal_name;
					_tmp82_ = string_replace (_tmp81_, "-", "_");
					_tmp83_ = _tmp82_;
					_tmp84_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) _tmp80_, _tmp83_);
					_tmp85_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp84_, VALA_TYPE_SIGNAL) ? ((ValaSignal*) _tmp84_) : NULL;
					if (_tmp85_ == NULL) {
						_vala_code_node_unref0 (_tmp84_);
					}
					_tmp86_ = _tmp85_;
					_g_free0 (_tmp83_);
					sig = _tmp86_;
					_tmp87_ = sig;
					if (_tmp87_ != NULL) {
						ValaHashMap* _tmp88_;
						const gchar* _tmp89_;
						ValaSignal* _tmp90_;
						_tmp88_ = self->priv->current_handler_to_signal_map;
						_tmp89_ = handler_name;
						_tmp90_ = sig;
						vala_map_set ((ValaMap*) _tmp88_, _tmp89_, _tmp90_);
					}
					_vala_code_node_unref0 (sig);
				}
				_g_free0 (handler_name);
				_g_free0 (signal_name);
			}
		}
		_tmp91_ = reader;
		current_token = vala_markup_reader_read_token (_tmp91_, NULL, NULL);
	}
	if (!template_tag_found) {
		ValaSourceReference* _tmp92_;
		ValaSourceReference* _tmp93_;
		gchar* _tmp94_;
		gchar* _tmp95_;
		_tmp92_ = vala_code_node_get_source_reference (node);
		_tmp93_ = _tmp92_;
		_tmp94_ = g_strdup_printf ("ui resource `%s' does not describe a valid composite template", ui_resource);
		_tmp95_ = _tmp94_;
		vala_report_error (_tmp93_, _tmp95_);
		_g_free0 (_tmp95_);
	}
	_vala_code_node_unref0 (current_class);
	_vala_markup_reader_unref0 (reader);
	_g_free0 (ui_file);
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_gtk_module_is_gtk_template (ValaGtkModule* self,
                                 ValaClass* cl)
{
	ValaAttribute* attr = NULL;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	ValaAttribute* _tmp2_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cl != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) cl, "GtkTemplate");
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	attr = _tmp1_;
	_tmp2_ = attr;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		ValaClass* _tmp4_;
		_tmp4_ = ((ValaCCodeBaseModule*) self)->gtk_widget_type;
		if (_tmp4_ == NULL) {
			_tmp3_ = TRUE;
		} else {
			ValaClass* _tmp5_;
			_tmp5_ = ((ValaCCodeBaseModule*) self)->gtk_widget_type;
			_tmp3_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) cl, (ValaTypeSymbol*) _tmp5_);
		}
		if (_tmp3_) {
			gboolean _tmp6_;
			gboolean _tmp7_;
			_tmp6_ = vala_code_node_get_error ((ValaCodeNode*) cl);
			_tmp7_ = _tmp6_;
			if (!_tmp7_) {
				ValaAttribute* _tmp8_;
				ValaSourceReference* _tmp9_;
				ValaSourceReference* _tmp10_;
				_tmp8_ = attr;
				_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp8_);
				_tmp10_ = _tmp9_;
				vala_report_error (_tmp10_, "subclassing Gtk.Widget is required for using Gtk templates");
				vala_code_node_set_error ((ValaCodeNode*) cl, TRUE);
			}
			result = FALSE;
			_vala_code_node_unref0 (attr);
			return result;
		}
		result = TRUE;
		_vala_code_node_unref0 (attr);
		return result;
	}
	result = FALSE;
	_vala_code_node_unref0 (attr);
	return result;
}

static void
vala_gtk_module_real_generate_class_init (ValaGTypeModule* base,
                                          ValaClass* cl)
{
	ValaGtkModule * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gchar* ui = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp7_;
	ValaCCodeFunctionCall* call = NULL;
	ValaCCodeIdentifier* _tmp8_;
	ValaCCodeIdentifier* _tmp9_;
	ValaCCodeFunctionCall* _tmp10_;
	ValaCCodeFunctionCall* _tmp11_;
	ValaCCodeFunctionCall* _tmp12_;
	ValaCCodeIdentifier* _tmp13_;
	ValaCCodeIdentifier* _tmp14_;
	ValaCCodeFunctionCall* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeConstant* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeFunction* _tmp22_;
	ValaCCodeFunctionCall* _tmp23_;
	ValaList* _tmp24_;
	self = (ValaGtkModule*) base;
	g_return_if_fail (cl != NULL);
	VALA_GTYPE_MODULE_CLASS (vala_gtk_module_parent_class)->generate_class_init ((ValaGTypeModule*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModule), cl);
	_tmp1_ = vala_code_node_get_error ((ValaCodeNode*) cl);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !vala_gtk_module_is_gtk_template (self, cl);
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = vala_code_node_get_attribute_string ((ValaCodeNode*) cl, "GtkTemplate", "ui", NULL);
	ui = _tmp3_;
	_tmp4_ = ui;
	if (_tmp4_ == NULL) {
		ValaSourceReference* _tmp5_;
		ValaSourceReference* _tmp6_;
		_tmp5_ = vala_code_node_get_source_reference ((ValaCodeNode*) cl);
		_tmp6_ = _tmp5_;
		vala_report_error (_tmp6_, "empty ui resource declaration for Gtk widget template");
		vala_code_node_set_error ((ValaCodeNode*) cl, TRUE);
		_g_free0 (ui);
		return;
	}
	_tmp7_ = ui;
	vala_gtk_module_process_current_ui_resource (self, _tmp7_, (ValaCodeNode*) cl);
	_tmp8_ = vala_ccode_identifier_new ("gtk_widget_class_set_template_from_resource");
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp9_);
	_tmp11_ = _tmp10_;
	_vala_ccode_node_unref0 (_tmp9_);
	call = _tmp11_;
	_tmp12_ = call;
	_tmp13_ = vala_ccode_identifier_new ("GTK_WIDGET_CLASS (klass)");
	_tmp14_ = _tmp13_;
	vala_ccode_function_call_add_argument (_tmp12_, (ValaCCodeExpression*) _tmp14_);
	_vala_ccode_node_unref0 (_tmp14_);
	_tmp15_ = call;
	_tmp16_ = ui;
	_tmp17_ = g_strdup_printf ("\"%s\"", _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_ccode_constant_new (_tmp18_);
	_tmp20_ = _tmp19_;
	vala_ccode_function_call_add_argument (_tmp15_, (ValaCCodeExpression*) _tmp20_);
	_vala_ccode_node_unref0 (_tmp20_);
	_g_free0 (_tmp18_);
	_tmp21_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp22_ = _tmp21_;
	_tmp23_ = call;
	vala_ccode_function_add_expression (_tmp22_, (ValaCCodeExpression*) _tmp23_);
	_tmp24_ = self->priv->current_required_app_classes;
	vala_collection_clear ((ValaCollection*) _tmp24_);
	_vala_ccode_node_unref0 (call);
	_g_free0 (ui);
}

static void
vala_gtk_module_real_visit_property (ValaCodeVisitor* base,
                                     ValaProperty* prop)
{
	ValaGtkModule * self;
	gboolean _tmp0_ = FALSE;
	ValaAttribute* _tmp1_;
	self = (ValaGtkModule*) base;
	g_return_if_fail (prop != NULL);
	_tmp1_ = vala_code_node_get_attribute ((ValaCodeNode*) prop, "GtkChild");
	if (_tmp1_ != NULL) {
		ValaField* _tmp2_;
		ValaField* _tmp3_;
		_tmp2_ = vala_property_get_field (prop);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) prop);
		_tmp5_ = _tmp4_;
		vala_report_error (_tmp5_, "[GtkChild] is only allowed on automatic properties");
	}
	VALA_CODE_VISITOR_CLASS (vala_gtk_module_parent_class)->visit_property ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModule), prop);
}

static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}

static void
vala_gtk_module_real_visit_field (ValaCodeVisitor* base,
                                  ValaField* f)
{
	ValaGtkModule * self;
	ValaClass* cl = NULL;
	ValaClass* _tmp0_;
	ValaClass* _tmp1_;
	ValaClass* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaClass* _tmp4_;
	gboolean _tmp8_ = FALSE;
	ValaMemberBinding _tmp9_;
	ValaMemberBinding _tmp10_;
	ValaClass* _tmp12_;
	ValaCCodeBaseModuleEmitContext* _tmp15_;
	gchar* gtk_name = NULL;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	ValaClass* child_class = NULL;
	ValaHashMap* _tmp19_;
	const gchar* _tmp20_;
	gpointer _tmp21_;
	ValaClass* _tmp22_;
	ValaClass* field_class = NULL;
	ValaDataType* _tmp28_;
	ValaDataType* _tmp29_;
	ValaTypeSymbol* _tmp30_;
	ValaTypeSymbol* _tmp31_;
	ValaClass* _tmp32_;
	gboolean _tmp33_ = FALSE;
	ValaClass* _tmp34_;
	gboolean internal_child = FALSE;
	ValaCCodeExpression* offset = NULL;
	ValaCCodeFunctionCall* call = NULL;
	ValaCCodeIdentifier* _tmp90_;
	ValaCCodeIdentifier* _tmp91_;
	ValaCCodeFunctionCall* _tmp92_;
	ValaCCodeFunctionCall* _tmp93_;
	ValaCCodeFunctionCall* _tmp94_;
	ValaCCodeIdentifier* _tmp95_;
	ValaCCodeIdentifier* _tmp96_;
	ValaCCodeFunctionCall* _tmp97_;
	const gchar* _tmp98_;
	gchar* _tmp99_;
	gchar* _tmp100_;
	ValaCCodeConstant* _tmp101_;
	ValaCCodeConstant* _tmp102_;
	const gchar* _tmp103_ = NULL;
	ValaCCodeFunctionCall* _tmp104_;
	ValaCCodeConstant* _tmp105_;
	ValaCCodeConstant* _tmp106_;
	ValaCCodeFunctionCall* _tmp107_;
	ValaCCodeExpression* _tmp108_;
	ValaCCodeFunction* _tmp109_;
	ValaCCodeFunction* _tmp110_;
	ValaCCodeFunctionCall* _tmp111_;
	gboolean _tmp112_ = FALSE;
	ValaClass* _tmp113_;
	gboolean _tmp114_;
	gboolean _tmp115_;
	self = (ValaGtkModule*) base;
	g_return_if_fail (f != NULL);
	VALA_CODE_VISITOR_CLASS (vala_gtk_module_parent_class)->visit_field ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModule), f);
	_tmp0_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (_tmp1_);
	cl = _tmp2_;
	_tmp4_ = cl;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		ValaClass* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = cl;
		_tmp6_ = vala_code_node_get_error ((ValaCodeNode*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_;
	}
	if (_tmp3_) {
		_vala_code_node_unref0 (cl);
		return;
	}
	_tmp9_ = vala_field_get_binding (f);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != VALA_MEMBER_BINDING_INSTANCE) {
		_tmp8_ = TRUE;
	} else {
		ValaAttribute* _tmp11_;
		_tmp11_ = vala_code_node_get_attribute ((ValaCodeNode*) f, "GtkChild");
		_tmp8_ = _tmp11_ == NULL;
	}
	if (_tmp8_) {
		_vala_code_node_unref0 (cl);
		return;
	}
	_tmp12_ = cl;
	if (!vala_gtk_module_is_gtk_template (self, _tmp12_)) {
		ValaSourceReference* _tmp13_;
		ValaSourceReference* _tmp14_;
		_tmp13_ = vala_code_node_get_source_reference ((ValaCodeNode*) f);
		_tmp14_ = _tmp13_;
		vala_report_error (_tmp14_, "[GtkChild] is only allowed in classes with a [GtkTemplate] attribute");
		_vala_code_node_unref0 (cl);
		return;
	}
	_tmp15_ = ((ValaCCodeBaseModule*) self)->class_init_context;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_symbol_get_name ((ValaSymbol*) f);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_code_node_get_attribute_string ((ValaCodeNode*) f, "GtkChild", "name", _tmp17_);
	gtk_name = _tmp18_;
	_tmp19_ = self->priv->current_child_to_class_map;
	_tmp20_ = gtk_name;
	_tmp21_ = vala_map_get ((ValaMap*) _tmp19_, _tmp20_);
	child_class = (ValaClass*) _tmp21_;
	_tmp22_ = child_class;
	if (_tmp22_ == NULL) {
		ValaSourceReference* _tmp23_;
		ValaSourceReference* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) f);
		_tmp24_ = _tmp23_;
		_tmp25_ = gtk_name;
		_tmp26_ = g_strdup_printf ("could not find child `%s'", _tmp25_);
		_tmp27_ = _tmp26_;
		vala_report_error (_tmp24_, _tmp27_);
		_g_free0 (_tmp27_);
		_vala_code_node_unref0 (child_class);
		_g_free0 (gtk_name);
		_vala_code_node_unref0 (cl);
		return;
	}
	_tmp28_ = vala_variable_get_variable_type ((ValaVariable*) f);
	_tmp29_ = _tmp28_;
	_tmp30_ = vala_data_type_get_data_type (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp31_) : NULL);
	field_class = _tmp32_;
	_tmp34_ = field_class;
	if (_tmp34_ == NULL) {
		_tmp33_ = TRUE;
	} else {
		ValaClass* _tmp35_;
		ValaClass* _tmp36_;
		_tmp35_ = child_class;
		_tmp36_ = field_class;
		_tmp33_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp35_, (ValaTypeSymbol*) _tmp36_);
	}
	if (_tmp33_) {
		ValaSourceReference* _tmp37_;
		ValaSourceReference* _tmp38_;
		ValaClass* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		ValaClass* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		_tmp37_ = vala_code_node_get_source_reference ((ValaCodeNode*) f);
		_tmp38_ = _tmp37_;
		_tmp39_ = child_class;
		_tmp40_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = field_class;
		_tmp43_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = g_strdup_printf ("cannot convert from Gtk child type `%s' to `%s'", _tmp41_, _tmp44_);
		_tmp46_ = _tmp45_;
		vala_report_error (_tmp38_, _tmp46_);
		_g_free0 (_tmp46_);
		_g_free0 (_tmp44_);
		_g_free0 (_tmp41_);
		_vala_code_node_unref0 (field_class);
		_vala_code_node_unref0 (child_class);
		_g_free0 (gtk_name);
		_vala_code_node_unref0 (cl);
		return;
	}
	internal_child = vala_code_node_get_attribute_bool ((ValaCodeNode*) f, "GtkChild", "internal", FALSE);
	if (vala_symbol_is_private_symbol ((ValaSymbol*) f)) {
		ValaCCodeFunctionCall* private_field_offset = NULL;
		ValaCCodeIdentifier* _tmp47_;
		ValaCCodeIdentifier* _tmp48_;
		ValaCCodeFunctionCall* _tmp49_;
		ValaCCodeFunctionCall* _tmp50_;
		ValaCCodeFunctionCall* _tmp51_;
		ValaClass* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		ValaCCodeIdentifier* _tmp57_;
		ValaCCodeIdentifier* _tmp58_;
		ValaCCodeFunctionCall* _tmp59_;
		gchar* _tmp60_;
		gchar* _tmp61_;
		ValaCCodeIdentifier* _tmp62_;
		ValaCCodeIdentifier* _tmp63_;
		ValaClass* _tmp64_;
		gchar* _tmp65_;
		gchar* _tmp66_;
		gchar* _tmp67_;
		gchar* _tmp68_;
		ValaCCodeIdentifier* _tmp69_;
		ValaCCodeIdentifier* _tmp70_;
		ValaCCodeFunctionCall* _tmp71_;
		ValaCCodeBinaryExpression* _tmp72_;
		_tmp47_ = vala_ccode_identifier_new ("G_STRUCT_OFFSET");
		_tmp48_ = _tmp47_;
		_tmp49_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp48_);
		_tmp50_ = _tmp49_;
		_vala_ccode_node_unref0 (_tmp48_);
		private_field_offset = _tmp50_;
		_tmp51_ = private_field_offset;
		_tmp52_ = cl;
		_tmp53_ = vala_get_ccode_name ((ValaCodeNode*) _tmp52_);
		_tmp54_ = _tmp53_;
		_tmp55_ = g_strdup_printf ("%sPrivate", _tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = vala_ccode_identifier_new (_tmp56_);
		_tmp58_ = _tmp57_;
		vala_ccode_function_call_add_argument (_tmp51_, (ValaCCodeExpression*) _tmp58_);
		_vala_ccode_node_unref0 (_tmp58_);
		_g_free0 (_tmp56_);
		_g_free0 (_tmp54_);
		_tmp59_ = private_field_offset;
		_tmp60_ = vala_get_ccode_name ((ValaCodeNode*) f);
		_tmp61_ = _tmp60_;
		_tmp62_ = vala_ccode_identifier_new (_tmp61_);
		_tmp63_ = _tmp62_;
		vala_ccode_function_call_add_argument (_tmp59_, (ValaCCodeExpression*) _tmp63_);
		_vala_ccode_node_unref0 (_tmp63_);
		_g_free0 (_tmp61_);
		_tmp64_ = cl;
		_tmp65_ = vala_get_ccode_name ((ValaCodeNode*) _tmp64_);
		_tmp66_ = _tmp65_;
		_tmp67_ = g_strdup_printf ("%s_private_offset", _tmp66_);
		_tmp68_ = _tmp67_;
		_tmp69_ = vala_ccode_identifier_new (_tmp68_);
		_tmp70_ = _tmp69_;
		_tmp71_ = private_field_offset;
		_tmp72_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp70_, (ValaCCodeExpression*) _tmp71_);
		_vala_ccode_node_unref0 (offset);
		offset = (ValaCCodeExpression*) _tmp72_;
		_vala_ccode_node_unref0 (_tmp70_);
		_g_free0 (_tmp68_);
		_g_free0 (_tmp66_);
		_vala_ccode_node_unref0 (private_field_offset);
	} else {
		ValaCCodeFunctionCall* offset_call = NULL;
		ValaCCodeIdentifier* _tmp73_;
		ValaCCodeIdentifier* _tmp74_;
		ValaCCodeFunctionCall* _tmp75_;
		ValaCCodeFunctionCall* _tmp76_;
		ValaCCodeFunctionCall* _tmp77_;
		ValaClass* _tmp78_;
		gchar* _tmp79_;
		gchar* _tmp80_;
		ValaCCodeIdentifier* _tmp81_;
		ValaCCodeIdentifier* _tmp82_;
		ValaCCodeFunctionCall* _tmp83_;
		gchar* _tmp84_;
		gchar* _tmp85_;
		ValaCCodeIdentifier* _tmp86_;
		ValaCCodeIdentifier* _tmp87_;
		ValaCCodeFunctionCall* _tmp88_;
		ValaCCodeExpression* _tmp89_;
		_tmp73_ = vala_ccode_identifier_new ("G_STRUCT_OFFSET");
		_tmp74_ = _tmp73_;
		_tmp75_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp74_);
		_tmp76_ = _tmp75_;
		_vala_ccode_node_unref0 (_tmp74_);
		offset_call = _tmp76_;
		_tmp77_ = offset_call;
		_tmp78_ = cl;
		_tmp79_ = vala_get_ccode_name ((ValaCodeNode*) _tmp78_);
		_tmp80_ = _tmp79_;
		_tmp81_ = vala_ccode_identifier_new (_tmp80_);
		_tmp82_ = _tmp81_;
		vala_ccode_function_call_add_argument (_tmp77_, (ValaCCodeExpression*) _tmp82_);
		_vala_ccode_node_unref0 (_tmp82_);
		_g_free0 (_tmp80_);
		_tmp83_ = offset_call;
		_tmp84_ = vala_get_ccode_name ((ValaCodeNode*) f);
		_tmp85_ = _tmp84_;
		_tmp86_ = vala_ccode_identifier_new (_tmp85_);
		_tmp87_ = _tmp86_;
		vala_ccode_function_call_add_argument (_tmp83_, (ValaCCodeExpression*) _tmp87_);
		_vala_ccode_node_unref0 (_tmp87_);
		_g_free0 (_tmp85_);
		_tmp88_ = offset_call;
		_tmp89_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp88_);
		_vala_ccode_node_unref0 (offset);
		offset = _tmp89_;
		_vala_ccode_node_unref0 (offset_call);
	}
	_tmp90_ = vala_ccode_identifier_new ("gtk_widget_class_bind_template_child_full");
	_tmp91_ = _tmp90_;
	_tmp92_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp91_);
	_tmp93_ = _tmp92_;
	_vala_ccode_node_unref0 (_tmp91_);
	call = _tmp93_;
	_tmp94_ = call;
	_tmp95_ = vala_ccode_identifier_new ("GTK_WIDGET_CLASS (klass)");
	_tmp96_ = _tmp95_;
	vala_ccode_function_call_add_argument (_tmp94_, (ValaCCodeExpression*) _tmp96_);
	_vala_ccode_node_unref0 (_tmp96_);
	_tmp97_ = call;
	_tmp98_ = gtk_name;
	_tmp99_ = g_strdup_printf ("\"%s\"", _tmp98_);
	_tmp100_ = _tmp99_;
	_tmp101_ = vala_ccode_constant_new (_tmp100_);
	_tmp102_ = _tmp101_;
	vala_ccode_function_call_add_argument (_tmp97_, (ValaCCodeExpression*) _tmp102_);
	_vala_ccode_node_unref0 (_tmp102_);
	_g_free0 (_tmp100_);
	if (internal_child) {
		_tmp103_ = "TRUE";
	} else {
		_tmp103_ = "FALSE";
	}
	_tmp104_ = call;
	_tmp105_ = vala_ccode_constant_new (_tmp103_);
	_tmp106_ = _tmp105_;
	vala_ccode_function_call_add_argument (_tmp104_, (ValaCCodeExpression*) _tmp106_);
	_vala_ccode_node_unref0 (_tmp106_);
	_tmp107_ = call;
	_tmp108_ = offset;
	vala_ccode_function_call_add_argument (_tmp107_, _tmp108_);
	_tmp109_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp110_ = _tmp109_;
	_tmp111_ = call;
	vala_ccode_function_add_expression (_tmp110_, (ValaCCodeExpression*) _tmp111_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	_tmp113_ = field_class;
	_tmp114_ = vala_symbol_get_external ((ValaSymbol*) _tmp113_);
	_tmp115_ = _tmp114_;
	if (!_tmp115_) {
		ValaClass* _tmp116_;
		gboolean _tmp117_;
		gboolean _tmp118_;
		_tmp116_ = field_class;
		_tmp117_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp116_);
		_tmp118_ = _tmp117_;
		_tmp112_ = !_tmp118_;
	} else {
		_tmp112_ = FALSE;
	}
	if (_tmp112_) {
		ValaList* _tmp119_;
		ValaClass* _tmp120_;
		_tmp119_ = self->priv->current_required_app_classes;
		_tmp120_ = field_class;
		vala_collection_add ((ValaCollection*) _tmp119_, _tmp120_);
	}
	_vala_ccode_node_unref0 (call);
	_vala_ccode_node_unref0 (offset);
	_vala_code_node_unref0 (field_class);
	_vala_code_node_unref0 (child_class);
	_g_free0 (gtk_name);
	_vala_code_node_unref0 (cl);
}

static void
vala_gtk_module_real_visit_method (ValaCodeVisitor* base,
                                   ValaMethod* m)
{
	ValaGtkModule * self;
	ValaClass* cl = NULL;
	ValaClass* _tmp0_;
	ValaClass* _tmp1_;
	ValaClass* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	ValaClass* _tmp5_;
	gboolean _tmp10_ = FALSE;
	ValaMemberBinding _tmp11_;
	ValaMemberBinding _tmp12_;
	gchar* handler_name = NULL;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	ValaSignal* sig = NULL;
	ValaHashMap* _tmp17_;
	const gchar* _tmp18_;
	gpointer _tmp19_;
	ValaSignal* _tmp20_;
	ValaCCodeBaseModuleEmitContext* _tmp26_;
	ValaSignal* _tmp27_;
	self = (ValaGtkModule*) base;
	g_return_if_fail (m != NULL);
	VALA_CODE_VISITOR_CLASS (vala_gtk_module_parent_class)->visit_method ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModule), m);
	_tmp0_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (_tmp1_);
	cl = _tmp2_;
	_tmp5_ = cl;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		ValaClass* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp6_ = cl;
		_tmp7_ = vala_code_node_get_error ((ValaCodeNode*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		ValaClass* _tmp9_;
		_tmp9_ = cl;
		_tmp3_ = !vala_gtk_module_is_gtk_template (self, _tmp9_);
	}
	if (_tmp3_) {
		_vala_code_node_unref0 (cl);
		return;
	}
	_tmp11_ = vala_method_get_binding (m);
	_tmp12_ = _tmp11_;
	if (_tmp12_ != VALA_MEMBER_BINDING_INSTANCE) {
		_tmp10_ = TRUE;
	} else {
		ValaAttribute* _tmp13_;
		_tmp13_ = vala_code_node_get_attribute ((ValaCodeNode*) m, "GtkCallback");
		_tmp10_ = _tmp13_ == NULL;
	}
	if (_tmp10_) {
		_vala_code_node_unref0 (cl);
		return;
	}
	_tmp14_ = vala_symbol_get_name ((ValaSymbol*) m);
	_tmp15_ = _tmp14_;
	_tmp16_ = vala_code_node_get_attribute_string ((ValaCodeNode*) m, "GtkCallback", "name", _tmp15_);
	handler_name = _tmp16_;
	_tmp17_ = self->priv->current_handler_to_signal_map;
	_tmp18_ = handler_name;
	_tmp19_ = vala_map_get ((ValaMap*) _tmp17_, _tmp18_);
	sig = (ValaSignal*) _tmp19_;
	_tmp20_ = sig;
	if (_tmp20_ == NULL) {
		ValaSourceReference* _tmp21_;
		ValaSourceReference* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp21_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp22_ = _tmp21_;
		_tmp23_ = handler_name;
		_tmp24_ = g_strdup_printf ("could not find signal for handler `%s'", _tmp23_);
		_tmp25_ = _tmp24_;
		vala_report_error (_tmp22_, _tmp25_);
		_g_free0 (_tmp25_);
		_vala_code_node_unref0 (sig);
		_g_free0 (handler_name);
		_vala_code_node_unref0 (cl);
		return;
	}
	_tmp26_ = ((ValaCCodeBaseModule*) self)->class_init_context;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp26_);
	_tmp27_ = sig;
	if (_tmp27_ != NULL) {
		ValaSignal* _tmp28_;
		ValaCodeContext* _tmp29_;
		ValaCodeContext* _tmp30_;
		ValaMethodType* method_type = NULL;
		ValaMethodType* _tmp31_;
		ValaSignalType* signal_type = NULL;
		ValaSignal* _tmp32_;
		ValaSignalType* _tmp33_;
		ValaDelegateType* delegate_type = NULL;
		ValaSignalType* _tmp34_;
		ValaDelegateType* _tmp35_;
		ValaMethodType* _tmp36_;
		ValaDelegateType* _tmp37_;
		_tmp28_ = sig;
		_tmp29_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp30_ = _tmp29_;
		vala_code_node_check ((ValaCodeNode*) _tmp28_, _tmp30_);
		_tmp31_ = vala_method_type_new (m);
		method_type = _tmp31_;
		_tmp32_ = sig;
		_tmp33_ = vala_signal_type_new (_tmp32_);
		signal_type = _tmp33_;
		_tmp34_ = signal_type;
		_tmp35_ = vala_signal_type_get_handler_type (_tmp34_);
		delegate_type = _tmp35_;
		_tmp36_ = method_type;
		_tmp37_ = delegate_type;
		if (!vala_data_type_compatible ((ValaDataType*) _tmp36_, (ValaDataType*) _tmp37_)) {
			ValaSourceReference* _tmp38_;
			ValaSourceReference* _tmp39_;
			ValaMethodType* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			ValaDelegateType* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			ValaDelegateType* _tmp46_;
			const gchar* _tmp47_;
			const gchar* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			gchar* _tmp51_;
			gchar* _tmp52_;
			_tmp38_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
			_tmp39_ = _tmp38_;
			_tmp40_ = method_type;
			_tmp41_ = vala_code_node_to_string ((ValaCodeNode*) _tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = delegate_type;
			_tmp44_ = vala_code_node_to_string ((ValaCodeNode*) _tmp43_);
			_tmp45_ = _tmp44_;
			_tmp46_ = delegate_type;
			_tmp47_ = vala_symbol_get_name ((ValaSymbol*) m);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp46_, _tmp48_);
			_tmp50_ = _tmp49_;
			_tmp51_ = g_strdup_printf ("method `%s' is incompatible with signal `%s', expected `%s'", _tmp42_, _tmp45_, _tmp50_);
			_tmp52_ = _tmp51_;
			vala_report_error (_tmp39_, _tmp52_);
			_g_free0 (_tmp52_);
			_g_free0 (_tmp50_);
			_g_free0 (_tmp45_);
			_g_free0 (_tmp42_);
		} else {
			gchar* wrapper = NULL;
			ValaSignalType* _tmp53_;
			ValaDelegateType* _tmp54_;
			ValaDelegateType* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			ValaCCodeFunctionCall* call = NULL;
			ValaCCodeIdentifier* _tmp58_;
			ValaCCodeIdentifier* _tmp59_;
			ValaCCodeFunctionCall* _tmp60_;
			ValaCCodeFunctionCall* _tmp61_;
			ValaCCodeFunctionCall* _tmp62_;
			ValaCCodeIdentifier* _tmp63_;
			ValaCCodeIdentifier* _tmp64_;
			ValaCCodeFunctionCall* _tmp65_;
			const gchar* _tmp66_;
			gchar* _tmp67_;
			gchar* _tmp68_;
			ValaCCodeConstant* _tmp69_;
			ValaCCodeConstant* _tmp70_;
			ValaCCodeFunctionCall* _tmp71_;
			const gchar* _tmp72_;
			gchar* _tmp73_;
			gchar* _tmp74_;
			ValaCCodeIdentifier* _tmp75_;
			ValaCCodeIdentifier* _tmp76_;
			ValaCCodeFunction* _tmp77_;
			ValaCCodeFunction* _tmp78_;
			ValaCCodeFunctionCall* _tmp79_;
			_tmp53_ = signal_type;
			_tmp54_ = vala_signal_type_get_handler_type (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = vala_ccode_delegate_module_generate_delegate_wrapper ((ValaCCodeDelegateModule*) self, m, _tmp55_, (ValaCodeNode*) m);
			_tmp57_ = _tmp56_;
			_vala_code_node_unref0 (_tmp55_);
			wrapper = _tmp57_;
			_tmp58_ = vala_ccode_identifier_new ("gtk_widget_class_bind_template_callback_full");
			_tmp59_ = _tmp58_;
			_tmp60_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp59_);
			_tmp61_ = _tmp60_;
			_vala_ccode_node_unref0 (_tmp59_);
			call = _tmp61_;
			_tmp62_ = call;
			_tmp63_ = vala_ccode_identifier_new ("GTK_WIDGET_CLASS (klass)");
			_tmp64_ = _tmp63_;
			vala_ccode_function_call_add_argument (_tmp62_, (ValaCCodeExpression*) _tmp64_);
			_vala_ccode_node_unref0 (_tmp64_);
			_tmp65_ = call;
			_tmp66_ = handler_name;
			_tmp67_ = g_strdup_printf ("\"%s\"", _tmp66_);
			_tmp68_ = _tmp67_;
			_tmp69_ = vala_ccode_constant_new (_tmp68_);
			_tmp70_ = _tmp69_;
			vala_ccode_function_call_add_argument (_tmp65_, (ValaCCodeExpression*) _tmp70_);
			_vala_ccode_node_unref0 (_tmp70_);
			_g_free0 (_tmp68_);
			_tmp71_ = call;
			_tmp72_ = wrapper;
			_tmp73_ = g_strdup_printf ("G_CALLBACK(%s)", _tmp72_);
			_tmp74_ = _tmp73_;
			_tmp75_ = vala_ccode_identifier_new (_tmp74_);
			_tmp76_ = _tmp75_;
			vala_ccode_function_call_add_argument (_tmp71_, (ValaCCodeExpression*) _tmp76_);
			_vala_ccode_node_unref0 (_tmp76_);
			_g_free0 (_tmp74_);
			_tmp77_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp78_ = _tmp77_;
			_tmp79_ = call;
			vala_ccode_function_add_expression (_tmp78_, (ValaCCodeExpression*) _tmp79_);
			_vala_ccode_node_unref0 (call);
			_g_free0 (wrapper);
		}
		_vala_code_node_unref0 (delegate_type);
		_vala_code_node_unref0 (signal_type);
		_vala_code_node_unref0 (method_type);
	}
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	_vala_code_node_unref0 (sig);
	_g_free0 (handler_name);
	_vala_code_node_unref0 (cl);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_gtk_module_real_end_instance_init (ValaGTypeModule* base,
                                        ValaClass* cl)
{
	ValaGtkModule * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaCCodeFunctionCall* call = NULL;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	ValaCCodeFunctionCall* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeIdentifier* _tmp30_;
	ValaCCodeFunction* _tmp31_;
	ValaCCodeFunction* _tmp32_;
	ValaCCodeFunctionCall* _tmp33_;
	self = (ValaGtkModule*) base;
	g_return_if_fail (cl != NULL);
	if (cl == NULL) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) cl);
		_tmp3_ = _tmp2_;
		_tmp1_ = _tmp3_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !vala_gtk_module_is_gtk_template (self, cl);
	}
	if (_tmp0_) {
		return;
	}
	{
		ValaList* _req_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _req_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _req_index = 0;
		_tmp4_ = self->priv->current_required_app_classes;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_req_list = _tmp5_;
		_tmp6_ = _req_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_req_size = _tmp8_;
		_req_index = -1;
		while (TRUE) {
			ValaClass* req = NULL;
			ValaList* _tmp9_;
			gpointer _tmp10_;
			ValaCCodeFunctionCall* call = NULL;
			ValaCCodeIdentifier* _tmp11_;
			ValaCCodeIdentifier* _tmp12_;
			ValaCCodeFunctionCall* _tmp13_;
			ValaCCodeFunctionCall* _tmp14_;
			ValaCCodeFunctionCall* _tmp15_;
			ValaClass* _tmp16_;
			ValaDataType* _tmp17_;
			ValaDataType* _tmp18_;
			ValaCCodeExpression* _tmp19_;
			ValaCCodeExpression* _tmp20_;
			ValaCCodeFunction* _tmp21_;
			ValaCCodeFunction* _tmp22_;
			ValaCCodeFunctionCall* _tmp23_;
			_req_index = _req_index + 1;
			if (!(_req_index < _req_size)) {
				break;
			}
			_tmp9_ = _req_list;
			_tmp10_ = vala_list_get (_tmp9_, _req_index);
			req = (ValaClass*) _tmp10_;
			_tmp11_ = vala_ccode_identifier_new ("g_type_ensure");
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp12_);
			_tmp14_ = _tmp13_;
			_vala_ccode_node_unref0 (_tmp12_);
			call = _tmp14_;
			_tmp15_ = call;
			_tmp16_ = req;
			_tmp17_ = vala_semantic_analyzer_get_data_type_for_symbol ((ValaSymbol*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_ccode_base_module_get_type_id_expression ((ValaCCodeBaseModule*) self, _tmp18_, FALSE);
			_tmp20_ = _tmp19_;
			vala_ccode_function_call_add_argument (_tmp15_, _tmp20_);
			_vala_ccode_node_unref0 (_tmp20_);
			_vala_code_node_unref0 (_tmp18_);
			_tmp21_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp22_ = _tmp21_;
			_tmp23_ = call;
			vala_ccode_function_add_expression (_tmp22_, (ValaCCodeExpression*) _tmp23_);
			_vala_ccode_node_unref0 (call);
			_vala_code_node_unref0 (req);
		}
		_vala_iterable_unref0 (_req_list);
	}
	_tmp24_ = vala_ccode_identifier_new ("gtk_widget_init_template");
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp25_);
	_tmp27_ = _tmp26_;
	_vala_ccode_node_unref0 (_tmp25_);
	call = _tmp27_;
	_tmp28_ = call;
	_tmp29_ = vala_ccode_identifier_new ("GTK_WIDGET (self)");
	_tmp30_ = _tmp29_;
	vala_ccode_function_call_add_argument (_tmp28_, (ValaCCodeExpression*) _tmp30_);
	_vala_ccode_node_unref0 (_tmp30_);
	_tmp31_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp32_ = _tmp31_;
	_tmp33_ = call;
	vala_ccode_function_add_expression (_tmp32_, (ValaCCodeExpression*) _tmp33_);
	_vala_ccode_node_unref0 (call);
}

ValaGtkModule*
vala_gtk_module_construct (GType object_type)
{
	ValaGtkModule* self = NULL;
	self = (ValaGtkModule*) vala_gsignal_module_construct (object_type);
	return self;
}

ValaGtkModule*
vala_gtk_module_new (void)
{
	return vala_gtk_module_construct (VALA_TYPE_GTK_MODULE);
}

static void
vala_gtk_module_class_init (ValaGtkModuleClass * klass,
                            gpointer klass_data)
{
	vala_gtk_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_gtk_module_finalize;
	g_type_class_adjust_private_offset (klass, &ValaGtkModule_private_offset);
	((ValaGTypeModuleClass *) klass)->generate_class_init = (void (*) (ValaGTypeModule*, ValaClass*)) vala_gtk_module_real_generate_class_init;
	((ValaCodeVisitorClass *) klass)->visit_property = (void (*) (ValaCodeVisitor*, ValaProperty*)) vala_gtk_module_real_visit_property;
	((ValaCodeVisitorClass *) klass)->visit_field = (void (*) (ValaCodeVisitor*, ValaField*)) vala_gtk_module_real_visit_field;
	((ValaCodeVisitorClass *) klass)->visit_method = (void (*) (ValaCodeVisitor*, ValaMethod*)) vala_gtk_module_real_visit_method;
	((ValaGTypeModuleClass *) klass)->end_instance_init = (void (*) (ValaGTypeModule*, ValaClass*)) vala_gtk_module_real_end_instance_init;
}

static void
vala_gtk_module_instance_init (ValaGtkModule * self,
                               gpointer klass)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	GEqualFunc _tmp6_;
	ValaHashMap* _tmp7_;
	GEqualFunc _tmp8_;
	ValaArrayList* _tmp9_;
	self->priv = vala_gtk_module_get_instance_private (self);
	self->priv->type_id_to_vala_map = NULL;
	self->priv->cclass_to_vala_map = NULL;
	self->priv->gresource_to_file_map = NULL;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALA_TYPE_SIGNAL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_, _tmp1_, _tmp2_);
	self->priv->current_handler_to_signal_map = _tmp3_;
	_tmp4_ = g_str_hash;
	_tmp5_ = g_str_equal;
	_tmp6_ = g_direct_equal;
	_tmp7_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALA_TYPE_CLASS, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_, _tmp5_, _tmp6_);
	self->priv->current_child_to_class_map = _tmp7_;
	_tmp8_ = g_direct_equal;
	_tmp9_ = vala_array_list_new (VALA_TYPE_CLASS, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp8_);
	self->priv->current_required_app_classes = (ValaList*) _tmp9_;
}

static void
vala_gtk_module_finalize (ValaCodeVisitor * obj)
{
	ValaGtkModule * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_GTK_MODULE, ValaGtkModule);
	_vala_map_unref0 (self->priv->type_id_to_vala_map);
	_vala_map_unref0 (self->priv->cclass_to_vala_map);
	_vala_map_unref0 (self->priv->gresource_to_file_map);
	_vala_map_unref0 (self->priv->current_handler_to_signal_map);
	_vala_map_unref0 (self->priv->current_child_to_class_map);
	_vala_iterable_unref0 (self->priv->current_required_app_classes);
	VALA_CODE_VISITOR_CLASS (vala_gtk_module_parent_class)->finalize (obj);
}

GType
vala_gtk_module_get_type (void)
{
	static volatile gsize vala_gtk_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gtk_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGtkModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gtk_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGtkModule), 0, (GInstanceInitFunc) vala_gtk_module_instance_init, NULL };
		GType vala_gtk_module_type_id;
		vala_gtk_module_type_id = g_type_register_static (VALA_TYPE_GSIGNAL_MODULE, "ValaGtkModule", &g_define_type_info, 0);
		ValaGtkModule_private_offset = g_type_add_instance_private (vala_gtk_module_type_id, sizeof (ValaGtkModulePrivate));
		g_once_init_leave (&vala_gtk_module_type_id__volatile, vala_gtk_module_type_id);
	}
	return vala_gtk_module_type_id__volatile;
}

