/*
 * (C) Copyright 2017 Icenowy Zheng <icenowy@aosc.io>
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#ifndef _SUNXI_CPU_SUN50I_H6_H
#define _SUNXI_CPU_SUN50I_H6_H

#define SUNXI_SRAM_A1_BASE		CONFIG_SUNXI_SRAM_ADDRESS
#define SUNXI_SRAM_C_BASE		0x00028000
#define SUNXI_SRAM_A2_BASE		0x00100000

#define SUNXI_DE3_BASE			0x01000000
#define SUNXI_SS_BASE			0x01904000
#define SUNXI_EMCE_BASE			0x01905000

#define SUNXI_SRAMC_BASE		0x03000000
#define SUNXI_CCM_BASE			0x03001000
#define SUNXI_DMA_BASE			0x03002000
/* SID address space starts at 0x03006000, but e-fuse is at offset 0x200 */
#define SUNXI_SIDC_BASE			0x03006000
#define SUNXI_SID_BASE			0x03006200
#define SUNXI_TIMER_BASE		0x03009000
#define SUNXI_PIO_BASE			0x0300B000
#define SUNXI_PSI_BASE			0x0300C000

#define SUNXI_GIC400_BASE		0x03020000
#define SUNXI_IOMMU_BASE		0x030F0000

#define SUNXI_DRAM_COM_BASE		0x04002000
#define SUNXI_DRAM_CTL0_BASE		0x04003000
#define SUNXI_DRAM_PHY0_BASE		0x04005000
#define SUNXI_NFC_BASE			0x04011000
#define SUNXI_MMC0_BASE			0x04020000
#define SUNXI_MMC1_BASE			0x04021000
#define SUNXI_MMC2_BASE			0x04022000

#define SUNXI_UART0_BASE		0x05000000
#define SUNXI_UART1_BASE		0x05000400
#define SUNXI_UART2_BASE		0x05000800
#define SUNXI_UART3_BASE		0x05000C00
#define SUNXI_TWI0_BASE			0x05002000
#define SUNXI_TWI1_BASE			0x05002400
#define SUNXI_TWI2_BASE			0x05002800
#define SUNXI_TWI3_BASE			0x05002C00
#define SUNXI_SPI0_BASE			0x05010000
#define SUNXI_SPI1_BASE			0x05011000
#define SUNXI_GMAC_BASE			0x05020000
#define SUNXI_USB0_BASE			0x05100000
#define SUNXI_XHCI_BASE			0x05200000
#define SUNXI_USB3_BASE			0x05311000
#define SUNXI_PCIE_BASE			0x05400000

#define SUNXI_HDMI_BASE			0x06000000
#define SUNXI_TCON_TOP_BASE		0x06510000
#define SUNXI_TCON_LCD0_BASE		0x06511000
#define SUNXI_TCON_TV0_BASE		0x06515000

#define SUNXI_RTC_BASE			0x07000000
#define SUNXI_R_CPUCFG_BASE		0x07000400
#define SUNXI_PRCM_BASE			0x07010000
#define SUNXI_R_PIO_BASE		0x07022000
#define SUNXI_R_UART_BASE		0x07080000
#define SUNXI_R_TWI_BASE		0x07081400

#ifndef __ASSEMBLY__
void sunxi_board_init(void);
void sunxi_reset(void);
int sunxi_get_sid(unsigned int *sid);
#endif

#endif /* _SUNXI_CPU_SUN9I_H */
