/* valabooleanliteral.c generated by valac, the Vala compiler
 * generated from valabooleanliteral.vala, do not modify */

/* valabooleanliteral.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

struct _ValaBooleanLiteralPrivate {
	gboolean _value;
};

static gint ValaBooleanLiteral_private_offset;
static gpointer vala_boolean_literal_parent_class = NULL;

static void vala_boolean_literal_real_accept (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static gchar* vala_boolean_literal_real_to_string (ValaCodeNode* base);
static gboolean vala_boolean_literal_real_is_pure (ValaExpression* base);
static gboolean vala_boolean_literal_real_check (ValaCodeNode* base,
                                          ValaCodeContext* context);
static void vala_boolean_literal_real_emit (ValaCodeNode* base,
                                     ValaCodeGenerator* codegen);
static void vala_boolean_literal_finalize (ValaCodeNode * obj);

static inline gpointer
vala_boolean_literal_get_instance_private (ValaBooleanLiteral* self)
{
	return G_STRUCT_MEMBER_P (self, ValaBooleanLiteral_private_offset);
}

/**
 * Creates a new boolean literal.
 *
 * @param b      boolean value
 * @param source reference to source code
 * @return       newly created boolean literal
 */
ValaBooleanLiteral*
vala_boolean_literal_construct (GType object_type,
                                gboolean b,
                                ValaSourceReference* source)
{
	ValaBooleanLiteral* self = NULL;
	self = (ValaBooleanLiteral*) vala_literal_construct (object_type);
	vala_boolean_literal_set_value (self, b);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source);
	return self;
}

ValaBooleanLiteral*
vala_boolean_literal_new (gboolean b,
                          ValaSourceReference* source)
{
	return vala_boolean_literal_construct (VALA_TYPE_BOOLEAN_LITERAL, b, source);
}

static void
vala_boolean_literal_real_accept (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaBooleanLiteral * self;
	self = (ValaBooleanLiteral*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_boolean_literal (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gchar*
vala_boolean_literal_real_to_string (ValaCodeNode* base)
{
	ValaBooleanLiteral * self;
	gboolean _tmp0_;
	gchar* result = NULL;
	self = (ValaBooleanLiteral*) base;
	_tmp0_ = self->priv->_value;
	if (_tmp0_) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("true");
		result = _tmp1_;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("false");
		result = _tmp2_;
		return result;
	}
}

static gboolean
vala_boolean_literal_real_is_pure (ValaExpression* base)
{
	ValaBooleanLiteral * self;
	gboolean result = FALSE;
	self = (ValaBooleanLiteral*) base;
	result = TRUE;
	return result;
}

static gboolean
vala_boolean_literal_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context)
{
	ValaBooleanLiteral * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaDataType* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean result = FALSE;
	self = (ValaBooleanLiteral*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_->bool_type;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp6_);
	_tmp7_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp8_ = _tmp7_;
	result = !_tmp8_;
	return result;
}

static void
vala_boolean_literal_real_emit (ValaCodeNode* base,
                                ValaCodeGenerator* codegen)
{
	ValaBooleanLiteral * self;
	self = (ValaBooleanLiteral*) base;
	g_return_if_fail (codegen != NULL);
	vala_code_visitor_visit_boolean_literal ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

gboolean
vala_boolean_literal_get_value (ValaBooleanLiteral* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_value;
	return result;
}

void
vala_boolean_literal_set_value (ValaBooleanLiteral* self,
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_value = value;
}

static void
vala_boolean_literal_class_init (ValaBooleanLiteralClass * klass,
                                 gpointer klass_data)
{
	vala_boolean_literal_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_boolean_literal_finalize;
	g_type_class_adjust_private_offset (klass, &ValaBooleanLiteral_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_boolean_literal_real_accept;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_boolean_literal_real_to_string;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_boolean_literal_real_is_pure;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_boolean_literal_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_boolean_literal_real_emit;
}

static void
vala_boolean_literal_instance_init (ValaBooleanLiteral * self,
                                    gpointer klass)
{
	self->priv = vala_boolean_literal_get_instance_private (self);
}

static void
vala_boolean_literal_finalize (ValaCodeNode * obj)
{
	ValaBooleanLiteral * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_BOOLEAN_LITERAL, ValaBooleanLiteral);
	VALA_CODE_NODE_CLASS (vala_boolean_literal_parent_class)->finalize (obj);
}

/**
 * Represents a literal boolean, i.e. true or false.
 */
GType
vala_boolean_literal_get_type (void)
{
	static volatile gsize vala_boolean_literal_type_id__volatile = 0;
	if (g_once_init_enter (&vala_boolean_literal_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaBooleanLiteralClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_boolean_literal_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaBooleanLiteral), 0, (GInstanceInitFunc) vala_boolean_literal_instance_init, NULL };
		GType vala_boolean_literal_type_id;
		vala_boolean_literal_type_id = g_type_register_static (VALA_TYPE_LITERAL, "ValaBooleanLiteral", &g_define_type_info, 0);
		ValaBooleanLiteral_private_offset = g_type_add_instance_private (vala_boolean_literal_type_id, sizeof (ValaBooleanLiteralPrivate));
		g_once_init_leave (&vala_boolean_literal_type_id__volatile, vala_boolean_literal_type_id);
	}
	return vala_boolean_literal_type_id__volatile;
}

