#!/bin/bash

#Exit on failures
set -e

set -x


JOB_NAME=${TRAVIS_JOB_NAME:- Mageia 7}

arr=($JOB_NAME)
os_name=${arr[0]:-Mageia}
release=${arr[1]:-7}

COMMON_MESON_ARGS="-Dtest_dirty_git=${DIRTY_REPO_CHECK:-true}"


pushd /builddir/

# Build the code under GCC and run standard tests
meson --buildtype=debug \
      $COMMON_MESON_ARGS \
      travis

set +e
ninja -C travis test
if [ $? != 0 ]; then
    if [ "x$TRAVIS_JOB_NAME" != "x" ]; then
        cat travis/meson-logs/testlog.txt
    fi
    exit $ret
fi
set -e

