.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XGrabKeyboard __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XGrabKeyboard, XUngrabKeyboard \- grab the keyboard
.SH SYNTAX
.HP
int XGrabKeyboard\^(\^Display *\fIdisplay\fP\^, Window \fIgrab_window\fP\^,
Bool \fIowner_events\fP\^, int \fIpointer_mode\fP\^, int
\fIkeyboard_mode\fP\^, Time \fItime\fP\^);
.HP
int XUngrabKeyboard\^(\^Display *\fIdisplay\fP\^, Time \fItime\fP\^);
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIgrab_window\fP 1i
Specifies the grab window.
.IP \fIkeyboard_mode\fP 1i
Specifies further processing of keyboard events.
You can pass
.B GrabModeSync
or
.BR GrabModeAsync .
.IP \fIowner_events\fP 1i
Specifies a Boolean value that indicates whether the keyboard events
are to be reported as usual.
.IP \fIpointer_mode\fP 1i
Specifies further processing of pointer events.
You can pass
.B GrabModeSync
or
.BR GrabModeAsync .
.IP \fItime\fP 1i
Specifies the time.
You can pass either a timestamp or
.BR CurrentTime .
.SH DESCRIPTION
The
.B XGrabKeyboard
function actively grabs control of the keyboard and generates
.B FocusIn
and
.B FocusOut
events.
Further key events are reported only to the
grabbing client.
.B XGrabKeyboard
overrides any active keyboard grab by this client.
If owner_events is
.BR False ,
all generated key events are reported with
respect to grab_window.
If owner_events is
.B True
and if a generated
key event would normally be reported to this client, it is reported
normally; otherwise, the event is reported with respect to the
grab_window.
Both
.B KeyPress
and
.B KeyRelease
events are always reported,
independent of any event selection made by the client.
.LP
If the keyboard_mode argument is
.BR GrabModeAsync ,
keyboard event processing continues
as usual.
If the keyboard is currently frozen by this client,
then processing of keyboard events is resumed.
If the keyboard_mode  argument is
.BR GrabModeSync ,
the state of the keyboard (as seen by client applications) appears to freeze,
and the X server generates no further keyboard events until the
grabbing client issues a releasing
.B XAllowEvents
call or until the keyboard grab is released.
Actual keyboard changes are not lost while the keyboard is frozen;
they are simply queued in the server for later processing.
.LP
If pointer_mode is
.BR GrabModeAsync ,
pointer event processing is unaffected
by activation of the grab.
If pointer_mode is
.BR GrabModeSync ,
the state of the pointer (as seen by client applications) appears to freeze,
and the X server generates no further pointer events
until the grabbing client issues a releasing
.B XAllowEvents
call or until the keyboard grab is released.
Actual pointer changes are not lost while the pointer is frozen;
they are simply queued in the server for later processing.
.LP
If the keyboard is actively grabbed by some other client,
.B XGrabKeyboard
fails and returns
.BR AlreadyGrabbed .
If grab_window is not viewable,
it fails and returns
.BR GrabNotViewable .
If the keyboard is frozen by an active grab of another client,
it fails and returns
.BR GrabFrozen .
If the specified time is earlier than the last-keyboard-grab time
or later than the current X server time,
it fails and returns
.BR GrabInvalidTime .
Otherwise, the last-keyboard-grab time is set to the specified time
.Pn ( CurrentTime
is replaced by the current X server time).
.LP
.B XGrabKeyboard
can generate
.B BadValue
and
.B BadWindow
errors.
.LP
The
.B XUngrabKeyboard
function
releases the keyboard and any queued events if this client has it actively grabbed from
either
.B XGrabKeyboard
or
.BR XGrabKey .
.B XUngrabKeyboard
does not release the keyboard and any queued events
if the specified time is earlier than
the last-keyboard-grab time or is later than the current X server time.
It also generates
.B FocusIn
and
.B FocusOut
events.
The X server automatically performs an
.B UngrabKeyboard
request if the event window for an
active keyboard grab becomes not viewable.
.SH DIAGNOSTICS
.TP 1i
.B BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.
Any argument defined as a set of
alternatives can generate this error.
.TP 1i
.B BadWindow
A value for a Window argument does not name a defined Window.
.SH "SEE ALSO"
XAllowEvents(__libmansuffix__),
XGrabButton(__libmansuffix__),
XGrabKey(__libmansuffix__),
XGrabPointer(__libmansuffix__)
.br
\fI\*(xL\fP
