/*
 * Decompiled with CFR 0.152.
 */
package com.google.debugging.sourcemap;

import com.google.common.collect.ImmutableList;
import com.google.debugging.sourcemap.SourceMapObject;
import com.google.debugging.sourcemap.SourceMapParseException;
import com.google.debugging.sourcemap.SourceMapSection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsType;

public class SourceMapObjectParserJs {
    @JsMethod(namespace="<global>", name="JSON.parse")
    private static native Object parseJson(String var0);

    @JsMethod(namespace="<global>", name="Object.keys")
    private static native String[] keys(Object var0);

    @JsMethod
    public static native Object get(Object var0, String var1);

    public static SourceMapObject parse(String contents) throws SourceMapParseException {
        String[] keys;
        SourceMapObject.Builder builder = SourceMapObject.builder();
        Object jsonInstance = null;
        try {
            jsonInstance = SourceMapObjectParserJs.parseJson(contents);
        }
        catch (Exception ex) {
            throw new SourceMapParseException("JSON parse exception: " + ex);
        }
        JsonMap sourceMap = (JsonMap)jsonInstance;
        builder.setVersion(sourceMap.version);
        builder.setFile(sourceMap.file);
        builder.setLineCount(-1);
        builder.setMappings(sourceMap.mappings);
        builder.setSourceRoot(sourceMap.sourceRoot);
        if (sourceMap.sections != null) {
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            for (Section section : sourceMap.sections) {
                listBuilder.add(SourceMapObjectParserJs.buildSection(section));
            }
            builder.setSections((List<SourceMapSection>)((Object)listBuilder.build()));
        } else {
            builder.setSections(null);
        }
        builder.setSources(sourceMap.sources);
        builder.setNames(sourceMap.names);
        LinkedHashMap<String, Object> extensions = new LinkedHashMap<String, Object>();
        for (String key : keys = SourceMapObjectParserJs.keys(sourceMap)) {
            if (!key.startsWith("x_")) continue;
            extensions.put(key, SourceMapObjectParserJs.get(sourceMap, key));
        }
        builder.setExtensions(Collections.unmodifiableMap(extensions));
        return builder.build();
    }

    private static SourceMapSection buildSection(Section section) throws SourceMapParseException {
        int line = section.offset.line;
        int column = section.offset.column;
        if (section.map != null && section.url != null) {
            throw new SourceMapParseException("Invalid map format: section may not have both 'map' and 'url'");
        }
        if (section.url != null) {
            return SourceMapSection.forURL(section.url, line, column);
        }
        if (section.map != null) {
            return SourceMapSection.forMap(String.valueOf(section.map), line, column);
        }
        throw new SourceMapParseException("Invalid map format: section must have either 'map' or 'url'");
    }

    @JsType(isNative=true, name="Object", namespace="<global>")
    private static class Offset {
        int line;
        int column;

        private Offset() {
        }
    }

    @JsType(isNative=true, name="Object", namespace="<global>")
    private static class Section {
        Offset offset;
        String url;
        String map;

        private Section() {
        }
    }

    @JsType(isNative=true, name="Object", namespace="<global>")
    private static class JsonMap {
        int version;
        String file;
        String mappings;
        String sourceRoot;
        Section[] sections;
        String[] sources;
        String[] names;

        private JsonMap() {
        }
    }
}

