/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import java.util.ArrayList;

final class JsIterables {
    static final JSType getElementType(JSType iterableOrIterator, JSTypeRegistry typeRegistry) {
        TemplateTypeMap templateTypeMap = iterableOrIterator.autobox().getTemplateTypeMap();
        if (templateTypeMap.hasTemplateKey(typeRegistry.getIterableTemplate())) {
            return templateTypeMap.getResolvedTemplateType(typeRegistry.getIterableTemplate());
        }
        if (templateTypeMap.hasTemplateKey(typeRegistry.getIteratorTemplate())) {
            return templateTypeMap.getResolvedTemplateType(typeRegistry.getIteratorTemplate());
        }
        if (templateTypeMap.hasTemplateKey(typeRegistry.getAsyncIterableTemplate())) {
            return templateTypeMap.getResolvedTemplateType(typeRegistry.getAsyncIterableTemplate());
        }
        if (templateTypeMap.hasTemplateKey(typeRegistry.getAsyncIteratorTemplate())) {
            return templateTypeMap.getResolvedTemplateType(typeRegistry.getAsyncIteratorTemplate());
        }
        return typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
    }

    static final JSType createIterableTypeOf(JSType elementType, JSTypeRegistry typeRegistry) {
        return typeRegistry.createTemplatizedType(typeRegistry.getNativeObjectType(JSTypeNative.ITERABLE_TYPE), elementType);
    }

    static final MaybeBoxedIterableOrAsyncIterable maybeBoxIterableOrAsyncIterable(JSType type, JSTypeRegistry typeRegistry) {
        ArrayList<JSType> templatedTypes = new ArrayList<JSType>();
        if (type.isUnionType()) {
            for (JSType alt : type.toMaybeUnionType().getAlternates()) {
                alt = alt.isBoxableScalar() ? alt.autoboxesTo() : alt;
                boolean isIterable = alt.isSubtypeOf(typeRegistry.getNativeType(JSTypeNative.ITERABLE_TYPE));
                boolean isAsyncIterable = alt.isSubtypeOf(typeRegistry.getNativeType(JSTypeNative.ASYNC_ITERABLE_TYPE));
                if (!isIterable && !isAsyncIterable) {
                    return new MaybeBoxedIterableOrAsyncIterable(null, alt);
                }
                JSTypeNative iterableType = isAsyncIterable ? JSTypeNative.ASYNC_ITERABLE_TYPE : JSTypeNative.ITERABLE_TYPE;
                templatedTypes.add(alt.getInstantiatedTypeArgument(typeRegistry.getNativeType(iterableType)));
            }
        } else {
            JSType autoboxedType = type.isBoxableScalar() ? type.autoboxesTo() : type;
            boolean isIterable = autoboxedType.isSubtypeOf(typeRegistry.getNativeType(JSTypeNative.ITERABLE_TYPE));
            boolean isAsyncIterable = autoboxedType.isSubtypeOf(typeRegistry.getNativeType(JSTypeNative.ASYNC_ITERABLE_TYPE));
            if (!isIterable && !isAsyncIterable) {
                return new MaybeBoxedIterableOrAsyncIterable(null, autoboxedType);
            }
            JSTypeNative iterableType = isAsyncIterable ? JSTypeNative.ASYNC_ITERABLE_TYPE : JSTypeNative.ITERABLE_TYPE;
            templatedTypes.add(autoboxedType.getInstantiatedTypeArgument(typeRegistry.getNativeType(iterableType)));
        }
        return new MaybeBoxedIterableOrAsyncIterable(typeRegistry.createUnionType(templatedTypes), null);
    }

    private JsIterables() {
    }

    static final class MaybeBoxedIterableOrAsyncIterable {
        private final JSType templatedType;
        private final JSType mismatchType;

        private MaybeBoxedIterableOrAsyncIterable(JSType templatedType, JSType mismatchType) {
            this.templatedType = templatedType;
            this.mismatchType = mismatchType;
        }

        JSType getTemplatedType() {
            if (!this.isMatch()) {
                throw new IllegalStateException("Type was not boxable to iterable or async iterable!");
            }
            return this.templatedType;
        }

        JSType getMismatchType() {
            return this.mismatchType;
        }

        JSType orElse(JSType type) {
            if (this.isMatch()) {
                return this.templatedType;
            }
            return type;
        }

        boolean isMatch() {
            return this.templatedType != null;
        }
    }
}

