/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.MakeDeclaredNamesUnique;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class Normalize
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final boolean assertOnChange;

    Normalize(AbstractCompiler compiler, boolean assertOnChange) {
        this.compiler = compiler;
        this.assertOnChange = assertOnChange;
    }

    static void normalizeSyntheticCode(AbstractCompiler compiler, Node js, String prefix) {
        NodeTraversal.traverse(compiler, js, new NormalizeStatements(compiler, false));
        NodeTraversal.traverse(compiler, js, new MakeDeclaredNamesUnique(new MakeDeclaredNamesUnique.BoilerplateRenamer(compiler.getCodingConvention(), compiler.getUniqueNameIdSupplier(), prefix)));
    }

    static Node parseAndNormalizeTestCode(AbstractCompiler compiler, String code) {
        Node js = compiler.parseTestCode(code);
        NodeTraversal.traverse(compiler, js, new NormalizeStatements(compiler, false));
        return js;
    }

    private void reportCodeChange(String changeDescription, Node n) {
        if (this.assertOnChange) {
            throw new IllegalStateException("Normalize constraints violated:\n" + changeDescription);
        }
        this.compiler.reportChangeToEnclosingScope(n);
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseRoots(this.compiler, new NormalizeStatements(this.compiler, this.assertOnChange), externs, root);
        this.removeDuplicateDeclarations(externs, root);
        MakeDeclaredNamesUnique renamer = new MakeDeclaredNamesUnique();
        NodeTraversal.traverseRoots(this.compiler, renamer, externs, root);
        new PropagateConstantAnnotationsOverVars(this.compiler, this.assertOnChange).process(externs, root);
        FindExposeAnnotations findExposeAnnotations = new FindExposeAnnotations();
        NodeTraversal.traverse(this.compiler, root, findExposeAnnotations);
        if (!findExposeAnnotations.exposedProperties.isEmpty()) {
            NodeTraversal.traverse(this.compiler, root, new RewriteExposedProperties(findExposeAnnotations.exposedProperties));
        }
        if (!this.compiler.getLifeCycleStage().isNormalized()) {
            this.compiler.setLifeCycleStage(AbstractCompiler.LifeCycleStage.NORMALIZED);
        }
    }

    private void removeDuplicateDeclarations(Node externs, Node root) {
        ScopeTicklingCallback tickler = new ScopeTicklingCallback();
        SyntacticScopeCreator scopeCreator = new SyntacticScopeCreator(this.compiler, new DuplicateDeclarationHandler());
        NodeTraversal t = new NodeTraversal(this.compiler, tickler, scopeCreator);
        t.traverseRoots(externs, root);
    }

    private static final class ScopeTicklingCallback
    implements NodeTraversal.ScopedCallback {
        private ScopeTicklingCallback() {
        }

        @Override
        public void enterScope(NodeTraversal t) {
            t.getScope();
        }

        @Override
        public void exitScope(NodeTraversal t) {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
        }
    }

    private final class DuplicateDeclarationHandler
    implements SyntacticScopeCreator.RedeclarationHandler {
        private final Set<Var> hasOkDuplicateDeclaration = new HashSet<Var>();

        private DuplicateDeclarationHandler() {
        }

        @Override
        public void onRedeclaration(Scope s, String name, Node n, CompilerInput input) {
            Preconditions.checkState(n.isName());
            Node parent = n.getParent();
            Var v = (Var)s.getVar(name);
            if (s.isGlobal() && v.isExtern() && !input.isExtern() && this.hasOkDuplicateDeclaration.add(v)) {
                return;
            }
            if (parent.isFunction()) {
                if (v.getParentNode().isVar()) {
                    s.undeclare(v);
                    s.declare(name, n, v.input);
                    this.replaceVarWithAssignment(v.getNameNode(), v.getParentNode(), v.getParentNode().getParent());
                }
            } else if (parent.isVar()) {
                Preconditions.checkState(parent.hasOneChild());
                this.replaceVarWithAssignment(n, parent, parent.getParent());
            }
        }

        private void replaceVarWithAssignment(Node n, Node parent, Node grandparent) {
            if (n.hasChildren()) {
                parent.removeChild(n);
                Node value = n.getFirstChild();
                n.removeChild(value);
                Node replacement = IR.assign(n, value);
                replacement.setJSDocInfo(parent.getJSDocInfo());
                replacement.useSourceInfoIfMissingFrom(parent);
                Node statement = NodeUtil.newExpr(replacement);
                grandparent.replaceChild(parent, statement);
                Normalize.this.reportCodeChange("Duplicate VAR declaration", statement);
            } else {
                if (NodeUtil.isStatementBlock(grandparent)) {
                    grandparent.removeChild(parent);
                } else if (grandparent.isForIn() || grandparent.isForOf()) {
                    parent.removeChild(n);
                    grandparent.replaceChild(parent, n);
                } else {
                    Preconditions.checkState(grandparent.isLabel(), grandparent);
                }
                Normalize.this.reportCodeChange("Duplicate VAR declaration", grandparent);
            }
        }
    }

    static class NormalizeStatements
    implements NodeTraversal.Callback {
        private final AbstractCompiler compiler;
        private final boolean assertOnChange;

        NormalizeStatements(AbstractCompiler compiler, boolean assertOnChange) {
            this.compiler = compiler;
            this.assertOnChange = assertOnChange;
        }

        private void reportCodeChange(String changeDescription, Node n) {
            if (this.assertOnChange) {
                throw new IllegalStateException("Normalize constraints violated:\n" + changeDescription);
            }
            this.compiler.reportChangeToEnclosingScope(n);
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            this.doStatementNormalizations(n);
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case WHILE: {
                    Node expr = n.getFirstChild();
                    n.setToken(Token.FOR);
                    Node empty = IR.empty();
                    empty.useSourceInfoIfMissingFrom(n);
                    n.addChildBefore(empty, expr);
                    n.addChildAfter(empty.cloneNode(), expr);
                    this.reportCodeChange("WHILE node", n);
                    break;
                }
                case FUNCTION: {
                    if (!NormalizeStatements.visitFunction(n, this.compiler)) break;
                    this.reportCodeChange("Function declaration", n);
                    break;
                }
                case EXPORT: {
                    this.splitExportDeclaration(n);
                    break;
                }
                case NAME: 
                case STRING: 
                case GETTER_DEF: 
                case SETTER_DEF: {
                    this.annotateConstantsByConvention(n, parent);
                    break;
                }
                case CAST: {
                    this.compiler.reportChangeToEnclosingScope(n);
                    parent.replaceChild(n, n.removeFirstChild());
                    break;
                }
            }
        }

        private void annotateConstantsByConvention(Node n, Node parent) {
            boolean isMarkedConstant;
            boolean isProperty;
            Preconditions.checkState(n.isName() || n.isString() || n.isStringKey() || n.isGetterDef() || n.isSetterDef());
            if (this.compiler.getLifeCycleStage().isNormalizedObfuscated()) {
                return;
            }
            boolean isObjLitKey = NodeUtil.mayBeObjectLitKey(n);
            boolean bl = isProperty = isObjLitKey || parent.isGetProp() && parent.getLastChild() == n;
            if ((n.isName() || isProperty) && !(isMarkedConstant = n.getBooleanProp(Node.IS_CONSTANT_NAME)) && NodeUtil.isConstantByConvention(this.compiler.getCodingConvention(), n)) {
                if (this.assertOnChange) {
                    String name = n.getString();
                    throw new IllegalStateException("Unexpected const change.\n  name: " + name + "\n  parent:" + n.getParent().toStringTree());
                }
                n.putBooleanProp(Node.IS_CONSTANT_NAME, true);
            }
        }

        private void splitExportDeclaration(Node n) {
            if (n.getBooleanProp(Node.EXPORT_DEFAULT)) {
                return;
            }
            Node c = n.getFirstChild();
            if (NodeUtil.isDeclaration(c)) {
                Collection<Node> names;
                n.removeChild(c);
                Node exportSpecs = new Node(Token.EXPORT_SPECS).srcref(n);
                n.addChildToFront(exportSpecs);
                if (c.isClass() || c.isFunction()) {
                    names = Collections.singleton(c.getFirstChild());
                    n.getParent().addChildBefore(c, n);
                } else {
                    names = NodeUtil.findLhsNodesInNode(c);
                    for (Node child : c.children()) {
                        c.removeChild(child);
                        Node newDeclaration = new Node(c.getToken(), child).srcref(n);
                        n.getParent().addChildBefore(newDeclaration, n);
                    }
                }
                for (Node name : names) {
                    Node exportSpec = new Node(Token.EXPORT_SPEC).srcref(name);
                    exportSpec.addChildToFront(name.cloneNode());
                    exportSpec.addChildToFront(name.cloneNode());
                    exportSpecs.addChildToBack(exportSpec);
                }
                this.compiler.reportChangeToEnclosingScope(n.getParent());
            }
        }

        static boolean visitFunction(Node n, AbstractCompiler compiler) {
            Preconditions.checkState(n.isFunction(), n);
            if (NodeUtil.isFunctionDeclaration(n) && !NodeUtil.isHoistedFunctionDeclaration(n)) {
                NormalizeStatements.rewriteFunctionDeclaration(n, compiler);
                return true;
            }
            if (n.isFunction() && !NodeUtil.getFunctionBody(n).isBlock()) {
                Node returnValue = NodeUtil.getFunctionBody(n);
                Node body = IR.block(IR.returnNode(returnValue.detach()));
                body.useSourceInfoIfMissingFromForTree(returnValue);
                n.addChildToBack(body);
                compiler.reportChangeToEnclosingScope(body);
            }
            return false;
        }

        private static void rewriteFunctionDeclaration(Node n, AbstractCompiler compiler) {
            Node oldNameNode = n.getFirstChild();
            Node fnNameNode = oldNameNode.cloneNode();
            Node var = IR.var(fnNameNode).srcref(n);
            oldNameNode.setString("");
            compiler.reportChangeToEnclosingScope(oldNameNode);
            Node parent = n.getParent();
            parent.removeChild(n);
            parent.addChildToFront(var);
            compiler.reportChangeToEnclosingScope(var);
            fnNameNode.addChildToFront(n);
        }

        private void doStatementNormalizations(Node n) {
            if (n.isLabel()) {
                this.normalizeLabels(n);
            }
            if (NodeUtil.isStatementBlock(n) || n.isLabel()) {
                this.extractForInitializer(n, null, null);
            }
            if (NodeUtil.isStatementBlock(n)) {
                this.splitVarDeclarations(n);
            }
            if (n.isFunction()) {
                this.moveNamedFunctions(n.getLastChild());
            }
            if (NodeUtil.isCompoundAssignmentOp(n)) {
                this.normalizeAssignShorthand(n);
            }
        }

        private void normalizeLabels(Node n) {
            Preconditions.checkArgument(n.isLabel());
            Node last = n.getLastChild();
            switch (last.getToken()) {
                case WHILE: 
                case LABEL: 
                case BLOCK: 
                case FOR: 
                case FOR_IN: 
                case FOR_OF: 
                case FOR_AWAIT_OF: 
                case DO: {
                    return;
                }
            }
            Node block = IR.block();
            block.useSourceInfoIfMissingFrom(last);
            n.replaceChild(last, block);
            block.addChildToFront(last);
            this.reportCodeChange("LABEL normalization", n);
        }

        private void extractForInitializer(Node n, Node before, Node beforeParent) {
            Node c = n.getFirstChild();
            while (c != null) {
                Node next = c.getNext();
                Node insertBefore = before == null ? c : before;
                Node insertBeforeParent = before == null ? n : beforeParent;
                switch (c.getToken()) {
                    case LABEL: {
                        this.extractForInitializer(c, insertBefore, insertBeforeParent);
                        break;
                    }
                    case FOR_IN: 
                    case FOR_OF: 
                    case FOR_AWAIT_OF: {
                        Node first = c.getFirstChild();
                        if (!first.isVar()) break;
                        Node lhs = first.getFirstChild();
                        if (lhs.isDestructuringLhs()) {
                            List<Node> lhsNodes = NodeUtil.findLhsNodesInNode(lhs);
                            for (Node name : lhsNodes) {
                                Preconditions.checkState(name.isName(), "lhs in destructuring declaration should be a simple name.", (Object)name);
                                Node newName = IR.name(name.getString()).srcref(name);
                                Node newVar = IR.var(newName).srcref(name);
                                insertBeforeParent.addChildBefore(newVar, insertBefore);
                            }
                            Node destructuringPattern = lhs.removeFirstChild();
                            c.replaceChild(first, destructuringPattern);
                        } else {
                            Node newStatement = first;
                            Node name = newStatement.getFirstChild().cloneNode();
                            first.replaceWith(name);
                            insertBeforeParent.addChildBefore(newStatement, insertBefore);
                        }
                        this.reportCodeChange("FOR-IN var declaration", n);
                        break;
                    }
                    case FOR: {
                        if (c.getFirstChild().isEmpty()) break;
                        Node init = c.getFirstChild();
                        if (init.isLet() || init.isConst() || init.isClass() || init.isFunction()) {
                            return;
                        }
                        Node empty = IR.empty();
                        empty.useSourceInfoIfMissingFrom(c);
                        c.replaceChild(init, empty);
                        Node newStatement = init.isVar() ? init : NodeUtil.newExpr(init);
                        insertBeforeParent.addChildBefore(newStatement, insertBefore);
                        this.reportCodeChange("FOR initializer", n);
                        break;
                    }
                }
                c = next;
            }
        }

        private void splitVarDeclarations(Node n) {
            Node c = n.getFirstChild();
            while (c != null) {
                Node next = c.getNext();
                if (NodeUtil.isNameDeclaration(c)) {
                    if (this.assertOnChange && !c.hasChildren()) {
                        throw new IllegalStateException("Empty VAR node.");
                    }
                    while (c.getFirstChild() != c.getLastChild()) {
                        Node name = c.getFirstChild();
                        c.removeChild(name);
                        Node newVar = new Node(c.getToken(), name).srcref(n);
                        n.addChildBefore(newVar, c);
                        this.reportCodeChange("VAR with multiple children", n);
                    }
                }
                c = next;
            }
        }

        private void moveNamedFunctions(Node functionBody) {
            Node current;
            Preconditions.checkState(functionBody.getParent().isFunction());
            Node insertAfter = null;
            for (current = functionBody.getFirstChild(); current != null && NodeUtil.isFunctionDeclaration(current); current = current.getNext()) {
                insertAfter = current;
            }
            while (current != null) {
                Node next = current.getNext();
                if (NodeUtil.isFunctionDeclaration(current)) {
                    functionBody.removeChild(current);
                    insertAfter = NormalizeStatements.addToFront(functionBody, current, insertAfter);
                    this.reportCodeChange("Move function declaration not at top of function", functionBody);
                }
                current = next;
            }
        }

        private void normalizeAssignShorthand(Node shorthand) {
            if (shorthand.getFirstChild().isName()) {
                Node name = shorthand.getFirstChild();
                shorthand.setToken(NodeUtil.getOpFromAssignmentOp(shorthand));
                Node parent = shorthand.getParent();
                Node insertPoint = IR.empty();
                parent.replaceChild(shorthand, insertPoint);
                Node assign = IR.assign(name.cloneNode().useSourceInfoFrom(name), shorthand).useSourceInfoFrom(shorthand);
                assign.setJSDocInfo(shorthand.getJSDocInfo());
                shorthand.setJSDocInfo(null);
                parent.replaceChild(insertPoint, assign);
                this.compiler.reportChangeToEnclosingScope(assign);
            }
        }

        private static Node addToFront(Node parent, Node newChild, Node after) {
            if (after == null) {
                parent.addChildToFront(newChild);
            } else {
                parent.addChildAfter(newChild, after);
            }
            return newChild;
        }
    }

    static class VerifyConstants
    extends NodeTraversal.AbstractPostOrderCallback
    implements CompilerPass {
        private final AbstractCompiler compiler;
        private final boolean checkUserDeclarations;
        private final Map<String, Boolean> constantMap = new HashMap<String, Boolean>();

        VerifyConstants(AbstractCompiler compiler, boolean checkUserDeclarations) {
            this.compiler = compiler;
            this.checkUserDeclarations = checkUserDeclarations;
        }

        @Override
        public void process(Node externs, Node root) {
            Node externsAndJs = root.getParent();
            Preconditions.checkState(externsAndJs != null);
            Preconditions.checkState(externsAndJs.hasChild(externs));
            NodeTraversal.traverseRoots(this.compiler, this, externs, root);
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isName()) {
                Boolean value;
                String name = n.getString();
                if (n.getString().isEmpty()) {
                    return;
                }
                boolean isConst = n.getBooleanProp(Node.IS_CONSTANT_NAME);
                if (this.checkUserDeclarations) {
                    boolean expectedConst = false;
                    CodingConvention convention = this.compiler.getCodingConvention();
                    if (NodeUtil.isConstantName(n) || NodeUtil.isConstantByConvention(convention, n)) {
                        expectedConst = true;
                    } else {
                        expectedConst = false;
                        JSDocInfo info = null;
                        Var var = (Var)t.getScope().getVar(n.getString());
                        if (var != null) {
                            info = var.getJSDocInfo();
                        }
                        expectedConst = info != null && info.isConstant();
                    }
                    if (expectedConst) {
                        Preconditions.checkState(expectedConst == isConst, "The name %s is not annotated as constant.", (Object)name);
                    } else {
                        Preconditions.checkState(expectedConst == isConst, "The name %s should not be annotated as constant.", (Object)name);
                    }
                }
                if ((value = this.constantMap.get(name)) == null) {
                    this.constantMap.put(name, isConst);
                } else {
                    Preconditions.checkState(value == isConst, "The name %s is not consistently annotated as constant.", (Object)name);
                }
            }
        }
    }

    static class PropagateConstantAnnotationsOverVars
    extends NodeTraversal.AbstractPostOrderCallback
    implements CompilerPass {
        private final AbstractCompiler compiler;
        private final boolean assertOnChange;

        PropagateConstantAnnotationsOverVars(AbstractCompiler compiler, boolean forbidChanges) {
            this.compiler = compiler;
            this.assertOnChange = forbidChanges;
        }

        @Override
        public void process(Node externs, Node root) {
            NodeTraversal.traverseRoots(this.compiler, this, externs, root);
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isName() || n.isStringKey()) {
                if (n.getString().isEmpty()) {
                    return;
                }
                JSDocInfo info = null;
                Var var = (Var)t.getScope().getVar(n.getString());
                if (var != null) {
                    info = var.getJSDocInfo();
                }
                boolean shouldBeConstant = info != null && info.isConstant() || NodeUtil.isConstantByConvention(this.compiler.getCodingConvention(), n);
                boolean isMarkedConstant = n.getBooleanProp(Node.IS_CONSTANT_NAME);
                if (shouldBeConstant && !isMarkedConstant) {
                    if (this.assertOnChange) {
                        String name = n.getString();
                        throw new IllegalStateException("Unexpected const change.\n  name: " + name + "\n  parent:" + n.getParent().toStringTree());
                    }
                    n.putBooleanProp(Node.IS_CONSTANT_NAME, true);
                }
            }
        }
    }

    private class RewriteExposedProperties
    extends NodeTraversal.AbstractPostOrderCallback {
        private final Set<String> exposedProperties;

        RewriteExposedProperties(Set<String> exposedProperties) {
            this.exposedProperties = exposedProperties;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            String propName;
            if (n.isGetProp()) {
                String propName2 = n.getLastChild().getString();
                if (this.exposedProperties.contains(propName2)) {
                    Node obj = n.removeFirstChild();
                    Node prop = n.removeFirstChild();
                    Normalize.this.compiler.reportChangeToEnclosingScope(n);
                    n.replaceWith(IR.getelem(obj, prop));
                }
            } else if (n.isStringKey() && this.exposedProperties.contains(propName = n.getString()) && !n.isQuotedString()) {
                Normalize.this.compiler.reportChangeToEnclosingScope(n);
                n.setQuotedString();
            }
        }
    }

    private static class FindExposeAnnotations
    extends NodeTraversal.AbstractPostOrderCallback {
        private final Set<String> exposedProperties = new HashSet<String>();

        private FindExposeAnnotations() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (NodeUtil.isExprAssign(n)) {
                Node assign = n.getFirstChild();
                Node lhs = assign.getFirstChild();
                if (lhs.isGetProp() && FindExposeAnnotations.isMarkedExpose(assign)) {
                    this.exposedProperties.add(lhs.getLastChild().getString());
                }
            } else if (n.isStringKey() && FindExposeAnnotations.isMarkedExpose(n)) {
                this.exposedProperties.add(n.getString());
            } else if (n.isGetProp() && n.getParent().isExprResult() && FindExposeAnnotations.isMarkedExpose(n)) {
                this.exposedProperties.add(n.getLastChild().getString());
            }
        }

        private static boolean isMarkedExpose(Node n) {
            JSDocInfo info = n.getJSDocInfo();
            return info != null && info.isExpose();
        }
    }
}

