/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.modules;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.modules.Binding;
import com.google.javascript.jscomp.modules.ClosureModuleProcessor;
import com.google.javascript.jscomp.modules.EsModuleProcessor;
import com.google.javascript.jscomp.modules.Export;
import com.google.javascript.jscomp.modules.ExportTrace;
import com.google.javascript.jscomp.modules.GoogEsImports;
import com.google.javascript.jscomp.modules.Import;
import com.google.javascript.jscomp.modules.Module;
import com.google.javascript.jscomp.modules.ModuleMap;
import com.google.javascript.jscomp.modules.ModuleMetadataMap;
import com.google.javascript.jscomp.modules.ModuleRequestResolver;
import com.google.javascript.jscomp.modules.NonEsModuleProcessor;
import com.google.javascript.jscomp.modules.ResolveExportResult;
import com.google.javascript.jscomp.modules.UnresolvedModule;
import com.google.javascript.rhino.Node;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class ModuleMapCreator
implements HotSwapCompilerPass {
    public static final DiagnosticType MISSING_NAMESPACE_IMPORT = DiagnosticType.error("JSC_MISSING_NAMESPACE_IMPORT", "Imported Closure namespace \"{0}\" never defined.");
    public static final DiagnosticType DOES_NOT_HAVE_EXPORT = DiagnosticType.error("JSC_DOES_NOT_HAVE_EXPORT", "Requested module does not have an export \"{0}\".");
    private final AbstractCompiler compiler;
    private final EsModuleProcessor esModuleProcessor;
    private final ClosureModuleProcessor closureModuleProcessor;
    private final NonEsModuleProcessor nonEsModuleProcessor;
    private final Map<String, UnresolvedModule> unresolvedModules;
    private final Map<String, UnresolvedModule> unresolvedModulesByClosureNamespace;
    private final ModuleMetadataMap moduleMetadataMap;

    public ModuleMapCreator(AbstractCompiler compiler, ModuleMetadataMap moduleMetadataMap) {
        this.compiler = compiler;
        this.moduleMetadataMap = moduleMetadataMap;
        this.esModuleProcessor = new EsModuleProcessor(compiler);
        this.closureModuleProcessor = new ClosureModuleProcessor(compiler);
        this.nonEsModuleProcessor = new NonEsModuleProcessor();
        this.unresolvedModules = new HashMap<String, UnresolvedModule>();
        this.unresolvedModulesByClosureNamespace = new HashMap<String, UnresolvedModule>();
    }

    private ModuleMap create() {
        this.unresolvedModules.clear();
        this.unresolvedModulesByClosureNamespace.clear();
        for (ModuleMetadataMap.ModuleMetadata moduleMetadata : this.moduleMetadataMap.getAllModuleMetadata()) {
            this.process(moduleMetadata);
        }
        return this.resolve();
    }

    private ModuleMap resolve() {
        ImmutableSet<String> toResolve;
        ModuleRequestResolverImpl requestResolver = new ModuleRequestResolverImpl();
        HashMap<String, Module> resolvedModules = new HashMap<String, Module>();
        HashMap<String, Module> resolvedClosureModules = new HashMap<String, Module>();
        do {
            toResolve = Sets.difference(this.unresolvedModules.keySet(), resolvedModules.keySet()).immutableCopy();
            for (String key : toResolve) {
                Module resolved = this.unresolvedModules.get(key).resolve(requestResolver);
                resolvedModules.put(key, resolved);
                for (String namespace : resolved.metadata().googNamespaces()) {
                    resolvedClosureModules.put(namespace, resolved);
                }
            }
        } while (!resolvedModules.keySet().containsAll(this.unresolvedModules.keySet()));
        do {
            toResolve = Sets.difference(this.unresolvedModulesByClosureNamespace.keySet(), resolvedClosureModules.keySet()).immutableCopy();
            for (String namespace : toResolve) {
                resolvedClosureModules.put(namespace, this.unresolvedModulesByClosureNamespace.get(namespace).resolve(requestResolver));
            }
        } while (!resolvedClosureModules.keySet().containsAll(this.unresolvedModulesByClosureNamespace.keySet()));
        this.unresolvedModules.clear();
        this.unresolvedModulesByClosureNamespace.clear();
        return new ModuleMap(ImmutableMap.copyOf(resolvedModules), ImmutableMap.copyOf(resolvedClosureModules));
    }

    private void process(ModuleMetadataMap.ModuleMetadata moduleMetadata) {
        ModuleProcessor processor;
        switch (moduleMetadata.moduleType()) {
            case ES6_MODULE: {
                processor = this.esModuleProcessor;
                break;
            }
            case GOOG_MODULE: 
            case LEGACY_GOOG_MODULE: {
                processor = this.closureModuleProcessor;
                break;
            }
            default: {
                processor = this.nonEsModuleProcessor;
            }
        }
        UnresolvedModule module = processor.process(moduleMetadata, moduleMetadata.path(), moduleMetadata.rootNode());
        if (moduleMetadata.path() != null) {
            this.unresolvedModules.put(moduleMetadata.path().toModuleName(), module);
        }
        for (String namespace : moduleMetadata.googNamespaces()) {
            this.unresolvedModulesByClosureNamespace.put(namespace, module);
        }
    }

    @Override
    public void process(Node externs, Node root) {
        this.compiler.setModuleMap(this.create());
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        for (ModuleMetadataMap.ModuleMetadata metadata : this.compiler.getModuleMetadataMap().getAllModuleMetadata()) {
            if (originalRoot.getInputId().equals(NodeUtil.getInputId(metadata.rootNode()))) {
                this.process(metadata);
                continue;
            }
            if (metadata.path() != null) {
                Module module = this.compiler.getModuleMap().getModule(metadata.path());
                this.unresolvedModules.put(metadata.path().toModuleName(), module.unresolvedModule());
                module.unresolvedModule().reset();
            }
            for (String namespace : metadata.googNamespaces()) {
                Module module = this.compiler.getModuleMap().getClosureModule(namespace);
                this.unresolvedModulesByClosureNamespace.put(namespace, module.unresolvedModule());
                module.unresolvedModule().reset();
            }
        }
        this.compiler.setModuleMap(this.resolve());
    }

    static interface ModuleProcessor {
        public UnresolvedModule process(ModuleMetadataMap.ModuleMetadata var1, ModuleLoader.ModulePath var2, Node var3);
    }

    private final class ModuleRequestResolverImpl
    implements ModuleRequestResolver {
        private ModuleRequestResolverImpl() {
        }

        private UnresolvedModule getFallbackForMissingNonClosureModule(final ModuleLoader.ModulePath path) {
            final ModuleMetadataMap.ModuleMetadata metadata = ModuleMetadataMap.ModuleMetadata.builder().rootNode(null).path(path).moduleType(ModuleMetadataMap.ModuleType.ES6_MODULE).isTestOnly(false).usesClosure(false).build();
            return new UnresolvedModule(){

                @Override
                void reset() {
                }

                @Override
                Module resolve(ModuleRequestResolver moduleRequestResolver, @Nullable String moduleSpecifier) {
                    return Module.builder().boundNames(ImmutableMap.of()).namespace(ImmutableMap.of()).localNameToLocalExport(ImmutableMap.of()).path(path).metadata(metadata).unresolvedModule(this).build();
                }

                @Override
                ModuleMetadataMap.ModuleMetadata metadata() {
                    return metadata;
                }

                @Override
                ImmutableSet<String> getExportedNames(ModuleRequestResolver moduleRequestResolver) {
                    return ImmutableSet.of();
                }

                @Override
                protected ImmutableSet<String> getExportedNames(ModuleRequestResolver moduleRequestResolver, Set<UnresolvedModule> visited) {
                    return ImmutableSet.of();
                }

                @Override
                ResolveExportResult resolveExport(ModuleRequestResolver moduleRequestResolver, @Nullable String moduleSpecifier, String exportName, Set<ExportTrace> resolveSet, Set<UnresolvedModule> exportStarSet) {
                    return ResolveExportResult.of(Binding.from(Export.builder().localName(exportName).moduleMetadata(metadata).modulePath(path).closureNamespace(null).build(), null));
                }
            };
        }

        private UnresolvedModule getFallbackForMissingClosureModule(String namespace) {
            return ModuleMapCreator.this.nonEsModuleProcessor.process(ModuleMetadataMap.ModuleMetadata.builder().addGoogNamespace(namespace).isTestOnly(false).moduleType(ModuleMetadataMap.ModuleType.GOOG_PROVIDE).path(null).rootNode(null).usesClosure(true).build(), null, null);
        }

        @Override
        @Nullable
        public UnresolvedModule resolve(Import i) {
            if (i.modulePath() == null) {
                return this.resolveForClosure(i.moduleRequest(), i.importNode());
            }
            return this.resolve(i.moduleRequest(), i.modulePath(), i.importNode());
        }

        @Override
        @Nullable
        public UnresolvedModule resolve(Export e) {
            return this.resolve(e.moduleRequest(), e.modulePath(), e.exportNode());
        }

        @Nullable
        private UnresolvedModule resolveForClosure(String namespace, Node forLineInfo) {
            UnresolvedModule module = (UnresolvedModule)ModuleMapCreator.this.unresolvedModulesByClosureNamespace.get(namespace);
            if (module == null) {
                ModuleMapCreator.this.compiler.report(JSError.make(forLineInfo, MISSING_NAMESPACE_IMPORT, namespace));
                module = this.getFallbackForMissingClosureModule(namespace);
                ModuleMapCreator.this.unresolvedModulesByClosureNamespace.put(namespace, module);
            }
            return module;
        }

        @Nullable
        private UnresolvedModule resolve(String moduleRequest, ModuleLoader.ModulePath modulePath, Node forLineInfo) {
            if (GoogEsImports.isGoogImportSpecifier(moduleRequest)) {
                String namespace = GoogEsImports.getClosureIdFromGoogImportSpecifier(moduleRequest);
                return this.resolveForClosure(namespace, forLineInfo);
            }
            ModuleLoader.ModulePath requestedPath = modulePath.resolveJsModule(moduleRequest, modulePath.toString(), forLineInfo.getLineno(), forLineInfo.getCharno());
            if (requestedPath == null) {
                requestedPath = modulePath.resolveModuleAsPath(moduleRequest);
                if (!ModuleMapCreator.this.unresolvedModules.containsKey(requestedPath.toModuleName())) {
                    UnresolvedModule module = this.getFallbackForMissingNonClosureModule(requestedPath);
                    ModuleMapCreator.this.unresolvedModules.put(requestedPath.toModuleName(), module);
                    return module;
                }
            }
            return (UnresolvedModule)ModuleMapCreator.this.unresolvedModules.get(requestedPath.toModuleName());
        }
    }
}

