/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.EnumType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.NamedType;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.PropertyMap;
import com.google.javascript.rhino.jstype.RelationshipVisitor;
import com.google.javascript.rhino.jstype.TernaryValue;
import com.google.javascript.rhino.jstype.Visitor;

public class EnumElementType
extends ObjectType {
    private static final long serialVersionUID = 1L;
    private JSType primitiveType;
    private ObjectType primitiveObjectType;
    private final String name;
    private final EnumType enumType;

    EnumElementType(JSTypeRegistry registry, JSType elementType, String name, EnumType enumType) {
        super(registry);
        this.primitiveType = elementType;
        this.primitiveObjectType = elementType.toObjectType();
        this.name = name;
        this.enumType = enumType;
    }

    public EnumType getEnumType() {
        return this.enumType;
    }

    @Override
    public JSType.HasPropertyKind getPropertyKind(String propertyName, boolean autobox) {
        return this.primitiveType.getPropertyKind(propertyName, autobox);
    }

    @Override
    public PropertyMap getPropertyMap() {
        return this.primitiveObjectType == null ? PropertyMap.immutableEmptyMap() : this.primitiveObjectType.getPropertyMap();
    }

    @Override
    public EnumElementType toMaybeEnumElementType() {
        return this;
    }

    @Override
    public boolean matchesNumberContext() {
        return this.primitiveType.matchesNumberContext();
    }

    @Override
    public boolean matchesStringContext() {
        return this.primitiveType.matchesStringContext();
    }

    @Override
    public boolean matchesObjectContext() {
        return this.primitiveType.matchesObjectContext();
    }

    @Override
    public boolean canBeCalled() {
        return this.primitiveType.canBeCalled();
    }

    @Override
    public boolean isObject() {
        return this.primitiveType.isObject();
    }

    @Override
    public TernaryValue testForEquality(JSType that) {
        return this.primitiveType.testForEquality(that);
    }

    @Override
    public boolean isNullable() {
        return this.primitiveType.isNullable();
    }

    @Override
    public boolean isVoidable() {
        return this.primitiveType.isVoidable();
    }

    @Override
    public boolean isNominalType() {
        return this.hasReferenceName();
    }

    @Override
    int recursionUnsafeHashCode() {
        return NamedType.nominalHashCode(this);
    }

    @Override
    StringBuilder appendTo(StringBuilder sb, boolean forAnnotations) {
        if (forAnnotations) {
            return sb.append(this.primitiveType);
        }
        return sb.append(this.getReferenceName()).append("<").append(this.primitiveType).append(">");
    }

    @Override
    public String getReferenceName() {
        return this.name;
    }

    @Override
    public boolean isSubtype(JSType that) {
        return this.isSubtype(that, JSType.ImplCache.create(), JSType.SubtypingMode.NORMAL);
    }

    @Override
    protected boolean isSubtype(JSType that, JSType.ImplCache implicitImplCache, JSType.SubtypingMode subtypingMode) {
        if (JSType.isSubtypeHelper(this, that, implicitImplCache, subtypingMode)) {
            return true;
        }
        return this.primitiveType.isSubtype(that, implicitImplCache, subtypingMode);
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseEnumElementType(this);
    }

    @Override
    <T> T visit(RelationshipVisitor<T> visitor, JSType that) {
        return visitor.caseEnumElementType(this, that);
    }

    @Override
    boolean defineProperty(String propertyName, JSType type, boolean inferred, Node propertyNode) {
        return true;
    }

    @Override
    public ObjectType getImplicitPrototype() {
        return null;
    }

    @Override
    protected JSType findPropertyTypeWithoutConsideringTemplateTypes(String propertyName) {
        return this.primitiveType.findPropertyType(propertyName);
    }

    @Override
    public FunctionType getConstructor() {
        return this.primitiveObjectType == null ? null : this.primitiveObjectType.getConstructor();
    }

    @Override
    public JSType autoboxesTo() {
        return this.primitiveType.autoboxesTo();
    }

    public JSType getPrimitiveType() {
        return this.primitiveType;
    }

    JSType meet(JSType that) {
        JSType meetPrimitive = this.primitiveType.getGreatestSubtype(that);
        if (meetPrimitive.isEmptyType()) {
            return null;
        }
        return new EnumElementType(this.registry, meetPrimitive, this.name, this.getEnumType());
    }

    @Override
    JSType resolveInternal(ErrorReporter reporter) {
        this.primitiveType = this.primitiveType.resolve(reporter);
        this.primitiveObjectType = ObjectType.cast(this.primitiveType);
        return this;
    }

    @Override
    JSType simplifyForOptimizations() {
        return this.primitiveType.simplifyForOptimizations();
    }
}

