#!/usr/bin/env python
# Copyright 2016 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

from os import path as os_path

NODE_MODULES = os_path.join(os_path.dirname(__file__), 'node_modules')


def _path_in_node_modules(*args):
    return os_path.join(NODE_MODULES, *args)


def PathToBundler():
    return _path_in_node_modules('polymer-bundler', 'lib', 'bin', 'polymer-bundler')


def PathToCrisper():
    return _path_in_node_modules('crisper', 'bin', 'crisper')


def PathToEsLint():
    return _path_in_node_modules('eslint', 'bin', 'eslint')


def PathToPolymerCssBuild():
    return _path_in_node_modules('polymer-css-build', 'bin', 'polymer-css-build')


def PathToSvgo():
    return _path_in_node_modules('svgo', 'bin', 'svgo')


def PathToUglify():
    return _path_in_node_modules('uglify-es', 'bin', 'uglifyjs')
