//===-- lldb-ppc64le-register-enums.h ---------------------------*- C++ -*-===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef lldb_ppc64le_register_enums_h
#define lldb_ppc64le_register_enums_h

// LLDB register codes (e.g. RegisterKind == eRegisterKindLLDB)

// Internal codes for all ppc64le registers.
enum {
  k_first_gpr_ppc64le,
  gpr_r0_ppc64le = k_first_gpr_ppc64le,
  gpr_r1_ppc64le,
  gpr_r2_ppc64le,
  gpr_r3_ppc64le,
  gpr_r4_ppc64le,
  gpr_r5_ppc64le,
  gpr_r6_ppc64le,
  gpr_r7_ppc64le,
  gpr_r8_ppc64le,
  gpr_r9_ppc64le,
  gpr_r10_ppc64le,
  gpr_r11_ppc64le,
  gpr_r12_ppc64le,
  gpr_r13_ppc64le,
  gpr_r14_ppc64le,
  gpr_r15_ppc64le,
  gpr_r16_ppc64le,
  gpr_r17_ppc64le,
  gpr_r18_ppc64le,
  gpr_r19_ppc64le,
  gpr_r20_ppc64le,
  gpr_r21_ppc64le,
  gpr_r22_ppc64le,
  gpr_r23_ppc64le,
  gpr_r24_ppc64le,
  gpr_r25_ppc64le,
  gpr_r26_ppc64le,
  gpr_r27_ppc64le,
  gpr_r28_ppc64le,
  gpr_r29_ppc64le,
  gpr_r30_ppc64le,
  gpr_r31_ppc64le,
  gpr_pc_ppc64le,
  gpr_msr_ppc64le,
  gpr_origr3_ppc64le,
  gpr_ctr_ppc64le,
  gpr_lr_ppc64le,
  gpr_xer_ppc64le,
  gpr_cr_ppc64le,
  gpr_softe_ppc64le,
  gpr_trap_ppc64le,
  k_last_gpr_ppc64le = gpr_trap_ppc64le,

  k_first_fpr_ppc64le,
  fpr_f0_ppc64le = k_first_fpr_ppc64le,
  fpr_f1_ppc64le,
  fpr_f2_ppc64le,
  fpr_f3_ppc64le,
  fpr_f4_ppc64le,
  fpr_f5_ppc64le,
  fpr_f6_ppc64le,
  fpr_f7_ppc64le,
  fpr_f8_ppc64le,
  fpr_f9_ppc64le,
  fpr_f10_ppc64le,
  fpr_f11_ppc64le,
  fpr_f12_ppc64le,
  fpr_f13_ppc64le,
  fpr_f14_ppc64le,
  fpr_f15_ppc64le,
  fpr_f16_ppc64le,
  fpr_f17_ppc64le,
  fpr_f18_ppc64le,
  fpr_f19_ppc64le,
  fpr_f20_ppc64le,
  fpr_f21_ppc64le,
  fpr_f22_ppc64le,
  fpr_f23_ppc64le,
  fpr_f24_ppc64le,
  fpr_f25_ppc64le,
  fpr_f26_ppc64le,
  fpr_f27_ppc64le,
  fpr_f28_ppc64le,
  fpr_f29_ppc64le,
  fpr_f30_ppc64le,
  fpr_f31_ppc64le,
  fpr_fpscr_ppc64le,
  k_last_fpr_ppc64le = fpr_fpscr_ppc64le,

  k_first_vmx_ppc64le,
  vmx_vr0_ppc64le = k_first_vmx_ppc64le,
  vmx_vr1_ppc64le,
  vmx_vr2_ppc64le,
  vmx_vr3_ppc64le,
  vmx_vr4_ppc64le,
  vmx_vr5_ppc64le,
  vmx_vr6_ppc64le,
  vmx_vr7_ppc64le,
  vmx_vr8_ppc64le,
  vmx_vr9_ppc64le,
  vmx_vr10_ppc64le,
  vmx_vr11_ppc64le,
  vmx_vr12_ppc64le,
  vmx_vr13_ppc64le,
  vmx_vr14_ppc64le,
  vmx_vr15_ppc64le,
  vmx_vr16_ppc64le,
  vmx_vr17_ppc64le,
  vmx_vr18_ppc64le,
  vmx_vr19_ppc64le,
  vmx_vr20_ppc64le,
  vmx_vr21_ppc64le,
  vmx_vr22_ppc64le,
  vmx_vr23_ppc64le,
  vmx_vr24_ppc64le,
  vmx_vr25_ppc64le,
  vmx_vr26_ppc64le,
  vmx_vr27_ppc64le,
  vmx_vr28_ppc64le,
  vmx_vr29_ppc64le,
  vmx_vr30_ppc64le,
  vmx_vr31_ppc64le,
  vmx_vscr_ppc64le,
  vmx_vrsave_ppc64le,
  k_last_vmx_ppc64le = vmx_vrsave_ppc64le,

  k_first_vsx_ppc64le,
  vsx_vs0_ppc64le = k_first_vsx_ppc64le,
  vsx_vs1_ppc64le,
  vsx_vs2_ppc64le,
  vsx_vs3_ppc64le,
  vsx_vs4_ppc64le,
  vsx_vs5_ppc64le,
  vsx_vs6_ppc64le,
  vsx_vs7_ppc64le,
  vsx_vs8_ppc64le,
  vsx_vs9_ppc64le,
  vsx_vs10_ppc64le,
  vsx_vs11_ppc64le,
  vsx_vs12_ppc64le,
  vsx_vs13_ppc64le,
  vsx_vs14_ppc64le,
  vsx_vs15_ppc64le,
  vsx_vs16_ppc64le,
  vsx_vs17_ppc64le,
  vsx_vs18_ppc64le,
  vsx_vs19_ppc64le,
  vsx_vs20_ppc64le,
  vsx_vs21_ppc64le,
  vsx_vs22_ppc64le,
  vsx_vs23_ppc64le,
  vsx_vs24_ppc64le,
  vsx_vs25_ppc64le,
  vsx_vs26_ppc64le,
  vsx_vs27_ppc64le,
  vsx_vs28_ppc64le,
  vsx_vs29_ppc64le,
  vsx_vs30_ppc64le,
  vsx_vs31_ppc64le,
  vsx_vs32_ppc64le,
  vsx_vs33_ppc64le,
  vsx_vs34_ppc64le,
  vsx_vs35_ppc64le,
  vsx_vs36_ppc64le,
  vsx_vs37_ppc64le,
  vsx_vs38_ppc64le,
  vsx_vs39_ppc64le,
  vsx_vs40_ppc64le,
  vsx_vs41_ppc64le,
  vsx_vs42_ppc64le,
  vsx_vs43_ppc64le,
  vsx_vs44_ppc64le,
  vsx_vs45_ppc64le,
  vsx_vs46_ppc64le,
  vsx_vs47_ppc64le,
  vsx_vs48_ppc64le,
  vsx_vs49_ppc64le,
  vsx_vs50_ppc64le,
  vsx_vs51_ppc64le,
  vsx_vs52_ppc64le,
  vsx_vs53_ppc64le,
  vsx_vs54_ppc64le,
  vsx_vs55_ppc64le,
  vsx_vs56_ppc64le,
  vsx_vs57_ppc64le,
  vsx_vs58_ppc64le,
  vsx_vs59_ppc64le,
  vsx_vs60_ppc64le,
  vsx_vs61_ppc64le,
  vsx_vs62_ppc64le,
  vsx_vs63_ppc64le,
  k_last_vsx_ppc64le = vsx_vs63_ppc64le,

  k_num_registers_ppc64le,
  k_num_gpr_registers_ppc64le = k_last_gpr_ppc64le - k_first_gpr_ppc64le + 1,
  k_num_fpr_registers_ppc64le = k_last_fpr_ppc64le - k_first_fpr_ppc64le + 1,
  k_num_vmx_registers_ppc64le = k_last_vmx_ppc64le - k_first_vmx_ppc64le + 1,
  k_num_vsx_registers_ppc64le = k_last_vsx_ppc64le - k_first_vsx_ppc64le + 1,
};

#endif // #ifndef lldb_ppc64le_register_enums_h
