/* Generated by re2c */

#include <stddef.h> /* size_t */
#include <stdio.h>
#include <stdlib.h> /* malloc, free */
#include <string.h> /* memcpy */

static void *read_file
    ( const char *fname
    , size_t unit
    , size_t padding
    , size_t *pfsize
    )
{
    void *buffer = NULL;
    size_t fsize = 0;

    /* open file */
    FILE *f = fopen(fname, "rb");
    if(f == NULL) {
        goto error;
    }

    /* get file size */
    fseek(f, 0, SEEK_END);
    fsize = (size_t) ftell(f) / unit;
    fseek(f, 0, SEEK_SET);

    /* allocate memory for file and padding */
    buffer = malloc(unit * (fsize + padding));
    if (buffer == NULL) {
        goto error;
    }

    /* read the whole file in memory */
    if (fread(buffer, unit, fsize, f) != fsize) {
        goto error;
    }

    fclose(f);
    *pfsize = fsize;
    return buffer;

error:
    fprintf(stderr, "error: cannot read file '%s'\n", fname);
    free(buffer);
    if (f != NULL) {
        fclose(f);
    }
    return NULL;
}

#define YYCTYPE unsigned char
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYBACKUP() marker = cursor
#define YYRESTORE() cursor = marker
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line66
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line66: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line66: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line66(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line66: not enough keys\n");
    return 1;
}

int lex_line66()
{
    const size_t padding = 2; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("php20150211_pdo_sql_parser.ig--skeleton.c.line66.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    keys = (YYKEYTYPE *) read_file
        ("php20150211_pdo_sql_parser.ig--skeleton.c.line66.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        const YYCTYPE *marker = NULL;
        YYCTYPE yych;
        static const unsigned char yybm[] = {
            /* table 1 .. 8: 0 */
             96,  99,  99,  99,  99,  99,  99,  99, 
             99,  99,  66,  99,  99,  66,  99,  99, 
             99,  99,  99,  99,  99,  99,  99,  99, 
             99,  99,  99,  99,  99,  99,  99,  99, 
             99,  99,  96,  99,  99,  99,  99,  96, 
             99,  99, 161,  99,  99,  99,  99,  99, 
            103, 103, 103, 103, 103, 103, 103, 103, 
            103, 103, 104,  99,  99,  99,  99, 112, 
             99, 103, 103, 103, 103, 103, 103, 103, 
            103, 103, 103, 103, 103, 103, 103, 103, 
            103, 103, 103, 103, 103, 103, 103, 103, 
            103, 103, 103,  99,  99,  99,  99, 103, 
             99, 103, 103, 103, 103, 103, 103, 103, 
            103, 103, 103, 103, 103, 103, 103, 103, 
            103, 103, 103, 103, 103, 103, 103, 103, 
            103, 103, 103,  99,  99,  99,  99,  99, 
             99,  99,  99,  99,  99,  99,  99,  99, 
             99,  99,  99,  99,  99,  99,  99,  99, 
             99,  99,  99,  99,  99,  99,  99,  99, 
             99,  99,  99,  99,  99,  99,  99,  99, 
             99,  99,  99,  99,  99,  99,  99,  99, 
             99,  99,  99,  99,  99,  99,  99,  99, 
             99,  99,  99,  99,  99,  99,  99,  99, 
             99,  99,  99,  99,  99,  99,  99,  99, 
             99,  99,  99,  99,  99,  99,  99,  99, 
             99,  99,  99,  99,  99,  99,  99,  99, 
             99,  99,  99,  99,  99,  99,  99,  99, 
             99,  99,  99,  99,  99,  99,  99,  99, 
             99,  99,  99,  99,  99,  99,  99,  99, 
             99,  99,  99,  99,  99,  99,  99,  99, 
             99,  99,  99,  99,  99,  99,  99,  99, 
             99,  99,  99,  99,  99,  99,  99,  99, 
            /* table 9 .. 11: 256 */
              0, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 128, 224, 224, 224, 224,  64, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 192, 224, 224, 224, 224, 192, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224,  32, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
        };

        if (YYLESSTHAN (2)) YYFILL(2);
        yych = YYPEEK ();
        {
            static void *yytarget[256] = {
                &&yy2,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
                &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
                &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
                &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
                &&yy3,  &&yy3,  &&yy6,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy8,
                &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy9,  &&yy3,  &&yy10,
                &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
                &&yy3,  &&yy3,  &&yy11, &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy12,
                &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
                &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
                &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
                &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
                &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
                &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
                &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
                &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
                &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
                &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
                &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
                &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
                &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
                &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
                &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
                &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
                &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
                &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
                &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
                &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
                &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
                &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
                &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
                &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3
            };
            goto *yytarget[yych];
        }
yy2:
        YYRESTORE ();
        goto yy7;
yy3:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
yy4:
        if (yybm[256+yych] & 32) {
            goto yy3;
        }
        status = check_key_count_line66(keys_count, i, 3)
             || action_line66(&i, keys, input, token, &cursor, 7);
        continue;
yy6:
        YYSKIP ();
        YYBACKUP ();
        yych = YYPEEK ();
        if (yych >= 0x01) goto yy15;
yy7:
        status = check_key_count_line66(keys_count, i, 3)
             || action_line66(&i, keys, input, token, &cursor, 5);
        continue;
yy8:
        YYSKIP ();
        YYBACKUP ();
        yych = YYPEEK ();
        if (yych <= 0x00) goto yy7;
        goto yy20;
yy9:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych == '-') goto yy24;
        goto yy4;
yy10:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych == '*') goto yy26;
        goto yy4;
yy11:
        YYSKIP ();
        yych = YYPEEK ();
        if (yybm[0+yych] & 4) {
            goto yy28;
        }
        if (yych <= '/') goto yy7;
        if (yych <= ':') goto yy31;
        goto yy7;
yy12:
        YYSKIP ();
        yych = YYPEEK ();
        if (yybm[0+yych] & 16) {
            goto yy34;
        }
        status = check_key_count_line66(keys_count, i, 3)
             || action_line66(&i, keys, input, token, &cursor, 4);
        continue;
yy14:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
yy15:
        if (yybm[256+yych] & 64) {
            goto yy14;
        }
        if (yych <= 0x00) goto yy2;
        if (yych >= '#') goto yy18;
        YYSKIP ();
        status = check_key_count_line66(keys_count, i, 3)
             || action_line66(&i, keys, input, token, &cursor, 0);
        continue;
yy18:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x00) goto yy2;
        goto yy14;
yy19:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
yy20:
        if (yybm[256+yych] & 128) {
            goto yy19;
        }
        if (yych <= 0x00) goto yy2;
        if (yych >= '(') goto yy23;
        YYSKIP ();
        status = check_key_count_line66(keys_count, i, 3)
             || action_line66(&i, keys, input, token, &cursor, 1);
        continue;
yy23:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x00) goto yy2;
        goto yy19;
yy24:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yybm[0+yych] & 1) {
            goto yy24;
        }
        if (yych <= 0x00) goto yy36;
        if (yych <= '\r') goto yy3;
        goto yy36;
yy26:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yybm[0+yych] & 2) {
            goto yy26;
        }
        if (yych <= '\'') goto yy39;
        if (yych <= '*') goto yy41;
        goto yy39;
yy28:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yybm[0+yych] & 4) {
            goto yy28;
        }
        status = check_key_count_line66(keys_count, i, 3)
             || action_line66(&i, keys, input, token, &cursor, 3);
        continue;
yy31:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yybm[0+yych] & 8) {
            goto yy31;
        }
yy33:
        status = check_key_count_line66(keys_count, i, 3)
             || action_line66(&i, keys, input, token, &cursor, 2);
        continue;
yy34:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yybm[0+yych] & 16) {
            goto yy34;
        }
        goto yy33;
yy36:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yybm[0+yych] & 32) {
            goto yy36;
        }
yy38:
        status = check_key_count_line66(keys_count, i, 3)
             || action_line66(&i, keys, input, token, &cursor, 6);
        continue;
yy39:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yybm[0+yych] & 64) {
            goto yy39;
        }
        goto yy43;
yy41:
        YYSKIP ();
        if (YYLESSTHAN (2)) YYFILL(2);
        yych = YYPEEK ();
        {
            static void *yytarget[256] = {
                &&yy39, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26,
                &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26,
                &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26,
                &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26,
                &&yy26, &&yy26, &&yy39, &&yy26, &&yy26, &&yy26, &&yy26, &&yy39,
                &&yy26, &&yy26, &&yy41, &&yy26, &&yy26, &&yy26, &&yy26, &&yy45,
                &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26,
                &&yy26, &&yy26, &&yy39, &&yy26, &&yy26, &&yy26, &&yy26, &&yy39,
                &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26,
                &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26,
                &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26,
                &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26,
                &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26,
                &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26,
                &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26,
                &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26,
                &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26,
                &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26,
                &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26,
                &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26,
                &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26,
                &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26,
                &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26,
                &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26,
                &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26,
                &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26,
                &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26,
                &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26,
                &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26,
                &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26,
                &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26,
                &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26, &&yy26
            };
            goto *yytarget[yych];
        }
yy43:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych == '*') goto yy43;
        if (yych == '/') goto yy46;
        goto yy39;
yy45:
        YYSKIP ();
        yych = YYPEEK ();
        if (yybm[256+yych] & 32) {
            goto yy3;
        }
        goto yy38;
yy46:
        YYSKIP ();
        goto yy38;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line66: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line66: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYBACKUP
#undef YYRESTORE
#undef YYLESSTHAN
#undef YYFILL

int main()
{
    if(lex_line66() != 0) {
        return 1;
    }
    return 0;
}
 "':? "'		:

? "

':? "':? "':? "':?   "!!'##:$$?%% &&"((')):**?++ ,,".-'0.:1/?20 31"42'53:64?75 86"97';8:<9?=; ><"@='A>:B@?CA DB"EC'FD:GE?HF IG"JH'KI:LJ?MK NL"OM'PN:QO?RP SQ"TR'US:VT?WU XV"YW'ZX:[Y?\Z ]["^\'_]:`^?a_ b`"ca'db:ec?fd ge"hf'ig:jh?ki lj"mk'nl:om?pn qo"rp'sq:tr?us vt"wu'xv:yw?zx {y"|z'}{:~|?} ~"':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':?  "':? "'	:
? "
':? "':? "':? "':?  "!'#:$?% &"('):*?+ ,".'0:1?2 3"4'5:6?7 8"9';:<?= >"@'A:B?C D"E'F:G?H I"J'K:L?M N"O'P:Q?R S"T'U:V?W X"Y'Z:[?\ ]"^'_:`?a b"c'd:e?f g"h'i:j?k l"m'n:o?p q"r's:t?u v"w'x:y?z {"|'}:~? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':? "':"""""""""""""""""		""

""""""

""""""""""""""""""""""""""""""""""""""  ""!!""##""$$""%%""&&""''""((""))""**""++"",,""--""..""//""00""11""22""33""44""55""66""77""88""99""::"";;""<<""=="">>""??""@@""AA""BB""CC""DD""EE""FF""GG""HH""II""JJ""KK""LL""MM""NN""OO""PP""QQ""RR""SS""TT""UU""VV""WW""XX""YY""ZZ""[[""]]""^^""__""``""aa""bb""cc""dd""ee""ff""gg""hh""ii""jj""kk""ll""mm""nn""oo""pp""qq""rr""ss""tt""uu""vv""ww""xx""yy""zz""{{""||""}}""~~""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""\""\""\""\""\""\""\""\""		\	""

\
""\""\""

\
""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""  \ ""!!\!""##\"""$$\#""%%\$""&&\%""''\&""((\'""))\(""**\)""++\*"",,\+""--\,""..\-""//\.""00\/""11\0""22\1""33\2""44\3""55\4""66\5""77\6""88\7""99\8""::\9"";;\:""<<\;""==\<"">>\=""??\>""@@\?""AA\@""BB\A""CC\B""DD\C""EE\D""FF\E""GG\F""HH\G""II\H""JJ\I""KK\J""LL\K""MM\L""NN\M""OO\N""PP\O""QQ\P""RR\Q""SS\R""TT\S""UU\T""VV\U""WW\V""XX\W""YY\X""ZZ\Y""[[\Z""]]\[""^^\\""__\]""``\^""aa\_""bb\`""cc\a""dd\b""ee\c""ff\d""gg\e""hh\f""ii\g""jj\h""kk\i""ll\j""mm\k""nn\l""oo\m""pp\n""qq\o""rr\p""ss\q""tt\r""uu\s""vv\t""ww\u""xx\v""yy\w""zz\x""{{\y""||\z""}}\{""~~\|""\}""\~""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\ "\ "\ "\ "\ "\ "\ "\ "		\ "

\ "\ "\ "

\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "  \ "!!\ "##\ "$$\ "%%\ "&&\ "''\ "((\ "))\ "**\ "++\ ",,\ "--\ "..\ "//\ "00\ "11\ "22\ "33\ "44\ "55\ "66\ "77\ "88\ "99\ "::\ ";;\ "<<\ "==\ ">>\ "??\ "@@\ "AA\ "BB\ "CC\ "DD\ "EE\ "FF\ "GG\ "HH\ "II\ "JJ\ "KK\ "LL\ "MM\ "NN\ "OO\ "PP\ "QQ\ "RR\ "SS\ "TT\ "UU\ "VV\ "WW\ "XX\ "YY\ "ZZ\ "[[\ "]]\ "^^\ "__\ "``\ "aa\ "bb\ "cc\ "dd\ "ee\ "ff\ "gg\ "hh\ "ii\ "jj\ "kk\ "ll\ "mm\ "nn\ "oo\ "pp\ "qq\ "rr\ "ss\ "tt\ "uu\ "vv\ "ww\ "xx\ "yy\ "zz\ "{{\ "||\ "}}\ "~~\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ " " " " " " " " "		 "

 " " "

 " " " " " " " " " " " " " " " " " " "   "!! "## "$$ "%% "&& "'' "(( ")) "** "++ ",, "-- ".. "// "00 "11 "22 "33 "44 "55 "66 "77 "88 "99 ":: ";; "<< "== ">> "?? "@@ "AA "BB "CC "DD "EE "FF "GG "HH "II "JJ "KK "LL "MM "NN "OO "PP "QQ "RR "SS "TT "UU "VV "WW "XX "YY "ZZ "[[ "]] "^^ "__ "`` "aa "bb "cc "dd "ee "ff "gg "hh "ii "jj "kk "ll "mm "nn "oo "pp "qq "rr "ss "tt "uu "vv "ww "xx "yy "zz "{{ "|| "}} "~~ " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " """""""""""""""""	""
""""""
"""""""""""""""""""""""""""""""""""""" ""!""#""$""%""&""'""("")""*""+"",""-"".""/""0""1""2""3""4""5""6""7""8""9"":"";""<""="">""?""@""A""B""C""D""E""F""G""H""I""J""K""L""M""N""O""P""Q""R""S""T""U""V""W""X""Y""Z""[""]""^""_""`""a""b""c""d""e""f""g""h""i""j""k""l""m""n""o""p""q""r""s""t""u""v""w""x""y""z""{""|""}""~""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""\""\""\""\""\""\""\""\""	\	""
\
""\""\""
\
""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\"" \ ""!\!""#\"""$\#""%\$""&\%""'\&""(\'"")\(""*\)""+\*"",\+""-\,"".\-""/\.""0\/""1\0""2\1""3\2""4\3""5\4""6\5""7\6""8\7""9\8"":\9"";\:""<\;""=\<"">\=""?\>""@\?""A\@""B\A""C\B""D\C""E\D""F\E""G\F""H\G""I\H""J\I""K\J""L\K""M\L""N\M""O\N""P\O""Q\P""R\Q""S\R""T\S""U\T""V\U""W\V""X\W""Y\X""Z\Y""[\Z""]\[""^\\""_\]""`\^""a\_""b\`""c\a""d\b""e\c""f\d""g\e""h\f""i\g""j\h""k\i""l\j""m\k""n\l""o\m""p\n""q\o""r\p""s\q""t\r""u\s""v\t""w\u""x\v""y\w""z\x""{\y""|\z""}\{""~\|""\}""\~""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\"" " " " " " " " "	 "
 " " "
 " " " " " " " " " " " " " " " " " " "  "! "# "$ "% "& "' "( ") "* "+ ", "- ". "/ "0 "1 "2 "3 "4 "5 "6 "7 "8 "9 ": "; "< "= "> "? "@ "A "B "C "D "E "F "G "H "I "J "K "L "M "N "O "P "Q "R "S "T "U "V "W "X "Y "Z "[ "] "^ "_ "` "a "b "c "d "e "f "g "h "i "j "k "l "m "n "o "p "q "r "s "t "u "v "w "x "y "z "{ "| "} "~ " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " """\""\""\""\""\""\""\""\""\	""\
""\""\""\
""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\ ""\!""\"""\#""\$""\%""\&""\'""\(""\)""\*""\+""\,""\-""\.""\/""\0""\1""\2""\3""\4""\5""\6""\7""\8""\9""\:""\;""\<""\=""\>""\?""\@""\A""\B""\C""\D""\E""\F""\G""\H""\I""\J""\K""\L""\M""\N""\O""\P""\Q""\R""\S""\T""\U""\V""\W""\X""\Y""\Z""\[""\\""\]""\^""\_""\`""\a""\b""\c""\d""\e""\f""\g""\h""\i""\j""\k""\l""\m""\n""\o""\p""\q""\r""\s""\t""\u""\v""\w""\x""\y""\z""\{""\|""\}""\~""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\""\"" '''''''''''''''''		''

''''''

''''''''''''''''''''''''''''''''''''''  ''!!''""''##''$$''%%''&&''((''))''**''++'',,''--''..''//''00''11''22''33''44''55''66''77''88''99''::'';;''<<''==''>>''??''@@''AA''BB''CC''DD''EE''FF''GG''HH''II''JJ''KK''LL''MM''NN''OO''PP''QQ''RR''SS''TT''UU''VV''WW''XX''YY''ZZ''[['']]''^^''__''``''aa''bb''cc''dd''ee''ff''gg''hh''ii''jj''kk''ll''mm''nn''oo''pp''qq''rr''ss''tt''uu''vv''ww''xx''yy''zz''{{''||''}}''~~''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''\''\''\''\''\''\''\''\''		\	''

\
''\''\''

\
''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''  \ ''!!\!''""\"''##\#''$$\$''%%\%''&&\&''((\'''))\(''**\)''++\*'',,\+''--\,''..\-''//\.''00\/''11\0''22\1''33\2''44\3''55\4''66\5''77\6''88\7''99\8''::\9'';;\:''<<\;''==\<''>>\=''??\>''@@\?''AA\@''BB\A''CC\B''DD\C''EE\D''FF\E''GG\F''HH\G''II\H''JJ\I''KK\J''LL\K''MM\L''NN\M''OO\N''PP\O''QQ\P''RR\Q''SS\R''TT\S''UU\T''VV\U''WW\V''XX\W''YY\X''ZZ\Y''[[\Z'']]\[''^^\\''__\]''``\^''aa\_''bb\`''cc\a''dd\b''ee\c''ff\d''gg\e''hh\f''ii\g''jj\h''kk\i''ll\j''mm\k''nn\l''oo\m''pp\n''qq\o''rr\p''ss\q''tt\r''uu\s''vv\t''ww\u''xx\v''yy\w''zz\x''{{\y''||\z''}}\{''~~\|''\}''\~''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\ '\ '\ '\ '\ '\ '\ '\ '		\ '

\ '\ '\ '

\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '  \ '!!\ '""\ '##\ '$$\ '%%\ '&&\ '((\ '))\ '**\ '++\ ',,\ '--\ '..\ '//\ '00\ '11\ '22\ '33\ '44\ '55\ '66\ '77\ '88\ '99\ '::\ ';;\ '<<\ '==\ '>>\ '??\ '@@\ 'AA\ 'BB\ 'CC\ 'DD\ 'EE\ 'FF\ 'GG\ 'HH\ 'II\ 'JJ\ 'KK\ 'LL\ 'MM\ 'NN\ 'OO\ 'PP\ 'QQ\ 'RR\ 'SS\ 'TT\ 'UU\ 'VV\ 'WW\ 'XX\ 'YY\ 'ZZ\ '[[\ ']]\ '^^\ '__\ '``\ 'aa\ 'bb\ 'cc\ 'dd\ 'ee\ 'ff\ 'gg\ 'hh\ 'ii\ 'jj\ 'kk\ 'll\ 'mm\ 'nn\ 'oo\ 'pp\ 'qq\ 'rr\ 'ss\ 'tt\ 'uu\ 'vv\ 'ww\ 'xx\ 'yy\ 'zz\ '{{\ '||\ '}}\ '~~\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ '\ ' ' ' ' ' ' ' ' '		 '

 ' ' '

 ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' '   '!! '"" '## '$$ '%% '&& '(( ')) '** '++ ',, '-- '.. '// '00 '11 '22 '33 '44 '55 '66 '77 '88 '99 ':: ';; '<< '== '>> '?? '@@ 'AA 'BB 'CC 'DD 'EE 'FF 'GG 'HH 'II 'JJ 'KK 'LL 'MM 'NN 'OO 'PP 'QQ 'RR 'SS 'TT 'UU 'VV 'WW 'XX 'YY 'ZZ '[[ ']] '^^ '__ '`` 'aa 'bb 'cc 'dd 'ee 'ff 'gg 'hh 'ii 'jj 'kk 'll 'mm 'nn 'oo 'pp 'qq 'rr 'ss 'tt 'uu 'vv 'ww 'xx 'yy 'zz '{{ '|| '}} '~~ ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' '''''''''''''''''	''
''''''
'''''''''''''''''''''''''''''''''''''' ''!''"''#''$''%''&''('')''*''+'',''-''.''/''0''1''2''3''4''5''6''7''8''9'':'';''<''=''>''?''@''A''B''C''D''E''F''G''H''I''J''K''L''M''N''O''P''Q''R''S''T''U''V''W''X''Y''Z''['']''^''_''`''a''b''c''d''e''f''g''h''i''j''k''l''m''n''o''p''q''r''s''t''u''v''w''x''y''z''{''|''}''~''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''\''\''\''\''\''\''\''\''	\	''
\
''\''\''
\
''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\'' \ ''!\!''"\"''#\#''$\$''%\%''&\&''(\''')\(''*\)''+\*'',\+''-\,''.\-''/\.''0\/''1\0''2\1''3\2''4\3''5\4''6\5''7\6''8\7''9\8'':\9'';\:''<\;''=\<''>\=''?\>''@\?''A\@''B\A''C\B''D\C''E\D''F\E''G\F''H\G''I\H''J\I''K\J''L\K''M\L''N\M''O\N''P\O''Q\P''R\Q''S\R''T\S''U\T''V\U''W\V''X\W''Y\X''Z\Y''[\Z'']\[''^\\''_\]''`\^''a\_''b\`''c\a''d\b''e\c''f\d''g\e''h\f''i\g''j\h''k\i''l\j''m\k''n\l''o\m''p\n''q\o''r\p''s\q''t\r''u\s''v\t''w\u''x\v''y\w''z\x''{\y''|\z''}\{''~\|''\}''\~''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\'' ' ' ' ' ' ' ' '	 '
 ' ' '
 ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' '  '! '" '# '$ '% '& '( ') '* '+ ', '- '. '/ '0 '1 '2 '3 '4 '5 '6 '7 '8 '9 ': '; '< '= '> '? '@ 'A 'B 'C 'D 'E 'F 'G 'H 'I 'J 'K 'L 'M 'N 'O 'P 'Q 'R 'S 'T 'U 'V 'W 'X 'Y 'Z '[ '] '^ '_ '` 'a 'b 'c 'd 'e 'f 'g 'h 'i 'j 'k 'l 'm 'n 'o 'p 'q 'r 's 't 'u 'v 'w 'x 'y 'z '{ '| '} '~ ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' ' '''\''\''\''\''\''\''\''\''\	''\
''\''\''\
''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\ ''\!''\"''\#''\$''\%''\&''\'''\(''\)''\*''\+''\,''\-''\.''\/''\0''\1''\2''\3''\4''\5''\6''\7''\8''\9''\:''\;''\<''\=''\>''\?''\@''\A''\B''\C''\D''\E''\F''\G''\H''\I''\J''\K''\L''\M''\N''\O''\P''\Q''\R''\S''\T''\U''\V''\W''\X''\Y''\Z''\[''\\''\]''\^''\_''\`''\a''\b''\c''\d''\e''\f''\g''\h''\i''\j''\k''\l''\m''\n''\o''\p''\q''\r''\s''\t''\u''\v''\w''\x''\y''\z''\{''\|''\}''\~''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\'' - -"-'-:-?- -"-'-	:-
?- -"-
'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- - "-!'-#:-$?-% -&"-('-):-*?-+ -,"-.'-/:-0?-1 -2"-3'-4:-5?-6 -7"-8'-9:-;?-< -="->'-@:-A?-B -C"-D'-E:-F?-G -H"-I'-J:-K?-L -M"-N'-O:-P?-Q -R"-S'-T:-U?-V -W"-X'-Y:-Z?-[ -\"-]'-^:-_?-` -a"-b'-c:-d?-e -f"-g'-h:-i?-j -k"-l'-m:-n?-o -p"-q'-r:-s?-t -u"-v'-w:-x?-y -z"-{'-|:-}?-~ -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?- -"-'-:-?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--	
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:-- 
?--!
 --#
"--$
'--%
:--&
?--(
 --)
"--*
'--+
:--,
?---
 --.
"--/
'--0
:--1
?--2
 --3
"--4
'--5
:--6
?--7
 --8
"--9
'--;
:--<
?--=
 -->
"--@
'--A
:--B
?--C
 --D
"--E
'--F
:--G
?--H
 --I
"--J
'--K
:--L
?--M
 --N
"--O
'--P
:--Q
?--R
 --S
"--T
'--U
:--V
?--W
 --X
"--Y
'--Z
:--[
?--\
 --]
"--^
'--_
:--`
?--a
 --b
"--c
'--d
:--e
?--f
 --g
"--h
'--i
:--j
?--k
 --l
"--m
'--n
:--o
?--p
 --q
"--r
'--s
:--t
?--u
 --v
"--w
'--x
:--y
?--z
 --{
"--|
'--}
:--~
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--
?--
 --
"--
'--
:--  
--"
--'
--:
--?
-- 
--"
--'
--:
--?	
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
--  
--"!
--'"
--:#
--?$
-- %
--"&
--''
--:(
--?)
-- *
--"+
--',
--:-
--?.
-- /
--"0
--'1
--:2
--?3
-- 4
--"5
--'6
--:7
--?8
-- 9
--":
--';
--:<
--?=
-- >
--"?
--'@
--:A
--?B
-- C
--"D
--'E
--:F
--?G
-- H
--"I
--'J
--:K
--?L
-- M
--"N
--'O
--:P
--?Q
-- R
--"S
--'T
--:U
--?V
-- W
--"X
--'Y
--:Z
--?[
-- \
--"]
--'^
--:_
--?`
-- a
--"b
--'c
--:d
--?e
-- f
--"g
--'h
--:i
--?j
-- k
--"l
--'m
--:n
--?o
-- p
--"q
--'r
--:s
--?t
-- u
--"v
--'w
--:x
--?y
-- z
--"{
--'|
--:}
--?~
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
--?
-- 
--"
--'
--:
-- 
--"
--'
--:
--?
- -"-'-:-?/ /"/'/:/?/ /"/'/	:/
?/ /"/
'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ / "/!'/#:/$?/% /&"/('/):/+?/, /-"/.'//:/0?/1 /2"/3'/4:/5?/6 /7"/8'/9:/;?/< /="/>'/@:/A?/B /C"/D'/E:/F?/G /H"/I'/J:/K?/L /M"/N'/O:/P?/Q /R"/S'/T:/U?/V /W"/X'/Y:/Z?/[ /\"/]'/^:/_?/` /a"/b'/c:/d?/e /f"/g'/h:/i?/j /k"/l'/m:/n?/o /p"/q'/r:/s?/t /u"/v'/w:/x?/y /z"/{'/|:/}?/~ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/ /"/'/:/?/*  **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*	:**//*
?	**//* 
**//*"**//*
'**//*:
**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//* "**//*!' **//*#:!**//*$?"**//*% #**//*&"$**//*('%**//*):&**//*+?'**//*, (**//*-")**//*.'+**//*/:,**//*0?-**//*1 .**//*2"/**//*3'0**//*4:1**//*5?2**//*6 3**//*7"4**//*8'5**//*9:6**//*;?7**//*< 8**//*="9**//*>':**//*@:;**//*A?<**//*B =**//*C">**//*D'?**//*E:@**//*F?A**//*G B**//*H"C**//*I'D**//*J:E**//*K?F**//*L G**//*M"H**//*N'I**//*O:J**//*P?K**//*Q L**//*R"M**//*S'N**//*T:O**//*U?P**//*V Q**//*W"R**//*X'S**//*Y:T**//*Z?U**//*[ V**//*\"W**//*]'X**//*^:Y**//*_?Z**//*` [**//*a"\**//*b']**//*c:^**//*d?_**//*e `**//*f"a**//*g'b**//*h:c**//*i?d**//*j e**//*k"f**//*l'g**//*m:h**//*n?i**//*o j**//*p"k**//*q'l**//*r:m**//*s?n**//*t o**//*u"p**//*v'q**//*w:r**//*x?s**//*y t**//*z"u**//*{'v**//*|:w**//*}?x**//*~ y**//*"z**//*'{**//*:|**//*?}**//* ~**//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//* **//*"**//*'**//*:**//*?**//*  *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*	:*//*
?	*//* 
*//*"*//*
'*//*:
*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//* "*//*!' *//*#:!*//*$?"*//*% #*//*&"$*//*('%*//*):&*//*+?'*//*, (*//*-")*//*.'+*//*/:,*//*0?-*//*1 .*//*2"/*//*3'0*//*4:1*//*5?2*//*6 3*//*7"4*//*8'5*//*9:6*//*;?7*//*< 8*//*="9*//*>':*//*@:;*//*A?<*//*B =*//*C">*//*D'?*//*E:@*//*F?A*//*G B*//*H"C*//*I'D*//*J:E*//*K?F*//*L G*//*M"H*//*N'I*//*O:J*//*P?K*//*Q L*//*R"M*//*S'N*//*T:O*//*U?P*//*V Q*//*W"R*//*X'S*//*Y:T*//*Z?U*//*[ V*//*\"W*//*]'X*//*^:Y*//*_?Z*//*` [*//*a"\*//*b']*//*c:^*//*d?_*//*e `*//*f"a*//*g'b*//*h:c*//*i?d*//*j e*//*k"f*//*l'g*//*m:h*//*n?i*//*o j*//*p"k*//*q'l*//*r:m*//*s?n*//*t o*//*u"p*//*v'q*//*w:r*//*x?s*//*y t*//*z"u*//*{'v*//*|:w*//*}?x*//*~ y*//*"z*//*'{*//*:|*//*?}*//* ~*//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*	:*//*
?*//* *//*"*//*
'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//* "*//*!'*//*#:*//*$?*//*% *//*&"*//*('*//*):*//*+?*//*, *//*-"*//*.'*//*/:*//*0?*//*1 *//*2"*//*3'*//*4:*//*5?*//*6 *//*7"*//*8'*//*9:*//*;?*//*< *//*="*//*>'*//*@:*//*A?*//*B *//*C"*//*D'*//*E:*//*F?*//*G *//*H"*//*I'*//*J:*//*K?*//*L *//*M"*//*N'*//*O:*//*P?*//*Q *//*R"*//*S'*//*T:*//*U?*//*V *//*W"*//*X'*//*Y:*//*Z?*//*[ *//*\"*//*]'*//*^:*//*_?*//*` *//*a"*//*b'*//*c:*//*d?*//*e *//*f"*//*g'*//*h:*//*i?*//*j *//*k"*//*l'*//*m:*//*n?*//*o *//*p"*//*q'*//*r:*//*s?*//*t *//*u"*//*v'*//*w:*//*x?*//*y *//*z"*//*{'*//*|:*//*}?*//*~ *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//* *//*"*//*'*//*:*//*?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//*	*	:*//*
*
?*//** *//**"*//*
*
'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//* * "*//*!*!'*//*#*#:*//*$*$?*//*%*% *//*&*&"*//*(*('*//*)*):*//*+*+?*//*,*, *//*-*-"*//*.*.'*//*/*0:*//*0*1?*//*1*2 *//*2*3"*//*3*4'*//*4*5:*//*5*6?*//*6*7 *//*7*8"*//*8*9'*//*9*;:*//*;*<?*//*<*= *//*=*>"*//*>*@'*//*@*A:*//*A*B?*//*B*C *//*C*D"*//*D*E'*//*E*F:*//*F*G?*//*G*H *//*H*I"*//*I*J'*//*J*K:*//*K*L?*//*L*M *//*M*N"*//*N*O'*//*O*P:*//*P*Q?*//*Q*R *//*R*S"*//*S*T'*//*T*U:*//*U*V?*//*V*W *//*W*X"*//*X*Y'*//*Y*Z:*//*Z*[?*//*[*\ *//*\*]"*//*]*^'*//*^*_:*//*_*`?*//*`*a *//*a*b"*//*b*c'*//*c*d:*//*d*e?*//*e*f *//*f*g"*//*g*h'*//*h*i:*//*i*j?*//*j*k *//*k*l"*//*l*m'*//*m*n:*//*n*o?*//*o*p *//*p*q"*//*q*r'*//*r*s:*//*s*t?*//*t*u *//*u*v"*//*v*w'*//*w*x:*//*x*y?*//*y*z *//*z*{"*//*{*|'*//*|*}:*//*}*~?*//*~* *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//*	*:*//*
*?*//** *//**"*//*
*'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//* *"*//*!*'*//*#*:*//*$*?*//*%* *//*&*"*//*(*'*//*)*:*//*+*?*//*,* *//*-*"*//*.*'*//*/*:*//*0*?*//*1* *//*2*"*//*3*'*//*4*:*//*5*?*//*6* *//*7*"*//*8*'*//*9*:*//*;*?*//*<* *//*=*"*//*>*'*//*@*:*//*A*?*//*B* *//*C*"*//*D*'*//*E*:*//*F*?*//*G* *//*H*"*//*I*'*//*J*:*//*K*?*//*L* *//*M*"*//*N*'*//*O*:*//*P*?*//*Q* *//*R*"*//*S*'*//*T*:*//*U*?*//*V* *//*W*"*//*X*'*//*Y*:*//*Z*?*//*[* *//*\*"*//*]*'*//*^*:*//*_*?*//*`* *//*a*"*//*b*'*//*c*:*//*d*?*//*e* *//*f*"*//*g*'*//*h*:*//*i*?*//*j* *//*k*"*//*l*'*//*m*:*//*n*?*//*o* *//*p*"*//*q*'*//*r*:*//*s*?*//*t* *//*u*"*//*v*'*//*w*:*//*x*?*//*y* *//*z*"*//*{*'*//*|*:*//*}*?*//*~* *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//*	**	:*//*
**
?*//*** *//***"*//*
**
'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//* ** "*//*!**!'*//*#**#:*//*$**$?*//*%**% *//*&**&"*//*(**('*//*)**):*//*+**+?*//*,**, *//*-**-"*//*.**.'*//*/**0:*//*0**1?*//*1**2 *//*2**3"*//*3**4'*//*4**5:*//*5**6?*//*6**7 *//*7**8"*//*8**9'*//*9**;:*//*;**<?*//*<**= *//*=**>"*//*>**@'*//*@**A:*//*A**B?*//*B**C *//*C**D"*//*D**E'*//*E**F:*//*F**G?*//*G**H *//*H**I"*//*I**J'*//*J**K:*//*K**L?*//*L**M *//*M**N"*//*N**O'*//*O**P:*//*P**Q?*//*Q**R *//*R**S"*//*S**T'*//*T**U:*//*U**V?*//*V**W *//*W**X"*//*X**Y'*//*Y**Z:*//*Z**[?*//*[**\ *//*\**]"*//*]**^'*//*^**_:*//*_**`?*//*`**a *//*a**b"*//*b**c'*//*c**d:*//*d**e?*//*e**f *//*f**g"*//*g**h'*//*h**i:*//*i**j?*//*j**k *//*k**l"*//*l**m'*//*m**n:*//*n**o?*//*o**p *//*p**q"*//*q**r'*//*r**s:*//*s**t?*//*t**u *//*u**v"*//*v**w'*//*w**x:*//*x**y?*//*y**z *//*z**{"*//*{**|'*//*|**}:*//*}**~?*//*~** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//*** *//***"*//***'*//***:*//***?*//**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/*	*/	:/*
*/
?/**/ /**/"/*
*/
'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /* */ "/*!*/!'/*#*/#:/*$*/$?/*%*/% /*&*/&"/*(*/('/*)*/):/*+*/*?/*,*/+ /*-*/,"/*.*/-'/*/*/.:/*0*//?/*1*/0 /*2*/1"/*3*/2'/*4*/3:/*5*/4?/*6*/5 /*7*/6"/*8*/7'/*9*/8:/*;*/9?/*<*/; /*=*/<"/*>*/='/*@*/>:/*A*/@?/*B*/A /*C*/B"/*D*/C'/*E*/D:/*F*/E?/*G*/F /*H*/G"/*I*/H'/*J*/I:/*K*/J?/*L*/K /*M*/L"/*N*/M'/*O*/N:/*P*/O?/*Q*/P /*R*/Q"/*S*/R'/*T*/S:/*U*/T?/*V*/U /*W*/V"/*X*/W'/*Y*/X:/*Z*/Y?/*[*/Z /*\*/["/*]*/\'/*^*/]:/*_*/^?/*`*/_ /*a*/`"/*b*/a'/*c*/b:/*d*/c?/*e*/d /*f*/e"/*g*/f'/*h*/g:/*i*/h?/*j*/i /*k*/j"/*l*/k'/*m*/l:/*n*/m?/*o*/n /*p*/o"/*q*/p'/*r*/q:/*s*/r?/*t*/s /*u*/t"/*v*/u'/*w*/v:/*x*/w?/*y*/x /*z*/y"/*{*/z'/*|*/{:/*}*/|?/*~*/} /**/~"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/*	*/:/*
*/?/**/ /**/"/*
*/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /* */"/*!*/'/*#*/:/*$*/?/*%*/ /*&*/"/*(*/'/*)*/:/*+*/?/*,*/ /*-*/"/*.*/'/*/*/:/*0*/?/*1*/ /*2*/"/*3*/'/*4*/:/*5*/?/*6*/ /*7*/"/*8*/'/*9*/:/*;*/?/*<*/ /*=*/"/*>*/'/*@*/:/*A*/?/*B*/ /*C*/"/*D*/'/*E*/:/*F*/?/*G*/ /*H*/"/*I*/'/*J*/:/*K*/?/*L*/ /*M*/"/*N*/'/*O*/:/*P*/?/*Q*/ /*R*/"/*S*/'/*T*/:/*U*/?/*V*/ /*W*/"/*X*/'/*Y*/:/*Z*/?/*[*/ /*\*/"/*]*/'/*^*/:/*_*/?/*`*/ /*a*/"/*b*/'/*c*/:/*d*/?/*e*/ /*f*/"/*g*/'/*h*/:/*i*/?/*j*/ /*k*/"/*l*/'/*m*/:/*n*/?/*o*/ /*p*/"/*q*/'/*r*/:/*s*/?/*t*/ /*u*/"/*v*/'/*w*/:/*x*/?/*y*/ /*z*/"/*{*/'/*|*/:/*}*/?/*~*/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/**/ /**/"/**/'/**/:/**/?/* *//*"*//*'*//*:*//*?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**	:*//**
?*//** *//**"*//**
'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//** "*//**!'*//**#:*//**$?*//**% *//**&"*//**('*//**):*//**+?*//**, *//**-"*//**.'*//**0:*//**1?*//**2 *//**3"*//**4'*//**5:*//**6?*//**7 *//**8"*//**9'*//**;:*//**<?*//**= *//**>"*//**@'*//**A:*//**B?*//**C *//**D"*//**E'*//**F:*//**G?*//**H *//**I"*//**J'*//**K:*//**L?*//**M *//**N"*//**O'*//**P:*//**Q?*//**R *//**S"*//**T'*//**U:*//**V?*//**W *//**X"*//**Y'*//**Z:*//**[?*//**\ *//**]"*//**^'*//**_:*//**`?*//**a *//**b"*//**c'*//**d:*//**e?*//**f *//**g"*//**h'*//**i:*//**j?*//**k *//**l"*//**m'*//**n:*//**o?*//**p *//**q"*//**r'*//**s:*//**t?*//**u *//**v"*//**w'*//**x:*//**y?*//**z *//**{"*//**|'*//**}:*//**~?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*//**?*//** *//**"*//**'*//**:*// /"/'/:/?:00 :11:22:33:44:55:66:77:88:99	:AA
:BB:CC:DD
:EE:FF:GG:HH:II:JJ:KK:LL:MM:NN:OO:PP:QQ:RR:SS:TT:UU:VV:WW :XX!:YY":ZZ#:__$:aa%:bb&:cc':dd(:ee):ff*:gg+:hh,:ii-:jj.:kk/:ll::mm;:nn<:oo=:pp>:qq?:rr@:ss[:tt\:uu]:vv^:ww`:xx{:yy|:zz}:00~:11:22:33:44:55:66:77:88:99:AA:BB:CC:DD:EE:FF:GG:HH:II:JJ:KK:LL:MM:NN:OO:PP:QQ:RR:SS:TT:UU:VV:WW:XX:YY:ZZ:__:aa:bb:cc:dd:ee:ff:gg:hh:ii:jj:kk:ll:mm:nn:oo:pp:qq:rr:ss:tt:uu:vv:ww:xx:yy:zz:00:11:22:33:44:55:66:77:88:99:AA:BB:CC:DD:EE:FF:GG:HH:II:JJ:KK:LL:MM:NN:OO:PP:QQ:RR:SS:TT:UU:VV:WW:XX:YY:ZZ:__:aa:bb:cc:dd:ee:ff:gg:hh:ii:jj:kk:ll:mm:nn:oo:pp:qq:rr:ss:tt:uu:vv:ww:xx:yy:zz:00:11:22:33:0 :1:2:3:4:5:6:7:8:9	:A
:B:C:D
:E:F:G:H:I:J:K:L:M:N:O:P:Q:R:S:T:U:V:W :X!:Y":Z#:_$:a%:b&:c':d(:e):f*:g+:h,:i-:j.:k/:l::m;:n<:o=:p>:q?:r@:s[:t\:u]:v^:w`:x{:y|:z}:0~:1:2:3:4:5:6:7:8:9:A:B:C:D:E:F:G:H:I:J:K:L:M:N:O:P:Q:R:S:T:U:V:W:X:Y:Z:_:a:b:c:d:e:f:g:h:i:j:k:l:m:n:o:p:q:r:s:t:u:v:w:x:y:z:0:1:2:3:4:5:6:7:8:9:A:B:C:D:E:F:G:H:I:J:K:L:M:N:O:P:Q:R:S:T:U:V:W:X:Y:Z:_:a:b:c:d:e:f:g:h:i:j:k:l:m:n:o:p:q:r:s:t:u:v:w:x:y:z:0:1:2:3::: :::::::::::::::::::::::::::	:::
:::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::: :::!:::":::#:::$:::%:::&:::':::(:::):::*:::+:::,:::-:::.:::/:::0:::1:::2:::3:::4:::5:::6:::7:::8:::9:::;:::<:::=:::>:::?:::@:::A:::B:::C:::D:::E:::F:::G:::H:::I:::J:::K:::L:::M:::N:::O:::P:::Q:::R:::S:::T:::U:::V:::W:::X:::Y:::Z:::[:::\:::]:::^:::_:::`:::a:::b:::c:::d:::e:::f:::g:::h:::i:::j:::k:::l:::m:::n:::o:::p:::q:::r:::s:::t:::u:::v:::w:::x:::y:::z:::{:::|:::}:::~::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: ::::::::::::::::::	::
::::::
:::::::::::::::::::::::::::::::::::::: ::!::"::#::$::%::&::'::(::)::*::+::,::-::.::/::0::1::2::3::4::5::6::7::8::9::;::<::=::>::?::@::A::B::C::D::E::F::G::H::I::J::K::L::M::N::O::P::Q::R::S::T::U::V::W::X::Y::Z::[::\::]::^::_::`::a::b::c::d::e::f::g::h::i::j::k::l::m::n::o::p::q::r::s::t::u::v::w::x::y::z::{::|::}::~::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: :::::::::	:
:::
::::::::::::::::::: :!:":#:$:%:&:':(:):*:+:,:-:.:/:;:<:=:>:?:@:[:\:]:^:`:{:|:}:~:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::??? ???????????????????????????	???
?????????
????????????????????????????????????????????????????????? ???!???"???#???$???%???&???'???(???)???*???+???,???-???.???/???0???1???2???3???4???5???6???7???8???9???:???;???<???=???>???@???A???B???C???D???E???F???G???H???I???J???K???L???M???N???O???P???Q???R???S???T???U???V???W???X???Y???Z???[???\???]???^???_???`???a???b???c???d???e???f???g???h???i???j???k???l???m???n???o???p???q???r???s???t???u???v???w???x???y???z???{???|???}???~????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????? ??????????????????	??
??????
?????????????????????????????????????? ??!??"??#??$??%??&??'??(??)??*??+??,??-??.??/??0??1??2??3??4??5??6??7??8??9??:??;??<??=??>??@??A??B??C??D??E??F??G??H??I??J??K??L??M??N??O??P??Q??R??S??T??U??V??W??X??Y??Z??[??\??]??^??_??`??a??b??c??d??e??f??g??h??i??j??k??l??m??n??o??p??q??r??s??t??u??v??w??x??y??z??{??|??}??~??????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????? ?????????	?
???
??????????????????? ?!?"?#?$?%?&?'?(?)?*?+?,?-?.?/?0?1?2?3?4?5?6?7?8?9?:?;?<?=?>?@?A?B?C?D?E?F?G?H?I?J?K?L?M?N?O?P?Q?R?S?T?U?V?W?X?Y?Z?[?\?]?^?_?`?a?b?c?d?e?f?g?h?i?j?k?l?m?n?o?p?q?r?s?t?u?v?w?x?y?z?{?|?}?~?????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																				 re2c: warning: line 66: control flow is undefined for strings that match '\x0', use default rule '*' [-Wundefined-control-flow]
