# Contributing to Eclipse Kuksa

Thanks for your interest in this project.

## Project description

Because today's software-intensive automotive systems are still developed in
silos by each car manufacturer or OEM in-house, long-term challenges in the
industry are yet unresolved. Establishing a standard for car-to-cloud scenarios
significantly improves comprehensive domain-related development activities and
opens the market to external applications, service provider, and the use of open
source software wherever possible without compromising security. Connectivity,
OTA maintenance, automated driving, electric mobility, and related approaches
increasingly demand technical innovations applicable across automotive players.

* https://projects.eclipse.org/projects/iot.kuksa

## Developer resources

Information regarding source code management, builds, coding standards, and
more.

* https://projects.eclipse.org/projects/iot.kuksa/developer

The project maintains the following source code repositories

* https://github.com/eclipse/kuksa.apps
* https://github.com/eclipse/kuksa.cloud
* https://github.com/eclipse/kuksa.ide
* https://github.com/eclipse/kuksa.integration
* https://github.com/eclipse/kuksa.invehicle
* https://github.com/eclipse/kuksa.website
* https://github.com/eclipse/kuksa.val

This project uses Bugzilla to track ongoing development and issues.

* Search for issues: https://bugs.eclipse.org/bugs/buglist.cgi?product=Kuksa
* Create a new report:
   https://bugs.eclipse.org/bugs/enter_bug.cgi?product=Kuksa

Be sure to search for existing bugs before you create another one. Remember that
contributions are always welcome!

## Eclipse Contributor Agreement

Before your contribution can be accepted by the project team contributors must
electronically sign the Eclipse Contributor Agreement (ECA).

* http://www.eclipse.org/legal/ECA.php

Commits that are provided by non-committers must have a Signed-off-by field in
the footer indicating that the author is aware of the terms by which the
contribution has been provided to the project. The non-committer must
additionally have an Eclipse Foundation account and must have a signed Eclipse
Contributor Agreement (ECA) on file.

For more information, please see the Eclipse Committer Handbook:
https://www.eclipse.org/projects/handbook/#resources-commit

## Contact

Contact the project developers via the project's "dev" list.

* https://dev.eclipse.org/mailman/listinfo/kuksa-dev
