// Copyright (c) 2014-2021 LG Electronics, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// SPDX-License-Identifier: Apache-2.0

#ifndef CORE_PLUGIN_SERVICE_H_
#define CORE_PLUGIN_SERVICE_H_

#include <list>
#include <string>

class WebAppBase;

class PlugInService {
 public:
  virtual ~PlugInService() {}
  virtual void StartService() = 0;

 protected:
  WebAppBase* FindAppById(const std::string& app_id);
  WebAppBase* FindAppByInstanceId(const std::string& instance_id);
  std::string GetActiveInstanceId();

  std::list<const WebAppBase*> RunningApps();
};

#endif  // CORE_PLUGIN_SERVICE_H_
