// Copyright (c) 2014, the Dart project authors.
// Please see the AUTHORS file
// for details. All rights reserved. Use of this source
// code is governed by a
// BSD-style license that can be found in the LICENSE file.

/// Date/time formatting symbols for all locales.
///
/// DO NOT EDIT. This file is autogenerated by script.  See
/// http://go/generate_number_constants.py using the --for_dart flag.
///
/// Before checkin, this file could have been manually edited. This is
/// to incorporate changes before we could correct CLDR. All manual
/// modification must be documented in this section, and should be
/// removed after those changes land to CLDR.

// MANUAL EDIT TO SUPPRESS WARNINGS IN GENERATED CODE
// ignore_for_file: unnecessary_new, prefer_single_quotes, prefer_const_constructors
library number_symbol_data;

import "number_symbols.dart";

/// Map from locale to [NumberSymbols] used for that locale.
Map<dynamic, dynamic> numberFormatSymbols = <String, NumberSymbols>{
  // Number formatting symbols for locale af.
  "af": new NumberSymbols(
      NAME: "af",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'ZAR'),
  // Number formatting symbols for locale am.
  "am": new NumberSymbols(
      NAME: "am",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'ETB'),
  // Number formatting symbols for locale ar.
  "ar": new NumberSymbols(
      NAME: "ar",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '\u200E%\u200E',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '\u200E+',
      MINUS_SIGN: '\u200E-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: '\u0644\u064A\u0633\u00A0\u0631\u0642\u0645\u064B\u0627',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4\u00A0#,##0.00',
      DEF_CURRENCY_CODE: 'EGP'),
  // Number formatting symbols for locale ar_DZ.
  "ar_DZ": new NumberSymbols(
      NAME: "ar_DZ",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '\u200E%\u200E',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '\u200E+',
      MINUS_SIGN: '\u200E-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: '\u0644\u064A\u0633\u00A0\u0631\u0642\u0645\u064B\u0627',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4\u00A0#,##0.00',
      DEF_CURRENCY_CODE: 'DZD'),
  // Number formatting symbols for locale ar_EG.
  "ar_EG": new NumberSymbols(
      NAME: "ar_EG",
      DECIMAL_SEP: '\u066B',
      GROUP_SEP: '\u066C',
      PERCENT: '\u066A\u061C',
      ZERO_DIGIT: '\u0660',
      PLUS_SIGN: '\u061C+',
      MINUS_SIGN: '\u061C-',
      EXP_SYMBOL: '\u0627\u0633',
      PERMILL: '\u0609',
      INFINITY: '\u221E',
      NAN: '\u0644\u064A\u0633\u00A0\u0631\u0642\u0645',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EGP'),
  // Number formatting symbols for locale az.
  "az": new NumberSymbols(
      NAME: "az",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'AZN'),
  // Number formatting symbols for locale be.
  "be": new NumberSymbols(
      NAME: "be",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'BYN'),
  // Number formatting symbols for locale bg.
  "bg": new NumberSymbols(
      NAME: "bg",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'BGN'),
  // Number formatting symbols for locale bn.
  "bn": new NumberSymbols(
      NAME: "bn",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '\u09E6',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##,##0.00\u00A4',
      DEF_CURRENCY_CODE: 'BDT'),
  // Number formatting symbols for locale br.
  "br": new NumberSymbols(
      NAME: "br",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale bs.
  "bs": new NumberSymbols(
      NAME: "bs",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'BAM'),
  // Number formatting symbols for locale ca.
  "ca": new NumberSymbols(
      NAME: "ca",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale chr.
  "chr": new NumberSymbols(
      NAME: "chr",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'USD'),
  // Number formatting symbols for locale cs.
  "cs": new NumberSymbols(
      NAME: "cs",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'CZK'),
  // Number formatting symbols for locale cy.
  "cy": new NumberSymbols(
      NAME: "cy",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'GBP'),
  // Number formatting symbols for locale da.
  "da": new NumberSymbols(
      NAME: "da",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'DKK'),
  // Number formatting symbols for locale de.
  "de": new NumberSymbols(
      NAME: "de",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale de_AT.
  "de_AT": new NumberSymbols(
      NAME: "de_AT",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '\u00A4\u00A0#,##0.00',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale de_CH.
  "de_CH": new NumberSymbols(
      NAME: "de_CH",
      DECIMAL_SEP: '.',
      GROUP_SEP: '\u2019',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4\u00A0#,##0.00;\u00A4-#,##0.00',
      DEF_CURRENCY_CODE: 'CHF'),
  // Number formatting symbols for locale el.
  "el": new NumberSymbols(
      NAME: "el",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'e',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale en.
  "en": new NumberSymbols(
      NAME: "en",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'USD'),
  // Number formatting symbols for locale en_AU.
  "en_AU": new NumberSymbols(
      NAME: "en_AU",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'e',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'AUD'),
  // Number formatting symbols for locale en_CA.
  "en_CA": new NumberSymbols(
      NAME: "en_CA",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'e',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'CAD'),
  // Number formatting symbols for locale en_GB.
  "en_GB": new NumberSymbols(
      NAME: "en_GB",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'GBP'),
  // Number formatting symbols for locale en_IE.
  "en_IE": new NumberSymbols(
      NAME: "en_IE",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale en_IN.
  "en_IN": new NumberSymbols(
      NAME: "en_IN",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##,##0%',
      CURRENCY_PATTERN: '\u00A4\u00A0#,##,##0.00',
      DEF_CURRENCY_CODE: 'INR'),
  // Number formatting symbols for locale en_MY.
  "en_MY": new NumberSymbols(
      NAME: "en_MY",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'MYR'),
  // Number formatting symbols for locale en_SG.
  "en_SG": new NumberSymbols(
      NAME: "en_SG",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'SGD'),
  // Number formatting symbols for locale en_US.
  "en_US": new NumberSymbols(
      NAME: "en_US",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'USD'),
  // Number formatting symbols for locale en_ZA.
  "en_ZA": new NumberSymbols(
      NAME: "en_ZA",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'ZAR'),
  // Number formatting symbols for locale es.
  "es": new NumberSymbols(
      NAME: "es",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale es_419.
  "es_419": new NumberSymbols(
      NAME: "es_419",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'MXN'),
  // Number formatting symbols for locale es_ES.
  "es_ES": new NumberSymbols(
      NAME: "es_ES",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale es_MX.
  "es_MX": new NumberSymbols(
      NAME: "es_MX",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'MXN'),
  // Number formatting symbols for locale es_US.
  "es_US": new NumberSymbols(
      NAME: "es_US",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'USD'),
  // Number formatting symbols for locale et.
  "et": new NumberSymbols(
      NAME: "et",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '\u2212',
      EXP_SYMBOL: '\u00D710^',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale eu.
  "eu": new NumberSymbols(
      NAME: "eu",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '\u2212',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '%\u00A0#,##0',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale fa.
  "fa": new NumberSymbols(
      NAME: "fa",
      DECIMAL_SEP: '\u066B',
      GROUP_SEP: '\u066C',
      PERCENT: '\u066A',
      ZERO_DIGIT: '\u06F0',
      PLUS_SIGN: '\u200E+',
      MINUS_SIGN: '\u200E\u2212',
      EXP_SYMBOL: '\u00D7\u06F1\u06F0^',
      PERMILL: '\u0609',
      INFINITY: '\u221E',
      NAN: '\u0646\u0627\u0639\u062F\u062F',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u200E\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'IRR'),
  // Number formatting symbols for locale fi.
  "fi": new NumberSymbols(
      NAME: "fi",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '\u2212',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'ep\u00E4luku',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale fil.
  "fil": new NumberSymbols(
      NAME: "fil",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'PHP'),
  // Number formatting symbols for locale fr.
  "fr": new NumberSymbols(
      NAME: "fr",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u202F',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale fr_CA.
  "fr_CA": new NumberSymbols(
      NAME: "fr_CA",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'CAD'),
  // Number formatting symbols for locale fr_CH.
  "fr_CH": new NumberSymbols(
      NAME: "fr_CH",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u202F',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'CHF'),
  // Number formatting symbols for locale ga.
  "ga": new NumberSymbols(
      NAME: "ga",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale gl.
  "gl": new NumberSymbols(
      NAME: "gl",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale gsw.
  "gsw": new NumberSymbols(
      NAME: "gsw",
      DECIMAL_SEP: '.',
      GROUP_SEP: '\u2019',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '\u2212',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'CHF'),
  // Number formatting symbols for locale gu.
  "gu": new NumberSymbols(
      NAME: "gu",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##,##0.###',
      SCIENTIFIC_PATTERN: '[#E0]',
      PERCENT_PATTERN: '#,##,##0%',
      CURRENCY_PATTERN: '\u00A4#,##,##0.00',
      DEF_CURRENCY_CODE: 'INR'),
  // Number formatting symbols for locale haw.
  "haw": new NumberSymbols(
      NAME: "haw",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'USD'),
  // Number formatting symbols for locale he.
  "he": new NumberSymbols(
      NAME: "he",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '\u200E+',
      MINUS_SIGN: '\u200E-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN:
          '\u200F#,##0.00\u00A0\u00A4;\u200F-#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'ILS'),
  // Number formatting symbols for locale hi.
  "hi": new NumberSymbols(
      NAME: "hi",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##,##0.###',
      SCIENTIFIC_PATTERN: '[#E0]',
      PERCENT_PATTERN: '#,##,##0%',
      CURRENCY_PATTERN: '\u00A4#,##,##0.00',
      DEF_CURRENCY_CODE: 'INR'),
  // Number formatting symbols for locale hr.
  "hr": new NumberSymbols(
      NAME: "hr",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'HRK'),
  // Number formatting symbols for locale hu.
  "hu": new NumberSymbols(
      NAME: "hu",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'HUF'),
  // Number formatting symbols for locale hy.
  "hy": new NumberSymbols(
      NAME: "hy",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: '\u0548\u0579\u0539',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'AMD'),
  // Number formatting symbols for locale id.
  "id": new NumberSymbols(
      NAME: "id",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'IDR'),
  // Number formatting symbols for locale in.
  "in": new NumberSymbols(
      NAME: "in",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'IDR'),
  // Number formatting symbols for locale is.
  "is": new NumberSymbols(
      NAME: "is",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'ISK'),
  // Number formatting symbols for locale it.
  "it": new NumberSymbols(
      NAME: "it",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale it_CH.
  "it_CH": new NumberSymbols(
      NAME: "it_CH",
      DECIMAL_SEP: '.',
      GROUP_SEP: '\u2019',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4\u00A0#,##0.00;\u00A4-#,##0.00',
      DEF_CURRENCY_CODE: 'CHF'),
  // Number formatting symbols for locale iw.
  "iw": new NumberSymbols(
      NAME: "iw",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '\u200E+',
      MINUS_SIGN: '\u200E-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN:
          '\u200F#,##0.00\u00A0\u00A4;\u200F-#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'ILS'),
  // Number formatting symbols for locale ja.
  "ja": new NumberSymbols(
      NAME: "ja",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'JPY'),
  // Number formatting symbols for locale ka.
  "ka": new NumberSymbols(
      NAME: "ka",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN:
          '\u10D0\u10E0\u00A0\u10D0\u10E0\u10D8\u10E1\u00A0\u10E0\u10D8\u10EA\u10EE\u10D5\u10D8',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'GEL'),
  // Number formatting symbols for locale kk.
  "kk": new NumberSymbols(
      NAME: "kk",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: '\u0441\u0430\u043D\u00A0\u0435\u043C\u0435\u0441',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'KZT'),
  // Number formatting symbols for locale km.
  "km": new NumberSymbols(
      NAME: "km",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A4',
      DEF_CURRENCY_CODE: 'KHR'),
  // Number formatting symbols for locale kn.
  "kn": new NumberSymbols(
      NAME: "kn",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'INR'),
  // Number formatting symbols for locale ko.
  "ko": new NumberSymbols(
      NAME: "ko",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'KRW'),
  // Number formatting symbols for locale ky.
  "ky": new NumberSymbols(
      NAME: "ky",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: '\u0441\u0430\u043D\u00A0\u044D\u043C\u0435\u0441',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'KGS'),
  // Number formatting symbols for locale ln.
  "ln": new NumberSymbols(
      NAME: "ln",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'CDF'),
  // Number formatting symbols for locale lo.
  "lo": new NumberSymbols(
      NAME: "lo",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN:
          '\u0E9A\u0ECD\u0EC8\u200B\u0EC1\u0EA1\u0EC8\u0E99\u200B\u0EC2\u0E95\u200B\u0EC0\u0EA5\u0E81',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00;\u00A4-#,##0.00',
      DEF_CURRENCY_CODE: 'LAK'),
  // Number formatting symbols for locale lt.
  "lt": new NumberSymbols(
      NAME: "lt",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '\u2212',
      EXP_SYMBOL: '\u00D710^',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale lv.
  "lv": new NumberSymbols(
      NAME: "lv",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NS',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale mk.
  "mk": new NumberSymbols(
      NAME: "mk",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'MKD'),
  // Number formatting symbols for locale ml.
  "ml": new NumberSymbols(
      NAME: "ml",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'INR'),
  // Number formatting symbols for locale mn.
  "mn": new NumberSymbols(
      NAME: "mn",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4\u00A0#,##0.00',
      DEF_CURRENCY_CODE: 'MNT'),
  // Number formatting symbols for locale mr.
  "mr": new NumberSymbols(
      NAME: "mr",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '\u0966',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##,##0.###',
      SCIENTIFIC_PATTERN: '[#E0]',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'INR'),
  // Number formatting symbols for locale ms.
  "ms": new NumberSymbols(
      NAME: "ms",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'MYR'),
  // Number formatting symbols for locale mt.
  "mt": new NumberSymbols(
      NAME: "mt",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale my.
  "my": new NumberSymbols(
      NAME: "my",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '\u1040',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN:
          '\u1002\u100F\u1014\u103A\u1038\u1019\u101F\u102F\u1010\u103A\u101E\u1031\u102C',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'MMK'),
  // Number formatting symbols for locale nb.
  "nb": new NumberSymbols(
      NAME: "nb",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '\u2212',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '\u00A4\u00A0#,##0.00',
      DEF_CURRENCY_CODE: 'NOK'),
  // Number formatting symbols for locale ne.
  "ne": new NumberSymbols(
      NAME: "ne",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '\u0966',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4\u00A0#,##0.00',
      DEF_CURRENCY_CODE: 'NPR'),
  // Number formatting symbols for locale nl.
  "nl": new NumberSymbols(
      NAME: "nl",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4\u00A0#,##0.00;\u00A4\u00A0-#,##0.00',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale no.
  "no": new NumberSymbols(
      NAME: "no",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '\u2212',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '\u00A4\u00A0#,##0.00',
      DEF_CURRENCY_CODE: 'NOK'),
  // Number formatting symbols for locale no_NO.
  "no_NO": new NumberSymbols(
      NAME: "no_NO",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '\u2212',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '\u00A4\u00A0#,##0.00',
      DEF_CURRENCY_CODE: 'NOK'),
  // Number formatting symbols for locale or.
  "or": new NumberSymbols(
      NAME: "or",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'INR'),
  // Number formatting symbols for locale pa.
  "pa": new NumberSymbols(
      NAME: "pa",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##,##0.###',
      SCIENTIFIC_PATTERN: '[#E0]',
      PERCENT_PATTERN: '#,##,##0%',
      CURRENCY_PATTERN: '\u00A4\u00A0#,##,##0.00',
      DEF_CURRENCY_CODE: 'INR'),
  // Number formatting symbols for locale pl.
  "pl": new NumberSymbols(
      NAME: "pl",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'PLN'),
  // Number formatting symbols for locale ps.
  "ps": new NumberSymbols(
      NAME: "ps",
      DECIMAL_SEP: '\u066B',
      GROUP_SEP: '\u066C',
      PERCENT: '\u066A',
      ZERO_DIGIT: '\u06F0',
      PLUS_SIGN: '\u200E+\u200E',
      MINUS_SIGN: '\u200E-\u200E',
      EXP_SYMBOL: '\u00D7\u06F1\u06F0^',
      PERMILL: '\u0609',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'AFN'),
  // Number formatting symbols for locale pt.
  "pt": new NumberSymbols(
      NAME: "pt",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4\u00A0#,##0.00',
      DEF_CURRENCY_CODE: 'BRL'),
  // Number formatting symbols for locale pt_BR.
  "pt_BR": new NumberSymbols(
      NAME: "pt_BR",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4\u00A0#,##0.00',
      DEF_CURRENCY_CODE: 'BRL'),
  // Number formatting symbols for locale pt_PT.
  "pt_PT": new NumberSymbols(
      NAME: "pt_PT",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale ro.
  "ro": new NumberSymbols(
      NAME: "ro",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'RON'),
  // Number formatting symbols for locale ru.
  "ru": new NumberSymbols(
      NAME: "ru",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: '\u043D\u0435\u00A0\u0447\u0438\u0441\u043B\u043E',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'RUB'),
  // Number formatting symbols for locale si.
  "si": new NumberSymbols(
      NAME: "si",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'LKR'),
  // Number formatting symbols for locale sk.
  "sk": new NumberSymbols(
      NAME: "sk",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'e',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale sl.
  "sl": new NumberSymbols(
      NAME: "sl",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '\u2212',
      EXP_SYMBOL: 'e',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale sq.
  "sq": new NumberSymbols(
      NAME: "sq",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'ALL'),
  // Number formatting symbols for locale sr.
  "sr": new NumberSymbols(
      NAME: "sr",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'RSD'),
  // Number formatting symbols for locale sr_Latn.
  "sr_Latn": new NumberSymbols(
      NAME: "sr_Latn",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'RSD'),
  // Number formatting symbols for locale sv.
  "sv": new NumberSymbols(
      NAME: "sv",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '\u2212',
      EXP_SYMBOL: '\u00D710^',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'SEK'),
  // Number formatting symbols for locale sw.
  "sw": new NumberSymbols(
      NAME: "sw",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4\u00A0#,##0.00',
      DEF_CURRENCY_CODE: 'TZS'),
  // Number formatting symbols for locale ta.
  "ta": new NumberSymbols(
      NAME: "ta",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##,##0%',
      CURRENCY_PATTERN: '\u00A4\u00A0#,##,##0.00',
      DEF_CURRENCY_CODE: 'INR'),
  // Number formatting symbols for locale te.
  "te": new NumberSymbols(
      NAME: "te",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##,##0.00',
      DEF_CURRENCY_CODE: 'INR'),
  // Number formatting symbols for locale th.
  "th": new NumberSymbols(
      NAME: "th",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'THB'),
  // Number formatting symbols for locale tl.
  "tl": new NumberSymbols(
      NAME: "tl",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'PHP'),
  // Number formatting symbols for locale tr.
  "tr": new NumberSymbols(
      NAME: "tr",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '%#,##0',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'TRY'),
  // Number formatting symbols for locale uk.
  "uk": new NumberSymbols(
      NAME: "uk",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: '\u0415',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'UAH'),
  // Number formatting symbols for locale ur.
  "ur": new NumberSymbols(
      NAME: "ur",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '\u200E+',
      MINUS_SIGN: '\u200E-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4\u00A0#,##0.00',
      DEF_CURRENCY_CODE: 'PKR'),
  // Number formatting symbols for locale uz.
  "uz": new NumberSymbols(
      NAME: "uz",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'son\u00A0emas',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'UZS'),
  // Number formatting symbols for locale vi.
  "vi": new NumberSymbols(
      NAME: "vi",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'VND'),
  // Number formatting symbols for locale zh.
  "zh": new NumberSymbols(
      NAME: "zh",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'CNY'),
  // Number formatting symbols for locale zh_CN.
  "zh_CN": new NumberSymbols(
      NAME: "zh_CN",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'CNY'),
  // Number formatting symbols for locale zh_HK.
  "zh_HK": new NumberSymbols(
      NAME: "zh_HK",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: '\u975E\u6578\u503C',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'HKD'),
  // Number formatting symbols for locale zh_TW.
  "zh_TW": new NumberSymbols(
      NAME: "zh_TW",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: '\u975E\u6578\u503C',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'TWD'),
  // Number formatting symbols for locale zu.
  "zu": new NumberSymbols(
      NAME: "zu",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'ZAR')
};

Map<String, CompactNumberSymbols> compactNumberSymbols = {
  // Compact number symbols for locale af.
  "af": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0k',
    4: '00\u00A0k',
    5: '000\u00A0k',
    6: '0\u00A0m',
    7: '00\u00A0m',
    8: '000\u00A0m',
    9: '0\u00A0mjd',
    10: '00\u00A0mjd',
    11: '000\u00A0mjd',
    12: '0\u00A0bn',
    13: '00\u00A0bn',
    14: '000\u00A0bn',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 duisend',
    4: '00 duisend',
    5: '000 duisend',
    6: '0 miljoen',
    7: '00 miljoen',
    8: '000 miljoen',
    9: '0 miljard',
    10: '00 miljard',
    11: '000 miljard',
    12: '0 biljoen',
    13: '00 biljoen',
    14: '000 biljoen',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40\u00A0k',
    4: '\u00A400\u00A0k',
    5: '\u00A4000\u00A0k',
    6: '\u00A40\u00A0m',
    7: '\u00A400\u00A0m',
    8: '\u00A4000\u00A0m',
    9: '\u00A40\u00A0mjd',
    10: '\u00A400\u00A0mjd',
    11: '\u00A4000\u00A0mjd',
    12: '\u00A40\u00A0bn',
    13: '\u00A400\u00A0bn',
    14: '\u00A4000\u00A0bn',
  }),
  // Compact number symbols for locale am.
  "am": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0\u123A',
    4: '00\u00A0\u123A',
    5: '000\u00A0\u123A',
    6: '0\u00A0\u121C\u1275\u122D',
    7: '00\u00A0\u121C\u1275\u122D',
    8: '000\u121C',
    9: '0\u00A0\u1262',
    10: '00\u00A0\u1262',
    11: '000\u00A0\u1262',
    12: '0\u00A0\u1275',
    13: '00\u00A0\u1275',
    14: '000\u00A0\u1275',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 \u123A',
    4: '00 \u123A',
    5: '000 \u123A',
    6: '0 \u121A\u120A\u12EE\u1295',
    7: '00 \u121A\u120A\u12EE\u1295',
    8: '000 \u121A\u120A\u12EE\u1295',
    9: '0 \u1262\u120A\u12EE\u1295',
    10: '00 \u1262\u120A\u12EE\u1295',
    11: '000 \u1262\u120A\u12EE\u1295',
    12: '0 \u1275\u122A\u120A\u12EE\u1295',
    13: '00 \u1275\u122A\u120A\u12EE\u1295',
    14: '000 \u1275\u122A\u120A\u12EE\u1295',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40\u00A0\u123A',
    4: '\u00A400\u00A0\u123A',
    5: '\u00A4000\u00A0\u123A',
    6: '\u00A40\u00A0\u121C\u1275\u122D',
    7: '\u00A400\u00A0\u121C\u1275\u122D',
    8: '\u00A4000\u00A0\u121C\u1275\u122D',
    9: '\u00A40\u00A0\u1262',
    10: '\u00A400\u00A0\u1262',
    11: '\u00A4000\u00A0\u1262',
    12: '\u00A40\u00A0\u1275',
    13: '\u00A400\u00A0\u1275',
    14: '\u00A4000\u00A0\u1275',
  }),
  // Compact number symbols for locale ar.
  "ar": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0\u0623\u0644\u0641',
    4: '00\u00A0\u0623\u0644\u0641',
    5: '000\u00A0\u0623\u0644\u0641',
    6: '0\u00A0\u0645\u0644\u064A\u0648\u0646',
    7: '00\u00A0\u0645\u0644\u064A\u0648\u0646',
    8: '000\u00A0\u0645\u0644\u064A\u0648\u0646',
    9: '0\u00A0\u0645\u0644\u064A\u0627\u0631',
    10: '00\u00A0\u0645\u0644\u064A\u0627\u0631',
    11: '000\u00A0\u0645\u0644\u064A\u0627\u0631',
    12: '0\u00A0\u062A\u0631\u0644\u064A\u0648\u0646',
    13: '00\u00A0\u062A\u0631\u0644\u064A\u0648\u0646',
    14: '000\u00A0\u062A\u0631\u0644\u064A\u0648\u0646',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 \u0623\u0644\u0641',
    4: '00 \u0623\u0644\u0641',
    5: '000 \u0623\u0644\u0641',
    6: '0 \u0645\u0644\u064A\u0648\u0646',
    7: '00 \u0645\u0644\u064A\u0648\u0646',
    8: '000 \u0645\u0644\u064A\u0648\u0646',
    9: '0 \u0645\u0644\u064A\u0627\u0631',
    10: '00 \u0645\u0644\u064A\u0627\u0631',
    11: '000 \u0645\u0644\u064A\u0627\u0631',
    12: '0 \u062A\u0631\u0644\u064A\u0648\u0646',
    13: '00 \u062A\u0631\u0644\u064A\u0648\u0646',
    14: '000 \u062A\u0631\u0644\u064A\u0648\u0646',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A4\u00A00\u00A0\u0623\u0644\u0641',
    4: '\u00A4\u00A000\u00A0\u0623\u0644\u0641',
    5: '\u00A4\u00A0000\u00A0\u0623\u0644\u0641',
    6: '\u00A4\u00A00\u00A0\u0645\u0644\u064A\u0648\u0646',
    7: '\u00A4\u00A000\u00A0\u0645\u0644\u064A\u0648\u0646',
    8: '\u00A4\u00A0000\u00A0\u0645\u0644\u064A\u0648\u0646',
    9: '\u00A4\u00A00\u00A0\u0645\u0644\u064A\u0627\u0631',
    10: '\u00A4\u00A000\u00A0\u0645\u0644\u064A\u0627\u0631',
    11: '\u00A4\u00A0000\u00A0\u0645\u0644\u064A\u0627\u0631',
    12: '\u00A4\u00A00\u00A0\u062A\u0631\u0644\u064A\u0648\u0646',
    13: '\u00A4\u00A000\u00A0\u062A\u0631\u0644\u064A\u0648\u0646',
    14: '\u00A4\u00A0000\u00A0\u062A\u0631\u0644\u064A\u0648\u0646',
  }),
  // Compact number symbols for locale ar_DZ.
  "ar_DZ": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0\u0623\u0644\u0641',
    4: '00\u00A0\u0623\u0644\u0641',
    5: '000\u00A0\u0623\u0644\u0641',
    6: '0\u00A0\u0645\u0644\u064A\u0648\u0646',
    7: '00\u00A0\u0645\u0644\u064A\u0648\u0646',
    8: '000\u00A0\u0645\u0644\u064A\u0648\u0646',
    9: '0\u00A0\u0645\u0644\u064A\u0627\u0631',
    10: '00\u00A0\u0645\u0644\u064A\u0627\u0631',
    11: '000\u00A0\u0645\u0644\u064A\u0627\u0631',
    12: '0\u00A0\u062A\u0631\u0644\u064A\u0648\u0646',
    13: '00\u00A0\u062A\u0631\u0644\u064A\u0648\u0646',
    14: '000\u00A0\u062A\u0631\u0644\u064A\u0648\u0646',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 \u0623\u0644\u0641',
    4: '00 \u0623\u0644\u0641',
    5: '000 \u0623\u0644\u0641',
    6: '0 \u0645\u0644\u064A\u0648\u0646',
    7: '00 \u0645\u0644\u064A\u0648\u0646',
    8: '000 \u0645\u0644\u064A\u0648\u0646',
    9: '0 \u0645\u0644\u064A\u0627\u0631',
    10: '00 \u0645\u0644\u064A\u0627\u0631',
    11: '000 \u0645\u0644\u064A\u0627\u0631',
    12: '0 \u062A\u0631\u0644\u064A\u0648\u0646',
    13: '00 \u062A\u0631\u0644\u064A\u0648\u0646',
    14: '000 \u062A\u0631\u0644\u064A\u0648\u0646',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A4\u00A00\u00A0\u0623\u0644\u0641',
    4: '\u00A4\u00A000\u00A0\u0623\u0644\u0641',
    5: '\u00A4\u00A0000\u00A0\u0623\u0644\u0641',
    6: '\u00A4\u00A00\u00A0\u0645\u0644\u064A\u0648\u0646',
    7: '\u00A4\u00A000\u00A0\u0645\u0644\u064A\u0648\u0646',
    8: '\u00A4\u00A0000\u00A0\u0645\u0644\u064A\u0648\u0646',
    9: '\u00A4\u00A00\u00A0\u0645\u0644\u064A\u0627\u0631',
    10: '\u00A4\u00A000\u00A0\u0645\u0644\u064A\u0627\u0631',
    11: '\u00A4\u00A0000\u00A0\u0645\u0644\u064A\u0627\u0631',
    12: '\u00A4\u00A00\u00A0\u062A\u0631\u0644\u064A\u0648\u0646',
    13: '\u00A4\u00A000\u00A0\u062A\u0631\u0644\u064A\u0648\u0646',
    14: '\u00A4\u00A0000\u00A0\u062A\u0631\u0644\u064A\u0648\u0646',
  }),
  // Compact number symbols for locale ar_EG.
  "ar_EG": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0\u0623\u0644\u0641',
    4: '00\u00A0\u0623\u0644\u0641',
    5: '000\u00A0\u0623\u0644\u0641',
    6: '0\u00A0\u0645\u0644\u064A\u0648\u0646',
    7: '00\u00A0\u0645\u0644\u064A\u0648\u0646',
    8: '000\u00A0\u0645\u0644\u064A\u0648\u0646',
    9: '0\u00A0\u0645\u0644\u064A\u0627\u0631',
    10: '00\u00A0\u0645\u0644\u064A\u0627\u0631',
    11: '000\u00A0\u0645\u0644\u064A\u0627\u0631',
    12: '0\u00A0\u062A\u0631\u0644\u064A\u0648\u0646',
    13: '00\u00A0\u062A\u0631\u0644\u064A\u0648\u0646',
    14: '000\u00A0\u062A\u0631\u0644\u064A\u0648\u0646',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 \u0623\u0644\u0641',
    4: '00 \u0623\u0644\u0641',
    5: '000 \u0623\u0644\u0641',
    6: '0 \u0645\u0644\u064A\u0648\u0646',
    7: '00 \u0645\u0644\u064A\u0648\u0646',
    8: '000 \u0645\u0644\u064A\u0648\u0646',
    9: '0 \u0645\u0644\u064A\u0627\u0631',
    10: '00 \u0645\u0644\u064A\u0627\u0631',
    11: '000 \u0645\u0644\u064A\u0627\u0631',
    12: '0 \u062A\u0631\u0644\u064A\u0648\u0646',
    13: '00 \u062A\u0631\u0644\u064A\u0648\u0646',
    14: '000 \u062A\u0631\u0644\u064A\u0648\u0646',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A4\u00A00\u00A0\u0623\u0644\u0641',
    4: '\u00A4\u00A000\u00A0\u0623\u0644\u0641',
    5: '\u00A4\u00A0000\u00A0\u0623\u0644\u0641',
    6: '\u00A4\u00A00\u00A0\u0645\u0644\u064A\u0648\u0646',
    7: '\u00A4\u00A000\u00A0\u0645\u0644\u064A\u0648\u0646',
    8: '\u00A4\u00A0000\u00A0\u0645\u0644\u064A\u0648\u0646',
    9: '\u00A4\u00A00\u00A0\u0645\u0644\u064A\u0627\u0631',
    10: '\u00A4\u00A000\u00A0\u0645\u0644\u064A\u0627\u0631',
    11: '\u00A4\u00A0000\u00A0\u0645\u0644\u064A\u0627\u0631',
    12: '\u00A4\u00A00\u00A0\u062A\u0631\u0644\u064A\u0648\u0646',
    13: '\u00A4\u00A000\u00A0\u062A\u0631\u0644\u064A\u0648\u0646',
    14: '\u00A4\u00A0000\u00A0\u062A\u0631\u0644\u064A\u0648\u0646',
  }),
  // Compact number symbols for locale az.
  "az": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0K',
    4: '00K',
    5: '000K',
    6: '0M',
    7: '00M',
    8: '000M',
    9: '0G',
    10: '00G',
    11: '000G',
    12: '0T',
    13: '00T',
    14: '000T',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 min',
    4: '00 min',
    5: '000 min',
    6: '0 milyon',
    7: '00 milyon',
    8: '000 milyon',
    9: '0 milyard',
    10: '00 milyard',
    11: '000 milyard',
    12: '0 trilyon',
    13: '00 trilyon',
    14: '000 trilyon',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0K\u00A0\u00A4',
    4: '00K\u00A0\u00A4',
    5: '000K\u00A0\u00A4',
    6: '0M\u00A0\u00A4',
    7: '00M\u00A0\u00A4',
    8: '000M\u00A0\u00A4',
    9: '0G\u00A0\u00A4',
    10: '00G\u00A0\u00A4',
    11: '000G\u00A0\u00A4',
    12: '0T\u00A0\u00A4',
    13: '00T\u00A0\u00A4',
    14: '000T\u00A0\u00A4',
  }),
  // Compact number symbols for locale be.
  "be": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0\u0442\u044B\u0441.',
    4: '00\u00A0\u0442\u044B\u0441.',
    5: '000\u00A0\u0442\u044B\u0441.',
    6: '0\u00A0\u043C\u043B\u043D',
    7: '00\u00A0\u043C\u043B\u043D',
    8: '000\u00A0\u043C\u043B\u043D',
    9: '0\u00A0\u043C\u043B\u0440\u0434',
    10: '00\u00A0\u043C\u043B\u0440\u0434',
    11: '000\u00A0\u043C\u043B\u0440\u0434',
    12: '0\u00A0\u0442\u0440\u043B\u043D',
    13: '00\u00A0\u0442\u0440\u043B\u043D',
    14: '000\u00A0\u0442\u0440\u043B\u043D',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 \u0442\u044B\u0441\u044F\u0447\u044B',
    4: '00 \u0442\u044B\u0441\u044F\u0447\u044B',
    5: '000 \u0442\u044B\u0441\u044F\u0447\u044B',
    6: '0 \u043C\u0456\u043B\u044C\u0451\u043D\u0430',
    7: '00 \u043C\u0456\u043B\u044C\u0451\u043D\u0430',
    8: '000 \u043C\u0456\u043B\u044C\u0451\u043D\u0430',
    9: '0 \u043C\u0456\u043B\u044C\u044F\u0440\u0434\u0430',
    10: '00 \u043C\u0456\u043B\u044C\u044F\u0440\u0434\u0430',
    11: '000 \u043C\u0456\u043B\u044C\u044F\u0440\u0434\u0430',
    12: '0 \u0442\u0440\u044B\u043B\u044C\u0451\u043D\u0430',
    13: '00 \u0442\u0440\u044B\u043B\u044C\u0451\u043D\u0430',
    14: '000 \u0442\u0440\u044B\u043B\u044C\u0451\u043D\u0430',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0\u0442\u044B\u0441.\u00A0\u00A4',
    4: '00\u00A0\u0442\u044B\u0441.\u00A0\u00A4',
    5: '000\u00A0\u0442\u044B\u0441.\u00A0\u00A4',
    6: '0\u00A0\u043C\u043B\u043D\u00A0\u00A4',
    7: '00\u00A0\u043C\u043B\u043D\u00A0\u00A4',
    8: '000\u00A0\u043C\u043B\u043D\u00A0\u00A4',
    9: '0\u00A0\u043C\u043B\u0440\u0434\u00A0\u00A4\u00A0',
    10: '00\u00A0\u043C\u043B\u0440\u0434\u00A0\u00A4',
    11: '000\u00A0\u043C\u043B\u0440\u0434\u00A0\u00A4',
    12: '0\u00A0\u0442\u0440\u043B\u043D\u00A0\u00A4',
    13: '00\u00A0\u0442\u0440\u043B\u043D\u00A0\u00A4',
    14: '000\u00A0\u0442\u0440\u043B\u043D\u00A0\u00A4',
  }),
  // Compact number symbols for locale bg.
  "bg": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0\u0445\u0438\u043B.',
    4: '00\u00A0\u0445\u0438\u043B.',
    5: '000\u00A0\u0445\u0438\u043B.',
    6: '0\u00A0\u043C\u043B\u043D.',
    7: '00\u00A0\u043C\u043B\u043D.',
    8: '000\u00A0\u043C\u043B\u043D.',
    9: '0\u00A0\u043C\u043B\u0440\u0434.',
    10: '00\u00A0\u043C\u043B\u0440\u0434.',
    11: '000\u00A0\u043C\u043B\u0440\u0434.',
    12: '0\u00A0\u0442\u0440\u043B\u043D.',
    13: '00\u00A0\u0442\u0440\u043B\u043D.',
    14: '000\u00A0\u0442\u0440\u043B\u043D.',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 \u0445\u0438\u043B\u044F\u0434\u0438',
    4: '00 \u0445\u0438\u043B\u044F\u0434\u0438',
    5: '000 \u0445\u0438\u043B\u044F\u0434\u0438',
    6: '0 \u043C\u0438\u043B\u0438\u043E\u043D\u0430',
    7: '00 \u043C\u0438\u043B\u0438\u043E\u043D\u0430',
    8: '000 \u043C\u0438\u043B\u0438\u043E\u043D\u0430',
    9: '0 \u043C\u0438\u043B\u0438\u0430\u0440\u0434\u0430',
    10: '00 \u043C\u0438\u043B\u0438\u0430\u0440\u0434\u0430',
    11: '000 \u043C\u0438\u043B\u0438\u0430\u0440\u0434\u0430',
    12: '0 \u0442\u0440\u0438\u043B\u0438\u043E\u043D\u0430',
    13: '00 \u0442\u0440\u0438\u043B\u0438\u043E\u043D\u0430',
    14: '000 \u0442\u0440\u0438\u043B\u0438\u043E\u043D\u0430',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0\u0445\u0438\u043B.\u00A0\u00A4',
    4: '00\u00A0\u0445\u0438\u043B.\u00A0\u00A4',
    5: '000\u00A0\u0445\u0438\u043B.\u00A0\u00A4',
    6: '0\u00A0\u043C\u043B\u043D.\u00A0\u00A4',
    7: '00\u00A0\u043C\u043B\u043D.\u00A0\u00A4',
    8: '000\u00A0\u043C\u043B\u043D.\u00A0\u00A4',
    9: '0\u00A0\u043C\u043B\u0440\u0434.\u00A0\u00A4',
    10: '00\u00A0\u043C\u043B\u0440\u0434.\u00A0\u00A4',
    11: '000\u00A0\u043C\u043B\u0440\u0434.\u00A0\u00A4',
    12: '0\u00A0\u0442\u0440\u043B\u043D.\u00A0\u00A4',
    13: '00\u00A0\u0442\u0440\u043B\u043D.\u00A0\u00A4',
    14: '000\u00A0\u0442\u0440\u043B\u043D.\u00A0\u00A4',
  }),
  // Compact number symbols for locale bn.
  "bn": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0\u09B9\u09BE',
    4: '00\u00A0\u09B9\u09BE',
    5: '0\u00A0\u09B2\u09BE',
    6: '00\u00A0\u09B2\u09BE',
    7: '0\u00A0\u0995\u09CB',
    8: '00\u00A0\u0995\u09CB',
    9: '000\u00A0\u0995\u09CB',
    10: '0000\u00A0\u0995\u09CB',
    11: '00000\u00A0\u0995\u09CB',
    12: '0\u00A0\u09B2\u09BE.\u0995\u09CB.',
    13: '00\u00A0\u09B2\u09BE.\u0995\u09CB.',
    14: '000\u00A0\u09B2\u09BE.\u0995\u09CB.',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 \u09B9\u09BE\u099C\u09BE\u09B0',
    4: '00 \u09B9\u09BE\u099C\u09BE\u09B0',
    5: '0 \u09B2\u09BE\u0996',
    6: '00 \u09B2\u09BE\u0996',
    7: '0 \u0995\u09CB\u099F\u09BF',
    8: '00 \u0995\u09CB\u099F\u09BF',
    9: '000 \u0995\u09CB\u099F\u09BF',
    10: '0000 \u0995\u09CB\u099F\u09BF',
    11: '00000 \u0995\u09CB\u099F\u09BF',
    12: '0 \u09B2\u09BE\u0996 \u0995\u09CB\u099F\u09BF',
    13: '00 \u09B2\u09BE\u0996 \u0995\u09CB\u099F\u09BF',
    14: '000 \u09B2\u09BE\u0996 \u0995\u09CB\u099F\u09BF',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0\u09B9\u09BE\u00A4',
    4: '00\u00A0\u09B9\u09BE\u00A4',
    5: '0\u00A0\u09B2\u09BE\u00A4',
    6: '00\u00A0\u09B2\u09BE\u00A4',
    7: '0\u00A0\u0995\u09CB\u00A4',
    8: '00\u00A0\u0995\u09CB\u00A4',
    9: '000\u00A0\u0995\u09CB\u00A4',
    10: '0000\u00A0\u0995\u09CB\u00A4',
    11: '00000\u00A0\u0995\u09CB\u00A4',
    12: '0\u00A0\u09B2\u09BE.\u0995\u09CB.\u00A4',
    13: '00\u00A0\u09B2\u09BE.\u0995\u09CB.\u00A4',
    14: '000\u00A0\u09B2\u09BE.\u0995\u09CB.\u00A4',
  }),
  // Compact number symbols for locale br.
  "br": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0k',
    4: '00k',
    5: '000k',
    6: '0M',
    7: '00M',
    8: '000M',
    9: '0G',
    10: '00G',
    11: '000G',
    12: '0T',
    13: '00T',
    14: '000T',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 miliad',
    4: '00 miliad',
    5: '000 miliad',
    6: '0 milion',
    7: '00 milion',
    8: '000 milion',
    9: '0 miliard',
    10: '00 miliard',
    11: '000 miliard',
    12: '0 bilion',
    13: '00 bilion',
    14: '000 bilion',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0k\u00A4',
    4: '00\u00A0k\u00A4',
    5: '000\u00A0k\u00A4',
    6: '0\u00A0M\u00A4',
    7: '00\u00A0M\u00A4',
    8: '000\u00A0M\u00A4',
    9: '0\u00A0G\u00A4',
    10: '00\u00A0G\u00A4',
    11: '000\u00A0G\u00A4',
    12: '0\u00A0T\u00A4',
    13: '00\u00A0T\u00A4',
    14: '000\u00A0T\u00A4',
  }),
  // Compact number symbols for locale bs.
  "bs": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0hilj.',
    4: '00\u00A0hilj.',
    5: '000\u00A0hilj.',
    6: '0\u00A0mil.',
    7: '00\u00A0mil.',
    8: '000\u00A0mil.',
    9: '0\u00A0mlr.',
    10: '00\u00A0mlr.',
    11: '000\u00A0mlr.',
    12: '0\u00A0bil.',
    13: '00\u00A0bil.',
    14: '000\u00A0bil.',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 hiljada',
    4: '00 hiljada',
    5: '000 hiljada',
    6: '0 miliona',
    7: '00 miliona',
    8: '000 miliona',
    9: '0 milijardi',
    10: '00 milijardi',
    11: '000 milijardi',
    12: '0 biliona',
    13: '00 biliona',
    14: '000 biliona',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0hilj.\u00A0\u00A4',
    4: '00\u00A0hilj.\u00A0\u00A4',
    5: '000\u00A0hilj.\u00A0\u00A4',
    6: '0\u00A0mil.\u00A0\u00A4',
    7: '00\u00A0mil.\u00A0\u00A4',
    8: '000\u00A0mil.\u00A0\u00A4',
    9: '0\u00A0mlr.\u00A0\u00A4',
    10: '00\u00A0mlr.\u00A0\u00A4',
    11: '000\u00A0mlr.\u00A0\u00A4',
    12: '0\u00A0bil.\u00A0\u00A4',
    13: '00\u00A0bil.\u00A0\u00A4',
    14: '000\u00A0bil.\u00A0\u00A4',
  }),
  // Compact number symbols for locale ca.
  "ca": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0m',
    4: '00m',
    5: '000m',
    6: '0\u00A0M',
    7: '00\u00A0M',
    8: '000\u00A0M',
    9: '0000\u00A0M',
    10: '00mM',
    11: '000mM',
    12: '0\u00A0B',
    13: '00\u00A0B',
    14: '000\u00A0B',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 milers',
    4: '00 milers',
    5: '000 milers',
    6: '0 milions',
    7: '00 milions',
    8: '000 milions',
    9: '0 milers de milions',
    10: '00 milers de milions',
    11: '000 milers de milions',
    12: '0 bilions',
    13: '00 bilions',
    14: '000 bilions',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0m\u00A0\u00A4',
    4: '00m\u00A0\u00A4',
    5: '000m\u00A0\u00A4',
    6: '0\u00A0M\u00A0\u00A4',
    7: '00\u00A0M\u00A0\u00A4',
    8: '000\u00A0M\u00A0\u00A4',
    9: '0000\u00A0M\u00A0\u00A4',
    10: '00mM\u00A0\u00A4',
    11: '000mM\u00A0\u00A4',
    12: '0\u00A0B\u00A0\u00A4',
    13: '00\u00A0B\u00A0\u00A4',
    14: '000\u00A0B\u00A0\u00A4',
  }),
  // Compact number symbols for locale chr.
  "chr": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0K',
    4: '00K',
    5: '000K',
    6: '0M',
    7: '00M',
    8: '000M',
    9: '0B',
    10: '00B',
    11: '000B',
    12: '0T',
    13: '00T',
    14: '000T',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 \u13A2\u13EF\u13A6\u13F4\u13B5',
    4: '00 \u13A2\u13EF\u13A6\u13F4\u13B5',
    5: '000 \u13A2\u13EF\u13A6\u13F4\u13B5',
    6: '0 \u13A2\u13F3\u13C6\u13D7\u13C5\u13DB',
    7: '00 \u13A2\u13F3\u13C6\u13D7\u13C5\u13DB',
    8: '000 \u13A2\u13F3\u13C6\u13D7\u13C5\u13DB',
    9: '0 \u13A2\u13EF\u13D4\u13B3\u13D7\u13C5\u13DB',
    10: '00 \u13A2\u13EF\u13D4\u13B3\u13D7\u13C5\u13DB',
    11: '000 \u13A2\u13EF\u13D4\u13B3\u13D7\u13C5\u13DB',
    12: '0 \u13A2\u13EF\u13E6\u13A0\u13D7\u13C5\u13DB',
    13: '00 \u13A2\u13EF\u13E6\u13A0\u13D7\u13C5\u13DB',
    14: '000 \u13A2\u13EF\u13E6\u13A0\u13D7\u13C5\u13DB',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40K',
    4: '\u00A400K',
    5: '\u00A4000K',
    6: '\u00A40M',
    7: '\u00A400M',
    8: '\u00A4000M',
    9: '\u00A40B',
    10: '\u00A400B',
    11: '\u00A4000B',
    12: '\u00A40T',
    13: '\u00A400T',
    14: '\u00A4000T',
  }),
  // Compact number symbols for locale cs.
  "cs": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0tis.',
    4: '00\u00A0tis.',
    5: '000\u00A0tis.',
    6: '0\u00A0mil.',
    7: '00\u00A0mil.',
    8: '000\u00A0mil.',
    9: '0\u00A0mld.',
    10: '00\u00A0mld.',
    11: '000\u00A0mld.',
    12: '0\u00A0bil.',
    13: '00\u00A0bil.',
    14: '000\u00A0bil.',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 tis\u00EDc',
    4: '00 tis\u00EDc',
    5: '000 tis\u00EDc',
    6: '0 milion\u016F',
    7: '00 milion\u016F',
    8: '000 milion\u016F',
    9: '0 miliard',
    10: '00 miliard',
    11: '000 miliard',
    12: '0 bilion\u016F',
    13: '00 bilion\u016F',
    14: '000 bilion\u016F',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0tis.\u00A0\u00A4',
    4: '00\u00A0tis.\u00A0\u00A4',
    5: '000\u00A0tis.\u00A0\u00A4',
    6: '0\u00A0mil.\u00A0\u00A4',
    7: '00\u00A0mil.\u00A0\u00A4',
    8: '000\u00A0mil.\u00A0\u00A4',
    9: '0\u00A0mld.\u00A0\u00A4',
    10: '00\u00A0mld.\u00A0\u00A4',
    11: '000\u00A0mld.\u00A0\u00A4',
    12: '0\u00A0bil.\u00A0\u00A4',
    13: '00\u00A0bil.\u00A0\u00A4',
    14: '000\u00A0bil.\u00A0\u00A4',
  }),
  // Compact number symbols for locale cy.
  "cy": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0K',
    4: '00K',
    5: '000K',
    6: '0M',
    7: '00M',
    8: '000M',
    9: '0B',
    10: '00B',
    11: '000B',
    12: '0T',
    13: '00T',
    14: '000T',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 mil',
    4: '00 mil',
    5: '000 mil',
    6: '0 miliwn',
    7: '00 miliwn',
    8: '000 miliwn',
    9: '0 biliwn',
    10: '00 biliwn',
    11: '000 biliwn',
    12: '0 triliwn',
    13: '00 triliwn',
    14: '000 triliwn',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40K',
    4: '\u00A400K',
    5: '\u00A4000K',
    6: '\u00A40M',
    7: '\u00A400M',
    8: '\u00A4000M',
    9: '\u00A40B',
    10: '\u00A400B',
    11: '\u00A4000B',
    12: '\u00A40T',
    13: '\u00A400T',
    14: '\u00A4000T',
  }),
  // Compact number symbols for locale da.
  "da": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0t',
    4: '00\u00A0t',
    5: '000\u00A0t',
    6: '0\u00A0mio.',
    7: '00\u00A0mio.',
    8: '000\u00A0mio.',
    9: '0\u00A0mia.',
    10: '00\u00A0mia.',
    11: '000\u00A0mia.',
    12: '0\u00A0bio.',
    13: '00\u00A0bio.',
    14: '000\u00A0bio.',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 tusind',
    4: '00 tusind',
    5: '000 tusind',
    6: '0 millioner',
    7: '00 millioner',
    8: '000 millioner',
    9: '0 milliarder',
    10: '00 milliarder',
    11: '000 milliarder',
    12: '0 billioner',
    13: '00 billioner',
    14: '000 billioner',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0t\u00A0\u00A4',
    4: '00\u00A0t\u00A0\u00A4',
    5: '000\u00A0t\u00A0\u00A4',
    6: '0\u00A0mio.\u00A0\u00A4',
    7: '00\u00A0mio.\u00A0\u00A4',
    8: '000\u00A0mio.\u00A0\u00A4',
    9: '0\u00A0mia.\u00A0\u00A4',
    10: '00\u00A0mia.\u00A0\u00A4',
    11: '000\u00A0mia.\u00A0\u00A4',
    12: '0\u00A0bio.\u00A0\u00A4',
    13: '00\u00A0bio.\u00A0\u00A4',
    14: '000\u00A0bio.\u00A0\u00A4',
  }),
  // Compact number symbols for locale de.
  "de": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0',
    4: '0',
    5: '0',
    6: '0\u00A0Mio.',
    7: '00\u00A0Mio.',
    8: '000\u00A0Mio.',
    9: '0\u00A0Mrd.',
    10: '00\u00A0Mrd.',
    11: '000\u00A0Mrd.',
    12: '0\u00A0Bio.',
    13: '00\u00A0Bio.',
    14: '000\u00A0Bio.',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 Tausend',
    4: '00 Tausend',
    5: '000 Tausend',
    6: '0 Millionen',
    7: '00 Millionen',
    8: '000 Millionen',
    9: '0 Milliarden',
    10: '00 Milliarden',
    11: '000 Milliarden',
    12: '0 Billionen',
    13: '00 Billionen',
    14: '000 Billionen',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0',
    4: '0',
    5: '0',
    6: '0\u00A0Mio.\u00A0\u00A4',
    7: '00\u00A0Mio.\u00A0\u00A4',
    8: '000\u00A0Mio.\u00A0\u00A4',
    9: '0\u00A0Mrd.\u00A0\u00A4',
    10: '00\u00A0Mrd.\u00A0\u00A4',
    11: '000\u00A0Mrd.\u00A0\u00A4',
    12: '0\u00A0Bio.\u00A0\u00A4',
    13: '00\u00A0Bio.\u00A0\u00A4',
    14: '000\u00A0Bio.\u00A0\u00A4',
  }),
  // Compact number symbols for locale de_AT.
  "de_AT": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0',
    4: '0',
    5: '0',
    6: '0\u00A0Mio.',
    7: '00\u00A0Mio.',
    8: '000\u00A0Mio.',
    9: '0\u00A0Mrd.',
    10: '00\u00A0Mrd.',
    11: '000\u00A0Mrd.',
    12: '0\u00A0Bio.',
    13: '00\u00A0Bio.',
    14: '000\u00A0Bio.',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 Tausend',
    4: '00 Tausend',
    5: '000 Tausend',
    6: '0 Millionen',
    7: '00 Millionen',
    8: '000 Millionen',
    9: '0 Milliarden',
    10: '00 Milliarden',
    11: '000 Milliarden',
    12: '0 Billionen',
    13: '00 Billionen',
    14: '000 Billionen',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0',
    4: '0',
    5: '0',
    6: '0\u00A0Mio.\u00A0\u00A4',
    7: '00\u00A0Mio.\u00A0\u00A4',
    8: '000\u00A0Mio.\u00A0\u00A4',
    9: '0\u00A0Mrd.\u00A0\u00A4',
    10: '00\u00A0Mrd.\u00A0\u00A4',
    11: '000\u00A0Mrd.\u00A0\u00A4',
    12: '0\u00A0Bio.\u00A0\u00A4',
    13: '00\u00A0Bio.\u00A0\u00A4',
    14: '000\u00A0Bio.\u00A0\u00A4',
  }),
  // Compact number symbols for locale de_CH.
  "de_CH": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0',
    4: '0',
    5: '0',
    6: '0\u00A0Mio.',
    7: '00\u00A0Mio.',
    8: '000\u00A0Mio.',
    9: '0\u00A0Mrd.',
    10: '00\u00A0Mrd.',
    11: '000\u00A0Mrd.',
    12: '0\u00A0Bio.',
    13: '00\u00A0Bio.',
    14: '000\u00A0Bio.',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 Tausend',
    4: '00 Tausend',
    5: '000 Tausend',
    6: '0 Millionen',
    7: '00 Millionen',
    8: '000 Millionen',
    9: '0 Milliarden',
    10: '00 Milliarden',
    11: '000 Milliarden',
    12: '0 Billionen',
    13: '00 Billionen',
    14: '000 Billionen',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0',
    4: '0',
    5: '0',
    6: '0\u00A0Mio.\u00A0\u00A4',
    7: '00\u00A0Mio.\u00A0\u00A4',
    8: '000\u00A0Mio.\u00A0\u00A4',
    9: '0\u00A0Mrd.\u00A0\u00A4',
    10: '00\u00A0Mrd.\u00A0\u00A4',
    11: '000\u00A0Mrd.\u00A0\u00A4',
    12: '0\u00A0Bio.\u00A0\u00A4',
    13: '00\u00A0Bio.\u00A0\u00A4',
    14: '000\u00A0Bio.\u00A0\u00A4',
  }),
  // Compact number symbols for locale el.
  "el": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0\u03C7\u03B9\u03BB.',
    4: '00\u00A0\u03C7\u03B9\u03BB.',
    5: '000\u00A0\u03C7\u03B9\u03BB.',
    6: '0\u00A0\u03B5\u03BA.',
    7: '00\u00A0\u03B5\u03BA.',
    8: '000\u00A0\u03B5\u03BA.',
    9: '0\u00A0\u03B4\u03B9\u03C3.',
    10: '00\u00A0\u03B4\u03B9\u03C3.',
    11: '000\u00A0\u03B4\u03B9\u03C3.',
    12: '0\u00A0\u03C4\u03C1\u03B9\u03C3.',
    13: '00\u00A0\u03C4\u03C1\u03B9\u03C3.',
    14: '000\u00A0\u03C4\u03C1\u03B9\u03C3.',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 \u03C7\u03B9\u03BB\u03B9\u03AC\u03B4\u03B5\u03C2',
    4: '00 \u03C7\u03B9\u03BB\u03B9\u03AC\u03B4\u03B5\u03C2',
    5: '000 \u03C7\u03B9\u03BB\u03B9\u03AC\u03B4\u03B5\u03C2',
    6: '0 \u03B5\u03BA\u03B1\u03C4\u03BF\u03BC\u03BC\u03CD\u03C1\u03B9\u03B1',
    7: '00 \u03B5\u03BA\u03B1\u03C4\u03BF\u03BC\u03BC\u03CD\u03C1\u03B9\u03B1',
    8: '000 \u03B5\u03BA\u03B1\u03C4\u03BF\u03BC\u03BC\u03CD\u03C1\u03B9\u03B1',
    9: '0 \u03B4\u03B9\u03C3\u03B5\u03BA\u03B1\u03C4\u03BF\u03BC\u03BC\u03CD\u03C1\u03B9\u03B1',
    10: '00 \u03B4\u03B9\u03C3\u03B5\u03BA\u03B1\u03C4\u03BF\u03BC\u03BC\u03CD\u03C1\u03B9\u03B1',
    11: '000 \u03B4\u03B9\u03C3\u03B5\u03BA\u03B1\u03C4\u03BF\u03BC\u03BC\u03CD\u03C1\u03B9\u03B1',
    12: '0 \u03C4\u03C1\u03B9\u03C3\u03B5\u03BA\u03B1\u03C4\u03BF\u03BC\u03BC\u03CD\u03C1\u03B9\u03B1',
    13: '00 \u03C4\u03C1\u03B9\u03C3\u03B5\u03BA\u03B1\u03C4\u03BF\u03BC\u03BC\u03CD\u03C1\u03B9\u03B1',
    14: '000 \u03C4\u03C1\u03B9\u03C3\u03B5\u03BA\u03B1\u03C4\u03BF\u03BC\u03BC\u03CD\u03C1\u03B9\u03B1',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0\u03C7\u03B9\u03BB.\u00A0\u00A4',
    4: '00\u00A0\u03C7\u03B9\u03BB.\u00A0\u00A4',
    5: '000\u00A0\u03C7\u03B9\u03BB.\u00A0\u00A4',
    6: '0\u00A0\u03B5\u03BA.\u00A0\u00A4',
    7: '00\u00A0\u03B5\u03BA.\u00A0\u00A4',
    8: '000\u00A0\u03B5\u03BA.\u00A0\u00A4',
    9: '0\u00A0\u03B4\u03B9\u03C3.\u00A0\u00A4',
    10: '00\u00A0\u03B4\u03B9\u03C3.\u00A0\u00A4',
    11: '000\u00A0\u03B4\u03B9\u03C3.\u00A0\u00A4',
    12: '0\u00A0\u03C4\u03C1\u03B9\u03C3.\u00A0\u00A4',
    13: '00\u00A0\u03C4\u03C1\u03B9\u03C3.\u00A0\u00A4',
    14: '000\u00A0\u03C4\u03C1\u03B9\u03C3.\u00A0\u00A4',
  }),
  // Compact number symbols for locale en.
  "en": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0K',
    4: '00K',
    5: '000K',
    6: '0M',
    7: '00M',
    8: '000M',
    9: '0B',
    10: '00B',
    11: '000B',
    12: '0T',
    13: '00T',
    14: '000T',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 thousand',
    4: '00 thousand',
    5: '000 thousand',
    6: '0 million',
    7: '00 million',
    8: '000 million',
    9: '0 billion',
    10: '00 billion',
    11: '000 billion',
    12: '0 trillion',
    13: '00 trillion',
    14: '000 trillion',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40K',
    4: '\u00A400K',
    5: '\u00A4000K',
    6: '\u00A40M',
    7: '\u00A400M',
    8: '\u00A4000M',
    9: '\u00A40B',
    10: '\u00A400B',
    11: '\u00A4000B',
    12: '\u00A40T',
    13: '\u00A400T',
    14: '\u00A4000T',
  }),
  // Compact number symbols for locale en_AU.
  "en_AU": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0K',
    4: '00K',
    5: '000K',
    6: '0M',
    7: '00M',
    8: '000M',
    9: '0B',
    10: '00B',
    11: '000B',
    12: '0T',
    13: '00T',
    14: '000T',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 thousand',
    4: '00 thousand',
    5: '000 thousand',
    6: '0 million',
    7: '00 million',
    8: '000 million',
    9: '0 billion',
    10: '00 billion',
    11: '000 billion',
    12: '0 trillion',
    13: '00 trillion',
    14: '000 trillion',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40K',
    4: '\u00A400K',
    5: '\u00A4000K',
    6: '\u00A40M',
    7: '\u00A400M',
    8: '\u00A4000M',
    9: '\u00A40B',
    10: '\u00A400B',
    11: '\u00A4000B',
    12: '\u00A40T',
    13: '\u00A400T',
    14: '\u00A4000T',
  }),
  // Compact number symbols for locale en_CA.
  "en_CA": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0K',
    4: '00K',
    5: '000K',
    6: '0M',
    7: '00M',
    8: '000M',
    9: '0B',
    10: '00B',
    11: '000B',
    12: '0T',
    13: '00T',
    14: '000T',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 thousand',
    4: '00 thousand',
    5: '000 thousand',
    6: '0 million',
    7: '00 million',
    8: '000 million',
    9: '0 billion',
    10: '00 billion',
    11: '000 billion',
    12: '0 trillion',
    13: '00 trillion',
    14: '000 trillion',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40K',
    4: '\u00A400K',
    5: '\u00A4000K',
    6: '\u00A40M',
    7: '\u00A400M',
    8: '\u00A4000M',
    9: '\u00A40B',
    10: '\u00A400B',
    11: '\u00A4000B',
    12: '\u00A40T',
    13: '\u00A400T',
    14: '\u00A4000T',
  }),
  // Compact number symbols for locale en_GB.
  "en_GB": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0K',
    4: '00K',
    5: '000K',
    6: '0M',
    7: '00M',
    8: '000M',
    9: '0B',
    10: '00B',
    11: '000B',
    12: '0T',
    13: '00T',
    14: '000T',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 thousand',
    4: '00 thousand',
    5: '000 thousand',
    6: '0 million',
    7: '00 million',
    8: '000 million',
    9: '0 billion',
    10: '00 billion',
    11: '000 billion',
    12: '0 trillion',
    13: '00 trillion',
    14: '000 trillion',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40K',
    4: '\u00A400K',
    5: '\u00A4000K',
    6: '\u00A40M',
    7: '\u00A400M',
    8: '\u00A4000M',
    9: '\u00A40B',
    10: '\u00A400B',
    11: '\u00A4000B',
    12: '\u00A40T',
    13: '\u00A400T',
    14: '\u00A4000T',
  }),
  // Compact number symbols for locale en_IE.
  "en_IE": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0K',
    4: '00K',
    5: '000K',
    6: '0M',
    7: '00M',
    8: '000M',
    9: '0B',
    10: '00B',
    11: '000B',
    12: '0T',
    13: '00T',
    14: '000T',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 thousand',
    4: '00 thousand',
    5: '000 thousand',
    6: '0 million',
    7: '00 million',
    8: '000 million',
    9: '0 billion',
    10: '00 billion',
    11: '000 billion',
    12: '0 trillion',
    13: '00 trillion',
    14: '000 trillion',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40K',
    4: '\u00A400K',
    5: '\u00A4000K',
    6: '\u00A40M',
    7: '\u00A400M',
    8: '\u00A4000M',
    9: '\u00A40B',
    10: '\u00A400B',
    11: '\u00A4000B',
    12: '\u00A40T',
    13: '\u00A400T',
    14: '\u00A4000T',
  }),
  // Compact number symbols for locale en_IN.
  "en_IN": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0K',
    4: '00K',
    5: '000K',
    6: '0M',
    7: '00M',
    8: '000M',
    9: '0B',
    10: '00B',
    11: '000B',
    12: '0T',
    13: '00T',
    14: '000T',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 thousand',
    4: '00 thousand',
    5: '000 thousand',
    6: '0 million',
    7: '00 million',
    8: '000 million',
    9: '0 billion',
    10: '00 billion',
    11: '000 billion',
    12: '0 trillion',
    13: '00 trillion',
    14: '000 trillion',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40T',
    4: '\u00A400T',
    5: '\u00A40L',
    6: '\u00A400L',
    7: '\u00A40Cr',
    8: '\u00A400Cr',
    9: '\u00A4000Cr',
    10: '\u00A40TCr',
    11: '\u00A400TCr',
    12: '\u00A40LCr',
    13: '\u00A400LCr',
    14: '\u00A4000LCr',
  }),
  // Compact number symbols for locale en_MY.
  "en_MY": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0K',
    4: '00K',
    5: '000K',
    6: '0M',
    7: '00M',
    8: '000M',
    9: '0B',
    10: '00B',
    11: '000B',
    12: '0T',
    13: '00T',
    14: '000T',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 thousand',
    4: '00 thousand',
    5: '000 thousand',
    6: '0 million',
    7: '00 million',
    8: '000 million',
    9: '0 billion',
    10: '00 billion',
    11: '000 billion',
    12: '0 trillion',
    13: '00 trillion',
    14: '000 trillion',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40K',
    4: '\u00A400K',
    5: '\u00A4000K',
    6: '\u00A40M',
    7: '\u00A400M',
    8: '\u00A4000M',
    9: '\u00A40B',
    10: '\u00A400B',
    11: '\u00A4000B',
    12: '\u00A40T',
    13: '\u00A400T',
    14: '\u00A4000T',
  }),
  // Compact number symbols for locale en_SG.
  "en_SG": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0K',
    4: '00K',
    5: '000K',
    6: '0M',
    7: '00M',
    8: '000M',
    9: '0B',
    10: '00B',
    11: '000B',
    12: '0T',
    13: '00T',
    14: '000T',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 thousand',
    4: '00 thousand',
    5: '000 thousand',
    6: '0 million',
    7: '00 million',
    8: '000 million',
    9: '0 billion',
    10: '00 billion',
    11: '000 billion',
    12: '0 trillion',
    13: '00 trillion',
    14: '000 trillion',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40K',
    4: '\u00A400K',
    5: '\u00A4000K',
    6: '\u00A40M',
    7: '\u00A400M',
    8: '\u00A4000M',
    9: '\u00A40B',
    10: '\u00A400B',
    11: '\u00A4000B',
    12: '\u00A40T',
    13: '\u00A400T',
    14: '\u00A4000T',
  }),
  // Compact number symbols for locale en_US.
  "en_US": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0K',
    4: '00K',
    5: '000K',
    6: '0M',
    7: '00M',
    8: '000M',
    9: '0B',
    10: '00B',
    11: '000B',
    12: '0T',
    13: '00T',
    14: '000T',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 thousand',
    4: '00 thousand',
    5: '000 thousand',
    6: '0 million',
    7: '00 million',
    8: '000 million',
    9: '0 billion',
    10: '00 billion',
    11: '000 billion',
    12: '0 trillion',
    13: '00 trillion',
    14: '000 trillion',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40K',
    4: '\u00A400K',
    5: '\u00A4000K',
    6: '\u00A40M',
    7: '\u00A400M',
    8: '\u00A4000M',
    9: '\u00A40B',
    10: '\u00A400B',
    11: '\u00A4000B',
    12: '\u00A40T',
    13: '\u00A400T',
    14: '\u00A4000T',
  }),
  // Compact number symbols for locale en_ZA.
  "en_ZA": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0K',
    4: '00K',
    5: '000K',
    6: '0M',
    7: '00M',
    8: '000M',
    9: '0B',
    10: '00B',
    11: '000B',
    12: '0T',
    13: '00T',
    14: '000T',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 thousand',
    4: '00 thousand',
    5: '000 thousand',
    6: '0 million',
    7: '00 million',
    8: '000 million',
    9: '0 billion',
    10: '00 billion',
    11: '000 billion',
    12: '0 trillion',
    13: '00 trillion',
    14: '000 trillion',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40K',
    4: '\u00A400K',
    5: '\u00A4000K',
    6: '\u00A40M',
    7: '\u00A400M',
    8: '\u00A4000M',
    9: '\u00A40B',
    10: '\u00A400B',
    11: '\u00A4000B',
    12: '\u00A40T',
    13: '\u00A400T',
    14: '\u00A4000T',
  }),
  // Compact number symbols for locale es.
  "es": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0mil',
    4: '00\u00A0mil',
    5: '000\u00A0mil',
    6: '0\u00A0M',
    7: '00\u00A0M',
    8: '000\u00A0M',
    9: '0000\u00A0M',
    10: '00\u00A0mil\u00A0M',
    11: '000\u00A0mil\u00A0M',
    12: '0\u00A0B',
    13: '00\u00A0B',
    14: '000\u00A0B',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 mil',
    4: '00 mil',
    5: '000 mil',
    6: '0 millones',
    7: '00 millones',
    8: '000 millones',
    9: '0 mil millones',
    10: '00 mil millones',
    11: '000 mil millones',
    12: '0 billones',
    13: '00 billones',
    14: '000 billones',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0mil\u00A0\u00A4',
    4: '00\u00A0mil\u00A0\u00A4',
    5: '000\u00A0mil\u00A0\u00A4',
    6: '0\u00A0M\u00A4',
    7: '00\u00A0M\u00A4',
    8: '000\u00A0M\u00A4',
    9: '0000\u00A0M\u00A4',
    10: '00\u00A0mil\u00A0M\u00A4',
    11: '000\u00A0mil\u00A0M\u00A4',
    12: '0\u00A0B\u00A4',
    13: '00\u00A0B\u00A4',
    14: '000\u00A0B\u00A4',
  }),
  // Compact number symbols for locale es_419.
  "es_419": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0K',
    4: '00\u00A0k',
    5: '000\u00A0k',
    6: '0\u00A0M',
    7: '00\u00A0M',
    8: '000\u00A0M',
    9: '0k\u00A0M',
    10: '00k\u00A0M',
    11: '000k\u00A0M',
    12: '0\u00A0B',
    13: '00\u00A0B',
    14: '000\u00A0B',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 mil',
    4: '00 mil',
    5: '000 mil',
    6: '0 millones',
    7: '00 millones',
    8: '000 millones',
    9: '0 mil millones',
    10: '00 mil millones',
    11: '000 mil millones',
    12: '0 bill\u00F3n',
    13: '00 billones',
    14: '000 billones',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40\u00A0K',
    4: '\u00A400\u00A0K',
    5: '\u00A4000\u00A0K',
    6: '\u00A40\u00A0M',
    7: '\u00A400\u00A0M',
    8: '\u00A4000\u00A0M',
    9: '\u00A40000\u00A0M',
    10: '\u00A400\u00A0MRD',
    11: '\u00A4000\u00A0MRD',
    12: '\u00A40\u00A0B',
    13: '\u00A400\u00A0B',
    14: '\u00A4000\u00A0B',
  }),
  // Compact number symbols for locale es_ES.
  "es_ES": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0mil',
    4: '00\u00A0mil',
    5: '000\u00A0mil',
    6: '0\u00A0M',
    7: '00\u00A0M',
    8: '000\u00A0M',
    9: '0000\u00A0M',
    10: '00\u00A0mil\u00A0M',
    11: '000\u00A0mil\u00A0M',
    12: '0\u00A0B',
    13: '00\u00A0B',
    14: '000\u00A0B',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 mil',
    4: '00 mil',
    5: '000 mil',
    6: '0 millones',
    7: '00 millones',
    8: '000 millones',
    9: '0 mil millones',
    10: '00 mil millones',
    11: '000 mil millones',
    12: '0 billones',
    13: '00 billones',
    14: '000 billones',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0mil\u00A0\u00A4',
    4: '00\u00A0mil\u00A0\u00A4',
    5: '000\u00A0mil\u00A0\u00A4',
    6: '0\u00A0M\u00A4',
    7: '00\u00A0M\u00A4',
    8: '000\u00A0M\u00A4',
    9: '0000\u00A0M\u00A4',
    10: '00\u00A0mil\u00A0M\u00A4',
    11: '000\u00A0mil\u00A0M\u00A4',
    12: '0\u00A0B\u00A4',
    13: '00\u00A0B\u00A4',
    14: '000\u00A0B\u00A4',
  }),
  // Compact number symbols for locale es_MX.
  "es_MX": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0k',
    4: '00\u00A0k',
    5: '000\u00A0k',
    6: '0\u00A0M',
    7: '00\u00A0M',
    8: '000\u00A0M',
    9: '0000\u00A0M',
    10: '00\u00A0mil\u00A0M',
    11: '000\u00A0mil\u00A0M',
    12: '0\u00A0B',
    13: '00\u00A0B',
    14: '000\u00A0B',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 mil',
    4: '00 mil',
    5: '000 mil',
    6: '0 millones',
    7: '00 millones',
    8: '000 millones',
    9: '0 mil millones',
    10: '00 mil millones',
    11: '000 mil millones',
    12: '0 billones',
    13: '00 billones',
    14: '000 billones',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0k\u00A4',
    4: '00\u00A0k\u00A4',
    5: '000\u00A0k\u00A4',
    6: '0\u00A0M\u00A4',
    7: '00\u00A0M\u00A4',
    8: '000\u00A0M\u00A4',
    9: '0000\u00A0M\u00A4',
    10: '00\u00A0MRD\u00A0\u00A4',
    11: '000\u00A0MRD\u00A0\u00A4',
    12: '0\u00A0B\u00A4',
    13: '00\u00A0B\u00A4',
    14: '000\u00A0B\u00A4',
  }),
  // Compact number symbols for locale es_US.
  "es_US": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0K',
    4: '00\u00A0K',
    5: '000\u00A0K',
    6: '0\u00A0M',
    7: '00\u00A0M',
    8: '000\u00A0M',
    9: '0\u00A0B',
    10: '00\u00A0B',
    11: '000\u00A0B',
    12: '0\u00A0T',
    13: '00\u00A0T',
    14: '000\u00A0T',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 mil',
    4: '00 mil',
    5: '000 mil',
    6: '0 millones',
    7: '00 millones',
    8: '000 millones',
    9: '0 billones',
    10: '00 billones',
    11: '000 billones',
    12: '0 trillones',
    13: '00 trillones',
    14: '000 trillones',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0K\u00A0\u00A4',
    4: '00\u00A0K\u00A0\u00A4',
    5: '000\u00A0K\u00A0\u00A4',
    6: '0\u00A0M\u00A0\u00A4',
    7: '00\u00A0M\u00A0\u00A4',
    8: '000\u00A0M\u00A0\u00A4',
    9: '0000\u00A0M\u00A0\u00A4',
    10: '\u00A400\u00A0B',
    11: '\u00A4000\u00A0B',
    12: '\u00A40\u00A0T',
    13: '\u00A400\u00A0T',
    14: '\u00A4000\u00A0T',
  }),
  // Compact number symbols for locale et.
  "et": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0tuh',
    4: '00\u00A0tuh',
    5: '000\u00A0tuh',
    6: '0\u00A0mln',
    7: '00\u00A0mln',
    8: '000\u00A0mln',
    9: '0\u00A0mld',
    10: '00\u00A0mld',
    11: '000\u00A0mld',
    12: '0\u00A0trl',
    13: '00\u00A0trl',
    14: '000\u00A0trl',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 tuhat',
    4: '00 tuhat',
    5: '000 tuhat',
    6: '0 miljonit',
    7: '00 miljonit',
    8: '000 miljonit',
    9: '0 miljardit',
    10: '00 miljardit',
    11: '000 miljardit',
    12: '0 triljonit',
    13: '00 triljonit',
    14: '000 triljonit',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0tuh\u00A0\u00A4',
    4: '00\u00A0tuh\u00A0\u00A4',
    5: '000\u00A0tuh\u00A0\u00A4',
    6: '0\u00A0mln\u00A0\u00A4',
    7: '00\u00A0mln\u00A0\u00A4',
    8: '000\u00A0mln\u00A0\u00A4',
    9: '0\u00A0mld\u00A0\u00A4',
    10: '00\u00A0mld\u00A0\u00A4',
    11: '000\u00A0mld\u00A0\u00A4',
    12: '0\u00A0trl\u00A0\u00A4',
    13: '00\u00A0trl\u00A0\u00A4',
    14: '000\u00A0trl\u00A0\u00A4',
  }),
  // Compact number symbols for locale eu.
  "eu": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0000',
    4: '00000',
    5: '000000',
    6: '0\u00A0M',
    7: '00\u00A0M',
    8: '000\u00A0M',
    9: '0000\u00A0M',
    10: '00000\u00A0M',
    11: '000000\u00A0M',
    12: '0\u00A0B',
    13: '00\u00A0B',
    14: '000\u00A0B',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0000',
    4: '00000',
    5: '000000',
    6: '0 milioi',
    7: '00 milioi',
    8: '000 milioi',
    9: '0000 milioi',
    10: '00000 milioi',
    11: '000000 milioi',
    12: '0 bilioi',
    13: '00 bilioi',
    14: '000 bilioi',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0000\u00A0\u00A4',
    4: '00000\u00A0\u00A4',
    5: '000000\u00A0\u00A4',
    6: '0\u00A0M\u00A0\u00A4',
    7: '00\u00A0M\u00A0\u00A4',
    8: '000\u00A0M\u00A0\u00A4',
    9: '0000\u00A0M\u00A0\u00A4',
    10: '00000\u00A0M\u00A0\u00A4',
    11: '000000\u00A0M\u00A0\u00A4',
    12: '0\u00A0B\u00A0\u00A4',
    13: '00\u00A0B\u00A0\u00A4',
    14: '000\u00A0B\u00A0\u00A4',
  }),
  // Compact number symbols for locale fa.
  "fa": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0\u0647\u0632\u0627\u0631',
    4: '00\u00A0\u0647\u0632\u0627\u0631',
    5: '000\u00A0\u0647\u0632\u0627\u0631',
    6: '0\u00A0\u0645\u06CC\u0644\u06CC\u0648\u0646',
    7: '00\u00A0\u0645\u06CC\u0644\u06CC\u0648\u0646',
    8: '000\u00A0\u0645',
    9: '0\u00A0\u0645',
    10: '00\u00A0\u0645',
    11: '000\u00A0\u0645\u06CC\u0644\u06CC\u0627\u0631\u062F',
    12: '0\u00A0\u062A\u0631\u06CC\u0644\u06CC\u0648\u0646',
    13: '00\u00A0\u062A',
    14: '000\u00A0\u062A',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 \u0647\u0632\u0627\u0631',
    4: '00 \u0647\u0632\u0627\u0631',
    5: '000 \u0647\u0632\u0627\u0631',
    6: '0 \u0645\u06CC\u0644\u06CC\u0648\u0646',
    7: '00 \u0645\u06CC\u0644\u06CC\u0648\u0646',
    8: '000 \u0645\u06CC\u0644\u06CC\u0648\u0646',
    9: '0 \u0645\u06CC\u0644\u06CC\u0627\u0631\u062F',
    10: '00 \u0645\u06CC\u0644\u06CC\u0627\u0631\u062F',
    11: '000 \u0645\u06CC\u0644\u06CC\u0627\u0631\u062F',
    12: '0 \u0647\u0632\u0627\u0631\u0645\u06CC\u0644\u06CC\u0627\u0631\u062F',
    13: '00 \u0647\u0632\u0627\u0631\u0645\u06CC\u0644\u06CC\u0627\u0631\u062F',
    14: '000 \u0647\u0632\u0627\u0631\u0645\u06CC\u0644\u06CC\u0627\u0631\u062F',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0\u0647\u0632\u0627\u0631\u00A0\u00A4',
    4: '00\u00A0\u0647\u0632\u0627\u0631\u00A0\u00A4',
    5: '000\u00A0\u0647\u0632\u0627\u0631\u00A0\u00A4',
    6: '0\u00A0\u0645\u06CC\u0644\u06CC\u0648\u0646\u00A0\u00A4',
    7: '00\u00A0\u0645\u06CC\u0644\u06CC\u0648\u0646\u00A0\u00A4',
    8: '000\u00A0\u0645\u06CC\u0644\u06CC\u0648\u0646\u00A0\u00A4',
    9: '0\u00A0\u0645\u06CC\u0644\u06CC\u0627\u0631\u062F\u00A0\u00A4',
    10: '00\u00A0\u0645\u06CC\u0644\u06CC\u0627\u0631\u062F\u00A0\u00A4',
    11: '000\u00A0\u0645\u06CC\u0644\u06CC\u0627\u0631\u062F\u00A0\u00A4',
    12: '0\u00A0\u0647\u0632\u0627\u0631\u0645\u06CC\u0644\u06CC\u0627\u0631\u062F\u00A0\u00A4',
    13: '00\u00A0\u0647\u0632\u0627\u0631\u0645\u06CC\u0644\u06CC\u0627\u0631\u062F\u00A0\u00A4',
    14: '000\u00A0\u0647\u0632\u0627\u0631\u0645\u06CC\u0644\u06CC\u0627\u0631\u062F\u00A0\u00A4',
  }),
  // Compact number symbols for locale fi.
  "fi": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0t.',
    4: '00\u00A0t.',
    5: '000\u00A0t.',
    6: '0\u00A0milj.',
    7: '00\u00A0milj.',
    8: '000\u00A0milj.',
    9: '0\u00A0mrd.',
    10: '00\u00A0mrd.',
    11: '000\u00A0mrd.',
    12: '0\u00A0bilj.',
    13: '00\u00A0bilj.',
    14: '000\u00A0bilj.',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 tuhatta',
    4: '00 tuhatta',
    5: '000 tuhatta',
    6: '0 miljoonaa',
    7: '00 miljoonaa',
    8: '000 miljoonaa',
    9: '0 miljardia',
    10: '00 miljardia',
    11: '000 miljardia',
    12: '0 biljoonaa',
    13: '00 biljoonaa',
    14: '000 biljoonaa',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0t.\u00A0\u00A4',
    4: '00\u00A0t.\u00A0\u00A4',
    5: '000\u00A0t.\u00A0\u00A4',
    6: '0\u00A0milj.\u00A0\u00A4',
    7: '00\u00A0milj.\u00A0\u00A4',
    8: '000\u00A0milj.\u00A0\u00A4',
    9: '0\u00A0mrd.\u00A0\u00A4',
    10: '00\u00A0mrd.\u00A0\u00A4',
    11: '000\u00A0mrd.\u00A0\u00A4',
    12: '0\u00A0bilj.\u00A0\u00A4',
    13: '00\u00A0bilj.\u00A0\u00A4',
    14: '000\u00A0bilj.\u00A0\u00A4',
  }),
  // Compact number symbols for locale fil.
  "fil": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0K',
    4: '00K',
    5: '000K',
    6: '0M',
    7: '00M',
    8: '000M',
    9: '0B',
    10: '00B',
    11: '000B',
    12: '0T',
    13: '00T',
    14: '000T',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 na libo',
    4: '00 na libo',
    5: '000 na libo',
    6: '0 na milyon',
    7: '00 na milyon',
    8: '000 na milyon',
    9: '0 na bilyon',
    10: '00 na bilyon',
    11: '000 na bilyon',
    12: '0 na trilyon',
    13: '00 na trilyon',
    14: '000 na trilyon',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40K',
    4: '\u00A400K',
    5: '\u00A4000K',
    6: '\u00A40M',
    7: '\u00A400M',
    8: '\u00A4000M',
    9: '\u00A40B',
    10: '\u00A400B',
    11: '\u00A4000B',
    12: '\u00A40T',
    13: '\u00A400T',
    14: '\u00A4000T',
  }),
  // Compact number symbols for locale fr.
  "fr": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0k',
    4: '00\u00A0k',
    5: '000\u00A0k',
    6: '0\u00A0M',
    7: '00\u00A0M',
    8: '000\u00A0M',
    9: '0\u00A0Md',
    10: '00\u00A0Md',
    11: '000\u00A0Md',
    12: '0\u00A0Bn',
    13: '00\u00A0Bn',
    14: '000\u00A0Bn',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 mille',
    4: '00 mille',
    5: '000 mille',
    6: '0 millions',
    7: '00 millions',
    8: '000 millions',
    9: '0 milliards',
    10: '00 milliards',
    11: '000 milliards',
    12: '0 billions',
    13: '00 billions',
    14: '000 billions',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0k\u00A0\u00A4',
    4: '00\u00A0k\u00A0\u00A4',
    5: '000\u00A0k\u00A0\u00A4',
    6: '0\u00A0M\u00A0\u00A4',
    7: '00\u00A0M\u00A0\u00A4',
    8: '000\u00A0M\u00A0\u00A4',
    9: '0\u00A0Md\u00A0\u00A4',
    10: '00\u00A0Md\u00A0\u00A4',
    11: '000\u00A0Md\u00A0\u00A4',
    12: '0\u00A0Bn\u00A0\u00A4',
    13: '00\u00A0Bn\u00A0\u00A4',
    14: '000\u00A0Bn\u00A0\u00A4',
  }),
  // Compact number symbols for locale fr_CA.
  "fr_CA": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0k',
    4: '00\u00A0k',
    5: '000\u00A0k',
    6: '0\u00A0M',
    7: '00\u00A0M',
    8: '000\u00A0M',
    9: '0\u00A0G',
    10: '00\u00A0G',
    11: '000\u00A0G',
    12: '0\u00A0T',
    13: '00\u00A0T',
    14: '000\u00A0T',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 mille',
    4: '00 mille',
    5: '000 mille',
    6: '0 millions',
    7: '00 millions',
    8: '000 millions',
    9: '0 milliards',
    10: '00 milliards',
    11: '000 milliards',
    12: '0 billions',
    13: '00 billions',
    14: '000 billions',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0k\u00A4',
    4: '00\u00A0k\u00A4',
    5: '000\u00A0k\u00A4',
    6: '0\u00A0M\u00A4',
    7: '00\u00A0M\u00A4',
    8: '000\u00A0M\u00A4',
    9: '0\u00A0G\u00A4',
    10: '00\u00A0G\u00A4',
    11: '000\u00A0G\u00A4',
    12: '0\u00A0T\u00A4',
    13: '00\u00A0T\u00A4',
    14: '000\u00A0T\u00A4',
  }),
  // Compact number symbols for locale fr_CH.
  "fr_CH": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0k',
    4: '00\u00A0k',
    5: '000\u00A0k',
    6: '0\u00A0M',
    7: '00\u00A0M',
    8: '000\u00A0M',
    9: '0\u00A0Md',
    10: '00\u00A0Md',
    11: '000\u00A0Md',
    12: '0\u00A0Bn',
    13: '00\u00A0Bn',
    14: '000\u00A0Bn',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 mille',
    4: '00 mille',
    5: '000 mille',
    6: '0 millions',
    7: '00 millions',
    8: '000 millions',
    9: '0 milliards',
    10: '00 milliards',
    11: '000 milliards',
    12: '0 billions',
    13: '00 billions',
    14: '000 billions',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0k\u00A0\u00A4',
    4: '00\u00A0k\u00A0\u00A4',
    5: '000\u00A0k\u00A0\u00A4',
    6: '0\u00A0M\u00A0\u00A4',
    7: '00\u00A0M\u00A0\u00A4',
    8: '000\u00A0M\u00A0\u00A4',
    9: '0\u00A0Md\u00A0\u00A4',
    10: '00\u00A0Md\u00A0\u00A4',
    11: '000\u00A0Md\u00A0\u00A4',
    12: '0\u00A0Bn\u00A0\u00A4',
    13: '00\u00A0Bn\u00A0\u00A4',
    14: '000\u00A0Bn\u00A0\u00A4',
  }),
  // Compact number symbols for locale ga.
  "ga": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0k',
    4: '00k',
    5: '000k',
    6: '0M',
    7: '00M',
    8: '000M',
    9: '0B',
    10: '00B',
    11: '000B',
    12: '0T',
    13: '00T',
    14: '000T',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 m\u00EDle',
    4: '00 m\u00EDle',
    5: '000 m\u00EDle',
    6: '0 milli\u00FAn',
    7: '00 milli\u00FAn',
    8: '000 milli\u00FAn',
    9: '0 billi\u00FAn',
    10: '00 billi\u00FAn',
    11: '000 billi\u00FAn',
    12: '0 trilli\u00FAn',
    13: '00 trilli\u00FAn',
    14: '000 trilli\u00FAn',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40k',
    4: '\u00A400k',
    5: '\u00A4000k',
    6: '\u00A40M',
    7: '\u00A400M',
    8: '\u00A4000M',
    9: '\u00A40B',
    10: '\u00A400B',
    11: '\u00A4000B',
    12: '\u00A40T',
    13: '\u00A400T',
    14: '\u00A4000T',
  }),
  // Compact number symbols for locale gl.
  "gl": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0',
    4: '0',
    5: '0',
    6: '0\u00A0M',
    7: '00\u00A0M',
    8: '000\u00A0M',
    9: '0',
    10: '0',
    11: '0',
    12: '0\u00A0B',
    13: '00\u00A0B',
    14: '000\u00A0B',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0',
    4: '0',
    5: '0',
    6: '0 mill\u00F3ns',
    7: '00 mill\u00F3ns',
    8: '000 mill\u00F3ns',
    9: '0',
    10: '0',
    11: '0',
    12: '0 bill\u00F3ns',
    13: '00 bill\u00F3ns',
    14: '000 bill\u00F3ns',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0\u00A4',
    4: '0\u00A0\u00A4',
    5: '0\u00A0\u00A4',
    6: '0\u00A0M\u00A4',
    7: '00\u00A0M\u00A4',
    8: '000\u00A0M\u00A4',
    9: '0\u00A0\u00A4',
    10: '0\u00A0\u00A4',
    11: '0\u00A0\u00A4',
    12: '0\u00A0B\u00A4',
    13: '00\u00A0B\u00A4',
    14: '000\u00A0B\u00A4',
  }),
  // Compact number symbols for locale gsw.
  "gsw": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0Tsg.',
    4: '00\u00A0Tsg.',
    5: '000\u00A0Tsg.',
    6: '0\u00A0Mio.',
    7: '00\u00A0Mio.',
    8: '000\u00A0Mio.',
    9: '0\u00A0Mrd.',
    10: '00\u00A0Mrd.',
    11: '000\u00A0Mrd.',
    12: '0\u00A0Bio.',
    13: '00\u00A0Bio.',
    14: '000\u00A0Bio.',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 Tuusig',
    4: '00 Tuusig',
    5: '000 Tuusig',
    6: '0 Millioone',
    7: '00 Millioone',
    8: '000 Millioone',
    9: '0 Milliarde',
    10: '00 Milliarde',
    11: '000 Milliarde',
    12: '0 Billioone',
    13: '00 Billioone',
    14: '000 Billioone',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0Tsg.\u00A0\u00A4',
    4: '00\u00A0Tsg.\u00A0\u00A4',
    5: '000\u00A0Tsg.\u00A0\u00A4',
    6: '0\u00A0Mio.\u00A0\u00A4',
    7: '00\u00A0Mio.\u00A0\u00A4',
    8: '000\u00A0Mio.\u00A0\u00A4',
    9: '0\u00A0Mrd.\u00A0\u00A4',
    10: '00\u00A0Mrd.\u00A0\u00A4',
    11: '000\u00A0Mrd.\u00A0\u00A4',
    12: '0\u00A0Bio.\u00A0\u00A4',
    13: '00\u00A0Bio.\u00A0\u00A4',
    14: '000\u00A0Bio.\u00A0\u00A4',
  }),
  // Compact number symbols for locale gu.
  "gu": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0\u0AB9\u0A9C\u0ABE\u0AB0',
    4: '00\u00A0\u0AB9\u0A9C\u0ABE\u0AB0',
    5: '0\u00A0\u0AB2\u0ABE\u0A96',
    6: '00\u00A0\u0AB2\u0ABE\u0A96',
    7: '0\u00A0\u0A95\u0AB0\u0ACB\u0AA1',
    8: '00\u00A0\u0A95\u0AB0\u0ACB\u0AA1',
    9: '0\u00A0\u0A85\u0AAC\u0A9C',
    10: '00\u00A0\u0A85\u0AAC\u0A9C',
    11: '0\u00A0\u0AA8\u0ABF\u0A96\u0AB0\u0ACD\u0AB5',
    12: '0\u00A0\u0AAE\u0AB9\u0ABE\u0AAA\u0AA6\u0ACD\u0AAE',
    13: '0\u00A0\u0AB6\u0A82\u0A95\u0AC1',
    14: '0\u00A0\u0A9C\u0AB2\u0AA7\u0ABF',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 \u0AB9\u0A9C\u0ABE\u0AB0',
    4: '00 \u0AB9\u0A9C\u0ABE\u0AB0',
    5: '0 \u0AB2\u0ABE\u0A96',
    6: '00 \u0AB2\u0ABE\u0A96',
    7: '0 \u0A95\u0AB0\u0ACB\u0AA1',
    8: '00 \u0A95\u0AB0\u0ACB\u0AA1',
    9: '0 \u0A85\u0AAC\u0A9C',
    10: '00 \u0A85\u0AAC\u0A9C',
    11: '0 \u0AA8\u0ABF\u0A96\u0AB0\u0ACD\u0AB5',
    12: '0 \u0AAE\u0AB9\u0ABE\u0AAA\u0AA6\u0ACD\u0AAE',
    13: '0 \u0AB6\u0A82\u0A95\u0AC1',
    14: '0 \u0A9C\u0AB2\u0AA7\u0ABF',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40\u00A0\u0AB9\u0A9C\u0ABE\u0AB0',
    4: '\u00A400\u00A0\u0AB9\u0A9C\u0ABE\u0AB0',
    5: '\u00A40\u00A0\u0AB2\u0ABE\u0A96',
    6: '\u00A400\u00A0\u0AB2\u0ABE\u0A96',
    7: '\u00A40\u00A0\u0A95\u0AB0\u0ACB\u0AA1',
    8: '\u00A400\u00A0\u0A95\u0AB0\u0ACB\u0AA1',
    9: '\u00A40\u00A0\u0A85\u0AAC\u0A9C',
    10: '\u00A400\u00A0\u0A85\u0AAC\u0A9C',
    11: '\u00A40\u00A0\u0AA8\u0ABF\u0A96\u0AB0\u0ACD\u0AB5',
    12: '\u00A40\u00A0\u0AAE\u0AB9\u0ABE\u0AAA\u0AA6\u0ACD\u0AAE',
    13: '\u00A40\u00A0\u0AB6\u0A82\u0A95\u0AC1',
    14: '\u00A40\u00A0\u0A9C\u0AB2\u0AA7\u0ABF',
  }),
  // Compact number symbols for locale haw.
  "haw": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0K',
    4: '00K',
    5: '000K',
    6: '0M',
    7: '00M',
    8: '000M',
    9: '0G',
    10: '00G',
    11: '000G',
    12: '0T',
    13: '00T',
    14: '000T',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40K',
    4: '\u00A400K',
    5: '\u00A4000K',
    6: '\u00A40M',
    7: '\u00A400M',
    8: '\u00A4000M',
    9: '\u00A40G',
    10: '\u00A400G',
    11: '\u00A4000G',
    12: '\u00A40T',
    13: '\u00A400T',
    14: '\u00A4000T',
  }),
  // Compact number symbols for locale he.
  "he": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0K',
    4: '00K',
    5: '000K',
    6: '0M',
    7: '00M',
    8: '000M',
    9: '0B',
    10: '00B',
    11: '000B',
    12: '0T',
    13: '00T',
    14: '000T',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '\u200F0 \u05D0\u05DC\u05E3',
    4: '\u200F00 \u05D0\u05DC\u05E3',
    5: '\u200F000 \u05D0\u05DC\u05E3',
    6: '\u200F0 \u05DE\u05D9\u05DC\u05D9\u05D5\u05DF',
    7: '\u200F00 \u05DE\u05D9\u05DC\u05D9\u05D5\u05DF',
    8: '\u200F000 \u05DE\u05D9\u05DC\u05D9\u05D5\u05DF',
    9: '\u200F0 \u05DE\u05D9\u05DC\u05D9\u05D0\u05E8\u05D3',
    10: '\u200F00 \u05DE\u05D9\u05DC\u05D9\u05D0\u05E8\u05D3',
    11: '\u200F000 \u05DE\u05D9\u05DC\u05D9\u05D0\u05E8\u05D3',
    12: '\u200F0 \u05D8\u05E8\u05D9\u05DC\u05D9\u05D5\u05DF',
    13: '\u200F00 \u05D8\u05E8\u05D9\u05DC\u05D9\u05D5\u05DF',
    14: '\u200F000 \u05D8\u05E8\u05D9\u05DC\u05D9\u05D5\u05DF',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A4\u00A00K',
    4: '\u00A4\u00A000K',
    5: '\u00A4000K',
    6: '\u00A40M',
    7: '\u00A400M',
    8: '\u00A4000M',
    9: '\u00A40B',
    10: '\u00A400B',
    11: '\u00A4000B',
    12: '\u00A40T',
    13: '\u00A400T',
    14: '\u00A4000T',
  }),
  // Compact number symbols for locale hi.
  "hi": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0\u0939\u091C\u093C\u093E\u0930',
    4: '00\u00A0\u0939\u091C\u093C\u093E\u0930',
    5: '0\u00A0\u0932\u093E\u0916',
    6: '00\u00A0\u0932\u093E\u0916',
    7: '0\u00A0\u0915\u0970',
    8: '00\u00A0\u0915\u0970',
    9: '0\u00A0\u0905\u0970',
    10: '00\u00A0\u0905\u0970',
    11: '0\u00A0\u0916\u0970',
    12: '00\u00A0\u0916\u0970',
    13: '0\u00A0\u0928\u0940\u0932',
    14: '00\u00A0\u0928\u0940\u0932',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 \u0939\u091C\u093C\u093E\u0930',
    4: '00 \u0939\u091C\u093C\u093E\u0930',
    5: '0 \u0932\u093E\u0916',
    6: '00 \u0932\u093E\u0916',
    7: '0 \u0915\u0930\u094B\u0921\u093C',
    8: '00 \u0915\u0930\u094B\u0921\u093C',
    9: '0 \u0905\u0930\u092C',
    10: '00 \u0905\u0930\u092C',
    11: '0 \u0916\u0930\u092C',
    12: '00 \u0916\u0930\u092C',
    13: '000 \u0916\u0930\u092C',
    14: '0000 \u0916\u0930\u092C',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40\u00A0\u0939\u091C\u093C\u093E\u0930',
    4: '\u00A400\u00A0\u0939\u091C\u093C\u093E\u0930',
    5: '\u00A40\u00A0\u0932\u093E\u0916',
    6: '\u00A400\u00A0\u0932\u093E\u0916',
    7: '\u00A40\u00A0\u0915\u0970',
    8: '\u00A400\u00A0\u0915\u0970',
    9: '\u00A40\u00A0\u0905\u0970',
    10: '\u00A400\u00A0\u0905\u0970',
    11: '\u00A40\u00A0\u0916\u0970',
    12: '\u00A400\u00A0\u0916\u0970',
    13: '\u00A40\u00A0\u0928\u0940\u0932',
    14: '\u00A400\u00A0\u0928\u0940\u0932',
  }),
  // Compact number symbols for locale hr.
  "hr": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0tis.',
    4: '00\u00A0tis.',
    5: '000\u00A0tis.',
    6: '0\u00A0mil.',
    7: '00\u00A0mil.',
    8: '000\u00A0mil.',
    9: '0\u00A0mlr.',
    10: '00\u00A0mlr.',
    11: '000\u00A0mlr.',
    12: '0\u00A0bil.',
    13: '00\u00A0bil.',
    14: '000\u00A0bil.',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 tisu\u0107a',
    4: '00 tisu\u0107a',
    5: '000 tisu\u0107a',
    6: '0 milijuna',
    7: '00 milijuna',
    8: '000 milijuna',
    9: '0 milijardi',
    10: '00 milijardi',
    11: '000 milijardi',
    12: '0 bilijuna',
    13: '00 bilijuna',
    14: '000 bilijuna',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0000\u00A4',
    4: '00\u00A0tis.\u00A0\u00A4',
    5: '000\u00A0tis.\u00A0\u00A4',
    6: '0\u00A0mil.\u00A0\u00A4',
    7: '00\u00A0mil.\u00A0\u00A4',
    8: '000\u00A0mil.\u00A0\u00A4',
    9: '0\u00A0mlr.\u00A0\u00A4',
    10: '00\u00A0mlr.\u00A0\u00A4',
    11: '000\u00A0mlr.\u00A0\u00A4',
    12: '0\u00A0bil.\u00A0\u00A4',
    13: '00\u00A0bil.\u00A0\u00A4',
    14: '000\u00A0bil.\u00A0\u00A4',
  }),
  // Compact number symbols for locale hu.
  "hu": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0E',
    4: '00\u00A0E',
    5: '000\u00A0E',
    6: '0\u00A0M',
    7: '00\u00A0M',
    8: '000\u00A0M',
    9: '0\u00A0Mrd',
    10: '00\u00A0Mrd',
    11: '000\u00A0Mrd',
    12: '0\u00A0B',
    13: '00\u00A0B',
    14: '000\u00A0B',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 ezer',
    4: '00 ezer',
    5: '000 ezer',
    6: '0 milli\u00F3',
    7: '00 milli\u00F3',
    8: '000 milli\u00F3',
    9: '0 milli\u00E1rd',
    10: '00 milli\u00E1rd',
    11: '000 milli\u00E1rd',
    12: '0 billi\u00F3',
    13: '00 billi\u00F3',
    14: '000 billi\u00F3',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0E\u00A0\u00A4',
    4: '00\u00A0E\u00A0\u00A4',
    5: '000\u00A0E\u00A0\u00A4',
    6: '0\u00A0M\u00A0\u00A4',
    7: '00\u00A0M\u00A0\u00A4',
    8: '000\u00A0M\u00A0\u00A4',
    9: '0\u00A0Mrd\u00A0\u00A4',
    10: '00\u00A0Mrd\u00A0\u00A4',
    11: '000\u00A0Mrd\u00A0\u00A4',
    12: '0\u00A0B\u00A0\u00A4',
    13: '00\u00A0B\u00A0\u00A4',
    14: '000\u00A0B\u00A0\u00A4',
  }),
  // Compact number symbols for locale hy.
  "hy": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0\u0570\u0566\u0580',
    4: '00\u00A0\u0570\u0566\u0580',
    5: '000\u00A0\u0570\u0566\u0580',
    6: '0\u00A0\u0574\u056C\u0576',
    7: '00\u00A0\u0574\u056C\u0576',
    8: '000\u00A0\u0574\u056C\u0576',
    9: '0\u00A0\u0574\u056C\u0580\u0564',
    10: '00\u00A0\u0574\u056C\u0580\u0564',
    11: '000\u00A0\u0574\u056C\u0580\u0564',
    12: '0\u00A0\u057F\u0580\u056C\u0576',
    13: '00\u00A0\u057F\u0580\u056C\u0576',
    14: '000\u00A0\u057F\u0580\u056C\u0576',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 \u0570\u0561\u0566\u0561\u0580',
    4: '00 \u0570\u0561\u0566\u0561\u0580',
    5: '000 \u0570\u0561\u0566\u0561\u0580',
    6: '0 \u0574\u056B\u056C\u056B\u0578\u0576',
    7: '00 \u0574\u056B\u056C\u056B\u0578\u0576',
    8: '000 \u0574\u056B\u056C\u056B\u0578\u0576',
    9: '0 \u0574\u056B\u056C\u056B\u0561\u0580\u0564',
    10: '00 \u0574\u056B\u056C\u056B\u0561\u0580\u0564',
    11: '000 \u0574\u056B\u056C\u056B\u0561\u0580\u0564',
    12: '0 \u057F\u0580\u056B\u056C\u056B\u0578\u0576',
    13: '00 \u057F\u0580\u056B\u056C\u056B\u0578\u0576',
    14: '000 \u057F\u0580\u056B\u056C\u056B\u0578\u0576',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0\u0570\u0566\u0580\u00A0\u00A4',
    4: '00\u00A0\u0570\u0566\u0580\u00A0\u00A4',
    5: '000\u00A0\u0570\u0566\u0580\u00A0\u00A4',
    6: '0\u00A0\u0574\u056C\u0576\u00A0\u00A4',
    7: '00\u00A0\u0574\u056C\u0576\u00A0\u00A4',
    8: '000\u00A0\u0574\u056C\u0576\u00A0\u00A4',
    9: '0\u00A0\u0574\u056C\u0580\u0564\u00A0\u00A4',
    10: '00\u00A0\u0574\u056C\u0580\u0564\u00A0\u00A4',
    11: '000\u00A0\u0574\u056C\u0580\u0564\u00A0\u00A4',
    12: '0\u00A0\u057F\u0580\u056C\u0576\u00A0\u00A4',
    13: '00\u00A0\u057F\u0580\u056C\u0576\u00A0\u00A4',
    14: '000\u00A0\u057F\u0580\u056C\u0576\u00A0\u00A4',
  }),
  // Compact number symbols for locale id.
  "id": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0rb',
    4: '00\u00A0rb',
    5: '000\u00A0rb',
    6: '0\u00A0jt',
    7: '00\u00A0jt',
    8: '000\u00A0jt',
    9: '0\u00A0M',
    10: '00\u00A0M',
    11: '000\u00A0M',
    12: '0\u00A0T',
    13: '00\u00A0T',
    14: '000\u00A0T',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 ribu',
    4: '00 ribu',
    5: '000 ribu',
    6: '0 juta',
    7: '00 juta',
    8: '000 juta',
    9: '0 miliar',
    10: '00 miliar',
    11: '000 miliar',
    12: '0 triliun',
    13: '00 triliun',
    14: '000 triliun',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40\u00A0rb',
    4: '\u00A400\u00A0rb',
    5: '\u00A4000\u00A0rb',
    6: '\u00A40\u00A0jt',
    7: '\u00A400\u00A0jt',
    8: '\u00A4000\u00A0jt',
    9: '\u00A40\u00A0M',
    10: '\u00A400\u00A0M',
    11: '\u00A4000\u00A0M',
    12: '\u00A40\u00A0T',
    13: '\u00A400\u00A0T',
    14: '\u00A4000\u00A0T',
  }),
  // Compact number symbols for locale in.
  "in": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0rb',
    4: '00\u00A0rb',
    5: '000\u00A0rb',
    6: '0\u00A0jt',
    7: '00\u00A0jt',
    8: '000\u00A0jt',
    9: '0\u00A0M',
    10: '00\u00A0M',
    11: '000\u00A0M',
    12: '0\u00A0T',
    13: '00\u00A0T',
    14: '000\u00A0T',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 ribu',
    4: '00 ribu',
    5: '000 ribu',
    6: '0 juta',
    7: '00 juta',
    8: '000 juta',
    9: '0 miliar',
    10: '00 miliar',
    11: '000 miliar',
    12: '0 triliun',
    13: '00 triliun',
    14: '000 triliun',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40\u00A0rb',
    4: '\u00A400\u00A0rb',
    5: '\u00A4000\u00A0rb',
    6: '\u00A40\u00A0jt',
    7: '\u00A400\u00A0jt',
    8: '\u00A4000\u00A0jt',
    9: '\u00A40\u00A0M',
    10: '\u00A400\u00A0M',
    11: '\u00A4000\u00A0M',
    12: '\u00A40\u00A0T',
    13: '\u00A400\u00A0T',
    14: '\u00A4000\u00A0T',
  }),
  // Compact number symbols for locale is.
  "is": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0\u00FE.',
    4: '00\u00A0\u00FE.',
    5: '000\u00A0\u00FE.',
    6: '0\u00A0m.',
    7: '00\u00A0m.',
    8: '000\u00A0m.',
    9: '0\u00A0ma.',
    10: '00\u00A0ma.',
    11: '000\u00A0ma.',
    12: '0\u00A0bn',
    13: '00\u00A0bn',
    14: '000\u00A0bn',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 \u00FE\u00FAsund',
    4: '00 \u00FE\u00FAsund',
    5: '000 \u00FE\u00FAsund',
    6: '0 millj\u00F3nir',
    7: '00 millj\u00F3nir',
    8: '000 millj\u00F3nir',
    9: '0 milljar\u00F0ar',
    10: '00 milljar\u00F0ar',
    11: '000 milljar\u00F0ar',
    12: '0 billj\u00F3nir',
    13: '00 billj\u00F3nir',
    14: '000 billj\u00F3nir',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0\u00FE.\u00A0\u00A4',
    4: '00\u00A0\u00FE.\u00A0\u00A4',
    5: '000\u00A0\u00FE.\u00A0\u00A4',
    6: '0\u00A0m.\u00A0\u00A4',
    7: '00\u00A0m.\u00A0\u00A4',
    8: '000\u00A0m.\u00A0\u00A4',
    9: '0\u00A0ma.\u00A0\u00A4',
    10: '00\u00A0ma.\u00A0\u00A4',
    11: '000\u00A0ma.\u00A0\u00A4',
    12: '0\u00A0bn\u00A0\u00A4',
    13: '00\u00A0bn\u00A0\u00A4',
    14: '000\u00A0bn\u00A0\u00A4',
  }),
  // Compact number symbols for locale it.
  "it": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0',
    4: '0',
    5: '0',
    6: '0\u00A0Mln',
    7: '00\u00A0Mln',
    8: '000\u00A0Mln',
    9: '0\u00A0Mrd',
    10: '00\u00A0Mrd',
    11: '000\u00A0Mrd',
    12: '0\u00A0Bln',
    13: '00\u00A0Bln',
    14: '000\u00A0Bln',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 mila',
    4: '00 mila',
    5: '000 mila',
    6: '0 milioni',
    7: '00 milioni',
    8: '000 milioni',
    9: '0 miliardi',
    10: '00 miliardi',
    11: '000 miliardi',
    12: '0 mila miliardi',
    13: '00 mila miliardi',
    14: '000 mila miliardi',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0',
    4: '0',
    5: '0',
    6: '0\u00A0Mio\u00A0\u00A4',
    7: '00\u00A0Mio\u00A0\u00A4',
    8: '000\u00A0Mio\u00A0\u00A4',
    9: '0\u00A0Mrd\u00A0\u00A4',
    10: '00\u00A0Mrd\u00A0\u00A4',
    11: '000\u00A0Mrd\u00A0\u00A4',
    12: '0\u00A0Bln\u00A0\u00A4',
    13: '00\u00A0Bln\u00A0\u00A4',
    14: '000\u00A0Bln\u00A0\u00A4',
  }),
  // Compact number symbols for locale it_CH.
  "it_CH": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0',
    4: '0',
    5: '0',
    6: '0\u00A0Mln',
    7: '00\u00A0Mln',
    8: '000\u00A0Mln',
    9: '0\u00A0Mrd',
    10: '00\u00A0Mrd',
    11: '000\u00A0Mrd',
    12: '0\u00A0Bln',
    13: '00\u00A0Bln',
    14: '000\u00A0Bln',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 mila',
    4: '00 mila',
    5: '000 mila',
    6: '0 milioni',
    7: '00 milioni',
    8: '000 milioni',
    9: '0 miliardi',
    10: '00 miliardi',
    11: '000 miliardi',
    12: '0 mila miliardi',
    13: '00 mila miliardi',
    14: '000 mila miliardi',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0',
    4: '0',
    5: '0',
    6: '0\u00A0Mio\u00A0\u00A4',
    7: '00\u00A0Mio\u00A0\u00A4',
    8: '000\u00A0Mio\u00A0\u00A4',
    9: '0\u00A0Mrd\u00A0\u00A4',
    10: '00\u00A0Mrd\u00A0\u00A4',
    11: '000\u00A0Mrd\u00A0\u00A4',
    12: '0\u00A0Bln\u00A0\u00A4',
    13: '00\u00A0Bln\u00A0\u00A4',
    14: '000\u00A0Bln\u00A0\u00A4',
  }),
  // Compact number symbols for locale iw.
  "iw": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0K',
    4: '00K',
    5: '000K',
    6: '0M',
    7: '00M',
    8: '000M',
    9: '0B',
    10: '00B',
    11: '000B',
    12: '0T',
    13: '00T',
    14: '000T',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '\u200F0 \u05D0\u05DC\u05E3',
    4: '\u200F00 \u05D0\u05DC\u05E3',
    5: '\u200F000 \u05D0\u05DC\u05E3',
    6: '\u200F0 \u05DE\u05D9\u05DC\u05D9\u05D5\u05DF',
    7: '\u200F00 \u05DE\u05D9\u05DC\u05D9\u05D5\u05DF',
    8: '\u200F000 \u05DE\u05D9\u05DC\u05D9\u05D5\u05DF',
    9: '\u200F0 \u05DE\u05D9\u05DC\u05D9\u05D0\u05E8\u05D3',
    10: '\u200F00 \u05DE\u05D9\u05DC\u05D9\u05D0\u05E8\u05D3',
    11: '\u200F000 \u05DE\u05D9\u05DC\u05D9\u05D0\u05E8\u05D3',
    12: '\u200F0 \u05D8\u05E8\u05D9\u05DC\u05D9\u05D5\u05DF',
    13: '\u200F00 \u05D8\u05E8\u05D9\u05DC\u05D9\u05D5\u05DF',
    14: '\u200F000 \u05D8\u05E8\u05D9\u05DC\u05D9\u05D5\u05DF',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A4\u00A00K',
    4: '\u00A4\u00A000K',
    5: '\u00A4000K',
    6: '\u00A40M',
    7: '\u00A400M',
    8: '\u00A4000M',
    9: '\u00A40B',
    10: '\u00A400B',
    11: '\u00A4000B',
    12: '\u00A40T',
    13: '\u00A400T',
    14: '\u00A4000T',
  }),
  // Compact number symbols for locale ja.
  "ja": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0',
    4: '0\u4E07',
    5: '00\u4E07',
    6: '000\u4E07',
    7: '0000\u4E07',
    8: '0\u5104',
    9: '00\u5104',
    10: '000\u5104',
    11: '0000\u5104',
    12: '0\u5146',
    13: '00\u5146',
    14: '000\u5146',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0',
    4: '0\u4E07',
    5: '00\u4E07',
    6: '000\u4E07',
    7: '0000\u4E07',
    8: '0\u5104',
    9: '00\u5104',
    10: '000\u5104',
    11: '0000\u5104',
    12: '0\u5146',
    13: '00\u5146',
    14: '000\u5146',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0',
    4: '\u00A40\u4E07',
    5: '\u00A400\u4E07',
    6: '\u00A4000\u4E07',
    7: '\u00A40000\u4E07',
    8: '\u00A40\u5104',
    9: '\u00A400\u5104',
    10: '\u00A4000\u5104',
    11: '\u00A40000\u5104',
    12: '\u00A40\u5146',
    13: '\u00A400\u5146',
    14: '\u00A4000\u5146',
  }),
  // Compact number symbols for locale ka.
  "ka": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0\u10D0\u10D7.',
    4: '00\u00A0\u10D0\u10D7.',
    5: '000\u00A0\u10D0\u10D7.',
    6: '0\u00A0\u10DB\u10DA\u10DC.',
    7: '00\u00A0\u10DB\u10DA\u10DC.',
    8: '000\u00A0\u10DB\u10DA\u10DC.',
    9: '0\u00A0\u10DB\u10DA\u10E0\u10D3.',
    10: '00\u00A0\u10DB\u10DA\u10E0\u10D3.',
    11: '000\u00A0\u10DB\u10DA\u10E0.',
    12: '0\u00A0\u10E2\u10E0\u10DA.',
    13: '00\u00A0\u10E2\u10E0\u10DA.',
    14: '000\u00A0\u10E2\u10E0\u10DA.',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 \u10D0\u10D7\u10D0\u10E1\u10D8',
    4: '00 \u10D0\u10D7\u10D0\u10E1\u10D8',
    5: '000 \u10D0\u10D7\u10D0\u10E1\u10D8',
    6: '0 \u10DB\u10D8\u10DA\u10D8\u10DD\u10DC\u10D8',
    7: '00 \u10DB\u10D8\u10DA\u10D8\u10DD\u10DC\u10D8',
    8: '000 \u10DB\u10D8\u10DA\u10D8\u10DD\u10DC\u10D8',
    9: '0 \u10DB\u10D8\u10DA\u10D8\u10D0\u10E0\u10D3\u10D8',
    10: '00 \u10DB\u10D8\u10DA\u10D8\u10D0\u10E0\u10D3\u10D8',
    11: '000 \u10DB\u10D8\u10DA\u10D8\u10D0\u10E0\u10D3\u10D8',
    12: '0 \u10E2\u10E0\u10D8\u10DA\u10D8\u10DD\u10DC\u10D8',
    13: '00 \u10E2\u10E0\u10D8\u10DA\u10D8\u10DD\u10DC\u10D8',
    14: '000 \u10E2\u10E0\u10D8\u10DA\u10D8\u10DD\u10DC\u10D8',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0\u10D0\u10D7.\u00A0\u00A4',
    4: '00\u00A0\u10D0\u10D7.\u00A0\u00A4',
    5: '000\u00A0\u10D0\u10D7.\u00A0\u00A4',
    6: '0\u00A0\u10DB\u10DA\u10DC.\u00A0\u00A4',
    7: '00\u00A0\u10DB\u10DA\u10DC.\u00A0\u00A4',
    8: '000\u00A0\u10DB\u10DA\u10DC.\u00A0\u00A4',
    9: '0\u00A0\u10DB\u10DA\u10E0\u10D3.\u00A0\u00A4',
    10: '00\u00A0\u10DB\u10DA\u10E0\u10D3.\u00A0\u00A4',
    11: '000\u00A0\u10DB\u10DA\u10E0.\u00A0\u00A4',
    12: '0\u00A0\u10E2\u10E0\u10DA.\u00A0\u00A4',
    13: '00\u00A0\u10E2\u10E0\u10DA.\u00A0\u00A4',
    14: '000\u00A0\u10E2\u10E0\u10DA.\u00A0\u00A4',
  }),
  // Compact number symbols for locale kk.
  "kk": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0\u043C\u044B\u04A3',
    4: '00\u00A0\u043C\u044B\u04A3',
    5: '000\u00A0\u043C.',
    6: '0\u00A0\u043C\u043B\u043D',
    7: '00\u00A0\u043C\u043B\u043D',
    8: '000\u00A0\u043C\u043B\u043D',
    9: '0\u00A0\u043C\u043B\u0440\u0434',
    10: '00\u00A0\u043C\u043B\u0440\u0434',
    11: '000\u00A0\u043C\u043B\u0440\u0434',
    12: '0\u00A0\u0442\u0440\u043B\u043D',
    13: '00\u00A0\u0442\u0440\u043B\u043D',
    14: '000\u00A0\u0442\u0440\u043B\u043D',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 \u043C\u044B\u04A3',
    4: '00 \u043C\u044B\u04A3',
    5: '000 \u043C\u044B\u04A3',
    6: '0 \u043C\u0438\u043B\u043B\u0438\u043E\u043D',
    7: '00 \u043C\u0438\u043B\u043B\u0438\u043E\u043D',
    8: '000 \u043C\u0438\u043B\u043B\u0438\u043E\u043D',
    9: '0 \u043C\u0438\u043B\u043B\u0438\u0430\u0440\u0434',
    10: '00 \u043C\u0438\u043B\u043B\u0438\u0430\u0440\u0434',
    11: '000 \u043C\u0438\u043B\u043B\u0438\u0430\u0440\u0434',
    12: '0 \u0442\u0440\u0438\u043B\u043B\u0438\u043E\u043D',
    13: '00 \u0442\u0440\u0438\u043B\u043B\u0438\u043E\u043D',
    14: '000 \u0442\u0440\u0438\u043B\u043B\u0438\u043E\u043D',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0\u043C\u044B\u04A3\u00A0\u00A4',
    4: '00\u00A0\u043C\u044B\u04A3\u00A0\u00A4',
    5: '000\u00A0\u043C\u044B\u04A3\u00A0\u00A4',
    6: '0\u00A0\u043C\u043B\u043D\u00A0\u00A4',
    7: '00\u00A0\u043C\u043B\u043D\u00A0\u00A4',
    8: '000\u00A0\u043C\u043B\u043D\u00A0\u00A4',
    9: '0\u00A0\u043C\u043B\u0440\u0434\u00A0\u00A4',
    10: '00\u00A0\u043C\u043B\u0440\u0434\u00A0\u00A4',
    11: '000\u00A0\u043C\u043B\u0440\u0434\u00A0\u00A4',
    12: '0\u00A0\u0442\u0440\u043B\u043D\u00A0\u00A4',
    13: '00\u00A0\u0442\u0440\u043B\u043D\u00A0\u00A4',
    14: '000\u00A0\u0442\u0440\u043B\u043D\u00A0\u00A4',
  }),
  // Compact number symbols for locale km.
  "km": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u1796\u17B6\u1793\u17CB',
    4: '00\u00A0\u1796\u17B6\u1793\u17CB',
    5: '000\u00A0\u1796\u17B6\u1793\u17CB',
    6: '0\u00A0\u179B\u17B6\u1793',
    7: '00\u00A0\u179B\u17B6\u1793',
    8: '000\u00A0\u179B\u17B6\u1793',
    9: '0\u00A0\u1794\u17CA\u17B8\u179B\u17B6\u1793',
    10: '00\u00A0\u1794\u17CA\u17B8\u179B\u17B6\u1793',
    11: '000\u00A0\u1794\u17CA\u17B8\u179B\u17B6\u1793',
    12: '0\u00A0\u1791\u17D2\u179A\u17B8\u179B\u17B6\u1793',
    13: '00\u00A0\u1791\u17D2\u179A\u17B8\u179B\u17B6\u1793',
    14: '000\u00A0\u1791\u17D2\u179A\u17B8\u179B\u17B6\u1793',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 \u1796\u17B6\u1793\u17CB',
    4: '00 \u1796\u17B6\u1793\u17CB',
    5: '000\u1796\u17B6\u1793\u17CB',
    6: '0 \u179B\u17B6\u1793',
    7: '00 \u179B\u17B6\u1793',
    8: '000 \u179B\u17B6\u1793',
    9: '0 \u1794\u17CA\u17B8\u179B\u17B6\u1793',
    10: '00 \u1794\u17CA\u17B8\u179B\u17B6\u1793',
    11: '000 \u1794\u17CA\u17B8\u179B\u17B6\u1793',
    12: '0 \u1791\u17D2\u179A\u17B8\u179B\u17B6\u1793',
    13: '00 \u1791\u17D2\u179A\u17B8\u179B\u17B6\u1793',
    14: '000 \u1791\u17D2\u179A\u17B8\u179B\u17B6\u1793',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40\u00A0\u1796\u17B6\u1793\u17CB',
    4: '\u00A400\u00A0\u1796\u17B6\u1793\u17CB',
    5: '\u00A4000\u00A0\u1796\u17B6\u1793\u17CB',
    6: '\u00A40\u00A0\u179B\u17B6\u1793',
    7: '\u00A400\u00A0\u179B\u17B6\u1793',
    8: '\u00A4000\u00A0\u179B\u17B6\u1793',
    9: '\u00A40\u00A0\u1794\u17CA\u17B8\u179B\u17B6\u1793',
    10: '\u00A400\u00A0\u1794\u17CA\u17B8\u179B\u17B6\u1793',
    11: '\u00A4000\u00A0\u1794\u17CA\u17B8\u179B\u17B6\u1793',
    12: '\u00A40\u00A0\u1791\u17D2\u179A\u17B8\u179B\u17B6\u1793',
    13: '\u00A400\u00A0\u1791\u17D2\u179A\u17B8\u179B\u17B6\u1793',
    14: '\u00A4000\u00A0\u1791\u17D2\u179A\u17B8\u179B\u17B6\u1793',
  }),
  // Compact number symbols for locale kn.
  "kn": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u0CB8\u0CBE',
    4: '00\u0CB8\u0CBE',
    5: '000\u0CB8\u0CBE',
    6: '0\u0CAE\u0CBF',
    7: '00\u0CAE\u0CBF',
    8: '000\u0CAE\u0CBF',
    9: '0\u0CAC\u0CBF',
    10: '00\u0CAC\u0CBF',
    11: '000\u0CAC\u0CBF',
    12: '0\u0C9F\u0CCD\u0CB0\u0CBF',
    13: '00\u0C9F\u0CCD\u0CB0\u0CBF',
    14: '000\u0C9F\u0CCD\u0CB0\u0CBF',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 \u0CB8\u0CBE\u0CB5\u0CBF\u0CB0',
    4: '00 \u0CB8\u0CBE\u0CB5\u0CBF\u0CB0',
    5: '000 \u0CB8\u0CBE\u0CB5\u0CBF\u0CB0',
    6: '0 \u0CAE\u0CBF\u0CB2\u0CBF\u0CAF\u0CA8\u0CCD',
    7: '00 \u0CAE\u0CBF\u0CB2\u0CBF\u0CAF\u0CA8\u0CCD',
    8: '000 \u0CAE\u0CBF\u0CB2\u0CBF\u0CAF\u0CA8\u0CCD',
    9: '0 \u0CAC\u0CBF\u0CB2\u0CBF\u0CAF\u0CA8\u0CCD',
    10: '00 \u0CAC\u0CBF\u0CB2\u0CBF\u0CAF\u0CA8\u0CCD',
    11: '000 \u0CAC\u0CBF\u0CB2\u0CBF\u0CAF\u0CA8\u0CCD',
    12: '0 \u0C9F\u0CCD\u0CB0\u0CBF\u0CB2\u0CBF\u0CAF\u0CA8\u0CCD\u200C',
    13: '00 \u0C9F\u0CCD\u0CB0\u0CBF\u0CB2\u0CBF\u0CAF\u0CA8\u0CCD\u200C',
    14: '000 \u0C9F\u0CCD\u0CB0\u0CBF\u0CB2\u0CBF\u0CAF\u0CA8\u0CCD\u200C',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40\u0CB8\u0CBE',
    4: '\u00A400\u0CB8\u0CBE',
    5: '\u00A4000\u0CB8\u0CBE',
    6: '\u00A40\u0CAE\u0CBF',
    7: '\u00A400\u0CAE\u0CBF',
    8: '\u00A4000\u0CAE\u0CBF',
    9: '\u00A40\u0CAC\u0CBF',
    10: '\u00A400\u0CAC\u0CBF',
    11: '\u00A4000\u0CAC\u0CBF',
    12: '\u00A40\u0C9F\u0CCD\u0CB0\u0CBF',
    13: '\u00A400\u0C9F\u0CCD\u0CB0\u0CBF',
    14: '\u00A4000\u0C9F\u0CCD\u0CB0\u0CBF',
  }),
  // Compact number symbols for locale ko.
  "ko": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\uCC9C',
    4: '0\uB9CC',
    5: '00\uB9CC',
    6: '000\uB9CC',
    7: '0000\uB9CC',
    8: '0\uC5B5',
    9: '00\uC5B5',
    10: '000\uC5B5',
    11: '0000\uC5B5',
    12: '0\uC870',
    13: '00\uC870',
    14: '000\uC870',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0\uCC9C',
    4: '0\uB9CC',
    5: '00\uB9CC',
    6: '000\uB9CC',
    7: '0000\uB9CC',
    8: '0\uC5B5',
    9: '00\uC5B5',
    10: '000\uC5B5',
    11: '0000\uC5B5',
    12: '0\uC870',
    13: '00\uC870',
    14: '000\uC870',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40\uCC9C',
    4: '\u00A40\uB9CC',
    5: '\u00A400\uB9CC',
    6: '\u00A4000\uB9CC',
    7: '\u00A40000\uB9CC',
    8: '\u00A40\uC5B5',
    9: '\u00A400\uC5B5',
    10: '\u00A4000\uC5B5',
    11: '\u00A40000\uC5B5',
    12: '\u00A40\uC870',
    13: '\u00A400\uC870',
    14: '\u00A4000\uC870',
  }),
  // Compact number symbols for locale ky.
  "ky": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0\u043C\u0438\u04A3',
    4: '00\u00A0\u043C\u0438\u04A3',
    5: '000\u00A0\u043C\u0438\u04A3',
    6: '0\u00A0\u043C\u043B\u043D',
    7: '00\u00A0\u043C\u043B\u043D',
    8: '000\u00A0\u043C\u043B\u043D',
    9: '0\u00A0\u043C\u043B\u0434',
    10: '00\u00A0\u043C\u043B\u0434',
    11: '000\u00A0\u043C\u043B\u0434',
    12: '0\u00A0\u0442\u0440\u043B\u043D',
    13: '00\u00A0\u0442\u0440\u043B\u043D',
    14: '000\u00A0\u0442\u0440\u043B\u043D',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 \u043C\u0438\u04A3',
    4: '00 \u043C\u0438\u04A3',
    5: '000 \u043C\u0438\u04A3',
    6: '0 \u043C\u0438\u043B\u043B\u0438\u043E\u043D',
    7: '00 \u043C\u0438\u043B\u043B\u0438\u043E\u043D',
    8: '000 \u043C\u0438\u043B\u043B\u0438\u043E\u043D',
    9: '0 \u043C\u0438\u043B\u043B\u0438\u0430\u0440\u0434',
    10: '00 \u043C\u0438\u043B\u043B\u0438\u0430\u0440\u0434',
    11: '000 \u043C\u0438\u043B\u043B\u0438\u0430\u0440\u0434',
    12: '0 \u0442\u0440\u0438\u043B\u043B\u0438\u043E\u043D',
    13: '00 \u0442\u0440\u0438\u043B\u043B\u0438\u043E\u043D',
    14: '000 \u0442\u0440\u0438\u043B\u043B\u0438\u043E\u043D',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0\u043C\u0438\u04A3\u00A0\u00A4',
    4: '00\u00A0\u043C\u0438\u04A3\u00A0\u00A4',
    5: '000\u00A0\u043C\u0438\u04A3\u00A0\u00A4',
    6: '0\u00A0\u043C\u043B\u043D\u00A0\u00A4',
    7: '00\u00A0\u043C\u043B\u043D\u00A0\u00A4',
    8: '000\u00A0\u043C\u043B\u043D\u00A0\u00A4',
    9: '0\u00A0\u043C\u043B\u0434\u00A0\u00A4',
    10: '00\u00A0\u043C\u043B\u0434\u00A0\u00A4',
    11: '000\u00A0\u043C\u043B\u0434\u00A0\u00A4',
    12: '0\u00A0\u0442\u0440\u043B\u043D\u00A0\u00A4',
    13: '00\u00A0\u0442\u0440\u043B\u043D\u00A0\u00A4',
    14: '000\u00A0\u0442\u0440\u043B\u043D\u00A0\u00A4',
  }),
  // Compact number symbols for locale ln.
  "ln": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0K',
    4: '00K',
    5: '000K',
    6: '0M',
    7: '00M',
    8: '000M',
    9: '0G',
    10: '00G',
    11: '000G',
    12: '0T',
    13: '00T',
    14: '000T',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0K\u00A0\u00A4',
    4: '00K\u00A0\u00A4',
    5: '000K\u00A0\u00A4',
    6: '0M\u00A0\u00A4',
    7: '00M\u00A0\u00A4',
    8: '000M\u00A0\u00A4',
    9: '0G\u00A0\u00A4',
    10: '00G\u00A0\u00A4',
    11: '000G\u00A0\u00A4',
    12: '0T\u00A0\u00A4',
    13: '00T\u00A0\u00A4',
    14: '000T\u00A0\u00A4',
  }),
  // Compact number symbols for locale lo.
  "lo": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0\u0E9E\u0EB1\u0E99',
    4: '00\u00A0\u0E9E\u0EB1\u0E99',
    5: '000\u00A0\u0E81\u0EB5\u0E9A',
    6: '0\u00A0\u0EA5\u0EC9\u0EB2\u0E99',
    7: '00\u00A0\u0EA5\u0EC9\u0EB2\u0E99',
    8: '000\u00A0\u0EA5\u0EC9\u0EB2\u0E99',
    9: '0\u00A0\u0E95\u0EB7\u0EC9',
    10: '00\u00A0\u0E95\u0EB7\u0EC9',
    11: '000\u00A0\u0E95\u0EB7\u0EC9',
    12: '0\u00A0\u0EA5\u0EC9\u0EB2\u0E99\u0EA5\u0EC9\u0EB2\u0E99',
    13: '00\u0EA5\u0EA5',
    14: '000\u0EA5\u0EA5',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 \u0E9E\u0EB1\u0E99',
    4: '00 \u0E9E\u0EB1\u0E99',
    5: '0 \u0EC1\u0EAA\u0E99',
    6: '0 \u0EA5\u0EC9\u0EB2\u0E99',
    7: '00 \u0EA5\u0EC9\u0EB2\u0E99',
    8: '000 \u0EA5\u0EC9\u0EB2\u0E99',
    9: '0 \u0E95\u0EB7\u0EC9',
    10: '00 \u0E95\u0EB7\u0EC9',
    11: '000 \u0E95\u0EB7\u0EC9',
    12: '0 \u0EA5\u0EC9\u0EB2\u0E99\u0EA5\u0EC9\u0EB2\u0E99',
    13: '00 \u0EA5\u0EC9\u0EB2\u0E99\u0EA5\u0EC9\u0EB2\u0E99',
    14: '000 \u0EA5\u0EC9\u0EB2\u0E99\u0EA5\u0EC9\u0EB2\u0E99',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40\u00A0\u0E9E\u0EB1\u0E99',
    4: '\u00A400\u00A0\u0E9E\u0EB1\u0E99',
    5: '\u00A4000\u00A0\u0E81\u0EB5\u0E9A',
    6: '\u00A40\u00A0\u0EA5\u0EC9\u0EB2\u0E99',
    7: '\u00A400\u00A0\u0EA5\u0EC9\u0EB2\u0E99',
    8: '\u00A4000\u00A0\u0EA5\u0EC9\u0EB2\u0E99',
    9: '\u00A40\u00A0\u0E95\u0EB7\u0EC9',
    10: '\u00A400\u00A0\u0E95\u0EB7\u0EC9',
    11: '\u00A4000\u00A0\u0E95\u0EB7\u0EC9',
    12: '\u00A40\u00A0\u0EA5\u0EC9\u0EB2\u0E99\u0EA5\u0EC9\u0EB2\u0E99',
    13: '\u00A400\u00A0\u0EA5\u0EC9\u0EB2\u0E99\u0EA5\u0EC9\u0EB2\u0E99',
    14: '\u00A4000\u00A0\u0EA5\u0EC9\u0EB2\u0E99\u0EA5\u0EC9\u0EB2\u0E99',
  }),
  // Compact number symbols for locale lt.
  "lt": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0t\u016Bkst.',
    4: '00\u00A0t\u016Bkst.',
    5: '000\u00A0t\u016Bkst.',
    6: '0\u00A0mln.',
    7: '00\u00A0mln.',
    8: '000\u00A0mln.',
    9: '0\u00A0mlrd.',
    10: '00\u00A0mlrd.',
    11: '000\u00A0mlrd.',
    12: '0\u00A0trln.',
    13: '00\u00A0trln.',
    14: '000\u00A0trln.',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 t\u016Bkstan\u010Di\u0173',
    4: '00 t\u016Bkstan\u010Di\u0173',
    5: '000 t\u016Bkstan\u010Di\u0173',
    6: '0 milijon\u0173',
    7: '00 milijon\u0173',
    8: '000 milijon\u0173',
    9: '0 milijard\u0173',
    10: '00 milijard\u0173',
    11: '000 milijard\u0173',
    12: '0 trilijon\u0173',
    13: '00 trilijon\u0173',
    14: '000 trilijon\u0173',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0t\u016Bkst.\u00A0\u00A4',
    4: '00\u00A0t\u016Bkst.\u00A0\u00A4',
    5: '000\u00A0t\u016Bkst.\u00A0\u00A4',
    6: '0\u00A0mln.\u00A0\u00A4',
    7: '00\u00A0mln.\u00A0\u00A4',
    8: '000\u00A0mln.\u00A0\u00A4',
    9: '0\u00A0mlrd.\u00A0\u00A4',
    10: '00\u00A0mlrd.\u00A0\u00A4',
    11: '000\u00A0mlrd.\u00A0\u00A4',
    12: '0\u00A0trln.\u00A0\u00A4',
    13: '00\u00A0trln.\u00A0\u00A4',
    14: '000\u00A0trln.\u00A0\u00A4',
  }),
  // Compact number symbols for locale lv.
  "lv": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0t\u016Bkst.',
    4: '00\u00A0t\u016Bkst.',
    5: '000\u00A0t\u016Bkst.',
    6: '0\u00A0milj.',
    7: '00\u00A0milj.',
    8: '000\u00A0milj.',
    9: '0\u00A0mljrd.',
    10: '00\u00A0mljrd.',
    11: '000\u00A0mljrd.',
    12: '0\u00A0trilj.',
    13: '00\u00A0trilj.',
    14: '000\u00A0trilj.',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 t\u016Bksto\u0161i',
    4: '00 t\u016Bksto\u0161i',
    5: '000 t\u016Bksto\u0161i',
    6: '0 miljoni',
    7: '00 miljoni',
    8: '000 miljoni',
    9: '0 miljardi',
    10: '00 miljardi',
    11: '000 miljardi',
    12: '0 triljoni',
    13: '00 triljoni',
    14: '000 triljoni',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0t\u016Bkst.\u00A0\u00A4',
    4: '00\u00A0t\u016Bkst.\u00A0\u00A4',
    5: '000\u00A0t\u016Bkst.\u00A0\u00A4',
    6: '0\u00A0milj.\u00A0\u00A4',
    7: '00\u00A0milj.\u00A0\u00A4',
    8: '000\u00A0milj.\u00A0\u00A4',
    9: '0\u00A0mljrd.\u00A0\u00A4',
    10: '00\u00A0mljrd.\u00A0\u00A4',
    11: '000\u00A0mljrd.\u00A0\u00A4',
    12: '0\u00A0trilj.\u00A0\u00A4',
    13: '00\u00A0trilj.\u00A0\u00A4',
    14: '000\u00A0trilj.\u00A0\u00A4',
  }),
  // Compact number symbols for locale mk.
  "mk": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0\u0438\u043B\u0458.',
    4: '00\u00A0\u0438\u043B\u0458.',
    5: '000\u00A0\u0438\u043B\u0458.',
    6: '0\u00A0\u043C\u0438\u043B.',
    7: '00\u00A0\u043C\u0438\u043B.',
    8: '000\u00A0\u041C',
    9: '0\u00A0\u043C\u0438\u043B\u0458.',
    10: '00\u00A0\u043C\u0438\u043B\u0458.',
    11: '000\u00A0\u043C\u0438.',
    12: '0\u00A0\u0431\u0438\u043B.',
    13: '00\u00A0\u0431\u0438\u043B.',
    14: '000\u00A0\u0431\u0438\u043B.',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 \u0438\u043B\u0458\u0430\u0434\u0438',
    4: '00 \u0438\u043B\u0458\u0430\u0434\u0438',
    5: '000 \u0438\u043B\u0458\u0430\u0434\u0438',
    6: '0 \u043C\u0438\u043B\u0438\u043E\u043D\u0438',
    7: '00 \u043C\u0438\u043B\u0438\u043E\u043D\u0438',
    8: '000 \u043C\u0438\u043B\u0438\u043E\u043D\u0438',
    9: '0 \u043C\u0438\u043B\u0438\u0458\u0430\u0440\u0434\u0438',
    10: '00 \u043C\u0438\u043B\u0438\u0458\u0430\u0440\u0434\u0438',
    11: '000 \u043C\u0438\u043B\u0438\u0458\u0430\u0440\u0434\u0438',
    12: '0 \u0431\u0438\u043B\u0438\u043E\u043D\u0438',
    13: '00 \u0431\u0438\u043B\u0438\u043E\u043D\u0438',
    14: '000 \u0431\u0438\u043B\u0438\u043E\u043D\u0438',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0\u0438\u043B\u0458.\u00A0\u00A4\u00A0',
    4: '00\u00A0\u0438\u043B\u0458.\u00A0\u00A4\u00A0',
    5: '000\u00A0\u0438\u043B\u0458.\u00A0\u00A4\u00A0',
    6: '0\u00A0\u043C\u0438\u043B.\u00A0\u00A4',
    7: '00\u00A0\u043C\u0438\u043B.\u00A0\u00A4',
    8: '000\u00A0\u043C\u0438\u043B.\u00A0\u00A4',
    9: '0\u00A0\u043C\u0438\u043B\u0458.\u00A0\u00A4',
    10: '00\u00A0\u043C\u0438\u043B\u0458.\u00A0\u00A4',
    11: '000\u00A0\u043C\u0438\u043B\u0458.\u00A0\u00A4',
    12: '0\u00A0\u0431\u0438\u043B.\u00A0\u00A4',
    13: '00\u00A0\u0431\u0438\u043B.\u00A0\u00A4',
    14: '000\u00A0\u0431\u0438\u043B.\u00A0\u00A4',
  }),
  // Compact number symbols for locale ml.
  "ml": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0K',
    4: '00K',
    5: '000K',
    6: '0M',
    7: '00M',
    8: '000M',
    9: '0B',
    10: '00B',
    11: '000B',
    12: '0T',
    13: '00T',
    14: '000T',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 \u0D06\u0D2F\u0D3F\u0D30\u0D02',
    4: '00 \u0D06\u0D2F\u0D3F\u0D30\u0D02',
    5: '000 \u0D06\u0D2F\u0D3F\u0D30\u0D02',
    6: '0 \u0D26\u0D36\u0D32\u0D15\u0D4D\u0D37\u0D02',
    7: '00 \u0D26\u0D36\u0D32\u0D15\u0D4D\u0D37\u0D02',
    8: '000 \u0D26\u0D36\u0D32\u0D15\u0D4D\u0D37\u0D02',
    9: '0 \u0D32\u0D15\u0D4D\u0D37\u0D02 \u0D15\u0D4B\u0D1F\u0D3F',
    10: '00 \u0D32\u0D15\u0D4D\u0D37\u0D02 \u0D15\u0D4B\u0D1F\u0D3F',
    11: '000 \u0D32\u0D15\u0D4D\u0D37\u0D02 \u0D15\u0D4B\u0D1F\u0D3F',
    12: '0 \u0D1F\u0D4D\u0D30\u0D3F\u0D32\u0D4D\u0D2F\u0D7A',
    13: '00 \u0D1F\u0D4D\u0D30\u0D3F\u0D32\u0D4D\u0D2F\u0D7A',
    14: '000 \u0D1F\u0D4D\u0D30\u0D3F\u0D32\u0D4D\u0D2F\u0D7A',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40K',
    4: '\u00A400K',
    5: '\u00A4000K',
    6: '\u00A40M',
    7: '\u00A400M',
    8: '\u00A4000M',
    9: '\u00A40B',
    10: '\u00A400B',
    11: '\u00A4000B',
    12: '\u00A40T',
    13: '\u00A400T',
    14: '\u00A4000T',
  }),
  // Compact number symbols for locale mn.
  "mn": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0\u043C\u044F\u043D\u0433\u0430',
    4: '00\u00A0\u043C\u044F\u043D\u0433\u0430',
    5: '000\u00A0\u043C\u044F\u043D\u0433\u0430',
    6: '0\u00A0\u0441\u0430\u044F',
    7: '00\u00A0\u0441\u0430\u044F',
    8: '000\u00A0\u0441\u0430\u044F',
    9: '0\u00A0\u0442\u044D\u0440\u0431\u0443\u043C',
    10: '00\u00A0\u0442\u044D\u0440\u0431\u0443\u043C',
    11: '000\u0422',
    12: '0\u0418\u041D',
    13: '00\u0418\u041D',
    14: '000\u0418\u041D',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 \u043C\u044F\u043D\u0433\u0430',
    4: '00 \u043C\u044F\u043D\u0433\u0430',
    5: '000 \u043C\u044F\u043D\u0433\u0430',
    6: '0 \u0441\u0430\u044F',
    7: '00 \u0441\u0430\u044F',
    8: '000 \u0441\u0430\u044F',
    9: '0 \u0442\u044D\u0440\u0431\u0443\u043C',
    10: '00 \u0442\u044D\u0440\u0431\u0443\u043C',
    11: '000 \u0442\u044D\u0440\u0431\u0443\u043C',
    12: '0 \u0438\u0445 \u043D\u0430\u044F\u0434',
    13: '00 \u0438\u0445 \u043D\u0430\u044F\u0434',
    14: '000 \u0438\u0445 \u043D\u0430\u044F\u0434',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A4\u00A00\u00A0\u043C\u044F\u043D\u0433\u0430',
    4: '\u00A4\u00A000\u00A0\u043C\u044F\u043D\u0433\u0430',
    5: '\u00A4000\u00A0\u043C\u044F\u043D\u0433\u0430',
    6: '\u00A40\u00A0\u0441\u0430\u044F',
    7: '\u00A400\u00A0\u0441\u0430\u044F',
    8: '\u00A4000\u00A0\u0441\u0430\u044F',
    9: '\u00A40\u00A0\u0442\u044D\u0440\u0431\u0443\u043C',
    10: '\u00A4\u00A000\u00A0\u0442\u044D\u0440\u0431\u0443\u043C',
    11: '\u00A4\u00A0000\u00A0\u0442\u044D\u0440\u0431\u0443\u043C',
    12: '\u00A4\u00A00\u00A0\u0438\u0445\u00A0\u043D\u0430\u044F\u0434',
    13: '\u00A4\u00A000\u00A0\u0438\u0445\u00A0\u043D\u0430\u044F\u0434',
    14: '\u00A4\u00A0000\u00A0\u0438\u0445\u00A0\u043D\u0430\u044F\u0434',
  }),
  // Compact number symbols for locale mr.
  "mr": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0\u0939',
    4: '00\u00A0\u0939',
    5: '0\u00A0\u0932\u093E\u0916',
    6: '00\u00A0\u0932\u093E\u0916',
    7: '0\u00A0\u0915\u094B\u091F\u0940',
    8: '00\u00A0\u0915\u094B\u091F\u0940',
    9: '0\u00A0\u0905\u092C\u094D\u091C',
    10: '00\u00A0\u0905\u092C\u094D\u091C',
    11: '0\u00A0\u0916\u0930\u094D\u0935',
    12: '00\u00A0\u0916\u0930\u094D\u0935',
    13: '0\u00A0\u092A\u0926\u094D\u092E',
    14: '00\u00A0\u092A\u0926\u094D\u092E',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 \u0939\u091C\u093E\u0930',
    4: '00 \u0939\u091C\u093E\u0930',
    5: '0 \u0932\u093E\u0916',
    6: '00 \u0932\u093E\u0916',
    7: '0 \u0915\u094B\u091F\u0940',
    8: '00 \u0915\u094B\u091F\u0940',
    9: '0 \u0905\u092C\u094D\u091C',
    10: '00 \u0905\u092C\u094D\u091C',
    11: '0 \u0916\u0930\u094D\u0935',
    12: '00 \u0916\u0930\u094D\u0935',
    13: '0 \u092A\u0926\u094D\u092E',
    14: '00 \u092A\u0926\u094D\u092E',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40\u00A0\u0939',
    4: '\u00A400\u00A0\u0939',
    5: '\u00A40\u00A0\u0932\u093E\u0916',
    6: '\u00A400\u00A0\u0932\u093E\u0916',
    7: '\u00A40\u00A0\u0915\u094B\u091F\u0940',
    8: '\u00A400\u00A0\u0915\u094B\u091F\u0940',
    9: '\u00A40\u00A0\u0905\u092C\u094D\u091C',
    10: '\u00A400\u00A0\u0905\u092C\u094D\u091C',
    11: '\u00A40\u00A0\u0916\u0930\u094D\u0935',
    12: '\u00A400\u00A0\u0916\u0930\u094D\u0935',
    13: '\u00A40\u00A0\u092A\u0926\u094D\u092E',
    14: '\u00A400\u00A0\u092A\u0926\u094D\u092E',
  }),
  // Compact number symbols for locale ms.
  "ms": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0K',
    4: '00K',
    5: '000K',
    6: '0J',
    7: '00J',
    8: '000J',
    9: '0B',
    10: '00B',
    11: '000B',
    12: '0T',
    13: '00T',
    14: '000T',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 ribu',
    4: '00 ribu',
    5: '000 ribu',
    6: '0 juta',
    7: '00 juta',
    8: '000 juta',
    9: '0 bilion',
    10: '00 bilion',
    11: '000 bilion',
    12: '0 trilion',
    13: '00 trilion',
    14: '000 trilion',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40K',
    4: '\u00A400K',
    5: '\u00A4000K',
    6: '\u00A40J',
    7: '\u00A400J',
    8: '\u00A4000J',
    9: '\u00A40B',
    10: '\u00A400B',
    11: '\u00A4000B',
    12: '\u00A40T',
    13: '\u00A400T',
    14: '\u00A4000T',
  }),
  // Compact number symbols for locale mt.
  "mt": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0K',
    4: '00K',
    5: '000K',
    6: '0M',
    7: '00M',
    8: '000M',
    9: '0G',
    10: '00G',
    11: '000G',
    12: '0T',
    13: '00T',
    14: '000T',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40K',
    4: '\u00A400K',
    5: '\u00A4000K',
    6: '\u00A40M',
    7: '\u00A400M',
    8: '\u00A4000M',
    9: '\u00A40G',
    10: '\u00A400G',
    11: '\u00A4000G',
    12: '\u00A40T',
    13: '\u00A400T',
    14: '\u00A4000T',
  }),
  // Compact number symbols for locale my.
  "my": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u1011\u1031\u102C\u1004\u103A',
    4: '0\u101E\u1031\u102C\u1004\u103A\u1038',
    5: '0\u101E\u102D\u1014\u103A\u1038',
    6: '0\u101E\u1014\u103A\u1038',
    7: '0\u1000\u102F\u100B\u1031',
    8: '00\u1000\u102F\u100B\u1031',
    9: '\u1000\u102F\u100B\u1031000',
    10: '\u1000\u102F\u100B\u10310\u1011',
    11: '\u1000\u102F\u100B\u10310\u101E',
    12: '\u100B\u10310\u101E\u102D\u1014\u103A\u1038',
    13: '\u100B\u10310\u101E\u1014\u103A\u1038',
    14: '0\u1000\u1031\u102C\u100B\u102D',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0\u1011\u1031\u102C\u1004\u103A',
    4: '0\u101E\u1031\u102C\u1004\u103A\u1038',
    5: '0\u101E\u102D\u1014\u103A\u1038',
    6: '0\u101E\u1014\u103A\u1038',
    7: '0\u1000\u102F\u100B\u1031',
    8: '00\u1000\u102F\u100B\u1031',
    9: '\u1000\u102F\u100B\u1031000',
    10: '\u1000\u102F\u100B\u10310000',
    11: '\u1000\u102F\u100B\u10310\u101E\u1031\u102C\u1004\u103A\u1038',
    12: '\u1000\u102F\u100B\u10310\u101E\u102D\u1014\u103A\u1038',
    13: '\u1000\u102F\u100B\u10310\u101E\u1014\u103A\u1038',
    14: '0\u1000\u1031\u102C\u100B\u102D',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A4\u00A00\u1011\u1031\u102C\u1004\u103A',
    4: '\u00A4\u00A00\u101E\u1031\u102C\u1004\u103A\u1038',
    5: '\u00A4\u00A00\u101E\u102D\u1014\u103A\u1038',
    6: '\u00A4\u00A00\u101E\u1014\u103A\u1038',
    7: '\u00A4\u00A00\u1000\u102F\u100B\u1031',
    8: '\u00A4\u00A000\u1000\u102F\u100B\u1031',
    9: '\u00A4\u00A0\u1000\u102F\u100B\u1031000',
    10: '\u00A4\u00A0\u1000\u102F\u100B\u10310000',
    11: '\u00A4\u00A0\u1000\u102F\u100B\u10310\u101E\u1031\u102C\u1004\u103A\u1038',
    12: '\u00A4\u00A0\u1000\u102F\u100B\u10310\u101E\u102D\u1014\u103A\u1038',
    13: '\u00A4\u00A0\u1000\u102F\u100B\u10310\u101E\u1014\u103A\u1038',
    14: '\u00A4\u00A00\u1000\u1031\u102C\u100B\u102D',
  }),
  // Compact number symbols for locale nb.
  "nb": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0k',
    4: '00k',
    5: '000k',
    6: '0\u00A0mill.',
    7: '00\u00A0mill.',
    8: '000\u00A0mill.',
    9: '0\u00A0mrd.',
    10: '00\u00A0mrd.',
    11: '000\u00A0mrd.',
    12: '0\u00A0bill.',
    13: '00\u00A0bill.',
    14: '000\u00A0bill.',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 tusen',
    4: '00 tusen',
    5: '000 tusen',
    6: '0 millioner',
    7: '00 millioner',
    8: '000 millioner',
    9: '0 milliarder',
    10: '00 milliarder',
    11: '000 milliarder',
    12: '0 billioner',
    13: '00 billioner',
    14: '000 billioner',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A4\u00A00k',
    4: '\u00A4\u00A000k',
    5: '\u00A4\u00A0000k',
    6: '\u00A4\u00A00\u00A0mill.',
    7: '\u00A4\u00A000\u00A0mill.',
    8: '\u00A4\u00A0000\u00A0mill.',
    9: '\u00A4\u00A00\u00A0mrd.',
    10: '\u00A4\u00A000\u00A0mrd.',
    11: '\u00A4\u00A0000\u00A0mrd.',
    12: '\u00A4\u00A00\u00A0bill.',
    13: '\u00A4\u00A000\u00A0bill.',
    14: '\u00A4\u00A0000\u00A0bill.',
  }),
  // Compact number symbols for locale ne.
  "ne": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0\u0939\u091C\u093E\u0930',
    4: '00\u00A0\u0939\u091C\u093E\u0930',
    5: '0\u00A0\u0932\u093E\u0916',
    6: '00\u00A0\u0932\u093E\u0916',
    7: '0\u00A0\u0915\u0930\u094B\u0921',
    8: '00\u00A0\u0915\u0930\u094B\u0921',
    9: '0\u00A0\u0905\u0930\u092C',
    10: '00\u00A0\u0905\u0930\u092C',
    11: '0\u00A0\u0916\u0930\u092C',
    12: '00\u00A0\u0916\u0930\u092C',
    13: '0\u00A0\u0936\u0902\u0916',
    14: '00\u00A0\u0936\u0902\u0916',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 \u0939\u091C\u093E\u0930',
    4: '00 \u0939\u091C\u093E\u0930',
    5: '0 \u0932\u093E\u0916',
    6: '0 \u0915\u0930\u094B\u0921',
    7: '00 \u0915\u0930\u094B\u0921',
    8: '000 \u0915\u0930\u094B\u0921',
    9: '0 \u0905\u0930\u092C',
    10: '00 \u0905\u0930\u092C',
    11: '000 \u0905\u0930\u092C',
    12: '00 \u0916\u0930\u092C',
    13: '0 \u0936\u0902\u0916',
    14: '00 \u0936\u0902\u0916',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A4\u00A00\u00A0\u0939\u091C\u093E\u0930',
    4: '\u00A4\u00A000\u00A0\u0939\u091C\u093E\u0930',
    5: '\u00A4\u00A00\u00A0\u0932\u093E\u0916',
    6: '\u00A4\u00A000\u00A0\u0932\u093E\u0916',
    7: '\u00A4\u00A00\u00A0\u0915\u0930\u094B\u0921',
    8: '\u00A4\u00A000\u00A0\u0915\u0930\u094B\u0921',
    9: '\u00A4\u00A00\u00A0\u0905\u0930\u092C',
    10: '\u00A4\u00A000\u00A0\u0905\u0930\u092C',
    11: '\u00A4\u00A00\u00A0\u0916\u0930\u092C',
    12: '\u00A4\u00A000\u00A0\u0916\u0930\u092C',
    13: '\u00A4\u00A00\u00A0\u0936\u0902\u0916',
    14: '\u00A4\u00A000\u00A0\u0936\u0902\u0916',
  }),
  // Compact number symbols for locale nl.
  "nl": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0K',
    4: '00K',
    5: '000K',
    6: '0\u00A0mln.',
    7: '00\u00A0mln.',
    8: '000\u00A0mln.',
    9: '0\u00A0mld.',
    10: '00\u00A0mld.',
    11: '000\u00A0mld.',
    12: '0\u00A0bln.',
    13: '00\u00A0bln.',
    14: '000\u00A0bln.',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 duizend',
    4: '00 duizend',
    5: '000 duizend',
    6: '0 miljoen',
    7: '00 miljoen',
    8: '000 miljoen',
    9: '0 miljard',
    10: '00 miljard',
    11: '000 miljard',
    12: '0 biljoen',
    13: '00 biljoen',
    14: '000 biljoen',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A4\u00A00K',
    4: '\u00A4\u00A000K',
    5: '\u00A4\u00A0000K',
    6: '\u00A4\u00A00\u00A0mln.',
    7: '\u00A4\u00A000\u00A0mln.',
    8: '\u00A4\u00A0000\u00A0mln.',
    9: '\u00A4\u00A00\u00A0mld.',
    10: '\u00A4\u00A000\u00A0mld.',
    11: '\u00A4\u00A0000\u00A0mld.',
    12: '\u00A4\u00A00\u00A0bln.',
    13: '\u00A4\u00A000\u00A0bln.',
    14: '\u00A4\u00A0000\u00A0bln.',
  }),
  // Compact number symbols for locale no.
  "no": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0k',
    4: '00k',
    5: '000k',
    6: '0\u00A0mill.',
    7: '00\u00A0mill.',
    8: '000\u00A0mill.',
    9: '0\u00A0mrd.',
    10: '00\u00A0mrd.',
    11: '000\u00A0mrd.',
    12: '0\u00A0bill.',
    13: '00\u00A0bill.',
    14: '000\u00A0bill.',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 tusen',
    4: '00 tusen',
    5: '000 tusen',
    6: '0 millioner',
    7: '00 millioner',
    8: '000 millioner',
    9: '0 milliarder',
    10: '00 milliarder',
    11: '000 milliarder',
    12: '0 billioner',
    13: '00 billioner',
    14: '000 billioner',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A4\u00A00k',
    4: '\u00A4\u00A000k',
    5: '\u00A4\u00A0000k',
    6: '\u00A4\u00A00\u00A0mill.',
    7: '\u00A4\u00A000\u00A0mill.',
    8: '\u00A4\u00A0000\u00A0mill.',
    9: '\u00A4\u00A00\u00A0mrd.',
    10: '\u00A4\u00A000\u00A0mrd.',
    11: '\u00A4\u00A0000\u00A0mrd.',
    12: '\u00A4\u00A00\u00A0bill.',
    13: '\u00A4\u00A000\u00A0bill.',
    14: '\u00A4\u00A0000\u00A0bill.',
  }),
  // Compact number symbols for locale no_NO.
  "no_NO": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0k',
    4: '00k',
    5: '000k',
    6: '0\u00A0mill.',
    7: '00\u00A0mill.',
    8: '000\u00A0mill.',
    9: '0\u00A0mrd.',
    10: '00\u00A0mrd.',
    11: '000\u00A0mrd.',
    12: '0\u00A0bill.',
    13: '00\u00A0bill.',
    14: '000\u00A0bill.',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 tusen',
    4: '00 tusen',
    5: '000 tusen',
    6: '0 millioner',
    7: '00 millioner',
    8: '000 millioner',
    9: '0 milliarder',
    10: '00 milliarder',
    11: '000 milliarder',
    12: '0 billioner',
    13: '00 billioner',
    14: '000 billioner',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A4\u00A00k',
    4: '\u00A4\u00A000k',
    5: '\u00A4\u00A0000k',
    6: '\u00A4\u00A00\u00A0mill.',
    7: '\u00A4\u00A000\u00A0mill.',
    8: '\u00A4\u00A0000\u00A0mill.',
    9: '\u00A4\u00A00\u00A0mrd.',
    10: '\u00A4\u00A000\u00A0mrd.',
    11: '\u00A4\u00A0000\u00A0mrd.',
    12: '\u00A4\u00A00\u00A0bill.',
    13: '\u00A4\u00A000\u00A0bill.',
    14: '\u00A4\u00A0000\u00A0bill.',
  }),
  // Compact number symbols for locale or.
  "or": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u0B39',
    4: '00\u0B39',
    5: '000\u0B39',
    6: '0\u0B28\u0B3F',
    7: '00\u0B28\u0B3F',
    8: '000\u0B28\u0B3F',
    9: '0\u0B2C\u0B3F',
    10: '00\u0B2C\u0B3F',
    11: '000\u0B2C\u0B3F',
    12: '0\u0B1F\u0B4D\u0B30\u0B3F',
    13: '00\u0B1F\u0B4D\u0B30\u0B3F',
    14: '000\u0B1F\u0B4D\u0B30\u0B3F',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 \u0B39\u0B1C\u0B3E\u0B30',
    4: '00 \u0B39\u0B1C\u0B3E\u0B30',
    5: '000 \u0B39\u0B1C\u0B3E\u0B30',
    6: '0 \u0B28\u0B3F\u0B5F\u0B41\u0B24',
    7: '00 \u0B28\u0B3F\u0B5F\u0B41\u0B24',
    8: '000 \u0B28\u0B3F\u0B5F\u0B41\u0B24',
    9: '0 \u0B36\u0B39\u0B15\u0B4B\u0B1F\u0B3F',
    10: '00 \u0B36\u0B39\u0B15\u0B4B\u0B1F\u0B3F',
    11: '000 \u0B36\u0B39\u0B15\u0B4B\u0B1F\u0B3F',
    12: '0 \u0B32\u0B15\u0B4D\u0B37\u0B15\u0B4B\u0B1F\u0B3F',
    13: '00 \u0B32\u0B15\u0B4D\u0B37\u0B15\u0B4B\u0B1F\u0B3F',
    14: '000 \u0B32\u0B15\u0B4D\u0B37\u0B15\u0B4B\u0B1F\u0B3F',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40\u0B39',
    4: '\u00A400\u0B39',
    5: '\u00A4000\u0B39',
    6: '\u00A40\u0B28\u0B3F',
    7: '\u00A400\u0B28\u0B3F',
    8: '\u00A4000\u0B28\u0B3F',
    9: '\u00A40\u0B2C\u0B3F',
    10: '\u00A400\u0B2C\u0B3F',
    11: '\u00A4000\u0B2C\u0B3F',
    12: '\u00A40\u0B1F\u0B4D\u0B30\u0B3F',
    13: '\u00A400\u0B1F\u0B4D\u0B30\u0B3F',
    14: '\u00A4000\u0B1F\u0B4D\u0B30\u0B3F',
  }),
  // Compact number symbols for locale pa.
  "pa": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0\u0A39\u0A1C\u0A3C\u0A3E\u0A30',
    4: '00\u00A0\u0A39\u0A1C\u0A3C\u0A3E\u0A30',
    5: '0\u00A0\u0A32\u0A71\u0A16',
    6: '00\u00A0\u0A32\u0A71\u0A16',
    7: '0\u00A0\u0A15\u0A30\u0A4B\u0A5C',
    8: '00\u00A0\u0A15\u0A30\u0A4B\u0A5C',
    9: '0\u00A0\u0A05\u0A30\u0A2C',
    10: '00\u00A0\u0A05\u0A30\u0A2C',
    11: '0\u00A0\u0A16\u0A30\u0A2C',
    12: '00\u00A0\u0A16\u0A30\u0A2C',
    13: '0\u00A0\u0A28\u0A40\u0A32',
    14: '00\u00A0\u0A28\u0A40\u0A32',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 \u0A39\u0A1C\u0A3C\u0A3E\u0A30',
    4: '00 \u0A39\u0A1C\u0A3C\u0A3E\u0A30',
    5: '0 \u0A32\u0A71\u0A16',
    6: '00 \u0A32\u0A71\u0A16',
    7: '0 \u0A15\u0A30\u0A4B\u0A5C',
    8: '00 \u0A15\u0A30\u0A4B\u0A5C',
    9: '0 \u0A05\u0A30\u0A2C',
    10: '00 \u0A05\u0A30\u0A2C',
    11: '0 \u0A16\u0A30\u0A2C',
    12: '00 \u0A16\u0A30\u0A2C',
    13: '0 \u0A28\u0A40\u0A32',
    14: '00 \u0A28\u0A40\u0A32',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A4\u00A00\u00A0\u0A39\u0A1C\u0A3C\u0A3E\u0A30',
    4: '\u00A4\u00A000\u00A0\u0A39\u0A1C\u0A3C\u0A3E\u0A30',
    5: '\u00A4\u00A00\u00A0\u0A32\u0A71\u0A16',
    6: '\u00A4\u00A000\u00A0\u0A32\u0A71\u0A16',
    7: '\u00A4\u00A00\u00A0\u0A15\u0A30\u0A4B\u0A5C',
    8: '\u00A4\u00A000\u00A0\u0A15\u0A30\u0A4B\u0A5C',
    9: '\u00A4\u00A00\u00A0\u0A05\u0A30\u0A2C',
    10: '\u00A4\u00A000\u00A0\u0A05\u0A30\u0A2C',
    11: '\u00A4\u00A00\u00A0\u0A16\u0A30\u0A2C',
    12: '\u00A4\u00A000\u00A0\u0A16\u0A30\u0A2C',
    13: '\u00A4\u00A00\u00A0\u0A28\u0A40\u0A32',
    14: '\u00A4\u00A000\u00A0\u0A28\u0A40\u0A32',
  }),
  // Compact number symbols for locale pl.
  "pl": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0tys.',
    4: '00\u00A0tys.',
    5: '000\u00A0tys.',
    6: '0\u00A0mln',
    7: '00\u00A0mln',
    8: '000\u00A0mln',
    9: '0\u00A0mld',
    10: '00\u00A0mld',
    11: '000\u00A0mld',
    12: '0\u00A0bln',
    13: '00\u00A0bln',
    14: '000\u00A0bln',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 tysi\u0105ca',
    4: '00 tysi\u0105ca',
    5: '000 tysi\u0105ca',
    6: '0 miliona',
    7: '00 miliona',
    8: '000 miliona',
    9: '0 miliarda',
    10: '00 miliarda',
    11: '000 miliarda',
    12: '0 biliona',
    13: '00 biliona',
    14: '000 biliona',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0tys.\u00A0\u00A4',
    4: '00\u00A0tys.\u00A0\u00A4',
    5: '000\u00A0tys.\u00A0\u00A4',
    6: '0\u00A0mln\u00A0\u00A4',
    7: '00\u00A0mln\u00A0\u00A4',
    8: '000\u00A0mln\u00A0\u00A4',
    9: '0\u00A0mld\u00A0\u00A4',
    10: '00\u00A0mld\u00A0\u00A4',
    11: '000\u00A0mld\u00A0\u00A4',
    12: '0\u00A0bln\u00A0\u00A4',
    13: '00\u00A0bln\u00A0\u00A4',
    14: '000\u00A0bln\u00A0\u00A4',
  }),
  // Compact number symbols for locale ps.
  "ps": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0K',
    4: '00K',
    5: '000K',
    6: '0M',
    7: '00M',
    8: '000M',
    9: '0B',
    10: '00B',
    11: '000B',
    12: '0T',
    13: '00T',
    14: '000T',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0K',
    4: '00K',
    5: '000K',
    6: '0M',
    7: '00M',
    8: '000M',
    9: '0G',
    10: '00G',
    11: '000G',
    12: '0T',
    13: '00T',
    14: '000T',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0K\u00A0\u00A4',
    4: '00K\u00A0\u00A4',
    5: '000K\u00A0\u00A4',
    6: '0M\u00A0\u00A4',
    7: '00M\u00A0\u00A4',
    8: '000M\u00A0\u00A4',
    9: '0G\u00A0\u00A4',
    10: '00G\u00A0\u00A4',
    11: '000G\u00A0\u00A4',
    12: '0T\u00A0\u00A4',
    13: '00T\u00A0\u00A4',
    14: '000T\u00A0\u00A4',
  }),
  // Compact number symbols for locale pt.
  "pt": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0mil',
    4: '00\u00A0mil',
    5: '000\u00A0mil',
    6: '0\u00A0mi',
    7: '00\u00A0mi',
    8: '000\u00A0mi',
    9: '0\u00A0bi',
    10: '00\u00A0bi',
    11: '000\u00A0bi',
    12: '0\u00A0tri',
    13: '00\u00A0tri',
    14: '000\u00A0tri',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 mil',
    4: '00 mil',
    5: '000 mil',
    6: '0 milh\u00F5es',
    7: '00 milh\u00F5es',
    8: '000 milh\u00F5es',
    9: '0 bilh\u00F5es',
    10: '00 bilh\u00F5es',
    11: '000 bilh\u00F5es',
    12: '0 trilh\u00F5es',
    13: '00 trilh\u00F5es',
    14: '000 trilh\u00F5es',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A4\u00A00\u00A0mil',
    4: '\u00A4\u00A000\u00A0mil',
    5: '\u00A4\u00A0000\u00A0mil',
    6: '\u00A4\u00A00\u00A0mi',
    7: '\u00A4\u00A000\u00A0mi',
    8: '\u00A4\u00A0000\u00A0mi',
    9: '\u00A4\u00A00\u00A0bi',
    10: '\u00A4\u00A000\u00A0bi',
    11: '\u00A4\u00A0000\u00A0bi',
    12: '\u00A4\u00A00\u00A0tri',
    13: '\u00A4\u00A000\u00A0tri',
    14: '\u00A4\u00A0000\u00A0tri',
  }),
  // Compact number symbols for locale pt_BR.
  "pt_BR": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0mil',
    4: '00\u00A0mil',
    5: '000\u00A0mil',
    6: '0\u00A0mi',
    7: '00\u00A0mi',
    8: '000\u00A0mi',
    9: '0\u00A0bi',
    10: '00\u00A0bi',
    11: '000\u00A0bi',
    12: '0\u00A0tri',
    13: '00\u00A0tri',
    14: '000\u00A0tri',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 mil',
    4: '00 mil',
    5: '000 mil',
    6: '0 milh\u00F5es',
    7: '00 milh\u00F5es',
    8: '000 milh\u00F5es',
    9: '0 bilh\u00F5es',
    10: '00 bilh\u00F5es',
    11: '000 bilh\u00F5es',
    12: '0 trilh\u00F5es',
    13: '00 trilh\u00F5es',
    14: '000 trilh\u00F5es',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A4\u00A00\u00A0mil',
    4: '\u00A4\u00A000\u00A0mil',
    5: '\u00A4\u00A0000\u00A0mil',
    6: '\u00A4\u00A00\u00A0mi',
    7: '\u00A4\u00A000\u00A0mi',
    8: '\u00A4\u00A0000\u00A0mi',
    9: '\u00A4\u00A00\u00A0bi',
    10: '\u00A4\u00A000\u00A0bi',
    11: '\u00A4\u00A0000\u00A0bi',
    12: '\u00A4\u00A00\u00A0tri',
    13: '\u00A4\u00A000\u00A0tri',
    14: '\u00A4\u00A0000\u00A0tri',
  }),
  // Compact number symbols for locale pt_PT.
  "pt_PT": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0mil',
    4: '00\u00A0mil',
    5: '000\u00A0mil',
    6: '0\u00A0M',
    7: '00\u00A0M',
    8: '000\u00A0M',
    9: '0\u00A0mM',
    10: '00\u00A0mM',
    11: '000\u00A0mM',
    12: '0\u00A0Bi',
    13: '00\u00A0Bi',
    14: '000\u00A0Bi',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 mil',
    4: '00 mil',
    5: '000 mil',
    6: '0 milh\u00F5es',
    7: '00 milh\u00F5es',
    8: '000 milh\u00F5es',
    9: '0 mil milh\u00F5es',
    10: '00 mil milh\u00F5es',
    11: '000 mil milh\u00F5es',
    12: '0 bili\u00F5es',
    13: '00 bili\u00F5es',
    14: '000 bili\u00F5es',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0mil\u00A0\u00A4',
    4: '00\u00A0mil\u00A0\u00A4',
    5: '000\u00A0mil\u00A0\u00A4',
    6: '0\u00A0M\u00A0\u00A4',
    7: '00\u00A0M\u00A0\u00A4',
    8: '000\u00A0M\u00A0\u00A4',
    9: '0\u00A0mM\u00A0\u00A4',
    10: '00\u00A0mM\u00A0\u00A4',
    11: '000\u00A0mM\u00A0\u00A4',
    12: '0\u00A0B\u00A0\u00A4',
    13: '00\u00A0B\u00A0\u00A4',
    14: '000\u00A0B\u00A0\u00A4',
  }),
  // Compact number symbols for locale ro.
  "ro": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0K',
    4: '00\u00A0K',
    5: '000\u00A0K',
    6: '0\u00A0mil.',
    7: '00\u00A0mil.',
    8: '000\u00A0mil.',
    9: '0\u00A0mld.',
    10: '00\u00A0mld.',
    11: '000\u00A0mld.',
    12: '0\u00A0tril.',
    13: '00\u00A0tril.',
    14: '000\u00A0tril.',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 de mii',
    4: '00 de mii',
    5: '000 de mii',
    6: '0 de milioane',
    7: '00 de milioane',
    8: '000 de milioane',
    9: '0 de miliarde',
    10: '00 de miliarde',
    11: '000 de miliarde',
    12: '0 de trilioane',
    13: '00 de trilioane',
    14: '000 de trilioane',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0mii\u00A0\u00A4',
    4: '00\u00A0mii\u00A0\u00A4',
    5: '000\u00A0mii\u00A0\u00A4',
    6: '0\u00A0mil.\u00A0\u00A4',
    7: '00\u00A0mil.\u00A0\u00A4',
    8: '000\u00A0mil.\u00A0\u00A4',
    9: '0\u00A0mld.\u00A0\u00A4',
    10: '00\u00A0mld.\u00A0\u00A4',
    11: '000\u00A0mld.\u00A0\u00A4',
    12: '0\u00A0tril.\u00A0\u00A4',
    13: '00\u00A0tril.\u00A0\u00A4',
    14: '000\u00A0tril.\u00A0\u00A4',
  }),
  // Compact number symbols for locale ru.
  "ru": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0\u0442\u044B\u0441.',
    4: '00\u00A0\u0442\u044B\u0441.',
    5: '000\u00A0\u0442\u044B\u0441.',
    6: '0\u00A0\u043C\u043B\u043D',
    7: '00\u00A0\u043C\u043B\u043D',
    8: '000\u00A0\u043C\u043B\u043D',
    9: '0\u00A0\u043C\u043B\u0440\u0434',
    10: '00\u00A0\u043C\u043B\u0440\u0434',
    11: '000\u00A0\u043C\u043B\u0440\u0434',
    12: '0\u00A0\u0442\u0440\u043B\u043D',
    13: '00\u00A0\u0442\u0440\u043B\u043D',
    14: '000\u00A0\u0442\u0440\u043B\u043D',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 \u0442\u044B\u0441\u044F\u0447\u0438',
    4: '00 \u0442\u044B\u0441\u044F\u0447\u0438',
    5: '000 \u0442\u044B\u0441\u044F\u0447\u0438',
    6: '0 \u043C\u0438\u043B\u043B\u0438\u043E\u043D\u0430',
    7: '00 \u043C\u0438\u043B\u043B\u0438\u043E\u043D\u0430',
    8: '000 \u043C\u0438\u043B\u043B\u0438\u043E\u043D\u0430',
    9: '0 \u043C\u0438\u043B\u043B\u0438\u0430\u0440\u0434\u0430',
    10: '00 \u043C\u0438\u043B\u043B\u0438\u0430\u0440\u0434\u0430',
    11: '000 \u043C\u0438\u043B\u043B\u0438\u0430\u0440\u0434\u0430',
    12: '0 \u0442\u0440\u0438\u043B\u043B\u0438\u043E\u043D\u0430',
    13: '00 \u0442\u0440\u0438\u043B\u043B\u0438\u043E\u043D\u0430',
    14: '000 \u0442\u0440\u0438\u043B\u043B\u0438\u043E\u043D\u0430',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0\u0442\u044B\u0441.\u00A0\u00A4',
    4: '00\u00A0\u0442\u044B\u0441.\u00A0\u00A4',
    5: '000\u00A0\u0442\u044B\u0441.\u00A0\u00A4',
    6: '0\u00A0\u043C\u043B\u043D\u00A0\u00A4',
    7: '00\u00A0\u043C\u043B\u043D\u00A0\u00A4',
    8: '000\u00A0\u043C\u043B\u043D\u00A0\u00A4',
    9: '0\u00A0\u043C\u043B\u0440\u0434\u00A0\u00A4',
    10: '00\u00A0\u043C\u043B\u0440\u0434\u00A0\u00A4',
    11: '000\u00A0\u043C\u043B\u0440\u0434\u00A0\u00A4',
    12: '0\u00A0\u0442\u0440\u043B\u043D\u00A0\u00A4',
    13: '00\u00A0\u0442\u0440\u043B\u043D\u00A0\u00A4',
    14: '000\u00A0\u0442\u0440\u043B\u043D\u00A0\u00A4',
  }),
  // Compact number symbols for locale si.
  "si": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '\u0DAF0',
    4: '\u0DAF00',
    5: '\u0DAF000',
    6: '\u0DB8\u0DD20',
    7: '\u0DB8\u0DD200',
    8: '\u0DB8\u0DD2000',
    9: '\u0DB6\u0DD20',
    10: '\u0DB6\u0DD200',
    11: '\u0DB6\u0DD2000',
    12: '\u0DA7\u0DCA\u200D\u0DBB\u0DD20',
    13: '\u0DA7\u0DCA\u200D\u0DBB\u0DD200',
    14: '\u0DA7\u0DCA\u200D\u0DBB\u0DD2000',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '\u0DAF\u0DC4\u0DC3 0',
    4: '\u0DAF\u0DC4\u0DC3 00',
    5: '\u0DAF\u0DC4\u0DC3 000',
    6: '\u0DB8\u0DD2\u0DBD\u0DD2\u0DBA\u0DB1 0',
    7: '\u0DB8\u0DD2\u0DBD\u0DD2\u0DBA\u0DB1 00',
    8: '\u0DB8\u0DD2\u0DBD\u0DD2\u0DBA\u0DB1 000',
    9: '\u0DB6\u0DD2\u0DBD\u0DD2\u0DBA\u0DB1 0',
    10: '\u0DB6\u0DD2\u0DBD\u0DD2\u0DBA\u0DB1 00',
    11: '\u0DB6\u0DD2\u0DBD\u0DD2\u0DBA\u0DB1 000',
    12: '\u0DA7\u0DCA\u200D\u0DBB\u0DD2\u0DBD\u0DD2\u0DBA\u0DB1 0',
    13: '\u0DA7\u0DCA\u200D\u0DBB\u0DD2\u0DBD\u0DD2\u0DBA\u0DB1 00',
    14: '\u0DA7\u0DCA\u200D\u0DBB\u0DD2\u0DBD\u0DD2\u0DBA\u0DB1 000',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A4\u0DAF0',
    4: '\u00A4\u0DAF00',
    5: '\u00A4\u0DAF000',
    6: '\u00A4\u0DB8\u0DD20',
    7: '\u00A4\u0DB8\u0DD200',
    8: '\u00A4\u0DB8\u0DD2000',
    9: '\u00A4\u0DB6\u0DD20',
    10: '\u00A4\u0DB6\u0DD200',
    11: '\u00A4\u0DB6\u0DD2000',
    12: '\u00A4\u0DA7\u0DCA\u200D\u0DBB\u0DD20',
    13: '\u00A4\u0DA7\u0DCA\u200D\u0DBB\u0DD200',
    14: '\u00A4\u0DA7\u0DCA\u200D\u0DBB\u0DD2000',
  }),
  // Compact number symbols for locale sk.
  "sk": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0tis.',
    4: '00\u00A0tis.',
    5: '000\u00A0tis.',
    6: '0\u00A0mil.',
    7: '00\u00A0mil.',
    8: '000\u00A0mil.',
    9: '0\u00A0mld.',
    10: '00\u00A0mld.',
    11: '000\u00A0mld.',
    12: '0\u00A0bil.',
    13: '00\u00A0bil.',
    14: '000\u00A0bil.',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 tis\u00EDc',
    4: '00 tis\u00EDc',
    5: '000 tis\u00EDc',
    6: '0 mili\u00F3nov',
    7: '00 mili\u00F3nov',
    8: '000 mili\u00F3nov',
    9: '0 mili\u00E1rd',
    10: '00 mili\u00E1rd',
    11: '000 mili\u00E1rd',
    12: '0 bili\u00F3nov',
    13: '00 bili\u00F3nov',
    14: '000 bili\u00F3nov',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0tis.\u00A0\u00A4',
    4: '00\u00A0tis.\u00A0\u00A4',
    5: '000\u00A0tis.\u00A0\u00A4',
    6: '0\u00A0mil.\u00A0\u00A4',
    7: '00\u00A0mil.\u00A0\u00A4',
    8: '000\u00A0mil.\u00A0\u00A4',
    9: '0\u00A0mld.\u00A0\u00A4',
    10: '00\u00A0mld.\u00A0\u00A4',
    11: '000\u00A0mld.\u00A0\u00A4',
    12: '0\u00A0bil.\u00A0\u00A4',
    13: '00\u00A0bil.\u00A0\u00A4',
    14: '000\u00A0bil.\u00A0\u00A4',
  }),
  // Compact number symbols for locale sl.
  "sl": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0tis.',
    4: '00\u00A0tis.',
    5: '000\u00A0tis.',
    6: '0\u00A0mio.',
    7: '00\u00A0mio.',
    8: '000\u00A0mio.',
    9: '0\u00A0mrd.',
    10: '00\u00A0mrd.',
    11: '000\u00A0mrd.',
    12: '0\u00A0bil.',
    13: '00\u00A0bil.',
    14: '000\u00A0bil.',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 tiso\u010D',
    4: '00 tiso\u010D',
    5: '000 tiso\u010D',
    6: '0 milijonov',
    7: '00 milijonov',
    8: '000 milijonov',
    9: '0 milijard',
    10: '00 milijard',
    11: '000 milijard',
    12: '0 bilijonov',
    13: '00 bilijonov',
    14: '000 bilijonov',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0tis.\u00A0\u00A4',
    4: '00\u00A0tis.\u00A0\u00A4',
    5: '000\u00A0tis.\u00A0\u00A4',
    6: '0\u00A0mio.\u00A0\u00A4',
    7: '00\u00A0mio.\u00A0\u00A4',
    8: '000\u00A0mio.\u00A0\u00A4',
    9: '0\u00A0mrd.\u00A0\u00A4',
    10: '00\u00A0mrd.\u00A0\u00A4',
    11: '000\u00A0mrd.\u00A0\u00A4',
    12: '0\u00A0bil.\u00A0\u00A4',
    13: '00\u00A0bil.\u00A0\u00A4',
    14: '000\u00A0bil.\u00A0\u00A4',
  }),
  // Compact number symbols for locale sq.
  "sq": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0mij\u00EB',
    4: '00\u00A0mij\u00EB',
    5: '000\u00A0mij\u00EB',
    6: '0\u00A0mln',
    7: '00\u00A0mln',
    8: '000\u00A0mln',
    9: '0\u00A0mld',
    10: '00\u00A0mld',
    11: '000\u00A0mld',
    12: '0\u00A0bln',
    13: '00\u00A0bln',
    14: '000\u00A0bln',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 mij\u00EB',
    4: '00 mij\u00EB',
    5: '000 mij\u00EB',
    6: '0 milion',
    7: '00 milion',
    8: '000 milion',
    9: '0 miliard',
    10: '00 miliard',
    11: '000 miliard',
    12: '0 bilion',
    13: '00 bilion',
    14: '000 bilion',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0mij\u00EB\u00A0\u00A4',
    4: '00\u00A0mij\u00EB\u00A0\u00A4',
    5: '000\u00A0mij\u00EB\u00A0\u00A4',
    6: '0\u00A0mln\u00A0\u00A4',
    7: '00\u00A0mln\u00A0\u00A4',
    8: '000\u00A0mln\u00A0\u00A4',
    9: '0\u00A0mld\u00A0\u00A4',
    10: '00\u00A0mld\u00A0\u00A4',
    11: '000\u00A0mld\u00A0\u00A4',
    12: '0\u00A0bln\u00A0\u00A4',
    13: '00\u00A0bln\u00A0\u00A4',
    14: '000\u00A0bln\u00A0\u00A4',
  }),
  // Compact number symbols for locale sr.
  "sr": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0\u0445\u0438\u0459.',
    4: '00\u00A0\u0445\u0438\u0459.',
    5: '000\u00A0\u0445\u0438\u0459.',
    6: '0\u00A0\u043C\u0438\u043B.',
    7: '00\u00A0\u043C\u0438\u043B.',
    8: '000\u00A0\u043C\u0438\u043B.',
    9: '0\u00A0\u043C\u043B\u0440\u0434.',
    10: '00\u00A0\u043C\u043B\u0440\u0434.',
    11: '000\u00A0\u043C\u043B\u0440\u0434.',
    12: '0\u00A0\u0431\u0438\u043B.',
    13: '00\u00A0\u0431\u0438\u043B.',
    14: '000\u00A0\u0431\u0438\u043B.',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 \u0445\u0438\u0459\u0430\u0434\u0430',
    4: '00 \u0445\u0438\u0459\u0430\u0434\u0430',
    5: '000 \u0445\u0438\u0459\u0430\u0434\u0430',
    6: '0 \u043C\u0438\u043B\u0438\u043E\u043D\u0430',
    7: '00 \u043C\u0438\u043B\u0438\u043E\u043D\u0430',
    8: '000 \u043C\u0438\u043B\u0438\u043E\u043D\u0430',
    9: '0 \u043C\u0438\u043B\u0438\u0458\u0430\u0440\u0434\u0438',
    10: '00 \u043C\u0438\u043B\u0438\u0458\u0430\u0440\u0434\u0438',
    11: '000 \u043C\u0438\u043B\u0438\u0458\u0430\u0440\u0434\u0438',
    12: '0 \u0431\u0438\u043B\u0438\u043E\u043D\u0430',
    13: '00 \u0431\u0438\u043B\u0438\u043E\u043D\u0430',
    14: '000 \u0431\u0438\u043B\u0438\u043E\u043D\u0430',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0\u0445\u0438\u0459.\u00A0\u00A4',
    4: '00\u00A0\u0445\u0438\u0459.\u00A0\u00A4',
    5: '000\u00A0\u0445\u0438\u0459.\u00A0\u00A4',
    6: '0\u00A0\u043C\u0438\u043B.\u00A0\u00A4',
    7: '00\u00A0\u043C\u0438\u043B.\u00A0\u00A4',
    8: '000\u00A0\u043C\u0438\u043B.\u00A0\u00A4',
    9: '0\u00A0\u043C\u043B\u0440\u0434.\u00A0\u00A4',
    10: '00\u00A0\u043C\u043B\u0440\u0434.\u00A0\u00A4',
    11: '000\u00A0\u043C\u043B\u0440\u0434.\u00A0\u00A4',
    12: '0\u00A0\u0431\u0438\u043B.\u00A0\u00A4',
    13: '00\u00A0\u0431\u0438\u043B.\u00A0\u00A4',
    14: '000\u00A0\u0431\u0438\u043B.\u00A0\u00A4',
  }),
  // Compact number symbols for locale sr_Latn.
  "sr_Latn": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0hilj.',
    4: '00\u00A0hilj.',
    5: '000\u00A0hilj.',
    6: '0\u00A0mil.',
    7: '00\u00A0mil.',
    8: '000\u00A0mil.',
    9: '0\u00A0mlrd.',
    10: '00\u00A0mlrd.',
    11: '000\u00A0mlrd.',
    12: '0\u00A0bil.',
    13: '00\u00A0bil.',
    14: '000\u00A0bil.',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 hiljada',
    4: '00 hiljada',
    5: '000 hiljada',
    6: '0 miliona',
    7: '00 miliona',
    8: '000 miliona',
    9: '0 milijardi',
    10: '00 milijardi',
    11: '000 milijardi',
    12: '0 biliona',
    13: '00 biliona',
    14: '000 biliona',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0hilj.\u00A0\u00A4',
    4: '00\u00A0hilj.\u00A0\u00A4',
    5: '000\u00A0hilj.\u00A0\u00A4',
    6: '0\u00A0mil.\u00A0\u00A4',
    7: '00\u00A0mil.\u00A0\u00A4',
    8: '000\u00A0mil.\u00A0\u00A4',
    9: '0\u00A0mlrd.\u00A0\u00A4',
    10: '00\u00A0mlrd.\u00A0\u00A4',
    11: '000\u00A0mlrd.\u00A0\u00A4',
    12: '0\u00A0bil.\u00A0\u00A4',
    13: '00\u00A0bil.\u00A0\u00A4',
    14: '000\u00A0bil.\u00A0\u00A4',
  }),
  // Compact number symbols for locale sv.
  "sv": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0tn',
    4: '00\u00A0tn',
    5: '000\u00A0tn',
    6: '0\u00A0mn',
    7: '00\u00A0mn',
    8: '000\u00A0mn',
    9: '0\u00A0md',
    10: '00\u00A0md',
    11: '000\u00A0md',
    12: '0\u00A0bn',
    13: '00\u00A0bn',
    14: '000\u00A0bn',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 tusen',
    4: '00 tusen',
    5: '000 tusen',
    6: '0 miljoner',
    7: '00 miljoner',
    8: '000 miljoner',
    9: '0 miljarder',
    10: '00 miljarder',
    11: '000 miljarder',
    12: '0 biljoner',
    13: '00 biljoner',
    14: '000 biljoner',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0tn\u00A0\u00A4',
    4: '00\u00A0tn\u00A0\u00A4',
    5: '000\u00A0tn\u00A0\u00A4',
    6: '0\u00A0mn\u00A0\u00A4',
    7: '00\u00A0mn\u00A0\u00A4',
    8: '000\u00A0mn\u00A0\u00A4',
    9: '0\u00A0md\u00A0\u00A4',
    10: '00\u00A0md\u00A0\u00A4',
    11: '000\u00A0md\u00A0\u00A4',
    12: '0\u00A0bn\u00A0\u00A4',
    13: '00\u00A0bn\u00A0\u00A4',
    14: '000\u00A0bn\u00A0\u00A4',
  }),
  // Compact number symbols for locale sw.
  "sw": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: 'elfu\u00A00;elfu\u00A0-0',
    4: 'elfu\u00A000;elfu\u00A0-00',
    5: 'elfu\u00A0000;elfu\u00A0-000',
    6: '0M',
    7: '00M',
    8: '000M',
    9: '0B;-0B',
    10: '00B;-00B',
    11: '000B;-000B',
    12: '0T',
    13: '00T',
    14: '000T',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: 'elfu 0;elfu -0',
    4: 'elfu 00;elfu -00',
    5: 'elfu 000;elfu -000',
    6: 'milioni 0;milioni -0',
    7: 'milioni 00;milioni -00',
    8: 'milioni 000;milioni -000',
    9: 'bilioni 0;bilioni -0',
    10: 'bilioni 00;bilioni -00',
    11: 'bilioni 000;bilioni -000',
    12: 'trilioni 0;trilioni -0',
    13: 'trilioni 00;trilioni -00',
    14: 'trilioni 000;trilioni -000',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A4\u00A0elfu0',
    4: '\u00A4\u00A0elfu00;\u00A4elfu\u00A0-00',
    5: '\u00A4\u00A0laki000;\u00A4laki\u00A0-000',
    6: '\u00A4\u00A00M',
    7: '\u00A4\u00A000M;\u00A4-00M',
    8: '\u00A4\u00A0000M',
    9: '\u00A4\u00A00B;\u00A4-0B',
    10: '\u00A4\u00A000B;\u00A4-00B',
    11: '\u00A4\u00A0000B;\u00A4-000B',
    12: '\u00A4\u00A00T',
    13: '\u00A4\u00A000T',
    14: '\u00A4\u00A0000T;\u00A4-000T',
  }),
  // Compact number symbols for locale ta.
  "ta": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u0B86',
    4: '00\u0B86',
    5: '000\u0B86',
    6: '0\u0BAE\u0BBF',
    7: '00\u0BAE\u0BBF',
    8: '000\u0BAE\u0BBF',
    9: '0\u0BAA\u0BBF',
    10: '00\u0BAA\u0BBF',
    11: '000\u0BAA\u0BBF',
    12: '0\u0B9F\u0BBF',
    13: '00\u0B9F\u0BBF',
    14: '000\u0B9F\u0BBF',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 \u0B86\u0BAF\u0BBF\u0BB0\u0BAE\u0BCD',
    4: '00 \u0B86\u0BAF\u0BBF\u0BB0\u0BAE\u0BCD',
    5: '000 \u0B86\u0BAF\u0BBF\u0BB0\u0BAE\u0BCD',
    6: '0 \u0BAE\u0BBF\u0BB2\u0BCD\u0BB2\u0BBF\u0BAF\u0BA9\u0BCD',
    7: '00 \u0BAE\u0BBF\u0BB2\u0BCD\u0BB2\u0BBF\u0BAF\u0BA9\u0BCD',
    8: '000 \u0BAE\u0BBF\u0BB2\u0BCD\u0BB2\u0BBF\u0BAF\u0BA9\u0BCD',
    9: '0 \u0BAA\u0BBF\u0BB2\u0BCD\u0BB2\u0BBF\u0BAF\u0BA9\u0BCD',
    10: '00 \u0BAA\u0BBF\u0BB2\u0BCD\u0BB2\u0BBF\u0BAF\u0BA9\u0BCD',
    11: '000 \u0BAA\u0BBF\u0BB2\u0BCD\u0BB2\u0BBF\u0BAF\u0BA9\u0BCD',
    12: '0 \u0B9F\u0BBF\u0BB0\u0BBF\u0BB2\u0BCD\u0BB2\u0BBF\u0BAF\u0BA9\u0BCD',
    13: '00 \u0B9F\u0BBF\u0BB0\u0BBF\u0BB2\u0BCD\u0BB2\u0BBF\u0BAF\u0BA9\u0BCD',
    14: '000 \u0B9F\u0BBF\u0BB0\u0BBF\u0BB2\u0BCD\u0BB2\u0BBF\u0BAF\u0BA9\u0BCD',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A4\u00A00\u0B86',
    4: '\u00A4\u00A000\u0B86',
    5: '\u00A4\u00A0000\u0B86',
    6: '\u00A4\u00A00\u0BAE\u0BBF',
    7: '\u00A4\u00A000\u0BAE\u0BBF',
    8: '\u00A4\u00A0000\u0BAE\u0BBF',
    9: '\u00A40\u0BAA\u0BBF',
    10: '\u00A4\u00A000\u0BAA\u0BBF',
    11: '\u00A4000\u0BAA\u0BBF',
    12: '\u00A4\u00A00\u0B9F\u0BBF',
    13: '\u00A4\u00A000\u0B9F\u0BBF',
    14: '\u00A4\u00A0000\u0B9F\u0BBF',
  }),
  // Compact number symbols for locale te.
  "te": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u0C35\u0C47',
    4: '00\u0C35\u0C47',
    5: '000\u0C35\u0C47',
    6: '0\u0C2E\u0C3F',
    7: '00\u0C2E\u0C3F',
    8: '000\u0C2E\u0C3F',
    9: '0\u0C2C\u0C3F',
    10: '00\u0C2C\u0C3F',
    11: '000\u0C2C\u0C3F',
    12: '0\u0C1F\u0C4D\u0C30\u0C3F',
    13: '00\u0C1F\u0C4D\u0C30\u0C3F',
    14: '000\u0C1F\u0C4D\u0C30\u0C3F',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 \u0C35\u0C47\u0C32\u0C41',
    4: '00 \u0C35\u0C47\u0C32\u0C41',
    5: '000 \u0C35\u0C47\u0C32\u0C41',
    6: '0 \u0C2E\u0C3F\u0C32\u0C3F\u0C2F\u0C28\u0C4D\u0C32\u0C41',
    7: '00 \u0C2E\u0C3F\u0C32\u0C3F\u0C2F\u0C28\u0C4D\u0C32\u0C41',
    8: '000 \u0C2E\u0C3F\u0C32\u0C3F\u0C2F\u0C28\u0C4D\u0C32\u0C41',
    9: '0 \u0C2C\u0C3F\u0C32\u0C3F\u0C2F\u0C28\u0C4D\u0C32\u0C41',
    10: '00 \u0C2C\u0C3F\u0C32\u0C3F\u0C2F\u0C28\u0C4D\u0C32\u0C41',
    11: '000 \u0C2C\u0C3F\u0C32\u0C3F\u0C2F\u0C28\u0C4D\u0C32\u0C41',
    12: '0 \u0C1F\u0C4D\u0C30\u0C3F\u0C32\u0C3F\u0C2F\u0C28\u0C4D\u0C32\u0C41',
    13: '00 \u0C1F\u0C4D\u0C30\u0C3F\u0C32\u0C3F\u0C2F\u0C28\u0C4D\u0C32\u0C41',
    14: '000 \u0C1F\u0C4D\u0C30\u0C3F\u0C32\u0C3F\u0C2F\u0C28\u0C4D\u0C32\u0C41',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40\u0C35\u0C47',
    4: '\u00A400\u0C35\u0C47',
    5: '\u00A4000\u0C35\u0C47',
    6: '\u00A40\u0C2E\u0C3F',
    7: '\u00A400\u0C2E\u0C3F',
    8: '\u00A4000\u0C2E\u0C3F',
    9: '\u00A40\u0C2C\u0C3F',
    10: '\u00A400\u0C2C\u0C3F',
    11: '\u00A4000\u0C2C\u0C3F',
    12: '\u00A40\u0C1F\u0C4D\u0C30\u0C3F',
    13: '\u00A400\u0C1F\u0C4D\u0C30\u0C3F',
    14: '\u00A4000\u0C1F\u0C4D\u0C30\u0C3F',
  }),
  // Compact number symbols for locale th.
  "th": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0K',
    4: '00K',
    5: '000K',
    6: '0M',
    7: '00M',
    8: '000M',
    9: '0B',
    10: '00B',
    11: '000B',
    12: '0T',
    13: '00T',
    14: '000T',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 \u0E1E\u0E31\u0E19',
    4: '0 \u0E2B\u0E21\u0E37\u0E48\u0E19',
    5: '0 \u0E41\u0E2A\u0E19',
    6: '0 \u0E25\u0E49\u0E32\u0E19',
    7: '00 \u0E25\u0E49\u0E32\u0E19',
    8: '000 \u0E25\u0E49\u0E32\u0E19',
    9: '0 \u0E1E\u0E31\u0E19\u0E25\u0E49\u0E32\u0E19',
    10: '0 \u0E2B\u0E21\u0E37\u0E48\u0E19\u0E25\u0E49\u0E32\u0E19',
    11: '0 \u0E41\u0E2A\u0E19\u0E25\u0E49\u0E32\u0E19',
    12: '0 \u0E25\u0E49\u0E32\u0E19\u0E25\u0E49\u0E32\u0E19',
    13: '00 \u0E25\u0E49\u0E32\u0E19\u0E25\u0E49\u0E32\u0E19',
    14: '000 \u0E25\u0E49\u0E32\u0E19\u0E25\u0E49\u0E32\u0E19',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40K',
    4: '\u00A400K',
    5: '\u00A4000K',
    6: '\u00A40M',
    7: '\u00A400M',
    8: '\u00A4000M',
    9: '\u00A40B',
    10: '\u00A400B',
    11: '\u00A4000B',
    12: '\u00A40T',
    13: '\u00A400T',
    14: '\u00A4000T',
  }),
  // Compact number symbols for locale tl.
  "tl": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0K',
    4: '00K',
    5: '000K',
    6: '0M',
    7: '00M',
    8: '000M',
    9: '0B',
    10: '00B',
    11: '000B',
    12: '0T',
    13: '00T',
    14: '000T',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 na libo',
    4: '00 na libo',
    5: '000 na libo',
    6: '0 na milyon',
    7: '00 na milyon',
    8: '000 na milyon',
    9: '0 na bilyon',
    10: '00 na bilyon',
    11: '000 na bilyon',
    12: '0 na trilyon',
    13: '00 na trilyon',
    14: '000 na trilyon',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40K',
    4: '\u00A400K',
    5: '\u00A4000K',
    6: '\u00A40M',
    7: '\u00A400M',
    8: '\u00A4000M',
    9: '\u00A40B',
    10: '\u00A400B',
    11: '\u00A4000B',
    12: '\u00A40T',
    13: '\u00A400T',
    14: '\u00A4000T',
  }),
  // Compact number symbols for locale tr.
  "tr": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0B',
    4: '00\u00A0B',
    5: '000\u00A0B',
    6: '0\u00A0Mn',
    7: '00\u00A0Mn',
    8: '000\u00A0Mn',
    9: '0\u00A0Mr',
    10: '00\u00A0Mr',
    11: '000\u00A0Mr',
    12: '0\u00A0Tn',
    13: '00\u00A0Tn',
    14: '000\u00A0Tn',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 bin',
    4: '00 bin',
    5: '000 bin',
    6: '0 milyon',
    7: '00 milyon',
    8: '000 milyon',
    9: '0 milyar',
    10: '00 milyar',
    11: '000 milyar',
    12: '0 trilyon',
    13: '00 trilyon',
    14: '000 trilyon',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0B\u00A0\u00A4',
    4: '00\u00A0B\u00A0\u00A4',
    5: '000\u00A0B\u00A0\u00A4',
    6: '0\u00A0Mn\u00A0\u00A4',
    7: '00\u00A0Mn\u00A0\u00A4',
    8: '000\u00A0Mn\u00A0\u00A4',
    9: '0\u00A0Mr\u00A0\u00A4',
    10: '00\u00A0Mr\u00A0\u00A4',
    11: '000\u00A0Mr\u00A0\u00A4',
    12: '0\u00A0Tn\u00A0\u00A4',
    13: '00\u00A0Tn\u00A0\u00A4',
    14: '000\u00A0Tn\u00A0\u00A4',
  }),
  // Compact number symbols for locale uk.
  "uk": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0\u0442\u0438\u0441.',
    4: '00\u00A0\u0442\u0438\u0441.',
    5: '000\u00A0\u0442\u0438\u0441.',
    6: '0\u00A0\u043C\u043B\u043D',
    7: '00\u00A0\u043C\u043B\u043D',
    8: '000\u00A0\u043C\u043B\u043D',
    9: '0\u00A0\u043C\u043B\u0440\u0434',
    10: '00\u00A0\u043C\u043B\u0440\u0434',
    11: '000\u00A0\u043C\u043B\u0440\u0434',
    12: '0\u00A0\u0442\u0440\u043B\u043D',
    13: '00\u00A0\u0442\u0440\u043B\u043D',
    14: '000\u00A0\u0442\u0440\u043B\u043D',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 \u0442\u0438\u0441\u044F\u0447\u0456',
    4: '00 \u0442\u0438\u0441\u044F\u0447\u0456',
    5: '000 \u0442\u0438\u0441\u044F\u0447\u0456',
    6: '0 \u043C\u0456\u043B\u044C\u0439\u043E\u043D\u0430',
    7: '00 \u043C\u0456\u043B\u044C\u0439\u043E\u043D\u0430',
    8: '000 \u043C\u0456\u043B\u044C\u0439\u043E\u043D\u0430',
    9: '0 \u043C\u0456\u043B\u044C\u044F\u0440\u0434\u0430',
    10: '00 \u043C\u0456\u043B\u044C\u044F\u0440\u0434\u0430',
    11: '000 \u043C\u0456\u043B\u044C\u044F\u0440\u0434\u0430',
    12: '0 \u0442\u0440\u0438\u043B\u044C\u0439\u043E\u043D\u0430',
    13: '00 \u0442\u0440\u0438\u043B\u044C\u0439\u043E\u043D\u0430',
    14: '000 \u0442\u0440\u0438\u043B\u044C\u0439\u043E\u043D\u0430',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0\u0442\u0438\u0441.\u00A0\u00A4',
    4: '00\u00A0\u0442\u0438\u0441.\u00A0\u00A4',
    5: '000\u00A0\u0442\u0438\u0441.\u00A0\u00A4',
    6: '0\u00A0\u043C\u043B\u043D\u00A0\u00A4',
    7: '00\u00A0\u043C\u043B\u043D\u00A0\u00A4',
    8: '000\u00A0\u043C\u043B\u043D\u00A0\u00A4',
    9: '0\u00A0\u043C\u043B\u0440\u0434\u00A0\u00A4',
    10: '00\u00A0\u043C\u043B\u0440\u0434\u00A0\u00A4',
    11: '000\u00A0\u043C\u043B\u0440\u0434\u00A0\u00A4',
    12: '0\u00A0\u0442\u0440\u043B\u043D\u00A0\u00A4',
    13: '00\u00A0\u0442\u0440\u043B\u043D\u00A0\u00A4',
    14: '000\u00A0\u0442\u0440\u043B\u043D\u00A0\u00A4',
  }),
  // Compact number symbols for locale ur.
  "ur": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0\u06C1\u0632\u0627\u0631',
    4: '00\u00A0\u06C1\u0632\u0627\u0631',
    5: '0\u00A0\u0644\u0627\u06A9\u06BE',
    6: '00\u00A0\u0644\u0627\u06A9\u06BE',
    7: '0\u00A0\u06A9\u0631\u0648\u0691',
    8: '00\u00A0\u06A9\u0631\u0648\u0691',
    9: '0\u00A0\u0627\u0631\u0628',
    10: '00\u00A0\u0627\u0631\u0628',
    11: '0\u00A0\u06A9\u06BE\u0631\u0628',
    12: '00\u00A0\u06A9\u06BE\u0631\u0628',
    13: '00\u00A0\u0679\u0631\u06CC\u0644\u06CC\u0646',
    14: '000\u00A0\u0679\u0631\u06CC\u0644\u06CC\u0646',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 \u06C1\u0632\u0627\u0631',
    4: '00 \u06C1\u0632\u0627\u0631',
    5: '0 \u0644\u0627\u06A9\u06BE',
    6: '00 \u0644\u0627\u06A9\u06BE',
    7: '0 \u06A9\u0631\u0648\u0691',
    8: '00 \u06A9\u0631\u0648\u0691',
    9: '0 \u0627\u0631\u0628',
    10: '00 \u0627\u0631\u0628',
    11: '0 \u06A9\u06BE\u0631\u0628',
    12: '00 \u06A9\u06BE\u0631\u0628',
    13: '00 \u0679\u0631\u06CC\u0644\u06CC\u0646',
    14: '000 \u0679\u0631\u06CC\u0644\u06CC\u0646',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A4\u00A00\u00A0\u06C1\u0632\u0627\u0631',
    4: '\u00A4\u00A000\u00A0\u06C1\u0632\u0627\u0631',
    5: '\u00A4\u00A00\u00A0\u0644\u0627\u06A9\u06BE',
    6: '\u00A4\u00A000\u00A0\u0644\u0627\u06A9\u06BE',
    7: '\u00A4\u00A00\u00A0\u06A9\u0631\u0648\u0691',
    8: '\u00A4\u00A000\u00A0\u06A9\u0631\u0648\u0691',
    9: '\u00A4\u00A00\u00A0\u0627\u0631\u0628',
    10: '\u00A4\u00A000\u00A0\u0627\u0631\u0628',
    11: '\u00A4\u00A00\u00A0\u06A9\u06BE\u0631\u0628',
    12: '\u00A40\u00A0\u0679\u0631\u06CC\u0644\u06CC\u0646',
    13: '\u00A4\u00A000\u00A0\u0679\u0631\u06CC\u0644\u06CC\u0646',
    14: '\u00A4\u00A0000\u00A0\u0679\u0631\u06CC\u0644\u06CC\u0646',
  }),
  // Compact number symbols for locale uz.
  "uz": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0ming',
    4: '00\u00A0ming',
    5: '000\u00A0ming',
    6: '0\u00A0mln',
    7: '00\u00A0mln',
    8: '000\u00A0mln',
    9: '0\u00A0mlrd',
    10: '00\u00A0mlrd',
    11: '000\u00A0mlrd',
    12: '0\u00A0trln',
    13: '00\u00A0trln',
    14: '000\u00A0trln',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 ming',
    4: '00 ming',
    5: '000 ming',
    6: '0 million',
    7: '00 million',
    8: '000 million',
    9: '0 milliard',
    10: '00 milliard',
    11: '000 milliard',
    12: '0 trillion',
    13: '00 trillion',
    14: '000 trillion',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0ming\u00A0\u00A4',
    4: '00\u00A0ming\u00A0\u00A4',
    5: '000\u00A0ming\u00A0\u00A4',
    6: '0\u00A0mln\u00A0\u00A4',
    7: '00\u00A0mln\u00A0\u00A4',
    8: '000\u00A0mln\u00A0\u00A4',
    9: '0\u00A0mlrd\u00A0\u00A4',
    10: '00\u00A0mlrd\u00A0\u00A4',
    11: '000\u00A0mlrd\u00A0\u00A4',
    12: '0\u00A0trln\u00A0\u00A4',
    13: '00\u00A0trln\u00A0\u00A4',
    14: '000\u00A0trln\u00A0\u00A4',
  }),
  // Compact number symbols for locale vi.
  "vi": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0\u00A0N',
    4: '00\u00A0N',
    5: '000\u00A0N',
    6: '0\u00A0Tr',
    7: '00\u00A0Tr',
    8: '000\u00A0Tr',
    9: '0\u00A0T',
    10: '00\u00A0T',
    11: '000\u00A0T',
    12: '0\u00A0NT',
    13: '00\u00A0NT',
    14: '000\u00A0NT',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 ngh\u00ECn',
    4: '00 ngh\u00ECn',
    5: '000 ngh\u00ECn',
    6: '0 tri\u1EC7u',
    7: '00 tri\u1EC7u',
    8: '000 tri\u1EC7u',
    9: '0 t\u1EF7',
    10: '00 t\u1EF7',
    11: '000 t\u1EF7',
    12: '0 ngh\u00ECn t\u1EF7',
    13: '00 ngh\u00ECn t\u1EF7',
    14: '000 ngh\u00ECn t\u1EF7',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0\u00A0N\u00A0\u00A4',
    4: '00\u00A0N\u00A0\u00A4',
    5: '000\u00A0N\u00A0\u00A4',
    6: '0\u00A0Tr\u00A0\u00A4',
    7: '00\u00A0Tr\u00A0\u00A4',
    8: '000\u00A0Tr\u00A0\u00A4',
    9: '0\u00A0T\u00A0\u00A4',
    10: '00\u00A0T\u00A0\u00A4',
    11: '000\u00A0T\u00A0\u00A4',
    12: '0\u00A0NT\u00A0\u00A4',
    13: '00\u00A0NT\u00A0\u00A4',
    14: '000\u00A0NT\u00A0\u00A4',
  }),
  // Compact number symbols for locale zh.
  "zh": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0',
    4: '0\u4E07',
    5: '00\u4E07',
    6: '000\u4E07',
    7: '0000\u4E07',
    8: '0\u4EBF',
    9: '00\u4EBF',
    10: '000\u4EBF',
    11: '0000\u4EBF',
    12: '0\u5146',
    13: '00\u5146',
    14: '000\u5146',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0',
    4: '0\u4E07',
    5: '00\u4E07',
    6: '000\u4E07',
    7: '0000\u4E07',
    8: '0\u4EBF',
    9: '00\u4EBF',
    10: '000\u4EBF',
    11: '0000\u4EBF',
    12: '0\u5146',
    13: '00\u5146',
    14: '000\u5146',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0',
    4: '\u00A40\u4E07',
    5: '\u00A400\u4E07',
    6: '\u00A4000\u4E07',
    7: '\u00A40000\u4E07',
    8: '\u00A40\u4EBF',
    9: '\u00A400\u4EBF',
    10: '\u00A4000\u4EBF',
    11: '\u00A40000\u4EBF',
    12: '\u00A40\u5146',
    13: '\u00A400\u5146',
    14: '\u00A4000\u5146',
  }),
  // Compact number symbols for locale zh_CN.
  "zh_CN": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0',
    4: '0\u4E07',
    5: '00\u4E07',
    6: '000\u4E07',
    7: '0000\u4E07',
    8: '0\u4EBF',
    9: '00\u4EBF',
    10: '000\u4EBF',
    11: '0000\u4EBF',
    12: '0\u5146',
    13: '00\u5146',
    14: '000\u5146',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0',
    4: '0\u4E07',
    5: '00\u4E07',
    6: '000\u4E07',
    7: '0000\u4E07',
    8: '0\u4EBF',
    9: '00\u4EBF',
    10: '000\u4EBF',
    11: '0000\u4EBF',
    12: '0\u5146',
    13: '00\u5146',
    14: '000\u5146',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0',
    4: '\u00A40\u4E07',
    5: '\u00A400\u4E07',
    6: '\u00A4000\u4E07',
    7: '\u00A40000\u4E07',
    8: '\u00A40\u4EBF',
    9: '\u00A400\u4EBF',
    10: '\u00A4000\u4EBF',
    11: '\u00A40000\u4EBF',
    12: '\u00A40\u5146',
    13: '\u00A400\u5146',
    14: '\u00A4000\u5146',
  }),
  // Compact number symbols for locale zh_HK.
  "zh_HK": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0K',
    4: '00K',
    5: '000K',
    6: '0M',
    7: '00M',
    8: '000M',
    9: '0B',
    10: '00B',
    11: '000B',
    12: '0T',
    13: '00T',
    14: '000T',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0',
    4: '0\u842C',
    5: '00\u842C',
    6: '000\u842C',
    7: '0000\u842C',
    8: '0\u5104',
    9: '00\u5104',
    10: '000\u5104',
    11: '0000\u5104',
    12: '0\u5146',
    13: '00\u5146',
    14: '000\u5146',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40K',
    4: '\u00A400K',
    5: '\u00A4000K',
    6: '\u00A40M',
    7: '\u00A400M',
    8: '\u00A4000M',
    9: '\u00A40B',
    10: '\u00A400B',
    11: '\u00A4000B',
    12: '\u00A40T',
    13: '\u00A400T',
    14: '\u00A4000T',
  }),
  // Compact number symbols for locale zh_TW.
  "zh_TW": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0',
    4: '0\u842C',
    5: '00\u842C',
    6: '000\u842C',
    7: '0000\u842C',
    8: '0\u5104',
    9: '00\u5104',
    10: '000\u5104',
    11: '0000\u5104',
    12: '0\u5146',
    13: '00\u5146',
    14: '000\u5146',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0',
    4: '0\u842C',
    5: '00\u842C',
    6: '000\u842C',
    7: '0000\u842C',
    8: '0\u5104',
    9: '00\u5104',
    10: '000\u5104',
    11: '0000\u5104',
    12: '0\u5146',
    13: '00\u5146',
    14: '000\u5146',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '0',
    4: '\u00A40\u842C',
    5: '\u00A400\u842C',
    6: '\u00A4000\u842C',
    7: '\u00A40000\u842C',
    8: '\u00A40\u5104',
    9: '\u00A400\u5104',
    10: '\u00A4000\u5104',
    11: '\u00A40000\u5104',
    12: '\u00A40\u5146',
    13: '\u00A400\u5146',
    14: '\u00A4000\u5146',
  }),
  // Compact number symbols for locale zu.
  "zu": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: '0K',
    4: '00K',
    5: '000K',
    6: '0M',
    7: '00M',
    8: '000M',
    9: '0B',
    10: '00B',
    11: '000B',
    12: '0T',
    13: '00T',
    14: '000T',
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: '0 inkulungwane',
    4: '00 inkulungwane',
    5: '000 inkulungwane',
    6: '0 isigidi',
    7: '00 isigidi',
    8: '000 isigidi',
    9: '0 isigidi sezigidi',
    10: '00 isigidi sezigidi',
    11: '000 isigidi sezigidi',
    12: '0 isigidintathu',
    13: '00 isigidintathu',
    14: '000 isigidintathu',
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: '\u00A40K',
    4: '\u00A400K',
    5: '\u00A4000K',
    6: '\u00A4\u00A00M',
    7: '\u00A4\u00A000M',
    8: '\u00A4000M',
    9: '\u00A40B',
    10: '\u00A400B',
    11: '\u00A4000B',
    12: '\u00A40T',
    13: '\u00A400T',
    14: '\u00A4000T',
  })
};

final currencyFractionDigits = {
  "ADP": 0,
  "AFN": 0,
  "ALL": 0,
  "AMD": 2,
  "BHD": 3,
  "BIF": 0,
  "BYN": 2,
  "BYR": 0,
  "CAD": 2,
  "CHF": 2,
  "CLF": 4,
  "CLP": 0,
  "COP": 2,
  "CRC": 2,
  "CZK": 2,
  "DEFAULT": 2,
  "DJF": 0,
  "DKK": 2,
  "ESP": 0,
  "GNF": 0,
  "GYD": 2,
  "HUF": 2,
  "IDR": 2,
  "IQD": 0,
  "IRR": 0,
  "ISK": 0,
  "ITL": 0,
  "JOD": 3,
  "JPY": 0,
  "KMF": 0,
  "KPW": 0,
  "KRW": 0,
  "KWD": 3,
  "LAK": 0,
  "LBP": 0,
  "LUF": 0,
  "LYD": 3,
  "MGA": 0,
  "MGF": 0,
  "MMK": 0,
  "MNT": 2,
  "MRO": 0,
  "MUR": 2,
  "NOK": 2,
  "OMR": 3,
  "PKR": 2,
  "PYG": 0,
  "RSD": 0,
  "RWF": 0,
  "SEK": 2,
  "SLL": 0,
  "SOS": 0,
  "STD": 0,
  "SYP": 0,
  "TMM": 0,
  "TND": 3,
  "TRL": 0,
  "TWD": 2,
  "TZS": 2,
  "UGX": 0,
  "UYI": 0,
  "UYW": 4,
  "UZS": 2,
  "VEF": 2,
  "VND": 0,
  "VUV": 0,
  "XAF": 0,
  "XOF": 0,
  "XPF": 0,
  "YER": 0,
  "ZMK": 0,
  "ZWD": 0,
};
