/**********************************************************************
 * Copyright (c) 2018 Robert Bosch GmbH.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *  SPDX-License-Identifier: Apache-2.0
 *
 *  Contributors:
 *      Robert Bosch GmbH - initial API and functionality
 **********************************************************************/
 
#ifndef __ACCESSCHECKER_H__
#define __ACCESSCHECKER_H__

#include "IAccessChecker.hpp"
#include "KuksaChannel.hpp"

class IAuthenticator;


class AccessChecker : public IAccessChecker {
 private:
  std::shared_ptr<IAuthenticator> tokenValidator;
  bool checkSignalAccess(const KuksaChannel& channel, const std::string& path, const std::string& requiredPermission);

 public:
  AccessChecker(std::shared_ptr<IAuthenticator> vdator);
  
  bool checkReadAccess(KuksaChannel &channel, const VSSPath &path) override;

  bool checkWriteAccess(KuksaChannel &channel, const VSSPath &path) override;

  bool checkPathWriteAccess(KuksaChannel &channel, const jsoncons::json &paths) override;
};

#endif
