/* vim: set ts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

/* This file is generated from sources in nss/gtests/common/wycheproof
 * automatically and should not be touched manually.
 * Generation is trigged by calling python3 genTestVectors.py */

#ifndef p521ecdsa_sha512_vectors_h__
#define p521ecdsa_sha512_vectors_h__

#include "testvectors_base/test-structs.h"

const EcdsaTestVector kP521EcdsaSha512Vectors[] = {

    // Comment: signature malleability
    // tcID: 1
    {SEC_OID_SHA512,
     1,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x42,
      0x01, 0xd7, 0x4a, 0x2f, 0x6d, 0x95, 0xbe, 0x8d, 0x4c, 0xb6, 0x4f, 0x02,
      0xd1, 0x6d, 0x6b, 0x78, 0x5a, 0x12, 0x46, 0xb4, 0xeb, 0xd2, 0x06, 0xdc,
      0x59, 0x68, 0x18, 0xbb, 0x95, 0x32, 0x53, 0x24, 0x5f, 0x5a, 0x27, 0xa2,
      0x4a, 0x1a, 0xae, 0x1e, 0x21, 0x8f, 0xdc, 0xcd, 0x8c, 0xd7, 0xd4, 0x99,
      0x0b, 0x66, 0x6d, 0x4b, 0xf4, 0x90, 0x2b, 0x84, 0xfd, 0xad, 0x12, 0x3f,
      0x94, 0x1f, 0xe9, 0x06, 0xd9, 0x48},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: valid
    // tcID: 2
    {SEC_OID_SHA512,
     2,
     {0x30, 0x81, 0x86, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: length of sequence contains leading 0
    // tcID: 3
    {SEC_OID_SHA512,
     3,
     {0x30, 0x82, 0x00, 0x86, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8,
      0xcb, 0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8,
      0x2c, 0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7,
      0x5f, 0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04,
      0xf6, 0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20,
      0xb0, 0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02,
      0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd,
      0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23,
      0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4,
      0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70,
      0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30,
      0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: wrong length of sequence
    // tcID: 4
    {SEC_OID_SHA512,
     4,
     {0x30, 0x87, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb, 0x89,
      0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c, 0x7a,
      0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f, 0xfb,
      0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6, 0x6f,
      0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0, 0xec,
      0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41, 0x28,
      0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92,
      0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97,
      0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69,
      0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a, 0x69,
      0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe,
      0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: wrong length of sequence
    // tcID: 5
    {SEC_OID_SHA512,
     5,
     {0x30, 0x85, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb, 0x89,
      0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c, 0x7a,
      0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f, 0xfb,
      0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6, 0x6f,
      0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0, 0xec,
      0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41, 0x28,
      0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92,
      0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97,
      0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69,
      0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a, 0x69,
      0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe,
      0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: uint32 overflow in length of sequence
    // tcID: 6
    {SEC_OID_SHA512,
     6,
     {0x30, 0x85, 0x01, 0x00, 0x00, 0x00, 0x86, 0x02, 0x41, 0x4e, 0x42, 0x23,
      0xee, 0x43, 0xe8, 0xcb, 0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79,
      0xe5, 0x82, 0xf8, 0x2c, 0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe,
      0x37, 0x4a, 0xc7, 0x5f, 0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75,
      0x0b, 0x9a, 0x04, 0xf6, 0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd,
      0x51, 0x57, 0x20, 0xb0, 0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf,
      0x86, 0x45, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3,
      0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14,
      0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0,
      0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74,
      0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a,
      0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: uint64 overflow in length of sequence
    // tcID: 7
    {SEC_OID_SHA512,
     7,
     {0x30, 0x89, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0x02,
      0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb, 0x89, 0xde, 0x3b, 0x13,
      0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c, 0x7a, 0xb0, 0xf7, 0x1b,
      0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f, 0xfb, 0xef, 0x29, 0xac,
      0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6, 0x6f, 0xda, 0x48, 0x35,
      0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0, 0xec, 0x5c, 0xd7, 0x36,
      0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92,
      0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5,
      0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a,
      0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74,
      0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5,
      0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a,
      0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of sequence = 2**31 - 1
    // tcID: 8
    {SEC_OID_SHA512,
     8,
     {0x30, 0x84, 0x7f, 0xff, 0xff, 0xff, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee,
      0x43, 0xe8, 0xcb, 0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5,
      0x82, 0xf8, 0x2c, 0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37,
      0x4a, 0xc7, 0x5f, 0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b,
      0x9a, 0x04, 0xf6, 0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51,
      0x57, 0x20, 0xb0, 0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86,
      0x45, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49,
      0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d,
      0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0,
      0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71,
      0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01,
      0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of sequence = 2**32 - 1
    // tcID: 9
    {SEC_OID_SHA512,
     9,
     {0x30, 0x84, 0xff, 0xff, 0xff, 0xff, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee,
      0x43, 0xe8, 0xcb, 0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5,
      0x82, 0xf8, 0x2c, 0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37,
      0x4a, 0xc7, 0x5f, 0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b,
      0x9a, 0x04, 0xf6, 0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51,
      0x57, 0x20, 0xb0, 0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86,
      0x45, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49,
      0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d,
      0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0,
      0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71,
      0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01,
      0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of sequence = 2**40 - 1
    // tcID: 10
    {SEC_OID_SHA512,
     10,
     {0x30, 0x85, 0xff, 0xff, 0xff, 0xff, 0xff, 0x02, 0x41, 0x4e, 0x42, 0x23,
      0xee, 0x43, 0xe8, 0xcb, 0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79,
      0xe5, 0x82, 0xf8, 0x2c, 0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe,
      0x37, 0x4a, 0xc7, 0x5f, 0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75,
      0x0b, 0x9a, 0x04, 0xf6, 0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd,
      0x51, 0x57, 0x20, 0xb0, 0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf,
      0x86, 0x45, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3,
      0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14,
      0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0,
      0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74,
      0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a,
      0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of sequence = 2**64 - 1
    // tcID: 11
    {SEC_OID_SHA512,
     11,
     {0x30, 0x88, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x02, 0x41,
      0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb, 0x89, 0xde, 0x3b, 0x13, 0x39,
      0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c, 0x7a, 0xb0, 0xf7, 0x1b, 0xbd,
      0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f, 0xfb, 0xef, 0x29, 0xac, 0xdf,
      0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6, 0x6f, 0xda, 0x48, 0x35, 0x1d,
      0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0, 0xec, 0x5c, 0xd7, 0x36, 0xf9,
      0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a,
      0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed,
      0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd,
      0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb,
      0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28,
      0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: incorrect length of sequence
    // tcID: 12
    {SEC_OID_SHA512,
     12,
     {0x30, 0xff, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb, 0x89,
      0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c, 0x7a,
      0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f, 0xfb,
      0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6, 0x6f,
      0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0, 0xec,
      0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41, 0x28,
      0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92,
      0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97,
      0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69,
      0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a, 0x69,
      0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe,
      0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length without termination
    // tcID: 13
    {SEC_OID_SHA512,
     13,
     {0x30, 0x80, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb, 0x89,
      0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c, 0x7a,
      0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f, 0xfb,
      0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6, 0x6f,
      0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0, 0xec,
      0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41, 0x28,
      0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92,
      0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97,
      0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69,
      0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a, 0x69,
      0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe,
      0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length without termination
    // tcID: 14
    {SEC_OID_SHA512,
     14,
     {0x30, 0x81, 0x86, 0x02, 0x80, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length without termination
    // tcID: 15
    {SEC_OID_SHA512,
     15,
     {0x30, 0x81, 0x86, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x80,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: removing sequence
    // tcID: 16
    {SEC_OID_SHA512,
     16,
     {},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: lonely sequence tag
    // tcID: 17
    {SEC_OID_SHA512,
     17,
     {0x30},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending 0's to sequence
    // tcID: 18
    {SEC_OID_SHA512,
     18,
     {0x30, 0x81, 0x88, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1, 0x00, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: prepending 0's to sequence
    // tcID: 19
    {SEC_OID_SHA512,
     19,
     {0x30, 0x81, 0x88, 0x00, 0x00, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43,
      0xe8, 0xcb, 0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82,
      0xf8, 0x2c, 0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a,
      0xc7, 0x5f, 0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a,
      0x04, 0xf6, 0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57,
      0x20, 0xb0, 0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45,
      0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0,
      0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9,
      0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29,
      0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22,
      0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9,
      0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending unused 0's to sequence
    // tcID: 20
    {SEC_OID_SHA512,
     20,
     {0x30, 0x81, 0x86, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1, 0x00, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending null value to sequence
    // tcID: 21
    {SEC_OID_SHA512,
     21,
     {0x30, 0x81, 0x88, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1, 0x05, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 22
    {SEC_OID_SHA512,
     22,
     {0x30, 0x81, 0x8c, 0x49, 0x81, 0x77, 0x30, 0x81, 0x86, 0x02, 0x41, 0x4e,
      0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb, 0x89, 0xde, 0x3b, 0x13, 0x39, 0xff,
      0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c, 0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4,
      0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f, 0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e,
      0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6, 0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7,
      0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0, 0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7,
      0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41,
      0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9,
      0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac,
      0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2,
      0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e,
      0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 23
    {SEC_OID_SHA512,
     23,
     {0x30, 0x81, 0x8b, 0x25, 0x00, 0x30, 0x81, 0x86, 0x02, 0x41, 0x4e, 0x42,
      0x23, 0xee, 0x43, 0xe8, 0xcb, 0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2,
      0x79, 0xe5, 0x82, 0xf8, 0x2c, 0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d,
      0xbe, 0x37, 0x4a, 0xc7, 0x5f, 0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70,
      0x75, 0x0b, 0x9a, 0x04, 0xf6, 0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb,
      0xfd, 0x51, 0x57, 0x20, 0xb0, 0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b,
      0xdf, 0x86, 0x45, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72,
      0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b,
      0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb,
      0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe,
      0x74, 0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17,
      0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 24
    {SEC_OID_SHA512,
     24,
     {0x30, 0x81, 0x89, 0x30, 0x81, 0x86, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee,
      0x43, 0xe8, 0xcb, 0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5,
      0x82, 0xf8, 0x2c, 0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37,
      0x4a, 0xc7, 0x5f, 0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b,
      0x9a, 0x04, 0xf6, 0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51,
      0x57, 0x20, 0xb0, 0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86,
      0x45, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49,
      0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d,
      0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0,
      0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71,
      0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01,
      0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1, 0x00, 0x04, 0xde, 0xad,
      0xbe, 0xef},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 25
    {SEC_OID_SHA512,
     25,
     {0x30, 0x81, 0x8b, 0x22, 0x46, 0x49, 0x81, 0x77, 0x02, 0x41, 0x4e, 0x42,
      0x23, 0xee, 0x43, 0xe8, 0xcb, 0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2,
      0x79, 0xe5, 0x82, 0xf8, 0x2c, 0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d,
      0xbe, 0x37, 0x4a, 0xc7, 0x5f, 0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70,
      0x75, 0x0b, 0x9a, 0x04, 0xf6, 0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb,
      0xfd, 0x51, 0x57, 0x20, 0xb0, 0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b,
      0xdf, 0x86, 0x45, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72,
      0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b,
      0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb,
      0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe,
      0x74, 0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17,
      0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 26
    {SEC_OID_SHA512,
     26,
     {0x30, 0x81, 0x8a, 0x22, 0x45, 0x25, 0x00, 0x02, 0x41, 0x4e, 0x42, 0x23,
      0xee, 0x43, 0xe8, 0xcb, 0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79,
      0xe5, 0x82, 0xf8, 0x2c, 0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe,
      0x37, 0x4a, 0xc7, 0x5f, 0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75,
      0x0b, 0x9a, 0x04, 0xf6, 0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd,
      0x51, 0x57, 0x20, 0xb0, 0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf,
      0x86, 0x45, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3,
      0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14,
      0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0,
      0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74,
      0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a,
      0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 27
    {SEC_OID_SHA512,
     27,
     {0x30, 0x81, 0x8e, 0x22, 0x43, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43,
      0xe8, 0xcb, 0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82,
      0xf8, 0x2c, 0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a,
      0xc7, 0x5f, 0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a,
      0x04, 0xf6, 0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57,
      0x20, 0xb0, 0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45,
      0x00, 0x04, 0xde, 0xad, 0xbe, 0xef, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92,
      0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5,
      0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a,
      0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74,
      0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5,
      0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a,
      0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 28
    {SEC_OID_SHA512,
     28,
     {0x30, 0x81, 0x8b, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x22, 0x46,
      0x49, 0x81, 0x77, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72,
      0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b,
      0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb,
      0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe,
      0x74, 0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17,
      0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 29
    {SEC_OID_SHA512,
     29,
     {0x30, 0x81, 0x8a, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x22, 0x45,
      0x25, 0x00, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3,
      0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14,
      0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0,
      0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74,
      0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a,
      0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 30
    {SEC_OID_SHA512,
     30,
     {0x30, 0x81, 0x8e, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x22, 0x43,
      0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0,
      0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9,
      0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29,
      0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22,
      0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9,
      0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1, 0x00, 0x04, 0xde, 0xad, 0xbe,
      0xef},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including undefined tags
    // tcID: 31
    {SEC_OID_SHA512,
     31,
     {0x30, 0x81, 0x8f, 0xaa, 0x00, 0xbb, 0x00, 0xcd, 0x00, 0x30, 0x81, 0x86,
      0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb, 0x89, 0xde, 0x3b,
      0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c, 0x7a, 0xb0, 0xf7,
      0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f, 0xfb, 0xef, 0x29,
      0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6, 0x6f, 0xda, 0x48,
      0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0, 0xec, 0x5c, 0xd7,
      0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41, 0x28, 0xb5, 0xd0,
      0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87,
      0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44,
      0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11,
      0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69,
      0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31,
      0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including undefined tags
    // tcID: 32
    {SEC_OID_SHA512,
     32,
     {0x30, 0x81, 0x8d, 0xaa, 0x02, 0xaa, 0xbb, 0x30, 0x81, 0x86, 0x02, 0x41,
      0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb, 0x89, 0xde, 0x3b, 0x13, 0x39,
      0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c, 0x7a, 0xb0, 0xf7, 0x1b, 0xbd,
      0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f, 0xfb, 0xef, 0x29, 0xac, 0xdf,
      0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6, 0x6f, 0xda, 0x48, 0x35, 0x1d,
      0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0, 0xec, 0x5c, 0xd7, 0x36, 0xf9,
      0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a,
      0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed,
      0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd,
      0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb,
      0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28,
      0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including undefined tags
    // tcID: 33
    {SEC_OID_SHA512,
     33,
     {0x30, 0x81, 0x8e, 0x22, 0x49, 0xaa, 0x00, 0xbb, 0x00, 0xcd, 0x00, 0x02,
      0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb, 0x89, 0xde, 0x3b, 0x13,
      0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c, 0x7a, 0xb0, 0xf7, 0x1b,
      0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f, 0xfb, 0xef, 0x29, 0xac,
      0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6, 0x6f, 0xda, 0x48, 0x35,
      0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0, 0xec, 0x5c, 0xd7, 0x36,
      0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92,
      0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5,
      0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a,
      0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74,
      0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5,
      0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a,
      0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including undefined tags
    // tcID: 34
    {SEC_OID_SHA512,
     34,
     {0x30, 0x81, 0x8c, 0x22, 0x47, 0xaa, 0x02, 0xaa, 0xbb, 0x02, 0x41, 0x4e,
      0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb, 0x89, 0xde, 0x3b, 0x13, 0x39, 0xff,
      0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c, 0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4,
      0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f, 0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e,
      0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6, 0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7,
      0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0, 0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7,
      0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41,
      0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9,
      0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac,
      0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2,
      0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e,
      0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including undefined tags
    // tcID: 35
    {SEC_OID_SHA512,
     35,
     {0x30, 0x81, 0x8e, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x22, 0x49,
      0xaa, 0x00, 0xbb, 0x00, 0xcd, 0x00, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92,
      0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5,
      0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a,
      0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74,
      0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5,
      0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a,
      0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including undefined tags
    // tcID: 36
    {SEC_OID_SHA512,
     36,
     {0x30, 0x81, 0x8c, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x22, 0x47,
      0xaa, 0x02, 0xaa, 0xbb, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41,
      0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9,
      0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac,
      0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2,
      0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e,
      0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated length of sequence
    // tcID: 37
    {SEC_OID_SHA512,
     37,
     {0x30, 0x81},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition with indefinite length
    // tcID: 38
    {SEC_OID_SHA512,
     38,
     {0x30, 0x80, 0x30, 0x81, 0x86, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43,
      0xe8, 0xcb, 0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82,
      0xf8, 0x2c, 0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a,
      0xc7, 0x5f, 0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a,
      0x04, 0xf6, 0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57,
      0x20, 0xb0, 0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45,
      0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0,
      0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9,
      0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29,
      0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22,
      0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9,
      0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1, 0x00, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition with indefinite length
    // tcID: 39
    {SEC_OID_SHA512,
     39,
     {0x30, 0x81, 0x8a, 0x22, 0x80, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43,
      0xe8, 0xcb, 0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82,
      0xf8, 0x2c, 0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a,
      0xc7, 0x5f, 0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a,
      0x04, 0xf6, 0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57,
      0x20, 0xb0, 0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45,
      0x00, 0x00, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3,
      0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14,
      0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0,
      0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74,
      0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a,
      0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition with indefinite length
    // tcID: 40
    {SEC_OID_SHA512,
     40,
     {0x30, 0x81, 0x8a, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x22, 0x80,
      0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0,
      0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9,
      0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29,
      0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22,
      0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9,
      0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1, 0x00, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition with wrong tag
    // tcID: 41
    {SEC_OID_SHA512,
     41,
     {0x30, 0x80, 0x31, 0x81, 0x86, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43,
      0xe8, 0xcb, 0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82,
      0xf8, 0x2c, 0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a,
      0xc7, 0x5f, 0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a,
      0x04, 0xf6, 0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57,
      0x20, 0xb0, 0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45,
      0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0,
      0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9,
      0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29,
      0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22,
      0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9,
      0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1, 0x00, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition with wrong tag
    // tcID: 42
    {SEC_OID_SHA512,
     42,
     {0x30, 0x81, 0x8a, 0x22, 0x80, 0x03, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43,
      0xe8, 0xcb, 0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82,
      0xf8, 0x2c, 0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a,
      0xc7, 0x5f, 0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a,
      0x04, 0xf6, 0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57,
      0x20, 0xb0, 0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45,
      0x00, 0x00, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3,
      0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14,
      0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0,
      0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74,
      0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a,
      0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition with wrong tag
    // tcID: 43
    {SEC_OID_SHA512,
     43,
     {0x30, 0x81, 0x8a, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x22, 0x80,
      0x03, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0,
      0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9,
      0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29,
      0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22,
      0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9,
      0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1, 0x00, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Replacing sequence with NULL
    // tcID: 44
    {SEC_OID_SHA512,
     44,
     {0x05, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of sequence
    // tcID: 45
    {SEC_OID_SHA512,
     45,
     {0x2e, 0x81, 0x86, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of sequence
    // tcID: 46
    {SEC_OID_SHA512,
     46,
     {0x2f, 0x81, 0x86, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of sequence
    // tcID: 47
    {SEC_OID_SHA512,
     47,
     {0x31, 0x81, 0x86, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of sequence
    // tcID: 48
    {SEC_OID_SHA512,
     48,
     {0x32, 0x81, 0x86, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of sequence
    // tcID: 49
    {SEC_OID_SHA512,
     49,
     {0xff, 0x81, 0x86, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: dropping value of sequence
    // tcID: 50
    {SEC_OID_SHA512,
     50,
     {0x30, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition for sequence
    // tcID: 51
    {SEC_OID_SHA512,
     51,
     {0x30, 0x81, 0x8b, 0x30, 0x01, 0x02, 0x30, 0x81, 0x85, 0x41, 0x4e, 0x42,
      0x23, 0xee, 0x43, 0xe8, 0xcb, 0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2,
      0x79, 0xe5, 0x82, 0xf8, 0x2c, 0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d,
      0xbe, 0x37, 0x4a, 0xc7, 0x5f, 0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70,
      0x75, 0x0b, 0x9a, 0x04, 0xf6, 0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb,
      0xfd, 0x51, 0x57, 0x20, 0xb0, 0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b,
      0xdf, 0x86, 0x45, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72,
      0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b,
      0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb,
      0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe,
      0x74, 0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17,
      0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated sequence
    // tcID: 52
    {SEC_OID_SHA512,
     52,
     {0x30, 0x81, 0x85, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated sequence
    // tcID: 53
    {SEC_OID_SHA512,
     53,
     {0x30, 0x81, 0x85, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb, 0x89,
      0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c, 0x7a,
      0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f, 0xfb,
      0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6, 0x6f,
      0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0, 0xec,
      0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41, 0x28,
      0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92,
      0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97,
      0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69,
      0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a, 0x69,
      0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe,
      0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length
    // tcID: 54
    {SEC_OID_SHA512,
     54,
     {0x30, 0x80, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb, 0x89,
      0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c, 0x7a,
      0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f, 0xfb,
      0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6, 0x6f,
      0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0, 0xec,
      0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41, 0x28,
      0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92,
      0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97,
      0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69,
      0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a, 0x69,
      0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe,
      0xa8, 0x31, 0x8a, 0xc1, 0x00, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length with truncated delimiter
    // tcID: 55
    {SEC_OID_SHA512,
     55,
     {0x30, 0x80, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb, 0x89,
      0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c, 0x7a,
      0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f, 0xfb,
      0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6, 0x6f,
      0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0, 0xec,
      0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41, 0x28,
      0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92,
      0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97,
      0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69,
      0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a, 0x69,
      0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe,
      0xa8, 0x31, 0x8a, 0xc1, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length with additional element
    // tcID: 56
    {SEC_OID_SHA512,
     56,
     {0x30, 0x80, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb, 0x89,
      0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c, 0x7a,
      0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f, 0xfb,
      0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6, 0x6f,
      0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0, 0xec,
      0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41, 0x28,
      0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92,
      0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97,
      0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69,
      0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a, 0x69,
      0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe,
      0xa8, 0x31, 0x8a, 0xc1, 0x05, 0x00, 0x00, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length with truncated element
    // tcID: 57
    {SEC_OID_SHA512,
     57,
     {0x30, 0x80, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb, 0x89,
      0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c, 0x7a,
      0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f, 0xfb,
      0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6, 0x6f,
      0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0, 0xec,
      0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41, 0x28,
      0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92,
      0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97,
      0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69,
      0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a, 0x69,
      0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe,
      0xa8, 0x31, 0x8a, 0xc1, 0x06, 0x08, 0x11, 0x22, 0x00, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length with garbage
    // tcID: 58
    {SEC_OID_SHA512,
     58,
     {0x30, 0x80, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb, 0x89,
      0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c, 0x7a,
      0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f, 0xfb,
      0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6, 0x6f,
      0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0, 0xec,
      0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41, 0x28,
      0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92,
      0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97,
      0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69,
      0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a, 0x69,
      0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe,
      0xa8, 0x31, 0x8a, 0xc1, 0x00, 0x00, 0xfe, 0x02, 0xbe, 0xef},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length with nonempty EOC
    // tcID: 59
    {SEC_OID_SHA512,
     59,
     {0x30, 0x80, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb, 0x89,
      0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c, 0x7a,
      0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f, 0xfb,
      0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6, 0x6f,
      0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0, 0xec,
      0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41, 0x28,
      0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92,
      0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97,
      0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69,
      0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a, 0x69,
      0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe,
      0xa8, 0x31, 0x8a, 0xc1, 0x00, 0x02, 0xbe, 0xef},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: prepend empty sequence
    // tcID: 60
    {SEC_OID_SHA512,
     60,
     {0x30, 0x81, 0x88, 0x30, 0x00, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43,
      0xe8, 0xcb, 0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82,
      0xf8, 0x2c, 0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a,
      0xc7, 0x5f, 0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a,
      0x04, 0xf6, 0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57,
      0x20, 0xb0, 0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45,
      0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0,
      0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9,
      0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29,
      0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22,
      0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9,
      0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: append empty sequence
    // tcID: 61
    {SEC_OID_SHA512,
     61,
     {0x30, 0x81, 0x88, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1, 0x30, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: append garbage with high tag number
    // tcID: 62
    {SEC_OID_SHA512,
     62,
     {0x30, 0x81, 0x89, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1, 0xbf, 0x7f, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: sequence of sequence
    // tcID: 63
    {SEC_OID_SHA512,
     63,
     {0x30, 0x81, 0x89, 0x30, 0x81, 0x86, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee,
      0x43, 0xe8, 0xcb, 0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5,
      0x82, 0xf8, 0x2c, 0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37,
      0x4a, 0xc7, 0x5f, 0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b,
      0x9a, 0x04, 0xf6, 0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51,
      0x57, 0x20, 0xb0, 0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86,
      0x45, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49,
      0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d,
      0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0,
      0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71,
      0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01,
      0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated sequence: removed last 1 elements
    // tcID: 64
    {SEC_OID_SHA512,
     64,
     {0x30, 0x43, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb, 0x89,
      0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c, 0x7a,
      0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f, 0xfb,
      0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6, 0x6f,
      0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0, 0xec,
      0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: repeating element in sequence
    // tcID: 65
    {SEC_OID_SHA512,
     65,
     {0x30, 0x81, 0xc9, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a,
      0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed,
      0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd,
      0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb,
      0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28,
      0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: long form encoding of length of integer
    // tcID: 66
    {SEC_OID_SHA512,
     66,
     {0x30, 0x81, 0x87, 0x02, 0x81, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8,
      0xcb, 0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8,
      0x2c, 0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7,
      0x5f, 0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04,
      0xf6, 0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20,
      0xb0, 0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02,
      0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd,
      0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23,
      0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4,
      0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70,
      0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30,
      0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: long form encoding of length of integer
    // tcID: 67
    {SEC_OID_SHA512,
     67,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x81,
      0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd,
      0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23,
      0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4,
      0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70,
      0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30,
      0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer contains leading 0
    // tcID: 68
    {SEC_OID_SHA512,
     68,
     {0x30, 0x81, 0x88, 0x02, 0x82, 0x00, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43,
      0xe8, 0xcb, 0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82,
      0xf8, 0x2c, 0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a,
      0xc7, 0x5f, 0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a,
      0x04, 0xf6, 0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57,
      0x20, 0xb0, 0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45,
      0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0,
      0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9,
      0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29,
      0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22,
      0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9,
      0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer contains leading 0
    // tcID: 69
    {SEC_OID_SHA512,
     69,
     {0x30, 0x81, 0x88, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x82,
      0x00, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0,
      0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9,
      0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29,
      0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22,
      0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9,
      0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: wrong length of integer
    // tcID: 70
    {SEC_OID_SHA512,
     70,
     {0x30, 0x81, 0x86, 0x02, 0x42, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: wrong length of integer
    // tcID: 71
    {SEC_OID_SHA512,
     71,
     {0x30, 0x81, 0x86, 0x02, 0x40, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: wrong length of integer
    // tcID: 72
    {SEC_OID_SHA512,
     72,
     {0x30, 0x81, 0x86, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x42,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: wrong length of integer
    // tcID: 73
    {SEC_OID_SHA512,
     73,
     {0x30, 0x81, 0x86, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x40,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: uint32 overflow in length of integer
    // tcID: 74
    {SEC_OID_SHA512,
     74,
     {0x30, 0x81, 0x8b, 0x02, 0x85, 0x01, 0x00, 0x00, 0x00, 0x41, 0x4e, 0x42,
      0x23, 0xee, 0x43, 0xe8, 0xcb, 0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2,
      0x79, 0xe5, 0x82, 0xf8, 0x2c, 0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d,
      0xbe, 0x37, 0x4a, 0xc7, 0x5f, 0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70,
      0x75, 0x0b, 0x9a, 0x04, 0xf6, 0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb,
      0xfd, 0x51, 0x57, 0x20, 0xb0, 0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b,
      0xdf, 0x86, 0x45, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72,
      0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b,
      0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb,
      0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe,
      0x74, 0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17,
      0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: uint32 overflow in length of integer
    // tcID: 75
    {SEC_OID_SHA512,
     75,
     {0x30, 0x81, 0x8b, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x85,
      0x01, 0x00, 0x00, 0x00, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72,
      0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b,
      0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb,
      0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe,
      0x74, 0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17,
      0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: uint64 overflow in length of integer
    // tcID: 76
    {SEC_OID_SHA512,
     76,
     {0x30, 0x81, 0x8f, 0x02, 0x89, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb, 0x89, 0xde, 0x3b,
      0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c, 0x7a, 0xb0, 0xf7,
      0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f, 0xfb, 0xef, 0x29,
      0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6, 0x6f, 0xda, 0x48,
      0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0, 0xec, 0x5c, 0xd7,
      0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41, 0x28, 0xb5, 0xd0,
      0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87,
      0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44,
      0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11,
      0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69,
      0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31,
      0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: uint64 overflow in length of integer
    // tcID: 77
    {SEC_OID_SHA512,
     77,
     {0x30, 0x81, 0x8f, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x89,
      0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x28, 0xb5, 0xd0,
      0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87,
      0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44,
      0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11,
      0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69,
      0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31,
      0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer = 2**31 - 1
    // tcID: 78
    {SEC_OID_SHA512,
     78,
     {0x30, 0x81, 0x8a, 0x02, 0x84, 0x7f, 0xff, 0xff, 0xff, 0x4e, 0x42, 0x23,
      0xee, 0x43, 0xe8, 0xcb, 0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79,
      0xe5, 0x82, 0xf8, 0x2c, 0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe,
      0x37, 0x4a, 0xc7, 0x5f, 0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75,
      0x0b, 0x9a, 0x04, 0xf6, 0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd,
      0x51, 0x57, 0x20, 0xb0, 0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf,
      0x86, 0x45, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3,
      0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14,
      0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0,
      0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74,
      0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a,
      0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer = 2**31 - 1
    // tcID: 79
    {SEC_OID_SHA512,
     79,
     {0x30, 0x81, 0x8a, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x84,
      0x7f, 0xff, 0xff, 0xff, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3,
      0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14,
      0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0,
      0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74,
      0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a,
      0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer = 2**32 - 1
    // tcID: 80
    {SEC_OID_SHA512,
     80,
     {0x30, 0x81, 0x8a, 0x02, 0x84, 0xff, 0xff, 0xff, 0xff, 0x4e, 0x42, 0x23,
      0xee, 0x43, 0xe8, 0xcb, 0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79,
      0xe5, 0x82, 0xf8, 0x2c, 0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe,
      0x37, 0x4a, 0xc7, 0x5f, 0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75,
      0x0b, 0x9a, 0x04, 0xf6, 0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd,
      0x51, 0x57, 0x20, 0xb0, 0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf,
      0x86, 0x45, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3,
      0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14,
      0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0,
      0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74,
      0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a,
      0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer = 2**32 - 1
    // tcID: 81
    {SEC_OID_SHA512,
     81,
     {0x30, 0x81, 0x8a, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x84,
      0xff, 0xff, 0xff, 0xff, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3,
      0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14,
      0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0,
      0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74,
      0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a,
      0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer = 2**40 - 1
    // tcID: 82
    {SEC_OID_SHA512,
     82,
     {0x30, 0x81, 0x8b, 0x02, 0x85, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4e, 0x42,
      0x23, 0xee, 0x43, 0xe8, 0xcb, 0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2,
      0x79, 0xe5, 0x82, 0xf8, 0x2c, 0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d,
      0xbe, 0x37, 0x4a, 0xc7, 0x5f, 0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70,
      0x75, 0x0b, 0x9a, 0x04, 0xf6, 0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb,
      0xfd, 0x51, 0x57, 0x20, 0xb0, 0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b,
      0xdf, 0x86, 0x45, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72,
      0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b,
      0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb,
      0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe,
      0x74, 0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17,
      0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer = 2**40 - 1
    // tcID: 83
    {SEC_OID_SHA512,
     83,
     {0x30, 0x81, 0x8b, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x85,
      0xff, 0xff, 0xff, 0xff, 0xff, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72,
      0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b,
      0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb,
      0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe,
      0x74, 0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17,
      0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer = 2**64 - 1
    // tcID: 84
    {SEC_OID_SHA512,
     84,
     {0x30, 0x81, 0x8e, 0x02, 0x88, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb, 0x89, 0xde, 0x3b, 0x13,
      0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c, 0x7a, 0xb0, 0xf7, 0x1b,
      0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f, 0xfb, 0xef, 0x29, 0xac,
      0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6, 0x6f, 0xda, 0x48, 0x35,
      0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0, 0xec, 0x5c, 0xd7, 0x36,
      0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92,
      0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5,
      0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a,
      0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74,
      0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5,
      0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a,
      0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer = 2**64 - 1
    // tcID: 85
    {SEC_OID_SHA512,
     85,
     {0x30, 0x81, 0x8e, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x88,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x28, 0xb5, 0xd0, 0x92,
      0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5,
      0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a,
      0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74,
      0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5,
      0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a,
      0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: incorrect length of integer
    // tcID: 86
    {SEC_OID_SHA512,
     86,
     {0x30, 0x81, 0x86, 0x02, 0xff, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: incorrect length of integer
    // tcID: 87
    {SEC_OID_SHA512,
     87,
     {0x30, 0x81, 0x86, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0xff,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: removing integer
    // tcID: 88
    {SEC_OID_SHA512,
     88,
     {0x30, 0x43, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3,
      0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14,
      0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0,
      0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74,
      0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a,
      0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: lonely integer tag
    // tcID: 89
    {SEC_OID_SHA512,
     89,
     {0x30, 0x44, 0x02, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72,
      0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b,
      0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb,
      0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe,
      0x74, 0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17,
      0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: lonely integer tag
    // tcID: 90
    {SEC_OID_SHA512,
     90,
     {0x30, 0x44, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb, 0x89,
      0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c, 0x7a,
      0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f, 0xfb,
      0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6, 0x6f,
      0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0, 0xec,
      0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending 0's to integer
    // tcID: 91
    {SEC_OID_SHA512,
     91,
     {0x30, 0x81, 0x88, 0x02, 0x43, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x00, 0x00,
      0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0,
      0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9,
      0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29,
      0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22,
      0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9,
      0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending 0's to integer
    // tcID: 92
    {SEC_OID_SHA512,
     92,
     {0x30, 0x81, 0x88, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x43,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1, 0x00, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: prepending 0's to integer
    // tcID: 93
    {SEC_OID_SHA512,
     93,
     {0x30, 0x81, 0x88, 0x02, 0x43, 0x00, 0x00, 0x4e, 0x42, 0x23, 0xee, 0x43,
      0xe8, 0xcb, 0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82,
      0xf8, 0x2c, 0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a,
      0xc7, 0x5f, 0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a,
      0x04, 0xf6, 0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57,
      0x20, 0xb0, 0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45,
      0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0,
      0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9,
      0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29,
      0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22,
      0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9,
      0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: prepending 0's to integer
    // tcID: 94
    {SEC_OID_SHA512,
     94,
     {0x30, 0x81, 0x88, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x43,
      0x00, 0x00, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0,
      0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9,
      0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29,
      0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22,
      0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9,
      0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending unused 0's to integer
    // tcID: 95
    {SEC_OID_SHA512,
     95,
     {0x30, 0x81, 0x88, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x00, 0x00,
      0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0,
      0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9,
      0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29,
      0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22,
      0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9,
      0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending null value to integer
    // tcID: 96
    {SEC_OID_SHA512,
     96,
     {0x30, 0x81, 0x88, 0x02, 0x43, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x05, 0x00,
      0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0,
      0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9,
      0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29,
      0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22,
      0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9,
      0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending null value to integer
    // tcID: 97
    {SEC_OID_SHA512,
     97,
     {0x30, 0x81, 0x88, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x43,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1, 0x05, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated length of integer
    // tcID: 98
    {SEC_OID_SHA512,
     98,
     {0x30, 0x45, 0x02, 0x81, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41,
      0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9,
      0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac,
      0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2,
      0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e,
      0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated length of integer
    // tcID: 99
    {SEC_OID_SHA512,
     99,
     {0x30, 0x45, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb, 0x89,
      0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c, 0x7a,
      0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f, 0xfb,
      0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6, 0x6f,
      0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0, 0xec,
      0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x81},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Replacing integer with NULL
    // tcID: 100
    {SEC_OID_SHA512,
     100,
     {0x30, 0x45, 0x05, 0x00, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41,
      0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9,
      0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac,
      0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2,
      0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e,
      0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Replacing integer with NULL
    // tcID: 101
    {SEC_OID_SHA512,
     101,
     {0x30, 0x45, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb, 0x89,
      0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c, 0x7a,
      0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f, 0xfb,
      0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6, 0x6f,
      0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0, 0xec,
      0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x05, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 102
    {SEC_OID_SHA512,
     102,
     {0x30, 0x81, 0x86, 0x00, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 103
    {SEC_OID_SHA512,
     103,
     {0x30, 0x81, 0x86, 0x01, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 104
    {SEC_OID_SHA512,
     104,
     {0x30, 0x81, 0x86, 0x03, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 105
    {SEC_OID_SHA512,
     105,
     {0x30, 0x81, 0x86, 0x04, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 106
    {SEC_OID_SHA512,
     106,
     {0x30, 0x81, 0x86, 0xff, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 107
    {SEC_OID_SHA512,
     107,
     {0x30, 0x81, 0x86, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x00, 0x41,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 108
    {SEC_OID_SHA512,
     108,
     {0x30, 0x81, 0x86, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x01, 0x41,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 109
    {SEC_OID_SHA512,
     109,
     {0x30, 0x81, 0x86, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x03, 0x41,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 110
    {SEC_OID_SHA512,
     110,
     {0x30, 0x81, 0x86, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x04, 0x41,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 111
    {SEC_OID_SHA512,
     111,
     {0x30, 0x81, 0x86, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0xff, 0x41,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: dropping value of integer
    // tcID: 112
    {SEC_OID_SHA512,
     112,
     {0x30, 0x45, 0x02, 0x00, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41,
      0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9,
      0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac,
      0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2,
      0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e,
      0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: dropping value of integer
    // tcID: 113
    {SEC_OID_SHA512,
     113,
     {0x30, 0x45, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb, 0x89,
      0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c, 0x7a,
      0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f, 0xfb,
      0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6, 0x6f,
      0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0, 0xec,
      0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition for integer
    // tcID: 114
    {SEC_OID_SHA512,
     114,
     {0x30, 0x81, 0x8a, 0x22, 0x45, 0x02, 0x01, 0x4e, 0x02, 0x40, 0x42, 0x23,
      0xee, 0x43, 0xe8, 0xcb, 0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79,
      0xe5, 0x82, 0xf8, 0x2c, 0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe,
      0x37, 0x4a, 0xc7, 0x5f, 0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75,
      0x0b, 0x9a, 0x04, 0xf6, 0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd,
      0x51, 0x57, 0x20, 0xb0, 0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf,
      0x86, 0x45, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3,
      0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14,
      0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0,
      0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74,
      0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a,
      0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition for integer
    // tcID: 115
    {SEC_OID_SHA512,
     115,
     {0x30, 0x81, 0x8a, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x22, 0x45,
      0x02, 0x01, 0x28, 0x02, 0x40, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3,
      0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14,
      0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0,
      0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74,
      0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a,
      0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: modify first byte of integer
    // tcID: 116
    {SEC_OID_SHA512,
     116,
     {0x30, 0x81, 0x86, 0x02, 0x41, 0x4c, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: modify first byte of integer
    // tcID: 117
    {SEC_OID_SHA512,
     117,
     {0x30, 0x81, 0x86, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41,
      0x2a, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: modify last byte of integer
    // tcID: 118
    {SEC_OID_SHA512,
     118,
     {0x30, 0x81, 0x86, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0xc5, 0x02, 0x41,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: modify last byte of integer
    // tcID: 119
    {SEC_OID_SHA512,
     119,
     {0x30, 0x81, 0x86, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0x41},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated integer
    // tcID: 120
    {SEC_OID_SHA512,
     120,
     {0x30, 0x81, 0x85, 0x02, 0x40, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x02, 0x41, 0x28,
      0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92,
      0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97,
      0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69,
      0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a, 0x69,
      0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe,
      0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated integer
    // tcID: 121
    {SEC_OID_SHA512,
     121,
     {0x30, 0x81, 0x85, 0x02, 0x40, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb, 0x89,
      0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c, 0x7a,
      0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f, 0xfb,
      0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6, 0x6f,
      0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0, 0xec,
      0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41, 0x28,
      0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92,
      0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97,
      0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69,
      0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a, 0x69,
      0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe,
      0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated integer
    // tcID: 122
    {SEC_OID_SHA512,
     122,
     {0x30, 0x81, 0x85, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x40,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated integer
    // tcID: 123
    {SEC_OID_SHA512,
     123,
     {0x30, 0x81, 0x85, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x40,
      0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92,
      0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97,
      0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69,
      0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a, 0x69,
      0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe,
      0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: leading ff in integer
    // tcID: 124
    {SEC_OID_SHA512,
     124,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0xff, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8,
      0xcb, 0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8,
      0x2c, 0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7,
      0x5f, 0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04,
      0xf6, 0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20,
      0xb0, 0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02,
      0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd,
      0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23,
      0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4,
      0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70,
      0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30,
      0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: leading ff in integer
    // tcID: 125
    {SEC_OID_SHA512,
     125,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x42,
      0xff, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd,
      0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23,
      0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4,
      0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70,
      0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30,
      0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: replaced integer by infinity
    // tcID: 126
    {SEC_OID_SHA512,
     126,
     {0x30, 0x46, 0x09, 0x01, 0x80, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a,
      0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed,
      0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd,
      0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb,
      0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28,
      0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: replaced integer by infinity
    // tcID: 127
    {SEC_OID_SHA512,
     127,
     {0x30, 0x46, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb, 0x89,
      0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c, 0x7a,
      0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f, 0xfb,
      0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6, 0x6f,
      0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0, 0xec,
      0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x09, 0x01, 0x80},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: replacing integer with zero
    // tcID: 128
    {SEC_OID_SHA512,
     128,
     {0x30, 0x46, 0x02, 0x01, 0x00, 0x02, 0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a,
      0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed,
      0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd,
      0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb,
      0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28,
      0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: replacing integer with zero
    // tcID: 129
    {SEC_OID_SHA512,
     129,
     {0x30, 0x46, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb, 0x89,
      0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c, 0x7a,
      0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f, 0xfb,
      0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6, 0x6f,
      0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0, 0xec,
      0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x01, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 130
    {SEC_OID_SHA512,
     130,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x02, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8,
      0xcb, 0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8,
      0x2c, 0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7,
      0x5f, 0xfb, 0xe9, 0x7b, 0x33, 0x67, 0x12, 0x2f, 0xa4, 0xa2, 0x05, 0x84,
      0xc2, 0x71, 0x23, 0x3f, 0x3e, 0xc3, 0xb7, 0xf7, 0xb3, 0x1b, 0x0f, 0xaa,
      0x4d, 0x34, 0x0b, 0x92, 0xa6, 0xb0, 0xd5, 0xcd, 0x17, 0xea, 0x4e, 0x02,
      0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd,
      0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23,
      0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4,
      0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70,
      0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30,
      0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 131
    {SEC_OID_SHA512,
     131,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0xfe, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8,
      0xcb, 0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8,
      0x2c, 0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7,
      0x5f, 0xfb, 0xf4, 0xd8, 0x26, 0x58, 0x0a, 0xb1, 0x45, 0x75, 0x2e, 0x85,
      0x2a, 0x6e, 0x91, 0x51, 0x2b, 0x78, 0x17, 0x80, 0x47, 0x87, 0x9e, 0x97,
      0x14, 0xa4, 0xae, 0x1b, 0xc7, 0x42, 0x98, 0xaa, 0xa7, 0x22, 0x3c, 0x02,
      0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd,
      0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23,
      0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4,
      0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70,
      0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30,
      0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 132
    {SEC_OID_SHA512,
     132,
     {0x30, 0x81, 0x86, 0x02, 0x41, 0xb1, 0xbd, 0xdc, 0x11, 0xbc, 0x17, 0x34,
      0x76, 0x21, 0xc4, 0xec, 0xc6, 0x00, 0x3d, 0x86, 0x1a, 0x7d, 0x07, 0xd3,
      0x85, 0x4f, 0x08, 0xe4, 0x42, 0x1b, 0xc2, 0x41, 0xc8, 0xb5, 0x38, 0xa0,
      0x04, 0x10, 0xd6, 0x53, 0x20, 0x71, 0x8f, 0x8a, 0xf4, 0x65, 0xfb, 0x09,
      0x90, 0x25, 0xb7, 0xca, 0xe2, 0x18, 0x44, 0x02, 0xae, 0xa8, 0xdf, 0x4f,
      0x13, 0xa3, 0x28, 0xc9, 0x06, 0x48, 0xc4, 0x20, 0x79, 0xbb, 0x02, 0x41,
      0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd, 0x2e,
      0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23, 0xa6,
      0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4, 0x3d,
      0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70, 0x9a,
      0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30, 0x22,
      0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 133
    {SEC_OID_SHA512,
     133,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x01, 0xb1, 0xbd, 0xdc, 0x11, 0xbc, 0x17,
      0x34, 0x76, 0x21, 0xc4, 0xec, 0xc6, 0x00, 0x3d, 0x86, 0x1a, 0x7d, 0x07,
      0xd3, 0x85, 0x4f, 0x08, 0xe4, 0x42, 0x1b, 0xc2, 0x41, 0xc8, 0xb5, 0x38,
      0xa0, 0x04, 0x0b, 0x27, 0xd9, 0xa7, 0xf5, 0x4e, 0xba, 0x8a, 0xd1, 0x7a,
      0xd5, 0x91, 0x6e, 0xae, 0xd4, 0x87, 0xe8, 0x7f, 0xb8, 0x78, 0x61, 0x68,
      0xeb, 0x5b, 0x51, 0xe4, 0x38, 0xbd, 0x67, 0x55, 0x58, 0xdd, 0xc4, 0x02,
      0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd,
      0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23,
      0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4,
      0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70,
      0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30,
      0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 134
    {SEC_OID_SHA512,
     134,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0xfd, 0xb1, 0xbd, 0xdc, 0x11, 0xbc, 0x17,
      0x34, 0x76, 0x21, 0xc4, 0xec, 0xc6, 0x00, 0x3d, 0x86, 0x1a, 0x7d, 0x07,
      0xd3, 0x85, 0x4f, 0x08, 0xe4, 0x42, 0x1b, 0xc2, 0x41, 0xc8, 0xb5, 0x38,
      0xa0, 0x04, 0x16, 0x84, 0xcc, 0x98, 0xed, 0xd0, 0x5b, 0x5d, 0xfa, 0x7b,
      0x3d, 0x8e, 0xdc, 0xc0, 0xc1, 0x3c, 0x48, 0x08, 0x4c, 0xe4, 0xf0, 0x55,
      0xb2, 0xcb, 0xf4, 0x6d, 0x59, 0x4f, 0x2a, 0x32, 0xe8, 0x15, 0xb2, 0x02,
      0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd,
      0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23,
      0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4,
      0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70,
      0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30,
      0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 135
    {SEC_OID_SHA512,
     135,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x02, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8,
      0xcb, 0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8,
      0x2c, 0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7,
      0x5f, 0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04,
      0xf6, 0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20,
      0xb0, 0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02,
      0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd,
      0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23,
      0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4,
      0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70,
      0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30,
      0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 136
    {SEC_OID_SHA512,
     136,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0xfe, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8,
      0xcb, 0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8,
      0x2c, 0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7,
      0x5f, 0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04,
      0xf6, 0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20,
      0xb0, 0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02,
      0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd,
      0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23,
      0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4,
      0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70,
      0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30,
      0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 137
    {SEC_OID_SHA512,
     137,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x01, 0xb1, 0xbd, 0xdc, 0x11, 0xbc, 0x17,
      0x34, 0x76, 0x21, 0xc4, 0xec, 0xc6, 0x00, 0x3d, 0x86, 0x1a, 0x7d, 0x07,
      0xd3, 0x85, 0x4f, 0x08, 0xe4, 0x42, 0x1b, 0xc2, 0x41, 0xc8, 0xb5, 0x38,
      0xa0, 0x04, 0x10, 0xd6, 0x53, 0x20, 0x71, 0x8f, 0x8a, 0xf4, 0x65, 0xfb,
      0x09, 0x90, 0x25, 0xb7, 0xca, 0xe2, 0x18, 0x44, 0x02, 0xae, 0xa8, 0xdf,
      0x4f, 0x13, 0xa3, 0x28, 0xc9, 0x06, 0x48, 0xc4, 0x20, 0x79, 0xbb, 0x02,
      0x41, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd,
      0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23,
      0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4,
      0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70,
      0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30,
      0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 138
    {SEC_OID_SHA512,
     138,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x42,
      0x02, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd,
      0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23,
      0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0x9a, 0x7b, 0x6a,
      0xc4, 0xec, 0xd0, 0x41, 0x0b, 0x47, 0x22, 0xca, 0x75, 0xba, 0x19, 0x7a,
      0x40, 0x3a, 0x0a, 0x1f, 0x9e, 0xe0, 0xe7, 0xb3, 0x91, 0xb0, 0x64, 0x9f,
      0xda, 0x1d, 0x39, 0x69, 0xee, 0xca},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 139
    {SEC_OID_SHA512,
     139,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x42,
      0xfe, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd,
      0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23,
      0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa5, 0xd8, 0x5d,
      0xb5, 0xe5, 0x51, 0xe1, 0xde, 0x70, 0x23, 0x32, 0x73, 0x28, 0x2b, 0x66,
      0xf4, 0x99, 0x92, 0xb4, 0x0b, 0x6f, 0xd4, 0x7b, 0x02, 0x52, 0xed, 0xc0,
      0x6b, 0xe0, 0x16, 0xf9, 0x26, 0xb8},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 140
    {SEC_OID_SHA512,
     140,
     {0x30, 0x81, 0x86, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x41,
      0xd7, 0x4a, 0x2f, 0x6d, 0x95, 0xbe, 0x8d, 0x4c, 0xb6, 0x4f, 0x02, 0xd1,
      0x6d, 0x6b, 0x78, 0x5a, 0x12, 0x46, 0xb4, 0xeb, 0xd2, 0x06, 0xdc, 0x59,
      0x68, 0x18, 0xbb, 0x95, 0x32, 0x53, 0x24, 0x5f, 0x5f, 0xd6, 0x1b, 0xc2,
      0x96, 0xee, 0xee, 0x8b, 0x24, 0x5d, 0x01, 0x8b, 0x8e, 0xdd, 0x8f, 0x65,
      0x96, 0x31, 0x96, 0x2a, 0xd7, 0xa1, 0xe8, 0xb5, 0xfe, 0x56, 0xcf, 0xdd,
      0x01, 0x57, 0xce, 0x75, 0x3f},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 141
    {SEC_OID_SHA512,
     141,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x42,
      0xfd, 0xd7, 0x4a, 0x2f, 0x6d, 0x95, 0xbe, 0x8d, 0x4c, 0xb6, 0x4f, 0x02,
      0xd1, 0x6d, 0x6b, 0x78, 0x5a, 0x12, 0x46, 0xb4, 0xeb, 0xd2, 0x06, 0xdc,
      0x59, 0x68, 0x18, 0xbb, 0x95, 0x32, 0x53, 0x24, 0x5f, 0x65, 0x84, 0x95,
      0x3b, 0x13, 0x2f, 0xbe, 0xf4, 0xb8, 0xdd, 0x35, 0x8a, 0x45, 0xe6, 0x85,
      0xbf, 0xc5, 0xf5, 0xe0, 0x61, 0x1f, 0x18, 0x4c, 0x6e, 0x4f, 0x9b, 0x60,
      0x25, 0xe2, 0xc6, 0x96, 0x11, 0x36},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 142
    {SEC_OID_SHA512,
     142,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x42,
      0x02, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd,
      0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23,
      0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4,
      0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70,
      0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30,
      0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 143
    {SEC_OID_SHA512,
     143,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x42,
      0xfe, 0x28, 0xb5, 0xd0, 0x92, 0x6a, 0x41, 0x72, 0xb3, 0x49, 0xb0, 0xfd,
      0x2e, 0x92, 0x94, 0x87, 0xa5, 0xed, 0xb9, 0x4b, 0x14, 0x2d, 0xf9, 0x23,
      0xa6, 0x97, 0xe7, 0x44, 0x6a, 0xcd, 0xac, 0xdb, 0xa0, 0xa0, 0x29, 0xe4,
      0x3d, 0x69, 0x11, 0x11, 0x74, 0xdb, 0xa2, 0xfe, 0x74, 0x71, 0x22, 0x70,
      0x9a, 0x69, 0xce, 0x69, 0xd5, 0x28, 0x5e, 0x17, 0x4a, 0x01, 0xa9, 0x30,
      0x22, 0xfe, 0xa8, 0x31, 0x8a, 0xc1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 144
    {SEC_OID_SHA512,
     144,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x4e, 0x42, 0x23, 0xee, 0x43, 0xe8, 0xcb,
      0x89, 0xde, 0x3b, 0x13, 0x39, 0xff, 0xc2, 0x79, 0xe5, 0x82, 0xf8, 0x2c,
      0x7a, 0xb0, 0xf7, 0x1b, 0xbd, 0xe4, 0x3d, 0xbe, 0x37, 0x4a, 0xc7, 0x5f,
      0xfb, 0xef, 0x29, 0xac, 0xdf, 0x8e, 0x70, 0x75, 0x0b, 0x9a, 0x04, 0xf6,
      0x6f, 0xda, 0x48, 0x35, 0x1d, 0xe7, 0xbb, 0xfd, 0x51, 0x57, 0x20, 0xb0,
      0xec, 0x5c, 0xd7, 0x36, 0xf9, 0xb7, 0x3b, 0xdf, 0x86, 0x45, 0x02, 0x42,
      0x01, 0xd7, 0x4a, 0x2f, 0x6d, 0x95, 0xbe, 0x8d, 0x4c, 0xb6, 0x4f, 0x02,
      0xd1, 0x6d, 0x6b, 0x78, 0x5a, 0x12, 0x46, 0xb4, 0xeb, 0xd2, 0x06, 0xdc,
      0x59, 0x68, 0x18, 0xbb, 0x95, 0x32, 0x53, 0x24, 0x5f, 0x5f, 0xd6, 0x1b,
      0xc2, 0x96, 0xee, 0xee, 0x8b, 0x24, 0x5d, 0x01, 0x8b, 0x8e, 0xdd, 0x8f,
      0x65, 0x96, 0x31, 0x96, 0x2a, 0xd7, 0xa1, 0xe8, 0xb5, 0xfe, 0x56, 0xcf,
      0xdd, 0x01, 0x57, 0xce, 0x75, 0x3f},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 145
    {SEC_OID_SHA512,
     145,
     {0x30, 0x06, 0x02, 0x01, 0x00, 0x02, 0x01, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 146
    {SEC_OID_SHA512,
     146,
     {0x30, 0x06, 0x02, 0x01, 0x00, 0x02, 0x01, 0x01},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 147
    {SEC_OID_SHA512,
     147,
     {0x30, 0x06, 0x02, 0x01, 0x00, 0x02, 0x01, 0xff},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 148
    {SEC_OID_SHA512,
     148,
     {0x30, 0x47, 0x02, 0x01, 0x00, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x51, 0x86, 0x87,
      0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7, 0x09,
      0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb,
      0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x09},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 149
    {SEC_OID_SHA512,
     149,
     {0x30, 0x47, 0x02, 0x01, 0x00, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x51, 0x86, 0x87,
      0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7, 0x09,
      0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb,
      0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x08},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 150
    {SEC_OID_SHA512,
     150,
     {0x30, 0x47, 0x02, 0x01, 0x00, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x51, 0x86, 0x87,
      0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7, 0x09,
      0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb,
      0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x0a},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 151
    {SEC_OID_SHA512,
     151,
     {0x30, 0x47, 0x02, 0x01, 0x00, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 152
    {SEC_OID_SHA512,
     152,
     {0x30, 0x47, 0x02, 0x01, 0x00, 0x02, 0x42, 0x02, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 153
    {SEC_OID_SHA512,
     153,
     {0x30, 0x08, 0x02, 0x01, 0x00, 0x09, 0x03, 0x80, 0xfe, 0x01},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 154
    {SEC_OID_SHA512,
     154,
     {0x30, 0x06, 0x02, 0x01, 0x00, 0x09, 0x01, 0x42},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 155
    {SEC_OID_SHA512,
     155,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x02, 0x01, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 156
    {SEC_OID_SHA512,
     156,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x02, 0x01, 0x01},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 157
    {SEC_OID_SHA512,
     157,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x02, 0x01, 0xff},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 158
    {SEC_OID_SHA512,
     158,
     {0x30, 0x47, 0x02, 0x01, 0x01, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x51, 0x86, 0x87,
      0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7, 0x09,
      0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb,
      0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x09},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 159
    {SEC_OID_SHA512,
     159,
     {0x30, 0x47, 0x02, 0x01, 0x01, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x51, 0x86, 0x87,
      0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7, 0x09,
      0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb,
      0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x08},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 160
    {SEC_OID_SHA512,
     160,
     {0x30, 0x47, 0x02, 0x01, 0x01, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x51, 0x86, 0x87,
      0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7, 0x09,
      0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb,
      0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x0a},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 161
    {SEC_OID_SHA512,
     161,
     {0x30, 0x47, 0x02, 0x01, 0x01, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 162
    {SEC_OID_SHA512,
     162,
     {0x30, 0x47, 0x02, 0x01, 0x01, 0x02, 0x42, 0x02, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 163
    {SEC_OID_SHA512,
     163,
     {0x30, 0x08, 0x02, 0x01, 0x01, 0x09, 0x03, 0x80, 0xfe, 0x01},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 164
    {SEC_OID_SHA512,
     164,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x09, 0x01, 0x42},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 165
    {SEC_OID_SHA512,
     165,
     {0x30, 0x06, 0x02, 0x01, 0xff, 0x02, 0x01, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 166
    {SEC_OID_SHA512,
     166,
     {0x30, 0x06, 0x02, 0x01, 0xff, 0x02, 0x01, 0x01},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 167
    {SEC_OID_SHA512,
     167,
     {0x30, 0x06, 0x02, 0x01, 0xff, 0x02, 0x01, 0xff},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 168
    {SEC_OID_SHA512,
     168,
     {0x30, 0x47, 0x02, 0x01, 0xff, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x51, 0x86, 0x87,
      0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7, 0x09,
      0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb,
      0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x09},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 169
    {SEC_OID_SHA512,
     169,
     {0x30, 0x47, 0x02, 0x01, 0xff, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x51, 0x86, 0x87,
      0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7, 0x09,
      0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb,
      0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x08},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 170
    {SEC_OID_SHA512,
     170,
     {0x30, 0x47, 0x02, 0x01, 0xff, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x51, 0x86, 0x87,
      0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7, 0x09,
      0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb,
      0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x0a},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 171
    {SEC_OID_SHA512,
     171,
     {0x30, 0x47, 0x02, 0x01, 0xff, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 172
    {SEC_OID_SHA512,
     172,
     {0x30, 0x47, 0x02, 0x01, 0xff, 0x02, 0x42, 0x02, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 173
    {SEC_OID_SHA512,
     173,
     {0x30, 0x08, 0x02, 0x01, 0xff, 0x09, 0x03, 0x80, 0xfe, 0x01},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 174
    {SEC_OID_SHA512,
     174,
     {0x30, 0x06, 0x02, 0x01, 0xff, 0x09, 0x01, 0x42},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 175
    {SEC_OID_SHA512,
     175,
     {0x30, 0x47, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f,
      0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0, 0x3b,
      0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e,
      0x91, 0x38, 0x64, 0x09, 0x02, 0x01, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 176
    {SEC_OID_SHA512,
     176,
     {0x30, 0x47, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f,
      0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0, 0x3b,
      0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e,
      0x91, 0x38, 0x64, 0x09, 0x02, 0x01, 0x01},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 177
    {SEC_OID_SHA512,
     177,
     {0x30, 0x47, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f,
      0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0, 0x3b,
      0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e,
      0x91, 0x38, 0x64, 0x09, 0x02, 0x01, 0xff},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 178
    {SEC_OID_SHA512,
     178,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f,
      0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89,
      0x9c, 0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x09, 0x02,
      0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x51,
      0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7,
      0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb,
      0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x09},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 179
    {SEC_OID_SHA512,
     179,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f,
      0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89,
      0x9c, 0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x09, 0x02,
      0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x51,
      0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7,
      0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb,
      0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x08},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 180
    {SEC_OID_SHA512,
     180,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f,
      0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89,
      0x9c, 0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x09, 0x02,
      0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x51,
      0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7,
      0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb,
      0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x0a},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 181
    {SEC_OID_SHA512,
     181,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f,
      0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89,
      0x9c, 0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x09, 0x02,
      0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 182
    {SEC_OID_SHA512,
     182,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f,
      0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89,
      0x9c, 0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x09, 0x02,
      0x42, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 183
    {SEC_OID_SHA512,
     183,
     {0x30, 0x49, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f,
      0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0, 0x3b,
      0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e,
      0x91, 0x38, 0x64, 0x09, 0x09, 0x03, 0x80, 0xfe, 0x01},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 184
    {SEC_OID_SHA512,
     184,
     {0x30, 0x47, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f,
      0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0, 0x3b,
      0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e,
      0x91, 0x38, 0x64, 0x09, 0x09, 0x01, 0x42},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 185
    {SEC_OID_SHA512,
     185,
     {0x30, 0x47, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f,
      0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0, 0x3b,
      0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e,
      0x91, 0x38, 0x64, 0x08, 0x02, 0x01, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 186
    {SEC_OID_SHA512,
     186,
     {0x30, 0x47, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f,
      0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0, 0x3b,
      0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e,
      0x91, 0x38, 0x64, 0x08, 0x02, 0x01, 0x01},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 187
    {SEC_OID_SHA512,
     187,
     {0x30, 0x47, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f,
      0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0, 0x3b,
      0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e,
      0x91, 0x38, 0x64, 0x08, 0x02, 0x01, 0xff},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 188
    {SEC_OID_SHA512,
     188,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f,
      0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89,
      0x9c, 0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x08, 0x02,
      0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x51,
      0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7,
      0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb,
      0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x09},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 189
    {SEC_OID_SHA512,
     189,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f,
      0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89,
      0x9c, 0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x08, 0x02,
      0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x51,
      0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7,
      0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb,
      0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x08},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 190
    {SEC_OID_SHA512,
     190,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f,
      0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89,
      0x9c, 0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x08, 0x02,
      0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x51,
      0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7,
      0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb,
      0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x0a},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 191
    {SEC_OID_SHA512,
     191,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f,
      0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89,
      0x9c, 0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x08, 0x02,
      0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 192
    {SEC_OID_SHA512,
     192,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f,
      0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89,
      0x9c, 0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x08, 0x02,
      0x42, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 193
    {SEC_OID_SHA512,
     193,
     {0x30, 0x49, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f,
      0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0, 0x3b,
      0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e,
      0x91, 0x38, 0x64, 0x08, 0x09, 0x03, 0x80, 0xfe, 0x01},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 194
    {SEC_OID_SHA512,
     194,
     {0x30, 0x47, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f,
      0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0, 0x3b,
      0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e,
      0x91, 0x38, 0x64, 0x08, 0x09, 0x01, 0x42},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 195
    {SEC_OID_SHA512,
     195,
     {0x30, 0x47, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f,
      0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0, 0x3b,
      0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e,
      0x91, 0x38, 0x64, 0x0a, 0x02, 0x01, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 196
    {SEC_OID_SHA512,
     196,
     {0x30, 0x47, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f,
      0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0, 0x3b,
      0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e,
      0x91, 0x38, 0x64, 0x0a, 0x02, 0x01, 0x01},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 197
    {SEC_OID_SHA512,
     197,
     {0x30, 0x47, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f,
      0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0, 0x3b,
      0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e,
      0x91, 0x38, 0x64, 0x0a, 0x02, 0x01, 0xff},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 198
    {SEC_OID_SHA512,
     198,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f,
      0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89,
      0x9c, 0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x0a, 0x02,
      0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x51,
      0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7,
      0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb,
      0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x09},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 199
    {SEC_OID_SHA512,
     199,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f,
      0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89,
      0x9c, 0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x0a, 0x02,
      0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x51,
      0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7,
      0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb,
      0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x08},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 200
    {SEC_OID_SHA512,
     200,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f,
      0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89,
      0x9c, 0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x0a, 0x02,
      0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x51,
      0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7,
      0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb,
      0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x0a},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 201
    {SEC_OID_SHA512,
     201,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f,
      0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89,
      0x9c, 0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x0a, 0x02,
      0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 202
    {SEC_OID_SHA512,
     202,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f,
      0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89,
      0x9c, 0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x0a, 0x02,
      0x42, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 203
    {SEC_OID_SHA512,
     203,
     {0x30, 0x49, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f,
      0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0, 0x3b,
      0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e,
      0x91, 0x38, 0x64, 0x0a, 0x09, 0x03, 0x80, 0xfe, 0x01},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 204
    {SEC_OID_SHA512,
     204,
     {0x30, 0x47, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f,
      0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0, 0x3b,
      0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e,
      0x91, 0x38, 0x64, 0x0a, 0x09, 0x01, 0x42},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 205
    {SEC_OID_SHA512,
     205,
     {0x30, 0x47, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0x02, 0x01, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 206
    {SEC_OID_SHA512,
     206,
     {0x30, 0x47, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0x02, 0x01, 0x01},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 207
    {SEC_OID_SHA512,
     207,
     {0x30, 0x47, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0x02, 0x01, 0xff},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 208
    {SEC_OID_SHA512,
     208,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x02,
      0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x51,
      0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7,
      0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb,
      0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x09},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 209
    {SEC_OID_SHA512,
     209,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x02,
      0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x51,
      0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7,
      0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb,
      0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x08},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 210
    {SEC_OID_SHA512,
     210,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x02,
      0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x51,
      0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7,
      0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb,
      0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x0a},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 211
    {SEC_OID_SHA512,
     211,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x02,
      0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 212
    {SEC_OID_SHA512,
     212,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x02,
      0x42, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 213
    {SEC_OID_SHA512,
     213,
     {0x30, 0x49, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0x09, 0x03, 0x80, 0xfe, 0x01},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 214
    {SEC_OID_SHA512,
     214,
     {0x30, 0x47, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0x09, 0x01, 0x42},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 215
    {SEC_OID_SHA512,
     215,
     {0x30, 0x47, 0x02, 0x42, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 216
    {SEC_OID_SHA512,
     216,
     {0x30, 0x47, 0x02, 0x42, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x01},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 217
    {SEC_OID_SHA512,
     217,
     {0x30, 0x47, 0x02, 0x42, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0xff},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 218
    {SEC_OID_SHA512,
     218,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
      0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x51,
      0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7,
      0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb,
      0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x09},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 219
    {SEC_OID_SHA512,
     219,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
      0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x51,
      0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7,
      0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb,
      0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x08},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 220
    {SEC_OID_SHA512,
     220,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
      0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x51,
      0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7,
      0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb,
      0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x0a},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 221
    {SEC_OID_SHA512,
     221,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
      0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 222
    {SEC_OID_SHA512,
     222,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
      0x42, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 223
    {SEC_OID_SHA512,
     223,
     {0x30, 0x49, 0x02, 0x42, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x09, 0x03, 0x80, 0xfe, 0x01},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 224
    {SEC_OID_SHA512,
     224,
     {0x30, 0x47, 0x02, 0x42, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x09, 0x01, 0x42},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature encoding contains wrong types.
    // tcID: 225
    {SEC_OID_SHA512,
     225,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x0c, 0x01, 0x30},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature encoding contains wrong types.
    // tcID: 226
    {SEC_OID_SHA512,
     226,
     {0x30, 0x05, 0x02, 0x01, 0x01, 0x0c, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature encoding contains wrong types.
    // tcID: 227
    {SEC_OID_SHA512,
     227,
     {0x30, 0x09, 0x0c, 0x02, 0x25, 0x73, 0x0c, 0x03, 0x73, 0x25, 0x73},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature encoding contains wrong types.
    // tcID: 228
    {SEC_OID_SHA512,
     228,
     {0x30, 0x08, 0x02, 0x01, 0x01, 0x30, 0x03, 0x02, 0x01, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature encoding contains wrong types.
    // tcID: 229
    {SEC_OID_SHA512,
     229,
     {0x30, 0x03, 0x02, 0x01, 0x01},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature encoding contains wrong types.
    // tcID: 230
    {SEC_OID_SHA512,
     230,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x01, 0x01, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Edge case for Shamir multiplication
    // tcID: 231
    {SEC_OID_SHA512,
     231,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x00, 0xb4, 0xb1, 0x06, 0x46, 0xa6, 0x68,
      0xc3, 0x85, 0xe1, 0xc4, 0xda, 0x61, 0x3e, 0xb6, 0x59, 0x2c, 0x09, 0x76,
      0xfc, 0x4d, 0xf8, 0x43, 0xfc, 0x44, 0x6f, 0x20, 0x67, 0x3b, 0xe5, 0xac,
      0x18, 0xc7, 0xd8, 0x60, 0x8a, 0x94, 0x3f, 0x01, 0x9d, 0x96, 0x21, 0x62,
      0x54, 0xb0, 0x9d, 0xe5, 0xf2, 0x0f, 0x31, 0x59, 0x40, 0x2c, 0xed, 0x88,
      0xef, 0x80, 0x5a, 0x41, 0x54, 0xf7, 0x80, 0xe0, 0x93, 0xe0, 0x44, 0x02,
      0x41, 0x65, 0xcd, 0x4e, 0x7f, 0x2d, 0x8b, 0x75, 0x2c, 0x35, 0xa6, 0x2f,
      0xc1, 0x1a, 0x4a, 0xb7, 0x45, 0xa9, 0x1c, 0xa8, 0x06, 0x98, 0xa2, 0x26,
      0xb4, 0x1f, 0x15, 0x6f, 0xb7, 0x64, 0xb7, 0x9f, 0x4d, 0x76, 0x54, 0x81,
      0x40, 0xeb, 0x94, 0xd2, 0xc4, 0x77, 0xc0, 0xa9, 0xbe, 0x3e, 0x1d, 0x4d,
      0x1a, 0xcb, 0xf9, 0xcf, 0x44, 0x97, 0x01, 0xc1, 0x0b, 0xd4, 0x7c, 0x2e,
      0x36, 0x98, 0xb3, 0x28, 0x79, 0x34},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x39, 0x35, 0x30, 0x32},
     true},

    // Comment: special case hash
    // tcID: 232
    {SEC_OID_SHA512,
     232,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x20, 0x9e, 0x6f, 0x7b, 0x6f, 0x2f,
      0x76, 0x42, 0x61, 0x76, 0x6d, 0x41, 0x06, 0xc3, 0xe4, 0xa4, 0x3a, 0xc6,
      0x15, 0xf6, 0x45, 0xf3, 0xef, 0x5c, 0x71, 0x39, 0x65, 0x1e, 0x86, 0xe4,
      0xa1, 0x77, 0xf9, 0xc2, 0xab, 0x68, 0x02, 0x7a, 0xfb, 0xc6, 0x78, 0x4c,
      0xcb, 0x78, 0xd0, 0x5c, 0x25, 0x8a, 0x8b, 0x9b, 0x18, 0xfb, 0x1c, 0x0f,
      0x28, 0xbe, 0x4d, 0x02, 0x4d, 0xa9, 0x07, 0x38, 0xfb, 0xd3, 0x74, 0x02,
      0x42, 0x01, 0xad, 0xe5, 0xd2, 0xcb, 0x6b, 0xf7, 0x9d, 0x80, 0x58, 0x3a,
      0xeb, 0x11, 0xac, 0x32, 0x54, 0xfc, 0x15, 0x1f, 0xa3, 0x63, 0x30, 0x55,
      0x08, 0xa0, 0xf1, 0x21, 0x45, 0x7d, 0x00, 0x91, 0x1f, 0x8f, 0x5e, 0xf6,
      0xd4, 0xec, 0x27, 0x46, 0x0d, 0x26, 0xf3, 0xb5, 0x6f, 0x44, 0x47, 0xf4,
      0x34, 0xff, 0x9a, 0xbe, 0x6a, 0x91, 0xe5, 0x05, 0x5e, 0x7f, 0xe7, 0x70,
      0x73, 0x45, 0xe5, 0x62, 0x98, 0x3d, 0x64},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x33, 0x39, 0x34, 0x39, 0x31, 0x39, 0x34, 0x31, 0x37, 0x32},
     true},

    // Comment: special case hash
    // tcID: 233
    {SEC_OID_SHA512,
     233,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xc0, 0x83, 0x2c, 0x97, 0x3a, 0x45,
      0x5c, 0xac, 0x48, 0xa4, 0x43, 0x96, 0x59, 0xaa, 0x21, 0x14, 0x60, 0x36,
      0xc5, 0x2e, 0xc1, 0x51, 0x41, 0x21, 0xc6, 0x67, 0x14, 0x34, 0x8a, 0x1c,
      0x0e, 0x2c, 0x70, 0x99, 0xa2, 0x46, 0x6d, 0x9a, 0xcb, 0x49, 0x32, 0x5a,
      0x0c, 0xb5, 0x09, 0xe5, 0xdf, 0xf2, 0xef, 0xbc, 0xd9, 0x03, 0x69, 0xd3,
      0x02, 0x7c, 0xbb, 0x7d, 0xca, 0x58, 0xa1, 0x34, 0x27, 0x8d, 0x05, 0x02,
      0x42, 0x00, 0xa4, 0x26, 0xc0, 0x63, 0xab, 0x5c, 0xc6, 0xaf, 0x20, 0xdd,
      0x1b, 0xa8, 0xa5, 0x19, 0xfa, 0xc9, 0x10, 0x18, 0x35, 0x61, 0x59, 0x8e,
      0x67, 0xc0, 0x92, 0x9e, 0x25, 0xf9, 0xc3, 0xaa, 0xeb, 0x24, 0x5c, 0x56,
      0x47, 0xfb, 0xa2, 0x1e, 0x30, 0xc1, 0x03, 0x30, 0x4d, 0xc6, 0xf4, 0x9e,
      0x6d, 0xec, 0x68, 0xa7, 0x83, 0x35, 0x33, 0xe4, 0xe5, 0x44, 0x82, 0x40,
      0xbd, 0xe0, 0x23, 0xfe, 0x20, 0x1e, 0xb9},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x35, 0x33, 0x36, 0x37, 0x36, 0x34, 0x31, 0x38, 0x37, 0x37},
     true},

    // Comment: special case hash
    // tcID: 234
    {SEC_OID_SHA512,
     234,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x0d, 0x01, 0xcd, 0xe6, 0x4d, 0xda, 0x4d,
      0xbc, 0xef, 0x1a, 0x9b, 0x92, 0x47, 0x79, 0x59, 0x82, 0x17, 0xb9, 0x7e,
      0xb6, 0x88, 0xd9, 0xb4, 0xa4, 0xfd, 0x20, 0xd1, 0xb8, 0x1f, 0xf0, 0xbb,
      0x87, 0x0a, 0xbf, 0xf1, 0xb0, 0xdb, 0x6d, 0xfc, 0x37, 0x62, 0xf2, 0x7c,
      0x39, 0x54, 0xf2, 0x30, 0xa7, 0x93, 0x3d, 0x9e, 0xa3, 0x97, 0xa9, 0x72,
      0xca, 0xac, 0x5e, 0xd2, 0x18, 0x3e, 0xc7, 0x27, 0x16, 0xc7, 0x02, 0x42,
      0x01, 0xc6, 0x53, 0x0f, 0xb6, 0xb9, 0x13, 0x00, 0x5f, 0x81, 0xe1, 0x56,
      0xbe, 0x89, 0xb3, 0x84, 0x77, 0x01, 0x82, 0x9f, 0xbb, 0x31, 0x0d, 0x8a,
      0x4c, 0x76, 0x12, 0x12, 0xc6, 0xd2, 0xf8, 0x75, 0x01, 0x74, 0xf2, 0xbf,
      0x81, 0xc2, 0x38, 0xfd, 0xde, 0x43, 0x70, 0xfa, 0x87, 0xde, 0x32, 0x0f,
      0x57, 0xdb, 0xed, 0x96, 0x69, 0x1a, 0xf4, 0x5c, 0xb9, 0x9f, 0x3d, 0xaa,
      0x86, 0x5e, 0xdc, 0xdd, 0xa5, 0x9e},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x35, 0x36, 0x37, 0x31, 0x34, 0x38, 0x31, 0x30, 0x39, 0x35},
     true},

    // Comment: special case hash
    // tcID: 235
    {SEC_OID_SHA512,
     235,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x00, 0xc0, 0x09, 0xc7, 0x4e, 0xc7, 0x07,
      0x25, 0x23, 0x25, 0xd7, 0x8f, 0x4e, 0x7f, 0x14, 0xbe, 0x28, 0xf5, 0x62,
      0x72, 0xbe, 0x17, 0xc0, 0xc1, 0x8c, 0x90, 0xad, 0x4c, 0x07, 0x32, 0x2c,
      0xef, 0x4e, 0xea, 0x44, 0x4c, 0x8f, 0xea, 0xbf, 0x41, 0xa2, 0x13, 0xe3,
      0xe8, 0x46, 0xf8, 0xac, 0x8b, 0xb7, 0x75, 0x0d, 0x49, 0x14, 0x30, 0x69,
      0xcd, 0x01, 0x87, 0x7d, 0x53, 0x0b, 0xb9, 0x81, 0xf1, 0xa8, 0x5b, 0x02,
      0x41, 0x1f, 0x1c, 0x27, 0xef, 0x97, 0xf4, 0x34, 0xa8, 0xc2, 0xff, 0x31,
      0x5d, 0xd3, 0x9d, 0x90, 0x97, 0x09, 0x77, 0x5b, 0xb3, 0xc7, 0x58, 0x82,
      0x43, 0xbd, 0xfd, 0x8f, 0x7c, 0x86, 0x6c, 0x49, 0xb3, 0x36, 0x97, 0x19,
      0xd5, 0xb7, 0x4a, 0x47, 0x92, 0x4b, 0xbc, 0xe5, 0x73, 0x01, 0x67, 0x5e,
      0x2b, 0xaa, 0xdc, 0xec, 0x43, 0x8e, 0x07, 0xe6, 0xd5, 0x32, 0xab, 0xa6,
      0x64, 0x25, 0x3a, 0xb0, 0x95, 0x50},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x31, 0x32, 0x30, 0x37, 0x31, 0x37, 0x32, 0x39, 0x30, 0x39},
     true},

    // Comment: special case hash
    // tcID: 236
    {SEC_OID_SHA512,
     236,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xd3, 0xb1, 0x7a, 0x34, 0xb1, 0x9d,
      0x13, 0x47, 0x73, 0x98, 0x8c, 0x43, 0x4a, 0x9f, 0xb7, 0xf2, 0x2a, 0x57,
      0xdf, 0xb4, 0xc4, 0xbc, 0xca, 0x03, 0x1e, 0x21, 0x3e, 0x1b, 0x9a, 0x56,
      0xdb, 0x0e, 0xcb, 0x2f, 0x3c, 0x54, 0xcf, 0x9b, 0x1b, 0x6e, 0x59, 0x81,
      0x36, 0x96, 0x52, 0xde, 0x37, 0x33, 0x7a, 0x7a, 0x7d, 0x7d, 0xdb, 0x54,
      0xd6, 0x7b, 0x06, 0x7b, 0xbc, 0xe0, 0x1f, 0xd7, 0xfd, 0x28, 0x08, 0x02,
      0x42, 0x00, 0xc9, 0x03, 0x17, 0xdf, 0xa0, 0x61, 0x12, 0x25, 0x57, 0xeb,
      0x38, 0x99, 0x93, 0x99, 0x24, 0xa8, 0xea, 0x3c, 0xdd, 0x88, 0x6e, 0x0f,
      0x2e, 0x5f, 0x2c, 0x38, 0x4b, 0x65, 0xb1, 0xa4, 0x0d, 0xe5, 0xf0, 0x0f,
      0xd9, 0xfc, 0xe8, 0x89, 0xfc, 0x31, 0x3a, 0x6a, 0x9d, 0x5f, 0x0a, 0x9c,
      0xd3, 0xa7, 0xb8, 0x9b, 0x7b, 0xa8, 0xe9, 0x78, 0x07, 0x03, 0x1f, 0x3d,
      0x1e, 0x3f, 0x9c, 0x10, 0x3f, 0x0a, 0x10},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x31, 0x32, 0x39, 0x38, 0x30, 0x33, 0x34, 0x32, 0x33, 0x36},
     true},

    // Comment: special case hash
    // tcID: 237
    {SEC_OID_SHA512,
     237,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xcd, 0xca, 0x52, 0x99, 0xe7, 0x88,
      0x60, 0x0a, 0x3c, 0xa5, 0x93, 0x8d, 0x4a, 0x4c, 0x5f, 0x42, 0xb5, 0xee,
      0xa3, 0xce, 0xfc, 0x99, 0x0e, 0x67, 0xaf, 0x95, 0xa4, 0x44, 0x9a, 0xac,
      0x0a, 0xb5, 0x0e, 0x8f, 0xc4, 0x77, 0x8e, 0xfa, 0x49, 0x72, 0x23, 0xcd,
      0xca, 0x07, 0xc0, 0xe5, 0xa5, 0x92, 0x01, 0x10, 0xf3, 0xa8, 0x7a, 0xfa,
      0xaf, 0x26, 0x5b, 0xea, 0xdb, 0xb9, 0x1c, 0x00, 0xd1, 0x34, 0x64, 0x02,
      0x42, 0x01, 0xa9, 0x2b, 0x9a, 0x55, 0x70, 0xb4, 0x2f, 0x91, 0xeb, 0xc3,
      0xd8, 0xba, 0x27, 0x2d, 0xb9, 0x24, 0x14, 0x68, 0x15, 0x47, 0x83, 0x54,
      0x8d, 0x3f, 0xcf, 0xb6, 0xef, 0x46, 0xc9, 0xe0, 0x37, 0xbb, 0x62, 0x17,
      0xaf, 0x0a, 0x31, 0xef, 0x95, 0x2c, 0x27, 0x60, 0x46, 0x29, 0xad, 0x57,
      0x75, 0xe7, 0x69, 0x5c, 0x63, 0xef, 0xa1, 0x38, 0xce, 0xe8, 0x32, 0x6a,
      0x51, 0xc1, 0xb0, 0x4d, 0x0c, 0x65, 0x8f},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x39, 0x38, 0x37, 0x36, 0x30, 0x32, 0x39, 0x36, 0x38, 0x33},
     true},

    // Comment: special case hash
    // tcID: 238
    {SEC_OID_SHA512,
     238,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x66, 0x0b, 0x0e, 0xd1, 0x5d, 0x5f,
      0x63, 0x04, 0x4c, 0xb1, 0x89, 0xe1, 0xa4, 0x05, 0xbc, 0xb5, 0x91, 0xc3,
      0x72, 0x17, 0xd0, 0xe0, 0x00, 0x00, 0x86, 0x14, 0xb1, 0x52, 0x66, 0x5d,
      0x5b, 0xb9, 0x35, 0x3a, 0x38, 0x26, 0x85, 0x4a, 0x8b, 0xc6, 0xeb, 0xed,
      0x42, 0x3b, 0x15, 0x68, 0x0e, 0x43, 0x40, 0xa0, 0x07, 0x01, 0xb1, 0x7b,
      0xae, 0x24, 0xbd, 0x39, 0x9b, 0xcf, 0xf7, 0xe0, 0x43, 0x8b, 0xfb, 0x02,
      0x42, 0x01, 0xc4, 0x7f, 0x2f, 0x5c, 0x61, 0x43, 0xd2, 0xee, 0xf0, 0x63,
      0x75, 0x71, 0x14, 0xaa, 0xeb, 0x27, 0x82, 0x7b, 0x6a, 0x8f, 0x67, 0x5d,
      0x18, 0x25, 0xda, 0xc7, 0xf4, 0x54, 0x8c, 0xbf, 0x78, 0xa3, 0x7e, 0xb9,
      0x62, 0x1a, 0x29, 0xe9, 0xb1, 0x4c, 0xf6, 0x1f, 0xc6, 0xae, 0x49, 0xe7,
      0xe6, 0xe1, 0x53, 0x50, 0xa4, 0xb9, 0x0a, 0x4a, 0x89, 0x7f, 0xf6, 0x9b,
      0x0c, 0x59, 0xb6, 0x95, 0x08, 0xeb, 0xc7},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x32, 0x30, 0x32, 0x30, 0x34, 0x32, 0x39, 0x36, 0x35, 0x31, 0x39},
     true},

    // Comment: special case hash
    // tcID: 239
    {SEC_OID_SHA512,
     239,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x36, 0x46, 0x84, 0x85, 0x6c, 0x7c, 0x02,
      0xbf, 0xb2, 0xad, 0x2d, 0xe6, 0x03, 0xd1, 0x08, 0x83, 0xca, 0x93, 0xc1,
      0x22, 0xd4, 0xce, 0xbe, 0xf2, 0x76, 0x46, 0x7a, 0x9b, 0x76, 0x20, 0xfb,
      0x53, 0x0e, 0x4d, 0x05, 0xd0, 0x7c, 0x15, 0xab, 0x94, 0x8b, 0x9c, 0xe7,
      0x68, 0x25, 0x61, 0x30, 0x79, 0x13, 0xb6, 0x4e, 0xa6, 0x89, 0x6e, 0xce,
      0x10, 0x95, 0xdc, 0x64, 0x36, 0x9f, 0x1a, 0x9d, 0x5c, 0x0d, 0x02, 0x42,
      0x00, 0x9e, 0x6d, 0xb2, 0xff, 0x96, 0xd9, 0xd7, 0x11, 0x50, 0x44, 0x0f,
      0xd4, 0x49, 0x92, 0x65, 0x6c, 0xa1, 0x18, 0xfc, 0xaf, 0x6b, 0xd0, 0x44,
      0x99, 0x31, 0x4e, 0x8b, 0xa6, 0x1a, 0x55, 0xa8, 0x79, 0x0a, 0xac, 0x02,
      0x3d, 0xdb, 0x68, 0x60, 0x0f, 0xbd, 0x7e, 0xd4, 0xcd, 0x4d, 0xec, 0xb1,
      0x76, 0xe8, 0xbd, 0x78, 0x22, 0xea, 0x31, 0xd7, 0x5a, 0xdc, 0xbd, 0xac,
      0xca, 0xfc, 0xf5, 0x10, 0xc2, 0x6c},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x34, 0x35, 0x31, 0x36, 0x36, 0x39, 0x31, 0x38, 0x30},
     true},

    // Comment: special case hash
    // tcID: 240
    {SEC_OID_SHA512,
     240,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xa3, 0x17, 0xe4, 0x90, 0x14, 0xf1,
      0xbf, 0x3a, 0xfc, 0x09, 0xcc, 0x04, 0x85, 0x31, 0x01, 0x0e, 0x21, 0x44,
      0xb6, 0x62, 0xca, 0xc6, 0x57, 0xe5, 0x1b, 0x32, 0xbb, 0x43, 0x2d, 0x27,
      0x4a, 0x73, 0x0b, 0x53, 0x5f, 0xb2, 0xde, 0x66, 0xfa, 0x8d, 0xdd, 0x26,
      0xfa, 0xa3, 0xf4, 0x6e, 0x00, 0x43, 0x89, 0xd2, 0x55, 0x17, 0xc5, 0x6e,
      0x7d, 0x8a, 0x1d, 0x39, 0x56, 0x3b, 0x0e, 0x8c, 0x9c, 0x21, 0x5b, 0x02,
      0x42, 0x01, 0xad, 0x2e, 0x12, 0x12, 0xe1, 0x68, 0x0b, 0x66, 0x0a, 0x1c,
      0x07, 0xf5, 0x4a, 0xdd, 0xff, 0x57, 0x5c, 0x8c, 0x82, 0x98, 0xe2, 0x6a,
      0x14, 0xc5, 0x16, 0xf5, 0x17, 0xfb, 0x5f, 0x96, 0x6a, 0x2b, 0x38, 0x3a,
      0xa4, 0x6a, 0x48, 0x3f, 0xdb, 0xfa, 0x72, 0x71, 0x1d, 0x60, 0xc0, 0xf6,
      0x7a, 0x2c, 0x03, 0xd6, 0x3d, 0x26, 0x26, 0xff, 0xe2, 0x71, 0xe0, 0xce,
      0x35, 0x3a, 0x4d, 0x4b, 0x09, 0xbd, 0x5e},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x30, 0x39, 0x33, 0x36, 0x38, 0x35, 0x39, 0x35, 0x31},
     true},

    // Comment: special case hash
    // tcID: 241
    {SEC_OID_SHA512,
     241,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xc0, 0x9b, 0x29, 0xfc, 0x4d, 0xa0,
      0x4e, 0x9b, 0x86, 0x09, 0x7b, 0xd6, 0xd6, 0x80, 0x6a, 0xa9, 0x69, 0xce,
      0xb3, 0x7c, 0xe5, 0x2e, 0xea, 0xc5, 0xe9, 0x51, 0x8d, 0x27, 0x54, 0x1c,
      0x3f, 0x30, 0xc0, 0x0f, 0x11, 0x3d, 0x9d, 0xd3, 0xb0, 0x07, 0xda, 0xe6,
      0xf3, 0x81, 0x89, 0x6d, 0x43, 0xfc, 0x6d, 0xdf, 0xb3, 0xfa, 0x25, 0x6a,
      0x36, 0x52, 0x9b, 0x05, 0x4e, 0x41, 0x6e, 0xd6, 0x38, 0x05, 0x99, 0x02,
      0x42, 0x01, 0x13, 0xe5, 0x62, 0x2c, 0xb1, 0xe4, 0xc4, 0xbb, 0x08, 0x42,
      0xf3, 0xd3, 0x96, 0xd7, 0xe6, 0x60, 0x24, 0x11, 0x16, 0xe9, 0x4e, 0x81,
      0x20, 0xa6, 0x02, 0xe3, 0xd2, 0x95, 0x27, 0x01, 0xb1, 0xa1, 0x14, 0x15,
      0xa3, 0xd8, 0xc5, 0x03, 0xad, 0xce, 0xd1, 0x60, 0x45, 0x0f, 0xd1, 0x31,
      0x57, 0xad, 0x14, 0x7d, 0x2d, 0x65, 0xd7, 0x74, 0x49, 0x45, 0x86, 0x59,
      0x35, 0x0e, 0x20, 0xa5, 0x45, 0x60, 0x2e},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x36, 0x32, 0x31, 0x39, 0x35, 0x36, 0x30, 0x32, 0x30, 0x31},
     true},

    // Comment: special case hash
    // tcID: 242
    {SEC_OID_SHA512,
     242,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x78, 0xf4, 0xa2, 0x96, 0x84, 0x60, 0xea,
      0x8f, 0x64, 0xa9, 0x38, 0xb3, 0xa9, 0x7c, 0x91, 0x4e, 0xb0, 0xcc, 0xfa,
      0x94, 0xeb, 0x08, 0x63, 0x6e, 0xfe, 0xe9, 0xd5, 0xad, 0x86, 0x68, 0xce,
      0x1c, 0x90, 0x99, 0x57, 0x3a, 0xbd, 0x14, 0x6d, 0xf9, 0xe7, 0xb2, 0xcc,
      0xaa, 0xa1, 0xa2, 0x5d, 0xe9, 0x03, 0xf8, 0x59, 0x62, 0x84, 0x93, 0x56,
      0xa8, 0x72, 0xe8, 0x8e, 0x54, 0x5b, 0xab, 0xc2, 0x89, 0x74, 0x02, 0x42,
      0x00, 0xf2, 0x72, 0x9e, 0x95, 0x93, 0xc9, 0xfc, 0xdf, 0x59, 0x71, 0xb2,
      0x1e, 0x36, 0x7f, 0xfd, 0xc8, 0x7a, 0xa7, 0x52, 0x03, 0x93, 0x52, 0x7c,
      0x6f, 0x68, 0xab, 0x51, 0x2b, 0x88, 0xb8, 0x39, 0x00, 0x3c, 0x1c, 0x99,
      0x52, 0xb0, 0x4f, 0x2d, 0xc7, 0x40, 0x10, 0xa3, 0x10, 0x71, 0xee, 0x20,
      0xa9, 0xfb, 0x1c, 0x7e, 0x11, 0x87, 0xd0, 0x4d, 0xe7, 0x1b, 0x3f, 0x43,
      0x27, 0xdf, 0x12, 0x8c, 0xcd, 0x43},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x35, 0x36, 0x38, 0x32, 0x34, 0x37, 0x34, 0x33, 0x30, 0x33},
     true},

    // Comment: special case hash
    // tcID: 243
    {SEC_OID_SHA512,
     243,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x01, 0x9f, 0xae, 0xd1, 0x47, 0xa7, 0x6b,
      0x65, 0x77, 0x9d, 0x09, 0x89, 0xe1, 0x30, 0x08, 0x02, 0x84, 0x4c, 0x9b,
      0xa0, 0x9f, 0x33, 0x8c, 0x5e, 0x31, 0xa2, 0x4d, 0x9e, 0xbf, 0x8f, 0x0b,
      0x0b, 0x4c, 0x21, 0xf5, 0x9d, 0x36, 0x9a, 0xc1, 0x0e, 0x31, 0x5f, 0xa2,
      0xb7, 0x60, 0x5b, 0x0f, 0x17, 0xa9, 0xc0, 0x7c, 0xf6, 0xce, 0x4c, 0x83,
      0x83, 0x8e, 0x58, 0x33, 0x3a, 0x33, 0x90, 0x14, 0x2d, 0x79, 0xd0, 0x02,
      0x41, 0x5f, 0x4d, 0xe7, 0x1f, 0xda, 0xce, 0xd1, 0xe8, 0xda, 0x86, 0xef,
      0xd4, 0x7e, 0xcb, 0xda, 0xc6, 0xa6, 0xff, 0xc6, 0xd6, 0x9d, 0xf7, 0x1d,
      0xa7, 0xce, 0xb5, 0x59, 0x64, 0x75, 0xcd, 0xfe, 0xce, 0xa3, 0xd0, 0x0f,
      0x07, 0x4d, 0x2d, 0xe8, 0x9e, 0x0f, 0xcc, 0x05, 0xe3, 0x23, 0x1d, 0x53,
      0x1f, 0x0d, 0x38, 0xf2, 0xb7, 0xc6, 0xfe, 0x4e, 0xcf, 0x67, 0xa0, 0xcd,
      0xdd, 0xc2, 0x1d, 0x08, 0x67, 0xb8},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x33, 0x37, 0x33, 0x36, 0x35, 0x33, 0x31, 0x37, 0x38, 0x36},
     true},

    // Comment: special case hash
    // tcID: 244
    {SEC_OID_SHA512,
     244,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xd0, 0xb1, 0x44, 0x35, 0x0a, 0x21,
      0x28, 0xf0, 0x42, 0xbc, 0x1a, 0x27, 0xf6, 0xc0, 0x21, 0xda, 0xd1, 0xec,
      0x03, 0x1b, 0xe8, 0xf1, 0xd8, 0x30, 0x47, 0x97, 0xf9, 0xdd, 0xcb, 0x74,
      0x29, 0x74, 0xaa, 0xe2, 0x09, 0xf0, 0x14, 0x98, 0x01, 0x74, 0xb9, 0xd4,
      0xe4, 0x34, 0xe3, 0xf5, 0x32, 0x47, 0x88, 0x9d, 0x2d, 0xa4, 0xb7, 0x67,
      0x59, 0x31, 0x79, 0xcb, 0x4e, 0xda, 0x47, 0xe7, 0x99, 0x64, 0x30, 0x02,
      0x42, 0x01, 0x84, 0xd3, 0x41, 0x6d, 0xee, 0x35, 0xba, 0x88, 0x07, 0x70,
      0x3a, 0x91, 0xac, 0x92, 0x70, 0x96, 0xc1, 0x09, 0x59, 0xa0, 0x5c, 0xbf,
      0xfd, 0x81, 0x03, 0xa9, 0x3a, 0x9f, 0x20, 0xa1, 0x15, 0x37, 0xbe, 0xd7,
      0xa6, 0x45, 0xf3, 0x22, 0x95, 0xe4, 0xab, 0xce, 0x49, 0x35, 0x79, 0xca,
      0xa4, 0xe2, 0x24, 0x20, 0x60, 0xcc, 0x4d, 0x58, 0xb2, 0x41, 0x48, 0x70,
      0xe9, 0x8b, 0x93, 0x36, 0x79, 0x57, 0x87},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x34, 0x37, 0x39, 0x35, 0x39, 0x30, 0x33, 0x37, 0x39, 0x32},
     true},

    // Comment: special case hash
    // tcID: 245
    {SEC_OID_SHA512,
     245,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x05, 0x25, 0x7a, 0x0f, 0x45, 0xee, 0x2a,
      0xe5, 0xcc, 0x30, 0x28, 0x3d, 0x23, 0xc4, 0x7c, 0x96, 0xf6, 0xde, 0xaa,
      0x3a, 0xc1, 0x47, 0x3e, 0x8e, 0x8a, 0x40, 0xea, 0xf6, 0x1b, 0xc4, 0xb0,
      0xef, 0x8b, 0xd1, 0x8d, 0x11, 0x98, 0x3f, 0x25, 0x7e, 0xc4, 0xb1, 0xd8,
      0xd0, 0x4e, 0x76, 0xa1, 0x22, 0xb5, 0xbb, 0xe1, 0xd3, 0x10, 0x65, 0x15,
      0x90, 0x72, 0xc5, 0x8f, 0xd9, 0xbc, 0x3e, 0x98, 0x37, 0x68, 0x02, 0x42,
      0x01, 0x22, 0xdb, 0xa5, 0x0d, 0x0e, 0xb7, 0x1b, 0xdb, 0xf0, 0x92, 0xa9,
      0x4a, 0x7e, 0xa2, 0x80, 0x41, 0x29, 0x06, 0xe1, 0xf8, 0x49, 0xe9, 0x1d,
      0xbd, 0x5d, 0x81, 0x58, 0xe3, 0xfc, 0x6c, 0xd1, 0x2e, 0x20, 0x46, 0x1b,
      0x77, 0x65, 0x3e, 0x3d, 0xf2, 0xe4, 0x5b, 0x86, 0x88, 0x3f, 0x81, 0x07,
      0x1b, 0x33, 0x65, 0x1a, 0xe1, 0xb8, 0x4c, 0xc8, 0xe7, 0xc3, 0x65, 0xab,
      0x8d, 0x6a, 0x36, 0xd1, 0xcf, 0xa6},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x39, 0x33, 0x39, 0x39, 0x36, 0x31, 0x31, 0x30, 0x30, 0x37},
     true},

    // Comment: special case hash
    // tcID: 246
    {SEC_OID_SHA512,
     246,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x4f, 0x62, 0x4a, 0xf9, 0xd8, 0x09,
      0x6f, 0xe7, 0xa2, 0x90, 0x65, 0x1d, 0x23, 0xab, 0x26, 0x0d, 0xa6, 0x4e,
      0x44, 0xb8, 0x86, 0xfe, 0xf4, 0xf3, 0x88, 0x1d, 0x0d, 0x98, 0x4d, 0x3b,
      0x38, 0x7f, 0xdd, 0xcf, 0x65, 0xb1, 0xfa, 0x1d, 0xbb, 0x23, 0x90, 0x28,
      0xfb, 0xab, 0x4a, 0x1d, 0xe6, 0xad, 0x15, 0x0c, 0xc8, 0xa4, 0xe4, 0xdb,
      0x0a, 0x97, 0x1b, 0xb8, 0xbc, 0xf0, 0x1c, 0x47, 0x28, 0xff, 0x98, 0x02,
      0x42, 0x01, 0x05, 0xe3, 0xb5, 0x5d, 0xb0, 0x14, 0x1c, 0x06, 0xd9, 0x85,
      0x40, 0x96, 0xcc, 0x0f, 0x73, 0x41, 0x5d, 0xd2, 0xb8, 0x5a, 0x33, 0x1d,
      0xa5, 0x0c, 0xfe, 0xa3, 0xbb, 0xf6, 0x48, 0xbb, 0xf8, 0x65, 0x1f, 0x61,
      0xf2, 0xcd, 0x09, 0x38, 0x6b, 0x62, 0xfb, 0xb8, 0xce, 0x67, 0x24, 0x86,
      0x83, 0xc2, 0x60, 0x89, 0x4d, 0x9e, 0xd5, 0x4d, 0x66, 0x67, 0xae, 0x02,
      0x97, 0x8e, 0x38, 0xab, 0x99, 0x32, 0x0a},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x30, 0x38, 0x37, 0x34, 0x39, 0x31, 0x31, 0x38, 0x35},
     true},

    // Comment: special case hash
    // tcID: 247
    {SEC_OID_SHA512,
     247,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x2c, 0x95, 0x2d, 0x7e, 0x61, 0xe1, 0x09,
      0x7c, 0xd7, 0xf7, 0x09, 0xe6, 0x2e, 0xc4, 0x86, 0x87, 0x9b, 0x38, 0x0b,
      0x63, 0x79, 0x1c, 0x14, 0x6b, 0x54, 0x5c, 0x06, 0x4e, 0x65, 0xb3, 0x06,
      0x02, 0x50, 0xd0, 0x0a, 0xf2, 0x79, 0xcf, 0x15, 0xea, 0xde, 0x67, 0x38,
      0x4b, 0x28, 0x59, 0x4d, 0xb5, 0x42, 0x84, 0x5f, 0xcc, 0x65, 0x74, 0xef,
      0x5d, 0x8d, 0x5b, 0xb8, 0xa1, 0x62, 0xe0, 0x35, 0x0a, 0x00, 0x02, 0x42,
      0x01, 0x35, 0xac, 0x6d, 0x1c, 0xc0, 0x5b, 0x09, 0x5f, 0xba, 0xe2, 0x8b,
      0x65, 0x2f, 0xe5, 0x38, 0x6b, 0x86, 0x89, 0xe2, 0x1a, 0x14, 0x99, 0x02,
      0x36, 0xd3, 0xad, 0xa7, 0xce, 0xeb, 0x0c, 0x12, 0xa4, 0xf7, 0x74, 0xbf,
      0xf7, 0xb8, 0x1c, 0x8d, 0x07, 0x57, 0x2b, 0x0c, 0x79, 0x85, 0x36, 0x4c,
      0x5d, 0x31, 0xf3, 0x32, 0x71, 0xf0, 0xac, 0x3a, 0x2a, 0xfb, 0x88, 0xb4,
      0x6b, 0xfe, 0xef, 0xba, 0xea, 0xa8},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x33, 0x32, 0x33, 0x36, 0x36, 0x37, 0x38, 0x35, 0x30, 0x30},
     true},

    // Comment: special case hash
    // tcID: 248
    {SEC_OID_SHA512,
     248,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x79, 0x19, 0xef, 0xf7, 0x82, 0x25,
      0xe1, 0x93, 0x7a, 0x92, 0x1f, 0x98, 0xf5, 0xd1, 0x53, 0xcb, 0xff, 0xa0,
      0x39, 0x29, 0x81, 0x9f, 0x22, 0x8e, 0xe0, 0x13, 0xf8, 0xe5, 0x95, 0x49,
      0xb0, 0x4b, 0x98, 0x67, 0x00, 0x6a, 0x8d, 0xf2, 0x5a, 0x93, 0xa6, 0xa2,
      0x5d, 0xd1, 0xd3, 0xf5, 0x40, 0x23, 0x9a, 0x8e, 0xd1, 0x40, 0x47, 0xea,
      0x00, 0x81, 0x1d, 0xa9, 0x30, 0x5e, 0xc5, 0x15, 0xad, 0x00, 0x0d, 0x02,
      0x42, 0x01, 0x1f, 0xb8, 0x73, 0xbd, 0xae, 0x17, 0x57, 0x80, 0x1e, 0x57,
      0x5c, 0x5d, 0xf6, 0x2c, 0xf8, 0x2a, 0x18, 0x81, 0xaf, 0x3c, 0xd6, 0xed,
      0x17, 0xdc, 0x50, 0xed, 0xbe, 0x6c, 0x5f, 0xd0, 0xf4, 0xd3, 0x17, 0x66,
      0x67, 0x0b, 0x2a, 0xa5, 0x72, 0xa9, 0xe6, 0x54, 0x7b, 0x36, 0x14, 0x2a,
      0xfa, 0x84, 0x64, 0xd0, 0xbe, 0x4b, 0xf4, 0x19, 0x30, 0x62, 0x9d, 0xc0,
      0x4c, 0x85, 0xe0, 0x1b, 0x2e, 0xe8, 0xe2},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x34, 0x34, 0x38, 0x39, 0x39, 0x37, 0x37, 0x30, 0x33},
     true},

    // Comment: special case hash
    // tcID: 249
    {SEC_OID_SHA512,
     249,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x6a, 0xc9, 0xb3, 0x70, 0x06, 0x7b, 0x13,
      0xac, 0x2b, 0x57, 0xf3, 0x5d, 0x6d, 0x9b, 0x1f, 0xaa, 0x93, 0xb9, 0xb0,
      0x68, 0xef, 0x5d, 0xdf, 0x8b, 0xde, 0x3a, 0x54, 0x02, 0x48, 0x10, 0xaa,
      0x22, 0x26, 0x56, 0x00, 0x65, 0xb0, 0xcb, 0x75, 0x01, 0xdf, 0x96, 0xb4,
      0x75, 0x6c, 0xe1, 0xe1, 0xfa, 0x60, 0x7f, 0x86, 0xa9, 0x42, 0x36, 0x78,
      0x94, 0xa1, 0xf7, 0x72, 0x8b, 0xd5, 0xf2, 0x2c, 0xf1, 0x77, 0x02, 0x42,
      0x00, 0x8b, 0x47, 0xa9, 0xe1, 0x37, 0x0c, 0x9f, 0x5b, 0xf4, 0x67, 0x7d,
      0x55, 0x4c, 0x00, 0xe9, 0xac, 0x3e, 0xa7, 0xcd, 0xfc, 0x78, 0x83, 0x6a,
      0xc5, 0x3a, 0xc7, 0x10, 0xb7, 0xf3, 0xbf, 0xf8, 0xc2, 0x29, 0x77, 0x80,
      0xc6, 0x9a, 0x9f, 0xdd, 0xb8, 0x0e, 0x03, 0xa6, 0x05, 0xe5, 0xe4, 0x8a,
      0x52, 0xe5, 0x2f, 0xd3, 0x5f, 0x41, 0x66, 0x8c, 0xd9, 0x06, 0x48, 0x86,
      0x36, 0x6f, 0xda, 0x20, 0x60, 0x86},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x35, 0x37, 0x31, 0x34, 0x36, 0x33, 0x32, 0x38, 0x30, 0x37},
     true},

    // Comment: special case hash
    // tcID: 250
    {SEC_OID_SHA512,
     250,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x00, 0xc4, 0xbc, 0xff, 0xf2, 0x65, 0xcd,
      0x32, 0x44, 0x22, 0x20, 0x97, 0x6f, 0xfc, 0x7e, 0x4e, 0xc0, 0x91, 0x81,
      0xd6, 0x94, 0x69, 0x6e, 0xb8, 0x9a, 0xf0, 0xcb, 0x2d, 0x5a, 0x2d, 0xfc,
      0x38, 0x76, 0xde, 0xb3, 0xc6, 0xad, 0xea, 0x16, 0x89, 0x65, 0x20, 0x0c,
      0x35, 0x5c, 0x3b, 0xff, 0x5e, 0x47, 0xab, 0x17, 0xec, 0xc4, 0x4c, 0x84,
      0x34, 0x33, 0x32, 0x80, 0x79, 0x6d, 0x3a, 0x18, 0x34, 0x49, 0xea, 0x02,
      0x41, 0x62, 0xde, 0xbe, 0x91, 0x55, 0x0f, 0x8a, 0x76, 0x0e, 0xae, 0xa3,
      0x09, 0xf4, 0x84, 0x83, 0xc6, 0x5a, 0x52, 0xc7, 0xe8, 0x8a, 0x83, 0x86,
      0x7c, 0x31, 0x73, 0x0c, 0xbc, 0x6b, 0x0a, 0x64, 0xd4, 0xc5, 0x64, 0xbd,
      0xe6, 0x7e, 0x65, 0x39, 0xaf, 0x78, 0x7e, 0xcf, 0xd1, 0x80, 0x16, 0xcd,
      0xe4, 0x6d, 0xdf, 0x91, 0x74, 0x0f, 0x58, 0xf6, 0xea, 0x6e, 0xc8, 0x0b,
      0x17, 0x3f, 0xd1, 0xc4, 0x7a, 0xd0},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x32, 0x32, 0x36, 0x34, 0x38, 0x37, 0x34, 0x39, 0x32},
     true},

    // Comment: special case hash
    // tcID: 251
    {SEC_OID_SHA512,
     251,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x74, 0xd7, 0x44, 0xdd, 0xc6, 0x31,
      0xfc, 0xf8, 0x20, 0x2f, 0xca, 0x0a, 0xb1, 0x0f, 0x6d, 0x96, 0xd3, 0xf7,
      0x55, 0x2b, 0xb2, 0xa9, 0xae, 0x5a, 0xc5, 0x73, 0x63, 0x41, 0x33, 0xf6,
      0x1c, 0x59, 0xa1, 0x20, 0xfe, 0xdb, 0xc3, 0x9c, 0xfb, 0x52, 0x1a, 0xb0,
      0xcd, 0x57, 0x2a, 0xfb, 0xd5, 0x14, 0x79, 0x81, 0x09, 0x0d, 0x1d, 0xcb,
      0xfe, 0x90, 0x2e, 0x03, 0xf0, 0xc0, 0x57, 0x99, 0x67, 0xb5, 0x81, 0x02,
      0x42, 0x01, 0x2f, 0x59, 0xca, 0x92, 0x7c, 0x4a, 0xe3, 0x31, 0xd2, 0xf6,
      0x67, 0xfc, 0xd9, 0xec, 0x01, 0xb0, 0xb5, 0x51, 0x4e, 0x2a, 0xb5, 0xda,
      0x05, 0x61, 0xea, 0x61, 0x44, 0x31, 0xdc, 0x1f, 0xcb, 0x76, 0x1c, 0x35,
      0x1c, 0xd1, 0x21, 0x10, 0x92, 0x72, 0x0e, 0xbb, 0x70, 0x74, 0xa5, 0x12,
      0x8f, 0x80, 0x19, 0xb7, 0xc1, 0x8e, 0x04, 0x8d, 0x5e, 0xd3, 0x57, 0x3e,
      0xd6, 0x16, 0x86, 0xe9, 0x71, 0x3f, 0x72},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x35, 0x33, 0x35, 0x33, 0x34, 0x34, 0x39, 0x34, 0x37, 0x39},
     true},

    // Comment: special case hash
    // tcID: 252
    {SEC_OID_SHA512,
     252,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x9a, 0x51, 0x3c, 0xfa, 0xf8, 0x71,
      0x28, 0x73, 0x40, 0xd8, 0xa5, 0x1d, 0x2f, 0x43, 0x48, 0xab, 0x40, 0x96,
      0xc5, 0xfe, 0x24, 0x4b, 0x22, 0xad, 0xd3, 0x8c, 0xe4, 0x33, 0xe3, 0x17,
      0x8e, 0x8f, 0xf5, 0xb2, 0xdf, 0x0f, 0xe7, 0x4a, 0x1b, 0xa4, 0x0f, 0xe8,
      0x34, 0x1f, 0x73, 0x4c, 0x71, 0xf9, 0xa1, 0x17, 0x7b, 0x41, 0x03, 0x57,
      0x77, 0xe2, 0xda, 0x6b, 0x08, 0x2e, 0x0b, 0x56, 0x66, 0x90, 0xde, 0x02,
      0x42, 0x00, 0xd0, 0xc4, 0x3e, 0xb3, 0x3a, 0x81, 0x7c, 0x3a, 0xab, 0x30,
      0x28, 0x1c, 0x59, 0x3c, 0x74, 0x51, 0x7e, 0xe8, 0x4e, 0x95, 0x8b, 0x11,
      0x43, 0x95, 0xce, 0x0b, 0x31, 0xfc, 0xf3, 0x0b, 0xb8, 0xf5, 0xdf, 0xe6,
      0x0d, 0xbc, 0x7f, 0x6f, 0x14, 0x69, 0x89, 0x77, 0xd8, 0xe0, 0x51, 0x6a,
      0x92, 0x74, 0xa5, 0xbd, 0x71, 0x84, 0x70, 0x57, 0xe0, 0x06, 0xfa, 0x31,
      0x5f, 0xae, 0x69, 0x22, 0xea, 0xaa, 0x55},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x34, 0x37, 0x38, 0x37, 0x33, 0x30, 0x33, 0x38, 0x38, 0x30},
     true},

    // Comment: special case hash
    // tcID: 253
    {SEC_OID_SHA512,
     253,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x01, 0x32, 0x04, 0x80, 0x0e, 0xfc, 0xb4,
      0x0a, 0xb0, 0x9a, 0xe4, 0x13, 0x73, 0x25, 0xa3, 0xe8, 0xc4, 0x68, 0xed,
      0xae, 0x91, 0x88, 0x0a, 0x51, 0x61, 0x6b, 0xa6, 0x1f, 0x3e, 0xf1, 0xf7,
      0x2f, 0xd8, 0x9f, 0xeb, 0x95, 0x6b, 0xfb, 0x39, 0x81, 0x8d, 0x82, 0x74,
      0x68, 0xbb, 0x44, 0x75, 0x11, 0x0a, 0x04, 0x77, 0x9f, 0xd6, 0xbb, 0x3d,
      0xef, 0x25, 0xc6, 0x1c, 0x4b, 0xa6, 0x08, 0x89, 0xed, 0x0f, 0xf7, 0x02,
      0x41, 0x70, 0x4b, 0x73, 0x94, 0x68, 0x76, 0x98, 0xc8, 0x84, 0x1f, 0x48,
      0x75, 0xd4, 0x0e, 0x5b, 0x3c, 0x91, 0x4f, 0x15, 0x4c, 0xcb, 0x2b, 0x54,
      0x46, 0x6a, 0xe1, 0x63, 0xed, 0x34, 0x10, 0xf2, 0x0d, 0x0a, 0x07, 0xac,
      0x5f, 0x90, 0xc0, 0xc3, 0x12, 0x71, 0xec, 0x8a, 0x52, 0x4c, 0xa2, 0xda,
      0xe4, 0xb8, 0xbc, 0x4f, 0x6e, 0x1e, 0xce, 0x17, 0x3e, 0xa9, 0x07, 0x89,
      0x06, 0x93, 0xc5, 0xf2, 0x19, 0x0c},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x32, 0x32, 0x33, 0x32, 0x31, 0x39, 0x35, 0x38, 0x32, 0x33},
     true},

    // Comment: special case hash
    // tcID: 254
    {SEC_OID_SHA512,
     254,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x80, 0x24, 0x1c, 0xd2, 0xe6, 0x16,
      0x31, 0x58, 0xa3, 0x95, 0x99, 0x89, 0x0d, 0xab, 0xee, 0x99, 0xc2, 0xc8,
      0x6b, 0x88, 0xac, 0xcd, 0x2b, 0x04, 0xb5, 0xa7, 0x28, 0x74, 0xfb, 0xdf,
      0xbd, 0xe0, 0xd1, 0x81, 0x43, 0xc4, 0xd7, 0x8e, 0x0d, 0xa1, 0xab, 0xf3,
      0x79, 0x6b, 0x23, 0x87, 0x38, 0x84, 0x0d, 0x60, 0xe3, 0x47, 0x75, 0xa8,
      0xff, 0x81, 0x0d, 0x58, 0xa9, 0xbb, 0x35, 0x59, 0xa3, 0x99, 0x7c, 0x02,
      0x42, 0x00, 0xbc, 0x39, 0x6c, 0x2e, 0xf2, 0x8b, 0x24, 0x4f, 0xb8, 0xe0,
      0x04, 0xbf, 0x53, 0x61, 0x57, 0x2b, 0xa1, 0xfe, 0xf6, 0xfb, 0xe0, 0x81,
      0xed, 0x1d, 0xed, 0xba, 0x4d, 0x9a, 0xf7, 0x8d, 0xee, 0xe1, 0x26, 0x59,
      0x9f, 0x75, 0xa0, 0xa9, 0xd0, 0xf1, 0xb1, 0x61, 0x8d, 0xed, 0x7a, 0x0c,
      0x5e, 0x67, 0x2e, 0x40, 0x91, 0x7f, 0xdd, 0x30, 0x58, 0x24, 0x60, 0xda,
      0x3a, 0xeb, 0x1e, 0x9c, 0x44, 0x77, 0xd7},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x30, 0x37, 0x33, 0x39, 0x33, 0x39, 0x31, 0x39, 0x31, 0x37},
     true},

    // Comment: special case hash
    // tcID: 255
    {SEC_OID_SHA512,
     255,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x48, 0x5f, 0xc0, 0x3f, 0xcd, 0x62,
      0x9f, 0xd4, 0xc5, 0x64, 0x77, 0x5a, 0xb6, 0x96, 0x9b, 0xbc, 0x69, 0x6b,
      0x5b, 0x0f, 0x38, 0x14, 0x1b, 0x69, 0xf8, 0x6e, 0x05, 0x2e, 0x7f, 0xe8,
      0x84, 0x9a, 0x64, 0xaf, 0x2d, 0xd3, 0x7a, 0x2a, 0xdf, 0x64, 0x67, 0x2f,
      0x20, 0xbd, 0x6f, 0x97, 0xcd, 0x32, 0xf0, 0xef, 0xea, 0x51, 0xaa, 0x22,
      0x06, 0x4c, 0x5f, 0x10, 0xa3, 0x91, 0x11, 0x77, 0xe1, 0x97, 0x9d, 0x02,
      0x42, 0x01, 0x80, 0xfa, 0xb4, 0x73, 0xff, 0x9d, 0x72, 0x6d, 0xb6, 0xd2,
      0x66, 0x54, 0x1a, 0x0b, 0xdd, 0xff, 0x86, 0x10, 0xe4, 0x02, 0x6d, 0x26,
      0xb6, 0xc9, 0xab, 0xf9, 0x72, 0xea, 0xef, 0x47, 0x7d, 0x50, 0x67, 0x0b,
      0xdd, 0x30, 0x67, 0xc9, 0xd7, 0x11, 0xa8, 0x34, 0x6e, 0x16, 0x86, 0x91,
      0x47, 0x75, 0x1e, 0x89, 0xb4, 0xea, 0x75, 0xbb, 0x00, 0xec, 0xe7, 0x13,
      0x00, 0xcc, 0x3b, 0x80, 0xcf, 0x88, 0x99},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x38, 0x38, 0x31, 0x30, 0x32, 0x37, 0x33, 0x31, 0x35},
     true},

    // Comment: special case hash
    // tcID: 256
    {SEC_OID_SHA512,
     256,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xbe, 0xa4, 0x9b, 0x15, 0x0a, 0x27,
      0x02, 0x6f, 0xdf, 0x84, 0x82, 0x97, 0xb0, 0x49, 0x10, 0x19, 0xf7, 0x6a,
      0xbf, 0x90, 0xf3, 0xe6, 0xd7, 0x82, 0xe3, 0xd3, 0xfa, 0x6c, 0xad, 0xdb,
      0x81, 0xb7, 0xef, 0x58, 0xb2, 0x7f, 0x1b, 0x2b, 0x3f, 0x78, 0x98, 0x88,
      0x9b, 0x4e, 0x2b, 0x6c, 0xdd, 0xa7, 0xb5, 0x63, 0x61, 0x77, 0xa2, 0x7e,
      0xb9, 0xa6, 0x7b, 0x20, 0x55, 0xb6, 0xf2, 0x1d, 0x26, 0x2c, 0x26, 0x02,
      0x42, 0x00, 0xdf, 0xfb, 0x13, 0xc2, 0xd5, 0xf7, 0x46, 0xc8, 0x57, 0x3a,
      0xa4, 0x44, 0xaf, 0xc8, 0xba, 0xf8, 0xbf, 0x88, 0x1c, 0xc4, 0xd0, 0xfc,
      0xa8, 0x16, 0x9f, 0x6c, 0xb3, 0x04, 0xf4, 0x00, 0xeb, 0x39, 0x32, 0x66,
      0x6c, 0xd3, 0x75, 0x8c, 0x43, 0x7c, 0x9c, 0xad, 0x79, 0xab, 0xfd, 0x89,
      0xc7, 0x2a, 0x78, 0x85, 0x05, 0x76, 0x3a, 0xab, 0xdf, 0xab, 0xf8, 0x90,
      0x3a, 0xd4, 0xa7, 0x0d, 0x9e, 0xc9, 0xf7},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x36, 0x30, 0x36, 0x31, 0x36, 0x39, 0x33, 0x39, 0x30, 0x37},
     true},

    // Comment: special case hash
    // tcID: 257
    {SEC_OID_SHA512,
     257,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x01, 0xd5, 0x6b, 0xf6, 0xf3, 0x75, 0x8f,
      0x62, 0x7f, 0x47, 0x07, 0x06, 0xd1, 0xd2, 0x8c, 0x28, 0xfb, 0xfc, 0xad,
      0x6d, 0xc3, 0x04, 0x65, 0xcb, 0x28, 0x5a, 0x27, 0x4f, 0xc0, 0x57, 0xf7,
      0x91, 0xde, 0x73, 0xac, 0x30, 0xba, 0xcc, 0xde, 0x04, 0x44, 0x73, 0xfa,
      0x9e, 0x3d, 0xce, 0x6d, 0x39, 0x5e, 0xad, 0xf9, 0x8d, 0x1f, 0x97, 0x25,
      0x9b, 0xd8, 0x51, 0xa1, 0xeb, 0x6f, 0x3d, 0x31, 0xd2, 0xd7, 0x56, 0x02,
      0x41, 0x33, 0x70, 0x4b, 0x4a, 0xd3, 0x73, 0x00, 0xa9, 0x66, 0x82, 0x56,
      0x9f, 0x4f, 0x7f, 0xea, 0x3e, 0x14, 0xd6, 0xe1, 0xf6, 0x58, 0x64, 0x66,
      0x3f, 0x39, 0xaa, 0x67, 0xf4, 0x0b, 0x5c, 0x94, 0x9f, 0x19, 0x8d, 0x5d,
      0xe9, 0xf2, 0xac, 0x23, 0x69, 0xbb, 0xb9, 0x11, 0x1c, 0x89, 0xb3, 0x93,
      0x19, 0x95, 0x37, 0xc6, 0xc0, 0x8e, 0xd7, 0xc0, 0x27, 0x09, 0xc7, 0x33,
      0xef, 0x76, 0x60, 0x11, 0x3d, 0x53},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x38, 0x38, 0x39, 0x35, 0x32, 0x32, 0x37, 0x30, 0x39, 0x34},
     true},

    // Comment: special case hash
    // tcID: 258
    {SEC_OID_SHA512,
     258,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x55, 0x40, 0x35, 0xba, 0x84, 0xb0,
      0x51, 0xd5, 0x09, 0x01, 0xc6, 0x22, 0xb9, 0x8b, 0xe4, 0xde, 0x01, 0x23,
      0xa0, 0x29, 0x28, 0xdf, 0xfa, 0x7e, 0xb1, 0x3b, 0x04, 0x03, 0xfd, 0x5e,
      0x25, 0x5f, 0x22, 0x65, 0x05, 0xe1, 0x56, 0x94, 0x95, 0x6a, 0x66, 0xa8,
      0x78, 0xff, 0x58, 0x11, 0x73, 0xd1, 0x23, 0xd1, 0xb2, 0x4e, 0xaa, 0x85,
      0xc5, 0xfe, 0x46, 0xd8, 0x97, 0x3a, 0x55, 0x04, 0x0f, 0xf4, 0x05, 0x02,
      0x42, 0x01, 0xb0, 0x16, 0xdd, 0x6b, 0x51, 0x76, 0xad, 0x83, 0x47, 0xeb,
      0x98, 0x02, 0xdd, 0x77, 0x27, 0xe0, 0x6a, 0x29, 0xdb, 0x33, 0xcc, 0x94,
      0x6f, 0x80, 0x9a, 0x42, 0xf9, 0x19, 0x30, 0x40, 0x69, 0x2b, 0x0f, 0x82,
      0xeb, 0xbd, 0x04, 0xef, 0xf9, 0xf0, 0x99, 0xb7, 0xf7, 0x5f, 0x8e, 0x45,
      0xe7, 0x4a, 0xc0, 0x0a, 0x51, 0xa9, 0xcd, 0x4f, 0x2c, 0xbf, 0x5f, 0x03,
      0xf4, 0xd2, 0xbe, 0xe9, 0x9c, 0x24, 0xeb},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x35, 0x38, 0x30, 0x32, 0x33, 0x34, 0x30, 0x39, 0x34},
     true},

    // Comment: special case hash
    // tcID: 259
    {SEC_OID_SHA512,
     259,
     {0x30, 0x81, 0x86, 0x02, 0x41, 0x29, 0x3e, 0x8d, 0x67, 0x75, 0xf3, 0xc1,
      0x41, 0x83, 0xae, 0xcc, 0x22, 0xf6, 0x08, 0xe9, 0x01, 0x3d, 0x7b, 0x15,
      0xda, 0xd1, 0x67, 0xbb, 0x38, 0xa1, 0xdf, 0xef, 0x6b, 0x37, 0x36, 0x19,
      0xf1, 0xba, 0x27, 0x51, 0xd7, 0x7b, 0x43, 0xf6, 0x43, 0xf6, 0x86, 0x43,
      0xcf, 0xdb, 0x5c, 0x04, 0xa8, 0xed, 0x85, 0x8b, 0xfc, 0xf3, 0x85, 0x8a,
      0x68, 0x1a, 0xe9, 0x3b, 0xfc, 0x7c, 0xd7, 0xe3, 0x14, 0x38, 0x02, 0x41,
      0x2c, 0x7d, 0x96, 0xdb, 0x7d, 0xbb, 0xe3, 0x47, 0xba, 0xb9, 0xf6, 0xf7,
      0xb8, 0x8f, 0x48, 0xcb, 0x32, 0xab, 0x96, 0x32, 0x48, 0x73, 0x7d, 0x2c,
      0x90, 0x1b, 0x90, 0xd6, 0x45, 0x91, 0xcb, 0xdb, 0x0f, 0x0c, 0xa7, 0xa1,
      0x45, 0x57, 0xf8, 0xa5, 0x0f, 0xd8, 0x0d, 0x40, 0x2f, 0x92, 0x9d, 0xad,
      0x14, 0x11, 0x41, 0xf1, 0xf0, 0xc8, 0x5d, 0x94, 0x14, 0xb3, 0x2d, 0x1f,
      0xd4, 0xd7, 0x96, 0xe6, 0xe7},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x33, 0x39, 0x36, 0x35, 0x39, 0x39, 0x31, 0x35, 0x31, 0x32},
     true},

    // Comment: special case hash
    // tcID: 260
    {SEC_OID_SHA512,
     260,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xb1, 0x6a, 0x9b, 0x3a, 0xce, 0xec,
      0xe8, 0x59, 0x08, 0x12, 0x5f, 0x96, 0xf6, 0xcb, 0x6b, 0x1a, 0xfd, 0x0e,
      0xf0, 0x41, 0x71, 0x93, 0x6b, 0x37, 0x66, 0xf8, 0xe4, 0x3b, 0xeb, 0x34,
      0x0d, 0x38, 0x20, 0x84, 0xb3, 0x34, 0x39, 0xf7, 0x75, 0xa2, 0x9a, 0x83,
      0x94, 0x5d, 0xa8, 0xef, 0xc4, 0x19, 0x0d, 0xb1, 0x34, 0x3e, 0x87, 0xd8,
      0xc0, 0xff, 0xb9, 0x7a, 0xeb, 0x3b, 0xe1, 0x59, 0xd9, 0x0f, 0x59, 0x02,
      0x42, 0x00, 0xe5, 0xc2, 0xbb, 0xd9, 0x8e, 0x44, 0x9b, 0xd0, 0xbb, 0x4f,
      0x75, 0xa0, 0x7f, 0x1a, 0x88, 0xdd, 0x63, 0xc0, 0x60, 0x2a, 0x76, 0x60,
      0xf4, 0xac, 0xd3, 0x39, 0x37, 0xc4, 0x91, 0x3a, 0x9c, 0x16, 0xba, 0x44,
      0xdc, 0x58, 0x08, 0x89, 0x2e, 0xc8, 0x8a, 0x42, 0x55, 0x10, 0x9a, 0x7b,
      0xc5, 0xb2, 0x21, 0xc0, 0x7e, 0x6a, 0x27, 0x88, 0x88, 0xa9, 0x71, 0x2f,
      0xc2, 0xa2, 0x5b, 0x37, 0x44, 0x27, 0xe3},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x32, 0x32, 0x38, 0x38, 0x37, 0x33, 0x32, 0x31, 0x39, 0x38},
     true},

    // Comment: special case hash
    // tcID: 261
    {SEC_OID_SHA512,
     261,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x3b, 0x47, 0xa8, 0xed, 0x52, 0xf5, 0xb0,
      0x56, 0x63, 0x65, 0x31, 0x35, 0x20, 0xbc, 0x0b, 0x6e, 0x4e, 0x4e, 0xfb,
      0x3e, 0xa4, 0x17, 0x6e, 0xd7, 0xa3, 0x52, 0xc4, 0xb2, 0xf8, 0xbf, 0xfb,
      0xdb, 0x01, 0x48, 0xff, 0x44, 0xf3, 0xf1, 0x3d, 0x9e, 0x5e, 0x31, 0xb1,
      0xcd, 0xea, 0xe0, 0x97, 0x57, 0x4a, 0xad, 0x8b, 0xf3, 0x93, 0xc5, 0x4a,
      0x5c, 0x84, 0x2e, 0x74, 0x9e, 0xe8, 0x7a, 0x74, 0xc6, 0xb0, 0x02, 0x42,
      0x01, 0xd3, 0xf4, 0x84, 0xe9, 0xe2, 0x24, 0xbd, 0xa9, 0xc8, 0xf1, 0x0f,
      0xbb, 0x74, 0xbb, 0xb6, 0x2d, 0x7a, 0x18, 0x24, 0x57, 0x07, 0xf4, 0xeb,
      0x52, 0xf1, 0x7d, 0xde, 0x79, 0x38, 0x92, 0xc1, 0x6e, 0x4b, 0xdf, 0x50,
      0x49, 0x60, 0xfb, 0xa5, 0x5d, 0xa4, 0x87, 0xf5, 0x42, 0xd4, 0x12, 0xb1,
      0xb8, 0x33, 0xf6, 0xf4, 0x63, 0x36, 0x11, 0x86, 0x18, 0xfc, 0xff, 0x69,
      0x46, 0x9c, 0x83, 0x96, 0x37, 0x77},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x32, 0x32, 0x33, 0x30, 0x38, 0x38, 0x37, 0x33, 0x31, 0x39},
     true},

    // Comment: special case hash
    // tcID: 262
    {SEC_OID_SHA512,
     262,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x28, 0xb8, 0x98, 0x8b, 0xfe, 0x92,
      0x87, 0xf8, 0x2a, 0xc9, 0x7b, 0xe5, 0x07, 0xa5, 0x44, 0xb8, 0x23, 0xe8,
      0x5c, 0xc2, 0x81, 0x3b, 0x69, 0x29, 0xe6, 0x36, 0x99, 0xcf, 0xf8, 0x5a,
      0x40, 0x28, 0x30, 0x76, 0x02, 0x8e, 0x7b, 0xf8, 0xd2, 0x43, 0x30, 0xf8,
      0x9a, 0xdb, 0x96, 0xbf, 0x24, 0xa4, 0xe1, 0x83, 0xa8, 0x98, 0xe6, 0x79,
      0xb3, 0x67, 0x68, 0x90, 0x95, 0x74, 0xe7, 0xd4, 0x73, 0x3d, 0x61, 0x02,
      0x42, 0x00, 0xc1, 0x8a, 0xae, 0x44, 0xe6, 0x80, 0x1f, 0xc2, 0xe3, 0xd9,
      0xc7, 0xa2, 0x0f, 0xf9, 0xd4, 0x2b, 0x46, 0xe4, 0xa3, 0x1c, 0xa3, 0x77,
      0x72, 0xf8, 0xc4, 0x6c, 0xe6, 0x52, 0x19, 0xb1, 0x95, 0xca, 0x23, 0x71,
      0x7f, 0x81, 0x6e, 0x1f, 0xed, 0x51, 0xe5, 0xb6, 0xf9, 0xa0, 0xca, 0x12,
      0xc3, 0xcf, 0x81, 0xae, 0x7f, 0xc9, 0xcc, 0x69, 0x46, 0xa8, 0x83, 0x30,
      0xb2, 0x01, 0x1d, 0xdd, 0x16, 0x09, 0x30},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x39, 0x30, 0x35, 0x36, 0x39, 0x33, 0x37},
     true},

    // Comment: special case hash
    // tcID: 263
    {SEC_OID_SHA512,
     263,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x01, 0x5e, 0xdf, 0x1f, 0xa9, 0x5b, 0x17,
      0x15, 0x9f, 0x76, 0x2d, 0x68, 0xc1, 0x73, 0x61, 0x01, 0x30, 0x9e, 0x80,
      0xfe, 0x5b, 0x2c, 0x44, 0x15, 0x60, 0x9a, 0x5a, 0xc0, 0x83, 0x7f, 0xe5,
      0x90, 0x1f, 0x3c, 0x2d, 0x3d, 0x82, 0x6a, 0x43, 0xb1, 0xf8, 0xcd, 0x1b,
      0xab, 0xf4, 0x94, 0xff, 0xd9, 0x6c, 0xca, 0x12, 0x67, 0x95, 0x01, 0x88,
      0xa9, 0x24, 0xd4, 0xe1, 0xbf, 0x7f, 0x68, 0x18, 0x9f, 0x27, 0xd3, 0x02,
      0x41, 0x2e, 0x86, 0x97, 0xef, 0xbb, 0xf5, 0x3a, 0xdb, 0x7c, 0xb1, 0xb9,
      0x04, 0x71, 0x8f, 0xc7, 0x1e, 0xb2, 0x56, 0x1f, 0x33, 0x1c, 0x20, 0x9c,
      0x50, 0x84, 0x8b, 0x5b, 0xc5, 0x0b, 0xef, 0x77, 0xc5, 0xc3, 0x48, 0x7d,
      0x28, 0x5b, 0xfa, 0xa3, 0xca, 0xa1, 0x40, 0x25, 0xcb, 0xb7, 0x1b, 0xdb,
      0xae, 0xa6, 0x91, 0x1e, 0x36, 0x10, 0x33, 0x56, 0x41, 0xd2, 0x79, 0x9c,
      0x3f, 0xd7, 0x50, 0x19, 0xf7, 0x16},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x32, 0x37, 0x34, 0x38, 0x36, 0x35, 0x36, 0x34, 0x33, 0x38},
     true},

    // Comment: special case hash
    // tcID: 264
    {SEC_OID_SHA512,
     264,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x61, 0xf6, 0x4b, 0xbe, 0x93, 0xfd,
      0xc0, 0xe6, 0x11, 0x34, 0xcf, 0xd4, 0xc4, 0x53, 0xab, 0x74, 0x02, 0x33,
      0xb4, 0x36, 0x17, 0x93, 0x51, 0xaa, 0x68, 0xa3, 0xe3, 0x8a, 0x83, 0x40,
      0x0d, 0x86, 0xff, 0x46, 0x4d, 0x7c, 0xeb, 0x7a, 0x51, 0xf5, 0x41, 0xb8,
      0x6e, 0xb2, 0xf1, 0x2e, 0x32, 0xa8, 0x79, 0xb3, 0xa2, 0x9b, 0xcb, 0x92,
      0xe0, 0x8c, 0xd5, 0x0e, 0x74, 0xf8, 0x6a, 0x0e, 0xd5, 0x2a, 0xe9, 0x02,
      0x42, 0x00, 0x8f, 0x6f, 0xef, 0x49, 0xba, 0x12, 0xce, 0xd6, 0x69, 0x6f,
      0x4f, 0x6d, 0x24, 0xe6, 0xc6, 0x80, 0x57, 0xa8, 0x44, 0x96, 0xd4, 0x2e,
      0xed, 0xe6, 0x30, 0x19, 0x9e, 0x9b, 0xd0, 0x6d, 0x91, 0x36, 0x35, 0x42,
      0xa9, 0x77, 0x6b, 0xfc, 0xd6, 0xd7, 0x7f, 0xba, 0xe4, 0x22, 0xe8, 0x0f,
      0xe4, 0x66, 0xed, 0xd2, 0xc2, 0xc5, 0xe1, 0xf5, 0xcc, 0x79, 0xbe, 0xdd,
      0x1a, 0x7b, 0xec, 0xc1, 0xa1, 0x26, 0x60},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x37, 0x35, 0x38, 0x33, 0x35, 0x30, 0x32, 0x36, 0x30, 0x34},
     true},

    // Comment: special case hash
    // tcID: 265
    {SEC_OID_SHA512,
     265,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x01, 0x3a, 0x6f, 0xac, 0xcc, 0x1c, 0x06,
      0xcb, 0x5d, 0xad, 0xb2, 0xcf, 0x08, 0x3c, 0xb9, 0x4a, 0x71, 0x81, 0xfd,
      0x5c, 0xbf, 0x39, 0x54, 0xfd, 0xc4, 0x30, 0xc2, 0x69, 0x12, 0x48, 0xfc,
      0xfc, 0xd1, 0x37, 0x67, 0xe3, 0x24, 0x91, 0xf0, 0x02, 0x69, 0xb5, 0x49,
      0xca, 0xe9, 0x37, 0x77, 0xce, 0xd0, 0xf7, 0xb0, 0x69, 0x44, 0x07, 0x26,
      0xad, 0xde, 0x76, 0x05, 0xd4, 0x03, 0x8d, 0x7b, 0x5e, 0xa4, 0xcc, 0x02,
      0x41, 0x76, 0x22, 0xc9, 0x06, 0x5f, 0x4c, 0x49, 0xa6, 0xf8, 0x64, 0x90,
      0x73, 0xdf, 0xc6, 0xa8, 0x27, 0xb8, 0x97, 0xb6, 0x98, 0x41, 0x76, 0xb1,
      0xa0, 0x9d, 0x15, 0x1b, 0x97, 0x33, 0xa6, 0x8f, 0x6d, 0xa7, 0x46, 0xc4,
      0x74, 0x27, 0xcd, 0xeb, 0x3b, 0xe0, 0x75, 0xda, 0x4a, 0x35, 0x1a, 0xb7,
      0x8d, 0xd5, 0xe4, 0x72, 0xcd, 0x98, 0xd1, 0x58, 0x6e, 0xdd, 0x6f, 0xf2,
      0xa1, 0x1c, 0x6c, 0x16, 0x9f, 0xbb},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x32, 0x33, 0x32, 0x37, 0x37, 0x35, 0x34, 0x32, 0x37, 0x39},
     true},

    // Comment: special case hash
    // tcID: 266
    {SEC_OID_SHA512,
     266,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x89, 0x96, 0x09, 0xe7, 0xf7, 0xcd,
      0x2e, 0xf1, 0x4b, 0xfb, 0xb1, 0xcb, 0x9b, 0xa9, 0x28, 0x3a, 0xe1, 0x1a,
      0x93, 0x46, 0xa3, 0x4b, 0xef, 0x23, 0xb1, 0xc2, 0x49, 0xda, 0x2e, 0x76,
      0xa7, 0x70, 0x8e, 0x0f, 0x2f, 0x97, 0xf8, 0x19, 0xe4, 0xe2, 0x5b, 0x0d,
      0x52, 0x27, 0xee, 0xb8, 0x5a, 0xa5, 0x93, 0xc3, 0xfa, 0xe9, 0x39, 0x8a,
      0x70, 0x20, 0xf6, 0x1a, 0xe1, 0x60, 0x69, 0x45, 0xd1, 0x38, 0x41, 0x02,
      0x42, 0x01, 0xb8, 0xd5, 0xe9, 0xc4, 0xf0, 0x30, 0x29, 0x54, 0x47, 0x10,
      0x6d, 0x2b, 0x5c, 0x80, 0xcc, 0x2e, 0x7d, 0x4e, 0x36, 0xb4, 0x58, 0xa9,
      0x0a, 0x08, 0xf5, 0x05, 0xdf, 0x62, 0xd2, 0x23, 0x4e, 0x59, 0xd0, 0x81,
      0x87, 0x38, 0x5b, 0xa5, 0x50, 0x10, 0x49, 0xb3, 0x4e, 0x12, 0xec, 0x92,
      0xf7, 0x83, 0x9a, 0x18, 0x36, 0x1a, 0x52, 0xa9, 0xa0, 0xb6, 0xf6, 0xa6,
      0x64, 0xb1, 0x18, 0x68, 0x0b, 0x53, 0xd7},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x37, 0x37, 0x35, 0x35, 0x30, 0x38, 0x35, 0x38, 0x34},
     true},

    // Comment: special case hash
    // tcID: 267
    {SEC_OID_SHA512,
     267,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x01, 0xdd, 0xc6, 0x9d, 0x15, 0x08, 0x02,
      0x1e, 0xb5, 0x60, 0xdb, 0x39, 0xf3, 0xad, 0xd8, 0xa2, 0x8d, 0xd7, 0xfb,
      0xce, 0x41, 0x7e, 0x5f, 0xa1, 0xf4, 0xf6, 0x26, 0x70, 0x5c, 0xaa, 0xad,
      0x72, 0xb6, 0x34, 0x86, 0x8d, 0x01, 0xdf, 0xc4, 0x74, 0xe9, 0x26, 0xc9,
      0x79, 0x27, 0xc5, 0x6a, 0xc5, 0x1f, 0x9b, 0xdc, 0xfd, 0x0e, 0x76, 0x27,
      0xbe, 0x35, 0xcc, 0x30, 0x0a, 0x0c, 0xdc, 0x08, 0x3b, 0x00, 0xd4, 0x02,
      0x41, 0x6e, 0x86, 0x2c, 0xaf, 0x9f, 0x2d, 0xf1, 0x1b, 0x0a, 0x46, 0x10,
      0x4e, 0x78, 0x86, 0x5f, 0xbb, 0xab, 0xe3, 0x0b, 0xfa, 0xc0, 0xb1, 0xfe,
      0x7f, 0x99, 0xba, 0xdc, 0x11, 0x74, 0x6a, 0x28, 0x8c, 0x1f, 0xf2, 0x7f,
      0x6f, 0xa2, 0xaa, 0xba, 0x64, 0x41, 0xba, 0xb0, 0x37, 0x2a, 0xf9, 0x06,
      0xee, 0xf0, 0x83, 0xff, 0x03, 0xba, 0x46, 0x6b, 0x89, 0x6c, 0x93, 0x44,
      0xcd, 0x39, 0x6d, 0xd4, 0x6d, 0xbd},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x37, 0x39, 0x38, 0x32, 0x36, 0x34, 0x38, 0x33, 0x38, 0x32},
     true},

    // Comment: special case hash
    // tcID: 268
    {SEC_OID_SHA512,
     268,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x01, 0x17, 0xfe, 0x2c, 0x21, 0xf2, 0x82,
      0xc7, 0xe4, 0xa8, 0x41, 0x5e, 0x9c, 0x53, 0xc2, 0x54, 0x51, 0x4e, 0xee,
      0xb0, 0xad, 0xad, 0xc7, 0x71, 0xad, 0xbc, 0x6d, 0x21, 0xa0, 0x9a, 0xdd,
      0x4f, 0x17, 0xea, 0x0c, 0x59, 0x74, 0x69, 0x48, 0x82, 0x38, 0xbe, 0x79,
      0x5f, 0x2e, 0x18, 0x7f, 0xa0, 0x16, 0xd5, 0x90, 0x53, 0x5b, 0x4f, 0xf1,
      0x0c, 0x62, 0xd2, 0x24, 0x6a, 0xa1, 0x7b, 0xb0, 0x13, 0xf9, 0xee, 0x02,
      0x41, 0x3c, 0x9f, 0x15, 0x90, 0xce, 0x7a, 0x68, 0xfc, 0x84, 0xc6, 0x17,
      0xf4, 0x78, 0x18, 0x8e, 0x71, 0xae, 0xfe, 0x8c, 0x74, 0xc4, 0xb9, 0x97,
      0x9b, 0x8c, 0x91, 0x96, 0xbc, 0xc2, 0x62, 0x20, 0x5a, 0xec, 0xce, 0x5f,
      0xd2, 0xbb, 0x80, 0xc3, 0x60, 0xd3, 0xe2, 0x0d, 0xa2, 0x0e, 0x36, 0xc5,
      0xab, 0x70, 0xd8, 0x10, 0xd4, 0xba, 0x97, 0xd1, 0x38, 0x58, 0x19, 0x9d,
      0x3a, 0x1c, 0x9c, 0x14, 0x0c, 0x63},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x32, 0x33, 0x39, 0x36, 0x37, 0x37, 0x37, 0x33, 0x36, 0x35},
     true},

    // Comment: special case hash
    // tcID: 269
    {SEC_OID_SHA512,
     269,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xbe, 0x6b, 0x47, 0x25, 0x4a, 0x3c,
      0xf9, 0x3e, 0x2e, 0x27, 0x6a, 0xdf, 0xb0, 0x72, 0x25, 0x64, 0x04, 0x74,
      0x40, 0x70, 0xd6, 0xde, 0xc8, 0x3e, 0xf3, 0x4e, 0x3e, 0x6c, 0x11, 0x92,
      0x06, 0x42, 0x2b, 0xb2, 0x75, 0xe6, 0x1f, 0xc4, 0x70, 0x53, 0xef, 0x7b,
      0x2a, 0xf9, 0xe3, 0x3a, 0xca, 0x8f, 0x8b, 0x2e, 0x49, 0x38, 0x05, 0x70,
      0x70, 0xeb, 0x6e, 0xbb, 0xcf, 0x82, 0xfa, 0xbb, 0x44, 0xa5, 0xfe, 0x02,
      0x42, 0x01, 0x06, 0x1e, 0xf8, 0x09, 0x35, 0xff, 0x6d, 0x0e, 0x9f, 0x87,
      0xf3, 0x53, 0x7b, 0x63, 0x99, 0x45, 0xac, 0xf5, 0x0c, 0x5d, 0x97, 0xd3,
      0x0b, 0x4b, 0x9c, 0x34, 0x7e, 0x3f, 0x5f, 0x5e, 0xc0, 0x2b, 0x15, 0xa3,
      0x76, 0xae, 0x75, 0x4d, 0x64, 0xb2, 0xef, 0xaa, 0x81, 0x1b, 0x3d, 0x12,
      0xa0, 0xff, 0xf0, 0xbc, 0x68, 0x90, 0x22, 0x02, 0x5d, 0xd2, 0xf6, 0x9f,
      0x2f, 0x4b, 0x40, 0xdd, 0xa8, 0x68, 0x7a},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x35, 0x39, 0x39, 0x38, 0x31, 0x30, 0x35, 0x38, 0x30, 0x31},
     true},

    // Comment: special case hash
    // tcID: 270
    {SEC_OID_SHA512,
     270,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x30, 0xb6, 0xfd, 0x7d, 0xec, 0x5c,
      0xb6, 0xf9, 0x0a, 0x8b, 0x54, 0xce, 0x7b, 0x58, 0xc6, 0x1b, 0x01, 0x3d,
      0x0a, 0xed, 0x7c, 0x4a, 0x26, 0x63, 0x9d, 0xe8, 0x0a, 0xea, 0xc3, 0xd9,
      0xe3, 0x38, 0x8e, 0x9f, 0x87, 0xe1, 0xe6, 0x41, 0x9d, 0x3f, 0x03, 0x39,
      0xaf, 0x32, 0x4e, 0x14, 0x21, 0xb5, 0xd1, 0x30, 0x31, 0x7f, 0xfd, 0x9d,
      0x8b, 0xe3, 0x65, 0x00, 0xa8, 0x4b, 0xb4, 0x1d, 0x02, 0x6c, 0xea, 0x02,
      0x42, 0x01, 0x76, 0xb4, 0x60, 0xa3, 0xea, 0xe0, 0x1d, 0x8a, 0xa8, 0xcc,
      0xff, 0xb0, 0xd6, 0xcf, 0x4d, 0x15, 0x95, 0xaa, 0x69, 0x7c, 0x65, 0x51,
      0x0a, 0x11, 0x97, 0xb9, 0x73, 0x43, 0xc1, 0xa6, 0x23, 0x45, 0x52, 0xce,
      0x9d, 0x6d, 0x31, 0x8c, 0x5f, 0x20, 0xf4, 0x8b, 0xec, 0x0d, 0xc3, 0x11,
      0xdd, 0x62, 0xeb, 0x40, 0x05, 0x8f, 0x3c, 0xb2, 0x2f, 0xa9, 0x58, 0xed,
      0xaf, 0x9d, 0xdd, 0xed, 0x19, 0x1a, 0x08},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x36, 0x36, 0x37, 0x37, 0x38, 0x32, 0x37, 0x30, 0x35, 0x37},
     true},

    // Comment: special case hash
    // tcID: 271
    {SEC_OID_SHA512,
     271,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xa8, 0x7d, 0xe4, 0x2d, 0x82, 0x7a,
      0xe1, 0xf5, 0x5d, 0x6f, 0xab, 0x32, 0x77, 0xc7, 0xa9, 0xfd, 0xfa, 0xc3,
      0xaf, 0x22, 0xfe, 0x47, 0xe5, 0x2b, 0xfe, 0xe3, 0x4f, 0xa1, 0xee, 0x3e,
      0x76, 0x50, 0x95, 0xff, 0xf2, 0x01, 0x75, 0xbe, 0xcb, 0xdc, 0x94, 0xb4,
      0xa5, 0xad, 0x3a, 0x14, 0x9e, 0xa7, 0xc1, 0xbe, 0xbf, 0x4d, 0x45, 0x37,
      0x0e, 0x6b, 0x44, 0x04, 0xa0, 0x43, 0x7d, 0x8f, 0xae, 0x26, 0x4f, 0x02,
      0x42, 0x01, 0xa3, 0xc1, 0xc5, 0x18, 0x6d, 0x8a, 0xa4, 0x91, 0xb4, 0x62,
      0x3f, 0x57, 0x65, 0xa3, 0x88, 0x93, 0x0f, 0x37, 0xbb, 0x8f, 0x3e, 0x1c,
      0x0d, 0xb5, 0x08, 0x98, 0x35, 0x85, 0xb9, 0x09, 0x0b, 0x3a, 0xaf, 0x22,
      0xbb, 0x84, 0x6e, 0x0f, 0xb6, 0xd9, 0x15, 0xb5, 0x81, 0x1a, 0xc5, 0x5e,
      0x4d, 0x6c, 0xb0, 0x8f, 0x60, 0x5c, 0xb8, 0x4d, 0xeb, 0x55, 0xab, 0x7f,
      0xba, 0x2d, 0xde, 0x87, 0x36, 0xb1, 0xc4},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x32, 0x30, 0x36, 0x32, 0x31, 0x34, 0x33, 0x36, 0x32},
     true},

    // Comment: special case hash
    // tcID: 272
    {SEC_OID_SHA512,
     272,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x0e, 0x46, 0x05, 0x5d, 0x9a, 0xa0,
      0x87, 0xf1, 0xc4, 0xb6, 0x05, 0x63, 0x19, 0xcb, 0xf1, 0x7a, 0x06, 0x94,
      0xfe, 0x07, 0x32, 0x66, 0xa3, 0xf3, 0x03, 0x63, 0x03, 0x0e, 0x34, 0x5a,
      0x4b, 0xd4, 0x61, 0xac, 0xbd, 0x99, 0xd1, 0x26, 0x1f, 0xc0, 0x5e, 0xf3,
      0xc9, 0xa1, 0xc3, 0x7a, 0xfb, 0xa6, 0xe2, 0x1c, 0x2d, 0x51, 0x3e, 0xa3,
      0xd4, 0x70, 0x9d, 0xe5, 0x58, 0x68, 0x10, 0xd7, 0xd2, 0x9e, 0xc6, 0x02,
      0x42, 0x00, 0xd0, 0xc9, 0x5c, 0x7e, 0x97, 0xa9, 0x4e, 0xfb, 0x44, 0xaa,
      0x71, 0x7c, 0xd6, 0xeb, 0xe8, 0x2d, 0xe0, 0x64, 0x4e, 0x32, 0x67, 0x6d,
      0x19, 0x73, 0x51, 0xf1, 0x28, 0xee, 0x8d, 0x2b, 0x22, 0x3a, 0xb4, 0x76,
      0xd3, 0xe6, 0x60, 0x14, 0xec, 0xc0, 0x03, 0x08, 0x1f, 0x70, 0x40, 0xc5,
      0x78, 0xb8, 0x98, 0x46, 0x28, 0xd6, 0xec, 0x80, 0x73, 0x3f, 0x71, 0x3e,
      0x26, 0xb2, 0xc9, 0x8c, 0xb4, 0xed, 0xe1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x36, 0x38, 0x34, 0x32, 0x34, 0x39, 0x36, 0x30, 0x34, 0x35},
     true},

    // Comment: special case hash
    // tcID: 273
    {SEC_OID_SHA512,
     273,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x2c, 0x04, 0xd0, 0x8a, 0x7a, 0x2d,
      0x07, 0x40, 0x3a, 0xba, 0x60, 0x4e, 0xa8, 0x5e, 0xc2, 0x3a, 0x52, 0xb5,
      0x27, 0x86, 0xe7, 0xfc, 0xe0, 0x41, 0x70, 0xe8, 0x67, 0xbe, 0x61, 0x46,
      0xee, 0xa7, 0x5a, 0x71, 0x80, 0xf5, 0xd4, 0xf3, 0xb8, 0x2a, 0x20, 0x4a,
      0x3c, 0x99, 0x68, 0x11, 0xa1, 0xe6, 0x1a, 0x3e, 0x76, 0xed, 0x20, 0x9c,
      0x22, 0x42, 0x8b, 0x35, 0xc5, 0x1f, 0xe6, 0x0f, 0x3b, 0xee, 0x1e, 0x02,
      0x42, 0x01, 0x6f, 0x2f, 0xea, 0xbc, 0x25, 0x73, 0x3b, 0x0a, 0x46, 0x04,
      0x63, 0xb9, 0x93, 0x3e, 0x6e, 0x4a, 0xe9, 0xf4, 0x12, 0x4c, 0xd0, 0xad,
      0x37, 0x85, 0xc7, 0x77, 0x55, 0xdb, 0xf0, 0x84, 0x8e, 0xc1, 0xcf, 0xd2,
      0xab, 0x08, 0xb9, 0x60, 0xb5, 0x56, 0x87, 0x0f, 0xa0, 0x03, 0x88, 0xd2,
      0x3d, 0x9a, 0x9f, 0xa3, 0x11, 0x2a, 0xc3, 0xe6, 0x2a, 0x0f, 0x34, 0x2d,
      0x58, 0xfb, 0x1f, 0x0a, 0xa8, 0x17, 0x48},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x33, 0x32, 0x36, 0x39, 0x38, 0x39, 0x37, 0x33, 0x32, 0x31},
     true},

    // Comment: special case hash
    // tcID: 274
    {SEC_OID_SHA512,
     274,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xca, 0x95, 0x32, 0xc9, 0xda, 0xeb,
      0x80, 0xd0, 0xdb, 0xc0, 0x7a, 0x41, 0x38, 0xba, 0x62, 0xa6, 0xba, 0xb8,
      0xc8, 0x8b, 0x9e, 0x1e, 0x2e, 0xdf, 0x26, 0x75, 0x13, 0x2e, 0xb9, 0x7c,
      0xfb, 0x26, 0xf4, 0xc3, 0x95, 0xf3, 0xb9, 0xd1, 0xd1, 0x27, 0x56, 0x94,
      0x95, 0x6b, 0x34, 0xc3, 0xef, 0x72, 0xcd, 0x00, 0xba, 0xb8, 0x67, 0x77,
      0x46, 0x5b, 0x9e, 0xdb, 0xa2, 0x9a, 0x41, 0xb0, 0x11, 0x4c, 0x62, 0x02,
      0x42, 0x01, 0x40, 0xeb, 0x6d, 0xdd, 0xff, 0x25, 0x3a, 0x7f, 0xf5, 0xb0,
      0x32, 0xd8, 0x2f, 0xbd, 0x18, 0xe4, 0x81, 0xa3, 0x76, 0xfe, 0x24, 0x2f,
      0x64, 0x05, 0xb8, 0x1b, 0x57, 0x16, 0x56, 0x65, 0xc9, 0xbf, 0xe6, 0x1e,
      0x25, 0xcd, 0x33, 0x58, 0x24, 0x5b, 0xdf, 0xb8, 0xde, 0x76, 0x32, 0xde,
      0x72, 0xed, 0x20, 0xcd, 0xac, 0xf3, 0x84, 0x76, 0x40, 0x96, 0xc8, 0xfe,
      0x3a, 0x37, 0x65, 0x63, 0xa3, 0x48, 0xaf},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x33, 0x38, 0x37, 0x33, 0x32, 0x34, 0x36, 0x39, 0x32},
     true},

    // Comment: special case hash
    // tcID: 275
    {SEC_OID_SHA512,
     275,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xd6, 0x09, 0xe1, 0xf1, 0xcc, 0x1a,
      0xdf, 0x58, 0x89, 0xdc, 0x6d, 0xed, 0xa4, 0x41, 0x68, 0x2e, 0x76, 0x0b,
      0xe0, 0x89, 0x32, 0xb3, 0x15, 0x92, 0xfe, 0xf3, 0xad, 0xa1, 0x43, 0xfb,
      0x49, 0x40, 0xe4, 0xea, 0x75, 0xae, 0x51, 0x9e, 0x4f, 0xb0, 0x76, 0x9c,
      0x4f, 0xbd, 0x33, 0xa5, 0x2b, 0x18, 0x3a, 0x21, 0xd0, 0xbb, 0xa1, 0xff,
      0xa3, 0xfe, 0x50, 0xfd, 0x11, 0xf7, 0x5c, 0x6a, 0xc5, 0x8f, 0xf6, 0x02,
      0x42, 0x01, 0x24, 0x00, 0xcc, 0x4d, 0xdc, 0x24, 0xdd, 0xcd, 0x47, 0xa6,
      0xd6, 0x39, 0xa2, 0xab, 0xde, 0xf2, 0x9a, 0x65, 0xd4, 0xfe, 0x91, 0x75,
      0xf5, 0x1b, 0x31, 0x6f, 0x4b, 0xf9, 0x18, 0xbc, 0x91, 0x88, 0x79, 0x49,
      0x5c, 0x57, 0x2f, 0x8e, 0x98, 0x36, 0x4e, 0x2e, 0x1a, 0xa0, 0xd4, 0xd5,
      0x3a, 0xd2, 0x9e, 0x80, 0x3a, 0x44, 0x70, 0xd9, 0x4d, 0xd0, 0x6a, 0x98,
      0x2a, 0x1d, 0x04, 0x1b, 0xf2, 0xb5, 0xdd},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x34, 0x31, 0x31, 0x38, 0x38, 0x38, 0x37, 0x35, 0x33, 0x36},
     true},

    // Comment: special case hash
    // tcID: 276
    {SEC_OID_SHA512,
     276,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x37, 0x75, 0xa7, 0xe6, 0x1b, 0xdd, 0xa9,
      0xa3, 0xa9, 0x90, 0xba, 0x9f, 0xde, 0x98, 0xf9, 0xd8, 0x1d, 0x4b, 0x03,
      0x19, 0x55, 0x47, 0xbb, 0xd0, 0x65, 0x8e, 0x10, 0x59, 0xda, 0xa0, 0x0d,
      0xa9, 0x27, 0x06, 0x71, 0xb2, 0xfa, 0xda, 0x1b, 0xbb, 0xf1, 0x39, 0x82,
      0xf8, 0x7c, 0x9f, 0x3f, 0x26, 0xdd, 0xa5, 0xcd, 0x4f, 0x24, 0xde, 0x63,
      0xbc, 0xeb, 0x5f, 0xd9, 0x39, 0x01, 0x63, 0xc5, 0x8d, 0x26, 0x02, 0x42,
      0x01, 0x0a, 0x03, 0xe4, 0xba, 0x08, 0xf9, 0xe2, 0xb6, 0x91, 0x5a, 0x6c,
      0x0b, 0x83, 0x15, 0x6b, 0x00, 0xf5, 0x9e, 0xfc, 0x54, 0x17, 0x39, 0x4c,
      0x51, 0xca, 0x76, 0x16, 0xb5, 0x8c, 0xf9, 0x1a, 0xb7, 0x16, 0x6d, 0x84,
      0x59, 0xeb, 0x4e, 0xeb, 0x0d, 0x57, 0x14, 0x6e, 0xd6, 0x56, 0x0e, 0x17,
      0x3f, 0xaf, 0x35, 0x4b, 0x43, 0x90, 0x81, 0x7e, 0x0a, 0xaf, 0xb3, 0x82,
      0x94, 0xdf, 0x25, 0x99, 0x2c, 0xbd},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x39, 0x38, 0x38, 0x36, 0x30, 0x36, 0x35, 0x34, 0x35},
     true},

    // Comment: special case hash
    // tcID: 277
    {SEC_OID_SHA512,
     277,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x7a, 0xb0, 0x0a, 0x30, 0xc8, 0x8f,
      0xae, 0xce, 0xd3, 0xe4, 0xa1, 0x0f, 0x9c, 0x63, 0x78, 0x5b, 0xc2, 0x9e,
      0x9a, 0xf4, 0x49, 0x94, 0x66, 0xbd, 0x88, 0x80, 0x82, 0x7c, 0xfa, 0x58,
      0x0b, 0x61, 0x71, 0xf4, 0xa2, 0x0f, 0x36, 0x48, 0x7f, 0x7b, 0x94, 0x59,
      0x29, 0x46, 0xbc, 0xa4, 0x16, 0x2f, 0xaf, 0x65, 0x87, 0x2a, 0xf6, 0xbf,
      0xb1, 0x91, 0x9e, 0x6b, 0x02, 0x6c, 0x14, 0xe5, 0x1e, 0x27, 0x40, 0x02,
      0x42, 0x01, 0x92, 0x75, 0x15, 0xf6, 0x48, 0x9e, 0x9b, 0x7d, 0x9c, 0xbf,
      0x61, 0xe1, 0x03, 0x29, 0x58, 0x57, 0xc8, 0x13, 0x13, 0x20, 0x21, 0x7e,
      0x7a, 0x86, 0xd3, 0xf2, 0xfd, 0xcb, 0x35, 0x0d, 0xa5, 0xb4, 0x2c, 0x2d,
      0xbe, 0x17, 0x3f, 0xcb, 0x02, 0x5d, 0x14, 0xda, 0x23, 0x9d, 0x7d, 0x61,
      0x0d, 0xe8, 0x47, 0x59, 0x14, 0x74, 0x85, 0x73, 0x42, 0x9c, 0x95, 0x90,
      0xd3, 0x59, 0x4f, 0x4f, 0xa3, 0xaa, 0xb3},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x32, 0x34, 0x37, 0x39, 0x31, 0x31, 0x35, 0x38, 0x34, 0x35},
     true},

    // Comment: special case hash
    // tcID: 278
    {SEC_OID_SHA512,
     278,
     {0x30, 0x81, 0x86, 0x02, 0x41, 0x3b, 0x2b, 0xa1, 0x50, 0x9a, 0xea, 0x9d,
      0x42, 0xd4, 0x00, 0x40, 0x00, 0x33, 0x95, 0x2a, 0x02, 0x2f, 0xe7, 0xe0,
      0x0c, 0x7a, 0xd6, 0x5c, 0x39, 0xa2, 0xf7, 0x6d, 0x41, 0x13, 0x0a, 0xad,
      0xa9, 0x9c, 0x3c, 0xdf, 0xb9, 0xcf, 0x44, 0x57, 0x5a, 0x21, 0x63, 0xde,
      0x29, 0xf0, 0x97, 0xbe, 0xb9, 0xbd, 0x3a, 0xef, 0x93, 0x34, 0xe6, 0xfd,
      0x08, 0x13, 0xdd, 0xe2, 0xa0, 0x87, 0xf9, 0x38, 0xc5, 0xf6, 0x02, 0x41,
      0x1a, 0xfb, 0x56, 0x08, 0x7d, 0xfd, 0x5c, 0xb4, 0xff, 0xf6, 0x67, 0x9a,
      0x11, 0x4c, 0x34, 0x0f, 0x3a, 0x59, 0xf6, 0xb3, 0xe1, 0x81, 0x33, 0x73,
      0xbf, 0x3e, 0xbe, 0x30, 0xcb, 0x5e, 0x8b, 0x28, 0x5a, 0x58, 0x75, 0xd1,
      0xb5, 0xa9, 0x12, 0x0d, 0xb8, 0x0f, 0x70, 0x31, 0x02, 0x01, 0x55, 0x9f,
      0x89, 0xbb, 0x1d, 0xf1, 0x47, 0x96, 0x1d, 0x1c, 0xa4, 0xfc, 0xdb, 0x5e,
      0x8e, 0x84, 0xca, 0xe0, 0x82},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x35, 0x30, 0x37, 0x36, 0x38, 0x38, 0x37, 0x33, 0x36, 0x37},
     true},

    // Comment: special case hash
    // tcID: 279
    {SEC_OID_SHA512,
     279,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x0e, 0xfb, 0x32, 0x1a, 0x34, 0x76,
      0x25, 0x34, 0x3f, 0x51, 0x26, 0xed, 0x85, 0x45, 0x01, 0x7d, 0x79, 0x9e,
      0xb1, 0x03, 0xc7, 0x55, 0x58, 0x92, 0x2e, 0xab, 0xe4, 0x42, 0x11, 0xe8,
      0xfd, 0x83, 0x46, 0x55, 0xdc, 0x2e, 0xc5, 0xbe, 0xe9, 0xbb, 0x3e, 0x44,
      0x35, 0x0e, 0xb6, 0x88, 0x5e, 0x0a, 0xb9, 0x74, 0x73, 0x02, 0x22, 0xe5,
      0x5f, 0x13, 0xad, 0x27, 0xc0, 0x66, 0x72, 0x2f, 0xec, 0xaa, 0x25, 0x02,
      0x42, 0x00, 0xd6, 0x2e, 0x3d, 0x7f, 0xf9, 0x21, 0x53, 0x69, 0xaa, 0x7d,
      0xa8, 0x18, 0xdb, 0x30, 0x2e, 0x49, 0x03, 0x38, 0x75, 0x01, 0x0b, 0x2f,
      0x9b, 0x73, 0xd2, 0x5c, 0xa5, 0xb9, 0xbf, 0x2c, 0x62, 0xed, 0x75, 0x66,
      0x86, 0x23, 0x0c, 0xd5, 0xf4, 0xa3, 0x7c, 0x1f, 0xa8, 0x81, 0xc9, 0x7e,
      0x62, 0x39, 0x19, 0xfa, 0xb8, 0x27, 0xde, 0x59, 0x95, 0xab, 0x45, 0x6a,
      0x1f, 0xd7, 0xac, 0x7b, 0x85, 0xb1, 0xf8},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x39, 0x38, 0x38, 0x35, 0x30, 0x36, 0x39, 0x36, 0x37},
     true},

    // Comment: special case hash
    // tcID: 280
    {SEC_OID_SHA512,
     280,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x2f, 0x77, 0x8c, 0xd5, 0x52, 0xf5, 0x4d,
      0xa5, 0xf5, 0x67, 0xf4, 0x7e, 0x69, 0x79, 0x87, 0x2b, 0xa1, 0x30, 0xdc,
      0x08, 0x90, 0x17, 0x2b, 0xf3, 0xb3, 0xbb, 0x95, 0x2f, 0x03, 0xc6, 0x4b,
      0xc8, 0x78, 0x3a, 0xbe, 0x9f, 0x05, 0x6d, 0x60, 0xe1, 0x66, 0x77, 0x80,
      0xf5, 0xea, 0x88, 0xf5, 0x9e, 0xf3, 0x3c, 0x73, 0x5d, 0x54, 0x05, 0x61,
      0xa1, 0x97, 0xd3, 0x1f, 0xe3, 0x48, 0x53, 0xa6, 0x0a, 0x52, 0x02, 0x42,
      0x00, 0xbd, 0x28, 0x16, 0xf0, 0x63, 0x72, 0xf2, 0xe3, 0xf2, 0x58, 0x2d,
      0x53, 0xe5, 0x83, 0xe1, 0x33, 0xa5, 0x51, 0xaa, 0xec, 0x04, 0xdd, 0xc2,
      0xfd, 0xb7, 0xb8, 0x13, 0x17, 0x87, 0xe7, 0x3e, 0x42, 0x95, 0xac, 0x28,
      0xa9, 0x60, 0x4a, 0x24, 0x02, 0xed, 0x5b, 0x27, 0x2c, 0xc0, 0x3b, 0xe5,
      0x7d, 0xd4, 0xa7, 0xdf, 0x84, 0xd9, 0xee, 0x24, 0xcb, 0x0c, 0x2b, 0xf1,
      0x24, 0xed, 0x92, 0x7d, 0xef, 0xee},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x32, 0x37, 0x32, 0x31, 0x33, 0x30, 0x36, 0x31, 0x33, 0x31},
     true},

    // Comment: special case hash
    // tcID: 281
    {SEC_OID_SHA512,
     281,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x2a, 0x45, 0x9f, 0xff, 0xea, 0x70,
      0xd3, 0xbf, 0xc1, 0x3e, 0x9e, 0xa0, 0xab, 0xb1, 0x0a, 0xae, 0x39, 0x10,
      0xdf, 0x60, 0x49, 0x97, 0xcb, 0x5e, 0x4b, 0xb0, 0x54, 0x8a, 0xbd, 0x85,
      0x2a, 0xba, 0xc6, 0xb9, 0xa3, 0x24, 0x18, 0xc3, 0xb5, 0xed, 0x4e, 0x79,
      0x51, 0xae, 0x88, 0xee, 0xcc, 0x0a, 0x2f, 0x10, 0x65, 0xca, 0xf2, 0x4c,
      0x6a, 0x81, 0x46, 0x74, 0xe9, 0x56, 0x82, 0xd9, 0xb4, 0x93, 0xf2, 0x02,
      0x42, 0x00, 0xe2, 0xab, 0xd0, 0x5c, 0x58, 0x5e, 0x0c, 0x21, 0x3a, 0x21,
      0x9a, 0x7e, 0x7d, 0x38, 0xb8, 0x10, 0xd2, 0x52, 0xff, 0xea, 0x67, 0x65,
      0x0d, 0x4d, 0x19, 0x94, 0xa4, 0x1c, 0x2c, 0xa3, 0x25, 0xbb, 0x96, 0x49,
      0x20, 0xc6, 0xc2, 0x54, 0x53, 0x81, 0xc4, 0x5c, 0xa3, 0xe1, 0xec, 0xa0,
      0x5e, 0x00, 0x51, 0x4b, 0x36, 0x6c, 0xb0, 0xe1, 0xe4, 0x9b, 0x8c, 0x23,
      0x6d, 0x38, 0x3b, 0x26, 0x0b, 0x9c, 0xbd},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x33, 0x32, 0x30, 0x34, 0x31, 0x30, 0x31, 0x36, 0x35, 0x35},
     true},

    // Comment: special case hash
    // tcID: 282
    {SEC_OID_SHA512,
     282,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x01, 0x0f, 0x26, 0x53, 0xd9, 0x4a, 0xa2,
      0x8b, 0xcb, 0xd6, 0x67, 0xa5, 0x01, 0x3f, 0x9b, 0x28, 0x3d, 0x84, 0x87,
      0xc4, 0x4d, 0x09, 0x3e, 0xe4, 0x76, 0x60, 0x32, 0x93, 0x98, 0xca, 0xa5,
      0x50, 0xca, 0x9c, 0x93, 0x88, 0xc7, 0xaa, 0xde, 0xce, 0xac, 0xac, 0x15,
      0x07, 0xe7, 0x65, 0x90, 0xaf, 0xb7, 0x36, 0xad, 0xb3, 0x58, 0x3f, 0x54,
      0xf3, 0x1a, 0xe2, 0x5c, 0x9c, 0x71, 0x7e, 0xc9, 0xf8, 0x9b, 0x5e, 0x02,
      0x41, 0x49, 0x44, 0x48, 0xa7, 0xff, 0xe4, 0xa4, 0xee, 0xd8, 0x4b, 0x46,
      0x02, 0x78, 0x1e, 0xce, 0xf7, 0x7a, 0x23, 0xfe, 0xd1, 0x16, 0xb1, 0xb7,
      0x91, 0xb8, 0xd2, 0xe4, 0x23, 0x1b, 0x7c, 0xa2, 0xa7, 0xb6, 0xf0, 0x6d,
      0x13, 0x27, 0x05, 0x93, 0x2d, 0x44, 0x6e, 0x61, 0xd3, 0x44, 0x71, 0x4e,
      0xe2, 0x40, 0x14, 0xfa, 0x5b, 0xb1, 0x44, 0xa9, 0x65, 0x72, 0xb3, 0xd4,
      0x8d, 0x03, 0x8a, 0x55, 0xad, 0x68},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x33, 0x31, 0x35, 0x30, 0x36, 0x38, 0x30, 0x39, 0x35, 0x30},
     true},

    // Comment: special case hash
    // tcID: 283
    {SEC_OID_SHA512,
     283,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xc2, 0xda, 0x48, 0x55, 0x2c, 0x39,
      0xd9, 0x4f, 0x5a, 0x45, 0x42, 0x7a, 0xe9, 0xdc, 0xd8, 0x91, 0xb6, 0x5c,
      0xca, 0x33, 0xe6, 0x24, 0xad, 0x25, 0x32, 0xff, 0xa3, 0x33, 0x66, 0x6b,
      0x24, 0x1d, 0x87, 0x33, 0x36, 0xfa, 0xb7, 0xbb, 0xd7, 0xb4, 0xc1, 0x93,
      0xdb, 0x4d, 0x86, 0x5c, 0xd5, 0x0f, 0x0c, 0x1d, 0x8c, 0xb5, 0xc1, 0x4c,
      0xf3, 0xf0, 0x89, 0xad, 0x42, 0xdd, 0x43, 0xcf, 0xff, 0x63, 0x4e, 0x02,
      0x42, 0x01, 0x4f, 0x20, 0x70, 0xdc, 0xf8, 0x60, 0xb9, 0x6a, 0x45, 0xf2,
      0xa6, 0x06, 0x1e, 0x4e, 0xc2, 0xa6, 0xad, 0x64, 0xd7, 0xd0, 0xe9, 0xfb,
      0xdb, 0x25, 0xaa, 0x93, 0xb9, 0x99, 0x41, 0xbe, 0x28, 0x0f, 0x5c, 0x70,
      0xc0, 0xe3, 0x2b, 0x62, 0x34, 0xdf, 0x54, 0x5b, 0xac, 0xe7, 0x34, 0x1a,
      0xf9, 0x4c, 0x14, 0x0c, 0x86, 0x5d, 0x44, 0xfa, 0x8e, 0xa7, 0xeb, 0xe0,
      0xfe, 0x53, 0xbd, 0xa4, 0x46, 0x45, 0xdf},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x37, 0x32, 0x37, 0x34, 0x36, 0x30, 0x31, 0x30, 0x33},
     true},

    // Comment: special case hash
    // tcID: 284
    {SEC_OID_SHA512,
     284,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0x9b, 0xc6, 0xe7, 0x45, 0x49, 0xb4,
      0x8a, 0x1e, 0x7c, 0x18, 0x1b, 0x17, 0x96, 0x87, 0xfb, 0x27, 0xd6, 0xe9,
      0xac, 0xac, 0x47, 0xec, 0x34, 0xb1, 0xb8, 0xbd, 0x04, 0x4d, 0x32, 0x93,
      0x20, 0x54, 0x4e, 0x4e, 0x56, 0x8e, 0x67, 0xd1, 0x7f, 0x4c, 0xda, 0x2f,
      0x0a, 0x3f, 0xe3, 0x03, 0xd5, 0x61, 0xa1, 0x1f, 0xc0, 0xc9, 0x81, 0xed,
      0x9b, 0xe2, 0xfc, 0xc6, 0xd3, 0x97, 0xa4, 0x3a, 0xd4, 0x9e, 0x10, 0x02,
      0x42, 0x00, 0xff, 0x29, 0x5e, 0x43, 0xfe, 0xc5, 0xb6, 0x8b, 0x00, 0xce,
      0x80, 0x44, 0x43, 0x4b, 0xcd, 0x17, 0xaf, 0x1b, 0xa0, 0x4a, 0x74, 0x55,
      0x63, 0x53, 0xe2, 0x58, 0xd0, 0x17, 0xba, 0x26, 0xbe, 0xd6, 0x7f, 0x45,
      0x8f, 0xad, 0x5d, 0xd8, 0xe7, 0xd2, 0x73, 0x4d, 0x56, 0xf5, 0x99, 0x28,
      0xc2, 0x41, 0x94, 0x41, 0xa9, 0xe8, 0xc0, 0x57, 0x3d, 0xb3, 0x58, 0x6c,
      0xa0, 0x56, 0x95, 0x1c, 0xa9, 0x35, 0xe0},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x34, 0x35, 0x37, 0x31, 0x34, 0x36, 0x31, 0x32, 0x32, 0x35},
     true},

    // Comment: special case hash
    // tcID: 285
    {SEC_OID_SHA512,
     285,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x20, 0x96, 0x36, 0x38, 0xd0, 0xb0, 0x58,
      0x49, 0x42, 0x54, 0xef, 0xce, 0x57, 0x77, 0x8a, 0xc6, 0x5e, 0x5f, 0x23,
      0x49, 0x1f, 0x7a, 0xdf, 0xa7, 0x2e, 0x47, 0x13, 0xb7, 0xc0, 0x39, 0x46,
      0xb5, 0x43, 0xc0, 0x14, 0xd9, 0x66, 0x0d, 0x85, 0x52, 0x46, 0xf3, 0x08,
      0x08, 0x5e, 0xee, 0xe4, 0x95, 0xcd, 0x83, 0x1b, 0x7d, 0xbe, 0xce, 0x47,
      0xae, 0xa4, 0x8e, 0x90, 0x43, 0x3b, 0xd0, 0xfe, 0x81, 0x84, 0x02, 0x42,
      0x01, 0x61, 0xa4, 0xf4, 0x97, 0x7f, 0xec, 0xae, 0x92, 0xd4, 0xf6, 0x7e,
      0x56, 0xf3, 0x33, 0x8c, 0x7a, 0x9b, 0x82, 0x0b, 0x5e, 0x05, 0xdb, 0x1f,
      0x28, 0xd0, 0x5d, 0x71, 0xf7, 0xe5, 0xf3, 0x6b, 0xc6, 0x3f, 0x6e, 0xdd,
      0xa4, 0xd3, 0xc1, 0xb2, 0xd7, 0x3b, 0xb8, 0xa3, 0x0c, 0x4d, 0x74, 0x5b,
      0x73, 0xe6, 0x34, 0xef, 0x57, 0x4c, 0xf4, 0x76, 0x56, 0xa3, 0x72, 0xe3,
      0xeb, 0x42, 0xcc, 0x03, 0x88, 0x50},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x34, 0x31, 0x37, 0x39, 0x35, 0x31, 0x36, 0x30, 0x39, 0x30},
     true},

    // Comment: special case hash
    // tcID: 286
    {SEC_OID_SHA512,
     286,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x01, 0xbc, 0xc5, 0x85, 0x85, 0x97, 0xce,
      0x8d, 0x4d, 0xc5, 0xff, 0xa6, 0xbe, 0x33, 0xf7, 0xd8, 0x04, 0xf2, 0xf8,
      0xef, 0x59, 0xc5, 0xdb, 0x93, 0x01, 0x78, 0x5e, 0x0c, 0xce, 0xb7, 0xed,
      0x57, 0x46, 0x2f, 0x45, 0x5a, 0x46, 0x57, 0x10, 0xc7, 0x41, 0x45, 0x70,
      0xc9, 0xa3, 0x5a, 0x31, 0x00, 0xbd, 0x15, 0xfa, 0x40, 0xe3, 0xec, 0x35,
      0x0d, 0x1f, 0x75, 0x40, 0x6c, 0x2a, 0x25, 0x88, 0x5e, 0x9d, 0x76, 0x02,
      0x41, 0x43, 0x75, 0x7d, 0x28, 0x2f, 0xd1, 0xd4, 0x4c, 0x25, 0x3f, 0x9a,
      0x05, 0xd8, 0x14, 0x2c, 0x29, 0xa6, 0xd6, 0x3c, 0x0a, 0x1f, 0x55, 0x08,
      0x43, 0x1b, 0xc9, 0xfb, 0x9b, 0x60, 0xa3, 0x8b, 0x7f, 0x41, 0x4e, 0x73,
      0x0e, 0x0d, 0x59, 0xb7, 0xb7, 0x09, 0x70, 0x6a, 0x67, 0x02, 0x2e, 0x19,
      0x22, 0xfe, 0x88, 0xb1, 0x82, 0xa5, 0x74, 0x43, 0xc5, 0x8b, 0xd0, 0x6a,
      0x69, 0xee, 0x78, 0x14, 0xbc, 0xab},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x35, 0x38, 0x39, 0x32, 0x37, 0x31, 0x33, 0x30, 0x35, 0x34},
     true},

    // Comment: special case hash
    // tcID: 287
    {SEC_OID_SHA512,
     287,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x24, 0x01, 0x20, 0xb9, 0x7e, 0xa6,
      0x7b, 0xcb, 0xd0, 0xe4, 0x12, 0xd8, 0x71, 0x37, 0xa1, 0x3e, 0x34, 0x7a,
      0x87, 0x0a, 0x22, 0x49, 0x37, 0x5f, 0xcc, 0xf8, 0xc0, 0x04, 0xda, 0x35,
      0xe5, 0x92, 0x62, 0x07, 0x74, 0x16, 0x0e, 0x7b, 0x82, 0xae, 0xd1, 0xf5,
      0x79, 0x97, 0xfb, 0x01, 0x5a, 0x76, 0x4d, 0x01, 0x4d, 0x4b, 0xe1, 0xf3,
      0x89, 0xe5, 0x49, 0x97, 0x77, 0x05, 0x45, 0x76, 0xe7, 0xbf, 0x00, 0x02,
      0x42, 0x01, 0x9f, 0x15, 0x7e, 0xc3, 0xa2, 0x41, 0x08, 0x53, 0x27, 0x4b,
      0xc4, 0xd8, 0xe7, 0x56, 0x5e, 0x9e, 0xaa, 0x5d, 0xc4, 0x7d, 0x5e, 0x51,
      0x5a, 0xbc, 0x86, 0xc2, 0x2f, 0xa6, 0xdc, 0x21, 0x54, 0x82, 0xdf, 0x5c,
      0x0e, 0x2b, 0x88, 0x5f, 0x37, 0xba, 0xef, 0x3a, 0x6a, 0xe8, 0x3d, 0xaa,
      0xc9, 0x30, 0x61, 0x7a, 0x5f, 0xb3, 0x7b, 0xb0, 0x3c, 0xe4, 0x0f, 0x06,
      0xfa, 0x4e, 0xce, 0x26, 0xcb, 0xb1, 0x1c},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x33, 0x38, 0x39, 0x36, 0x31, 0x38, 0x32, 0x32, 0x39, 0x37},
     true},

    // Comment: special case hash
    // tcID: 288
    {SEC_OID_SHA512,
     288,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xa7, 0x53, 0x6d, 0x55, 0x87, 0x6f,
      0x83, 0x92, 0xa6, 0xeb, 0xa1, 0x8f, 0x07, 0x51, 0x18, 0xc2, 0x73, 0x01,
      0x58, 0x44, 0xeb, 0x35, 0x36, 0xc7, 0x27, 0xc0, 0x04, 0xc1, 0xbf, 0x23,
      0x06, 0x7d, 0x57, 0xe8, 0xfe, 0x31, 0x87, 0x2f, 0x8b, 0xf8, 0x39, 0x64,
      0x0e, 0x80, 0xe0, 0x6a, 0xba, 0x3c, 0x0a, 0x36, 0x5a, 0x26, 0x8c, 0xab,
      0xc2, 0xda, 0x96, 0xd8, 0x45, 0x50, 0xa5, 0x69, 0xf1, 0x7f, 0x9c, 0x02,
      0x42, 0x00, 0xe8, 0x40, 0xb6, 0xa7, 0xcb, 0xa7, 0x18, 0xd9, 0x11, 0x03,
      0xfa, 0xa1, 0x34, 0xc2, 0xf6, 0x37, 0x63, 0xf3, 0xb6, 0xb9, 0x1d, 0xb7,
      0xec, 0xbd, 0x3b, 0x10, 0xf1, 0x01, 0x71, 0xa8, 0x75, 0x71, 0x2c, 0xb9,
      0x38, 0x43, 0x25, 0x41, 0x1b, 0xec, 0xa9, 0xa3, 0xaa, 0x87, 0xaa, 0xae,
      0x39, 0x02, 0xc2, 0x82, 0xd2, 0xde, 0xda, 0xa1, 0xcb, 0xdd, 0xd4, 0x0c,
      0xcf, 0x0d, 0x29, 0x97, 0x5d, 0xf2, 0x2a},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x38, 0x32, 0x38, 0x33, 0x33, 0x34, 0x36, 0x37, 0x33, 0x32},
     true},

    // Comment: special case hash
    // tcID: 289
    {SEC_OID_SHA512,
     289,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x3f, 0x72, 0xbe, 0x1c, 0x33, 0x12,
      0x14, 0xf4, 0x50, 0x07, 0xff, 0x72, 0xce, 0x54, 0xaf, 0xce, 0x1c, 0x91,
      0x0a, 0x90, 0xe4, 0xff, 0x3d, 0x17, 0x66, 0x20, 0xff, 0x3c, 0xa9, 0x76,
      0xc2, 0xb6, 0x2d, 0x0c, 0xdf, 0x5d, 0x11, 0x34, 0x29, 0x0e, 0xe9, 0x74,
      0x40, 0x71, 0x55, 0x31, 0x45, 0x5d, 0xc2, 0x98, 0x18, 0x82, 0x80, 0x94,
      0xd3, 0x66, 0xf9, 0x59, 0xe1, 0xad, 0xc7, 0xd7, 0xe9, 0x8e, 0xa4, 0x02,
      0x42, 0x01, 0xe8, 0x0a, 0xc3, 0x8b, 0xa6, 0x9f, 0x3e, 0x53, 0x11, 0x6e,
      0x54, 0x32, 0xfb, 0xdb, 0x3b, 0x1e, 0x7e, 0xa1, 0xb4, 0x3e, 0x5f, 0x86,
      0xd1, 0xc0, 0xe3, 0xd1, 0xc4, 0x69, 0x44, 0x2d, 0xbb, 0x40, 0x6f, 0xfe,
      0x52, 0x4f, 0x06, 0x85, 0xf7, 0x1e, 0x81, 0x1d, 0x94, 0xa9, 0xef, 0xa9,
      0xed, 0x38, 0xcc, 0xd9, 0x21, 0x3f, 0x98, 0x39, 0x83, 0x03, 0x5f, 0x2a,
      0xdd, 0x0b, 0x8f, 0x2f, 0xa4, 0xae, 0x23},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x33, 0x33, 0x36, 0x36, 0x39, 0x37, 0x34, 0x38, 0x39, 0x31},
     true},

    // Comment: special case hash
    // tcID: 290
    {SEC_OID_SHA512,
     290,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xac, 0xea, 0xa6, 0xd5, 0x67, 0xdd,
      0xb3, 0x9b, 0xa5, 0x2d, 0x29, 0x7e, 0x60, 0xe4, 0xa8, 0x14, 0xc9, 0xb4,
      0x76, 0xca, 0xb5, 0x68, 0xc0, 0x9d, 0x8a, 0xce, 0x87, 0x8d, 0x84, 0x62,
      0x18, 0xdd, 0x2b, 0x5d, 0x2a, 0x24, 0x61, 0xf0, 0xd5, 0xa5, 0x6c, 0x12,
      0xf0, 0xbd, 0x80, 0x3e, 0x32, 0x53, 0xdc, 0x5b, 0x38, 0x7b, 0x94, 0xe8,
      0x65, 0x89, 0xcb, 0x1d, 0x0c, 0xb8, 0x09, 0xc7, 0x07, 0x11, 0x25, 0x02,
      0x42, 0x01, 0xb1, 0xfb, 0x02, 0x1b, 0x10, 0xb5, 0x93, 0xcf, 0x9e, 0x79,
      0x3c, 0xf2, 0x2a, 0x88, 0xbd, 0xe9, 0xa4, 0xb9, 0x2f, 0x9e, 0x21, 0x80,
      0x94, 0xf2, 0x70, 0xb0, 0x93, 0xe8, 0xc6, 0xc9, 0x5a, 0xce, 0xd4, 0x3d,
      0x09, 0x7b, 0xfa, 0x33, 0x54, 0xe6, 0xb9, 0x8d, 0x19, 0x5c, 0x59, 0x9c,
      0x2e, 0x6f, 0x13, 0x35, 0x1c, 0x63, 0xc2, 0x89, 0x67, 0xe0, 0x8b, 0x7e,
      0x49, 0x7e, 0x12, 0x06, 0x65, 0xc6, 0x63},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x32, 0x31, 0x39, 0x39, 0x31, 0x35, 0x33, 0x32, 0x32, 0x39},
     true},

    // Comment: special case hash
    // tcID: 291
    {SEC_OID_SHA512,
     291,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xf6, 0xff, 0xb5, 0xdd, 0x78, 0x63,
      0x26, 0x04, 0x1e, 0x74, 0x56, 0x4b, 0x71, 0x9d, 0x38, 0x92, 0x4a, 0x28,
      0x32, 0x98, 0x68, 0x17, 0x7c, 0x13, 0x46, 0x3c, 0xff, 0x90, 0xc4, 0xb0,
      0x9d, 0x3d, 0x2d, 0xbc, 0x01, 0x12, 0x81, 0xcc, 0x78, 0xaa, 0x0e, 0x5e,
      0x86, 0x56, 0x12, 0x3b, 0xc5, 0x06, 0x05, 0x60, 0x1a, 0x54, 0x7b, 0xb4,
      0xb1, 0x76, 0x1f, 0x85, 0x2a, 0x12, 0x0e, 0xa4, 0x6d, 0xf9, 0xdf, 0x02,
      0x42, 0x01, 0xa4, 0x07, 0xfd, 0xd4, 0x45, 0x61, 0x4a, 0x16, 0xa5, 0xeb,
      0xd4, 0xba, 0x07, 0x5c, 0x6c, 0x1d, 0x75, 0x64, 0xf3, 0xcf, 0xd4, 0x77,
      0xd6, 0xb2, 0x62, 0x0a, 0xbf, 0x18, 0xa5, 0xbf, 0x78, 0x31, 0x12, 0x82,
      0xea, 0x45, 0xb9, 0xbf, 0xf8, 0x13, 0xf2, 0x4c, 0x3c, 0x78, 0x54, 0xe6,
      0x09, 0x1c, 0x80, 0x55, 0x14, 0x4f, 0x95, 0x92, 0xfb, 0xf2, 0xe4, 0x56,
      0x42, 0x1a, 0x41, 0xc5, 0x55, 0xd7, 0xa9},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x35, 0x36, 0x30, 0x30, 0x33, 0x31, 0x36, 0x38, 0x32, 0x32},
     true},

    // Comment: special case hash
    // tcID: 292
    {SEC_OID_SHA512,
     292,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x01, 0xa1, 0x5a, 0xf4, 0xd5, 0xca, 0x3d,
      0xea, 0xde, 0xcd, 0x75, 0xec, 0x1b, 0xae, 0xc3, 0x1c, 0x8d, 0x43, 0xfb,
      0xc8, 0x89, 0x46, 0x64, 0x75, 0xe6, 0xc2, 0x31, 0x06, 0xdb, 0x4e, 0x63,
      0xab, 0x69, 0x00, 0x3f, 0x56, 0xd8, 0x19, 0xdd, 0xfc, 0x5a, 0x67, 0x3c,
      0x82, 0x89, 0xf9, 0xe6, 0xdf, 0x80, 0x6b, 0x07, 0xaf, 0x57, 0xa2, 0x54,
      0x1a, 0xf6, 0x94, 0xe6, 0x48, 0x97, 0x34, 0xc8, 0xee, 0xc8, 0x37, 0x02,
      0x41, 0x69, 0xc3, 0x54, 0x33, 0xa3, 0x21, 0x7f, 0xcd, 0x73, 0x8a, 0x65,
      0xb7, 0xda, 0x9e, 0x81, 0xcd, 0x81, 0xf0, 0x4f, 0x0e, 0xf0, 0x60, 0x05,
      0x0b, 0x9c, 0x84, 0x3e, 0x9e, 0x80, 0x8d, 0x8b, 0x81, 0x75, 0xf3, 0xad,
      0xae, 0xfa, 0x10, 0x5d, 0x21, 0x5e, 0xa9, 0xa4, 0x6b, 0xf4, 0x15, 0xfe,
      0x2a, 0xc1, 0x80, 0x95, 0x8f, 0xcd, 0xd8, 0x78, 0xd5, 0x4f, 0x8d, 0x19,
      0xd2, 0x3e, 0x11, 0xb7, 0x6d, 0x1a},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x38, 0x36, 0x39, 0x36, 0x35, 0x31, 0x36, 0x39, 0x35},
     true},

    // Comment: special case hash
    // tcID: 293
    {SEC_OID_SHA512,
     293,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xba, 0x89, 0x9f, 0x94, 0x84, 0x1d,
      0xb6, 0xc3, 0x3b, 0x85, 0x08, 0x67, 0xc8, 0x90, 0x6b, 0x43, 0x6b, 0xe3,
      0x85, 0x36, 0x40, 0xdb, 0xfc, 0x86, 0x31, 0x97, 0xfa, 0x1e, 0x5a, 0x55,
      0xce, 0x25, 0x24, 0x0f, 0x2b, 0xe4, 0x98, 0xb9, 0xbd, 0xcf, 0xc0, 0xa8,
      0x9d, 0xbd, 0xca, 0x19, 0x2d, 0x8f, 0x84, 0xca, 0x3c, 0x44, 0xe5, 0xe0,
      0xee, 0x6f, 0x83, 0xe7, 0x90, 0x0e, 0x08, 0x5e, 0x1b, 0xd4, 0x81, 0x02,
      0x42, 0x00, 0x86, 0xe6, 0xd5, 0x58, 0xde, 0x8d, 0x8f, 0x01, 0x4a, 0x85,
      0xcb, 0x4a, 0x5f, 0x69, 0x08, 0x62, 0x7e, 0x7a, 0x1a, 0xcd, 0x70, 0x58,
      0x1d, 0x9d, 0x9c, 0x7d, 0x14, 0xdf, 0x44, 0xd4, 0x37, 0xaa, 0x09, 0xe5,
      0xa1, 0x0a, 0x0b, 0x76, 0x0e, 0x98, 0xd4, 0x67, 0x31, 0xf2, 0x51, 0x2c,
      0xa1, 0xb0, 0x24, 0x0c, 0x60, 0x2b, 0x5f, 0x0a, 0x20, 0x30, 0x48, 0x5e,
      0x34, 0xde, 0x9c, 0x6c, 0xd0, 0x8e, 0x7e},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x36, 0x35, 0x38, 0x33, 0x39, 0x32, 0x36, 0x33, 0x37, 0x32},
     true},

    // Comment: special case hash
    // tcID: 294
    {SEC_OID_SHA512,
     294,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0x8e, 0xb5, 0xc9, 0x2d, 0xbf, 0x5e,
      0x00, 0x88, 0x8b, 0x85, 0xe6, 0xbf, 0x66, 0x17, 0x01, 0x7e, 0x97, 0xc0,
      0x4a, 0xe9, 0x50, 0xdd, 0x73, 0x18, 0x56, 0xb9, 0xdf, 0xb2, 0x0e, 0x0c,
      0x0e, 0x5c, 0x54, 0x28, 0x4f, 0x41, 0x12, 0x31, 0xfe, 0xd1, 0xd0, 0x71,
      0xb3, 0x21, 0xf7, 0x86, 0x18, 0xd2, 0xa7, 0x5c, 0x13, 0x96, 0x63, 0xfb,
      0x9d, 0xb3, 0x43, 0x52, 0x14, 0xcb, 0xac, 0x5a, 0x0d, 0xcb, 0x4f, 0x02,
      0x42, 0x01, 0xda, 0x0d, 0xd2, 0x9d, 0x47, 0x28, 0xfe, 0x63, 0x31, 0xc8,
      0xe2, 0xad, 0xe5, 0x04, 0x5b, 0x12, 0x37, 0x66, 0x4a, 0xed, 0x15, 0x7d,
      0xb2, 0xa6, 0xcb, 0xde, 0xaf, 0x5a, 0xbe, 0xa8, 0x13, 0x24, 0xe2, 0x89,
      0x20, 0xa1, 0xc4, 0x9c, 0x33, 0x4b, 0x12, 0x26, 0x44, 0x1f, 0x88, 0xe1,
      0xa7, 0xf2, 0xc7, 0xe0, 0x1d, 0x63, 0xe9, 0x50, 0xd4, 0x37, 0x8f, 0x08,
      0x97, 0x3d, 0xb1, 0x6b, 0x2e, 0x61, 0x61},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x33, 0x32, 0x30, 0x35, 0x30, 0x31, 0x35, 0x37, 0x32, 0x35},
     true},

    // Comment: special case hash
    // tcID: 295
    {SEC_OID_SHA512,
     295,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x30, 0x77, 0x9f, 0x94, 0x3d, 0xf0,
      0x98, 0xdd, 0xb5, 0x31, 0x5c, 0xdc, 0xa4, 0xb7, 0x31, 0xc8, 0x34, 0x72,
      0xd5, 0x89, 0xf4, 0xba, 0x4d, 0x32, 0xc1, 0x72, 0xfa, 0xf6, 0xb3, 0xa9,
      0xe4, 0x15, 0x4c, 0x05, 0x17, 0xfc, 0xc5, 0xc4, 0x32, 0xeb, 0x26, 0x9b,
      0x01, 0x52, 0x29, 0x7f, 0x6d, 0xf4, 0x90, 0xec, 0xe5, 0x94, 0x96, 0xbe,
      0xa8, 0x04, 0x7e, 0x2f, 0x32, 0xd0, 0xb5, 0xf9, 0x1e, 0x85, 0xef, 0x02,
      0x42, 0x00, 0xc9, 0xeb, 0x0b, 0x56, 0x27, 0x31, 0x14, 0xce, 0x2e, 0x55,
      0x33, 0x41, 0x24, 0x7d, 0xa8, 0x6b, 0x81, 0x3b, 0xfd, 0x65, 0xf1, 0x43,
      0xa5, 0x56, 0x2b, 0xb1, 0xc8, 0x74, 0xff, 0x97, 0x05, 0x23, 0x83, 0x6b,
      0xcd, 0xf3, 0x90, 0xdc, 0x19, 0x6e, 0x67, 0xdd, 0x75, 0xcd, 0x28, 0x11,
      0x2e, 0xf7, 0x4a, 0xfd, 0x51, 0xb1, 0xfb, 0x35, 0x33, 0x3b, 0xe0, 0x50,
      0x5a, 0x01, 0x2e, 0xfe, 0xbd, 0x4e, 0x22},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x35, 0x30, 0x38, 0x35, 0x33, 0x33, 0x30, 0x37, 0x39, 0x31},
     true},

    // Comment: special case hash
    // tcID: 296
    {SEC_OID_SHA512,
     296,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x59, 0x3f, 0x01, 0x32, 0xf7, 0xb5, 0xc2,
      0x82, 0x35, 0x59, 0x78, 0xa2, 0xcb, 0xa7, 0x3f, 0xd3, 0xbd, 0x5c, 0xe3,
      0x27, 0x20, 0x66, 0xd4, 0xad, 0x9b, 0xd8, 0xbd, 0x8b, 0x3e, 0x2b, 0xe0,
      0x99, 0x00, 0x71, 0xb3, 0x50, 0x9e, 0xa4, 0x45, 0xdd, 0x15, 0x5c, 0xf9,
      0x7e, 0x29, 0x4e, 0x2b, 0x8d, 0x13, 0x55, 0x80, 0x9d, 0x88, 0x0e, 0x10,
      0x70, 0x0e, 0xea, 0xb0, 0xeb, 0x8e, 0xbb, 0xaa, 0x4f, 0x09, 0x02, 0x42,
      0x01, 0x07, 0xeb, 0x3d, 0x5e, 0xd7, 0x5c, 0xbb, 0x9b, 0xcb, 0x92, 0x78,
      0xf2, 0x26, 0x6c, 0x14, 0xc5, 0x7c, 0xf7, 0x03, 0xcb, 0xd8, 0xf7, 0xc7,
      0xde, 0x45, 0xc5, 0x1f, 0x0f, 0x3b, 0xaf, 0x1d, 0xff, 0x6b, 0xb9, 0x2f,
      0x1c, 0xbf, 0x89, 0xba, 0x64, 0x96, 0x77, 0xbc, 0xdc, 0xa7, 0x76, 0xfc,
      0x57, 0xf5, 0x87, 0xce, 0x71, 0x4e, 0x2e, 0x43, 0xe6, 0xcc, 0x52, 0x3f,
      0x0d, 0x0a, 0x28, 0x6d, 0x38, 0xfb},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x37, 0x38, 0x36, 0x36, 0x38, 0x31, 0x33, 0x31, 0x31, 0x39},
     true},

    // Comment: special case hash
    // tcID: 297
    {SEC_OID_SHA512,
     297,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x6d, 0xed, 0x17, 0xfa, 0xd1, 0x0f,
      0x94, 0x5e, 0x3d, 0x95, 0x3b, 0x4f, 0xd3, 0xb7, 0x28, 0x98, 0xc3, 0x70,
      0xf1, 0x51, 0x64, 0xbb, 0x77, 0x12, 0x67, 0x33, 0x85, 0xc1, 0x0b, 0xf3,
      0x92, 0x9b, 0xea, 0x29, 0x3e, 0x08, 0xbf, 0xc3, 0x00, 0x29, 0xa4, 0x65,
      0x13, 0x8a, 0xd4, 0x7a, 0xbe, 0x60, 0x4d, 0xf8, 0x07, 0xb3, 0x17, 0x07,
      0xfe, 0xf5, 0x5a, 0xdf, 0x3e, 0x10, 0x49, 0x20, 0x03, 0x8e, 0x3b, 0x02,
      0x42, 0x00, 0xb7, 0x6b, 0x21, 0x2d, 0x74, 0xe4, 0xb6, 0xeb, 0x99, 0x4d,
      0x92, 0x6e, 0x9e, 0x79, 0x69, 0x75, 0x23, 0x5f, 0xad, 0x90, 0xe3, 0x39,
      0xa2, 0x1a, 0x32, 0x9e, 0x6e, 0xed, 0x3f, 0xe9, 0x6b, 0x6d, 0x3c, 0x0d,
      0x54, 0x26, 0xe8, 0x46, 0x4c, 0x4a, 0x9e, 0xd5, 0xcb, 0xe0, 0x8e, 0xeb,
      0x5e, 0x49, 0x0f, 0x72, 0xe9, 0xe0, 0x40, 0x6c, 0x0d, 0x76, 0xad, 0x07,
      0x6b, 0x47, 0x6d, 0x07, 0xc0, 0x14, 0x4a},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x32, 0x30, 0x38, 0x32, 0x35, 0x33, 0x39, 0x34, 0x32, 0x39},
     true},

    // Comment: special case hash
    // tcID: 298
    {SEC_OID_SHA512,
     298,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x01, 0xf8, 0x62, 0x4f, 0xfa, 0x5a, 0x6a,
      0xa8, 0xd9, 0xd0, 0x4e, 0xd1, 0xc2, 0x27, 0x2e, 0xa5, 0x5f, 0x52, 0x71,
      0xca, 0x2c, 0xfc, 0x9a, 0xa6, 0xa3, 0x77, 0x8a, 0x0b, 0x8a, 0x23, 0x0f,
      0x61, 0x1e, 0x5d, 0x65, 0xaf, 0x18, 0xd8, 0x25, 0x1a, 0x0c, 0xc4, 0xac,
      0xe6, 0x63, 0x87, 0x8c, 0x33, 0x20, 0x52, 0x39, 0xee, 0x7e, 0x83, 0x88,
      0xcc, 0x0a, 0x04, 0x0e, 0xa5, 0x15, 0x15, 0x07, 0x2e, 0x3f, 0x61, 0x02,
      0x41, 0x2c, 0x1e, 0x61, 0x19, 0x72, 0x29, 0xf4, 0x0e, 0x84, 0x0e, 0xa3,
      0x73, 0x25, 0xf3, 0xbd, 0x87, 0xa6, 0xcd, 0x32, 0xd0, 0x80, 0xbd, 0x61,
      0xbb, 0xde, 0x4b, 0x07, 0x2c, 0xf7, 0xa0, 0xc8, 0xa8, 0x9d, 0x40, 0x2c,
      0xd9, 0x23, 0x5c, 0x26, 0xf1, 0x9a, 0x08, 0x4d, 0xdc, 0xeb, 0x1c, 0xc0,
      0xba, 0xe4, 0x00, 0x62, 0x51, 0xcc, 0xbe, 0x10, 0xde, 0x39, 0x54, 0xe8,
      0x5a, 0x8c, 0x5e, 0xfa, 0xf6, 0xcc},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x30, 0x30, 0x36, 0x35, 0x39, 0x35, 0x36, 0x36, 0x39, 0x37},
     true},

    // Comment: special case hash
    // tcID: 299
    {SEC_OID_SHA512,
     299,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x2b, 0x01, 0xc6, 0x60, 0x1c, 0xec,
      0xa9, 0xe5, 0x8e, 0x8a, 0xbb, 0x85, 0xd1, 0xf6, 0x66, 0x3d, 0xf7, 0x0c,
      0xee, 0x76, 0x1a, 0x75, 0x6b, 0x77, 0xe4, 0x52, 0x94, 0xf0, 0x9a, 0xe6,
      0x09, 0xa6, 0xb7, 0x6c, 0xfc, 0xd6, 0x7f, 0x60, 0xe4, 0x7a, 0x34, 0x94,
      0xcb, 0x85, 0x51, 0x1e, 0x33, 0xd9, 0x2a, 0x8d, 0x29, 0x7a, 0x1b, 0x89,
      0xe9, 0xa9, 0x03, 0x8c, 0x0c, 0x5b, 0x78, 0xc3, 0xa3, 0xd4, 0xca, 0x02,
      0x42, 0x01, 0x0e, 0xf5, 0xd2, 0xfa, 0xb5, 0x9b, 0xd4, 0x2e, 0x2e, 0x92,
      0xa2, 0xfc, 0xa7, 0xa9, 0x75, 0xb9, 0x59, 0xdf, 0xb3, 0x72, 0x51, 0x93,
      0x30, 0xde, 0xfc, 0x8f, 0xa8, 0x95, 0x4b, 0xfc, 0xfb, 0x39, 0x7b, 0xa9,
      0x39, 0xed, 0xb6, 0xa9, 0x44, 0xa2, 0xce, 0x9f, 0x6f, 0xaf, 0xbf, 0xcd,
      0xa6, 0x09, 0x2c, 0xdd, 0xf6, 0x28, 0x80, 0x1f, 0x6d, 0xd8, 0xcd, 0x40,
      0xca, 0xd4, 0xd8, 0x09, 0xd5, 0xc1, 0xbf},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x33, 0x30, 0x32, 0x34, 0x31, 0x38, 0x31, 0x36, 0x30, 0x34},
     true},

    // Comment: special case hash
    // tcID: 300
    {SEC_OID_SHA512,
     300,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xc5, 0x4a, 0x33, 0x0b, 0x9d, 0xc4,
      0x7e, 0xb8, 0x8d, 0xbf, 0x60, 0xc9, 0xee, 0x49, 0xf2, 0xc7, 0x51, 0x8c,
      0x0a, 0x78, 0xba, 0xf6, 0x42, 0xc7, 0x41, 0x05, 0xfe, 0x28, 0x3f, 0xa4,
      0xc3, 0x57, 0xff, 0x22, 0x93, 0x1e, 0xf4, 0x2f, 0x92, 0xd1, 0x6d, 0x6a,
      0x0b, 0x80, 0x6e, 0xf7, 0x18, 0x53, 0x9d, 0x21, 0xca, 0xd7, 0x19, 0x55,
      0xa5, 0x30, 0xe2, 0x1c, 0xab, 0x49, 0xa5, 0x6f, 0x56, 0x16, 0x73, 0x02,
      0x42, 0x01, 0xc2, 0xcc, 0x32, 0xc5, 0xa4, 0xd3, 0x35, 0xc4, 0x8d, 0x0c,
      0xbb, 0x04, 0x07, 0xfb, 0x7e, 0x47, 0x29, 0xc5, 0x72, 0x51, 0xaf, 0xbf,
      0x95, 0x34, 0xc5, 0x30, 0x9b, 0x94, 0xe6, 0xaa, 0xe1, 0x36, 0x14, 0xa1,
      0xf2, 0x51, 0x42, 0x52, 0xf4, 0x8c, 0xc7, 0xf1, 0x43, 0xee, 0x76, 0x17,
      0x82, 0xf8, 0xdc, 0xeb, 0xf2, 0xfb, 0x49, 0x0e, 0x08, 0xfd, 0xea, 0xf5,
      0x70, 0xa7, 0xed, 0x9d, 0x28, 0x7d, 0xa2},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x37, 0x37, 0x36, 0x37, 0x38, 0x35, 0x32, 0x38, 0x37, 0x34},
     true},

    // Comment: special case hash
    // tcID: 301
    {SEC_OID_SHA512,
     301,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x46, 0x7b, 0x45, 0x11, 0xb9, 0xd6,
      0x60, 0x1d, 0xa3, 0x55, 0x7b, 0x8e, 0xd4, 0x32, 0xc1, 0x4a, 0x80, 0xe5,
      0x99, 0x98, 0x47, 0xbe, 0x13, 0x6c, 0x75, 0x6a, 0x88, 0xdd, 0x51, 0x34,
      0x68, 0x9b, 0x5a, 0xb7, 0x0d, 0x0a, 0x2e, 0x8f, 0xd8, 0xd6, 0x14, 0x1e,
      0x2b, 0x14, 0x32, 0x82, 0xf9, 0x8a, 0xfb, 0x93, 0xb7, 0xe1, 0x76, 0x09,
      0x52, 0x2d, 0xd9, 0xe6, 0x4c, 0x9e, 0x4a, 0x31, 0xc7, 0xc3, 0x4f, 0x02,
      0x42, 0x00, 0xf5, 0x0e, 0xe6, 0x6a, 0x1d, 0xfb, 0xf8, 0x61, 0x67, 0xba,
      0x59, 0x68, 0xd4, 0xee, 0x35, 0x06, 0xa7, 0xcf, 0xfe, 0x0f, 0x52, 0x1c,
      0x1b, 0xf8, 0x30, 0xd0, 0x86, 0x72, 0x41, 0xe3, 0x45, 0xd3, 0x19, 0xe7,
      0x7e, 0xec, 0xa4, 0x58, 0x58, 0xbb, 0x30, 0x62, 0xac, 0xbf, 0x8d, 0x10,
      0x0b, 0xc6, 0xbf, 0xd3, 0x12, 0x7d, 0x57, 0xa7, 0xe9, 0x1a, 0x81, 0x99,
      0xe0, 0x50, 0x52, 0xb8, 0xcc, 0xf3, 0x04},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x35, 0x34, 0x34, 0x31, 0x39, 0x39, 0x39, 0x37, 0x34},
     true},

    // Comment: special case hash
    // tcID: 302
    {SEC_OID_SHA512,
     302,
     {0x30, 0x81, 0x86, 0x02, 0x41, 0x7a, 0xf9, 0x0f, 0x62, 0x27, 0x75, 0x0f,
      0x91, 0x7d, 0x65, 0xb1, 0xc6, 0x02, 0x00, 0xc7, 0x55, 0x15, 0x8b, 0xb7,
      0x83, 0xa4, 0x79, 0xbe, 0x68, 0x77, 0xc5, 0x9e, 0xd8, 0x9f, 0xf5, 0x95,
      0xfe, 0xa3, 0xf3, 0xa4, 0x13, 0x75, 0x91, 0xaa, 0xb2, 0x38, 0x26, 0xed,
      0x38, 0x5b, 0xd6, 0x15, 0x62, 0x77, 0x36, 0x4b, 0x5d, 0x60, 0x3c, 0xa2,
      0x72, 0x25, 0x90, 0x83, 0xe6, 0xe9, 0xab, 0x5d, 0xb3, 0xf9, 0x02, 0x41,
      0x70, 0x84, 0x2e, 0xb6, 0x2c, 0x89, 0x49, 0x35, 0xb8, 0x2d, 0xa1, 0x5c,
      0xa6, 0x11, 0xd9, 0xd7, 0x54, 0xef, 0x57, 0x85, 0x9e, 0x0c, 0x91, 0x2c,
      0x03, 0x58, 0xd0, 0x82, 0x0f, 0x49, 0x40, 0xcd, 0xf5, 0x36, 0x0f, 0x11,
      0x6a, 0x75, 0x47, 0xa8, 0x1b, 0xf6, 0x56, 0x17, 0xf1, 0x82, 0xe5, 0x97,
      0xeb, 0x10, 0x07, 0xe2, 0x6c, 0x62, 0x83, 0x84, 0x87, 0xca, 0x02, 0x1c,
      0x38, 0x29, 0xa5, 0x90, 0xdb},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x35, 0x38, 0x34, 0x33, 0x34, 0x38, 0x30, 0x33, 0x39, 0x31},
     true},

    // Comment: special case hash
    // tcID: 303
    {SEC_OID_SHA512,
     303,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xb0, 0x16, 0x9e, 0x68, 0x06, 0x2c,
      0xaa, 0x79, 0xf9, 0x9e, 0xc0, 0xc7, 0x2d, 0x83, 0xc4, 0xd0, 0xfc, 0x2a,
      0x1c, 0x81, 0x86, 0x65, 0xcf, 0xed, 0x1a, 0xba, 0x3e, 0x68, 0x43, 0x92,
      0xb9, 0xa9, 0x5a, 0xfb, 0x82, 0xdd, 0xd1, 0xde, 0x49, 0xe3, 0xfc, 0x3c,
      0xb3, 0x88, 0x9b, 0x4f, 0x5a, 0x86, 0xa7, 0xbd, 0xf9, 0x44, 0x36, 0x1d,
      0xb2, 0xcf, 0xa5, 0x70, 0x21, 0xa7, 0x64, 0x3f, 0xcf, 0xce, 0x95, 0x02,
      0x42, 0x01, 0x15, 0xec, 0x78, 0x4e, 0x04, 0x24, 0x36, 0x89, 0x2c, 0x6c,
      0xc1, 0xbe, 0xde, 0x0f, 0x4b, 0x7b, 0x6e, 0xb2, 0x4b, 0x30, 0x0b, 0x1f,
      0x0c, 0x67, 0x49, 0x99, 0xa6, 0xda, 0x81, 0x6d, 0xbe, 0xfb, 0x2d, 0x53,
      0xf9, 0x0b, 0x0d, 0xed, 0xb9, 0x62, 0xa0, 0x85, 0xe5, 0x20, 0x9f, 0xce,
      0xa5, 0x03, 0x11, 0x13, 0x08, 0x00, 0xd2, 0xa9, 0x24, 0x9d, 0x27, 0x9c,
      0x7b, 0xde, 0x2f, 0x88, 0x62, 0x25, 0x12},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x37, 0x31, 0x38, 0x38, 0x39, 0x32, 0x36, 0x32, 0x39},
     true},

    // Comment: special case hash
    // tcID: 304
    {SEC_OID_SHA512,
     304,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xde, 0x4e, 0xd1, 0xee, 0x81, 0xd5,
      0xcf, 0xfc, 0xf8, 0x25, 0x6a, 0x06, 0x85, 0x8c, 0xba, 0x5e, 0xb9, 0x25,
      0xee, 0x68, 0xe3, 0xed, 0x84, 0x8a, 0xc9, 0x80, 0x71, 0xb6, 0xe3, 0x0c,
      0x3b, 0x44, 0xb1, 0x02, 0xa2, 0xde, 0x81, 0x17, 0xcc, 0xe5, 0xb4, 0xf9,
      0xe4, 0x26, 0x03, 0x22, 0x5e, 0x0d, 0xbc, 0xb3, 0xfc, 0xc1, 0x71, 0xd1,
      0x49, 0x2e, 0x7e, 0xd8, 0xbc, 0xb6, 0xec, 0x28, 0x6c, 0x7d, 0xe0, 0x02,
      0x42, 0x00, 0xfd, 0x1e, 0x93, 0xbb, 0xc8, 0xb8, 0xad, 0xeb, 0x78, 0x64,
      0xa2, 0xbf, 0x8e, 0x29, 0xd6, 0xf9, 0xc0, 0x96, 0x6f, 0xe3, 0xd5, 0x43,
      0x52, 0x5b, 0xf2, 0x68, 0xb5, 0x7c, 0xd6, 0xfa, 0x88, 0x52, 0xbf, 0xe0,
      0xd2, 0x75, 0x07, 0x26, 0xd5, 0x44, 0x55, 0x60, 0xf2, 0xfc, 0x21, 0x1a,
      0xa7, 0x85, 0x9d, 0xd3, 0xee, 0x10, 0x07, 0x8e, 0xf9, 0x07, 0xe4, 0x9c,
      0xd6, 0x43, 0x26, 0xb3, 0x97, 0xe0, 0x1c},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x37, 0x34, 0x33, 0x32, 0x32, 0x33, 0x34, 0x34, 0x33},
     true},

    // Comment: special case hash
    // tcID: 305
    {SEC_OID_SHA512,
     305,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xfc, 0xaf, 0xa6, 0x2e, 0xe6, 0x27,
      0x54, 0x43, 0xd7, 0x27, 0x7f, 0xc4, 0x6e, 0x4c, 0x30, 0xb4, 0xdb, 0x84,
      0x5b, 0xa4, 0x5b, 0x5d, 0x6b, 0x54, 0xfa, 0xf4, 0x7b, 0xbf, 0x92, 0x1f,
      0x82, 0x5f, 0x6f, 0xd0, 0xf2, 0x3a, 0x38, 0xc0, 0xc7, 0xf4, 0xde, 0xbc,
      0x33, 0xad, 0xd2, 0x82, 0xaf, 0xad, 0x11, 0x54, 0xc8, 0x70, 0x7b, 0x6e,
      0x18, 0xcd, 0x65, 0xad, 0xcb, 0x07, 0xd3, 0x29, 0x15, 0xb4, 0x62, 0x02,
      0x42, 0x00, 0x87, 0xa2, 0x7b, 0x2b, 0xf3, 0xc3, 0x5d, 0x18, 0xfd, 0x39,
      0x7e, 0x0c, 0xd7, 0x15, 0x95, 0x16, 0xcf, 0x56, 0x3b, 0x98, 0x44, 0x1e,
      0x03, 0x0b, 0xfd, 0xe9, 0x3c, 0xea, 0xcd, 0x2c, 0x4e, 0x41, 0x22, 0x8b,
      0x7b, 0x33, 0x44, 0x3e, 0xf0, 0xa3, 0x51, 0xce, 0x55, 0x3d, 0x6d, 0x1d,
      0x71, 0xc1, 0x20, 0x92, 0xdf, 0x79, 0x62, 0x76, 0x17, 0x5c, 0xd7, 0x79,
      0xb8, 0x09, 0x0c, 0x49, 0x58, 0xb3, 0x91},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x32, 0x34, 0x30, 0x36, 0x30, 0x30, 0x35, 0x39, 0x33, 0x36},
     true},

    // Comment: special case hash
    // tcID: 306
    {SEC_OID_SHA512,
     306,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x78, 0x98, 0x96, 0x28, 0xac, 0xfb, 0xa8,
      0x6d, 0x4b, 0xf2, 0x8b, 0xee, 0xb9, 0xf4, 0x40, 0x01, 0xfb, 0x8f, 0x2d,
      0x8e, 0x24, 0x53, 0x20, 0xa1, 0x9e, 0xfd, 0xed, 0xe3, 0x1e, 0xae, 0x3e,
      0xc8, 0xb4, 0x96, 0xfa, 0xec, 0x30, 0xc8, 0x5e, 0x8f, 0x63, 0xf8, 0xae,
      0x06, 0x04, 0x6f, 0xe1, 0xd1, 0x57, 0x53, 0x21, 0xfa, 0x04, 0x95, 0x3e,
      0x46, 0x0f, 0x6b, 0x13, 0x86, 0xdd, 0x5d, 0xf9, 0x4e, 0xdb, 0x02, 0x42,
      0x01, 0x2a, 0xba, 0x33, 0x49, 0x73, 0x2e, 0x21, 0xa5, 0xbb, 0x27, 0xd7,
      0xd6, 0xfa, 0xcd, 0x8c, 0x76, 0x88, 0xb9, 0xd0, 0xd0, 0x27, 0x1d, 0x6a,
      0x07, 0x7f, 0x9d, 0x6d, 0x82, 0xdb, 0x45, 0xb5, 0x45, 0x6b, 0x76, 0x7f,
      0x4b, 0x9f, 0x1a, 0x80, 0xf4, 0x87, 0x03, 0x1f, 0x9c, 0x0b, 0x3e, 0xa8,
      0x33, 0xc6, 0x3f, 0xdf, 0x9c, 0x6a, 0x25, 0xe6, 0xb4, 0x24, 0xc1, 0x9c,
      0x2e, 0x55, 0x30, 0x5d, 0x7a, 0x0f},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x36, 0x31, 0x34, 0x30, 0x33, 0x36, 0x39, 0x38, 0x38},
     true},

    // Comment: special case hash
    // tcID: 307
    {SEC_OID_SHA512,
     307,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x14, 0xa5, 0xa4, 0x6a, 0x3b, 0xa4, 0x15,
      0xf6, 0xe8, 0xc5, 0x66, 0xca, 0x1b, 0x15, 0xfa, 0x20, 0x55, 0x64, 0x96,
      0x87, 0xb1, 0xa9, 0xfc, 0x84, 0xcc, 0x0f, 0xa8, 0x63, 0x12, 0x96, 0x89,
      0x8f, 0xe0, 0x14, 0xe0, 0xd4, 0x59, 0x27, 0xe4, 0x27, 0x13, 0x96, 0xba,
      0xa4, 0xcf, 0xb3, 0x67, 0x56, 0x69, 0xb1, 0x6e, 0x76, 0xc3, 0x39, 0xdb,
      0x3c, 0x0e, 0xda, 0xf6, 0x13, 0x37, 0xe8, 0xbe, 0xbe, 0x91, 0x02, 0x42,
      0x01, 0xfb, 0x31, 0x31, 0x29, 0x75, 0x7f, 0x76, 0x75, 0x4b, 0x60, 0xfd,
      0xb1, 0xe4, 0x07, 0x7f, 0x9f, 0xe3, 0xdd, 0x62, 0xc8, 0xbc, 0xe5, 0x21,
      0x90, 0xcf, 0xeb, 0x9c, 0x03, 0x02, 0x1c, 0xc9, 0x2f, 0x6d, 0x7d, 0x13,
      0x02, 0xb8, 0xa8, 0x47, 0x33, 0x48, 0x6b, 0xf7, 0x69, 0xae, 0x94, 0xd3,
      0xdb, 0x4b, 0x60, 0xb6, 0xdf, 0x28, 0xfe, 0xd4, 0x81, 0xd3, 0xd7, 0xc5,
      0x10, 0x29, 0x9f, 0x0c, 0x31, 0x9f},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x32, 0x30, 0x39, 0x35, 0x34, 0x32, 0x35, 0x36, 0x38, 0x35},
     true},

    // Comment: special case hash
    // tcID: 308
    {SEC_OID_SHA512,
     308,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x00, 0x8a, 0x32, 0x50, 0xeb, 0x5f, 0x28,
      0xb5, 0x98, 0xc4, 0xa4, 0x28, 0x90, 0xd2, 0x5f, 0x6a, 0xf8, 0x40, 0x82,
      0xd4, 0x37, 0x6f, 0x84, 0xf1, 0x71, 0x7e, 0x51, 0x12, 0xa7, 0x66, 0x23,
      0xe6, 0xfe, 0x0d, 0x20, 0x7c, 0x39, 0x46, 0x3d, 0x20, 0xbb, 0x86, 0x34,
      0x1b, 0xc2, 0x6c, 0x9f, 0x68, 0xbc, 0xdf, 0x79, 0x46, 0x71, 0xa0, 0x1f,
      0x90, 0x46, 0x50, 0x25, 0xf8, 0x7a, 0x8c, 0x52, 0x13, 0x7e, 0xdf, 0x02,
      0x41, 0x1d, 0xdd, 0x31, 0x7f, 0x66, 0x22, 0xd9, 0xb0, 0x32, 0x22, 0x3f,
      0x76, 0x76, 0x5b, 0xa6, 0xc9, 0x11, 0x6a, 0xe4, 0xb4, 0x3a, 0x1b, 0xd3,
      0x57, 0xbc, 0x9d, 0xb6, 0xfa, 0x62, 0xf0, 0x86, 0x7d, 0xc5, 0xd8, 0xf7,
      0x81, 0xf0, 0x8c, 0x1c, 0xbd, 0x49, 0xb4, 0x42, 0x4f, 0xe8, 0xc2, 0x2c,
      0xfd, 0x1d, 0xcd, 0x07, 0xcf, 0xde, 0x7b, 0x35, 0x98, 0x34, 0x24, 0x42,
      0x58, 0x98, 0x25, 0xaa, 0x67, 0xf7},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x30, 0x30, 0x38, 0x30, 0x39, 0x38, 0x39, 0x38, 0x33},
     true},

    // Comment: special case hash
    // tcID: 309
    {SEC_OID_SHA512,
     309,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x60, 0xee, 0x16, 0x17, 0x41, 0xd5, 0xcb,
      0x2d, 0xd0, 0xff, 0x2c, 0xf9, 0x92, 0x4a, 0xca, 0x03, 0x76, 0xb1, 0x54,
      0x46, 0x81, 0x62, 0x7a, 0x31, 0x68, 0x8e, 0x4d, 0x8b, 0x3b, 0x63, 0xa0,
      0x1a, 0xdb, 0xb4, 0x17, 0xee, 0x11, 0x3b, 0x9b, 0xa8, 0xd4, 0xd1, 0x3b,
      0x7b, 0x4e, 0x1b, 0x14, 0xb5, 0x1a, 0x24, 0xdb, 0xc3, 0xf0, 0x99, 0xb0,
      0x68, 0xd9, 0x16, 0xaa, 0x94, 0x86, 0x2e, 0xe0, 0x81, 0xb4, 0x02, 0x42,
      0x01, 0x5c, 0xaf, 0xf8, 0xd3, 0x01, 0x41, 0xe1, 0xc1, 0x63, 0xe3, 0xec,
      0x62, 0xb7, 0xe1, 0x48, 0x74, 0xda, 0x62, 0x4a, 0x6d, 0x8e, 0x02, 0x52,
      0xd8, 0xe8, 0x29, 0x86, 0x0e, 0x5a, 0x49, 0xd3, 0x73, 0x23, 0x21, 0xb6,
      0x25, 0x26, 0x2e, 0x5c, 0x9b, 0x1e, 0xf3, 0x48, 0xc3, 0xe7, 0xcb, 0xb1,
      0xde, 0x82, 0x27, 0x51, 0x3f, 0x32, 0x06, 0x37, 0x86, 0x67, 0x85, 0xe9,
      0x7e, 0x19, 0x31, 0xd3, 0x5c, 0xcb},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x35, 0x37, 0x34, 0x31, 0x34, 0x37, 0x39, 0x32, 0x37},
     true},

    // Comment: special case hash
    // tcID: 310
    {SEC_OID_SHA512,
     310,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xa1, 0xef, 0x82, 0x29, 0xdb, 0x9f,
      0x45, 0xda, 0x38, 0xae, 0x3b, 0x6d, 0x60, 0x11, 0x10, 0x61, 0x1e, 0x20,
      0x98, 0x78, 0xbb, 0xd0, 0x3a, 0xc2, 0xa6, 0xde, 0x65, 0xe8, 0x40, 0x29,
      0x57, 0xc6, 0x69, 0xa1, 0x15, 0xe3, 0xf0, 0x2d, 0x08, 0x5f, 0xe2, 0xd0,
      0x31, 0xc6, 0x13, 0x24, 0xb7, 0x70, 0x52, 0xab, 0x34, 0x6b, 0x4b, 0x1a,
      0x43, 0x7b, 0x58, 0x06, 0x2f, 0xb3, 0x6f, 0x9d, 0x56, 0xcf, 0x45, 0x02,
      0x42, 0x00, 0xcc, 0x5c, 0x0a, 0x3b, 0x68, 0x97, 0x02, 0x79, 0xae, 0x16,
      0x88, 0x0f, 0x6c, 0xa5, 0x79, 0xd0, 0x17, 0x1a, 0x82, 0x7e, 0x99, 0xa4,
      0x6a, 0xa8, 0x2b, 0x92, 0x42, 0xdc, 0xc0, 0x9c, 0xb0, 0xb2, 0x2a, 0x44,
      0xeb, 0xcf, 0xca, 0x84, 0x29, 0x3e, 0x6d, 0x21, 0xae, 0xea, 0x49, 0x2f,
      0x00, 0xba, 0x31, 0x57, 0xc5, 0xb6, 0xe2, 0xe4, 0xca, 0xea, 0x6a, 0x1c,
      0x09, 0xc8, 0x24, 0x72, 0x05, 0x52, 0xf2},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x32, 0x38, 0x36, 0x36, 0x37, 0x37, 0x31, 0x35, 0x32, 0x32},
     true},

    // Comment: special case hash
    // tcID: 311
    {SEC_OID_SHA512,
     311,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x5a, 0xa0, 0xc8, 0xa3, 0x78, 0xc4, 0xe0,
      0x2b, 0xcc, 0x2f, 0x56, 0xc2, 0xc3, 0x65, 0xcc, 0xee, 0x42, 0x4e, 0x29,
      0x73, 0xc2, 0x8f, 0x0d, 0xaa, 0xe8, 0xf4, 0xc3, 0xf0, 0xd9, 0x0b, 0x42,
      0x1f, 0xef, 0xd4, 0x56, 0xe7, 0x49, 0x08, 0x7e, 0x0c, 0x66, 0x7c, 0x2a,
      0x71, 0x47, 0xbc, 0x67, 0xb9, 0x0c, 0x69, 0x62, 0x44, 0xf2, 0x16, 0xb4,
      0xd9, 0xd7, 0x41, 0x8e, 0xad, 0xc7, 0xd0, 0x6e, 0xf1, 0xd2, 0x02, 0x42,
      0x01, 0xe2, 0x89, 0x14, 0xbd, 0x34, 0x1f, 0x52, 0x6b, 0x04, 0x11, 0x28,
      0xf2, 0xd2, 0x51, 0x13, 0x1d, 0x8b, 0x2c, 0x65, 0x84, 0x7e, 0x54, 0x1d,
      0x65, 0xad, 0xca, 0x34, 0x42, 0x96, 0x2c, 0xdd, 0xb2, 0xa7, 0x1c, 0x64,
      0xfa, 0xe3, 0x9f, 0xdd, 0x56, 0xe4, 0x16, 0x86, 0xad, 0x63, 0x2f, 0x99,
      0xc6, 0x03, 0x8d, 0x8d, 0xe0, 0xb3, 0xaa, 0xc4, 0x04, 0x5e, 0x0a, 0x96,
      0x1e, 0xfd, 0xbf, 0x4c, 0x6a, 0x22},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x36, 0x39, 0x34, 0x32, 0x38, 0x30, 0x37, 0x38, 0x37},
     true},

    // Comment: special case hash
    // tcID: 312
    {SEC_OID_SHA512,
     312,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x5a, 0x05, 0xf5, 0x36, 0x6c, 0x8b, 0x8b,
      0xe2, 0x86, 0x54, 0xbc, 0x39, 0xa6, 0x67, 0x1d, 0x1b, 0x15, 0x93, 0x49,
      0x5e, 0x44, 0x5c, 0x07, 0xc9, 0x95, 0xc3, 0xbe, 0x3e, 0x16, 0x8f, 0xfd,
      0xec, 0x92, 0xe4, 0x42, 0x88, 0x80, 0x2f, 0xd4, 0x55, 0x00, 0x7f, 0x87,
      0x46, 0x57, 0x0d, 0x93, 0xb5, 0x68, 0x3e, 0x4d, 0x40, 0xe9, 0xd9, 0xe5,
      0x9d, 0xe5, 0x39, 0xf0, 0xe6, 0x2b, 0xc4, 0x0d, 0x92, 0xbc, 0x02, 0x42,
      0x01, 0x87, 0xa4, 0x7d, 0x8f, 0x70, 0xad, 0xcc, 0x5e, 0x10, 0x26, 0x7b,
      0x8f, 0xec, 0x89, 0xd7, 0x01, 0x1d, 0x99, 0x85, 0x42, 0x76, 0x45, 0xae,
      0xd1, 0x9a, 0x8e, 0xfa, 0x2d, 0x11, 0x89, 0xb4, 0x69, 0xcb, 0x7a, 0xab,
      0x19, 0x98, 0xe0, 0xc1, 0xd2, 0xfc, 0xac, 0x5a, 0x50, 0x54, 0xd7, 0x9d,
      0x2e, 0xc1, 0xc9, 0xa0, 0x0b, 0x18, 0x3d, 0xc9, 0xaf, 0x20, 0xf5, 0x55,
      0xa1, 0x14, 0x0b, 0xe2, 0xdc, 0xef},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x39, 0x39, 0x32, 0x31, 0x36, 0x39, 0x32, 0x35, 0x36, 0x38},
     true},

    // Comment: special case hash
    // tcID: 313
    {SEC_OID_SHA512,
     313,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x01, 0xe2, 0x13, 0xbc, 0xb8, 0xb9, 0x60,
      0xb1, 0x29, 0x6a, 0xe1, 0x76, 0x99, 0x3b, 0x24, 0x49, 0xba, 0xe5, 0x56,
      0xb6, 0xd9, 0x0d, 0xf2, 0xf0, 0x7f, 0xb0, 0x8a, 0xd8, 0xfd, 0x60, 0xe3,
      0xb7, 0xfe, 0x6c, 0x73, 0xf9, 0xc8, 0xa7, 0x36, 0x44, 0x17, 0x61, 0x1d,
      0x60, 0x11, 0x9c, 0x55, 0x02, 0x61, 0xc5, 0x4b, 0xbc, 0xa8, 0xd6, 0x1e,
      0x26, 0x41, 0x30, 0xab, 0x90, 0x18, 0x7e, 0x27, 0xd2, 0x2d, 0xbd, 0x02,
      0x41, 0x34, 0xf5, 0x19, 0x38, 0x2c, 0xfa, 0xcf, 0xd0, 0x7b, 0x0a, 0x6f,
      0x3a, 0xca, 0x11, 0x7c, 0x13, 0xd2, 0xbe, 0x72, 0x5d, 0x2f, 0x9e, 0xe4,
      0xe5, 0xf8, 0x87, 0x39, 0xc9, 0x91, 0x21, 0xe6, 0x3e, 0xd7, 0x35, 0x80,
      0x46, 0xbf, 0xb1, 0x57, 0x5f, 0xc7, 0x3e, 0x1e, 0xde, 0x83, 0x39, 0xe4,
      0x6c, 0x51, 0x39, 0x84, 0x3e, 0x52, 0xe9, 0x18, 0x4b, 0xb8, 0xc5, 0x79,
      0x06, 0x1a, 0x15, 0x4a, 0x0b, 0x8f},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x31, 0x36, 0x30, 0x39, 0x34, 0x33, 0x39, 0x37, 0x39, 0x38},
     true},

    // Comment: special case hash
    // tcID: 314
    {SEC_OID_SHA512,
     314,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xed, 0x11, 0xac, 0x7e, 0xfb, 0x1f,
      0x29, 0xee, 0x64, 0x10, 0x8a, 0x5e, 0x26, 0x06, 0xfa, 0x9a, 0xf3, 0xbb,
      0xc1, 0x2d, 0x1a, 0x95, 0x2e, 0x47, 0x24, 0x0d, 0x52, 0x36, 0xdf, 0x64,
      0xf5, 0xb2, 0xb7, 0x7a, 0x0f, 0x7a, 0x0a, 0x73, 0xd3, 0x0d, 0x07, 0x08,
      0xb5, 0xb2, 0x3a, 0xc6, 0xd5, 0x84, 0xbf, 0x69, 0x97, 0xd8, 0x85, 0x16,
      0x23, 0x79, 0x36, 0x55, 0xde, 0xe8, 0x77, 0x45, 0x49, 0xb8, 0x29, 0x02,
      0x42, 0x01, 0xe1, 0x60, 0x2a, 0x2c, 0xae, 0x7d, 0x32, 0x12, 0xdf, 0x47,
      0xee, 0xbd, 0x12, 0xe2, 0xfe, 0x40, 0x48, 0x51, 0x20, 0x11, 0x01, 0xbb,
      0xde, 0x70, 0x2b, 0xe9, 0xd7, 0x4d, 0x04, 0x0e, 0xd9, 0x98, 0xe7, 0x9a,
      0x09, 0xeb, 0xf6, 0xd0, 0x55, 0xf9, 0x44, 0x73, 0xb1, 0xf8, 0xd8, 0x7c,
      0x99, 0xaa, 0x16, 0x5b, 0xda, 0xf0, 0xa5, 0xf2, 0x70, 0xd4, 0x6c, 0xaa,
      0xbb, 0x8e, 0x88, 0xbf, 0xa5, 0x41, 0x03},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x37, 0x31, 0x38, 0x36, 0x31, 0x36, 0x32, 0x31, 0x30, 0x30},
     true},

    // Comment: special case hash
    // tcID: 315
    {SEC_OID_SHA512,
     315,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x07, 0x12, 0x3c, 0x45, 0xe6, 0xe9, 0x33,
      0x8b, 0xc9, 0xfe, 0x22, 0x5c, 0xdd, 0x96, 0xc5, 0xab, 0x36, 0xca, 0xd5,
      0xc0, 0x61, 0x63, 0xf4, 0x4f, 0x6b, 0xd9, 0x03, 0xc7, 0x59, 0x4e, 0x80,
      0x68, 0xba, 0x9b, 0xc8, 0x9f, 0x65, 0x2e, 0xc3, 0x1b, 0x6e, 0x12, 0x98,
      0x76, 0x6b, 0x24, 0x6c, 0x1f, 0x10, 0x87, 0x7f, 0x1e, 0x3e, 0xc9, 0x82,
      0x9b, 0x09, 0x37, 0xb8, 0xd3, 0x6e, 0x3c, 0x1a, 0xb2, 0xb5, 0x02, 0x42,
      0x01, 0x68, 0x8b, 0xba, 0xeb, 0x18, 0x8b, 0x50, 0x47, 0xbe, 0x6e, 0x80,
      0x23, 0xb1, 0x4f, 0xb1, 0x21, 0xeb, 0x14, 0x51, 0xdc, 0xb1, 0x9f, 0x81,
      0x4f, 0x5f, 0x4d, 0xca, 0x55, 0xff, 0x95, 0x12, 0x80, 0x11, 0xe3, 0xba,
      0xe5, 0x05, 0xa4, 0xd2, 0x21, 0x66, 0xd0, 0x0c, 0xb7, 0xcf, 0x14, 0x13,
      0x05, 0x90, 0x33, 0x5e, 0xe9, 0x23, 0xdc, 0x5d, 0xb3, 0xe7, 0x36, 0x83,
      0x2a, 0x12, 0x8a, 0x06, 0x7a, 0xa4},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x33, 0x32, 0x39, 0x34, 0x33, 0x34, 0x37, 0x31, 0x37, 0x37},
     true},

    // Comment: special case hash
    // tcID: 316
    {SEC_OID_SHA512,
     316,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x01, 0x26, 0x4e, 0x3c, 0xc4, 0xfb, 0x80,
      0x2a, 0xa2, 0x21, 0xd0, 0x78, 0x7c, 0xd0, 0xcd, 0xf4, 0x4e, 0xb6, 0x56,
      0x89, 0x82, 0xa0, 0x0a, 0x66, 0x39, 0xf1, 0x52, 0x38, 0xaf, 0x36, 0xe8,
      0x94, 0xb1, 0x4f, 0x45, 0xf0, 0x6f, 0x8c, 0x21, 0x80, 0xfd, 0xea, 0xaa,
      0xc7, 0x7f, 0x67, 0x4e, 0x05, 0x6d, 0x19, 0x28, 0xcb, 0xbd, 0xfc, 0x4b,
      0x2c, 0xec, 0xa0, 0xb3, 0x53, 0x45, 0xca, 0x07, 0xbf, 0xff, 0x7f, 0x02,
      0x41, 0x5c, 0x2d, 0xed, 0xee, 0x6b, 0x3a, 0xa0, 0x96, 0xfc, 0x47, 0xba,
      0x09, 0x91, 0xa0, 0x77, 0xef, 0x4d, 0x5d, 0xf2, 0x0d, 0x8e, 0xff, 0x1b,
      0xf8, 0x35, 0x44, 0x12, 0xb1, 0x71, 0xf0, 0x8a, 0x98, 0xce, 0xa1, 0x70,
      0x4c, 0x81, 0x89, 0xa7, 0x95, 0x1b, 0x0e, 0x7a, 0x82, 0x70, 0xcc, 0xb2,
      0x85, 0xb8, 0xdb, 0x8e, 0x35, 0x28, 0x5e, 0xd9, 0x26, 0xb1, 0x9c, 0x1e,
      0xef, 0x07, 0xfd, 0xc0, 0x5e, 0xe5},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x38, 0x35, 0x31, 0x34, 0x34, 0x35, 0x35, 0x31, 0x32, 0x30},
     true},

    // Comment: special case hash
    // tcID: 317
    {SEC_OID_SHA512,
     317,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xca, 0x38, 0x14, 0x74, 0x78, 0x88,
      0x75, 0x17, 0x94, 0xb0, 0x48, 0x89, 0x55, 0xe2, 0xae, 0xe0, 0x7e, 0x5f,
      0xab, 0x4b, 0x98, 0x72, 0x07, 0x4a, 0xa7, 0x43, 0x26, 0x98, 0xe7, 0xc8,
      0x3b, 0x80, 0x79, 0x77, 0x37, 0x34, 0xdf, 0x1b, 0xc7, 0x52, 0x54, 0x8a,
      0x21, 0x8f, 0xa5, 0x9a, 0x36, 0x2e, 0x06, 0x57, 0xb7, 0x7a, 0xe7, 0x79,
      0x8e, 0xf4, 0xa7, 0xa3, 0x87, 0x32, 0x56, 0xea, 0x59, 0xec, 0x67, 0x02,
      0x42, 0x01, 0x5d, 0xf8, 0xf1, 0xf1, 0x66, 0x11, 0xc9, 0x60, 0xd5, 0x66,
      0x47, 0x42, 0x4b, 0x97, 0x93, 0x6c, 0x8a, 0x06, 0xf6, 0x2d, 0xc3, 0xa9,
      0x5d, 0x66, 0xbf, 0x4a, 0xa3, 0x78, 0xd7, 0xa9, 0xe1, 0x7d, 0x2a, 0xfb,
      0x53, 0x56, 0x57, 0x80, 0x02, 0x59, 0x27, 0xe6, 0x92, 0x8f, 0x53, 0x13,
      0x42, 0x8f, 0x1d, 0x67, 0x08, 0x33, 0x97, 0x87, 0xc8, 0xf4, 0x60, 0xba,
      0x18, 0x45, 0x7d, 0x4c, 0x0f, 0x52, 0x1f},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x34, 0x37, 0x36, 0x30, 0x34, 0x33, 0x39, 0x33, 0x30},
     true},

    // Comment: special case hash
    // tcID: 318
    {SEC_OID_SHA512,
     318,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x01, 0x7b, 0xa8, 0x71, 0xae, 0xe3, 0x4a,
      0x89, 0x3c, 0x4d, 0xed, 0x7a, 0x2a, 0x54, 0x6d, 0xa0, 0xd6, 0x86, 0x7d,
      0x42, 0x84, 0x97, 0xb8, 0x0f, 0xca, 0x7e, 0xea, 0x6e, 0x51, 0xb7, 0x3d,
      0x64, 0x11, 0xaf, 0xf7, 0x60, 0x97, 0x43, 0xe6, 0x24, 0x2b, 0x6d, 0x4d,
      0x37, 0x36, 0xdd, 0xcc, 0x9e, 0xe1, 0xaa, 0x12, 0xc8, 0xb6, 0x2d, 0xe5,
      0x38, 0x2e, 0x5c, 0x33, 0xd1, 0xfc, 0x48, 0x53, 0xe3, 0xe4, 0x7d, 0x02,
      0x41, 0x5f, 0xeb, 0x9d, 0x9f, 0x8f, 0xdd, 0x44, 0x62, 0x2e, 0x4f, 0x9e,
      0xff, 0xe7, 0x3f, 0xd9, 0xb4, 0x67, 0xd3, 0x55, 0xfd, 0x6b, 0x8d, 0xe2,
      0x05, 0x52, 0x7f, 0x72, 0x2e, 0xe2, 0xf5, 0xa1, 0x5e, 0xeb, 0xd5, 0x9c,
      0xcd, 0xd7, 0xb5, 0x7d, 0xa2, 0x6c, 0xf9, 0x53, 0xf7, 0x88, 0x86, 0xdb,
      0x5a, 0x6e, 0x5b, 0xdd, 0x0d, 0x56, 0xc9, 0xbd, 0x47, 0xba, 0x22, 0x71,
      0xf7, 0x76, 0x87, 0xa6, 0x4b, 0x63},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x32, 0x35, 0x36, 0x37, 0x33, 0x37, 0x38, 0x37, 0x34, 0x31},
     true},

    // Comment: special case hash
    // tcID: 319
    {SEC_OID_SHA512,
     319,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x84, 0x07, 0x93, 0x68, 0x47, 0x65,
      0x41, 0x0b, 0xaf, 0x26, 0xb6, 0x6c, 0xbc, 0xf7, 0xc3, 0x66, 0x58, 0xd6,
      0xc1, 0x8a, 0x2f, 0x75, 0x0c, 0x12, 0x25, 0x52, 0x0e, 0x9f, 0x3a, 0x7c,
      0x1b, 0x89, 0x05, 0x83, 0xf3, 0x21, 0xd4, 0xe4, 0x87, 0x52, 0xc3, 0xb3,
      0x11, 0x6d, 0xfe, 0xf7, 0x33, 0xee, 0x38, 0x6c, 0x52, 0xa5, 0x34, 0x02,
      0xac, 0xea, 0x77, 0xcf, 0xad, 0x1d, 0xb9, 0x38, 0x01, 0x10, 0xe6, 0x02,
      0x42, 0x01, 0xb5, 0x19, 0x85, 0xa3, 0x06, 0xfc, 0xdb, 0xe3, 0x69, 0x21,
      0x81, 0x10, 0x6d, 0x7d, 0x63, 0x08, 0x87, 0x39, 0x12, 0xd0, 0x03, 0x94,
      0x69, 0x92, 0x09, 0x8b, 0xc9, 0x8b, 0x42, 0x61, 0xfd, 0x78, 0x86, 0x9e,
      0xd8, 0x21, 0x88, 0x49, 0x45, 0x97, 0x80, 0xb6, 0x07, 0x9f, 0x68, 0x99,
      0xa4, 0x7f, 0xcb, 0x9e, 0xa4, 0x87, 0x4d, 0x1c, 0x08, 0xfa, 0xb8, 0x2c,
      0x6f, 0x1e, 0x9c, 0x9a, 0xaa, 0xe2, 0x45},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x35, 0x37, 0x33, 0x39, 0x39, 0x33, 0x34, 0x39, 0x39, 0x35},
     true},

    // Comment: special case hash
    // tcID: 320
    {SEC_OID_SHA512,
     320,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x01, 0x22, 0x76, 0x72, 0x0b, 0x27, 0x25,
      0xba, 0x55, 0x6d, 0x06, 0xbe, 0x39, 0xcd, 0x16, 0xca, 0x0a, 0x03, 0x51,
      0xd8, 0xf5, 0x30, 0x91, 0x3c, 0x4f, 0x0c, 0xfb, 0x71, 0xfd, 0xda, 0x74,
      0xb8, 0x3f, 0x02, 0xfe, 0xbd, 0xdc, 0x8d, 0xa0, 0xa1, 0xf0, 0xf9, 0x10,
      0xd3, 0x7d, 0x3f, 0x53, 0x32, 0xc0, 0x27, 0xd7, 0xbd, 0x4c, 0x38, 0xfd,
      0x08, 0xeb, 0xc7, 0x70, 0xbf, 0x12, 0x52, 0x07, 0x86, 0x49, 0x54, 0x02,
      0x41, 0x63, 0x7e, 0x70, 0xb0, 0x60, 0x45, 0xa8, 0x6e, 0x2f, 0x32, 0x9f,
      0x90, 0x7e, 0x07, 0x9a, 0x78, 0x5d, 0x7f, 0x86, 0x49, 0x54, 0x18, 0x60,
      0x32, 0x2f, 0xb8, 0xb6, 0x4b, 0x97, 0x36, 0x36, 0x3f, 0x90, 0x15, 0x6b,
      0x9a, 0x55, 0x32, 0xd8, 0x08, 0xcf, 0x2a, 0xf3, 0x3b, 0x87, 0xff, 0x97,
      0x0c, 0x02, 0xe6, 0x48, 0xdc, 0x4f, 0x1c, 0x90, 0xff, 0x07, 0x04, 0x02,
      0x8e, 0xc2, 0xc2, 0xd9, 0xa8, 0x2d},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x33, 0x34, 0x37, 0x38, 0x33, 0x36, 0x36, 0x31, 0x33, 0x39},
     true},

    // Comment: special case hash
    // tcID: 321
    {SEC_OID_SHA512,
     321,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x7a, 0xad, 0xe6, 0x08, 0xb2, 0x2c, 0x77,
      0x24, 0x57, 0x34, 0xfc, 0x5c, 0x4b, 0xe8, 0x73, 0x7b, 0xa2, 0x4d, 0xc2,
      0xed, 0x43, 0x21, 0xb5, 0x81, 0x24, 0xae, 0x46, 0xa7, 0x7e, 0xa7, 0xbe,
      0xfa, 0xa5, 0xbc, 0xf1, 0x66, 0xcb, 0x96, 0x6a, 0xad, 0x00, 0x79, 0x11,
      0x62, 0x3a, 0xf1, 0x09, 0x25, 0xa3, 0x24, 0xbc, 0x3c, 0x6d, 0x06, 0xf2,
      0x4d, 0x0e, 0x2e, 0x7b, 0x2c, 0x7b, 0x84, 0x68, 0xb8, 0xee, 0x02, 0x42,
      0x01, 0xe9, 0x91, 0x3a, 0x41, 0x23, 0x00, 0xb3, 0x98, 0x07, 0x19, 0x14,
      0x8d, 0xe0, 0xbb, 0x03, 0x82, 0x61, 0x84, 0xaa, 0xbd, 0x58, 0xf1, 0x96,
      0x59, 0xaa, 0x8c, 0xa1, 0x80, 0x45, 0xf3, 0x6c, 0x73, 0xc9, 0x7d, 0xf3,
      0xd1, 0x2b, 0x92, 0x1d, 0xe5, 0x10, 0xff, 0xa9, 0x6c, 0xea, 0xc5, 0x45,
      0x4b, 0x80, 0x1c, 0x86, 0xc5, 0x5a, 0x06, 0xb2, 0xd7, 0x71, 0xfa, 0x77,
      0xbc, 0xa7, 0x84, 0x33, 0x2c, 0x39},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x36, 0x34, 0x39, 0x30, 0x35, 0x32, 0x36, 0x30, 0x32},
     true},

    // Comment: special case hash
    // tcID: 322
    {SEC_OID_SHA512,
     322,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x01, 0xee, 0xfc, 0x7b, 0x6c, 0x14, 0x68,
      0xff, 0xa7, 0xd6, 0x0b, 0x84, 0x08, 0xbd, 0x44, 0xc6, 0x4a, 0x3f, 0xfa,
      0xff, 0x29, 0x81, 0x68, 0xc5, 0x01, 0x6c, 0x6f, 0x50, 0x40, 0x31, 0x86,
      0x7e, 0xa1, 0x4a, 0xe4, 0x8c, 0x66, 0x1b, 0x81, 0x24, 0x41, 0x8b, 0x4e,
      0xd6, 0xcc, 0xc3, 0x2d, 0xf6, 0xba, 0xc6, 0xd0, 0xa4, 0x85, 0xb1, 0x99,
      0x02, 0x36, 0xe1, 0x56, 0x76, 0x26, 0x8b, 0x78, 0x68, 0xd2, 0x76, 0x02,
      0x41, 0x51, 0x5d, 0x48, 0x43, 0x6a, 0xff, 0xfd, 0xb6, 0x5c, 0xae, 0xd7,
      0x37, 0x11, 0x6a, 0x86, 0x19, 0x74, 0xb7, 0x34, 0xbd, 0x19, 0x03, 0xe3,
      0x7d, 0xbb, 0xc2, 0x31, 0xa9, 0xdb, 0x37, 0x46, 0x4e, 0xd7, 0x62, 0xe3,
      0x64, 0xca, 0xc8, 0xb3, 0x2f, 0x15, 0x46, 0xd6, 0xde, 0x37, 0x97, 0x9f,
      0xa0, 0x5f, 0x8b, 0x80, 0x15, 0x9a, 0x0f, 0x74, 0x7d, 0x94, 0x70, 0x29,
      0x1a, 0xf6, 0x56, 0x9d, 0x6d, 0x94},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x34, 0x37, 0x36, 0x33, 0x38, 0x38, 0x37, 0x34, 0x39, 0x36},
     true},

    // Comment: special case hash
    // tcID: 323
    {SEC_OID_SHA512,
     323,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x27, 0x1b, 0x91, 0x2c, 0xa0, 0x55,
      0x04, 0x0c, 0x22, 0x79, 0x55, 0xdf, 0x72, 0x97, 0x57, 0x65, 0x4a, 0xa9,
      0xbb, 0xdb, 0x73, 0xc6, 0x1b, 0xa1, 0x41, 0x55, 0x22, 0x0e, 0x4e, 0x71,
      0x32, 0x31, 0x9f, 0x6f, 0xb0, 0xee, 0x94, 0xf2, 0xfb, 0xe1, 0x60, 0x73,
      0x8f, 0x1d, 0xce, 0x2a, 0xd6, 0x90, 0x84, 0x5c, 0x38, 0xd9, 0x62, 0xdb,
      0x4f, 0xda, 0x15, 0x98, 0xe9, 0x32, 0x70, 0xda, 0x84, 0xa2, 0xbb, 0x02,
      0x42, 0x00, 0xb8, 0x90, 0x7f, 0x04, 0x1c, 0x3b, 0x19, 0xb9, 0x23, 0x4a,
      0xb5, 0x55, 0xd0, 0xb4, 0x83, 0x25, 0xb0, 0xcd, 0x33, 0x08, 0x89, 0xa5,
      0x32, 0x76, 0xa1, 0xe9, 0x13, 0xba, 0xb8, 0x92, 0xb9, 0xc0, 0x5c, 0xfa,
      0x88, 0x90, 0x05, 0xb1, 0x4e, 0xe2, 0x73, 0x02, 0x20, 0x74, 0x6a, 0xec,
      0xf1, 0x2a, 0xf9, 0x11, 0xc5, 0xba, 0xea, 0x4b, 0xe3, 0x77, 0xee, 0x76,
      0xc0, 0xee, 0xaf, 0x47, 0xb7, 0xa7, 0x12},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x35, 0x37, 0x39, 0x30, 0x32, 0x30, 0x30, 0x38, 0x30},
     true},

    // Comment: special case hash
    // tcID: 324
    {SEC_OID_SHA512,
     324,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x6a, 0x81, 0x3d, 0xb0, 0xf7, 0x5f,
      0x90, 0x47, 0xfb, 0x11, 0xf3, 0xe1, 0x9f, 0xc1, 0x68, 0x8c, 0x29, 0x32,
      0x8a, 0x54, 0xf5, 0x6a, 0xe3, 0x0c, 0x1c, 0x9d, 0x93, 0x78, 0x53, 0x7b,
      0xfc, 0x40, 0xc5, 0x71, 0x9d, 0x08, 0x4e, 0x49, 0xa3, 0xb4, 0xae, 0xa2,
      0x55, 0xf5, 0xb7, 0xf6, 0xcc, 0x77, 0x54, 0x92, 0xb5, 0x37, 0x1e, 0x6b,
      0x67, 0xb2, 0xd6, 0xab, 0xd5, 0x74, 0x3e, 0x10, 0xfa, 0xc7, 0x09, 0x02,
      0x42, 0x01, 0xc2, 0x58, 0xff, 0xd8, 0x30, 0x15, 0x1b, 0xfd, 0x41, 0xcc,
      0xda, 0xbb, 0x86, 0xb2, 0x4a, 0xf8, 0x46, 0x61, 0x27, 0x88, 0xb3, 0x61,
      0xc1, 0x96, 0xd2, 0x4e, 0x99, 0x7c, 0xcf, 0x3f, 0x17, 0xd4, 0x45, 0x2f,
      0x63, 0xd3, 0x28, 0x51, 0xa4, 0x83, 0x07, 0x2e, 0x69, 0x08, 0x09, 0x5e,
      0x5c, 0x49, 0xbb, 0xc2, 0x41, 0xa0, 0x41, 0x77, 0x49, 0xb0, 0x97, 0xbc,
      0x1c, 0xa0, 0xe4, 0xd1, 0x27, 0x77, 0x9b},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x35, 0x33, 0x34, 0x34, 0x37, 0x38, 0x37, 0x38, 0x34, 0x38},
     true},

    // Comment: special case hash
    // tcID: 325
    {SEC_OID_SHA512,
     325,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x15, 0x6a, 0x04, 0xc2, 0x2e, 0xa5, 0xbd,
      0xb7, 0x87, 0x11, 0x24, 0xf1, 0x11, 0x73, 0x01, 0xd7, 0x81, 0x11, 0x3a,
      0xc4, 0xc9, 0xd4, 0xda, 0x05, 0xfe, 0xa5, 0x36, 0xe9, 0x83, 0xd9, 0x26,
      0x1d, 0x25, 0xdc, 0x97, 0x00, 0x6f, 0x8c, 0x78, 0xde, 0x23, 0xc7, 0x88,
      0x71, 0x85, 0x57, 0xcf, 0x6f, 0x98, 0x86, 0x39, 0x94, 0xaf, 0x20, 0x86,
      0xf0, 0xbe, 0x3e, 0x8a, 0xa8, 0x81, 0x2d, 0xc3, 0xa1, 0x1d, 0x02, 0x42,
      0x00, 0xff, 0xca, 0x96, 0xb0, 0x4c, 0x56, 0xa4, 0xa6, 0xce, 0x5d, 0x22,
      0xb3, 0x6e, 0x44, 0xd3, 0xb9, 0x74, 0xd5, 0x20, 0xe7, 0xf7, 0xc0, 0xf9,
      0xd6, 0x90, 0x34, 0xf9, 0xe5, 0x9e, 0x0b, 0xbd, 0xc4, 0x32, 0x36, 0xb3,
      0xe4, 0xbf, 0xb0, 0xf6, 0xbd, 0xe8, 0x80, 0x2c, 0xc5, 0xcd, 0x60, 0x22,
      0xcf, 0xf1, 0x66, 0xf4, 0xc4, 0x88, 0xd6, 0x4f, 0x38, 0xd4, 0x4e, 0x3c,
      0x56, 0x3d, 0xa3, 0x1c, 0xf6, 0xfe},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x39, 0x32, 0x36, 0x36, 0x34, 0x31, 0x30, 0x39, 0x32, 0x30},
     true},

    // Comment: special case hash
    // tcID: 326
    {SEC_OID_SHA512,
     326,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x09, 0x13, 0x54, 0x0a, 0xd7, 0x3c,
      0xee, 0xf7, 0x31, 0x4d, 0x17, 0x58, 0x26, 0x4e, 0x1d, 0x15, 0x25, 0xa3,
      0x71, 0xa7, 0xb9, 0xb3, 0x08, 0x69, 0x71, 0x59, 0x9a, 0x6b, 0x74, 0x9b,
      0xe4, 0xd6, 0xba, 0x69, 0x26, 0x9b, 0x08, 0x95, 0x08, 0xf6, 0x50, 0x0d,
      0xd9, 0x25, 0xaa, 0x89, 0xa7, 0xc7, 0xcb, 0x71, 0x85, 0xe0, 0xcc, 0xa7,
      0xd2, 0xee, 0x56, 0x64, 0xf2, 0x28, 0x45, 0xd9, 0x61, 0xe3, 0x17, 0x02,
      0x42, 0x01, 0x35, 0x25, 0x6c, 0x79, 0xea, 0x5e, 0x57, 0x68, 0xfb, 0x3a,
      0x55, 0xe2, 0x89, 0x9b, 0x12, 0x21, 0x9b, 0x8f, 0x68, 0x95, 0x3c, 0xcd,
      0x98, 0xc7, 0x10, 0xb6, 0xa1, 0x3d, 0xe0, 0xf5, 0x97, 0x86, 0xf4, 0x33,
      0x18, 0x45, 0xe6, 0x5c, 0x7d, 0xd6, 0x34, 0x00, 0x23, 0xa5, 0xe2, 0x80,
      0x20, 0x6c, 0xa3, 0x14, 0x16, 0x05, 0x8f, 0x39, 0x5f, 0xff, 0x4b, 0xb5,
      0xde, 0x41, 0x1f, 0xf6, 0x6f, 0xc0, 0x18},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x33, 0x37, 0x30, 0x33, 0x39, 0x31, 0x35, 0x37, 0x30, 0x35},
     true},

    // Comment: special case hash
    // tcID: 327
    {SEC_OID_SHA512,
     327,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xb5, 0x05, 0x1c, 0xa0, 0xdd, 0x3b,
      0x20, 0xdf, 0x7d, 0x8c, 0x5b, 0x92, 0xcb, 0x42, 0xb8, 0xa2, 0x04, 0xf9,
      0x2f, 0xb4, 0xe5, 0x8c, 0x61, 0x2f, 0x43, 0xd3, 0x80, 0x0d, 0xe8, 0xc0,
      0x68, 0x3c, 0x42, 0x7e, 0x83, 0x2c, 0xe6, 0x22, 0x15, 0x67, 0x47, 0x05,
      0x2b, 0x81, 0xbf, 0xbf, 0x6e, 0xd5, 0xfa, 0x17, 0x7b, 0x6d, 0x47, 0x85,
      0x8e, 0xc8, 0x47, 0x8f, 0x6c, 0x9c, 0xa7, 0x94, 0x8f, 0xd5, 0x11, 0x02,
      0x42, 0x01, 0xfe, 0x57, 0x10, 0xfa, 0xc0, 0xe9, 0xd3, 0xe2, 0xb3, 0xb8,
      0x30, 0x81, 0xb2, 0x8b, 0x19, 0x4b, 0x82, 0x2d, 0x0c, 0x13, 0x39, 0x7b,
      0xf1, 0x51, 0x61, 0x40, 0xcb, 0xe3, 0xfa, 0xa5, 0x2e, 0x90, 0x88, 0x48,
      0xf6, 0x97, 0x89, 0xa7, 0x41, 0xb9, 0xcd, 0x54, 0xd7, 0x03, 0xa9, 0x45,
      0x77, 0xfa, 0x81, 0x3e, 0x2f, 0x2c, 0x75, 0x83, 0x48, 0x07, 0x40, 0x1c,
      0xa0, 0x10, 0xfd, 0xe5, 0x32, 0x83, 0x17},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x38, 0x31, 0x35, 0x34, 0x35, 0x37, 0x37, 0x30},
     true},

    // Comment: special case hash
    // tcID: 328
    {SEC_OID_SHA512,
     328,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x00, 0x8d, 0x3c, 0x8f, 0x8e, 0x7a, 0xb7,
      0x4d, 0x49, 0xe1, 0x6a, 0x4c, 0x7d, 0xb3, 0xa3, 0x93, 0xfa, 0x95, 0x67,
      0x77, 0x7e, 0x37, 0x33, 0x13, 0x66, 0x7f, 0x9c, 0xe3, 0x2b, 0x1b, 0x5e,
      0x64, 0x8d, 0xeb, 0xff, 0xed, 0xfd, 0x2f, 0xf5, 0x34, 0x5c, 0xa1, 0xb8,
      0x15, 0x4c, 0x18, 0xc8, 0xb8, 0x83, 0x95, 0x7d, 0x91, 0x1e, 0x41, 0x33,
      0x62, 0x85, 0xf8, 0x62, 0x61, 0xc3, 0xee, 0x22, 0x5f, 0xde, 0xdd, 0x02,
      0x41, 0x3c, 0x51, 0xb8, 0x4c, 0x2c, 0x9a, 0x3f, 0xeb, 0x76, 0xa6, 0x51,
      0x86, 0x34, 0xb6, 0xf0, 0x9c, 0x0d, 0xde, 0x8a, 0x9d, 0x08, 0xde, 0xc0,
      0xb3, 0xd6, 0x61, 0x35, 0xcc, 0x1b, 0xdb, 0x0a, 0x80, 0xfd, 0x69, 0x63,
      0x61, 0x04, 0xaf, 0x69, 0xde, 0x8f, 0x40, 0x62, 0x64, 0x6b, 0x29, 0xfa,
      0x3a, 0xf6, 0x85, 0xec, 0x82, 0x70, 0x4c, 0xef, 0x70, 0x6a, 0x18, 0xc5,
      0x9c, 0xa7, 0xec, 0xa0, 0xfb, 0x56},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x39, 0x35, 0x35, 0x33, 0x30, 0x33, 0x37, 0x37},
     true},

    // Comment: special case hash
    // tcID: 329
    {SEC_OID_SHA512,
     329,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x01, 0x19, 0x56, 0x25, 0xa6, 0x4a, 0xc1,
      0x1c, 0x4f, 0xc1, 0xfc, 0x47, 0x9e, 0xf8, 0x04, 0x30, 0xeb, 0x85, 0xc1,
      0xaf, 0x77, 0xf8, 0xa1, 0x97, 0xa1, 0x7e, 0x00, 0x95, 0x69, 0xef, 0x6c,
      0x41, 0xac, 0x6f, 0x35, 0x85, 0x07, 0x55, 0x37, 0x9f, 0x47, 0x8d, 0x89,
      0x28, 0xb1, 0x54, 0xe3, 0xba, 0xaa, 0x29, 0xe9, 0x2b, 0x48, 0x1a, 0xc0,
      0x4d, 0xc7, 0x2f, 0x37, 0x28, 0xb4, 0xf0, 0x88, 0xff, 0x37, 0xdc, 0x02,
      0x41, 0x0d, 0x55, 0xc7, 0x06, 0x78, 0x77, 0xdd, 0x13, 0x02, 0xfd, 0xc6,
      0xbb, 0x69, 0xb7, 0xb7, 0xc0, 0x24, 0xe4, 0xcf, 0x3a, 0x0e, 0x92, 0x41,
      0x02, 0xd7, 0x44, 0xac, 0x52, 0x36, 0x6d, 0x9d, 0x76, 0xd5, 0x85, 0x5d,
      0x3d, 0xa2, 0x28, 0xc4, 0xb6, 0x7b, 0xc7, 0xbc, 0x4b, 0x2a, 0x14, 0xe7,
      0x99, 0x99, 0x62, 0xcc, 0x9b, 0xbd, 0xc5, 0x17, 0xfc, 0x24, 0xa8, 0x23,
      0xab, 0xf5, 0x84, 0xb8, 0xf5, 0x6e},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x36, 0x37, 0x38, 0x31, 0x30, 0x39, 0x30, 0x33},
     true},

    // Comment: special case hash
    // tcID: 330
    {SEC_OID_SHA512,
     330,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x26, 0xeb, 0x68, 0xbc, 0x0f, 0xb7, 0x66,
      0x4c, 0x35, 0xbf, 0x57, 0x62, 0xcd, 0x53, 0x2d, 0xce, 0x33, 0xb0, 0xe3,
      0x96, 0xe9, 0x7d, 0x6f, 0x41, 0x43, 0xdc, 0x6e, 0x1e, 0x76, 0x6c, 0x83,
      0x6e, 0x27, 0xc0, 0x69, 0xda, 0x9e, 0xa1, 0xe7, 0x4e, 0x0b, 0x03, 0xd0,
      0x30, 0xcf, 0x8a, 0x81, 0x49, 0x05, 0x08, 0xc1, 0xc7, 0x28, 0xf8, 0x6e,
      0x59, 0x28, 0x2d, 0xf9, 0x4d, 0xe8, 0xd8, 0xa0, 0xdc, 0xaf, 0x02, 0x42,
      0x00, 0xa9, 0xfb, 0x58, 0x4b, 0x71, 0x29, 0x86, 0xf1, 0x9a, 0xb7, 0x56,
      0x86, 0x93, 0xdf, 0x27, 0x8c, 0xaf, 0xa4, 0x32, 0x72, 0xdb, 0xa4, 0x00,
      0xff, 0x33, 0x3c, 0xf4, 0x8b, 0x55, 0x56, 0xe6, 0xe7, 0x83, 0x53, 0xa6,
      0x65, 0x60, 0x5c, 0x70, 0xb6, 0xfd, 0x0f, 0x18, 0xf3, 0x0b, 0x85, 0x0e,
      0x1a, 0x47, 0xcd, 0xa4, 0x2c, 0x4c, 0x92, 0x4b, 0xca, 0x80, 0x10, 0x2e,
      0x67, 0x93, 0xbe, 0x9a, 0x86, 0x98},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x31, 0x31, 0x38, 0x30, 0x37, 0x32, 0x30, 0x38, 0x31, 0x35},
     true},

    // Comment: special case hash
    // tcID: 331
    {SEC_OID_SHA512,
     331,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xf3, 0xd3, 0x4e, 0x36, 0xf9, 0x75,
      0x4d, 0xfa, 0x8e, 0xaf, 0xab, 0x16, 0x0c, 0xa9, 0x6d, 0x91, 0xc7, 0xf4,
      0xf3, 0x88, 0xec, 0x82, 0xac, 0x33, 0x78, 0x40, 0x26, 0xbb, 0x6c, 0x6a,
      0x03, 0x57, 0x19, 0xea, 0xee, 0xc3, 0xee, 0x51, 0x1f, 0xff, 0xb2, 0x2d,
      0xd5, 0xd6, 0xab, 0x81, 0x9e, 0x6c, 0x63, 0x87, 0x19, 0x2d, 0x6c, 0x3a,
      0x6e, 0x92, 0x49, 0xea, 0xd5, 0x65, 0x15, 0x7e, 0x32, 0x3f, 0x62, 0x02,
      0x42, 0x01, 0xb5, 0x78, 0x6b, 0x1d, 0x66, 0x2d, 0x26, 0xfe, 0x9f, 0x69,
      0xc3, 0x70, 0xd2, 0xbc, 0x18, 0x88, 0x2a, 0xbe, 0xf6, 0x93, 0xc8, 0xf1,
      0x71, 0x00, 0xa0, 0x27, 0x25, 0xde, 0x7c, 0x9f, 0x03, 0x60, 0x2f, 0xd5,
      0x3a, 0x92, 0x08, 0xb5, 0x73, 0xb3, 0xb7, 0xb0, 0xb6, 0x6d, 0xb9, 0x71,
      0x76, 0x7b, 0xde, 0x83, 0x5f, 0x9e, 0x8f, 0x42, 0xad, 0xa2, 0x01, 0xe7,
      0xb7, 0x39, 0x1b, 0x86, 0xfe, 0x02, 0x94},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x38, 0x33, 0x38, 0x31, 0x38, 0x36, 0x39, 0x32, 0x39, 0x30},
     true},

    // Comment: special case hash
    // tcID: 332
    {SEC_OID_SHA512,
     332,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xe6, 0x9c, 0x83, 0x3b, 0x60, 0x40,
      0x75, 0xe9, 0xb2, 0x8a, 0x2f, 0xf7, 0x3a, 0x56, 0xa3, 0x2e, 0x1a, 0x24,
      0x7e, 0xf9, 0xae, 0x01, 0xe7, 0xa0, 0xe4, 0x71, 0xf6, 0x01, 0x5c, 0x2b,
      0x86, 0xeb, 0x86, 0x4c, 0x28, 0x1c, 0x8c, 0x93, 0xd2, 0xac, 0xf5, 0x65,
      0x3a, 0xd0, 0x5b, 0xaf, 0xab, 0x2f, 0x58, 0x02, 0x7f, 0x37, 0x51, 0x3e,
      0xb8, 0x56, 0x9f, 0x50, 0xbd, 0x47, 0x5e, 0x77, 0x0e, 0x9a, 0x81, 0x02,
      0x42, 0x00, 0xb9, 0xc9, 0xd6, 0xce, 0x09, 0xb5, 0x30, 0x25, 0xbf, 0xca,
      0xa7, 0xd1, 0x72, 0xae, 0x41, 0xa9, 0xb6, 0x36, 0xaa, 0x4b, 0x80, 0xa9,
      0x30, 0x93, 0x1f, 0xc9, 0x9e, 0x5e, 0x2a, 0xa2, 0x33, 0x06, 0xf1, 0x9d,
      0xc5, 0x73, 0x99, 0xb0, 0x43, 0x1e, 0x72, 0x44, 0x0a, 0x1f, 0x4e, 0xc7,
      0xd5, 0xca, 0x90, 0x2f, 0x0f, 0x7b, 0x81, 0xc9, 0x1d, 0xe8, 0x5e, 0x46,
      0x9f, 0x99, 0x2f, 0xdf, 0xd4, 0xc5, 0x2e},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x33, 0x31, 0x33, 0x31, 0x32, 0x38, 0x37, 0x32, 0x37, 0x37},
     true},

    // Comment: special case hash
    // tcID: 333
    {SEC_OID_SHA512,
     333,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xc6, 0xb8, 0xb5, 0xcf, 0x3c, 0x4d,
      0xd3, 0xd6, 0x23, 0x91, 0xf1, 0x8e, 0x97, 0xee, 0xf3, 0xaa, 0x6a, 0xce,
      0x0a, 0xe2, 0xc6, 0xfc, 0x97, 0xa5, 0x61, 0xcb, 0x8e, 0x49, 0xc0, 0x87,
      0xdb, 0xcf, 0x81, 0x35, 0xfa, 0x43, 0x3b, 0x56, 0x6b, 0x33, 0x85, 0xcb,
      0x57, 0x20, 0x2f, 0x1b, 0x12, 0x16, 0x4f, 0xe6, 0x27, 0x65, 0xef, 0x73,
      0xb7, 0x2a, 0x94, 0xe7, 0xa5, 0x78, 0x70, 0x98, 0x9a, 0x49, 0x81, 0x02,
      0x42, 0x01, 0x85, 0x94, 0x44, 0x34, 0xb8, 0x3a, 0x0d, 0x0f, 0xb4, 0xbc,
      0xdc, 0xe8, 0xdd, 0xaa, 0xdb, 0x30, 0xa1, 0xe4, 0x40, 0x81, 0x5e, 0x76,
      0x74, 0x56, 0x2d, 0xf9, 0xc8, 0xbf, 0x71, 0x12, 0x22, 0x20, 0x8c, 0xc3,
      0x46, 0xb9, 0x66, 0x5d, 0x90, 0xab, 0xed, 0xb4, 0x37, 0x91, 0x23, 0x91,
      0x50, 0x5d, 0xd5, 0xd2, 0x6f, 0x01, 0x78, 0xe7, 0xc0, 0x63, 0x79, 0x0f,
      0x55, 0x18, 0xf4, 0x7d, 0x1b, 0x05, 0xc7},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x34, 0x33, 0x33, 0x31, 0x39, 0x32, 0x36, 0x35, 0x33, 0x38},
     true},

    // Comment: special case hash
    // tcID: 334
    {SEC_OID_SHA512,
     334,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0x9f, 0x35, 0x1a, 0x41, 0xd5, 0x37,
      0x5b, 0x89, 0x93, 0xe9, 0x0b, 0x8d, 0x8a, 0x65, 0xbf, 0x01, 0xd5, 0x2d,
      0x14, 0xab, 0xa1, 0xdb, 0xe4, 0x9c, 0xbb, 0x4e, 0xa8, 0x23, 0x80, 0x4f,
      0x2b, 0x53, 0x3e, 0x0c, 0x16, 0x79, 0x03, 0xc8, 0xbb, 0xc5, 0x93, 0x29,
      0x7c, 0x18, 0xf3, 0x09, 0x79, 0x8a, 0x54, 0x47, 0x87, 0xd5, 0x98, 0x07,
      0x4c, 0xbf, 0x56, 0xef, 0x0e, 0x50, 0x22, 0x52, 0x09, 0x12, 0xad, 0x02,
      0x42, 0x01, 0xb8, 0x92, 0x74, 0x0a, 0x57, 0x20, 0x41, 0x86, 0xbd, 0x5f,
      0x43, 0x4f, 0x72, 0xd1, 0x53, 0x4b, 0x42, 0x89, 0xf8, 0xf7, 0x11, 0x4c,
      0xb7, 0xb1, 0xc9, 0xcf, 0x45, 0x41, 0xd7, 0x54, 0xf3, 0x14, 0x44, 0x8c,
      0xc3, 0x2d, 0xea, 0xf3, 0x56, 0x08, 0x26, 0x34, 0x88, 0xfd, 0xc7, 0x59,
      0x6f, 0x74, 0x81, 0xec, 0x09, 0x8b, 0x36, 0xf8, 0xe4, 0x40, 0x82, 0x91,
      0x94, 0xbe, 0xcc, 0x74, 0x6c, 0x77, 0xf5},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x33, 0x34, 0x34, 0x39, 0x30, 0x38, 0x32, 0x33, 0x36},
     true},

    // Comment: special case hash
    // tcID: 335
    {SEC_OID_SHA512,
     335,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x01, 0xfe, 0x24, 0xea, 0x83, 0x11, 0x99,
      0xe3, 0x1c, 0xc6, 0x8e, 0xf2, 0x39, 0x80, 0xc4, 0xba, 0xbd, 0x37, 0x73,
      0x04, 0x08, 0x70, 0xaf, 0x88, 0x23, 0xa1, 0x97, 0x08, 0xbd, 0x02, 0x29,
      0xad, 0xc1, 0xce, 0x99, 0xd0, 0x2e, 0x4d, 0x95, 0x22, 0x41, 0x01, 0xe3,
      0xe9, 0x74, 0x23, 0x6f, 0x54, 0xdf, 0x86, 0x05, 0x1f, 0xa1, 0xe9, 0xfd,
      0x21, 0x38, 0x04, 0x32, 0x63, 0x3b, 0x24, 0x95, 0xab, 0x78, 0x2a, 0x02,
      0x41, 0x0e, 0xfd, 0x1f, 0x2a, 0x28, 0x1f, 0x96, 0x7e, 0x7b, 0x09, 0xd7,
      0x21, 0x58, 0x13, 0x56, 0xa7, 0x14, 0xc4, 0x99, 0xf9, 0xb1, 0x4f, 0x78,
      0x19, 0x92, 0xeb, 0x9a, 0xe7, 0xa1, 0x9f, 0x68, 0x25, 0x04, 0x5f, 0xdc,
      0x6d, 0x9d, 0x76, 0x3f, 0x44, 0xe1, 0xe7, 0xc9, 0x14, 0x80, 0xa6, 0x78,
      0xa1, 0xd8, 0xec, 0xf6, 0xd6, 0x6e, 0x76, 0xce, 0xa3, 0x50, 0x5f, 0x65,
      0xff, 0x78, 0xcf, 0xf1, 0x5c, 0xbd},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x36, 0x38, 0x32, 0x39, 0x38, 0x33, 0x35, 0x39, 0x32, 0x39},
     true},

    // Comment: special case hash
    // tcID: 336
    {SEC_OID_SHA512,
     336,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x01, 0x4c, 0x6e, 0xe9, 0xde, 0x0a, 0x2a,
      0x0b, 0x60, 0xc9, 0x81, 0x83, 0x1e, 0x0a, 0xcd, 0x66, 0x36, 0xb4, 0x6a,
      0xe1, 0x34, 0xfe, 0xdc, 0xe6, 0x1b, 0x04, 0x88, 0x11, 0x26, 0x63, 0xb2,
      0x4e, 0x1d, 0x7e, 0x74, 0xe2, 0x27, 0xfe, 0xa8, 0x83, 0xd2, 0x6b, 0x68,
      0xf2, 0x1e, 0x41, 0x35, 0xba, 0x0e, 0x20, 0x69, 0xbb, 0xe0, 0xd9, 0xc6,
      0x43, 0x3c, 0x39, 0x08, 0xfd, 0x5b, 0x00, 0x18, 0x28, 0x94, 0xb0, 0x02,
      0x41, 0x6a, 0x18, 0x0a, 0x49, 0x31, 0x82, 0xc6, 0xbc, 0x2a, 0x09, 0xd7,
      0xe1, 0x7f, 0xf5, 0xd6, 0x20, 0x15, 0x29, 0x3f, 0x1e, 0x8a, 0xe2, 0x05,
      0xa1, 0x6f, 0xa0, 0x90, 0x42, 0xb0, 0xa9, 0xaf, 0x67, 0x94, 0xcb, 0x37,
      0x7f, 0x4b, 0x8b, 0x11, 0x75, 0xfc, 0xee, 0x51, 0x37, 0xc2, 0x34, 0x90,
      0x0f, 0x73, 0x5c, 0x48, 0x4f, 0xeb, 0x7d, 0xa4, 0xcb, 0xb4, 0x05, 0xcf,
      0x9e, 0x53, 0x70, 0xfe, 0x4f, 0x49},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x33, 0x34, 0x34, 0x35, 0x31, 0x35, 0x38, 0x30, 0x32, 0x33},
     true},

    // Comment: special case hash
    // tcID: 337
    {SEC_OID_SHA512,
     337,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x04, 0x4a, 0x45, 0x85, 0x3a, 0xda,
      0x17, 0xca, 0x76, 0x1a, 0xcc, 0x7d, 0xf6, 0xd1, 0xd3, 0x80, 0x25, 0x2c,
      0xb0, 0xfa, 0x66, 0x12, 0x4d, 0x92, 0x78, 0xa5, 0xed, 0x8a, 0x4a, 0x60,
      0x45, 0x3b, 0xc7, 0x1d, 0xe1, 0xdb, 0xe3, 0x2b, 0x02, 0x61, 0x16, 0x59,
      0x48, 0x82, 0x3c, 0x46, 0x1c, 0x7c, 0x1e, 0xb1, 0x71, 0x4e, 0xc1, 0xdb,
      0xf6, 0x6f, 0xd6, 0x02, 0xc7, 0xa4, 0x74, 0x46, 0xd1, 0xda, 0xe1, 0x02,
      0x42, 0x00, 0xf8, 0xb2, 0x7f, 0x7c, 0x71, 0xe3, 0x7e, 0x4b, 0x44, 0x0d,
      0x2c, 0x86, 0xf1, 0xc1, 0xd5, 0x0b, 0xf7, 0xc5, 0x3d, 0x38, 0x78, 0xed,
      0x27, 0xe7, 0xbc, 0xfb, 0xeb, 0x90, 0x2f, 0x76, 0x9f, 0x86, 0xd6, 0xc3,
      0xe8, 0x82, 0x0b, 0x99, 0xf8, 0x90, 0x05, 0x0f, 0x0d, 0xbe, 0xbd, 0x21,
      0x32, 0xe8, 0x46, 0x26, 0xc5, 0xb1, 0x6a, 0x8c, 0x7f, 0xff, 0xfc, 0x3a,
      0x30, 0xac, 0xe6, 0x9d, 0xd1, 0x5a, 0x11},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x32, 0x36, 0x39, 0x37, 0x39, 0x38, 0x37, 0x36, 0x34, 0x34},
     true},

    // Comment: special case hash
    // tcID: 338
    {SEC_OID_SHA512,
     338,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x67, 0x6a, 0x38, 0x1b, 0x18, 0xd0, 0x52,
      0x07, 0xcd, 0xdd, 0x73, 0xb4, 0x4e, 0x4d, 0xd7, 0x14, 0x49, 0x98, 0x5c,
      0x0f, 0xa7, 0xde, 0x1f, 0xff, 0x43, 0xca, 0x51, 0x55, 0x13, 0x9a, 0x1a,
      0x09, 0xe5, 0xe3, 0xfd, 0x75, 0x4d, 0x86, 0xeb, 0xbe, 0x32, 0xf6, 0x60,
      0x9f, 0x6e, 0x90, 0x6d, 0x48, 0xd2, 0x47, 0x90, 0xe4, 0x94, 0x34, 0x3c,
      0x61, 0xfa, 0xa9, 0x0b, 0xfd, 0xaa, 0x4f, 0x49, 0xfd, 0xc7, 0x02, 0x42,
      0x00, 0xfb, 0xc1, 0xc8, 0x91, 0xbf, 0x6e, 0x36, 0x8f, 0xcc, 0xad, 0x51,
      0xcc, 0x9b, 0x2c, 0x29, 0xe8, 0xe9, 0x2b, 0x65, 0x8e, 0x88, 0xc0, 0xd2,
      0x32, 0x85, 0xaf, 0x26, 0x9a, 0xff, 0x67, 0x02, 0xa5, 0x5a, 0x0a, 0xb1,
      0x68, 0x07, 0xe5, 0x52, 0x3b, 0x66, 0x37, 0xbb, 0xb0, 0x04, 0x72, 0x7f,
      0x6f, 0x55, 0xc5, 0x1a, 0xd4, 0xce, 0xc8, 0xc9, 0x24, 0xf9, 0xc1, 0xfe,
      0xb2, 0x46, 0x01, 0xae, 0xdd, 0xef},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x33, 0x39, 0x39, 0x32, 0x34, 0x32, 0x35, 0x35, 0x33},
     true},

    // Comment: special case hash
    // tcID: 339
    {SEC_OID_SHA512,
     339,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x3c, 0x9a, 0x57, 0x53, 0x82, 0xff,
      0x68, 0x81, 0xc9, 0x08, 0xfb, 0x51, 0x84, 0xbe, 0x7b, 0xaf, 0x38, 0xed,
      0xb0, 0xb0, 0x60, 0x08, 0x59, 0x25, 0x58, 0xef, 0xd5, 0x7d, 0xd8, 0xfb,
      0x99, 0x93, 0xc8, 0x93, 0x80, 0x0a, 0x6a, 0xc8, 0xc6, 0xd2, 0xe3, 0x4e,
      0xbf, 0xbe, 0xff, 0x43, 0xe6, 0x32, 0x63, 0xf1, 0x33, 0x86, 0x8d, 0x0a,
      0xc7, 0xa8, 0x38, 0xf6, 0x9a, 0xff, 0x26, 0xd6, 0x0a, 0x38, 0x49, 0x02,
      0x42, 0x00, 0x9d, 0x22, 0xae, 0x7b, 0xca, 0x8a, 0x75, 0xa5, 0x32, 0x14,
      0xc3, 0xee, 0xce, 0x43, 0x7f, 0xb2, 0x8e, 0x05, 0xb0, 0x76, 0xec, 0x70,
      0x4d, 0x75, 0x1a, 0x28, 0xa7, 0xed, 0x7e, 0x52, 0x9d, 0x5c, 0x53, 0x38,
      0xbe, 0x8c, 0x72, 0x4a, 0xfa, 0x54, 0x75, 0x74, 0xa1, 0x7f, 0x70, 0x51,
      0x0b, 0x24, 0x62, 0x74, 0x8a, 0x53, 0x67, 0x8e, 0x39, 0x75, 0x2a, 0x68,
      0x8d, 0xc8, 0xcf, 0x39, 0xe8, 0x86, 0xc2},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x36, 0x30, 0x31, 0x39, 0x37, 0x37, 0x39, 0x37, 0x37},
     true},

    // Comment: special case hash
    // tcID: 340
    {SEC_OID_SHA512,
     340,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x07, 0x1c, 0xe5, 0xa1, 0x9a, 0x09,
      0xaa, 0xcd, 0x43, 0xc7, 0xca, 0xcd, 0x58, 0xa4, 0x39, 0xdc, 0xca, 0x4e,
      0x85, 0xf9, 0x4e, 0xa1, 0xd4, 0x8a, 0x60, 0xf2, 0x98, 0xee, 0x01, 0xbb,
      0x3e, 0xeb, 0x11, 0xd5, 0xda, 0xf5, 0x45, 0xe7, 0x08, 0x64, 0x86, 0xf8,
      0xe4, 0xb5, 0x18, 0xa1, 0x5b, 0xe6, 0x96, 0x20, 0xab, 0x92, 0x0c, 0xf9,
      0x5c, 0x5c, 0x15, 0xff, 0x17, 0x8c, 0x90, 0x31, 0x24, 0xfa, 0xc3, 0x02,
      0x42, 0x01, 0xad, 0x6e, 0xae, 0xed, 0xec, 0xe9, 0xa7, 0x59, 0x2b, 0xd2,
      0x15, 0x08, 0xb2, 0x72, 0x0f, 0x1b, 0x8c, 0x4b, 0xf5, 0x56, 0x37, 0xb1,
      0xe8, 0xa5, 0xce, 0x53, 0x59, 0x77, 0x5b, 0x98, 0x0b, 0x21, 0xeb, 0x1d,
      0x33, 0xe8, 0xeb, 0xf5, 0xc0, 0xb3, 0xd7, 0x82, 0x91, 0x52, 0xa2, 0x95,
      0xb8, 0xa9, 0xa1, 0x34, 0x3c, 0x25, 0x35, 0x0e, 0x35, 0xf7, 0x09, 0x93,
      0x6a, 0xcc, 0xc8, 0xce, 0x08, 0xb0, 0xb1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x30, 0x38, 0x37, 0x38, 0x37, 0x35, 0x35, 0x31, 0x34, 0x35},
     true},

    // Comment: special case hash
    // tcID: 341
    {SEC_OID_SHA512,
     341,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xbd, 0xae, 0x49, 0x91, 0x60, 0xf4,
      0xcc, 0x6c, 0xd1, 0x63, 0xcf, 0x11, 0x0b, 0xb1, 0xf9, 0xb4, 0x21, 0xe8,
      0x78, 0x6a, 0x8e, 0xf9, 0x29, 0x7e, 0x4b, 0x98, 0xfd, 0x50, 0x8a, 0x1d,
      0x14, 0xc5, 0x06, 0x17, 0xc8, 0xd1, 0xa3, 0xde, 0x94, 0xfc, 0x8b, 0xd6,
      0xc3, 0x80, 0x55, 0xe4, 0x90, 0x6b, 0x20, 0xfd, 0xca, 0xb6, 0xef, 0x7b,
      0xf9, 0xe7, 0xe5, 0xc9, 0x8e, 0xf3, 0xe8, 0x3e, 0x38, 0xec, 0x3b, 0x02,
      0x42, 0x01, 0xba, 0x86, 0x7b, 0x8e, 0xe7, 0x2b, 0xb7, 0x30, 0x4f, 0xf8,
      0x3f, 0xc2, 0xd7, 0x34, 0x74, 0x94, 0x47, 0x42, 0x07, 0x91, 0xd5, 0x60,
      0x9e, 0x05, 0x15, 0xde, 0x4e, 0x05, 0xfa, 0x70, 0xa8, 0x33, 0x85, 0xa8,
      0x53, 0xca, 0xc6, 0xc4, 0x7a, 0x07, 0x5c, 0x8c, 0x61, 0xe4, 0xb6, 0x5b,
      0x97, 0x74, 0x57, 0x41, 0x01, 0xcf, 0x4e, 0x08, 0x17, 0x70, 0xf8, 0x3a,
      0xe1, 0xb7, 0xe7, 0x27, 0x01, 0x0b, 0xa3},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x37, 0x30, 0x30, 0x34, 0x32, 0x35, 0x32, 0x39, 0x39, 0x39},
     true},

    // Comment: special case hash
    // tcID: 342
    {SEC_OID_SHA512,
     342,
     {0x30, 0x81, 0x86, 0x02, 0x40, 0x26, 0x9f, 0xc7, 0xed, 0x89, 0xe5, 0x54,
      0xaa, 0x52, 0xb3, 0x87, 0x5d, 0xc0, 0x0b, 0xc1, 0x40, 0xc1, 0x93, 0x7d,
      0x4f, 0x1b, 0x32, 0xe2, 0x9d, 0xa4, 0x1f, 0xf2, 0x41, 0xcd, 0xb9, 0xbd,
      0x30, 0x58, 0xfc, 0x14, 0x8f, 0x90, 0x59, 0x82, 0xb8, 0x71, 0x7b, 0x03,
      0x5e, 0x0d, 0xb0, 0x0d, 0xed, 0x7e, 0xbc, 0xb0, 0x85, 0x72, 0xec, 0x76,
      0xbf, 0x01, 0x28, 0x41, 0x11, 0x45, 0xd7, 0x30, 0x91, 0x02, 0x42, 0x01,
      0xb4, 0xbd, 0x6b, 0xc4, 0xba, 0x7b, 0xef, 0xd5, 0xc3, 0x05, 0xe0, 0x18,
      0x44, 0x8a, 0x77, 0x1b, 0x71, 0xfa, 0x1a, 0x11, 0xb3, 0xa2, 0xc6, 0x18,
      0x5d, 0xd6, 0xb8, 0x47, 0x7c, 0x35, 0xea, 0xeb, 0x47, 0x33, 0xfe, 0xcd,
      0x90, 0xf3, 0x8e, 0xcb, 0xa6, 0x28, 0xf2, 0x7c, 0x02, 0xf8, 0x09, 0x19,
      0x1e, 0x99, 0x3e, 0x1e, 0x7f, 0xf5, 0x90, 0x38, 0x3e, 0x2e, 0xc2, 0xaf,
      0xd0, 0x80, 0x20, 0xb2, 0x67},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x35, 0x36, 0x35, 0x33, 0x32, 0x35, 0x32, 0x38, 0x33},
     true},

    // Comment: special case hash
    // tcID: 343
    {SEC_OID_SHA512,
     343,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xa5, 0xce, 0xcc, 0x0e, 0x57, 0x2f,
      0x5e, 0xe4, 0xee, 0xd6, 0x75, 0x5d, 0x32, 0x30, 0xec, 0x5a, 0x93, 0x3c,
      0x1f, 0xb0, 0xe3, 0x5a, 0xe7, 0x71, 0xa1, 0xfc, 0xf0, 0xdc, 0x88, 0x0e,
      0x1c, 0x15, 0x9d, 0xd5, 0xb6, 0xd1, 0x92, 0xdc, 0x37, 0x75, 0x05, 0x04,
      0x8b, 0x71, 0x88, 0xde, 0x3f, 0xeb, 0x81, 0x5a, 0x81, 0xa4, 0xf3, 0x0d,
      0x92, 0x26, 0xcd, 0xc8, 0x5f, 0x75, 0x1d, 0xec, 0x1a, 0x04, 0x10, 0x02,
      0x42, 0x01, 0xef, 0x4a, 0x74, 0x3e, 0x1e, 0x16, 0xf0, 0xa6, 0x02, 0x01,
      0xcc, 0x10, 0x60, 0x62, 0x5e, 0xde, 0x6f, 0x09, 0x36, 0xe7, 0xaf, 0x90,
      0xb4, 0x27, 0x36, 0x28, 0x1e, 0x89, 0xfe, 0x7f, 0x2d, 0xe6, 0xaa, 0x3f,
      0x25, 0xc6, 0x85, 0x76, 0xda, 0x70, 0x5d, 0x8b, 0x3f, 0x6d, 0x5d, 0x8a,
      0x34, 0xd3, 0x07, 0x33, 0x07, 0xea, 0x19, 0x8d, 0x1c, 0xc8, 0xd7, 0x2a,
      0x18, 0xef, 0x25, 0xe9, 0x0f, 0x31, 0xaf},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x32, 0x33, 0x38, 0x32, 0x36, 0x33, 0x34, 0x32, 0x33, 0x35, 0x30},
     true},

    // Comment: special case hash
    // tcID: 344
    {SEC_OID_SHA512,
     344,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xa9, 0x2b, 0x43, 0xf5, 0x74, 0x21,
      0xe5, 0x4d, 0x25, 0x28, 0xd3, 0x05, 0xe7, 0xd5, 0xaa, 0xc9, 0xa7, 0x08,
      0xe7, 0x5a, 0x7d, 0x6f, 0xed, 0xb4, 0x79, 0x08, 0xa4, 0xe3, 0xed, 0xca,
      0xbd, 0xd8, 0x36, 0xa2, 0xc4, 0xe8, 0x43, 0x6f, 0x3b, 0x7b, 0x64, 0x89,
      0x52, 0x54, 0x53, 0x61, 0x74, 0xd8, 0x8c, 0x6d, 0xca, 0x14, 0x36, 0x99,
      0x52, 0x2b, 0xc2, 0xdf, 0xde, 0xeb, 0xcb, 0xf3, 0x8e, 0xb9, 0x05, 0x02,
      0x42, 0x00, 0x93, 0xb0, 0xb9, 0x9a, 0x89, 0xde, 0x72, 0xac, 0xa0, 0xc0,
      0x3e, 0x12, 0x72, 0x4c, 0x2b, 0xe3, 0x23, 0x57, 0x7a, 0x46, 0x29, 0xcb,
      0x47, 0xfd, 0xda, 0x5b, 0x12, 0xb6, 0x1a, 0xce, 0x0b, 0x9f, 0xdb, 0x97,
      0x54, 0x9d, 0x3d, 0x2a, 0x1d, 0xac, 0x15, 0xda, 0x66, 0xba, 0x63, 0x89,
      0xee, 0x54, 0xcb, 0xc8, 0x2c, 0x99, 0x5b, 0x9f, 0x3a, 0xa3, 0xae, 0x84,
      0x74, 0xf4, 0xbb, 0x4b, 0x52, 0xda, 0x8a},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x34, 0x34, 0x37, 0x38, 0x34, 0x37, 0x30, 0x36, 0x35},
     true},

    // Comment: special case hash
    // tcID: 345
    {SEC_OID_SHA512,
     345,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xa0, 0x40, 0x0f, 0x25, 0x51, 0x74,
      0xff, 0xb8, 0x54, 0x8c, 0x29, 0xf5, 0xfa, 0xa7, 0x0e, 0x80, 0x6b, 0xb6,
      0xf6, 0xca, 0x08, 0xa0, 0x87, 0x53, 0xc8, 0x5c, 0x5d, 0x14, 0x5a, 0x55,
      0x5c, 0xc8, 0xe2, 0xdf, 0x28, 0x5a, 0xf9, 0x98, 0x5f, 0x2e, 0x72, 0x9d,
      0x4a, 0x99, 0xa7, 0x34, 0xb7, 0xe7, 0xfc, 0x95, 0x56, 0x0d, 0x54, 0x6a,
      0x06, 0x7f, 0xda, 0x03, 0x52, 0x9f, 0x56, 0xb2, 0xfe, 0x66, 0xbc, 0x02,
      0x42, 0x00, 0xd7, 0xfb, 0x60, 0x27, 0x1d, 0x22, 0xec, 0xb5, 0xd8, 0xec,
      0x90, 0x4a, 0x9d, 0xf1, 0xa4, 0x16, 0xbe, 0x70, 0x6c, 0xe5, 0x39, 0xe3,
      0x46, 0x50, 0xb8, 0xfc, 0x51, 0x4d, 0x1d, 0xd7, 0xaf, 0xeb, 0xc1, 0x34,
      0x4c, 0x0c, 0x68, 0xc5, 0x33, 0xc5, 0xb2, 0x0e, 0xe2, 0x49, 0xa7, 0x7c,
      0x07, 0x52, 0x93, 0xb2, 0xd7, 0xef, 0xc8, 0x73, 0x1c, 0x2e, 0x36, 0x19,
      0xbe, 0x59, 0xda, 0x87, 0x1b, 0xb0, 0x83},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x34, 0x32, 0x36, 0x30, 0x32, 0x30, 0x35, 0x35, 0x34, 0x34},
     true},

    // Comment: special case hash
    // tcID: 346
    {SEC_OID_SHA512,
     346,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x92, 0x07, 0xc7, 0xb6, 0x45, 0xaa,
      0x45, 0xc2, 0x72, 0x23, 0x31, 0xf4, 0x6e, 0x09, 0x4f, 0x2e, 0xb0, 0x05,
      0x20, 0x75, 0xb8, 0xac, 0x94, 0x14, 0xad, 0x77, 0xba, 0xaf, 0xd0, 0x1d,
      0x4d, 0x1f, 0xdc, 0x68, 0x34, 0x41, 0x36, 0xfb, 0xce, 0x01, 0xed, 0xfa,
      0x56, 0x27, 0xbf, 0xb8, 0xf3, 0xc1, 0x28, 0xab, 0xb6, 0x10, 0x72, 0xc7,
      0x48, 0x02, 0x19, 0x2e, 0x89, 0x13, 0x7c, 0x68, 0xd0, 0xcc, 0x31, 0x02,
      0x42, 0x00, 0xff, 0x15, 0xb0, 0x21, 0x8f, 0x81, 0xf0, 0xa8, 0x48, 0x74,
      0x2f, 0x68, 0x3c, 0xb4, 0xd1, 0xb7, 0xc5, 0x17, 0xef, 0xdb, 0x8f, 0xcf,
      0x8a, 0xc6, 0xa3, 0x5e, 0x49, 0x71, 0xb3, 0x55, 0x36, 0x85, 0x1e, 0xd6,
      0x8d, 0xe4, 0x0a, 0x6e, 0x1a, 0x4a, 0x23, 0xbd, 0xdb, 0x5b, 0x42, 0xef,
      0xca, 0x23, 0xb9, 0x1e, 0x91, 0x95, 0x9a, 0x4f, 0x7e, 0x2a, 0xfa, 0x19,
      0x67, 0x79, 0xc9, 0x6c, 0x6c, 0x65, 0x4c},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x39, 0x39, 0x33, 0x38, 0x33, 0x35, 0x32, 0x38, 0x35},
     true},

    // Comment: special case hash
    // tcID: 347
    {SEC_OID_SHA512,
     347,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xaa, 0xf1, 0x19, 0x70, 0x2b, 0x99,
      0x85, 0x35, 0x4b, 0xbe, 0x3f, 0x6b, 0x6c, 0xda, 0x8c, 0x46, 0x15, 0x1a,
      0xf4, 0x20, 0x25, 0x46, 0xdf, 0xbe, 0x04, 0xd5, 0xf0, 0xff, 0xd1, 0x8e,
      0xbe, 0x7b, 0x29, 0xd6, 0x16, 0xf1, 0xc4, 0x03, 0x76, 0xa4, 0x12, 0xa5,
      0x2f, 0x42, 0x04, 0xb5, 0xa1, 0x3e, 0x7f, 0x3e, 0x43, 0x04, 0xea, 0xd5,
      0x66, 0xfc, 0x41, 0xbf, 0x4b, 0x5f, 0xc0, 0xb8, 0x4c, 0x8a, 0x2d, 0x02,
      0x42, 0x00, 0xd5, 0x99, 0xde, 0xaf, 0xd4, 0xfa, 0x23, 0x68, 0xcd, 0x07,
      0x2b, 0x85, 0x4a, 0x3d, 0x53, 0x42, 0x5d, 0x06, 0xad, 0xf3, 0x57, 0x3e,
      0x88, 0x6b, 0x81, 0x24, 0x8a, 0x73, 0x28, 0xa5, 0x46, 0xdd, 0xc4, 0x1c,
      0xae, 0xd3, 0x8c, 0x6b, 0x1f, 0xfe, 0xae, 0xc9, 0xa9, 0x8c, 0x94, 0x09,
      0x05, 0xcb, 0xff, 0xa8, 0x7b, 0x93, 0x6d, 0xa9, 0x80, 0xd4, 0xa9, 0x00,
      0x3d, 0xa4, 0x1e, 0x0c, 0x59, 0xc9, 0x2f},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x34, 0x32, 0x39, 0x32, 0x31, 0x35, 0x33, 0x35, 0x32, 0x33},
     true},

    // Comment: special case hash
    // tcID: 348
    {SEC_OID_SHA512,
     348,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x6c, 0x09, 0xa5, 0x9e, 0x71, 0xcf, 0x34,
      0xf9, 0x83, 0xf7, 0x5d, 0xbb, 0x47, 0x24, 0xc4, 0x82, 0x8a, 0x93, 0x02,
      0x1c, 0xee, 0x8f, 0xd7, 0xd9, 0x2a, 0xf6, 0x94, 0x1c, 0xa8, 0xef, 0xc9,
      0xc5, 0xdd, 0xda, 0x7c, 0x49, 0xa0, 0xe1, 0x77, 0x72, 0x25, 0x78, 0x2e,
      0x09, 0x31, 0x3e, 0x30, 0x91, 0xf0, 0x56, 0x12, 0x2e, 0x58, 0x5c, 0x4e,
      0xaa, 0x68, 0x9f, 0xb2, 0xfd, 0xb1, 0xcb, 0x78, 0x48, 0xd8, 0x02, 0x42,
      0x01, 0x9f, 0x0c, 0x5f, 0xf6, 0xb4, 0x63, 0x8f, 0x4c, 0x33, 0x91, 0x6d,
      0xb7, 0x6f, 0x9d, 0x07, 0x8b, 0xfa, 0x8f, 0x9e, 0x25, 0xae, 0x00, 0x34,
      0x8e, 0x46, 0xbb, 0x32, 0xd7, 0x77, 0xaa, 0x26, 0x15, 0x5b, 0x82, 0xea,
      0x73, 0xa9, 0xe4, 0xe2, 0xf2, 0x1f, 0x6a, 0x65, 0xc7, 0x3e, 0xd6, 0xc6,
      0xab, 0x21, 0x01, 0xce, 0xf3, 0x52, 0x4d, 0x45, 0xb9, 0xfc, 0x6e, 0xa1,
      0x29, 0x2f, 0x19, 0x86, 0xac, 0xad},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x34, 0x34, 0x35, 0x39, 0x39, 0x30, 0x31, 0x34, 0x39, 0x36},
     true},

    // Comment: special case hash
    // tcID: 349
    {SEC_OID_SHA512,
     349,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x4e, 0x79, 0x1c, 0x42, 0xf3, 0x99,
      0x84, 0x58, 0xc5, 0xe1, 0x7f, 0x89, 0x5d, 0x25, 0xc8, 0x5c, 0xb4, 0x19,
      0x19, 0x5d, 0x65, 0xe5, 0xa0, 0xb9, 0xa4, 0x2c, 0xf1, 0x3d, 0xdd, 0x36,
      0x95, 0x9c, 0x73, 0x46, 0x0f, 0x54, 0xaa, 0x84, 0x0d, 0x22, 0x54, 0x35,
      0x5c, 0x6a, 0xc6, 0x26, 0xf4, 0x40, 0xcb, 0x3a, 0x84, 0xfb, 0xa6, 0x32,
      0x26, 0x2c, 0x9d, 0xc5, 0xca, 0xb3, 0x1b, 0xe7, 0xda, 0x10, 0x6b, 0x02,
      0x42, 0x00, 0xab, 0xb9, 0x7b, 0x68, 0x2f, 0x01, 0xf4, 0x51, 0x68, 0x40,
      0x36, 0x13, 0xa7, 0xe2, 0xff, 0x82, 0xbb, 0x4a, 0x9f, 0xc2, 0x09, 0x52,
      0xa3, 0x5d, 0x93, 0x54, 0x28, 0xf7, 0x1d, 0xdc, 0xc7, 0x99, 0xc6, 0xd9,
      0x08, 0x5f, 0xe3, 0x23, 0x0d, 0x72, 0x26, 0x1d, 0x73, 0xcd, 0x08, 0x2e,
      0x81, 0x08, 0x52, 0x3d, 0xa7, 0xba, 0x0b, 0x16, 0x91, 0xad, 0x6e, 0xa6,
      0x3f, 0x5f, 0x4e, 0x8e, 0x89, 0x09, 0xf4},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x33, 0x39, 0x33, 0x39, 0x37, 0x31, 0x31, 0x37, 0x31},
     true},

    // Comment: special case hash
    // tcID: 350
    {SEC_OID_SHA512,
     350,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x3d, 0xed, 0x35, 0xdd, 0xff, 0x2f,
      0x97, 0x78, 0x0b, 0xbc, 0x60, 0xb8, 0xce, 0xc8, 0x98, 0x55, 0xa3, 0x51,
      0x83, 0xa4, 0x8f, 0x8f, 0xa6, 0xbb, 0xdc, 0x18, 0x39, 0x94, 0xbf, 0x89,
      0x02, 0x11, 0x18, 0xcc, 0x01, 0x96, 0x29, 0xdf, 0x72, 0x11, 0x2b, 0x2c,
      0x52, 0x9c, 0x02, 0x3e, 0x7a, 0x5c, 0xfc, 0xe2, 0x53, 0xf7, 0xfd, 0xb4,
      0x91, 0x05, 0xd2, 0x38, 0x68, 0x0b, 0x64, 0x27, 0x5a, 0x21, 0x3c, 0x02,
      0x42, 0x00, 0x9c, 0x92, 0xe7, 0xa0, 0xf7, 0x16, 0x08, 0xe8, 0xd8, 0xcf,
      0xab, 0x3f, 0x85, 0x0f, 0x7f, 0xda, 0x1a, 0x1a, 0x1d, 0x05, 0x6e, 0x72,
      0x25, 0x44, 0x69, 0xaf, 0xe5, 0xce, 0xec, 0x3c, 0x71, 0x8e, 0x6a, 0x46,
      0x2e, 0x13, 0x46, 0x94, 0x1e, 0xb0, 0x8c, 0x10, 0x55, 0x01, 0x64, 0x75,
      0x02, 0xc1, 0xa8, 0x10, 0xa2, 0x9d, 0xf8, 0xb2, 0x08, 0xda, 0x6a, 0x5b,
      0x29, 0x6b, 0x2b, 0xd1, 0xe9, 0x81, 0x37},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x32, 0x33, 0x39, 0x30, 0x36, 0x39, 0x36, 0x34, 0x39, 0x35},
     true},

    // Comment: special case hash
    // tcID: 351
    {SEC_OID_SHA512,
     351,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xd0, 0xd2, 0x97, 0x56, 0xeb, 0xff,
      0x02, 0xb7, 0x16, 0x74, 0xfa, 0x4e, 0xae, 0x37, 0x55, 0x7c, 0xcd, 0x51,
      0xa0, 0x36, 0xfb, 0x1e, 0xb0, 0xb7, 0x12, 0x1b, 0x40, 0x5e, 0x7f, 0xab,
      0xd6, 0x05, 0x92, 0x92, 0x7d, 0x80, 0x5b, 0x75, 0x81, 0x5a, 0xf1, 0xbc,
      0xa6, 0xe9, 0xd6, 0xc5, 0x48, 0x42, 0x25, 0xbd, 0xd0, 0xec, 0x7a, 0x40,
      0x73, 0x5d, 0xa9, 0x72, 0xfd, 0x5f, 0xf6, 0x45, 0xd8, 0x6f, 0x1d, 0x02,
      0x42, 0x00, 0x8b, 0x9f, 0xe5, 0x53, 0x57, 0xdc, 0x11, 0x80, 0x70, 0xcf,
      0x89, 0x89, 0x73, 0xa6, 0x4e, 0x75, 0x54, 0xb7, 0x34, 0xe9, 0x00, 0xc6,
      0x75, 0x54, 0x1e, 0x20, 0x33, 0x2a, 0x26, 0x0c, 0xa5, 0x1a, 0x23, 0x24,
      0x8d, 0x9b, 0x8f, 0x47, 0xde, 0xd8, 0x11, 0xcf, 0xce, 0x55, 0x6a, 0x06,
      0xa7, 0x1b, 0xa5, 0xdc, 0x5b, 0x87, 0x30, 0x75, 0xf2, 0x64, 0xa6, 0x84,
      0x3e, 0x67, 0x5c, 0xaf, 0x06, 0xa5, 0x34},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x31, 0x31, 0x34, 0x34, 0x36, 0x30, 0x35, 0x36, 0x32, 0x36, 0x34},
     true},

    // Comment: special case hash
    // tcID: 352
    {SEC_OID_SHA512,
     352,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x65, 0xfb, 0x99, 0x3f, 0x39, 0xd3,
      0x50, 0xed, 0x60, 0xc8, 0x48, 0x3d, 0xd6, 0xe4, 0xe6, 0x73, 0x65, 0x91,
      0xde, 0xa9, 0x74, 0xec, 0xd8, 0xab, 0x02, 0x7d, 0x38, 0x39, 0xb7, 0x52,
      0x32, 0x2e, 0xe2, 0x20, 0xd4, 0x0b, 0xb6, 0xfc, 0x0b, 0x0d, 0x5a, 0x8c,
      0x42, 0x92, 0x8b, 0xde, 0x50, 0xf6, 0x59, 0xb1, 0x8f, 0x51, 0xf4, 0x2f,
      0xb2, 0xb1, 0xaa, 0x45, 0x83, 0x89, 0x2a, 0x91, 0x14, 0xa0, 0xc3, 0x02,
      0x42, 0x00, 0xa8, 0x81, 0x6c, 0x09, 0xd4, 0x71, 0x38, 0xbf, 0x66, 0x2d,
      0xa4, 0xba, 0x25, 0xca, 0xf4, 0x4e, 0x24, 0x18, 0x56, 0x96, 0xd4, 0x91,
      0x4a, 0x7d, 0xe2, 0xb2, 0x53, 0x5f, 0x73, 0xb9, 0xaf, 0xbd, 0x3f, 0xfa,
      0x9c, 0xb0, 0xa8, 0x6a, 0x11, 0x5e, 0x4d, 0x9a, 0xc5, 0xbe, 0x48, 0xcf,
      0x7e, 0x8f, 0xe2, 0x76, 0x46, 0x6a, 0xbd, 0xf1, 0x71, 0x27, 0xbc, 0xc7,
      0xaa, 0xf4, 0xd0, 0x96, 0x00, 0x8c, 0xa4},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x36, 0x38, 0x35, 0x30, 0x30, 0x34, 0x37, 0x35, 0x30},
     true},

    // Comment: special case hash
    // tcID: 353
    {SEC_OID_SHA512,
     353,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x0b, 0x90, 0x1c, 0x88, 0xea, 0x69, 0x9e,
      0x71, 0x5f, 0x6d, 0xb8, 0x64, 0xe2, 0x3a, 0x67, 0x6e, 0x7f, 0x7f, 0x24,
      0x15, 0xac, 0x1f, 0x85, 0x0f, 0x2d, 0xde, 0x1a, 0xd0, 0xd3, 0xf9, 0xc9,
      0x2e, 0x8c, 0x5d, 0xe6, 0x6d, 0x45, 0x17, 0x4d, 0x61, 0x99, 0x55, 0xfa,
      0xe4, 0xb0, 0xdf, 0xeb, 0xe4, 0x9c, 0x58, 0x35, 0x06, 0x48, 0x1d, 0x28,
      0xd3, 0x0c, 0xbf, 0x58, 0xe2, 0xac, 0x49, 0xf3, 0x70, 0xc2, 0x02, 0x42,
      0x01, 0x44, 0xc9, 0x7b, 0x68, 0x8b, 0x9e, 0xcc, 0x07, 0xb8, 0x4c, 0x68,
      0x09, 0x52, 0x67, 0xe1, 0x7e, 0x48, 0x23, 0x29, 0x22, 0x75, 0x66, 0x09,
      0xe9, 0x85, 0x9d, 0x18, 0xd2, 0xeb, 0x78, 0x44, 0xec, 0x92, 0x51, 0x50,
      0xc3, 0x9f, 0x2b, 0x3a, 0x25, 0x5c, 0x88, 0x2b, 0xe7, 0x05, 0xe0, 0xa8,
      0xe3, 0x0e, 0x68, 0xe4, 0x9f, 0xe7, 0x91, 0x4d, 0xbc, 0xc3, 0xcc, 0xfb,
      0xc1, 0xd4, 0x67, 0x05, 0x0f, 0x80},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x32, 0x32, 0x32, 0x30, 0x35, 0x33, 0x36, 0x30, 0x36, 0x31, 0x39},
     true},

    // Comment: special case hash
    // tcID: 354
    {SEC_OID_SHA512,
     354,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xab, 0xbd, 0x9e, 0x77, 0xef, 0x1e,
      0x2a, 0x36, 0xc6, 0xb0, 0x6f, 0x06, 0x3d, 0x93, 0xef, 0xfb, 0x8e, 0x85,
      0x23, 0x87, 0xa9, 0x4b, 0xfd, 0xf8, 0x35, 0x9b, 0x5c, 0x18, 0x70, 0x8f,
      0x90, 0xd9, 0xf4, 0xe9, 0x74, 0x9f, 0xd4, 0x53, 0x47, 0xf6, 0x37, 0x54,
      0x6b, 0x08, 0x73, 0x37, 0x89, 0xc9, 0x88, 0xfd, 0xa4, 0xf0, 0x30, 0x95,
      0x51, 0xbd, 0xe8, 0x13, 0xa0, 0xbb, 0x1a, 0x23, 0x2a, 0xde, 0xe1, 0x02,
      0x42, 0x01, 0x91, 0x16, 0x5d, 0x58, 0xd1, 0x53, 0xfe, 0xc6, 0x8f, 0x5c,
      0xc8, 0x3b, 0xcf, 0x58, 0x91, 0xe2, 0xe0, 0xca, 0x96, 0x81, 0x20, 0x48,
      0x76, 0xe8, 0x72, 0x45, 0x3e, 0x9e, 0xbd, 0x45, 0x87, 0x0b, 0x68, 0x78,
      0xee, 0x43, 0x7e, 0x4d, 0x83, 0x3c, 0x6e, 0xc5, 0x43, 0x37, 0xb7, 0x79,
      0xac, 0xbf, 0x9f, 0x82, 0x02, 0xdf, 0x51, 0x0d, 0x26, 0x9a, 0x71, 0x0d,
      0x0c, 0x43, 0xe4, 0xe0, 0x7b, 0x04, 0x0d},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5c, 0x64, 0x57, 0xec, 0x08, 0x8d, 0x53, 0x2f, 0x48,
      0x20, 0x93, 0x96, 0x5a, 0xe5, 0x3c, 0xcd, 0x07, 0xe5, 0x56, 0xed, 0x59,
      0xe2, 0xaf, 0x94, 0x5c, 0xd8, 0xc7, 0xa9, 0x5c, 0x1c, 0x64, 0x4f, 0x8a,
      0x56, 0xa8, 0xa8, 0xa3, 0xcd, 0x77, 0x39, 0x2d, 0xdd, 0x86, 0x1e, 0x8a,
      0x92, 0x4d, 0xac, 0x99, 0xc6, 0x90, 0x69, 0x09, 0x3b, 0xd5, 0x2a, 0x52,
      0xfa, 0x6c, 0x56, 0x00, 0x4a, 0x07, 0x45, 0x08, 0x00, 0x78, 0x78, 0xd6,
      0xd4, 0x2e, 0x4b, 0x4d, 0xd1, 0xe9, 0xc0, 0x69, 0x6c, 0xb3, 0xe1, 0x9f,
      0x63, 0x03, 0x3c, 0x3d, 0xb4, 0xe6, 0x0d, 0x47, 0x32, 0x59, 0xb3, 0xeb,
      0xe0, 0x79, 0xaa, 0xf0, 0xa9, 0x86, 0xee, 0x61, 0x77, 0xf8, 0x21, 0x7a,
      0x78, 0xc6, 0x8b, 0x81, 0x3f, 0x7e, 0x14, 0x9a, 0x4e, 0x56, 0xfd, 0x95,
      0x62, 0xc0, 0x7f, 0xed, 0x3d, 0x89, 0x59, 0x42, 0xd7, 0xd1, 0x01, 0xcb,
      0x83, 0xf6},
     {0x36, 0x32, 0x31, 0x35, 0x36, 0x36, 0x35, 0x31, 0x32, 0x34},
     true},

    // Comment: k*G has a large x-coordinate
    // tcID: 355
    {SEC_OID_SHA512,
     355,
     {0x30, 0x67, 0x02, 0x21, 0x05, 0xae, 0x79, 0x78, 0x7c, 0x40, 0xd0, 0x69,
      0x94, 0x80, 0x33, 0xfe, 0xb7, 0x08, 0xf6, 0x5a, 0x2f, 0xc4, 0x4a, 0x36,
      0x47, 0x76, 0x63, 0xb8, 0x51, 0x44, 0x90, 0x48, 0xe1, 0x6e, 0xc7, 0x9b,
      0xf5, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f, 0xcc, 0x01,
      0x48, 0xf7, 0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47,
      0xae, 0xbb, 0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x06},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x49, 0x1c, 0xd6, 0xc5, 0xf9, 0x3b, 0x74, 0x14, 0xd6,
      0xd4, 0x5c, 0xfe, 0x3d, 0x26, 0x4b, 0xd0, 0x77, 0xfc, 0x44, 0x27, 0xa4,
      0xb0, 0xaf, 0xed, 0xe7, 0x6c, 0xac, 0x53, 0x7a, 0x7c, 0xa5, 0xee, 0x2c,
      0x44, 0x56, 0x42, 0x58, 0x26, 0x0f, 0x76, 0x91, 0xb8, 0x1f, 0xdf, 0xec,
      0xeb, 0xfd, 0x03, 0xba, 0x67, 0x22, 0x77, 0x87, 0x5c, 0x5b, 0x31, 0x1e,
      0xa9, 0x20, 0xe7, 0x4f, 0xb3, 0x97, 0x8a, 0xf5, 0x01, 0x44, 0xa3, 0x53,
      0xa2, 0x51, 0xb4, 0x29, 0x78, 0x94, 0x16, 0x1b, 0xae, 0x12, 0xd1, 0x6a,
      0x89, 0xc3, 0x3b, 0x71, 0x9f, 0x90, 0x4c, 0xfc, 0xcc, 0x27, 0x7d, 0xf7,
      0x8c, 0xea, 0x53, 0x79, 0x19, 0x86, 0x42, 0xfd, 0x54, 0x9d, 0xf9, 0x19,
      0x90, 0x4d, 0xc0, 0xcf, 0x36, 0x62, 0xee, 0xab, 0x01, 0xef, 0x11, 0xb8,
      0xe3, 0xcb, 0x49, 0xb5, 0x1b, 0x85, 0x3d, 0x98, 0xf0, 0x42, 0x60, 0x0c,
      0x09, 0x97},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: r too large
    // tcID: 356
    {SEC_OID_SHA512,
     356,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x02,
      0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x51,
      0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7,
      0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb,
      0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x06},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x49, 0x1c, 0xd6, 0xc5, 0xf9, 0x3b, 0x74, 0x14, 0xd6,
      0xd4, 0x5c, 0xfe, 0x3d, 0x26, 0x4b, 0xd0, 0x77, 0xfc, 0x44, 0x27, 0xa4,
      0xb0, 0xaf, 0xed, 0xe7, 0x6c, 0xac, 0x53, 0x7a, 0x7c, 0xa5, 0xee, 0x2c,
      0x44, 0x56, 0x42, 0x58, 0x26, 0x0f, 0x76, 0x91, 0xb8, 0x1f, 0xdf, 0xec,
      0xeb, 0xfd, 0x03, 0xba, 0x67, 0x22, 0x77, 0x87, 0x5c, 0x5b, 0x31, 0x1e,
      0xa9, 0x20, 0xe7, 0x4f, 0xb3, 0x97, 0x8a, 0xf5, 0x01, 0x44, 0xa3, 0x53,
      0xa2, 0x51, 0xb4, 0x29, 0x78, 0x94, 0x16, 0x1b, 0xae, 0x12, 0xd1, 0x6a,
      0x89, 0xc3, 0x3b, 0x71, 0x9f, 0x90, 0x4c, 0xfc, 0xcc, 0x27, 0x7d, 0xf7,
      0x8c, 0xea, 0x53, 0x79, 0x19, 0x86, 0x42, 0xfd, 0x54, 0x9d, 0xf9, 0x19,
      0x90, 0x4d, 0xc0, 0xcf, 0x36, 0x62, 0xee, 0xab, 0x01, 0xef, 0x11, 0xb8,
      0xe3, 0xcb, 0x49, 0xb5, 0x1b, 0x85, 0x3d, 0x98, 0xf0, 0x42, 0x60, 0x0c,
      0x09, 0x97},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: r,s are large
    // tcID: 357
    {SEC_OID_SHA512,
     357,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f,
      0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89,
      0x9c, 0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x07, 0x02,
      0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x51,
      0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7,
      0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb,
      0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x06},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0x5f, 0x28, 0x1d, 0xcd, 0xc9, 0x76, 0x64, 0x1c, 0xe0,
      0x24, 0xdc, 0xa1, 0xea, 0xc8, 0xdd, 0xd7, 0xf9, 0x49, 0xe3, 0x29, 0x0d,
      0x3b, 0x2d, 0xe1, 0x1c, 0x48, 0x73, 0xf3, 0x67, 0x6a, 0x06, 0xff, 0x9f,
      0x70, 0x4c, 0x24, 0x81, 0x3b, 0xd8, 0xd6, 0x35, 0x28, 0xb2, 0xe8, 0x13,
      0xf7, 0x8b, 0x86, 0x9f, 0xf3, 0x81, 0x12, 0x52, 0x7e, 0x79, 0xb3, 0x83,
      0xa3, 0xbd, 0x52, 0x7b, 0xad, 0xb9, 0x29, 0xff, 0x01, 0x50, 0x2e, 0x4c,
      0xc7, 0x03, 0x2d, 0x3e, 0xc3, 0x5b, 0x0f, 0x8d, 0x05, 0x40, 0x94, 0x38,
      0xa8, 0x69, 0x66, 0xd6, 0x23, 0xf7, 0xa2, 0xf4, 0x32, 0xbf, 0x71, 0x2f,
      0x76, 0xdc, 0x63, 0x45, 0x40, 0x5d, 0xfc, 0xfc, 0xdc, 0x36, 0xd4, 0x77,
      0x83, 0x1d, 0x38, 0xee, 0xc6, 0x4e, 0xde, 0x7f, 0x4d, 0x39, 0xaa, 0x91,
      0xbf, 0xfc, 0xc5, 0x6e, 0xc4, 0x24, 0x1c, 0xb0, 0x67, 0x35, 0xb2, 0x80,
      0x9f, 0xbe},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: r and s^-1 have a large Hamming weight
    // tcID: 358
    {SEC_OID_SHA512,
     358,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x02,
      0x42, 0x00, 0x95, 0xe1, 0x9f, 0xd2, 0xb7, 0x55, 0xd6, 0x03, 0xbf, 0x99,
      0x45, 0x62, 0xd9, 0xa1, 0x1f, 0x63, 0xcf, 0x4e, 0xad, 0xec, 0xbd, 0xc0,
      0xec, 0xb5, 0xa3, 0x94, 0xe5, 0x45, 0x29, 0xe8, 0xda, 0x58, 0xa5, 0x27,
      0xbc, 0x6d, 0x85, 0x72, 0x50, 0x43, 0x78, 0x63, 0x62, 0xab, 0x4d, 0xe6,
      0xcb, 0xc7, 0xd8, 0x0e, 0x62, 0x5a, 0xe0, 0xa9, 0x88, 0x61, 0xae, 0xa1,
      0xc7, 0xbf, 0x71, 0x09, 0xc9, 0x1f, 0x66},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x33, 0x6d, 0x5d, 0x08, 0xfe, 0x75, 0xc5, 0x09, 0x46,
      0xe6, 0xdd, 0xdd, 0x36, 0xc5, 0x50, 0xbb, 0x05, 0x4d, 0x99, 0x25, 0xc8,
      0xf2, 0x54, 0xcf, 0xe1, 0xc3, 0x38, 0x8f, 0x72, 0x0b, 0x1d, 0x65, 0x00,
      0xa9, 0x04, 0x12, 0xb0, 0x20, 0xb3, 0xdb, 0x59, 0x2b, 0x92, 0xab, 0x9f,
      0x68, 0xf1, 0xc6, 0x93, 0xb8, 0xd1, 0x36, 0x53, 0x71, 0x63, 0x5e, 0x21,
      0xbc, 0x43, 0xea, 0xad, 0xf8, 0x9e, 0x4e, 0x74, 0x01, 0xd4, 0x8d, 0x60,
      0x31, 0x9d, 0xfd, 0x06, 0xf9, 0x35, 0xfc, 0x46, 0x48, 0x8c, 0x22, 0x9b,
      0x61, 0x1e, 0xec, 0xd0, 0x38, 0x80, 0x4a, 0xe9, 0xf6, 0x81, 0xa0, 0x78,
      0xdd, 0xe8, 0xed, 0x8f, 0x8e, 0x20, 0xad, 0x95, 0x04, 0xbc, 0xf3, 0xc2,
      0x4a, 0x0b, 0x56, 0x6b, 0x1e, 0x85, 0xb2, 0xd3, 0xed, 0x0a, 0x12, 0x73,
      0x29, 0x2f, 0xf5, 0xf8, 0x7b, 0xae, 0x5b, 0x3c, 0x87, 0x85, 0x7e, 0x67,
      0xed, 0x81},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: r and s^-1 have a large Hamming weight
    // tcID: 359
    {SEC_OID_SHA512,
     359,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x02,
      0x41, 0x15, 0x83, 0x76, 0x45, 0x58, 0x3a, 0x37, 0xa7, 0xa6, 0x65, 0xf9,
      0x83, 0xc5, 0xe3, 0x47, 0xf6, 0x5d, 0xca, 0x47, 0x64, 0x7a, 0xa8, 0x0f,
      0xd2, 0x49, 0x8a, 0x79, 0x1d, 0x44, 0xd9, 0xb2, 0x85, 0x0a, 0x15, 0x1a,
      0x6e, 0x86, 0xfc, 0xe7, 0xd7, 0xbb, 0x81, 0x4e, 0x72, 0x4f, 0xf1, 0x1b,
      0x9e, 0xf7, 0x26, 0xbf, 0x36, 0xc6, 0xe7, 0x54, 0x8c, 0x37, 0xf8, 0x2a,
      0x24, 0x90, 0x28, 0x76, 0xee, 0x19},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x6f, 0x8f, 0xad, 0xed, 0xba, 0xe6, 0x37, 0x01, 0x07,
      0x2c, 0x28, 0x7c, 0x63, 0x3f, 0x9c, 0x00, 0x52, 0xea, 0x1e, 0x6c, 0xd0,
      0x0a, 0x84, 0x34, 0x2c, 0xc0, 0xf6, 0x26, 0x21, 0x00, 0x71, 0x57, 0x6a,
      0xbf, 0xd0, 0x87, 0x56, 0x64, 0xb0, 0x74, 0x6c, 0xda, 0xf2, 0x74, 0x5e,
      0xff, 0xc1, 0x8d, 0x94, 0x90, 0x5b, 0x0f, 0xc9, 0xd2, 0xca, 0xd4, 0xba,
      0x37, 0x5c, 0x0e, 0xa2, 0x29, 0x8c, 0x8d, 0x1c, 0x01, 0x50, 0xd1, 0x28,
      0xcb, 0x62, 0xa5, 0x27, 0xae, 0x6d, 0xf3, 0xe9, 0x2f, 0x1f, 0x28, 0x0e,
      0xa3, 0x32, 0x48, 0x71, 0x1f, 0xfe, 0x4b, 0x35, 0xc1, 0xb1, 0x62, 0xa9,
      0x50, 0x85, 0x76, 0x86, 0x01, 0x65, 0xe0, 0xdd, 0xc3, 0x61, 0xd9, 0x6f,
      0xaf, 0xcd, 0x2f, 0xf8, 0x27, 0x76, 0xc7, 0x43, 0xb9, 0xcd, 0x68, 0x45,
      0xdb, 0x61, 0xeb, 0x56, 0x73, 0x9f, 0x5c, 0x4e, 0xf5, 0x61, 0xe6, 0xc2,
      0x0d, 0x8c},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: small r and s
    // tcID: 360
    {SEC_OID_SHA512,
     360,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x02, 0x01, 0x01},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5e, 0x7e, 0xb6, 0xc4, 0xf4, 0x81, 0x83, 0x0a, 0xba,
      0xad, 0x8a, 0x60, 0xdd, 0xb0, 0x98, 0x91, 0x16, 0x4e, 0xe4, 0x18, 0xea,
      0x4c, 0xd2, 0x99, 0x50, 0x62, 0xe2, 0x27, 0xd3, 0x3c, 0x22, 0x9f, 0xb7,
      0x37, 0xbf, 0x33, 0x07, 0x03, 0x09, 0x7d, 0x6b, 0x3b, 0x69, 0xa3, 0xf0,
      0x9e, 0x79, 0xc9, 0xde, 0x0b, 0x40, 0x2b, 0xf8, 0x46, 0xdd, 0x26, 0xb5,
      0xbb, 0x11, 0x91, 0xcf, 0xf8, 0x01, 0x35, 0x5d, 0x01, 0x78, 0x9c, 0x9a,
      0xfd, 0xa5, 0x67, 0xe6, 0x1d, 0xe4, 0x14, 0x43, 0x7b, 0x0e, 0x93, 0xa1,
      0x76, 0x11, 0xe6, 0xe7, 0x68, 0x53, 0x76, 0x2b, 0xc0, 0xaf, 0xf1, 0xe2,
      0xbc, 0x9e, 0x46, 0xce, 0x12, 0x85, 0xb9, 0x31, 0x65, 0x1d, 0x71, 0x29,
      0xb8, 0x5a, 0xef, 0x2c, 0x1f, 0xab, 0x17, 0x28, 0xe7, 0xeb, 0x44, 0x49,
      0xb2, 0x95, 0x6d, 0xec, 0x33, 0xe6, 0xcd, 0x7c, 0x9b, 0xa1, 0x25, 0xc5,
      0xcd, 0x9d},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: small r and s
    // tcID: 361
    {SEC_OID_SHA512,
     361,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x02, 0x01, 0x02},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0xb4, 0x20, 0xfb, 0x1f, 0xec, 0xdd, 0x9c, 0xc5, 0xea,
      0x7d, 0x7c, 0x76, 0x17, 0xe7, 0x05, 0x38, 0xdb, 0x32, 0xe6, 0xd7, 0xa0,
      0xad, 0x72, 0x2c, 0x63, 0x58, 0x0f, 0x1f, 0x6a, 0x1f, 0x55, 0x37, 0xeb,
      0x50, 0x93, 0x0b, 0x90, 0xfd, 0x6f, 0xdd, 0x9a, 0xbd, 0x40, 0x01, 0x5f,
      0x74, 0x6d, 0x2f, 0xd8, 0xad, 0xf9, 0x45, 0xa7, 0x56, 0x21, 0x40, 0x7e,
      0xdb, 0x68, 0x63, 0x58, 0x8e, 0x41, 0x97, 0x9e, 0x00, 0x29, 0x51, 0x08,
      0xa7, 0xe9, 0xd2, 0x19, 0x1a, 0x28, 0x7f, 0xd1, 0x60, 0xbd, 0x24, 0xf4,
      0x98, 0x05, 0x5d, 0xc9, 0xba, 0xdb, 0xd6, 0x1c, 0x6a, 0x89, 0xfe, 0xde,
      0x27, 0xb4, 0xf9, 0xd4, 0x79, 0xd8, 0x6a, 0x20, 0xb6, 0xdc, 0x07, 0xc9,
      0x0f, 0x00, 0x8e, 0xbe, 0x68, 0xa0, 0xe0, 0xcc, 0x15, 0xa4, 0xa0, 0x3b,
      0x8c, 0xf9, 0x90, 0xe4, 0xff, 0x7e, 0xd6, 0xe3, 0x89, 0x2b, 0x21, 0xc5,
      0x21, 0x53},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: small r and s
    // tcID: 362
    {SEC_OID_SHA512,
     362,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x02, 0x01, 0x03},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x32, 0xb9, 0xa1, 0x7c, 0x20, 0x1a, 0xec, 0x34, 0xd2,
      0x9b, 0x8c, 0x27, 0x64, 0xe7, 0xc7, 0xf6, 0xae, 0xef, 0x10, 0xfb, 0x61,
      0xbf, 0x98, 0x37, 0x11, 0x7f, 0xad, 0x87, 0x9f, 0x8c, 0x6a, 0x22, 0xa3,
      0x00, 0x00, 0x6d, 0x20, 0x18, 0xcf, 0x42, 0xb2, 0x58, 0x98, 0xff, 0xc9,
      0xa1, 0xbf, 0x50, 0x73, 0x52, 0xe5, 0x9e, 0x6a, 0x52, 0xe6, 0x27, 0xcd,
      0xa1, 0x60, 0xe1, 0x7e, 0xa2, 0xf4, 0x60, 0x05, 0x00, 0x31, 0x7a, 0x89,
      0x89, 0x9b, 0x7c, 0xb3, 0xa0, 0xd3, 0x3e, 0xaf, 0xa0, 0x2b, 0x01, 0x37,
      0xa0, 0xfb, 0x1b, 0x05, 0x10, 0x2b, 0x22, 0xb6, 0x76, 0xf3, 0x5b, 0x9f,
      0xf6, 0xc0, 0x50, 0xdd, 0xee, 0x9f, 0x18, 0x56, 0x09, 0xff, 0xb7, 0xf5,
      0x16, 0x5a, 0x76, 0x9e, 0x44, 0x07, 0x92, 0xb7, 0x50, 0x44, 0xa4, 0x3e,
      0x83, 0x86, 0x90, 0xd1, 0x3f, 0x88, 0x4a, 0xaa, 0xe8, 0x88, 0xbf, 0x5f,
      0x86, 0xf0},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: r is larger than n
    // tcID: 363
    {SEC_OID_SHA512,
     363,
     {0x30, 0x47, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f,
      0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0, 0x3b,
      0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e,
      0x91, 0x38, 0x64, 0x0a, 0x02, 0x01, 0x03},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x32, 0xb9, 0xa1, 0x7c, 0x20, 0x1a, 0xec, 0x34, 0xd2,
      0x9b, 0x8c, 0x27, 0x64, 0xe7, 0xc7, 0xf6, 0xae, 0xef, 0x10, 0xfb, 0x61,
      0xbf, 0x98, 0x37, 0x11, 0x7f, 0xad, 0x87, 0x9f, 0x8c, 0x6a, 0x22, 0xa3,
      0x00, 0x00, 0x6d, 0x20, 0x18, 0xcf, 0x42, 0xb2, 0x58, 0x98, 0xff, 0xc9,
      0xa1, 0xbf, 0x50, 0x73, 0x52, 0xe5, 0x9e, 0x6a, 0x52, 0xe6, 0x27, 0xcd,
      0xa1, 0x60, 0xe1, 0x7e, 0xa2, 0xf4, 0x60, 0x05, 0x00, 0x31, 0x7a, 0x89,
      0x89, 0x9b, 0x7c, 0xb3, 0xa0, 0xd3, 0x3e, 0xaf, 0xa0, 0x2b, 0x01, 0x37,
      0xa0, 0xfb, 0x1b, 0x05, 0x10, 0x2b, 0x22, 0xb6, 0x76, 0xf3, 0x5b, 0x9f,
      0xf6, 0xc0, 0x50, 0xdd, 0xee, 0x9f, 0x18, 0x56, 0x09, 0xff, 0xb7, 0xf5,
      0x16, 0x5a, 0x76, 0x9e, 0x44, 0x07, 0x92, 0xb7, 0x50, 0x44, 0xa4, 0x3e,
      0x83, 0x86, 0x90, 0xd1, 0x3f, 0x88, 0x4a, 0xaa, 0xe8, 0x88, 0xbf, 0x5f,
      0x86, 0xf0},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: s is larger than n
    // tcID: 364
    {SEC_OID_SHA512,
     364,
     {0x30, 0x47, 0x02, 0x01, 0x01, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x51, 0x86, 0x87,
      0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7, 0x09,
      0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb,
      0x6f, 0xb7, 0x1e, 0x91, 0x4b, 0x3a, 0x90},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x67, 0xdd, 0x45, 0x6b, 0x52, 0xf8, 0x2a, 0x5d, 0x4c,
      0x4a, 0x71, 0xb3, 0xea, 0x93, 0x02, 0xf6, 0x2a, 0x85, 0x2d, 0xdc, 0x04,
      0xad, 0x25, 0xb6, 0x2f, 0xef, 0x1d, 0xdf, 0x65, 0x73, 0x74, 0xfb, 0x4e,
      0x80, 0x67, 0x9d, 0xdf, 0x42, 0xd2, 0x12, 0xf0, 0x71, 0x1d, 0xb3, 0x2b,
      0x62, 0x6d, 0x85, 0x93, 0xbd, 0x70, 0x89, 0x2e, 0x93, 0xed, 0x0a, 0xdb,
      0x27, 0x31, 0x57, 0xb6, 0xdf, 0x18, 0x79, 0x38, 0x01, 0x4d, 0x2c, 0x78,
      0x50, 0x9f, 0x3b, 0xd6, 0xf7, 0xd0, 0xfb, 0xa4, 0xa9, 0x0c, 0xb4, 0x56,
      0x28, 0x6e, 0x26, 0x7f, 0x5d, 0xd9, 0xd9, 0x67, 0x84, 0x2a, 0x60, 0x86,
      0x88, 0x4d, 0x66, 0xc7, 0xb2, 0xa9, 0x32, 0x83, 0x34, 0x70, 0xc7, 0x21,
      0xa4, 0xa7, 0x28, 0xcd, 0x84, 0x86, 0xd1, 0x53, 0x14, 0x23, 0x2d, 0x80,
      0x1f, 0x17, 0xe3, 0xa6, 0xfd, 0x70, 0x68, 0xbd, 0xeb, 0xac, 0xdf, 0x82,
      0xc0, 0xb4},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: small r and s^-1
    // tcID: 365
    {SEC_OID_SHA512,
     365,
     {0x30, 0x48, 0x02, 0x02, 0x01, 0x00, 0x02, 0x42, 0x01, 0xef, 0xdf,
      0xbf, 0x7e, 0xfd, 0xfb, 0xf7, 0xef, 0xdf, 0xbf, 0x7e, 0xfd, 0xfb,
      0xf7, 0xef, 0xdf, 0xbf, 0x7e, 0xfd, 0xfb, 0xf7, 0xef, 0xdf, 0xbf,
      0x7e, 0xfd, 0xfb, 0xf7, 0xef, 0xdf, 0xbf, 0x7e, 0xf8, 0x7b, 0x4d,
      0xe1, 0xfc, 0x92, 0xdd, 0x75, 0x76, 0x39, 0x40, 0x8a, 0x50, 0xbe,
      0xe1, 0x07, 0x64, 0xe3, 0x26, 0xfd, 0xd2, 0xfa, 0x30, 0x8d, 0xfd,
      0xe3, 0xe5, 0x24, 0x3f, 0xdf, 0x4a, 0xc5, 0xac},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x68, 0xd7, 0xb5, 0x18, 0x21, 0x47, 0x66, 0xac, 0x73,
      0x4a, 0x74, 0x61, 0xd4, 0x99, 0x35, 0x24, 0x44, 0x37, 0x7d, 0x50, 0xaf,
      0x42, 0xa1, 0xbb, 0xdb, 0x7f, 0x00, 0x32, 0x06, 0x5e, 0xe6, 0xdc, 0x34,
      0x1c, 0xcf, 0x23, 0x1a, 0xf6, 0x52, 0x50, 0xe7, 0xd1, 0x3a, 0x80, 0x73,
      0x3a, 0xbe, 0xbf, 0xf5, 0x59, 0x89, 0x1d, 0x42, 0x11, 0xd6, 0xc2, 0x8c,
      0xf9, 0x52, 0xc9, 0x22, 0x23, 0x03, 0xb5, 0x3b, 0x00, 0xa2, 0xf3, 0xd7,
      0xe1, 0x4d, 0x9d, 0x8f, 0xab, 0xe1, 0x93, 0x9d, 0x66, 0x4e, 0x46, 0x15,
      0xc6, 0xe2, 0x4f, 0x54, 0x90, 0xc8, 0x15, 0xc7, 0x65, 0x1c, 0xcf, 0x6c,
      0xc6, 0x52, 0x52, 0xf8, 0x8b, 0xcf, 0xd3, 0xb0, 0x7f, 0xbd, 0xba, 0xa0,
      0xba, 0x00, 0x44, 0x1e, 0x59, 0x0c, 0xcb, 0xce, 0xa0, 0x06, 0x58, 0xf3,
      0x88, 0xf2, 0x2c, 0x42, 0xd8, 0xa6, 0xd0, 0xf7, 0x81, 0xae, 0x5b, 0xb4,
      0xd7, 0x8b},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: smallish r and s^-1
    // tcID: 366
    {SEC_OID_SHA512,
     366,
     {0x30, 0x4d, 0x02, 0x07, 0x2d, 0x9b, 0x4d, 0x34, 0x79, 0x52, 0xcd, 0x02,
      0x42, 0x01, 0x00, 0x50, 0x8d, 0x07, 0x34, 0x13, 0xde, 0x82, 0x92, 0x75,
      0xe7, 0x65, 0x09, 0xfd, 0x81, 0xcf, 0xf4, 0x9a, 0xdf, 0x4c, 0x80, 0xed,
      0x2d, 0xdd, 0x4a, 0x79, 0x37, 0xd1, 0xd9, 0x18, 0x79, 0x68, 0x78, 0xfe,
      0xc2, 0x4c, 0xc4, 0x65, 0x70, 0x98, 0x2c, 0x3f, 0xb8, 0xf5, 0xe9, 0x2c,
      0xcd, 0xcb, 0x3e, 0x67, 0x7f, 0x07, 0xe9, 0xbd, 0x0d, 0xb0, 0xb8, 0x48,
      0x14, 0xbe, 0x1c, 0x79, 0x49, 0xb0, 0xde},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0x1e, 0xdc, 0x3b, 0x22, 0xb2, 0x0f, 0x9a, 0x18, 0x8b,
      0x32, 0xb1, 0xe8, 0x27, 0xd6, 0xe4, 0x6b, 0x2e, 0xd6, 0x1b, 0x9b, 0xe6,
      0xf4, 0xad, 0xa0, 0xb2, 0xc9, 0x58, 0x35, 0xbe, 0xe2, 0x73, 0x8e, 0xc4,
      0xdc, 0x53, 0x13, 0x83, 0x1c, 0xce, 0x5f, 0x92, 0x72, 0x10, 0xa7, 0xbc,
      0x2f, 0x13, 0xab, 0xc0, 0x2f, 0xa9, 0x0e, 0x71, 0x6f, 0xc1, 0xbd, 0x2f,
      0x63, 0xc4, 0x29, 0xa7, 0x60, 0xed, 0x23, 0x63, 0x01, 0x18, 0xda, 0xad,
      0x88, 0xfe, 0x9b, 0x9d, 0x66, 0xe6, 0x6e, 0x71, 0xce, 0x05, 0xd7, 0x41,
      0x37, 0xd2, 0x77, 0xa9, 0xca, 0x81, 0xc7, 0xd7, 0xae, 0xf1, 0xe7, 0x45,
      0x50, 0x89, 0x05, 0x64, 0x10, 0x3c, 0xc0, 0xd9, 0x5d, 0x30, 0xf6, 0x20,
      0x5c, 0x91, 0x24, 0x82, 0x91, 0x92, 0xe1, 0x5d, 0x66, 0xfb, 0x1f, 0x40,
      0x33, 0x03, 0x2a, 0x42, 0xba, 0x60, 0x6e, 0x3e, 0xdc, 0xa6, 0xec, 0x06,
      0x5c, 0x50},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: 100-bit r and small s^-1
    // tcID: 367
    {SEC_OID_SHA512,
     367,
     {0x30, 0x53, 0x02, 0x0d, 0x10, 0x33, 0xe6, 0x7e, 0x37, 0xb3, 0x2b,
      0x44, 0x55, 0x80, 0xbf, 0x4e, 0xff, 0x02, 0x42, 0x01, 0x3c, 0xc3,
      0x3c, 0xc3, 0x3c, 0xc3, 0x3c, 0xc3, 0x3c, 0xc3, 0x3c, 0xc3, 0x3c,
      0xc3, 0x3c, 0xc3, 0x3c, 0xc3, 0x3c, 0xc3, 0x3c, 0xc3, 0x3c, 0xc3,
      0x3c, 0xc3, 0x3c, 0xc3, 0x3c, 0xc3, 0x3c, 0xc3, 0x39, 0x3f, 0x63,
      0x2a, 0xff, 0xd3, 0xea, 0xa3, 0xc8, 0xfb, 0x64, 0x50, 0x7b, 0xd5,
      0x99, 0x64, 0x97, 0xbd, 0x58, 0x8f, 0xb9, 0xe3, 0x94, 0x7c, 0x09,
      0x7c, 0xed, 0x75, 0x46, 0xb5, 0x7c, 0x89, 0x98},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0x2f, 0x8b, 0x98, 0x63, 0xa1, 0x88, 0x7e, 0xca, 0x68,
      0x27, 0xad, 0x4a, 0xcc, 0xc2, 0xba, 0x60, 0x7f, 0x85, 0x92, 0xe5, 0xbe,
      0x15, 0xd9, 0x69, 0x2b, 0x69, 0x7a, 0x40, 0x61, 0xfc, 0xc8, 0x15, 0x60,
      0xc8, 0xfe, 0xb2, 0xae, 0x38, 0x51, 0xd0, 0x0e, 0x06, 0xdf, 0x3e, 0x00,
      0x91, 0xf1, 0xf1, 0xca, 0x5e, 0xc6, 0x47, 0x61, 0xf4, 0xf8, 0xbd, 0x6d,
      0x0c, 0x2c, 0xab, 0x2a, 0x12, 0x10, 0x24, 0x44, 0x01, 0x74, 0xb4, 0xe3,
      0x4a, 0xec, 0x51, 0x7a, 0x0d, 0x2c, 0xeb, 0x2f, 0xd1, 0x52, 0xed, 0x17,
      0x36, 0xbc, 0x33, 0x0e, 0xfc, 0xa5, 0xe6, 0xd5, 0x30, 0xea, 0x17, 0x08,
      0x02, 0xfb, 0x6a, 0xf0, 0x31, 0x42, 0x59, 0x03, 0xfa, 0x6a, 0x37, 0x84,
      0x05, 0xbe, 0x5e, 0x47, 0xd1, 0xe5, 0x2f, 0x62, 0xf8, 0x59, 0xf5, 0x37,
      0xdf, 0x9c, 0x0f, 0x6a, 0x4a, 0x64, 0x79, 0xa0, 0xaa, 0xda, 0xfe, 0x21,
      0x98, 0x21},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: small r and 100 bit s^-1
    // tcID: 368
    {SEC_OID_SHA512,
     368,
     {0x30, 0x48, 0x02, 0x02, 0x01, 0x00, 0x02, 0x42, 0x00, 0x86, 0xec,
      0xbf, 0x54, 0xab, 0x59, 0xa4, 0xe1, 0x95, 0xf0, 0xbe, 0x14, 0x02,
      0xed, 0xd8, 0x65, 0x7b, 0xb9, 0x46, 0x18, 0xfa, 0xb5, 0x0f, 0x2f,
      0xe2, 0x0f, 0xe5, 0xeb, 0xbc, 0x9f, 0xf0, 0xe4, 0x91, 0x39, 0x7e,
      0xd3, 0x13, 0xcc, 0x91, 0x8d, 0x43, 0x8e, 0xed, 0xb9, 0xb5, 0xec,
      0xb4, 0xd9, 0xdf, 0xa3, 0x05, 0x30, 0x35, 0x05, 0xba, 0xf2, 0x54,
      0x00, 0xed, 0x8c, 0x20, 0xfc, 0x3f, 0xc4, 0x7b},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x8a, 0xed, 0x77, 0x9a, 0x32, 0xb9, 0xbf, 0x56, 0xea,
      0x7a, 0xb4, 0x6e, 0x4b, 0x91, 0x4e, 0x55, 0xc6, 0x53, 0x01, 0xcd, 0xbe,
      0x9e, 0xa6, 0xe7, 0xed, 0x44, 0xf7, 0xe9, 0x78, 0xc0, 0x36, 0x59, 0x89,
      0xa1, 0x9a, 0x5e, 0x48, 0x28, 0x2f, 0xb1, 0x15, 0x8f, 0x48, 0x1c, 0x55,
      0x65, 0x05, 0xd6, 0x6f, 0xf4, 0x14, 0xa0, 0x70, 0x03, 0xeb, 0xf8, 0x2f,
      0xca, 0x16, 0x98, 0xc3, 0x3f, 0x28, 0x84, 0xc6, 0x00, 0xa6, 0x24, 0x26,
      0x99, 0x3e, 0xd5, 0xb1, 0x77, 0xb6, 0x04, 0x5e, 0x60, 0xb5, 0xfa, 0x1a,
      0x1f, 0x8c, 0xe1, 0xad, 0x5d, 0x70, 0xe7, 0xbc, 0x7b, 0x5a, 0xf8, 0x11,
      0xdb, 0xf8, 0x6e, 0x65, 0x1f, 0x9e, 0xa0, 0x2e, 0xc7, 0x96, 0xab, 0x99,
      0x1e, 0x14, 0x39, 0xbf, 0x07, 0xff, 0xe2, 0xac, 0x60, 0x52, 0xa8, 0xa0,
      0xb0, 0x17, 0x4d, 0x78, 0xa9, 0x44, 0x1a, 0xaf, 0x4d, 0x8f, 0xc7, 0x57,
      0xd8, 0x0f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: 100-bit r and s^-1
    // tcID: 369
    {SEC_OID_SHA512,
     369,
     {0x30, 0x53, 0x02, 0x0d, 0x06, 0x25, 0x22, 0xbb, 0xd3, 0xec, 0xbe,
      0x7c, 0x39, 0xe9, 0x3e, 0x7c, 0x24, 0x02, 0x42, 0x00, 0x86, 0xec,
      0xbf, 0x54, 0xab, 0x59, 0xa4, 0xe1, 0x95, 0xf0, 0xbe, 0x14, 0x02,
      0xed, 0xd8, 0x65, 0x7b, 0xb9, 0x46, 0x18, 0xfa, 0xb5, 0x0f, 0x2f,
      0xe2, 0x0f, 0xe5, 0xeb, 0xbc, 0x9f, 0xf0, 0xe4, 0x91, 0x39, 0x7e,
      0xd3, 0x13, 0xcc, 0x91, 0x8d, 0x43, 0x8e, 0xed, 0xb9, 0xb5, 0xec,
      0xb4, 0xd9, 0xdf, 0xa3, 0x05, 0x30, 0x35, 0x05, 0xba, 0xf2, 0x54,
      0x00, 0xed, 0x8c, 0x20, 0xfc, 0x3f, 0xc4, 0x7b},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x93, 0x69, 0x7b, 0x03, 0x78, 0x31, 0x2b, 0x38, 0xc3,
      0x1d, 0xea, 0xe0, 0x73, 0xf2, 0x4a, 0x81, 0x63, 0xf0, 0x86, 0xac, 0x21,
      0x16, 0xb7, 0xc3, 0x7c, 0x99, 0x15, 0x7c, 0xfa, 0xe7, 0x97, 0x0a, 0xb4,
      0x20, 0x1f, 0x5a, 0x7e, 0x06, 0xec, 0x39, 0xee, 0xdb, 0xf7, 0xd8, 0x7f,
      0x30, 0x21, 0xca, 0x43, 0x9e, 0x3f, 0xf7, 0xc5, 0x98, 0x8b, 0x84, 0x67,
      0x99, 0x37, 0xba, 0xb7, 0x86, 0xdb, 0xe1, 0x2e, 0x01, 0xc6, 0x98, 0x7c,
      0x86, 0x07, 0x7c, 0x05, 0x42, 0x3a, 0xc2, 0x81, 0xde, 0x6d, 0x23, 0xf6,
      0xa6, 0x85, 0x87, 0x0e, 0x12, 0x85, 0x54, 0x63, 0x77, 0x0e, 0xcc, 0xab,
      0xc9, 0xf3, 0xa1, 0xd2, 0x3c, 0xb2, 0xa0, 0xc1, 0x54, 0x79, 0x42, 0x0b,
      0x5d, 0xd4, 0x0f, 0xbd, 0xc9, 0x88, 0x6c, 0x46, 0x3b, 0x62, 0xee, 0x23,
      0x23, 0x9d, 0xf3, 0xa8, 0xb8, 0x61, 0xc3, 0x29, 0x1d, 0x28, 0x22, 0x4f,
      0x60, 0x57},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: r and s^-1 are close to n
    // tcID: 370
    {SEC_OID_SHA512,
     370,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f,
      0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89,
      0x9c, 0x47, 0xae, 0xbb, 0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x63, 0x8a, 0x02,
      0x42, 0x01, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x51, 0x8b,
      0xaf, 0x05, 0x02, 0x7f, 0x75, 0x0e, 0xf2, 0x55, 0x32, 0xab, 0x85, 0xfa,
      0x06, 0x6e, 0x8a, 0xd2, 0x79, 0x31, 0x25, 0xb1, 0x12, 0xda, 0x74, 0x7c,
      0xf5, 0x24, 0xbf, 0x0b, 0x7a, 0xed, 0x5b},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0x9a, 0x9f, 0x1b, 0x7b, 0x7f, 0x57, 0x4a, 0x02, 0x1f,
      0xed, 0xd8, 0x67, 0x9a, 0x4e, 0x99, 0x8b, 0x48, 0x52, 0x48, 0x54, 0xee,
      0xfb, 0xaa, 0xe4, 0x10, 0x4a, 0x39, 0x73, 0xd6, 0x93, 0xe0, 0x21, 0x04,
      0xfa, 0x11, 0x92, 0x43, 0x25, 0x6e, 0x3d, 0x98, 0x6f, 0x8b, 0x49, 0x66,
      0xc2, 0x86, 0xab, 0x8c, 0xb1, 0xf5, 0x26, 0x7c, 0x0b, 0xbd, 0x6b, 0xc1,
      0x82, 0xae, 0xb5, 0x74, 0x93, 0xa5, 0xd5, 0xb6, 0x01, 0x58, 0xb9, 0x7e,
      0xb7, 0x48, 0x62, 0xfb, 0xca, 0x41, 0x76, 0x3e, 0x8d, 0x3a, 0x7b, 0xeb,
      0x5f, 0xcc, 0xd0, 0x55, 0x65, 0xb7, 0x5a, 0x3a, 0x43, 0xc2, 0xb3, 0x8b,
      0x96, 0xeb, 0x2c, 0xcf, 0xf1, 0x49, 0xc2, 0x3e, 0xf1, 0xac, 0x09, 0xfc,
      0x45, 0x5d, 0x80, 0x8f, 0xf2, 0x80, 0x81, 0xe9, 0x85, 0xf9, 0xe1, 0x72,
      0xfc, 0x62, 0xd0, 0x90, 0x05, 0x85, 0x17, 0x2c, 0xfb, 0xff, 0x87, 0x38,
      0x35, 0x95},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: s == 1
    // tcID: 371
    {SEC_OID_SHA512,
     371,
     {0x30, 0x47, 0x02, 0x42, 0x00, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xaa, 0xaa, 0xa8, 0xc5, 0xd7, 0x82, 0x81, 0x3f, 0xba,
      0x87, 0x79, 0x2a, 0x99, 0x55, 0xc2, 0xfd, 0x03, 0x37, 0x45, 0x69,
      0x3c, 0x98, 0x92, 0xd8, 0x89, 0x6d, 0x3a, 0x3e, 0x7a, 0x92, 0x5f,
      0x85, 0xbd, 0x76, 0xad, 0x02, 0x01, 0x01},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0xaa, 0x9f, 0x3a, 0x89, 0x4b, 0x72, 0x7d, 0x7a, 0x01,
      0xb0, 0x9c, 0x4f, 0x05, 0x1b, 0x46, 0x9d, 0x66, 0x1d, 0xe1, 0xe0, 0x69,
      0x15, 0xb5, 0x99, 0xe2, 0x11, 0x46, 0x33, 0x19, 0xac, 0x1b, 0x7c, 0xa8,
      0xa6, 0x09, 0x7f, 0x1b, 0xe4, 0x01, 0xd7, 0x0a, 0x71, 0xd0, 0xb5, 0x36,
      0x55, 0xcd, 0xf9, 0xbe, 0xf7, 0x48, 0xd8, 0x86, 0xe0, 0x8e, 0xe7, 0xde,
      0x2f, 0xa7, 0x81, 0xe9, 0x3e, 0xc4, 0x1a, 0x26, 0x01, 0xba, 0x9e, 0xa6,
      0x73, 0x85, 0xe1, 0x98, 0x94, 0xfc, 0x9c, 0xd4, 0xb0, 0x17, 0x3a, 0xb2,
      0x15, 0xf7, 0xb9, 0x6f, 0x23, 0xbc, 0x42, 0x06, 0x65, 0xd4, 0x6c, 0x75,
      0x44, 0x7b, 0xf2, 0x00, 0xae, 0x3a, 0xc7, 0xb4, 0x2b, 0xd9, 0xb8, 0x57,
      0xfd, 0x1c, 0x85, 0xcc, 0xe8, 0xea, 0x9c, 0x8d, 0x23, 0x45, 0xe4, 0x68,
      0x7d, 0xd7, 0x0d, 0xf5, 0x9f, 0x51, 0x49, 0x51, 0x07, 0x35, 0xbb, 0x9c,
      0x7b, 0x64},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: s == 0
    // tcID: 372
    {SEC_OID_SHA512,
     372,
     {0x30, 0x47, 0x02, 0x42, 0x00, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xaa, 0xaa, 0xa8, 0xc5, 0xd7, 0x82, 0x81, 0x3f, 0xba,
      0x87, 0x79, 0x2a, 0x99, 0x55, 0xc2, 0xfd, 0x03, 0x37, 0x45, 0x69,
      0x3c, 0x98, 0x92, 0xd8, 0x89, 0x6d, 0x3a, 0x3e, 0x7a, 0x92, 0x5f,
      0x85, 0xbd, 0x76, 0xad, 0x02, 0x01, 0x00},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0xaa, 0x9f, 0x3a, 0x89, 0x4b, 0x72, 0x7d, 0x7a, 0x01,
      0xb0, 0x9c, 0x4f, 0x05, 0x1b, 0x46, 0x9d, 0x66, 0x1d, 0xe1, 0xe0, 0x69,
      0x15, 0xb5, 0x99, 0xe2, 0x11, 0x46, 0x33, 0x19, 0xac, 0x1b, 0x7c, 0xa8,
      0xa6, 0x09, 0x7f, 0x1b, 0xe4, 0x01, 0xd7, 0x0a, 0x71, 0xd0, 0xb5, 0x36,
      0x55, 0xcd, 0xf9, 0xbe, 0xf7, 0x48, 0xd8, 0x86, 0xe0, 0x8e, 0xe7, 0xde,
      0x2f, 0xa7, 0x81, 0xe9, 0x3e, 0xc4, 0x1a, 0x26, 0x01, 0xba, 0x9e, 0xa6,
      0x73, 0x85, 0xe1, 0x98, 0x94, 0xfc, 0x9c, 0xd4, 0xb0, 0x17, 0x3a, 0xb2,
      0x15, 0xf7, 0xb9, 0x6f, 0x23, 0xbc, 0x42, 0x06, 0x65, 0xd4, 0x6c, 0x75,
      0x44, 0x7b, 0xf2, 0x00, 0xae, 0x3a, 0xc7, 0xb4, 0x2b, 0xd9, 0xb8, 0x57,
      0xfd, 0x1c, 0x85, 0xcc, 0xe8, 0xea, 0x9c, 0x8d, 0x23, 0x45, 0xe4, 0x68,
      0x7d, 0xd7, 0x0d, 0xf5, 0x9f, 0x51, 0x49, 0x51, 0x07, 0x35, 0xbb, 0x9c,
      0x7b, 0x64},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: point at infinity during verify
    // tcID: 373
    {SEC_OID_SHA512,
     373,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xfd, 0x28, 0xc3, 0x43, 0xc1, 0xdf, 0x97, 0xcb, 0x35, 0xbf,
      0xe6, 0x00, 0xa4, 0x7b, 0x84, 0xd2, 0xe8, 0x1d, 0xda, 0xe4, 0xdc, 0x44,
      0xce, 0x23, 0xd7, 0x5d, 0xb7, 0xdb, 0x8f, 0x48, 0x9c, 0x32, 0x04, 0x02,
      0x42, 0x00, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa8, 0xc5,
      0xd7, 0x82, 0x81, 0x3f, 0xba, 0x87, 0x79, 0x2a, 0x99, 0x55, 0xc2, 0xfd,
      0x03, 0x37, 0x45, 0x69, 0x3c, 0x98, 0x92, 0xd8, 0x89, 0x6d, 0x3a, 0x3e,
      0x7a, 0x92, 0x5f, 0x85, 0xbd, 0x76, 0xad},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x2a, 0x07, 0xf1, 0x3f, 0x3e, 0x8d, 0xf3, 0x82, 0x14,
      0x5b, 0x79, 0x42, 0xfe, 0x6f, 0x91, 0xc1, 0x2f, 0xf3, 0x06, 0x4b, 0x31,
      0x4b, 0x4e, 0x34, 0x76, 0xbf, 0x3a, 0xfb, 0xb9, 0x82, 0x07, 0x0f, 0x17,
      0xf6, 0x3b, 0x2d, 0xe5, 0xfb, 0xe8, 0xc9, 0x1a, 0x87, 0xae, 0x63, 0x28,
      0x69, 0xfa, 0xcf, 0x17, 0xd5, 0xce, 0x9d, 0x13, 0x9b, 0x37, 0xed, 0x55,
      0x75, 0x81, 0xbb, 0x9a, 0x7e, 0x4b, 0x8f, 0xa3, 0x00, 0x24, 0xb9, 0x04,
      0xc5, 0xfc, 0x53, 0x6a, 0xe5, 0x3b, 0x32, 0x3a, 0x7f, 0xd0, 0xb7, 0xb8,
      0xe4, 0x20, 0x30, 0x24, 0x06, 0xad, 0xe8, 0x4e, 0xa8, 0xa1, 0x0c, 0xa7,
      0xc5, 0xc9, 0x34, 0xba, 0xd5, 0x48, 0x9d, 0xb6, 0xe3, 0xa8, 0xcc, 0x30,
      0x64, 0x60, 0x2c, 0xc8, 0x3f, 0x30, 0x9e, 0x9d, 0x24, 0x7a, 0xae, 0x72,
      0xaf, 0xca, 0x08, 0x33, 0x6b, 0xc8, 0x91, 0x9e, 0x15, 0xf4, 0xbe, 0x5a,
      0xd7, 0x7a},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: edge case for signature malleability
    // tcID: 374
    {SEC_OID_SHA512,
     374,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xfd, 0x28, 0xc3, 0x43, 0xc1, 0xdf, 0x97, 0xcb, 0x35, 0xbf,
      0xe6, 0x00, 0xa4, 0x7b, 0x84, 0xd2, 0xe8, 0x1d, 0xda, 0xe4, 0xdc, 0x44,
      0xce, 0x23, 0xd7, 0x5d, 0xb7, 0xdb, 0x8f, 0x48, 0x9c, 0x32, 0x06, 0x02,
      0x42, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x28,
      0xc3, 0x43, 0xc1, 0xdf, 0x97, 0xcb, 0x35, 0xbf, 0xe6, 0x00, 0xa4, 0x7b,
      0x84, 0xd2, 0xe8, 0x1d, 0xda, 0xe4, 0xdc, 0x44, 0xce, 0x23, 0xd7, 0x5d,
      0xb7, 0xdb, 0x8f, 0x48, 0x9c, 0x32, 0x04},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x4b, 0xb9, 0x04, 0x07, 0x3c, 0xb6, 0xda, 0x9e, 0x50,
      0x28, 0xdf, 0x54, 0xfc, 0x22, 0xcf, 0x5a, 0x9d, 0x5c, 0xa7, 0x3a, 0x01,
      0xfe, 0xed, 0xd2, 0xb4, 0xce, 0x43, 0xb8, 0x7b, 0xfd, 0x43, 0x00, 0xa7,
      0x2b, 0xdf, 0x26, 0xb1, 0x46, 0xb2, 0xe7, 0xb5, 0x06, 0xc0, 0x3c, 0x7a,
      0x0a, 0xd4, 0xa7, 0xe3, 0xe6, 0x72, 0x04, 0xdd, 0xdc, 0xa9, 0xb6, 0x5d,
      0x43, 0x56, 0x0f, 0xfa, 0xf9, 0xbf, 0xd5, 0x40, 0x01, 0x2b, 0x88, 0x95,
      0x63, 0x2e, 0x04, 0x06, 0xb7, 0x84, 0x63, 0xfe, 0x1b, 0xc5, 0x36, 0x0a,
      0x3c, 0xf7, 0x96, 0xfd, 0xdd, 0xa9, 0xdb, 0x2b, 0x18, 0xca, 0x91, 0x71,
      0x55, 0x8e, 0x61, 0x58, 0xfa, 0x4b, 0x0b, 0x1d, 0x04, 0x61, 0xd9, 0xa4,
      0x6b, 0x9b, 0x95, 0x8d, 0x62, 0x9b, 0xd6, 0x2a, 0x29, 0xee, 0x39, 0x42,
      0x23, 0x8e, 0x0f, 0xa8, 0x3e, 0x93, 0x2a, 0x66, 0xab, 0xb1, 0xb5, 0x0c,
      0x5f, 0x37},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for signature malleability
    // tcID: 375
    {SEC_OID_SHA512,
     375,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xfd, 0x28, 0xc3, 0x43, 0xc1, 0xdf, 0x97, 0xcb, 0x35, 0xbf,
      0xe6, 0x00, 0xa4, 0x7b, 0x84, 0xd2, 0xe8, 0x1d, 0xda, 0xe4, 0xdc, 0x44,
      0xce, 0x23, 0xd7, 0x5d, 0xb7, 0xdb, 0x8f, 0x48, 0x9c, 0x32, 0x06, 0x02,
      0x42, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x28,
      0xc3, 0x43, 0xc1, 0xdf, 0x97, 0xcb, 0x35, 0xbf, 0xe6, 0x00, 0xa4, 0x7b,
      0x84, 0xd2, 0xe8, 0x1d, 0xda, 0xe4, 0xdc, 0x44, 0xce, 0x23, 0xd7, 0x5d,
      0xb7, 0xdb, 0x8f, 0x48, 0x9c, 0x32, 0x05},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0x64, 0x54, 0xaf, 0xca, 0x38, 0x5e, 0xb5, 0x3e, 0xae,
      0xaa, 0xb7, 0x11, 0x53, 0x7d, 0x95, 0xc5, 0x0e, 0x01, 0x26, 0x8b, 0x10,
      0x0a, 0x22, 0x65, 0x6a, 0xdf, 0x5c, 0xed, 0xf6, 0x8b, 0x4a, 0x78, 0xa6,
      0xc1, 0x4a, 0x70, 0x24, 0x5d, 0xf7, 0x07, 0xf6, 0x56, 0x5c, 0xe1, 0x59,
      0x48, 0xc2, 0xe3, 0x8e, 0x3d, 0x90, 0xe0, 0x5d, 0xda, 0x31, 0x88, 0xab,
      0x43, 0xa7, 0x3f, 0x30, 0xdb, 0xc6, 0xbd, 0xa8, 0x01, 0x51, 0xdc, 0xa6,
      0xdc, 0x5a, 0xec, 0x84, 0xfa, 0x35, 0xc7, 0x9f, 0x21, 0x36, 0x59, 0x93,
      0xf0, 0xb2, 0x67, 0xca, 0x48, 0x6e, 0xa6, 0x6c, 0x21, 0x86, 0xa5, 0x2a,
      0x3f, 0xb6, 0x2b, 0x53, 0x50, 0x1c, 0xe2, 0x82, 0x2d, 0x46, 0x91, 0xfb,
      0xc2, 0x5c, 0xf2, 0x7a, 0xdb, 0x70, 0x73, 0x40, 0x71, 0xbe, 0x52, 0x3b,
      0x92, 0x31, 0xdd, 0x8d, 0x33, 0xa4, 0x01, 0xde, 0xa0, 0x0c, 0xf0, 0xae,
      0x30, 0xa1},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: u1 == 1
    // tcID: 376
    {SEC_OID_SHA512,
     376,
     {0x30, 0x81, 0x86, 0x02, 0x42, 0x00, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xa8, 0xc5, 0xd7, 0x82, 0x81, 0x3f, 0xba, 0x87, 0x79, 0x2a,
      0x99, 0x55, 0xc2, 0xfd, 0x03, 0x37, 0x45, 0x69, 0x3c, 0x98, 0x92, 0xd8,
      0x89, 0x6d, 0x3a, 0x3e, 0x7a, 0x92, 0x5f, 0x85, 0xbd, 0x76, 0xad, 0x02,
      0x40, 0x43, 0xf8, 0x00, 0xfb, 0xea, 0xf9, 0x23, 0x8c, 0x58, 0xaf, 0x79,
      0x5b, 0xcd, 0xad, 0x04, 0xbc, 0x49, 0xcd, 0x85, 0x0c, 0x39, 0x4d, 0x33,
      0x82, 0x95, 0x33, 0x56, 0xb0, 0x23, 0x21, 0x02, 0x81, 0x75, 0x7b, 0x30,
      0xe1, 0x92, 0x18, 0xa3, 0x7c, 0xbd, 0x61, 0x20, 0x86, 0xfb, 0xc1, 0x58,
      0xca, 0xa8, 0xb4, 0xe1, 0xac, 0xb2, 0xec, 0x00, 0x83, 0x7e, 0x5d, 0x94,
      0x1f, 0x34, 0x2f, 0xb3, 0xcc},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x60, 0xda, 0xf5, 0x96, 0x38, 0x15, 0x8e, 0xd9, 0xd3,
      0xd7, 0xe8, 0x42, 0x85, 0x01, 0x33, 0x47, 0x64, 0x16, 0x2f, 0x9b, 0xe2,
      0x39, 0xe1, 0x68, 0xfa, 0xe9, 0xaf, 0x34, 0x8c, 0x30, 0xa7, 0xbe, 0x1c,
      0xfa, 0x4d, 0x96, 0x36, 0xc3, 0xbb, 0x62, 0x1d, 0x7e, 0x0a, 0xa7, 0x14,
      0x46, 0xf8, 0xd4, 0xa3, 0x7f, 0x2d, 0x43, 0x27, 0x4a, 0x42, 0x55, 0xb2,
      0x26, 0xf6, 0x12, 0x38, 0x2f, 0x63, 0x15, 0x2e, 0x01, 0x6e, 0x48, 0x30,
      0x01, 0x24, 0xa6, 0x36, 0xb2, 0x06, 0xfa, 0xd4, 0xd0, 0x35, 0x58, 0x62,
      0xa8, 0x52, 0x62, 0x37, 0x99, 0xaf, 0xee, 0x94, 0x1e, 0x86, 0x4d, 0x96,
      0xdc, 0xbf, 0x55, 0xb8, 0x01, 0xca, 0xbd, 0x62, 0x49, 0xb6, 0xf5, 0x67,
      0x50, 0x6d, 0x5a, 0x50, 0x3e, 0x7d, 0x03, 0xb4, 0x76, 0x4c, 0x70, 0xfc,
      0x44, 0xc5, 0x36, 0x5f, 0x32, 0xc3, 0x60, 0x36, 0x78, 0x47, 0x6d, 0x62,
      0xb0, 0x9d},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: u1 == n - 1
    // tcID: 377
    {SEC_OID_SHA512,
     377,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xa8, 0xc5, 0xd7, 0x82, 0x81, 0x3f, 0xba, 0x87, 0x79, 0x2a,
      0x99, 0x55, 0xc2, 0xfd, 0x03, 0x37, 0x45, 0x69, 0x3c, 0x98, 0x92, 0xd8,
      0x89, 0x6d, 0x3a, 0x3e, 0x7a, 0x92, 0x5f, 0x85, 0xbd, 0x76, 0xad, 0x02,
      0x42, 0x01, 0xff, 0xbc, 0x07, 0xff, 0x04, 0x15, 0x06, 0xdc, 0x73, 0xa7,
      0x50, 0x86, 0xa4, 0x32, 0x52, 0xfb, 0x43, 0xb6, 0x32, 0x7a, 0xf3, 0xc6,
      0xb2, 0xcc, 0x7d, 0x6a, 0xcc, 0xa9, 0x4f, 0xdc, 0xde, 0xfd, 0x78, 0xdc,
      0x0b, 0x56, 0xa2, 0x2d, 0x16, 0xf2, 0xee, 0xc2, 0x6a, 0xe0, 0xc1, 0xfb,
      0x48, 0x4d, 0x05, 0x93, 0x00, 0xe8, 0x0b, 0xd6, 0xb0, 0x47, 0x2b, 0x3d,
      0x12, 0x22, 0xff, 0x5d, 0x08, 0xb0, 0x3d},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x51, 0xfe, 0x6a, 0x35, 0xa8, 0x50, 0x70, 0xc7, 0xc2,
      0x95, 0x02, 0xa8, 0x76, 0x72, 0xa3, 0x81, 0x53, 0xd7, 0x99, 0xae, 0xf7,
      0x34, 0x22, 0x6b, 0x64, 0xd8, 0xfd, 0x33, 0x98, 0x62, 0x17, 0x01, 0x11,
      0x7f, 0x0a, 0xf9, 0xd9, 0xaf, 0xaf, 0x6d, 0xbb, 0x8c, 0xa3, 0x00, 0x72,
      0x55, 0xdc, 0x79, 0xb0, 0xf4, 0x1e, 0xd5, 0x52, 0x51, 0x2c, 0xb2, 0x92,
      0x07, 0xb1, 0x5a, 0x01, 0xcd, 0xfd, 0xfa, 0xae, 0x01, 0xa1, 0x6c, 0x61,
      0x27, 0x75, 0x86, 0x35, 0x6e, 0xfa, 0xdc, 0xb2, 0x47, 0x64, 0xf2, 0x1f,
      0x57, 0x4e, 0xf9, 0x6f, 0x2c, 0xaa, 0xbc, 0x3f, 0x47, 0xfa, 0x66, 0xfb,
      0x87, 0x19, 0xd7, 0x78, 0x58, 0x24, 0x06, 0x1c, 0x2d, 0x6d, 0x7a, 0x4b,
      0xcb, 0x85, 0x15, 0x40, 0xe6, 0x2b, 0x2f, 0x00, 0x96, 0x0b, 0x28, 0x3e,
      0xac, 0x78, 0x08, 0xd1, 0x81, 0x3e, 0xf5, 0x1b, 0x46, 0xe1, 0x14, 0x9d,
      0x3e, 0x4d},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: u2 == 1
    // tcID: 378
    {SEC_OID_SHA512,
     378,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xa8, 0xc5, 0xd7, 0x82, 0x81, 0x3f, 0xba, 0x87, 0x79, 0x2a,
      0x99, 0x55, 0xc2, 0xfd, 0x03, 0x37, 0x45, 0x69, 0x3c, 0x98, 0x92, 0xd8,
      0x89, 0x6d, 0x3a, 0x3e, 0x7a, 0x92, 0x5f, 0x85, 0xbd, 0x76, 0xad, 0x02,
      0x42, 0x00, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa8, 0xc5,
      0xd7, 0x82, 0x81, 0x3f, 0xba, 0x87, 0x79, 0x2a, 0x99, 0x55, 0xc2, 0xfd,
      0x03, 0x37, 0x45, 0x69, 0x3c, 0x98, 0x92, 0xd8, 0x89, 0x6d, 0x3a, 0x3e,
      0x7a, 0x92, 0x5f, 0x85, 0xbd, 0x76, 0xad},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0xb4, 0xff, 0xc0, 0xff, 0xf0, 0x87, 0x60, 0x7a, 0xd2,
      0x6c, 0x4b, 0x23, 0xd6, 0xd3, 0x1a, 0xe5, 0xf9, 0x04, 0xcc, 0x06, 0x4e,
      0x35, 0x0f, 0x47, 0x13, 0x1c, 0xe2, 0x78, 0x4f, 0xbb, 0x35, 0x98, 0x67,
      0x98, 0x8a, 0x55, 0x9d, 0x43, 0x86, 0x75, 0x2e, 0x56, 0x27, 0x7b, 0xef,
      0x34, 0xe2, 0x65, 0x44, 0xde, 0xdd, 0xa8, 0x8c, 0xc2, 0x0a, 0x34, 0x11,
      0xfa, 0x98, 0x83, 0x4e, 0xea, 0xe8, 0x69, 0xad, 0x00, 0x9d, 0x6e, 0x8c,
      0xa9, 0x99, 0x49, 0xb7, 0xb3, 0x4f, 0xd0, 0x6a, 0x78, 0x97, 0x44, 0xec,
      0xac, 0x33, 0x56, 0x24, 0x73, 0x17, 0xc4, 0xd7, 0xaa, 0x92, 0x96, 0x67,
      0x6d, 0xd6, 0x23, 0x59, 0x4f, 0x36, 0x84, 0xbc, 0x13, 0x06, 0x4c, 0xab,
      0x8d, 0x2d, 0xb7, 0xed, 0xbc, 0xa9, 0x1f, 0x1c, 0x8b, 0xeb, 0x54, 0x2b,
      0xc9, 0x79, 0x78, 0xa3, 0xf3, 0x1f, 0x36, 0x10, 0xa0, 0x3f, 0x46, 0xa9,
      0x82, 0xd2},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: u2 == n - 1
    // tcID: 379
    {SEC_OID_SHA512,
     379,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xa8, 0xc5, 0xd7, 0x82, 0x81, 0x3f, 0xba, 0x87, 0x79, 0x2a,
      0x99, 0x55, 0xc2, 0xfd, 0x03, 0x37, 0x45, 0x69, 0x3c, 0x98, 0x92, 0xd8,
      0x89, 0x6d, 0x3a, 0x3e, 0x7a, 0x92, 0x5f, 0x85, 0xbd, 0x76, 0xad, 0x02,
      0x42, 0x01, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x51, 0x8b,
      0xaf, 0x05, 0x02, 0x7f, 0x75, 0x0e, 0xf2, 0x55, 0x32, 0xab, 0x85, 0xfa,
      0x06, 0x6e, 0x8a, 0xd2, 0x79, 0x31, 0x25, 0xb1, 0x12, 0xda, 0x74, 0x7c,
      0xf5, 0x24, 0xbf, 0x0b, 0x7a, 0xed, 0x5c},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x80, 0x9f, 0xba, 0x32, 0x0f, 0xe9, 0x6d, 0xed, 0x24,
      0x61, 0x1b, 0x72, 0xa2, 0xa5, 0x42, 0x8f, 0xe4, 0x60, 0x49, 0xff, 0x08,
      0x0d, 0x6e, 0x08, 0x13, 0xab, 0x7a, 0x35, 0x89, 0x70, 0x18, 0xfe, 0x64,
      0x18, 0x61, 0x3a, 0xbd, 0x86, 0x0d, 0x1e, 0xb4, 0x84, 0x95, 0x90, 0x59,
      0xa0, 0x1a, 0xf7, 0xd6, 0x8c, 0xba, 0x69, 0xd1, 0xc5, 0x2e, 0xa6, 0x4a,
      0xd0, 0xf2, 0x8a, 0x18, 0xa4, 0x1f, 0xc7, 0x8a, 0x01, 0x10, 0x8a, 0xcc,
      0x55, 0x77, 0xe9, 0xe8, 0x96, 0x2e, 0x2a, 0x7c, 0xea, 0x0b, 0xb3, 0x7d,
      0xf1, 0xd0, 0xca, 0x40, 0x50, 0xfb, 0x6c, 0xfe, 0xba, 0x41, 0xa7, 0xf8,
      0x68, 0xd9, 0x88, 0xdb, 0xbc, 0xeb, 0xc9, 0x62, 0x98, 0x67, 0x48, 0xfa,
      0x48, 0x51, 0x83, 0xf6, 0xb6, 0x0f, 0x45, 0x3e, 0xc8, 0x60, 0x6f, 0x8c,
      0x33, 0xd4, 0x37, 0x67, 0xdd, 0xdb, 0xbe, 0xf8, 0xc4, 0x12, 0xb2, 0xc3,
      0x79, 0x39},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 380
    {SEC_OID_SHA512,
     380,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x02,
      0x42, 0x01, 0x55, 0x6b, 0xfd, 0x55, 0xa9, 0x4e, 0x53, 0x0b, 0xd9, 0x72,
      0xe5, 0x28, 0x73, 0xef, 0x39, 0xac, 0x3e, 0xc3, 0x44, 0x81, 0xae, 0xbd,
      0xc4, 0x66, 0x80, 0xdc, 0x66, 0x72, 0x3a, 0xb6, 0x60, 0x56, 0x27, 0x5d,
      0x82, 0xbf, 0xf8, 0x5a, 0xd2, 0x9a, 0xc6, 0x94, 0x53, 0x0b, 0xb2, 0xf8,
      0x9c, 0x36, 0xce, 0x60, 0x0a, 0xd1, 0xb4, 0x97, 0x61, 0x85, 0x4a, 0xfc,
      0x69, 0xab, 0x74, 0x1c, 0xe0, 0x29, 0x4a},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0x45, 0x13, 0x0d, 0xca, 0x77, 0xd9, 0x67, 0x4d, 0xfc,
      0xef, 0xfa, 0x85, 0x1b, 0x4a, 0x26, 0x72, 0xe4, 0x90, 0xe8, 0xfb, 0xa8,
      0x27, 0x76, 0x22, 0xb0, 0x02, 0x0e, 0x2f, 0xe9, 0x10, 0x1e, 0x76, 0x93,
      0x3b, 0x0c, 0x01, 0xd2, 0x48, 0x07, 0x1f, 0x85, 0x4e, 0x9b, 0xc5, 0x23,
      0x73, 0x39, 0x36, 0xdc, 0x0b, 0x99, 0x30, 0xcb, 0xe1, 0x54, 0xb9, 0xa4,
      0x02, 0xf6, 0x81, 0xee, 0x3c, 0x6c, 0xef, 0x6b, 0x00, 0x0d, 0x0c, 0x94,
      0xb2, 0xad, 0x28, 0x55, 0x66, 0x43, 0xaa, 0x3d, 0x27, 0x52, 0x30, 0x48,
      0xd2, 0x27, 0xa1, 0xde, 0x82, 0xf8, 0xa6, 0x64, 0x70, 0x7e, 0x75, 0x39,
      0x4d, 0x21, 0xda, 0x18, 0x1b, 0xec, 0x82, 0xe1, 0xaf, 0xb0, 0xe6, 0x27,
      0x53, 0x95, 0x31, 0xaf, 0xfa, 0x84, 0x9a, 0x24, 0x09, 0xbc, 0xac, 0x83,
      0xfb, 0x78, 0x6c, 0x35, 0x1c, 0x88, 0xba, 0xc2, 0xfb, 0x2e, 0x43, 0x22,
      0xe5, 0x4a},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 381
    {SEC_OID_SHA512,
     381,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x02,
      0x42, 0x00, 0xdc, 0xf9, 0xe7, 0xf4, 0x41, 0x44, 0x8a, 0x12, 0x5b, 0x96,
      0xd7, 0x2b, 0x98, 0x9d, 0x9f, 0x4d, 0xac, 0x75, 0x08, 0xc7, 0xe0, 0x36,
      0xf6, 0x08, 0x0d, 0x47, 0x58, 0xe7, 0x36, 0xf5, 0xe0, 0x63, 0x6b, 0x0f,
      0xf5, 0x03, 0xf1, 0x28, 0xa9, 0x8d, 0x08, 0xe0, 0xae, 0x18, 0x99, 0x21,
      0x06, 0x52, 0x19, 0xd2, 0xcc, 0x3a, 0xa8, 0x3e, 0x3c, 0x66, 0x0c, 0xa0,
      0xcb, 0x85, 0xe7, 0xc1, 0x1a, 0x24, 0xd0},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0xed, 0x3e, 0x09, 0x80, 0x9f, 0xe5, 0x98, 0x58, 0x18,
      0xf9, 0x05, 0x92, 0xfd, 0x06, 0xe7, 0x1d, 0x2c, 0x49, 0x3d, 0x9a, 0x78,
      0x17, 0x14, 0xc9, 0x15, 0x7c, 0xba, 0xfa, 0x5b, 0xa1, 0x96, 0xb9, 0x87,
      0xfd, 0x49, 0xae, 0x24, 0x27, 0x4c, 0x76, 0x25, 0x1c, 0x70, 0xb9, 0xf7,
      0x97, 0x0f, 0x1f, 0x71, 0x3a, 0xd2, 0x74, 0x59, 0x0a, 0x70, 0x2f, 0x46,
      0x3c, 0x73, 0xa0, 0x70, 0x48, 0x31, 0xce, 0x5d, 0x00, 0xca, 0xc2, 0x78,
      0x29, 0x70, 0x93, 0xbd, 0x9f, 0x9a, 0xc2, 0xd0, 0x0b, 0xef, 0x3d, 0x67,
      0xa0, 0x1b, 0x43, 0xb2, 0x8b, 0x9f, 0x82, 0x94, 0x07, 0x26, 0x4c, 0x73,
      0x81, 0x17, 0x43, 0x83, 0x00, 0xc7, 0x70, 0x47, 0x72, 0x97, 0x69, 0x16,
      0xea, 0x10, 0x2a, 0x77, 0x62, 0x62, 0xcc, 0xf4, 0x22, 0x2c, 0xc3, 0x48,
      0xc3, 0x4a, 0xac, 0x68, 0x3d, 0x8f, 0x00, 0x17, 0x9a, 0x34, 0x83, 0x23,
      0xba, 0xbd},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 382
    {SEC_OID_SHA512,
     382,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x02,
      0x41, 0x66, 0xeb, 0x57, 0x73, 0x3c, 0x19, 0xa7, 0x00, 0x3c, 0xf8, 0x25,
      0x32, 0x79, 0xfc, 0xe4, 0x19, 0x07, 0xbc, 0x4f, 0x12, 0x71, 0x53, 0xc4,
      0x57, 0x6d, 0xd4, 0x81, 0x4f, 0x8b, 0x33, 0x5a, 0x0b, 0x51, 0x56, 0x0b,
      0x44, 0x47, 0xf0, 0x38, 0x2c, 0x69, 0xb3, 0xfe, 0x50, 0x95, 0x22, 0xc8,
      0x91, 0xf0, 0xee, 0xc3, 0x99, 0x9a, 0xd2, 0x52, 0x68, 0x35, 0xf3, 0x3a,
      0xe2, 0x2a, 0x64, 0x28, 0x43, 0xaf},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x0a, 0xc2, 0xc5, 0xa4, 0xc7, 0x93, 0x09, 0xa5, 0x13,
      0x2d, 0x5d, 0x74, 0x94, 0xbe, 0xfb, 0x39, 0x05, 0xd3, 0x3f, 0xda, 0x5f,
      0x80, 0xee, 0xaf, 0x63, 0x77, 0x51, 0x83, 0xaa, 0xe7, 0xaf, 0x10, 0x8a,
      0x3d, 0x97, 0xf3, 0xa4, 0x41, 0x53, 0x2c, 0xf6, 0xfa, 0xc4, 0x7f, 0x6c,
      0x89, 0x83, 0x29, 0xd6, 0x91, 0x82, 0xe1, 0xfa, 0x07, 0xce, 0x45, 0x99,
      0x7e, 0xbe, 0xc3, 0x78, 0x1c, 0x9a, 0xd7, 0x41, 0x01, 0x73, 0xa5, 0xb6,
      0xb8, 0x0a, 0x8b, 0x73, 0xd3, 0x0a, 0xc9, 0x7e, 0x1a, 0x4a, 0xac, 0xb7,
      0x73, 0xc1, 0xad, 0x69, 0x2c, 0x5e, 0xa6, 0x3f, 0x68, 0xe3, 0x73, 0x84,
      0x27, 0x82, 0xbd, 0x67, 0x78, 0x64, 0xff, 0x65, 0x6c, 0xf8, 0xd1, 0xe6,
      0xec, 0x1e, 0x58, 0xe9, 0xa8, 0x38, 0x56, 0xef, 0x92, 0x67, 0x75, 0x55,
      0x91, 0x67, 0x49, 0xfb, 0x95, 0xe8, 0x00, 0xae, 0x2e, 0x01, 0x16, 0x18,
      0xca, 0x3a},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 383
    {SEC_OID_SHA512,
     383,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x02,
      0x42, 0x01, 0x71, 0x06, 0xd1, 0x13, 0x1b, 0x33, 0x00, 0xd7, 0xff, 0xbc,
      0x07, 0xff, 0x04, 0x15, 0x06, 0xdc, 0x73, 0xa7, 0x50, 0x86, 0xa4, 0x32,
      0x52, 0xfb, 0x43, 0xb6, 0x32, 0x7a, 0xf3, 0xc6, 0xb2, 0xcc, 0x79, 0x52,
      0x7a, 0xc0, 0x9f, 0x0a, 0x3f, 0x0a, 0x8a, 0xa3, 0x82, 0x85, 0x58, 0x5b,
      0x6a, 0xfc, 0xea, 0xc5, 0xff, 0x66, 0x92, 0x84, 0x22, 0x32, 0xd1, 0x06,
      0xd1, 0x5d, 0x4d, 0xf1, 0xb6, 0x6a, 0xa8},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0xeb, 0x2a, 0x35, 0x3d, 0xec, 0x6b, 0x46, 0x0f, 0xbd,
      0xa4, 0x9c, 0x67, 0xf4, 0x31, 0x19, 0x0f, 0xff, 0x6f, 0x19, 0x56, 0x39,
      0xc2, 0x26, 0xef, 0x8f, 0xef, 0xcb, 0xf1, 0x91, 0xd7, 0x25, 0x29, 0xa1,
      0x2c, 0xc5, 0x48, 0x5b, 0x28, 0x2a, 0x52, 0x70, 0x4c, 0x1f, 0xd8, 0x45,
      0x29, 0xa1, 0xaa, 0x0a, 0xd7, 0x94, 0xf9, 0x64, 0x93, 0xe2, 0x99, 0x71,
      0x8d, 0x26, 0x18, 0xa1, 0xb8, 0x3a, 0x52, 0x6c, 0x01, 0xf7, 0x04, 0x60,
      0x4d, 0x5b, 0x2b, 0x94, 0xa4, 0x2b, 0xfc, 0x3a, 0xb9, 0x33, 0x17, 0xd6,
      0x6a, 0x54, 0xde, 0x15, 0x25, 0x83, 0x37, 0x43, 0x3f, 0xc9, 0x6a, 0x96,
      0x5d, 0x8e, 0x2d, 0x05, 0x6f, 0xd1, 0x13, 0x4b, 0x79, 0x89, 0xd7, 0xb3,
      0xf7, 0x09, 0xad, 0xc2, 0x82, 0x27, 0xbd, 0xab, 0xc1, 0x1f, 0xe2, 0xf3,
      0x59, 0xc6, 0xa6, 0xe5, 0x11, 0x1a, 0xb4, 0x33, 0x79, 0xca, 0x25, 0xb6,
      0x6f, 0x2f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 384
    {SEC_OID_SHA512,
     384,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x02,
      0x41, 0x6d, 0x11, 0x31, 0xb3, 0x30, 0x0d, 0x7f, 0xfb, 0xc0, 0x7f, 0xf0,
      0x41, 0x50, 0x6d, 0xc7, 0x3a, 0x75, 0x08, 0x6a, 0x43, 0x25, 0x2f, 0xb4,
      0x3b, 0x63, 0x27, 0xaf, 0x3c, 0x6b, 0x2c, 0xc7, 0xd6, 0xab, 0x94, 0xbf,
      0x49, 0x6f, 0x53, 0xea, 0x22, 0x9e, 0x7f, 0xe6, 0xb4, 0x56, 0x08, 0x8e,
      0xa3, 0x2f, 0x6e, 0x2b, 0x10, 0x4f, 0x51, 0x12, 0x79, 0x8b, 0xb5, 0x9d,
      0x46, 0xa0, 0xd4, 0x68, 0xf8, 0x38},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0xe4, 0x3d, 0xfe, 0xcc, 0x7e, 0x6c, 0xaa, 0xd0, 0x3d,
      0x17, 0xb4, 0x07, 0x32, 0x2c, 0x87, 0x8f, 0x70, 0x1c, 0x5a, 0xdd, 0x6e,
      0xb2, 0xaf, 0xcd, 0x78, 0x6f, 0xf3, 0x80, 0x36, 0x22, 0xdf, 0xbb, 0x6b,
      0xaa, 0x01, 0x24, 0x6e, 0x1e, 0xa0, 0x59, 0xf7, 0xb7, 0x88, 0x42, 0x91,
      0x9b, 0x25, 0x07, 0xda, 0xa9, 0xe3, 0x43, 0x4e, 0xfa, 0x7e, 0x8d, 0x3a,
      0xe6, 0xc3, 0x54, 0x99, 0xf8, 0x2d, 0x0a, 0xc8, 0x01, 0x8b, 0x0e, 0x4d,
      0x63, 0x78, 0x22, 0x2a, 0x07, 0xcc, 0xdb, 0x42, 0x14, 0x00, 0x1f, 0x97,
      0xb1, 0xa5, 0x03, 0xd1, 0xaa, 0xc3, 0xab, 0x92, 0x5e, 0xa6, 0x4f, 0xaa,
      0x9c, 0x73, 0x9b, 0xa0, 0x4e, 0xe3, 0x48, 0x0b, 0x14, 0x7c, 0xb0, 0x7f,
      0x93, 0xed, 0xf4, 0x0b, 0x68, 0x56, 0xa2, 0x2f, 0x41, 0x59, 0xc3, 0xf5,
      0xcd, 0x6c, 0x9e, 0x71, 0x65, 0x45, 0x29, 0x07, 0xc8, 0xd0, 0x2f, 0xab,
      0x20, 0x1e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 385
    {SEC_OID_SHA512,
     385,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x02,
      0x42, 0x00, 0xda, 0x22, 0x63, 0x66, 0x60, 0x1a, 0xff, 0xf7, 0x80, 0xff,
      0xe0, 0x82, 0xa0, 0xdb, 0x8e, 0x74, 0xea, 0x10, 0xd4, 0x86, 0x4a, 0x5f,
      0x68, 0x76, 0xc6, 0x4f, 0x5e, 0x78, 0xd6, 0x59, 0x8f, 0xad, 0x57, 0x29,
      0x7e, 0x92, 0xde, 0xa7, 0xd4, 0x45, 0x3c, 0xff, 0xcd, 0x68, 0xac, 0x11,
      0x1d, 0x46, 0x5e, 0xdc, 0x56, 0x20, 0x9e, 0xa2, 0x24, 0xf3, 0x17, 0x6b,
      0x3a, 0x8d, 0x41, 0xa8, 0xd1, 0xf0, 0x70},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0x41, 0xa4, 0xd7, 0x14, 0x62, 0x8c, 0x19, 0x2b, 0x8a,
      0xce, 0x1a, 0x42, 0x85, 0x4d, 0xa0, 0x6e, 0x0e, 0x1d, 0xdb, 0x82, 0xa0,
      0x76, 0x18, 0xe4, 0xef, 0xb0, 0x5d, 0x70, 0x95, 0xcd, 0x1e, 0xb6, 0x54,
      0x25, 0x07, 0x81, 0x60, 0x59, 0x47, 0x15, 0xea, 0xf5, 0x9f, 0xcb, 0x41,
      0xc9, 0xe5, 0x73, 0xfe, 0x10, 0x29, 0x8c, 0x75, 0xc9, 0xe9, 0x13, 0x5c,
      0x77, 0x5c, 0xa7, 0x3f, 0x63, 0xd1, 0x3a, 0xac, 0x00, 0x89, 0x52, 0x4b,
      0x47, 0x51, 0x70, 0xd4, 0x39, 0x1c, 0xc0, 0x32, 0xa0, 0x54, 0x3e, 0xa2,
      0x2d, 0xab, 0x60, 0xea, 0x07, 0x53, 0x8f, 0x3a, 0x37, 0x60, 0x7f, 0x0d,
      0x4e, 0xd5, 0x16, 0x63, 0x4f, 0xde, 0x54, 0x5e, 0x2f, 0x0a, 0x6b, 0xa8,
      0xd0, 0xd2, 0xfe, 0x6a, 0xde, 0xd0, 0xa7, 0x71, 0xb4, 0xb1, 0x34, 0xa5,
      0xa2, 0x80, 0xe5, 0x47, 0x99, 0xfa, 0x47, 0x6e, 0xf0, 0xec, 0x87, 0xd4,
      0x4e, 0x1c},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 386
    {SEC_OID_SHA512,
     386,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x02,
      0x42, 0x01, 0x1b, 0x33, 0x00, 0xd7, 0xff, 0xbc, 0x07, 0xff, 0x04, 0x15,
      0x06, 0xdc, 0x73, 0xa7, 0x50, 0x86, 0xa4, 0x32, 0x52, 0xfb, 0x43, 0xb6,
      0x32, 0x7a, 0xf3, 0xc6, 0xb2, 0xcc, 0x7d, 0x6a, 0xcc, 0xa9, 0x4c, 0xb8,
      0x5d, 0xf5, 0xe6, 0xc1, 0x12, 0x53, 0x94, 0xfc, 0xd3, 0x4f, 0x65, 0x21,
      0xff, 0xda, 0xdd, 0xd9, 0x8f, 0x88, 0xa9, 0x9f, 0xed, 0xce, 0xdd, 0x93,
      0x84, 0x28, 0x8b, 0xb7, 0x93, 0xcf, 0x2f},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0x47, 0xfb, 0xcc, 0x65, 0xd4, 0x81, 0x8e, 0x02, 0x9e,
      0x0a, 0x3a, 0xf1, 0x3a, 0x1f, 0x7c, 0x90, 0xf0, 0x60, 0x5a, 0x00, 0xcd,
      0x07, 0x81, 0x20, 0x0e, 0xb6, 0x56, 0xa5, 0x91, 0xd6, 0x69, 0xa7, 0x87,
      0x62, 0x0e, 0x6f, 0xc8, 0xcc, 0x59, 0x4a, 0xa2, 0x8a, 0x0b, 0x0f, 0x29,
      0x39, 0xec, 0x73, 0x47, 0x2c, 0x49, 0x4e, 0x09, 0xce, 0xca, 0xf5, 0xf3,
      0x31, 0xda, 0xfd, 0x32, 0xd5, 0xac, 0x31, 0xc3, 0x00, 0x75, 0x43, 0x2b,
      0xda, 0xee, 0xca, 0xa0, 0xbe, 0xc7, 0xfe, 0xdd, 0xc2, 0x98, 0xc5, 0x65,
      0x72, 0x3f, 0xb6, 0x69, 0xee, 0x76, 0xe3, 0x8a, 0x4c, 0x5f, 0xf1, 0x70,
      0x1f, 0x1b, 0x38, 0xcd, 0xa9, 0xdc, 0x9a, 0xc4, 0x3b, 0xff, 0x18, 0xda,
      0x20, 0x47, 0xe4, 0xdc, 0xd8, 0x0c, 0x05, 0xa7, 0xbb, 0x7e, 0x74, 0x64,
      0x82, 0x9d, 0x60, 0x8b, 0x68, 0x17, 0x6b, 0x04, 0xc8, 0x7f, 0x40, 0x9f,
      0x46, 0xd6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 387
    {SEC_OID_SHA512,
     387,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x02,
      0x42, 0x01, 0x61, 0xbe, 0x37, 0xed, 0x5f, 0x74, 0x8e, 0x06, 0xa8, 0x9d,
      0x72, 0xc4, 0xb7, 0x05, 0x1c, 0xae, 0x80, 0x9d, 0x95, 0x67, 0x84, 0x8b,
      0x1d, 0x8d, 0x7e, 0xd0, 0x19, 0x22, 0x1e, 0xfb, 0x06, 0xae, 0x81, 0xe1,
      0x26, 0x4c, 0xe4, 0x9c, 0x5d, 0x29, 0xee, 0x5f, 0xe2, 0x2c, 0xcf, 0x70,
      0x89, 0x90, 0x02, 0x64, 0x3a, 0xca, 0x7b, 0x99, 0xf5, 0x77, 0x56, 0xf2,
      0x63, 0x9b, 0x6d, 0x45, 0x9a, 0xe4, 0x10},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0xb5, 0xb1, 0xc3, 0x99, 0x85, 0x89, 0xb2, 0x5c, 0x96,
      0xa7, 0x00, 0xbb, 0xd4, 0x50, 0xd0, 0x4d, 0xa1, 0xf2, 0x73, 0xdf, 0x80,
      0x53, 0x76, 0x7a, 0x3b, 0x03, 0xed, 0x1a, 0x76, 0x3e, 0xd0, 0x89, 0xc0,
      0xde, 0x99, 0xbc, 0xf5, 0x4d, 0x49, 0xc1, 0x52, 0x0d, 0x3a, 0x09, 0xb8,
      0x45, 0x29, 0x6f, 0x04, 0x45, 0xb3, 0xbd, 0x5b, 0x87, 0x91, 0x8d, 0x37,
      0x52, 0xcf, 0x65, 0x1e, 0x0f, 0xf3, 0x00, 0x7b, 0x00, 0xe8, 0x96, 0x38,
      0x08, 0x76, 0xb9, 0x41, 0x9c, 0x56, 0x09, 0x69, 0x14, 0xff, 0x6e, 0xec,
      0x01, 0xae, 0xe2, 0x47, 0xee, 0xfe, 0xf0, 0x74, 0x18, 0x95, 0xf1, 0x4e,
      0xe2, 0x80, 0xf3, 0x60, 0xe1, 0x15, 0x08, 0xc3, 0x78, 0x26, 0xaf, 0x82,
      0xcd, 0x91, 0x5b, 0x90, 0x02, 0xf0, 0x46, 0xcb, 0x51, 0x00, 0x8d, 0x9e,
      0xad, 0x21, 0x12, 0x4c, 0x59, 0x1b, 0xd8, 0x26, 0x5d, 0x14, 0x92, 0xb3,
      0x5f, 0xfb},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 388
    {SEC_OID_SHA512,
     388,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x02,
      0x42, 0x01, 0xe9, 0xbb, 0xbd, 0x64, 0x27, 0x0b, 0x96, 0x68, 0xf7, 0x62,
      0x3e, 0xf7, 0xcb, 0xea, 0xd5, 0x48, 0x3e, 0xb0, 0x7b, 0x88, 0x3c, 0xf3,
      0x9f, 0xb6, 0x88, 0x4a, 0xab, 0x67, 0xda, 0xc7, 0x95, 0x8b, 0x0e, 0x03,
      0x14, 0x43, 0x57, 0xb9, 0x43, 0x3e, 0x69, 0xad, 0xc6, 0x96, 0xc8, 0x6c,
      0x63, 0xa2, 0x3d, 0x35, 0x72, 0x4c, 0xbd, 0x74, 0x9b, 0x7c, 0x34, 0xf8,
      0xe3, 0x42, 0x32, 0xd2, 0x1e, 0xa4, 0x20},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0xaa, 0xdb, 0x41, 0xfa, 0xdc, 0x35, 0xcf, 0x6d, 0x11,
      0xa7, 0xc7, 0xd0, 0x1d, 0x04, 0x9b, 0x74, 0xb3, 0x76, 0x77, 0xf0, 0x4e,
      0x1b, 0xd3, 0xdc, 0x08, 0x45, 0x0f, 0xab, 0xae, 0x28, 0xad, 0xcd, 0x2d,
      0x13, 0x5f, 0x96, 0x66, 0x16, 0xd2, 0x83, 0xfb, 0x18, 0xa5, 0xe6, 0x9e,
      0xab, 0xfe, 0x7e, 0xc4, 0x1e, 0x1a, 0x0e, 0xdb, 0x36, 0x82, 0xf1, 0xd3,
      0x9f, 0x2a, 0xf6, 0x4a, 0x94, 0xd6, 0x02, 0xb9, 0x01, 0x4a, 0xe8, 0x1e,
      0xbf, 0x5e, 0x3d, 0x2d, 0x05, 0x29, 0x47, 0x9d, 0x4a, 0xe8, 0xeb, 0x05,
      0xf4, 0xb4, 0x2e, 0x51, 0x96, 0x08, 0x46, 0x6a, 0xd6, 0x9e, 0x76, 0x62,
      0xd6, 0xe9, 0xb2, 0x36, 0x76, 0x5f, 0x9b, 0xe5, 0x35, 0xc0, 0x58, 0xf0,
      0x0f, 0x08, 0x66, 0xbb, 0xb4, 0xb1, 0x72, 0xef, 0x47, 0xa0, 0x3c, 0xb9,
      0x7c, 0x58, 0xdd, 0xe5, 0x75, 0x03, 0x44, 0xbb, 0x29, 0x30, 0x35, 0xf8,
      0xe9, 0x7e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 389
    {SEC_OID_SHA512,
     389,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x02,
      0x42, 0x00, 0x92, 0x44, 0x49, 0xb6, 0xc9, 0x6f, 0x37, 0x58, 0xe3, 0xb0,
      0x85, 0xc0, 0x79, 0x71, 0x4f, 0x11, 0xf2, 0x8d, 0x03, 0x9b, 0x11, 0x69,
      0x9f, 0x0e, 0x9b, 0x3e, 0x7c, 0x55, 0x3c, 0x8f, 0xc6, 0xc8, 0xf5, 0x21,
      0x2f, 0xec, 0x5e, 0xac, 0x30, 0x68, 0x71, 0x3b, 0x8e, 0xc7, 0x2f, 0xc6,
      0xe2, 0xa9, 0x08, 0x72, 0xb9, 0x4e, 0x16, 0x1a, 0x89, 0x82, 0x28, 0x87,
      0xf4, 0xa9, 0xbd, 0x5c, 0x9e, 0xfd, 0x74},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0xb7, 0x06, 0xfc, 0x3f, 0x4a, 0xae, 0x5b, 0x86, 0xda,
      0x26, 0x1a, 0x66, 0xfb, 0xce, 0x47, 0xeb, 0x3b, 0x3e, 0x1e, 0x91, 0x54,
      0x4a, 0x40, 0xa9, 0x98, 0x9f, 0xcc, 0xf7, 0x41, 0x54, 0xbb, 0xec, 0xac,
      0x04, 0x2d, 0xbb, 0xbf, 0x41, 0x1a, 0x39, 0x09, 0x00, 0x58, 0xb6, 0x2c,
      0x46, 0xfc, 0xcd, 0x1d, 0x5e, 0xab, 0xa0, 0xc4, 0x87, 0x9a, 0x68, 0x8e,
      0xa5, 0xfd, 0x0a, 0x7b, 0x4f, 0x9a, 0x0b, 0x4f, 0x01, 0xed, 0xa0, 0x19,
      0x30, 0xc6, 0xb2, 0x27, 0x45, 0xa9, 0x7f, 0x2d, 0x59, 0xe1, 0x82, 0x59,
      0x8d, 0xfd, 0xfb, 0xfd, 0xb4, 0x63, 0x33, 0x52, 0x93, 0x90, 0x1d, 0xe7,
      0xfc, 0x9d, 0x49, 0xcf, 0x55, 0xed, 0x7f, 0xcf, 0x5d, 0x76, 0x7d, 0x4c,
      0x22, 0xf8, 0x9f, 0x17, 0x1b, 0x41, 0x37, 0xc8, 0x41, 0x5c, 0x3e, 0xd4,
      0x38, 0x08, 0x92, 0x70, 0xc4, 0x1f, 0x88, 0xea, 0xde, 0xf3, 0x01, 0x81,
      0x40, 0xe1},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 390
    {SEC_OID_SHA512,
     390,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x02,
      0x42, 0x01, 0x55, 0x4a, 0x01, 0x55, 0x2b, 0x58, 0xd6, 0x7a, 0x13, 0x46,
      0x8d, 0x6b, 0xc6, 0x08, 0x63, 0x29, 0xe0, 0x9e, 0x5d, 0xbf, 0x28, 0xa1,
      0x1d, 0xcc, 0xbf, 0x91, 0xcc, 0xc6, 0xe2, 0xa4, 0xcf, 0xd4, 0xe6, 0xa2,
      0xc5, 0x27, 0x87, 0x91, 0xc6, 0x49, 0x08, 0x35, 0xa2, 0x7b, 0x6f, 0x7a,
      0xbb, 0x8a, 0x69, 0x0b, 0xb0, 0x60, 0xde, 0x3d, 0xeb, 0x85, 0x09, 0x3d,
      0x3a, 0xe1, 0x64, 0x82, 0xc8, 0x4f, 0x64},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x58, 0xa1, 0xfa, 0x96, 0x11, 0x1b, 0xf3, 0x0b, 0xe7,
      0x6c, 0x3b, 0x8b, 0xa4, 0x43, 0x56, 0x66, 0x67, 0x7b, 0x6d, 0xd0, 0x50,
      0x31, 0xb5, 0xc4, 0xa8, 0x40, 0xe1, 0xea, 0x81, 0xf6, 0x02, 0x5f, 0x70,
      0xe1, 0xd3, 0x95, 0xef, 0x63, 0xcb, 0x59, 0xfa, 0x71, 0xe3, 0x67, 0x4c,
      0xb6, 0x78, 0xf7, 0x25, 0x08, 0x87, 0xf5, 0xd7, 0x34, 0xe3, 0xec, 0x37,
      0x7d, 0xbe, 0x3a, 0xe6, 0x37, 0xd2, 0x4f, 0x82, 0x00, 0x7a, 0x4e, 0xaf,
      0x02, 0xcc, 0x57, 0xe6, 0x58, 0xb5, 0xb9, 0xfa, 0x08, 0xee, 0x30, 0xe0,
      0xef, 0x5b, 0x34, 0x29, 0xbb, 0x5a, 0x10, 0x43, 0x8b, 0x0e, 0x05, 0xba,
      0xca, 0xeb, 0xc6, 0x03, 0x17, 0x01, 0x0a, 0x33, 0x4d, 0x7f, 0x89, 0x60,
      0x28, 0xae, 0xf6, 0x20, 0xf5, 0xd9, 0xc7, 0xca, 0xbc, 0x38, 0x30, 0x6e,
      0x03, 0x2b, 0x1b, 0x91, 0xc2, 0x37, 0x6c, 0x3f, 0xef, 0x3e, 0x45, 0x5a,
      0x10, 0xdf},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 391
    {SEC_OID_SHA512,
     391,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x02,
      0x42, 0x00, 0xaa, 0x94, 0x02, 0xaa, 0x56, 0xb1, 0xac, 0xf4, 0x26, 0x8d,
      0x1a, 0xd7, 0x8c, 0x10, 0xc6, 0x53, 0xc1, 0x3c, 0xbb, 0x7e, 0x51, 0x42,
      0x3b, 0x99, 0x7f, 0x23, 0x99, 0x8d, 0xc5, 0x49, 0x9f, 0xa9, 0xd2, 0xf4,
      0x03, 0xc7, 0x8b, 0x64, 0x5c, 0xfb, 0xa4, 0xeb, 0x78, 0xf5, 0x95, 0xfe,
      0x6d, 0x6f, 0x01, 0xdb, 0xaa, 0xf8, 0x03, 0xf2, 0x3a, 0xc2, 0x63, 0xbf,
      0x06, 0x0b, 0xaa, 0x74, 0x58, 0x3a, 0xbf},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x30, 0x3b, 0xa5, 0xef, 0x90, 0xb0, 0x51, 0x10, 0x00,
      0x2f, 0xdf, 0x74, 0xd2, 0xb8, 0xd4, 0xc7, 0xab, 0x18, 0x9c, 0x64, 0x00,
      0x48, 0x59, 0xc6, 0x9d, 0x7c, 0x47, 0x30, 0xfc, 0xac, 0xb5, 0xf4, 0xd9,
      0xb7, 0x61, 0xae, 0x98, 0x7d, 0x1f, 0x3b, 0x63, 0xbb, 0x3e, 0xcb, 0x78,
      0xae, 0xec, 0xf4, 0xa0, 0x4f, 0xf6, 0x0f, 0x5f, 0x36, 0x7a, 0x96, 0xac,
      0x2d, 0xa8, 0xda, 0x27, 0xa3, 0x68, 0x7a, 0x3e, 0x00, 0x66, 0x73, 0xd0,
      0xd4, 0xcc, 0xd4, 0xc3, 0xce, 0x1a, 0xbc, 0x99, 0x80, 0xfd, 0x18, 0x85,
      0x00, 0x2c, 0x3e, 0x7b, 0x86, 0x07, 0x82, 0x14, 0xca, 0xf7, 0xf0, 0x96,
      0x2f, 0xa5, 0x1e, 0x11, 0x63, 0x63, 0x03, 0x2d, 0x7a, 0x1b, 0x93, 0xc9,
      0x2a, 0x4d, 0x62, 0x82, 0x75, 0x49, 0xd5, 0xa3, 0x3e, 0x4e, 0x6b, 0x9b,
      0x6c, 0x2a, 0xb6, 0xad, 0x9c, 0x2a, 0x15, 0xe4, 0x10, 0xc5, 0xb1, 0xa8,
      0x46, 0xb2},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 392
    {SEC_OID_SHA512,
     392,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x02,
      0x42, 0x01, 0xff, 0xde, 0x03, 0xff, 0x82, 0x0a, 0x83, 0x6e, 0x39, 0xd3,
      0xa8, 0x43, 0x52, 0x19, 0x29, 0x7d, 0xa1, 0xdb, 0x19, 0x3d, 0x79, 0xe3,
      0x59, 0x66, 0x3e, 0xb5, 0x66, 0x54, 0xa7, 0xee, 0x6f, 0x7e, 0xb9, 0x96,
      0xc8, 0xef, 0x12, 0xf6, 0x23, 0x44, 0xad, 0x21, 0x1b, 0x71, 0x05, 0x79,
      0x28, 0xf9, 0x6a, 0xe7, 0x5b, 0x58, 0xe2, 0x30, 0x26, 0x47, 0x6c, 0xfc,
      0x40, 0xed, 0x0e, 0xf7, 0x20, 0x8a, 0x23},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0xa9, 0x4e, 0xea, 0x84, 0x3a, 0x5c, 0x49, 0x63, 0x70,
      0x41, 0x59, 0x8e, 0x30, 0xc3, 0x81, 0xf7, 0x17, 0x3b, 0xf8, 0xcd, 0x12,
      0x7f, 0x3c, 0xaf, 0x5c, 0x16, 0xcb, 0xc7, 0x28, 0xaa, 0x4d, 0x99, 0x17,
      0x3f, 0xb3, 0x8d, 0x6a, 0x1b, 0x1e, 0xc2, 0x1e, 0x40, 0x33, 0x6e, 0x8d,
      0x80, 0x22, 0x49, 0x27, 0x2b, 0x0c, 0xcb, 0xf4, 0xf8, 0xc3, 0x63, 0x6e,
      0xf6, 0x62, 0x90, 0xa8, 0x1b, 0x58, 0xfa, 0x5b, 0x01, 0x11, 0x6c, 0x23,
      0x46, 0x4f, 0xad, 0x61, 0xdf, 0x8d, 0x2d, 0x5d, 0x12, 0x50, 0xa5, 0xa4,
      0xc4, 0x27, 0xe9, 0xc5, 0x8e, 0x2c, 0xf1, 0xd0, 0x59, 0xcd, 0xd8, 0x8a,
      0x7c, 0x34, 0x98, 0x4f, 0xdd, 0x22, 0xa4, 0xcf, 0x18, 0x41, 0x1e, 0x1b,
      0x02, 0x24, 0xd4, 0x44, 0xa5, 0xbd, 0x39, 0xd5, 0xfc, 0x97, 0xfc, 0x0b,
      0x36, 0x48, 0x60, 0x0f, 0x19, 0xd6, 0xab, 0x80, 0xaa, 0x6a, 0x7c, 0x08,
      0x3a, 0x17},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 393
    {SEC_OID_SHA512,
     393,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x02,
      0x42, 0x01, 0x33, 0x75, 0xab, 0xb9, 0x9e, 0x0c, 0xd3, 0x80, 0x1e, 0x7c,
      0x12, 0x99, 0x3c, 0xfe, 0x72, 0x0c, 0x83, 0xde, 0x27, 0x89, 0x38, 0xa9,
      0xe2, 0x2b, 0xb6, 0xea, 0x40, 0xa7, 0xc5, 0x99, 0xad, 0x05, 0xa5, 0xd3,
      0xc8, 0xe5, 0xe5, 0xd7, 0xb3, 0xe1, 0x6a, 0x99, 0xe5, 0x28, 0xef, 0x0c,
      0xe9, 0x1b, 0xe0, 0x95, 0x3c, 0xb1, 0xa9, 0xad, 0xf7, 0x57, 0xf2, 0x57,
      0x55, 0x4c, 0xa4, 0x7a, 0xb0, 0x53, 0xdc},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0x4f, 0x71, 0xd2, 0xca, 0x5b, 0xd2, 0x05, 0x13, 0x36,
      0x85, 0x46, 0x57, 0xf0, 0x9a, 0x1f, 0xab, 0x14, 0xc7, 0xf2, 0xf7, 0x86,
      0x5d, 0x71, 0xbd, 0x3f, 0xa3, 0x54, 0xbf, 0x27, 0xb6, 0x9d, 0xc8, 0x73,
      0x89, 0x72, 0x14, 0x05, 0x53, 0xb5, 0x25, 0x65, 0x8b, 0x6f, 0xd2, 0x03,
      0xcc, 0x05, 0xca, 0x08, 0x22, 0xe0, 0x90, 0x4b, 0xad, 0x21, 0xb6, 0x32,
      0xe0, 0xde, 0x74, 0xa2, 0xad, 0x3f, 0x0e, 0x72, 0x00, 0x45, 0x25, 0xf9,
      0x05, 0x19, 0xf9, 0x49, 0x74, 0x25, 0x46, 0x0b, 0x31, 0xcb, 0xb6, 0x9a,
      0xb3, 0x70, 0x1a, 0x9e, 0xa6, 0x8a, 0xaa, 0xb7, 0x2c, 0x6d, 0x65, 0xd3,
      0x64, 0xd0, 0xf0, 0xed, 0x4d, 0x05, 0x24, 0x28, 0x0f, 0x11, 0x3b, 0xd6,
      0x9e, 0xf1, 0xba, 0x98, 0x25, 0x20, 0x2b, 0x10, 0x28, 0x7a, 0x08, 0x8c,
      0x4b, 0xf3, 0x0d, 0xeb, 0xec, 0xb7, 0x20, 0xac, 0x07, 0x39, 0xec, 0x67,
      0x43, 0x4d},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 394
    {SEC_OID_SHA512,
     394,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x02,
      0x41, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x54},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0xd2, 0xec, 0xad, 0x92, 0x1d, 0xd1, 0x00, 0xa8, 0xdc,
      0x1a, 0x7b, 0x82, 0x4b, 0x0a, 0xc6, 0xc9, 0xb6, 0x54, 0xab, 0x17, 0x98,
      0x33, 0xc2, 0x88, 0x1c, 0xe2, 0x37, 0xf1, 0xb8, 0x49, 0x7a, 0xde, 0x85,
      0x13, 0x02, 0xcf, 0x50, 0xea, 0x5e, 0xa1, 0x69, 0xc2, 0xa5, 0x0c, 0x0c,
      0x09, 0xcb, 0x6e, 0xa5, 0x39, 0xa7, 0x29, 0x0a, 0x0f, 0x34, 0x37, 0x04,
      0x4b, 0x7a, 0x2e, 0x9c, 0xa8, 0xd4, 0x05, 0x00, 0x00, 0x3f, 0xd5, 0x65,
      0x15, 0x35, 0xdc, 0xba, 0x1f, 0x33, 0x19, 0x81, 0xc2, 0x16, 0xa1, 0xc7,
      0xd9, 0x84, 0x2f, 0x65, 0xc5, 0xf3, 0x8c, 0xa4, 0x3d, 0xd7, 0x1c, 0x41,
      0xe1, 0x9e, 0xfc, 0xac, 0x38, 0x46, 0x17, 0x65, 0x6f, 0xd0, 0xaf, 0xdd,
      0x83, 0xc5, 0x0c, 0x5e, 0x52, 0x4e, 0x9b, 0x67, 0x2b, 0x7a, 0xa8, 0xa6,
      0x6b, 0x28, 0x9a, 0xfa, 0x68, 0x8e, 0x45, 0xca, 0x6e, 0xdb, 0x34, 0x77,
      0xa8, 0xb0},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 395
    {SEC_OID_SHA512,
     395,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x02,
      0x42, 0x00, 0x9f, 0x57, 0x70, 0x8f, 0xa9, 0x7e, 0xba, 0x94, 0xc6, 0xd4,
      0x78, 0x2c, 0xdd, 0x4e, 0x33, 0xbb, 0x95, 0xc1, 0x35, 0x3b, 0xde, 0x09,
      0x52, 0x32, 0xe3, 0xe2, 0xba, 0xb2, 0x77, 0xbb, 0x5d, 0x2b, 0x48, 0xf5,
      0x5a, 0x53, 0xff, 0xe9, 0x28, 0xd0, 0x34, 0xc2, 0x99, 0x70, 0xa9, 0xe5,
      0xf3, 0x84, 0xa0, 0x03, 0x90, 0x7d, 0x3d, 0x9b, 0x82, 0xa8, 0x68, 0x17,
      0xcc, 0x61, 0xfb, 0x17, 0xf4, 0xc5, 0x9e},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0x65, 0xd6, 0x79, 0x72, 0xa4, 0x8f, 0xdd, 0xc2, 0xf4,
      0x1c, 0x03, 0xf7, 0x9a, 0xb5, 0xe0, 0xd4, 0x2f, 0xd0, 0x99, 0x2c, 0x01,
      0x3e, 0xad, 0x13, 0x5c, 0x33, 0x94, 0x04, 0x96, 0x45, 0xe2, 0x6a, 0xd7,
      0xc7, 0xbe, 0x96, 0x51, 0x0d, 0xf5, 0x9b, 0xa6, 0x77, 0xdc, 0x94, 0xf1,
      0x14, 0x6e, 0x8e, 0x8e, 0x8f, 0xbe, 0x56, 0xde, 0xbc, 0xb6, 0x69, 0x20,
      0x63, 0x95, 0x81, 0x95, 0x6b, 0x92, 0xb4, 0xd1, 0x00, 0x8a, 0xeb, 0x66,
      0xee, 0x0b, 0xe1, 0x8a, 0xba, 0xa9, 0x09, 0xa9, 0x73, 0xc7, 0x0b, 0x57,
      0x49, 0xd6, 0x88, 0xf8, 0xe2, 0xcd, 0x2e, 0x6e, 0x16, 0x13, 0xaf, 0x93,
      0xd0, 0x03, 0x34, 0x92, 0xd2, 0x6a, 0x6e, 0x82, 0xcf, 0xb8, 0x0a, 0xc6,
      0x92, 0x5a, 0xc6, 0xbc, 0x79, 0xb9, 0x84, 0xf7, 0x3e, 0x3e, 0xbb, 0xff,
      0x2f, 0x22, 0x3a, 0x38, 0x67, 0x68, 0x91, 0xc1, 0xec, 0xd7, 0x84, 0xa8,
      0xa7, 0x89},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 396
    {SEC_OID_SHA512,
     396,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x02,
      0x41, 0x68, 0xd9, 0x8f, 0xa9, 0x07, 0x36, 0xef, 0xf3, 0xe9, 0x0f, 0x8f,
      0xcf, 0xe5, 0x08, 0x38, 0xb6, 0xfa, 0x0b, 0xf2, 0xcd, 0xe7, 0x7b, 0xc5,
      0x1e, 0x3f, 0x41, 0x01, 0x9c, 0x80, 0x06, 0xf4, 0xe9, 0xcb, 0xae, 0xad,
      0xce, 0x7d, 0xbb, 0x44, 0x46, 0x2d, 0xa6, 0x42, 0x5b, 0xe9, 0xcf, 0xda,
      0xec, 0xb2, 0x34, 0xc4, 0x17, 0x49, 0xce, 0x69, 0x5b, 0xe1, 0xb5, 0xea,
      0xd2, 0xe6, 0xb1, 0x20, 0x5f, 0x35},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0x8c, 0xd1, 0x12, 0x52, 0xf0, 0xa4, 0x34, 0xf4, 0x46,
      0xd3, 0xaf, 0x18, 0x51, 0x8c, 0x6b, 0x84, 0xcb, 0x0b, 0x7b, 0xf3, 0x37,
      0x58, 0xb4, 0xd8, 0x3b, 0x97, 0xc2, 0xa5, 0x6e, 0x00, 0x37, 0xb5, 0x4d,
      0x57, 0xd2, 0xb0, 0xb8, 0x42, 0xe9, 0xc1, 0x7d, 0x70, 0x50, 0x4e, 0x01,
      0x89, 0x63, 0x89, 0xc0, 0x66, 0xdb, 0x8f, 0x2b, 0xfe, 0xc0, 0x25, 0x25,
      0x9a, 0x51, 0xdf, 0xf5, 0x14, 0x66, 0x83, 0x08, 0x01, 0xcc, 0xa5, 0x43,
      0x65, 0x15, 0x6c, 0x59, 0xe2, 0xc7, 0x3c, 0x17, 0x66, 0x4f, 0x09, 0xfc,
      0xdc, 0xfd, 0x5b, 0x91, 0x0f, 0x9a, 0xb4, 0x8d, 0x08, 0x99, 0xb6, 0xa7,
      0x06, 0x4d, 0xe8, 0xb8, 0x0f, 0xc7, 0xa9, 0x92, 0xe4, 0x7e, 0xe7, 0xf2,
      0x3e, 0xc8, 0x2f, 0xd8, 0x01, 0x79, 0xa1, 0x9f, 0x4c, 0xf8, 0x9b, 0x4c,
      0x02, 0xb7, 0x21, 0x8f, 0x43, 0x52, 0x98, 0xda, 0x5d, 0x32, 0x2a, 0x98,
      0x2c, 0x1e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 397
    {SEC_OID_SHA512,
     397,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x02,
      0x42, 0x00, 0xe9, 0x7a, 0xe6, 0x6b, 0xcd, 0x4c, 0xae, 0x36, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x68,
      0xbc, 0x97, 0x26, 0xf0, 0x2d, 0xbf, 0x85, 0x98, 0xa9, 0x8b, 0x3e, 0x50,
      0x77, 0xef, 0xf6, 0xf2, 0x49, 0x1e, 0xb6, 0x78, 0xed, 0x04, 0x0f, 0xb3,
      0x38, 0xc0, 0x84, 0xa9, 0xea, 0x8a, 0x4c},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0xd6, 0x32, 0x9a, 0x8a, 0xfd, 0xea, 0x27, 0xcf, 0x10,
      0x28, 0xa4, 0x4d, 0x19, 0xc3, 0xc7, 0x29, 0x27, 0x59, 0x0d, 0x64, 0x62,
      0x87, 0x75, 0xf3, 0x24, 0x51, 0x4c, 0x81, 0xde, 0x30, 0x1a, 0xa9, 0xbe,
      0x9c, 0x77, 0x5c, 0x53, 0xa6, 0x34, 0x9d, 0x1c, 0xbd, 0x5e, 0xcf, 0xc7,
      0xbd, 0x39, 0xb3, 0x73, 0xe6, 0x13, 0xa1, 0x0c, 0x14, 0x39, 0x44, 0x1b,
      0x14, 0x14, 0x30, 0xfd, 0xad, 0xac, 0x16, 0x8c, 0x00, 0x07, 0x13, 0x42,
      0xd6, 0x3d, 0xba, 0x90, 0x1b, 0x93, 0xbd, 0xc4, 0x44, 0xa1, 0xfe, 0x2e,
      0xc6, 0xa1, 0x51, 0x08, 0xbd, 0xf4, 0x9e, 0xb1, 0xdf, 0xd2, 0x18, 0x37,
      0x38, 0x84, 0x52, 0x0d, 0x84, 0xbc, 0xe0, 0x3c, 0x50, 0x12, 0xf5, 0x83,
      0x70, 0x51, 0xcb, 0x8a, 0xbf, 0x6a, 0x0b, 0xe7, 0x8d, 0xfd, 0xfe, 0xeb,
      0x3a, 0x58, 0x72, 0xdf, 0xf7, 0x5b, 0x3f, 0x87, 0x4f, 0xaa, 0x6d, 0x22,
      0x43, 0xbf},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 398
    {SEC_OID_SHA512,
     398,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x02,
      0x42, 0x01, 0xae, 0x66, 0xbc, 0xd4, 0xca, 0xe3, 0x6f, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x39,
      0x54, 0x21, 0x2f, 0x8b, 0xea, 0x57, 0x8d, 0x93, 0xe6, 0x85, 0xe5, 0xdb,
      0xa3, 0x29, 0x81, 0x1b, 0x25, 0x42, 0xbb, 0x39, 0x82, 0x33, 0xe2, 0x94,
      0x4b, 0xce, 0xb1, 0x92, 0x63, 0x32, 0x5d},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0xc9, 0x63, 0xb6, 0x4c, 0xdc, 0x3e, 0xcb, 0x1c, 0x35,
      0xcd, 0xa5, 0xce, 0xd9, 0x41, 0x9a, 0xc1, 0x46, 0xb0, 0x60, 0xad, 0xb0,
      0x4c, 0x63, 0x8c, 0xf6, 0xb6, 0x66, 0x58, 0x01, 0x3c, 0xb2, 0x5e, 0x91,
      0x5a, 0x6a, 0xd0, 0x05, 0x56, 0x68, 0x34, 0x28, 0x81, 0xed, 0x27, 0xf4,
      0x38, 0xb5, 0x0a, 0xe4, 0xbb, 0x86, 0xae, 0x3c, 0x7c, 0x02, 0xb7, 0x27,
      0xa1, 0x30, 0xc7, 0x7b, 0xad, 0x69, 0x80, 0x08, 0x00, 0x48, 0x1b, 0xff,
      0xfa, 0xea, 0xd8, 0x56, 0xb4, 0x13, 0x7f, 0xd4, 0x26, 0x8e, 0xcd, 0x74,
      0xa6, 0xc2, 0xd4, 0xbd, 0x6c, 0xd1, 0x39, 0x98, 0xce, 0x7f, 0x0e, 0x82,
      0x8b, 0x22, 0x01, 0x35, 0xd8, 0xdf, 0x23, 0x25, 0x3e, 0x68, 0x1d, 0xc9,
      0x06, 0x73, 0xe0, 0x53, 0x7e, 0x75, 0x90, 0x76, 0x9a, 0x2a, 0x44, 0x1a,
      0xaa, 0xaa, 0x3a, 0x99, 0x01, 0xc4, 0xfb, 0xe4, 0x4f, 0xa9, 0x51, 0x39,
      0x51, 0xef},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 399
    {SEC_OID_SHA512,
     399,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x02,
      0x42, 0x01, 0x5c, 0xcd, 0x79, 0xa9, 0x95, 0xc6, 0xdf, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x21,
      0x21, 0xba, 0xdb, 0x58, 0xa5, 0x18, 0xaf, 0xa8, 0x01, 0x0a, 0x82, 0xc0,
      0x3c, 0xad, 0x31, 0xfa, 0x94, 0xbb, 0xbd, 0xe9, 0x68, 0x20, 0x16, 0x6d,
      0x27, 0xe6, 0x44, 0x93, 0x8e, 0x00, 0xb1},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5d, 0xfb, 0xc8, 0x67, 0xd5, 0x3c, 0x57, 0xb2, 0x94,
      0x55, 0x02, 0xb8, 0xe5, 0x6d, 0x96, 0xca, 0x2d, 0x4d, 0x48, 0x5a, 0xa3,
      0x34, 0x52, 0x20, 0x0a, 0x2f, 0x4b, 0xa1, 0x60, 0x42, 0x35, 0x79, 0x76,
      0xaf, 0xee, 0xcf, 0x3e, 0x63, 0xb2, 0xfd, 0xcd, 0x5c, 0xdd, 0x76, 0x07,
      0x6c, 0x1a, 0x73, 0xe4, 0x96, 0xca, 0xf9, 0xd6, 0xde, 0x3e, 0x88, 0x31,
      0xd9, 0x55, 0xd1, 0x38, 0xe0, 0x58, 0x84, 0xae, 0x01, 0xe0, 0x4a, 0xa0,
      0xb5, 0x36, 0x0a, 0x0d, 0x3b, 0xad, 0xd0, 0x12, 0x0f, 0xbb, 0x8c, 0xc4,
      0x2a, 0x38, 0xbf, 0x1c, 0x61, 0x75, 0x5d, 0x00, 0x85, 0x8e, 0x40, 0xe4,
      0xb1, 0x0d, 0xa4, 0xea, 0x25, 0x75, 0x83, 0x0d, 0xc9, 0x2e, 0x31, 0x2c,
      0x20, 0xaf, 0x2b, 0x8b, 0x16, 0x7d, 0x7a, 0x58, 0xd1, 0x78, 0x66, 0x1d,
      0x48, 0xcd, 0x93, 0x2f, 0xe4, 0x7a, 0x4b, 0xc7, 0x14, 0x5e, 0x62, 0x0a,
      0xe2, 0x2c},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 400
    {SEC_OID_SHA512,
     400,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x02,
      0x42, 0x01, 0xcd, 0x4c, 0xae, 0x36, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xe1,
      0x8d, 0xcc, 0x11, 0xdf, 0xf7, 0x52, 0x62, 0x33, 0xd9, 0x23, 0xa0, 0xb2,
      0x02, 0xcb, 0x29, 0xe7, 0x13, 0xf2, 0x2d, 0xe8, 0xbb, 0x6a, 0xb0, 0xa1,
      0x28, 0x21, 0xc5, 0xab, 0xbe, 0x3f, 0x23},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x78, 0xbe, 0x6c, 0x43, 0xe3, 0x66, 0xcf, 0x63, 0xdd,
      0xc4, 0x23, 0x5e, 0x8b, 0x96, 0x93, 0x86, 0xe9, 0x50, 0x12, 0xfb, 0xca,
      0x5c, 0xeb, 0xf1, 0xb0, 0xa6, 0xfe, 0x3c, 0x03, 0xc1, 0x25, 0x7d, 0xf7,
      0xcf, 0x47, 0xb0, 0x02, 0xeb, 0x6c, 0x44, 0x97, 0xf3, 0x10, 0xbf, 0xf6,
      0x13, 0x1b, 0x5c, 0xcb, 0x54, 0xfd, 0x0e, 0x8e, 0xe7, 0xfc, 0xf6, 0xb4,
      0x9d, 0x48, 0x7e, 0x1b, 0x54, 0x50, 0x8f, 0x68, 0x00, 0x9b, 0x61, 0xa5,
      0x47, 0x10, 0x4c, 0x85, 0x16, 0xe0, 0xdc, 0x35, 0xd3, 0xd1, 0x76, 0x59,
      0xca, 0x09, 0x8d, 0x02, 0x3b, 0x05, 0x93, 0x90, 0x8f, 0xe9, 0x79, 0xc2,
      0x9e, 0x62, 0x37, 0x37, 0x38, 0xa3, 0xc3, 0x00, 0x94, 0xba, 0x47, 0x10,
      0x5a, 0x49, 0xed, 0xbc, 0x6e, 0x1d, 0x37, 0xcc, 0xe3, 0x17, 0xb4, 0x9d,
      0x27, 0x01, 0x47, 0x0e, 0xeb, 0x53, 0xd9, 0xb2, 0x4d, 0xce, 0x9d, 0x80,
      0x91, 0x66},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 401
    {SEC_OID_SHA512,
     401,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x02,
      0x41, 0x22, 0xe8, 0xba, 0x2e, 0x8b, 0xa2, 0xe8, 0xba, 0x2e, 0x8b, 0xa2,
      0xe8, 0xba, 0x2e, 0x8b, 0xa2, 0xe8, 0xba, 0x2e, 0x8b, 0xa2, 0xe8, 0xba,
      0x2e, 0x8b, 0xa2, 0xe8, 0xba, 0x2e, 0x8b, 0xa2, 0xe8, 0xb9, 0xc4, 0xc3,
      0xf7, 0x3c, 0xc8, 0x16, 0x14, 0x3f, 0xac, 0x34, 0x12, 0xb6, 0x2d, 0xe4,
      0xc6, 0x3d, 0xb0, 0x8f, 0x8c, 0x57, 0xe4, 0xc5, 0x8c, 0x31, 0xf1, 0xb4,
      0x57, 0xca, 0x5e, 0x57, 0xe2, 0x0a},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x93, 0xf6, 0x89, 0x61, 0x00, 0x5f, 0x30, 0x40, 0xdc,
      0x1a, 0x8f, 0xf1, 0x41, 0x6c, 0x91, 0x7b, 0xdc, 0xc7, 0x7f, 0x1d, 0xfa,
      0x85, 0x50, 0x6c, 0x3b, 0xb6, 0x2d, 0xac, 0x47, 0xf7, 0xbe, 0x95, 0x29,
      0xb4, 0xcb, 0xe5, 0x7d, 0xd2, 0xc1, 0x9e, 0x86, 0x0b, 0xd2, 0xa0, 0xdb,
      0x71, 0xd4, 0x7e, 0xf1, 0xec, 0xa8, 0xa2, 0x0b, 0xfc, 0x3e, 0x0b, 0xc5,
      0xe0, 0x5c, 0x83, 0x03, 0x00, 0x1c, 0x19, 0x60, 0x00, 0x2b, 0x9a, 0x3d,
      0x45, 0xf2, 0xf5, 0x12, 0x0f, 0xee, 0x06, 0x44, 0x5f, 0x0d, 0x34, 0xe6,
      0x13, 0x8e, 0x3a, 0xc5, 0xb1, 0x6d, 0x2a, 0x22, 0xf0, 0x46, 0x0c, 0xea,
      0x25, 0x8c, 0x36, 0x8c, 0xa9, 0xe4, 0x78, 0xeb, 0x7b, 0x82, 0x53, 0xe7,
      0xc6, 0xf2, 0xf7, 0x25, 0x0f, 0xdc, 0x7d, 0xcd, 0x72, 0x43, 0x76, 0x1f,
      0x8d, 0x56, 0xf2, 0x35, 0x0a, 0xc5, 0x1e, 0x47, 0xee, 0x06, 0x3f, 0x41,
      0xda, 0x31},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 402
    {SEC_OID_SHA512,
     402,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x02,
      0x42, 0x01, 0x05, 0x90, 0xb2, 0x16, 0x42, 0xc8, 0x59, 0x0b, 0x21, 0x64,
      0x2c, 0x85, 0x90, 0xb2, 0x16, 0x42, 0xc8, 0x59, 0x0b, 0x21, 0x64, 0x2c,
      0x85, 0x90, 0xb2, 0x16, 0x42, 0xc8, 0x59, 0x0b, 0x21, 0x64, 0x29, 0x8e,
      0xb5, 0x7e, 0x5a, 0xff, 0x93, 0x43, 0x59, 0x7a, 0x54, 0x2d, 0x31, 0x32,
      0xf9, 0xe7, 0x34, 0xfd, 0xc3, 0x05, 0x12, 0x5e, 0x0e, 0xc1, 0x39, 0xc5,
      0xf7, 0x80, 0xee, 0x8e, 0x8c, 0xb9, 0xc2},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x2d, 0x2d, 0x7d, 0x40, 0xbf, 0x17, 0xc4, 0xe8, 0xb1,
      0x87, 0x57, 0xe4, 0x51, 0xdd, 0xde, 0xd9, 0x5e, 0x6b, 0x10, 0x07, 0xcd,
      0x14, 0x48, 0x09, 0xd2, 0x1a, 0xf3, 0x13, 0x53, 0xb0, 0x30, 0x38, 0x37,
      0x2c, 0x4a, 0xf2, 0x04, 0xd4, 0x41, 0x4b, 0x71, 0x06, 0x0b, 0x48, 0xb3,
      0xa8, 0x43, 0x9c, 0x63, 0x28, 0x09, 0xbd, 0x33, 0xc4, 0x73, 0x62, 0x63,
      0x04, 0x44, 0x05, 0xa1, 0xad, 0x76, 0x6e, 0x36, 0x00, 0xbb, 0x0c, 0x5a,
      0x88, 0x48, 0xf9, 0x3f, 0xa3, 0xe8, 0x53, 0x76, 0xb0, 0x12, 0xbf, 0x06,
      0x4e, 0x30, 0x37, 0x46, 0x52, 0x9a, 0x67, 0x3b, 0x85, 0x2b, 0xb5, 0xa9,
      0x69, 0xc2, 0x4c, 0x01, 0x56, 0xa8, 0xdd, 0x26, 0x24, 0x2d, 0x0a, 0xad,
      0x4b, 0xae, 0x43, 0xe2, 0x36, 0x31, 0xb0, 0x1f, 0xb9, 0xd0, 0x50, 0xf9,
      0x74, 0x4b, 0x59, 0xf3, 0xb5, 0x2b, 0x1c, 0x57, 0x22, 0x17, 0xa1, 0xd7,
      0x05, 0x88},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 403
    {SEC_OID_SHA512,
     403,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x02,
      0x42, 0x01, 0xa4, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24,
      0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24,
      0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x44, 0x45,
      0xe1, 0x06, 0x70, 0xed, 0x04, 0x37, 0xc9, 0xdb, 0x41, 0x25, 0xac, 0x41,
      0x75, 0xfb, 0xd7, 0x0e, 0x9b, 0xd1, 0x79, 0x9a, 0x85, 0xf4, 0x4c, 0xa0,
      0xa8, 0xe6, 0x1a, 0x33, 0x54, 0xe8, 0x08},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0x8a, 0xc1, 0x1d, 0xfe, 0x62, 0xd1, 0xf2, 0xa8, 0x20,
      0x27, 0x32, 0xc7, 0x9b, 0x42, 0x3d, 0x29, 0xf4, 0x3b, 0xec, 0x4d, 0xb6,
      0x08, 0x0a, 0x22, 0x07, 0x96, 0xa1, 0x0f, 0x26, 0x85, 0xf9, 0x2c, 0x71,
      0xc7, 0xf7, 0x2d, 0x9d, 0xa0, 0xa8, 0xac, 0xb2, 0x26, 0x80, 0xcc, 0xa0,
      0x18, 0xeb, 0xa2, 0xe8, 0xba, 0x3b, 0xfd, 0xe1, 0xdb, 0x9a, 0x4e, 0xf3,
      0xb9, 0x7d, 0xa1, 0x64, 0x74, 0x36, 0x4e, 0x96, 0x00, 0x5a, 0xad, 0x3b,
      0x28, 0x67, 0x07, 0xbd, 0x3a, 0xd0, 0x7a, 0x06, 0x0c, 0xab, 0xca, 0x49,
      0xc5, 0x3d, 0xe4, 0xf5, 0x6c, 0x05, 0xa0, 0xa8, 0xde, 0x40, 0xfd, 0x96,
      0x9d, 0x7d, 0x4f, 0x99, 0x5f, 0x7c, 0x67, 0x01, 0xfe, 0x5c, 0x53, 0x21,
      0xf8, 0x53, 0x18, 0xb9, 0x8b, 0xe6, 0x62, 0x51, 0xfa, 0x49, 0x00, 0x88,
      0xfd, 0x72, 0x7d, 0xa2, 0x45, 0x4e, 0x00, 0xb3, 0xb9, 0x4d, 0xc6, 0xe1,
      0x24, 0x1b},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 404
    {SEC_OID_SHA512,
     404,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x02,
      0x42, 0x01, 0xd5, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x4f, 0xa6,
      0xdb, 0xdc, 0xd9, 0x14, 0x84, 0xeb, 0xc0, 0xd5, 0x21, 0x56, 0x9e, 0x4c,
      0x5e, 0xfb, 0x25, 0x91, 0x0b, 0x1f, 0x0d, 0xde, 0xf1, 0x9d, 0x04, 0x10,
      0xc5, 0x0c, 0x73, 0xe6, 0x8d, 0xb9, 0x5f},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x51, 0xb2, 0xc3, 0xe0, 0x49, 0x45, 0x64, 0xed, 0x48,
      0xed, 0x34, 0x79, 0xb5, 0x96, 0xea, 0x40, 0x78, 0x24, 0x05, 0x50, 0xa3,
      0xc2, 0x8d, 0xa3, 0x3d, 0x71, 0xd2, 0x59, 0xe8, 0xe6, 0x23, 0xe3, 0x7a,
      0xb4, 0x3f, 0x39, 0x6c, 0x49, 0x36, 0x3f, 0x31, 0xc8, 0xde, 0x8a, 0x46,
      0x44, 0xd3, 0x7e, 0x94, 0xed, 0x80, 0xe0, 0xdd, 0x4f, 0x92, 0xc3, 0xdf,
      0x21, 0x06, 0xe2, 0x79, 0x5c, 0x27, 0x98, 0xb8, 0x00, 0xa5, 0x30, 0xd5,
      0xe9, 0x61, 0xf0, 0x69, 0x6b, 0xbe, 0xb9, 0x62, 0xac, 0xa8, 0xe7, 0x1f,
      0x65, 0x95, 0x6a, 0xe0, 0x4c, 0xdc, 0x22, 0xa4, 0xac, 0x65, 0x14, 0x69,
      0x43, 0xe9, 0x9a, 0x4a, 0x2f, 0xdb, 0x47, 0x7d, 0xf7, 0x5a, 0xa0, 0x69,
      0xc8, 0xdd, 0x37, 0xa5, 0xda, 0xae, 0xa3, 0x84, 0x80, 0x79, 0xa6, 0xa7,
      0xbc, 0x03, 0xe0, 0xfa, 0xa3, 0xd6, 0x5d, 0x42, 0xf8, 0x05, 0x3d, 0xb2,
      0x07, 0x8b},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 405
    {SEC_OID_SHA512,
     405,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x02,
      0x42, 0x01, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4, 0xfc,
      0x31, 0x32, 0x2e, 0x69, 0xda, 0x41, 0x16, 0x2a, 0x76, 0xab, 0xf3, 0xa1,
      0xb4, 0x50, 0x7a, 0xe6, 0x60, 0x74, 0x63, 0x34, 0x46, 0xf2, 0x59, 0x66,
      0x1a, 0x61, 0xc9, 0x3b, 0xe3, 0x0e, 0xb5},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0xba, 0x31, 0xa6, 0xf9, 0xc2, 0xd2, 0x27, 0xda, 0x57,
      0xde, 0x00, 0x75, 0x9e, 0x2e, 0x84, 0x4d, 0x60, 0x7b, 0xc9, 0xbd, 0x92,
      0xbc, 0xdf, 0x28, 0x20, 0x06, 0x88, 0x4d, 0xc3, 0x47, 0xc9, 0x28, 0x4f,
      0x0d, 0xc0, 0x62, 0x3a, 0xf1, 0xe9, 0xdb, 0x22, 0x11, 0x73, 0x64, 0xa7,
      0xa8, 0x0a, 0x5b, 0x06, 0x7e, 0xfa, 0x19, 0xb2, 0x04, 0xda, 0xc8, 0xfa,
      0xf2, 0x23, 0x0d, 0x80, 0xb7, 0x04, 0xad, 0xdc, 0x00, 0xd8, 0x8b, 0x76,
      0x1c, 0xd3, 0xa4, 0xb0, 0x94, 0x7b, 0xfc, 0x17, 0xe2, 0x04, 0xb4, 0xd7,
      0x51, 0xf7, 0x68, 0x80, 0xa8, 0x2c, 0x9b, 0x7c, 0x6f, 0xd9, 0x3d, 0xed,
      0x55, 0x88, 0x3c, 0x99, 0x50, 0x02, 0xd8, 0xb8, 0xbf, 0xff, 0x1e, 0x02,
      0x11, 0x89, 0xc0, 0x8d, 0x82, 0x9d, 0x16, 0xb0, 0x88, 0xf4, 0xfb, 0x39,
      0xad, 0x94, 0x56, 0xea, 0xfb, 0xc7, 0x7c, 0x20, 0x35, 0x3b, 0xc0, 0xf3,
      0xc0, 0x38},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 406
    {SEC_OID_SHA512,
     406,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x02,
      0x42, 0x01, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x51,
      0x86, 0x87, 0x83, 0xbf, 0x2f, 0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7,
      0x09, 0xa5, 0xd0, 0x3b, 0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb,
      0x6f, 0xb7, 0x1e, 0x91, 0x38, 0x64, 0x0b},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0x37, 0xbb, 0xb4, 0x8e, 0xf2, 0x81, 0x13, 0x38, 0x49,
      0xed, 0x72, 0x3f, 0x56, 0x62, 0xa1, 0x9f, 0xff, 0x9c, 0xc7, 0x38, 0x9a,
      0x01, 0x70, 0xd3, 0x11, 0xbd, 0x34, 0xf4, 0xdb, 0xdc, 0x65, 0x62, 0x46,
      0xdb, 0x69, 0x5e, 0xa0, 0x71, 0x2d, 0x8a, 0xce, 0xff, 0x9d, 0x1d, 0x0e,
      0xf7, 0x92, 0x1e, 0xc2, 0xe3, 0xf8, 0xb5, 0x33, 0xe4, 0xca, 0x12, 0x2f,
      0x9f, 0x7f, 0x44, 0x60, 0x73, 0x88, 0x93, 0x34, 0x01, 0x63, 0xe4, 0x50,
      0x0d, 0x99, 0x80, 0x95, 0xf6, 0x0f, 0xa3, 0xfe, 0xd4, 0x14, 0x9d, 0x2d,
      0x9b, 0x5b, 0x01, 0x8e, 0x03, 0xeb, 0x53, 0x44, 0xef, 0xe8, 0xff, 0xcc,
      0x1c, 0x7d, 0x27, 0x6e, 0x74, 0x01, 0xa4, 0xdf, 0x63, 0x9c, 0x4a, 0xb1,
      0x08, 0x82, 0x00, 0x62, 0x49, 0x54, 0x71, 0xbe, 0x7b, 0x29, 0x39, 0x8a,
      0xad, 0xba, 0xe4, 0x40, 0xa9, 0xbd, 0xcd, 0x55, 0xcf, 0x0b, 0xb5, 0xd9,
      0x6f, 0x79},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 407
    {SEC_OID_SHA512,
     407,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x02,
      0x42, 0x01, 0x34, 0x6c, 0xc7, 0xd4, 0x83, 0x9b, 0x77, 0xf9, 0xf4, 0x87,
      0xc7, 0xe7, 0xf2, 0x84, 0x1c, 0x5b, 0x7d, 0x05, 0xf9, 0x66, 0xf3, 0xbd,
      0xe2, 0x8f, 0x1f, 0xa0, 0x80, 0xce, 0x40, 0x03, 0x7a, 0x74, 0xe3, 0x00,
      0x1a, 0x2b, 0x00, 0xbd, 0x39, 0xee, 0x4c, 0x93, 0x07, 0x2e, 0x99, 0x63,
      0x72, 0x49, 0x41, 0x38, 0x3c, 0xf0, 0x81, 0x2c, 0x02, 0xd1, 0xc8, 0x38,
      0xad, 0x45, 0x02, 0xa1, 0x2c, 0x61, 0x9f},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x72, 0x6d, 0xda, 0x8b, 0x7b, 0x6e, 0xd2, 0x5f, 0x97,
      0xf1, 0xfc, 0x6c, 0x3c, 0xcf, 0x55, 0x4d, 0x60, 0xfc, 0x71, 0xe4, 0xfa,
      0xb2, 0xa5, 0x78, 0x28, 0x6d, 0x32, 0x61, 0x2e, 0x7f, 0x3e, 0x66, 0x9f,
      0xae, 0xd0, 0xb9, 0x76, 0x19, 0xae, 0xf2, 0xd5, 0xaf, 0xf9, 0xc8, 0xff,
      0xd9, 0x87, 0xfe, 0xdd, 0xc0, 0xd6, 0xc3, 0x8b, 0x7e, 0xec, 0x02, 0x81,
      0x91, 0x40, 0x08, 0x74, 0x80, 0x3f, 0x49, 0x8b, 0x00, 0xc0, 0xb8, 0x87,
      0x0c, 0x61, 0x2e, 0x06, 0xc1, 0x3c, 0x57, 0xed, 0x6f, 0x7e, 0xf3, 0xd5,
      0x3b, 0x5e, 0x5f, 0xa2, 0xdb, 0x62, 0x70, 0x7b, 0x03, 0x4b, 0x5e, 0xc1,
      0x3f, 0xb4, 0x70, 0x18, 0xe3, 0x1d, 0xa7, 0xec, 0xc9, 0x91, 0xd5, 0x75,
      0x94, 0x34, 0x68, 0xd7, 0x01, 0xe1, 0x18, 0xec, 0xa3, 0x31, 0x22, 0xcf,
      0x6d, 0x39, 0x4b, 0x8a, 0x6e, 0xc0, 0xf4, 0x5b, 0xc0, 0x97, 0x01, 0x60,
      0x3a, 0x26},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: point duplication during verification
    // tcID: 408
    {SEC_OID_SHA512,
     408,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0x90, 0xc8, 0xd0, 0xd7, 0x18, 0xcb,
      0x9d, 0x8d, 0x81, 0x09, 0x4e, 0x6d, 0x06, 0x8f, 0xb1, 0x3c, 0x16, 0xb4,
      0xdf, 0x8c, 0x77, 0xba, 0xc6, 0x76, 0xdd, 0xdf, 0xe3, 0xe6, 0x88, 0x55,
      0xbe, 0xd0, 0x6b, 0x9b, 0xa8, 0xd0, 0xf8, 0xa8, 0x0e, 0xdc, 0xe0, 0x3a,
      0x9f, 0xac, 0x7d, 0xa5, 0x61, 0xe2, 0x4b, 0x1c, 0xd2, 0x2d, 0x45, 0x92,
      0x39, 0xa1, 0x46, 0x69, 0x5a, 0x67, 0x1f, 0x81, 0xf7, 0x3a, 0xaf, 0x02,
      0x42, 0x01, 0x15, 0x0b, 0x0f, 0xe9, 0xf0, 0xdf, 0xf2, 0x7f, 0xa1, 0x80,
      0xcc, 0x94, 0x42, 0xc3, 0xbf, 0xc9, 0xe3, 0x95, 0x23, 0x28, 0x98, 0x60,
      0x7b, 0x11, 0x0a, 0x51, 0xbc, 0xb1, 0x08, 0x6c, 0xb9, 0x72, 0x6e, 0x25,
      0x1a, 0x07, 0xc9, 0x55, 0x78, 0x08, 0xdf, 0x32, 0x46, 0x07, 0x15, 0x95,
      0x0a, 0x3d, 0xc4, 0x46, 0xae, 0x42, 0x29, 0xb9, 0xed, 0x59, 0xfe, 0x24,
      0x1b, 0x38, 0x9a, 0xee, 0x3a, 0x69, 0x63},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0x6f, 0xce, 0x9f, 0x37, 0x5b, 0xbd, 0x29, 0x68, 0xad,
      0xaa, 0xf3, 0x57, 0x55, 0x95, 0x12, 0x9e, 0xf3, 0xe7, 0x21, 0xc3, 0xb7,
      0xc8, 0x3d, 0x5a, 0x4a, 0x79, 0xf4, 0xb5, 0xdf, 0xbb, 0xdb, 0x1f, 0x66,
      0xda, 0x72, 0x43, 0xe5, 0x12, 0x0c, 0x5d, 0xbd, 0x7b, 0xe1, 0xca, 0x07,
      0x3e, 0x04, 0xb4, 0xcc, 0x58, 0xca, 0x8c, 0xe2, 0xf3, 0x4f, 0xf6, 0xa3,
      0xd0, 0x2a, 0x92, 0x9b, 0xf2, 0xfc, 0x27, 0x97, 0x00, 0x83, 0xf1, 0x30,
      0x79, 0x2d, 0x6c, 0x45, 0xc8, 0xf2, 0xa6, 0x74, 0x71, 0xe5, 0x12, 0x46,
      0xe2, 0xb8, 0x78, 0x14, 0x65, 0xb8, 0x29, 0x1c, 0xbd, 0xa6, 0x6d, 0x22,
      0x71, 0x9c, 0xd5, 0x36, 0xbf, 0x80, 0x1e, 0x00, 0x76, 0x03, 0x09, 0x19,
      0xd5, 0x70, 0x17, 0x32, 0xce, 0x76, 0x78, 0xbf, 0x47, 0x28, 0x46, 0xed,
      0x07, 0x77, 0x93, 0x7e, 0xd7, 0x7c, 0xaa, 0xd7, 0x4d, 0x05, 0x66, 0x46,
      0x14, 0xa2},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: duplication bug
    // tcID: 409
    {SEC_OID_SHA512,
     409,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0x90, 0xc8, 0xd0, 0xd7, 0x18, 0xcb,
      0x9d, 0x8d, 0x81, 0x09, 0x4e, 0x6d, 0x06, 0x8f, 0xb1, 0x3c, 0x16, 0xb4,
      0xdf, 0x8c, 0x77, 0xba, 0xc6, 0x76, 0xdd, 0xdf, 0xe3, 0xe6, 0x88, 0x55,
      0xbe, 0xd0, 0x6b, 0x9b, 0xa8, 0xd0, 0xf8, 0xa8, 0x0e, 0xdc, 0xe0, 0x3a,
      0x9f, 0xac, 0x7d, 0xa5, 0x61, 0xe2, 0x4b, 0x1c, 0xd2, 0x2d, 0x45, 0x92,
      0x39, 0xa1, 0x46, 0x69, 0x5a, 0x67, 0x1f, 0x81, 0xf7, 0x3a, 0xaf, 0x02,
      0x42, 0x01, 0x15, 0x0b, 0x0f, 0xe9, 0xf0, 0xdf, 0xf2, 0x7f, 0xa1, 0x80,
      0xcc, 0x94, 0x42, 0xc3, 0xbf, 0xc9, 0xe3, 0x95, 0x23, 0x28, 0x98, 0x60,
      0x7b, 0x11, 0x0a, 0x51, 0xbc, 0xb1, 0x08, 0x6c, 0xb9, 0x72, 0x6e, 0x25,
      0x1a, 0x07, 0xc9, 0x55, 0x78, 0x08, 0xdf, 0x32, 0x46, 0x07, 0x15, 0x95,
      0x0a, 0x3d, 0xc4, 0x46, 0xae, 0x42, 0x29, 0xb9, 0xed, 0x59, 0xfe, 0x24,
      0x1b, 0x38, 0x9a, 0xee, 0x3a, 0x69, 0x63},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0x6f, 0xce, 0x9f, 0x37, 0x5b, 0xbd, 0x29, 0x68, 0xad,
      0xaa, 0xf3, 0x57, 0x55, 0x95, 0x12, 0x9e, 0xf3, 0xe7, 0x21, 0xc3, 0xb7,
      0xc8, 0x3d, 0x5a, 0x4a, 0x79, 0xf4, 0xb5, 0xdf, 0xbb, 0xdb, 0x1f, 0x66,
      0xda, 0x72, 0x43, 0xe5, 0x12, 0x0c, 0x5d, 0xbd, 0x7b, 0xe1, 0xca, 0x07,
      0x3e, 0x04, 0xb4, 0xcc, 0x58, 0xca, 0x8c, 0xe2, 0xf3, 0x4f, 0xf6, 0xa3,
      0xd0, 0x2a, 0x92, 0x9b, 0xf2, 0xfc, 0x27, 0x97, 0x01, 0x7c, 0x0e, 0xcf,
      0x86, 0xd2, 0x93, 0xba, 0x37, 0x0d, 0x59, 0x8b, 0x8e, 0x1a, 0xed, 0xb9,
      0x1d, 0x47, 0x87, 0xeb, 0x9a, 0x47, 0xd6, 0xe3, 0x42, 0x59, 0x92, 0xdd,
      0x8e, 0x63, 0x2a, 0xc9, 0x40, 0x7f, 0xe1, 0xff, 0x89, 0xfc, 0xf6, 0xe6,
      0x2a, 0x8f, 0xe8, 0xcd, 0x31, 0x89, 0x87, 0x40, 0xb8, 0xd7, 0xb9, 0x12,
      0xf8, 0x88, 0x6c, 0x81, 0x28, 0x83, 0x55, 0x28, 0xb2, 0xfa, 0x99, 0xb9,
      0xeb, 0x5d},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: point with x-coordinate 0
    // tcID: 410
    {SEC_OID_SHA512,
     410,
     {0x30, 0x47, 0x02, 0x01, 0x01, 0x02, 0x42, 0x00, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa8, 0xc5, 0xd7, 0x82,
      0x81, 0x3f, 0xba, 0x87, 0x79, 0x2a, 0x99, 0x55, 0xc2, 0xfd, 0x03,
      0x37, 0x45, 0x69, 0x3c, 0x98, 0x92, 0xd8, 0x89, 0x6d, 0x3a, 0x3e,
      0x7a, 0x92, 0x5f, 0x85, 0xbd, 0x76, 0xad},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0x10, 0xfb, 0x89, 0xaf, 0xf1, 0x35, 0xed, 0xb8, 0x01,
      0xa1, 0xcb, 0x5b, 0xc4, 0x95, 0x25, 0xb8, 0x1d, 0xc7, 0x4d, 0xa4, 0x50,
      0x90, 0xd2, 0x28, 0x12, 0x28, 0x71, 0x81, 0x4f, 0x48, 0x9f, 0xdc, 0xb0,
      0x2e, 0xbe, 0xe4, 0x6b, 0x70, 0x3e, 0x6b, 0x4e, 0x6a, 0xf5, 0x6c, 0x50,
      0x24, 0x42, 0x2b, 0x31, 0xfd, 0x42, 0x52, 0xc4, 0x4d, 0x0b, 0xfd, 0x29,
      0xd9, 0x45, 0xde, 0x78, 0x2d, 0x98, 0x54, 0x3f, 0x01, 0xec, 0x42, 0x5b,
      0x4c, 0x49, 0x28, 0xe1, 0x2b, 0x61, 0x92, 0x27, 0xf1, 0xda, 0x6d, 0x0a,
      0x96, 0x75, 0x07, 0x0d, 0x9c, 0x5b, 0x49, 0xca, 0x52, 0x30, 0x50, 0xac,
      0xb7, 0x18, 0xe6, 0x26, 0x43, 0xb0, 0xe5, 0x80, 0x15, 0x43, 0xb7, 0x6d,
      0xc1, 0x1f, 0x8d, 0x69, 0x4b, 0xa0, 0x94, 0x36, 0xd8, 0x39, 0x1b, 0x47,
      0x7a, 0xd2, 0xc1, 0x43, 0xec, 0x50, 0xc2, 0x38, 0x4c, 0x4f, 0x68, 0x85,
      0x12, 0xdc},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: point with x-coordinate 0
    // tcID: 411
    {SEC_OID_SHA512,
     411,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
      0x41, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
      0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
      0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x65, 0x43, 0x81,
      0x4e, 0x4d, 0x8c, 0xa3, 0x1e, 0x15, 0x7f, 0xf5, 0x99, 0xdb, 0x64, 0x9b,
      0x87, 0x90, 0x0b, 0xf1, 0x28, 0x58, 0x1b, 0x85, 0xa7, 0xef, 0xbf, 0x16,
      0x57, 0xd2, 0xe9, 0xd8, 0x14, 0x01},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0xc6, 0x93, 0xa3, 0xfc, 0xcb, 0xc9, 0xf6, 0x25, 0x28,
      0x42, 0x39, 0xc2, 0x72, 0x5f, 0x2a, 0x5c, 0x90, 0xb2, 0x9b, 0x7c, 0xe3,
      0xd0, 0x77, 0x30, 0xf7, 0xde, 0x60, 0x31, 0xc9, 0xe7, 0x44, 0x46, 0xd2,
      0x17, 0x88, 0x8a, 0xe0, 0x23, 0xaa, 0xe2, 0x3d, 0xf6, 0xa4, 0xaa, 0x15,
      0x3f, 0x58, 0xc7, 0x95, 0x97, 0xd5, 0x7f, 0x42, 0xce, 0x5c, 0x13, 0x54,
      0xe5, 0xdc, 0x43, 0xa5, 0xeb, 0x31, 0x1e, 0x13, 0x01, 0x5f, 0x99, 0x65,
      0x84, 0x43, 0xb2, 0xe3, 0x9c, 0x3e, 0xdc, 0xbc, 0xda, 0x70, 0x70, 0x7f,
      0xc5, 0xa4, 0xd3, 0x95, 0x45, 0xea, 0xbe, 0x35, 0x48, 0x16, 0xd0, 0x92,
      0x84, 0xa6, 0x26, 0x5e, 0x47, 0xeb, 0xf0, 0xa4, 0x73, 0x55, 0x82, 0x8e,
      0x81, 0x8a, 0x76, 0x7f, 0x84, 0x52, 0xa6, 0xd1, 0x84, 0x51, 0xe0, 0xe3,
      0x81, 0x7a, 0x89, 0x6f, 0xf4, 0x04, 0xcb, 0x16, 0x11, 0xbf, 0xc4, 0xc4,
      0xb4, 0xa3},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: comparison with point at infinity
    // tcID: 412
    {SEC_OID_SHA512,
     412,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x00, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xa8, 0xc5, 0xd7, 0x82, 0x81, 0x3f, 0xba, 0x87, 0x79, 0x2a,
      0x99, 0x55, 0xc2, 0xfd, 0x03, 0x37, 0x45, 0x69, 0x3c, 0x98, 0x92, 0xd8,
      0x89, 0x6d, 0x3a, 0x3e, 0x7a, 0x92, 0x5f, 0x85, 0xbd, 0x76, 0xad, 0x02,
      0x41, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
      0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
      0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x65, 0x43, 0x81,
      0x4e, 0x4d, 0x8c, 0xa3, 0x1e, 0x15, 0x7f, 0xf5, 0x99, 0xdb, 0x64, 0x9b,
      0x87, 0x90, 0x0b, 0xf1, 0x28, 0x58, 0x1b, 0x85, 0xa7, 0xef, 0xbf, 0x16,
      0x57, 0xd2, 0xe9, 0xd8, 0x14, 0x01},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0x7d, 0x7b, 0xf7, 0x23, 0x67, 0x8d, 0xf5, 0x74, 0xce,
      0x43, 0x66, 0x74, 0x1e, 0x1d, 0x37, 0x87, 0xf8, 0x34, 0xaf, 0x99, 0x97,
      0xb4, 0x1c, 0x82, 0x60, 0xa0, 0x74, 0xcb, 0x1f, 0x32, 0x5d, 0x2b, 0xae,
      0x9f, 0x85, 0x65, 0xdc, 0x6b, 0x51, 0xb6, 0xcb, 0x02, 0xdc, 0xee, 0xb5,
      0xa1, 0xb7, 0x74, 0xee, 0x8d, 0xd7, 0x05, 0x7c, 0x99, 0xe2, 0xd9, 0x4c,
      0x3c, 0x71, 0x29, 0x9a, 0x9c, 0xe0, 0xf1, 0xb0, 0x01, 0x62, 0xc6, 0x56,
      0x32, 0xff, 0xf8, 0x8b, 0xdb, 0xb1, 0x7c, 0xe2, 0x52, 0x5c, 0xca, 0xc8,
      0xdf, 0x37, 0xc5, 0x01, 0xab, 0x0e, 0x66, 0x26, 0xe2, 0x73, 0xfb, 0x6c,
      0xf9, 0x90, 0x00, 0x42, 0x43, 0x44, 0xc0, 0xac, 0x53, 0x9c, 0x9f, 0xd6,
      0xc4, 0xf3, 0xd2, 0x88, 0x76, 0xb2, 0x57, 0xc0, 0x10, 0xd3, 0x47, 0xa4,
      0x5b, 0xb0, 0x10, 0xcc, 0x05, 0x84, 0x43, 0x84, 0x3a, 0x75, 0x83, 0x28,
      0xd4, 0x91},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: extreme value for k and edgecase s
    // tcID: 413
    {SEC_OID_SHA512,
     413,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x43, 0x3c, 0x21, 0x90, 0x24, 0x27, 0x7e,
      0x7e, 0x68, 0x2f, 0xcb, 0x28, 0x81, 0x48, 0xc2, 0x82, 0x74, 0x74, 0x03,
      0x27, 0x9b, 0x1c, 0xcc, 0x06, 0x35, 0x2c, 0x6e, 0x55, 0x05, 0xd7, 0x69,
      0xbe, 0x97, 0xb3, 0xb2, 0x04, 0xda, 0x6e, 0xf5, 0x55, 0x07, 0xaa, 0x10,
      0x4a, 0x3a, 0x35, 0xc5, 0xaf, 0x41, 0xcf, 0x2f, 0xa3, 0x64, 0xd6, 0x0f,
      0xd9, 0x67, 0xf4, 0x3e, 0x39, 0x33, 0xba, 0x6d, 0x78, 0x3d, 0x02, 0x42,
      0x00, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa8, 0xc5, 0xd7,
      0x82, 0x81, 0x3f, 0xba, 0x87, 0x79, 0x2a, 0x99, 0x55, 0xc2, 0xfd, 0x03,
      0x37, 0x45, 0x69, 0x3c, 0x98, 0x92, 0xd8, 0x89, 0x6d, 0x3a, 0x3e, 0x7a,
      0x92, 0x5f, 0x85, 0xbd, 0x76, 0xad},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0xe0, 0x6d, 0xb4, 0x23, 0xa9, 0x02, 0xe2, 0x39, 0xb9,
      0x73, 0x40, 0xab, 0x05, 0x25, 0x34, 0xea, 0xd3, 0x7e, 0x79, 0x41, 0x2c,
      0x67, 0x5b, 0xf0, 0xeb, 0x82, 0x39, 0x99, 0xe6, 0xb7, 0x31, 0x04, 0x0b,
      0xff, 0x2b, 0x0e, 0x4f, 0xa6, 0x4e, 0xdf, 0x39, 0x62, 0xa3, 0x28, 0x92,
      0x1e, 0xa5, 0xae, 0x4e, 0x8f, 0x40, 0x79, 0xea, 0xb4, 0x39, 0xe1, 0x2f,
      0x92, 0x33, 0x5d, 0xfc, 0x48, 0x63, 0xc0, 0x7f, 0x00, 0x7e, 0xe9, 0xf0,
      0xec, 0xb4, 0x09, 0xcb, 0x13, 0x3c, 0x0c, 0xd0, 0x8b, 0x85, 0xe8, 0x40,
      0xb0, 0x76, 0xf3, 0xd6, 0x15, 0xe1, 0xef, 0x13, 0x93, 0xb5, 0x22, 0x23,
      0x38, 0xb2, 0x27, 0xd7, 0x68, 0x00, 0x3d, 0xa5, 0xf3, 0xba, 0x1f, 0x72,
      0xf6, 0x65, 0x4c, 0xa5, 0x4a, 0xc1, 0x1c, 0x2b, 0xa9, 0x1a, 0x6c, 0xb5,
      0x88, 0x3d, 0x6d, 0x1a, 0x82, 0x30, 0x4a, 0xd2, 0xb7, 0x9d, 0xe0, 0x92,
      0x15, 0xf3},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: extreme value for k and s^-1
    // tcID: 414
    {SEC_OID_SHA512,
     414,
     {0x30, 0x81, 0x86, 0x02, 0x41, 0x43, 0x3c, 0x21, 0x90, 0x24, 0x27, 0x7e,
      0x7e, 0x68, 0x2f, 0xcb, 0x28, 0x81, 0x48, 0xc2, 0x82, 0x74, 0x74, 0x03,
      0x27, 0x9b, 0x1c, 0xcc, 0x06, 0x35, 0x2c, 0x6e, 0x55, 0x05, 0xd7, 0x69,
      0xbe, 0x97, 0xb3, 0xb2, 0x04, 0xda, 0x6e, 0xf5, 0x55, 0x07, 0xaa, 0x10,
      0x4a, 0x3a, 0x35, 0xc5, 0xaf, 0x41, 0xcf, 0x2f, 0xa3, 0x64, 0xd6, 0x0f,
      0xd9, 0x67, 0xf4, 0x3e, 0x39, 0x33, 0xba, 0x6d, 0x78, 0x3d, 0x02, 0x41,
      0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92,
      0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92,
      0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x91, 0x79, 0x5c, 0x5c,
      0x80, 0x89, 0x06, 0xcc, 0x58, 0x7f, 0xf8, 0x92, 0x78, 0x23, 0x4a, 0x85,
      0x66, 0xe3, 0xf5, 0x65, 0xf5, 0xca, 0x84, 0x0a, 0x3d, 0x88, 0x7d, 0xac,
      0x72, 0x14, 0xbe, 0xe9, 0xb8},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0x50, 0x53, 0x74, 0x4d, 0x53, 0x81, 0x1d, 0xbe, 0xd8,
      0x88, 0x0f, 0x38, 0xd3, 0xa3, 0x45, 0x78, 0xa7, 0xf1, 0xc1, 0x72, 0xec,
      0x65, 0xbd, 0x8a, 0xd8, 0x18, 0x3b, 0xa0, 0xae, 0x10, 0x09, 0x34, 0x16,
      0x10, 0x7f, 0x3c, 0x94, 0x27, 0x42, 0xbd, 0xe6, 0x07, 0x19, 0x94, 0x9b,
      0x2c, 0x4f, 0x02, 0x6f, 0x43, 0x58, 0x21, 0x25, 0xc9, 0x9e, 0xd4, 0x8c,
      0xbc, 0x7c, 0x5a, 0x05, 0x1a, 0x5a, 0x74, 0x48, 0x00, 0xb3, 0x6d, 0x4c,
      0x91, 0xa2, 0xb0, 0x36, 0x7c, 0x56, 0x6b, 0x2c, 0x12, 0x98, 0x1c, 0xe0,
      0xfd, 0xbc, 0x3b, 0xeb, 0x98, 0x37, 0x17, 0x40, 0x3f, 0x69, 0xbf, 0x42,
      0x64, 0xfc, 0x61, 0x82, 0x47, 0x8a, 0xf0, 0xb2, 0x36, 0xff, 0x12, 0x0b,
      0xcf, 0xca, 0x11, 0x69, 0x24, 0xc5, 0x52, 0xab, 0xef, 0x66, 0x63, 0xb6,
      0x02, 0x3b, 0xe1, 0x98, 0x6b, 0x70, 0x20, 0x6d, 0x9b, 0xb8, 0x9b, 0x5e,
      0xd2, 0x98},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: extreme value for k and s^-1
    // tcID: 415
    {SEC_OID_SHA512,
     415,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x43, 0x3c, 0x21, 0x90, 0x24, 0x27, 0x7e,
      0x7e, 0x68, 0x2f, 0xcb, 0x28, 0x81, 0x48, 0xc2, 0x82, 0x74, 0x74, 0x03,
      0x27, 0x9b, 0x1c, 0xcc, 0x06, 0x35, 0x2c, 0x6e, 0x55, 0x05, 0xd7, 0x69,
      0xbe, 0x97, 0xb3, 0xb2, 0x04, 0xda, 0x6e, 0xf5, 0x55, 0x07, 0xaa, 0x10,
      0x4a, 0x3a, 0x35, 0xc5, 0xaf, 0x41, 0xcf, 0x2f, 0xa3, 0x64, 0xd6, 0x0f,
      0xd9, 0x67, 0xf4, 0x3e, 0x39, 0x33, 0xba, 0x6d, 0x78, 0x3d, 0x02, 0x42,
      0x01, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
      0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
      0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x95, 0x0e, 0x05,
      0x39, 0x36, 0x32, 0x8c, 0x78, 0x55, 0xff, 0xd6, 0x67, 0x6d, 0x92, 0x6e,
      0x1e, 0x40, 0x2f, 0xc4, 0xa1, 0x60, 0x6e, 0x16, 0x9f, 0xbe, 0xfc, 0x59,
      0x5f, 0x4b, 0xa7, 0x60, 0x50, 0x07},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0xfb, 0x2e, 0x26, 0x59, 0x6c, 0xc8, 0x04, 0x73, 0x91,
      0x7d, 0xd4, 0x6b, 0x4a, 0x1d, 0x14, 0xbd, 0x9a, 0x1c, 0xa9, 0x76, 0x9d,
      0xd1, 0x2b, 0xfa, 0xc1, 0xbf, 0xf1, 0x7c, 0xdc, 0x28, 0x2e, 0x74, 0xc7,
      0x3a, 0x80, 0x1e, 0xc1, 0xbe, 0x83, 0xed, 0xfe, 0x4b, 0xfe, 0x98, 0x13,
      0xec, 0x94, 0x3a, 0xc1, 0x51, 0x67, 0x8f, 0x0a, 0x9a, 0x0b, 0xf2, 0x7d,
      0x9e, 0xf3, 0x08, 0x17, 0x7e, 0xb0, 0x40, 0x0f, 0x01, 0x9e, 0x03, 0xa5,
      0xda, 0x3d, 0xa6, 0x7e, 0x6b, 0x8d, 0x06, 0x8d, 0xbd, 0xac, 0xf0, 0x91,
      0xb9, 0xd5, 0xef, 0xad, 0xaf, 0x63, 0xf4, 0xa7, 0xe9, 0xc6, 0xb6, 0xed,
      0x0a, 0x1c, 0x9a, 0x5d, 0x3c, 0xbc, 0x3e, 0x02, 0x44, 0xd4, 0x81, 0x06,
      0x60, 0x18, 0xfb, 0xa7, 0x67, 0x4a, 0x2b, 0x59, 0x13, 0x9a, 0x56, 0x56,
      0x78, 0x05, 0x63, 0xbb, 0x46, 0x18, 0x01, 0x4f, 0x17, 0x67, 0x52, 0xe1,
      0x77, 0xe0},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: extreme value for k and s^-1
    // tcID: 416
    {SEC_OID_SHA512,
     416,
     {0x30, 0x81, 0x86, 0x02, 0x41, 0x43, 0x3c, 0x21, 0x90, 0x24, 0x27, 0x7e,
      0x7e, 0x68, 0x2f, 0xcb, 0x28, 0x81, 0x48, 0xc2, 0x82, 0x74, 0x74, 0x03,
      0x27, 0x9b, 0x1c, 0xcc, 0x06, 0x35, 0x2c, 0x6e, 0x55, 0x05, 0xd7, 0x69,
      0xbe, 0x97, 0xb3, 0xb2, 0x04, 0xda, 0x6e, 0xf5, 0x55, 0x07, 0xaa, 0x10,
      0x4a, 0x3a, 0x35, 0xc5, 0xaf, 0x41, 0xcf, 0x2f, 0xa3, 0x64, 0xd6, 0x0f,
      0xd9, 0x67, 0xf4, 0x3e, 0x39, 0x33, 0xba, 0x6d, 0x78, 0x3d, 0x02, 0x41,
      0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
      0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
      0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x65, 0x43, 0x81, 0x4e,
      0x4d, 0x8c, 0xa3, 0x1e, 0x15, 0x7f, 0xf5, 0x99, 0xdb, 0x64, 0x9b, 0x87,
      0x90, 0x0b, 0xf1, 0x28, 0x58, 0x1b, 0x85, 0xa7, 0xef, 0xbf, 0x16, 0x57,
      0xd2, 0xe9, 0xd8, 0x14, 0x02},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x84, 0x22, 0xce, 0xa9, 0xdc, 0xf8, 0xae, 0x01, 0xf7,
      0xa1, 0x57, 0x88, 0x8f, 0x01, 0x8a, 0x40, 0xa6, 0x64, 0x61, 0xd3, 0x56,
      0x6e, 0xc4, 0xa4, 0xdf, 0xc8, 0x9e, 0xcb, 0x3c, 0x24, 0x04, 0xbe, 0x73,
      0x4d, 0x32, 0x91, 0x37, 0xd6, 0x30, 0x38, 0x7b, 0x01, 0x2d, 0x03, 0x32,
      0x21, 0x85, 0x7d, 0x5b, 0xfb, 0x29, 0x0f, 0xa8, 0x02, 0x76, 0x40, 0xb4,
      0x06, 0x30, 0x72, 0xa3, 0xe5, 0xb1, 0x4c, 0x86, 0x00, 0x25, 0xa2, 0x19,
      0xe7, 0x24, 0xb8, 0x18, 0x14, 0x90, 0x1a, 0x67, 0x7a, 0x8b, 0xee, 0x9b,
      0x71, 0x6b, 0x33, 0xb1, 0x6a, 0x5b, 0x65, 0xf2, 0x27, 0x29, 0x56, 0xa4,
      0x6b, 0x5e, 0x86, 0x83, 0xdc, 0x89, 0x69, 0x84, 0x30, 0x9a, 0xc7, 0x94,
      0x49, 0x65, 0x7a, 0x18, 0x95, 0xc9, 0xf6, 0x2b, 0xde, 0x99, 0xc7, 0xf5,
      0xe2, 0x4e, 0xd2, 0xde, 0xfb, 0xc9, 0xf8, 0xdd, 0xe3, 0x5e, 0xbd, 0x0b,
      0xdd, 0xc1},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: extreme value for k and s^-1
    // tcID: 417
    {SEC_OID_SHA512,
     417,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x43, 0x3c, 0x21, 0x90, 0x24, 0x27, 0x7e,
      0x7e, 0x68, 0x2f, 0xcb, 0x28, 0x81, 0x48, 0xc2, 0x82, 0x74, 0x74, 0x03,
      0x27, 0x9b, 0x1c, 0xcc, 0x06, 0x35, 0x2c, 0x6e, 0x55, 0x05, 0xd7, 0x69,
      0xbe, 0x97, 0xb3, 0xb2, 0x04, 0xda, 0x6e, 0xf5, 0x55, 0x07, 0xaa, 0x10,
      0x4a, 0x3a, 0x35, 0xc5, 0xaf, 0x41, 0xcf, 0x2f, 0xa3, 0x64, 0xd6, 0x0f,
      0xd9, 0x67, 0xf4, 0x3e, 0x39, 0x33, 0xba, 0x6d, 0x78, 0x3d, 0x02, 0x42,
      0x01, 0xb6, 0xdb, 0x6d, 0xb6, 0xdb, 0x6d, 0xb6, 0xdb, 0x6d, 0xb6, 0xdb,
      0x6d, 0xb6, 0xdb, 0x6d, 0xb6, 0xdb, 0x6d, 0xb6, 0xdb, 0x6d, 0xb6, 0xdb,
      0x6d, 0xb6, 0xdb, 0x6d, 0xb6, 0xdb, 0x6d, 0xb6, 0xdb, 0x68, 0xd8, 0x2a,
      0x2b, 0x03, 0x36, 0x28, 0xca, 0x12, 0xff, 0xd3, 0x6e, 0xd0, 0xd3, 0xbf,
      0x20, 0x69, 0x57, 0xc0, 0x63, 0xc2, 0xbf, 0x18, 0x3d, 0x71, 0x32, 0xf2,
      0x0a, 0xac, 0x7c, 0x79, 0x7a, 0x51},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0xbc, 0x19, 0xcf, 0x4b, 0x94, 0xbc, 0xd3, 0x41, 0x14,
      0xce, 0x83, 0xc5, 0xf1, 0xa7, 0xe0, 0x48, 0xe2, 0xfc, 0x4f, 0xd4, 0x57,
      0xd5, 0x7e, 0x39, 0xb3, 0xda, 0x29, 0xf4, 0x76, 0x6a, 0xcb, 0xae, 0xf1,
      0xc1, 0x0c, 0xb1, 0x3c, 0x79, 0x6a, 0x6f, 0xff, 0xb5, 0x6d, 0x6a, 0x39,
      0x2e, 0x47, 0xb6, 0xc7, 0x45, 0x22, 0xdf, 0x7f, 0xa0, 0x27, 0x54, 0xc3,
      0x3d, 0x95, 0xb1, 0xa9, 0xa3, 0xc9, 0x2a, 0x15, 0x00, 0xf5, 0x74, 0x4c,
      0x2b, 0xed, 0x30, 0x8c, 0xb4, 0xf4, 0x1b, 0x51, 0x2e, 0x63, 0x2c, 0xd0,
      0x1d, 0x27, 0x0e, 0xf1, 0xa0, 0xd3, 0xf4, 0x7e, 0xa7, 0x80, 0xe7, 0x3c,
      0x6a, 0x6c, 0x9e, 0xa6, 0xa9, 0x96, 0xfa, 0xef, 0x4d, 0x28, 0x28, 0x96,
      0xc6, 0x4f, 0xa5, 0x0f, 0x5b, 0x04, 0xe2, 0x04, 0xc5, 0x6b, 0x50, 0x4b,
      0xc1, 0x22, 0xff, 0xba, 0x7a, 0xea, 0x45, 0x74, 0xd7, 0xd7, 0xab, 0x63,
      0x03, 0xc0},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: extreme value for k
    // tcID: 418
    {SEC_OID_SHA512,
     418,
     {0x30, 0x81, 0x86, 0x02, 0x41, 0x43, 0x3c, 0x21, 0x90, 0x24, 0x27, 0x7e,
      0x7e, 0x68, 0x2f, 0xcb, 0x28, 0x81, 0x48, 0xc2, 0x82, 0x74, 0x74, 0x03,
      0x27, 0x9b, 0x1c, 0xcc, 0x06, 0x35, 0x2c, 0x6e, 0x55, 0x05, 0xd7, 0x69,
      0xbe, 0x97, 0xb3, 0xb2, 0x04, 0xda, 0x6e, 0xf5, 0x55, 0x07, 0xaa, 0x10,
      0x4a, 0x3a, 0x35, 0xc5, 0xaf, 0x41, 0xcf, 0x2f, 0xa3, 0x64, 0xd6, 0x0f,
      0xd9, 0x67, 0xf4, 0x3e, 0x39, 0x33, 0xba, 0x6d, 0x78, 0x3d, 0x02, 0x41,
      0x0e, 0xb1, 0x0e, 0x5a, 0xb9, 0x5f, 0x2f, 0x26, 0xa4, 0x07, 0x00, 0xb1,
      0x30, 0x0f, 0xb8, 0xc3, 0xc8, 0xd5, 0x38, 0x4f, 0xfb, 0xec, 0xf1, 0xfd,
      0xb9, 0xe1, 0x1e, 0x67, 0xcb, 0x7f, 0xd6, 0xa7, 0xf5, 0x03, 0xe6, 0xe2,
      0x5a, 0xc0, 0x9b, 0xb8, 0x8b, 0x6c, 0x39, 0x83, 0xdf, 0x76, 0x4d, 0x4d,
      0x72, 0xbc, 0x29, 0x20, 0xe2, 0x33, 0xf0, 0xf7, 0x97, 0x4a, 0x23, 0x4a,
      0x21, 0xb0, 0x0b, 0xb4, 0x47},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0x7b, 0x0e, 0xbc, 0xe0, 0x8b, 0x09, 0xf2, 0x1e, 0x30,
      0xd1, 0x5e, 0x0e, 0xdd, 0x9f, 0xcd, 0xf2, 0x4a, 0xb4, 0x83, 0x1e, 0xc8,
      0xa6, 0x5a, 0x3d, 0x1e, 0x38, 0xf7, 0x2b, 0x15, 0xf0, 0x11, 0x5d, 0xa6,
      0xed, 0x18, 0x85, 0xe4, 0x2f, 0xcf, 0xae, 0x31, 0xc0, 0x91, 0x4b, 0x71,
      0xe9, 0xdf, 0x2c, 0xd1, 0x06, 0xad, 0xc0, 0x39, 0xa8, 0x28, 0x10, 0xa9,
      0x29, 0x24, 0xdd, 0x15, 0x4d, 0xc0, 0x5d, 0xa3, 0x00, 0xc6, 0x14, 0xd1,
      0xaf, 0xc4, 0xf6, 0x3d, 0xe3, 0x80, 0x3b, 0xb5, 0x49, 0x0a, 0x34, 0xe1,
      0xe2, 0xfa, 0xb9, 0xeb, 0x78, 0x42, 0x2b, 0x21, 0xd3, 0x77, 0xfc, 0x0d,
      0x7f, 0x99, 0x1b, 0x93, 0x8c, 0x22, 0xf4, 0xd7, 0xdd, 0x66, 0x5f, 0x8d,
      0xd2, 0x1f, 0xad, 0xde, 0x43, 0x17, 0x2a, 0x55, 0xf8, 0x0d, 0x05, 0xcc,
      0x45, 0x57, 0xb6, 0x66, 0x3f, 0x9e, 0x7a, 0x3f, 0xe4, 0x90, 0xd2, 0x5c,
      0x55, 0x31},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: extreme value for k and edgecase s
    // tcID: 419
    {SEC_OID_SHA512,
     419,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xc6, 0x85, 0x8e, 0x06, 0xb7, 0x04,
      0x04, 0xe9, 0xcd, 0x9e, 0x3e, 0xcb, 0x66, 0x23, 0x95, 0xb4, 0x42, 0x9c,
      0x64, 0x81, 0x39, 0x05, 0x3f, 0xb5, 0x21, 0xf8, 0x28, 0xaf, 0x60, 0x6b,
      0x4d, 0x3d, 0xba, 0xa1, 0x4b, 0x5e, 0x77, 0xef, 0xe7, 0x59, 0x28, 0xfe,
      0x1d, 0xc1, 0x27, 0xa2, 0xff, 0xa8, 0xde, 0x33, 0x48, 0xb3, 0xc1, 0x85,
      0x6a, 0x42, 0x9b, 0xf9, 0x7e, 0x7e, 0x31, 0xc2, 0xe5, 0xbd, 0x66, 0x02,
      0x42, 0x00, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa8, 0xc5,
      0xd7, 0x82, 0x81, 0x3f, 0xba, 0x87, 0x79, 0x2a, 0x99, 0x55, 0xc2, 0xfd,
      0x03, 0x37, 0x45, 0x69, 0x3c, 0x98, 0x92, 0xd8, 0x89, 0x6d, 0x3a, 0x3e,
      0x7a, 0x92, 0x5f, 0x85, 0xbd, 0x76, 0xad},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x04, 0xc3, 0xec, 0x8d, 0x7d, 0x23, 0xce, 0x74, 0xbe,
      0x8b, 0x9c, 0x7c, 0x27, 0xbe, 0x86, 0x9c, 0x23, 0xba, 0xfc, 0x68, 0x74,
      0xeb, 0xc4, 0x4f, 0x47, 0xe1, 0x07, 0x42, 0x2a, 0xb1, 0xe7, 0x5e, 0xd0,
      0x9b, 0xeb, 0xd7, 0xcb, 0x1e, 0xc4, 0x62, 0x6e, 0x44, 0x2b, 0xcf, 0x51,
      0x2a, 0x25, 0xc5, 0xdd, 0xde, 0x26, 0xeb, 0x08, 0xba, 0x37, 0x50, 0x64,
      0x61, 0x83, 0x0c, 0xf9, 0x24, 0x1c, 0xbe, 0x9c, 0x00, 0x50, 0xa1, 0xbc,
      0x08, 0xf4, 0xba, 0x8d, 0xa1, 0xd6, 0x41, 0xac, 0x38, 0x91, 0x82, 0x3a,
      0xb5, 0x19, 0xfa, 0xcd, 0x41, 0x59, 0x76, 0x8b, 0x1c, 0x07, 0x38, 0xf0,
      0xe2, 0x34, 0x50, 0xf3, 0x74, 0xe4, 0xd6, 0xde, 0x55, 0xcc, 0xee, 0xd9,
      0x57, 0x22, 0xbe, 0x63, 0x5c, 0x5d, 0xc0, 0x02, 0x3a, 0x14, 0x98, 0x86,
      0x2f, 0x87, 0xbf, 0xe6, 0x1d, 0x77, 0xe2, 0x0e, 0x59, 0x2c, 0xc2, 0x0b,
      0xb2, 0xca},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: extreme value for k and s^-1
    // tcID: 420
    {SEC_OID_SHA512,
     420,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x00, 0xc6, 0x85, 0x8e, 0x06, 0xb7, 0x04,
      0x04, 0xe9, 0xcd, 0x9e, 0x3e, 0xcb, 0x66, 0x23, 0x95, 0xb4, 0x42, 0x9c,
      0x64, 0x81, 0x39, 0x05, 0x3f, 0xb5, 0x21, 0xf8, 0x28, 0xaf, 0x60, 0x6b,
      0x4d, 0x3d, 0xba, 0xa1, 0x4b, 0x5e, 0x77, 0xef, 0xe7, 0x59, 0x28, 0xfe,
      0x1d, 0xc1, 0x27, 0xa2, 0xff, 0xa8, 0xde, 0x33, 0x48, 0xb3, 0xc1, 0x85,
      0x6a, 0x42, 0x9b, 0xf9, 0x7e, 0x7e, 0x31, 0xc2, 0xe5, 0xbd, 0x66, 0x02,
      0x41, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24,
      0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24,
      0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x91, 0x79, 0x5c,
      0x5c, 0x80, 0x89, 0x06, 0xcc, 0x58, 0x7f, 0xf8, 0x92, 0x78, 0x23, 0x4a,
      0x85, 0x66, 0xe3, 0xf5, 0x65, 0xf5, 0xca, 0x84, 0x0a, 0x3d, 0x88, 0x7d,
      0xac, 0x72, 0x14, 0xbe, 0xe9, 0xb8},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0xa7, 0xc8, 0x20, 0x4f, 0x28, 0x64, 0xdc, 0xef, 0x08,
      0x91, 0x65, 0xc3, 0x91, 0x4d, 0xcc, 0x2c, 0x08, 0x96, 0x07, 0x58, 0x70,
      0xca, 0x0b, 0xc1, 0xce, 0x37, 0x85, 0x6f, 0x80, 0xf2, 0x38, 0x15, 0xb0,
      0xc8, 0xf2, 0xec, 0x05, 0x14, 0x5c, 0x42, 0x10, 0x49, 0xe8, 0x0e, 0xc1,
      0xe7, 0x69, 0x4f, 0x9f, 0x04, 0x17, 0x4b, 0xbe, 0xf2, 0x1b, 0xc0, 0x97,
      0x2e, 0x55, 0x9c, 0xf2, 0x22, 0xde, 0x7e, 0x1a, 0x01, 0xff, 0x11, 0x08,
      0xc2, 0x8f, 0x01, 0xb7, 0x03, 0x82, 0x0e, 0x1c, 0x01, 0x87, 0x91, 0x29,
      0x62, 0xab, 0x23, 0x10, 0x96, 0x18, 0xdf, 0xcb, 0x0c, 0x06, 0x2c, 0xce,
      0xe3, 0x39, 0x00, 0x22, 0x22, 0xa3, 0xf7, 0xdd, 0x8d, 0xd2, 0x16, 0x75,
      0xb0, 0xe2, 0x09, 0x08, 0xfe, 0x58, 0x55, 0xea, 0x87, 0x6d, 0x6a, 0x9e,
      0x02, 0xc5, 0xf5, 0xb7, 0x93, 0xd3, 0x8f, 0xdf, 0x79, 0xfb, 0x83, 0x60,
      0x3e, 0xa9},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: extreme value for k and s^-1
    // tcID: 421
    {SEC_OID_SHA512,
     421,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xc6, 0x85, 0x8e, 0x06, 0xb7, 0x04,
      0x04, 0xe9, 0xcd, 0x9e, 0x3e, 0xcb, 0x66, 0x23, 0x95, 0xb4, 0x42, 0x9c,
      0x64, 0x81, 0x39, 0x05, 0x3f, 0xb5, 0x21, 0xf8, 0x28, 0xaf, 0x60, 0x6b,
      0x4d, 0x3d, 0xba, 0xa1, 0x4b, 0x5e, 0x77, 0xef, 0xe7, 0x59, 0x28, 0xfe,
      0x1d, 0xc1, 0x27, 0xa2, 0xff, 0xa8, 0xde, 0x33, 0x48, 0xb3, 0xc1, 0x85,
      0x6a, 0x42, 0x9b, 0xf9, 0x7e, 0x7e, 0x31, 0xc2, 0xe5, 0xbd, 0x66, 0x02,
      0x42, 0x01, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
      0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
      0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x95, 0x0e,
      0x05, 0x39, 0x36, 0x32, 0x8c, 0x78, 0x55, 0xff, 0xd6, 0x67, 0x6d, 0x92,
      0x6e, 0x1e, 0x40, 0x2f, 0xc4, 0xa1, 0x60, 0x6e, 0x16, 0x9f, 0xbe, 0xfc,
      0x59, 0x5f, 0x4b, 0xa7, 0x60, 0x50, 0x07},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0x80, 0x2f, 0xc7, 0x9f, 0xc8, 0xe5, 0x5b, 0xce, 0x50,
      0xa5, 0x81, 0x63, 0x2b, 0x51, 0xd6, 0xee, 0xc0, 0x4a, 0x3c, 0x74, 0xac,
      0x2b, 0xf4, 0xfa, 0xe1, 0x6c, 0xe6, 0xc7, 0xef, 0xef, 0x17, 0x01, 0xd6,
      0x9f, 0x9c, 0x00, 0xa9, 0x1a, 0xd5, 0x21, 0xd7, 0x5a, 0xc7, 0x53, 0x9d,
      0x54, 0xbf, 0x46, 0x4c, 0xae, 0xec, 0x87, 0x14, 0x56, 0x10, 0x3d, 0xc9,
      0x74, 0x35, 0x44, 0x60, 0x89, 0x8a, 0x19, 0xc6, 0x00, 0x72, 0x2f, 0xc1,
      0xf5, 0x28, 0x50, 0x66, 0x18, 0xb1, 0xda, 0x9f, 0x8b, 0x2e, 0xdb, 0xdb,
      0xda, 0xf7, 0xee, 0xc0, 0x2e, 0x8f, 0xb9, 0x20, 0x3d, 0x2b, 0x27, 0x77,
      0x35, 0xa1, 0xd8, 0x67, 0x91, 0x1b, 0x13, 0x1f, 0x45, 0x3f, 0x52, 0xcc,
      0xc4, 0xce, 0xd0, 0x5c, 0x3b, 0x1b, 0xc2, 0x9e, 0x4d, 0x20, 0xf1, 0xe6,
      0xd3, 0x49, 0x79, 0xfa, 0xa6, 0x88, 0xce, 0x80, 0x03, 0xf7, 0x9d, 0x8e,
      0x0c, 0x95},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: extreme value for k and s^-1
    // tcID: 422
    {SEC_OID_SHA512,
     422,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x00, 0xc6, 0x85, 0x8e, 0x06, 0xb7, 0x04,
      0x04, 0xe9, 0xcd, 0x9e, 0x3e, 0xcb, 0x66, 0x23, 0x95, 0xb4, 0x42, 0x9c,
      0x64, 0x81, 0x39, 0x05, 0x3f, 0xb5, 0x21, 0xf8, 0x28, 0xaf, 0x60, 0x6b,
      0x4d, 0x3d, 0xba, 0xa1, 0x4b, 0x5e, 0x77, 0xef, 0xe7, 0x59, 0x28, 0xfe,
      0x1d, 0xc1, 0x27, 0xa2, 0xff, 0xa8, 0xde, 0x33, 0x48, 0xb3, 0xc1, 0x85,
      0x6a, 0x42, 0x9b, 0xf9, 0x7e, 0x7e, 0x31, 0xc2, 0xe5, 0xbd, 0x66, 0x02,
      0x41, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
      0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
      0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x65, 0x43, 0x81,
      0x4e, 0x4d, 0x8c, 0xa3, 0x1e, 0x15, 0x7f, 0xf5, 0x99, 0xdb, 0x64, 0x9b,
      0x87, 0x90, 0x0b, 0xf1, 0x28, 0x58, 0x1b, 0x85, 0xa7, 0xef, 0xbf, 0x16,
      0x57, 0xd2, 0xe9, 0xd8, 0x14, 0x02},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0xbe, 0xb0, 0xb4, 0xc2, 0xe4, 0x94, 0x22, 0x64, 0x04,
      0xfc, 0xa4, 0xad, 0x50, 0x5e, 0xbf, 0xed, 0x13, 0xd1, 0x84, 0xb1, 0x57,
      0x26, 0x83, 0x21, 0x5b, 0x16, 0x17, 0x3c, 0x29, 0xa4, 0x47, 0x5a, 0xed,
      0xe4, 0x7f, 0x26, 0x6e, 0x0c, 0x9c, 0x41, 0x43, 0x13, 0x7d, 0x3e, 0x00,
      0x01, 0xf9, 0xf0, 0x14, 0x8b, 0x68, 0x92, 0x86, 0xa7, 0xc6, 0x4e, 0x22,
      0x94, 0x58, 0xb8, 0x24, 0xed, 0x76, 0x58, 0x36, 0x01, 0x30, 0x20, 0x51,
      0x69, 0x78, 0x3e, 0xd9, 0xad, 0xa9, 0xf3, 0xa1, 0x93, 0x02, 0x7a, 0xe4,
      0xe2, 0x18, 0x29, 0xad, 0x4a, 0x71, 0xd0, 0x5d, 0x96, 0x96, 0x05, 0xc0,
      0x4f, 0x32, 0x31, 0xda, 0xba, 0xb0, 0x3b, 0xeb, 0x2f, 0xab, 0x07, 0xdd,
      0x83, 0x23, 0xd7, 0x13, 0x27, 0x55, 0x73, 0x4f, 0x4e, 0x6d, 0x1f, 0xb4,
      0x3f, 0xc8, 0xa6, 0x3b, 0xfd, 0x24, 0x41, 0x60, 0xc2, 0x3e, 0xfb, 0x6c,
      0x14, 0x29},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: extreme value for k and s^-1
    // tcID: 423
    {SEC_OID_SHA512,
     423,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xc6, 0x85, 0x8e, 0x06, 0xb7, 0x04,
      0x04, 0xe9, 0xcd, 0x9e, 0x3e, 0xcb, 0x66, 0x23, 0x95, 0xb4, 0x42, 0x9c,
      0x64, 0x81, 0x39, 0x05, 0x3f, 0xb5, 0x21, 0xf8, 0x28, 0xaf, 0x60, 0x6b,
      0x4d, 0x3d, 0xba, 0xa1, 0x4b, 0x5e, 0x77, 0xef, 0xe7, 0x59, 0x28, 0xfe,
      0x1d, 0xc1, 0x27, 0xa2, 0xff, 0xa8, 0xde, 0x33, 0x48, 0xb3, 0xc1, 0x85,
      0x6a, 0x42, 0x9b, 0xf9, 0x7e, 0x7e, 0x31, 0xc2, 0xe5, 0xbd, 0x66, 0x02,
      0x42, 0x01, 0xb6, 0xdb, 0x6d, 0xb6, 0xdb, 0x6d, 0xb6, 0xdb, 0x6d, 0xb6,
      0xdb, 0x6d, 0xb6, 0xdb, 0x6d, 0xb6, 0xdb, 0x6d, 0xb6, 0xdb, 0x6d, 0xb6,
      0xdb, 0x6d, 0xb6, 0xdb, 0x6d, 0xb6, 0xdb, 0x6d, 0xb6, 0xdb, 0x68, 0xd8,
      0x2a, 0x2b, 0x03, 0x36, 0x28, 0xca, 0x12, 0xff, 0xd3, 0x6e, 0xd0, 0xd3,
      0xbf, 0x20, 0x69, 0x57, 0xc0, 0x63, 0xc2, 0xbf, 0x18, 0x3d, 0x71, 0x32,
      0xf2, 0x0a, 0xac, 0x7c, 0x79, 0x7a, 0x51},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0x21, 0xe5, 0x9a, 0xaf, 0x26, 0xb8, 0x30, 0x1f, 0x4f,
      0xcc, 0x3e, 0x0a, 0x56, 0x3c, 0x41, 0x04, 0xae, 0x00, 0xb4, 0x7c, 0x55,
      0xb8, 0x94, 0x5c, 0xe7, 0x49, 0x11, 0x6f, 0xdf, 0x67, 0x61, 0xd7, 0x68,
      0xbd, 0x50, 0xed, 0x43, 0x1e, 0x2b, 0x51, 0xe6, 0x46, 0xfe, 0x4f, 0xe7,
      0xdc, 0x29, 0x85, 0xb6, 0xae, 0xfa, 0x7f, 0x94, 0x41, 0xea, 0x11, 0x84,
      0x0d, 0x2a, 0xce, 0x2f, 0x34, 0x29, 0x3c, 0xb1, 0x00, 0x0c, 0xf1, 0xe1,
      0xa4, 0x6d, 0x4d, 0x63, 0x72, 0x16, 0xe2, 0x8a, 0xbd, 0x12, 0x4c, 0xc6,
      0x41, 0xae, 0x7a, 0x67, 0x34, 0x45, 0xd5, 0x73, 0x85, 0x6b, 0xc2, 0xfe,
      0xc5, 0x8d, 0x86, 0xe5, 0xed, 0x63, 0xbc, 0x2a, 0x7f, 0x20, 0x49, 0x23,
      0x4e, 0x33, 0x5a, 0x7b, 0xee, 0x95, 0xbb, 0x27, 0x24, 0xfb, 0x14, 0x80,
      0xc9, 0x7c, 0x38, 0xcd, 0x0d, 0x29, 0x6c, 0xbc, 0xc1, 0x13, 0xde, 0x3f,
      0x13, 0x5f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: extreme value for k
    // tcID: 424
    {SEC_OID_SHA512,
     424,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x00, 0xc6, 0x85, 0x8e, 0x06, 0xb7, 0x04,
      0x04, 0xe9, 0xcd, 0x9e, 0x3e, 0xcb, 0x66, 0x23, 0x95, 0xb4, 0x42, 0x9c,
      0x64, 0x81, 0x39, 0x05, 0x3f, 0xb5, 0x21, 0xf8, 0x28, 0xaf, 0x60, 0x6b,
      0x4d, 0x3d, 0xba, 0xa1, 0x4b, 0x5e, 0x77, 0xef, 0xe7, 0x59, 0x28, 0xfe,
      0x1d, 0xc1, 0x27, 0xa2, 0xff, 0xa8, 0xde, 0x33, 0x48, 0xb3, 0xc1, 0x85,
      0x6a, 0x42, 0x9b, 0xf9, 0x7e, 0x7e, 0x31, 0xc2, 0xe5, 0xbd, 0x66, 0x02,
      0x41, 0x0e, 0xb1, 0x0e, 0x5a, 0xb9, 0x5f, 0x2f, 0x26, 0xa4, 0x07, 0x00,
      0xb1, 0x30, 0x0f, 0xb8, 0xc3, 0xc8, 0xd5, 0x38, 0x4f, 0xfb, 0xec, 0xf1,
      0xfd, 0xb9, 0xe1, 0x1e, 0x67, 0xcb, 0x7f, 0xd6, 0xa7, 0xf5, 0x03, 0xe6,
      0xe2, 0x5a, 0xc0, 0x9b, 0xb8, 0x8b, 0x6c, 0x39, 0x83, 0xdf, 0x76, 0x4d,
      0x4d, 0x72, 0xbc, 0x29, 0x20, 0xe2, 0x33, 0xf0, 0xf7, 0x97, 0x4a, 0x23,
      0x4a, 0x21, 0xb0, 0x0b, 0xb4, 0x47},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x8e, 0x85, 0x9e, 0x66, 0xd1, 0x23, 0x7f, 0xdc, 0x92,
      0x8a, 0x4b, 0x95, 0x49, 0x54, 0xfe, 0xf5, 0x65, 0xd2, 0x03, 0xa0, 0x73,
      0x1d, 0x06, 0x5d, 0x9d, 0xf4, 0x1a, 0x4f, 0xd3, 0x81, 0x2b, 0x1c, 0xc2,
      0x48, 0x70, 0x53, 0xea, 0x19, 0xce, 0x83, 0x9d, 0x20, 0x08, 0x45, 0x95,
      0x2f, 0x80, 0xd8, 0x06, 0x98, 0x77, 0x1d, 0x83, 0xcc, 0xc1, 0xfc, 0x7f,
      0x23, 0x6d, 0xbe, 0xe4, 0xc7, 0x6b, 0x2b, 0xb4, 0x00, 0x5a, 0x04, 0xb2,
      0x4c, 0x88, 0xcd, 0x40, 0x23, 0x3f, 0xb4, 0x3c, 0x59, 0xea, 0x5c, 0xf2,
      0xcb, 0x95, 0x10, 0xd1, 0x6b, 0x11, 0x68, 0xbc, 0x12, 0x6d, 0xb6, 0x4a,
      0xaf, 0x9a, 0xb0, 0x7a, 0x74, 0x53, 0x20, 0x8f, 0xde, 0x07, 0x90, 0x95,
      0x96, 0x62, 0x72, 0xbf, 0x03, 0xbc, 0x33, 0x12, 0xc9, 0xb9, 0xba, 0xb8,
      0xc7, 0x95, 0xae, 0x37, 0x5e, 0x8a, 0x0e, 0x8d, 0xd8, 0x1c, 0x92, 0x4e,
      0x7c, 0x27},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: testing point duplication
    // tcID: 425
    {SEC_OID_SHA512,
     425,
     {0x30, 0x81, 0x85, 0x02, 0x40, 0x43, 0xf8, 0x00, 0xfb, 0xea, 0xf9, 0x23,
      0x8c, 0x58, 0xaf, 0x79, 0x5b, 0xcd, 0xad, 0x04, 0xbc, 0x49, 0xcd, 0x85,
      0x0c, 0x39, 0x4d, 0x33, 0x82, 0x95, 0x33, 0x56, 0xb0, 0x23, 0x21, 0x02,
      0x81, 0x75, 0x7b, 0x30, 0xe1, 0x92, 0x18, 0xa3, 0x7c, 0xbd, 0x61, 0x20,
      0x86, 0xfb, 0xc1, 0x58, 0xca, 0xa8, 0xb4, 0xe1, 0xac, 0xb2, 0xec, 0x00,
      0x83, 0x7e, 0x5d, 0x94, 0x1f, 0x34, 0x2f, 0xb3, 0xcc, 0x02, 0x41, 0x49,
      0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49,
      0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49,
      0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x91, 0x79, 0x5c, 0x5c, 0x80,
      0x89, 0x06, 0xcc, 0x58, 0x7f, 0xf8, 0x92, 0x78, 0x23, 0x4a, 0x85, 0x66,
      0xe3, 0xf5, 0x65, 0xf5, 0xca, 0x84, 0x0a, 0x3d, 0x88, 0x7d, 0xac, 0x72,
      0x14, 0xbe, 0xe9, 0xb8},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0xc6, 0x85, 0x8e, 0x06, 0xb7, 0x04, 0x04, 0xe9, 0xcd,
      0x9e, 0x3e, 0xcb, 0x66, 0x23, 0x95, 0xb4, 0x42, 0x9c, 0x64, 0x81, 0x39,
      0x05, 0x3f, 0xb5, 0x21, 0xf8, 0x28, 0xaf, 0x60, 0x6b, 0x4d, 0x3d, 0xba,
      0xa1, 0x4b, 0x5e, 0x77, 0xef, 0xe7, 0x59, 0x28, 0xfe, 0x1d, 0xc1, 0x27,
      0xa2, 0xff, 0xa8, 0xde, 0x33, 0x48, 0xb3, 0xc1, 0x85, 0x6a, 0x42, 0x9b,
      0xf9, 0x7e, 0x7e, 0x31, 0xc2, 0xe5, 0xbd, 0x66, 0x01, 0x18, 0x39, 0x29,
      0x6a, 0x78, 0x9a, 0x3b, 0xc0, 0x04, 0x5c, 0x8a, 0x5f, 0xb4, 0x2c, 0x7d,
      0x1b, 0xd9, 0x98, 0xf5, 0x44, 0x49, 0x57, 0x9b, 0x44, 0x68, 0x17, 0xaf,
      0xbd, 0x17, 0x27, 0x3e, 0x66, 0x2c, 0x97, 0xee, 0x72, 0x99, 0x5e, 0xf4,
      0x26, 0x40, 0xc5, 0x50, 0xb9, 0x01, 0x3f, 0xad, 0x07, 0x61, 0x35, 0x3c,
      0x70, 0x86, 0xa2, 0x72, 0xc2, 0x40, 0x88, 0xbe, 0x94, 0x76, 0x9f, 0xd1,
      0x66, 0x50},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: testing point duplication
    // tcID: 426
    {SEC_OID_SHA512,
     426,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x01, 0xff, 0xbc, 0x07, 0xff, 0x04, 0x15,
      0x06, 0xdc, 0x73, 0xa7, 0x50, 0x86, 0xa4, 0x32, 0x52, 0xfb, 0x43, 0xb6,
      0x32, 0x7a, 0xf3, 0xc6, 0xb2, 0xcc, 0x7d, 0x6a, 0xcc, 0xa9, 0x4f, 0xdc,
      0xde, 0xfd, 0x78, 0xdc, 0x0b, 0x56, 0xa2, 0x2d, 0x16, 0xf2, 0xee, 0xc2,
      0x6a, 0xe0, 0xc1, 0xfb, 0x48, 0x4d, 0x05, 0x93, 0x00, 0xe8, 0x0b, 0xd6,
      0xb0, 0x47, 0x2b, 0x3d, 0x12, 0x22, 0xff, 0x5d, 0x08, 0xb0, 0x3d, 0x02,
      0x41, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24,
      0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24,
      0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x91, 0x79, 0x5c,
      0x5c, 0x80, 0x89, 0x06, 0xcc, 0x58, 0x7f, 0xf8, 0x92, 0x78, 0x23, 0x4a,
      0x85, 0x66, 0xe3, 0xf5, 0x65, 0xf5, 0xca, 0x84, 0x0a, 0x3d, 0x88, 0x7d,
      0xac, 0x72, 0x14, 0xbe, 0xe9, 0xb8},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0xc6, 0x85, 0x8e, 0x06, 0xb7, 0x04, 0x04, 0xe9, 0xcd,
      0x9e, 0x3e, 0xcb, 0x66, 0x23, 0x95, 0xb4, 0x42, 0x9c, 0x64, 0x81, 0x39,
      0x05, 0x3f, 0xb5, 0x21, 0xf8, 0x28, 0xaf, 0x60, 0x6b, 0x4d, 0x3d, 0xba,
      0xa1, 0x4b, 0x5e, 0x77, 0xef, 0xe7, 0x59, 0x28, 0xfe, 0x1d, 0xc1, 0x27,
      0xa2, 0xff, 0xa8, 0xde, 0x33, 0x48, 0xb3, 0xc1, 0x85, 0x6a, 0x42, 0x9b,
      0xf9, 0x7e, 0x7e, 0x31, 0xc2, 0xe5, 0xbd, 0x66, 0x01, 0x18, 0x39, 0x29,
      0x6a, 0x78, 0x9a, 0x3b, 0xc0, 0x04, 0x5c, 0x8a, 0x5f, 0xb4, 0x2c, 0x7d,
      0x1b, 0xd9, 0x98, 0xf5, 0x44, 0x49, 0x57, 0x9b, 0x44, 0x68, 0x17, 0xaf,
      0xbd, 0x17, 0x27, 0x3e, 0x66, 0x2c, 0x97, 0xee, 0x72, 0x99, 0x5e, 0xf4,
      0x26, 0x40, 0xc5, 0x50, 0xb9, 0x01, 0x3f, 0xad, 0x07, 0x61, 0x35, 0x3c,
      0x70, 0x86, 0xa2, 0x72, 0xc2, 0x40, 0x88, 0xbe, 0x94, 0x76, 0x9f, 0xd1,
      0x66, 0x50},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: testing point duplication
    // tcID: 427
    {SEC_OID_SHA512,
     427,
     {0x30, 0x81, 0x85, 0x02, 0x40, 0x43, 0xf8, 0x00, 0xfb, 0xea, 0xf9, 0x23,
      0x8c, 0x58, 0xaf, 0x79, 0x5b, 0xcd, 0xad, 0x04, 0xbc, 0x49, 0xcd, 0x85,
      0x0c, 0x39, 0x4d, 0x33, 0x82, 0x95, 0x33, 0x56, 0xb0, 0x23, 0x21, 0x02,
      0x81, 0x75, 0x7b, 0x30, 0xe1, 0x92, 0x18, 0xa3, 0x7c, 0xbd, 0x61, 0x20,
      0x86, 0xfb, 0xc1, 0x58, 0xca, 0xa8, 0xb4, 0xe1, 0xac, 0xb2, 0xec, 0x00,
      0x83, 0x7e, 0x5d, 0x94, 0x1f, 0x34, 0x2f, 0xb3, 0xcc, 0x02, 0x41, 0x49,
      0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49,
      0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49,
      0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x91, 0x79, 0x5c, 0x5c, 0x80,
      0x89, 0x06, 0xcc, 0x58, 0x7f, 0xf8, 0x92, 0x78, 0x23, 0x4a, 0x85, 0x66,
      0xe3, 0xf5, 0x65, 0xf5, 0xca, 0x84, 0x0a, 0x3d, 0x88, 0x7d, 0xac, 0x72,
      0x14, 0xbe, 0xe9, 0xb8},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0xc6, 0x85, 0x8e, 0x06, 0xb7, 0x04, 0x04, 0xe9, 0xcd,
      0x9e, 0x3e, 0xcb, 0x66, 0x23, 0x95, 0xb4, 0x42, 0x9c, 0x64, 0x81, 0x39,
      0x05, 0x3f, 0xb5, 0x21, 0xf8, 0x28, 0xaf, 0x60, 0x6b, 0x4d, 0x3d, 0xba,
      0xa1, 0x4b, 0x5e, 0x77, 0xef, 0xe7, 0x59, 0x28, 0xfe, 0x1d, 0xc1, 0x27,
      0xa2, 0xff, 0xa8, 0xde, 0x33, 0x48, 0xb3, 0xc1, 0x85, 0x6a, 0x42, 0x9b,
      0xf9, 0x7e, 0x7e, 0x31, 0xc2, 0xe5, 0xbd, 0x66, 0x00, 0xe7, 0xc6, 0xd6,
      0x95, 0x87, 0x65, 0xc4, 0x3f, 0xfb, 0xa3, 0x75, 0xa0, 0x4b, 0xd3, 0x82,
      0xe4, 0x26, 0x67, 0x0a, 0xbb, 0xb6, 0xa8, 0x64, 0xbb, 0x97, 0xe8, 0x50,
      0x42, 0xe8, 0xd8, 0xc1, 0x99, 0xd3, 0x68, 0x11, 0x8d, 0x66, 0xa1, 0x0b,
      0xd9, 0xbf, 0x3a, 0xaf, 0x46, 0xfe, 0xc0, 0x52, 0xf8, 0x9e, 0xca, 0xc3,
      0x8f, 0x79, 0x5d, 0x8d, 0x3d, 0xbf, 0x77, 0x41, 0x6b, 0x89, 0x60, 0x2e,
      0x99, 0xaf},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: testing point duplication
    // tcID: 428
    {SEC_OID_SHA512,
     428,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x01, 0xff, 0xbc, 0x07, 0xff, 0x04, 0x15,
      0x06, 0xdc, 0x73, 0xa7, 0x50, 0x86, 0xa4, 0x32, 0x52, 0xfb, 0x43, 0xb6,
      0x32, 0x7a, 0xf3, 0xc6, 0xb2, 0xcc, 0x7d, 0x6a, 0xcc, 0xa9, 0x4f, 0xdc,
      0xde, 0xfd, 0x78, 0xdc, 0x0b, 0x56, 0xa2, 0x2d, 0x16, 0xf2, 0xee, 0xc2,
      0x6a, 0xe0, 0xc1, 0xfb, 0x48, 0x4d, 0x05, 0x93, 0x00, 0xe8, 0x0b, 0xd6,
      0xb0, 0x47, 0x2b, 0x3d, 0x12, 0x22, 0xff, 0x5d, 0x08, 0xb0, 0x3d, 0x02,
      0x41, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24,
      0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24,
      0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x91, 0x79, 0x5c,
      0x5c, 0x80, 0x89, 0x06, 0xcc, 0x58, 0x7f, 0xf8, 0x92, 0x78, 0x23, 0x4a,
      0x85, 0x66, 0xe3, 0xf5, 0x65, 0xf5, 0xca, 0x84, 0x0a, 0x3d, 0x88, 0x7d,
      0xac, 0x72, 0x14, 0xbe, 0xe9, 0xb8},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0xc6, 0x85, 0x8e, 0x06, 0xb7, 0x04, 0x04, 0xe9, 0xcd,
      0x9e, 0x3e, 0xcb, 0x66, 0x23, 0x95, 0xb4, 0x42, 0x9c, 0x64, 0x81, 0x39,
      0x05, 0x3f, 0xb5, 0x21, 0xf8, 0x28, 0xaf, 0x60, 0x6b, 0x4d, 0x3d, 0xba,
      0xa1, 0x4b, 0x5e, 0x77, 0xef, 0xe7, 0x59, 0x28, 0xfe, 0x1d, 0xc1, 0x27,
      0xa2, 0xff, 0xa8, 0xde, 0x33, 0x48, 0xb3, 0xc1, 0x85, 0x6a, 0x42, 0x9b,
      0xf9, 0x7e, 0x7e, 0x31, 0xc2, 0xe5, 0xbd, 0x66, 0x00, 0xe7, 0xc6, 0xd6,
      0x95, 0x87, 0x65, 0xc4, 0x3f, 0xfb, 0xa3, 0x75, 0xa0, 0x4b, 0xd3, 0x82,
      0xe4, 0x26, 0x67, 0x0a, 0xbb, 0xb6, 0xa8, 0x64, 0xbb, 0x97, 0xe8, 0x50,
      0x42, 0xe8, 0xd8, 0xc1, 0x99, 0xd3, 0x68, 0x11, 0x8d, 0x66, 0xa1, 0x0b,
      0xd9, 0xbf, 0x3a, 0xaf, 0x46, 0xfe, 0xc0, 0x52, 0xf8, 0x9e, 0xca, 0xc3,
      0x8f, 0x79, 0x5d, 0x8d, 0x3d, 0xbf, 0x77, 0x41, 0x6b, 0x89, 0x60, 0x2e,
      0x99, 0xaf},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: pseudorandom signature
    // tcID: 429
    {SEC_OID_SHA512,
     429,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x62, 0x5d, 0x61, 0x15, 0x09, 0x2a,
      0x8e, 0x2e, 0xe2, 0x1b, 0x9f, 0x8a, 0x42, 0x5a, 0xa7, 0x38, 0x14, 0xde,
      0xc8, 0xb2, 0x33, 0x5e, 0x86, 0x15, 0x0a, 0xb4, 0x22, 0x9f, 0x5a, 0x34,
      0x21, 0xd2, 0xe6, 0x25, 0x6d, 0x63, 0x2c, 0x7a, 0x43, 0x65, 0xa1, 0xee,
      0x01, 0xdd, 0x2a, 0x93, 0x69, 0x21, 0xbb, 0xb4, 0x55, 0x1a, 0x51, 0x2d,
      0x1d, 0x4b, 0x5a, 0x56, 0xc3, 0x14, 0xe4, 0xa0, 0x25, 0x34, 0xc5, 0x02,
      0x42, 0x01, 0xb7, 0x92, 0xd2, 0x3f, 0x26, 0x49, 0x86, 0x25, 0x95, 0x45,
      0x10, 0x55, 0x77, 0x7b, 0xda, 0x1b, 0x02, 0xdc, 0x6c, 0xc8, 0xfe, 0xf2,
      0x32, 0x31, 0xe4, 0x4b, 0x92, 0x1b, 0x16, 0x15, 0x5c, 0xd4, 0x22, 0x57,
      0x44, 0x1d, 0x75, 0xa7, 0x90, 0x37, 0x1e, 0x91, 0x81, 0x9f, 0x0a, 0x9b,
      0x1f, 0xd0, 0xeb, 0xd0, 0x2c, 0x90, 0xb5, 0xb7, 0x74, 0x52, 0x77, 0x46,
      0xed, 0x9b, 0xfe, 0x74, 0x3d, 0xbe, 0x2f},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0x2a, 0x90, 0x8b, 0xfc, 0x5b, 0x70, 0xe1, 0x7b, 0xdf,
      0xae, 0x74, 0x29, 0x49, 0x94, 0x80, 0x8b, 0xf2, 0xa4, 0x2d, 0xab, 0x59,
      0xaf, 0x8b, 0x05, 0x23, 0xa0, 0x26, 0xd6, 0x40, 0xa2, 0xa3, 0xd6, 0xd3,
      0x44, 0x52, 0x0b, 0x62, 0x17, 0x7e, 0x2c, 0xfa, 0x33, 0x9c, 0xa4, 0x2f,
      0xb0, 0x88, 0x3e, 0xc4, 0x25, 0x90, 0x4f, 0xbd, 0xa2, 0x83, 0x3a, 0x3b,
      0x5b, 0x0a, 0x9a, 0x00, 0x81, 0x13, 0x65, 0xd8, 0x01, 0x23, 0x33, 0xd5,
      0x32, 0xf8, 0xf8, 0xeb, 0x1a, 0x62, 0x3c, 0x37, 0x8a, 0x36, 0x94, 0x65,
      0x11, 0x92, 0xbb, 0xda, 0x83, 0x3e, 0x3b, 0x8d, 0x7b, 0x8f, 0x90, 0xb2,
      0xbf, 0xc9, 0xb0, 0x45, 0xf8, 0xa5, 0x5e, 0x1b, 0x6a, 0x5f, 0xe1, 0x51,
      0x2c, 0x40, 0x0c, 0x4b, 0xc9, 0xc8, 0x6f, 0xd7, 0xc6, 0x99, 0xd6, 0x42,
      0xf5, 0xce, 0xe9, 0xbb, 0x82, 0x7c, 0x8b, 0x0a, 0xbc, 0x0d, 0xa0, 0x1c,
      0xef, 0x1e},
     {},
     true},

    // Comment: pseudorandom signature
    // tcID: 430
    {SEC_OID_SHA512,
     430,
     {0x30, 0x81, 0x86, 0x02, 0x41, 0x5a, 0xdc, 0x83, 0x3c, 0xbc, 0x1d, 0x61,
      0x41, 0xce, 0xd4, 0x57, 0xba, 0xb2, 0xb0, 0x1b, 0x08, 0x14, 0x05, 0x4d,
      0x7a, 0x28, 0xfa, 0x8b, 0xb2, 0x92, 0x5d, 0x1e, 0x75, 0x25, 0xb7, 0xcf,
      0x7d, 0x5c, 0x93, 0x8a, 0x17, 0xab, 0xfb, 0x33, 0x42, 0x6d, 0xcc, 0x05,
      0xce, 0x8d, 0x44, 0xdb, 0x02, 0xf5, 0x3a, 0x75, 0xea, 0x04, 0x01, 0x7d,
      0xca, 0x51, 0xe1, 0xfb, 0xb1, 0x4c, 0xe3, 0x31, 0x1b, 0x14, 0x02, 0x41,
      0x5f, 0x69, 0xb2, 0xa6, 0xde, 0x12, 0x91, 0x47, 0xa8, 0x43, 0x7b, 0x79,
      0xc7, 0x23, 0x15, 0xd3, 0x51, 0x73, 0xd8, 0x8c, 0x2d, 0x61, 0x19, 0x08,
      0x5c, 0x90, 0xda, 0xe8, 0xec, 0x05, 0xc5, 0x5e, 0x06, 0x7e, 0x7d, 0xfa,
      0x4f, 0x68, 0x10, 0x35, 0xe3, 0xdc, 0xca, 0xb0, 0x99, 0x29, 0x1c, 0x0e,
      0xcf, 0x44, 0x28, 0x33, 0x2a, 0x9c, 0xb0, 0x73, 0x6d, 0x16, 0xe7, 0x91,
      0x11, 0xac, 0x76, 0xd7, 0x66},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0x2a, 0x90, 0x8b, 0xfc, 0x5b, 0x70, 0xe1, 0x7b, 0xdf,
      0xae, 0x74, 0x29, 0x49, 0x94, 0x80, 0x8b, 0xf2, 0xa4, 0x2d, 0xab, 0x59,
      0xaf, 0x8b, 0x05, 0x23, 0xa0, 0x26, 0xd6, 0x40, 0xa2, 0xa3, 0xd6, 0xd3,
      0x44, 0x52, 0x0b, 0x62, 0x17, 0x7e, 0x2c, 0xfa, 0x33, 0x9c, 0xa4, 0x2f,
      0xb0, 0x88, 0x3e, 0xc4, 0x25, 0x90, 0x4f, 0xbd, 0xa2, 0x83, 0x3a, 0x3b,
      0x5b, 0x0a, 0x9a, 0x00, 0x81, 0x13, 0x65, 0xd8, 0x01, 0x23, 0x33, 0xd5,
      0x32, 0xf8, 0xf8, 0xeb, 0x1a, 0x62, 0x3c, 0x37, 0x8a, 0x36, 0x94, 0x65,
      0x11, 0x92, 0xbb, 0xda, 0x83, 0x3e, 0x3b, 0x8d, 0x7b, 0x8f, 0x90, 0xb2,
      0xbf, 0xc9, 0xb0, 0x45, 0xf8, 0xa5, 0x5e, 0x1b, 0x6a, 0x5f, 0xe1, 0x51,
      0x2c, 0x40, 0x0c, 0x4b, 0xc9, 0xc8, 0x6f, 0xd7, 0xc6, 0x99, 0xd6, 0x42,
      0xf5, 0xce, 0xe9, 0xbb, 0x82, 0x7c, 0x8b, 0x0a, 0xbc, 0x0d, 0xa0, 0x1c,
      0xef, 0x1e},
     {0x4d, 0x73, 0x67},
     true},

    // Comment: pseudorandom signature
    // tcID: 431
    {SEC_OID_SHA512,
     431,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x41, 0x41, 0xe4, 0xd9, 0x4a, 0x58,
      0xc1, 0xe7, 0x47, 0xcb, 0xd9, 0xee, 0x66, 0x70, 0xa4, 0x1e, 0xac, 0x3c,
      0x26, 0xfb, 0x4d, 0xb3, 0x24, 0x8e, 0x45, 0xd5, 0x83, 0x17, 0x90, 0x76,
      0xe6, 0xb1, 0x9a, 0x8e, 0x20, 0x03, 0x65, 0x7a, 0x10, 0x8f, 0x91, 0xf9,
      0xa1, 0x03, 0x15, 0x7e, 0xdf, 0xf9, 0xb3, 0x7d, 0xf2, 0xb4, 0x36, 0xa7,
      0x7d, 0xc1, 0x12, 0x92, 0x7d, 0x90, 0x7a, 0xc9, 0xba, 0x25, 0x87, 0x02,
      0x42, 0x01, 0x08, 0xaf, 0xa9, 0x1b, 0x34, 0xbd, 0x90, 0x4c, 0x68, 0x04,
      0x71, 0xe9, 0x43, 0xaf, 0x33, 0x6f, 0xb9, 0x0c, 0x5f, 0xb2, 0xb9, 0x14,
      0x01, 0xa5, 0x8c, 0x9b, 0x1f, 0x46, 0x7b, 0xf8, 0x1a, 0xf8, 0x04, 0x99,
      0x65, 0xdd, 0x8b, 0x45, 0xf1, 0x2e, 0x15, 0x2f, 0x4f, 0x7f, 0xd3, 0x78,
      0x0e, 0x34, 0x92, 0xf3, 0x1e, 0xd2, 0x68, 0x0d, 0x47, 0x77, 0xfb, 0xe6,
      0x55, 0xfe, 0x77, 0x9a, 0xd8, 0x97, 0xab},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0x2a, 0x90, 0x8b, 0xfc, 0x5b, 0x70, 0xe1, 0x7b, 0xdf,
      0xae, 0x74, 0x29, 0x49, 0x94, 0x80, 0x8b, 0xf2, 0xa4, 0x2d, 0xab, 0x59,
      0xaf, 0x8b, 0x05, 0x23, 0xa0, 0x26, 0xd6, 0x40, 0xa2, 0xa3, 0xd6, 0xd3,
      0x44, 0x52, 0x0b, 0x62, 0x17, 0x7e, 0x2c, 0xfa, 0x33, 0x9c, 0xa4, 0x2f,
      0xb0, 0x88, 0x3e, 0xc4, 0x25, 0x90, 0x4f, 0xbd, 0xa2, 0x83, 0x3a, 0x3b,
      0x5b, 0x0a, 0x9a, 0x00, 0x81, 0x13, 0x65, 0xd8, 0x01, 0x23, 0x33, 0xd5,
      0x32, 0xf8, 0xf8, 0xeb, 0x1a, 0x62, 0x3c, 0x37, 0x8a, 0x36, 0x94, 0x65,
      0x11, 0x92, 0xbb, 0xda, 0x83, 0x3e, 0x3b, 0x8d, 0x7b, 0x8f, 0x90, 0xb2,
      0xbf, 0xc9, 0xb0, 0x45, 0xf8, 0xa5, 0x5e, 0x1b, 0x6a, 0x5f, 0xe1, 0x51,
      0x2c, 0x40, 0x0c, 0x4b, 0xc9, 0xc8, 0x6f, 0xd7, 0xc6, 0x99, 0xd6, 0x42,
      0xf5, 0xce, 0xe9, 0xbb, 0x82, 0x7c, 0x8b, 0x0a, 0xbc, 0x0d, 0xa0, 0x1c,
      0xef, 0x1e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: pseudorandom signature
    // tcID: 432
    {SEC_OID_SHA512,
     432,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x08, 0x13, 0x5d, 0x3f, 0x1a, 0xe9, 0xe2,
      0x6f, 0xba, 0x82, 0x56, 0x43, 0xed, 0x8a, 0x29, 0xd6, 0x3d, 0x78, 0x43,
      0x72, 0x0e, 0x93, 0x56, 0x6a, 0xa0, 0x9d, 0xb2, 0xbd, 0xf5, 0xaa, 0xa6,
      0x9a, 0xfb, 0xcc, 0x0c, 0x51, 0xe5, 0x29, 0x5c, 0x29, 0x8f, 0x30, 0x5b,
      0xa7, 0xb8, 0x70, 0xf0, 0xa8, 0x5b, 0xb5, 0x69, 0x9c, 0xdf, 0x40, 0x76,
      0x4a, 0xab, 0x59, 0x41, 0x8f, 0x77, 0xc6, 0xff, 0xb4, 0x52, 0x02, 0x42,
      0x01, 0x1d, 0x34, 0x52, 0x56, 0x88, 0x7f, 0xb3, 0x51, 0xf5, 0x70, 0x09,
      0x61, 0xa7, 0xd4, 0x75, 0x72, 0xe0, 0xd6, 0x69, 0x05, 0x6c, 0xb1, 0xd5,
      0x61, 0x93, 0x45, 0xc0, 0xc9, 0x87, 0xf3, 0x33, 0x1c, 0x2f, 0xe2, 0xc6,
      0xdf, 0x84, 0x8a, 0x5c, 0x61, 0x04, 0x22, 0xde, 0xfd, 0x62, 0x12, 0xb6,
      0x43, 0x46, 0x16, 0x1a, 0xa8, 0x71, 0xae, 0x55, 0xb1, 0xfe, 0x4a, 0xdd,
      0x5f, 0x68, 0x83, 0x6e, 0xb1, 0x81},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0x2a, 0x90, 0x8b, 0xfc, 0x5b, 0x70, 0xe1, 0x7b, 0xdf,
      0xae, 0x74, 0x29, 0x49, 0x94, 0x80, 0x8b, 0xf2, 0xa4, 0x2d, 0xab, 0x59,
      0xaf, 0x8b, 0x05, 0x23, 0xa0, 0x26, 0xd6, 0x40, 0xa2, 0xa3, 0xd6, 0xd3,
      0x44, 0x52, 0x0b, 0x62, 0x17, 0x7e, 0x2c, 0xfa, 0x33, 0x9c, 0xa4, 0x2f,
      0xb0, 0x88, 0x3e, 0xc4, 0x25, 0x90, 0x4f, 0xbd, 0xa2, 0x83, 0x3a, 0x3b,
      0x5b, 0x0a, 0x9a, 0x00, 0x81, 0x13, 0x65, 0xd8, 0x01, 0x23, 0x33, 0xd5,
      0x32, 0xf8, 0xf8, 0xeb, 0x1a, 0x62, 0x3c, 0x37, 0x8a, 0x36, 0x94, 0x65,
      0x11, 0x92, 0xbb, 0xda, 0x83, 0x3e, 0x3b, 0x8d, 0x7b, 0x8f, 0x90, 0xb2,
      0xbf, 0xc9, 0xb0, 0x45, 0xf8, 0xa5, 0x5e, 0x1b, 0x6a, 0x5f, 0xe1, 0x51,
      0x2c, 0x40, 0x0c, 0x4b, 0xc9, 0xc8, 0x6f, 0xd7, 0xc6, 0x99, 0xd6, 0x42,
      0xf5, 0xce, 0xe9, 0xbb, 0x82, 0x7c, 0x8b, 0x0a, 0xbc, 0x0d, 0xa0, 0x1c,
      0xef, 0x1e},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     true},

    // Comment: y-coordinate of the public key is small
    // tcID: 433
    {SEC_OID_SHA512,
     433,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x01, 0x1c, 0x96, 0x84, 0xaf, 0x6d, 0xc5,
      0x27, 0x28, 0x41, 0x04, 0x73, 0xc6, 0x30, 0x53, 0xb0, 0x1c, 0x35, 0x8d,
      0x67, 0xe8, 0x1f, 0x8a, 0x13, 0x24, 0xad, 0x71, 0x1c, 0x60, 0x48, 0x1a,
      0x4a, 0x86, 0xdd, 0x3e, 0x75, 0xde, 0x20, 0xca, 0x55, 0xce, 0x7a, 0x9a,
      0x39, 0xb1, 0xf8, 0x2f, 0xd5, 0xda, 0x4f, 0xad, 0xf2, 0x6a, 0x5b, 0xb8,
      0xed, 0xd4, 0x67, 0xaf, 0x88, 0x25, 0xef, 0xe4, 0x74, 0x62, 0x18, 0x02,
      0x41, 0x34, 0xc0, 0x58, 0xab, 0xa6, 0x48, 0x8d, 0x69, 0x43, 0xe1, 0x1e,
      0x0d, 0x13, 0x48, 0x42, 0x94, 0x49, 0xea, 0x17, 0xac, 0x5e, 0xdf, 0x8b,
      0xca, 0xf6, 0x54, 0x10, 0x6b, 0x98, 0xb2, 0xdd, 0xf3, 0x46, 0xc5, 0x37,
      0xb8, 0xa9, 0xa3, 0xf9, 0xb3, 0x17, 0x4b, 0x77, 0x63, 0x7d, 0x22, 0x0e,
      0xf5, 0x31, 0x8d, 0xbb, 0xc3, 0x3d, 0x0a, 0xac, 0x0f, 0xe2, 0xdd, 0xed,
      0xa1, 0x7b, 0x23, 0xcb, 0x2d, 0xe6},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x30, 0x4b, 0x3d, 0x07, 0x1e, 0xd1, 0xef, 0x30, 0x23,
      0x91, 0xb5, 0x66, 0xaf, 0x8c, 0x9d, 0x1c, 0xb7, 0xaf, 0xe9, 0xaa, 0xbc,
      0x14, 0x1a, 0xc3, 0x9a, 0xb3, 0x96, 0x76, 0xc6, 0x3e, 0x48, 0xc1, 0xb2,
      0xc6, 0x45, 0x1e, 0xb4, 0x60, 0xe4, 0x52, 0xbd, 0x57, 0x3e, 0x1f, 0xb5,
      0xf1, 0x5b, 0x8e, 0x5f, 0x9c, 0x03, 0xf6, 0x34, 0xd8, 0xdb, 0x68, 0x97,
      0x28, 0x50, 0x64, 0xb3, 0xce, 0x9b, 0xd9, 0x8a, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x9b, 0x98, 0xbf, 0xd3, 0x33, 0x98, 0xc2, 0xcf, 0x86, 0x06, 0xfc,
      0x0a, 0xe4, 0x68, 0xb6, 0xd6, 0x17, 0xcc, 0xb3, 0xe7, 0x04, 0xaf, 0x3b,
      0x85, 0x06, 0x64, 0x2a, 0x77, 0x5d, 0x5b, 0x4d, 0xa9, 0xd0, 0x02, 0x09,
      0x36, 0x4a, 0x9f, 0x0a, 0x4a, 0xd7, 0x7c, 0xba, 0xc6, 0x04, 0xa0, 0x15,
      0xc9, 0x7e, 0x6b, 0x5a, 0x18, 0x84, 0x4a, 0x58, 0x9a, 0x4f, 0x1c, 0x7d,
      0x96, 0x25},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: y-coordinate of the public key is small
    // tcID: 434
    {SEC_OID_SHA512,
     434,
     {0x30, 0x81, 0x87, 0x02, 0x41, 0x7c, 0x47, 0xa6, 0x68, 0x62, 0x56, 0x48,
      0xcd, 0x8a, 0x31, 0xac, 0x92, 0x17, 0x4c, 0xf3, 0xd6, 0x10, 0x41, 0xf7,
      0xad, 0x29, 0x25, 0x88, 0xde, 0xf6, 0xed, 0x14, 0x3b, 0x1f, 0xf9, 0xa2,
      0x88, 0xfd, 0x20, 0xcf, 0x36, 0xf5, 0x8d, 0x4b, 0xfe, 0x4b, 0x2c, 0xd4,
      0xa3, 0x81, 0xd4, 0xda, 0x50, 0xc8, 0xed, 0xa5, 0x67, 0x4f, 0x02, 0x04,
      0x49, 0xae, 0x1d, 0x3d, 0xd7, 0x7e, 0x44, 0xed, 0x48, 0x5e, 0x02, 0x42,
      0x01, 0x05, 0x8e, 0x86, 0xb3, 0x27, 0xd2, 0x84, 0xe3, 0x5b, 0xab, 0x49,
      0xfc, 0x7c, 0x33, 0x54, 0x17, 0x57, 0x3f, 0x31, 0x0a, 0xfa, 0x9e, 0x1a,
      0x53, 0x56, 0x6e, 0x0f, 0xae, 0x51, 0x6e, 0x09, 0x90, 0x07, 0x96, 0x50,
      0x30, 0xf6, 0xf4, 0x6b, 0x07, 0x71, 0x16, 0x35, 0x3f, 0x26, 0xcb, 0x46,
      0x6d, 0x1c, 0xf3, 0xf3, 0x53, 0x00, 0xd7, 0x44, 0xd2, 0xd8, 0xf8, 0x83,
      0xc8, 0xa3, 0x1b, 0x43, 0xc2, 0x0d},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x30, 0x4b, 0x3d, 0x07, 0x1e, 0xd1, 0xef, 0x30, 0x23,
      0x91, 0xb5, 0x66, 0xaf, 0x8c, 0x9d, 0x1c, 0xb7, 0xaf, 0xe9, 0xaa, 0xbc,
      0x14, 0x1a, 0xc3, 0x9a, 0xb3, 0x96, 0x76, 0xc6, 0x3e, 0x48, 0xc1, 0xb2,
      0xc6, 0x45, 0x1e, 0xb4, 0x60, 0xe4, 0x52, 0xbd, 0x57, 0x3e, 0x1f, 0xb5,
      0xf1, 0x5b, 0x8e, 0x5f, 0x9c, 0x03, 0xf6, 0x34, 0xd8, 0xdb, 0x68, 0x97,
      0x28, 0x50, 0x64, 0xb3, 0xce, 0x9b, 0xd9, 0x8a, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x9b, 0x98, 0xbf, 0xd3, 0x33, 0x98, 0xc2, 0xcf, 0x86, 0x06, 0xfc,
      0x0a, 0xe4, 0x68, 0xb6, 0xd6, 0x17, 0xcc, 0xb3, 0xe7, 0x04, 0xaf, 0x3b,
      0x85, 0x06, 0x64, 0x2a, 0x77, 0x5d, 0x5b, 0x4d, 0xa9, 0xd0, 0x02, 0x09,
      0x36, 0x4a, 0x9f, 0x0a, 0x4a, 0xd7, 0x7c, 0xba, 0xc6, 0x04, 0xa0, 0x15,
      0xc9, 0x7e, 0x6b, 0x5a, 0x18, 0x84, 0x4a, 0x58, 0x9a, 0x4f, 0x1c, 0x7d,
      0x96, 0x25},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: y-coordinate of the public key is small
    // tcID: 435
    {SEC_OID_SHA512,
     435,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xe4, 0xe9, 0xf3, 0xa7, 0xb8, 0x00,
      0xde, 0x63, 0x40, 0x7b, 0x87, 0x03, 0xac, 0x54, 0x52, 0x26, 0x54, 0x1c,
      0x97, 0xa6, 0x73, 0x56, 0x67, 0x11, 0xf7, 0x0e, 0x2b, 0x9c, 0xcb, 0x21,
      0xa1, 0x45, 0xad, 0x46, 0x37, 0x82, 0x5b, 0x02, 0x3d, 0x1e, 0xa9, 0xf1,
      0x8e, 0x60, 0x89, 0x74, 0x13, 0x71, 0x16, 0x11, 0xa8, 0x5c, 0x11, 0x79,
      0xbf, 0xf9, 0xc1, 0x07, 0x36, 0x8f, 0x1c, 0x1b, 0x61, 0xc2, 0x4c, 0x02,
      0x42, 0x01, 0xde, 0x94, 0x8e, 0xe5, 0x77, 0xc3, 0xd4, 0xe4, 0x12, 0x2a,
      0x52, 0xec, 0xcc, 0xac, 0x59, 0xab, 0xb6, 0xfa, 0x93, 0x7d, 0xfb, 0x3e,
      0x4b, 0x98, 0x8c, 0xb2, 0x43, 0xef, 0xe9, 0x87, 0x40, 0x30, 0x94, 0x52,
      0xba, 0x01, 0x31, 0x12, 0xb2, 0x25, 0xb3, 0xb1, 0xb1, 0x38, 0x4d, 0x5f,
      0x68, 0x79, 0x68, 0x45, 0x19, 0x9a, 0x26, 0x02, 0xa8, 0xd4, 0x50, 0x5a,
      0x33, 0x1b, 0x07, 0xd1, 0x01, 0x18, 0x8e},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x30, 0x4b, 0x3d, 0x07, 0x1e, 0xd1, 0xef, 0x30, 0x23,
      0x91, 0xb5, 0x66, 0xaf, 0x8c, 0x9d, 0x1c, 0xb7, 0xaf, 0xe9, 0xaa, 0xbc,
      0x14, 0x1a, 0xc3, 0x9a, 0xb3, 0x96, 0x76, 0xc6, 0x3e, 0x48, 0xc1, 0xb2,
      0xc6, 0x45, 0x1e, 0xb4, 0x60, 0xe4, 0x52, 0xbd, 0x57, 0x3e, 0x1f, 0xb5,
      0xf1, 0x5b, 0x8e, 0x5f, 0x9c, 0x03, 0xf6, 0x34, 0xd8, 0xdb, 0x68, 0x97,
      0x28, 0x50, 0x64, 0xb3, 0xce, 0x9b, 0xd9, 0x8a, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x9b, 0x98, 0xbf, 0xd3, 0x33, 0x98, 0xc2, 0xcf, 0x86, 0x06, 0xfc,
      0x0a, 0xe4, 0x68, 0xb6, 0xd6, 0x17, 0xcc, 0xb3, 0xe7, 0x04, 0xaf, 0x3b,
      0x85, 0x06, 0x64, 0x2a, 0x77, 0x5d, 0x5b, 0x4d, 0xa9, 0xd0, 0x02, 0x09,
      0x36, 0x4a, 0x9f, 0x0a, 0x4a, 0xd7, 0x7c, 0xba, 0xc6, 0x04, 0xa0, 0x15,
      0xc9, 0x7e, 0x6b, 0x5a, 0x18, 0x84, 0x4a, 0x58, 0x9a, 0x4f, 0x1c, 0x7d,
      0x96, 0x25},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: y-coordinate of the public key is large
    // tcID: 436
    {SEC_OID_SHA512,
     436,
     {0x30, 0x81, 0x87, 0x02, 0x42, 0x00, 0xb6, 0xcf, 0x64, 0x86, 0x1a, 0x2b,
      0x16, 0xe3, 0x39, 0x76, 0x09, 0x5d, 0xbf, 0x45, 0xa5, 0x92, 0xc7, 0xc2,
      0x42, 0x28, 0xc4, 0xa1, 0xdd, 0x72, 0x7f, 0x30, 0x3d, 0x5e, 0xeb, 0x87,
      0xe5, 0x38, 0x8a, 0xd0, 0x5c, 0x32, 0x8f, 0x82, 0x4c, 0x40, 0xab, 0xd3,
      0xe6, 0xce, 0x00, 0x3f, 0xef, 0x5c, 0xd5, 0x9d, 0xee, 0x00, 0x69, 0xad,
      0x63, 0x48, 0xea, 0x6e, 0x57, 0xf9, 0x0f, 0x6b, 0xdc, 0x0a, 0x82, 0x02,
      0x41, 0x22, 0x81, 0x81, 0xc1, 0x80, 0x36, 0x6e, 0x54, 0x51, 0xdf, 0xef,
      0x35, 0x93, 0xce, 0x66, 0x48, 0x04, 0xcb, 0x42, 0xd5, 0xa8, 0xd5, 0x04,
      0x6b, 0x81, 0x6b, 0x3d, 0xaf, 0x66, 0x02, 0xfa, 0xfd, 0x9a, 0xc2, 0xdc,
      0x24, 0xb8, 0xc9, 0x3a, 0x10, 0x02, 0x44, 0x80, 0x88, 0x25, 0x58, 0xb6,
      0xad, 0x3d, 0x9e, 0x90, 0x59, 0x23, 0xdc, 0xd0, 0xfd, 0x2a, 0x11, 0x96,
      0x47, 0x54, 0xa9, 0xb4, 0x6b, 0x8f},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x30, 0x4b, 0x3d, 0x07, 0x1e, 0xd1, 0xef, 0x30, 0x23,
      0x91, 0xb5, 0x66, 0xaf, 0x8c, 0x9d, 0x1c, 0xb7, 0xaf, 0xe9, 0xaa, 0xbc,
      0x14, 0x1a, 0xc3, 0x9a, 0xb3, 0x96, 0x76, 0xc6, 0x3e, 0x48, 0xc1, 0xb2,
      0xc6, 0x45, 0x1e, 0xb4, 0x60, 0xe4, 0x52, 0xbd, 0x57, 0x3e, 0x1f, 0xb5,
      0xf1, 0x5b, 0x8e, 0x5f, 0x9c, 0x03, 0xf6, 0x34, 0xd8, 0xdb, 0x68, 0x97,
      0x28, 0x50, 0x64, 0xb3, 0xce, 0x9b, 0xd9, 0x8a, 0x01, 0xff, 0xff, 0xff,
      0xff, 0x64, 0x67, 0x40, 0x2c, 0xcc, 0x67, 0x3d, 0x30, 0x79, 0xf9, 0x03,
      0xf5, 0x1b, 0x97, 0x49, 0x29, 0xe8, 0x33, 0x4c, 0x18, 0xfb, 0x50, 0xc4,
      0x7a, 0xf9, 0x9b, 0xd5, 0x88, 0xa2, 0xa4, 0xb2, 0x56, 0x2f, 0xfd, 0xf6,
      0xc9, 0xb5, 0x60, 0xf5, 0xb5, 0x28, 0x83, 0x45, 0x39, 0xfb, 0x5f, 0xea,
      0x36, 0x81, 0x94, 0xa5, 0xe7, 0x7b, 0xb5, 0xa7, 0x65, 0xb0, 0xe3, 0x82,
      0x69, 0xda},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: y-coordinate of the public key is large
    // tcID: 437
    {SEC_OID_SHA512,
     437,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0x93, 0xc8, 0xf7, 0x66, 0x82, 0x7d,
      0x6d, 0xc1, 0x5c, 0x81, 0x0f, 0xa3, 0x04, 0x33, 0x15, 0x3a, 0x5e, 0x74,
      0x28, 0x59, 0x20, 0x5e, 0xe8, 0x38, 0x9f, 0xbf, 0x69, 0x5c, 0x88, 0x40,
      0xdc, 0x91, 0x74, 0x40, 0x87, 0x0a, 0xcc, 0x5b, 0x16, 0x00, 0x87, 0xff,
      0xd0, 0xcd, 0x9a, 0x60, 0x81, 0x02, 0x9c, 0x60, 0xa7, 0xc2, 0x6d, 0x5e,
      0x8a, 0xa9, 0xa0, 0x57, 0x0f, 0x4e, 0xfd, 0xeb, 0x13, 0xde, 0xa2, 0x02,
      0x42, 0x01, 0x2e, 0xc3, 0xbb, 0xf7, 0x5a, 0x0a, 0xd3, 0xdf, 0x40, 0x31,
      0x02, 0x66, 0x64, 0x8a, 0x36, 0xdb, 0x82, 0x02, 0x17, 0xed, 0x7f, 0xa9,
      0x4e, 0x9c, 0x83, 0x13, 0xe0, 0x32, 0x93, 0xef, 0x4f, 0x6a, 0x40, 0xe7,
      0x36, 0xfb, 0x8f, 0x20, 0x8a, 0xd8, 0xfb, 0x88, 0x3c, 0xa5, 0x09, 0xd4,
      0x80, 0x46, 0x91, 0x05, 0x23, 0x64, 0x54, 0x59, 0xc2, 0x78, 0x29, 0xd5,
      0x44, 0x31, 0x46, 0x3b, 0x25, 0x48, 0xc7},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x30, 0x4b, 0x3d, 0x07, 0x1e, 0xd1, 0xef, 0x30, 0x23,
      0x91, 0xb5, 0x66, 0xaf, 0x8c, 0x9d, 0x1c, 0xb7, 0xaf, 0xe9, 0xaa, 0xbc,
      0x14, 0x1a, 0xc3, 0x9a, 0xb3, 0x96, 0x76, 0xc6, 0x3e, 0x48, 0xc1, 0xb2,
      0xc6, 0x45, 0x1e, 0xb4, 0x60, 0xe4, 0x52, 0xbd, 0x57, 0x3e, 0x1f, 0xb5,
      0xf1, 0x5b, 0x8e, 0x5f, 0x9c, 0x03, 0xf6, 0x34, 0xd8, 0xdb, 0x68, 0x97,
      0x28, 0x50, 0x64, 0xb3, 0xce, 0x9b, 0xd9, 0x8a, 0x01, 0xff, 0xff, 0xff,
      0xff, 0x64, 0x67, 0x40, 0x2c, 0xcc, 0x67, 0x3d, 0x30, 0x79, 0xf9, 0x03,
      0xf5, 0x1b, 0x97, 0x49, 0x29, 0xe8, 0x33, 0x4c, 0x18, 0xfb, 0x50, 0xc4,
      0x7a, 0xf9, 0x9b, 0xd5, 0x88, 0xa2, 0xa4, 0xb2, 0x56, 0x2f, 0xfd, 0xf6,
      0xc9, 0xb5, 0x60, 0xf5, 0xb5, 0x28, 0x83, 0x45, 0x39, 0xfb, 0x5f, 0xea,
      0x36, 0x81, 0x94, 0xa5, 0xe7, 0x7b, 0xb5, 0xa7, 0x65, 0xb0, 0xe3, 0x82,
      0x69, 0xda},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: y-coordinate of the public key is large
    // tcID: 438
    {SEC_OID_SHA512,
     438,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x52, 0x38, 0x8c, 0x6d, 0xa6, 0x61,
      0x64, 0xb7, 0x06, 0xb4, 0x1d, 0xd4, 0xdd, 0x48, 0x17, 0x6d, 0x6e, 0xaf,
      0x65, 0x25, 0xf8, 0x76, 0xef, 0x0f, 0xf2, 0xd1, 0x47, 0xf6, 0x96, 0x6e,
      0xbf, 0xad, 0xf1, 0x76, 0x7f, 0xa6, 0x6d, 0x04, 0x20, 0x3d, 0x3e, 0xc9,
      0xc9, 0x37, 0xa1, 0xf0, 0xc9, 0x45, 0xae, 0xd9, 0x53, 0xe3, 0x4b, 0xe4,
      0x44, 0xc2, 0x19, 0xfd, 0x3b, 0x94, 0xd3, 0x27, 0x7a, 0xa6, 0x52, 0x02,
      0x42, 0x01, 0x65, 0x8c, 0x1e, 0x5b, 0x2e, 0x56, 0x3a, 0x49, 0xd1, 0x1c,
      0x88, 0x3d, 0x05, 0xc4, 0x91, 0xd6, 0x28, 0xf0, 0xa9, 0x2c, 0x3e, 0x3d,
      0xc8, 0xdb, 0x9a, 0x4c, 0x8d, 0x5f, 0x0d, 0xc8, 0x46, 0xac, 0x22, 0xaf,
      0x8b, 0x3c, 0x5f, 0xb5, 0xbb, 0xe2, 0xcf, 0xa9, 0x86, 0x14, 0xdc, 0xff,
      0xd8, 0x7d, 0xe1, 0xce, 0xe2, 0xc5, 0x91, 0x2a, 0x58, 0x99, 0x50, 0x5a,
      0x0c, 0x5b, 0xca, 0xa5, 0x13, 0xe2, 0xc6},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x30, 0x4b, 0x3d, 0x07, 0x1e, 0xd1, 0xef, 0x30, 0x23,
      0x91, 0xb5, 0x66, 0xaf, 0x8c, 0x9d, 0x1c, 0xb7, 0xaf, 0xe9, 0xaa, 0xbc,
      0x14, 0x1a, 0xc3, 0x9a, 0xb3, 0x96, 0x76, 0xc6, 0x3e, 0x48, 0xc1, 0xb2,
      0xc6, 0x45, 0x1e, 0xb4, 0x60, 0xe4, 0x52, 0xbd, 0x57, 0x3e, 0x1f, 0xb5,
      0xf1, 0x5b, 0x8e, 0x5f, 0x9c, 0x03, 0xf6, 0x34, 0xd8, 0xdb, 0x68, 0x97,
      0x28, 0x50, 0x64, 0xb3, 0xce, 0x9b, 0xd9, 0x8a, 0x01, 0xff, 0xff, 0xff,
      0xff, 0x64, 0x67, 0x40, 0x2c, 0xcc, 0x67, 0x3d, 0x30, 0x79, 0xf9, 0x03,
      0xf5, 0x1b, 0x97, 0x49, 0x29, 0xe8, 0x33, 0x4c, 0x18, 0xfb, 0x50, 0xc4,
      0x7a, 0xf9, 0x9b, 0xd5, 0x88, 0xa2, 0xa4, 0xb2, 0x56, 0x2f, 0xfd, 0xf6,
      0xc9, 0xb5, 0x60, 0xf5, 0xb5, 0x28, 0x83, 0x45, 0x39, 0xfb, 0x5f, 0xea,
      0x36, 0x81, 0x94, 0xa5, 0xe7, 0x7b, 0xb5, 0xa7, 0x65, 0xb0, 0xe3, 0x82,
      0x69, 0xda},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: x-coordinate of the public key is small
    // tcID: 439
    {SEC_OID_SHA512,
     439,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x0e, 0x89, 0x47, 0x0f, 0x98, 0x1d,
      0x2c, 0x7c, 0x5c, 0x96, 0x58, 0x71, 0x21, 0xa6, 0x73, 0x23, 0xbb, 0x96,
      0xff, 0x24, 0x27, 0x73, 0x9d, 0x0d, 0x88, 0x5e, 0xa2, 0x77, 0x29, 0x3e,
      0xfa, 0x3b, 0x25, 0xc0, 0xbd, 0xa0, 0x4d, 0x81, 0x46, 0x61, 0x98, 0xa3,
      0xcb, 0xfc, 0x44, 0x1f, 0x1b, 0x1b, 0x98, 0xf6, 0xbc, 0xdc, 0x25, 0x89,
      0xd9, 0xd9, 0x1a, 0x17, 0xa7, 0x89, 0x9f, 0x70, 0xd0, 0x46, 0x1e, 0x02,
      0x42, 0x01, 0x73, 0x51, 0xb0, 0xda, 0x8c, 0x8d, 0x0e, 0x4a, 0xa0, 0x97,
      0x46, 0x69, 0xd1, 0x90, 0xfa, 0x2f, 0x90, 0xaa, 0x50, 0x22, 0x71, 0x60,
      0x59, 0x4d, 0xfb, 0x55, 0x75, 0x50, 0x02, 0x36, 0x54, 0x41, 0xde, 0x17,
      0xea, 0x42, 0x90, 0x21, 0x28, 0xa6, 0xf8, 0x1e, 0x55, 0x41, 0x77, 0xed,
      0x50, 0x9c, 0x0c, 0xec, 0x31, 0xfd, 0x50, 0x53, 0xfa, 0xe0, 0x3f, 0x62,
      0xff, 0x76, 0x57, 0x9b, 0xa9, 0x2b, 0xda},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x02, 0xfb, 0xa6, 0xa0, 0x61, 0x20,
      0x1e, 0xa6, 0xb1, 0xed, 0x42, 0x65, 0x16, 0x35, 0x68, 0x73, 0x5e, 0xba,
      0xb7, 0x86, 0x00, 0xcd, 0xf6, 0xa7, 0x11, 0x01, 0xdc, 0x63, 0xbe, 0xaf,
      0x54, 0x6d, 0x97, 0xa2, 0x14, 0xfc, 0x63, 0x96, 0x79, 0x3b, 0x01, 0x4e,
      0xb1, 0xaa, 0x7a, 0x72, 0x8f, 0x53, 0xde, 0xb2, 0xff, 0x99, 0x99, 0xa3,
      0x80, 0x8d, 0xdf, 0xed, 0x15, 0xe9, 0x62, 0x9b, 0x01, 0x99, 0x38, 0x52,
      0xda, 0xdc, 0x39, 0x29, 0x9a, 0x5a, 0x45, 0xb6, 0xbd, 0x7c, 0x8d, 0xc8,
      0xec, 0x67, 0xe7, 0xad, 0xbb, 0x35, 0x9f, 0xa8, 0xfa, 0x5d, 0x44, 0x97,
      0x7e, 0x15, 0xe2, 0xe5, 0xa9, 0xac, 0xf0, 0xc3, 0x36, 0x45, 0xf3, 0xf2,
      0xc6, 0x8c, 0x52, 0x6e, 0x07, 0x73, 0x2f, 0xb3, 0x50, 0x43, 0x71, 0x9c,
      0xfa, 0xfc, 0x16, 0x06, 0x3c, 0x8e, 0x58, 0x85, 0x0a, 0x95, 0x84, 0x36,
      0xa4, 0xe5},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: x-coordinate of the public key is small
    // tcID: 440
    {SEC_OID_SHA512,
     440,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x10, 0x94, 0xac, 0x23, 0xca, 0x46,
      0xa3, 0xe2, 0xb4, 0xac, 0x3b, 0xaa, 0xe6, 0x50, 0x4f, 0x1b, 0xfb, 0x3d,
      0xdf, 0x2d, 0xb9, 0xab, 0x40, 0xed, 0xa3, 0x2d, 0x8e, 0x0a, 0x05, 0x72,
      0x79, 0x98, 0xf8, 0x55, 0x2a, 0x03, 0x3b, 0xb0, 0x52, 0x41, 0xe8, 0x26,
      0xa8, 0x6a, 0x1d, 0x03, 0x01, 0x4e, 0xae, 0x3a, 0xa5, 0xfe, 0x1a, 0x45,
      0xca, 0xac, 0x1d, 0xb3, 0xe8, 0x13, 0x8b, 0x9c, 0xf5, 0x90, 0x68, 0x02,
      0x42, 0x01, 0x47, 0xed, 0xb1, 0x5a, 0x50, 0x80, 0xee, 0x2f, 0x92, 0x9f,
      0x78, 0xb6, 0xac, 0x86, 0x60, 0x4a, 0xae, 0x51, 0xb6, 0x74, 0xfa, 0x46,
      0xea, 0xae, 0x7f, 0xdf, 0xd9, 0x0b, 0xf6, 0x4d, 0x61, 0x89, 0x34, 0x11,
      0x55, 0xf4, 0xeb, 0xa9, 0x37, 0xea, 0xe7, 0x4c, 0x9e, 0x48, 0x0e, 0xb4,
      0xfb, 0x7e, 0x6a, 0xaf, 0xd4, 0x28, 0x5e, 0x7f, 0xc5, 0x03, 0xee, 0x6e,
      0xc2, 0x0f, 0x0b, 0x14, 0x15, 0xbe, 0x06},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x02, 0xfb, 0xa6, 0xa0, 0x61, 0x20,
      0x1e, 0xa6, 0xb1, 0xed, 0x42, 0x65, 0x16, 0x35, 0x68, 0x73, 0x5e, 0xba,
      0xb7, 0x86, 0x00, 0xcd, 0xf6, 0xa7, 0x11, 0x01, 0xdc, 0x63, 0xbe, 0xaf,
      0x54, 0x6d, 0x97, 0xa2, 0x14, 0xfc, 0x63, 0x96, 0x79, 0x3b, 0x01, 0x4e,
      0xb1, 0xaa, 0x7a, 0x72, 0x8f, 0x53, 0xde, 0xb2, 0xff, 0x99, 0x99, 0xa3,
      0x80, 0x8d, 0xdf, 0xed, 0x15, 0xe9, 0x62, 0x9b, 0x01, 0x99, 0x38, 0x52,
      0xda, 0xdc, 0x39, 0x29, 0x9a, 0x5a, 0x45, 0xb6, 0xbd, 0x7c, 0x8d, 0xc8,
      0xec, 0x67, 0xe7, 0xad, 0xbb, 0x35, 0x9f, 0xa8, 0xfa, 0x5d, 0x44, 0x97,
      0x7e, 0x15, 0xe2, 0xe5, 0xa9, 0xac, 0xf0, 0xc3, 0x36, 0x45, 0xf3, 0xf2,
      0xc6, 0x8c, 0x52, 0x6e, 0x07, 0x73, 0x2f, 0xb3, 0x50, 0x43, 0x71, 0x9c,
      0xfa, 0xfc, 0x16, 0x06, 0x3c, 0x8e, 0x58, 0x85, 0x0a, 0x95, 0x84, 0x36,
      0xa4, 0xe5},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: x-coordinate of the public key is small
    // tcID: 441
    {SEC_OID_SHA512,
     441,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xd8, 0x76, 0xae, 0x17, 0x4d, 0xa3,
      0x1e, 0x12, 0x8b, 0xab, 0xff, 0x9f, 0x1d, 0x15, 0x50, 0x76, 0x60, 0xbd,
      0xc7, 0x95, 0x87, 0x50, 0x84, 0x4d, 0xc4, 0xf4, 0x29, 0x1f, 0x75, 0xa8,
      0x82, 0xa2, 0x2f, 0x17, 0x7f, 0x70, 0x4b, 0xe6, 0x06, 0x7b, 0xf7, 0xce,
      0x8f, 0x06, 0xb8, 0x62, 0x6d, 0x97, 0x1e, 0x6e, 0xf5, 0xdc, 0xb6, 0x66,
      0xfa, 0x97, 0x5c, 0x1e, 0x11, 0x12, 0x6e, 0x04, 0xfc, 0xcc, 0xe2, 0x02,
      0x42, 0x01, 0xab, 0xb1, 0x26, 0x30, 0xa6, 0x8b, 0x66, 0x9e, 0x6a, 0xd2,
      0xd8, 0xd6, 0x26, 0x54, 0xd7, 0x5d, 0xfb, 0xc6, 0xb5, 0x4a, 0x8e, 0x3a,
      0x9c, 0x91, 0x5b, 0xe6, 0x63, 0xe0, 0x80, 0xdd, 0xcc, 0x34, 0x8e, 0x57,
      0xa1, 0x0e, 0x2b, 0x1d, 0xd9, 0xf0, 0x3e, 0x1b, 0x89, 0x77, 0x96, 0xad,
      0x88, 0x9b, 0x07, 0x5e, 0x59, 0x19, 0xdc, 0x5b, 0xf3, 0x7a, 0x11, 0x2d,
      0x92, 0xc6, 0x93, 0x45, 0x6e, 0x64, 0x57},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x02, 0xfb, 0xa6, 0xa0, 0x61, 0x20,
      0x1e, 0xa6, 0xb1, 0xed, 0x42, 0x65, 0x16, 0x35, 0x68, 0x73, 0x5e, 0xba,
      0xb7, 0x86, 0x00, 0xcd, 0xf6, 0xa7, 0x11, 0x01, 0xdc, 0x63, 0xbe, 0xaf,
      0x54, 0x6d, 0x97, 0xa2, 0x14, 0xfc, 0x63, 0x96, 0x79, 0x3b, 0x01, 0x4e,
      0xb1, 0xaa, 0x7a, 0x72, 0x8f, 0x53, 0xde, 0xb2, 0xff, 0x99, 0x99, 0xa3,
      0x80, 0x8d, 0xdf, 0xed, 0x15, 0xe9, 0x62, 0x9b, 0x01, 0x99, 0x38, 0x52,
      0xda, 0xdc, 0x39, 0x29, 0x9a, 0x5a, 0x45, 0xb6, 0xbd, 0x7c, 0x8d, 0xc8,
      0xec, 0x67, 0xe7, 0xad, 0xbb, 0x35, 0x9f, 0xa8, 0xfa, 0x5d, 0x44, 0x97,
      0x7e, 0x15, 0xe2, 0xe5, 0xa9, 0xac, 0xf0, 0xc3, 0x36, 0x45, 0xf3, 0xf2,
      0xc6, 0x8c, 0x52, 0x6e, 0x07, 0x73, 0x2f, 0xb3, 0x50, 0x43, 0x71, 0x9c,
      0xfa, 0xfc, 0x16, 0x06, 0x3c, 0x8e, 0x58, 0x85, 0x0a, 0x95, 0x84, 0x36,
      0xa4, 0xe5},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: x-coordinate of the public key is large
    // tcID: 442
    {SEC_OID_SHA512,
     442,
     {0x30, 0x81, 0x86, 0x02, 0x41, 0x4e, 0xd6, 0x92, 0xaf, 0x1e, 0xd1, 0xb4,
      0xbd, 0x5c, 0xea, 0x3a, 0xa8, 0xdd, 0xc6, 0xf3, 0xf1, 0x5d, 0x8a, 0x6e,
      0xe0, 0x01, 0x6f, 0xa0, 0xe8, 0xeb, 0x95, 0x85, 0x80, 0xe7, 0x42, 0x18,
      0x32, 0xec, 0xc0, 0xe3, 0x87, 0xc3, 0x4a, 0xaf, 0xac, 0x63, 0x80, 0xba,
      0xc4, 0x19, 0xea, 0x45, 0xc4, 0x2a, 0xe6, 0x42, 0x6a, 0xf5, 0x03, 0x84,
      0x7f, 0x22, 0xc4, 0x9c, 0x2f, 0x45, 0x63, 0x38, 0xc1, 0xa7, 0x02, 0x41,
      0x7a, 0xce, 0xad, 0xde, 0x02, 0xac, 0xe1, 0x66, 0x8b, 0xc1, 0xa3, 0x36,
      0x0d, 0x34, 0xe1, 0x25, 0xaf, 0xde, 0x23, 0x0f, 0x53, 0x6c, 0x15, 0x4d,
      0x91, 0xe6, 0xc8, 0x76, 0xbe, 0xe1, 0xd3, 0x4a, 0xe0, 0x6e, 0xdc, 0xbb,
      0xca, 0x0c, 0x7c, 0xd1, 0x76, 0x46, 0x84, 0x09, 0x13, 0x16, 0x47, 0x40,
      0xb1, 0x2e, 0x2e, 0x22, 0x4f, 0xe3, 0xef, 0x3d, 0xec, 0x6f, 0xd8, 0x4a,
      0x81, 0xb5, 0x81, 0xc1, 0x88},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0xff, 0xff, 0xff, 0xfe, 0x1d, 0x5d, 0x52, 0xb3, 0x1c,
      0xa5, 0x2f, 0x89, 0x47, 0xa3, 0x55, 0x93, 0xed, 0xf1, 0x64, 0xcd, 0x32,
      0x4f, 0x83, 0x3b, 0x90, 0x93, 0x58, 0x46, 0xc6, 0x4d, 0xb1, 0x45, 0x4d,
      0xf9, 0xf0, 0x28, 0xdc, 0x8b, 0xc3, 0x6b, 0xb0, 0x4c, 0xb7, 0xf0, 0xcc,
      0xec, 0xeb, 0xa0, 0x1a, 0x38, 0x44, 0x09, 0x7f, 0x7c, 0x35, 0xee, 0xaa,
      0x81, 0x42, 0x8d, 0xb0, 0xcc, 0xa6, 0x33, 0x31, 0x01, 0xb7, 0xc7, 0x02,
      0x77, 0xd0, 0xbf, 0x78, 0xa3, 0xc7, 0xb6, 0x2c, 0x93, 0x7f, 0x0c, 0xb2,
      0xca, 0xd2, 0x56, 0x5f, 0x55, 0x14, 0xf6, 0x20, 0x5c, 0xeb, 0x1a, 0x19,
      0x3d, 0x4f, 0xdb, 0x45, 0xba, 0x6e, 0x6c, 0xec, 0x07, 0x82, 0x7b, 0xae,
      0x0b, 0x16, 0xb8, 0x31, 0x6c, 0x35, 0x39, 0xa1, 0x51, 0x14, 0xd0, 0xde,
      0x6d, 0x2d, 0xe4, 0x07, 0xfd, 0x71, 0x17, 0x55, 0x1a, 0x70, 0x82, 0x6e,
      0xad, 0xa6},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: x-coordinate of the public key is large
    // tcID: 443
    {SEC_OID_SHA512,
     443,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x00, 0xe0, 0x10, 0x94, 0x04, 0x8f, 0xcf,
      0x7a, 0x1e, 0x2e, 0xc6, 0x6f, 0xae, 0xdf, 0xfc, 0x40, 0xf4, 0x8c, 0x9c,
      0x93, 0x51, 0x43, 0x25, 0xbd, 0xe6, 0xb4, 0x95, 0x8d, 0x80, 0xf0, 0x41,
      0x3e, 0xfd, 0xe7, 0xee, 0xc1, 0xdc, 0x6d, 0xe6, 0x5f, 0x96, 0x00, 0x9c,
      0x06, 0x93, 0x97, 0xe5, 0x1d, 0xa2, 0xeb, 0x17, 0x29, 0xef, 0xa2, 0x87,
      0xaf, 0xd5, 0x55, 0x2b, 0x25, 0xa9, 0xe4, 0x27, 0xa6, 0xd8, 0x36, 0x02,
      0x42, 0x01, 0x48, 0x9e, 0x7e, 0x12, 0x4f, 0x66, 0x94, 0x2e, 0x64, 0x2d,
      0xe9, 0x92, 0xe6, 0x0b, 0x3a, 0x86, 0xfc, 0xce, 0x57, 0x67, 0x67, 0x71,
      0x93, 0x90, 0xc3, 0xa3, 0x12, 0xfc, 0xde, 0xaa, 0x56, 0x0a, 0x7f, 0xbb,
      0x0c, 0xab, 0xb3, 0x5e, 0x05, 0xa6, 0xd6, 0xf3, 0x49, 0x91, 0x60, 0xfd,
      0x2d, 0xba, 0x12, 0xd2, 0x9b, 0x61, 0x3b, 0x16, 0xde, 0xc7, 0x49, 0x4c,
      0x95, 0x0d, 0x65, 0xfd, 0xf1, 0x1f, 0xa3},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0xff, 0xff, 0xff, 0xfe, 0x1d, 0x5d, 0x52, 0xb3, 0x1c,
      0xa5, 0x2f, 0x89, 0x47, 0xa3, 0x55, 0x93, 0xed, 0xf1, 0x64, 0xcd, 0x32,
      0x4f, 0x83, 0x3b, 0x90, 0x93, 0x58, 0x46, 0xc6, 0x4d, 0xb1, 0x45, 0x4d,
      0xf9, 0xf0, 0x28, 0xdc, 0x8b, 0xc3, 0x6b, 0xb0, 0x4c, 0xb7, 0xf0, 0xcc,
      0xec, 0xeb, 0xa0, 0x1a, 0x38, 0x44, 0x09, 0x7f, 0x7c, 0x35, 0xee, 0xaa,
      0x81, 0x42, 0x8d, 0xb0, 0xcc, 0xa6, 0x33, 0x31, 0x01, 0xb7, 0xc7, 0x02,
      0x77, 0xd0, 0xbf, 0x78, 0xa3, 0xc7, 0xb6, 0x2c, 0x93, 0x7f, 0x0c, 0xb2,
      0xca, 0xd2, 0x56, 0x5f, 0x55, 0x14, 0xf6, 0x20, 0x5c, 0xeb, 0x1a, 0x19,
      0x3d, 0x4f, 0xdb, 0x45, 0xba, 0x6e, 0x6c, 0xec, 0x07, 0x82, 0x7b, 0xae,
      0x0b, 0x16, 0xb8, 0x31, 0x6c, 0x35, 0x39, 0xa1, 0x51, 0x14, 0xd0, 0xde,
      0x6d, 0x2d, 0xe4, 0x07, 0xfd, 0x71, 0x17, 0x55, 0x1a, 0x70, 0x82, 0x6e,
      0xad, 0xa6},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: x-coordinate of the public key is large
    // tcID: 444
    {SEC_OID_SHA512,
     444,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xd2, 0x96, 0x29, 0x22, 0x13, 0x38,
      0x0d, 0xe1, 0x33, 0xdc, 0x66, 0xec, 0xeb, 0x8b, 0xd8, 0x57, 0xa5, 0xc4,
      0x68, 0xaf, 0xe8, 0x55, 0xc0, 0x5d, 0xa9, 0xdb, 0x93, 0x73, 0x73, 0xb5,
      0x1f, 0x90, 0x20, 0xca, 0x11, 0x35, 0x34, 0x15, 0xda, 0x76, 0xbb, 0x6a,
      0xf9, 0x97, 0xa4, 0x86, 0xd2, 0x37, 0x0e, 0x31, 0xad, 0xcc, 0x0a, 0x45,
      0x31, 0x95, 0x2a, 0x3b, 0x59, 0x42, 0x86, 0x78, 0xee, 0x59, 0x43, 0x02,
      0x42, 0x01, 0x59, 0x79, 0xa3, 0xc6, 0x09, 0xc2, 0xc2, 0x09, 0x9a, 0xe1,
      0xb2, 0x90, 0xda, 0x3d, 0x61, 0x3b, 0x24, 0x8e, 0x3a, 0x10, 0xde, 0x7a,
      0xd7, 0x70, 0xdf, 0xfc, 0x82, 0xfb, 0x33, 0xe7, 0x4f, 0xc3, 0x20, 0x75,
      0x33, 0xf9, 0x72, 0x85, 0xcf, 0x45, 0x57, 0xa6, 0x40, 0x7e, 0x9a, 0x77,
      0x5e, 0x59, 0xef, 0xea, 0xee, 0x42, 0x64, 0xb2, 0x63, 0x49, 0x33, 0xa6,
      0xba, 0xf8, 0xc4, 0x06, 0xf0, 0xc4, 0xa9},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x01, 0xff, 0xff, 0xff, 0xfe, 0x1d, 0x5d, 0x52, 0xb3, 0x1c,
      0xa5, 0x2f, 0x89, 0x47, 0xa3, 0x55, 0x93, 0xed, 0xf1, 0x64, 0xcd, 0x32,
      0x4f, 0x83, 0x3b, 0x90, 0x93, 0x58, 0x46, 0xc6, 0x4d, 0xb1, 0x45, 0x4d,
      0xf9, 0xf0, 0x28, 0xdc, 0x8b, 0xc3, 0x6b, 0xb0, 0x4c, 0xb7, 0xf0, 0xcc,
      0xec, 0xeb, 0xa0, 0x1a, 0x38, 0x44, 0x09, 0x7f, 0x7c, 0x35, 0xee, 0xaa,
      0x81, 0x42, 0x8d, 0xb0, 0xcc, 0xa6, 0x33, 0x31, 0x01, 0xb7, 0xc7, 0x02,
      0x77, 0xd0, 0xbf, 0x78, 0xa3, 0xc7, 0xb6, 0x2c, 0x93, 0x7f, 0x0c, 0xb2,
      0xca, 0xd2, 0x56, 0x5f, 0x55, 0x14, 0xf6, 0x20, 0x5c, 0xeb, 0x1a, 0x19,
      0x3d, 0x4f, 0xdb, 0x45, 0xba, 0x6e, 0x6c, 0xec, 0x07, 0x82, 0x7b, 0xae,
      0x0b, 0x16, 0xb8, 0x31, 0x6c, 0x35, 0x39, 0xa1, 0x51, 0x14, 0xd0, 0xde,
      0x6d, 0x2d, 0xe4, 0x07, 0xfd, 0x71, 0x17, 0x55, 0x1a, 0x70, 0x82, 0x6e,
      0xad, 0xa6},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: y-coordinate of the public key has many trailing 1's
    // tcID: 445
    {SEC_OID_SHA512,
     445,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xef, 0x8f, 0x78, 0x5c, 0x51, 0xa2,
      0x5a, 0xe2, 0xcd, 0x93, 0x48, 0x7b, 0x5c, 0x84, 0x8d, 0x4a, 0xf1, 0x33,
      0x21, 0x7a, 0x91, 0xf5, 0x13, 0x59, 0xc9, 0x66, 0xe7, 0x53, 0x8e, 0x68,
      0x74, 0x35, 0x78, 0x12, 0x2d, 0xf5, 0x83, 0x00, 0x02, 0xf9, 0x6f, 0x6f,
      0xad, 0xb5, 0xbc, 0x44, 0x48, 0x0e, 0x3b, 0x3b, 0x2c, 0x80, 0x4e, 0x4c,
      0x51, 0xcf, 0x95, 0xd0, 0x59, 0xd5, 0x64, 0x6c, 0x5c, 0xef, 0x21, 0x02,
      0x42, 0x01, 0xba, 0x22, 0x76, 0xcc, 0x00, 0x3e, 0x87, 0xbe, 0xa3, 0x7c,
      0x37, 0x24, 0xe5, 0x8a, 0x0a, 0xb8, 0x85, 0xf5, 0x6d, 0x09, 0xb8, 0xb5,
      0x71, 0x8f, 0x67, 0x4f, 0x9c, 0x70, 0xf3, 0xb5, 0xec, 0xfb, 0x4a, 0xd1,
      0xf3, 0x41, 0x7b, 0x42, 0x0e, 0xc4, 0x08, 0x10, 0xe0, 0x88, 0x26, 0xef,
      0xa7, 0xd8, 0xad, 0x6c, 0xa7, 0xc6, 0xa7, 0x84, 0x03, 0x48, 0x09, 0x7f,
      0x92, 0xb2, 0xde, 0x8d, 0x6e, 0x08, 0x0b},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0xc7, 0xc8, 0x81, 0x7b, 0xf2, 0xf0, 0x65, 0x2a, 0x4a,
      0x4b, 0x51, 0x40, 0xc7, 0x73, 0xe2, 0x61, 0x08, 0x0a, 0x0a, 0x11, 0x13,
      0x95, 0x85, 0x6e, 0x8a, 0x33, 0x50, 0xf5, 0xeb, 0x56, 0x12, 0xbd, 0x63,
      0xb3, 0x67, 0xb9, 0x65, 0xe9, 0x2e, 0x95, 0x38, 0xea, 0x3b, 0x79, 0x08,
      0xae, 0xf1, 0xad, 0xe4, 0xb6, 0x8e, 0x17, 0xf9, 0xf9, 0x14, 0x84, 0x95,
      0xc1, 0x67, 0xd1, 0xc4, 0xdd, 0x49, 0x13, 0x49, 0x00, 0x08, 0xbf, 0x0b,
      0xe2, 0x97, 0x9a, 0xbb, 0x81, 0x11, 0xfd, 0x0d, 0x76, 0x8a, 0xdc, 0xad,
      0x77, 0x41, 0x13, 0xa8, 0x22, 0xc1, 0xbb, 0x60, 0x88, 0x70, 0x53, 0xb5,
      0xcf, 0x8c, 0x95, 0x63, 0xe7, 0x67, 0x05, 0xa3, 0x91, 0xec, 0xe1, 0x54,
      0xb5, 0xdf, 0xb1, 0x14, 0xb2, 0x0e, 0x35, 0x1d, 0xf4, 0x01, 0x4b, 0xec,
      0x19, 0xfa, 0x87, 0x72, 0x08, 0x45, 0x80, 0x1c, 0xf0, 0x6b, 0x7f, 0xff,
      0xff, 0xff},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: y-coordinate of the public key has many trailing 1's
    // tcID: 446
    {SEC_OID_SHA512,
     446,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0x55, 0x97, 0x8a, 0xdc, 0x4b, 0x57,
      0x0d, 0x89, 0x75, 0x11, 0xf5, 0xec, 0xfb, 0x65, 0xa3, 0x19, 0x47, 0xe6,
      0xe9, 0x89, 0xda, 0x17, 0xde, 0xa7, 0x16, 0x62, 0x5b, 0xb3, 0xfa, 0x7b,
      0x92, 0xb8, 0x53, 0x62, 0x3e, 0xb0, 0xcd, 0x9c, 0xe2, 0xa5, 0xe2, 0xb4,
      0xd8, 0xc1, 0xc2, 0xa9, 0x0e, 0xc0, 0x4f, 0xe7, 0x9d, 0x01, 0x25, 0x76,
      0xec, 0x72, 0x8a, 0x45, 0xc5, 0xce, 0x47, 0xc6, 0xd5, 0x00, 0xc0, 0x02,
      0x42, 0x00, 0xf7, 0x9f, 0xa8, 0xb9, 0x4e, 0xe2, 0x82, 0xa3, 0xd1, 0x81,
      0x58, 0x92, 0xcb, 0xf1, 0x5d, 0x7e, 0xbd, 0xf6, 0x2c, 0xb0, 0x42, 0xc7,
      0x6b, 0xb3, 0xc7, 0x10, 0xc2, 0x3e, 0x32, 0xb7, 0x59, 0x92, 0xcc, 0x24,
      0x9d, 0x84, 0x07, 0x21, 0x98, 0xe4, 0xed, 0x63, 0xd7, 0x24, 0x35, 0xa0,
      0x7d, 0x2e, 0xd7, 0x6f, 0x27, 0x8d, 0x73, 0x99, 0xf6, 0x1a, 0x5b, 0x5c,
      0x99, 0x7f, 0x45, 0x69, 0x2f, 0xed, 0x22},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0xc7, 0xc8, 0x81, 0x7b, 0xf2, 0xf0, 0x65, 0x2a, 0x4a,
      0x4b, 0x51, 0x40, 0xc7, 0x73, 0xe2, 0x61, 0x08, 0x0a, 0x0a, 0x11, 0x13,
      0x95, 0x85, 0x6e, 0x8a, 0x33, 0x50, 0xf5, 0xeb, 0x56, 0x12, 0xbd, 0x63,
      0xb3, 0x67, 0xb9, 0x65, 0xe9, 0x2e, 0x95, 0x38, 0xea, 0x3b, 0x79, 0x08,
      0xae, 0xf1, 0xad, 0xe4, 0xb6, 0x8e, 0x17, 0xf9, 0xf9, 0x14, 0x84, 0x95,
      0xc1, 0x67, 0xd1, 0xc4, 0xdd, 0x49, 0x13, 0x49, 0x00, 0x08, 0xbf, 0x0b,
      0xe2, 0x97, 0x9a, 0xbb, 0x81, 0x11, 0xfd, 0x0d, 0x76, 0x8a, 0xdc, 0xad,
      0x77, 0x41, 0x13, 0xa8, 0x22, 0xc1, 0xbb, 0x60, 0x88, 0x70, 0x53, 0xb5,
      0xcf, 0x8c, 0x95, 0x63, 0xe7, 0x67, 0x05, 0xa3, 0x91, 0xec, 0xe1, 0x54,
      0xb5, 0xdf, 0xb1, 0x14, 0xb2, 0x0e, 0x35, 0x1d, 0xf4, 0x01, 0x4b, 0xec,
      0x19, 0xfa, 0x87, 0x72, 0x08, 0x45, 0x80, 0x1c, 0xf0, 0x6b, 0x7f, 0xff,
      0xff, 0xff},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: y-coordinate of the public key has many trailing 1's
    // tcID: 447
    {SEC_OID_SHA512,
     447,
     {0x30, 0x81, 0x88, 0x02, 0x42, 0x01, 0xa2, 0xaf, 0x29, 0xc5, 0x81, 0x84,
      0xca, 0x86, 0x1e, 0x7c, 0xd9, 0x31, 0xf3, 0x9c, 0xea, 0x06, 0x4b, 0x19,
      0x9e, 0xee, 0x56, 0x3f, 0x24, 0x1c, 0xd5, 0xec, 0xf6, 0xeb, 0xb2, 0xad,
      0xe7, 0x28, 0xf1, 0xbe, 0x23, 0xcf, 0x00, 0x7e, 0xbe, 0x8e, 0xf0, 0xc4,
      0x2d, 0x99, 0xf9, 0xf5, 0x19, 0x0f, 0x68, 0x15, 0x44, 0x6a, 0xfc, 0x30,
      0x43, 0xa8, 0x20, 0xd7, 0xda, 0xf2, 0x7e, 0x86, 0xb8, 0x3b, 0x8a, 0x02,
      0x42, 0x01, 0xa2, 0xac, 0xd1, 0x82, 0x2e, 0xb5, 0x39, 0x38, 0x3d, 0xef,
      0xff, 0x87, 0x69, 0xaa, 0xd8, 0xba, 0xcd, 0x50, 0xcd, 0x24, 0xca, 0x7a,
      0xa6, 0x67, 0x06, 0x71, 0x41, 0x81, 0x10, 0x17, 0x78, 0x08, 0xc3, 0xf4,
      0xfb, 0xe6, 0x04, 0x1b, 0x9c, 0xb8, 0x98, 0x35, 0x9e, 0xe6, 0x1e, 0x04,
      0x82, 0x4a, 0xde, 0xdd, 0x62, 0xb3, 0x9f, 0xe5, 0x79, 0x19, 0x07, 0xa2,
      0x05, 0x86, 0x33, 0x3b, 0xd3, 0xc7, 0x6d},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0xc7, 0xc8, 0x81, 0x7b, 0xf2, 0xf0, 0x65, 0x2a, 0x4a,
      0x4b, 0x51, 0x40, 0xc7, 0x73, 0xe2, 0x61, 0x08, 0x0a, 0x0a, 0x11, 0x13,
      0x95, 0x85, 0x6e, 0x8a, 0x33, 0x50, 0xf5, 0xeb, 0x56, 0x12, 0xbd, 0x63,
      0xb3, 0x67, 0xb9, 0x65, 0xe9, 0x2e, 0x95, 0x38, 0xea, 0x3b, 0x79, 0x08,
      0xae, 0xf1, 0xad, 0xe4, 0xb6, 0x8e, 0x17, 0xf9, 0xf9, 0x14, 0x84, 0x95,
      0xc1, 0x67, 0xd1, 0xc4, 0xdd, 0x49, 0x13, 0x49, 0x00, 0x08, 0xbf, 0x0b,
      0xe2, 0x97, 0x9a, 0xbb, 0x81, 0x11, 0xfd, 0x0d, 0x76, 0x8a, 0xdc, 0xad,
      0x77, 0x41, 0x13, 0xa8, 0x22, 0xc1, 0xbb, 0x60, 0x88, 0x70, 0x53, 0xb5,
      0xcf, 0x8c, 0x95, 0x63, 0xe7, 0x67, 0x05, 0xa3, 0x91, 0xec, 0xe1, 0x54,
      0xb5, 0xdf, 0xb1, 0x14, 0xb2, 0x0e, 0x35, 0x1d, 0xf4, 0x01, 0x4b, 0xec,
      0x19, 0xfa, 0x87, 0x72, 0x08, 0x45, 0x80, 0x1c, 0xf0, 0x6b, 0x7f, 0xff,
      0xff, 0xff},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true}};

#endif  // p521ecdsa_sha512_vectors_h__
