<!--- AUTOGENERATED BY `./recipes.py test train` -->
# Repo documentation for [depot\_tools](https://chromium.googlesource.com/chromium/tools/depot_tools.git)
## Table of Contents

**[Recipe Modules](#Recipe-Modules)**
  * [bot_update](#recipe_modules-bot_update) &mdash; Recipe module to ensure a checkout is consistent on a bot.
  * [cipd](#recipe_modules-cipd) &mdash; API for interacting with CIPD.
  * [depot_tools](#recipe_modules-depot_tools) &mdash; The `depot_tools` module provides safe functions to access paths within the depot_tools repo.
  * [gclient](#recipe_modules-gclient)
  * [gerrit](#recipe_modules-gerrit)
  * [git](#recipe_modules-git)
  * [git_cl](#recipe_modules-git_cl)
  * [gitiles](#recipe_modules-gitiles)
  * [gsutil](#recipe_modules-gsutil)
  * [osx_sdk](#recipe_modules-osx_sdk) &mdash; The `osx_sdk` module provides safe functions to access a semi-hermetic XCode installation.
  * [presubmit](#recipe_modules-presubmit)
  * [tryserver](#recipe_modules-tryserver)
  * [windows_sdk](#recipe_modules-windows_sdk) &mdash; The `windows_sdk` module provides safe functions to access a hermetic Microsoft Visual Studio installation.

**[Recipes](#Recipes)**
  * [bot_update:examples/full](#recipes-bot_update_examples_full)
  * [bot_update:tests/do_not_retry_patch_failures_in_cq](#recipes-bot_update_tests_do_not_retry_patch_failures_in_cq)
  * [bot_update:tests/ensure_checkout](#recipes-bot_update_tests_ensure_checkout)
  * [cipd:examples/full](#recipes-cipd_examples_full)
  * [cipd:examples/platform_suffix](#recipes-cipd_examples_platform_suffix)
  * [depot_tools:examples/full](#recipes-depot_tools_examples_full)
  * [fetch_end_to_end_test](#recipes-fetch_end_to_end_test)
  * [gclient:examples/full](#recipes-gclient_examples_full)
  * [gclient:tests/diff_deps](#recipes-gclient_tests_diff_deps)
  * [gclient:tests/patch_project](#recipes-gclient_tests_patch_project)
  * [gclient:tests/sync_failure](#recipes-gclient_tests_sync_failure)
  * [gerrit:examples/full](#recipes-gerrit_examples_full)
  * [git:examples/full](#recipes-git_examples_full)
  * [git_cl:examples/full](#recipes-git_cl_examples_full)
  * [gitiles:examples/full](#recipes-gitiles_examples_full)
  * [gitiles:tests/parse_repo_url](#recipes-gitiles_tests_parse_repo_url)
  * [gsutil:examples/full](#recipes-gsutil_examples_full)
  * [osx_sdk:examples/full](#recipes-osx_sdk_examples_full)
  * [presubmit:examples/full](#recipes-presubmit_examples_full)
  * [presubmit:tests/execute](#recipes-presubmit_tests_execute)
  * [presubmit:tests/prepare](#recipes-presubmit_tests_prepare)
  * [tryserver:examples/full](#recipes-tryserver_examples_full)
  * [tryserver:tests/gerrit_change_fetch_ref_timeout](#recipes-tryserver_tests_gerrit_change_fetch_ref_timeout)
  * [tryserver:tests/gerrit_change_owner](#recipes-tryserver_tests_gerrit_change_owner)
  * [tryserver:tests/gerrit_change_target_ref](#recipes-tryserver_tests_gerrit_change_target_ref)
  * [windows_sdk:examples/full](#recipes-windows_sdk_examples_full)
## Recipe Modules

### *recipe_modules* / [bot\_update](/recipes/recipe_modules/bot_update)

[DEPS](/recipes/recipe_modules/bot_update/__init__.py#1): [depot\_tools](#recipe_modules-depot_tools), [gclient](#recipe_modules-gclient), [gerrit](#recipe_modules-gerrit), [gitiles](#recipe_modules-gitiles), [tryserver](#recipe_modules-tryserver), [recipe\_engine/buildbucket][recipe_engine/recipe_modules/buildbucket], [recipe\_engine/commit\_position][recipe_engine/recipe_modules/commit_position], [recipe\_engine/context][recipe_engine/recipe_modules/context], [recipe\_engine/cq][recipe_engine/recipe_modules/cq], [recipe\_engine/json][recipe_engine/recipe_modules/json], [recipe\_engine/milo][recipe_engine/recipe_modules/milo], [recipe\_engine/path][recipe_engine/recipe_modules/path], [recipe\_engine/platform][recipe_engine/recipe_modules/platform], [recipe\_engine/properties][recipe_engine/recipe_modules/properties], [recipe\_engine/python][recipe_engine/recipe_modules/python], [recipe\_engine/raw\_io][recipe_engine/recipe_modules/raw_io], [recipe\_engine/runtime][recipe_engine/recipe_modules/runtime], [recipe\_engine/step][recipe_engine/recipe_modules/step]

Recipe module to ensure a checkout is consistent on a bot.

#### **class [BotUpdateApi](/recipes/recipe_modules/bot_update/api.py#12)([RecipeApi][recipe_engine/wkt/RecipeApi]):**

&mdash; **def [\_\_call\_\_](/recipes/recipe_modules/bot_update/api.py#22)(self, name, cmd, \*\*kwargs):**

Wrapper for easy calling of bot_update.

&mdash; **def [deapply\_patch](/recipes/recipe_modules/bot_update/api.py#531)(self, bot_update_step):**

Deapplies a patch, taking care of DEPS and solution revisions properly.
    

&mdash; **def [ensure\_checkout](/recipes/recipe_modules/bot_update/api.py#79)(self, gclient_config=None, suffix=None, patch=True, update_presentation=True, patch_root=None, with_branch_heads=False, with_tags=False, no_fetch_tags=False, refs=None, patch_oauth2=None, oauth2_json=None, use_site_config_creds=None, clobber=False, root_solution_revision=None, rietveld=None, issue=None, patchset=None, gerrit_no_reset=False, gerrit_no_rebase_patch_ref=False, assert_one_gerrit_change=True, disable_syntax_validation=False, patch_refs=None, ignore_input_commit=False, add_blamelists=False, set_output_commit=False, step_test_data=None, enforce_fetch=False, \*\*kwargs):**

Args:
  * gclient_config: The gclient configuration to use when running bot_update.
    If omitted, the current gclient configuration is used.
  * no_fetch_tags: When true, the root git repo being checked out will not
    fetch any tags referenced from the references being fetched. When a repo
    has many references, it can become a performance bottleneck, so avoid
    tags if the checkout will not need them present.
  * disable_syntax_validation: (legacy) Disables syntax validation for DEPS.
    Needed as migration paths for recipes dealing with older revisions,
    such as bisect.
  * ignore_input_commit: if True, ignore api.buildbucket.gitiles_commit.
    Exists for historical reasons. Please do not use.
  * add_blamelists: if True, add blamelist pins for all of the repos that had
    revisions specified in the gclient config.
  * set_output_commit: if True, mark the checked out commit as the
    primary output commit of this build, i.e. call
    api.buildbucket.set_output_gitiles_commit.
    In case of multiple repos, the repo is the one specified in
    api.buildbucket.gitiles_commit or the first configured solution.
    When sorting builds by commit position, this commit will be used.
    Requires falsy ignore_input_commit.
  * step_test_data: a null function that returns test bot_update.py output.
    Use test_api.output_json to generate test data.
  * enforce_fetch: Enforce a new fetch to refresh the git cache, even if the
    solution revision passed in already exists in the current git cache.
  * assert_one_gerrit_change: if True, assert that there is at most one
    change in self.m.buildbucket.build.input.gerrit_changes, because
    bot_update module ONLY supports one change. Users may specify a change
    via tryserver.set_change() and explicitly set this flag False.

&mdash; **def [get\_project\_revision\_properties](/recipes/recipe_modules/bot_update/api.py#508)(self, project_name, gclient_config=None):**

Returns all property names used for storing the checked-out revision of
a given project.

Args:
  * project_name (str): The name of a checked-out project as deps path, e.g.
      src or src/v8.
  * gclient_config: The gclient configuration to use. If omitted, the current
      gclient configuration is used.

Returns (list of str): All properties that'll hold the checked-out revision
    of the given project. An empty list if no such properties exist.

&emsp; **@property**<br>&mdash; **def [last\_returned\_properties](/recipes/recipe_modules/bot_update/api.py#47)(self):**

&mdash; **def [resolve\_fixed\_revision](/recipes/recipe_modules/bot_update/api.py#459)(self, bot_update_json, name):**

Sets a fixed revision for a single dependency using project revision
properties.
### *recipe_modules* / [cipd](/recipes/recipe_modules/cipd)

[DEPS](/recipes/recipe_modules/cipd/__init__.py#1): [recipe\_engine/json][recipe_engine/recipe_modules/json], [recipe\_engine/path][recipe_engine/recipe_modules/path], [recipe\_engine/platform][recipe_engine/recipe_modules/platform], [recipe\_engine/properties][recipe_engine/recipe_modules/properties], [recipe\_engine/python][recipe_engine/recipe_modules/python], [recipe\_engine/raw\_io][recipe_engine/recipe_modules/raw_io], [recipe\_engine/step][recipe_engine/recipe_modules/step]

API for interacting with CIPD.

Depends on 'cipd' binary available in PATH:
https://godoc.org/go.chromium.org/luci/cipd/client/cmd/cipd

WARNING: There is an alternative cipd recipe_module in recipes-py.git:
https://codesearch.chromium.org/chromium/infra/recipes-py/recipe_modules/cipd/

Consider using that one instead.
TODO(crbug.com/875523): Delete this module.

#### **class [CIPDApi](/recipes/recipe_modules/cipd/api.py#163)([RecipeApi][recipe_engine/wkt/RecipeApi]):**

CIPDApi provides basic support for CIPD.

This assumes that `cipd` (or `cipd.exe` or `cipd.bat` on windows) has been
installed somewhere in $PATH. This will be true if you use depot_tools, or if
your recipe is running inside of chrome-infrastructure's systems (buildbot,
swarming).

&mdash; **def [build](/recipes/recipe_modules/cipd/api.py#236)(self, input_dir, output_package, package_name, install_mode=None):**

Builds, but does not upload, a cipd package from a directory.

Args:
  input_dir (Path) - the directory to build the package from.
  output_package (Path) - the file to write the package to.
  package_name (str) - the name of the cipd package as it would appear when
    uploaded to the cipd package server.
  install_mode (None|'copy'|'symlink') - the mechanism that the cipd client
    should use when installing this package. If None, defaults to the
    platform default ('copy' on windows, 'symlink' on everything else).

&mdash; **def [create\_from\_pkg](/recipes/recipe_modules/cipd/api.py#340)(self, pkg_def, refs=None, tags=None):**

Builds and uploads a package based on a PackageDefinition object.

This builds and uploads the package in one step.

Args:
  pkg_def (PackageDefinition) - The description of the package we want to
    create.
  refs (list(str)) - A list of ref names to set for the package instance.
  tags (dict(str, str)) - A map of tag name -> value to set for the package
                          instance.

Returns the JSON 'result' section, e.g.: {
  "package": "infra/tools/cipd/android-amd64",
  "instance_id": "433bfdf86c0bb82d1eee2d1a0473d3709c25d2c4"
}

&mdash; **def [create\_from\_yaml](/recipes/recipe_modules/cipd/api.py#314)(self, pkg_def, refs=None, tags=None, verification_timeout=None):**

Builds and uploads a package based on on-disk YAML package definition
file.

This builds and uploads the package in one step.

Args:
  pkg_def (Path) - The path to the yaml file.
  refs (list(str)) - A list of ref names to set for the package instance.
  tags (dict(str, str)) - A map of tag name -> value to set for the package
                          instance.
  verification_timeout (str) - Duration string that controls the time to
                               wait for backend-side package hash
                               verification. Valid time units are "ns",
                               "us", "ms", "s", "m", "h".

Returns the JSON 'result' section, e.g.: {
  "package": "infra/tools/cipd/android-amd64",
  "instance_id": "433bfdf86c0bb82d1eee2d1a0473d3709c25d2c4"
}

&emsp; **@property**<br>&mdash; **def [default\_bot\_service\_account\_credentials](/recipes/recipe_modules/cipd/api.py#200)(self):**

&mdash; **def [describe](/recipes/recipe_modules/cipd/api.py#447)(self, package_name, version, test_data_refs=None, test_data_tags=None):**

&mdash; **def [ensure](/recipes/recipe_modules/cipd/api.py#362)(self, root, packages):**

Ensures that packages are installed in a given root dir.

packages must be a mapping from package name to its version, where
  * name must be for right platform (see also ``platform_suffix``),
  * version could be either instance_id, or ref, or unique tag.

If installing a package requires credentials, call
``set_service_account_credentials`` before calling this function.

&emsp; **@property**<br>&mdash; **def [executable](/recipes/recipe_modules/cipd/api.py#196)(self):**

&mdash; **def [initialize](/recipes/recipe_modules/cipd/api.py#190)(self):**

&mdash; **def [platform\_suffix](/recipes/recipe_modules/cipd/api.py#209)(self, name=None, arch=None, bits=None):**

Use to get full package name that is platform indepdent.

Example:
  >>> 'my/package/%s' % api.cipd.platform_suffix()
  'my/package/linux-amd64'

Optional platform bits and architecture may be supplied to generate CIPD
suffixes for other platforms. If any are omitted, the current platform
parameters will be used.

&mdash; **def [register](/recipes/recipe_modules/cipd/api.py#264)(self, package_name, package_path, refs=None, tags=None):**

&mdash; **def [search](/recipes/recipe_modules/cipd/api.py#429)(self, package_name, tag):**

&mdash; **def [set\_ref](/recipes/recipe_modules/cipd/api.py#409)(self, package_name, version, refs):**

&mdash; **def [set\_service\_account\_credentials](/recipes/recipe_modules/cipd/api.py#193)(self, path):**

&mdash; **def [set\_tag](/recipes/recipe_modules/cipd/api.py#389)(self, package_name, version, tags):**
### *recipe_modules* / [depot\_tools](/recipes/recipe_modules/depot_tools)

[DEPS](/recipes/recipe_modules/depot_tools/__init__.py#5): [recipe\_engine/context][recipe_engine/recipe_modules/context], [recipe\_engine/platform][recipe_engine/recipe_modules/platform], [recipe\_engine/runtime][recipe_engine/recipe_modules/runtime]

The `depot_tools` module provides safe functions to access paths within
the depot_tools repo.

#### **class [DepotToolsApi](/recipes/recipe_modules/depot_tools/api.py#12)([RecipeApi][recipe_engine/wkt/RecipeApi]):**

&emsp; **@property**<br>&mdash; **def [autoninja\_path](/recipes/recipe_modules/depot_tools/api.py#45)(self):**

&emsp; **@property**<br>&mdash; **def [cros\_path](/recipes/recipe_modules/depot_tools/api.py#26)(self):**

&emsp; **@property**<br>&mdash; **def [download\_from\_google\_storage\_path](/recipes/recipe_modules/depot_tools/api.py#13)(self):**

&emsp; **@property**<br>&mdash; **def [gn\_py\_path](/recipes/recipe_modules/depot_tools/api.py#30)(self):**

&emsp; **@property**<br>&mdash; **def [gsutil\_py\_path](/recipes/recipe_modules/depot_tools/api.py#36)(self):**

&emsp; **@property**<br>&mdash; **def [ninja\_path](/recipes/recipe_modules/depot_tools/api.py#40)(self):**

&emsp; **@contextlib.contextmanager**<br>&mdash; **def [on\_path](/recipes/recipe_modules/depot_tools/api.py#54)(self):**

Use this context manager to put depot_tools on $PATH.

Example:

```python
with api.depot_tools.on_path():
  # run some steps
```

&emsp; **@property**<br>&mdash; **def [presubmit\_support\_py\_path](/recipes/recipe_modules/depot_tools/api.py#50)(self):**

&emsp; **@property**<br>&mdash; **def [root](/recipes/recipe_modules/depot_tools/api.py#21)(self):**

Returns (Path): The "depot_tools" root directory.

&emsp; **@property**<br>&mdash; **def [upload\_to\_google\_storage\_path](/recipes/recipe_modules/depot_tools/api.py#17)(self):**
### *recipe_modules* / [gclient](/recipes/recipe_modules/gclient)

[DEPS](/recipes/recipe_modules/gclient/__init__.py#1): [git](#recipe_modules-git), [gitiles](#recipe_modules-gitiles), [tryserver](#recipe_modules-tryserver), [recipe\_engine/buildbucket][recipe_engine/recipe_modules/buildbucket], [recipe\_engine/context][recipe_engine/recipe_modules/context], [recipe\_engine/json][recipe_engine/recipe_modules/json], [recipe\_engine/path][recipe_engine/recipe_modules/path], [recipe\_engine/platform][recipe_engine/recipe_modules/platform], [recipe\_engine/properties][recipe_engine/recipe_modules/properties], [recipe\_engine/python][recipe_engine/recipe_modules/python], [recipe\_engine/raw\_io][recipe_engine/recipe_modules/raw_io], [recipe\_engine/step][recipe_engine/recipe_modules/step]

#### **class [GclientApi](/recipes/recipe_modules/gclient/api.py#77)([RecipeApi][recipe_engine/wkt/RecipeApi]):**

&emsp; **@property**<br>&mdash; **def [DepsDiffException](/recipes/recipe_modules/gclient/api.py#440)(self):**

&mdash; **def [\_\_call\_\_](/recipes/recipe_modules/gclient/api.py#87)(self, name, cmd, infra_step=True, \*\*kwargs):**

Wrapper for easy calling of gclient steps.

&mdash; **def [break\_locks](/recipes/recipe_modules/gclient/api.py#291)(self):**

Remove all index.lock files. If a previous run of git crashed, bot was
reset, etc... we might end up with leftover index.lock files.

&mdash; **def [checkout](/recipes/recipe_modules/gclient/api.py#251)(self, gclient_config=None, revert=RevertOnTryserver, inject_parent_got_revision=True, extra_sync_flags=None, \*\*kwargs):**

Return a step generator function for gclient checkouts.

&emsp; **@staticmethod**<br>&mdash; **def [config\_to\_pythonish](/recipes/recipe_modules/gclient/api.py#139)(cfg):**

&mdash; **def [diff\_deps](/recipes/recipe_modules/gclient/api.py#383)(self, cwd):**

&mdash; **def [get\_config\_defaults](/recipes/recipe_modules/gclient/api.py#133)(self):**

&mdash; **def [get\_gerrit\_patch\_root](/recipes/recipe_modules/gclient/api.py#314)(self, gclient_config=None):**

Returns local path to the repo where gerrit patch will be applied.

If there is no patch, returns None.
If patch is specified, but such repo is not found among configured solutions
or repo_path_map, returns name of the first solution. This is done solely
for backward compatibility with existing tests.
Please do not rely on this logic in new code.
Instead, properly map a repository to a local path using repo_path_map.
TODO(nodir): remove this. Update all recipe tests to specify a git_repo
matching the recipe.

&mdash; **def [get\_repo\_path](/recipes/recipe_modules/gclient/api.py#341)(self, repo_url, gclient_config=None):**

Returns local path to the repo checkout given its url.

Consults cfg.repo_path_map and fallbacks to urls in configured solutions.

Returns None if not found.

&emsp; **@staticmethod**<br>&mdash; **def [got\_revision\_reverse\_mapping](/recipes/recipe_modules/gclient/api.py#144)(cfg):**

Returns the merged got_revision_reverse_mapping.

Returns (dict): A mapping from property name -> project name. It merges the
    values of the deprecated got_revision_mapping and the new
    got_revision_reverse_mapping.

&mdash; **def [inject\_parent\_got\_revision](/recipes/recipe_modules/gclient/api.py#226)(self, gclient_config=None, override=False):**

Match gclient config to build revisions obtained from build_properties.

Args:
  gclient_config (gclient config object) - The config to manipulate. A value
    of None manipulates the module's built-in config (self.c).
  override (bool) - If True, will forcibly set revision and custom_vars
    even if the config already contains values for them.

&mdash; **def [resolve\_revision](/recipes/recipe_modules/gclient/api.py#161)(self, revision):**

&mdash; **def [runhooks](/recipes/recipe_modules/gclient/api.py#285)(self, args=None, name='runhooks', \*\*kwargs):**

&mdash; **def [set\_patch\_repo\_revision](/recipes/recipe_modules/gclient/api.py#371)(self, gclient_config=None):**

Updates config revision corresponding to patched project.

Useful for bot_update only, as this is the only consumer of gclient's config
revision map. This doesn't overwrite the revision if it was already set.

&emsp; **@spec_alias.deleter**<br>&mdash; **def [spec\_alias](/recipes/recipe_modules/gclient/api.py#129)(self):**

&mdash; **def [sync](/recipes/recipe_modules/gclient/api.py#166)(self, cfg, extra_sync_flags=None, \*\*kwargs):**

&emsp; **@use_mirror.setter**<br>&mdash; **def [use\_mirror](/recipes/recipe_modules/gclient/api.py#116)(self, val):**
### *recipe_modules* / [gerrit](/recipes/recipe_modules/gerrit)

[DEPS](/recipes/recipe_modules/gerrit/__init__.py#1): [recipe\_engine/context][recipe_engine/recipe_modules/context], [recipe\_engine/json][recipe_engine/recipe_modules/json], [recipe\_engine/path][recipe_engine/recipe_modules/path], [recipe\_engine/python][recipe_engine/recipe_modules/python], [recipe\_engine/raw\_io][recipe_engine/recipe_modules/raw_io], [recipe\_engine/step][recipe_engine/recipe_modules/step]

#### **class [GerritApi](/recipes/recipe_modules/gerrit/api.py#7)([RecipeApi][recipe_engine/wkt/RecipeApi]):**

Module for interact with Gerrit endpoints

&mdash; **def [\_\_call\_\_](/recipes/recipe_modules/gerrit/api.py#14)(self, name, cmd, infra_step=True, \*\*kwargs):**

Wrapper for easy calling of gerrit_utils steps.

&mdash; **def [abandon\_change](/recipes/recipe_modules/gerrit/api.py#209)(self, host, change, message=None, name=None, step_test_data=None):**

&mdash; **def [create\_gerrit\_branch](/recipes/recipe_modules/gerrit/api.py#32)(self, host, project, branch, commit, \*\*kwargs):**

Creates a new branch from given project and commit

Returns:
  The ref of the branch created

&mdash; **def [get\_change\_description](/recipes/recipe_modules/gerrit/api.py#71)(self, host, change, patchset, timeout=None, step_test_data=None):**

Gets the description for a given CL and patchset.

Args:
  host: URL of Gerrit host to query.
  change: The change number.
  patchset: The patchset number.

Returns:
  The description corresponding to given CL and patchset.

&mdash; **def [get\_changes](/recipes/recipe_modules/gerrit/api.py#131)(self, host, query_params, start=None, limit=None, o_params=None, step_test_data=None, \*\*kwargs):**

Queries changes for the given host.

Args:
  * host: URL of Gerrit host to query.
  * query_params: Query parameters as list of (key, value) tuples to form a
      query as documented here:
      https://gerrit-review.googlesource.com/Documentation/user-search.html#search-operators
  * start: How many changes to skip (starting with the most recent).
  * limit: Maximum number of results to return.
  * o_params: A list of additional output specifiers, as documented here:
      https://gerrit-review.googlesource.com/Documentation/rest-api-changes.html#list-changes
  * step_test_data: Optional mock test data for the underlying gerrit client.

Returns:
  A list of change dicts as documented here:
      https://gerrit-review.googlesource.com/Documentation/rest-api-changes.html#list-changes

&mdash; **def [get\_gerrit\_branch](/recipes/recipe_modules/gerrit/api.py#53)(self, host, project, branch, \*\*kwargs):**

Gets a branch from given project and commit

Returns:
  The revision of the branch

&mdash; **def [get\_related\_changes](/recipes/recipe_modules/gerrit/api.py#173)(self, host, change, revision='current', step_test_data=None):**

Queries related changes for a given host, change, and revision.

Args:
  * host: URL of Gerrit host to query.
  * change: The change-id of the change to get related changes for as
      documented here:
      https://gerrit-review.googlesource.com/Documentation/rest-api-changes.html#change-id
  * revision: The revision-id of the revision to get related changes for as
      documented here:
      https://gerrit-review.googlesource.com/Documentation/rest-api-changes.html#revision-id
      This defaults to current, which names the most recent patch set.
  * step_test_data: Optional mock test data for the underlying gerrit client.

Returns:
  A related changes dictionary as documented here:
      https://gerrit-review.googlesource.com/Documentation/rest-api-changes.html#related-changes-info

&mdash; **def [get\_revision\_info](/recipes/recipe_modules/gerrit/api.py#90)(self, host, change, patchset, timeout=None, step_test_data=None):**

Returns the info for a given patchset of a given change.

Args:
  host: Gerrit host to query.
  change: The change number.
  patchset: The patchset number.

Returns:
  A dict for the target revision as documented here:
      https://gerrit-review.googlesource.com/Documentation/rest-api-changes.html#list-changes

&mdash; **def [move\_changes](/recipes/recipe_modules/gerrit/api.py#229)(self, host, project, from_branch, to_branch, step_test_data=None):**
### *recipe_modules* / [git](/recipes/recipe_modules/git)

[DEPS](/recipes/recipe_modules/git/__init__.py#1): [recipe\_engine/buildbucket][recipe_engine/recipe_modules/buildbucket], [recipe\_engine/context][recipe_engine/recipe_modules/context], [recipe\_engine/path][recipe_engine/recipe_modules/path], [recipe\_engine/platform][recipe_engine/recipe_modules/platform], [recipe\_engine/properties][recipe_engine/recipe_modules/properties], [recipe\_engine/python][recipe_engine/recipe_modules/python], [recipe\_engine/raw\_io][recipe_engine/recipe_modules/raw_io], [recipe\_engine/runtime][recipe_engine/recipe_modules/runtime], [recipe\_engine/step][recipe_engine/recipe_modules/step]

#### **class [GitApi](/recipes/recipe_modules/git/api.py#18)([RecipeApi][recipe_engine/wkt/RecipeApi]):**

&mdash; **def [\_\_call\_\_](/recipes/recipe_modules/git/api.py#21)(self, \*args, \*\*kwargs):**

Returns a git command step.

&mdash; **def [bundle\_create](/recipes/recipe_modules/git/api.py#388)(self, bundle_path, rev_list_args=None, \*\*kwargs):**

Runs 'git bundle create' on a Git repository.

Args:
  * bundle_path (Path): The path of the output bundle.
  * refs (list): The list of refs to include in the bundle. If None, all
      refs in the Git checkout will be bundled.
  * kwargs: Forwarded to '__call__'.

&mdash; **def [cat\_file\_at\_commit](/recipes/recipe_modules/git/api.py#48)(self, file_path, commit_hash, remote_name=None, \*\*kwargs):**

Outputs the contents of a file at a given revision.

&mdash; **def [checkout](/recipes/recipe_modules/git/api.py#121)(self, url, ref=None, dir_path=None, recursive=False, submodules=True, submodule_update_force=False, keep_paths=None, step_suffix=None, curl_trace_file=None, can_fail_build=True, set_got_revision=False, remote_name=None, display_fetch_size=None, file_name=None, submodule_update_recursive=True, use_git_cache=False, progress=True, tags=False):**

Performs a full git checkout and returns sha1 of checked out revision.

Args:
  * url (str): url of remote repo to use as upstream
  * ref (str): ref to fetch and check out
  * dir_path (Path): optional directory to clone into
  * recursive (bool): whether to recursively fetch submodules or not
  * submodules (bool): whether to sync and update submodules or not
  * submodule_update_force (bool): whether to update submodules with --force
  * keep_paths (iterable of strings): paths to ignore during git-clean;
      paths are gitignore-style patterns relative to checkout_path.
  * step_suffix (str): suffix to add to a each step name
  * curl_trace_file (Path): if not None, dump GIT_CURL_VERBOSE=1 trace to that
      file. Useful for debugging git issue reproducible only on bots. It has
      a side effect of all stderr output of 'git fetch' going to that file.
  * can_fail_build (bool): if False, ignore errors during fetch or checkout.
  * set_got_revision (bool): if True, resolves HEAD and sets got_revision
      property.
  * remote_name (str): name of the git remote to use
  * display_fetch_size (bool): if True, run `git count-objects` before and
    after fetch and display delta. Adds two more steps. Defaults to False.
  * file_name (str): optional path to a single file to checkout.
  * submodule_update_recursive (bool): if True, updates submodules
      recursively.
  * use_git_cache (bool): if True, git cache will be used for this checkout.
      WARNING, this is EXPERIMENTAL!!! This wasn't tested with:
       * submodules
       * since origin url is modified
         to a local path, may cause problem with scripts that do
         "git fetch origin" or "git push origin".
       * arbitrary refs such refs/whatever/not-fetched-by-default-to-cache
   progress (bool): whether to show progress for fetch or not
  * tags (bool): Also fetch tags.

Returns: If the checkout was successful, this returns the commit hash of
  the checked-out-repo. Otherwise this returns None.

&mdash; **def [config\_get](/recipes/recipe_modules/git/api.py#357)(self, prop_name, \*\*kwargs):**

Returns git config output.

Args:
  * prop_name: (str) The name of the config property to query.
  * kwargs: Forwarded to '__call__'.

Returns: (str) The Git config output, or None if no output was generated.

&mdash; **def [count\_objects](/recipes/recipe_modules/git/api.py#56)(self, previous_result=None, can_fail_build=False, \*\*kwargs):**

Returns `git count-objects` result as a dict.

Args:
  * previous_result (dict): the result of previous count_objects call.
    If passed, delta is reported in the log and step text.
  * can_fail_build (bool): if True, may fail the build and/or raise an
    exception. Defaults to False.

Returns:
  A dict of count-object values, or None if count-object run failed.

&mdash; **def [fetch\_tags](/recipes/recipe_modules/git/api.py#42)(self, remote_name=None, \*\*kwargs):**

Fetches all tags from the remote.

&mdash; **def [get\_remote\_url](/recipes/recipe_modules/git/api.py#376)(self, remote_name=None, \*\*kwargs):**

Returns the remote Git repository URL, or None.

Args:
  * remote_name: (str) The name of the remote to query, defaults to 'origin'.
  * kwargs: Forwarded to '__call__'.

Returns: (str) The URL of the remote Git repository, or None.

&mdash; **def [get\_timestamp](/recipes/recipe_modules/git/api.py#328)(self, commit='HEAD', test_data=None, \*\*kwargs):**

Find and return the timestamp of the given commit.

&mdash; **def [new\_branch](/recipes/recipe_modules/git/api.py#401)(self, branch, name=None, upstream=None, \*\*kwargs):**

Runs git new-branch on a Git repository, to be used before git cl
upload.

Args:
  * branch (str): new branch name, which must not yet exist.
  * name (str): step name.
  * upstream (str): to origin/master.
  * kwargs: Forwarded to '__call__'.

&mdash; **def [rebase](/recipes/recipe_modules/git/api.py#337)(self, name_prefix, branch, dir_path, remote_name=None, \*\*kwargs):**

Runs rebase HEAD onto branch

Args:
  * name_prefix (str): a prefix used for the step names
  * branch (str): a branch name or a hash to rebase onto
  * dir_path (Path): directory to clone into
  * remote_name (str): the remote name to rebase from if not origin
### *recipe_modules* / [git\_cl](/recipes/recipe_modules/git_cl)

[DEPS](/recipes/recipe_modules/git_cl/__init__.py#1): [recipe\_engine/context][recipe_engine/recipe_modules/context], [recipe\_engine/python][recipe_engine/recipe_modules/python], [recipe\_engine/raw\_io][recipe_engine/recipe_modules/raw_io]

#### **class [GitClApi](/recipes/recipe_modules/git_cl/api.py#9)([RecipeApi][recipe_engine/wkt/RecipeApi]):**

&mdash; **def [get\_description](/recipes/recipe_modules/git_cl/api.py#24)(self, patch_url=None, \*\*kwargs):**

DEPRECATED. Consider using gerrit.get_change_description instead.

&mdash; **def [issue](/recipes/recipe_modules/git_cl/api.py#49)(self, \*\*kwargs):**

&mdash; **def [set\_description](/recipes/recipe_modules/git_cl/api.py#32)(self, description, patch_url=None, \*\*kwargs):**

&mdash; **def [upload](/recipes/recipe_modules/git_cl/api.py#42)(self, message, upload_args=None, \*\*kwargs):**
### *recipe_modules* / [gitiles](/recipes/recipe_modules/gitiles)

[DEPS](/recipes/recipe_modules/gitiles/__init__.py#5): [recipe\_engine/json][recipe_engine/recipe_modules/json], [recipe\_engine/path][recipe_engine/recipe_modules/path], [recipe\_engine/python][recipe_engine/recipe_modules/python], [recipe\_engine/raw\_io][recipe_engine/recipe_modules/raw_io], [recipe\_engine/step][recipe_engine/recipe_modules/step], [recipe\_engine/url][recipe_engine/recipe_modules/url]

#### **class [Gitiles](/recipes/recipe_modules/gitiles/api.py#17)([RecipeApi][recipe_engine/wkt/RecipeApi]):**

Module for polling a git repository using the Gitiles web interface.

&mdash; **def [canonicalize\_repo\_url](/recipes/recipe_modules/gitiles/api.py#222)(self, repo_url):**

Returns a canonical form of repo_url. If not recognized, returns as is.
    

&mdash; **def [commit\_log](/recipes/recipe_modules/gitiles/api.py#120)(self, url, commit, step_name=None, attempts=None):**

Returns: (dict) the Gitiles commit log structure for a given commit.

Args:
  * url (str): The base repository URL.
  * commit (str): The commit hash.
  * step_name (str): If not None, override the step name.
  * attempts (int): Number of times to try the request before failing.

&mdash; **def [download\_archive](/recipes/recipe_modules/gitiles/api.py#162)(self, repository_url, destination, revision='refs/heads/master'):**

Downloads an archive of the repo and extracts it to `destination`.

If the gitiles server attempts to provide a tarball with paths which escape
`destination`, this function will extract all valid files and then
raise StepFailure with an attribute `StepFailure.gitiles_skipped_files`
containing the names of the files that were skipped.

Args:
  * repository_url (str): Full URL to the repository
  * destination (Path): Local path to extract the archive to. Must not exist
    prior to this call.
  * revision (str): The ref or revision in the repo to download. Defaults to
    'refs/heads/master'.

&mdash; **def [download\_file](/recipes/recipe_modules/gitiles/api.py#136)(self, repository_url, file_path, branch='master', step_name=None, attempts=None, \*\*kwargs):**

Downloads raw file content from a Gitiles repository.

Args:
  * repository_url (str): Full URL to the repository.
  * branch (str): Branch of the repository.
  * file_path (str): Relative path to the file from the repository root.
  * step_name (str): Custom name for this step (optional).
  * attempts (int): Number of times to try the request before failing.

Returns:
  Raw file content.

&mdash; **def [log](/recipes/recipe_modules/gitiles/api.py#74)(self, url, ref, limit=0, cursor=None, step_name=None, attempts=None, \*\*kwargs):**

Returns the most recent commits under the given ref with properties.

Args:
  * url (str): URL of the remote repository.
  * ref (str): Name of the desired ref (see Gitiles.refs).
  * limit (int): Number of commits to limit the fetching to.
    Gitiles does not return all commits in one call; instead paging is
    used. 0 implies to return whatever first gerrit responds with.
    Otherwise, paging will be used to fetch at least this many
    commits, but all fetched commits will be returned.
  * cursor (str or None): The paging cursor used to fetch the next page.
  * step_name (str): Custom name for this step (optional).

Returns:
  A tuple of (commits, cursor).
  Commits are a list of commits (as Gitiles dict structure) in reverse
  chronological order. The number of commits may be higher than limit
  argument.
  Cursor can be used for subsequent calls to log for paging. If None,
  signals that there are no more commits to fetch.

&mdash; **def [parse\_repo\_url](/recipes/recipe_modules/gitiles/api.py#211)(self, repo_url):**

Returns (host, project) pair.

Returns (None, None) if repo_url is not recognized.

&mdash; **def [refs](/recipes/recipe_modules/gitiles/api.py#62)(self, url, step_name='refs', attempts=None):**

Returns a list of refs in the remote repository.

&mdash; **def [unparse\_repo\_url](/recipes/recipe_modules/gitiles/api.py#218)(self, host, project):**

Generates a Gitiles repo URL. See also parse_repo_url.
### *recipe_modules* / [gsutil](/recipes/recipe_modules/gsutil)

[DEPS](/recipes/recipe_modules/gsutil/__init__.py#1): [recipe\_engine/path][recipe_engine/recipe_modules/path], [recipe\_engine/python][recipe_engine/recipe_modules/python]

#### **class [GSUtilApi](/recipes/recipe_modules/gsutil/api.py#9)([RecipeApi][recipe_engine/wkt/RecipeApi]):**

&mdash; **def [\_\_call\_\_](/recipes/recipe_modules/gsutil/api.py#14)(self, cmd, name=None, use_retry_wrapper=True, version=None, parallel_upload=False, multithreaded=False, infra_step=True, \*\*kwargs):**

A step to run arbitrary gsutil commands.

On LUCI this should automatically use the ambient task account credentials.
On Buildbot, this assumes that gsutil authentication environment variables
(AWS_CREDENTIAL_FILE and BOTO_CONFIG) are already set, though if you want to
set them to something else you can always do so using the env={} kwarg.

Note also that gsutil does its own wildcard processing, so wildcards are
valid in file-like portions of the cmd. See 'gsutil help wildcards'.

Args:
  * cmd (List[str|Path]) - Arguments to pass to gsutil. Include gsutil-level
      options first (see 'gsutil help options').
  * name (str) - Name of the step to use. Defaults to the first non-flag
      token in the cmd.

&mdash; **def [cat](/recipes/recipe_modules/gsutil/api.py#108)(self, url, args=None, \*\*kwargs):**

&mdash; **def [copy](/recipes/recipe_modules/gsutil/api.py#122)(self, source_bucket, source, dest_bucket, dest, args=None, link_name='gsutil.copy', metadata=None, unauthenticated_url=False, \*\*kwargs):**

&mdash; **def [download](/recipes/recipe_modules/gsutil/api.py#94)(self, bucket, source, dest, args=None, \*\*kwargs):**

&mdash; **def [download\_url](/recipes/recipe_modules/gsutil/api.py#101)(self, url, dest, args=None, \*\*kwargs):**

&emsp; **@property**<br>&mdash; **def [gsutil\_py\_path](/recipes/recipe_modules/gsutil/api.py#10)(self):**

&mdash; **def [list](/recipes/recipe_modules/gsutil/api.py#141)(self, url, args=None, \*\*kwargs):**

&mdash; **def [remove\_url](/recipes/recipe_modules/gsutil/api.py#155)(self, url, args=None, \*\*kwargs):**

&mdash; **def [signurl](/recipes/recipe_modules/gsutil/api.py#148)(self, private_key_file, bucket, dest, args=None, \*\*kwargs):**

&mdash; **def [stat](/recipes/recipe_modules/gsutil/api.py#115)(self, url, args=None, \*\*kwargs):**

&mdash; **def [upload](/recipes/recipe_modules/gsutil/api.py#77)(self, source, bucket, dest, args=None, link_name='gsutil.upload', metadata=None, unauthenticated_url=False, \*\*kwargs):**
### *recipe_modules* / [osx\_sdk](/recipes/recipe_modules/osx_sdk)

[DEPS](/recipes/recipe_modules/osx_sdk/__init__.py#5): [recipe\_engine/cipd][recipe_engine/recipe_modules/cipd], [recipe\_engine/context][recipe_engine/recipe_modules/context], [recipe\_engine/json][recipe_engine/recipe_modules/json], [recipe\_engine/path][recipe_engine/recipe_modules/path], [recipe\_engine/platform][recipe_engine/recipe_modules/platform], [recipe\_engine/step][recipe_engine/recipe_modules/step], [recipe\_engine/version][recipe_engine/recipe_modules/version]

The `osx_sdk` module provides safe functions to access a semi-hermetic
XCode installation.

Available only to Google-run bots.

#### **class [OSXSDKApi](/recipes/recipe_modules/osx_sdk/api.py#36)([RecipeApi][recipe_engine/wkt/RecipeApi]):**

API for using OS X SDK distributed via CIPD.

&emsp; **@contextmanager**<br>&mdash; **def [\_\_call\_\_](/recipes/recipe_modules/osx_sdk/api.py#62)(self, kind):**

Sets up the XCode SDK environment.

Is a no-op on non-mac platforms.

This will deploy the helper tool and the XCode.app bundle at
`[START_DIR]/cache/osx_sdk`.

To avoid machines rebuilding these on every run, set up a named cache in
your cr-buildbucket.cfg file like:

    caches: {
      # Cache for mac_toolchain tool and XCode.app
      name: "osx_sdk"
      path: "osx_sdk"
    }

If you have builders which e.g. use a non-current SDK, you can give them
a uniqely named cache:

    caches: {
      # Cache for N-1 version mac_toolchain tool and XCode.app
      name: "osx_sdk_old"
      path: "osx_sdk"
    }

Similarly, if you have mac and iOS builders you may want to distinguish the
cache name by adding '_ios' to it. However, if you're sharing the same bots
for both mac and iOS, consider having a single cache and just always
fetching the iOS version. This will lead to lower overall disk utilization
and should help to reduce cache thrashing.

Usage:
  with api.osx_sdk('mac'):
    # sdk with mac build bits

  with api.osx_sdk('ios'):
    # sdk with mac+iOS build bits

Args:
  kind ('mac'|'ios'): How the SDK should be configured. iOS includes the
    base XCode distribution, as well as the iOS simulators (which can be
    quite large).

Raises:
    StepFailure or InfraFailure.

&mdash; **def [initialize](/recipes/recipe_modules/osx_sdk/api.py#47)(self):**
### *recipe_modules* / [presubmit](/recipes/recipe_modules/presubmit)

[DEPS](/recipes/recipe_modules/presubmit/__init__.py#11): [bot\_update](#recipe_modules-bot_update), [depot\_tools](#recipe_modules-depot_tools), [gclient](#recipe_modules-gclient), [git](#recipe_modules-git), [tryserver](#recipe_modules-tryserver), [recipe\_engine/context][recipe_engine/recipe_modules/context], [recipe\_engine/cq][recipe_engine/recipe_modules/cq], [recipe\_engine/json][recipe_engine/recipe_modules/json], [recipe\_engine/path][recipe_engine/recipe_modules/path], [recipe\_engine/properties][recipe_engine/recipe_modules/properties], [recipe\_engine/python][recipe_engine/recipe_modules/python], [recipe\_engine/resultdb][recipe_engine/recipe_modules/resultdb], [recipe\_engine/step][recipe_engine/recipe_modules/step]

#### **class [PresubmitApi](/recipes/recipe_modules/presubmit/api.py#16)([RecipeApi][recipe_engine/wkt/RecipeApi]):**

&mdash; **def [\_\_call\_\_](/recipes/recipe_modules/presubmit/api.py#28)(self, \*args, \*\*kwargs):**

Returns a presubmit step.

&mdash; **def [execute](/recipes/recipe_modules/presubmit/api.py#100)(self, bot_update_step, skip_owners=False):**

Runs presubmit and sets summary markdown if applicable.

Args:
  * bot_update_step: the StepResult from a previously executed bot_update step.
  * skip_owners: a boolean indicating whether Owners checks should be skipped.

Returns:
  a RawResult object, suitable for being returned from RunSteps.

&mdash; **def [prepare](/recipes/recipe_modules/presubmit/api.py#65)(self):**

Sets up a presubmit run.

This includes:
  - setting up the checkout w/ bot_update
  - locally committing the applied patch
  - running hooks, if requested

This expects the gclient configuration to already have been set.

Returns:
  the StepResult from the bot_update step.

&emsp; **@property**<br>&mdash; **def [presubmit\_support\_path](/recipes/recipe_modules/presubmit/api.py#24)(self):**
### *recipe_modules* / [tryserver](/recipes/recipe_modules/tryserver)

[DEPS](/recipes/recipe_modules/tryserver/__init__.py#5): [gerrit](#recipe_modules-gerrit), [git](#recipe_modules-git), [git\_cl](#recipe_modules-git_cl), [recipe\_engine/buildbucket][recipe_engine/recipe_modules/buildbucket], [recipe\_engine/context][recipe_engine/recipe_modules/context], [recipe\_engine/json][recipe_engine/recipe_modules/json], [recipe\_engine/path][recipe_engine/recipe_modules/path], [recipe\_engine/platform][recipe_engine/recipe_modules/platform], [recipe\_engine/properties][recipe_engine/recipe_modules/properties], [recipe\_engine/python][recipe_engine/recipe_modules/python], [recipe\_engine/raw\_io][recipe_engine/recipe_modules/raw_io], [recipe\_engine/step][recipe_engine/recipe_modules/step]

#### **class [TryserverApi](/recipes/recipe_modules/tryserver/api.py#27)([RecipeApi][recipe_engine/wkt/RecipeApi]):**

&emsp; **@property**<br>&mdash; **def [constants](/recipes/recipe_modules/tryserver/api.py#49)(self):**

&emsp; **@property**<br>&mdash; **def [gerrit\_change](/recipes/recipe_modules/tryserver/api.py#54)(self):**

Returns current gerrit change, if there is exactly one.

Returns a self.m.buildbucket.common_pb2.GerritChange or None.

&emsp; **@property**<br>&mdash; **def [gerrit\_change\_fetch\_ref](/recipes/recipe_modules/tryserver/api.py#131)(self):**

Returns gerrit patch ref, e.g. "refs/heads/45/12345/6, or None.

Populated iff gerrit_change is populated.

&emsp; **@property**<br>&mdash; **def [gerrit\_change\_number](/recipes/recipe_modules/tryserver/api.py#149)(self):**

Returns gerrit change patchset, e.g. 12345 for a patch ref of
"refs/heads/45/12345/6".

Populated iff gerrit_change is populated. Returns None if not populated.

&emsp; **@property**<br>&mdash; **def [gerrit\_change\_owner](/recipes/recipe_modules/tryserver/api.py#70)(self):**

Returns owner of the current Gerrit CL.

Populated iff gerrit_change is populated.
Is a dictionary with keys like "name".

&emsp; **@property**<br>&mdash; **def [gerrit\_change\_repo\_url](/recipes/recipe_modules/tryserver/api.py#62)(self):**

Returns canonical URL of the gitiles repo of the current Gerrit CL.

Populated iff gerrit_change is populated.

&emsp; **@property**<br>&mdash; **def [gerrit\_change\_target\_ref](/recipes/recipe_modules/tryserver/api.py#140)(self):**

Returns gerrit change destination ref, e.g. "refs/heads/master".

Populated iff gerrit_change is populated.

&emsp; **@property**<br>&mdash; **def [gerrit\_patchset\_number](/recipes/recipe_modules/tryserver/api.py#161)(self):**

Returns gerrit change patchset, e.g. 6 for a patch ref of
"refs/heads/45/12345/6".

Populated iff gerrit_change is populated Returns None if not populated..

&mdash; **def [get\_files\_affected\_by\_patch](/recipes/recipe_modules/tryserver/api.py#194)(self, patch_root, report_files_via_property=None, \*\*kwargs):**

Returns list of paths to files affected by the patch.

Args:
  * patch_root: path relative to api.path['root'], usually obtained from
    api.gclient.get_gerrit_patch_root().
  * report_files_via_property: name of the output property to report the
    list of the files. If None (default), do not report.

Returned paths will be relative to to patch_root.

&mdash; **def [get\_footer](/recipes/recipe_modules/tryserver/api.py#334)(self, tag, patch_text=None):**

Gets a specific tag from a CL description

&mdash; **def [get\_footers](/recipes/recipe_modules/tryserver/api.py#298)(self, patch_text=None):**

Retrieves footers from the patch description.

footers are machine readable tags embedded in commit messages. See
git-footers documentation for more information.

&mdash; **def [initialize](/recipes/recipe_modules/tryserver/api.py#40)(self):**

&emsp; **@property**<br>&mdash; **def [is\_gerrit\_issue](/recipes/recipe_modules/tryserver/api.py#178)(self):**

Returns true iff the properties exist to match a Gerrit issue.

&emsp; **@property**<br>&mdash; **def [is\_patch\_in\_git](/recipes/recipe_modules/tryserver/api.py#188)(self):**

&emsp; **@property**<br>&mdash; **def [is\_tryserver](/recipes/recipe_modules/tryserver/api.py#173)(self):**

Returns true iff we have a change to check out.

&mdash; **def [normalize\_footer\_name](/recipes/recipe_modules/tryserver/api.py#342)(self, footer):**

&mdash; **def [set\_change](/recipes/recipe_modules/tryserver/api.py#345)(self, change):**

Set the gerrit change for this module.

Args:
  * change: a self.m.buildbucket.common_pb2.GerritChange.

&mdash; **def [set\_compile\_failure\_tryjob\_result](/recipes/recipe_modules/tryserver/api.py#259)(self):**

Mark the tryjob result as a compile failure.

&mdash; **def [set\_invalid\_test\_results\_tryjob\_result](/recipes/recipe_modules/tryserver/api.py#271)(self):**

Mark the tryjob result as having invalid test results.

This means we run some tests, but the results were not valid
(e.g. no list of specific test cases that failed, or too many
tests failing, etc).

&mdash; **def [set\_patch\_failure\_tryjob\_result](/recipes/recipe_modules/tryserver/api.py#255)(self):**

Mark the tryjob result as failure to apply the patch.

&mdash; **def [set\_subproject\_tag](/recipes/recipe_modules/tryserver/api.py#233)(self, subproject_tag):**

Adds a subproject tag to the build.

This can be used to distinguish between builds that execute different steps
depending on what was patched, e.g. blink vs. pure chromium patches.

&mdash; **def [set\_test\_expired\_tryjob\_result](/recipes/recipe_modules/tryserver/api.py#288)(self):**

Mark the tryjob result as a test expiration.

This means a test task expired and was never scheduled, most likely due to
lack of capacity.

&mdash; **def [set\_test\_failure\_tryjob\_result](/recipes/recipe_modules/tryserver/api.py#263)(self):**

Mark the tryjob result as a test failure.

This means we started running actual tests (not prerequisite steps
like checkout or compile), and some of these tests have failed.

&mdash; **def [set\_test\_timeout\_tryjob\_result](/recipes/recipe_modules/tryserver/api.py#280)(self):**

Mark the tryjob result as a test timeout.

This means tests were scheduled but didn't finish executing within the
timeout.

&emsp; **@property**<br>&mdash; **def [valid\_footers](/recipes/recipe_modules/tryserver/api.py#45)(self):**
### *recipe_modules* / [windows\_sdk](/recipes/recipe_modules/windows_sdk)

[DEPS](/recipes/recipe_modules/windows_sdk/__init__.py#5): [recipe\_engine/cipd][recipe_engine/recipe_modules/cipd], [recipe\_engine/context][recipe_engine/recipe_modules/context], [recipe\_engine/json][recipe_engine/recipe_modules/json], [recipe\_engine/path][recipe_engine/recipe_modules/path], [recipe\_engine/step][recipe_engine/recipe_modules/step]

The `windows_sdk` module provides safe functions to access a hermetic
Microsoft Visual Studio installation.

Available only to Google-run bots.

#### **class [WindowsSDKApi](/recipes/recipe_modules/windows_sdk/api.py#17)([RecipeApi][recipe_engine/wkt/RecipeApi]):**

API for using Windows SDK distributed via CIPD.

&emsp; **@contextmanager**<br>&mdash; **def [\_\_call\_\_](/recipes/recipe_modules/windows_sdk/api.py#27)(self, path=None, version=None, enabled=True, target_arch='x64'):**

Sets up the SDK environment when enabled.

Args:
  * path (path): Path to a directory where to install the SDK
    (default is '[CACHE]/windows_sdk')
  * version (str): CIPD version of the SDK
    (default is set via $infra/windows_sdk.version property)
  * enabled (bool): Whether the SDK should be used or not.
  * target_arch (str): 'x86' or 'x64'.

Yields:
  If enabled, yields SDKPaths object with paths to well-known roots within
  the deployed bundle:
    * win_sdk - a Path to the root of the extracted Windows SDK.
    * dia_sdk - a Path to the root of the extracted Debug Interface Access
      SDK.

Raises:
    StepFailure or InfraFailure.
## Recipes

### *recipes* / [bot\_update:examples/full](/recipes/recipe_modules/bot_update/examples/full.py)

[DEPS](/recipes/recipe_modules/bot_update/examples/full.py#5): [bot\_update](#recipe_modules-bot_update), [gclient](#recipe_modules-gclient), [gerrit](#recipe_modules-gerrit), [tryserver](#recipe_modules-tryserver), [recipe\_engine/buildbucket][recipe_engine/recipe_modules/buildbucket], [recipe\_engine/json][recipe_engine/recipe_modules/json], [recipe\_engine/path][recipe_engine/recipe_modules/path], [recipe\_engine/platform][recipe_engine/recipe_modules/platform], [recipe\_engine/properties][recipe_engine/recipe_modules/properties], [recipe\_engine/runtime][recipe_engine/recipe_modules/runtime]

&mdash; **def [RunSteps](/recipes/recipe_modules/bot_update/examples/full.py#23)(api):**
### *recipes* / [bot\_update:tests/do\_not\_retry\_patch\_failures\_in\_cq](/recipes/recipe_modules/bot_update/tests/do_not_retry_patch_failures_in_cq.py)

[DEPS](/recipes/recipe_modules/bot_update/tests/do_not_retry_patch_failures_in_cq.py#5): [bot\_update](#recipe_modules-bot_update), [gclient](#recipe_modules-gclient), [recipe\_engine/buildbucket][recipe_engine/recipe_modules/buildbucket], [recipe\_engine/cq][recipe_engine/recipe_modules/cq], [recipe\_engine/properties][recipe_engine/recipe_modules/properties], [recipe\_engine/step][recipe_engine/recipe_modules/step]

&mdash; **def [RunSteps](/recipes/recipe_modules/bot_update/tests/do_not_retry_patch_failures_in_cq.py#17)(api):**
### *recipes* / [bot\_update:tests/ensure\_checkout](/recipes/recipe_modules/bot_update/tests/ensure_checkout.py)

[DEPS](/recipes/recipe_modules/bot_update/tests/ensure_checkout.py#7): [bot\_update](#recipe_modules-bot_update), [gclient](#recipe_modules-gclient), [recipe\_engine/json][recipe_engine/recipe_modules/json]

&mdash; **def [RunSteps](/recipes/recipe_modules/bot_update/tests/ensure_checkout.py#14)(api):**
### *recipes* / [cipd:examples/full](/recipes/recipe_modules/cipd/examples/full.py)

[DEPS](/recipes/recipe_modules/cipd/examples/full.py#8): [cipd](#recipe_modules-cipd), [recipe\_engine/path][recipe_engine/recipe_modules/path], [recipe\_engine/platform][recipe_engine/recipe_modules/platform], [recipe\_engine/properties][recipe_engine/recipe_modules/properties], [recipe\_engine/step][recipe_engine/recipe_modules/step]

&mdash; **def [RunSteps](/recipes/recipe_modules/cipd/examples/full.py#27)(api, use_pkg, pkg_files, pkg_dirs, ver_files, install_mode):**
### *recipes* / [cipd:examples/platform\_suffix](/recipes/recipe_modules/cipd/examples/platform_suffix.py)

[DEPS](/recipes/recipe_modules/cipd/examples/platform_suffix.py#8): [cipd](#recipe_modules-cipd), [recipe\_engine/path][recipe_engine/recipe_modules/path], [recipe\_engine/platform][recipe_engine/recipe_modules/platform], [recipe\_engine/properties][recipe_engine/recipe_modules/properties], [recipe\_engine/step][recipe_engine/recipe_modules/step]

&mdash; **def [RunSteps](/recipes/recipe_modules/cipd/examples/platform_suffix.py#22)(api, arch_override, bits_override, expect_error):**
### *recipes* / [depot\_tools:examples/full](/recipes/recipe_modules/depot_tools/examples/full.py)

[DEPS](/recipes/recipe_modules/depot_tools/examples/full.py#5): [depot\_tools](#recipe_modules-depot_tools), [recipe\_engine/path][recipe_engine/recipe_modules/path], [recipe\_engine/platform][recipe_engine/recipe_modules/platform], [recipe\_engine/runtime][recipe_engine/recipe_modules/runtime], [recipe\_engine/step][recipe_engine/recipe_modules/step]

&mdash; **def [RunSteps](/recipes/recipe_modules/depot_tools/examples/full.py#14)(api):**
### *recipes* / [fetch\_end\_to\_end\_test](/recipes/recipes/fetch_end_to_end_test.py)

[DEPS](/recipes/recipes/fetch_end_to_end_test.py#5): [bot\_update](#recipe_modules-bot_update), [gclient](#recipe_modules-gclient), [recipe\_engine/context][recipe_engine/recipe_modules/context], [recipe\_engine/file][recipe_engine/recipe_modules/file], [recipe\_engine/path][recipe_engine/recipe_modules/path], [recipe\_engine/python][recipe_engine/recipe_modules/python], [recipe\_engine/step][recipe_engine/recipe_modules/step]

&mdash; **def [RunSteps](/recipes/recipes/fetch_end_to_end_test.py#16)(api):**
### *recipes* / [gclient:examples/full](/recipes/recipe_modules/gclient/examples/full.py)

[DEPS](/recipes/recipe_modules/gclient/examples/full.py#5): [gclient](#recipe_modules-gclient), [recipe\_engine/buildbucket][recipe_engine/recipe_modules/buildbucket], [recipe\_engine/context][recipe_engine/recipe_modules/context], [recipe\_engine/path][recipe_engine/recipe_modules/path], [recipe\_engine/properties][recipe_engine/recipe_modules/properties], [recipe\_engine/step][recipe_engine/recipe_modules/step]

&mdash; **def [RunSteps](/recipes/recipe_modules/gclient/examples/full.py#63)(api):**
### *recipes* / [gclient:tests/diff\_deps](/recipes/recipe_modules/gclient/tests/diff_deps.py)

[DEPS](/recipes/recipe_modules/gclient/tests/diff_deps.py#7): [gclient](#recipe_modules-gclient), [recipe\_engine/assertions][recipe_engine/recipe_modules/assertions], [recipe\_engine/buildbucket][recipe_engine/recipe_modules/buildbucket], [recipe\_engine/path][recipe_engine/recipe_modules/path], [recipe\_engine/platform][recipe_engine/recipe_modules/platform], [recipe\_engine/properties][recipe_engine/recipe_modules/properties], [recipe\_engine/raw\_io][recipe_engine/recipe_modules/raw_io]

&mdash; **def [RunSteps](/recipes/recipe_modules/gclient/tests/diff_deps.py#18)(api):**
### *recipes* / [gclient:tests/patch\_project](/recipes/recipe_modules/gclient/tests/patch_project.py)

[DEPS](/recipes/recipe_modules/gclient/tests/patch_project.py#9): [gclient](#recipe_modules-gclient), [recipe\_engine/buildbucket][recipe_engine/recipe_modules/buildbucket], [recipe\_engine/path][recipe_engine/recipe_modules/path], [recipe\_engine/properties][recipe_engine/recipe_modules/properties]

&mdash; **def [RunSteps](/recipes/recipe_modules/gclient/tests/patch_project.py#18)(api):**
### *recipes* / [gclient:tests/sync\_failure](/recipes/recipe_modules/gclient/tests/sync_failure.py)

[DEPS](/recipes/recipe_modules/gclient/tests/sync_failure.py#7): [gclient](#recipe_modules-gclient), [recipe\_engine/path][recipe_engine/recipe_modules/path]

&mdash; **def [RunSteps](/recipes/recipe_modules/gclient/tests/sync_failure.py#13)(api):**
### *recipes* / [gerrit:examples/full](/recipes/recipe_modules/gerrit/examples/full.py)

[DEPS](/recipes/recipe_modules/gerrit/examples/full.py#5): [gerrit](#recipe_modules-gerrit), [recipe\_engine/step][recipe_engine/recipe_modules/step]

&mdash; **def [RunSteps](/recipes/recipe_modules/gerrit/examples/full.py#11)(api):**
### *recipes* / [git:examples/full](/recipes/recipe_modules/git/examples/full.py)

[DEPS](/recipes/recipe_modules/git/examples/full.py#5): [git](#recipe_modules-git), [recipe\_engine/buildbucket][recipe_engine/recipe_modules/buildbucket], [recipe\_engine/context][recipe_engine/recipe_modules/context], [recipe\_engine/path][recipe_engine/recipe_modules/path], [recipe\_engine/platform][recipe_engine/recipe_modules/platform], [recipe\_engine/properties][recipe_engine/recipe_modules/properties], [recipe\_engine/raw\_io][recipe_engine/recipe_modules/raw_io], [recipe\_engine/step][recipe_engine/recipe_modules/step]

&mdash; **def [RunSteps](/recipes/recipe_modules/git/examples/full.py#18)(api):**
### *recipes* / [git\_cl:examples/full](/recipes/recipe_modules/git_cl/examples/full.py)

[DEPS](/recipes/recipe_modules/git_cl/examples/full.py#9): [git\_cl](#recipe_modules-git_cl), [recipe\_engine/path][recipe_engine/recipe_modules/path], [recipe\_engine/raw\_io][recipe_engine/recipe_modules/raw_io], [recipe\_engine/step][recipe_engine/recipe_modules/step]

&mdash; **def [RunSteps](/recipes/recipe_modules/git_cl/examples/full.py#17)(api):**
### *recipes* / [gitiles:examples/full](/recipes/recipe_modules/gitiles/examples/full.py)

[DEPS](/recipes/recipe_modules/gitiles/examples/full.py#5): [gitiles](#recipe_modules-gitiles), [recipe\_engine/json][recipe_engine/recipe_modules/json], [recipe\_engine/path][recipe_engine/recipe_modules/path], [recipe\_engine/properties][recipe_engine/recipe_modules/properties], [recipe\_engine/step][recipe_engine/recipe_modules/step]

&mdash; **def [RunSteps](/recipes/recipe_modules/gitiles/examples/full.py#14)(api):**
### *recipes* / [gitiles:tests/parse\_repo\_url](/recipes/recipe_modules/gitiles/tests/parse_repo_url.py)

[DEPS](/recipes/recipe_modules/gitiles/tests/parse_repo_url.py#5): [gitiles](#recipe_modules-gitiles), [recipe\_engine/properties][recipe_engine/recipe_modules/properties], [recipe\_engine/step][recipe_engine/recipe_modules/step]

&mdash; **def [RunSteps](/recipes/recipe_modules/gitiles/tests/parse_repo_url.py#12)(api):**
### *recipes* / [gsutil:examples/full](/recipes/recipe_modules/gsutil/examples/full.py)

[DEPS](/recipes/recipe_modules/gsutil/examples/full.py#5): [gsutil](#recipe_modules-gsutil), [recipe\_engine/path][recipe_engine/recipe_modules/path]

&mdash; **def [RunSteps](/recipes/recipe_modules/gsutil/examples/full.py#11)(api):**

Move things around in a loop!
### *recipes* / [osx\_sdk:examples/full](/recipes/recipe_modules/osx_sdk/examples/full.py)

[DEPS](/recipes/recipe_modules/osx_sdk/examples/full.py#5): [osx\_sdk](#recipe_modules-osx_sdk), [recipe\_engine/platform][recipe_engine/recipe_modules/platform], [recipe\_engine/properties][recipe_engine/recipe_modules/properties], [recipe\_engine/step][recipe_engine/recipe_modules/step]

&mdash; **def [RunSteps](/recipes/recipe_modules/osx_sdk/examples/full.py#13)(api):**
### *recipes* / [presubmit:examples/full](/recipes/recipe_modules/presubmit/examples/full.py)

[DEPS](/recipes/recipe_modules/presubmit/examples/full.py#5): [presubmit](#recipe_modules-presubmit), [recipe\_engine/json][recipe_engine/recipe_modules/json]

&mdash; **def [RunSteps](/recipes/recipe_modules/presubmit/examples/full.py#11)(api):**
### *recipes* / [presubmit:tests/execute](/recipes/recipe_modules/presubmit/tests/execute.py)

[DEPS](/recipes/recipe_modules/presubmit/tests/execute.py#10): [gclient](#recipe_modules-gclient), [presubmit](#recipe_modules-presubmit), [recipe\_engine/buildbucket][recipe_engine/recipe_modules/buildbucket], [recipe\_engine/context][recipe_engine/recipe_modules/context], [recipe\_engine/cq][recipe_engine/recipe_modules/cq], [recipe\_engine/json][recipe_engine/recipe_modules/json], [recipe\_engine/path][recipe_engine/recipe_modules/path], [recipe\_engine/properties][recipe_engine/recipe_modules/properties], [recipe\_engine/runtime][recipe_engine/recipe_modules/runtime]

&mdash; **def [RunSteps](/recipes/recipe_modules/presubmit/tests/execute.py#23)(api):**
### *recipes* / [presubmit:tests/prepare](/recipes/recipe_modules/presubmit/tests/prepare.py)

[DEPS](/recipes/recipe_modules/presubmit/tests/prepare.py#9): [gclient](#recipe_modules-gclient), [presubmit](#recipe_modules-presubmit), [recipe\_engine/buildbucket][recipe_engine/recipe_modules/buildbucket], [recipe\_engine/context][recipe_engine/recipe_modules/context], [recipe\_engine/path][recipe_engine/recipe_modules/path], [recipe\_engine/properties][recipe_engine/recipe_modules/properties], [recipe\_engine/runtime][recipe_engine/recipe_modules/runtime]

&mdash; **def [RunSteps](/recipes/recipe_modules/presubmit/tests/prepare.py#26)(api, patch_project, patch_repository_url):**
### *recipes* / [tryserver:examples/full](/recipes/recipe_modules/tryserver/examples/full.py)

[DEPS](/recipes/recipe_modules/tryserver/examples/full.py#5): [gerrit](#recipe_modules-gerrit), [tryserver](#recipe_modules-tryserver), [recipe\_engine/buildbucket][recipe_engine/recipe_modules/buildbucket], [recipe\_engine/json][recipe_engine/recipe_modules/json], [recipe\_engine/path][recipe_engine/recipe_modules/path], [recipe\_engine/platform][recipe_engine/recipe_modules/platform], [recipe\_engine/properties][recipe_engine/recipe_modules/properties], [recipe\_engine/python][recipe_engine/recipe_modules/python], [recipe\_engine/raw\_io][recipe_engine/recipe_modules/raw_io], [recipe\_engine/step][recipe_engine/recipe_modules/step]

&mdash; **def [RunSteps](/recipes/recipe_modules/tryserver/examples/full.py#21)(api):**
### *recipes* / [tryserver:tests/gerrit\_change\_fetch\_ref\_timeout](/recipes/recipe_modules/tryserver/tests/gerrit_change_fetch_ref_timeout.py)

[DEPS](/recipes/recipe_modules/tryserver/tests/gerrit_change_fetch_ref_timeout.py#7): [gerrit](#recipe_modules-gerrit), [tryserver](#recipe_modules-tryserver), [recipe\_engine/buildbucket][recipe_engine/recipe_modules/buildbucket], [recipe\_engine/properties][recipe_engine/recipe_modules/properties]

&mdash; **def [RunSteps](/recipes/recipe_modules/tryserver/tests/gerrit_change_fetch_ref_timeout.py#15)(api):**
### *recipes* / [tryserver:tests/gerrit\_change\_owner](/recipes/recipe_modules/tryserver/tests/gerrit_change_owner.py)

[DEPS](/recipes/recipe_modules/tryserver/tests/gerrit_change_owner.py#7): [gerrit](#recipe_modules-gerrit), [tryserver](#recipe_modules-tryserver), [recipe\_engine/buildbucket][recipe_engine/recipe_modules/buildbucket]

&mdash; **def [RunSteps](/recipes/recipe_modules/tryserver/tests/gerrit_change_owner.py#14)(api):**
### *recipes* / [tryserver:tests/gerrit\_change\_target\_ref](/recipes/recipe_modules/tryserver/tests/gerrit_change_target_ref.py)

[DEPS](/recipes/recipe_modules/tryserver/tests/gerrit_change_target_ref.py#7): [gerrit](#recipe_modules-gerrit), [tryserver](#recipe_modules-tryserver), [recipe\_engine/buildbucket][recipe_engine/recipe_modules/buildbucket], [recipe\_engine/properties][recipe_engine/recipe_modules/properties], [recipe\_engine/step][recipe_engine/recipe_modules/step]

&mdash; **def [RunSteps](/recipes/recipe_modules/tryserver/tests/gerrit_change_target_ref.py#16)(api):**
### *recipes* / [windows\_sdk:examples/full](/recipes/recipe_modules/windows_sdk/examples/full.py)

[DEPS](/recipes/recipe_modules/windows_sdk/examples/full.py#5): [windows\_sdk](#recipe_modules-windows_sdk), [recipe\_engine/platform][recipe_engine/recipe_modules/platform], [recipe\_engine/properties][recipe_engine/recipe_modules/properties], [recipe\_engine/step][recipe_engine/recipe_modules/step]

&mdash; **def [RunSteps](/recipes/recipe_modules/windows_sdk/examples/full.py#13)(api):**

[recipe_engine/recipe_modules/assertions]: https://chromium.googlesource.com/infra/luci/recipes-py.git/+/7caff240ba2cdb9ec5b4fb01b6e966ff6df4af86/README.recipes.md#recipe_modules-assertions
[recipe_engine/recipe_modules/buildbucket]: https://chromium.googlesource.com/infra/luci/recipes-py.git/+/7caff240ba2cdb9ec5b4fb01b6e966ff6df4af86/README.recipes.md#recipe_modules-buildbucket
[recipe_engine/recipe_modules/cipd]: https://chromium.googlesource.com/infra/luci/recipes-py.git/+/7caff240ba2cdb9ec5b4fb01b6e966ff6df4af86/README.recipes.md#recipe_modules-cipd
[recipe_engine/recipe_modules/commit_position]: https://chromium.googlesource.com/infra/luci/recipes-py.git/+/7caff240ba2cdb9ec5b4fb01b6e966ff6df4af86/README.recipes.md#recipe_modules-commit_position
[recipe_engine/recipe_modules/context]: https://chromium.googlesource.com/infra/luci/recipes-py.git/+/7caff240ba2cdb9ec5b4fb01b6e966ff6df4af86/README.recipes.md#recipe_modules-context
[recipe_engine/recipe_modules/cq]: https://chromium.googlesource.com/infra/luci/recipes-py.git/+/7caff240ba2cdb9ec5b4fb01b6e966ff6df4af86/README.recipes.md#recipe_modules-cq
[recipe_engine/recipe_modules/file]: https://chromium.googlesource.com/infra/luci/recipes-py.git/+/7caff240ba2cdb9ec5b4fb01b6e966ff6df4af86/README.recipes.md#recipe_modules-file
[recipe_engine/recipe_modules/json]: https://chromium.googlesource.com/infra/luci/recipes-py.git/+/7caff240ba2cdb9ec5b4fb01b6e966ff6df4af86/README.recipes.md#recipe_modules-json
[recipe_engine/recipe_modules/milo]: https://chromium.googlesource.com/infra/luci/recipes-py.git/+/7caff240ba2cdb9ec5b4fb01b6e966ff6df4af86/README.recipes.md#recipe_modules-milo
[recipe_engine/recipe_modules/path]: https://chromium.googlesource.com/infra/luci/recipes-py.git/+/7caff240ba2cdb9ec5b4fb01b6e966ff6df4af86/README.recipes.md#recipe_modules-path
[recipe_engine/recipe_modules/platform]: https://chromium.googlesource.com/infra/luci/recipes-py.git/+/7caff240ba2cdb9ec5b4fb01b6e966ff6df4af86/README.recipes.md#recipe_modules-platform
[recipe_engine/recipe_modules/properties]: https://chromium.googlesource.com/infra/luci/recipes-py.git/+/7caff240ba2cdb9ec5b4fb01b6e966ff6df4af86/README.recipes.md#recipe_modules-properties
[recipe_engine/recipe_modules/python]: https://chromium.googlesource.com/infra/luci/recipes-py.git/+/7caff240ba2cdb9ec5b4fb01b6e966ff6df4af86/README.recipes.md#recipe_modules-python
[recipe_engine/recipe_modules/raw_io]: https://chromium.googlesource.com/infra/luci/recipes-py.git/+/7caff240ba2cdb9ec5b4fb01b6e966ff6df4af86/README.recipes.md#recipe_modules-raw_io
[recipe_engine/recipe_modules/resultdb]: https://chromium.googlesource.com/infra/luci/recipes-py.git/+/7caff240ba2cdb9ec5b4fb01b6e966ff6df4af86/README.recipes.md#recipe_modules-resultdb
[recipe_engine/recipe_modules/runtime]: https://chromium.googlesource.com/infra/luci/recipes-py.git/+/7caff240ba2cdb9ec5b4fb01b6e966ff6df4af86/README.recipes.md#recipe_modules-runtime
[recipe_engine/recipe_modules/step]: https://chromium.googlesource.com/infra/luci/recipes-py.git/+/7caff240ba2cdb9ec5b4fb01b6e966ff6df4af86/README.recipes.md#recipe_modules-step
[recipe_engine/recipe_modules/url]: https://chromium.googlesource.com/infra/luci/recipes-py.git/+/7caff240ba2cdb9ec5b4fb01b6e966ff6df4af86/README.recipes.md#recipe_modules-url
[recipe_engine/recipe_modules/version]: https://chromium.googlesource.com/infra/luci/recipes-py.git/+/7caff240ba2cdb9ec5b4fb01b6e966ff6df4af86/README.recipes.md#recipe_modules-version
[recipe_engine/wkt/RecipeApi]: https://chromium.googlesource.com/infra/luci/recipes-py.git/+/7caff240ba2cdb9ec5b4fb01b6e966ff6df4af86/recipe_engine/recipe_api.py#881
