// Copyright 2021 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SAFE_BROWSING_CORE_DB_FAKE_DATABASE_MANAGER_H_
#define COMPONENTS_SAFE_BROWSING_CORE_DB_FAKE_DATABASE_MANAGER_H_

#include "base/containers/flat_map.h"
#include "components/safe_browsing/core/db/test_database_manager.h"
#include "url/gurl.h"

namespace safe_browsing {

// A test support class used to classify given URLs as dangerous so that
// features may test their interaction with Safe Browsing.
class FakeSafeBrowsingDatabaseManager : public TestSafeBrowsingDatabaseManager {
 public:
  FakeSafeBrowsingDatabaseManager();

  void AddDangerousUrl(const GURL& dangerous_url, SBThreatType threat_type);
  void ClearDangerousUrl(const GURL& dangerous_url);

  // TestSafeBrowsingDatabaseManager implementation:
  // These are implemented as needed to return stubbed values.
  bool CanCheckRequestDestination(
      network::mojom::RequestDestination request_destination) const override;
  bool ChecksAreAlwaysAsync() const override;
  bool CheckBrowseUrl(const GURL& url,
                      const SBThreatTypeSet& threat_types,
                      Client* client) override;
  bool CheckExtensionIDs(const std::set<std::string>& extension_ids,
                         Client* client) override;
  bool CheckUrlForSubresourceFilter(const GURL& url, Client* client) override;
  safe_browsing::ThreatSource GetThreatSource() const override;
  bool IsSupported() const override;

 private:
  ~FakeSafeBrowsingDatabaseManager() override;

  static void CheckBrowseURLAsync(GURL url,
                                  SBThreatType result_threat_type,
                                  Client* client);

  base::flat_map<GURL, SBThreatType> dangerous_urls_;
};

}  // namespace safe_browsing

#endif  // COMPONENTS_SAFE_BROWSING_CORE_DB_FAKE_DATABASE_MANAGER_H_
