/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.java;

import java.text.Collator;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Platform;
import net.sf.saxon.dom.DOMEnvelope;
import net.sf.saxon.dom.DOMObjectModel;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.NamedCollation;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.java.JavaCollationFactory;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class JavaPlatform
implements Platform {
    public void initialize(Configuration config) {
        config.registerExternalObjectModel(DOMEnvelope.getInstance());
        config.registerExternalObjectModel(DOMObjectModel.getInstance());
    }

    public boolean isJava() {
        return true;
    }

    public boolean isDotNet() {
        return false;
    }

    public String getVerifierClassName() {
        return "com.saxonica.config.Verifier";
    }

    public String getPlatformVersion() {
        return "Java version " + System.getProperty("java.version");
    }

    public String getPlatformSuffix() {
        return "J";
    }

    public XMLReader loadParser() {
        XMLReader parser;
        try {
            parser = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException err) {
            throw new TransformerFactoryConfigurationError(err);
        }
        catch (SAXException err) {
            throw new TransformerFactoryConfigurationError(err);
        }
        return parser;
    }

    public Source getParserSource(PipelineConfiguration pipe, StreamSource input, int validation, boolean dtdValidation, int stripspace) {
        return input;
    }

    public StringCollator makeCollation(Configuration config, Properties props, String uri) throws XPathException {
        return JavaCollationFactory.makeCollation(config, uri, props);
    }

    public boolean canReturnCollationKeys(StringCollator collation) {
        return collation instanceof CodepointCollator || collation instanceof NamedCollation && ((NamedCollation)collation).getCollation() instanceof Collator;
    }

    public Object getCollationKey(NamedCollation namedCollation, String value) {
        return ((Collator)namedCollation.getCollation()).getCollationKey(value);
    }

    public void addFunctionLibraries(FunctionLibraryList list, Configuration config, int hostLanguage) {
    }

    public SchemaType getExternalObjectType(Configuration config, String uri, String localName) {
        throw new UnsupportedOperationException("getExternalObjectType for Java");
    }

    public String getInstallationDirectory(String edition) {
        return System.getenv("SAXON_HOME");
    }

    public void registerAllBuiltInObjectModels(Configuration config) {
    }
}

