# VEHICLE SIGNAL SPECIFICATION


[![License](https://img.shields.io/badge/License-MPL%202.0-blue.svg)](https://opensource.org/licenses/MPL-2.0)
[![Build Status](https://github.com/COVESA/vehicle_signal_specification/actions/workflows/buildcheck.yml/badge.svg)](https://github.com/COVESA/vehicle_signal_specification/actions/workflows/buildcheck.yml?query=branch%3Amaster)

The overall goal of the Vehicle Signal Specification (VSS)  is to create a common understanding of vehicle signals in order to reach a “common language” independent of the protocol or serialisation format. 

Please find the official documentation at: [Vehicle Signal Specification](https://covesa.github.io/vehicle_signal_specification/)

## Getting started

### Using VSS
To use a specific version of VSS in your toolchain, head over to our [releases page](https://github.com/COVESA/vehicle_signal_specification/releases/).


[Latest release](https://github.com/COVESA/vehicle_signal_specification/releases/latest)

### Discuss all things VSS, "meet" the community
The community has regular calls to discuss topics around VSS. This includes specific tickets in this repository as well as the broader direction in which VSS is evolving.  You can find current call coordinates and dates in [our wiki](https://github.com/COVESA/vehicle_signal_specification/wiki/Weekly-meeting#meeting). 


### Contribute to VSS
Work towards the next version is continuously ongoing in the [master branch](https://github.com/COVESA/vehicle_signal_specification/tree/master)

To work with the specification directly, you need to clone this repository.

This repository uses git submodules.  Please make sure you clone recursively,

```
git clone --recurse-submodules https://github.com/COVESA/vehicle_signal_specification
```


Alternatively, just init and update the submodules after the initial cloning:

```
git clone https://github.com/COVESA/vehicle_signal_specification
git submodule update --init
```


## Contributors
VSS is an open standard and we invite anybody to contribute. Currently VSS contains - among others - significant  contributions from
 - [Bayerische Motoren Werke Aktiengesellschaft (BMW AG)](https://www.bmwgroup.com/)
 - [Volvo Cars](https://www.volvocars.com/)
 - [Jaguar Land Rover](https://www.jaguarlandrover.com/)
 - [Robert Bosch GmbH](https://www.bosch.com/)
 - [Geotab Inc](https://www.geotab.com/about/).

