'\" t
.\"     Title: xgetfeedbackcontrol
.\"    Author: [FIXME: author] [see http://docbook.sf.net/el/author]
.\" Generator: DocBook XSL Stylesheets v1.79.1 <http://docbook.sf.net/>
.\"      Date: 09/15/2021
.\"    Manual: \ \&
.\"    Source: \ \&
.\"  Language: English
.\"
.TH "XGETFEEDBACKCONTROL" "libmansuffix" "09/15/2021" "\ \&" "\ \&"
.\" -----------------------------------------------------------------
.\" * Define some portability stuff
.\" -----------------------------------------------------------------
.\" ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
.\" http://bugs.debian.org/507673
.\" http://lists.gnu.org/archive/html/groff/2009-02/msg00013.html
.\" ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
.ie \n(.g .ds Aq \(aq
.el       .ds Aq '
.\" -----------------------------------------------------------------
.\" * set default formatting
.\" -----------------------------------------------------------------
.\" disable hyphenation
.nh
.\" disable justification (adjust text to left margin only)
.ad l
.\" -----------------------------------------------------------------
.\" * MAIN CONTENT STARTS HERE *
.\" -----------------------------------------------------------------
.SH "NAME"
XGetFeedbackControl, XChangeFeedbackControl \- query and change input device feedbacks
.SH "SYNOPSIS"
.sp
.nf
#include <X11/extensions/XInput\&.h>
.fi
.sp
.nf
XFeedbackState *XGetFeedbackControl( Display *display,
                                     XDevice *device,
                                     int *num_feedbacks);
.fi
.sp
.nf
int XChangeFeedbackControl( Display *display,
                            XDevice *device,
                            Mask mask,
                            XFeedbackControl *control);
.fi
.sp
.nf
display
       Specifies the connection to the X server\&.
.fi
.sp
.nf
device
       Specifies the device whose feedbacks are to be queried
       or modified\&.
.fi
.sp
.nf
num_feedbacks
       Specifies an address into which the number of feedbacks
       supported by the device is to be returned\&.
.fi
.sp
.nf
mask
       Specifies a mask specific to each type of feedback that
       describes how the feedback is to be modified\&.
.fi
.sp
.nf
control
       Specifies the address of an XFeedbackControl structure
       that contains the new values for the feedback\&.
.fi
.SH "DESCRIPTION"
.sp
.if n \{\
.RS 4
.\}
.nf
These requests are provided to manipulate those input devices
that support feedbacks\&. A BadMatch error will be generated if
the requested device does not support feedbacks\&. Whether or not
a given device supports feedbacks can be determined by
examining the information returned by the XOpenDevice request\&.
For those devices that support feedbacks, XOpenDevice will
return an XInputClassInfo structure with the input_class field
equal to the constant FeedbackClass (defined in the file XI\&.h)\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
The XGetFeedbackControl request returns a pointer to a list of
XFeedbackState structures\&. Each item in this list describes one
of the feedbacks supported by the device\&. The items are
variable length, so each contains its length to allow traversal
to the next item in the list\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
The feedback classes that are currently defined are:
KbdFeedbackClass, PtrFeedbackClass, StringFeedbackClass,
IntegerFeedbackClass, LedFeedbackClass, and BellFeedbackClass\&.
These constants are defined in the file XI\&.h\&. An input device
may support zero or more classes of feedback, and may support
multiple feedbacks of the same class\&. Each feedback contains a
class identifier and an id that is unique within that class for
that input device\&. The id is used to identify the feedback when
making an XChangeFeedbackControl request\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
XGetFeedbackControl can generate a BadDevice or BadMatch error\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
The XChangeFeedbackControl request modifies the values of one
feedback on the specified device\&. The feedback is identified by
the id field of the XFeedbackControl structure that is passed
with the request\&. The fields of the feedback that are to be
modified are identified by the bits of the mask that is passed
with the request\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
XChangeFeedbackControl can generate a BadDevice, BadMatch, or
BadValue error\&.
.fi
.if n \{\
.RE
.\}
.SS "Structures"
.sp
.if n \{\
.RS 4
.\}
.nf
Each class of feedback is described by a structure specific to
that class\&. These structures are defined in the file XInput\&.h\&.
XFeedbackState and XFeedbackControl are generic structures that
contain three fields that are at the beginning of each class of
feedback:
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
typedef struct {
    XID class;
    int length;
    XID id;
} XFeedbackState, XFeedbackControl;
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
The XKbdFeedbackState structure defines the attributes that are
returned for feedbacks equivalent to those on the X keyboard\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
typedef struct {
    XID class;
    int length;
    XID id;
    int click;
    int percent;
    int pitch;
    int duration;
    int led_mask;
    int global_auto_repeat;
    char auto_repeats[32];
} XKbdFeedbackState;
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
The XPtrFeedbackState structure defines the attributes that are
returned for feedbacks equivalent to those on the the X
pointer\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
typedef struct {
    XID class;
    int length;
    XID id;
    int accelNum;
    int accelDenom;
    int threshold;
} XPtrFeedbackState;
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
The XIntegerFeedbackState structure defines attributes that are
returned for integer feedbacks\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
typedef struct {
    XID class;
    int length;
    XID id;
    int resolution;
    int minVal;
    int maxVal;
} XIntegerFeedbackState;
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
The XStringFeedbackState structure defines the attributes that
are returned for string feedbacks\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
typedef struct {
    XID class;
    int length;
    XID id;
    int max_symbols;
    int num_syms_supported;
    KeySym *syms_supported;
} XStringFeedbackState;
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
The XBellFeedbackState structure defines the attributes that
are returned for bell feedbacks\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
typedef struct {
    XID class;
    int length;
    XID id;
    int percent;
    int pitch;
    int duration;
} XBellFeedbackState;
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
The XLedFeedbackState structure defines the attributes that are
returned for LED feedbacks\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
typedef struct {
    XID class;
    int length;
    XID id;
    int led_values;
} XLedFeedbackState;
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
The XPrtFeedbackControl structure defines the attributes that
can be controlled for pointer feedbacks\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
typedef struct {
    XID class;
    int length;
    XID id;
    int accelNum;
    int accelDenom;
    int threshold;
} XPtrFeedbackControl;
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
The XKbdFeedbackControl structure defines the attributes that
can be controlled for keyboard feedbacks\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
typedef struct {
    XID class;
    int length;
    XID id;
    int click;
    int percent;
    int pitch;
    int duration;
    int led_mask;
    int led_value;
    int key;
    int auto_repeat_mode;
} XKbdFeedbackControl;
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
The XStringFeedbackControl structure defines the attributes
that can be controlled for string feedbacks\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
typedef struct {
    XID class;
    int length;
    XID id;
    int num_keysyms;
    KeySym  *syms_to_display;
} XStringFeedbackControl;
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
The XIntegerFeedbackControl structure defines the attributes
that can be controlled for integer feedbacks\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
typedef struct {
    XID class;
    int length;
    XID id;
    int int_to_display;
} XIntegerFeedbackControl;
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
The XBellFeedbackControl structure defines the attributes that
can be controlled for bell feedbacks\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
typedef struct {
    XID     class;
    int     length;
    XID     id;
    int     percent;
    int     pitch;
    int     duration;
} XBellFeedbackControl;
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
The XLedFeedbackControl structure defines the attributes that
can be controlled for LED feedbacks\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
typedef struct {
    XID     class;
    int     length;
    XID     id;
    int     led_mask;
    int     led_values;
} XLedFeedbackControl;
.fi
.if n \{\
.RE
.\}
.SH "DIAGNOSTICS"
.sp
.if n \{\
.RS 4
.\}
.nf
BadDevice
       An invalid device was specified\&. The specified device
       does not exist or has not been opened by this client via
       XOpenInputDevice\&. This error may also occur if some
       other client has caused the specified device to become
       the X keyboard or X pointer device via the
       XChangeKeyboardDevice or XChangePointerDevice requests\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
BadMatch
       This error may occur if an XGetFeedbackControl request
       was made specifying a device that has no feedbacks, or
       an XChangeFeedbackControl request was made with an
       XFeedbackControl structure that contains an invalid
       feedback type\&. It may also occur if an invalid
       combination of mask bits is specified ( DvKey but no
       DvAutoRepeatMode for keyboard feedbacks), or if an
       invalid KeySym is specified for a string feedback\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
BadValue
       Some numeric value falls outside the range of values
       accepted by the XChangeFeedbackControl request\&. Unless a
       specific range is specified for an argument, the full
       range defined by the argument\*(Aqs type is accepted\&. Any
       argument defined as a set of alternatives can generate
       this error\&.
.fi
.if n \{\
.RE
.\}
