/* SPDX-License-Identifier: GPL-2.0 WITH Linux-syscall-note */
/*
 * Texas Instruments Ethernet Switch Driver
 *
 * Copyright (C) 2014-2020 Texas Instruments, Inc
 *
 * Userspace API for Switch Configuration
 */

#ifndef __NET_CONFIG_SWITCH_H__
#define __NET_CONFIG_SWITCH_H__

#include <linux/types.h>
#include <linux/ethtool.h>

enum {
	SWITCH_INVALID,
	SWITCH_ADD_MULTICAST,
	SWITCH_DEL_MULTICAST,
	SWITCH_ADD_VLAN,
	SWITCH_DEL_VLAN,
	SWITCH_SET_PORT_CONFIG,
	SWITCH_GET_PORT_CONFIG,
	SWITCH_ADD_UNKNOWN_VLAN_INFO,
	SWITCH_GET_PORT_STATE,
	SWITCH_SET_PORT_STATE,
	SWITCH_GET_PORT_VLAN_CONFIG,
	SWITCH_SET_PORT_VLAN_CONFIG,
	SWITCH_RATELIMIT,
};

enum {
	PORT_STATE_DISABLED = 0,
	PORT_STATE_BLOCKED,
	PORT_STATE_LEARN,
	PORT_STATE_FORWARD,
};

/*
 * Pass all unused parameters as zero is recomented.
 */
struct net_switch_config {
	unsigned int cmd;	/* API to be invoked by the kernel driver */

	unsigned int	port;
	unsigned int	vid;		/* VLAN identifier */
	unsigned char	unreg_multi;	/* unreg multicast Egress Ports */
	unsigned char	reg_multi;	/* register multicast Egress ports */
	unsigned char	untag_port;	/* Untag ports */
	unsigned char	addr[6];
	unsigned int	super;
	struct ethtool_cmd ecmd;
	unsigned char	unknown_vlan_member;
	unsigned char	unknown_vlan_untag;
	unsigned int	unknown_vlan_unreg_multi;
	unsigned int	unknown_vlan_reg_multi;
	unsigned int	port_state;
	unsigned int	prio;
	int		vlan_cfi;
	unsigned int	bcast_rate_limit;
	unsigned int	mcast_rate_limit;
	int		direction;

	unsigned int ret_type;   /* Return  Success/Failure */
};

#endif /* __NET_CONFIG_SWITCH_H__*/
