/* valaproperty.c generated by valac, the Vala compiler
 * generated from valaproperty.vala, do not modify */

/* valaproperty.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaPropertyPrivate {
	ValaParameter* _this_parameter;
	gboolean _interface_only;
	gboolean _is_abstract;
	gboolean _is_virtual;
	gboolean _overrides;
	ValaMemberBinding _binding;
	gboolean _lock_used;
	ValaExpression* _initializer;
	ValaDataType* _data_type;
	ValaProperty* _base_property;
	ValaProperty* _base_interface_property;
	gboolean base_properties_valid;
	ValaPropertyAccessor* _get_accessor;
	ValaPropertyAccessor* _set_accessor;
	gchar* _nick;
	gchar* _blurb;
	gboolean* _notify;
	ValaField* _field;
	gboolean _field_checked;
};

static gint ValaProperty_private_offset;
static gpointer vala_property_parent_class = NULL;
static ValaLockableIface * vala_property_vala_lockable_parent_iface = NULL;

static gboolean* _bool_dup (gboolean* self);
static void vala_property_find_base_properties (ValaProperty* self);
static void vala_property_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor);
static void vala_property_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor);
static void vala_property_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type);
static void vala_property_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node);
static void vala_property_find_base_interface_property (ValaProperty* self,
                                                 ValaClass* cl);
static void vala_property_find_base_class_property (ValaProperty* self,
                                             ValaClass* cl);
static gboolean vala_property_real_check (ValaCodeNode* base,
                                   ValaCodeContext* context);
static gboolean vala_property_is_valid_name (const gchar* name);
static void vala_property_finalize (ValaCodeNode * obj);
static GType vala_property_get_type_once (void);

static inline gpointer
vala_property_get_instance_private (ValaProperty* self)
{
	return G_STRUCT_MEMBER_P (self, ValaProperty_private_offset);
}

ValaDataType*
vala_property_get_property_type (ValaProperty* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_property_set_property_type (ValaProperty* self,
                                 ValaDataType* value)
{
	ValaDataType* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp0_;
	if (value != NULL) {
		ValaDataType* _tmp1_;
		_tmp1_ = self->priv->_data_type;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
	}
}

ValaPropertyAccessor*
vala_property_get_get_accessor (ValaProperty* self)
{
	ValaPropertyAccessor* result;
	ValaPropertyAccessor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_get_accessor;
	result = _tmp0_;
	return result;
}

void
vala_property_set_get_accessor (ValaProperty* self,
                                ValaPropertyAccessor* value)
{
	ValaPropertyAccessor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_get_accessor);
	self->priv->_get_accessor = _tmp0_;
	if (value != NULL) {
		ValaScope* _tmp1_;
		ValaScope* _tmp2_;
		_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp2_ = _tmp1_;
		vala_symbol_set_owner ((ValaSymbol*) value, _tmp2_);
	}
}

ValaPropertyAccessor*
vala_property_get_set_accessor (ValaProperty* self)
{
	ValaPropertyAccessor* result;
	ValaPropertyAccessor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_set_accessor;
	result = _tmp0_;
	return result;
}

void
vala_property_set_set_accessor (ValaProperty* self,
                                ValaPropertyAccessor* value)
{
	ValaPropertyAccessor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_set_accessor);
	self->priv->_set_accessor = _tmp0_;
	if (value != NULL) {
		ValaScope* _tmp1_;
		ValaScope* _tmp2_;
		_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp2_ = _tmp1_;
		vala_symbol_set_owner ((ValaSymbol*) value, _tmp2_);
	}
}

ValaParameter*
vala_property_get_this_parameter (ValaProperty* self)
{
	ValaParameter* result;
	ValaParameter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_this_parameter;
	result = _tmp0_;
	return result;
}

void
vala_property_set_this_parameter (ValaProperty* self,
                                  ValaParameter* value)
{
	ValaParameter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	self->priv->_this_parameter = _tmp0_;
}

gboolean
vala_property_get_interface_only (ValaProperty* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_interface_only;
	return result;
}

void
vala_property_set_interface_only (ValaProperty* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_interface_only = value;
}

gboolean
vala_property_get_is_abstract (ValaProperty* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_abstract;
	return result;
}

void
vala_property_set_is_abstract (ValaProperty* self,
                               gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}

gboolean
vala_property_get_is_virtual (ValaProperty* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_virtual;
	return result;
}

void
vala_property_set_is_virtual (ValaProperty* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_virtual = value;
}

gboolean
vala_property_get_overrides (ValaProperty* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_overrides;
	return result;
}

void
vala_property_set_overrides (ValaProperty* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_overrides = value;
}

ValaField*
vala_property_get_field (ValaProperty* self)
{
	ValaField* result;
	ValaField* _tmp60_;
	g_return_val_if_fail (self != NULL, NULL);
	if (!self->priv->_field_checked) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_;
		_tmp1_ = self->priv->_is_abstract;
		if (!_tmp1_) {
			ValaSourceFileType _tmp2_;
			ValaSourceFileType _tmp3_;
			_tmp2_ = vala_symbol_get_source_type ((ValaSymbol*) self);
			_tmp3_ = _tmp2_;
			_tmp0_ = _tmp3_ == VALA_SOURCE_FILE_TYPE_SOURCE;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			gboolean has_get = FALSE;
			ValaPropertyAccessor* _tmp4_;
			ValaPropertyAccessor* _tmp5_;
			gboolean _tmp6_ = FALSE;
			gboolean get_has_body = FALSE;
			gboolean has_set = FALSE;
			ValaPropertyAccessor* _tmp11_;
			ValaPropertyAccessor* _tmp12_;
			gboolean _tmp13_ = FALSE;
			gboolean set_has_body = FALSE;
			gboolean _tmp18_ = FALSE;
			gboolean _tmp22_ = FALSE;
			gboolean _tmp26_ = FALSE;
			_tmp4_ = vala_property_get_get_accessor (self);
			_tmp5_ = _tmp4_;
			has_get = _tmp5_ != NULL;
			if (has_get) {
				ValaPropertyAccessor* _tmp7_;
				ValaPropertyAccessor* _tmp8_;
				ValaBlock* _tmp9_;
				ValaBlock* _tmp10_;
				_tmp7_ = vala_property_get_get_accessor (self);
				_tmp8_ = _tmp7_;
				_tmp9_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp8_);
				_tmp10_ = _tmp9_;
				_tmp6_ = _tmp10_ != NULL;
			} else {
				_tmp6_ = FALSE;
			}
			get_has_body = _tmp6_;
			_tmp11_ = vala_property_get_set_accessor (self);
			_tmp12_ = _tmp11_;
			has_set = _tmp12_ != NULL;
			if (has_set) {
				ValaPropertyAccessor* _tmp14_;
				ValaPropertyAccessor* _tmp15_;
				ValaBlock* _tmp16_;
				ValaBlock* _tmp17_;
				_tmp14_ = vala_property_get_set_accessor (self);
				_tmp15_ = _tmp14_;
				_tmp16_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp15_);
				_tmp17_ = _tmp16_;
				_tmp13_ = _tmp17_ != NULL;
			} else {
				_tmp13_ = FALSE;
			}
			set_has_body = _tmp13_;
			if (set_has_body) {
				gboolean _tmp19_ = FALSE;
				if (has_get) {
					_tmp19_ = !get_has_body;
				} else {
					_tmp19_ = FALSE;
				}
				_tmp18_ = _tmp19_;
			} else {
				_tmp18_ = FALSE;
			}
			if (_tmp18_) {
				ValaSourceReference* _tmp20_;
				ValaSourceReference* _tmp21_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp20_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp21_ = _tmp20_;
				vala_report_error (_tmp21_, "Property getter must have a body");
			}
			if (get_has_body) {
				gboolean _tmp23_ = FALSE;
				if (has_set) {
					_tmp23_ = !set_has_body;
				} else {
					_tmp23_ = FALSE;
				}
				_tmp22_ = _tmp23_;
			} else {
				_tmp22_ = FALSE;
			}
			if (_tmp22_) {
				ValaSourceReference* _tmp24_;
				ValaSourceReference* _tmp25_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp25_ = _tmp24_;
				vala_report_error (_tmp25_, "Property setter must have a body");
			}
			if (!get_has_body) {
				_tmp26_ = !set_has_body;
			} else {
				_tmp26_ = FALSE;
			}
			if (_tmp26_) {
				gboolean _tmp27_ = FALSE;
				ValaAttribute* _tmp28_;
				const gchar* _tmp37_;
				const gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				ValaDataType* _tmp41_;
				ValaDataType* _tmp42_;
				ValaDataType* _tmp43_;
				ValaDataType* _tmp44_;
				ValaExpression* _tmp45_;
				ValaExpression* _tmp46_;
				ValaSourceReference* _tmp47_;
				ValaSourceReference* _tmp48_;
				ValaField* _tmp49_;
				ValaField* _tmp50_;
				ValaField* _tmp51_;
				ValaMemberBinding _tmp52_;
				ValaAttribute* _tmp53_;
				_tmp28_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "GtkChild");
				if (_tmp28_ != NULL) {
					ValaDataType* _tmp29_;
					ValaDataType* _tmp30_;
					gboolean _tmp31_;
					gboolean _tmp32_;
					_tmp29_ = vala_property_get_property_type (self);
					_tmp30_ = _tmp29_;
					_tmp31_ = vala_data_type_get_value_owned (_tmp30_);
					_tmp32_ = _tmp31_;
					_tmp27_ = _tmp32_;
				} else {
					_tmp27_ = FALSE;
				}
				if (_tmp27_) {
					ValaSourceReference* _tmp33_;
					ValaSourceReference* _tmp34_;
					ValaDataType* _tmp35_;
					ValaDataType* _tmp36_;
					_tmp33_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp34_ = _tmp33_;
					vala_report_warning (_tmp34_, "[GtkChild] properties must be declared as `unowned'");
					_tmp35_ = vala_property_get_property_type (self);
					_tmp36_ = _tmp35_;
					vala_data_type_set_value_owned (_tmp36_, FALSE);
				}
				_tmp37_ = vala_symbol_get_name ((ValaSymbol*) self);
				_tmp38_ = _tmp37_;
				_tmp39_ = g_strdup_printf ("_%s", _tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = vala_property_get_property_type (self);
				_tmp42_ = _tmp41_;
				_tmp43_ = vala_data_type_copy (_tmp42_);
				_tmp44_ = _tmp43_;
				_tmp45_ = vala_property_get_initializer (self);
				_tmp46_ = _tmp45_;
				_tmp47_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp48_ = _tmp47_;
				_tmp49_ = vala_field_new (_tmp40_, _tmp44_, _tmp46_, _tmp48_, NULL);
				_vala_code_node_unref0 (self->priv->_field);
				self->priv->_field = _tmp49_;
				_vala_code_node_unref0 (_tmp44_);
				_g_free0 (_tmp40_);
				_tmp50_ = self->priv->_field;
				vala_symbol_set_access ((ValaSymbol*) _tmp50_, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
				_tmp51_ = self->priv->_field;
				_tmp52_ = self->priv->_binding;
				vala_field_set_binding (_tmp51_, _tmp52_);
				_tmp53_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "GtkChild");
				if (_tmp53_ != NULL) {
					ValaField* _tmp54_;
					const gchar* _tmp55_;
					const gchar* _tmp56_;
					gchar* _tmp57_;
					gchar* _tmp58_;
					ValaField* _tmp59_;
					_tmp54_ = self->priv->_field;
					_tmp55_ = vala_symbol_get_name ((ValaSymbol*) self);
					_tmp56_ = _tmp55_;
					_tmp57_ = vala_code_node_get_attribute_string ((ValaCodeNode*) self, "GtkChild", "name", _tmp56_);
					_tmp58_ = _tmp57_;
					vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp54_, "GtkChild", "name", _tmp58_, NULL);
					_g_free0 (_tmp58_);
					_tmp59_ = self->priv->_field;
					vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp59_, "GtkChild", "internal", vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "GtkChild", "internal", FALSE), NULL);
				}
			}
		}
		self->priv->_field_checked = TRUE;
	}
	_tmp60_ = self->priv->_field;
	result = _tmp60_;
	return result;
}

ValaMemberBinding
vala_property_get_binding (ValaProperty* self)
{
	ValaMemberBinding result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_binding;
	return result;
}

void
vala_property_set_binding (ValaProperty* self,
                           ValaMemberBinding value)
{
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

const gchar*
vala_property_get_nick (ValaProperty* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_nick;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = vala_code_node_get_attribute_string ((ValaCodeNode*) self, "Description", "nick", NULL);
		_g_free0 (self->priv->_nick);
		self->priv->_nick = _tmp1_;
		_tmp2_ = self->priv->_nick;
		if (_tmp2_ == NULL) {
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp3_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp4_ = _tmp3_;
			_tmp5_ = string_replace (_tmp4_, "_", "-");
			_g_free0 (self->priv->_nick);
			self->priv->_nick = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_nick;
	result = _tmp6_;
	return result;
}

const gchar*
vala_property_get_blurb (ValaProperty* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_blurb;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = vala_code_node_get_attribute_string ((ValaCodeNode*) self, "Description", "blurb", NULL);
		_g_free0 (self->priv->_blurb);
		self->priv->_blurb = _tmp1_;
		_tmp2_ = self->priv->_blurb;
		if (_tmp2_ == NULL) {
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp3_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp4_ = _tmp3_;
			_tmp5_ = string_replace (_tmp4_, "_", "-");
			_g_free0 (self->priv->_blurb);
			self->priv->_blurb = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_blurb;
	result = _tmp6_;
	return result;
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

gboolean
vala_property_get_notify (ValaProperty* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_notify;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_;
		gboolean* _tmp2_;
		_tmp1_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "notify", TRUE);
		_tmp2_ = __bool_dup0 (&_tmp1_);
		_g_free0 (self->priv->_notify);
		self->priv->_notify = _tmp2_;
	}
	_tmp3_ = self->priv->_notify;
	result = *_tmp3_;
	return result;
}

ValaProperty*
vala_property_get_base_property (ValaProperty* self)
{
	ValaProperty* result;
	ValaProperty* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_property_find_base_properties (self);
	_tmp0_ = self->priv->_base_property;
	result = _tmp0_;
	return result;
}

ValaProperty*
vala_property_get_base_interface_property (ValaProperty* self)
{
	ValaProperty* result;
	ValaProperty* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_property_find_base_properties (self);
	_tmp0_ = self->priv->_base_interface_property;
	result = _tmp0_;
	return result;
}

ValaExpression*
vala_property_get_initializer (ValaProperty* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_initializer;
	result = _tmp0_;
	return result;
}

void
vala_property_set_initializer (ValaProperty* self,
                               ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_initializer);
	self->priv->_initializer = _tmp0_;
	_tmp1_ = self->priv->_initializer;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

static gboolean
vala_property_real_get_lock_used (ValaLockable* base)
{
	gboolean result;
	ValaProperty* self;
	self = (ValaProperty*) base;
	result = self->priv->_lock_used;
	return result;
}

static void
vala_property_real_set_lock_used (ValaLockable* base,
                                  gboolean value)
{
	ValaProperty* self;
	self = (ValaProperty*) base;
	self->priv->_lock_used = value;
}

/**
 * Creates a new property.
 *
 * @param name              property name
 * @param property_type     property type
 * @param get_accessor      get accessor
 * @param set_accessor      set/construct accessor
 * @param source_reference  reference to source code
 * @return                  newly created property
 */
ValaProperty*
vala_property_construct (GType object_type,
                         const gchar* name,
                         ValaDataType* property_type,
                         ValaPropertyAccessor* get_accessor,
                         ValaPropertyAccessor* set_accessor,
                         ValaSourceReference* source_reference,
                         ValaComment* comment)
{
	ValaProperty* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaProperty*) vala_symbol_construct (object_type, name, source_reference, comment);
	vala_property_set_property_type (self, property_type);
	vala_property_set_get_accessor (self, get_accessor);
	vala_property_set_set_accessor (self, set_accessor);
	return self;
}

ValaProperty*
vala_property_new (const gchar* name,
                   ValaDataType* property_type,
                   ValaPropertyAccessor* get_accessor,
                   ValaPropertyAccessor* set_accessor,
                   ValaSourceReference* source_reference,
                   ValaComment* comment)
{
	return vala_property_construct (VALA_TYPE_PROPERTY, name, property_type, get_accessor, set_accessor, source_reference, comment);
}

static void
vala_property_real_accept (ValaCodeNode* base,
                           ValaCodeVisitor* visitor)
{
	ValaProperty * self;
	self = (ValaProperty*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_property (visitor, self);
}

static void
vala_property_real_accept_children (ValaCodeNode* base,
                                    ValaCodeVisitor* visitor)
{
	ValaProperty * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaPropertyAccessor* _tmp2_;
	ValaPropertyAccessor* _tmp3_;
	ValaPropertyAccessor* _tmp6_;
	ValaPropertyAccessor* _tmp7_;
	ValaExpression* _tmp10_;
	ValaExpression* _tmp11_;
	self = (ValaProperty*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_property_get_property_type (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_property_get_get_accessor (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ValaPropertyAccessor* _tmp4_;
		ValaPropertyAccessor* _tmp5_;
		_tmp4_ = vala_property_get_get_accessor (self);
		_tmp5_ = _tmp4_;
		vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
	}
	_tmp6_ = vala_property_get_set_accessor (self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		ValaPropertyAccessor* _tmp8_;
		ValaPropertyAccessor* _tmp9_;
		_tmp8_ = vala_property_get_set_accessor (self);
		_tmp9_ = _tmp8_;
		vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
	}
	_tmp10_ = vala_property_get_initializer (self);
	_tmp11_ = _tmp10_;
	if (_tmp11_ != NULL) {
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		_tmp12_ = vala_property_get_initializer (self);
		_tmp13_ = _tmp12_;
		vala_code_node_accept ((ValaCodeNode*) _tmp13_, visitor);
	}
}

/**
 * Checks whether the accessors of this property are compatible
 * with the specified base property.
 *
 * @param base_property a property
 * @param invalid_match error string about which check failed
 * @return true if the specified property is compatible to this property
 */
gboolean
vala_property_compatible (ValaProperty* self,
                          ValaProperty* base_property,
                          gchar** invalid_match)
{
	gchar* _vala_invalid_match = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaPropertyAccessor* _tmp2_;
	ValaPropertyAccessor* _tmp3_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	ValaPropertyAccessor* _tmp14_;
	ValaPropertyAccessor* _tmp15_;
	ValaDataType* object_type = NULL;
	ValaSymbol* _tmp24_;
	ValaSymbol* _tmp25_;
	ValaDataType* _tmp26_;
	ValaPropertyAccessor* _tmp27_;
	ValaPropertyAccessor* _tmp28_;
	ValaPropertyAccessor* _tmp41_;
	ValaPropertyAccessor* _tmp42_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_property != NULL, FALSE);
	_tmp2_ = vala_property_get_get_accessor (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		ValaPropertyAccessor* _tmp4_;
		ValaPropertyAccessor* _tmp5_;
		_tmp4_ = vala_property_get_get_accessor (base_property);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		ValaPropertyAccessor* _tmp7_;
		ValaPropertyAccessor* _tmp8_;
		_tmp7_ = vala_property_get_get_accessor (self);
		_tmp8_ = _tmp7_;
		if (_tmp8_ != NULL) {
			ValaPropertyAccessor* _tmp9_;
			ValaPropertyAccessor* _tmp10_;
			_tmp9_ = vala_property_get_get_accessor (base_property);
			_tmp10_ = _tmp9_;
			_tmp6_ = _tmp10_ == NULL;
		} else {
			_tmp6_ = FALSE;
		}
		_tmp0_ = _tmp6_;
	}
	if (_tmp0_) {
		gchar* _tmp11_;
		_tmp11_ = g_strdup ("incompatible get accessor");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp11_;
		result = FALSE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp14_ = vala_property_get_set_accessor (self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ == NULL) {
		ValaPropertyAccessor* _tmp16_;
		ValaPropertyAccessor* _tmp17_;
		_tmp16_ = vala_property_get_set_accessor (base_property);
		_tmp17_ = _tmp16_;
		_tmp13_ = _tmp17_ != NULL;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		_tmp12_ = TRUE;
	} else {
		gboolean _tmp18_ = FALSE;
		ValaPropertyAccessor* _tmp19_;
		ValaPropertyAccessor* _tmp20_;
		_tmp19_ = vala_property_get_set_accessor (self);
		_tmp20_ = _tmp19_;
		if (_tmp20_ != NULL) {
			ValaPropertyAccessor* _tmp21_;
			ValaPropertyAccessor* _tmp22_;
			_tmp21_ = vala_property_get_set_accessor (base_property);
			_tmp22_ = _tmp21_;
			_tmp18_ = _tmp22_ == NULL;
		} else {
			_tmp18_ = FALSE;
		}
		_tmp12_ = _tmp18_;
	}
	if (_tmp12_) {
		gchar* _tmp23_;
		_tmp23_ = g_strdup ("incompatible set accessor");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp23_;
		result = FALSE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp24_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp25_);
	object_type = _tmp26_;
	_tmp27_ = vala_property_get_get_accessor (self);
	_tmp28_ = _tmp27_;
	if (_tmp28_ != NULL) {
		ValaDataType* actual_base_type = NULL;
		ValaPropertyAccessor* _tmp29_;
		ValaPropertyAccessor* _tmp30_;
		ValaDataType* _tmp31_;
		ValaDataType* _tmp32_;
		ValaDataType* _tmp33_;
		ValaDataType* _tmp34_;
		ValaDataType* _tmp35_;
		ValaPropertyAccessor* _tmp36_;
		ValaPropertyAccessor* _tmp37_;
		ValaDataType* _tmp38_;
		ValaDataType* _tmp39_;
		_tmp29_ = vala_property_get_get_accessor (base_property);
		_tmp30_ = _tmp29_;
		_tmp31_ = vala_property_accessor_get_value_type (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = object_type;
		_tmp34_ = vala_data_type_get_actual_type (_tmp32_, _tmp33_, NULL, (ValaCodeNode*) self);
		actual_base_type = _tmp34_;
		_tmp35_ = actual_base_type;
		_tmp36_ = vala_property_get_get_accessor (self);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_property_accessor_get_value_type (_tmp37_);
		_tmp39_ = _tmp38_;
		if (!vala_data_type_equals (_tmp35_, _tmp39_)) {
			gchar* _tmp40_;
			_tmp40_ = g_strdup ("incompatible get accessor type");
			_g_free0 (_vala_invalid_match);
			_vala_invalid_match = _tmp40_;
			result = FALSE;
			_vala_code_node_unref0 (actual_base_type);
			_vala_code_node_unref0 (object_type);
			if (invalid_match) {
				*invalid_match = _vala_invalid_match;
			} else {
				_g_free0 (_vala_invalid_match);
			}
			return result;
		}
		_vala_code_node_unref0 (actual_base_type);
	}
	_tmp41_ = vala_property_get_set_accessor (self);
	_tmp42_ = _tmp41_;
	if (_tmp42_ != NULL) {
		ValaDataType* actual_base_type = NULL;
		ValaPropertyAccessor* _tmp43_;
		ValaPropertyAccessor* _tmp44_;
		ValaDataType* _tmp45_;
		ValaDataType* _tmp46_;
		ValaDataType* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		ValaPropertyAccessor* _tmp50_;
		ValaPropertyAccessor* _tmp51_;
		ValaDataType* _tmp52_;
		ValaDataType* _tmp53_;
		ValaPropertyAccessor* _tmp55_;
		ValaPropertyAccessor* _tmp56_;
		gboolean _tmp57_;
		gboolean _tmp58_;
		ValaPropertyAccessor* _tmp59_;
		ValaPropertyAccessor* _tmp60_;
		gboolean _tmp61_;
		gboolean _tmp62_;
		ValaPropertyAccessor* _tmp64_;
		ValaPropertyAccessor* _tmp65_;
		gboolean _tmp66_;
		gboolean _tmp67_;
		ValaPropertyAccessor* _tmp68_;
		ValaPropertyAccessor* _tmp69_;
		gboolean _tmp70_;
		gboolean _tmp71_;
		_tmp43_ = vala_property_get_set_accessor (base_property);
		_tmp44_ = _tmp43_;
		_tmp45_ = vala_property_accessor_get_value_type (_tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = object_type;
		_tmp48_ = vala_data_type_get_actual_type (_tmp46_, _tmp47_, NULL, (ValaCodeNode*) self);
		actual_base_type = _tmp48_;
		_tmp49_ = actual_base_type;
		_tmp50_ = vala_property_get_set_accessor (self);
		_tmp51_ = _tmp50_;
		_tmp52_ = vala_property_accessor_get_value_type (_tmp51_);
		_tmp53_ = _tmp52_;
		if (!vala_data_type_equals (_tmp49_, _tmp53_)) {
			gchar* _tmp54_;
			_tmp54_ = g_strdup ("incompatible set accessor type");
			_g_free0 (_vala_invalid_match);
			_vala_invalid_match = _tmp54_;
			result = FALSE;
			_vala_code_node_unref0 (actual_base_type);
			_vala_code_node_unref0 (object_type);
			if (invalid_match) {
				*invalid_match = _vala_invalid_match;
			} else {
				_g_free0 (_vala_invalid_match);
			}
			return result;
		}
		_tmp55_ = vala_property_get_set_accessor (self);
		_tmp56_ = _tmp55_;
		_tmp57_ = vala_property_accessor_get_writable (_tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_property_get_set_accessor (base_property);
		_tmp60_ = _tmp59_;
		_tmp61_ = vala_property_accessor_get_writable (_tmp60_);
		_tmp62_ = _tmp61_;
		if (_tmp58_ != _tmp62_) {
			gchar* _tmp63_;
			_tmp63_ = g_strdup ("incompatible set accessor");
			_g_free0 (_vala_invalid_match);
			_vala_invalid_match = _tmp63_;
			result = FALSE;
			_vala_code_node_unref0 (actual_base_type);
			_vala_code_node_unref0 (object_type);
			if (invalid_match) {
				*invalid_match = _vala_invalid_match;
			} else {
				_g_free0 (_vala_invalid_match);
			}
			return result;
		}
		_tmp64_ = vala_property_get_set_accessor (self);
		_tmp65_ = _tmp64_;
		_tmp66_ = vala_property_accessor_get_construction (_tmp65_);
		_tmp67_ = _tmp66_;
		_tmp68_ = vala_property_get_set_accessor (base_property);
		_tmp69_ = _tmp68_;
		_tmp70_ = vala_property_accessor_get_construction (_tmp69_);
		_tmp71_ = _tmp70_;
		if (_tmp67_ != _tmp71_) {
			gchar* _tmp72_;
			_tmp72_ = g_strdup ("incompatible set accessor");
			_g_free0 (_vala_invalid_match);
			_vala_invalid_match = _tmp72_;
			result = FALSE;
			_vala_code_node_unref0 (actual_base_type);
			_vala_code_node_unref0 (object_type);
			if (invalid_match) {
				*invalid_match = _vala_invalid_match;
			} else {
				_g_free0 (_vala_invalid_match);
			}
			return result;
		}
		_vala_code_node_unref0 (actual_base_type);
	}
	_g_free0 (_vala_invalid_match);
	_vala_invalid_match = NULL;
	result = TRUE;
	_vala_code_node_unref0 (object_type);
	if (invalid_match) {
		*invalid_match = _vala_invalid_match;
	} else {
		_g_free0 (_vala_invalid_match);
	}
	return result;
}

static void
vala_property_real_replace_type (ValaCodeNode* base,
                                 ValaDataType* old_type,
                                 ValaDataType* new_type)
{
	ValaProperty * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaProperty*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_property_get_property_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_property_set_property_type (self, new_type);
	}
}

static void
vala_property_real_replace_expression (ValaCodeNode* base,
                                       ValaExpression* old_node,
                                       ValaExpression* new_node)
{
	ValaProperty * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaProperty*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_property_get_initializer (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_property_set_initializer (self, new_node);
	}
}

static void
vala_property_find_base_properties (ValaProperty* self)
{
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->priv->base_properties_valid) {
		return;
	}
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	if (VALA_IS_CLASS (_tmp1_)) {
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
		_tmp2_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp3_ = _tmp2_;
		vala_property_find_base_interface_property (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_CLASS, ValaClass));
		_tmp5_ = self->priv->_is_virtual;
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			gboolean _tmp6_;
			_tmp6_ = self->priv->_overrides;
			_tmp4_ = _tmp6_;
		}
		if (_tmp4_) {
			ValaSymbol* _tmp7_;
			ValaSymbol* _tmp8_;
			_tmp7_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp8_ = _tmp7_;
			vala_property_find_base_class_property (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_CLASS, ValaClass));
		}
	} else {
		ValaSymbol* _tmp9_;
		ValaSymbol* _tmp10_;
		_tmp9_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp10_ = _tmp9_;
		if (VALA_IS_INTERFACE (_tmp10_)) {
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_;
			_tmp12_ = self->priv->_is_virtual;
			if (_tmp12_) {
				_tmp11_ = TRUE;
			} else {
				gboolean _tmp13_;
				_tmp13_ = self->priv->_is_abstract;
				_tmp11_ = _tmp13_;
			}
			if (_tmp11_) {
				self->priv->_base_interface_property = self;
			}
		}
	}
	self->priv->base_properties_valid = TRUE;
}

static void
vala_property_find_base_class_property (ValaProperty* self,
                                        ValaClass* cl)
{
	ValaSymbol* sym = NULL;
	ValaScope* _tmp0_;
	ValaScope* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaClass* _tmp25_;
	ValaClass* _tmp26_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_symbol_get_scope ((ValaSymbol*) cl);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_scope_lookup (_tmp1_, _tmp3_);
	sym = _tmp4_;
	_tmp5_ = sym;
	if (VALA_IS_PROPERTY (_tmp5_)) {
		ValaProperty* base_property = NULL;
		ValaSymbol* _tmp6_;
		ValaProperty* _tmp7_;
		gboolean _tmp8_ = FALSE;
		ValaProperty* _tmp9_;
		gboolean _tmp10_;
		_tmp6_ = sym;
		_tmp7_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_PROPERTY, ValaProperty));
		base_property = _tmp7_;
		_tmp9_ = base_property;
		_tmp10_ = _tmp9_->priv->_is_abstract;
		if (_tmp10_) {
			_tmp8_ = TRUE;
		} else {
			ValaProperty* _tmp11_;
			gboolean _tmp12_;
			_tmp11_ = base_property;
			_tmp12_ = _tmp11_->priv->_is_virtual;
			_tmp8_ = _tmp12_;
		}
		if (_tmp8_) {
			gchar* invalid_match = NULL;
			ValaProperty* _tmp13_;
			gchar* _tmp14_ = NULL;
			gboolean _tmp15_;
			ValaProperty* _tmp24_;
			_tmp13_ = base_property;
			_tmp15_ = vala_property_compatible (self, _tmp13_, &_tmp14_);
			_g_free0 (invalid_match);
			invalid_match = _tmp14_;
			if (!_tmp15_) {
				ValaSourceReference* _tmp16_;
				ValaSourceReference* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				ValaProperty* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				const gchar* _tmp23_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp17_ = _tmp16_;
				_tmp18_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp19_ = _tmp18_;
				_tmp20_ = base_property;
				_tmp21_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = invalid_match;
				vala_report_error (_tmp17_, "Type and/or accessors of overriding property `%s' do not match overrid" \
"den property `%s': %s.", _tmp19_, _tmp22_, _tmp23_);
				_g_free0 (_tmp22_);
				_g_free0 (_tmp19_);
				_g_free0 (invalid_match);
				_vala_code_node_unref0 (base_property);
				_vala_code_node_unref0 (sym);
				return;
			}
			_tmp24_ = base_property;
			self->priv->_base_property = _tmp24_;
			_g_free0 (invalid_match);
			_vala_code_node_unref0 (base_property);
			_vala_code_node_unref0 (sym);
			return;
		}
		_vala_code_node_unref0 (base_property);
	}
	_tmp25_ = vala_class_get_base_class (cl);
	_tmp26_ = _tmp25_;
	if (_tmp26_ != NULL) {
		ValaClass* _tmp27_;
		ValaClass* _tmp28_;
		_tmp27_ = vala_class_get_base_class (cl);
		_tmp28_ = _tmp27_;
		vala_property_find_base_class_property (self, _tmp28_);
	}
	_vala_code_node_unref0 (sym);
}

static void
vala_property_find_base_interface_property (ValaProperty* self,
                                            ValaClass* cl)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		gint _type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _type_index = 0;
		_tmp0_ = vala_class_get_base_types (cl);
		_type_list = _tmp0_;
		_tmp1_ = _type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_type_size = _tmp3_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* type = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaDataType* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			_type_index = _type_index + 1;
			_tmp4_ = _type_index;
			_tmp5_ = _type_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _type_list;
			_tmp7_ = vala_list_get (_tmp6_, _type_index);
			type = (ValaDataType*) _tmp7_;
			_tmp8_ = type;
			_tmp9_ = vala_data_type_get_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			if (VALA_IS_INTERFACE (_tmp10_)) {
				ValaSymbol* sym = NULL;
				ValaDataType* _tmp11_;
				ValaTypeSymbol* _tmp12_;
				ValaTypeSymbol* _tmp13_;
				ValaScope* _tmp14_;
				ValaScope* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				ValaSymbol* _tmp18_;
				ValaSymbol* _tmp19_;
				_tmp11_ = type;
				_tmp12_ = vala_data_type_get_type_symbol (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = vala_symbol_get_scope ((ValaSymbol*) _tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = vala_symbol_get_name ((ValaSymbol*) self);
				_tmp17_ = _tmp16_;
				_tmp18_ = vala_scope_lookup (_tmp15_, _tmp17_);
				sym = _tmp18_;
				_tmp19_ = sym;
				if (VALA_IS_PROPERTY (_tmp19_)) {
					ValaProperty* base_property = NULL;
					ValaSymbol* _tmp20_;
					ValaProperty* _tmp21_;
					gboolean _tmp22_ = FALSE;
					ValaProperty* _tmp23_;
					gboolean _tmp24_;
					_tmp20_ = sym;
					_tmp21_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
					base_property = _tmp21_;
					_tmp23_ = base_property;
					_tmp24_ = _tmp23_->priv->_is_abstract;
					if (_tmp24_) {
						_tmp22_ = TRUE;
					} else {
						ValaProperty* _tmp25_;
						gboolean _tmp26_;
						_tmp25_ = base_property;
						_tmp26_ = _tmp25_->priv->_is_virtual;
						_tmp22_ = _tmp26_;
					}
					if (_tmp22_) {
						gchar* invalid_match = NULL;
						ValaProperty* _tmp27_;
						gchar* _tmp28_ = NULL;
						gboolean _tmp29_;
						ValaProperty* _tmp38_;
						_tmp27_ = base_property;
						_tmp29_ = vala_property_compatible (self, _tmp27_, &_tmp28_);
						_g_free0 (invalid_match);
						invalid_match = _tmp28_;
						if (!_tmp29_) {
							ValaSourceReference* _tmp30_;
							ValaSourceReference* _tmp31_;
							gchar* _tmp32_;
							gchar* _tmp33_;
							ValaProperty* _tmp34_;
							gchar* _tmp35_;
							gchar* _tmp36_;
							const gchar* _tmp37_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp31_ = _tmp30_;
							_tmp32_ = vala_symbol_get_full_name ((ValaSymbol*) self);
							_tmp33_ = _tmp32_;
							_tmp34_ = base_property;
							_tmp35_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp34_);
							_tmp36_ = _tmp35_;
							_tmp37_ = invalid_match;
							vala_report_error (_tmp31_, "Type and/or accessors of overriding property `%s' do not match overrid" \
"den property `%s': %s.", _tmp33_, _tmp36_, _tmp37_);
							_g_free0 (_tmp36_);
							_g_free0 (_tmp33_);
							_g_free0 (invalid_match);
							_vala_code_node_unref0 (base_property);
							_vala_code_node_unref0 (sym);
							_vala_code_node_unref0 (type);
							return;
						}
						_tmp38_ = base_property;
						self->priv->_base_interface_property = _tmp38_;
						_g_free0 (invalid_match);
						_vala_code_node_unref0 (base_property);
						_vala_code_node_unref0 (sym);
						_vala_code_node_unref0 (type);
						return;
					}
					_vala_code_node_unref0 (base_property);
				}
				_vala_code_node_unref0 (sym);
			}
			_vala_code_node_unref0 (type);
		}
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gboolean
vala_property_real_check (ValaCodeNode* base,
                          ValaCodeContext* context)
{
	ValaProperty * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	ValaProfile _tmp6_;
	ValaProfile _tmp7_;
	ValaParameter* _tmp21_;
	gboolean _tmp23_ = FALSE;
	ValaSymbol* _tmp24_;
	ValaSymbol* _tmp25_;
	gboolean _tmp46_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp83_;
	ValaSemanticAnalyzer* _tmp84_;
	ValaSourceFile* _tmp85_;
	ValaSourceFile* _tmp86_;
	ValaSourceFile* _tmp87_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp88_;
	ValaSemanticAnalyzer* _tmp89_;
	ValaSymbol* _tmp90_;
	ValaSymbol* _tmp91_;
	ValaSymbol* _tmp92_;
	ValaSourceReference* _tmp93_;
	ValaSourceReference* _tmp94_;
	ValaSemanticAnalyzer* _tmp101_;
	ValaSemanticAnalyzer* _tmp102_;
	ValaDataType* _tmp103_;
	ValaDataType* _tmp104_;
	ValaField* _tmp107_;
	ValaField* _tmp108_;
	ValaDataType* _tmp111_;
	ValaDataType* _tmp112_;
	gboolean _tmp113_;
	gboolean _tmp114_;
	gboolean _tmp119_ = FALSE;
	ValaPropertyAccessor* _tmp120_;
	ValaPropertyAccessor* _tmp121_;
	ValaPropertyAccessor* _tmp128_;
	ValaPropertyAccessor* _tmp129_;
	ValaPropertyAccessor* _tmp132_;
	ValaPropertyAccessor* _tmp133_;
	gboolean _tmp143_ = FALSE;
	gboolean _tmp144_ = FALSE;
	ValaExpression* _tmp145_;
	ValaExpression* _tmp146_;
	ValaExpression* _tmp154_;
	ValaExpression* _tmp155_;
	ValaDataType* _tmp158_;
	ValaDataType* _tmp159_;
	gboolean _tmp168_ = FALSE;
	gboolean _tmp169_ = FALSE;
	gboolean _tmp170_;
	gboolean _tmp179_ = FALSE;
	gboolean _tmp180_ = FALSE;
	gboolean _tmp181_ = FALSE;
	gboolean _tmp182_;
	gboolean _tmp183_;
	gboolean _tmp197_ = FALSE;
	ValaPropertyAccessor* _tmp198_;
	ValaPropertyAccessor* _tmp199_;
	gboolean _tmp210_ = FALSE;
	gboolean _tmp211_ = FALSE;
	gboolean _tmp212_ = FALSE;
	ValaExpression* _tmp213_;
	ValaExpression* _tmp214_;
	ValaSemanticAnalyzer* _tmp243_;
	ValaSemanticAnalyzer* _tmp244_;
	ValaSourceFile* _tmp245_;
	ValaSemanticAnalyzer* _tmp246_;
	ValaSemanticAnalyzer* _tmp247_;
	ValaSymbol* _tmp248_;
	gboolean _tmp249_;
	gboolean _tmp250_;
	gboolean result;
	self = (ValaProperty*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp6_ = vala_code_context_get_profile (context);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == VALA_PROFILE_GOBJECT) {
		ValaSymbol* _tmp8_;
		ValaSymbol* _tmp9_;
		_tmp8_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp9_ = _tmp8_;
		_tmp5_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp9_);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaSemanticAnalyzer* _tmp12_;
		ValaSemanticAnalyzer* _tmp13_;
		ValaClass* _tmp14_;
		_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_code_context_get_analyzer (context);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_->object_type;
		_tmp4_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), (ValaTypeSymbol*) _tmp14_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp15_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp16_ = _tmp15_;
		if (!vala_property_is_valid_name (_tmp16_)) {
			ValaSourceReference* _tmp17_;
			ValaSourceReference* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp17_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp20_ = _tmp19_;
			vala_report_error (_tmp18_, "Name `%s' is not valid for a GLib.Object property", _tmp20_);
		}
	}
	_tmp21_ = self->priv->_this_parameter;
	if (_tmp21_ != NULL) {
		ValaParameter* _tmp22_;
		_tmp22_ = self->priv->_this_parameter;
		vala_code_node_check ((ValaCodeNode*) _tmp22_, context);
	}
	_tmp24_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp25_ = _tmp24_;
	if (VALA_IS_CLASS (_tmp25_)) {
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_;
		_tmp27_ = self->priv->_is_abstract;
		if (_tmp27_) {
			_tmp26_ = TRUE;
		} else {
			gboolean _tmp28_;
			_tmp28_ = self->priv->_is_virtual;
			_tmp26_ = _tmp28_;
		}
		_tmp23_ = _tmp26_;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaClass* _tmp31_;
		gboolean _tmp32_ = FALSE;
		ValaClass* _tmp33_;
		gboolean _tmp34_;
		gboolean _tmp35_;
		ValaClass* _tmp41_;
		gboolean _tmp42_;
		gboolean _tmp43_;
		_tmp29_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp30_ = _tmp29_;
		_tmp31_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp31_;
		_tmp33_ = cl;
		_tmp34_ = vala_class_get_is_compact (_tmp33_);
		_tmp35_ = _tmp34_;
		if (_tmp35_) {
			ValaClass* _tmp36_;
			ValaClass* _tmp37_;
			ValaClass* _tmp38_;
			_tmp36_ = cl;
			_tmp37_ = vala_class_get_base_class (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp32_ = _tmp38_ != NULL;
		} else {
			_tmp32_ = FALSE;
		}
		if (_tmp32_) {
			ValaSourceReference* _tmp39_;
			ValaSourceReference* _tmp40_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp39_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp40_ = _tmp39_;
			vala_report_error (_tmp40_, "Abstract and virtual properties may not be declared in derived compact" \
" classes");
			result = FALSE;
			_vala_code_node_unref0 (cl);
			return result;
		}
		_tmp41_ = cl;
		_tmp42_ = vala_class_get_is_opaque (_tmp41_);
		_tmp43_ = _tmp42_;
		if (_tmp43_) {
			ValaSourceReference* _tmp44_;
			ValaSourceReference* _tmp45_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp44_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp45_ = _tmp44_;
			vala_report_error (_tmp45_, "Abstract and virtual properties may not be declared in opaque compact " \
"classes");
			result = FALSE;
			_vala_code_node_unref0 (cl);
			return result;
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp46_ = self->priv->_is_abstract;
	if (_tmp46_) {
		ValaSymbol* _tmp47_;
		ValaSymbol* _tmp48_;
		_tmp47_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp48_ = _tmp47_;
		if (VALA_IS_CLASS (_tmp48_)) {
			ValaClass* cl = NULL;
			ValaSymbol* _tmp49_;
			ValaSymbol* _tmp50_;
			ValaClass* _tmp51_;
			ValaClass* _tmp52_;
			gboolean _tmp53_;
			gboolean _tmp54_;
			_tmp49_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp50_ = _tmp49_;
			_tmp51_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp51_;
			_tmp52_ = cl;
			_tmp53_ = vala_class_get_is_abstract (_tmp52_);
			_tmp54_ = _tmp53_;
			if (!_tmp54_) {
				ValaSourceReference* _tmp55_;
				ValaSourceReference* _tmp56_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp55_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp56_ = _tmp55_;
				vala_report_error (_tmp56_, "Abstract properties may not be declared in non-abstract classes");
				result = FALSE;
				_vala_code_node_unref0 (cl);
				return result;
			}
			_vala_code_node_unref0 (cl);
		} else {
			ValaSymbol* _tmp57_;
			ValaSymbol* _tmp58_;
			_tmp57_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp58_ = _tmp57_;
			if (!VALA_IS_INTERFACE (_tmp58_)) {
				ValaSourceReference* _tmp59_;
				ValaSourceReference* _tmp60_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp59_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp60_ = _tmp59_;
				vala_report_error (_tmp60_, "Abstract properties may not be declared outside of classes and interfa" \
"ces");
				result = FALSE;
				return result;
			}
		}
	} else {
		gboolean _tmp61_;
		_tmp61_ = self->priv->_is_virtual;
		if (_tmp61_) {
			gboolean _tmp62_ = FALSE;
			ValaSymbol* _tmp63_;
			ValaSymbol* _tmp64_;
			_tmp63_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp64_ = _tmp63_;
			if (!VALA_IS_CLASS (_tmp64_)) {
				ValaSymbol* _tmp65_;
				ValaSymbol* _tmp66_;
				_tmp65_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp66_ = _tmp65_;
				_tmp62_ = !VALA_IS_INTERFACE (_tmp66_);
			} else {
				_tmp62_ = FALSE;
			}
			if (_tmp62_) {
				ValaSourceReference* _tmp67_;
				ValaSourceReference* _tmp68_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp67_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp68_ = _tmp67_;
				vala_report_error (_tmp68_, "Virtual properties may not be declared outside of classes and interfac" \
"es");
				result = FALSE;
				return result;
			}
		} else {
			gboolean _tmp69_;
			_tmp69_ = self->priv->_overrides;
			if (_tmp69_) {
				ValaSymbol* _tmp70_;
				ValaSymbol* _tmp71_;
				_tmp70_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp71_ = _tmp70_;
				if (!VALA_IS_CLASS (_tmp71_)) {
					ValaSourceReference* _tmp72_;
					ValaSourceReference* _tmp73_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp72_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp73_ = _tmp72_;
					vala_report_error (_tmp73_, "Properties may not be overridden outside of classes");
					result = FALSE;
					return result;
				}
			} else {
				ValaSymbolAccessibility _tmp74_;
				ValaSymbolAccessibility _tmp75_;
				_tmp74_ = vala_symbol_get_access ((ValaSymbol*) self);
				_tmp75_ = _tmp74_;
				if (_tmp75_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
					gboolean _tmp76_ = FALSE;
					ValaSymbol* _tmp77_;
					ValaSymbol* _tmp78_;
					_tmp77_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
					_tmp78_ = _tmp77_;
					if (!VALA_IS_CLASS (_tmp78_)) {
						ValaSymbol* _tmp79_;
						ValaSymbol* _tmp80_;
						_tmp79_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
						_tmp80_ = _tmp79_;
						_tmp76_ = !VALA_IS_INTERFACE (_tmp80_);
					} else {
						_tmp76_ = FALSE;
					}
					if (_tmp76_) {
						ValaSourceReference* _tmp81_;
						ValaSourceReference* _tmp82_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp81_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp82_ = _tmp81_;
						vala_report_error (_tmp82_, "Protected properties may not be declared outside of classes and interf" \
"aces");
						result = FALSE;
						return result;
					}
				}
			}
		}
	}
	_tmp83_ = vala_code_context_get_analyzer (context);
	_tmp84_ = _tmp83_;
	_tmp85_ = vala_semantic_analyzer_get_current_source_file (_tmp84_);
	_tmp86_ = _tmp85_;
	_tmp87_ = _vala_source_file_ref0 (_tmp86_);
	old_source_file = _tmp87_;
	_tmp88_ = vala_code_context_get_analyzer (context);
	_tmp89_ = _tmp88_;
	_tmp90_ = vala_semantic_analyzer_get_current_symbol (_tmp89_);
	_tmp91_ = _tmp90_;
	_tmp92_ = _vala_code_node_ref0 (_tmp91_);
	old_symbol = _tmp92_;
	_tmp93_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp94_ = _tmp93_;
	if (_tmp94_ != NULL) {
		ValaSemanticAnalyzer* _tmp95_;
		ValaSemanticAnalyzer* _tmp96_;
		ValaSourceReference* _tmp97_;
		ValaSourceReference* _tmp98_;
		ValaSourceFile* _tmp99_;
		ValaSourceFile* _tmp100_;
		_tmp95_ = vala_code_context_get_analyzer (context);
		_tmp96_ = _tmp95_;
		_tmp97_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp98_ = _tmp97_;
		_tmp99_ = vala_source_reference_get_file (_tmp98_);
		_tmp100_ = _tmp99_;
		vala_semantic_analyzer_set_current_source_file (_tmp96_, _tmp100_);
	}
	_tmp101_ = vala_code_context_get_analyzer (context);
	_tmp102_ = _tmp101_;
	vala_semantic_analyzer_set_current_symbol (_tmp102_, (ValaSymbol*) self);
	_tmp103_ = vala_property_get_property_type (self);
	_tmp104_ = _tmp103_;
	if (VALA_IS_VOID_TYPE (_tmp104_)) {
		ValaSourceReference* _tmp105_;
		ValaSourceReference* _tmp106_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp105_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp106_ = _tmp105_;
		vala_report_error (_tmp106_, "'void' not supported as property type");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp107_ = vala_property_get_field (self);
	_tmp108_ = _tmp107_;
	if (_tmp108_ != NULL) {
		ValaField* _tmp109_;
		ValaField* _tmp110_;
		_tmp109_ = vala_property_get_field (self);
		_tmp110_ = _tmp109_;
		vala_code_node_check ((ValaCodeNode*) _tmp110_, context);
	}
	_tmp111_ = vala_property_get_property_type (self);
	_tmp112_ = _tmp111_;
	vala_code_node_check ((ValaCodeNode*) _tmp112_, context);
	_tmp113_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp114_ = _tmp113_;
	if (!_tmp114_) {
		ValaSemanticAnalyzer* _tmp115_;
		ValaSemanticAnalyzer* _tmp116_;
		ValaDataType* _tmp117_;
		ValaDataType* _tmp118_;
		_tmp115_ = vala_code_context_get_analyzer (context);
		_tmp116_ = _tmp115_;
		_tmp117_ = vala_property_get_property_type (self);
		_tmp118_ = _tmp117_;
		vala_semantic_analyzer_check_type (_tmp116_, _tmp118_);
	}
	_tmp120_ = vala_property_get_get_accessor (self);
	_tmp121_ = _tmp120_;
	if (_tmp121_ == NULL) {
		ValaPropertyAccessor* _tmp122_;
		ValaPropertyAccessor* _tmp123_;
		_tmp122_ = vala_property_get_set_accessor (self);
		_tmp123_ = _tmp122_;
		_tmp119_ = _tmp123_ == NULL;
	} else {
		_tmp119_ = FALSE;
	}
	if (_tmp119_) {
		ValaSourceReference* _tmp124_;
		ValaSourceReference* _tmp125_;
		gchar* _tmp126_;
		gchar* _tmp127_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp124_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp125_ = _tmp124_;
		_tmp126_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp127_ = _tmp126_;
		vala_report_error (_tmp125_, "Property `%s' must have a `get' accessor and/or a `set' mutator", _tmp127_);
		_g_free0 (_tmp127_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp128_ = vala_property_get_get_accessor (self);
	_tmp129_ = _tmp128_;
	if (_tmp129_ != NULL) {
		ValaPropertyAccessor* _tmp130_;
		ValaPropertyAccessor* _tmp131_;
		_tmp130_ = vala_property_get_get_accessor (self);
		_tmp131_ = _tmp130_;
		vala_code_node_check ((ValaCodeNode*) _tmp131_, context);
	}
	_tmp132_ = vala_property_get_set_accessor (self);
	_tmp133_ = _tmp132_;
	if (_tmp133_ != NULL) {
		ValaAttribute* _tmp134_;
		ValaPropertyAccessor* _tmp141_;
		ValaPropertyAccessor* _tmp142_;
		_tmp134_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "GtkChild");
		if (_tmp134_ != NULL) {
			ValaPropertyAccessor* _tmp135_;
			ValaPropertyAccessor* _tmp136_;
			ValaSourceReference* _tmp137_;
			ValaSourceReference* _tmp138_;
			gchar* _tmp139_;
			gchar* _tmp140_;
			_tmp135_ = vala_property_get_set_accessor (self);
			_tmp136_ = _tmp135_;
			_tmp137_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp136_);
			_tmp138_ = _tmp137_;
			_tmp139_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp140_ = _tmp139_;
			vala_report_warning (_tmp138_, "[GtkChild] property `%s' is not allowed to have `set' accessor", _tmp140_);
			_g_free0 (_tmp140_);
		}
		_tmp141_ = vala_property_get_set_accessor (self);
		_tmp142_ = _tmp141_;
		vala_code_node_check ((ValaCodeNode*) _tmp142_, context);
	}
	_tmp145_ = vala_property_get_initializer (self);
	_tmp146_ = _tmp145_;
	if (_tmp146_ != NULL) {
		ValaField* _tmp147_;
		ValaField* _tmp148_;
		_tmp147_ = vala_property_get_field (self);
		_tmp148_ = _tmp147_;
		_tmp144_ = _tmp148_ == NULL;
	} else {
		_tmp144_ = FALSE;
	}
	if (_tmp144_) {
		gboolean _tmp149_;
		_tmp149_ = self->priv->_is_abstract;
		_tmp143_ = !_tmp149_;
	} else {
		_tmp143_ = FALSE;
	}
	if (_tmp143_) {
		ValaSourceReference* _tmp150_;
		ValaSourceReference* _tmp151_;
		gchar* _tmp152_;
		gchar* _tmp153_;
		_tmp150_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp151_ = _tmp150_;
		_tmp152_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp153_ = _tmp152_;
		vala_report_error (_tmp151_, "Property `%s' with custom `get' accessor and/or `set' mutator cannot h" \
"ave `default' value", _tmp153_);
		_g_free0 (_tmp153_);
	}
	_tmp154_ = vala_property_get_initializer (self);
	_tmp155_ = _tmp154_;
	if (_tmp155_ != NULL) {
		ValaExpression* _tmp156_;
		ValaExpression* _tmp157_;
		_tmp156_ = vala_property_get_initializer (self);
		_tmp157_ = _tmp156_;
		vala_code_node_check ((ValaCodeNode*) _tmp157_, context);
	}
	_tmp158_ = vala_property_get_property_type (self);
	_tmp159_ = _tmp158_;
	if (!vala_data_type_is_accessible (_tmp159_, (ValaSymbol*) self)) {
		ValaSourceReference* _tmp160_;
		ValaSourceReference* _tmp161_;
		ValaDataType* _tmp162_;
		ValaDataType* _tmp163_;
		gchar* _tmp164_;
		gchar* _tmp165_;
		gchar* _tmp166_;
		gchar* _tmp167_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp160_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp161_ = _tmp160_;
		_tmp162_ = vala_property_get_property_type (self);
		_tmp163_ = _tmp162_;
		_tmp164_ = vala_code_node_to_string ((ValaCodeNode*) _tmp163_);
		_tmp165_ = _tmp164_;
		_tmp166_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp167_ = _tmp166_;
		vala_report_error (_tmp161_, "property type `%s' is less accessible than property `%s'", _tmp165_, _tmp167_);
		_g_free0 (_tmp167_);
		_g_free0 (_tmp165_);
	}
	_tmp170_ = self->priv->_overrides;
	if (_tmp170_) {
		ValaProperty* _tmp171_;
		ValaProperty* _tmp172_;
		_tmp171_ = vala_property_get_base_property (self);
		_tmp172_ = _tmp171_;
		_tmp169_ = _tmp172_ == NULL;
	} else {
		_tmp169_ = FALSE;
	}
	if (_tmp169_) {
		ValaProperty* _tmp173_;
		ValaProperty* _tmp174_;
		_tmp173_ = vala_property_get_base_interface_property (self);
		_tmp174_ = _tmp173_;
		_tmp168_ = _tmp174_ == NULL;
	} else {
		_tmp168_ = FALSE;
	}
	if (_tmp168_) {
		ValaSourceReference* _tmp175_;
		ValaSourceReference* _tmp176_;
		gchar* _tmp177_;
		gchar* _tmp178_;
		_tmp175_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp176_ = _tmp175_;
		_tmp177_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp178_ = _tmp177_;
		vala_report_error (_tmp176_, "%s: no suitable property found to override", _tmp178_);
		_g_free0 (_tmp178_);
	}
	_tmp182_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp183_ = _tmp182_;
	if (!_tmp183_) {
		gboolean _tmp184_;
		_tmp184_ = self->priv->_overrides;
		_tmp181_ = !_tmp184_;
	} else {
		_tmp181_ = FALSE;
	}
	if (_tmp181_) {
		gboolean _tmp185_;
		gboolean _tmp186_;
		_tmp185_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp186_ = _tmp185_;
		_tmp180_ = !_tmp186_;
	} else {
		_tmp180_ = FALSE;
	}
	if (_tmp180_) {
		ValaSymbol* _tmp187_;
		ValaSymbol* _tmp188_;
		_tmp187_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp188_ = _tmp187_;
		_tmp179_ = _tmp188_ != NULL;
		_vala_code_node_unref0 (_tmp188_);
	} else {
		_tmp179_ = FALSE;
	}
	if (_tmp179_) {
		ValaSourceReference* _tmp189_;
		ValaSourceReference* _tmp190_;
		gchar* _tmp191_;
		gchar* _tmp192_;
		ValaSymbol* _tmp193_;
		ValaSymbol* _tmp194_;
		gchar* _tmp195_;
		gchar* _tmp196_;
		_tmp189_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp190_ = _tmp189_;
		_tmp191_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp192_ = _tmp191_;
		_tmp193_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp194_ = _tmp193_;
		_tmp195_ = vala_symbol_get_full_name (_tmp194_);
		_tmp196_ = _tmp195_;
		vala_report_warning (_tmp190_, "%s hides inherited property `%s'. Use the `new' keyword if hiding was " \
"intentional", _tmp192_, _tmp196_);
		_g_free0 (_tmp196_);
		_vala_code_node_unref0 (_tmp194_);
		_g_free0 (_tmp192_);
	}
	_tmp198_ = vala_property_get_set_accessor (self);
	_tmp199_ = _tmp198_;
	if (_tmp199_ != NULL) {
		ValaPropertyAccessor* _tmp200_;
		ValaPropertyAccessor* _tmp201_;
		gboolean _tmp202_;
		gboolean _tmp203_;
		_tmp200_ = vala_property_get_set_accessor (self);
		_tmp201_ = _tmp200_;
		_tmp202_ = vala_property_accessor_get_construction (_tmp201_);
		_tmp203_ = _tmp202_;
		_tmp197_ = _tmp203_;
	} else {
		_tmp197_ = FALSE;
	}
	if (_tmp197_) {
		ValaSymbolAccessibility _tmp204_;
		ValaSymbolAccessibility _tmp205_;
		_tmp204_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp205_ = _tmp204_;
		if (_tmp205_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
			ValaSourceReference* _tmp206_;
			ValaSourceReference* _tmp207_;
			gchar* _tmp208_;
			gchar* _tmp209_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp206_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp207_ = _tmp206_;
			_tmp208_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp209_ = _tmp208_;
			vala_report_error (_tmp207_, "%s: construct properties must be public", _tmp209_);
			_g_free0 (_tmp209_);
		}
	}
	_tmp213_ = vala_property_get_initializer (self);
	_tmp214_ = _tmp213_;
	if (_tmp214_ != NULL) {
		ValaExpression* _tmp215_;
		ValaExpression* _tmp216_;
		gboolean _tmp217_;
		gboolean _tmp218_;
		_tmp215_ = vala_property_get_initializer (self);
		_tmp216_ = _tmp215_;
		_tmp217_ = vala_code_node_get_error ((ValaCodeNode*) _tmp216_);
		_tmp218_ = _tmp217_;
		_tmp212_ = !_tmp218_;
	} else {
		_tmp212_ = FALSE;
	}
	if (_tmp212_) {
		ValaExpression* _tmp219_;
		ValaExpression* _tmp220_;
		ValaDataType* _tmp221_;
		ValaDataType* _tmp222_;
		_tmp219_ = vala_property_get_initializer (self);
		_tmp220_ = _tmp219_;
		_tmp221_ = vala_expression_get_value_type (_tmp220_);
		_tmp222_ = _tmp221_;
		_tmp211_ = _tmp222_ != NULL;
	} else {
		_tmp211_ = FALSE;
	}
	if (_tmp211_) {
		ValaExpression* _tmp223_;
		ValaExpression* _tmp224_;
		ValaDataType* _tmp225_;
		ValaDataType* _tmp226_;
		ValaDataType* _tmp227_;
		ValaDataType* _tmp228_;
		_tmp223_ = vala_property_get_initializer (self);
		_tmp224_ = _tmp223_;
		_tmp225_ = vala_expression_get_value_type (_tmp224_);
		_tmp226_ = _tmp225_;
		_tmp227_ = vala_property_get_property_type (self);
		_tmp228_ = _tmp227_;
		_tmp210_ = !vala_data_type_compatible (_tmp226_, _tmp228_);
	} else {
		_tmp210_ = FALSE;
	}
	if (_tmp210_) {
		ValaExpression* _tmp229_;
		ValaExpression* _tmp230_;
		ValaSourceReference* _tmp231_;
		ValaSourceReference* _tmp232_;
		ValaDataType* _tmp233_;
		ValaDataType* _tmp234_;
		gchar* _tmp235_;
		gchar* _tmp236_;
		ValaExpression* _tmp237_;
		ValaExpression* _tmp238_;
		ValaDataType* _tmp239_;
		ValaDataType* _tmp240_;
		gchar* _tmp241_;
		gchar* _tmp242_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp229_ = vala_property_get_initializer (self);
		_tmp230_ = _tmp229_;
		_tmp231_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp230_);
		_tmp232_ = _tmp231_;
		_tmp233_ = vala_property_get_property_type (self);
		_tmp234_ = _tmp233_;
		_tmp235_ = vala_code_node_to_string ((ValaCodeNode*) _tmp234_);
		_tmp236_ = _tmp235_;
		_tmp237_ = vala_property_get_initializer (self);
		_tmp238_ = _tmp237_;
		_tmp239_ = vala_expression_get_value_type (_tmp238_);
		_tmp240_ = _tmp239_;
		_tmp241_ = vala_code_node_to_string ((ValaCodeNode*) _tmp240_);
		_tmp242_ = _tmp241_;
		vala_report_error (_tmp232_, "Expected initializer of type `%s' but got `%s'", _tmp236_, _tmp242_);
		_g_free0 (_tmp242_);
		_g_free0 (_tmp236_);
	}
	_tmp243_ = vala_code_context_get_analyzer (context);
	_tmp244_ = _tmp243_;
	_tmp245_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp244_, _tmp245_);
	_tmp246_ = vala_code_context_get_analyzer (context);
	_tmp247_ = _tmp246_;
	_tmp248_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp247_, _tmp248_);
	_tmp249_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp250_ = _tmp249_;
	result = !_tmp250_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gboolean
vala_property_is_valid_name (const gchar* name)
{
	gchar* p = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (name != NULL, FALSE);
	if (string_get (name, (glong) 0) < 'A') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = string_get (name, (glong) 0) > 'Z';
	}
	if (_tmp1_) {
		gboolean _tmp2_ = FALSE;
		if (string_get (name, (glong) 0) < 'a') {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = string_get (name, (glong) 0) > 'z';
		}
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	{
		gboolean _tmp3_ = FALSE;
		p = name;
		_tmp3_ = TRUE;
		while (TRUE) {
			gchar* _tmp5_;
			gchar c = '\0';
			gchar* _tmp6_;
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_ = FALSE;
			if (!_tmp3_) {
				gchar* _tmp4_;
				_tmp4_ = p;
				p = _tmp4_ + 1;
			}
			_tmp3_ = FALSE;
			_tmp5_ = p;
			if (!((*_tmp5_) != '\0')) {
				break;
			}
			_tmp6_ = p;
			c = *_tmp6_;
			if (c != '-') {
				_tmp10_ = c != '_';
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				gboolean _tmp11_ = FALSE;
				if (c < '0') {
					_tmp11_ = TRUE;
				} else {
					_tmp11_ = c > '9';
				}
				_tmp9_ = _tmp11_;
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				gboolean _tmp12_ = FALSE;
				if (c < 'A') {
					_tmp12_ = TRUE;
				} else {
					_tmp12_ = c > 'Z';
				}
				_tmp8_ = _tmp12_;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				gboolean _tmp13_ = FALSE;
				if (c < 'a') {
					_tmp13_ = TRUE;
				} else {
					_tmp13_ = c > 'z';
				}
				_tmp7_ = _tmp13_;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = FALSE;
				return result;
			}
		}
	}
	result = TRUE;
	return result;
}

static void
vala_property_class_init (ValaPropertyClass * klass,
                          gpointer klass_data)
{
	vala_property_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_property_finalize;
	g_type_class_adjust_private_offset (klass, &ValaProperty_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_property_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_property_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_property_real_replace_type;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_property_real_replace_expression;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_property_real_check;
}

static void
vala_property_vala_lockable_interface_init (ValaLockableIface * iface,
                                            gpointer iface_data)
{
	vala_property_vala_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_lock_used = vala_property_real_get_lock_used;
	iface->set_lock_used = vala_property_real_set_lock_used;
}

static void
vala_property_instance_init (ValaProperty * self,
                             gpointer klass)
{
	self->priv = vala_property_get_instance_private (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
}

static void
vala_property_finalize (ValaCodeNode * obj)
{
	ValaProperty * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_PROPERTY, ValaProperty);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	_vala_code_node_unref0 (self->priv->_initializer);
	_vala_code_node_unref0 (self->priv->_data_type);
	_vala_code_node_unref0 (self->priv->_get_accessor);
	_vala_code_node_unref0 (self->priv->_set_accessor);
	_g_free0 (self->priv->_nick);
	_g_free0 (self->priv->_blurb);
	_g_free0 (self->priv->_notify);
	_vala_code_node_unref0 (self->priv->_field);
	VALA_CODE_NODE_CLASS (vala_property_parent_class)->finalize (obj);
}

/**
 * Represents a property declaration in the source code.
 */
static GType
vala_property_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaPropertyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_property_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaProperty), 0, (GInstanceInitFunc) vala_property_instance_init, NULL };
	static const GInterfaceInfo vala_lockable_info = { (GInterfaceInitFunc) vala_property_vala_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_property_type_id;
	vala_property_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaProperty", &g_define_type_info, 0);
	g_type_add_interface_static (vala_property_type_id, VALA_TYPE_LOCKABLE, &vala_lockable_info);
	ValaProperty_private_offset = g_type_add_instance_private (vala_property_type_id, sizeof (ValaPropertyPrivate));
	return vala_property_type_id;
}

GType
vala_property_get_type (void)
{
	static volatile gsize vala_property_type_id__once = 0;
	if (g_once_init_enter (&vala_property_type_id__once)) {
		GType vala_property_type_id;
		vala_property_type_id = vala_property_get_type_once ();
		g_once_init_leave (&vala_property_type_id__once, vala_property_type_id);
	}
	return vala_property_type_id__once;
}

