'\" t
.\"     Title: xlistdeviceproperties
.\"    Author: [FIXME: author] [see http://docbook.sf.net/el/author]
.\" Generator: DocBook XSL Stylesheets v1.79.1 <http://docbook.sf.net/>
.\"      Date: 09/15/2021
.\"    Manual: \ \&
.\"    Source: \ \&
.\"  Language: English
.\"
.TH "XLISTDEVICEPROPERTIE" "libmansuffix" "09/15/2021" "\ \&" "\ \&"
.\" -----------------------------------------------------------------
.\" * Define some portability stuff
.\" -----------------------------------------------------------------
.\" ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
.\" http://bugs.debian.org/507673
.\" http://lists.gnu.org/archive/html/groff/2009-02/msg00013.html
.\" ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
.ie \n(.g .ds Aq \(aq
.el       .ds Aq '
.\" -----------------------------------------------------------------
.\" * set default formatting
.\" -----------------------------------------------------------------
.\" disable hyphenation
.nh
.\" disable justification (adjust text to left margin only)
.ad l
.\" -----------------------------------------------------------------
.\" * MAIN CONTENT STARTS HERE *
.\" -----------------------------------------------------------------
.SH "NAME"
XListDeviceProperties \- List a device\*(Aqs properties\&.
.SH "SYNOPSIS"
.sp
.nf
#include <X11/extensions/XInput\&.h>
.fi
.sp
.nf
Atom* XListDeviceProperties( Display *display,
                             XDevice *device,
                             int *nprops_return);
.fi
.sp
.nf
display
       Specifies the connection to the X server\&.
.fi
.sp
.nf
device
       The device to list the properties for\&.
.fi
.sp
.nf
nprops_return
       Specifies the number of Atoms returned\&.
.fi
.SH "DESCRIPTION"
.sp
.if n \{\
.RS 4
.\}
.nf
The XListDeviceProperties function returns a list of the
properties associated with the input device specified in
device\&. Each device may have an arbitrary number of properties
attached, some of which were created by the driver and/or
server, others created by clients at runtime\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
The client is expected to free the list of properties using
XFree\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
XListDeviceProperties can generate a BadDevice error\&.
.fi
.if n \{\
.RE
.\}
.SH "DIAGNOSTICS"
.sp
.if n \{\
.RS 4
.\}
.nf
BadDevice
       An invalid device was specified\&. The device does not
       exist\&.
.fi
.if n \{\
.RE
.\}
.SH "SEE ALSO"
.sp
.if n \{\
.RS 4
.\}
.nf
XChangeDeviceProperty(libmansuffix),
XGetDeviceProperty(libmansuffix),
XDeleteDeviceProperty(libmansuffix)
.fi
.if n \{\
.RE
.\}
