/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.systemchannels;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.Log;
import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.plugin.common.BasicMessageChannel;
import io.flutter.plugin.common.StandardMessageCodec;
import io.flutter.view.AccessibilityBridge;
import java.util.HashMap;

public class AccessibilityChannel {
    private static final String TAG = "AccessibilityChannel";
    @NonNull
    public final BasicMessageChannel<Object> channel;
    @NonNull
    public final FlutterJNI flutterJNI;
    @Nullable
    private AccessibilityMessageHandler handler;
    public final BasicMessageChannel.MessageHandler<Object> parsingMessageHandler = new BasicMessageChannel.MessageHandler<Object>(){

        @Override
        public void onMessage(@Nullable Object message, @NonNull BasicMessageChannel.Reply<Object> reply) {
            if (AccessibilityChannel.this.handler == null) {
                reply.reply(null);
                return;
            }
            HashMap annotatedEvent = (HashMap)message;
            String type = (String)annotatedEvent.get("type");
            HashMap data = (HashMap)annotatedEvent.get("data");
            Log.v(AccessibilityChannel.TAG, "Received " + type + " message.");
            switch (type) {
                case "announce": {
                    String announceMessage = (String)data.get("message");
                    if (announceMessage == null) break;
                    AccessibilityChannel.this.handler.announce(announceMessage);
                    break;
                }
                case "tap": {
                    Integer nodeId = (Integer)annotatedEvent.get("nodeId");
                    if (nodeId == null) break;
                    AccessibilityChannel.this.handler.onTap(nodeId);
                    break;
                }
                case "longPress": {
                    Integer nodeId = (Integer)annotatedEvent.get("nodeId");
                    if (nodeId == null) break;
                    AccessibilityChannel.this.handler.onLongPress(nodeId);
                    break;
                }
                case "focus": {
                    Integer nodeId = (Integer)annotatedEvent.get("nodeId");
                    if (nodeId == null) break;
                    AccessibilityChannel.this.handler.onFocus(nodeId);
                    break;
                }
                case "tooltip": {
                    String tooltipMessage = (String)data.get("message");
                    if (tooltipMessage == null) break;
                    AccessibilityChannel.this.handler.onTooltip(tooltipMessage);
                    break;
                }
            }
            reply.reply(null);
        }
    };

    public AccessibilityChannel(@NonNull DartExecutor dartExecutor, @NonNull FlutterJNI flutterJNI) {
        this.channel = new BasicMessageChannel<Object>(dartExecutor, "flutter/accessibility", StandardMessageCodec.INSTANCE);
        this.channel.setMessageHandler(this.parsingMessageHandler);
        this.flutterJNI = flutterJNI;
    }

    public void onAndroidAccessibilityEnabled() {
        this.flutterJNI.setSemanticsEnabled(true);
    }

    public void onAndroidAccessibilityDisabled() {
        this.flutterJNI.setSemanticsEnabled(false);
    }

    public void setAccessibilityFeatures(int accessibilityFeatureFlags) {
        this.flutterJNI.setAccessibilityFeatures(accessibilityFeatureFlags);
    }

    public void dispatchSemanticsAction(int virtualViewId, @NonNull AccessibilityBridge.Action action) {
        this.flutterJNI.dispatchSemanticsAction(virtualViewId, action);
    }

    public void dispatchSemanticsAction(int virtualViewId, @NonNull AccessibilityBridge.Action action, @Nullable Object args) {
        this.flutterJNI.dispatchSemanticsAction(virtualViewId, action, args);
    }

    public void setAccessibilityMessageHandler(@Nullable AccessibilityMessageHandler handler) {
        this.handler = handler;
        this.flutterJNI.setAccessibilityDelegate(handler);
    }

    public static interface AccessibilityMessageHandler
    extends FlutterJNI.AccessibilityDelegate {
        public void announce(@NonNull String var1);

        public void onTap(int var1);

        public void onLongPress(int var1);

        public void onFocus(int var1);

        public void onTooltip(@NonNull String var1);
    }
}

