/* The tables in this file should all be sorted on their first item. */

/* *INDENT-OFF* */

const PairMap mandatory_liga_table[] = {
  {{0xFEDF, 0xFE82}, 0xFEF5},
  {{0xFEDF, 0xFE84}, 0xFEF7},
  {{0xFEDF, 0xFE88}, 0xFEF9},
  {{0xFEDF, 0xFE8E}, 0xFEFB},
  {{0xFEE0, 0xFE82}, 0xFEF6},
  {{0xFEE0, 0xFE84}, 0xFEF8},
  {{0xFEE0, 0xFE88}, 0xFEFA},
  {{0xFEE0, 0xFE8E}, 0xFEFC},
};


const PairMap console_liga_table[] = {
  {{0x0640, 0xFC60}, 0xFCF2},
  {{0x0640, 0xFC61}, 0xFCF3},
  {{0x0640, 0xFC62}, 0xFCF4},
  {{0x0640, 0xFE70}, 0xFE71},
  {{0x0640, 0xFE76}, 0xFE77},
  {{0x0640, 0xFE78}, 0xFE79},
  {{0x0640, 0xFE7A}, 0xFE7B},
  {{0x0640, 0xFE7C}, 0xFE7D},
  {{0x0640, 0xFE7E}, 0xFE7F},
  {{0xFBE8, 0x0654}, 0xFE8B},
  {{0xFBE9, 0x0654}, 0xFE8C},
  {{0xFBFC, 0x0654}, 0xFE89},
  {{0xFBFC, 0x0670}, 0xFC5D},
  {{0xFBFD, 0x0654}, 0xFE8A},
  {{0xFBFD, 0x0670}, 0xFC90},
  {{0xFE7C, 0x0670}, 0xFC63},
  {{0xFE7C, 0xFE72}, 0xFC5E},
  {{0xFE7C, 0xFE74}, 0xFC5F},
  {{0xFE7C, 0xFE76}, 0xFC60},
  {{0xFE7C, 0xFE78}, 0xFC61},
  {{0xFE7C, 0xFE7A}, 0xFC62},
  {{0xFE7D, 0xFE76}, 0xFCF2},
  {{0xFE7D, 0xFE77}, 0xFCF2},
  {{0xFE7D, 0xFE78}, 0xFCF3},
  {{0xFE7D, 0xFE79}, 0xFCF3},
  {{0xFE7D, 0xFE7A}, 0xFCF4},
  {{0xFE7D, 0xFE7B}, 0xFCF4},
  {{0xFE8D, 0x0653}, 0xFE81},
  {{0xFE8D, 0x0654}, 0xFE83},
  {{0xFE8D, 0x0655}, 0xFE87},
  {{0xFE8D, 0xFE70}, 0xFD3D},
  {{0xFE8E, 0x0653}, 0xFE82},
  {{0xFE8E, 0x0654}, 0xFE84},
  {{0xFE8E, 0x0655}, 0xFE88},
  {{0xFE8E, 0xFE70}, 0xFD3C},
  {{0xFEE9, 0x0654}, 0xFBA4},
  {{0xFEEA, 0x0654}, 0xFBA5},
  {{0xFEED, 0x0654}, 0xFE85},
  {{0xFEEE, 0x0654}, 0xFE86},
  {{0xFEEF, 0x0654}, 0xFE89},
  {{0xFEEF, 0x0670}, 0xFC5D},
  {{0xFEF0, 0x0654}, 0xFE8A},
  {{0xFEF0, 0x0670}, 0xFC90},
  {{0xFEF1, 0x0654}, 0xFE89},
  {{0xFEF1, 0x0670}, 0xFC5D},
  {{0xFEF2, 0x0654}, 0xFE8A},
  {{0xFEF2, 0x0670}, 0xFC90},
  {{0xFEF3, 0x0654}, 0xFE8B},
  {{0xFEF4, 0x0654}, 0xFE8C},
  {{0xFEFB, 0x0653}, 0xFEF5},
  {{0xFEFB, 0x0654}, 0xFEF7},
  {{0xFEFB, 0x0655}, 0xFEF9},
  {{0xFEFC, 0x0653}, 0xFEF6},
  {{0xFEFC, 0x0654}, 0xFEF8},
  {{0xFEFC, 0x0655}, 0xFEFA},
};


static const FriBidiChar NSMShap[][4] = {
  {0xFE70, 0xFE71, 0xFE70, 0xFE71,},
  {0xFE72, 0xFE72, 0xFE72, 0xFE72,},
  {0xFE74, 0xFE74, 0xFE74, 0xFE74,},
  {0xFE76, 0xFE77, 0xFE76, 0xFE77,},
  {0xFE78, 0xFE79, 0xFE78, 0xFE79,},
  {0xFE7A, 0xFE7B, 0xFE7A, 0xFE7B,},
  {0xFE7C, 0xFE7D, 0xFE7C, 0xFE7D,},
  {0xFE7E, 0xFE7F, 0xFE7E, 0xFE7F,},
};

/* *INDENT-ON* */

#ifndef FRIBIDI_ACCESS_SHAPE_TABLE
# define FRIBIDI_ACCESS_SHAPE_TABLE(table,min,max,x,shape) \
	(((x)<(min)||(x)>(max))?(x):(table)[(x)-(min)][(shape)])
#endif

#define FRIBIDI_GET_ARABIC_SHAPE_NSM(x,shape) FRIBIDI_ACCESS_SHAPE_TABLE(NSMShap, 0x064B, 0x0652, (x), (shape))
