/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.plugins.shim;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import io.flutter.FlutterInjector;
import io.flutter.Log;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.embedding.engine.plugins.activity.ActivityAware;
import io.flutter.embedding.engine.plugins.activity.ActivityPluginBinding;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.PluginRegistry;
import io.flutter.plugin.platform.PlatformViewRegistry;
import io.flutter.view.FlutterView;
import io.flutter.view.TextureRegistry;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class ShimRegistrar
implements PluginRegistry.Registrar,
FlutterPlugin,
ActivityAware {
    private static final String TAG = "ShimRegistrar";
    private final Map<String, Object> globalRegistrarMap;
    private final String pluginId;
    private final Set<PluginRegistry.ViewDestroyListener> viewDestroyListeners = new HashSet<PluginRegistry.ViewDestroyListener>();
    private final Set<PluginRegistry.RequestPermissionsResultListener> requestPermissionsResultListeners = new HashSet<PluginRegistry.RequestPermissionsResultListener>();
    private final Set<PluginRegistry.ActivityResultListener> activityResultListeners = new HashSet<PluginRegistry.ActivityResultListener>();
    private final Set<PluginRegistry.NewIntentListener> newIntentListeners = new HashSet<PluginRegistry.NewIntentListener>();
    private final Set<PluginRegistry.UserLeaveHintListener> userLeaveHintListeners = new HashSet<PluginRegistry.UserLeaveHintListener>();
    private final Set<PluginRegistry.WindowFocusChangedListener> WindowFocusChangedListeners = new HashSet<PluginRegistry.WindowFocusChangedListener>();
    private FlutterPlugin.FlutterPluginBinding pluginBinding;
    private ActivityPluginBinding activityPluginBinding;

    public ShimRegistrar(@NonNull String pluginId, @NonNull Map<String, Object> globalRegistrarMap) {
        this.pluginId = pluginId;
        this.globalRegistrarMap = globalRegistrarMap;
    }

    @Override
    public Activity activity() {
        return this.activityPluginBinding != null ? this.activityPluginBinding.getActivity() : null;
    }

    @Override
    public Context context() {
        return this.pluginBinding != null ? this.pluginBinding.getApplicationContext() : null;
    }

    @Override
    public Context activeContext() {
        return this.activityPluginBinding == null ? this.context() : this.activity();
    }

    @Override
    public BinaryMessenger messenger() {
        return this.pluginBinding != null ? this.pluginBinding.getBinaryMessenger() : null;
    }

    @Override
    public TextureRegistry textures() {
        return this.pluginBinding != null ? this.pluginBinding.getTextureRegistry() : null;
    }

    @Override
    public PlatformViewRegistry platformViewRegistry() {
        return this.pluginBinding != null ? this.pluginBinding.getPlatformViewRegistry() : null;
    }

    @Override
    public FlutterView view() {
        throw new UnsupportedOperationException("The new embedding does not support the old FlutterView.");
    }

    @Override
    public String lookupKeyForAsset(String asset) {
        return FlutterInjector.instance().flutterLoader().getLookupKeyForAsset(asset);
    }

    @Override
    public String lookupKeyForAsset(String asset, String packageName) {
        return FlutterInjector.instance().flutterLoader().getLookupKeyForAsset(asset, packageName);
    }

    @Override
    public PluginRegistry.Registrar publish(Object value) {
        this.globalRegistrarMap.put(this.pluginId, value);
        return this;
    }

    @Override
    public PluginRegistry.Registrar addRequestPermissionsResultListener(PluginRegistry.RequestPermissionsResultListener listener) {
        this.requestPermissionsResultListeners.add(listener);
        if (this.activityPluginBinding != null) {
            this.activityPluginBinding.addRequestPermissionsResultListener(listener);
        }
        return this;
    }

    @Override
    public PluginRegistry.Registrar addActivityResultListener(PluginRegistry.ActivityResultListener listener) {
        this.activityResultListeners.add(listener);
        if (this.activityPluginBinding != null) {
            this.activityPluginBinding.addActivityResultListener(listener);
        }
        return this;
    }

    @Override
    public PluginRegistry.Registrar addNewIntentListener(PluginRegistry.NewIntentListener listener) {
        this.newIntentListeners.add(listener);
        if (this.activityPluginBinding != null) {
            this.activityPluginBinding.addOnNewIntentListener(listener);
        }
        return this;
    }

    @Override
    public PluginRegistry.Registrar addUserLeaveHintListener(PluginRegistry.UserLeaveHintListener listener) {
        this.userLeaveHintListeners.add(listener);
        if (this.activityPluginBinding != null) {
            this.activityPluginBinding.addOnUserLeaveHintListener(listener);
        }
        return this;
    }

    @Override
    public PluginRegistry.Registrar addWindowFocusChangedListener(PluginRegistry.WindowFocusChangedListener listener) {
        this.WindowFocusChangedListeners.add(listener);
        if (this.activityPluginBinding != null) {
            this.activityPluginBinding.addOnWindowFocusChangedListener(listener);
        }
        return this;
    }

    @Override
    @NonNull
    public PluginRegistry.Registrar addViewDestroyListener(@NonNull PluginRegistry.ViewDestroyListener listener) {
        this.viewDestroyListeners.add(listener);
        return this;
    }

    @Override
    public void onAttachedToEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        Log.v(TAG, "Attached to FlutterEngine.");
        this.pluginBinding = binding;
    }

    @Override
    public void onDetachedFromEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        Log.v(TAG, "Detached from FlutterEngine.");
        for (PluginRegistry.ViewDestroyListener listener : this.viewDestroyListeners) {
            listener.onViewDestroy(null);
        }
        this.pluginBinding = null;
        this.activityPluginBinding = null;
    }

    @Override
    public void onAttachedToActivity(@NonNull ActivityPluginBinding binding) {
        Log.v(TAG, "Attached to an Activity.");
        this.activityPluginBinding = binding;
        this.addExistingListenersToActivityPluginBinding();
    }

    @Override
    public void onDetachedFromActivityForConfigChanges() {
        Log.v(TAG, "Detached from an Activity for config changes.");
        this.activityPluginBinding = null;
    }

    @Override
    public void onReattachedToActivityForConfigChanges(@NonNull ActivityPluginBinding binding) {
        Log.v(TAG, "Reconnected to an Activity after config changes.");
        this.activityPluginBinding = binding;
        this.addExistingListenersToActivityPluginBinding();
    }

    @Override
    public void onDetachedFromActivity() {
        Log.v(TAG, "Detached from an Activity.");
        this.activityPluginBinding = null;
    }

    private void addExistingListenersToActivityPluginBinding() {
        for (PluginRegistry.RequestPermissionsResultListener requestPermissionsResultListener : this.requestPermissionsResultListeners) {
            this.activityPluginBinding.addRequestPermissionsResultListener(requestPermissionsResultListener);
        }
        for (PluginRegistry.ActivityResultListener activityResultListener : this.activityResultListeners) {
            this.activityPluginBinding.addActivityResultListener(activityResultListener);
        }
        for (PluginRegistry.NewIntentListener newIntentListener : this.newIntentListeners) {
            this.activityPluginBinding.addOnNewIntentListener(newIntentListener);
        }
        for (PluginRegistry.UserLeaveHintListener userLeaveHintListener : this.userLeaveHintListeners) {
            this.activityPluginBinding.addOnUserLeaveHintListener(userLeaveHintListener);
        }
        for (PluginRegistry.WindowFocusChangedListener windowFocusChangedListener : this.WindowFocusChangedListeners) {
            this.activityPluginBinding.addOnWindowFocusChangedListener(windowFocusChangedListener);
        }
    }
}

