A non-`const` function was called in a `const` context.

Erroneous code example:

```compile_fail,E0015
fn create_some() -> Option<u8> {
    Some(1)
}

// error: cannot call non-const fn `create_some` in constants
const FOO: Option<u8> = create_some();
```

All functions used in a `const` context (constant or static expression) must
be marked `const`.

To fix this error, you can declare `create_some` as a constant function:

```
// declared as a `const` function:
const fn create_some() -> Option<u8> {
    Some(1)
}

const FOO: Option<u8> = create_some(); // no error!
```
